/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.util.StringTokenizer;
import jugglinglab.util.JuggleException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rJ\b\u0010\u0012\u001a\u00020\fH\u0016J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0010\u0010\u001c\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0003R\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011\u00a8\u0006&"}, d2={"Ljugglinglab/util/Permutation;", "", "n", "", "reverses", "", "<init>", "(IZ)V", "mapping", "", "(I[IZ)V", "perm", "", "(ILjava/lang/String;Z)V", "value", "size", "getSize", "()I", "toString", "cyclenotation", "convertReverse", "num", "hasReverses", "equals", "p", "getMapping", "elem", "power", "apply", "secondp", "getInverseMapping", "inverse", "getInverse", "()Ljugglinglab/util/Permutation;", "order", "getOrder", "getCycle", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nPermutation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Permutation.kt\njugglinglab/util/Permutation\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,445:1\n106#2:446\n78#2,22:447\n106#2:469\n78#2,22:470\n106#2:492\n78#2,22:493\n106#2:515\n78#2,22:516\n*S KotlinDebug\n*F\n+ 1 Permutation.kt\njugglinglab/util/Permutation\n*L\n75#1:446\n75#1:447,22\n96#1:469\n96#1:470,22\n105#1:492\n105#1:493,22\n111#1:515\n111#1:516,22\n*E\n"})
public final class Permutation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @NotNull
    private int[] mapping;
    private boolean reverses;

    public final int getSize() {
        return this.size;
    }

    public Permutation(int n, boolean reverses) {
        this.size = n;
        this.reverses = reverses;
        if (reverses) {
            this.mapping = new int[this.size * 2 + 1];
            int n2 = this.size * 2 + 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mapping[i2] = i2 - this.size;
            }
        } else {
            this.mapping = new int[this.size];
            for (int i3 = 0; i3 < n; ++i3) {
                this.mapping[i3] = i3 + 1;
            }
        }
    }

    public Permutation(int n, @NotNull int[] mapping, boolean reverses) {
        Intrinsics.checkNotNullParameter(mapping, "mapping");
        this.size = n;
        this.reverses = reverses;
        this.mapping = mapping;
    }

    public Permutation(int n, @NotNull String perm, boolean reverses) {
        boolean[] used;
        Intrinsics.checkNotNullParameter(perm, "perm");
        this.size = n;
        this.mapping = reverses ? new int[this.size * 2 + 1] : new int[this.size];
        this.reverses = reverses;
        boolean[] blArray = used = reverses ? new boolean[this.size * 2 + 1] : new boolean[this.size];
        if (!StringsKt.contains$default((CharSequence)perm, '(', false, 2, null)) {
            int num = 0;
            StringTokenizer st = new StringTokenizer(perm, ",");
            if (st.countTokens() != this.size) {
                throw new JuggleException("Permutation init error: must have " + n + " elements in mapping");
            }
            int n2 = this.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                String $this$trim$iv;
                Intrinsics.checkNotNullExpressionValue(st.nextToken(), "nextToken(...)");
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                try {
                    num = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JuggleException("Permutation init error: number format");
                }
                if (!(1 <= num ? num <= this.size : false)) {
                    throw new JuggleException("Permutation init error: out of range");
                }
                if (used[num - 1]) {
                    throw new JuggleException("Permutation init error: not one-to-one");
                }
                used[num - 1] = true;
                this.mapping[i2] = num;
            }
        } else {
            StringTokenizer st1 = new StringTokenizer(perm, ")");
            while (st1.hasMoreTokens()) {
                String s1;
                String $this$trim$iv;
                Intrinsics.checkNotNullExpressionValue(st1.nextToken(), "nextToken(...)");
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((s1 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).charAt(0) != '(') {
                    throw new JuggleException("Permutation init error: parenthesis not grouped");
                }
                String string = s1.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                s1 = string;
                int num = 0;
                int lastnum = -(this.size + 1);
                StringTokenizer st2 = new StringTokenizer(s1, ",");
                while (st2.hasMoreTokens()) {
                    String $this$trim$iv2;
                    Intrinsics.checkNotNullExpressionValue(st2.nextToken(), "nextToken(...)");
                    boolean $i$f$trim4 = false;
                    CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                    boolean $i$f$trim5 = false;
                    int startIndex$iv$iv2 = 0;
                    int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                    boolean startFound$iv$iv2 = false;
                    while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                        char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl4 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv2) {
                            if (!match$iv$iv) {
                                startFound$iv$iv2 = true;
                                continue;
                            }
                            ++startIndex$iv$iv2;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv2;
                    }
                    String s2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                    try {
                        if (reverses) {
                            boolean negate = false;
                            if (StringsKt.endsWith$default(s2, "*", false, 2, null)) {
                                negate = true;
                                String $this$trim$iv3 = StringsKt.replace$default(s2, '*', ' ', false, 4, null);
                                boolean $i$f$trim6 = false;
                                CharSequence $this$trim$iv$iv3 = $this$trim$iv3;
                                boolean $i$f$trim7 = false;
                                int startIndex$iv$iv3 = 0;
                                int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
                                boolean startFound$iv$iv3 = false;
                                while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                                    char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl5 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                                    if (!startFound$iv$iv3) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv3 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv3;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv3;
                                }
                                s2 = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
                            }
                            num = Integer.parseInt(s2);
                            if (negate) {
                                num = -num;
                            }
                        } else {
                            num = Integer.parseInt(s2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JuggleException("Permutation init error: number format");
                    }
                    if (reverses) {
                        if (num < -this.size || num > this.size || num == 0) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (used[num + this.size]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        used[num + this.size] = true;
                        if (lastnum == -(this.size + 1)) {
                            this.mapping[num + this.size] = num;
                        } else {
                            this.mapping[num + this.size] = this.mapping[lastnum + this.size];
                            this.mapping[lastnum + this.size] = num;
                            if (used[-lastnum + this.size] && this.mapping[-lastnum + this.size] != -num) {
                                throw new JuggleException("Permutation init error: input not reversible");
                            }
                        }
                    } else {
                        if (!(1 <= num ? num <= this.size : false)) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (used[num - 1]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        used[num - 1] = true;
                        if (lastnum == -(this.size + 1)) {
                            this.mapping[num - 1] = num;
                        } else {
                            this.mapping[num - 1] = this.mapping[lastnum - 1];
                            this.mapping[lastnum - 1] = num;
                        }
                    }
                    lastnum = num;
                }
            }
        }
        if (reverses) {
            i = 1;
            int n3 = this.size;
            if (i <= n3) {
                while (true) {
                    if (used[i + this.size] && !used[-i + this.size]) {
                        this.mapping[-i + this.size] = -this.mapping[i + this.size];
                    } else if (!used[i + this.size] && used[-i + this.size]) {
                        this.mapping[i + this.size] = -this.mapping[-i + this.size];
                    } else if (!used[i + this.size] && !used[-i + this.size]) {
                        this.mapping[-i + this.size] = 0;
                        this.mapping[i + this.size] = 0;
                    }
                    if (i != n3) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n4 = this.size;
            for (i = 0; i < n4; ++i) {
                if (used[i]) continue;
                this.mapping[i] = i + 1;
            }
        }
    }

    @NotNull
    public String toString() {
        return this.toString(true);
    }

    @NotNull
    public final String toString(boolean cyclenotation) {
        StringBuilder sb = new StringBuilder();
        if (cyclenotation) {
            if (this.reverses) {
                int start = 0;
                int current = 0;
                boolean[] printed = new boolean[this.size];
                int n = this.size;
                for (int i2 = 0; i2 < n; ++i2) {
                    if (printed[i2]) continue;
                    start = i2 + 1;
                    printed[i2] = true;
                    current = this.mapping[start + this.size];
                    if (current == 0) continue;
                    sb.append("(").append(this.convertReverse(start));
                    while (current != start) {
                        if (current > 0) {
                            printed[current - 1] = true;
                        } else if (current < 0) {
                            printed[-current - 1] = true;
                        }
                        sb.append(",").append(this.convertReverse(current));
                        current = this.mapping[current + this.size];
                    }
                    sb.append(")");
                }
            } else {
                int i3;
                int start = 0;
                int current = 0;
                int left = this.size;
                boolean[] printed = new boolean[this.size];
                int n = this.size;
                for (i3 = 0; i3 < n; ++i3) {
                    printed[i3] = false;
                }
                while (left > 0) {
                    for (i3 = 0; i3 < this.size && printed[i3]; ++i3) {
                    }
                    start = i3 + 1;
                    printed[i3] = true;
                    sb.append("(").append(start);
                    --left;
                    current = this.mapping[i3];
                    while (current != start) {
                        sb.append(",").append(current);
                        printed[current - 1] = true;
                        --left;
                        current = this.mapping[current - 1];
                    }
                    sb.append(")");
                }
            }
        } else if (this.reverses) {
            sb.append(this.convertReverse(this.mapping[this.size + 1]));
            int n = this.size;
            for (int i4 = 1; i4 < n; ++i4) {
                sb.append(",").append(this.convertReverse(this.mapping[this.size + 1 + i4]));
            }
        } else {
            sb.append(this.mapping[0]);
            int n = this.size;
            for (int i5 = 1; i5 < n; ++i5) {
                sb.append(",").append(this.mapping[i5]);
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String convertReverse(int num) {
        return num >= 0 ? String.valueOf(num) : -num + "*";
    }

    public final boolean hasReverses() {
        return this.reverses;
    }

    public final boolean equals(@Nullable Permutation p) {
        if (p == null) {
            return false;
        }
        if (this.reverses != p.hasReverses()) {
            return false;
        }
        if (this.size != p.size) {
            return false;
        }
        int i2 = 1;
        int n = this.size;
        if (i2 <= n) {
            while (true) {
                if (this.getMapping(i2) != p.getMapping(i2)) {
                    return false;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        return true;
    }

    public final int getMapping(int elem) {
        return this.reverses ? this.mapping[elem + this.size] : this.mapping[elem - 1];
    }

    public final int getMapping(int elem, int power) {
        int el;
        block3: {
            block2: {
                el = 0;
                el = elem;
                if (power <= 0) break block2;
                int n = 0;
                while (n < power) {
                    int it = n++;
                    boolean bl = false;
                    el = this.getMapping(el);
                }
                break block3;
            }
            if (power >= 0) break block3;
            int n = -power;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                el = this.getInverseMapping(el);
            }
        }
        return el;
    }

    @NotNull
    public final Permutation apply(@Nullable Permutation secondp) {
        if (secondp == null || this.size != secondp.size) {
            return this;
        }
        if (this.hasReverses() || secondp.hasReverses()) {
            return this;
        }
        int[] res = new int[this.size];
        int n = this.size;
        for (int i2 = 0; i2 < n; ++i2) {
            res[i2] = secondp.getMapping(this.getMapping(i2 + 1));
        }
        return new Permutation(this.size, res, false);
    }

    public final int getInverseMapping(int elem) {
        if (this.reverses) {
            int n = 2 * this.size + 1;
            for (int i2 = 0; i2 < n; ++i2) {
                if (this.mapping[i2] != elem) continue;
                return i2 - this.size;
            }
        } else {
            int n = this.size;
            for (int i3 = 0; i3 < n; ++i3) {
                if (this.mapping[i3] != elem) continue;
                return i3 + 1;
            }
        }
        return 0;
    }

    @NotNull
    public final Permutation getInverse() {
        int[] invmapping = null;
        if (this.reverses) {
            invmapping = new int[this.size * 2 + 1];
            int n = this.size * 2 + 1;
            for (int i2 = 0; i2 < n; ++i2) {
                invmapping[this.mapping[i2] + this.size] = i2 - this.size;
            }
        } else {
            invmapping = new int[this.size];
            int n = this.size;
            for (int i3 = 0; i3 < n; ++i3) {
                invmapping[this.mapping[i3] - 1] = i3 + 1;
            }
        }
        return new Permutation(this.size, invmapping, this.reverses);
    }

    public final int getOrder() {
        int ord = 1;
        int elem = 1;
        int n = this.size;
        if (elem <= n) {
            while (true) {
                if (this.getMapping(elem) != 0) {
                    ord = Companion.lcm(ord, this.getOrder(elem));
                }
                if (elem == n) break;
                ++elem;
            }
        }
        return ord;
    }

    public final int getOrder(int elem) {
        int index;
        int ord = 1;
        int n = index = this.reverses ? elem + this.size : elem - 1;
        while (this.mapping[index] != elem) {
            ++ord;
            index = this.mapping[index] + (this.reverses ? this.size : -1);
        }
        return ord;
    }

    @NotNull
    public final int[] getCycle(int elem) {
        int ord = this.getOrder(elem);
        int[] result = new int[ord];
        int term = elem;
        for (int i2 = 0; i2 < ord; ++i2) {
            result[i2] = term;
            term = this.mapping[this.reverses ? term + this.size : term - 1];
        }
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Ljugglinglab/util/Permutation$Companion;", "", "<init>", "()V", "lcm", "", "x", "y", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public final int lcm(int x, int y) {
            int x2 = x;
            int y2 = y;
            int x0 = x2;
            int y0 = y2;
            int g = y2;
            while (x2 > 0) {
                g = x2;
                x2 = y2 % x2;
                y2 = g;
            }
            return x0 * y0 / g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

