/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Ljugglinglab/view/Mutator;", "", "<init>", "()V", "rate", "", "cb", "", "Ljavax/swing/JCheckBox;", "sliderRate", "Ljavax/swing/JSlider;", "value", "Ljavax/swing/JPanel;", "controlPanel", "getControlPanel", "()Ljavax/swing/JPanel;", "mutatePattern", "Ljugglinglab/jml/JMLPattern;", "pat", "mutateEventPosition", "mutateEventTime", "mutatePatternTiming", "mutateAddEvent", "mutateRemoveEvent", "pickMasterEvent", "Ljugglinglab/jml/JMLEvent;", "pickNewPosition", "Ljugglinglab/util/Coordinate;", "hand", "", "scaleDistance", "pos", "makeControlPanel", "Companion", "jugglinglab"})
public final class Mutator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double rate;
    private List<JCheckBox> cb;
    private JSlider sliderRate;
    @NotNull
    private JPanel controlPanel = this.makeControlPanel();
    public static final double MUTATION_POSITION_CM = 40.0;
    public static final double MUTATION_MIN_EVENT_DELTA_SEC = 0.03;
    public static final double MUTATION_TIMING_SCALE = 0.5;
    public static final double MUTATION_NEW_EVENT_POSITION_CM = 40.0;
    @NotNull
    private static final double[] mutationFreq;
    @NotNull
    private static final double[] sliderRates;

    @NotNull
    public final JPanel getControlPanel() {
        return this.controlPanel;
    }

    @NotNull
    public final JMLPattern mutatePattern(@NotNull JMLPattern pat) throws JuggleExceptionInternal {
        Intrinsics.checkNotNullParameter(pat, "pat");
        double[] cdf = new double[5];
        double freqSum = 0.0;
        for (int i2 = 0; i2 < 5; ++i2) {
            List<JCheckBox> list = this.cb;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cb");
                list = null;
            }
            cdf[i2] = freqSum += list.get(i2).isSelected() ? mutationFreq[i2] : 0.0;
        }
        try {
            if (freqSum == 0.0) {
                return new JMLPattern(pat);
            }
            JSlider jSlider = this.sliderRate;
            if (jSlider == null) {
                Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
                jSlider = null;
            }
            this.rate = sliderRates[jSlider.getValue()];
            JMLPattern mutant = null;
            int tries = 0;
            do {
                JMLPattern clone = new JMLPattern(pat);
                double r = freqSum * Math.random();
                JMLPattern jMLPattern = r < cdf[0] ? this.mutateEventPosition(clone) : (r < cdf[1] ? this.mutateEventTime(clone) : (r < cdf[2] ? this.mutatePatternTiming(clone) : (mutant = r < cdf[3] ? this.mutateAddEvent(clone) : this.mutateRemoveEvent(clone))));
            } while (mutant == null && ++tries < 5);
            JMLPattern jMLPattern = mutant;
            if (jMLPattern == null) {
                jMLPattern = new JMLPattern(pat);
            }
            return jMLPattern;
        }
        catch (JuggleExceptionUser jeu) {
            throw new JuggleExceptionInternal("Mutator: User error: " + jeu.getMessage());
        }
    }

    private final JMLPattern mutateEventPosition(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        JMLEvent ev = this.pickMasterEvent(pat);
        Coordinate pos = ev.getLocalCoordinate();
        pos = this.pickNewPosition(ev.getHand(), this.rate * 40.0, pos);
        ev.setLocalCoordinate(pos);
        pat.setNeedsLayout();
        return pat;
    }

    private final JMLPattern mutateEventTime(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        double tmax;
        JMLEvent evNext;
        JMLEvent evPrev;
        JMLEvent ev = this.pickMasterEvent(pat);
        for (evPrev = ev.getPrevious(); evPrev != null && (evPrev.getJuggler() != ev.getJuggler() || evPrev.getHand() != ev.getHand()); evPrev = evPrev.getPrevious()) {
        }
        double tmin = evPrev == null ? pat.getLoopStartTime() : Math.max(pat.getLoopStartTime(), evPrev.getT()) + 0.03;
        for (evNext = ev.getNext(); evNext != null && (evNext.getJuggler() != ev.getJuggler() || evNext.getHand() != ev.getHand()); evNext = evNext.getNext()) {
        }
        double d = tmax = evNext == null ? pat.getLoopEndTime() : Math.min(pat.getLoopEndTime(), evNext.getT()) - 0.03;
        if (tmax <= tmin) {
            return null;
        }
        double r = Math.random();
        double tnow = ev.getT();
        double t2 = r < 0.5 ? tmin + (tnow - tmin) * Math.sqrt((double)2 * r) : tmax - (tmax - tnow) * Math.sqrt((double)2 * (1.0 - r));
        ev.setT(t2);
        pat.setNeedsLayout();
        return pat;
    }

    private final JMLPattern mutatePatternTiming(JMLPattern pat) throws JuggleExceptionUser {
        double r = Math.random();
        double scalemin = 1.0 / (1.0 + this.rate * 0.5);
        double scalemax = 1.0 + this.rate * 0.5;
        double scale = r < 0.5 ? scalemin + (1.0 - scalemin) * Math.sqrt((double)2 * r) : scalemax - (scalemax - 1.0) * Math.sqrt((double)2 * (1.0 - r));
        for (JMLEvent ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            ev.setT(ev.getT() * scale);
        }
        for (JMLPosition pos = pat.getPositionList(); pos != null; pos = pos.getNext()) {
            pos.setT(pos.getT() * scale);
        }
        Iterator<JMLSymmetry> iterator2 = pat.getSymmetries().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<JMLSymmetry> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            JMLSymmetry sym;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            double delay = sym.getDelay();
            if (!(delay > 0.0)) continue;
            sym.setDelay(delay * scale);
        }
        pat.setNeedsLayout();
        return pat;
    }

    private final JMLPattern mutateAddEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        pat.layoutPattern();
        JMLEvent ev = null;
        double tmin = 0.0;
        double tmax = 0.0;
        double t2 = 0.0;
        int juggler = 0;
        int hand = 0;
        int tries = 0;
        do {
            juggler = 1 + (int)((double)pat.getNumberOfJugglers() * Math.random());
            hand = Math.random() < 0.5 ? 1 : 2;
            tmin = pat.getLoopStartTime();
            tmax = pat.getLoopEndTime();
            t2 = tmin + (tmax - tmin) * Math.random();
            for (ev = pat.getEventList(); !(ev == null || ev.getJuggler() == juggler && ev.getHand() == hand && ev.getT() >= t2); ev = ev.getNext()) {
            }
            if (ev == null) {
                return null;
            }
            tmax = ev.getT() - 0.03;
            while (!(ev == null || ev.getJuggler() == juggler && ev.getHand() == hand && ev.getT() <= t2)) {
                ev = ev.getPrevious();
            }
            if (ev != null) continue;
            return null;
        } while ((tmin = ev.getT() + 0.03) > tmax && ++tries < 5);
        if (tries == 5) {
            return null;
        }
        double r = Math.random();
        double d = t2 = r < 0.5 ? tmin + (tmax - tmin) * Math.sqrt(0.5 * r) : tmax - (tmax - tmin) * Math.sqrt(0.5 * (1.0 - r));
        while (t2 < pat.getLoopStartTime()) {
            t2 += pat.getLoopEndTime() - pat.getLoopStartTime();
        }
        while (t2 > pat.getLoopEndTime()) {
            t2 -= pat.getLoopEndTime() - pat.getLoopStartTime();
        }
        ev = new JMLEvent();
        ev.setHand(juggler, hand);
        ev.setT(t2);
        ev.setMasterEvent(null);
        Coordinate pos = new Coordinate(0.0, 0.0, 0.0, 7, null);
        pat.getHandCoordinate(juggler, hand, t2, pos);
        pos = pat.convertGlobalToLocal(pos, juggler, t2);
        pos = this.pickNewPosition(hand, this.rate * 40.0, pos);
        ev.setLocalCoordinate(pos);
        int path = 1;
        int n = pat.getNumberOfPaths();
        if (path <= n) {
            while (true) {
                if (pat.isHandHoldingPath(juggler, hand, t2, path)) {
                    JMLTransition trans = new JMLTransition(5, path, null, null);
                    ev.addTransition(trans);
                }
                if (path == n) break;
                ++path;
            }
        }
        pat.addEvent(ev);
        pat.setNeedsLayout();
        return pat;
    }

    private final JMLPattern mutateRemoveEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        int type;
        JMLTransition tr;
        Iterator<JMLTransition> iterator2;
        boolean holdingOnly;
        JMLEvent ev;
        int count = 0;
        for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            holdingOnly = true;
            Intrinsics.checkNotNullExpressionValue(ev.getTransitions().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                type = tr.getTransType();
                if (type == 0 || type == 5) continue;
                holdingOnly = false;
                break;
            }
            if (!holdingOnly) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        count = (int)((double)count * Math.random());
        for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            holdingOnly = true;
            Intrinsics.checkNotNullExpressionValue(ev.getTransitions().iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                type = tr.getTransType();
                if (type == 0 || type == 5) continue;
                holdingOnly = false;
                break;
            }
            if (!holdingOnly) continue;
            if (count == 0) {
                pat.removeEvent(ev);
                pat.setNeedsLayout();
                return pat;
            }
            --count;
        }
        throw new JuggleExceptionInternal("mutateRemoveEvent error");
    }

    private final JMLEvent pickMasterEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        pat.layoutPattern();
        JMLEvent eventlist = pat.getEventList();
        int masterCount = 0;
        JMLEvent current = eventlist;
        do {
            JMLEvent jMLEvent = current;
            Intrinsics.checkNotNull(jMLEvent);
            if (!jMLEvent.isMaster()) continue;
            ++masterCount;
        } while ((current = current.getNext()) != null);
        int eventNum = (int)(Math.random() * (double)masterCount);
        current = eventlist;
        do {
            JMLEvent jMLEvent = current;
            Intrinsics.checkNotNull(jMLEvent);
            if (!jMLEvent.isMaster()) continue;
            if (eventNum == 0) {
                return current;
            }
            --eventNum;
        } while ((current = current.getNext()) != null);
        throw new JuggleExceptionInternal("Mutator: pickEvent() failed");
    }

    private final Coordinate pickNewPosition(int hand, double scaleDistance, Coordinate pos) {
        Coordinate result = null;
        boolean outsideBox = false;
        do {
            boolean bl;
            Coordinate coordinate = result = new Coordinate(pos.getX(), pos.getY(), pos.getZ());
            coordinate.setX(coordinate.getX() + 2.0 * scaleDistance * (Math.random() - 0.5));
            coordinate = result;
            coordinate.setZ(coordinate.getZ() + 2.0 * scaleDistance * (Math.random() - 0.5));
            if (hand == 1) {
                if (result.getX() < -75.0 || result.getX() > 40.0 || result.getZ() < -20.0 || result.getZ() > 80.0) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = outsideBox = result.getX() < -40.0 || result.getX() > 75.0 || result.getZ() < -20.0 || result.getZ() > 80.0;
        } while (outsideBox && Math.random() < 0.5);
        return result;
    }

    private final JPanel makeControlPanel() {
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        controls.setLayout(gb);
        controls.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JLabel lab = new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_header1"));
        gb.setConstraints(lab, JLFunc.constraints(21, 0, 0, new Insets(0, 0, 10, 0)));
        controls.add(lab);
        this.cb = new ArrayList(5);
        List<JCheckBox> list = this.cb;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list = null;
        }
        list.add(new JCheckBox(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_type1"), true));
        List<JCheckBox> list2 = this.cb;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list2 = null;
        }
        gb.setConstraints(list2.get(0), JLFunc.constraints(21, 0, 1, null));
        List<JCheckBox> list3 = this.cb;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list3 = null;
        }
        list3.add(new JCheckBox(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_type2"), true));
        List<JCheckBox> list4 = this.cb;
        if (list4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list4 = null;
        }
        gb.setConstraints(list4.get(1), JLFunc.constraints(21, 0, 2, null));
        List<JCheckBox> list5 = this.cb;
        if (list5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list5 = null;
        }
        list5.add(new JCheckBox(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_type3"), true));
        List<JCheckBox> list6 = this.cb;
        if (list6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list6 = null;
        }
        gb.setConstraints(list6.get(2), JLFunc.constraints(21, 0, 3, null));
        List<JCheckBox> list7 = this.cb;
        if (list7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list7 = null;
        }
        list7.add(new JCheckBox(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_type4"), true));
        List<JCheckBox> list8 = this.cb;
        if (list8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list8 = null;
        }
        gb.setConstraints(list8.get(3), JLFunc.constraints(21, 0, 4, null));
        List<JCheckBox> list9 = this.cb;
        if (list9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list9 = null;
        }
        list9.add(new JCheckBox(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_type5"), true));
        List<JCheckBox> list10 = this.cb;
        if (list10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list10 = null;
        }
        gb.setConstraints(list10.get(4), JLFunc.constraints(21, 0, 5, null));
        List<JCheckBox> list11 = this.cb;
        if (list11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cb");
            list11 = null;
        }
        for (JCheckBox checkbox : list11) {
            controls.add(checkbox);
        }
        lab = new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Mutator_header2"));
        gb.setConstraints(lab, JLFunc.constraints(21, 0, 6, new Insets(20, 0, 10, 0)));
        controls.add(lab);
        this.sliderRate = new JSlider(0, 0, 6, 3);
        GridBagConstraints gbc = JLFunc.constraints(21, 0, 7, null);
        gbc.fill = 2;
        JSlider jSlider = this.sliderRate;
        if (jSlider == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider = null;
        }
        gb.setConstraints(jSlider, gbc);
        JSlider jSlider2 = this.sliderRate;
        if (jSlider2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider2 = null;
        }
        jSlider2.setMajorTickSpacing(1);
        JSlider jSlider3 = this.sliderRate;
        if (jSlider3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider3 = null;
        }
        jSlider3.setPaintTicks(true);
        JSlider jSlider4 = this.sliderRate;
        if (jSlider4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider4 = null;
        }
        jSlider4.setSnapToTicks(true);
        Hashtable labels = new Hashtable();
        ((Map)labels).put(0, new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Mutation_rate_low")));
        ((Map)labels).put(3, new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Mutation_rate_medium")));
        ((Map)labels).put(6, new JLabel(JugglingLab.INSTANCE.getGuistrings().getString("Mutation_rate_high")));
        JSlider jSlider5 = this.sliderRate;
        if (jSlider5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider5 = null;
        }
        jSlider5.setLabelTable(labels);
        JSlider jSlider6 = this.sliderRate;
        if (jSlider6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider6 = null;
        }
        jSlider6.setPaintLabels(true);
        JSlider jSlider7 = this.sliderRate;
        if (jSlider7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("sliderRate");
            jSlider7 = null;
        }
        controls.add(jSlider7);
        return controls;
    }

    static {
        double[] dArray = new double[]{0.4, 0.1, 0.1, 0.2, 0.2};
        mutationFreq = dArray;
        dArray = new double[]{0.2, 0.4, 0.7, 1.0, 1.3, 1.6, 2.0};
        sliderRates = dArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Ljugglinglab/view/Mutator$Companion;", "", "<init>", "()V", "MUTATION_POSITION_CM", "", "MUTATION_MIN_EVENT_DELTA_SEC", "MUTATION_TIMING_SCALE", "MUTATION_NEW_EVENT_POSITION_CM", "mutationFreq", "", "getMutationFreq", "()[D", "sliderRates", "getSliderRates", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final double[] getMutationFreq() {
            return mutationFreq;
        }

        @NotNull
        public final double[] getSliderRates() {
            return sliderRates;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

