/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.Mutator;
import jugglinglab.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u00102\u001a\u00020\u0017H\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00067"}, d2={"Ljugglinglab/view/SelectionView;", "Ljugglinglab/view/View;", "dim", "Ljava/awt/Dimension;", "<init>", "(Ljava/awt/Dimension;)V", "ja", "", "Ljugglinglab/core/AnimationPanel;", "layered", "Ljavax/swing/JLayeredPane;", "mutator", "Ljugglinglab/view/Mutator;", "savedPrefs", "Ljugglinglab/core/AnimationPrefs;", "makeAnimationGrid", "Ljavax/swing/JPanel;", "makeOverlay", "makeLayeredPane", "d", "grid", "overlay", "restartView", "", "p", "Ljugglinglab/jml/JMLPattern;", "c", "animationPanelSize", "getAnimationPanelSize", "()Ljava/awt/Dimension;", "setAnimationPanelPreferredSize", "pattern", "getPattern", "()Ljugglinglab/jml/JMLPattern;", "animationPrefs", "getAnimationPrefs", "()Ljugglinglab/core/AnimationPrefs;", "z", "", "zoomLevel", "getZoomLevel", "()D", "setZoomLevel", "(D)V", "pause", "", "isPaused", "()Z", "setPaused", "(Z)V", "disposeView", "writeGIF", "f", "Ljava/io/File;", "Companion", "jugglinglab"})
@SourceDebugExtension(value={"SMAP\nSelectionView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionView.kt\njugglinglab/view/SelectionView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public final class SelectionView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AnimationPanel> ja;
    @NotNull
    private final JLayeredPane layered;
    @NotNull
    private final Mutator mutator;
    @Nullable
    private AnimationPrefs savedPrefs;
    private static final int ROWS = 3;
    private static final int COLUMNS = 3;
    private static final int COUNT = 9;
    private static final int CENTER = 4;

    public SelectionView(@NotNull Dimension dim) {
        Intrinsics.checkNotNullParameter(dim, "dim");
        int n = 9;
        SelectionView selectionView = this;
        ArrayList<AnimationPanel> arrayList = new ArrayList<AnimationPanel>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<AnimationPanel> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new AnimationPanel());
        }
        selectionView.ja = arrayList;
        this.layered = this.makeLayeredPane(dim, this.makeAnimationGrid(), this.makeOverlay());
        this.mutator = new Mutator();
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.add(this.layered);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.gridheight = gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = gbc.weighty = 1.0;
        gb.setConstraints(this.layered, gbc);
        JPanel controls = this.mutator.getControlPanel();
        this.add(controls);
        gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 0;
        gbc.gridheight = gbc.gridwidth = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gb.setConstraints(controls, gbc);
    }

    private final JPanel makeAnimationGrid() {
        JPanel grid = new JPanel(new GridLayout(3, 3));
        for (AnimationPanel ap : this.ja) {
            grid.add(ap);
        }
        grid.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SelectionView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseReleased(MouseEvent me) {
                int num;
                Intrinsics.checkNotNullParameter(me, "me");
                Component c = me.getComponent();
                for (num = 0; num < 9 && c != SelectionView.access$getJa$p(this.this$0).get(num); ++num) {
                }
                if (num == 9) {
                    return;
                }
                try {
                    this.this$0.restartView(((AnimationPanel)SelectionView.access$getJa$p(this.this$0).get(num)).getPattern(), null);
                    if (num != 4) {
                        JMLPattern jMLPattern = ((AnimationPanel)SelectionView.access$getJa$p(this.this$0).get(4)).getPattern();
                        Intrinsics.checkNotNull(jMLPattern);
                        this.this$0.addToUndoList(jMLPattern);
                    }
                }
                catch (JuggleExceptionUser jeu) {
                    ErrorDialog.INSTANCE.handleUserException(this.this$0.getParent(), jeu.getMessage());
                }
                catch (JuggleExceptionInternal jei) {
                    ErrorDialog.INSTANCE.handleFatalException(jei);
                }
            }
        });
        grid.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ SelectionView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseDragged(MouseEvent me) {
                int num;
                Intrinsics.checkNotNullParameter(me, "me");
                Component c = me.getComponent();
                for (num = 0; num < 9 && c != SelectionView.access$getJa$p(this.this$0).get(num); ++num) {
                }
                if (num == 9) {
                    return;
                }
                double[] ca = ((AnimationPanel)SelectionView.access$getJa$p(this.this$0).get(num)).getCameraAngle();
                for (int i2 = 0; i2 < 9; ++i2) {
                    if (i2 == num) continue;
                    ((AnimationPanel)SelectionView.access$getJa$p(this.this$0).get(i2)).setCameraAngle(ca);
                }
            }
        });
        grid.setOpaque(true);
        return grid;
    }

    private final JPanel makeOverlay() {
        JPanel overlay2 = new JPanel(){

            public void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter(g, "g");
                Dimension d = this.getSize();
                int xleft = d.width * 1 / 3;
                int ytop = d.height * 1 / 3;
                int width = d.width / 3;
                int height = d.height / 3;
                Graphics graphics = g.create();
                Intrinsics.checkNotNull(graphics, "null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                g2.setStroke(new BasicStroke(2.0f, 0, 2, 0.0f));
                g2.setColor(Color.lightGray);
                g2.drawRect(xleft, ytop, width, height);
                g2.dispose();
            }
        };
        overlay2.setOpaque(false);
        return overlay2;
    }

    private final JLayeredPane makeLayeredPane(Dimension d, JPanel grid, JPanel overlay2) {
        int prefHeight;
        int prefWidth;
        JLayeredPane layered;
        block3: {
            int maxHeight;
            int maxWidth;
            block2: {
                layered = new JLayeredPane();
                layered.setLayout(null);
                Component component = grid;
                Integer n = JLayeredPane.DEFAULT_LAYER;
                Intrinsics.checkNotNullExpressionValue(n, "DEFAULT_LAYER");
                layered.add(component, ((Number)n).intValue());
                Component component2 = overlay2;
                Integer n2 = JLayeredPane.PALETTE_LAYER;
                Intrinsics.checkNotNullExpressionValue(n2, "PALETTE_LAYER");
                layered.add(component2, ((Number)n2).intValue());
                layered.addComponentListener(new ComponentAdapter(layered, grid, overlay2, this){
                    final /* synthetic */ JLayeredPane $layered;
                    final /* synthetic */ JPanel $grid;
                    final /* synthetic */ JPanel $overlay;
                    final /* synthetic */ SelectionView this$0;
                    {
                        this.$layered = $layered;
                        this.$grid = $grid;
                        this.$overlay = $overlay;
                        this.this$0 = $receiver;
                    }

                    public void componentResized(ComponentEvent e) {
                        Dimension d = this.$layered.getSize();
                        this.$grid.setBounds(0, 0, d.width, d.height);
                        this.$overlay.setBounds(0, 0, d.width, d.height);
                        this.this$0.validate();
                    }
                });
                prefWidth = 3 * d.width;
                prefHeight = 3 * d.height;
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                maxWidth = screenSize.width - 300;
                maxHeight = screenSize.height - 120;
                if (prefWidth > maxWidth) break block2;
                if (prefHeight <= maxHeight) break block3;
            }
            double scale = Math.min((double)maxWidth / (double)prefWidth, (double)maxHeight / (double)prefHeight);
            prefWidth = (int)(scale * (double)prefWidth);
            prefHeight = (int)(scale * (double)prefHeight);
        }
        layered.setPreferredSize(new Dimension(prefWidth, prefHeight));
        grid.setBounds(0, 0, prefWidth, prefHeight);
        overlay2.setBounds(0, 0, prefWidth, prefHeight);
        return layered;
    }

    @Override
    public void restartView(@Nullable JMLPattern p, @Nullable AnimationPrefs c) throws JuggleExceptionUser, JuggleExceptionInternal {
        block4: {
            AnimationPrefs newjc = null;
            if (c != null) {
                this.savedPrefs = c;
                newjc = new AnimationPrefs(c);
                newjc.setStartPause(false);
            }
            this.ja.get(4).restartJuggle(p, newjc);
            for (int i2 = 0; i2 < 9; ++i2) {
                if (i2 == 4) continue;
                JMLPattern newp = p == null ? null : this.mutator.mutatePattern(p);
                this.ja.get(i2).restartJuggle(newp, newjc);
            }
            this.setAnimationPanelPreferredSize(this.getAnimationPrefs().getSize());
            if (p == null) break block4;
            PatternWindow patternWindow = this.getPatternWindow();
            if (patternWindow != null) {
                patternWindow.setTitle(p.getTitle());
            }
            PatternWindow patternWindow2 = this.getPatternWindow();
            if (patternWindow2 != null) {
                patternWindow2.updateColorsMenu();
            }
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        for (AnimationPanel ap : this.ja) {
            ap.restartJuggle();
        }
    }

    @Override
    @Nullable
    public Dimension getAnimationPanelSize() {
        return this.ja.get(4).getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(@NotNull Dimension d) {
        Intrinsics.checkNotNullParameter(d, "d");
        int width = 3 * d.width;
        int height = 3 * d.height;
        this.layered.setPreferredSize(new Dimension(width, height));
    }

    @Override
    @Nullable
    public JMLPattern getPattern() {
        return this.ja.get(4).getPattern();
    }

    @Override
    @NotNull
    public AnimationPrefs getAnimationPrefs() {
        AnimationPrefs animationPrefs = this.savedPrefs;
        Intrinsics.checkNotNull(animationPrefs);
        return animationPrefs;
    }

    @Override
    public double getZoomLevel() {
        return this.ja.get(4).getZoomLevel();
    }

    @Override
    public void setZoomLevel(double z) {
        for (AnimationPanel ap : this.ja) {
            ap.setZoomLevel(z);
        }
    }

    @Override
    public boolean isPaused() {
        return this.ja.get(4).isPaused();
    }

    @Override
    public void setPaused(boolean pause) {
        if (this.ja.get(4).getMessage() == null) {
            for (AnimationPanel ap : this.ja) {
                ap.setPaused(pause);
            }
        }
    }

    @Override
    public void disposeView() {
        for (AnimationPanel ap : this.ja) {
            ap.disposeAnimation();
        }
    }

    @Override
    public void writeGIF(@NotNull File f) {
        Intrinsics.checkNotNullParameter(f, "f");
        for (AnimationPanel ap : this.ja) {
            ap.setWritingGIF(true);
        }
        boolean origpause = this.isPaused();
        this.setPaused(true);
        PatternWindow patternWindow = this.getPatternWindow();
        if (patternWindow != null) {
            patternWindow.setResizable(false);
        }
        Runnable cleanup = () -> SelectionView.writeGIF$lambda$1(this, origpause);
        new View.GIFWriter(this.ja.get(4), f, cleanup);
    }

    private static final void writeGIF$lambda$1(SelectionView this$0, boolean $origpause) {
        block1: {
            for (AnimationPanel ap : this$0.ja) {
                ap.setWritingGIF(false);
            }
            this$0.setPaused($origpause);
            PatternWindow patternWindow = this$0.getPatternWindow();
            if (patternWindow == null) break block1;
            patternWindow.setResizable(true);
        }
    }

    public static final /* synthetic */ List access$getJa$p(SelectionView $this) {
        return $this.ja;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljugglinglab/view/SelectionView$Companion;", "", "<init>", "()V", "ROWS", "", "COLUMNS", "COUNT", "CENTER", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

