/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.Animator;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 A2\u00020\u0001:\u0002@AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001d\u001a\u00020\u0012J\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u001bJ\u001c\u0010\"\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010#\u001a\u0004\u0018\u00010$H&J\b\u0010\"\u001a\u00020\u001bH&J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020&H&J\b\u0010<\u001a\u00020\u001bH&J\u0010\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?H&R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010%\u001a\u0004\u0018\u00010&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010+\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0012\u0010.\u001a\u00020$X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0018\u00101\u001a\u000202X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0018\u00107\u001a\u000208X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b7\u00109\"\u0004\b:\u0010;\u00a8\u0006B"}, d2={"Ljugglinglab/view/View;", "Ljavax/swing/JPanel;", "<init>", "()V", "patternWindow", "Ljugglinglab/core/PatternWindow;", "getPatternWindow", "()Ljugglinglab/core/PatternWindow;", "setPatternWindow", "(Ljugglinglab/core/PatternWindow;)V", "undo", "Ljava/util/ArrayList;", "Ljugglinglab/jml/JMLPattern;", "getUndo", "()Ljava/util/ArrayList;", "setUndo", "(Ljava/util/ArrayList;)V", "value", "", "undoIndex", "getUndoIndex", "()I", "setUndoIndex", "(I)V", "hashCode", "getHashCode", "setUndoList", "", "u", "uIndex", "addToUndoList", "p", "undoEdit", "redoEdit", "restartView", "c", "Ljugglinglab/core/AnimationPrefs;", "animationPanelSize", "Ljava/awt/Dimension;", "getAnimationPanelSize", "()Ljava/awt/Dimension;", "setAnimationPanelPreferredSize", "d", "pattern", "getPattern", "()Ljugglinglab/jml/JMLPattern;", "animationPrefs", "getAnimationPrefs", "()Ljugglinglab/core/AnimationPrefs;", "zoomLevel", "", "getZoomLevel", "()D", "setZoomLevel", "(D)V", "isPaused", "", "()Z", "setPaused", "(Z)V", "disposeView", "writeGIF", "f", "Ljava/io/File;", "GIFWriter", "Companion", "jugglinglab"})
public abstract class View
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PatternWindow patternWindow;
    @Nullable
    private ArrayList<JMLPattern> undo;
    private int undoIndex;
    public static final int VIEW_NONE = 0;
    public static final int VIEW_SIMPLE = 1;
    public static final int VIEW_EDIT = 2;
    public static final int VIEW_PATTERN = 3;
    public static final int VIEW_SELECTION = 4;
    @JvmField
    @NotNull
    public static final String[] viewNames;

    @Nullable
    public final PatternWindow getPatternWindow() {
        return this.patternWindow;
    }

    public final void setPatternWindow(@Nullable PatternWindow patternWindow) {
        this.patternWindow = patternWindow;
    }

    @Nullable
    protected final ArrayList<JMLPattern> getUndo() {
        return this.undo;
    }

    protected final void setUndo(@Nullable ArrayList<JMLPattern> arrayList) {
        this.undo = arrayList;
    }

    public final int getUndoIndex() {
        return this.undoIndex;
    }

    protected final void setUndoIndex(int n) {
        this.undoIndex = n;
    }

    public final int getHashCode() {
        JMLPattern jMLPattern = this.getPattern();
        return jMLPattern != null ? jMLPattern.getHashCode() : 0;
    }

    public final void setUndoList(@NotNull ArrayList<JMLPattern> u, int uIndex) {
        Intrinsics.checkNotNullParameter(u, "u");
        this.undo = u;
        this.undoIndex = uIndex;
    }

    public final void addToUndoList(@NotNull JMLPattern p) {
        Intrinsics.checkNotNullParameter(p, "p");
        try {
            ++this.undoIndex;
            ArrayList<JMLPattern> arrayList = this.undo;
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(this.undoIndex, new JMLPattern(p));
            while (true) {
                ArrayList<JMLPattern> arrayList2 = this.undo;
                Intrinsics.checkNotNull(arrayList2);
                if (this.undoIndex + 1 >= arrayList2.size()) break;
                ArrayList<JMLPattern> arrayList3 = this.undo;
                Intrinsics.checkNotNull(arrayList3);
                arrayList3.remove(this.undoIndex + 1);
            }
            PatternWindow patternWindow = this.patternWindow;
            if (patternWindow != null) {
                patternWindow.updateUndoMenu();
            }
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.INSTANCE.handleFatalException(new JuggleExceptionInternal(jeu.getMessage()));
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.INSTANCE.handleFatalException(jei);
        }
    }

    public final void undoEdit() throws JuggleExceptionInternal {
        block6: {
            if (this.undoIndex == 0) {
                return;
            }
            try {
                this.undoIndex += -1;
                ArrayList<JMLPattern> arrayList = this.undo;
                Intrinsics.checkNotNull(arrayList);
                JMLPattern jMLPattern = arrayList.get(this.undoIndex);
                Intrinsics.checkNotNullExpressionValue(jMLPattern, "get(...)");
                this.restartView(new JMLPattern(jMLPattern), null);
                if (this.undoIndex != 0) {
                    ArrayList<JMLPattern> arrayList2 = this.undo;
                    Intrinsics.checkNotNull(arrayList2);
                    if (this.undoIndex != arrayList2.size() - 2) break block6;
                }
                PatternWindow patternWindow = this.patternWindow;
                if (patternWindow != null) {
                    patternWindow.updateUndoMenu();
                }
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal(jeu.getMessage());
            }
        }
    }

    public final void redoEdit() throws JuggleExceptionInternal {
        block6: {
            ArrayList<JMLPattern> arrayList = this.undo;
            Intrinsics.checkNotNull(arrayList);
            if (this.undoIndex == arrayList.size() - 1) {
                return;
            }
            try {
                ++this.undoIndex;
                ArrayList<JMLPattern> arrayList2 = this.undo;
                Intrinsics.checkNotNull(arrayList2);
                JMLPattern jMLPattern = arrayList2.get(this.undoIndex);
                Intrinsics.checkNotNullExpressionValue(jMLPattern, "get(...)");
                this.restartView(new JMLPattern(jMLPattern), null);
                if (this.undoIndex != 1) {
                    ArrayList<JMLPattern> arrayList3 = this.undo;
                    Intrinsics.checkNotNull(arrayList3);
                    if (this.undoIndex != arrayList3.size() - 1) break block6;
                }
                PatternWindow patternWindow = this.patternWindow;
                if (patternWindow != null) {
                    patternWindow.updateUndoMenu();
                }
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal(jeu.getMessage());
            }
        }
    }

    public abstract void restartView(@Nullable JMLPattern var1, @Nullable AnimationPrefs var2) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract void restartView() throws JuggleExceptionUser, JuggleExceptionInternal;

    @Nullable
    public abstract Dimension getAnimationPanelSize();

    public abstract void setAnimationPanelPreferredSize(@NotNull Dimension var1);

    @Nullable
    public abstract JMLPattern getPattern();

    @NotNull
    public abstract AnimationPrefs getAnimationPrefs();

    public abstract double getZoomLevel();

    public abstract void setZoomLevel(double var1);

    public abstract boolean isPaused();

    public abstract void setPaused(boolean var1);

    public abstract void disposeView();

    public abstract void writeGIF(@NotNull File var1);

    static {
        String[] stringArray = new String[]{"simple", "visual_editor", "pattern_editor", "selection_editor"};
        viewNames = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Ljugglinglab/view/View$Companion;", "", "<init>", "()V", "VIEW_NONE", "", "VIEW_SIMPLE", "VIEW_EDIT", "VIEW_PATTERN", "VIEW_SELECTION", "viewNames", "", "", "[Ljava/lang/String;", "jugglinglab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljugglinglab/view/View$GIFWriter;", "Ljava/lang/Thread;", "ap", "Ljugglinglab/core/AnimationPanel;", "file", "Ljava/io/File;", "cleanup", "Ljava/lang/Runnable;", "<init>", "(Ljugglinglab/view/View;Ljugglinglab/core/AnimationPanel;Ljava/io/File;Ljava/lang/Runnable;)V", "pm", "Ljavax/swing/ProgressMonitor;", "wgm", "Ljugglinglab/core/Animator$WriteGIFMonitor;", "fps", "", "run", "", "jugglinglab"})
    protected final class GIFWriter
    extends Thread {
        @NotNull
        private final AnimationPanel ap;
        @NotNull
        private final File file;
        @Nullable
        private final Runnable cleanup;
        @NotNull
        private final ProgressMonitor pm;
        @NotNull
        private final Animator.WriteGIFMonitor wgm;
        private final double fps;

        public GIFWriter(@NotNull AnimationPanel ap, @Nullable File file, Runnable cleanup) {
            Intrinsics.checkNotNullParameter(ap, "ap");
            Intrinsics.checkNotNullParameter(file, "file");
            this.ap = ap;
            this.file = file;
            this.cleanup = cleanup;
            this.pm = new ProgressMonitor(View.this.getPatternWindow(), JugglingLab.INSTANCE.getGuistrings().getString("Saving_animated_GIF"), "", 0, 1);
            this.pm.setMillisToPopup(200);
            this.wgm = new Animator.WriteGIFMonitor(){

                @Override
                public void update(int step, int stepsTotal) {
                    SwingUtilities.invokeLater(() -> 1.update$lambda$0(this, stepsTotal, step));
                }

                @Override
                public boolean isCanceled() {
                    return pm.isCanceled() || Thread.interrupted();
                }

                private static final void update$lambda$0(GIFWriter this$0, int $stepsTotal, int $step) {
                    this$0.pm.setMaximum($stepsTotal);
                    this$0.pm.setProgress($step);
                }
            };
            AnimationPrefs jc = this.ap.getAnimationPrefs();
            this.fps = jc.getFps() == AnimationPrefs.Companion.getFPS_DEF() ? 33.3 : jc.getFps();
            this.setPriority(1);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.ap.getAnimator().writeGIF(new FileOutputStream(this.file), this.wgm, this.fps);
            }
            catch (IOException iOException) {
                String string = JugglingLab.INSTANCE.getErrorstrings().getString("Error_writing_file");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                String template = string;
                Object[] objectArray = new Object[]{this.file.toString()};
                Object[] arg = objectArray;
                ErrorDialog.INSTANCE.handleUserException(View.this.getParent(), MessageFormat.format(template, Arrays.copyOf(arg, arg.length)));
            }
            catch (JuggleExceptionInternal jei) {
                ErrorDialog.INSTANCE.handleFatalException(jei);
            }
            finally {
                if (this.cleanup != null) {
                    SwingUtilities.invokeLater(this.cleanup);
                }
            }
        }
    }
}

