/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableMultivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.function.Identity;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            public double value(double x) {
                double r = x;
                for (int i2 = f.length - 1; i2 >= 0; --i2) {
                    r = f[i2].value(r);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction compose(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            public double value(double t2) {
                double r = t2;
                for (int i2 = f.length - 1; i2 >= 0; --i2) {
                    r = f[i2].value(r);
                }
                return r;
            }

            public DerivativeStructure value(DerivativeStructure t2) {
                DerivativeStructure r = t2;
                for (int i2 = f.length - 1; i2 >= 0; --i2) {
                    r = f[i2].value(r);
                }
                return r;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction compose(final DifferentiableUnivariateFunction ... f) {
        return new DifferentiableUnivariateFunction(){

            public double value(double x) {
                double r = x;
                for (int i2 = f.length - 1; i2 >= 0; --i2) {
                    r = f[i2].value(r);
                }
                return r;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double x) {
                        double p = 1.0;
                        double r = x;
                        for (int i2 = f.length - 1; i2 >= 0; --i2) {
                            p *= f[i2].derivative().value(r);
                            r = f[i2].value(r);
                        }
                        return p;
                    }
                };
            }
        };
    }

    public static UnivariateFunction add(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            public double value(double x) {
                double r = f[0].value(x);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r += f[i2].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction add(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            public double value(double t2) {
                double r = f[0].value(t2);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r += f[i2].value(t2);
                }
                return r;
            }

            public DerivativeStructure value(DerivativeStructure t2) throws DimensionMismatchException {
                DerivativeStructure r = f[0].value(t2);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r = r.add(f[i2].value(t2));
                }
                return r;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction add(final DifferentiableUnivariateFunction ... f) {
        return new DifferentiableUnivariateFunction(){

            public double value(double x) {
                double r = f[0].value(x);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r += f[i2].value(x);
                }
                return r;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double x) {
                        double r = f[0].derivative().value(x);
                        for (int i2 = 1; i2 < f.length; ++i2) {
                            r += f[i2].derivative().value(x);
                        }
                        return r;
                    }
                };
            }
        };
    }

    public static UnivariateFunction multiply(final UnivariateFunction ... f) {
        return new UnivariateFunction(){

            public double value(double x) {
                double r = f[0].value(x);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r *= f[i2].value(x);
                }
                return r;
            }
        };
    }

    public static UnivariateDifferentiableFunction multiply(final UnivariateDifferentiableFunction ... f) {
        return new UnivariateDifferentiableFunction(){

            public double value(double t2) {
                double r = f[0].value(t2);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r *= f[i2].value(t2);
                }
                return r;
            }

            public DerivativeStructure value(DerivativeStructure t2) {
                DerivativeStructure r = f[0].value(t2);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r = r.multiply(f[i2].value(t2));
                }
                return r;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction multiply(final DifferentiableUnivariateFunction ... f) {
        return new DifferentiableUnivariateFunction(){

            public double value(double x) {
                double r = f[0].value(x);
                for (int i2 = 1; i2 < f.length; ++i2) {
                    r *= f[i2].value(x);
                }
                return r;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double x) {
                        double sum = 0.0;
                        for (int i2 = 0; i2 < f.length; ++i2) {
                            double prod = f[i2].derivative().value(x);
                            for (int j = 0; j < f.length; ++j) {
                                if (i2 == j) continue;
                                prod *= f[j].value(x);
                            }
                            sum += prod;
                        }
                        return sum;
                    }
                };
            }
        };
    }

    public static UnivariateFunction combine(final BivariateFunction combiner, final UnivariateFunction f, final UnivariateFunction g) {
        return new UnivariateFunction(){

            public double value(double x) {
                return combiner.value(f.value(x), g.value(x));
            }
        };
    }

    public static MultivariateFunction collector(final BivariateFunction combiner, final UnivariateFunction f, final double initialValue) {
        return new MultivariateFunction(){

            public double value(double[] point) {
                double result = combiner.value(initialValue, f.value(point[0]));
                for (int i2 = 1; i2 < point.length; ++i2) {
                    result = combiner.value(result, f.value(point[i2]));
                }
                return result;
            }
        };
    }

    public static MultivariateFunction collector(BivariateFunction combiner, double initialValue) {
        return FunctionUtils.collector(combiner, new Identity(), initialValue);
    }

    public static UnivariateFunction fix1stArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            public double value(double x) {
                return f.value(fixed, x);
            }
        };
    }

    public static UnivariateFunction fix2ndArgument(final BivariateFunction f, final double fixed) {
        return new UnivariateFunction(){

            public double value(double x) {
                return f.value(x, fixed);
            }
        };
    }

    public static double[] sample(UnivariateFunction f, double min, double max, int n) throws NumberIsTooLargeException, NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        if (min >= max) {
            throw new NumberIsTooLargeException(min, (Number)max, false);
        }
        double[] s = new double[n];
        double h = (max - min) / (double)n;
        for (int i2 = 0; i2 < n; ++i2) {
            s[i2] = f.value(min + (double)i2 * h);
        }
        return s;
    }

    @Deprecated
    public static DifferentiableUnivariateFunction toDifferentiableUnivariateFunction(final UnivariateDifferentiableFunction f) {
        return new DifferentiableUnivariateFunction(){

            public double value(double x) {
                return f.value(x);
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double x) {
                        return f.value(new DerivativeStructure(1, 1, 0, x)).getPartialDerivative(1);
                    }
                };
            }
        };
    }

    @Deprecated
    public static UnivariateDifferentiableFunction toUnivariateDifferential(final DifferentiableUnivariateFunction f) {
        return new UnivariateDifferentiableFunction(){

            public double value(double x) {
                return f.value(x);
            }

            public DerivativeStructure value(DerivativeStructure t2) throws NumberIsTooLargeException {
                switch (t2.getOrder()) {
                    case 0: {
                        return new DerivativeStructure(t2.getFreeParameters(), 0, f.value(t2.getValue()));
                    }
                    case 1: {
                        int parameters = t2.getFreeParameters();
                        double[] derivatives = new double[parameters + 1];
                        derivatives[0] = f.value(t2.getValue());
                        double fPrime = f.derivative().value(t2.getValue());
                        int[] orders = new int[parameters];
                        for (int i2 = 0; i2 < parameters; ++i2) {
                            orders[i2] = 1;
                            derivatives[i2 + 1] = fPrime * t2.getPartialDerivative(orders);
                            orders[i2] = 0;
                        }
                        return new DerivativeStructure(parameters, 1, derivatives);
                    }
                }
                throw new NumberIsTooLargeException(t2.getOrder(), (Number)1, true);
            }
        };
    }

    @Deprecated
    public static DifferentiableMultivariateFunction toDifferentiableMultivariateFunction(final MultivariateDifferentiableFunction f) {
        return new DifferentiableMultivariateFunction(){

            public double value(double[] x) {
                return f.value(x);
            }

            public MultivariateFunction partialDerivative(final int k) {
                return new MultivariateFunction(){

                    public double value(double[] x) {
                        int n = x.length;
                        DerivativeStructure[] dsX = new DerivativeStructure[n];
                        for (int i2 = 0; i2 < n; ++i2) {
                            dsX[i2] = i2 == k ? new DerivativeStructure(1, 1, 0, x[i2]) : new DerivativeStructure(1, 1, x[i2]);
                        }
                        DerivativeStructure y = f.value(dsX);
                        return y.getPartialDerivative(1);
                    }
                };
            }

            public MultivariateVectorFunction gradient() {
                return new MultivariateVectorFunction(){

                    public double[] value(double[] x) {
                        int n = x.length;
                        DerivativeStructure[] dsX = new DerivativeStructure[n];
                        for (int i2 = 0; i2 < n; ++i2) {
                            dsX[i2] = new DerivativeStructure(n, 1, i2, x[i2]);
                        }
                        DerivativeStructure y = f.value(dsX);
                        double[] gradient = new double[n];
                        int[] orders = new int[n];
                        for (int i3 = 0; i3 < n; ++i3) {
                            orders[i3] = 1;
                            gradient[i3] = y.getPartialDerivative(orders);
                            orders[i3] = 0;
                        }
                        return gradient;
                    }
                };
            }
        };
    }

    @Deprecated
    public static MultivariateDifferentiableFunction toMultivariateDifferentiableFunction(final DifferentiableMultivariateFunction f) {
        return new MultivariateDifferentiableFunction(){

            public double value(double[] x) {
                return f.value(x);
            }

            public DerivativeStructure value(DerivativeStructure[] t2) throws DimensionMismatchException, NumberIsTooLargeException {
                int parameters = t2[0].getFreeParameters();
                int order = t2[0].getOrder();
                int n = t2.length;
                if (order > 1) {
                    throw new NumberIsTooLargeException(order, (Number)1, true);
                }
                for (int i2 = 0; i2 < n; ++i2) {
                    if (t2[i2].getFreeParameters() != parameters) {
                        throw new DimensionMismatchException(t2[i2].getFreeParameters(), parameters);
                    }
                    if (t2[i2].getOrder() == order) continue;
                    throw new DimensionMismatchException(t2[i2].getOrder(), order);
                }
                double[] point = new double[n];
                for (int i3 = 0; i3 < n; ++i3) {
                    point[i3] = t2[i3].getValue();
                }
                double value = f.value(point);
                double[] gradient = f.gradient().value(point);
                double[] derivatives = new double[parameters + 1];
                derivatives[0] = value;
                int[] orders = new int[parameters];
                for (int i4 = 0; i4 < parameters; ++i4) {
                    orders[i4] = 1;
                    for (int j = 0; j < n; ++j) {
                        int n2 = i4 + 1;
                        derivatives[n2] = derivatives[n2] + gradient[j] * t2[j].getPartialDerivative(orders);
                    }
                    orders[i4] = 0;
                }
                return new DerivativeStructure(parameters, order, derivatives);
            }
        };
    }

    @Deprecated
    public static DifferentiableMultivariateVectorFunction toDifferentiableMultivariateVectorFunction(final MultivariateDifferentiableVectorFunction f) {
        return new DifferentiableMultivariateVectorFunction(){

            public double[] value(double[] x) {
                return f.value(x);
            }

            public MultivariateMatrixFunction jacobian() {
                return new MultivariateMatrixFunction(){

                    public double[][] value(double[] x) {
                        int n = x.length;
                        DerivativeStructure[] dsX = new DerivativeStructure[n];
                        for (int i2 = 0; i2 < n; ++i2) {
                            dsX[i2] = new DerivativeStructure(n, 1, i2, x[i2]);
                        }
                        DerivativeStructure[] y = f.value(dsX);
                        double[][] jacobian = new double[y.length][n];
                        int[] orders = new int[n];
                        for (int i3 = 0; i3 < y.length; ++i3) {
                            for (int j = 0; j < n; ++j) {
                                orders[j] = 1;
                                jacobian[i3][j] = y[i3].getPartialDerivative(orders);
                                orders[j] = 0;
                            }
                        }
                        return jacobian;
                    }
                };
            }
        };
    }

    @Deprecated
    public static MultivariateDifferentiableVectorFunction toMultivariateDifferentiableVectorFunction(final DifferentiableMultivariateVectorFunction f) {
        return new MultivariateDifferentiableVectorFunction(){

            public double[] value(double[] x) {
                return f.value(x);
            }

            public DerivativeStructure[] value(DerivativeStructure[] t2) throws DimensionMismatchException, NumberIsTooLargeException {
                int parameters = t2[0].getFreeParameters();
                int order = t2[0].getOrder();
                int n = t2.length;
                if (order > 1) {
                    throw new NumberIsTooLargeException(order, (Number)1, true);
                }
                for (int i2 = 0; i2 < n; ++i2) {
                    if (t2[i2].getFreeParameters() != parameters) {
                        throw new DimensionMismatchException(t2[i2].getFreeParameters(), parameters);
                    }
                    if (t2[i2].getOrder() == order) continue;
                    throw new DimensionMismatchException(t2[i2].getOrder(), order);
                }
                double[] point = new double[n];
                for (int i3 = 0; i3 < n; ++i3) {
                    point[i3] = t2[i3].getValue();
                }
                double[] value = f.value(point);
                double[][] jacobian = f.jacobian().value(point);
                DerivativeStructure[] merged = new DerivativeStructure[value.length];
                for (int k = 0; k < merged.length; ++k) {
                    double[] derivatives = new double[parameters + 1];
                    derivatives[0] = value[k];
                    int[] orders = new int[parameters];
                    for (int i4 = 0; i4 < parameters; ++i4) {
                        orders[i4] = 1;
                        for (int j = 0; j < n; ++j) {
                            int n2 = i4 + 1;
                            derivatives[n2] = derivatives[n2] + jacobian[k][j] * t2[j].getPartialDerivative(orders);
                        }
                        orders[i4] = 0;
                    }
                    merged[k] = new DerivativeStructure(parameters, order, derivatives);
                }
                return merged;
            }
        };
    }
}

