/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.TestAbortedException;

@API(status=API.Status.STABLE, since="5.0")
public class Assumptions {
    protected Assumptions() {
    }

    public static void assumeTrue(boolean assumption) throws TestAbortedException {
        Assumptions.assumeTrue(assumption, "assumption is not true");
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), "assumption is not true");
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, String message) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), message);
    }

    public static void assumeTrue(boolean assumption, Supplier<String> messageSupplier) throws TestAbortedException {
        if (!assumption) {
            Assumptions.throwTestAbortedException(messageSupplier.get());
        }
    }

    public static void assumeTrue(boolean assumption, String message) throws TestAbortedException {
        if (!assumption) {
            Assumptions.throwTestAbortedException(message);
        }
    }

    public static void assumeTrue(BooleanSupplier assumptionSupplier, Supplier<String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeTrue(assumptionSupplier.getAsBoolean(), messageSupplier);
    }

    public static void assumeFalse(boolean assumption) throws TestAbortedException {
        Assumptions.assumeFalse(assumption, "assumption is not false");
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), "assumption is not false");
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, String message) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), message);
    }

    public static void assumeFalse(boolean assumption, Supplier<String> messageSupplier) throws TestAbortedException {
        if (assumption) {
            Assumptions.throwTestAbortedException(messageSupplier.get());
        }
    }

    public static void assumeFalse(boolean assumption, String message) throws TestAbortedException {
        if (assumption) {
            Assumptions.throwTestAbortedException(message);
        }
    }

    public static void assumeFalse(BooleanSupplier assumptionSupplier, Supplier<String> messageSupplier) throws TestAbortedException {
        Assumptions.assumeFalse(assumptionSupplier.getAsBoolean(), messageSupplier);
    }

    public static void assumingThat(BooleanSupplier assumptionSupplier, Executable executable) {
        Assumptions.assumingThat(assumptionSupplier.getAsBoolean(), executable);
    }

    public static void assumingThat(boolean assumption, Executable executable) {
        if (assumption) {
            try {
                executable.execute();
            }
            catch (Throwable t2) {
                ExceptionUtils.throwAsUncheckedException(t2);
            }
        }
    }

    private static void throwTestAbortedException(String message) {
        throw new TestAbortedException(StringUtils.isNotBlank(message) ? "Assumption failed: " + message : "Assumption failed");
    }
}

