/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static RuntimeException throwAsUncheckedException(Throwable t2) {
        Preconditions.notNull(t2, "Throwable must not be null");
        ExceptionUtils.throwAs(t2);
        return null;
    }

    private static <T extends Throwable> void throwAs(Throwable t2) throws T {
        throw t2;
    }

    public static String readStackTrace(Throwable throwable) {
        Preconditions.notNull(throwable, "Throwable must not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

