<?php
/**
 * The file that defines the Cekongkir_Courier_LION class
 *
 * @link       https://github.com/sofyansitorus
 * @since      1.2.12
 *
 * @package    Cekongkir
 * @subpackage Cekongkir/includes
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Cekongkir_Courier_LION class.
 *
 * @since      1.2.12
 * @package    Cekongkir
 * @subpackage Cekongkir/includes
 * @author     Sofyan Sitorus <sofyansitorus@gmail.com>
 */
class Cekongkir_Courier_LION extends Cekongkir_Courier {

	/**
	 * Courier Code
	 *
	 * @since 1.2.12
	 *
	 * @var string
	 */
	public $code = 'lion';

	/**
	 * Courier Label
	 *
	 * @since 1.2.12
	 *
	 * @var string
	 */
	public $label = 'Lion Parcel';

	/**
	 * Courier Website
	 *
	 * @since 1.2.12
	 *
	 * @var string
	 */
	public $website = 'http://lionparcel.com';

	/**
	 * Get courier services for domestic shipping
	 *
	 * @since 1.2.12
	 *
	 * @return array
	 */
	public function get_services_domestic_default() {
		return array(
			'JAGOPACK' => 'Economy Service',
			'REGPACK'  => 'Regular Service',
			'BOSSPACK' => 'Boss Service',
			'BIGPACK'  => 'Big Package Service',
			'LANDPACK' => 'Logistic Service',
			'ONEPACK'  => 'One Day Service',
			'OTOPACK150' => 'Oto Service',
			'OTOPACK250' => 'Oto Service',
		);
	}

	public function get_services_international_default() {
		return array(
			'INTERPACK'             => 'INTERPACK',
		);
	}

	/**
	 * Get courier account for domestic shipping
	 *
	 * @since 1.2.12
	 *
	 * @return array
	 */
	public function get_account_domestic() {
		return array(
			'pro',
		);
	}



	public function get_account_international() {
		return array(
			'starter',
			'basic',
			'pro',
		);
	}
}