// Code generated by protoc-gen-go. DO NOT EDIT.
// source: build_proto/build.proto

/*
Package blaze_query is a generated protocol buffer package.

It is generated from these files:
	build_proto/build.proto

It has these top-level messages:
	License
	StringDictEntry
	LabelDictUnaryEntry
	LabelListDictEntry
	LabelKeyedStringDictEntry
	StringListDictEntry
	FilesetEntry
	Attribute
	Rule
	AttributeAspect
	SkylarkAspect
	RuleSummary
	PackageGroup
	EnvironmentGroup
	SourceFile
	GeneratedFile
	Target
	QueryResult
	AllowedRuleClassInfo
	AttributeDefinition
	RuleDefinition
	BuildLanguage
	Location
	MakeVarBinding
	MakeVar
	GlobCriteria
	Event
*/
package blaze_query

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates what to do when a source file is actually a symlink.
type FilesetEntry_SymlinkBehavior int32

const (
	FilesetEntry_COPY        FilesetEntry_SymlinkBehavior = 1
	FilesetEntry_DEREFERENCE FilesetEntry_SymlinkBehavior = 2
)

var FilesetEntry_SymlinkBehavior_name = map[int32]string{
	1: "COPY",
	2: "DEREFERENCE",
}
var FilesetEntry_SymlinkBehavior_value = map[string]int32{
	"COPY":        1,
	"DEREFERENCE": 2,
}

func (x FilesetEntry_SymlinkBehavior) Enum() *FilesetEntry_SymlinkBehavior {
	p := new(FilesetEntry_SymlinkBehavior)
	*p = x
	return p
}
func (x FilesetEntry_SymlinkBehavior) String() string {
	return proto.EnumName(FilesetEntry_SymlinkBehavior_name, int32(x))
}
func (x *FilesetEntry_SymlinkBehavior) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FilesetEntry_SymlinkBehavior_value, data, "FilesetEntry_SymlinkBehavior")
	if err != nil {
		return err
	}
	*x = FilesetEntry_SymlinkBehavior(value)
	return nil
}
func (FilesetEntry_SymlinkBehavior) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{6, 0}
}

// Indicates the type of attribute.
type Attribute_Discriminator int32

const (
	Attribute_INTEGER                      Attribute_Discriminator = 1
	Attribute_STRING                       Attribute_Discriminator = 2
	Attribute_LABEL                        Attribute_Discriminator = 3
	Attribute_OUTPUT                       Attribute_Discriminator = 4
	Attribute_STRING_LIST                  Attribute_Discriminator = 5
	Attribute_LABEL_LIST                   Attribute_Discriminator = 6
	Attribute_OUTPUT_LIST                  Attribute_Discriminator = 7
	Attribute_DISTRIBUTION_SET             Attribute_Discriminator = 8
	Attribute_LICENSE                      Attribute_Discriminator = 9
	Attribute_STRING_DICT                  Attribute_Discriminator = 10
	Attribute_FILESET_ENTRY_LIST           Attribute_Discriminator = 11
	Attribute_LABEL_LIST_DICT              Attribute_Discriminator = 12
	Attribute_STRING_LIST_DICT             Attribute_Discriminator = 13
	Attribute_BOOLEAN                      Attribute_Discriminator = 14
	Attribute_TRISTATE                     Attribute_Discriminator = 15
	Attribute_INTEGER_LIST                 Attribute_Discriminator = 16
	Attribute_UNKNOWN                      Attribute_Discriminator = 18
	Attribute_LABEL_DICT_UNARY             Attribute_Discriminator = 19
	Attribute_SELECTOR_LIST                Attribute_Discriminator = 20
	Attribute_LABEL_KEYED_STRING_DICT      Attribute_Discriminator = 21
	Attribute_DEPRECATED_STRING_DICT_UNARY Attribute_Discriminator = 17
)

var Attribute_Discriminator_name = map[int32]string{
	1:  "INTEGER",
	2:  "STRING",
	3:  "LABEL",
	4:  "OUTPUT",
	5:  "STRING_LIST",
	6:  "LABEL_LIST",
	7:  "OUTPUT_LIST",
	8:  "DISTRIBUTION_SET",
	9:  "LICENSE",
	10: "STRING_DICT",
	11: "FILESET_ENTRY_LIST",
	12: "LABEL_LIST_DICT",
	13: "STRING_LIST_DICT",
	14: "BOOLEAN",
	15: "TRISTATE",
	16: "INTEGER_LIST",
	18: "UNKNOWN",
	19: "LABEL_DICT_UNARY",
	20: "SELECTOR_LIST",
	21: "LABEL_KEYED_STRING_DICT",
	17: "DEPRECATED_STRING_DICT_UNARY",
}
var Attribute_Discriminator_value = map[string]int32{
	"INTEGER":                      1,
	"STRING":                       2,
	"LABEL":                        3,
	"OUTPUT":                       4,
	"STRING_LIST":                  5,
	"LABEL_LIST":                   6,
	"OUTPUT_LIST":                  7,
	"DISTRIBUTION_SET":             8,
	"LICENSE":                      9,
	"STRING_DICT":                  10,
	"FILESET_ENTRY_LIST":           11,
	"LABEL_LIST_DICT":              12,
	"STRING_LIST_DICT":             13,
	"BOOLEAN":                      14,
	"TRISTATE":                     15,
	"INTEGER_LIST":                 16,
	"UNKNOWN":                      18,
	"LABEL_DICT_UNARY":             19,
	"SELECTOR_LIST":                20,
	"LABEL_KEYED_STRING_DICT":      21,
	"DEPRECATED_STRING_DICT_UNARY": 17,
}

func (x Attribute_Discriminator) Enum() *Attribute_Discriminator {
	p := new(Attribute_Discriminator)
	*p = x
	return p
}
func (x Attribute_Discriminator) String() string {
	return proto.EnumName(Attribute_Discriminator_name, int32(x))
}
func (x *Attribute_Discriminator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Attribute_Discriminator_value, data, "Attribute_Discriminator")
	if err != nil {
		return err
	}
	*x = Attribute_Discriminator(value)
	return nil
}
func (Attribute_Discriminator) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

// Values for the TriState field type.
type Attribute_Tristate int32

const (
	Attribute_NO   Attribute_Tristate = 0
	Attribute_YES  Attribute_Tristate = 1
	Attribute_AUTO Attribute_Tristate = 2
)

var Attribute_Tristate_name = map[int32]string{
	0: "NO",
	1: "YES",
	2: "AUTO",
}
var Attribute_Tristate_value = map[string]int32{
	"NO":   0,
	"YES":  1,
	"AUTO": 2,
}

func (x Attribute_Tristate) Enum() *Attribute_Tristate {
	p := new(Attribute_Tristate)
	*p = x
	return p
}
func (x Attribute_Tristate) String() string {
	return proto.EnumName(Attribute_Tristate_name, int32(x))
}
func (x *Attribute_Tristate) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Attribute_Tristate_value, data, "Attribute_Tristate")
	if err != nil {
		return err
	}
	*x = Attribute_Tristate(value)
	return nil
}
func (Attribute_Tristate) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 1} }

type Target_Discriminator int32

const (
	Target_RULE              Target_Discriminator = 1
	Target_SOURCE_FILE       Target_Discriminator = 2
	Target_GENERATED_FILE    Target_Discriminator = 3
	Target_PACKAGE_GROUP     Target_Discriminator = 4
	Target_ENVIRONMENT_GROUP Target_Discriminator = 5
)

var Target_Discriminator_name = map[int32]string{
	1: "RULE",
	2: "SOURCE_FILE",
	3: "GENERATED_FILE",
	4: "PACKAGE_GROUP",
	5: "ENVIRONMENT_GROUP",
}
var Target_Discriminator_value = map[string]int32{
	"RULE":              1,
	"SOURCE_FILE":       2,
	"GENERATED_FILE":    3,
	"PACKAGE_GROUP":     4,
	"ENVIRONMENT_GROUP": 5,
}

func (x Target_Discriminator) Enum() *Target_Discriminator {
	p := new(Target_Discriminator)
	*p = x
	return p
}
func (x Target_Discriminator) String() string {
	return proto.EnumName(Target_Discriminator_name, int32(x))
}
func (x *Target_Discriminator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Target_Discriminator_value, data, "Target_Discriminator")
	if err != nil {
		return err
	}
	*x = Target_Discriminator(value)
	return nil
}
func (Target_Discriminator) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{16, 0} }

type AllowedRuleClassInfo_AllowedRuleClasses int32

const (
	AllowedRuleClassInfo_ANY       AllowedRuleClassInfo_AllowedRuleClasses = 1
	AllowedRuleClassInfo_SPECIFIED AllowedRuleClassInfo_AllowedRuleClasses = 2
)

var AllowedRuleClassInfo_AllowedRuleClasses_name = map[int32]string{
	1: "ANY",
	2: "SPECIFIED",
}
var AllowedRuleClassInfo_AllowedRuleClasses_value = map[string]int32{
	"ANY":       1,
	"SPECIFIED": 2,
}

func (x AllowedRuleClassInfo_AllowedRuleClasses) Enum() *AllowedRuleClassInfo_AllowedRuleClasses {
	p := new(AllowedRuleClassInfo_AllowedRuleClasses)
	*p = x
	return p
}
func (x AllowedRuleClassInfo_AllowedRuleClasses) String() string {
	return proto.EnumName(AllowedRuleClassInfo_AllowedRuleClasses_name, int32(x))
}
func (x *AllowedRuleClassInfo_AllowedRuleClasses) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AllowedRuleClassInfo_AllowedRuleClasses_value, data, "AllowedRuleClassInfo_AllowedRuleClasses")
	if err != nil {
		return err
	}
	*x = AllowedRuleClassInfo_AllowedRuleClasses(value)
	return nil
}
func (AllowedRuleClassInfo_AllowedRuleClasses) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 0}
}

type Event_EventKind int32

const (
	Event_ERROR    Event_EventKind = 1
	Event_WARNING  Event_EventKind = 2
	Event_INFO     Event_EventKind = 3
	Event_PROGRESS Event_EventKind = 4
)

var Event_EventKind_name = map[int32]string{
	1: "ERROR",
	2: "WARNING",
	3: "INFO",
	4: "PROGRESS",
}
var Event_EventKind_value = map[string]int32{
	"ERROR":    1,
	"WARNING":  2,
	"INFO":     3,
	"PROGRESS": 4,
}

func (x Event_EventKind) Enum() *Event_EventKind {
	p := new(Event_EventKind)
	*p = x
	return p
}
func (x Event_EventKind) String() string {
	return proto.EnumName(Event_EventKind_name, int32(x))
}
func (x *Event_EventKind) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Event_EventKind_value, data, "Event_EventKind")
	if err != nil {
		return err
	}
	*x = Event_EventKind(value)
	return nil
}
func (Event_EventKind) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{26, 0} }

type License struct {
	LicenseType      []string `protobuf:"bytes,1,rep,name=license_type,json=licenseType" json:"license_type,omitempty"`
	Exception        []string `protobuf:"bytes,2,rep,name=exception" json:"exception,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *License) Reset()                    { *m = License{} }
func (m *License) String() string            { return proto.CompactTextString(m) }
func (*License) ProtoMessage()               {}
func (*License) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *License) GetLicenseType() []string {
	if m != nil {
		return m.LicenseType
	}
	return nil
}

func (m *License) GetException() []string {
	if m != nil {
		return m.Exception
	}
	return nil
}

type StringDictEntry struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StringDictEntry) Reset()                    { *m = StringDictEntry{} }
func (m *StringDictEntry) String() string            { return proto.CompactTextString(m) }
func (*StringDictEntry) ProtoMessage()               {}
func (*StringDictEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *StringDictEntry) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *StringDictEntry) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type LabelDictUnaryEntry struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LabelDictUnaryEntry) Reset()                    { *m = LabelDictUnaryEntry{} }
func (m *LabelDictUnaryEntry) String() string            { return proto.CompactTextString(m) }
func (*LabelDictUnaryEntry) ProtoMessage()               {}
func (*LabelDictUnaryEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *LabelDictUnaryEntry) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *LabelDictUnaryEntry) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type LabelListDictEntry struct {
	Key              *string  `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            []string `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *LabelListDictEntry) Reset()                    { *m = LabelListDictEntry{} }
func (m *LabelListDictEntry) String() string            { return proto.CompactTextString(m) }
func (*LabelListDictEntry) ProtoMessage()               {}
func (*LabelListDictEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *LabelListDictEntry) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *LabelListDictEntry) GetValue() []string {
	if m != nil {
		return m.Value
	}
	return nil
}

type LabelKeyedStringDictEntry struct {
	Key              *string `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            *string `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LabelKeyedStringDictEntry) Reset()                    { *m = LabelKeyedStringDictEntry{} }
func (m *LabelKeyedStringDictEntry) String() string            { return proto.CompactTextString(m) }
func (*LabelKeyedStringDictEntry) ProtoMessage()               {}
func (*LabelKeyedStringDictEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *LabelKeyedStringDictEntry) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *LabelKeyedStringDictEntry) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type StringListDictEntry struct {
	Key              *string  `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            []string `protobuf:"bytes,2,rep,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *StringListDictEntry) Reset()                    { *m = StringListDictEntry{} }
func (m *StringListDictEntry) String() string            { return proto.CompactTextString(m) }
func (*StringListDictEntry) ProtoMessage()               {}
func (*StringListDictEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *StringListDictEntry) GetKey() string {
	if m != nil && m.Key != nil {
		return *m.Key
	}
	return ""
}

func (m *StringListDictEntry) GetValue() []string {
	if m != nil {
		return m.Value
	}
	return nil
}

// Represents an entry attribute of a Fileset rule in a build file.
type FilesetEntry struct {
	// The label pointing to the source target where files are copied from.
	Source *string `protobuf:"bytes,1,req,name=source" json:"source,omitempty"`
	// The relative path within the fileset rule where files will be mapped.
	DestinationDirectory *string `protobuf:"bytes,2,req,name=destination_directory,json=destinationDirectory" json:"destination_directory,omitempty"`
	// Whether the files= attribute was specified. This is necessary because
	// no files= attribute and files=[] mean different things.
	FilesPresent *bool `protobuf:"varint,7,opt,name=files_present,json=filesPresent" json:"files_present,omitempty"`
	// A list of file labels to include from the source directory.
	File []string `protobuf:"bytes,3,rep,name=file" json:"file,omitempty"`
	// If this is a fileset entry representing files within the rule
	// package, this lists relative paths to files that should be excluded from
	// the set.  This cannot contain values if 'file' also has values.
	Exclude []string `protobuf:"bytes,4,rep,name=exclude" json:"exclude,omitempty"`
	// This field is optional because there will be some time when the new
	// PB is used by tools depending on blaze query, but the new blaze version
	// is not yet released.
	// TODO(bazel-team): Make this field required once a version of Blaze is
	// released that outputs this field.
	SymlinkBehavior *FilesetEntry_SymlinkBehavior `protobuf:"varint,5,opt,name=symlink_behavior,json=symlinkBehavior,enum=blaze_query.FilesetEntry_SymlinkBehavior,def=1" json:"symlink_behavior,omitempty"`
	// The prefix to strip from the path of the files in this FilesetEntry. Note
	// that no value and the empty string as the value mean different things here.
	StripPrefix      *string `protobuf:"bytes,6,opt,name=strip_prefix,json=stripPrefix" json:"strip_prefix,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FilesetEntry) Reset()                    { *m = FilesetEntry{} }
func (m *FilesetEntry) String() string            { return proto.CompactTextString(m) }
func (*FilesetEntry) ProtoMessage()               {}
func (*FilesetEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

const Default_FilesetEntry_SymlinkBehavior FilesetEntry_SymlinkBehavior = FilesetEntry_COPY

func (m *FilesetEntry) GetSource() string {
	if m != nil && m.Source != nil {
		return *m.Source
	}
	return ""
}

func (m *FilesetEntry) GetDestinationDirectory() string {
	if m != nil && m.DestinationDirectory != nil {
		return *m.DestinationDirectory
	}
	return ""
}

func (m *FilesetEntry) GetFilesPresent() bool {
	if m != nil && m.FilesPresent != nil {
		return *m.FilesPresent
	}
	return false
}

func (m *FilesetEntry) GetFile() []string {
	if m != nil {
		return m.File
	}
	return nil
}

func (m *FilesetEntry) GetExclude() []string {
	if m != nil {
		return m.Exclude
	}
	return nil
}

func (m *FilesetEntry) GetSymlinkBehavior() FilesetEntry_SymlinkBehavior {
	if m != nil && m.SymlinkBehavior != nil {
		return *m.SymlinkBehavior
	}
	return Default_FilesetEntry_SymlinkBehavior
}

func (m *FilesetEntry) GetStripPrefix() string {
	if m != nil && m.StripPrefix != nil {
		return *m.StripPrefix
	}
	return ""
}

// A rule attribute. Each attribute must have a type and one of the various
// value fields populated - for the most part.
//
// Attributes of BOOLEAN and TRISTATE type may set all of the int, bool, and
// string values for backwards compatibility with clients that expect them to
// be set.
//
// Attributes of INTEGER, STRING, LABEL, LICENSE, BOOLEAN, and TRISTATE type
// may set *none* of the values. This can happen if the Attribute message is
// prepared for a client that doesn't support SELECTOR_LIST, but the rule has
// a selector list value for the attribute. (Selector lists for attributes of
// other types--the collection types--are handled differently when prepared
// for such a client. The possible collection values are gathered together
// and flattened.)
//
// By checking the type, the appropriate value can be extracted - see the
// comments on each type for the associated value.  The order of lists comes
// from the blaze parsing. If an attribute is of a list type, the associated
// list should never be empty.
type Attribute struct {
	// The name of the attribute
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The location of the target in the BUILD file in a machine-parseable form.
	DEPRECATEDParseableLocation *Location `protobuf:"bytes,12,opt,name=DEPRECATED_parseable_location,json=DEPRECATEDParseableLocation" json:"DEPRECATED_parseable_location,omitempty"`
	// Whether the attribute was explicitly specified
	ExplicitlySpecified *bool `protobuf:"varint,13,opt,name=explicitly_specified,json=explicitlySpecified" json:"explicitly_specified,omitempty"`
	// If this attribute has a string value or a string list value, then this
	// may be set to indicate that the value may be treated as a label that
	// isn't a dependency of this attribute's rule.
	Nodep *bool `protobuf:"varint,20,opt,name=nodep" json:"nodep,omitempty"`
	// The type of attribute.  This message is used for all of the different
	// attribute types so the discriminator helps for figuring out what is
	// stored in the message.
	Type *Attribute_Discriminator `protobuf:"varint,2,req,name=type,enum=blaze_query.Attribute_Discriminator" json:"type,omitempty"`
	// If this attribute has an integer value this will be populated.
	// Boolean and TriState also use this field as [0,1] and [-1,0,1]
	// for [false, true] and [auto, no, yes] respectively.
	IntValue *int32 `protobuf:"varint,3,opt,name=int_value,json=intValue" json:"int_value,omitempty"`
	// If the attribute has a string value this will be populated.  Label and
	// path attributes use this field as the value even though the type may
	// be LABEL or something else other than STRING.
	StringValue *string `protobuf:"bytes,5,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	// If the attribute has a boolean value this will be populated.
	BooleanValue *bool `protobuf:"varint,14,opt,name=boolean_value,json=booleanValue" json:"boolean_value,omitempty"`
	// If the attribute is a Tristate value, this will be populated.
	TristateValue *Attribute_Tristate `protobuf:"varint,15,opt,name=tristate_value,json=tristateValue,enum=blaze_query.Attribute_Tristate" json:"tristate_value,omitempty"`
	// The value of the attribute has a list of string values (label and path
	// note from STRING applies here as well).
	StringListValue []string `protobuf:"bytes,6,rep,name=string_list_value,json=stringListValue" json:"string_list_value,omitempty"`
	// If this is a license attribute, the license information is stored here.
	License *License `protobuf:"bytes,7,opt,name=license" json:"license,omitempty"`
	// If this is a string dict, each entry will be stored here.
	StringDictValue []*StringDictEntry `protobuf:"bytes,8,rep,name=string_dict_value,json=stringDictValue" json:"string_dict_value,omitempty"`
	// If the attribute is part of a Fileset, the fileset entries are stored in
	// this field.
	FilesetListValue []*FilesetEntry `protobuf:"bytes,9,rep,name=fileset_list_value,json=filesetListValue" json:"fileset_list_value,omitempty"`
	// If this is a label list dict, each entry will be stored here.
	LabelListDictValue []*LabelListDictEntry `protobuf:"bytes,10,rep,name=label_list_dict_value,json=labelListDictValue" json:"label_list_dict_value,omitempty"`
	// If this is a string list dict, each entry will be stored here.
	StringListDictValue []*StringListDictEntry `protobuf:"bytes,11,rep,name=string_list_dict_value,json=stringListDictValue" json:"string_list_dict_value,omitempty"`
	// The glob criteria. This is non-empty if:
	// 1. This attribute is a list of strings or labels, and,
	// 2. It contained a glob() expression
	GlobCriteria []*GlobCriteria `protobuf:"bytes,16,rep,name=glob_criteria,json=globCriteria" json:"glob_criteria,omitempty"`
	// The value of the attribute has a list of int32 values
	IntListValue []int32 `protobuf:"varint,17,rep,name=int_list_value,json=intListValue" json:"int_list_value,omitempty"`
	// If this is a label dict unary, each entry will be stored here.
	LabelDictUnaryValue []*LabelDictUnaryEntry `protobuf:"bytes,19,rep,name=label_dict_unary_value,json=labelDictUnaryValue" json:"label_dict_unary_value,omitempty"`
	// If this is a label-keyed string dict, each entry will be stored here.
	LabelKeyedStringDictValue []*LabelKeyedStringDictEntry `protobuf:"bytes,22,rep,name=label_keyed_string_dict_value,json=labelKeyedStringDictValue" json:"label_keyed_string_dict_value,omitempty"`
	// If this attribute's value is an expression containing one or more select
	// expressions, then its type is SELECTOR_LIST and a SelectorList will be
	// stored here.
	SelectorList                   *Attribute_SelectorList `protobuf:"bytes,21,opt,name=selector_list,json=selectorList" json:"selector_list,omitempty"`
	DEPRECATEDStringDictUnaryValue [][]byte                `protobuf:"bytes,18,rep,name=DEPRECATED_string_dict_unary_value,json=DEPRECATEDStringDictUnaryValue" json:"DEPRECATED_string_dict_unary_value,omitempty"`
	XXX_unrecognized               []byte                  `json:"-"`
}

func (m *Attribute) Reset()                    { *m = Attribute{} }
func (m *Attribute) String() string            { return proto.CompactTextString(m) }
func (*Attribute) ProtoMessage()               {}
func (*Attribute) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Attribute) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Attribute) GetDEPRECATEDParseableLocation() *Location {
	if m != nil {
		return m.DEPRECATEDParseableLocation
	}
	return nil
}

func (m *Attribute) GetExplicitlySpecified() bool {
	if m != nil && m.ExplicitlySpecified != nil {
		return *m.ExplicitlySpecified
	}
	return false
}

func (m *Attribute) GetNodep() bool {
	if m != nil && m.Nodep != nil {
		return *m.Nodep
	}
	return false
}

func (m *Attribute) GetType() Attribute_Discriminator {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Attribute_INTEGER
}

func (m *Attribute) GetIntValue() int32 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

func (m *Attribute) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *Attribute) GetBooleanValue() bool {
	if m != nil && m.BooleanValue != nil {
		return *m.BooleanValue
	}
	return false
}

func (m *Attribute) GetTristateValue() Attribute_Tristate {
	if m != nil && m.TristateValue != nil {
		return *m.TristateValue
	}
	return Attribute_NO
}

func (m *Attribute) GetStringListValue() []string {
	if m != nil {
		return m.StringListValue
	}
	return nil
}

func (m *Attribute) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *Attribute) GetStringDictValue() []*StringDictEntry {
	if m != nil {
		return m.StringDictValue
	}
	return nil
}

func (m *Attribute) GetFilesetListValue() []*FilesetEntry {
	if m != nil {
		return m.FilesetListValue
	}
	return nil
}

func (m *Attribute) GetLabelListDictValue() []*LabelListDictEntry {
	if m != nil {
		return m.LabelListDictValue
	}
	return nil
}

func (m *Attribute) GetStringListDictValue() []*StringListDictEntry {
	if m != nil {
		return m.StringListDictValue
	}
	return nil
}

func (m *Attribute) GetGlobCriteria() []*GlobCriteria {
	if m != nil {
		return m.GlobCriteria
	}
	return nil
}

func (m *Attribute) GetIntListValue() []int32 {
	if m != nil {
		return m.IntListValue
	}
	return nil
}

func (m *Attribute) GetLabelDictUnaryValue() []*LabelDictUnaryEntry {
	if m != nil {
		return m.LabelDictUnaryValue
	}
	return nil
}

func (m *Attribute) GetLabelKeyedStringDictValue() []*LabelKeyedStringDictEntry {
	if m != nil {
		return m.LabelKeyedStringDictValue
	}
	return nil
}

func (m *Attribute) GetSelectorList() *Attribute_SelectorList {
	if m != nil {
		return m.SelectorList
	}
	return nil
}

func (m *Attribute) GetDEPRECATEDStringDictUnaryValue() [][]byte {
	if m != nil {
		return m.DEPRECATEDStringDictUnaryValue
	}
	return nil
}

type Attribute_SelectorEntry struct {
	// The key of the selector entry. At this time, this is the label of a
	// config_setting rule, or the pseudo-label "//conditions:default".
	Label *string `protobuf:"bytes,1,opt,name=label" json:"label,omitempty"`
	// True if the entry's value is the default value for the type as a
	// result of the condition value being specified as None (ie:
	// {"//condition": None}).
	IsDefaultValue *bool `protobuf:"varint,16,opt,name=is_default_value,json=isDefaultValue" json:"is_default_value,omitempty"`
	// Exactly one of the following fields (except for glob_criteria) must be
	// populated - note that the BOOLEAN and TRISTATE caveat in Attribute's
	// comment does not apply here. The type field in the SelectorList
	// containing this entry indicates which of these fields is populated,
	// in accordance with the comments on Discriminator enum values above.
	// (To be explicit: BOOLEAN populates the boolean_value field and TRISTATE
	// populates the tristate_value field.)
	IntValue                       *int32                       `protobuf:"varint,2,opt,name=int_value,json=intValue" json:"int_value,omitempty"`
	StringValue                    *string                      `protobuf:"bytes,3,opt,name=string_value,json=stringValue" json:"string_value,omitempty"`
	BooleanValue                   *bool                        `protobuf:"varint,4,opt,name=boolean_value,json=booleanValue" json:"boolean_value,omitempty"`
	TristateValue                  *Attribute_Tristate          `protobuf:"varint,5,opt,name=tristate_value,json=tristateValue,enum=blaze_query.Attribute_Tristate" json:"tristate_value,omitempty"`
	StringListValue                []string                     `protobuf:"bytes,6,rep,name=string_list_value,json=stringListValue" json:"string_list_value,omitempty"`
	License                        *License                     `protobuf:"bytes,7,opt,name=license" json:"license,omitempty"`
	StringDictValue                []*StringDictEntry           `protobuf:"bytes,8,rep,name=string_dict_value,json=stringDictValue" json:"string_dict_value,omitempty"`
	FilesetListValue               []*FilesetEntry              `protobuf:"bytes,9,rep,name=fileset_list_value,json=filesetListValue" json:"fileset_list_value,omitempty"`
	LabelListDictValue             []*LabelListDictEntry        `protobuf:"bytes,10,rep,name=label_list_dict_value,json=labelListDictValue" json:"label_list_dict_value,omitempty"`
	StringListDictValue            []*StringListDictEntry       `protobuf:"bytes,11,rep,name=string_list_dict_value,json=stringListDictValue" json:"string_list_dict_value,omitempty"`
	GlobCriteria                   []*GlobCriteria              `protobuf:"bytes,12,rep,name=glob_criteria,json=globCriteria" json:"glob_criteria,omitempty"`
	IntListValue                   []int32                      `protobuf:"varint,13,rep,name=int_list_value,json=intListValue" json:"int_list_value,omitempty"`
	LabelDictUnaryValue            []*LabelDictUnaryEntry       `protobuf:"bytes,15,rep,name=label_dict_unary_value,json=labelDictUnaryValue" json:"label_dict_unary_value,omitempty"`
	LabelKeyedStringDictValue      []*LabelKeyedStringDictEntry `protobuf:"bytes,17,rep,name=label_keyed_string_dict_value,json=labelKeyedStringDictValue" json:"label_keyed_string_dict_value,omitempty"`
	DEPRECATEDStringDictUnaryValue [][]byte                     `protobuf:"bytes,14,rep,name=DEPRECATED_string_dict_unary_value,json=DEPRECATEDStringDictUnaryValue" json:"DEPRECATED_string_dict_unary_value,omitempty"`
	XXX_unrecognized               []byte                       `json:"-"`
}

func (m *Attribute_SelectorEntry) Reset()                    { *m = Attribute_SelectorEntry{} }
func (m *Attribute_SelectorEntry) String() string            { return proto.CompactTextString(m) }
func (*Attribute_SelectorEntry) ProtoMessage()               {}
func (*Attribute_SelectorEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 0} }

func (m *Attribute_SelectorEntry) GetLabel() string {
	if m != nil && m.Label != nil {
		return *m.Label
	}
	return ""
}

func (m *Attribute_SelectorEntry) GetIsDefaultValue() bool {
	if m != nil && m.IsDefaultValue != nil {
		return *m.IsDefaultValue
	}
	return false
}

func (m *Attribute_SelectorEntry) GetIntValue() int32 {
	if m != nil && m.IntValue != nil {
		return *m.IntValue
	}
	return 0
}

func (m *Attribute_SelectorEntry) GetStringValue() string {
	if m != nil && m.StringValue != nil {
		return *m.StringValue
	}
	return ""
}

func (m *Attribute_SelectorEntry) GetBooleanValue() bool {
	if m != nil && m.BooleanValue != nil {
		return *m.BooleanValue
	}
	return false
}

func (m *Attribute_SelectorEntry) GetTristateValue() Attribute_Tristate {
	if m != nil && m.TristateValue != nil {
		return *m.TristateValue
	}
	return Attribute_NO
}

func (m *Attribute_SelectorEntry) GetStringListValue() []string {
	if m != nil {
		return m.StringListValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetStringDictValue() []*StringDictEntry {
	if m != nil {
		return m.StringDictValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetFilesetListValue() []*FilesetEntry {
	if m != nil {
		return m.FilesetListValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetLabelListDictValue() []*LabelListDictEntry {
	if m != nil {
		return m.LabelListDictValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetStringListDictValue() []*StringListDictEntry {
	if m != nil {
		return m.StringListDictValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetGlobCriteria() []*GlobCriteria {
	if m != nil {
		return m.GlobCriteria
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetIntListValue() []int32 {
	if m != nil {
		return m.IntListValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetLabelDictUnaryValue() []*LabelDictUnaryEntry {
	if m != nil {
		return m.LabelDictUnaryValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetLabelKeyedStringDictValue() []*LabelKeyedStringDictEntry {
	if m != nil {
		return m.LabelKeyedStringDictValue
	}
	return nil
}

func (m *Attribute_SelectorEntry) GetDEPRECATEDStringDictUnaryValue() [][]byte {
	if m != nil {
		return m.DEPRECATEDStringDictUnaryValue
	}
	return nil
}

type Attribute_Selector struct {
	// The list of (label, value) pairs in the map that defines the selector.
	// At this time, this cannot be empty, i.e. a selector has at least one
	// entry.
	Entries []*Attribute_SelectorEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	// Whether or not this has any default values.
	HasDefaultValue *bool `protobuf:"varint,2,opt,name=has_default_value,json=hasDefaultValue" json:"has_default_value,omitempty"`
	// The error message when no condition matches.
	NoMatchError     *string `protobuf:"bytes,3,opt,name=no_match_error,json=noMatchError" json:"no_match_error,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Attribute_Selector) Reset()                    { *m = Attribute_Selector{} }
func (m *Attribute_Selector) String() string            { return proto.CompactTextString(m) }
func (*Attribute_Selector) ProtoMessage()               {}
func (*Attribute_Selector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 1} }

func (m *Attribute_Selector) GetEntries() []*Attribute_SelectorEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

func (m *Attribute_Selector) GetHasDefaultValue() bool {
	if m != nil && m.HasDefaultValue != nil {
		return *m.HasDefaultValue
	}
	return false
}

func (m *Attribute_Selector) GetNoMatchError() string {
	if m != nil && m.NoMatchError != nil {
		return *m.NoMatchError
	}
	return ""
}

type Attribute_SelectorList struct {
	// The type that this selector list evaluates to, and the type that each
	// selector in the list evaluates to. At this time, this cannot be
	// SELECTOR_LIST, i.e. selector lists do not nest.
	Type *Attribute_Discriminator `protobuf:"varint,1,opt,name=type,enum=blaze_query.Attribute_Discriminator" json:"type,omitempty"`
	// The list of selector elements in this selector list. At this time, this
	// cannot be empty, i.e. a selector list is never empty.
	Elements         []*Attribute_Selector `protobuf:"bytes,2,rep,name=elements" json:"elements,omitempty"`
	XXX_unrecognized []byte                `json:"-"`
}

func (m *Attribute_SelectorList) Reset()                    { *m = Attribute_SelectorList{} }
func (m *Attribute_SelectorList) String() string            { return proto.CompactTextString(m) }
func (*Attribute_SelectorList) ProtoMessage()               {}
func (*Attribute_SelectorList) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7, 2} }

func (m *Attribute_SelectorList) GetType() Attribute_Discriminator {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Attribute_INTEGER
}

func (m *Attribute_SelectorList) GetElements() []*Attribute_Selector {
	if m != nil {
		return m.Elements
	}
	return nil
}

// A rule from a BUILD file (e.g., cc_library, java_binary).  The rule class
// is the actual name of the rule (e.g., cc_library) and the name is the full
// label of the rule (e.g., //foo/bar:baz).
type Rule struct {
	// The name of the rule
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The rule class (e.g., java_library)
	RuleClass *string `protobuf:"bytes,2,req,name=rule_class,json=ruleClass" json:"rule_class,omitempty"`
	// The BUILD file and line number of the rule.
	Location *string `protobuf:"bytes,3,opt,name=location" json:"location,omitempty"`
	// All of the attributes that describe the rule.
	Attribute []*Attribute `protobuf:"bytes,4,rep,name=attribute" json:"attribute,omitempty"`
	// All of the inputs to the rule.  These are predecessors in the dependency
	// graph.  A rule_input for a rule should always be described as a
	// source_file in some package (either the rule's package or some other one).
	RuleInput []string `protobuf:"bytes,5,rep,name=rule_input,json=ruleInput" json:"rule_input,omitempty"`
	// All of the outputs of the rule.  These are the successors in the
	// dependency graph.
	RuleOutput []string `protobuf:"bytes,6,rep,name=rule_output,json=ruleOutput" json:"rule_output,omitempty"`
	// The set of all default settings affecting this rule. The name of a default
	// setting is "<setting type>_<setting name>". There currently defined setting
	// types are:
	//
	// - 'blaze': settings implemented in Blaze itself
	DefaultSetting []string `protobuf:"bytes,7,rep,name=default_setting,json=defaultSetting" json:"default_setting,omitempty"`
	// The location of the target in the BUILD file in a machine-parseable form.
	DEPRECATEDParseableLocation *Location `protobuf:"bytes,8,opt,name=DEPRECATED_parseable_location,json=DEPRECATEDParseableLocation" json:"DEPRECATED_parseable_location,omitempty"`
	// The rule's class's public by default value.
	PublicByDefault *bool `protobuf:"varint,9,opt,name=public_by_default,json=publicByDefault" json:"public_by_default,omitempty"`
	// If this rule is of a skylark-defined RuleClass.
	IsSkylark *bool `protobuf:"varint,10,opt,name=is_skylark,json=isSkylark" json:"is_skylark,omitempty"`
	// List of Skylark aspects that this rule applies.
	SkylarkAttributeAspects []*AttributeAspect `protobuf:"bytes,11,rep,name=skylark_attribute_aspects,json=skylarkAttributeAspects" json:"skylark_attribute_aspects,omitempty"`
	// Hash encapsulating the behavior of this Skylark rule. Any change to this
	// rule's definition that could change its behavior will be reflected here.
	SkylarkEnvironmentHashCode *string `protobuf:"bytes,12,opt,name=skylark_environment_hash_code,json=skylarkEnvironmentHashCode" json:"skylark_environment_hash_code,omitempty"`
	XXX_unrecognized           []byte  `json:"-"`
}

func (m *Rule) Reset()                    { *m = Rule{} }
func (m *Rule) String() string            { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()               {}
func (*Rule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Rule) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *Rule) GetRuleClass() string {
	if m != nil && m.RuleClass != nil {
		return *m.RuleClass
	}
	return ""
}

func (m *Rule) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

func (m *Rule) GetAttribute() []*Attribute {
	if m != nil {
		return m.Attribute
	}
	return nil
}

func (m *Rule) GetRuleInput() []string {
	if m != nil {
		return m.RuleInput
	}
	return nil
}

func (m *Rule) GetRuleOutput() []string {
	if m != nil {
		return m.RuleOutput
	}
	return nil
}

func (m *Rule) GetDefaultSetting() []string {
	if m != nil {
		return m.DefaultSetting
	}
	return nil
}

func (m *Rule) GetDEPRECATEDParseableLocation() *Location {
	if m != nil {
		return m.DEPRECATEDParseableLocation
	}
	return nil
}

func (m *Rule) GetPublicByDefault() bool {
	if m != nil && m.PublicByDefault != nil {
		return *m.PublicByDefault
	}
	return false
}

func (m *Rule) GetIsSkylark() bool {
	if m != nil && m.IsSkylark != nil {
		return *m.IsSkylark
	}
	return false
}

func (m *Rule) GetSkylarkAttributeAspects() []*AttributeAspect {
	if m != nil {
		return m.SkylarkAttributeAspects
	}
	return nil
}

func (m *Rule) GetSkylarkEnvironmentHashCode() string {
	if m != nil && m.SkylarkEnvironmentHashCode != nil {
		return *m.SkylarkEnvironmentHashCode
	}
	return ""
}

// A pairing of attribute name and a Skylark aspect that is applied to that attribute.
type AttributeAspect struct {
	AttributeName    *string        `protobuf:"bytes,1,req,name=attribute_name,json=attributeName" json:"attribute_name,omitempty"`
	Aspect           *SkylarkAspect `protobuf:"bytes,2,req,name=aspect" json:"aspect,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *AttributeAspect) Reset()                    { *m = AttributeAspect{} }
func (m *AttributeAspect) String() string            { return proto.CompactTextString(m) }
func (*AttributeAspect) ProtoMessage()               {}
func (*AttributeAspect) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *AttributeAspect) GetAttributeName() string {
	if m != nil && m.AttributeName != nil {
		return *m.AttributeName
	}
	return ""
}

func (m *AttributeAspect) GetAspect() *SkylarkAspect {
	if m != nil {
		return m.Aspect
	}
	return nil
}

// Aspect defined in Skylark.
type SkylarkAspect struct {
	ExtensionFileLabel *string      `protobuf:"bytes,1,req,name=extension_file_label,json=extensionFileLabel" json:"extension_file_label,omitempty"`
	ExportedName       *string      `protobuf:"bytes,2,req,name=exported_name,json=exportedName" json:"exported_name,omitempty"`
	Attribute          []*Attribute `protobuf:"bytes,3,rep,name=attribute" json:"attribute,omitempty"`
	XXX_unrecognized   []byte       `json:"-"`
}

func (m *SkylarkAspect) Reset()                    { *m = SkylarkAspect{} }
func (m *SkylarkAspect) String() string            { return proto.CompactTextString(m) }
func (*SkylarkAspect) ProtoMessage()               {}
func (*SkylarkAspect) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SkylarkAspect) GetExtensionFileLabel() string {
	if m != nil && m.ExtensionFileLabel != nil {
		return *m.ExtensionFileLabel
	}
	return ""
}

func (m *SkylarkAspect) GetExportedName() string {
	if m != nil && m.ExportedName != nil {
		return *m.ExportedName
	}
	return ""
}

func (m *SkylarkAspect) GetAttribute() []*Attribute {
	if m != nil {
		return m.Attribute
	}
	return nil
}

// Summary of all transitive dependencies of 'rule,' where each dependent
// rule is included only once in the 'dependency' field.  Gives complete
// information to analyze the single build target labeled rule.name,
// including optional location of target in BUILD file.
type RuleSummary struct {
	Rule             *Rule   `protobuf:"bytes,1,req,name=rule" json:"rule,omitempty"`
	Dependency       []*Rule `protobuf:"bytes,2,rep,name=dependency" json:"dependency,omitempty"`
	Location         *string `protobuf:"bytes,3,opt,name=location" json:"location,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RuleSummary) Reset()                    { *m = RuleSummary{} }
func (m *RuleSummary) String() string            { return proto.CompactTextString(m) }
func (*RuleSummary) ProtoMessage()               {}
func (*RuleSummary) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *RuleSummary) GetRule() *Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *RuleSummary) GetDependency() []*Rule {
	if m != nil {
		return m.Dependency
	}
	return nil
}

func (m *RuleSummary) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

// A package group. Aside from the name, it contains the list of packages
// present in the group (as specified in the BUILD file).
type PackageGroup struct {
	// The name of the package group
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The list of packages as specified in the BUILD file. Currently this is
	// only a list of packages, but some time in the future, there might be
	// some type of wildcard mechanism.
	ContainedPackage []string `protobuf:"bytes,2,rep,name=contained_package,json=containedPackage" json:"contained_package,omitempty"`
	// The list of sub package groups included in this one.
	IncludedPackageGroup []string `protobuf:"bytes,3,rep,name=included_package_group,json=includedPackageGroup" json:"included_package_group,omitempty"`
	// The location of the target in the BUILD file in a machine-parseable form.
	DEPRECATEDParseableLocation *Location `protobuf:"bytes,4,opt,name=DEPRECATED_parseable_location,json=DEPRECATEDParseableLocation" json:"DEPRECATED_parseable_location,omitempty"`
	XXX_unrecognized            []byte    `json:"-"`
}

func (m *PackageGroup) Reset()                    { *m = PackageGroup{} }
func (m *PackageGroup) String() string            { return proto.CompactTextString(m) }
func (*PackageGroup) ProtoMessage()               {}
func (*PackageGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *PackageGroup) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PackageGroup) GetContainedPackage() []string {
	if m != nil {
		return m.ContainedPackage
	}
	return nil
}

func (m *PackageGroup) GetIncludedPackageGroup() []string {
	if m != nil {
		return m.IncludedPackageGroup
	}
	return nil
}

func (m *PackageGroup) GetDEPRECATEDParseableLocation() *Location {
	if m != nil {
		return m.DEPRECATEDParseableLocation
	}
	return nil
}

// An environment group.
type EnvironmentGroup struct {
	// The name of the environment group.
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The environments that belong to this group (as labels).
	Environment []string `protobuf:"bytes,2,rep,name=environment" json:"environment,omitempty"`
	// The member environments that rules implicitly support if not otherwise
	// specified.
	Default          []string `protobuf:"bytes,3,rep,name=default" json:"default,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *EnvironmentGroup) Reset()                    { *m = EnvironmentGroup{} }
func (m *EnvironmentGroup) String() string            { return proto.CompactTextString(m) }
func (*EnvironmentGroup) ProtoMessage()               {}
func (*EnvironmentGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *EnvironmentGroup) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *EnvironmentGroup) GetEnvironment() []string {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *EnvironmentGroup) GetDefault() []string {
	if m != nil {
		return m.Default
	}
	return nil
}

// A file that is an input into the build system.
// Next-Id: 10
type SourceFile struct {
	// The name of the source file (a label).
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The location of the source file.  This is a path with line numbers, not
	// a label in the build system.
	Location *string `protobuf:"bytes,2,opt,name=location" json:"location,omitempty"`
	// The location of the corresponding label in the BUILD file in a
	// machine-parseable form.
	DEPRECATEDParseableLocation *Location `protobuf:"bytes,7,opt,name=DEPRECATED_parseable_location,json=DEPRECATEDParseableLocation" json:"DEPRECATED_parseable_location,omitempty"`
	// Labels of files that are transitively subincluded in this BUILD file. This
	// is present only when the SourceFile represents a BUILD file that
	// subincludes other files. The subincluded file can be either a Python
	// preprocessed build extension or a Skylark file.
	Subinclude []string `protobuf:"bytes,3,rep,name=subinclude" json:"subinclude,omitempty"`
	// Labels of package groups that are mentioned in the visibility declaration
	// for this source file.
	PackageGroup []string `protobuf:"bytes,4,rep,name=package_group,json=packageGroup" json:"package_group,omitempty"`
	// Labels mentioned in the visibility declaration (including :__pkg__ and
	// //visibility: ones)
	VisibilityLabel []string `protobuf:"bytes,5,rep,name=visibility_label,json=visibilityLabel" json:"visibility_label,omitempty"`
	// The package-level features enabled for this package. Only present if the
	// SourceFile represents a BUILD file.
	Feature []string `protobuf:"bytes,6,rep,name=feature" json:"feature,omitempty"`
	// License attribute for the file.
	License *License `protobuf:"bytes,8,opt,name=license" json:"license,omitempty"`
	// True if the package contains an error. Only present if the SourceFile
	// represents a BUILD file.
	PackageContainsErrors *bool  `protobuf:"varint,9,opt,name=package_contains_errors,json=packageContainsErrors" json:"package_contains_errors,omitempty"`
	XXX_unrecognized      []byte `json:"-"`
}

func (m *SourceFile) Reset()                    { *m = SourceFile{} }
func (m *SourceFile) String() string            { return proto.CompactTextString(m) }
func (*SourceFile) ProtoMessage()               {}
func (*SourceFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *SourceFile) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *SourceFile) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

func (m *SourceFile) GetDEPRECATEDParseableLocation() *Location {
	if m != nil {
		return m.DEPRECATEDParseableLocation
	}
	return nil
}

func (m *SourceFile) GetSubinclude() []string {
	if m != nil {
		return m.Subinclude
	}
	return nil
}

func (m *SourceFile) GetPackageGroup() []string {
	if m != nil {
		return m.PackageGroup
	}
	return nil
}

func (m *SourceFile) GetVisibilityLabel() []string {
	if m != nil {
		return m.VisibilityLabel
	}
	return nil
}

func (m *SourceFile) GetFeature() []string {
	if m != nil {
		return m.Feature
	}
	return nil
}

func (m *SourceFile) GetLicense() *License {
	if m != nil {
		return m.License
	}
	return nil
}

func (m *SourceFile) GetPackageContainsErrors() bool {
	if m != nil && m.PackageContainsErrors != nil {
		return *m.PackageContainsErrors
	}
	return false
}

// A file that is the output of a build rule.
type GeneratedFile struct {
	// The name of the generated file (a label).
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// The label of the target that generates the file.
	GeneratingRule *string `protobuf:"bytes,2,req,name=generating_rule,json=generatingRule" json:"generating_rule,omitempty"`
	// The path of the output file (not a label).
	Location         *string `protobuf:"bytes,3,opt,name=location" json:"location,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GeneratedFile) Reset()                    { *m = GeneratedFile{} }
func (m *GeneratedFile) String() string            { return proto.CompactTextString(m) }
func (*GeneratedFile) ProtoMessage()               {}
func (*GeneratedFile) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GeneratedFile) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *GeneratedFile) GetGeneratingRule() string {
	if m != nil && m.GeneratingRule != nil {
		return *m.GeneratingRule
	}
	return ""
}

func (m *GeneratedFile) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

// A target from a blaze query execution.  Similar to the Attribute message,
// the Discriminator is used to determine which field contains information.
// For any given type, only one of these can be populated in a single Target.
type Target struct {
	// The type of target contained in the message.
	Type *Target_Discriminator `protobuf:"varint,1,req,name=type,enum=blaze_query.Target_Discriminator" json:"type,omitempty"`
	// If this target represents a rule, the rule is stored here.
	Rule *Rule `protobuf:"bytes,2,opt,name=rule" json:"rule,omitempty"`
	// A file that is not generated by the build system (version controlled
	// or created by the test harness).
	SourceFile *SourceFile `protobuf:"bytes,3,opt,name=source_file,json=sourceFile" json:"source_file,omitempty"`
	// A generated file that is the output of a rule.
	GeneratedFile *GeneratedFile `protobuf:"bytes,4,opt,name=generated_file,json=generatedFile" json:"generated_file,omitempty"`
	// A package group.
	PackageGroup *PackageGroup `protobuf:"bytes,5,opt,name=package_group,json=packageGroup" json:"package_group,omitempty"`
	// An environment group.
	EnvironmentGroup *EnvironmentGroup `protobuf:"bytes,6,opt,name=environment_group,json=environmentGroup" json:"environment_group,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *Target) Reset()                    { *m = Target{} }
func (m *Target) String() string            { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()               {}
func (*Target) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *Target) GetType() Target_Discriminator {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Target_RULE
}

func (m *Target) GetRule() *Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *Target) GetSourceFile() *SourceFile {
	if m != nil {
		return m.SourceFile
	}
	return nil
}

func (m *Target) GetGeneratedFile() *GeneratedFile {
	if m != nil {
		return m.GeneratedFile
	}
	return nil
}

func (m *Target) GetPackageGroup() *PackageGroup {
	if m != nil {
		return m.PackageGroup
	}
	return nil
}

func (m *Target) GetEnvironmentGroup() *EnvironmentGroup {
	if m != nil {
		return m.EnvironmentGroup
	}
	return nil
}

// Container for all of the blaze query results.
type QueryResult struct {
	// All of the targets returned by the blaze query.
	Target           []*Target `protobuf:"bytes,1,rep,name=target" json:"target,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *QueryResult) Reset()                    { *m = QueryResult{} }
func (m *QueryResult) String() string            { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()               {}
func (*QueryResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *QueryResult) GetTarget() []*Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// Information about allowed rule classes for a specific attribute of a rule.
type AllowedRuleClassInfo struct {
	Policy *AllowedRuleClassInfo_AllowedRuleClasses `protobuf:"varint,1,req,name=policy,enum=blaze_query.AllowedRuleClassInfo_AllowedRuleClasses" json:"policy,omitempty"`
	// Rule class names of rules allowed in this attribute, e.g "cc_library",
	// "py_binary". Only present if the allowed_rule_classes field is set to
	// SPECIFIED.
	AllowedRuleClass []string `protobuf:"bytes,2,rep,name=allowed_rule_class,json=allowedRuleClass" json:"allowed_rule_class,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *AllowedRuleClassInfo) Reset()                    { *m = AllowedRuleClassInfo{} }
func (m *AllowedRuleClassInfo) String() string            { return proto.CompactTextString(m) }
func (*AllowedRuleClassInfo) ProtoMessage()               {}
func (*AllowedRuleClassInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *AllowedRuleClassInfo) GetPolicy() AllowedRuleClassInfo_AllowedRuleClasses {
	if m != nil && m.Policy != nil {
		return *m.Policy
	}
	return AllowedRuleClassInfo_ANY
}

func (m *AllowedRuleClassInfo) GetAllowedRuleClass() []string {
	if m != nil {
		return m.AllowedRuleClass
	}
	return nil
}

// This message represents a single attribute of a single rule.
type AttributeDefinition struct {
	// Attribute name, i.e. "name", "srcs", "deps"
	Name      *string                  `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type      *Attribute_Discriminator `protobuf:"varint,2,req,name=type,enum=blaze_query.Attribute_Discriminator" json:"type,omitempty"`
	Mandatory *bool                    `protobuf:"varint,3,req,name=mandatory" json:"mandatory,omitempty"`
	// Only present for attributes of type LABEL and LABEL_LIST.
	AllowedRuleClasses *AllowedRuleClassInfo `protobuf:"bytes,4,opt,name=allowed_rule_classes,json=allowedRuleClasses" json:"allowed_rule_classes,omitempty"`
	Documentation      *string               `protobuf:"bytes,5,opt,name=documentation" json:"documentation,omitempty"`
	XXX_unrecognized   []byte                `json:"-"`
}

func (m *AttributeDefinition) Reset()                    { *m = AttributeDefinition{} }
func (m *AttributeDefinition) String() string            { return proto.CompactTextString(m) }
func (*AttributeDefinition) ProtoMessage()               {}
func (*AttributeDefinition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *AttributeDefinition) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *AttributeDefinition) GetType() Attribute_Discriminator {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return Attribute_INTEGER
}

func (m *AttributeDefinition) GetMandatory() bool {
	if m != nil && m.Mandatory != nil {
		return *m.Mandatory
	}
	return false
}

func (m *AttributeDefinition) GetAllowedRuleClasses() *AllowedRuleClassInfo {
	if m != nil {
		return m.AllowedRuleClasses
	}
	return nil
}

func (m *AttributeDefinition) GetDocumentation() string {
	if m != nil && m.Documentation != nil {
		return *m.Documentation
	}
	return ""
}

type RuleDefinition struct {
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Only contains documented attributes
	Attribute     []*AttributeDefinition `protobuf:"bytes,2,rep,name=attribute" json:"attribute,omitempty"`
	Documentation *string                `protobuf:"bytes,3,opt,name=documentation" json:"documentation,omitempty"`
	// Only for build extensions: label to file that defines the extension
	Label            *string `protobuf:"bytes,4,opt,name=label" json:"label,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RuleDefinition) Reset()                    { *m = RuleDefinition{} }
func (m *RuleDefinition) String() string            { return proto.CompactTextString(m) }
func (*RuleDefinition) ProtoMessage()               {}
func (*RuleDefinition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *RuleDefinition) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *RuleDefinition) GetAttribute() []*AttributeDefinition {
	if m != nil {
		return m.Attribute
	}
	return nil
}

func (m *RuleDefinition) GetDocumentation() string {
	if m != nil && m.Documentation != nil {
		return *m.Documentation
	}
	return ""
}

func (m *RuleDefinition) GetLabel() string {
	if m != nil && m.Label != nil {
		return *m.Label
	}
	return ""
}

type BuildLanguage struct {
	// Only contains documented rule definitions
	Rule             []*RuleDefinition `protobuf:"bytes,1,rep,name=rule" json:"rule,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *BuildLanguage) Reset()                    { *m = BuildLanguage{} }
func (m *BuildLanguage) String() string            { return proto.CompactTextString(m) }
func (*BuildLanguage) ProtoMessage()               {}
func (*BuildLanguage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *BuildLanguage) GetRule() []*RuleDefinition {
	if m != nil {
		return m.Rule
	}
	return nil
}

type Location struct {
	StartOffset      *int32 `protobuf:"varint,1,opt,name=start_offset,json=startOffset" json:"start_offset,omitempty"`
	StartLine        *int32 `protobuf:"varint,2,opt,name=start_line,json=startLine" json:"start_line,omitempty"`
	StartColumn      *int32 `protobuf:"varint,3,opt,name=start_column,json=startColumn" json:"start_column,omitempty"`
	EndOffset        *int32 `protobuf:"varint,4,opt,name=end_offset,json=endOffset" json:"end_offset,omitempty"`
	EndLine          *int32 `protobuf:"varint,5,opt,name=end_line,json=endLine" json:"end_line,omitempty"`
	EndColumn        *int32 `protobuf:"varint,6,opt,name=end_column,json=endColumn" json:"end_column,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Location) Reset()                    { *m = Location{} }
func (m *Location) String() string            { return proto.CompactTextString(m) }
func (*Location) ProtoMessage()               {}
func (*Location) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *Location) GetStartOffset() int32 {
	if m != nil && m.StartOffset != nil {
		return *m.StartOffset
	}
	return 0
}

func (m *Location) GetStartLine() int32 {
	if m != nil && m.StartLine != nil {
		return *m.StartLine
	}
	return 0
}

func (m *Location) GetStartColumn() int32 {
	if m != nil && m.StartColumn != nil {
		return *m.StartColumn
	}
	return 0
}

func (m *Location) GetEndOffset() int32 {
	if m != nil && m.EndOffset != nil {
		return *m.EndOffset
	}
	return 0
}

func (m *Location) GetEndLine() int32 {
	if m != nil && m.EndLine != nil {
		return *m.EndLine
	}
	return 0
}

func (m *Location) GetEndColumn() int32 {
	if m != nil && m.EndColumn != nil {
		return *m.EndColumn
	}
	return 0
}

type MakeVarBinding struct {
	Value             *string `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	PlatformSetRegexp *string `protobuf:"bytes,2,req,name=platform_set_regexp,json=platformSetRegexp" json:"platform_set_regexp,omitempty"`
	XXX_unrecognized  []byte  `json:"-"`
}

func (m *MakeVarBinding) Reset()                    { *m = MakeVarBinding{} }
func (m *MakeVarBinding) String() string            { return proto.CompactTextString(m) }
func (*MakeVarBinding) ProtoMessage()               {}
func (*MakeVarBinding) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *MakeVarBinding) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

func (m *MakeVarBinding) GetPlatformSetRegexp() string {
	if m != nil && m.PlatformSetRegexp != nil {
		return *m.PlatformSetRegexp
	}
	return ""
}

type MakeVar struct {
	Name             *string           `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Binding          []*MakeVarBinding `protobuf:"bytes,2,rep,name=binding" json:"binding,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *MakeVar) Reset()                    { *m = MakeVar{} }
func (m *MakeVar) String() string            { return proto.CompactTextString(m) }
func (*MakeVar) ProtoMessage()               {}
func (*MakeVar) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *MakeVar) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *MakeVar) GetBinding() []*MakeVarBinding {
	if m != nil {
		return m.Binding
	}
	return nil
}

type GlobCriteria struct {
	// List of includes (or items if this criteria did not come from a glob)
	Include []string `protobuf:"bytes,1,rep,name=include" json:"include,omitempty"`
	// List of exclude expressions
	Exclude []string `protobuf:"bytes,2,rep,name=exclude" json:"exclude,omitempty"`
	// Whether this message came from a glob
	Glob             *bool  `protobuf:"varint,3,opt,name=glob" json:"glob,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *GlobCriteria) Reset()                    { *m = GlobCriteria{} }
func (m *GlobCriteria) String() string            { return proto.CompactTextString(m) }
func (*GlobCriteria) ProtoMessage()               {}
func (*GlobCriteria) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *GlobCriteria) GetInclude() []string {
	if m != nil {
		return m.Include
	}
	return nil
}

func (m *GlobCriteria) GetExclude() []string {
	if m != nil {
		return m.Exclude
	}
	return nil
}

func (m *GlobCriteria) GetGlob() bool {
	if m != nil && m.Glob != nil {
		return *m.Glob
	}
	return false
}

type Event struct {
	Kind               *Event_EventKind `protobuf:"varint,1,req,name=kind,enum=blaze_query.Event_EventKind" json:"kind,omitempty"`
	DEPRECATEDLocation *Location        `protobuf:"bytes,2,opt,name=DEPRECATED_location,json=DEPRECATEDLocation" json:"DEPRECATED_location,omitempty"`
	Message            *string          `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized   []byte           `json:"-"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *Event) GetKind() Event_EventKind {
	if m != nil && m.Kind != nil {
		return *m.Kind
	}
	return Event_ERROR
}

func (m *Event) GetDEPRECATEDLocation() *Location {
	if m != nil {
		return m.DEPRECATEDLocation
	}
	return nil
}

func (m *Event) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func init() {
	proto.RegisterType((*License)(nil), "blaze_query.License")
	proto.RegisterType((*StringDictEntry)(nil), "blaze_query.StringDictEntry")
	proto.RegisterType((*LabelDictUnaryEntry)(nil), "blaze_query.LabelDictUnaryEntry")
	proto.RegisterType((*LabelListDictEntry)(nil), "blaze_query.LabelListDictEntry")
	proto.RegisterType((*LabelKeyedStringDictEntry)(nil), "blaze_query.LabelKeyedStringDictEntry")
	proto.RegisterType((*StringListDictEntry)(nil), "blaze_query.StringListDictEntry")
	proto.RegisterType((*FilesetEntry)(nil), "blaze_query.FilesetEntry")
	proto.RegisterType((*Attribute)(nil), "blaze_query.Attribute")
	proto.RegisterType((*Attribute_SelectorEntry)(nil), "blaze_query.Attribute.SelectorEntry")
	proto.RegisterType((*Attribute_Selector)(nil), "blaze_query.Attribute.Selector")
	proto.RegisterType((*Attribute_SelectorList)(nil), "blaze_query.Attribute.SelectorList")
	proto.RegisterType((*Rule)(nil), "blaze_query.Rule")
	proto.RegisterType((*AttributeAspect)(nil), "blaze_query.AttributeAspect")
	proto.RegisterType((*SkylarkAspect)(nil), "blaze_query.SkylarkAspect")
	proto.RegisterType((*RuleSummary)(nil), "blaze_query.RuleSummary")
	proto.RegisterType((*PackageGroup)(nil), "blaze_query.PackageGroup")
	proto.RegisterType((*EnvironmentGroup)(nil), "blaze_query.EnvironmentGroup")
	proto.RegisterType((*SourceFile)(nil), "blaze_query.SourceFile")
	proto.RegisterType((*GeneratedFile)(nil), "blaze_query.GeneratedFile")
	proto.RegisterType((*Target)(nil), "blaze_query.Target")
	proto.RegisterType((*QueryResult)(nil), "blaze_query.QueryResult")
	proto.RegisterType((*AllowedRuleClassInfo)(nil), "blaze_query.AllowedRuleClassInfo")
	proto.RegisterType((*AttributeDefinition)(nil), "blaze_query.AttributeDefinition")
	proto.RegisterType((*RuleDefinition)(nil), "blaze_query.RuleDefinition")
	proto.RegisterType((*BuildLanguage)(nil), "blaze_query.BuildLanguage")
	proto.RegisterType((*Location)(nil), "blaze_query.Location")
	proto.RegisterType((*MakeVarBinding)(nil), "blaze_query.MakeVarBinding")
	proto.RegisterType((*MakeVar)(nil), "blaze_query.MakeVar")
	proto.RegisterType((*GlobCriteria)(nil), "blaze_query.GlobCriteria")
	proto.RegisterType((*Event)(nil), "blaze_query.Event")
	proto.RegisterEnum("blaze_query.FilesetEntry_SymlinkBehavior", FilesetEntry_SymlinkBehavior_name, FilesetEntry_SymlinkBehavior_value)
	proto.RegisterEnum("blaze_query.Attribute_Discriminator", Attribute_Discriminator_name, Attribute_Discriminator_value)
	proto.RegisterEnum("blaze_query.Attribute_Tristate", Attribute_Tristate_name, Attribute_Tristate_value)
	proto.RegisterEnum("blaze_query.Target_Discriminator", Target_Discriminator_name, Target_Discriminator_value)
	proto.RegisterEnum("blaze_query.AllowedRuleClassInfo_AllowedRuleClasses", AllowedRuleClassInfo_AllowedRuleClasses_name, AllowedRuleClassInfo_AllowedRuleClasses_value)
	proto.RegisterEnum("blaze_query.Event_EventKind", Event_EventKind_name, Event_EventKind_value)
}

func init() { proto.RegisterFile("build_proto/build.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2621 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0x49, 0x73, 0xeb, 0xc6,
	0xf1, 0xff, 0x83, 0x3b, 0x9b, 0x1b, 0x34, 0xda, 0xf8, 0x36, 0x9b, 0x86, 0x9f, 0xff, 0xa6, 0x97,
	0x92, 0x6d, 0xe6, 0xd9, 0xe5, 0xd8, 0xc9, 0xab, 0x50, 0x24, 0x24, 0xd3, 0x8f, 0x26, 0x95, 0x21,
	0xf9, 0x1c, 0xe5, 0x82, 0x02, 0x89, 0x11, 0x35, 0x25, 0x10, 0x60, 0x00, 0x50, 0x11, 0x73, 0x4d,
	0xe5, 0xe0, 0x7c, 0x06, 0x1f, 0xf2, 0x2d, 0x72, 0xcd, 0x31, 0x1f, 0x21, 0xa9, 0x5c, 0x72, 0xcc,
	0x87, 0xc8, 0x21, 0x35, 0x0b, 0x48, 0x40, 0xa2, 0x2c, 0xf9, 0x39, 0xb9, 0xa4, 0x72, 0x61, 0x71,
	0x7a, 0xf9, 0x4d, 0xf7, 0x4c, 0x77, 0x4f, 0xcf, 0x00, 0xf6, 0xc7, 0x0b, 0x6a, 0x5b, 0xc6, 0xdc,
	0x73, 0x03, 0xf7, 0x03, 0xfe, 0xff, 0x80, 0xff, 0x47, 0x85, 0xb1, 0x6d, 0xfe, 0x86, 0x18, 0xbf,
	0x5a, 0x10, 0x6f, 0xa9, 0x7d, 0x09, 0xd9, 0x2e, 0x9d, 0x10, 0xc7, 0x27, 0xe8, 0x0d, 0x28, 0xda,
	0xe2, 0xaf, 0x11, 0x2c, 0xe7, 0xa4, 0xaa, 0xd4, 0x92, 0xf5, 0x3c, 0x2e, 0x48, 0xda, 0x70, 0x39,
	0x27, 0xe8, 0x31, 0xe4, 0xc9, 0xd5, 0x84, 0xcc, 0x03, 0xea, 0x3a, 0xd5, 0x04, 0xe7, 0xaf, 0x09,
	0xda, 0x8f, 0xa1, 0x32, 0x08, 0x3c, 0xea, 0x4c, 0xdb, 0x74, 0x12, 0xe8, 0x4e, 0xe0, 0x2d, 0x91,
	0x0a, 0xc9, 0x0b, 0xb2, 0xac, 0x2a, 0xb5, 0x44, 0x3d, 0x8f, 0xd9, 0x5f, 0xb4, 0x03, 0xe9, 0x4b,
	0xd3, 0x5e, 0x90, 0x6a, 0x82, 0xd3, 0xc4, 0x40, 0xfb, 0x29, 0x6c, 0x77, 0xcd, 0x31, 0xb1, 0x99,
	0xe6, 0xc8, 0x31, 0xbd, 0xe5, 0xf7, 0x53, 0xff, 0x09, 0x20, 0xae, 0xde, 0xa5, 0x7e, 0x70, 0xcf,
	0xc9, 0x93, 0x6b, 0xed, 0x16, 0x3c, 0xe0, 0xda, 0x2f, 0xc8, 0x92, 0x58, 0x3f, 0xc0, 0x03, 0xa1,
	0xfa, 0x6a, 0x36, 0xfc, 0x2d, 0x01, 0xc5, 0x23, 0x6a, 0x13, 0x9f, 0x48, 0xc5, 0x3d, 0xc8, 0xf8,
	0xee, 0xc2, 0x9b, 0x10, 0xa9, 0x2b, 0x47, 0xe8, 0x47, 0xb0, 0x6b, 0x11, 0x3f, 0xa0, 0x8e, 0xc9,
	0xd6, 0xdc, 0xb0, 0xa8, 0x47, 0x26, 0x81, 0xeb, 0x2d, 0xa5, 0x35, 0x3b, 0x11, 0x66, 0x3b, 0xe4,
	0xa1, 0x37, 0xa1, 0x74, 0xc6, 0xc0, 0x8d, 0xb9, 0x47, 0x7c, 0xe2, 0x04, 0xd5, 0x6c, 0x4d, 0xa9,
	0xe7, 0x70, 0x91, 0x13, 0x4f, 0x04, 0x0d, 0x21, 0x48, 0xb1, 0x71, 0x35, 0xc9, 0xed, 0xe2, 0xff,
	0x51, 0x15, 0xb2, 0xe4, 0x6a, 0x62, 0x2f, 0x2c, 0x52, 0x4d, 0x71, 0x72, 0x38, 0x44, 0xbf, 0x04,
	0xd5, 0x5f, 0xce, 0x6c, 0xea, 0x5c, 0x18, 0x63, 0x72, 0x6e, 0x5e, 0x52, 0xd7, 0xab, 0xa6, 0x6b,
	0x4a, 0xbd, 0xdc, 0x78, 0xe7, 0x20, 0x12, 0x60, 0x07, 0x51, 0xa7, 0x0e, 0x06, 0x42, 0xe3, 0x50,
	0x2a, 0x7c, 0x96, 0x6a, 0xf5, 0x4f, 0x4e, 0x71, 0xc5, 0x8f, 0x93, 0x59, 0x24, 0xfa, 0x81, 0x47,
	0xe7, 0xcc, 0xdc, 0x33, 0x7a, 0x55, 0xcd, 0xd4, 0x14, 0x16, 0x89, 0x9c, 0x76, 0xc2, 0x49, 0xda,
	0xfb, 0x50, 0xb9, 0x06, 0x86, 0x72, 0xc0, 0xe1, 0x54, 0x05, 0x55, 0xa0, 0xd0, 0xd6, 0xb1, 0x7e,
	0xa4, 0x63, 0xbd, 0xd7, 0xd2, 0xd5, 0x84, 0xf6, 0x8f, 0x7d, 0xc8, 0x37, 0x83, 0xc0, 0xa3, 0xe3,
	0x45, 0x40, 0x98, 0xa3, 0x8e, 0x39, 0x0b, 0x17, 0x96, 0xff, 0x47, 0xa7, 0xf0, 0xa4, 0xad, 0x9f,
	0x60, 0xbd, 0xd5, 0x1c, 0xea, 0x6d, 0x63, 0x6e, 0x7a, 0x3e, 0x31, 0xc7, 0x36, 0x31, 0x6c, 0x77,
	0xc2, 0xd7, 0xb2, 0x5a, 0xac, 0x29, 0xf5, 0x42, 0x63, 0x37, 0xe6, 0x5b, 0x57, 0x32, 0xf1, 0xa3,
	0xb5, 0xee, 0x49, 0xa8, 0x1a, 0x32, 0xd1, 0x47, 0xb0, 0x43, 0xae, 0xe6, 0x36, 0x9d, 0xd0, 0xc0,
	0x5e, 0x1a, 0xfe, 0x9c, 0x4c, 0xe8, 0x19, 0x25, 0x56, 0xb5, 0xc4, 0xf7, 0x60, 0x7b, 0xcd, 0x1b,
	0x84, 0x2c, 0x16, 0x23, 0x8e, 0x6b, 0x91, 0x79, 0x75, 0x87, 0xcb, 0x88, 0x01, 0xfa, 0x14, 0x52,
	0x3c, 0x31, 0xd9, 0x4e, 0x97, 0x1b, 0x4f, 0x63, 0xa6, 0xac, 0xbc, 0x3b, 0x68, 0x53, 0x7f, 0xe2,
	0xd1, 0x19, 0x8b, 0x01, 0xd7, 0xc3, 0x5c, 0x03, 0x3d, 0x82, 0x3c, 0x75, 0x02, 0x43, 0xc4, 0x5d,
	0xb2, 0xa6, 0xd4, 0xd3, 0x38, 0x47, 0x9d, 0xe0, 0x25, 0x1b, 0x87, 0xab, 0xed, 0x4c, 0x25, 0x3f,
	0xbd, 0x5e, 0x6d, 0x67, 0x2a, 0x44, 0xde, 0x84, 0xd2, 0xd8, 0x75, 0x6d, 0x62, 0x3a, 0x52, 0xa6,
	0x2c, 0xe2, 0x47, 0x12, 0x85, 0xd0, 0x11, 0x94, 0x03, 0x8f, 0xfa, 0x81, 0x19, 0x10, 0x29, 0x55,
	0xe1, 0xf1, 0xf0, 0xfa, 0x2d, 0x86, 0x0e, 0xa5, 0x30, 0x2e, 0x85, 0x6a, 0x02, 0xe7, 0x5d, 0xd8,
	0x92, 0xf6, 0xd8, 0xd4, 0x0f, 0x8d, 0xce, 0xf0, 0xe8, 0xab, 0xf8, 0xab, 0x14, 0x13, 0xb2, 0x07,
	0x90, 0x95, 0xf5, 0x89, 0x87, 0x74, 0xa1, 0xb1, 0x13, 0xdf, 0x20, 0xc1, 0xc3, 0xa1, 0x10, 0xfa,
	0x62, 0x85, 0x6d, 0xd1, 0x49, 0x88, 0x9d, 0xab, 0x25, 0xeb, 0x85, 0xc6, 0xe3, 0x98, 0xe6, 0xb5,
	0x32, 0x10, 0xce, 0xcc, 0x08, 0x62, 0xe6, 0x63, 0x40, 0x67, 0x22, 0xb4, 0xa3, 0x66, 0xe6, 0x39,
	0xd4, 0x83, 0x5b, 0x33, 0x00, 0xab, 0x52, 0x69, 0xed, 0x02, 0x86, 0x5d, 0x9b, 0x55, 0x1f, 0x01,
	0x13, 0x31, 0x0b, 0x38, 0x56, 0x7c, 0xf5, 0x6e, 0x56, 0x39, 0x8c, 0xec, 0x28, 0x4d, 0x60, 0x8e,
	0x60, 0x2f, 0xba, 0x84, 0x11, 0xd0, 0x02, 0x07, 0xad, 0x6d, 0xf0, 0x35, 0x8e, 0xba, 0xed, 0xc7,
	0x88, 0x02, 0xf6, 0x39, 0x94, 0xa6, 0xb6, 0x3b, 0x36, 0x26, 0x1e, 0x0d, 0x88, 0x47, 0xcd, 0xaa,
	0xba, 0xc1, 0xdd, 0x63, 0xdb, 0x1d, 0xb7, 0xa4, 0x00, 0x2e, 0x4e, 0x23, 0x23, 0xf4, 0x14, 0xca,
	0x2c, 0x0c, 0x23, 0xeb, 0xb5, 0x55, 0x4b, 0xd6, 0xd3, 0xb8, 0x48, 0x9d, 0xc8, 0x82, 0x8c, 0x60,
	0x4f, 0x2c, 0x08, 0x37, 0x7b, 0xc1, 0x4e, 0x03, 0x29, 0xbd, 0xbd, 0xc1, 0xf8, 0x0d, 0xc7, 0x06,
	0xde, 0xb6, 0x63, 0x44, 0x01, 0x7b, 0x0e, 0x4f, 0x04, 0xec, 0x05, 0x2b, 0xf3, 0xc6, 0xcd, 0x30,
	0xd8, 0xe3, 0xe8, 0xff, 0x7f, 0x13, 0x7d, 0xd3, 0xb9, 0x80, 0x1f, 0xd8, 0x1b, 0x58, 0x62, 0xa6,
	0x2f, 0xa0, 0xe4, 0x13, 0x9b, 0x97, 0x5e, 0xee, 0x6b, 0x75, 0x97, 0x87, 0xe6, 0x9b, 0xb7, 0xe4,
	0xc1, 0x40, 0xca, 0xb2, 0x15, 0xc0, 0x45, 0x3f, 0x32, 0x42, 0x5f, 0x82, 0x16, 0xa9, 0x4a, 0x51,
	0x93, 0xa3, 0xcb, 0x82, 0x6a, 0xc9, 0x7a, 0x11, 0xbf, 0xb6, 0x96, 0x5c, 0x1b, 0xb4, 0xf6, 0xff,
	0xe1, 0x37, 0x39, 0x28, 0x85, 0x53, 0x89, 0x23, 0x66, 0x07, 0xd2, 0xdc, 0x89, 0xaa, 0xc2, 0x33,
	0x5e, 0x0c, 0x50, 0x1d, 0x54, 0xea, 0x1b, 0x16, 0x39, 0x33, 0x17, 0x76, 0xb8, 0x34, 0x2a, 0x4f,
	0xf7, 0x32, 0xf5, 0xdb, 0x82, 0x2c, 0xfc, 0x8c, 0x55, 0x95, 0xc4, 0x1d, 0x55, 0x25, 0x79, 0x8f,
	0xaa, 0x92, 0xba, 0x57, 0x55, 0x49, 0xff, 0xaf, 0xaa, 0xfc, 0x77, 0x57, 0x95, 0xe2, 0x0f, 0xad,
	0x2a, 0xa5, 0xef, 0x55, 0x55, 0x2a, 0xff, 0xd1, 0xaa, 0xb2, 0xf5, 0xef, 0xaa, 0x2a, 0xf7, 0xab,
	0x05, 0xe5, 0x7b, 0xd5, 0x82, 0x6f, 0x15, 0xc8, 0x85, 0xb5, 0x00, 0x3d, 0x87, 0x2c, 0x71, 0x02,
	0x8f, 0x12, 0x9f, 0xb7, 0xfc, 0x85, 0x5b, 0x3b, 0x8b, 0x58, 0xf5, 0xc0, 0xa1, 0x12, 0xcb, 0xac,
	0x73, 0xf3, 0x7a, 0xc5, 0x48, 0xf0, 0x54, 0xae, 0x9c, 0x9b, 0xf1, 0x92, 0xf1, 0x14, 0xca, 0x8e,
	0x6b, 0xcc, 0xcc, 0x60, 0x72, 0x6e, 0x10, 0xcf, 0x73, 0x3d, 0x59, 0x17, 0x8a, 0x8e, 0xfb, 0x15,
	0x23, 0xea, 0x8c, 0xf6, 0xf0, 0x77, 0x0a, 0x14, 0xa3, 0x55, 0x71, 0xd5, 0xf9, 0x28, 0x3c, 0xf5,
	0xbf, 0x4f, 0xe7, 0xf3, 0x39, 0xe4, 0x88, 0x4d, 0x66, 0xc4, 0x09, 0x7c, 0xde, 0x70, 0x17, 0x6e,
	0x2d, 0x1c, 0xe1, 0x84, 0x78, 0xa5, 0xa0, 0xfd, 0x3e, 0x09, 0xa5, 0x18, 0x28, 0x2a, 0x40, 0xb6,
	0xd3, 0x1b, 0xea, 0xc7, 0x3a, 0x56, 0x15, 0x04, 0x90, 0x19, 0x0c, 0x71, 0xa7, 0x77, 0xac, 0x26,
	0x50, 0x1e, 0xd2, 0xdd, 0xe6, 0xa1, 0xde, 0x55, 0x93, 0x8c, 0xdc, 0x1f, 0x0d, 0x4f, 0x46, 0x43,
	0x35, 0xc5, 0x3a, 0x51, 0x21, 0x62, 0x74, 0x3b, 0x83, 0xa1, 0x9a, 0x46, 0x65, 0x00, 0x2e, 0x27,
	0xc6, 0x19, 0x26, 0x20, 0x84, 0x05, 0x21, 0x8b, 0x76, 0x40, 0x6d, 0x77, 0x98, 0xce, 0xe1, 0x68,
	0xd8, 0xe9, 0xf7, 0x8c, 0x81, 0x3e, 0x54, 0x73, 0x6c, 0xde, 0x6e, 0xa7, 0xa5, 0xf7, 0x06, 0xba,
	0x9a, 0x8f, 0x80, 0xb6, 0x3b, 0xad, 0xa1, 0x0a, 0x68, 0x0f, 0xd0, 0x51, 0xa7, 0xab, 0x0f, 0xf4,
	0xa1, 0xa1, 0xf7, 0x86, 0xf8, 0x54, 0x60, 0x15, 0xd0, 0x36, 0x54, 0xd6, 0x93, 0x09, 0xe1, 0x22,
	0x9b, 0x20, 0x62, 0x92, 0xa0, 0x96, 0xd8, 0x04, 0x87, 0xfd, 0x7e, 0x57, 0x6f, 0xf6, 0xd4, 0x32,
	0x2a, 0x42, 0x6e, 0x88, 0x3b, 0x83, 0x61, 0x73, 0xa8, 0xab, 0x15, 0xa4, 0x42, 0x51, 0xfa, 0x2c,
	0x70, 0x55, 0x26, 0x3c, 0xea, 0xbd, 0xe8, 0xf5, 0xbf, 0xee, 0xa9, 0x88, 0xe1, 0x89, 0x49, 0x18,
	0x92, 0x31, 0xea, 0x35, 0xf1, 0xa9, 0xba, 0x8d, 0xb6, 0xa0, 0x34, 0xd0, 0xbb, 0x7a, 0x6b, 0xd8,
	0x97, 0x5a, 0x3b, 0xe8, 0x11, 0xec, 0x0b, 0xc1, 0x17, 0xfa, 0xa9, 0xde, 0x36, 0xa2, 0x2e, 0xec,
	0xa2, 0x1a, 0x3c, 0x8e, 0x44, 0x77, 0x84, 0x27, 0x11, 0xb7, 0xb4, 0xb7, 0x20, 0x17, 0xd6, 0x76,
	0x94, 0x81, 0x44, 0xaf, 0xaf, 0xfe, 0x1f, 0xca, 0x42, 0xf2, 0x54, 0x1f, 0xa8, 0x0a, 0xeb, 0xfd,
	0x9b, 0xa3, 0x61, 0x5f, 0x4d, 0x68, 0x7f, 0x4c, 0x41, 0x0a, 0x2f, 0xec, 0xcd, 0x5d, 0xfe, 0x13,
	0x00, 0x6f, 0x61, 0x13, 0x63, 0x62, 0x9b, 0xbe, 0x2f, 0x6f, 0x4c, 0x79, 0x46, 0x69, 0x31, 0x02,
	0x7a, 0x08, 0xb9, 0x55, 0xbf, 0x2f, 0xe2, 0x72, 0x35, 0x46, 0xcf, 0x20, 0x6f, 0x86, 0xb1, 0xc2,
	0xef, 0x42, 0x85, 0xc6, 0xde, 0xe6, 0x48, 0xc2, 0x6b, 0xc1, 0xd5, 0x84, 0xd4, 0x99, 0x2f, 0x82,
	0x6a, 0x5a, 0xdc, 0x98, 0x19, 0xa5, 0xc3, 0x08, 0xe8, 0x75, 0x28, 0x70, 0xb6, 0xbb, 0x08, 0x18,
	0x5f, 0x1c, 0x47, 0x5c, 0xa3, 0xcf, 0x29, 0xe8, 0x6d, 0xa8, 0x84, 0x79, 0xe5, 0x93, 0x20, 0xa0,
	0xce, 0xb4, 0x9a, 0xe5, 0x42, 0x65, 0x49, 0x1e, 0x08, 0xea, 0xdd, 0xf7, 0x97, 0xdc, 0x2b, 0xdf,
	0x5f, 0xde, 0x85, 0xad, 0xf9, 0x62, 0x6c, 0xd3, 0x89, 0x31, 0x5e, 0x86, 0x59, 0x5e, 0xcd, 0x8b,
	0xfc, 0x16, 0x8c, 0xc3, 0xa5, 0x4c, 0x72, 0xe6, 0x2f, 0xf5, 0x0d, 0xff, 0x62, 0x69, 0x9b, 0xde,
	0x45, 0x15, 0xb8, 0x50, 0x9e, 0xfa, 0x03, 0x41, 0x40, 0xbf, 0x80, 0x07, 0x92, 0x67, 0xac, 0xd6,
	0xc8, 0x30, 0xd9, 0x95, 0x28, 0xf0, 0xe5, 0x21, 0xf2, 0x78, 0xf3, 0xa2, 0x36, 0xb9, 0x10, 0xde,
	0x97, 0xea, 0xd7, 0xe8, 0x3e, 0x6a, 0xc2, 0x93, 0x10, 0x99, 0x38, 0x97, 0xd4, 0x73, 0x1d, 0x96,
	0xc2, 0xc6, 0xb9, 0xe9, 0x9f, 0x1b, 0x13, 0xd7, 0x22, 0xfc, 0xfe, 0x96, 0xc7, 0x0f, 0xa5, 0x90,
	0xbe, 0x96, 0xf9, 0xc2, 0xf4, 0xcf, 0x5b, 0xae, 0x45, 0x34, 0x1b, 0x2a, 0xd7, 0x60, 0xd1, 0x5b,
	0x50, 0x5e, 0xdb, 0x19, 0x89, 0xa6, 0xd2, 0x8a, 0xda, 0x63, 0x61, 0xd5, 0x80, 0x8c, 0x70, 0x82,
	0x87, 0x54, 0xa1, 0xf1, 0x30, 0x7e, 0x10, 0x4a, 0x93, 0x85, 0x07, 0x52, 0x52, 0xfb, 0x56, 0x81,
	0x52, 0x8c, 0x83, 0x3e, 0x64, 0xf7, 0xc4, 0x80, 0x38, 0x3e, 0xbb, 0xd7, 0xb3, 0x03, 0xdd, 0x08,
	0xbb, 0x33, 0x36, 0x25, 0x5a, 0xf1, 0xd8, 0xc9, 0xcf, 0x4f, 0x10, 0xd6, 0x40, 0x91, 0xab, 0xb9,
	0xeb, 0x05, 0xc4, 0x12, 0xd6, 0x89, 0x88, 0x2e, 0x86, 0x44, 0x6e, 0x5c, 0x2c, 0x70, 0x93, 0xf7,
	0x0c, 0x5c, 0xed, 0xb7, 0x0a, 0x14, 0x58, 0x1a, 0x0d, 0x16, 0xb3, 0x99, 0xe9, 0x2d, 0xd1, 0x5b,
	0x90, 0x62, 0x61, 0xc9, 0x8d, 0x29, 0x34, 0xb6, 0x62, 0x00, 0x4c, 0x0e, 0x73, 0x36, 0xfa, 0x08,
	0xc0, 0x22, 0x73, 0xe2, 0x58, 0xc4, 0x99, 0x2c, 0x65, 0xc1, 0xdd, 0x20, 0x1c, 0x11, 0xfa, 0xae,
	0xa4, 0xd3, 0xfe, 0xae, 0x40, 0xf1, 0xc4, 0x9c, 0x5c, 0x98, 0x53, 0x72, 0xec, 0xb9, 0x8b, 0xf9,
	0xc6, 0xa4, 0x7e, 0x0f, 0xb6, 0x26, 0xae, 0x13, 0x98, 0xd4, 0x21, 0x96, 0x31, 0x17, 0xd2, 0xf2,
	0x71, 0x45, 0x5d, 0x31, 0x24, 0x0a, 0x7a, 0x06, 0x7b, 0xd4, 0xe1, 0x2f, 0x18, 0x2b, 0x59, 0x63,
	0xca, 0xa0, 0xe5, 0xb3, 0xc7, 0x4e, 0xc8, 0x8d, 0x4d, 0x7b, 0x67, 0x76, 0xa5, 0x5e, 0x35, 0xbb,
	0xb4, 0x31, 0xa8, 0x91, 0x60, 0xbc, 0xdd, 0xcb, 0x1a, 0x14, 0x22, 0x81, 0x2d, 0xfd, 0x8b, 0x92,
	0x50, 0x15, 0xb2, 0x61, 0x76, 0x0a, 0x5f, 0xc2, 0xa1, 0xf6, 0x4d, 0x12, 0x60, 0xc0, 0x9f, 0x8f,
	0x58, 0xec, 0x6c, 0x84, 0x8f, 0xee, 0x42, 0xe2, 0x5a, 0xe9, 0xbb, 0xd3, 0xfb, 0xec, 0x2b, 0xd7,
	0x96, 0xd7, 0x00, 0xfc, 0xc5, 0x58, 0xae, 0xb9, 0x34, 0x3b, 0x42, 0x61, 0x11, 0x1e, 0xdf, 0x25,
	0xf1, 0x0a, 0x55, 0x9c, 0x47, 0x77, 0xe7, 0x1d, 0x50, 0x2f, 0xa9, 0x4f, 0xc7, 0xd4, 0xa6, 0xc1,
	0x52, 0x26, 0x8d, 0x28, 0xb5, 0x95, 0x35, 0x5d, 0x64, 0x4c, 0x15, 0xb2, 0x67, 0xc4, 0x0c, 0x16,
	0x5e, 0xd8, 0xfb, 0x87, 0xc3, 0x68, 0xcf, 0x9f, 0xbb, 0x4f, 0xcf, 0xff, 0x09, 0xec, 0x87, 0x96,
	0xc9, 0x20, 0xf3, 0x45, 0x47, 0xe3, 0xcb, 0xda, 0xb8, 0x2b, 0xd9, 0x2d, 0xc9, 0xe5, 0xad, 0x8d,
	0xaf, 0x9d, 0x43, 0xe9, 0x98, 0x38, 0xc4, 0x33, 0x03, 0x62, 0xdd, 0xba, 0x1b, 0x6f, 0x43, 0x65,
	0x2a, 0x84, 0x58, 0x93, 0xc7, 0x13, 0x4f, 0xa4, 0x76, 0x79, 0x4d, 0xe6, 0x87, 0xdc, 0x77, 0x25,
	0xcf, 0x5f, 0x93, 0x90, 0x19, 0x9a, 0xde, 0x94, 0x04, 0xe8, 0xe3, 0x55, 0xff, 0x94, 0xa8, 0x97,
	0x1b, 0x6f, 0xc4, 0x3c, 0x13, 0x22, 0x1b, 0x9b, 0xa7, 0x30, 0xe9, 0x13, 0x7c, 0x41, 0x6e, 0x4d,
	0xfa, 0x4f, 0xa1, 0x20, 0x1e, 0x27, 0x0d, 0xf9, 0x7e, 0xc8, 0xa4, 0xf7, 0xe3, 0x35, 0x70, 0x15,
	0x7d, 0x18, 0xfc, 0x75, 0x24, 0x36, 0x21, 0x74, 0x88, 0x58, 0x42, 0x59, 0x24, 0x52, 0xbc, 0x80,
	0xc6, 0xd6, 0x0b, 0x97, 0xa6, 0xb1, 0xe5, 0x7b, 0x7e, 0x3d, 0x42, 0xd2, 0x1c, 0x21, 0x7e, 0x7b,
	0x88, 0x26, 0xf3, 0xb5, 0xe0, 0xf9, 0x12, 0xb6, 0xa2, 0x07, 0x86, 0xc0, 0xc8, 0x70, 0x8c, 0x27,
	0x31, 0x8c, 0xeb, 0x59, 0x8a, 0x55, 0x72, 0x8d, 0xc2, 0xf6, 0x36, 0xde, 0x2e, 0xe6, 0x20, 0x85,
	0x47, 0x5d, 0x5d, 0x3c, 0x49, 0x0e, 0xfa, 0x23, 0xdc, 0xd2, 0x0d, 0xd6, 0xa9, 0xa9, 0x09, 0x84,
	0xa0, 0x7c, 0xac, 0xf7, 0x74, 0xcc, 0x73, 0x8a, 0xd3, 0x92, 0xac, 0x69, 0x3a, 0x69, 0xb6, 0x5e,
	0x34, 0x8f, 0x75, 0xe3, 0x18, 0xf7, 0x47, 0x27, 0x6a, 0x0a, 0xed, 0xc2, 0x96, 0xde, 0x7b, 0xd9,
	0xc1, 0xfd, 0xde, 0x57, 0x7a, 0x6f, 0x28, 0xc9, 0x69, 0xed, 0x33, 0x28, 0xfc, 0x9c, 0x59, 0x85,
	0x89, 0xcf, 0x8e, 0xdd, 0xf7, 0x20, 0x13, 0xf0, 0x6d, 0x94, 0x1d, 0xfc, 0xf6, 0x86, 0x1d, 0xc6,
	0x52, 0x44, 0xfb, 0x93, 0x02, 0x3b, 0x4d, 0xdb, 0x76, 0x7f, 0x4d, 0x2c, 0x1c, 0xb6, 0x3e, 0x1d,
	0xe7, 0xcc, 0x45, 0x5d, 0xc8, 0xcc, 0x5d, 0x9b, 0x4e, 0x96, 0x32, 0x4e, 0x9e, 0xc5, 0x8f, 0x89,
	0x0d, 0x2a, 0x37, 0x88, 0xc4, 0xc7, 0x12, 0x03, 0xbd, 0x0f, 0xc8, 0x14, 0x5c, 0x23, 0xd6, 0x73,
	0xf1, 0xba, 0x6c, 0x5e, 0xd3, 0xd3, 0xde, 0x07, 0x74, 0x13, 0x8b, 0xf5, 0x77, 0xcd, 0xde, 0xa9,
	0xaa, 0xa0, 0x12, 0xe4, 0x07, 0x27, 0x7a, 0xab, 0x73, 0xd4, 0xd1, 0xdb, 0x6a, 0x42, 0xfb, 0xa7,
	0x02, 0xdb, 0xab, 0x63, 0xab, 0x4d, 0xce, 0xa8, 0x43, 0x79, 0x39, 0xd9, 0x94, 0x4b, 0xaf, 0xfe,
	0x6a, 0xfa, 0x18, 0xf2, 0x33, 0xd3, 0xb1, 0x4c, 0xfe, 0xbc, 0x9e, 0xac, 0x25, 0x58, 0x2f, 0xb3,
	0x22, 0xa0, 0x01, 0xec, 0xdc, 0xf4, 0x8f, 0xf8, 0x32, 0x82, 0xdf, 0xb8, 0x73, 0xed, 0x30, 0x32,
	0x6f, 0x3a, 0xfc, 0x14, 0x4a, 0x96, 0x3b, 0x59, 0xb0, 0x90, 0x12, 0x49, 0x2d, 0x1e, 0x63, 0xe3,
	0x44, 0xed, 0x0f, 0x0a, 0x94, 0x99, 0xd6, 0x1d, 0x9e, 0x3f, 0x8f, 0x9e, 0xfc, 0x89, 0x0d, 0xb7,
	0xdc, 0x0d, 0x4b, 0x18, 0x6d, 0x5e, 0x6f, 0x18, 0x93, 0xdc, 0x60, 0xcc, 0xfa, 0x15, 0x29, 0x15,
	0x79, 0x45, 0xd2, 0x7e, 0x06, 0xa5, 0xc3, 0x05, 0xb5, 0xad, 0xae, 0xe9, 0x4c, 0x17, 0xec, 0xe0,
	0xfd, 0x60, 0xd5, 0x40, 0x30, 0x3b, 0x1e, 0xdd, 0xa8, 0x25, 0x11, 0x13, 0xb8, 0xa0, 0xf6, 0x67,
	0x05, 0x72, 0xab, 0x73, 0x82, 0xbf, 0x26, 0x99, 0x5e, 0x60, 0xb8, 0x67, 0x67, 0x3e, 0x0f, 0x73,
	0xa5, 0x9e, 0xc6, 0x05, 0x4e, 0xeb, 0x73, 0x12, 0x6b, 0x3d, 0x85, 0x88, 0x4d, 0x9d, 0xf0, 0x39,
	0x2a, 0xcf, 0x29, 0x5d, 0xea, 0x90, 0x35, 0xc2, 0xc4, 0xb5, 0x17, 0x33, 0x47, 0xbe, 0x82, 0x0b,
	0x84, 0x16, 0x27, 0x31, 0x04, 0xe2, 0x58, 0xe1, 0x14, 0x29, 0x81, 0x40, 0x1c, 0x4b, 0x4e, 0xf0,
	0x00, 0x72, 0x8c, 0xcd, 0xe1, 0xd3, 0x9c, 0x99, 0x25, 0x8e, 0xc5, 0xc1, 0xa5, 0xa6, 0x84, 0xce,
	0xac, 0x34, 0x05, 0xb0, 0xf6, 0x12, 0xca, 0x5f, 0x99, 0x17, 0xe4, 0xa5, 0xe9, 0x1d, 0x52, 0xc7,
	0x62, 0xed, 0xfa, 0xea, 0x23, 0x90, 0x12, 0xf9, 0x86, 0x84, 0x0e, 0x60, 0x7b, 0x6e, 0x9b, 0xc1,
	0x99, 0xeb, 0xcd, 0x58, 0xbb, 0x6f, 0x78, 0x64, 0x4a, 0xae, 0xe6, 0xb2, 0xf4, 0x6f, 0x85, 0xac,
	0x01, 0x09, 0x30, 0x67, 0x68, 0x43, 0xc8, 0x4a, 0xdc, 0x8d, 0xfb, 0xff, 0x31, 0x64, 0xc7, 0x62,
	0x3e, 0xb9, 0xfb, 0xf1, 0x55, 0x8f, 0x9b, 0x84, 0x43, 0x59, 0xed, 0x25, 0x14, 0xa3, 0xaf, 0x2d,
	0xec, 0xcc, 0x0c, 0x0f, 0x68, 0xf1, 0x49, 0x30, 0x1c, 0x46, 0xbf, 0x0e, 0x25, 0xe2, 0x5f, 0x87,
	0x10, 0xa4, 0xa6, 0xb6, 0x3b, 0xe6, 0xab, 0x9c, 0xc3, 0xfc, 0xbf, 0xf6, 0x17, 0x05, 0xd2, 0xfa,
	0x25, 0xeb, 0x54, 0x3e, 0x84, 0xd4, 0x05, 0x75, 0x2c, 0x59, 0x66, 0xe2, 0x1d, 0x3f, 0x97, 0x10,
	0xbf, 0x2f, 0xa8, 0x63, 0x61, 0x2e, 0x89, 0x8e, 0x60, 0x3b, 0xd2, 0x82, 0xc4, 0x3a, 0x95, 0x5b,
	0x1b, 0x0f, 0xb4, 0xd6, 0x58, 0xc5, 0x51, 0x15, 0xb2, 0x33, 0xe2, 0xfb, 0xac, 0x43, 0x14, 0xc1,
	0x1c, 0x0e, 0xb5, 0xcf, 0x21, 0xbf, 0x9a, 0x94, 0xdd, 0xe6, 0x75, 0x8c, 0xfb, 0xec, 0x92, 0x5f,
	0x80, 0xec, 0xd7, 0x4d, 0xdc, 0x13, 0xb7, 0xfc, 0x1c, 0xa4, 0x3a, 0xbd, 0xa3, 0xbe, 0x9a, 0x64,
	0x57, 0xe4, 0x13, 0xdc, 0x3f, 0xc6, 0xfa, 0x60, 0xa0, 0xa6, 0x0e, 0x3f, 0x81, 0x67, 0x13, 0x77,
	0x76, 0x30, 0x75, 0xdd, 0xa9, 0x4d, 0x0e, 0x2c, 0x72, 0x19, 0xb8, 0xae, 0xed, 0x1f, 0x88, 0xaf,
	0xae, 0x36, 0x1d, 0x1f, 0x70, 0xd3, 0x1a, 0xe2, 0x03, 0xac, 0xf8, 0x6d, 0x98, 0x73, 0xfa, 0xaf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x1e, 0xc0, 0x9c, 0xa4, 0xa4, 0x1d, 0x00, 0x00,
}
