/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg5_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg1_types "k8s.io/kubernetes/pkg/types"
	pkg4_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg5_runtime.RawExtension
		var v3 pkg1_types.UID
		var v4 pkg4_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [15]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			yyq2[12] = len(x.OwnerReferences) != 0
			yyq2[13] = len(x.Finalizers) != 0
			yyq2[14] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(15)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym51 := z.EncBinary()
					_ = yym51
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv62 := &x.CreationTimestamp
				yym63 := z.DecBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv62) {
				} else if yym63 {
					z.DecBinaryUnmarshal(yyv62)
				} else if !yym63 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv62)
				} else {
					z.DecFallback(yyv62, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym65 := z.DecBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym65 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym65 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym67 := z.DecBinary()
				_ = yym67
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv68 := &x.Labels
				yym69 := z.DecBinary()
				_ = yym69
				if false {
				} else {
					z.F.DecMapStringStringX(yyv68, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv70 := &x.Annotations
				yym71 := z.DecBinary()
				_ = yym71
				if false {
				} else {
					z.F.DecMapStringStringX(yyv70, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv72 := &x.OwnerReferences
				yym73 := z.DecBinary()
				_ = yym73
				if false {
				} else {
					h.decSliceOwnerReference((*[]OwnerReference)(yyv72), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv74 := &x.Finalizers
				yym75 := z.DecBinary()
				_ = yym75
				if false {
				} else {
					z.F.DecSliceStringX(yyv74, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj77 int
	var yyb77 bool
	var yyhl77 bool = l >= 0
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv85 := &x.CreationTimestamp
		yym86 := z.DecBinary()
		_ = yym86
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv85) {
		} else if yym86 {
			z.DecBinaryUnmarshal(yyv85)
		} else if !yym86 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv85)
		} else {
			z.DecFallback(yyv85, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym88 := z.DecBinary()
		_ = yym88
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym88 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym88 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym90 := z.DecBinary()
		_ = yym90
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv91 := &x.Labels
		yym92 := z.DecBinary()
		_ = yym92
		if false {
		} else {
			z.F.DecMapStringStringX(yyv91, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv93 := &x.Annotations
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else {
			z.F.DecMapStringStringX(yyv93, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv95 := &x.OwnerReferences
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else {
			h.decSliceOwnerReference((*[]OwnerReference)(yyv95), d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv97 := &x.Finalizers
		yym98 := z.DecBinary()
		_ = yym98
		if false {
		} else {
			z.F.DecSliceStringX(yyv97, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	for {
		yyj77++
		if yyhl77 {
			yyb77 = yyj77 > l
		} else {
			yyb77 = r.CheckBreak()
		}
		if yyb77 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj77-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym100 := z.EncBinary()
		_ = yym100
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep101 := !z.EncBinary()
			yy2arr101 := z.EncBasicHandle().StructToArray
			var yyq101 [24]bool
			_, _, _ = yysep101, yyq101, yy2arr101
			const yyr101 bool = false
			yyq101[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq101[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq101[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq101[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq101[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq101[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq101[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq101[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq101[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq101[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq101[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq101[12] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq101[13] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq101[14] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq101[15] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq101[16] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq101[17] = x.VolumeSource.FC != nil && x.FC != nil
			yyq101[18] = x.VolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq101[19] = x.VolumeSource.ConfigMap != nil && x.ConfigMap != nil
			yyq101[20] = x.VolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq101[21] = x.VolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq101[22] = x.VolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq101[23] = x.VolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			var yynn101 int
			if yyr101 || yy2arr101 {
				r.EncodeArrayStart(24)
			} else {
				yynn101 = 1
				for _, b := range yyq101 {
					if b {
						yynn101++
					}
				}
				r.EncodeMapStart(yynn101)
				yynn101 = 0
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym104 := z.EncBinary()
				_ = yym104
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn105 bool
			if x.VolumeSource.HostPath == nil {
				yyn105 = true
				goto LABEL105
			}
		LABEL105:
			if yyr101 || yy2arr101 {
				if yyn105 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn105 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn106 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn106 = true
				goto LABEL106
			}
		LABEL106:
			if yyr101 || yy2arr101 {
				if yyn106 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn106 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn107 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn107 = true
				goto LABEL107
			}
		LABEL107:
			if yyr101 || yy2arr101 {
				if yyn107 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn107 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn108 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn108 = true
				goto LABEL108
			}
		LABEL108:
			if yyr101 || yy2arr101 {
				if yyn108 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn108 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn109 bool
			if x.VolumeSource.GitRepo == nil {
				yyn109 = true
				goto LABEL109
			}
		LABEL109:
			if yyr101 || yy2arr101 {
				if yyn109 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn109 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn110 bool
			if x.VolumeSource.Secret == nil {
				yyn110 = true
				goto LABEL110
			}
		LABEL110:
			if yyr101 || yy2arr101 {
				if yyn110 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn110 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn111 bool
			if x.VolumeSource.NFS == nil {
				yyn111 = true
				goto LABEL111
			}
		LABEL111:
			if yyr101 || yy2arr101 {
				if yyn111 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn111 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn112 bool
			if x.VolumeSource.ISCSI == nil {
				yyn112 = true
				goto LABEL112
			}
		LABEL112:
			if yyr101 || yy2arr101 {
				if yyn112 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn112 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn113 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn113 = true
				goto LABEL113
			}
		LABEL113:
			if yyr101 || yy2arr101 {
				if yyn113 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn113 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn114 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn114 = true
				goto LABEL114
			}
		LABEL114:
			if yyr101 || yy2arr101 {
				if yyn114 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn114 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn115 bool
			if x.VolumeSource.RBD == nil {
				yyn115 = true
				goto LABEL115
			}
		LABEL115:
			if yyr101 || yy2arr101 {
				if yyn115 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn115 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn116 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn116 = true
				goto LABEL116
			}
		LABEL116:
			if yyr101 || yy2arr101 {
				if yyn116 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn116 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn117 bool
			if x.VolumeSource.Cinder == nil {
				yyn117 = true
				goto LABEL117
			}
		LABEL117:
			if yyr101 || yy2arr101 {
				if yyn117 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[13] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn117 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn118 bool
			if x.VolumeSource.CephFS == nil {
				yyn118 = true
				goto LABEL118
			}
		LABEL118:
			if yyr101 || yy2arr101 {
				if yyn118 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[14] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn118 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn119 bool
			if x.VolumeSource.Flocker == nil {
				yyn119 = true
				goto LABEL119
			}
		LABEL119:
			if yyr101 || yy2arr101 {
				if yyn119 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[15] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn119 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn120 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn120 = true
				goto LABEL120
			}
		LABEL120:
			if yyr101 || yy2arr101 {
				if yyn120 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[16] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn120 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn121 bool
			if x.VolumeSource.FC == nil {
				yyn121 = true
				goto LABEL121
			}
		LABEL121:
			if yyr101 || yy2arr101 {
				if yyn121 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[17] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn121 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn122 bool
			if x.VolumeSource.AzureFile == nil {
				yyn122 = true
				goto LABEL122
			}
		LABEL122:
			if yyr101 || yy2arr101 {
				if yyn122 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[18] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn122 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn123 bool
			if x.VolumeSource.ConfigMap == nil {
				yyn123 = true
				goto LABEL123
			}
		LABEL123:
			if yyr101 || yy2arr101 {
				if yyn123 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[19] {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn123 {
						r.EncodeNil()
					} else {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn124 bool
			if x.VolumeSource.VsphereVolume == nil {
				yyn124 = true
				goto LABEL124
			}
		LABEL124:
			if yyr101 || yy2arr101 {
				if yyn124 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[20] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn124 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn125 bool
			if x.VolumeSource.Quobyte == nil {
				yyn125 = true
				goto LABEL125
			}
		LABEL125:
			if yyr101 || yy2arr101 {
				if yyn125 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[21] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn125 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn126 bool
			if x.VolumeSource.AzureDisk == nil {
				yyn126 = true
				goto LABEL126
			}
		LABEL126:
			if yyr101 || yy2arr101 {
				if yyn126 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[22] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn126 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn127 bool
			if x.VolumeSource.PhotonPersistentDisk == nil {
				yyn127 = true
				goto LABEL127
			}
		LABEL127:
			if yyr101 || yy2arr101 {
				if yyn127 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[23] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[23] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn127 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct129 := r.ContainerType()
		if yyct129 == codecSelferValueTypeMap1234 {
			yyl129 := r.ReadMapStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl129, d)
			}
		} else if yyct129 == codecSelferValueTypeArray1234 {
			yyl129 := r.ReadArrayStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl129, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys130Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys130Slc
	var yyhl130 bool = l >= 0
	for yyj130 := 0; ; yyj130++ {
		if yyhl130 {
			if yyj130 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys130Slc = r.DecodeBytes(yys130Slc, true, true)
		yys130 := string(yys130Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys130 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.VolumeSource.AzureFile == nil {
				x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if x.VolumeSource.ConfigMap == nil {
				x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.VolumeSource.VsphereVolume == nil {
				x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.VolumeSource.Quobyte == nil {
				x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.VolumeSource.AzureDisk == nil {
				x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.VolumeSource.PhotonPersistentDisk == nil {
				x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys130)
		} // end switch yys130
	} // end for yyj130
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj155 int
	var yyb155 bool
	var yyhl155 bool = l >= 0
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureFile == nil {
		x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ConfigMap == nil {
		x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	if x.VolumeSource.VsphereVolume == nil {
		x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Quobyte == nil {
		x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureDisk == nil {
		x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PhotonPersistentDisk == nil {
		x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj155++
		if yyhl155 {
			yyb155 = yyj155 > l
		} else {
			yyb155 = r.CheckBreak()
		}
		if yyb155 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj155-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym180 := z.EncBinary()
		_ = yym180
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep181 := !z.EncBinary()
			yy2arr181 := z.EncBasicHandle().StructToArray
			var yyq181 [23]bool
			_, _, _ = yysep181, yyq181, yy2arr181
			const yyr181 bool = false
			yyq181[0] = x.HostPath != nil
			yyq181[1] = x.EmptyDir != nil
			yyq181[2] = x.GCEPersistentDisk != nil
			yyq181[3] = x.AWSElasticBlockStore != nil
			yyq181[4] = x.GitRepo != nil
			yyq181[5] = x.Secret != nil
			yyq181[6] = x.NFS != nil
			yyq181[7] = x.ISCSI != nil
			yyq181[8] = x.Glusterfs != nil
			yyq181[9] = x.PersistentVolumeClaim != nil
			yyq181[10] = x.RBD != nil
			yyq181[11] = x.FlexVolume != nil
			yyq181[12] = x.Cinder != nil
			yyq181[13] = x.CephFS != nil
			yyq181[14] = x.Flocker != nil
			yyq181[15] = x.DownwardAPI != nil
			yyq181[16] = x.FC != nil
			yyq181[17] = x.AzureFile != nil
			yyq181[18] = x.ConfigMap != nil
			yyq181[19] = x.VsphereVolume != nil
			yyq181[20] = x.Quobyte != nil
			yyq181[21] = x.AzureDisk != nil
			yyq181[22] = x.PhotonPersistentDisk != nil
			var yynn181 int
			if yyr181 || yy2arr181 {
				r.EncodeArrayStart(23)
			} else {
				yynn181 = 0
				for _, b := range yyq181 {
					if b {
						yynn181++
					}
				}
				r.EncodeMapStart(yynn181)
				yynn181 = 0
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[12] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[13] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[14] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[15] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[16] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[17] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[18] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[19] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[20] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[21] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[22] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym205 := z.DecBinary()
	_ = yym205
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct206 := r.ContainerType()
		if yyct206 == codecSelferValueTypeMap1234 {
			yyl206 := r.ReadMapStart()
			if yyl206 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl206, d)
			}
		} else if yyct206 == codecSelferValueTypeArray1234 {
			yyl206 := r.ReadArrayStart()
			if yyl206 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl206, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys207Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys207Slc
	var yyhl207 bool = l >= 0
	for yyj207 := 0; ; yyj207++ {
		if yyhl207 {
			if yyj207 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys207Slc = r.DecodeBytes(yys207Slc, true, true)
		yys207 := string(yys207Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys207 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys207)
		} // end switch yys207
	} // end for yyj207
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj231 int
	var yyb231 bool
	var yyhl231 bool = l >= 0
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj231++
		if yyhl231 {
			yyb231 = yyj231 > l
		} else {
			yyb231 = r.CheckBreak()
		}
		if yyb231 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj231-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym255 := z.EncBinary()
		_ = yym255
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep256 := !z.EncBinary()
			yy2arr256 := z.EncBasicHandle().StructToArray
			var yyq256 [2]bool
			_, _, _ = yysep256, yyq256, yy2arr256
			const yyr256 bool = false
			yyq256[1] = x.ReadOnly != false
			var yynn256 int
			if yyr256 || yy2arr256 {
				r.EncodeArrayStart(2)
			} else {
				yynn256 = 1
				for _, b := range yyq256 {
					if b {
						yynn256++
					}
				}
				r.EncodeMapStart(yynn256)
				yynn256 = 0
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym258 := z.EncBinary()
				_ = yym258
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym259 := z.EncBinary()
				_ = yym259
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[1] {
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq256[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym262 := z.EncBinary()
					_ = yym262
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym263 := z.DecBinary()
	_ = yym263
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct264 := r.ContainerType()
		if yyct264 == codecSelferValueTypeMap1234 {
			yyl264 := r.ReadMapStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl264, d)
			}
		} else if yyct264 == codecSelferValueTypeArray1234 {
			yyl264 := r.ReadArrayStart()
			if yyl264 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl264, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys265Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys265Slc
	var yyhl265 bool = l >= 0
	for yyj265 := 0; ; yyj265++ {
		if yyhl265 {
			if yyj265 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys265Slc = r.DecodeBytes(yys265Slc, true, true)
		yys265 := string(yys265Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys265 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys265)
		} // end switch yys265
	} // end for yyj265
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj268 int
	var yyb268 bool
	var yyhl268 bool = l >= 0
	yyj268++
	if yyhl268 {
		yyb268 = yyj268 > l
	} else {
		yyb268 = r.CheckBreak()
	}
	if yyb268 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj268++
	if yyhl268 {
		yyb268 = yyj268 > l
	} else {
		yyb268 = r.CheckBreak()
	}
	if yyb268 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj268++
		if yyhl268 {
			yyb268 = yyj268 > l
		} else {
			yyb268 = r.CheckBreak()
		}
		if yyb268 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj268-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym271 := z.EncBinary()
		_ = yym271
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep272 := !z.EncBinary()
			yy2arr272 := z.EncBasicHandle().StructToArray
			var yyq272 [17]bool
			_, _, _ = yysep272, yyq272, yy2arr272
			const yyr272 bool = false
			yyq272[0] = x.GCEPersistentDisk != nil
			yyq272[1] = x.AWSElasticBlockStore != nil
			yyq272[2] = x.HostPath != nil
			yyq272[3] = x.Glusterfs != nil
			yyq272[4] = x.NFS != nil
			yyq272[5] = x.RBD != nil
			yyq272[6] = x.ISCSI != nil
			yyq272[7] = x.Cinder != nil
			yyq272[8] = x.CephFS != nil
			yyq272[9] = x.FC != nil
			yyq272[10] = x.Flocker != nil
			yyq272[11] = x.FlexVolume != nil
			yyq272[12] = x.AzureFile != nil
			yyq272[13] = x.VsphereVolume != nil
			yyq272[14] = x.Quobyte != nil
			yyq272[15] = x.AzureDisk != nil
			yyq272[16] = x.PhotonPersistentDisk != nil
			var yynn272 int
			if yyr272 || yy2arr272 {
				r.EncodeArrayStart(17)
			} else {
				yynn272 = 0
				for _, b := range yyq272 {
					if b {
						yynn272++
					}
				}
				r.EncodeMapStart(yynn272)
				yynn272 = 0
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[6] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[7] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[8] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[9] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[10] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[12] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[13] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[14] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[15] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq272[16] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq272[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr272 || yy2arr272 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym290 := z.DecBinary()
	_ = yym290
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct291 := r.ContainerType()
		if yyct291 == codecSelferValueTypeMap1234 {
			yyl291 := r.ReadMapStart()
			if yyl291 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl291, d)
			}
		} else if yyct291 == codecSelferValueTypeArray1234 {
			yyl291 := r.ReadArrayStart()
			if yyl291 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl291, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys292Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys292Slc
	var yyhl292 bool = l >= 0
	for yyj292 := 0; ; yyj292++ {
		if yyhl292 {
			if yyj292 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys292Slc = r.DecodeBytes(yys292Slc, true, true)
		yys292 := string(yys292Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys292 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys292)
		} // end switch yys292
	} // end for yyj292
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj310 int
	var yyb310 bool
	var yyhl310 bool = l >= 0
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj310++
		if yyhl310 {
			yyb310 = yyj310 > l
		} else {
			yyb310 = r.CheckBreak()
		}
		if yyb310 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj310-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym328 := z.EncBinary()
		_ = yym328
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep329 := !z.EncBinary()
			yy2arr329 := z.EncBasicHandle().StructToArray
			var yyq329 [5]bool
			_, _, _ = yysep329, yyq329, yy2arr329
			const yyr329 bool = false
			yyq329[0] = x.Kind != ""
			yyq329[1] = x.APIVersion != ""
			yyq329[2] = true
			yyq329[3] = true
			yyq329[4] = true
			var yynn329 int
			if yyr329 || yy2arr329 {
				r.EncodeArrayStart(5)
			} else {
				yynn329 = 0
				for _, b := range yyq329 {
					if b {
						yynn329++
					}
				}
				r.EncodeMapStart(yynn329)
				yynn329 = 0
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[0] {
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym332 := z.EncBinary()
					_ = yym332
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[1] {
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym335 := z.EncBinary()
					_ = yym335
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[2] {
					yy337 := &x.ObjectMeta
					yy337.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy338 := &x.ObjectMeta
					yy338.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[3] {
					yy340 := &x.Spec
					yy340.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy341 := &x.Spec
					yy341.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[4] {
					yy343 := &x.Status
					yy343.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy344 := &x.Status
					yy344.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym345 := z.DecBinary()
	_ = yym345
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct346 := r.ContainerType()
		if yyct346 == codecSelferValueTypeMap1234 {
			yyl346 := r.ReadMapStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl346, d)
			}
		} else if yyct346 == codecSelferValueTypeArray1234 {
			yyl346 := r.ReadArrayStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl346, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys347Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys347Slc
	var yyhl347 bool = l >= 0
	for yyj347 := 0; ; yyj347++ {
		if yyhl347 {
			if yyj347 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys347Slc = r.DecodeBytes(yys347Slc, true, true)
		yys347 := string(yys347Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys347 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv350 := &x.ObjectMeta
				yyv350.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv351 := &x.Spec
				yyv351.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv352 := &x.Status
				yyv352.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys347)
		} // end switch yys347
	} // end for yyj347
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj353 int
	var yyb353 bool
	var yyhl353 bool = l >= 0
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv356 := &x.ObjectMeta
		yyv356.CodecDecodeSelf(d)
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv357 := &x.Spec
		yyv357.CodecDecodeSelf(d)
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv358 := &x.Status
		yyv358.CodecDecodeSelf(d)
	}
	for {
		yyj353++
		if yyhl353 {
			yyb353 = yyj353 > l
		} else {
			yyb353 = r.CheckBreak()
		}
		if yyb353 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj353-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym359 := z.EncBinary()
		_ = yym359
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep360 := !z.EncBinary()
			yy2arr360 := z.EncBasicHandle().StructToArray
			var yyq360 [21]bool
			_, _, _ = yysep360, yyq360, yy2arr360
			const yyr360 bool = false
			yyq360[0] = len(x.Capacity) != 0
			yyq360[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq360[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq360[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq360[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq360[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq360[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq360[7] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq360[8] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq360[9] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq360[10] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq360[11] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq360[12] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq360[13] = x.PersistentVolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq360[14] = x.PersistentVolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq360[15] = x.PersistentVolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq360[16] = x.PersistentVolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq360[17] = x.PersistentVolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			yyq360[18] = len(x.AccessModes) != 0
			yyq360[19] = x.ClaimRef != nil
			yyq360[20] = x.PersistentVolumeReclaimPolicy != ""
			var yynn360 int
			if yyr360 || yy2arr360 {
				r.EncodeArrayStart(21)
			} else {
				yynn360 = 0
				for _, b := range yyq360 {
					if b {
						yynn360++
					}
				}
				r.EncodeMapStart(yynn360)
				yynn360 = 0
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq360[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			var yyn362 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn362 = true
				goto LABEL362
			}
		LABEL362:
			if yyr360 || yy2arr360 {
				if yyn362 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn362 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn363 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn363 = true
				goto LABEL363
			}
		LABEL363:
			if yyr360 || yy2arr360 {
				if yyn363 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn363 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn364 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn364 = true
				goto LABEL364
			}
		LABEL364:
			if yyr360 || yy2arr360 {
				if yyn364 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn364 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn365 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn365 = true
				goto LABEL365
			}
		LABEL365:
			if yyr360 || yy2arr360 {
				if yyn365 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn365 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn366 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn366 = true
				goto LABEL366
			}
		LABEL366:
			if yyr360 || yy2arr360 {
				if yyn366 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn366 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn367 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn367 = true
				goto LABEL367
			}
		LABEL367:
			if yyr360 || yy2arr360 {
				if yyn367 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn367 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn368 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn368 = true
				goto LABEL368
			}
		LABEL368:
			if yyr360 || yy2arr360 {
				if yyn368 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[7] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn368 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn369 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn369 = true
				goto LABEL369
			}
		LABEL369:
			if yyr360 || yy2arr360 {
				if yyn369 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[8] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn369 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn370 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn370 = true
				goto LABEL370
			}
		LABEL370:
			if yyr360 || yy2arr360 {
				if yyn370 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[9] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn370 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn371 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn371 = true
				goto LABEL371
			}
		LABEL371:
			if yyr360 || yy2arr360 {
				if yyn371 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[10] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn371 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn372 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn372 = true
				goto LABEL372
			}
		LABEL372:
			if yyr360 || yy2arr360 {
				if yyn372 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[11] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn372 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn373 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn373 = true
				goto LABEL373
			}
		LABEL373:
			if yyr360 || yy2arr360 {
				if yyn373 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn373 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn374 bool
			if x.PersistentVolumeSource.AzureFile == nil {
				yyn374 = true
				goto LABEL374
			}
		LABEL374:
			if yyr360 || yy2arr360 {
				if yyn374 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[13] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn374 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn375 bool
			if x.PersistentVolumeSource.VsphereVolume == nil {
				yyn375 = true
				goto LABEL375
			}
		LABEL375:
			if yyr360 || yy2arr360 {
				if yyn375 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[14] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn375 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn376 bool
			if x.PersistentVolumeSource.Quobyte == nil {
				yyn376 = true
				goto LABEL376
			}
		LABEL376:
			if yyr360 || yy2arr360 {
				if yyn376 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[15] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn376 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn377 bool
			if x.PersistentVolumeSource.AzureDisk == nil {
				yyn377 = true
				goto LABEL377
			}
		LABEL377:
			if yyr360 || yy2arr360 {
				if yyn377 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[16] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn377 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn378 bool
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				yyn378 = true
				goto LABEL378
			}
		LABEL378:
			if yyr360 || yy2arr360 {
				if yyn378 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[17] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn378 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[18] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym380 := z.EncBinary()
						_ = yym380
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq360[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym381 := z.EncBinary()
						_ = yym381
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[19] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq360[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[20] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq360[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym384 := z.DecBinary()
	_ = yym384
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct385 := r.ContainerType()
		if yyct385 == codecSelferValueTypeMap1234 {
			yyl385 := r.ReadMapStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl385, d)
			}
		} else if yyct385 == codecSelferValueTypeArray1234 {
			yyl385 := r.ReadArrayStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl385, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys386Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys386Slc
	var yyhl386 bool = l >= 0
	for yyj386 := 0; ; yyj386++ {
		if yyhl386 {
			if yyj386 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys386Slc = r.DecodeBytes(yys386Slc, true, true)
		yys386 := string(yys386Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys386 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv387 := &x.Capacity
				yyv387.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.PersistentVolumeSource.AzureFile == nil {
				x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.PersistentVolumeSource.VsphereVolume == nil {
				x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.PersistentVolumeSource.Quobyte == nil {
				x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.PersistentVolumeSource.AzureDisk == nil {
				x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv405 := &x.AccessModes
				yym406 := z.DecBinary()
				_ = yym406
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv405), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys386)
		} // end switch yys386
	} // end for yyj386
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj409 int
	var yyb409 bool
	var yyhl409 bool = l >= 0
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv410 := &x.Capacity
		yyv410.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureFile == nil {
		x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.VsphereVolume == nil {
		x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Quobyte == nil {
		x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureDisk == nil {
		x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
		x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv428 := &x.AccessModes
		yym429 := z.DecBinary()
		_ = yym429
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv428), d)
		}
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj409++
		if yyhl409 {
			yyb409 = yyj409 > l
		} else {
			yyb409 = r.CheckBreak()
		}
		if yyb409 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj409-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym432 := z.EncBinary()
	_ = yym432
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym433 := z.DecBinary()
	_ = yym433
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym434 := z.EncBinary()
		_ = yym434
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep435 := !z.EncBinary()
			yy2arr435 := z.EncBasicHandle().StructToArray
			var yyq435 [3]bool
			_, _, _ = yysep435, yyq435, yy2arr435
			const yyr435 bool = false
			yyq435[0] = x.Phase != ""
			yyq435[1] = x.Message != ""
			yyq435[2] = x.Reason != ""
			var yynn435 int
			if yyr435 || yy2arr435 {
				r.EncodeArrayStart(3)
			} else {
				yynn435 = 0
				for _, b := range yyq435 {
					if b {
						yynn435++
					}
				}
				r.EncodeMapStart(yynn435)
				yynn435 = 0
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[1] {
					yym438 := z.EncBinary()
					_ = yym438
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym439 := z.EncBinary()
					_ = yym439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[2] {
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym442 := z.EncBinary()
					_ = yym442
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym443 := z.DecBinary()
	_ = yym443
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct444 := r.ContainerType()
		if yyct444 == codecSelferValueTypeMap1234 {
			yyl444 := r.ReadMapStart()
			if yyl444 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl444, d)
			}
		} else if yyct444 == codecSelferValueTypeArray1234 {
			yyl444 := r.ReadArrayStart()
			if yyl444 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl444, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys445Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys445Slc
	var yyhl445 bool = l >= 0
	for yyj445 := 0; ; yyj445++ {
		if yyhl445 {
			if yyj445 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys445Slc = r.DecodeBytes(yys445Slc, true, true)
		yys445 := string(yys445Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys445 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys445)
		} // end switch yys445
	} // end for yyj445
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj449 int
	var yyb449 bool
	var yyhl449 bool = l >= 0
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj449++
		if yyhl449 {
			yyb449 = yyj449 > l
		} else {
			yyb449 = r.CheckBreak()
		}
		if yyb449 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj449-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym453 := z.EncBinary()
		_ = yym453
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep454 := !z.EncBinary()
			yy2arr454 := z.EncBasicHandle().StructToArray
			var yyq454 [4]bool
			_, _, _ = yysep454, yyq454, yy2arr454
			const yyr454 bool = false
			yyq454[0] = x.Kind != ""
			yyq454[1] = x.APIVersion != ""
			yyq454[2] = true
			var yynn454 int
			if yyr454 || yy2arr454 {
				r.EncodeArrayStart(4)
			} else {
				yynn454 = 1
				for _, b := range yyq454 {
					if b {
						yynn454++
					}
				}
				r.EncodeMapStart(yynn454)
				yynn454 = 0
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[0] {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq454[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[1] {
					yym459 := z.EncBinary()
					_ = yym459
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq454[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym460 := z.EncBinary()
					_ = yym460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[2] {
					yy462 := &x.ListMeta
					yym463 := z.EncBinary()
					_ = yym463
					if false {
					} else if z.HasExtensions() && z.EncExt(yy462) {
					} else {
						z.EncFallback(yy462)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq454[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy464 := &x.ListMeta
					yym465 := z.EncBinary()
					_ = yym465
					if false {
					} else if z.HasExtensions() && z.EncExt(yy464) {
					} else {
						z.EncFallback(yy464)
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym468 := z.EncBinary()
					_ = yym468
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym469 := z.DecBinary()
	_ = yym469
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct470 := r.ContainerType()
		if yyct470 == codecSelferValueTypeMap1234 {
			yyl470 := r.ReadMapStart()
			if yyl470 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl470, d)
			}
		} else if yyct470 == codecSelferValueTypeArray1234 {
			yyl470 := r.ReadArrayStart()
			if yyl470 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl470, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys471Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys471Slc
	var yyhl471 bool = l >= 0
	for yyj471 := 0; ; yyj471++ {
		if yyhl471 {
			if yyj471 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys471Slc = r.DecodeBytes(yys471Slc, true, true)
		yys471 := string(yys471Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys471 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv474 := &x.ListMeta
				yym475 := z.DecBinary()
				_ = yym475
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv474) {
				} else {
					z.DecFallback(yyv474, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv476 := &x.Items
				yym477 := z.DecBinary()
				_ = yym477
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv476), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys471)
		} // end switch yys471
	} // end for yyj471
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj478 int
	var yyb478 bool
	var yyhl478 bool = l >= 0
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv481 := &x.ListMeta
		yym482 := z.DecBinary()
		_ = yym482
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv481) {
		} else {
			z.DecFallback(yyv481, false)
		}
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv483 := &x.Items
		yym484 := z.DecBinary()
		_ = yym484
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv483), d)
		}
	}
	for {
		yyj478++
		if yyhl478 {
			yyb478 = yyj478 > l
		} else {
			yyb478 = r.CheckBreak()
		}
		if yyb478 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj478-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym485 := z.EncBinary()
		_ = yym485
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep486 := !z.EncBinary()
			yy2arr486 := z.EncBasicHandle().StructToArray
			var yyq486 [5]bool
			_, _, _ = yysep486, yyq486, yy2arr486
			const yyr486 bool = false
			yyq486[0] = x.Kind != ""
			yyq486[1] = x.APIVersion != ""
			yyq486[2] = true
			yyq486[3] = true
			yyq486[4] = true
			var yynn486 int
			if yyr486 || yy2arr486 {
				r.EncodeArrayStart(5)
			} else {
				yynn486 = 0
				for _, b := range yyq486 {
					if b {
						yynn486++
					}
				}
				r.EncodeMapStart(yynn486)
				yynn486 = 0
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[0] {
					yym488 := z.EncBinary()
					_ = yym488
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq486[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym489 := z.EncBinary()
					_ = yym489
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[1] {
					yym491 := z.EncBinary()
					_ = yym491
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq486[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym492 := z.EncBinary()
					_ = yym492
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[2] {
					yy494 := &x.ObjectMeta
					yy494.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy495 := &x.ObjectMeta
					yy495.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[3] {
					yy497 := &x.Spec
					yy497.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy498 := &x.Spec
					yy498.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[4] {
					yy500 := &x.Status
					yy500.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy501 := &x.Status
					yy501.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym502 := z.DecBinary()
	_ = yym502
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct503 := r.ContainerType()
		if yyct503 == codecSelferValueTypeMap1234 {
			yyl503 := r.ReadMapStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl503, d)
			}
		} else if yyct503 == codecSelferValueTypeArray1234 {
			yyl503 := r.ReadArrayStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl503, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys504Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys504Slc
	var yyhl504 bool = l >= 0
	for yyj504 := 0; ; yyj504++ {
		if yyhl504 {
			if yyj504 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys504Slc = r.DecodeBytes(yys504Slc, true, true)
		yys504 := string(yys504Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys504 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv507 := &x.ObjectMeta
				yyv507.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv508 := &x.Spec
				yyv508.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv509 := &x.Status
				yyv509.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys504)
		} // end switch yys504
	} // end for yyj504
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj510 int
	var yyb510 bool
	var yyhl510 bool = l >= 0
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv513 := &x.ObjectMeta
		yyv513.CodecDecodeSelf(d)
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv514 := &x.Spec
		yyv514.CodecDecodeSelf(d)
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv515 := &x.Status
		yyv515.CodecDecodeSelf(d)
	}
	for {
		yyj510++
		if yyhl510 {
			yyb510 = yyj510 > l
		} else {
			yyb510 = r.CheckBreak()
		}
		if yyb510 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj510-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym516 := z.EncBinary()
		_ = yym516
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep517 := !z.EncBinary()
			yy2arr517 := z.EncBasicHandle().StructToArray
			var yyq517 [4]bool
			_, _, _ = yysep517, yyq517, yy2arr517
			const yyr517 bool = false
			yyq517[0] = x.Kind != ""
			yyq517[1] = x.APIVersion != ""
			yyq517[2] = true
			var yynn517 int
			if yyr517 || yy2arr517 {
				r.EncodeArrayStart(4)
			} else {
				yynn517 = 1
				for _, b := range yyq517 {
					if b {
						yynn517++
					}
				}
				r.EncodeMapStart(yynn517)
				yynn517 = 0
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[0] {
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq517[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym520 := z.EncBinary()
					_ = yym520
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[1] {
					yym522 := z.EncBinary()
					_ = yym522
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq517[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym523 := z.EncBinary()
					_ = yym523
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[2] {
					yy525 := &x.ListMeta
					yym526 := z.EncBinary()
					_ = yym526
					if false {
					} else if z.HasExtensions() && z.EncExt(yy525) {
					} else {
						z.EncFallback(yy525)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq517[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy527 := &x.ListMeta
					yym528 := z.EncBinary()
					_ = yym528
					if false {
					} else if z.HasExtensions() && z.EncExt(yy527) {
					} else {
						z.EncFallback(yy527)
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym530 := z.EncBinary()
					_ = yym530
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym531 := z.EncBinary()
					_ = yym531
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym532 := z.DecBinary()
	_ = yym532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct533 := r.ContainerType()
		if yyct533 == codecSelferValueTypeMap1234 {
			yyl533 := r.ReadMapStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl533, d)
			}
		} else if yyct533 == codecSelferValueTypeArray1234 {
			yyl533 := r.ReadArrayStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl533, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys534Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys534Slc
	var yyhl534 bool = l >= 0
	for yyj534 := 0; ; yyj534++ {
		if yyhl534 {
			if yyj534 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys534Slc = r.DecodeBytes(yys534Slc, true, true)
		yys534 := string(yys534Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys534 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv537 := &x.ListMeta
				yym538 := z.DecBinary()
				_ = yym538
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv537) {
				} else {
					z.DecFallback(yyv537, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv539 := &x.Items
				yym540 := z.DecBinary()
				_ = yym540
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv539), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys534)
		} // end switch yys534
	} // end for yyj534
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj541 int
	var yyb541 bool
	var yyhl541 bool = l >= 0
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv544 := &x.ListMeta
		yym545 := z.DecBinary()
		_ = yym545
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv544) {
		} else {
			z.DecFallback(yyv544, false)
		}
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv546 := &x.Items
		yym547 := z.DecBinary()
		_ = yym547
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv546), d)
		}
	}
	for {
		yyj541++
		if yyhl541 {
			yyb541 = yyj541 > l
		} else {
			yyb541 = r.CheckBreak()
		}
		if yyb541 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj541-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym548 := z.EncBinary()
		_ = yym548
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep549 := !z.EncBinary()
			yy2arr549 := z.EncBasicHandle().StructToArray
			var yyq549 [4]bool
			_, _, _ = yysep549, yyq549, yy2arr549
			const yyr549 bool = false
			yyq549[0] = len(x.AccessModes) != 0
			yyq549[1] = x.Selector != nil
			yyq549[2] = true
			yyq549[3] = x.VolumeName != ""
			var yynn549 int
			if yyr549 || yy2arr549 {
				r.EncodeArrayStart(4)
			} else {
				yynn549 = 0
				for _, b := range yyq549 {
					if b {
						yynn549++
					}
				}
				r.EncodeMapStart(yynn549)
				yynn549 = 0
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym551 := z.EncBinary()
						_ = yym551
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym552 := z.EncBinary()
						_ = yym552
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym554 := z.EncBinary()
						_ = yym554
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym555 := z.EncBinary()
						_ = yym555
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[2] {
					yy557 := &x.Resources
					yy557.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy558 := &x.Resources
					yy558.CodecEncodeSelf(e)
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[3] {
					yym560 := z.EncBinary()
					_ = yym560
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq549[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym561 := z.EncBinary()
					_ = yym561
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym562 := z.DecBinary()
	_ = yym562
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct563 := r.ContainerType()
		if yyct563 == codecSelferValueTypeMap1234 {
			yyl563 := r.ReadMapStart()
			if yyl563 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl563, d)
			}
		} else if yyct563 == codecSelferValueTypeArray1234 {
			yyl563 := r.ReadArrayStart()
			if yyl563 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl563, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys564Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys564Slc
	var yyhl564 bool = l >= 0
	for yyj564 := 0; ; yyj564++ {
		if yyhl564 {
			if yyj564 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys564Slc = r.DecodeBytes(yys564Slc, true, true)
		yys564 := string(yys564Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys564 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv565 := &x.AccessModes
				yym566 := z.DecBinary()
				_ = yym566
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv565), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_unversioned.LabelSelector)
				}
				yym568 := z.DecBinary()
				_ = yym568
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv569 := &x.Resources
				yyv569.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys564)
		} // end switch yys564
	} // end for yyj564
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj571 int
	var yyb571 bool
	var yyhl571 bool = l >= 0
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv572 := &x.AccessModes
		yym573 := z.DecBinary()
		_ = yym573
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv572), d)
		}
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_unversioned.LabelSelector)
		}
		yym575 := z.DecBinary()
		_ = yym575
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv576 := &x.Resources
		yyv576.CodecDecodeSelf(d)
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj571++
		if yyhl571 {
			yyb571 = yyj571 > l
		} else {
			yyb571 = r.CheckBreak()
		}
		if yyb571 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj571-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym578 := z.EncBinary()
		_ = yym578
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep579 := !z.EncBinary()
			yy2arr579 := z.EncBasicHandle().StructToArray
			var yyq579 [3]bool
			_, _, _ = yysep579, yyq579, yy2arr579
			const yyr579 bool = false
			yyq579[0] = x.Phase != ""
			yyq579[1] = len(x.AccessModes) != 0
			yyq579[2] = len(x.Capacity) != 0
			var yynn579 int
			if yyr579 || yy2arr579 {
				r.EncodeArrayStart(3)
			} else {
				yynn579 = 0
				for _, b := range yyq579 {
					if b {
						yynn579++
					}
				}
				r.EncodeMapStart(yynn579)
				yynn579 = 0
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq579[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym582 := z.EncBinary()
						_ = yym582
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq579[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym583 := z.EncBinary()
						_ = yym583
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq579[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym585 := z.DecBinary()
	_ = yym585
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct586 := r.ContainerType()
		if yyct586 == codecSelferValueTypeMap1234 {
			yyl586 := r.ReadMapStart()
			if yyl586 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl586, d)
			}
		} else if yyct586 == codecSelferValueTypeArray1234 {
			yyl586 := r.ReadArrayStart()
			if yyl586 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl586, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys587Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys587Slc
	var yyhl587 bool = l >= 0
	for yyj587 := 0; ; yyj587++ {
		if yyhl587 {
			if yyj587 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys587Slc = r.DecodeBytes(yys587Slc, true, true)
		yys587 := string(yys587Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys587 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv589 := &x.AccessModes
				yym590 := z.DecBinary()
				_ = yym590
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv589), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv591 := &x.Capacity
				yyv591.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys587)
		} // end switch yys587
	} // end for yyj587
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj592 int
	var yyb592 bool
	var yyhl592 bool = l >= 0
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv594 := &x.AccessModes
		yym595 := z.DecBinary()
		_ = yym595
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv594), d)
		}
	}
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv596 := &x.Capacity
		yyv596.CodecDecodeSelf(d)
	}
	for {
		yyj592++
		if yyhl592 {
			yyb592 = yyj592 > l
		} else {
			yyb592 = r.CheckBreak()
		}
		if yyb592 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj592-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym597 := z.EncBinary()
	_ = yym597
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym598 := z.DecBinary()
	_ = yym598
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym599 := z.EncBinary()
	_ = yym599
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym600 := z.DecBinary()
	_ = yym600
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym601 := z.EncBinary()
	_ = yym601
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym602 := z.DecBinary()
	_ = yym602
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym603 := z.EncBinary()
		_ = yym603
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep604 := !z.EncBinary()
			yy2arr604 := z.EncBasicHandle().StructToArray
			var yyq604 [1]bool
			_, _, _ = yysep604, yyq604, yy2arr604
			const yyr604 bool = false
			var yynn604 int
			if yyr604 || yy2arr604 {
				r.EncodeArrayStart(1)
			} else {
				yynn604 = 1
				for _, b := range yyq604 {
					if b {
						yynn604++
					}
				}
				r.EncodeMapStart(yynn604)
				yynn604 = 0
			}
			if yyr604 || yy2arr604 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym606 := z.EncBinary()
				_ = yym606
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym607 := z.EncBinary()
				_ = yym607
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr604 || yy2arr604 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym608 := z.DecBinary()
	_ = yym608
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct609 := r.ContainerType()
		if yyct609 == codecSelferValueTypeMap1234 {
			yyl609 := r.ReadMapStart()
			if yyl609 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl609, d)
			}
		} else if yyct609 == codecSelferValueTypeArray1234 {
			yyl609 := r.ReadArrayStart()
			if yyl609 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl609, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys610Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys610Slc
	var yyhl610 bool = l >= 0
	for yyj610 := 0; ; yyj610++ {
		if yyhl610 {
			if yyj610 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys610Slc = r.DecodeBytes(yys610Slc, true, true)
		yys610 := string(yys610Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys610 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys610)
		} // end switch yys610
	} // end for yyj610
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj612 int
	var yyb612 bool
	var yyhl612 bool = l >= 0
	yyj612++
	if yyhl612 {
		yyb612 = yyj612 > l
	} else {
		yyb612 = r.CheckBreak()
	}
	if yyb612 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj612++
		if yyhl612 {
			yyb612 = yyj612 > l
		} else {
			yyb612 = r.CheckBreak()
		}
		if yyb612 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj612-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym614 := z.EncBinary()
		_ = yym614
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep615 := !z.EncBinary()
			yy2arr615 := z.EncBasicHandle().StructToArray
			var yyq615 [1]bool
			_, _, _ = yysep615, yyq615, yy2arr615
			const yyr615 bool = false
			yyq615[0] = x.Medium != ""
			var yynn615 int
			if yyr615 || yy2arr615 {
				r.EncodeArrayStart(1)
			} else {
				yynn615 = 0
				for _, b := range yyq615 {
					if b {
						yynn615++
					}
				}
				r.EncodeMapStart(yynn615)
				yynn615 = 0
			}
			if yyr615 || yy2arr615 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq615[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq615[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr615 || yy2arr615 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym617 := z.DecBinary()
	_ = yym617
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct618 := r.ContainerType()
		if yyct618 == codecSelferValueTypeMap1234 {
			yyl618 := r.ReadMapStart()
			if yyl618 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl618, d)
			}
		} else if yyct618 == codecSelferValueTypeArray1234 {
			yyl618 := r.ReadArrayStart()
			if yyl618 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl618, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys619Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys619Slc
	var yyhl619 bool = l >= 0
	for yyj619 := 0; ; yyj619++ {
		if yyhl619 {
			if yyj619 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys619Slc = r.DecodeBytes(yys619Slc, true, true)
		yys619 := string(yys619Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys619 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys619)
		} // end switch yys619
	} // end for yyj619
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj621 int
	var yyb621 bool
	var yyhl621 bool = l >= 0
	yyj621++
	if yyhl621 {
		yyb621 = yyj621 > l
	} else {
		yyb621 = r.CheckBreak()
	}
	if yyb621 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj621++
		if yyhl621 {
			yyb621 = yyj621 > l
		} else {
			yyb621 = r.CheckBreak()
		}
		if yyb621 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj621-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym623 := z.EncBinary()
		_ = yym623
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep624 := !z.EncBinary()
			yy2arr624 := z.EncBasicHandle().StructToArray
			var yyq624 [3]bool
			_, _, _ = yysep624, yyq624, yy2arr624
			const yyr624 bool = false
			yyq624[2] = x.ReadOnly != false
			var yynn624 int
			if yyr624 || yy2arr624 {
				r.EncodeArrayStart(3)
			} else {
				yynn624 = 2
				for _, b := range yyq624 {
					if b {
						yynn624++
					}
				}
				r.EncodeMapStart(yynn624)
				yynn624 = 0
			}
			if yyr624 || yy2arr624 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym626 := z.EncBinary()
				_ = yym626
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym627 := z.EncBinary()
				_ = yym627
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr624 || yy2arr624 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym629 := z.EncBinary()
				_ = yym629
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym630 := z.EncBinary()
				_ = yym630
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr624 || yy2arr624 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq624[2] {
					yym632 := z.EncBinary()
					_ = yym632
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq624[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym633 := z.EncBinary()
					_ = yym633
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr624 || yy2arr624 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym634 := z.DecBinary()
	_ = yym634
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct635 := r.ContainerType()
		if yyct635 == codecSelferValueTypeMap1234 {
			yyl635 := r.ReadMapStart()
			if yyl635 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl635, d)
			}
		} else if yyct635 == codecSelferValueTypeArray1234 {
			yyl635 := r.ReadArrayStart()
			if yyl635 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl635, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys636Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys636Slc
	var yyhl636 bool = l >= 0
	for yyj636 := 0; ; yyj636++ {
		if yyhl636 {
			if yyj636 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys636Slc = r.DecodeBytes(yys636Slc, true, true)
		yys636 := string(yys636Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys636 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys636)
		} // end switch yys636
	} // end for yyj636
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj640 int
	var yyb640 bool
	var yyhl640 bool = l >= 0
	yyj640++
	if yyhl640 {
		yyb640 = yyj640 > l
	} else {
		yyb640 = r.CheckBreak()
	}
	if yyb640 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj640++
	if yyhl640 {
		yyb640 = yyj640 > l
	} else {
		yyb640 = r.CheckBreak()
	}
	if yyb640 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj640++
	if yyhl640 {
		yyb640 = yyj640 > l
	} else {
		yyb640 = r.CheckBreak()
	}
	if yyb640 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj640++
		if yyhl640 {
			yyb640 = yyj640 > l
		} else {
			yyb640 = r.CheckBreak()
		}
		if yyb640 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj640-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym644 := z.EncBinary()
		_ = yym644
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep645 := !z.EncBinary()
			yy2arr645 := z.EncBasicHandle().StructToArray
			var yyq645 [8]bool
			_, _, _ = yysep645, yyq645, yy2arr645
			const yyr645 bool = false
			yyq645[2] = x.FSType != ""
			yyq645[3] = x.RBDPool != ""
			yyq645[4] = x.RadosUser != ""
			yyq645[5] = x.Keyring != ""
			yyq645[6] = x.SecretRef != nil
			yyq645[7] = x.ReadOnly != false
			var yynn645 int
			if yyr645 || yy2arr645 {
				r.EncodeArrayStart(8)
			} else {
				yynn645 = 2
				for _, b := range yyq645 {
					if b {
						yynn645++
					}
				}
				r.EncodeMapStart(yynn645)
				yynn645 = 0
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym647 := z.EncBinary()
					_ = yym647
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym650 := z.EncBinary()
				_ = yym650
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym651 := z.EncBinary()
				_ = yym651
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[2] {
					yym653 := z.EncBinary()
					_ = yym653
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq645[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym654 := z.EncBinary()
					_ = yym654
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[3] {
					yym656 := z.EncBinary()
					_ = yym656
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq645[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("pool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym657 := z.EncBinary()
					_ = yym657
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[4] {
					yym659 := z.EncBinary()
					_ = yym659
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq645[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym660 := z.EncBinary()
					_ = yym660
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[5] {
					yym662 := z.EncBinary()
					_ = yym662
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq645[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("keyring"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym663 := z.EncBinary()
					_ = yym663
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[6] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq645[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq645[7] {
					yym666 := z.EncBinary()
					_ = yym666
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq645[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym667 := z.EncBinary()
					_ = yym667
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr645 || yy2arr645 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym668 := z.DecBinary()
	_ = yym668
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct669 := r.ContainerType()
		if yyct669 == codecSelferValueTypeMap1234 {
			yyl669 := r.ReadMapStart()
			if yyl669 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl669, d)
			}
		} else if yyct669 == codecSelferValueTypeArray1234 {
			yyl669 := r.ReadArrayStart()
			if yyl669 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl669, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys670Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys670Slc
	var yyhl670 bool = l >= 0
	for yyj670 := 0; ; yyj670++ {
		if yyhl670 {
			if yyj670 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys670Slc = r.DecodeBytes(yys670Slc, true, true)
		yys670 := string(yys670Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys670 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv671 := &x.CephMonitors
				yym672 := z.DecBinary()
				_ = yym672
				if false {
				} else {
					z.F.DecSliceStringX(yyv671, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys670)
		} // end switch yys670
	} // end for yyj670
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj680 int
	var yyb680 bool
	var yyhl680 bool = l >= 0
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv681 := &x.CephMonitors
		yym682 := z.DecBinary()
		_ = yym682
		if false {
		} else {
			z.F.DecSliceStringX(yyv681, false, d)
		}
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj680++
	if yyhl680 {
		yyb680 = yyj680 > l
	} else {
		yyb680 = r.CheckBreak()
	}
	if yyb680 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj680++
		if yyhl680 {
			yyb680 = yyj680 > l
		} else {
			yyb680 = r.CheckBreak()
		}
		if yyb680 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj680-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym690 := z.EncBinary()
		_ = yym690
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep691 := !z.EncBinary()
			yy2arr691 := z.EncBasicHandle().StructToArray
			var yyq691 [3]bool
			_, _, _ = yysep691, yyq691, yy2arr691
			const yyr691 bool = false
			yyq691[1] = x.FSType != ""
			yyq691[2] = x.ReadOnly != false
			var yynn691 int
			if yyr691 || yy2arr691 {
				r.EncodeArrayStart(3)
			} else {
				yynn691 = 1
				for _, b := range yyq691 {
					if b {
						yynn691++
					}
				}
				r.EncodeMapStart(yynn691)
				yynn691 = 0
			}
			if yyr691 || yy2arr691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym693 := z.EncBinary()
				_ = yym693
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym694 := z.EncBinary()
				_ = yym694
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr691 || yy2arr691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq691[1] {
					yym696 := z.EncBinary()
					_ = yym696
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq691[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym697 := z.EncBinary()
					_ = yym697
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr691 || yy2arr691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq691[2] {
					yym699 := z.EncBinary()
					_ = yym699
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq691[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym700 := z.EncBinary()
					_ = yym700
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr691 || yy2arr691 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym701 := z.DecBinary()
	_ = yym701
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct702 := r.ContainerType()
		if yyct702 == codecSelferValueTypeMap1234 {
			yyl702 := r.ReadMapStart()
			if yyl702 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl702, d)
			}
		} else if yyct702 == codecSelferValueTypeArray1234 {
			yyl702 := r.ReadArrayStart()
			if yyl702 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl702, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys703Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys703Slc
	var yyhl703 bool = l >= 0
	for yyj703 := 0; ; yyj703++ {
		if yyhl703 {
			if yyj703 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys703Slc = r.DecodeBytes(yys703Slc, true, true)
		yys703 := string(yys703Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys703 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys703)
		} // end switch yys703
	} // end for yyj703
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj707 int
	var yyb707 bool
	var yyhl707 bool = l >= 0
	yyj707++
	if yyhl707 {
		yyb707 = yyj707 > l
	} else {
		yyb707 = r.CheckBreak()
	}
	if yyb707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj707++
	if yyhl707 {
		yyb707 = yyj707 > l
	} else {
		yyb707 = r.CheckBreak()
	}
	if yyb707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj707++
	if yyhl707 {
		yyb707 = yyj707 > l
	} else {
		yyb707 = r.CheckBreak()
	}
	if yyb707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj707++
		if yyhl707 {
			yyb707 = yyj707 > l
		} else {
			yyb707 = r.CheckBreak()
		}
		if yyb707 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj707-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym711 := z.EncBinary()
		_ = yym711
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep712 := !z.EncBinary()
			yy2arr712 := z.EncBasicHandle().StructToArray
			var yyq712 [6]bool
			_, _, _ = yysep712, yyq712, yy2arr712
			const yyr712 bool = false
			yyq712[1] = x.Path != ""
			yyq712[2] = x.User != ""
			yyq712[3] = x.SecretFile != ""
			yyq712[4] = x.SecretRef != nil
			yyq712[5] = x.ReadOnly != false
			var yynn712 int
			if yyr712 || yy2arr712 {
				r.EncodeArrayStart(6)
			} else {
				yynn712 = 1
				for _, b := range yyq712 {
					if b {
						yynn712++
					}
				}
				r.EncodeMapStart(yynn712)
				yynn712 = 0
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym714 := z.EncBinary()
					_ = yym714
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym715 := z.EncBinary()
					_ = yym715
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[1] {
					yym717 := z.EncBinary()
					_ = yym717
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq712[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym718 := z.EncBinary()
					_ = yym718
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[2] {
					yym720 := z.EncBinary()
					_ = yym720
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq712[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym721 := z.EncBinary()
					_ = yym721
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[3] {
					yym723 := z.EncBinary()
					_ = yym723
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq712[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym724 := z.EncBinary()
					_ = yym724
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[4] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq712[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq712[5] {
					yym727 := z.EncBinary()
					_ = yym727
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq712[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym728 := z.EncBinary()
					_ = yym728
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr712 || yy2arr712 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym729 := z.DecBinary()
	_ = yym729
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct730 := r.ContainerType()
		if yyct730 == codecSelferValueTypeMap1234 {
			yyl730 := r.ReadMapStart()
			if yyl730 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl730, d)
			}
		} else if yyct730 == codecSelferValueTypeArray1234 {
			yyl730 := r.ReadArrayStart()
			if yyl730 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl730, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys731Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys731Slc
	var yyhl731 bool = l >= 0
	for yyj731 := 0; ; yyj731++ {
		if yyhl731 {
			if yyj731 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys731Slc = r.DecodeBytes(yys731Slc, true, true)
		yys731 := string(yys731Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys731 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv732 := &x.Monitors
				yym733 := z.DecBinary()
				_ = yym733
				if false {
				} else {
					z.F.DecSliceStringX(yyv732, false, d)
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys731)
		} // end switch yys731
	} // end for yyj731
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj739 int
	var yyb739 bool
	var yyhl739 bool = l >= 0
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv740 := &x.Monitors
		yym741 := z.DecBinary()
		_ = yym741
		if false {
		} else {
			z.F.DecSliceStringX(yyv740, false, d)
		}
	}
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj739++
	if yyhl739 {
		yyb739 = yyj739 > l
	} else {
		yyb739 = r.CheckBreak()
	}
	if yyb739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj739++
		if yyhl739 {
			yyb739 = yyj739 > l
		} else {
			yyb739 = r.CheckBreak()
		}
		if yyb739 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj739-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym747 := z.EncBinary()
		_ = yym747
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep748 := !z.EncBinary()
			yy2arr748 := z.EncBasicHandle().StructToArray
			var yyq748 [2]bool
			_, _, _ = yysep748, yyq748, yy2arr748
			const yyr748 bool = false
			yyq748[0] = x.DatasetName != ""
			yyq748[1] = x.DatasetUUID != ""
			var yynn748 int
			if yyr748 || yy2arr748 {
				r.EncodeArrayStart(2)
			} else {
				yynn748 = 0
				for _, b := range yyq748 {
					if b {
						yynn748++
					}
				}
				r.EncodeMapStart(yynn748)
				yynn748 = 0
			}
			if yyr748 || yy2arr748 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq748[0] {
					yym750 := z.EncBinary()
					_ = yym750
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq748[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym751 := z.EncBinary()
					_ = yym751
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				}
			}
			if yyr748 || yy2arr748 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq748[1] {
					yym753 := z.EncBinary()
					_ = yym753
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq748[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetUUID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym754 := z.EncBinary()
					_ = yym754
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				}
			}
			if yyr748 || yy2arr748 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym755 := z.DecBinary()
	_ = yym755
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct756 := r.ContainerType()
		if yyct756 == codecSelferValueTypeMap1234 {
			yyl756 := r.ReadMapStart()
			if yyl756 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl756, d)
			}
		} else if yyct756 == codecSelferValueTypeArray1234 {
			yyl756 := r.ReadArrayStart()
			if yyl756 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl756, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys757Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys757Slc
	var yyhl757 bool = l >= 0
	for yyj757 := 0; ; yyj757++ {
		if yyhl757 {
			if yyj757 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys757Slc = r.DecodeBytes(yys757Slc, true, true)
		yys757 := string(yys757Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys757 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		case "datasetUUID":
			if r.TryDecodeAsNil() {
				x.DatasetUUID = ""
			} else {
				x.DatasetUUID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys757)
		} // end switch yys757
	} // end for yyj757
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj760 int
	var yyb760 bool
	var yyhl760 bool = l >= 0
	yyj760++
	if yyhl760 {
		yyb760 = yyj760 > l
	} else {
		yyb760 = r.CheckBreak()
	}
	if yyb760 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	yyj760++
	if yyhl760 {
		yyb760 = yyj760 > l
	} else {
		yyb760 = r.CheckBreak()
	}
	if yyb760 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetUUID = ""
	} else {
		x.DatasetUUID = string(r.DecodeString())
	}
	for {
		yyj760++
		if yyhl760 {
			yyb760 = yyj760 > l
		} else {
			yyb760 = r.CheckBreak()
		}
		if yyb760 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj760-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym763 := z.EncBinary()
	_ = yym763
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym764 := z.DecBinary()
	_ = yym764
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym765 := z.EncBinary()
	_ = yym765
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym766 := z.DecBinary()
	_ = yym766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym767 := z.EncBinary()
		_ = yym767
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep768 := !z.EncBinary()
			yy2arr768 := z.EncBasicHandle().StructToArray
			var yyq768 [4]bool
			_, _, _ = yysep768, yyq768, yy2arr768
			const yyr768 bool = false
			yyq768[1] = x.FSType != ""
			yyq768[2] = x.Partition != 0
			yyq768[3] = x.ReadOnly != false
			var yynn768 int
			if yyr768 || yy2arr768 {
				r.EncodeArrayStart(4)
			} else {
				yynn768 = 1
				for _, b := range yyq768 {
					if b {
						yynn768++
					}
				}
				r.EncodeMapStart(yynn768)
				yynn768 = 0
			}
			if yyr768 || yy2arr768 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym770 := z.EncBinary()
				_ = yym770
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym771 := z.EncBinary()
				_ = yym771
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr768 || yy2arr768 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq768[1] {
					yym773 := z.EncBinary()
					_ = yym773
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq768[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym774 := z.EncBinary()
					_ = yym774
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr768 || yy2arr768 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq768[2] {
					yym776 := z.EncBinary()
					_ = yym776
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq768[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym777 := z.EncBinary()
					_ = yym777
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr768 || yy2arr768 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq768[3] {
					yym779 := z.EncBinary()
					_ = yym779
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq768[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym780 := z.EncBinary()
					_ = yym780
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr768 || yy2arr768 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym781 := z.DecBinary()
	_ = yym781
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct782 := r.ContainerType()
		if yyct782 == codecSelferValueTypeMap1234 {
			yyl782 := r.ReadMapStart()
			if yyl782 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl782, d)
			}
		} else if yyct782 == codecSelferValueTypeArray1234 {
			yyl782 := r.ReadArrayStart()
			if yyl782 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl782, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys783Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys783Slc
	var yyhl783 bool = l >= 0
	for yyj783 := 0; ; yyj783++ {
		if yyhl783 {
			if yyj783 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys783Slc = r.DecodeBytes(yys783Slc, true, true)
		yys783 := string(yys783Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys783 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys783)
		} // end switch yys783
	} // end for yyj783
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj788 int
	var yyb788 bool
	var yyhl788 bool = l >= 0
	yyj788++
	if yyhl788 {
		yyb788 = yyj788 > l
	} else {
		yyb788 = r.CheckBreak()
	}
	if yyb788 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj788++
	if yyhl788 {
		yyb788 = yyj788 > l
	} else {
		yyb788 = r.CheckBreak()
	}
	if yyb788 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj788++
	if yyhl788 {
		yyb788 = yyj788 > l
	} else {
		yyb788 = r.CheckBreak()
	}
	if yyb788 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj788++
	if yyhl788 {
		yyb788 = yyj788 > l
	} else {
		yyb788 = r.CheckBreak()
	}
	if yyb788 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj788++
		if yyhl788 {
			yyb788 = yyj788 > l
		} else {
			yyb788 = r.CheckBreak()
		}
		if yyb788 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj788-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *QuobyteVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym793 := z.EncBinary()
		_ = yym793
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep794 := !z.EncBinary()
			yy2arr794 := z.EncBasicHandle().StructToArray
			var yyq794 [5]bool
			_, _, _ = yysep794, yyq794, yy2arr794
			const yyr794 bool = false
			yyq794[2] = x.ReadOnly != false
			yyq794[3] = x.User != ""
			yyq794[4] = x.Group != ""
			var yynn794 int
			if yyr794 || yy2arr794 {
				r.EncodeArrayStart(5)
			} else {
				yynn794 = 2
				for _, b := range yyq794 {
					if b {
						yynn794++
					}
				}
				r.EncodeMapStart(yynn794)
				yynn794 = 0
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym796 := z.EncBinary()
				_ = yym796
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym797 := z.EncBinary()
				_ = yym797
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym799 := z.EncBinary()
				_ = yym799
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volume"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym800 := z.EncBinary()
				_ = yym800
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq794[2] {
					yym802 := z.EncBinary()
					_ = yym802
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq794[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym803 := z.EncBinary()
					_ = yym803
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq794[3] {
					yym805 := z.EncBinary()
					_ = yym805
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq794[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym806 := z.EncBinary()
					_ = yym806
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq794[4] {
					yym808 := z.EncBinary()
					_ = yym808
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq794[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym809 := z.EncBinary()
					_ = yym809
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr794 || yy2arr794 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *QuobyteVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym810 := z.DecBinary()
	_ = yym810
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct811 := r.ContainerType()
		if yyct811 == codecSelferValueTypeMap1234 {
			yyl811 := r.ReadMapStart()
			if yyl811 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl811, d)
			}
		} else if yyct811 == codecSelferValueTypeArray1234 {
			yyl811 := r.ReadArrayStart()
			if yyl811 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl811, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys812Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys812Slc
	var yyhl812 bool = l >= 0
	for yyj812 := 0; ; yyj812++ {
		if yyhl812 {
			if yyj812 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys812Slc = r.DecodeBytes(yys812Slc, true, true)
		yys812 := string(yys812Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys812 {
		case "registry":
			if r.TryDecodeAsNil() {
				x.Registry = ""
			} else {
				x.Registry = string(r.DecodeString())
			}
		case "volume":
			if r.TryDecodeAsNil() {
				x.Volume = ""
			} else {
				x.Volume = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys812)
		} // end switch yys812
	} // end for yyj812
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj818 int
	var yyb818 bool
	var yyhl818 bool = l >= 0
	yyj818++
	if yyhl818 {
		yyb818 = yyj818 > l
	} else {
		yyb818 = r.CheckBreak()
	}
	if yyb818 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Registry = ""
	} else {
		x.Registry = string(r.DecodeString())
	}
	yyj818++
	if yyhl818 {
		yyb818 = yyj818 > l
	} else {
		yyb818 = r.CheckBreak()
	}
	if yyb818 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volume = ""
	} else {
		x.Volume = string(r.DecodeString())
	}
	yyj818++
	if yyhl818 {
		yyb818 = yyj818 > l
	} else {
		yyb818 = r.CheckBreak()
	}
	if yyb818 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj818++
	if yyhl818 {
		yyb818 = yyj818 > l
	} else {
		yyb818 = r.CheckBreak()
	}
	if yyb818 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj818++
	if yyhl818 {
		yyb818 = yyj818 > l
	} else {
		yyb818 = r.CheckBreak()
	}
	if yyb818 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	for {
		yyj818++
		if yyhl818 {
			yyb818 = yyj818 > l
		} else {
			yyb818 = r.CheckBreak()
		}
		if yyb818 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj818-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym824 := z.EncBinary()
		_ = yym824
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep825 := !z.EncBinary()
			yy2arr825 := z.EncBasicHandle().StructToArray
			var yyq825 [5]bool
			_, _, _ = yysep825, yyq825, yy2arr825
			const yyr825 bool = false
			yyq825[1] = x.FSType != ""
			yyq825[2] = x.SecretRef != nil
			yyq825[3] = x.ReadOnly != false
			yyq825[4] = len(x.Options) != 0
			var yynn825 int
			if yyr825 || yy2arr825 {
				r.EncodeArrayStart(5)
			} else {
				yynn825 = 1
				for _, b := range yyq825 {
					if b {
						yynn825++
					}
				}
				r.EncodeMapStart(yynn825)
				yynn825 = 0
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym827 := z.EncBinary()
				_ = yym827
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym828 := z.EncBinary()
				_ = yym828
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq825[1] {
					yym830 := z.EncBinary()
					_ = yym830
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq825[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym831 := z.EncBinary()
					_ = yym831
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq825[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq825[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq825[3] {
					yym834 := z.EncBinary()
					_ = yym834
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq825[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq825[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym837 := z.EncBinary()
						_ = yym837
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq825[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym838 := z.EncBinary()
						_ = yym838
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr825 || yy2arr825 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym839 := z.DecBinary()
	_ = yym839
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct840 := r.ContainerType()
		if yyct840 == codecSelferValueTypeMap1234 {
			yyl840 := r.ReadMapStart()
			if yyl840 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl840, d)
			}
		} else if yyct840 == codecSelferValueTypeArray1234 {
			yyl840 := r.ReadArrayStart()
			if yyl840 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl840, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys841Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys841Slc
	var yyhl841 bool = l >= 0
	for yyj841 := 0; ; yyj841++ {
		if yyhl841 {
			if yyj841 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys841Slc = r.DecodeBytes(yys841Slc, true, true)
		yys841 := string(yys841Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys841 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv846 := &x.Options
				yym847 := z.DecBinary()
				_ = yym847
				if false {
				} else {
					z.F.DecMapStringStringX(yyv846, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys841)
		} // end switch yys841
	} // end for yyj841
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj848 int
	var yyb848 bool
	var yyhl848 bool = l >= 0
	yyj848++
	if yyhl848 {
		yyb848 = yyj848 > l
	} else {
		yyb848 = r.CheckBreak()
	}
	if yyb848 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj848++
	if yyhl848 {
		yyb848 = yyj848 > l
	} else {
		yyb848 = r.CheckBreak()
	}
	if yyb848 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj848++
	if yyhl848 {
		yyb848 = yyj848 > l
	} else {
		yyb848 = r.CheckBreak()
	}
	if yyb848 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj848++
	if yyhl848 {
		yyb848 = yyj848 > l
	} else {
		yyb848 = r.CheckBreak()
	}
	if yyb848 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj848++
	if yyhl848 {
		yyb848 = yyj848 > l
	} else {
		yyb848 = r.CheckBreak()
	}
	if yyb848 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv853 := &x.Options
		yym854 := z.DecBinary()
		_ = yym854
		if false {
		} else {
			z.F.DecMapStringStringX(yyv853, false, d)
		}
	}
	for {
		yyj848++
		if yyhl848 {
			yyb848 = yyj848 > l
		} else {
			yyb848 = r.CheckBreak()
		}
		if yyb848 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj848-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym855 := z.EncBinary()
		_ = yym855
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep856 := !z.EncBinary()
			yy2arr856 := z.EncBasicHandle().StructToArray
			var yyq856 [4]bool
			_, _, _ = yysep856, yyq856, yy2arr856
			const yyr856 bool = false
			yyq856[1] = x.FSType != ""
			yyq856[2] = x.Partition != 0
			yyq856[3] = x.ReadOnly != false
			var yynn856 int
			if yyr856 || yy2arr856 {
				r.EncodeArrayStart(4)
			} else {
				yynn856 = 1
				for _, b := range yyq856 {
					if b {
						yynn856++
					}
				}
				r.EncodeMapStart(yynn856)
				yynn856 = 0
			}
			if yyr856 || yy2arr856 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym858 := z.EncBinary()
				_ = yym858
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym859 := z.EncBinary()
				_ = yym859
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr856 || yy2arr856 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq856[1] {
					yym861 := z.EncBinary()
					_ = yym861
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq856[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym862 := z.EncBinary()
					_ = yym862
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr856 || yy2arr856 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq856[2] {
					yym864 := z.EncBinary()
					_ = yym864
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq856[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym865 := z.EncBinary()
					_ = yym865
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr856 || yy2arr856 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq856[3] {
					yym867 := z.EncBinary()
					_ = yym867
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq856[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym868 := z.EncBinary()
					_ = yym868
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr856 || yy2arr856 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym869 := z.DecBinary()
	_ = yym869
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct870 := r.ContainerType()
		if yyct870 == codecSelferValueTypeMap1234 {
			yyl870 := r.ReadMapStart()
			if yyl870 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl870, d)
			}
		} else if yyct870 == codecSelferValueTypeArray1234 {
			yyl870 := r.ReadArrayStart()
			if yyl870 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl870, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys871Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys871Slc
	var yyhl871 bool = l >= 0
	for yyj871 := 0; ; yyj871++ {
		if yyhl871 {
			if yyj871 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys871Slc = r.DecodeBytes(yys871Slc, true, true)
		yys871 := string(yys871Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys871 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys871)
		} // end switch yys871
	} // end for yyj871
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj876 int
	var yyb876 bool
	var yyhl876 bool = l >= 0
	yyj876++
	if yyhl876 {
		yyb876 = yyj876 > l
	} else {
		yyb876 = r.CheckBreak()
	}
	if yyb876 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj876++
	if yyhl876 {
		yyb876 = yyj876 > l
	} else {
		yyb876 = r.CheckBreak()
	}
	if yyb876 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj876++
	if yyhl876 {
		yyb876 = yyj876 > l
	} else {
		yyb876 = r.CheckBreak()
	}
	if yyb876 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj876++
	if yyhl876 {
		yyb876 = yyj876 > l
	} else {
		yyb876 = r.CheckBreak()
	}
	if yyb876 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj876++
		if yyhl876 {
			yyb876 = yyj876 > l
		} else {
			yyb876 = r.CheckBreak()
		}
		if yyb876 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj876-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym881 := z.EncBinary()
		_ = yym881
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep882 := !z.EncBinary()
			yy2arr882 := z.EncBasicHandle().StructToArray
			var yyq882 [3]bool
			_, _, _ = yysep882, yyq882, yy2arr882
			const yyr882 bool = false
			yyq882[1] = x.Revision != ""
			yyq882[2] = x.Directory != ""
			var yynn882 int
			if yyr882 || yy2arr882 {
				r.EncodeArrayStart(3)
			} else {
				yynn882 = 1
				for _, b := range yyq882 {
					if b {
						yynn882++
					}
				}
				r.EncodeMapStart(yynn882)
				yynn882 = 0
			}
			if yyr882 || yy2arr882 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym884 := z.EncBinary()
				_ = yym884
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym885 := z.EncBinary()
				_ = yym885
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr882 || yy2arr882 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq882[1] {
					yym887 := z.EncBinary()
					_ = yym887
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq882[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym888 := z.EncBinary()
					_ = yym888
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr882 || yy2arr882 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq882[2] {
					yym890 := z.EncBinary()
					_ = yym890
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq882[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym891 := z.EncBinary()
					_ = yym891
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr882 || yy2arr882 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym892 := z.DecBinary()
	_ = yym892
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct893 := r.ContainerType()
		if yyct893 == codecSelferValueTypeMap1234 {
			yyl893 := r.ReadMapStart()
			if yyl893 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl893, d)
			}
		} else if yyct893 == codecSelferValueTypeArray1234 {
			yyl893 := r.ReadArrayStart()
			if yyl893 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl893, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys894Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys894Slc
	var yyhl894 bool = l >= 0
	for yyj894 := 0; ; yyj894++ {
		if yyhl894 {
			if yyj894 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys894Slc = r.DecodeBytes(yys894Slc, true, true)
		yys894 := string(yys894Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys894 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys894)
		} // end switch yys894
	} // end for yyj894
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj898 int
	var yyb898 bool
	var yyhl898 bool = l >= 0
	yyj898++
	if yyhl898 {
		yyb898 = yyj898 > l
	} else {
		yyb898 = r.CheckBreak()
	}
	if yyb898 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj898++
	if yyhl898 {
		yyb898 = yyj898 > l
	} else {
		yyb898 = r.CheckBreak()
	}
	if yyb898 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj898++
	if yyhl898 {
		yyb898 = yyj898 > l
	} else {
		yyb898 = r.CheckBreak()
	}
	if yyb898 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj898++
		if yyhl898 {
			yyb898 = yyj898 > l
		} else {
			yyb898 = r.CheckBreak()
		}
		if yyb898 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj898-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym902 := z.EncBinary()
		_ = yym902
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep903 := !z.EncBinary()
			yy2arr903 := z.EncBasicHandle().StructToArray
			var yyq903 [3]bool
			_, _, _ = yysep903, yyq903, yy2arr903
			const yyr903 bool = false
			yyq903[0] = x.SecretName != ""
			yyq903[1] = len(x.Items) != 0
			yyq903[2] = x.DefaultMode != nil
			var yynn903 int
			if yyr903 || yy2arr903 {
				r.EncodeArrayStart(3)
			} else {
				yynn903 = 0
				for _, b := range yyq903 {
					if b {
						yynn903++
					}
				}
				r.EncodeMapStart(yynn903)
				yynn903 = 0
			}
			if yyr903 || yy2arr903 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq903[0] {
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq903[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym906 := z.EncBinary()
					_ = yym906
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr903 || yy2arr903 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq903[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym908 := z.EncBinary()
						_ = yym908
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq903[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym909 := z.EncBinary()
						_ = yym909
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr903 || yy2arr903 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq903[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy911 := *x.DefaultMode
						yym912 := z.EncBinary()
						_ = yym912
						if false {
						} else {
							r.EncodeInt(int64(yy911))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq903[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy913 := *x.DefaultMode
						yym914 := z.EncBinary()
						_ = yym914
						if false {
						} else {
							r.EncodeInt(int64(yy913))
						}
					}
				}
			}
			if yyr903 || yy2arr903 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym915 := z.DecBinary()
	_ = yym915
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct916 := r.ContainerType()
		if yyct916 == codecSelferValueTypeMap1234 {
			yyl916 := r.ReadMapStart()
			if yyl916 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl916, d)
			}
		} else if yyct916 == codecSelferValueTypeArray1234 {
			yyl916 := r.ReadArrayStart()
			if yyl916 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl916, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys917Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys917Slc
	var yyhl917 bool = l >= 0
	for yyj917 := 0; ; yyj917++ {
		if yyhl917 {
			if yyj917 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys917Slc = r.DecodeBytes(yys917Slc, true, true)
		yys917 := string(yys917Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys917 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv919 := &x.Items
				yym920 := z.DecBinary()
				_ = yym920
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv919), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym922 := z.DecBinary()
				_ = yym922
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys917)
		} // end switch yys917
	} // end for yyj917
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj923 int
	var yyb923 bool
	var yyhl923 bool = l >= 0
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv925 := &x.Items
		yym926 := z.DecBinary()
		_ = yym926
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv925), d)
		}
	}
	yyj923++
	if yyhl923 {
		yyb923 = yyj923 > l
	} else {
		yyb923 = r.CheckBreak()
	}
	if yyb923 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym928 := z.DecBinary()
		_ = yym928
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj923++
		if yyhl923 {
			yyb923 = yyj923 > l
		} else {
			yyb923 = r.CheckBreak()
		}
		if yyb923 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj923-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym929 := z.EncBinary()
		_ = yym929
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep930 := !z.EncBinary()
			yy2arr930 := z.EncBasicHandle().StructToArray
			var yyq930 [3]bool
			_, _, _ = yysep930, yyq930, yy2arr930
			const yyr930 bool = false
			yyq930[2] = x.ReadOnly != false
			var yynn930 int
			if yyr930 || yy2arr930 {
				r.EncodeArrayStart(3)
			} else {
				yynn930 = 2
				for _, b := range yyq930 {
					if b {
						yynn930++
					}
				}
				r.EncodeMapStart(yynn930)
				yynn930 = 0
			}
			if yyr930 || yy2arr930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym932 := z.EncBinary()
				_ = yym932
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym933 := z.EncBinary()
				_ = yym933
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr930 || yy2arr930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym935 := z.EncBinary()
				_ = yym935
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym936 := z.EncBinary()
				_ = yym936
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr930 || yy2arr930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq930[2] {
					yym938 := z.EncBinary()
					_ = yym938
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq930[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym939 := z.EncBinary()
					_ = yym939
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr930 || yy2arr930 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym940 := z.DecBinary()
	_ = yym940
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct941 := r.ContainerType()
		if yyct941 == codecSelferValueTypeMap1234 {
			yyl941 := r.ReadMapStart()
			if yyl941 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl941, d)
			}
		} else if yyct941 == codecSelferValueTypeArray1234 {
			yyl941 := r.ReadArrayStart()
			if yyl941 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl941, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys942Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys942Slc
	var yyhl942 bool = l >= 0
	for yyj942 := 0; ; yyj942++ {
		if yyhl942 {
			if yyj942 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys942Slc = r.DecodeBytes(yys942Slc, true, true)
		yys942 := string(yys942Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys942 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys942)
		} // end switch yys942
	} // end for yyj942
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj946 int
	var yyb946 bool
	var yyhl946 bool = l >= 0
	yyj946++
	if yyhl946 {
		yyb946 = yyj946 > l
	} else {
		yyb946 = r.CheckBreak()
	}
	if yyb946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj946++
	if yyhl946 {
		yyb946 = yyj946 > l
	} else {
		yyb946 = r.CheckBreak()
	}
	if yyb946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj946++
	if yyhl946 {
		yyb946 = yyj946 > l
	} else {
		yyb946 = r.CheckBreak()
	}
	if yyb946 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj946++
		if yyhl946 {
			yyb946 = yyj946 > l
		} else {
			yyb946 = r.CheckBreak()
		}
		if yyb946 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj946-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym950 := z.EncBinary()
		_ = yym950
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep951 := !z.EncBinary()
			yy2arr951 := z.EncBasicHandle().StructToArray
			var yyq951 [6]bool
			_, _, _ = yysep951, yyq951, yy2arr951
			const yyr951 bool = false
			yyq951[3] = x.ISCSIInterface != ""
			yyq951[4] = x.FSType != ""
			yyq951[5] = x.ReadOnly != false
			var yynn951 int
			if yyr951 || yy2arr951 {
				r.EncodeArrayStart(6)
			} else {
				yynn951 = 3
				for _, b := range yyq951 {
					if b {
						yynn951++
					}
				}
				r.EncodeMapStart(yynn951)
				yynn951 = 0
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym953 := z.EncBinary()
				_ = yym953
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym954 := z.EncBinary()
				_ = yym954
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym956 := z.EncBinary()
				_ = yym956
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iqn"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym957 := z.EncBinary()
				_ = yym957
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym959 := z.EncBinary()
				_ = yym959
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym960 := z.EncBinary()
				_ = yym960
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[3] {
					yym962 := z.EncBinary()
					_ = yym962
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq951[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym963 := z.EncBinary()
					_ = yym963
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[4] {
					yym965 := z.EncBinary()
					_ = yym965
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq951[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym966 := z.EncBinary()
					_ = yym966
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[5] {
					yym968 := z.EncBinary()
					_ = yym968
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq951[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym969 := z.EncBinary()
					_ = yym969
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym970 := z.DecBinary()
	_ = yym970
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct971 := r.ContainerType()
		if yyct971 == codecSelferValueTypeMap1234 {
			yyl971 := r.ReadMapStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl971, d)
			}
		} else if yyct971 == codecSelferValueTypeArray1234 {
			yyl971 := r.ReadArrayStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl971, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys972Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys972Slc
	var yyhl972 bool = l >= 0
	for yyj972 := 0; ; yyj972++ {
		if yyhl972 {
			if yyj972 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys972Slc = r.DecodeBytes(yys972Slc, true, true)
		yys972 := string(yys972Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys972 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int32(r.DecodeInt(32))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys972)
		} // end switch yys972
	} // end for yyj972
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj979 int
	var yyb979 bool
	var yyhl979 bool = l >= 0
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int32(r.DecodeInt(32))
	}
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj979++
	if yyhl979 {
		yyb979 = yyj979 > l
	} else {
		yyb979 = r.CheckBreak()
	}
	if yyb979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj979++
		if yyhl979 {
			yyb979 = yyj979 > l
		} else {
			yyb979 = r.CheckBreak()
		}
		if yyb979 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj979-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym986 := z.EncBinary()
		_ = yym986
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep987 := !z.EncBinary()
			yy2arr987 := z.EncBasicHandle().StructToArray
			var yyq987 [4]bool
			_, _, _ = yysep987, yyq987, yy2arr987
			const yyr987 bool = false
			yyq987[2] = x.FSType != ""
			yyq987[3] = x.ReadOnly != false
			var yynn987 int
			if yyr987 || yy2arr987 {
				r.EncodeArrayStart(4)
			} else {
				yynn987 = 2
				for _, b := range yyq987 {
					if b {
						yynn987++
					}
				}
				r.EncodeMapStart(yynn987)
				yynn987 = 0
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym989 := z.EncBinary()
					_ = yym989
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym990 := z.EncBinary()
					_ = yym990
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy992 := *x.Lun
					yym993 := z.EncBinary()
					_ = yym993
					if false {
					} else {
						r.EncodeInt(int64(yy992))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy994 := *x.Lun
					yym995 := z.EncBinary()
					_ = yym995
					if false {
					} else {
						r.EncodeInt(int64(yy994))
					}
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq987[2] {
					yym997 := z.EncBinary()
					_ = yym997
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq987[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym998 := z.EncBinary()
					_ = yym998
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq987[3] {
					yym1000 := z.EncBinary()
					_ = yym1000
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq987[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1001 := z.EncBinary()
					_ = yym1001
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr987 || yy2arr987 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1002 := z.DecBinary()
	_ = yym1002
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1003 := r.ContainerType()
		if yyct1003 == codecSelferValueTypeMap1234 {
			yyl1003 := r.ReadMapStart()
			if yyl1003 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1003, d)
			}
		} else if yyct1003 == codecSelferValueTypeArray1234 {
			yyl1003 := r.ReadArrayStart()
			if yyl1003 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1003, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1004Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1004Slc
	var yyhl1004 bool = l >= 0
	for yyj1004 := 0; ; yyj1004++ {
		if yyhl1004 {
			if yyj1004 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1004Slc = r.DecodeBytes(yys1004Slc, true, true)
		yys1004 := string(yys1004Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1004 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv1005 := &x.TargetWWNs
				yym1006 := z.DecBinary()
				_ = yym1006
				if false {
				} else {
					z.F.DecSliceStringX(yyv1005, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym1008 := z.DecBinary()
				_ = yym1008
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1004)
		} // end switch yys1004
	} // end for yyj1004
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1011 int
	var yyb1011 bool
	var yyhl1011 bool = l >= 0
	yyj1011++
	if yyhl1011 {
		yyb1011 = yyj1011 > l
	} else {
		yyb1011 = r.CheckBreak()
	}
	if yyb1011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv1012 := &x.TargetWWNs
		yym1013 := z.DecBinary()
		_ = yym1013
		if false {
		} else {
			z.F.DecSliceStringX(yyv1012, false, d)
		}
	}
	yyj1011++
	if yyhl1011 {
		yyb1011 = yyj1011 > l
	} else {
		yyb1011 = r.CheckBreak()
	}
	if yyb1011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym1015 := z.DecBinary()
		_ = yym1015
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj1011++
	if yyhl1011 {
		yyb1011 = yyj1011 > l
	} else {
		yyb1011 = r.CheckBreak()
	}
	if yyb1011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj1011++
	if yyhl1011 {
		yyb1011 = yyj1011 > l
	} else {
		yyb1011 = r.CheckBreak()
	}
	if yyb1011 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj1011++
		if yyhl1011 {
			yyb1011 = yyj1011 > l
		} else {
			yyb1011 = r.CheckBreak()
		}
		if yyb1011 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1011-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AzureFileVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1018 := z.EncBinary()
		_ = yym1018
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1019 := !z.EncBinary()
			yy2arr1019 := z.EncBasicHandle().StructToArray
			var yyq1019 [3]bool
			_, _, _ = yysep1019, yyq1019, yy2arr1019
			const yyr1019 bool = false
			yyq1019[2] = x.ReadOnly != false
			var yynn1019 int
			if yyr1019 || yy2arr1019 {
				r.EncodeArrayStart(3)
			} else {
				yynn1019 = 2
				for _, b := range yyq1019 {
					if b {
						yynn1019++
					}
				}
				r.EncodeMapStart(yynn1019)
				yynn1019 = 0
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1021 := z.EncBinary()
				_ = yym1021
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1022 := z.EncBinary()
				_ = yym1022
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1024 := z.EncBinary()
				_ = yym1024
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("shareName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1019[2] {
					yym1027 := z.EncBinary()
					_ = yym1027
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1019[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureFileVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1029 := z.DecBinary()
	_ = yym1029
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1030 := r.ContainerType()
		if yyct1030 == codecSelferValueTypeMap1234 {
			yyl1030 := r.ReadMapStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1030, d)
			}
		} else if yyct1030 == codecSelferValueTypeArray1234 {
			yyl1030 := r.ReadArrayStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1030, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1031Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1031Slc
	var yyhl1031 bool = l >= 0
	for yyj1031 := 0; ; yyj1031++ {
		if yyhl1031 {
			if yyj1031 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1031Slc = r.DecodeBytes(yys1031Slc, true, true)
		yys1031 := string(yys1031Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1031 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "shareName":
			if r.TryDecodeAsNil() {
				x.ShareName = ""
			} else {
				x.ShareName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1031)
		} // end switch yys1031
	} // end for yyj1031
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1035 int
	var yyb1035 bool
	var yyhl1035 bool = l >= 0
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ShareName = ""
	} else {
		x.ShareName = string(r.DecodeString())
	}
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj1035++
		if yyhl1035 {
			yyb1035 = yyj1035 > l
		} else {
			yyb1035 = r.CheckBreak()
		}
		if yyb1035 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1035-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1039 := z.EncBinary()
		_ = yym1039
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1040 := !z.EncBinary()
			yy2arr1040 := z.EncBasicHandle().StructToArray
			var yyq1040 [2]bool
			_, _, _ = yysep1040, yyq1040, yy2arr1040
			const yyr1040 bool = false
			yyq1040[1] = x.FSType != ""
			var yynn1040 int
			if yyr1040 || yy2arr1040 {
				r.EncodeArrayStart(2)
			} else {
				yynn1040 = 1
				for _, b := range yyq1040 {
					if b {
						yynn1040++
					}
				}
				r.EncodeMapStart(yynn1040)
				yynn1040 = 0
			}
			if yyr1040 || yy2arr1040 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1042 := z.EncBinary()
				_ = yym1042
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			}
			if yyr1040 || yy2arr1040 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1040[1] {
					yym1045 := z.EncBinary()
					_ = yym1045
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1040[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1046 := z.EncBinary()
					_ = yym1046
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1040 || yy2arr1040 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1047 := z.DecBinary()
	_ = yym1047
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1048 := r.ContainerType()
		if yyct1048 == codecSelferValueTypeMap1234 {
			yyl1048 := r.ReadMapStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1048, d)
			}
		} else if yyct1048 == codecSelferValueTypeArray1234 {
			yyl1048 := r.ReadArrayStart()
			if yyl1048 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1048, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1049Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1049Slc
	var yyhl1049 bool = l >= 0
	for yyj1049 := 0; ; yyj1049++ {
		if yyhl1049 {
			if yyj1049 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1049Slc = r.DecodeBytes(yys1049Slc, true, true)
		yys1049 := string(yys1049Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1049 {
		case "volumePath":
			if r.TryDecodeAsNil() {
				x.VolumePath = ""
			} else {
				x.VolumePath = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1049)
		} // end switch yys1049
	} // end for yyj1049
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1052 int
	var yyb1052 bool
	var yyhl1052 bool = l >= 0
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePath = ""
	} else {
		x.VolumePath = string(r.DecodeString())
	}
	yyj1052++
	if yyhl1052 {
		yyb1052 = yyj1052 > l
	} else {
		yyb1052 = r.CheckBreak()
	}
	if yyb1052 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1052++
		if yyhl1052 {
			yyb1052 = yyj1052 > l
		} else {
			yyb1052 = r.CheckBreak()
		}
		if yyb1052 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1052-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1055 := z.EncBinary()
		_ = yym1055
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1056 := !z.EncBinary()
			yy2arr1056 := z.EncBasicHandle().StructToArray
			var yyq1056 [2]bool
			_, _, _ = yysep1056, yyq1056, yy2arr1056
			const yyr1056 bool = false
			yyq1056[1] = x.FSType != ""
			var yynn1056 int
			if yyr1056 || yy2arr1056 {
				r.EncodeArrayStart(2)
			} else {
				yynn1056 = 1
				for _, b := range yyq1056 {
					if b {
						yynn1056++
					}
				}
				r.EncodeMapStart(yynn1056)
				yynn1056 = 0
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1058 := z.EncBinary()
				_ = yym1058
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1059 := z.EncBinary()
				_ = yym1059
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1056[1] {
					yym1061 := z.EncBinary()
					_ = yym1061
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1056[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1062 := z.EncBinary()
					_ = yym1062
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1056 || yy2arr1056 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1063 := z.DecBinary()
	_ = yym1063
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1064 := r.ContainerType()
		if yyct1064 == codecSelferValueTypeMap1234 {
			yyl1064 := r.ReadMapStart()
			if yyl1064 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1064, d)
			}
		} else if yyct1064 == codecSelferValueTypeArray1234 {
			yyl1064 := r.ReadArrayStart()
			if yyl1064 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1064, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1065Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1065Slc
	var yyhl1065 bool = l >= 0
	for yyj1065 := 0; ; yyj1065++ {
		if yyhl1065 {
			if yyj1065 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1065Slc = r.DecodeBytes(yys1065Slc, true, true)
		yys1065 := string(yys1065Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1065 {
		case "pdID":
			if r.TryDecodeAsNil() {
				x.PdID = ""
			} else {
				x.PdID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1065)
		} // end switch yys1065
	} // end for yyj1065
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1068 int
	var yyb1068 bool
	var yyhl1068 bool = l >= 0
	yyj1068++
	if yyhl1068 {
		yyb1068 = yyj1068 > l
	} else {
		yyb1068 = r.CheckBreak()
	}
	if yyb1068 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PdID = ""
	} else {
		x.PdID = string(r.DecodeString())
	}
	yyj1068++
	if yyhl1068 {
		yyb1068 = yyj1068 > l
	} else {
		yyb1068 = r.CheckBreak()
	}
	if yyb1068 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1068++
		if yyhl1068 {
			yyb1068 = yyj1068 > l
		} else {
			yyb1068 = r.CheckBreak()
		}
		if yyb1068 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1068-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x AzureDataDiskCachingMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1071 := z.EncBinary()
	_ = yym1071
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *AzureDataDiskCachingMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1072 := z.DecBinary()
	_ = yym1072
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AzureDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1073 := z.EncBinary()
		_ = yym1073
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1074 := !z.EncBinary()
			yy2arr1074 := z.EncBasicHandle().StructToArray
			var yyq1074 [5]bool
			_, _, _ = yysep1074, yyq1074, yy2arr1074
			const yyr1074 bool = false
			yyq1074[2] = x.CachingMode != nil
			yyq1074[3] = x.FSType != nil
			yyq1074[4] = x.ReadOnly != nil
			var yynn1074 int
			if yyr1074 || yy2arr1074 {
				r.EncodeArrayStart(5)
			} else {
				yynn1074 = 2
				for _, b := range yyq1074 {
					if b {
						yynn1074++
					}
				}
				r.EncodeMapStart(yynn1074)
				yynn1074 = 0
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1076 := z.EncBinary()
				_ = yym1076
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1077 := z.EncBinary()
				_ = yym1077
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1079 := z.EncBinary()
				_ = yym1079
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskURI"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1080 := z.EncBinary()
				_ = yym1080
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1074[2] {
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1082 := *x.CachingMode
						yy1082.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1074[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cachingMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1083 := *x.CachingMode
						yy1083.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1074[3] {
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1085 := *x.FSType
						yym1086 := z.EncBinary()
						_ = yym1086
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1085))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1074[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1087 := *x.FSType
						yym1088 := z.EncBinary()
						_ = yym1088
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1087))
						}
					}
				}
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1074[4] {
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1090 := *x.ReadOnly
						yym1091 := z.EncBinary()
						_ = yym1091
						if false {
						} else {
							r.EncodeBool(bool(yy1090))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1074[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1092 := *x.ReadOnly
						yym1093 := z.EncBinary()
						_ = yym1093
						if false {
						} else {
							r.EncodeBool(bool(yy1092))
						}
					}
				}
			}
			if yyr1074 || yy2arr1074 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1094 := z.DecBinary()
	_ = yym1094
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1095 := r.ContainerType()
		if yyct1095 == codecSelferValueTypeMap1234 {
			yyl1095 := r.ReadMapStart()
			if yyl1095 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1095, d)
			}
		} else if yyct1095 == codecSelferValueTypeArray1234 {
			yyl1095 := r.ReadArrayStart()
			if yyl1095 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1095, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1096Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1096Slc
	var yyhl1096 bool = l >= 0
	for yyj1096 := 0; ; yyj1096++ {
		if yyhl1096 {
			if yyj1096 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1096Slc = r.DecodeBytes(yys1096Slc, true, true)
		yys1096 := string(yys1096Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1096 {
		case "diskName":
			if r.TryDecodeAsNil() {
				x.DiskName = ""
			} else {
				x.DiskName = string(r.DecodeString())
			}
		case "diskURI":
			if r.TryDecodeAsNil() {
				x.DataDiskURI = ""
			} else {
				x.DataDiskURI = string(r.DecodeString())
			}
		case "cachingMode":
			if r.TryDecodeAsNil() {
				if x.CachingMode != nil {
					x.CachingMode = nil
				}
			} else {
				if x.CachingMode == nil {
					x.CachingMode = new(AzureDataDiskCachingMode)
				}
				x.CachingMode.CodecDecodeSelf(d)
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				if x.FSType != nil {
					x.FSType = nil
				}
			} else {
				if x.FSType == nil {
					x.FSType = new(string)
				}
				yym1101 := z.DecBinary()
				_ = yym1101
				if false {
				} else {
					*((*string)(x.FSType)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				if x.ReadOnly != nil {
					x.ReadOnly = nil
				}
			} else {
				if x.ReadOnly == nil {
					x.ReadOnly = new(bool)
				}
				yym1103 := z.DecBinary()
				_ = yym1103
				if false {
				} else {
					*((*bool)(x.ReadOnly)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1096)
		} // end switch yys1096
	} // end for yyj1096
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1104 int
	var yyb1104 bool
	var yyhl1104 bool = l >= 0
	yyj1104++
	if yyhl1104 {
		yyb1104 = yyj1104 > l
	} else {
		yyb1104 = r.CheckBreak()
	}
	if yyb1104 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DiskName = ""
	} else {
		x.DiskName = string(r.DecodeString())
	}
	yyj1104++
	if yyhl1104 {
		yyb1104 = yyj1104 > l
	} else {
		yyb1104 = r.CheckBreak()
	}
	if yyb1104 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DataDiskURI = ""
	} else {
		x.DataDiskURI = string(r.DecodeString())
	}
	yyj1104++
	if yyhl1104 {
		yyb1104 = yyj1104 > l
	} else {
		yyb1104 = r.CheckBreak()
	}
	if yyb1104 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CachingMode != nil {
			x.CachingMode = nil
		}
	} else {
		if x.CachingMode == nil {
			x.CachingMode = new(AzureDataDiskCachingMode)
		}
		x.CachingMode.CodecDecodeSelf(d)
	}
	yyj1104++
	if yyhl1104 {
		yyb1104 = yyj1104 > l
	} else {
		yyb1104 = r.CheckBreak()
	}
	if yyb1104 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSType != nil {
			x.FSType = nil
		}
	} else {
		if x.FSType == nil {
			x.FSType = new(string)
		}
		yym1109 := z.DecBinary()
		_ = yym1109
		if false {
		} else {
			*((*string)(x.FSType)) = r.DecodeString()
		}
	}
	yyj1104++
	if yyhl1104 {
		yyb1104 = yyj1104 > l
	} else {
		yyb1104 = r.CheckBreak()
	}
	if yyb1104 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadOnly != nil {
			x.ReadOnly = nil
		}
	} else {
		if x.ReadOnly == nil {
			x.ReadOnly = new(bool)
		}
		yym1111 := z.DecBinary()
		_ = yym1111
		if false {
		} else {
			*((*bool)(x.ReadOnly)) = r.DecodeBool()
		}
	}
	for {
		yyj1104++
		if yyhl1104 {
			yyb1104 = yyj1104 > l
		} else {
			yyb1104 = r.CheckBreak()
		}
		if yyb1104 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1104-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1112 := z.EncBinary()
		_ = yym1112
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1113 := !z.EncBinary()
			yy2arr1113 := z.EncBasicHandle().StructToArray
			var yyq1113 [3]bool
			_, _, _ = yysep1113, yyq1113, yy2arr1113
			const yyr1113 bool = false
			yyq1113[0] = x.Name != ""
			yyq1113[1] = len(x.Items) != 0
			yyq1113[2] = x.DefaultMode != nil
			var yynn1113 int
			if yyr1113 || yy2arr1113 {
				r.EncodeArrayStart(3)
			} else {
				yynn1113 = 0
				for _, b := range yyq1113 {
					if b {
						yynn1113++
					}
				}
				r.EncodeMapStart(yynn1113)
				yynn1113 = 0
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[0] {
					yym1115 := z.EncBinary()
					_ = yym1115
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1113[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1116 := z.EncBinary()
					_ = yym1116
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1118 := z.EncBinary()
						_ = yym1118
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1113[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1119 := z.EncBinary()
						_ = yym1119
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1121 := *x.DefaultMode
						yym1122 := z.EncBinary()
						_ = yym1122
						if false {
						} else {
							r.EncodeInt(int64(yy1121))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1113[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1123 := *x.DefaultMode
						yym1124 := z.EncBinary()
						_ = yym1124
						if false {
						} else {
							r.EncodeInt(int64(yy1123))
						}
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1125 := z.DecBinary()
	_ = yym1125
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1126 := r.ContainerType()
		if yyct1126 == codecSelferValueTypeMap1234 {
			yyl1126 := r.ReadMapStart()
			if yyl1126 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1126, d)
			}
		} else if yyct1126 == codecSelferValueTypeArray1234 {
			yyl1126 := r.ReadArrayStart()
			if yyl1126 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1126, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1127Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1127Slc
	var yyhl1127 bool = l >= 0
	for yyj1127 := 0; ; yyj1127++ {
		if yyhl1127 {
			if yyj1127 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1127Slc = r.DecodeBytes(yys1127Slc, true, true)
		yys1127 := string(yys1127Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1127 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1129 := &x.Items
				yym1130 := z.DecBinary()
				_ = yym1130
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv1129), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1132 := z.DecBinary()
				_ = yym1132
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1127)
		} // end switch yys1127
	} // end for yyj1127
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1133 int
	var yyb1133 bool
	var yyhl1133 bool = l >= 0
	yyj1133++
	if yyhl1133 {
		yyb1133 = yyj1133 > l
	} else {
		yyb1133 = r.CheckBreak()
	}
	if yyb1133 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1133++
	if yyhl1133 {
		yyb1133 = yyj1133 > l
	} else {
		yyb1133 = r.CheckBreak()
	}
	if yyb1133 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1135 := &x.Items
		yym1136 := z.DecBinary()
		_ = yym1136
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv1135), d)
		}
	}
	yyj1133++
	if yyhl1133 {
		yyb1133 = yyj1133 > l
	} else {
		yyb1133 = r.CheckBreak()
	}
	if yyb1133 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1138 := z.DecBinary()
		_ = yym1138
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1133++
		if yyhl1133 {
			yyb1133 = yyj1133 > l
		} else {
			yyb1133 = r.CheckBreak()
		}
		if yyb1133 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1133-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KeyToPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1139 := z.EncBinary()
		_ = yym1139
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1140 := !z.EncBinary()
			yy2arr1140 := z.EncBasicHandle().StructToArray
			var yyq1140 [3]bool
			_, _, _ = yysep1140, yyq1140, yy2arr1140
			const yyr1140 bool = false
			yyq1140[2] = x.Mode != nil
			var yynn1140 int
			if yyr1140 || yy2arr1140 {
				r.EncodeArrayStart(3)
			} else {
				yynn1140 = 2
				for _, b := range yyq1140 {
					if b {
						yynn1140++
					}
				}
				r.EncodeMapStart(yynn1140)
				yynn1140 = 0
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1142 := z.EncBinary()
				_ = yym1142
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1143 := z.EncBinary()
				_ = yym1143
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1145 := z.EncBinary()
				_ = yym1145
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1146 := z.EncBinary()
				_ = yym1146
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1140[2] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1148 := *x.Mode
						yym1149 := z.EncBinary()
						_ = yym1149
						if false {
						} else {
							r.EncodeInt(int64(yy1148))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1140[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1150 := *x.Mode
						yym1151 := z.EncBinary()
						_ = yym1151
						if false {
						} else {
							r.EncodeInt(int64(yy1150))
						}
					}
				}
			}
			if yyr1140 || yy2arr1140 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KeyToPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1152 := z.DecBinary()
	_ = yym1152
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1153 := r.ContainerType()
		if yyct1153 == codecSelferValueTypeMap1234 {
			yyl1153 := r.ReadMapStart()
			if yyl1153 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1153, d)
			}
		} else if yyct1153 == codecSelferValueTypeArray1234 {
			yyl1153 := r.ReadArrayStart()
			if yyl1153 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1153, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KeyToPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1154Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1154Slc
	var yyhl1154 bool = l >= 0
	for yyj1154 := 0; ; yyj1154++ {
		if yyhl1154 {
			if yyj1154 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1154Slc = r.DecodeBytes(yys1154Slc, true, true)
		yys1154 := string(yys1154Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1154 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1158 := z.DecBinary()
				_ = yym1158
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1154)
		} // end switch yys1154
	} // end for yyj1154
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KeyToPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1159 int
	var yyb1159 bool
	var yyhl1159 bool = l >= 0
	yyj1159++
	if yyhl1159 {
		yyb1159 = yyj1159 > l
	} else {
		yyb1159 = r.CheckBreak()
	}
	if yyb1159 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1159++
	if yyhl1159 {
		yyb1159 = yyj1159 > l
	} else {
		yyb1159 = r.CheckBreak()
	}
	if yyb1159 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1159++
	if yyhl1159 {
		yyb1159 = yyj1159 > l
	} else {
		yyb1159 = r.CheckBreak()
	}
	if yyb1159 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1163 := z.DecBinary()
		_ = yym1163
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1159++
		if yyhl1159 {
			yyb1159 = yyj1159 > l
		} else {
			yyb1159 = r.CheckBreak()
		}
		if yyb1159 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1159-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1164 := z.EncBinary()
		_ = yym1164
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1165 := !z.EncBinary()
			yy2arr1165 := z.EncBasicHandle().StructToArray
			var yyq1165 [5]bool
			_, _, _ = yysep1165, yyq1165, yy2arr1165
			const yyr1165 bool = false
			yyq1165[0] = x.Name != ""
			yyq1165[1] = x.HostPort != 0
			yyq1165[3] = x.Protocol != ""
			yyq1165[4] = x.HostIP != ""
			var yynn1165 int
			if yyr1165 || yy2arr1165 {
				r.EncodeArrayStart(5)
			} else {
				yynn1165 = 1
				for _, b := range yyq1165 {
					if b {
						yynn1165++
					}
				}
				r.EncodeMapStart(yynn1165)
				yynn1165 = 0
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1165[0] {
					yym1167 := z.EncBinary()
					_ = yym1167
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1165[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1168 := z.EncBinary()
					_ = yym1168
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1165[1] {
					yym1170 := z.EncBinary()
					_ = yym1170
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1165[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1171 := z.EncBinary()
					_ = yym1171
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1173 := z.EncBinary()
				_ = yym1173
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1174 := z.EncBinary()
				_ = yym1174
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1165[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1165[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1165[4] {
					yym1177 := z.EncBinary()
					_ = yym1177
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1165[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1178 := z.EncBinary()
					_ = yym1178
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1179 := z.DecBinary()
	_ = yym1179
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1180 := r.ContainerType()
		if yyct1180 == codecSelferValueTypeMap1234 {
			yyl1180 := r.ReadMapStart()
			if yyl1180 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1180, d)
			}
		} else if yyct1180 == codecSelferValueTypeArray1234 {
			yyl1180 := r.ReadArrayStart()
			if yyl1180 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1180, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1181Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1181Slc
	var yyhl1181 bool = l >= 0
	for yyj1181 := 0; ; yyj1181++ {
		if yyhl1181 {
			if yyj1181 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1181Slc = r.DecodeBytes(yys1181Slc, true, true)
		yys1181 := string(yys1181Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1181 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int32(r.DecodeInt(32))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1181)
		} // end switch yys1181
	} // end for yyj1181
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1187 int
	var yyb1187 bool
	var yyhl1187 bool = l >= 0
	yyj1187++
	if yyhl1187 {
		yyb1187 = yyj1187 > l
	} else {
		yyb1187 = r.CheckBreak()
	}
	if yyb1187 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1187++
	if yyhl1187 {
		yyb1187 = yyj1187 > l
	} else {
		yyb1187 = r.CheckBreak()
	}
	if yyb1187 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int32(r.DecodeInt(32))
	}
	yyj1187++
	if yyhl1187 {
		yyb1187 = yyj1187 > l
	} else {
		yyb1187 = r.CheckBreak()
	}
	if yyb1187 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int32(r.DecodeInt(32))
	}
	yyj1187++
	if yyhl1187 {
		yyb1187 = yyj1187 > l
	} else {
		yyb1187 = r.CheckBreak()
	}
	if yyb1187 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj1187++
	if yyhl1187 {
		yyb1187 = yyj1187 > l
	} else {
		yyb1187 = r.CheckBreak()
	}
	if yyb1187 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj1187++
		if yyhl1187 {
			yyb1187 = yyj1187 > l
		} else {
			yyb1187 = r.CheckBreak()
		}
		if yyb1187 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1187-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1193 := z.EncBinary()
		_ = yym1193
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1194 := !z.EncBinary()
			yy2arr1194 := z.EncBasicHandle().StructToArray
			var yyq1194 [4]bool
			_, _, _ = yysep1194, yyq1194, yy2arr1194
			const yyr1194 bool = false
			yyq1194[1] = x.ReadOnly != false
			yyq1194[3] = x.SubPath != ""
			var yynn1194 int
			if yyr1194 || yy2arr1194 {
				r.EncodeArrayStart(4)
			} else {
				yynn1194 = 2
				for _, b := range yyq1194 {
					if b {
						yynn1194++
					}
				}
				r.EncodeMapStart(yynn1194)
				yynn1194 = 0
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1196 := z.EncBinary()
				_ = yym1196
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1197 := z.EncBinary()
				_ = yym1197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1194[1] {
					yym1199 := z.EncBinary()
					_ = yym1199
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1194[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1200 := z.EncBinary()
					_ = yym1200
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1202 := z.EncBinary()
				_ = yym1202
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1203 := z.EncBinary()
				_ = yym1203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1194[3] {
					yym1205 := z.EncBinary()
					_ = yym1205
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1194[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1206 := z.EncBinary()
					_ = yym1206
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				}
			}
			if yyr1194 || yy2arr1194 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1207 := z.DecBinary()
	_ = yym1207
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1208 := r.ContainerType()
		if yyct1208 == codecSelferValueTypeMap1234 {
			yyl1208 := r.ReadMapStart()
			if yyl1208 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1208, d)
			}
		} else if yyct1208 == codecSelferValueTypeArray1234 {
			yyl1208 := r.ReadArrayStart()
			if yyl1208 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1208, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1209Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1209Slc
	var yyhl1209 bool = l >= 0
	for yyj1209 := 0; ; yyj1209++ {
		if yyhl1209 {
			if yyj1209 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1209Slc = r.DecodeBytes(yys1209Slc, true, true)
		yys1209 := string(yys1209Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1209 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		case "subPath":
			if r.TryDecodeAsNil() {
				x.SubPath = ""
			} else {
				x.SubPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1209)
		} // end switch yys1209
	} // end for yyj1209
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1214 int
	var yyb1214 bool
	var yyhl1214 bool = l >= 0
	yyj1214++
	if yyhl1214 {
		yyb1214 = yyj1214 > l
	} else {
		yyb1214 = r.CheckBreak()
	}
	if yyb1214 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1214++
	if yyhl1214 {
		yyb1214 = yyj1214 > l
	} else {
		yyb1214 = r.CheckBreak()
	}
	if yyb1214 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj1214++
	if yyhl1214 {
		yyb1214 = yyj1214 > l
	} else {
		yyb1214 = r.CheckBreak()
	}
	if yyb1214 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	yyj1214++
	if yyhl1214 {
		yyb1214 = yyj1214 > l
	} else {
		yyb1214 = r.CheckBreak()
	}
	if yyb1214 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SubPath = ""
	} else {
		x.SubPath = string(r.DecodeString())
	}
	for {
		yyj1214++
		if yyhl1214 {
			yyb1214 = yyj1214 > l
		} else {
			yyb1214 = r.CheckBreak()
		}
		if yyb1214 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1214-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1219 := z.EncBinary()
		_ = yym1219
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1220 := !z.EncBinary()
			yy2arr1220 := z.EncBasicHandle().StructToArray
			var yyq1220 [3]bool
			_, _, _ = yysep1220, yyq1220, yy2arr1220
			const yyr1220 bool = false
			yyq1220[1] = x.Value != ""
			yyq1220[2] = x.ValueFrom != nil
			var yynn1220 int
			if yyr1220 || yy2arr1220 {
				r.EncodeArrayStart(3)
			} else {
				yynn1220 = 1
				for _, b := range yyq1220 {
					if b {
						yynn1220++
					}
				}
				r.EncodeMapStart(yynn1220)
				yynn1220 = 0
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1222 := z.EncBinary()
				_ = yym1222
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1223 := z.EncBinary()
				_ = yym1223
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1220[1] {
					yym1225 := z.EncBinary()
					_ = yym1225
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1220[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1226 := z.EncBinary()
					_ = yym1226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1220[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1220[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1228 := z.DecBinary()
	_ = yym1228
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1229 := r.ContainerType()
		if yyct1229 == codecSelferValueTypeMap1234 {
			yyl1229 := r.ReadMapStart()
			if yyl1229 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1229, d)
			}
		} else if yyct1229 == codecSelferValueTypeArray1234 {
			yyl1229 := r.ReadArrayStart()
			if yyl1229 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1229, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1230Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1230Slc
	var yyhl1230 bool = l >= 0
	for yyj1230 := 0; ; yyj1230++ {
		if yyhl1230 {
			if yyj1230 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1230Slc = r.DecodeBytes(yys1230Slc, true, true)
		yys1230 := string(yys1230Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1230 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1230)
		} // end switch yys1230
	} // end for yyj1230
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1234 int
	var yyb1234 bool
	var yyhl1234 bool = l >= 0
	yyj1234++
	if yyhl1234 {
		yyb1234 = yyj1234 > l
	} else {
		yyb1234 = r.CheckBreak()
	}
	if yyb1234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1234++
	if yyhl1234 {
		yyb1234 = yyj1234 > l
	} else {
		yyb1234 = r.CheckBreak()
	}
	if yyb1234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1234++
	if yyhl1234 {
		yyb1234 = yyj1234 > l
	} else {
		yyb1234 = r.CheckBreak()
	}
	if yyb1234 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj1234++
		if yyhl1234 {
			yyb1234 = yyj1234 > l
		} else {
			yyb1234 = r.CheckBreak()
		}
		if yyb1234 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1234-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1238 := z.EncBinary()
		_ = yym1238
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1239 := !z.EncBinary()
			yy2arr1239 := z.EncBasicHandle().StructToArray
			var yyq1239 [4]bool
			_, _, _ = yysep1239, yyq1239, yy2arr1239
			const yyr1239 bool = false
			yyq1239[0] = x.FieldRef != nil
			yyq1239[1] = x.ResourceFieldRef != nil
			yyq1239[2] = x.ConfigMapKeyRef != nil
			yyq1239[3] = x.SecretKeyRef != nil
			var yynn1239 int
			if yyr1239 || yy2arr1239 {
				r.EncodeArrayStart(4)
			} else {
				yynn1239 = 0
				for _, b := range yyq1239 {
					if b {
						yynn1239++
					}
				}
				r.EncodeMapStart(yynn1239)
				yynn1239 = 0
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1239[0] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1239[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1239[1] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1239[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1239[2] {
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1239[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1239[3] {
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1239[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1239 || yy2arr1239 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1244 := z.DecBinary()
	_ = yym1244
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1245 := r.ContainerType()
		if yyct1245 == codecSelferValueTypeMap1234 {
			yyl1245 := r.ReadMapStart()
			if yyl1245 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1245, d)
			}
		} else if yyct1245 == codecSelferValueTypeArray1234 {
			yyl1245 := r.ReadArrayStart()
			if yyl1245 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1245, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1246Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1246Slc
	var yyhl1246 bool = l >= 0
	for yyj1246 := 0; ; yyj1246++ {
		if yyhl1246 {
			if yyj1246 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1246Slc = r.DecodeBytes(yys1246Slc, true, true)
		yys1246 := string(yys1246Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1246 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "configMapKeyRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapKeyRef != nil {
					x.ConfigMapKeyRef = nil
				}
			} else {
				if x.ConfigMapKeyRef == nil {
					x.ConfigMapKeyRef = new(ConfigMapKeySelector)
				}
				x.ConfigMapKeyRef.CodecDecodeSelf(d)
			}
		case "secretKeyRef":
			if r.TryDecodeAsNil() {
				if x.SecretKeyRef != nil {
					x.SecretKeyRef = nil
				}
			} else {
				if x.SecretKeyRef == nil {
					x.SecretKeyRef = new(SecretKeySelector)
				}
				x.SecretKeyRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1246)
		} // end switch yys1246
	} // end for yyj1246
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1251 int
	var yyb1251 bool
	var yyhl1251 bool = l >= 0
	yyj1251++
	if yyhl1251 {
		yyb1251 = yyj1251 > l
	} else {
		yyb1251 = r.CheckBreak()
	}
	if yyb1251 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1251++
	if yyhl1251 {
		yyb1251 = yyj1251 > l
	} else {
		yyb1251 = r.CheckBreak()
	}
	if yyb1251 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1251++
	if yyhl1251 {
		yyb1251 = yyj1251 > l
	} else {
		yyb1251 = r.CheckBreak()
	}
	if yyb1251 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapKeyRef != nil {
			x.ConfigMapKeyRef = nil
		}
	} else {
		if x.ConfigMapKeyRef == nil {
			x.ConfigMapKeyRef = new(ConfigMapKeySelector)
		}
		x.ConfigMapKeyRef.CodecDecodeSelf(d)
	}
	yyj1251++
	if yyhl1251 {
		yyb1251 = yyj1251 > l
	} else {
		yyb1251 = r.CheckBreak()
	}
	if yyb1251 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretKeyRef != nil {
			x.SecretKeyRef = nil
		}
	} else {
		if x.SecretKeyRef == nil {
			x.SecretKeyRef = new(SecretKeySelector)
		}
		x.SecretKeyRef.CodecDecodeSelf(d)
	}
	for {
		yyj1251++
		if yyhl1251 {
			yyb1251 = yyj1251 > l
		} else {
			yyb1251 = r.CheckBreak()
		}
		if yyb1251 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1251-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1256 := z.EncBinary()
		_ = yym1256
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1257 := !z.EncBinary()
			yy2arr1257 := z.EncBasicHandle().StructToArray
			var yyq1257 [2]bool
			_, _, _ = yysep1257, yyq1257, yy2arr1257
			const yyr1257 bool = false
			yyq1257[0] = x.APIVersion != ""
			var yynn1257 int
			if yyr1257 || yy2arr1257 {
				r.EncodeArrayStart(2)
			} else {
				yynn1257 = 1
				for _, b := range yyq1257 {
					if b {
						yynn1257++
					}
				}
				r.EncodeMapStart(yynn1257)
				yynn1257 = 0
			}
			if yyr1257 || yy2arr1257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1257[0] {
					yym1259 := z.EncBinary()
					_ = yym1259
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1257[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1260 := z.EncBinary()
					_ = yym1260
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1257 || yy2arr1257 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1262 := z.EncBinary()
				_ = yym1262
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1263 := z.EncBinary()
				_ = yym1263
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr1257 || yy2arr1257 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1264 := z.DecBinary()
	_ = yym1264
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1265 := r.ContainerType()
		if yyct1265 == codecSelferValueTypeMap1234 {
			yyl1265 := r.ReadMapStart()
			if yyl1265 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1265, d)
			}
		} else if yyct1265 == codecSelferValueTypeArray1234 {
			yyl1265 := r.ReadArrayStart()
			if yyl1265 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1265, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1266Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1266Slc
	var yyhl1266 bool = l >= 0
	for yyj1266 := 0; ; yyj1266++ {
		if yyhl1266 {
			if yyj1266 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1266Slc = r.DecodeBytes(yys1266Slc, true, true)
		yys1266 := string(yys1266Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1266 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1266)
		} // end switch yys1266
	} // end for yyj1266
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1269 int
	var yyb1269 bool
	var yyhl1269 bool = l >= 0
	yyj1269++
	if yyhl1269 {
		yyb1269 = yyj1269 > l
	} else {
		yyb1269 = r.CheckBreak()
	}
	if yyb1269 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1269++
	if yyhl1269 {
		yyb1269 = yyj1269 > l
	} else {
		yyb1269 = r.CheckBreak()
	}
	if yyb1269 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj1269++
		if yyhl1269 {
			yyb1269 = yyj1269 > l
		} else {
			yyb1269 = r.CheckBreak()
		}
		if yyb1269 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1269-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1272 := z.EncBinary()
		_ = yym1272
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1273 := !z.EncBinary()
			yy2arr1273 := z.EncBasicHandle().StructToArray
			var yyq1273 [3]bool
			_, _, _ = yysep1273, yyq1273, yy2arr1273
			const yyr1273 bool = false
			yyq1273[0] = x.ContainerName != ""
			yyq1273[2] = true
			var yynn1273 int
			if yyr1273 || yy2arr1273 {
				r.EncodeArrayStart(3)
			} else {
				yynn1273 = 1
				for _, b := range yyq1273 {
					if b {
						yynn1273++
					}
				}
				r.EncodeMapStart(yynn1273)
				yynn1273 = 0
			}
			if yyr1273 || yy2arr1273 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1273[0] {
					yym1275 := z.EncBinary()
					_ = yym1275
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1273[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1276 := z.EncBinary()
					_ = yym1276
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				}
			}
			if yyr1273 || yy2arr1273 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1278 := z.EncBinary()
				_ = yym1278
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1279 := z.EncBinary()
				_ = yym1279
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr1273 || yy2arr1273 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1273[2] {
					yy1281 := &x.Divisor
					yym1282 := z.EncBinary()
					_ = yym1282
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1281) {
					} else if !yym1282 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1281)
					} else {
						z.EncFallback(yy1281)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1273[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("divisor"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1283 := &x.Divisor
					yym1284 := z.EncBinary()
					_ = yym1284
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1283) {
					} else if !yym1284 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1283)
					} else {
						z.EncFallback(yy1283)
					}
				}
			}
			if yyr1273 || yy2arr1273 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1285 := z.DecBinary()
	_ = yym1285
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1286 := r.ContainerType()
		if yyct1286 == codecSelferValueTypeMap1234 {
			yyl1286 := r.ReadMapStart()
			if yyl1286 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1286, d)
			}
		} else if yyct1286 == codecSelferValueTypeArray1234 {
			yyl1286 := r.ReadArrayStart()
			if yyl1286 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1286, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1287Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1287Slc
	var yyhl1287 bool = l >= 0
	for yyj1287 := 0; ; yyj1287++ {
		if yyhl1287 {
			if yyj1287 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1287Slc = r.DecodeBytes(yys1287Slc, true, true)
		yys1287 := string(yys1287Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1287 {
		case "containerName":
			if r.TryDecodeAsNil() {
				x.ContainerName = ""
			} else {
				x.ContainerName = string(r.DecodeString())
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "divisor":
			if r.TryDecodeAsNil() {
				x.Divisor = pkg3_resource.Quantity{}
			} else {
				yyv1290 := &x.Divisor
				yym1291 := z.DecBinary()
				_ = yym1291
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1290) {
				} else if !yym1291 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1290)
				} else {
					z.DecFallback(yyv1290, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1287)
		} // end switch yys1287
	} // end for yyj1287
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1292 int
	var yyb1292 bool
	var yyhl1292 bool = l >= 0
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerName = ""
	} else {
		x.ContainerName = string(r.DecodeString())
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj1292++
	if yyhl1292 {
		yyb1292 = yyj1292 > l
	} else {
		yyb1292 = r.CheckBreak()
	}
	if yyb1292 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Divisor = pkg3_resource.Quantity{}
	} else {
		yyv1295 := &x.Divisor
		yym1296 := z.DecBinary()
		_ = yym1296
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1295) {
		} else if !yym1296 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1295)
		} else {
			z.DecFallback(yyv1295, false)
		}
	}
	for {
		yyj1292++
		if yyhl1292 {
			yyb1292 = yyj1292 > l
		} else {
			yyb1292 = r.CheckBreak()
		}
		if yyb1292 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1292-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1297 := z.EncBinary()
		_ = yym1297
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1298 := !z.EncBinary()
			yy2arr1298 := z.EncBasicHandle().StructToArray
			var yyq1298 [2]bool
			_, _, _ = yysep1298, yyq1298, yy2arr1298
			const yyr1298 bool = false
			yyq1298[0] = x.Name != ""
			var yynn1298 int
			if yyr1298 || yy2arr1298 {
				r.EncodeArrayStart(2)
			} else {
				yynn1298 = 1
				for _, b := range yyq1298 {
					if b {
						yynn1298++
					}
				}
				r.EncodeMapStart(yynn1298)
				yynn1298 = 0
			}
			if yyr1298 || yy2arr1298 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1298[0] {
					yym1300 := z.EncBinary()
					_ = yym1300
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1298[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1301 := z.EncBinary()
					_ = yym1301
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1298 || yy2arr1298 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1303 := z.EncBinary()
				_ = yym1303
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1304 := z.EncBinary()
				_ = yym1304
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1298 || yy2arr1298 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1305 := z.DecBinary()
	_ = yym1305
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1306 := r.ContainerType()
		if yyct1306 == codecSelferValueTypeMap1234 {
			yyl1306 := r.ReadMapStart()
			if yyl1306 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1306, d)
			}
		} else if yyct1306 == codecSelferValueTypeArray1234 {
			yyl1306 := r.ReadArrayStart()
			if yyl1306 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1306, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1307Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1307Slc
	var yyhl1307 bool = l >= 0
	for yyj1307 := 0; ; yyj1307++ {
		if yyhl1307 {
			if yyj1307 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1307Slc = r.DecodeBytes(yys1307Slc, true, true)
		yys1307 := string(yys1307Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1307 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1307)
		} // end switch yys1307
	} // end for yyj1307
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1310 int
	var yyb1310 bool
	var yyhl1310 bool = l >= 0
	yyj1310++
	if yyhl1310 {
		yyb1310 = yyj1310 > l
	} else {
		yyb1310 = r.CheckBreak()
	}
	if yyb1310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1310++
	if yyhl1310 {
		yyb1310 = yyj1310 > l
	} else {
		yyb1310 = r.CheckBreak()
	}
	if yyb1310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1310++
		if yyhl1310 {
			yyb1310 = yyj1310 > l
		} else {
			yyb1310 = r.CheckBreak()
		}
		if yyb1310 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1310-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1313 := z.EncBinary()
		_ = yym1313
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1314 := !z.EncBinary()
			yy2arr1314 := z.EncBasicHandle().StructToArray
			var yyq1314 [2]bool
			_, _, _ = yysep1314, yyq1314, yy2arr1314
			const yyr1314 bool = false
			yyq1314[0] = x.Name != ""
			var yynn1314 int
			if yyr1314 || yy2arr1314 {
				r.EncodeArrayStart(2)
			} else {
				yynn1314 = 1
				for _, b := range yyq1314 {
					if b {
						yynn1314++
					}
				}
				r.EncodeMapStart(yynn1314)
				yynn1314 = 0
			}
			if yyr1314 || yy2arr1314 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1314[0] {
					yym1316 := z.EncBinary()
					_ = yym1316
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1314[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1317 := z.EncBinary()
					_ = yym1317
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1314 || yy2arr1314 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1319 := z.EncBinary()
				_ = yym1319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1320 := z.EncBinary()
				_ = yym1320
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1314 || yy2arr1314 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1321 := z.DecBinary()
	_ = yym1321
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1322 := r.ContainerType()
		if yyct1322 == codecSelferValueTypeMap1234 {
			yyl1322 := r.ReadMapStart()
			if yyl1322 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1322, d)
			}
		} else if yyct1322 == codecSelferValueTypeArray1234 {
			yyl1322 := r.ReadArrayStart()
			if yyl1322 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1322, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1323Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1323Slc
	var yyhl1323 bool = l >= 0
	for yyj1323 := 0; ; yyj1323++ {
		if yyhl1323 {
			if yyj1323 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1323Slc = r.DecodeBytes(yys1323Slc, true, true)
		yys1323 := string(yys1323Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1323 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1323)
		} // end switch yys1323
	} // end for yyj1323
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1326 int
	var yyb1326 bool
	var yyhl1326 bool = l >= 0
	yyj1326++
	if yyhl1326 {
		yyb1326 = yyj1326 > l
	} else {
		yyb1326 = r.CheckBreak()
	}
	if yyb1326 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1326++
	if yyhl1326 {
		yyb1326 = yyj1326 > l
	} else {
		yyb1326 = r.CheckBreak()
	}
	if yyb1326 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1326++
		if yyhl1326 {
			yyb1326 = yyj1326 > l
		} else {
			yyb1326 = r.CheckBreak()
		}
		if yyb1326 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1326-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPHeader) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1329 := z.EncBinary()
		_ = yym1329
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1330 := !z.EncBinary()
			yy2arr1330 := z.EncBasicHandle().StructToArray
			var yyq1330 [2]bool
			_, _, _ = yysep1330, yyq1330, yy2arr1330
			const yyr1330 bool = false
			var yynn1330 int
			if yyr1330 || yy2arr1330 {
				r.EncodeArrayStart(2)
			} else {
				yynn1330 = 2
				for _, b := range yyq1330 {
					if b {
						yynn1330++
					}
				}
				r.EncodeMapStart(yynn1330)
				yynn1330 = 0
			}
			if yyr1330 || yy2arr1330 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1332 := z.EncBinary()
				_ = yym1332
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1333 := z.EncBinary()
				_ = yym1333
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1330 || yy2arr1330 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1335 := z.EncBinary()
				_ = yym1335
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1336 := z.EncBinary()
				_ = yym1336
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr1330 || yy2arr1330 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPHeader) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1337 := z.DecBinary()
	_ = yym1337
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1338 := r.ContainerType()
		if yyct1338 == codecSelferValueTypeMap1234 {
			yyl1338 := r.ReadMapStart()
			if yyl1338 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1338, d)
			}
		} else if yyct1338 == codecSelferValueTypeArray1234 {
			yyl1338 := r.ReadArrayStart()
			if yyl1338 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1338, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPHeader) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1339Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1339Slc
	var yyhl1339 bool = l >= 0
	for yyj1339 := 0; ; yyj1339++ {
		if yyhl1339 {
			if yyj1339 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1339Slc = r.DecodeBytes(yys1339Slc, true, true)
		yys1339 := string(yys1339Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1339 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1339)
		} // end switch yys1339
	} // end for yyj1339
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPHeader) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1342 int
	var yyb1342 bool
	var yyhl1342 bool = l >= 0
	yyj1342++
	if yyhl1342 {
		yyb1342 = yyj1342 > l
	} else {
		yyb1342 = r.CheckBreak()
	}
	if yyb1342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1342++
	if yyhl1342 {
		yyb1342 = yyj1342 > l
	} else {
		yyb1342 = r.CheckBreak()
	}
	if yyb1342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj1342++
		if yyhl1342 {
			yyb1342 = yyj1342 > l
		} else {
			yyb1342 = r.CheckBreak()
		}
		if yyb1342 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1342-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1345 := z.EncBinary()
		_ = yym1345
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1346 := !z.EncBinary()
			yy2arr1346 := z.EncBasicHandle().StructToArray
			var yyq1346 [5]bool
			_, _, _ = yysep1346, yyq1346, yy2arr1346
			const yyr1346 bool = false
			yyq1346[0] = x.Path != ""
			yyq1346[2] = x.Host != ""
			yyq1346[3] = x.Scheme != ""
			yyq1346[4] = len(x.HTTPHeaders) != 0
			var yynn1346 int
			if yyr1346 || yy2arr1346 {
				r.EncodeArrayStart(5)
			} else {
				yynn1346 = 1
				for _, b := range yyq1346 {
					if b {
						yynn1346++
					}
				}
				r.EncodeMapStart(yynn1346)
				yynn1346 = 0
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1346[0] {
					yym1348 := z.EncBinary()
					_ = yym1348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1346[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1349 := z.EncBinary()
					_ = yym1349
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1351 := &x.Port
				yym1352 := z.EncBinary()
				_ = yym1352
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1351) {
				} else if !yym1352 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1351)
				} else {
					z.EncFallback(yy1351)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1353 := &x.Port
				yym1354 := z.EncBinary()
				_ = yym1354
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1353) {
				} else if !yym1354 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1353)
				} else {
					z.EncFallback(yy1353)
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1346[2] {
					yym1356 := z.EncBinary()
					_ = yym1356
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1346[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1357 := z.EncBinary()
					_ = yym1357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1346[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1346[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1346[4] {
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1360 := z.EncBinary()
						_ = yym1360
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1346[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpHeaders"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1361 := z.EncBinary()
						_ = yym1361
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1362 := z.DecBinary()
	_ = yym1362
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1363 := r.ContainerType()
		if yyct1363 == codecSelferValueTypeMap1234 {
			yyl1363 := r.ReadMapStart()
			if yyl1363 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1363, d)
			}
		} else if yyct1363 == codecSelferValueTypeArray1234 {
			yyl1363 := r.ReadArrayStart()
			if yyl1363 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1363, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1364Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1364Slc
	var yyhl1364 bool = l >= 0
	for yyj1364 := 0; ; yyj1364++ {
		if yyhl1364 {
			if yyj1364 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1364Slc = r.DecodeBytes(yys1364Slc, true, true)
		yys1364 := string(yys1364Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1364 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1366 := &x.Port
				yym1367 := z.DecBinary()
				_ = yym1367
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1366) {
				} else if !yym1367 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1366)
				} else {
					z.DecFallback(yyv1366, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		case "httpHeaders":
			if r.TryDecodeAsNil() {
				x.HTTPHeaders = nil
			} else {
				yyv1370 := &x.HTTPHeaders
				yym1371 := z.DecBinary()
				_ = yym1371
				if false {
				} else {
					h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1370), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1364)
		} // end switch yys1364
	} // end for yyj1364
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1372 int
	var yyb1372 bool
	var yyhl1372 bool = l >= 0
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1374 := &x.Port
		yym1375 := z.DecBinary()
		_ = yym1375
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1374) {
		} else if !yym1375 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1374)
		} else {
			z.DecFallback(yyv1374, false)
		}
	}
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPHeaders = nil
	} else {
		yyv1378 := &x.HTTPHeaders
		yym1379 := z.DecBinary()
		_ = yym1379
		if false {
		} else {
			h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1378), d)
		}
	}
	for {
		yyj1372++
		if yyhl1372 {
			yyb1372 = yyj1372 > l
		} else {
			yyb1372 = r.CheckBreak()
		}
		if yyb1372 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1372-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1380 := z.EncBinary()
	_ = yym1380
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1381 := z.DecBinary()
	_ = yym1381
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1382 := z.EncBinary()
		_ = yym1382
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1383 := !z.EncBinary()
			yy2arr1383 := z.EncBasicHandle().StructToArray
			var yyq1383 [1]bool
			_, _, _ = yysep1383, yyq1383, yy2arr1383
			const yyr1383 bool = false
			var yynn1383 int
			if yyr1383 || yy2arr1383 {
				r.EncodeArrayStart(1)
			} else {
				yynn1383 = 1
				for _, b := range yyq1383 {
					if b {
						yynn1383++
					}
				}
				r.EncodeMapStart(yynn1383)
				yynn1383 = 0
			}
			if yyr1383 || yy2arr1383 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1385 := &x.Port
				yym1386 := z.EncBinary()
				_ = yym1386
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1385) {
				} else if !yym1386 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1385)
				} else {
					z.EncFallback(yy1385)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1387 := &x.Port
				yym1388 := z.EncBinary()
				_ = yym1388
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1387) {
				} else if !yym1388 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1387)
				} else {
					z.EncFallback(yy1387)
				}
			}
			if yyr1383 || yy2arr1383 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1389 := z.DecBinary()
	_ = yym1389
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1390 := r.ContainerType()
		if yyct1390 == codecSelferValueTypeMap1234 {
			yyl1390 := r.ReadMapStart()
			if yyl1390 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1390, d)
			}
		} else if yyct1390 == codecSelferValueTypeArray1234 {
			yyl1390 := r.ReadArrayStart()
			if yyl1390 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1390, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1391Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1391Slc
	var yyhl1391 bool = l >= 0
	for yyj1391 := 0; ; yyj1391++ {
		if yyhl1391 {
			if yyj1391 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1391Slc = r.DecodeBytes(yys1391Slc, true, true)
		yys1391 := string(yys1391Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1391 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1392 := &x.Port
				yym1393 := z.DecBinary()
				_ = yym1393
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1392) {
				} else if !yym1393 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1392)
				} else {
					z.DecFallback(yyv1392, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1391)
		} // end switch yys1391
	} // end for yyj1391
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1394 int
	var yyb1394 bool
	var yyhl1394 bool = l >= 0
	yyj1394++
	if yyhl1394 {
		yyb1394 = yyj1394 > l
	} else {
		yyb1394 = r.CheckBreak()
	}
	if yyb1394 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1395 := &x.Port
		yym1396 := z.DecBinary()
		_ = yym1396
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1395) {
		} else if !yym1396 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1395)
		} else {
			z.DecFallback(yyv1395, false)
		}
	}
	for {
		yyj1394++
		if yyhl1394 {
			yyb1394 = yyj1394 > l
		} else {
			yyb1394 = r.CheckBreak()
		}
		if yyb1394 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1394-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1397 := z.EncBinary()
		_ = yym1397
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1398 := !z.EncBinary()
			yy2arr1398 := z.EncBasicHandle().StructToArray
			var yyq1398 [1]bool
			_, _, _ = yysep1398, yyq1398, yy2arr1398
			const yyr1398 bool = false
			yyq1398[0] = len(x.Command) != 0
			var yynn1398 int
			if yyr1398 || yy2arr1398 {
				r.EncodeArrayStart(1)
			} else {
				yynn1398 = 0
				for _, b := range yyq1398 {
					if b {
						yynn1398++
					}
				}
				r.EncodeMapStart(yynn1398)
				yynn1398 = 0
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1398[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1400 := z.EncBinary()
						_ = yym1400
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1398[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1401 := z.EncBinary()
						_ = yym1401
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1402 := z.DecBinary()
	_ = yym1402
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1403 := r.ContainerType()
		if yyct1403 == codecSelferValueTypeMap1234 {
			yyl1403 := r.ReadMapStart()
			if yyl1403 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1403, d)
			}
		} else if yyct1403 == codecSelferValueTypeArray1234 {
			yyl1403 := r.ReadArrayStart()
			if yyl1403 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1403, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1404Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1404Slc
	var yyhl1404 bool = l >= 0
	for yyj1404 := 0; ; yyj1404++ {
		if yyhl1404 {
			if yyj1404 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1404Slc = r.DecodeBytes(yys1404Slc, true, true)
		yys1404 := string(yys1404Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1404 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1405 := &x.Command
				yym1406 := z.DecBinary()
				_ = yym1406
				if false {
				} else {
					z.F.DecSliceStringX(yyv1405, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1404)
		} // end switch yys1404
	} // end for yyj1404
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1407 int
	var yyb1407 bool
	var yyhl1407 bool = l >= 0
	yyj1407++
	if yyhl1407 {
		yyb1407 = yyj1407 > l
	} else {
		yyb1407 = r.CheckBreak()
	}
	if yyb1407 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1408 := &x.Command
		yym1409 := z.DecBinary()
		_ = yym1409
		if false {
		} else {
			z.F.DecSliceStringX(yyv1408, false, d)
		}
	}
	for {
		yyj1407++
		if yyhl1407 {
			yyb1407 = yyj1407 > l
		} else {
			yyb1407 = r.CheckBreak()
		}
		if yyb1407 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1407-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1410 := z.EncBinary()
		_ = yym1410
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1411 := !z.EncBinary()
			yy2arr1411 := z.EncBasicHandle().StructToArray
			var yyq1411 [8]bool
			_, _, _ = yysep1411, yyq1411, yy2arr1411
			const yyr1411 bool = false
			yyq1411[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1411[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1411[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1411[3] = x.InitialDelaySeconds != 0
			yyq1411[4] = x.TimeoutSeconds != 0
			yyq1411[5] = x.PeriodSeconds != 0
			yyq1411[6] = x.SuccessThreshold != 0
			yyq1411[7] = x.FailureThreshold != 0
			var yynn1411 int
			if yyr1411 || yy2arr1411 {
				r.EncodeArrayStart(8)
			} else {
				yynn1411 = 0
				for _, b := range yyq1411 {
					if b {
						yynn1411++
					}
				}
				r.EncodeMapStart(yynn1411)
				yynn1411 = 0
			}
			var yyn1412 bool
			if x.Handler.Exec == nil {
				yyn1412 = true
				goto LABEL1412
			}
		LABEL1412:
			if yyr1411 || yy2arr1411 {
				if yyn1412 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1411[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1411[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1412 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1413 bool
			if x.Handler.HTTPGet == nil {
				yyn1413 = true
				goto LABEL1413
			}
		LABEL1413:
			if yyr1411 || yy2arr1411 {
				if yyn1413 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1411[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1411[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1413 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1414 bool
			if x.Handler.TCPSocket == nil {
				yyn1414 = true
				goto LABEL1414
			}
		LABEL1414:
			if yyr1411 || yy2arr1411 {
				if yyn1414 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1411[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1411[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1414 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1411[3] {
					yym1416 := z.EncBinary()
					_ = yym1416
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1411[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1417 := z.EncBinary()
					_ = yym1417
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1411[4] {
					yym1419 := z.EncBinary()
					_ = yym1419
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1411[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1420 := z.EncBinary()
					_ = yym1420
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1411[5] {
					yym1422 := z.EncBinary()
					_ = yym1422
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1411[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1423 := z.EncBinary()
					_ = yym1423
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1411[6] {
					yym1425 := z.EncBinary()
					_ = yym1425
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1411[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1426 := z.EncBinary()
					_ = yym1426
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1411[7] {
					yym1428 := z.EncBinary()
					_ = yym1428
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1411[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1429 := z.EncBinary()
					_ = yym1429
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1411 || yy2arr1411 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1430 := z.DecBinary()
	_ = yym1430
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1431 := r.ContainerType()
		if yyct1431 == codecSelferValueTypeMap1234 {
			yyl1431 := r.ReadMapStart()
			if yyl1431 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1431, d)
			}
		} else if yyct1431 == codecSelferValueTypeArray1234 {
			yyl1431 := r.ReadArrayStart()
			if yyl1431 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1431, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1432Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1432Slc
	var yyhl1432 bool = l >= 0
	for yyj1432 := 0; ; yyj1432++ {
		if yyhl1432 {
			if yyj1432 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1432Slc = r.DecodeBytes(yys1432Slc, true, true)
		yys1432 := string(yys1432Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1432 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int32(r.DecodeInt(32))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int32(r.DecodeInt(32))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int32(r.DecodeInt(32))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int32(r.DecodeInt(32))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1432)
		} // end switch yys1432
	} // end for yyj1432
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1441 int
	var yyb1441 bool
	var yyhl1441 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int32(r.DecodeInt(32))
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int32(r.DecodeInt(32))
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int32(r.DecodeInt(32))
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int32(r.DecodeInt(32))
	}
	yyj1441++
	if yyhl1441 {
		yyb1441 = yyj1441 > l
	} else {
		yyb1441 = r.CheckBreak()
	}
	if yyb1441 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int32(r.DecodeInt(32))
	}
	for {
		yyj1441++
		if yyhl1441 {
			yyb1441 = yyj1441 > l
		} else {
			yyb1441 = r.CheckBreak()
		}
		if yyb1441 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1441-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1450 := z.EncBinary()
	_ = yym1450
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1451 := z.DecBinary()
	_ = yym1451
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1452 := z.EncBinary()
	_ = yym1452
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1453 := z.DecBinary()
	_ = yym1453
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1454 := z.EncBinary()
		_ = yym1454
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1455 := !z.EncBinary()
			yy2arr1455 := z.EncBasicHandle().StructToArray
			var yyq1455 [2]bool
			_, _, _ = yysep1455, yyq1455, yy2arr1455
			const yyr1455 bool = false
			yyq1455[0] = len(x.Add) != 0
			yyq1455[1] = len(x.Drop) != 0
			var yynn1455 int
			if yyr1455 || yy2arr1455 {
				r.EncodeArrayStart(2)
			} else {
				yynn1455 = 0
				for _, b := range yyq1455 {
					if b {
						yynn1455++
					}
				}
				r.EncodeMapStart(yynn1455)
				yynn1455 = 0
			}
			if yyr1455 || yy2arr1455 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1455[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1457 := z.EncBinary()
						_ = yym1457
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1455[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1458 := z.EncBinary()
						_ = yym1458
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1455 || yy2arr1455 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1455[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1460 := z.EncBinary()
						_ = yym1460
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1455[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1461 := z.EncBinary()
						_ = yym1461
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1455 || yy2arr1455 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1462 := z.DecBinary()
	_ = yym1462
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1463 := r.ContainerType()
		if yyct1463 == codecSelferValueTypeMap1234 {
			yyl1463 := r.ReadMapStart()
			if yyl1463 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1463, d)
			}
		} else if yyct1463 == codecSelferValueTypeArray1234 {
			yyl1463 := r.ReadArrayStart()
			if yyl1463 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1463, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1464Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1464Slc
	var yyhl1464 bool = l >= 0
	for yyj1464 := 0; ; yyj1464++ {
		if yyhl1464 {
			if yyj1464 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1464Slc = r.DecodeBytes(yys1464Slc, true, true)
		yys1464 := string(yys1464Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1464 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1465 := &x.Add
				yym1466 := z.DecBinary()
				_ = yym1466
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1465), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1467 := &x.Drop
				yym1468 := z.DecBinary()
				_ = yym1468
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1467), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1464)
		} // end switch yys1464
	} // end for yyj1464
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1469 int
	var yyb1469 bool
	var yyhl1469 bool = l >= 0
	yyj1469++
	if yyhl1469 {
		yyb1469 = yyj1469 > l
	} else {
		yyb1469 = r.CheckBreak()
	}
	if yyb1469 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1470 := &x.Add
		yym1471 := z.DecBinary()
		_ = yym1471
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1470), d)
		}
	}
	yyj1469++
	if yyhl1469 {
		yyb1469 = yyj1469 > l
	} else {
		yyb1469 = r.CheckBreak()
	}
	if yyb1469 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1472 := &x.Drop
		yym1473 := z.DecBinary()
		_ = yym1473
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1472), d)
		}
	}
	for {
		yyj1469++
		if yyhl1469 {
			yyb1469 = yyj1469 > l
		} else {
			yyb1469 = r.CheckBreak()
		}
		if yyb1469 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1469-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1474 := z.EncBinary()
		_ = yym1474
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1475 := !z.EncBinary()
			yy2arr1475 := z.EncBasicHandle().StructToArray
			var yyq1475 [2]bool
			_, _, _ = yysep1475, yyq1475, yy2arr1475
			const yyr1475 bool = false
			yyq1475[0] = len(x.Limits) != 0
			yyq1475[1] = len(x.Requests) != 0
			var yynn1475 int
			if yyr1475 || yy2arr1475 {
				r.EncodeArrayStart(2)
			} else {
				yynn1475 = 0
				for _, b := range yyq1475 {
					if b {
						yynn1475++
					}
				}
				r.EncodeMapStart(yynn1475)
				yynn1475 = 0
			}
			if yyr1475 || yy2arr1475 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1475[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1475[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1475 || yy2arr1475 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1475[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1475[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1475 || yy2arr1475 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1478 := z.DecBinary()
	_ = yym1478
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1479 := r.ContainerType()
		if yyct1479 == codecSelferValueTypeMap1234 {
			yyl1479 := r.ReadMapStart()
			if yyl1479 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1479, d)
			}
		} else if yyct1479 == codecSelferValueTypeArray1234 {
			yyl1479 := r.ReadArrayStart()
			if yyl1479 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1479, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1480Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1480Slc
	var yyhl1480 bool = l >= 0
	for yyj1480 := 0; ; yyj1480++ {
		if yyhl1480 {
			if yyj1480 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1480Slc = r.DecodeBytes(yys1480Slc, true, true)
		yys1480 := string(yys1480Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1480 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1481 := &x.Limits
				yyv1481.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1482 := &x.Requests
				yyv1482.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1480)
		} // end switch yys1480
	} // end for yyj1480
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1483 int
	var yyb1483 bool
	var yyhl1483 bool = l >= 0
	yyj1483++
	if yyhl1483 {
		yyb1483 = yyj1483 > l
	} else {
		yyb1483 = r.CheckBreak()
	}
	if yyb1483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1484 := &x.Limits
		yyv1484.CodecDecodeSelf(d)
	}
	yyj1483++
	if yyhl1483 {
		yyb1483 = yyj1483 > l
	} else {
		yyb1483 = r.CheckBreak()
	}
	if yyb1483 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1485 := &x.Requests
		yyv1485.CodecDecodeSelf(d)
	}
	for {
		yyj1483++
		if yyhl1483 {
			yyb1483 = yyj1483 > l
		} else {
			yyb1483 = r.CheckBreak()
		}
		if yyb1483 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1483-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1486 := z.EncBinary()
		_ = yym1486
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1487 := !z.EncBinary()
			yy2arr1487 := z.EncBasicHandle().StructToArray
			var yyq1487 [18]bool
			_, _, _ = yysep1487, yyq1487, yy2arr1487
			const yyr1487 bool = false
			yyq1487[1] = x.Image != ""
			yyq1487[2] = len(x.Command) != 0
			yyq1487[3] = len(x.Args) != 0
			yyq1487[4] = x.WorkingDir != ""
			yyq1487[5] = len(x.Ports) != 0
			yyq1487[6] = len(x.Env) != 0
			yyq1487[7] = true
			yyq1487[8] = len(x.VolumeMounts) != 0
			yyq1487[9] = x.LivenessProbe != nil
			yyq1487[10] = x.ReadinessProbe != nil
			yyq1487[11] = x.Lifecycle != nil
			yyq1487[12] = x.TerminationMessagePath != ""
			yyq1487[13] = x.ImagePullPolicy != ""
			yyq1487[14] = x.SecurityContext != nil
			yyq1487[15] = x.Stdin != false
			yyq1487[16] = x.StdinOnce != false
			yyq1487[17] = x.TTY != false
			var yynn1487 int
			if yyr1487 || yy2arr1487 {
				r.EncodeArrayStart(18)
			} else {
				yynn1487 = 1
				for _, b := range yyq1487 {
					if b {
						yynn1487++
					}
				}
				r.EncodeMapStart(yynn1487)
				yynn1487 = 0
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1489 := z.EncBinary()
				_ = yym1489
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1490 := z.EncBinary()
				_ = yym1490
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[1] {
					yym1492 := z.EncBinary()
					_ = yym1492
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1487[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1493 := z.EncBinary()
					_ = yym1493
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1495 := z.EncBinary()
						_ = yym1495
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1496 := z.EncBinary()
						_ = yym1496
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1498 := z.EncBinary()
						_ = yym1498
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1499 := z.EncBinary()
						_ = yym1499
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[4] {
					yym1501 := z.EncBinary()
					_ = yym1501
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1487[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1502 := z.EncBinary()
					_ = yym1502
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1504 := z.EncBinary()
						_ = yym1504
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1505 := z.EncBinary()
						_ = yym1505
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1507 := z.EncBinary()
						_ = yym1507
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1508 := z.EncBinary()
						_ = yym1508
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[7] {
					yy1510 := &x.Resources
					yy1510.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1511 := &x.Resources
					yy1511.CodecEncodeSelf(e)
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1513 := z.EncBinary()
						_ = yym1513
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1514 := z.EncBinary()
						_ = yym1514
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[12] {
					yym1519 := z.EncBinary()
					_ = yym1519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1487[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1520 := z.EncBinary()
					_ = yym1520
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[13] {
					x.ImagePullPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1487[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.ImagePullPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1487[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[15] {
					yym1524 := z.EncBinary()
					_ = yym1524
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1487[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1525 := z.EncBinary()
					_ = yym1525
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[16] {
					yym1527 := z.EncBinary()
					_ = yym1527
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1487[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1528 := z.EncBinary()
					_ = yym1528
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1487[17] {
					yym1530 := z.EncBinary()
					_ = yym1530
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1487[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1531 := z.EncBinary()
					_ = yym1531
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1487 || yy2arr1487 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1532 := z.DecBinary()
	_ = yym1532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1533 := r.ContainerType()
		if yyct1533 == codecSelferValueTypeMap1234 {
			yyl1533 := r.ReadMapStart()
			if yyl1533 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1533, d)
			}
		} else if yyct1533 == codecSelferValueTypeArray1234 {
			yyl1533 := r.ReadArrayStart()
			if yyl1533 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1533, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1534Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1534Slc
	var yyhl1534 bool = l >= 0
	for yyj1534 := 0; ; yyj1534++ {
		if yyhl1534 {
			if yyj1534 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1534Slc = r.DecodeBytes(yys1534Slc, true, true)
		yys1534 := string(yys1534Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1534 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1537 := &x.Command
				yym1538 := z.DecBinary()
				_ = yym1538
				if false {
				} else {
					z.F.DecSliceStringX(yyv1537, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1539 := &x.Args
				yym1540 := z.DecBinary()
				_ = yym1540
				if false {
				} else {
					z.F.DecSliceStringX(yyv1539, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1542 := &x.Ports
				yym1543 := z.DecBinary()
				_ = yym1543
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1542), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1544 := &x.Env
				yym1545 := z.DecBinary()
				_ = yym1545
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1544), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1546 := &x.Resources
				yyv1546.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1547 := &x.VolumeMounts
				yym1548 := z.DecBinary()
				_ = yym1548
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1547), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1534)
		} // end switch yys1534
	} // end for yyj1534
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1558 int
	var yyb1558 bool
	var yyhl1558 bool = l >= 0
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1561 := &x.Command
		yym1562 := z.DecBinary()
		_ = yym1562
		if false {
		} else {
			z.F.DecSliceStringX(yyv1561, false, d)
		}
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1563 := &x.Args
		yym1564 := z.DecBinary()
		_ = yym1564
		if false {
		} else {
			z.F.DecSliceStringX(yyv1563, false, d)
		}
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1566 := &x.Ports
		yym1567 := z.DecBinary()
		_ = yym1567
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1566), d)
		}
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1568 := &x.Env
		yym1569 := z.DecBinary()
		_ = yym1569
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1568), d)
		}
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1570 := &x.Resources
		yyv1570.CodecDecodeSelf(d)
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1571 := &x.VolumeMounts
		yym1572 := z.DecBinary()
		_ = yym1572
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1571), d)
		}
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1558++
	if yyhl1558 {
		yyb1558 = yyj1558 > l
	} else {
		yyb1558 = r.CheckBreak()
	}
	if yyb1558 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1558++
		if yyhl1558 {
			yyb1558 = yyj1558 > l
		} else {
			yyb1558 = r.CheckBreak()
		}
		if yyb1558 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1558-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1582 := z.EncBinary()
		_ = yym1582
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1583 := !z.EncBinary()
			yy2arr1583 := z.EncBasicHandle().StructToArray
			var yyq1583 [3]bool
			_, _, _ = yysep1583, yyq1583, yy2arr1583
			const yyr1583 bool = false
			yyq1583[0] = x.Exec != nil
			yyq1583[1] = x.HTTPGet != nil
			yyq1583[2] = x.TCPSocket != nil
			var yynn1583 int
			if yyr1583 || yy2arr1583 {
				r.EncodeArrayStart(3)
			} else {
				yynn1583 = 0
				for _, b := range yyq1583 {
					if b {
						yynn1583++
					}
				}
				r.EncodeMapStart(yynn1583)
				yynn1583 = 0
			}
			if yyr1583 || yy2arr1583 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1583[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1583[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1583 || yy2arr1583 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1583[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1583[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1583 || yy2arr1583 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1583[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1583[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1583 || yy2arr1583 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1587 := z.DecBinary()
	_ = yym1587
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1588 := r.ContainerType()
		if yyct1588 == codecSelferValueTypeMap1234 {
			yyl1588 := r.ReadMapStart()
			if yyl1588 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1588, d)
			}
		} else if yyct1588 == codecSelferValueTypeArray1234 {
			yyl1588 := r.ReadArrayStart()
			if yyl1588 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1588, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1589Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1589Slc
	var yyhl1589 bool = l >= 0
	for yyj1589 := 0; ; yyj1589++ {
		if yyhl1589 {
			if yyj1589 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1589Slc = r.DecodeBytes(yys1589Slc, true, true)
		yys1589 := string(yys1589Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1589 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1589)
		} // end switch yys1589
	} // end for yyj1589
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1593 int
	var yyb1593 bool
	var yyhl1593 bool = l >= 0
	yyj1593++
	if yyhl1593 {
		yyb1593 = yyj1593 > l
	} else {
		yyb1593 = r.CheckBreak()
	}
	if yyb1593 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1593++
	if yyhl1593 {
		yyb1593 = yyj1593 > l
	} else {
		yyb1593 = r.CheckBreak()
	}
	if yyb1593 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1593++
	if yyhl1593 {
		yyb1593 = yyj1593 > l
	} else {
		yyb1593 = r.CheckBreak()
	}
	if yyb1593 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1593++
		if yyhl1593 {
			yyb1593 = yyj1593 > l
		} else {
			yyb1593 = r.CheckBreak()
		}
		if yyb1593 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1593-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1597 := z.EncBinary()
		_ = yym1597
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1598 := !z.EncBinary()
			yy2arr1598 := z.EncBasicHandle().StructToArray
			var yyq1598 [2]bool
			_, _, _ = yysep1598, yyq1598, yy2arr1598
			const yyr1598 bool = false
			yyq1598[0] = x.PostStart != nil
			yyq1598[1] = x.PreStop != nil
			var yynn1598 int
			if yyr1598 || yy2arr1598 {
				r.EncodeArrayStart(2)
			} else {
				yynn1598 = 0
				for _, b := range yyq1598 {
					if b {
						yynn1598++
					}
				}
				r.EncodeMapStart(yynn1598)
				yynn1598 = 0
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1598[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1598[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1598[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1598[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1598 || yy2arr1598 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1601 := z.DecBinary()
	_ = yym1601
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1602 := r.ContainerType()
		if yyct1602 == codecSelferValueTypeMap1234 {
			yyl1602 := r.ReadMapStart()
			if yyl1602 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1602, d)
			}
		} else if yyct1602 == codecSelferValueTypeArray1234 {
			yyl1602 := r.ReadArrayStart()
			if yyl1602 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1602, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1603Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1603Slc
	var yyhl1603 bool = l >= 0
	for yyj1603 := 0; ; yyj1603++ {
		if yyhl1603 {
			if yyj1603 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1603Slc = r.DecodeBytes(yys1603Slc, true, true)
		yys1603 := string(yys1603Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1603 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1603)
		} // end switch yys1603
	} // end for yyj1603
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1606 int
	var yyb1606 bool
	var yyhl1606 bool = l >= 0
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1606++
		if yyhl1606 {
			yyb1606 = yyj1606 > l
		} else {
			yyb1606 = r.CheckBreak()
		}
		if yyb1606 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1606-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1609 := z.EncBinary()
	_ = yym1609
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1610 := z.DecBinary()
	_ = yym1610
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1611 := z.EncBinary()
		_ = yym1611
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1612 := !z.EncBinary()
			yy2arr1612 := z.EncBasicHandle().StructToArray
			var yyq1612 [2]bool
			_, _, _ = yysep1612, yyq1612, yy2arr1612
			const yyr1612 bool = false
			yyq1612[0] = x.Reason != ""
			yyq1612[1] = x.Message != ""
			var yynn1612 int
			if yyr1612 || yy2arr1612 {
				r.EncodeArrayStart(2)
			} else {
				yynn1612 = 0
				for _, b := range yyq1612 {
					if b {
						yynn1612++
					}
				}
				r.EncodeMapStart(yynn1612)
				yynn1612 = 0
			}
			if yyr1612 || yy2arr1612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1612[0] {
					yym1614 := z.EncBinary()
					_ = yym1614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1612[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1615 := z.EncBinary()
					_ = yym1615
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1612 || yy2arr1612 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1612[1] {
					yym1617 := z.EncBinary()
					_ = yym1617
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1612[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1618 := z.EncBinary()
					_ = yym1618
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1612 || yy2arr1612 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1619 := z.DecBinary()
	_ = yym1619
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1620 := r.ContainerType()
		if yyct1620 == codecSelferValueTypeMap1234 {
			yyl1620 := r.ReadMapStart()
			if yyl1620 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1620, d)
			}
		} else if yyct1620 == codecSelferValueTypeArray1234 {
			yyl1620 := r.ReadArrayStart()
			if yyl1620 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1620, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1621Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1621Slc
	var yyhl1621 bool = l >= 0
	for yyj1621 := 0; ; yyj1621++ {
		if yyhl1621 {
			if yyj1621 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1621Slc = r.DecodeBytes(yys1621Slc, true, true)
		yys1621 := string(yys1621Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1621 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1621)
		} // end switch yys1621
	} // end for yyj1621
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1624 int
	var yyb1624 bool
	var yyhl1624 bool = l >= 0
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1624++
	if yyhl1624 {
		yyb1624 = yyj1624 > l
	} else {
		yyb1624 = r.CheckBreak()
	}
	if yyb1624 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1624++
		if yyhl1624 {
			yyb1624 = yyj1624 > l
		} else {
			yyb1624 = r.CheckBreak()
		}
		if yyb1624 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1624-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1627 := z.EncBinary()
		_ = yym1627
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1628 := !z.EncBinary()
			yy2arr1628 := z.EncBasicHandle().StructToArray
			var yyq1628 [1]bool
			_, _, _ = yysep1628, yyq1628, yy2arr1628
			const yyr1628 bool = false
			yyq1628[0] = true
			var yynn1628 int
			if yyr1628 || yy2arr1628 {
				r.EncodeArrayStart(1)
			} else {
				yynn1628 = 0
				for _, b := range yyq1628 {
					if b {
						yynn1628++
					}
				}
				r.EncodeMapStart(yynn1628)
				yynn1628 = 0
			}
			if yyr1628 || yy2arr1628 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1628[0] {
					yy1630 := &x.StartedAt
					yym1631 := z.EncBinary()
					_ = yym1631
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1630) {
					} else if yym1631 {
						z.EncBinaryMarshal(yy1630)
					} else if !yym1631 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1630)
					} else {
						z.EncFallback(yy1630)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1628[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1632 := &x.StartedAt
					yym1633 := z.EncBinary()
					_ = yym1633
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1632) {
					} else if yym1633 {
						z.EncBinaryMarshal(yy1632)
					} else if !yym1633 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1632)
					} else {
						z.EncFallback(yy1632)
					}
				}
			}
			if yyr1628 || yy2arr1628 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1634 := z.DecBinary()
	_ = yym1634
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1635 := r.ContainerType()
		if yyct1635 == codecSelferValueTypeMap1234 {
			yyl1635 := r.ReadMapStart()
			if yyl1635 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1635, d)
			}
		} else if yyct1635 == codecSelferValueTypeArray1234 {
			yyl1635 := r.ReadArrayStart()
			if yyl1635 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1635, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1636Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1636Slc
	var yyhl1636 bool = l >= 0
	for yyj1636 := 0; ; yyj1636++ {
		if yyhl1636 {
			if yyj1636 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1636Slc = r.DecodeBytes(yys1636Slc, true, true)
		yys1636 := string(yys1636Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1636 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1637 := &x.StartedAt
				yym1638 := z.DecBinary()
				_ = yym1638
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1637) {
				} else if yym1638 {
					z.DecBinaryUnmarshal(yyv1637)
				} else if !yym1638 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1637)
				} else {
					z.DecFallback(yyv1637, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1636)
		} // end switch yys1636
	} // end for yyj1636
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1639 int
	var yyb1639 bool
	var yyhl1639 bool = l >= 0
	yyj1639++
	if yyhl1639 {
		yyb1639 = yyj1639 > l
	} else {
		yyb1639 = r.CheckBreak()
	}
	if yyb1639 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1640 := &x.StartedAt
		yym1641 := z.DecBinary()
		_ = yym1641
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1640) {
		} else if yym1641 {
			z.DecBinaryUnmarshal(yyv1640)
		} else if !yym1641 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1640)
		} else {
			z.DecFallback(yyv1640, false)
		}
	}
	for {
		yyj1639++
		if yyhl1639 {
			yyb1639 = yyj1639 > l
		} else {
			yyb1639 = r.CheckBreak()
		}
		if yyb1639 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1639-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1642 := z.EncBinary()
		_ = yym1642
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1643 := !z.EncBinary()
			yy2arr1643 := z.EncBasicHandle().StructToArray
			var yyq1643 [7]bool
			_, _, _ = yysep1643, yyq1643, yy2arr1643
			const yyr1643 bool = false
			yyq1643[1] = x.Signal != 0
			yyq1643[2] = x.Reason != ""
			yyq1643[3] = x.Message != ""
			yyq1643[4] = true
			yyq1643[5] = true
			yyq1643[6] = x.ContainerID != ""
			var yynn1643 int
			if yyr1643 || yy2arr1643 {
				r.EncodeArrayStart(7)
			} else {
				yynn1643 = 1
				for _, b := range yyq1643 {
					if b {
						yynn1643++
					}
				}
				r.EncodeMapStart(yynn1643)
				yynn1643 = 0
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1645 := z.EncBinary()
				_ = yym1645
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1646 := z.EncBinary()
				_ = yym1646
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[1] {
					yym1648 := z.EncBinary()
					_ = yym1648
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1643[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1649 := z.EncBinary()
					_ = yym1649
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[2] {
					yym1651 := z.EncBinary()
					_ = yym1651
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1643[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1652 := z.EncBinary()
					_ = yym1652
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[3] {
					yym1654 := z.EncBinary()
					_ = yym1654
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1643[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1655 := z.EncBinary()
					_ = yym1655
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[4] {
					yy1657 := &x.StartedAt
					yym1658 := z.EncBinary()
					_ = yym1658
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1657) {
					} else if yym1658 {
						z.EncBinaryMarshal(yy1657)
					} else if !yym1658 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1657)
					} else {
						z.EncFallback(yy1657)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1643[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1659 := &x.StartedAt
					yym1660 := z.EncBinary()
					_ = yym1660
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1659) {
					} else if yym1660 {
						z.EncBinaryMarshal(yy1659)
					} else if !yym1660 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1659)
					} else {
						z.EncFallback(yy1659)
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[5] {
					yy1662 := &x.FinishedAt
					yym1663 := z.EncBinary()
					_ = yym1663
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1662) {
					} else if yym1663 {
						z.EncBinaryMarshal(yy1662)
					} else if !yym1663 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1662)
					} else {
						z.EncFallback(yy1662)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1643[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1664 := &x.FinishedAt
					yym1665 := z.EncBinary()
					_ = yym1665
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1664) {
					} else if yym1665 {
						z.EncBinaryMarshal(yy1664)
					} else if !yym1665 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1664)
					} else {
						z.EncFallback(yy1664)
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1643[6] {
					yym1667 := z.EncBinary()
					_ = yym1667
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1643[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1668 := z.EncBinary()
					_ = yym1668
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1643 || yy2arr1643 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1669 := z.DecBinary()
	_ = yym1669
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1670 := r.ContainerType()
		if yyct1670 == codecSelferValueTypeMap1234 {
			yyl1670 := r.ReadMapStart()
			if yyl1670 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1670, d)
			}
		} else if yyct1670 == codecSelferValueTypeArray1234 {
			yyl1670 := r.ReadArrayStart()
			if yyl1670 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1670, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1671Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1671Slc
	var yyhl1671 bool = l >= 0
	for yyj1671 := 0; ; yyj1671++ {
		if yyhl1671 {
			if yyj1671 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1671Slc = r.DecodeBytes(yys1671Slc, true, true)
		yys1671 := string(yys1671Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1671 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int32(r.DecodeInt(32))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int32(r.DecodeInt(32))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1676 := &x.StartedAt
				yym1677 := z.DecBinary()
				_ = yym1677
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1676) {
				} else if yym1677 {
					z.DecBinaryUnmarshal(yyv1676)
				} else if !yym1677 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1676)
				} else {
					z.DecFallback(yyv1676, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1678 := &x.FinishedAt
				yym1679 := z.DecBinary()
				_ = yym1679
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1678) {
				} else if yym1679 {
					z.DecBinaryUnmarshal(yyv1678)
				} else if !yym1679 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1678)
				} else {
					z.DecFallback(yyv1678, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1671)
		} // end switch yys1671
	} // end for yyj1671
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1681 int
	var yyb1681 bool
	var yyhl1681 bool = l >= 0
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int32(r.DecodeInt(32))
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int32(r.DecodeInt(32))
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1686 := &x.StartedAt
		yym1687 := z.DecBinary()
		_ = yym1687
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1686) {
		} else if yym1687 {
			z.DecBinaryUnmarshal(yyv1686)
		} else if !yym1687 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1686)
		} else {
			z.DecFallback(yyv1686, false)
		}
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1688 := &x.FinishedAt
		yym1689 := z.DecBinary()
		_ = yym1689
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1688) {
		} else if yym1689 {
			z.DecBinaryUnmarshal(yyv1688)
		} else if !yym1689 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1688)
		} else {
			z.DecFallback(yyv1688, false)
		}
	}
	yyj1681++
	if yyhl1681 {
		yyb1681 = yyj1681 > l
	} else {
		yyb1681 = r.CheckBreak()
	}
	if yyb1681 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1681++
		if yyhl1681 {
			yyb1681 = yyj1681 > l
		} else {
			yyb1681 = r.CheckBreak()
		}
		if yyb1681 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1681-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1691 := z.EncBinary()
		_ = yym1691
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1692 := !z.EncBinary()
			yy2arr1692 := z.EncBasicHandle().StructToArray
			var yyq1692 [3]bool
			_, _, _ = yysep1692, yyq1692, yy2arr1692
			const yyr1692 bool = false
			yyq1692[0] = x.Waiting != nil
			yyq1692[1] = x.Running != nil
			yyq1692[2] = x.Terminated != nil
			var yynn1692 int
			if yyr1692 || yy2arr1692 {
				r.EncodeArrayStart(3)
			} else {
				yynn1692 = 0
				for _, b := range yyq1692 {
					if b {
						yynn1692++
					}
				}
				r.EncodeMapStart(yynn1692)
				yynn1692 = 0
			}
			if yyr1692 || yy2arr1692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1692[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1692[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1692 || yy2arr1692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1692[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1692[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1692 || yy2arr1692 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1692[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1692[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1692 || yy2arr1692 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1696 := z.DecBinary()
	_ = yym1696
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1697 := r.ContainerType()
		if yyct1697 == codecSelferValueTypeMap1234 {
			yyl1697 := r.ReadMapStart()
			if yyl1697 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1697, d)
			}
		} else if yyct1697 == codecSelferValueTypeArray1234 {
			yyl1697 := r.ReadArrayStart()
			if yyl1697 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1697, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1698Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1698Slc
	var yyhl1698 bool = l >= 0
	for yyj1698 := 0; ; yyj1698++ {
		if yyhl1698 {
			if yyj1698 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1698Slc = r.DecodeBytes(yys1698Slc, true, true)
		yys1698 := string(yys1698Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1698 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1698)
		} // end switch yys1698
	} // end for yyj1698
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1702 int
	var yyb1702 bool
	var yyhl1702 bool = l >= 0
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1702++
	if yyhl1702 {
		yyb1702 = yyj1702 > l
	} else {
		yyb1702 = r.CheckBreak()
	}
	if yyb1702 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1702++
		if yyhl1702 {
			yyb1702 = yyj1702 > l
		} else {
			yyb1702 = r.CheckBreak()
		}
		if yyb1702 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1702-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1706 := z.EncBinary()
		_ = yym1706
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1707 := !z.EncBinary()
			yy2arr1707 := z.EncBasicHandle().StructToArray
			var yyq1707 [8]bool
			_, _, _ = yysep1707, yyq1707, yy2arr1707
			const yyr1707 bool = false
			yyq1707[1] = true
			yyq1707[2] = true
			yyq1707[7] = x.ContainerID != ""
			var yynn1707 int
			if yyr1707 || yy2arr1707 {
				r.EncodeArrayStart(8)
			} else {
				yynn1707 = 5
				for _, b := range yyq1707 {
					if b {
						yynn1707++
					}
				}
				r.EncodeMapStart(yynn1707)
				yynn1707 = 0
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1709 := z.EncBinary()
				_ = yym1709
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1710 := z.EncBinary()
				_ = yym1710
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[1] {
					yy1712 := &x.State
					yy1712.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1707[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1713 := &x.State
					yy1713.CodecEncodeSelf(e)
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[2] {
					yy1715 := &x.LastTerminationState
					yy1715.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1707[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1716 := &x.LastTerminationState
					yy1716.CodecEncodeSelf(e)
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1718 := z.EncBinary()
				_ = yym1718
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1719 := z.EncBinary()
				_ = yym1719
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1721 := z.EncBinary()
				_ = yym1721
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1722 := z.EncBinary()
				_ = yym1722
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1724 := z.EncBinary()
				_ = yym1724
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1725 := z.EncBinary()
				_ = yym1725
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1727 := z.EncBinary()
				_ = yym1727
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1728 := z.EncBinary()
				_ = yym1728
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1707[7] {
					yym1730 := z.EncBinary()
					_ = yym1730
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1707[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1731 := z.EncBinary()
					_ = yym1731
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1707 || yy2arr1707 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1732 := z.DecBinary()
	_ = yym1732
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1733 := r.ContainerType()
		if yyct1733 == codecSelferValueTypeMap1234 {
			yyl1733 := r.ReadMapStart()
			if yyl1733 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1733, d)
			}
		} else if yyct1733 == codecSelferValueTypeArray1234 {
			yyl1733 := r.ReadArrayStart()
			if yyl1733 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1733, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1734Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1734Slc
	var yyhl1734 bool = l >= 0
	for yyj1734 := 0; ; yyj1734++ {
		if yyhl1734 {
			if yyj1734 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1734Slc = r.DecodeBytes(yys1734Slc, true, true)
		yys1734 := string(yys1734Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1734 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1736 := &x.State
				yyv1736.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1737 := &x.LastTerminationState
				yyv1737.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int32(r.DecodeInt(32))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1734)
		} // end switch yys1734
	} // end for yyj1734
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1743 int
	var yyb1743 bool
	var yyhl1743 bool = l >= 0
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1745 := &x.State
		yyv1745.CodecDecodeSelf(d)
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1746 := &x.LastTerminationState
		yyv1746.CodecDecodeSelf(d)
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int32(r.DecodeInt(32))
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1743++
	if yyhl1743 {
		yyb1743 = yyj1743 > l
	} else {
		yyb1743 = r.CheckBreak()
	}
	if yyb1743 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1743++
		if yyhl1743 {
			yyb1743 = yyj1743 > l
		} else {
			yyb1743 = r.CheckBreak()
		}
		if yyb1743 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1743-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1752 := z.EncBinary()
	_ = yym1752
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1753 := z.DecBinary()
	_ = yym1753
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1754 := z.EncBinary()
	_ = yym1754
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1755 := z.DecBinary()
	_ = yym1755
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1756 := z.EncBinary()
		_ = yym1756
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1757 := !z.EncBinary()
			yy2arr1757 := z.EncBasicHandle().StructToArray
			var yyq1757 [6]bool
			_, _, _ = yysep1757, yyq1757, yy2arr1757
			const yyr1757 bool = false
			yyq1757[2] = true
			yyq1757[3] = true
			yyq1757[4] = x.Reason != ""
			yyq1757[5] = x.Message != ""
			var yynn1757 int
			if yyr1757 || yy2arr1757 {
				r.EncodeArrayStart(6)
			} else {
				yynn1757 = 2
				for _, b := range yyq1757 {
					if b {
						yynn1757++
					}
				}
				r.EncodeMapStart(yynn1757)
				yynn1757 = 0
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1757[2] {
					yy1761 := &x.LastProbeTime
					yym1762 := z.EncBinary()
					_ = yym1762
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1761) {
					} else if yym1762 {
						z.EncBinaryMarshal(yy1761)
					} else if !yym1762 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1761)
					} else {
						z.EncFallback(yy1761)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1757[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1763 := &x.LastProbeTime
					yym1764 := z.EncBinary()
					_ = yym1764
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1763) {
					} else if yym1764 {
						z.EncBinaryMarshal(yy1763)
					} else if !yym1764 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1763)
					} else {
						z.EncFallback(yy1763)
					}
				}
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1757[3] {
					yy1766 := &x.LastTransitionTime
					yym1767 := z.EncBinary()
					_ = yym1767
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1766) {
					} else if yym1767 {
						z.EncBinaryMarshal(yy1766)
					} else if !yym1767 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1766)
					} else {
						z.EncFallback(yy1766)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1757[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1768 := &x.LastTransitionTime
					yym1769 := z.EncBinary()
					_ = yym1769
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1768) {
					} else if yym1769 {
						z.EncBinaryMarshal(yy1768)
					} else if !yym1769 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1768)
					} else {
						z.EncFallback(yy1768)
					}
				}
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1757[4] {
					yym1771 := z.EncBinary()
					_ = yym1771
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1757[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1772 := z.EncBinary()
					_ = yym1772
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1757[5] {
					yym1774 := z.EncBinary()
					_ = yym1774
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1757[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1775 := z.EncBinary()
					_ = yym1775
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1757 || yy2arr1757 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1776 := z.DecBinary()
	_ = yym1776
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1777 := r.ContainerType()
		if yyct1777 == codecSelferValueTypeMap1234 {
			yyl1777 := r.ReadMapStart()
			if yyl1777 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1777, d)
			}
		} else if yyct1777 == codecSelferValueTypeArray1234 {
			yyl1777 := r.ReadArrayStart()
			if yyl1777 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1777, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1778Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1778Slc
	var yyhl1778 bool = l >= 0
	for yyj1778 := 0; ; yyj1778++ {
		if yyhl1778 {
			if yyj1778 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1778Slc = r.DecodeBytes(yys1778Slc, true, true)
		yys1778 := string(yys1778Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1778 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1781 := &x.LastProbeTime
				yym1782 := z.DecBinary()
				_ = yym1782
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1781) {
				} else if yym1782 {
					z.DecBinaryUnmarshal(yyv1781)
				} else if !yym1782 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1781)
				} else {
					z.DecFallback(yyv1781, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1783 := &x.LastTransitionTime
				yym1784 := z.DecBinary()
				_ = yym1784
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1783) {
				} else if yym1784 {
					z.DecBinaryUnmarshal(yyv1783)
				} else if !yym1784 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1783)
				} else {
					z.DecFallback(yyv1783, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1778)
		} // end switch yys1778
	} // end for yyj1778
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1787 int
	var yyb1787 bool
	var yyhl1787 bool = l >= 0
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1790 := &x.LastProbeTime
		yym1791 := z.DecBinary()
		_ = yym1791
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1790) {
		} else if yym1791 {
			z.DecBinaryUnmarshal(yyv1790)
		} else if !yym1791 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1790)
		} else {
			z.DecFallback(yyv1790, false)
		}
	}
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1792 := &x.LastTransitionTime
		yym1793 := z.DecBinary()
		_ = yym1793
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1792) {
		} else if yym1793 {
			z.DecBinaryUnmarshal(yyv1792)
		} else if !yym1793 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1792)
		} else {
			z.DecFallback(yyv1792, false)
		}
	}
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1787++
	if yyhl1787 {
		yyb1787 = yyj1787 > l
	} else {
		yyb1787 = r.CheckBreak()
	}
	if yyb1787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1787++
		if yyhl1787 {
			yyb1787 = yyj1787 > l
		} else {
			yyb1787 = r.CheckBreak()
		}
		if yyb1787 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1787-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1796 := z.EncBinary()
	_ = yym1796
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1797 := z.DecBinary()
	_ = yym1797
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1798 := z.EncBinary()
	_ = yym1798
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1799 := z.DecBinary()
	_ = yym1799
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1800 := z.EncBinary()
		_ = yym1800
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1801 := !z.EncBinary()
			yy2arr1801 := z.EncBasicHandle().StructToArray
			var yyq1801 [1]bool
			_, _, _ = yysep1801, yyq1801, yy2arr1801
			const yyr1801 bool = false
			var yynn1801 int
			if yyr1801 || yy2arr1801 {
				r.EncodeArrayStart(1)
			} else {
				yynn1801 = 1
				for _, b := range yyq1801 {
					if b {
						yynn1801++
					}
				}
				r.EncodeMapStart(yynn1801)
				yynn1801 = 0
			}
			if yyr1801 || yy2arr1801 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1803 := z.EncBinary()
					_ = yym1803
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSelectorTerms"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1804 := z.EncBinary()
					_ = yym1804
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			}
			if yyr1801 || yy2arr1801 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1805 := z.DecBinary()
	_ = yym1805
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1806 := r.ContainerType()
		if yyct1806 == codecSelferValueTypeMap1234 {
			yyl1806 := r.ReadMapStart()
			if yyl1806 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1806, d)
			}
		} else if yyct1806 == codecSelferValueTypeArray1234 {
			yyl1806 := r.ReadArrayStart()
			if yyl1806 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1806, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1807Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1807Slc
	var yyhl1807 bool = l >= 0
	for yyj1807 := 0; ; yyj1807++ {
		if yyhl1807 {
			if yyj1807 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1807Slc = r.DecodeBytes(yys1807Slc, true, true)
		yys1807 := string(yys1807Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1807 {
		case "nodeSelectorTerms":
			if r.TryDecodeAsNil() {
				x.NodeSelectorTerms = nil
			} else {
				yyv1808 := &x.NodeSelectorTerms
				yym1809 := z.DecBinary()
				_ = yym1809
				if false {
				} else {
					h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1808), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1807)
		} // end switch yys1807
	} // end for yyj1807
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1810 int
	var yyb1810 bool
	var yyhl1810 bool = l >= 0
	yyj1810++
	if yyhl1810 {
		yyb1810 = yyj1810 > l
	} else {
		yyb1810 = r.CheckBreak()
	}
	if yyb1810 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelectorTerms = nil
	} else {
		yyv1811 := &x.NodeSelectorTerms
		yym1812 := z.DecBinary()
		_ = yym1812
		if false {
		} else {
			h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1811), d)
		}
	}
	for {
		yyj1810++
		if yyhl1810 {
			yyb1810 = yyj1810 > l
		} else {
			yyb1810 = r.CheckBreak()
		}
		if yyb1810 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1810-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1813 := z.EncBinary()
		_ = yym1813
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1814 := !z.EncBinary()
			yy2arr1814 := z.EncBasicHandle().StructToArray
			var yyq1814 [1]bool
			_, _, _ = yysep1814, yyq1814, yy2arr1814
			const yyr1814 bool = false
			var yynn1814 int
			if yyr1814 || yy2arr1814 {
				r.EncodeArrayStart(1)
			} else {
				yynn1814 = 1
				for _, b := range yyq1814 {
					if b {
						yynn1814++
					}
				}
				r.EncodeMapStart(yynn1814)
				yynn1814 = 0
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1816 := z.EncBinary()
					_ = yym1816
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1817 := z.EncBinary()
					_ = yym1817
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			}
			if yyr1814 || yy2arr1814 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1818 := z.DecBinary()
	_ = yym1818
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1819 := r.ContainerType()
		if yyct1819 == codecSelferValueTypeMap1234 {
			yyl1819 := r.ReadMapStart()
			if yyl1819 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1819, d)
			}
		} else if yyct1819 == codecSelferValueTypeArray1234 {
			yyl1819 := r.ReadArrayStart()
			if yyl1819 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1819, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1820Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1820Slc
	var yyhl1820 bool = l >= 0
	for yyj1820 := 0; ; yyj1820++ {
		if yyhl1820 {
			if yyj1820 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1820Slc = r.DecodeBytes(yys1820Slc, true, true)
		yys1820 := string(yys1820Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1820 {
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1821 := &x.MatchExpressions
				yym1822 := z.DecBinary()
				_ = yym1822
				if false {
				} else {
					h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1821), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1820)
		} // end switch yys1820
	} // end for yyj1820
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1823 int
	var yyb1823 bool
	var yyhl1823 bool = l >= 0
	yyj1823++
	if yyhl1823 {
		yyb1823 = yyj1823 > l
	} else {
		yyb1823 = r.CheckBreak()
	}
	if yyb1823 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1824 := &x.MatchExpressions
		yym1825 := z.DecBinary()
		_ = yym1825
		if false {
		} else {
			h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1824), d)
		}
	}
	for {
		yyj1823++
		if yyhl1823 {
			yyb1823 = yyj1823 > l
		} else {
			yyb1823 = r.CheckBreak()
		}
		if yyb1823 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1823-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1826 := z.EncBinary()
		_ = yym1826
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1827 := !z.EncBinary()
			yy2arr1827 := z.EncBasicHandle().StructToArray
			var yyq1827 [3]bool
			_, _, _ = yysep1827, yyq1827, yy2arr1827
			const yyr1827 bool = false
			yyq1827[2] = len(x.Values) != 0
			var yynn1827 int
			if yyr1827 || yy2arr1827 {
				r.EncodeArrayStart(3)
			} else {
				yynn1827 = 2
				for _, b := range yyq1827 {
					if b {
						yynn1827++
					}
				}
				r.EncodeMapStart(yynn1827)
				yynn1827 = 0
			}
			if yyr1827 || yy2arr1827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1829 := z.EncBinary()
				_ = yym1829
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1830 := z.EncBinary()
				_ = yym1830
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1827 || yy2arr1827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1827 || yy2arr1827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1827[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1833 := z.EncBinary()
						_ = yym1833
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1827[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1834 := z.EncBinary()
						_ = yym1834
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1827 || yy2arr1827 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1835 := z.DecBinary()
	_ = yym1835
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1836 := r.ContainerType()
		if yyct1836 == codecSelferValueTypeMap1234 {
			yyl1836 := r.ReadMapStart()
			if yyl1836 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1836, d)
			}
		} else if yyct1836 == codecSelferValueTypeArray1234 {
			yyl1836 := r.ReadArrayStart()
			if yyl1836 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1836, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1837Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1837Slc
	var yyhl1837 bool = l >= 0
	for yyj1837 := 0; ; yyj1837++ {
		if yyhl1837 {
			if yyj1837 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1837Slc = r.DecodeBytes(yys1837Slc, true, true)
		yys1837 := string(yys1837Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1837 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = NodeSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1840 := &x.Values
				yym1841 := z.DecBinary()
				_ = yym1841
				if false {
				} else {
					z.F.DecSliceStringX(yyv1840, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1837)
		} // end switch yys1837
	} // end for yyj1837
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1842 int
	var yyb1842 bool
	var yyhl1842 bool = l >= 0
	yyj1842++
	if yyhl1842 {
		yyb1842 = yyj1842 > l
	} else {
		yyb1842 = r.CheckBreak()
	}
	if yyb1842 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1842++
	if yyhl1842 {
		yyb1842 = yyj1842 > l
	} else {
		yyb1842 = r.CheckBreak()
	}
	if yyb1842 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = NodeSelectorOperator(r.DecodeString())
	}
	yyj1842++
	if yyhl1842 {
		yyb1842 = yyj1842 > l
	} else {
		yyb1842 = r.CheckBreak()
	}
	if yyb1842 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1845 := &x.Values
		yym1846 := z.DecBinary()
		_ = yym1846
		if false {
		} else {
			z.F.DecSliceStringX(yyv1845, false, d)
		}
	}
	for {
		yyj1842++
		if yyhl1842 {
			yyb1842 = yyj1842 > l
		} else {
			yyb1842 = r.CheckBreak()
		}
		if yyb1842 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1842-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1847 := z.EncBinary()
	_ = yym1847
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1848 := z.DecBinary()
	_ = yym1848
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Affinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1849 := z.EncBinary()
		_ = yym1849
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1850 := !z.EncBinary()
			yy2arr1850 := z.EncBasicHandle().StructToArray
			var yyq1850 [3]bool
			_, _, _ = yysep1850, yyq1850, yy2arr1850
			const yyr1850 bool = false
			yyq1850[0] = x.NodeAffinity != nil
			yyq1850[1] = x.PodAffinity != nil
			yyq1850[2] = x.PodAntiAffinity != nil
			var yynn1850 int
			if yyr1850 || yy2arr1850 {
				r.EncodeArrayStart(3)
			} else {
				yynn1850 = 0
				for _, b := range yyq1850 {
					if b {
						yynn1850++
					}
				}
				r.EncodeMapStart(yynn1850)
				yynn1850 = 0
			}
			if yyr1850 || yy2arr1850 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1850[0] {
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1850[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1850 || yy2arr1850 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1850[1] {
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1850[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1850 || yy2arr1850 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1850[2] {
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1850[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAntiAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1850 || yy2arr1850 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Affinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1854 := z.DecBinary()
	_ = yym1854
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1855 := r.ContainerType()
		if yyct1855 == codecSelferValueTypeMap1234 {
			yyl1855 := r.ReadMapStart()
			if yyl1855 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1855, d)
			}
		} else if yyct1855 == codecSelferValueTypeArray1234 {
			yyl1855 := r.ReadArrayStart()
			if yyl1855 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1855, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Affinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1856Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1856Slc
	var yyhl1856 bool = l >= 0
	for yyj1856 := 0; ; yyj1856++ {
		if yyhl1856 {
			if yyj1856 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1856Slc = r.DecodeBytes(yys1856Slc, true, true)
		yys1856 := string(yys1856Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1856 {
		case "nodeAffinity":
			if r.TryDecodeAsNil() {
				if x.NodeAffinity != nil {
					x.NodeAffinity = nil
				}
			} else {
				if x.NodeAffinity == nil {
					x.NodeAffinity = new(NodeAffinity)
				}
				x.NodeAffinity.CodecDecodeSelf(d)
			}
		case "podAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAffinity != nil {
					x.PodAffinity = nil
				}
			} else {
				if x.PodAffinity == nil {
					x.PodAffinity = new(PodAffinity)
				}
				x.PodAffinity.CodecDecodeSelf(d)
			}
		case "podAntiAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAntiAffinity != nil {
					x.PodAntiAffinity = nil
				}
			} else {
				if x.PodAntiAffinity == nil {
					x.PodAntiAffinity = new(PodAntiAffinity)
				}
				x.PodAntiAffinity.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1856)
		} // end switch yys1856
	} // end for yyj1856
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Affinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1860 int
	var yyb1860 bool
	var yyhl1860 bool = l >= 0
	yyj1860++
	if yyhl1860 {
		yyb1860 = yyj1860 > l
	} else {
		yyb1860 = r.CheckBreak()
	}
	if yyb1860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeAffinity != nil {
			x.NodeAffinity = nil
		}
	} else {
		if x.NodeAffinity == nil {
			x.NodeAffinity = new(NodeAffinity)
		}
		x.NodeAffinity.CodecDecodeSelf(d)
	}
	yyj1860++
	if yyhl1860 {
		yyb1860 = yyj1860 > l
	} else {
		yyb1860 = r.CheckBreak()
	}
	if yyb1860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAffinity != nil {
			x.PodAffinity = nil
		}
	} else {
		if x.PodAffinity == nil {
			x.PodAffinity = new(PodAffinity)
		}
		x.PodAffinity.CodecDecodeSelf(d)
	}
	yyj1860++
	if yyhl1860 {
		yyb1860 = yyj1860 > l
	} else {
		yyb1860 = r.CheckBreak()
	}
	if yyb1860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAntiAffinity != nil {
			x.PodAntiAffinity = nil
		}
	} else {
		if x.PodAntiAffinity == nil {
			x.PodAntiAffinity = new(PodAntiAffinity)
		}
		x.PodAntiAffinity.CodecDecodeSelf(d)
	}
	for {
		yyj1860++
		if yyhl1860 {
			yyb1860 = yyj1860 > l
		} else {
			yyb1860 = r.CheckBreak()
		}
		if yyb1860 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1860-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1864 := z.EncBinary()
		_ = yym1864
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1865 := !z.EncBinary()
			yy2arr1865 := z.EncBasicHandle().StructToArray
			var yyq1865 [2]bool
			_, _, _ = yysep1865, yyq1865, yy2arr1865
			const yyr1865 bool = false
			yyq1865[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1865[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1865 int
			if yyr1865 || yy2arr1865 {
				r.EncodeArrayStart(2)
			} else {
				yynn1865 = 0
				for _, b := range yyq1865 {
					if b {
						yynn1865++
					}
				}
				r.EncodeMapStart(yynn1865)
				yynn1865 = 0
			}
			if yyr1865 || yy2arr1865 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1865[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1867 := z.EncBinary()
						_ = yym1867
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1865[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1868 := z.EncBinary()
						_ = yym1868
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1865 || yy2arr1865 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1865[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1870 := z.EncBinary()
						_ = yym1870
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1865[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1871 := z.EncBinary()
						_ = yym1871
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1865 || yy2arr1865 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1872 := z.DecBinary()
	_ = yym1872
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1873 := r.ContainerType()
		if yyct1873 == codecSelferValueTypeMap1234 {
			yyl1873 := r.ReadMapStart()
			if yyl1873 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1873, d)
			}
		} else if yyct1873 == codecSelferValueTypeArray1234 {
			yyl1873 := r.ReadArrayStart()
			if yyl1873 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1873, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1874Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1874Slc
	var yyhl1874 bool = l >= 0
	for yyj1874 := 0; ; yyj1874++ {
		if yyhl1874 {
			if yyj1874 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1874Slc = r.DecodeBytes(yys1874Slc, true, true)
		yys1874 := string(yys1874Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1874 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1875 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1876 := z.DecBinary()
				_ = yym1876
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1875), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1877 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1878 := z.DecBinary()
				_ = yym1878
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1877), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1874)
		} // end switch yys1874
	} // end for yyj1874
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1879 int
	var yyb1879 bool
	var yyhl1879 bool = l >= 0
	yyj1879++
	if yyhl1879 {
		yyb1879 = yyj1879 > l
	} else {
		yyb1879 = r.CheckBreak()
	}
	if yyb1879 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1880 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1881 := z.DecBinary()
		_ = yym1881
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1880), d)
		}
	}
	yyj1879++
	if yyhl1879 {
		yyb1879 = yyj1879 > l
	} else {
		yyb1879 = r.CheckBreak()
	}
	if yyb1879 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1882 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1883 := z.DecBinary()
		_ = yym1883
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1882), d)
		}
	}
	for {
		yyj1879++
		if yyhl1879 {
			yyb1879 = yyj1879 > l
		} else {
			yyb1879 = r.CheckBreak()
		}
		if yyb1879 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1879-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAntiAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1884 := z.EncBinary()
		_ = yym1884
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1885 := !z.EncBinary()
			yy2arr1885 := z.EncBasicHandle().StructToArray
			var yyq1885 [2]bool
			_, _, _ = yysep1885, yyq1885, yy2arr1885
			const yyr1885 bool = false
			yyq1885[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1885[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1885 int
			if yyr1885 || yy2arr1885 {
				r.EncodeArrayStart(2)
			} else {
				yynn1885 = 0
				for _, b := range yyq1885 {
					if b {
						yynn1885++
					}
				}
				r.EncodeMapStart(yynn1885)
				yynn1885 = 0
			}
			if yyr1885 || yy2arr1885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1885[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1887 := z.EncBinary()
						_ = yym1887
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1885[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1888 := z.EncBinary()
						_ = yym1888
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1885 || yy2arr1885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1885[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1890 := z.EncBinary()
						_ = yym1890
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1885[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1891 := z.EncBinary()
						_ = yym1891
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1885 || yy2arr1885 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAntiAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1892 := z.DecBinary()
	_ = yym1892
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1893 := r.ContainerType()
		if yyct1893 == codecSelferValueTypeMap1234 {
			yyl1893 := r.ReadMapStart()
			if yyl1893 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1893, d)
			}
		} else if yyct1893 == codecSelferValueTypeArray1234 {
			yyl1893 := r.ReadArrayStart()
			if yyl1893 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1893, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAntiAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1894Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1894Slc
	var yyhl1894 bool = l >= 0
	for yyj1894 := 0; ; yyj1894++ {
		if yyhl1894 {
			if yyj1894 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1894Slc = r.DecodeBytes(yys1894Slc, true, true)
		yys1894 := string(yys1894Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1894 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1895 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1896 := z.DecBinary()
				_ = yym1896
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1895), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1897 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1898 := z.DecBinary()
				_ = yym1898
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1897), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1894)
		} // end switch yys1894
	} // end for yyj1894
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAntiAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1899 int
	var yyb1899 bool
	var yyhl1899 bool = l >= 0
	yyj1899++
	if yyhl1899 {
		yyb1899 = yyj1899 > l
	} else {
		yyb1899 = r.CheckBreak()
	}
	if yyb1899 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1900 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1901 := z.DecBinary()
		_ = yym1901
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1900), d)
		}
	}
	yyj1899++
	if yyhl1899 {
		yyb1899 = yyj1899 > l
	} else {
		yyb1899 = r.CheckBreak()
	}
	if yyb1899 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1902 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1903 := z.DecBinary()
		_ = yym1903
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1902), d)
		}
	}
	for {
		yyj1899++
		if yyhl1899 {
			yyb1899 = yyj1899 > l
		} else {
			yyb1899 = r.CheckBreak()
		}
		if yyb1899 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1899-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *WeightedPodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1904 := z.EncBinary()
		_ = yym1904
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1905 := !z.EncBinary()
			yy2arr1905 := z.EncBasicHandle().StructToArray
			var yyq1905 [2]bool
			_, _, _ = yysep1905, yyq1905, yy2arr1905
			const yyr1905 bool = false
			var yynn1905 int
			if yyr1905 || yy2arr1905 {
				r.EncodeArrayStart(2)
			} else {
				yynn1905 = 2
				for _, b := range yyq1905 {
					if b {
						yynn1905++
					}
				}
				r.EncodeMapStart(yynn1905)
				yynn1905 = 0
			}
			if yyr1905 || yy2arr1905 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1907 := z.EncBinary()
				_ = yym1907
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1908 := z.EncBinary()
				_ = yym1908
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1905 || yy2arr1905 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1910 := &x.PodAffinityTerm
				yy1910.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podAffinityTerm"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1911 := &x.PodAffinityTerm
				yy1911.CodecEncodeSelf(e)
			}
			if yyr1905 || yy2arr1905 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *WeightedPodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1912 := z.DecBinary()
	_ = yym1912
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1913 := r.ContainerType()
		if yyct1913 == codecSelferValueTypeMap1234 {
			yyl1913 := r.ReadMapStart()
			if yyl1913 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1913, d)
			}
		} else if yyct1913 == codecSelferValueTypeArray1234 {
			yyl1913 := r.ReadArrayStart()
			if yyl1913 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1913, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1914Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1914Slc
	var yyhl1914 bool = l >= 0
	for yyj1914 := 0; ; yyj1914++ {
		if yyhl1914 {
			if yyj1914 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1914Slc = r.DecodeBytes(yys1914Slc, true, true)
		yys1914 := string(yys1914Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1914 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "podAffinityTerm":
			if r.TryDecodeAsNil() {
				x.PodAffinityTerm = PodAffinityTerm{}
			} else {
				yyv1916 := &x.PodAffinityTerm
				yyv1916.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1914)
		} // end switch yys1914
	} // end for yyj1914
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1917 int
	var yyb1917 bool
	var yyhl1917 bool = l >= 0
	yyj1917++
	if yyhl1917 {
		yyb1917 = yyj1917 > l
	} else {
		yyb1917 = r.CheckBreak()
	}
	if yyb1917 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj1917++
	if yyhl1917 {
		yyb1917 = yyj1917 > l
	} else {
		yyb1917 = r.CheckBreak()
	}
	if yyb1917 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodAffinityTerm = PodAffinityTerm{}
	} else {
		yyv1919 := &x.PodAffinityTerm
		yyv1919.CodecDecodeSelf(d)
	}
	for {
		yyj1917++
		if yyhl1917 {
			yyb1917 = yyj1917 > l
		} else {
			yyb1917 = r.CheckBreak()
		}
		if yyb1917 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1917-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1920 := z.EncBinary()
		_ = yym1920
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1921 := !z.EncBinary()
			yy2arr1921 := z.EncBasicHandle().StructToArray
			var yyq1921 [3]bool
			_, _, _ = yysep1921, yyq1921, yy2arr1921
			const yyr1921 bool = false
			yyq1921[0] = x.LabelSelector != nil
			yyq1921[2] = x.TopologyKey != ""
			var yynn1921 int
			if yyr1921 || yy2arr1921 {
				r.EncodeArrayStart(3)
			} else {
				yynn1921 = 1
				for _, b := range yyq1921 {
					if b {
						yynn1921++
					}
				}
				r.EncodeMapStart(yynn1921)
				yynn1921 = 0
			}
			if yyr1921 || yy2arr1921 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1921[0] {
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1923 := z.EncBinary()
						_ = yym1923
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1921[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym1924 := z.EncBinary()
						_ = yym1924
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				}
			}
			if yyr1921 || yy2arr1921 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1926 := z.EncBinary()
					_ = yym1926
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaces"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym1927 := z.EncBinary()
					_ = yym1927
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			}
			if yyr1921 || yy2arr1921 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1921[2] {
					yym1929 := z.EncBinary()
					_ = yym1929
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1921[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("topologyKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1930 := z.EncBinary()
					_ = yym1930
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				}
			}
			if yyr1921 || yy2arr1921 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1931 := z.DecBinary()
	_ = yym1931
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1932 := r.ContainerType()
		if yyct1932 == codecSelferValueTypeMap1234 {
			yyl1932 := r.ReadMapStart()
			if yyl1932 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1932, d)
			}
		} else if yyct1932 == codecSelferValueTypeArray1234 {
			yyl1932 := r.ReadArrayStart()
			if yyl1932 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1932, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1933Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1933Slc
	var yyhl1933 bool = l >= 0
	for yyj1933 := 0; ; yyj1933++ {
		if yyhl1933 {
			if yyj1933 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1933Slc = r.DecodeBytes(yys1933Slc, true, true)
		yys1933 := string(yys1933Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1933 {
		case "labelSelector":
			if r.TryDecodeAsNil() {
				if x.LabelSelector != nil {
					x.LabelSelector = nil
				}
			} else {
				if x.LabelSelector == nil {
					x.LabelSelector = new(pkg2_unversioned.LabelSelector)
				}
				yym1935 := z.DecBinary()
				_ = yym1935
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
				} else {
					z.DecFallback(x.LabelSelector, false)
				}
			}
		case "namespaces":
			if r.TryDecodeAsNil() {
				x.Namespaces = nil
			} else {
				yyv1936 := &x.Namespaces
				yym1937 := z.DecBinary()
				_ = yym1937
				if false {
				} else {
					z.F.DecSliceStringX(yyv1936, false, d)
				}
			}
		case "topologyKey":
			if r.TryDecodeAsNil() {
				x.TopologyKey = ""
			} else {
				x.TopologyKey = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1933)
		} // end switch yys1933
	} // end for yyj1933
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1939 int
	var yyb1939 bool
	var yyhl1939 bool = l >= 0
	yyj1939++
	if yyhl1939 {
		yyb1939 = yyj1939 > l
	} else {
		yyb1939 = r.CheckBreak()
	}
	if yyb1939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LabelSelector != nil {
			x.LabelSelector = nil
		}
	} else {
		if x.LabelSelector == nil {
			x.LabelSelector = new(pkg2_unversioned.LabelSelector)
		}
		yym1941 := z.DecBinary()
		_ = yym1941
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
		} else {
			z.DecFallback(x.LabelSelector, false)
		}
	}
	yyj1939++
	if yyhl1939 {
		yyb1939 = yyj1939 > l
	} else {
		yyb1939 = r.CheckBreak()
	}
	if yyb1939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespaces = nil
	} else {
		yyv1942 := &x.Namespaces
		yym1943 := z.DecBinary()
		_ = yym1943
		if false {
		} else {
			z.F.DecSliceStringX(yyv1942, false, d)
		}
	}
	yyj1939++
	if yyhl1939 {
		yyb1939 = yyj1939 > l
	} else {
		yyb1939 = r.CheckBreak()
	}
	if yyb1939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TopologyKey = ""
	} else {
		x.TopologyKey = string(r.DecodeString())
	}
	for {
		yyj1939++
		if yyhl1939 {
			yyb1939 = yyj1939 > l
		} else {
			yyb1939 = r.CheckBreak()
		}
		if yyb1939 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1939-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1945 := z.EncBinary()
		_ = yym1945
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1946 := !z.EncBinary()
			yy2arr1946 := z.EncBasicHandle().StructToArray
			var yyq1946 [2]bool
			_, _, _ = yysep1946, yyq1946, yy2arr1946
			const yyr1946 bool = false
			yyq1946[0] = x.RequiredDuringSchedulingIgnoredDuringExecution != nil
			yyq1946[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1946 int
			if yyr1946 || yy2arr1946 {
				r.EncodeArrayStart(2)
			} else {
				yynn1946 = 0
				for _, b := range yyq1946 {
					if b {
						yynn1946++
					}
				}
				r.EncodeMapStart(yynn1946)
				yynn1946 = 0
			}
			if yyr1946 || yy2arr1946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1946[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1946[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1946 || yy2arr1946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1946[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1949 := z.EncBinary()
						_ = yym1949
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1946[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1950 := z.EncBinary()
						_ = yym1950
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1946 || yy2arr1946 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1951 := z.DecBinary()
	_ = yym1951
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1952 := r.ContainerType()
		if yyct1952 == codecSelferValueTypeMap1234 {
			yyl1952 := r.ReadMapStart()
			if yyl1952 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1952, d)
			}
		} else if yyct1952 == codecSelferValueTypeArray1234 {
			yyl1952 := r.ReadArrayStart()
			if yyl1952 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1952, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1953Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1953Slc
	var yyhl1953 bool = l >= 0
	for yyj1953 := 0; ; yyj1953++ {
		if yyhl1953 {
			if yyj1953 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1953Slc = r.DecodeBytes(yys1953Slc, true, true)
		yys1953 := string(yys1953Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1953 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = nil
				}
			} else {
				if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
				}
				x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1955 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1956 := z.DecBinary()
				_ = yym1956
				if false {
				} else {
					h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv1955), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1953)
		} // end switch yys1953
	} // end for yyj1953
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1957 int
	var yyb1957 bool
	var yyhl1957 bool = l >= 0
	yyj1957++
	if yyhl1957 {
		yyb1957 = yyj1957 > l
	} else {
		yyb1957 = r.CheckBreak()
	}
	if yyb1957 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
	} else {
		if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
		}
		x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
	}
	yyj1957++
	if yyhl1957 {
		yyb1957 = yyj1957 > l
	} else {
		yyb1957 = r.CheckBreak()
	}
	if yyb1957 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1959 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1960 := z.DecBinary()
		_ = yym1960
		if false {
		} else {
			h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv1959), d)
		}
	}
	for {
		yyj1957++
		if yyhl1957 {
			yyb1957 = yyj1957 > l
		} else {
			yyb1957 = r.CheckBreak()
		}
		if yyb1957 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1957-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferredSchedulingTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1961 := z.EncBinary()
		_ = yym1961
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1962 := !z.EncBinary()
			yy2arr1962 := z.EncBasicHandle().StructToArray
			var yyq1962 [2]bool
			_, _, _ = yysep1962, yyq1962, yy2arr1962
			const yyr1962 bool = false
			var yynn1962 int
			if yyr1962 || yy2arr1962 {
				r.EncodeArrayStart(2)
			} else {
				yynn1962 = 2
				for _, b := range yyq1962 {
					if b {
						yynn1962++
					}
				}
				r.EncodeMapStart(yynn1962)
				yynn1962 = 0
			}
			if yyr1962 || yy2arr1962 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1964 := z.EncBinary()
				_ = yym1964
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1965 := z.EncBinary()
				_ = yym1965
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1962 || yy2arr1962 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1967 := &x.Preference
				yy1967.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("preference"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1968 := &x.Preference
				yy1968.CodecEncodeSelf(e)
			}
			if yyr1962 || yy2arr1962 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferredSchedulingTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1969 := z.DecBinary()
	_ = yym1969
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1970 := r.ContainerType()
		if yyct1970 == codecSelferValueTypeMap1234 {
			yyl1970 := r.ReadMapStart()
			if yyl1970 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1970, d)
			}
		} else if yyct1970 == codecSelferValueTypeArray1234 {
			yyl1970 := r.ReadArrayStart()
			if yyl1970 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1970, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1971Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1971Slc
	var yyhl1971 bool = l >= 0
	for yyj1971 := 0; ; yyj1971++ {
		if yyhl1971 {
			if yyj1971 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1971Slc = r.DecodeBytes(yys1971Slc, true, true)
		yys1971 := string(yys1971Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1971 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "preference":
			if r.TryDecodeAsNil() {
				x.Preference = NodeSelectorTerm{}
			} else {
				yyv1973 := &x.Preference
				yyv1973.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1971)
		} // end switch yys1971
	} // end for yyj1971
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1974 int
	var yyb1974 bool
	var yyhl1974 bool = l >= 0
	yyj1974++
	if yyhl1974 {
		yyb1974 = yyj1974 > l
	} else {
		yyb1974 = r.CheckBreak()
	}
	if yyb1974 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj1974++
	if yyhl1974 {
		yyb1974 = yyj1974 > l
	} else {
		yyb1974 = r.CheckBreak()
	}
	if yyb1974 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Preference = NodeSelectorTerm{}
	} else {
		yyv1976 := &x.Preference
		yyv1976.CodecDecodeSelf(d)
	}
	for {
		yyj1974++
		if yyhl1974 {
			yyb1974 = yyj1974 > l
		} else {
			yyb1974 = r.CheckBreak()
		}
		if yyb1974 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1974-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Taint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1977 := z.EncBinary()
		_ = yym1977
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1978 := !z.EncBinary()
			yy2arr1978 := z.EncBasicHandle().StructToArray
			var yyq1978 [3]bool
			_, _, _ = yysep1978, yyq1978, yy2arr1978
			const yyr1978 bool = false
			yyq1978[1] = x.Value != ""
			var yynn1978 int
			if yyr1978 || yy2arr1978 {
				r.EncodeArrayStart(3)
			} else {
				yynn1978 = 2
				for _, b := range yyq1978 {
					if b {
						yynn1978++
					}
				}
				r.EncodeMapStart(yynn1978)
				yynn1978 = 0
			}
			if yyr1978 || yy2arr1978 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1980 := z.EncBinary()
				_ = yym1980
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1981 := z.EncBinary()
				_ = yym1981
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1978 || yy2arr1978 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1978[1] {
					yym1983 := z.EncBinary()
					_ = yym1983
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1978[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1984 := z.EncBinary()
					_ = yym1984
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1978 || yy2arr1978 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Effect.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("effect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Effect.CodecEncodeSelf(e)
			}
			if yyr1978 || yy2arr1978 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Taint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1986 := z.DecBinary()
	_ = yym1986
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1987 := r.ContainerType()
		if yyct1987 == codecSelferValueTypeMap1234 {
			yyl1987 := r.ReadMapStart()
			if yyl1987 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1987, d)
			}
		} else if yyct1987 == codecSelferValueTypeArray1234 {
			yyl1987 := r.ReadArrayStart()
			if yyl1987 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1987, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Taint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1988Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1988Slc
	var yyhl1988 bool = l >= 0
	for yyj1988 := 0; ; yyj1988++ {
		if yyhl1988 {
			if yyj1988 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1988Slc = r.DecodeBytes(yys1988Slc, true, true)
		yys1988 := string(yys1988Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1988 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1988)
		} // end switch yys1988
	} // end for yyj1988
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Taint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1992 int
	var yyb1992 bool
	var yyhl1992 bool = l >= 0
	yyj1992++
	if yyhl1992 {
		yyb1992 = yyj1992 > l
	} else {
		yyb1992 = r.CheckBreak()
	}
	if yyb1992 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1992++
	if yyhl1992 {
		yyb1992 = yyj1992 > l
	} else {
		yyb1992 = r.CheckBreak()
	}
	if yyb1992 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1992++
	if yyhl1992 {
		yyb1992 = yyj1992 > l
	} else {
		yyb1992 = r.CheckBreak()
	}
	if yyb1992 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj1992++
		if yyhl1992 {
			yyb1992 = yyj1992 > l
		} else {
			yyb1992 = r.CheckBreak()
		}
		if yyb1992 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1992-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TaintEffect) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1996 := z.EncBinary()
	_ = yym1996
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TaintEffect) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1997 := z.DecBinary()
	_ = yym1997
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Toleration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1998 := z.EncBinary()
		_ = yym1998
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1999 := !z.EncBinary()
			yy2arr1999 := z.EncBasicHandle().StructToArray
			var yyq1999 [4]bool
			_, _, _ = yysep1999, yyq1999, yy2arr1999
			const yyr1999 bool = false
			yyq1999[0] = x.Key != ""
			yyq1999[1] = x.Operator != ""
			yyq1999[2] = x.Value != ""
			yyq1999[3] = x.Effect != ""
			var yynn1999 int
			if yyr1999 || yy2arr1999 {
				r.EncodeArrayStart(4)
			} else {
				yynn1999 = 0
				for _, b := range yyq1999 {
					if b {
						yynn1999++
					}
				}
				r.EncodeMapStart(yynn1999)
				yynn1999 = 0
			}
			if yyr1999 || yy2arr1999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1999[0] {
					yym2001 := z.EncBinary()
					_ = yym2001
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1999[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("key"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2002 := z.EncBinary()
					_ = yym2002
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				}
			}
			if yyr1999 || yy2arr1999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1999[1] {
					x.Operator.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1999[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("operator"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Operator.CodecEncodeSelf(e)
				}
			}
			if yyr1999 || yy2arr1999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1999[2] {
					yym2005 := z.EncBinary()
					_ = yym2005
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1999[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2006 := z.EncBinary()
					_ = yym2006
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1999 || yy2arr1999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1999[3] {
					x.Effect.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1999[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("effect"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Effect.CodecEncodeSelf(e)
				}
			}
			if yyr1999 || yy2arr1999 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Toleration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2008 := z.DecBinary()
	_ = yym2008
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2009 := r.ContainerType()
		if yyct2009 == codecSelferValueTypeMap1234 {
			yyl2009 := r.ReadMapStart()
			if yyl2009 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2009, d)
			}
		} else if yyct2009 == codecSelferValueTypeArray1234 {
			yyl2009 := r.ReadArrayStart()
			if yyl2009 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2009, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Toleration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2010Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2010Slc
	var yyhl2010 bool = l >= 0
	for yyj2010 := 0; ; yyj2010++ {
		if yyhl2010 {
			if yyj2010 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2010Slc = r.DecodeBytes(yys2010Slc, true, true)
		yys2010 := string(yys2010Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2010 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = TolerationOperator(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2010)
		} // end switch yys2010
	} // end for yyj2010
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Toleration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2015 int
	var yyb2015 bool
	var yyhl2015 bool = l >= 0
	yyj2015++
	if yyhl2015 {
		yyb2015 = yyj2015 > l
	} else {
		yyb2015 = r.CheckBreak()
	}
	if yyb2015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj2015++
	if yyhl2015 {
		yyb2015 = yyj2015 > l
	} else {
		yyb2015 = r.CheckBreak()
	}
	if yyb2015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = TolerationOperator(r.DecodeString())
	}
	yyj2015++
	if yyhl2015 {
		yyb2015 = yyj2015 > l
	} else {
		yyb2015 = r.CheckBreak()
	}
	if yyb2015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj2015++
	if yyhl2015 {
		yyb2015 = yyj2015 > l
	} else {
		yyb2015 = r.CheckBreak()
	}
	if yyb2015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj2015++
		if yyhl2015 {
			yyb2015 = yyj2015 > l
		} else {
			yyb2015 = r.CheckBreak()
		}
		if yyb2015 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2015-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TolerationOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2020 := z.EncBinary()
	_ = yym2020
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TolerationOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2021 := z.DecBinary()
	_ = yym2021
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2022 := z.EncBinary()
		_ = yym2022
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2023 := !z.EncBinary()
			yy2arr2023 := z.EncBasicHandle().StructToArray
			var yyq2023 [17]bool
			_, _, _ = yysep2023, yyq2023, yy2arr2023
			const yyr2023 bool = false
			yyq2023[0] = len(x.Volumes) != 0
			yyq2023[2] = x.RestartPolicy != ""
			yyq2023[3] = x.TerminationGracePeriodSeconds != nil
			yyq2023[4] = x.ActiveDeadlineSeconds != nil
			yyq2023[5] = x.DNSPolicy != ""
			yyq2023[6] = len(x.NodeSelector) != 0
			yyq2023[7] = x.ServiceAccountName != ""
			yyq2023[8] = x.DeprecatedServiceAccount != ""
			yyq2023[9] = x.NodeName != ""
			yyq2023[10] = x.HostNetwork != false
			yyq2023[11] = x.HostPID != false
			yyq2023[12] = x.HostIPC != false
			yyq2023[13] = x.SecurityContext != nil
			yyq2023[14] = len(x.ImagePullSecrets) != 0
			yyq2023[15] = x.Hostname != ""
			yyq2023[16] = x.Subdomain != ""
			var yynn2023 int
			if yyr2023 || yy2arr2023 {
				r.EncodeArrayStart(17)
			} else {
				yynn2023 = 1
				for _, b := range yyq2023 {
					if b {
						yynn2023++
					}
				}
				r.EncodeMapStart(yynn2023)
				yynn2023 = 0
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[0] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym2025 := z.EncBinary()
						_ = yym2025
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym2026 := z.EncBinary()
						_ = yym2026
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2028 := z.EncBinary()
					_ = yym2028
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2029 := z.EncBinary()
					_ = yym2029
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2032 := *x.TerminationGracePeriodSeconds
						yym2033 := z.EncBinary()
						_ = yym2033
						if false {
						} else {
							r.EncodeInt(int64(yy2032))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2034 := *x.TerminationGracePeriodSeconds
						yym2035 := z.EncBinary()
						_ = yym2035
						if false {
						} else {
							r.EncodeInt(int64(yy2034))
						}
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2037 := *x.ActiveDeadlineSeconds
						yym2038 := z.EncBinary()
						_ = yym2038
						if false {
						} else {
							r.EncodeInt(int64(yy2037))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2039 := *x.ActiveDeadlineSeconds
						yym2040 := z.EncBinary()
						_ = yym2040
						if false {
						} else {
							r.EncodeInt(int64(yy2039))
						}
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2043 := z.EncBinary()
						_ = yym2043
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2044 := z.EncBinary()
						_ = yym2044
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[7] {
					yym2046 := z.EncBinary()
					_ = yym2046
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2047 := z.EncBinary()
					_ = yym2047
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[8] {
					yym2049 := z.EncBinary()
					_ = yym2049
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2050 := z.EncBinary()
					_ = yym2050
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[9] {
					yym2052 := z.EncBinary()
					_ = yym2052
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2053 := z.EncBinary()
					_ = yym2053
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[10] {
					yym2055 := z.EncBinary()
					_ = yym2055
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2023[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2056 := z.EncBinary()
					_ = yym2056
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[11] {
					yym2058 := z.EncBinary()
					_ = yym2058
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2023[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2059 := z.EncBinary()
					_ = yym2059
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[12] {
					yym2061 := z.EncBinary()
					_ = yym2061
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2023[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2062 := z.EncBinary()
					_ = yym2062
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[13] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[14] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2065 := z.EncBinary()
						_ = yym2065
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2023[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2066 := z.EncBinary()
						_ = yym2066
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[15] {
					yym2068 := z.EncBinary()
					_ = yym2068
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2069 := z.EncBinary()
					_ = yym2069
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2023[16] {
					yym2071 := z.EncBinary()
					_ = yym2071
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2023[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subdomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2072 := z.EncBinary()
					_ = yym2072
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				}
			}
			if yyr2023 || yy2arr2023 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2073 := z.DecBinary()
	_ = yym2073
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2074 := r.ContainerType()
		if yyct2074 == codecSelferValueTypeMap1234 {
			yyl2074 := r.ReadMapStart()
			if yyl2074 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2074, d)
			}
		} else if yyct2074 == codecSelferValueTypeArray1234 {
			yyl2074 := r.ReadArrayStart()
			if yyl2074 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2074, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2075Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2075Slc
	var yyhl2075 bool = l >= 0
	for yyj2075 := 0; ; yyj2075++ {
		if yyhl2075 {
			if yyj2075 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2075Slc = r.DecodeBytes(yys2075Slc, true, true)
		yys2075 := string(yys2075Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2075 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv2076 := &x.Volumes
				yym2077 := z.DecBinary()
				_ = yym2077
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv2076), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv2078 := &x.Containers
				yym2079 := z.DecBinary()
				_ = yym2079
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv2078), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym2082 := z.DecBinary()
				_ = yym2082
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym2084 := z.DecBinary()
				_ = yym2084
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv2086 := &x.NodeSelector
				yym2087 := z.DecBinary()
				_ = yym2087
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2086, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "serviceAccount":
			if r.TryDecodeAsNil() {
				x.DeprecatedServiceAccount = ""
			} else {
				x.DeprecatedServiceAccount = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2095 := &x.ImagePullSecrets
				yym2096 := z.DecBinary()
				_ = yym2096
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2095), d)
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "subdomain":
			if r.TryDecodeAsNil() {
				x.Subdomain = ""
			} else {
				x.Subdomain = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2075)
		} // end switch yys2075
	} // end for yyj2075
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2099 int
	var yyb2099 bool
	var yyhl2099 bool = l >= 0
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv2100 := &x.Volumes
		yym2101 := z.DecBinary()
		_ = yym2101
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv2100), d)
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv2102 := &x.Containers
		yym2103 := z.DecBinary()
		_ = yym2103
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv2102), d)
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym2106 := z.DecBinary()
		_ = yym2106
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym2108 := z.DecBinary()
		_ = yym2108
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv2110 := &x.NodeSelector
		yym2111 := z.DecBinary()
		_ = yym2111
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2110, false, d)
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedServiceAccount = ""
	} else {
		x.DeprecatedServiceAccount = string(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2119 := &x.ImagePullSecrets
		yym2120 := z.DecBinary()
		_ = yym2120
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2119), d)
		}
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2099++
	if yyhl2099 {
		yyb2099 = yyj2099 > l
	} else {
		yyb2099 = r.CheckBreak()
	}
	if yyb2099 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subdomain = ""
	} else {
		x.Subdomain = string(r.DecodeString())
	}
	for {
		yyj2099++
		if yyhl2099 {
			yyb2099 = yyj2099 > l
		} else {
			yyb2099 = r.CheckBreak()
		}
		if yyb2099 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2099-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2123 := z.EncBinary()
		_ = yym2123
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2124 := !z.EncBinary()
			yy2arr2124 := z.EncBasicHandle().StructToArray
			var yyq2124 [5]bool
			_, _, _ = yysep2124, yyq2124, yy2arr2124
			const yyr2124 bool = false
			yyq2124[0] = x.SELinuxOptions != nil
			yyq2124[1] = x.RunAsUser != nil
			yyq2124[2] = x.RunAsNonRoot != nil
			yyq2124[3] = len(x.SupplementalGroups) != 0
			yyq2124[4] = x.FSGroup != nil
			var yynn2124 int
			if yyr2124 || yy2arr2124 {
				r.EncodeArrayStart(5)
			} else {
				yynn2124 = 0
				for _, b := range yyq2124 {
					if b {
						yynn2124++
					}
				}
				r.EncodeMapStart(yynn2124)
				yynn2124 = 0
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2124[0] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2124[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2124[1] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2127 := *x.RunAsUser
						yym2128 := z.EncBinary()
						_ = yym2128
						if false {
						} else {
							r.EncodeInt(int64(yy2127))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2124[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2129 := *x.RunAsUser
						yym2130 := z.EncBinary()
						_ = yym2130
						if false {
						} else {
							r.EncodeInt(int64(yy2129))
						}
					}
				}
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2124[2] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2132 := *x.RunAsNonRoot
						yym2133 := z.EncBinary()
						_ = yym2133
						if false {
						} else {
							r.EncodeBool(bool(yy2132))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2124[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2134 := *x.RunAsNonRoot
						yym2135 := z.EncBinary()
						_ = yym2135
						if false {
						} else {
							r.EncodeBool(bool(yy2134))
						}
					}
				}
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2124[3] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2137 := z.EncBinary()
						_ = yym2137
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2124[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2138 := z.EncBinary()
						_ = yym2138
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2124[4] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2140 := *x.FSGroup
						yym2141 := z.EncBinary()
						_ = yym2141
						if false {
						} else {
							r.EncodeInt(int64(yy2140))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2124[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2142 := *x.FSGroup
						yym2143 := z.EncBinary()
						_ = yym2143
						if false {
						} else {
							r.EncodeInt(int64(yy2142))
						}
					}
				}
			}
			if yyr2124 || yy2arr2124 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2144 := z.DecBinary()
	_ = yym2144
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2145 := r.ContainerType()
		if yyct2145 == codecSelferValueTypeMap1234 {
			yyl2145 := r.ReadMapStart()
			if yyl2145 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2145, d)
			}
		} else if yyct2145 == codecSelferValueTypeArray1234 {
			yyl2145 := r.ReadArrayStart()
			if yyl2145 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2145, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2146Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2146Slc
	var yyhl2146 bool = l >= 0
	for yyj2146 := 0; ; yyj2146++ {
		if yyhl2146 {
			if yyj2146 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2146Slc = r.DecodeBytes(yys2146Slc, true, true)
		yys2146 := string(yys2146Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2146 {
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym2149 := z.DecBinary()
				_ = yym2149
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym2151 := z.DecBinary()
				_ = yym2151
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv2152 := &x.SupplementalGroups
				yym2153 := z.DecBinary()
				_ = yym2153
				if false {
				} else {
					z.F.DecSliceInt64X(yyv2152, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym2155 := z.DecBinary()
				_ = yym2155
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2146)
		} // end switch yys2146
	} // end for yyj2146
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2156 int
	var yyb2156 bool
	var yyhl2156 bool = l >= 0
	yyj2156++
	if yyhl2156 {
		yyb2156 = yyj2156 > l
	} else {
		yyb2156 = r.CheckBreak()
	}
	if yyb2156 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj2156++
	if yyhl2156 {
		yyb2156 = yyj2156 > l
	} else {
		yyb2156 = r.CheckBreak()
	}
	if yyb2156 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym2159 := z.DecBinary()
		_ = yym2159
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj2156++
	if yyhl2156 {
		yyb2156 = yyj2156 > l
	} else {
		yyb2156 = r.CheckBreak()
	}
	if yyb2156 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym2161 := z.DecBinary()
		_ = yym2161
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj2156++
	if yyhl2156 {
		yyb2156 = yyj2156 > l
	} else {
		yyb2156 = r.CheckBreak()
	}
	if yyb2156 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv2162 := &x.SupplementalGroups
		yym2163 := z.DecBinary()
		_ = yym2163
		if false {
		} else {
			z.F.DecSliceInt64X(yyv2162, false, d)
		}
	}
	yyj2156++
	if yyhl2156 {
		yyb2156 = yyj2156 > l
	} else {
		yyb2156 = r.CheckBreak()
	}
	if yyb2156 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym2165 := z.DecBinary()
		_ = yym2165
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2156++
		if yyhl2156 {
			yyb2156 = yyj2156 > l
		} else {
			yyb2156 = r.CheckBreak()
		}
		if yyb2156 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2156-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2166 := z.EncBinary()
		_ = yym2166
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2167 := !z.EncBinary()
			yy2arr2167 := z.EncBasicHandle().StructToArray
			var yyq2167 [8]bool
			_, _, _ = yysep2167, yyq2167, yy2arr2167
			const yyr2167 bool = false
			yyq2167[0] = x.Phase != ""
			yyq2167[1] = len(x.Conditions) != 0
			yyq2167[2] = x.Message != ""
			yyq2167[3] = x.Reason != ""
			yyq2167[4] = x.HostIP != ""
			yyq2167[5] = x.PodIP != ""
			yyq2167[6] = x.StartTime != nil
			yyq2167[7] = len(x.ContainerStatuses) != 0
			var yynn2167 int
			if yyr2167 || yy2arr2167 {
				r.EncodeArrayStart(8)
			} else {
				yynn2167 = 0
				for _, b := range yyq2167 {
					if b {
						yynn2167++
					}
				}
				r.EncodeMapStart(yynn2167)
				yynn2167 = 0
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2167[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2170 := z.EncBinary()
						_ = yym2170
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2171 := z.EncBinary()
						_ = yym2171
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[2] {
					yym2173 := z.EncBinary()
					_ = yym2173
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2167[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2174 := z.EncBinary()
					_ = yym2174
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[3] {
					yym2176 := z.EncBinary()
					_ = yym2176
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2167[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2177 := z.EncBinary()
					_ = yym2177
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[4] {
					yym2179 := z.EncBinary()
					_ = yym2179
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2167[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2180 := z.EncBinary()
					_ = yym2180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[5] {
					yym2182 := z.EncBinary()
					_ = yym2182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2167[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2183 := z.EncBinary()
					_ = yym2183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2185 := z.EncBinary()
						_ = yym2185
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2185 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2185 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2186 := z.EncBinary()
						_ = yym2186
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2186 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2186 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2167[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2188 := z.EncBinary()
						_ = yym2188
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2167[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2189 := z.EncBinary()
						_ = yym2189
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr2167 || yy2arr2167 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2190 := z.DecBinary()
	_ = yym2190
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2191 := r.ContainerType()
		if yyct2191 == codecSelferValueTypeMap1234 {
			yyl2191 := r.ReadMapStart()
			if yyl2191 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2191, d)
			}
		} else if yyct2191 == codecSelferValueTypeArray1234 {
			yyl2191 := r.ReadArrayStart()
			if yyl2191 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2191, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2192Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2192Slc
	var yyhl2192 bool = l >= 0
	for yyj2192 := 0; ; yyj2192++ {
		if yyhl2192 {
			if yyj2192 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2192Slc = r.DecodeBytes(yys2192Slc, true, true)
		yys2192 := string(yys2192Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2192 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2194 := &x.Conditions
				yym2195 := z.DecBinary()
				_ = yym2195
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv2194), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym2201 := z.DecBinary()
				_ = yym2201
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym2201 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym2201 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv2202 := &x.ContainerStatuses
				yym2203 := z.DecBinary()
				_ = yym2203
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv2202), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2192)
		} // end switch yys2192
	} // end for yyj2192
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2204 int
	var yyb2204 bool
	var yyhl2204 bool = l >= 0
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2206 := &x.Conditions
		yym2207 := z.DecBinary()
		_ = yym2207
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv2206), d)
		}
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym2213 := z.DecBinary()
		_ = yym2213
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym2213 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym2213 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj2204++
	if yyhl2204 {
		yyb2204 = yyj2204 > l
	} else {
		yyb2204 = r.CheckBreak()
	}
	if yyb2204 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv2214 := &x.ContainerStatuses
		yym2215 := z.DecBinary()
		_ = yym2215
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv2214), d)
		}
	}
	for {
		yyj2204++
		if yyhl2204 {
			yyb2204 = yyj2204 > l
		} else {
			yyb2204 = r.CheckBreak()
		}
		if yyb2204 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2204-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2216 := z.EncBinary()
		_ = yym2216
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2217 := !z.EncBinary()
			yy2arr2217 := z.EncBasicHandle().StructToArray
			var yyq2217 [4]bool
			_, _, _ = yysep2217, yyq2217, yy2arr2217
			const yyr2217 bool = false
			yyq2217[0] = x.Kind != ""
			yyq2217[1] = x.APIVersion != ""
			yyq2217[2] = true
			yyq2217[3] = true
			var yynn2217 int
			if yyr2217 || yy2arr2217 {
				r.EncodeArrayStart(4)
			} else {
				yynn2217 = 0
				for _, b := range yyq2217 {
					if b {
						yynn2217++
					}
				}
				r.EncodeMapStart(yynn2217)
				yynn2217 = 0
			}
			if yyr2217 || yy2arr2217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2217[0] {
					yym2219 := z.EncBinary()
					_ = yym2219
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2217[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2220 := z.EncBinary()
					_ = yym2220
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2217 || yy2arr2217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2217[1] {
					yym2222 := z.EncBinary()
					_ = yym2222
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2217[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2223 := z.EncBinary()
					_ = yym2223
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2217 || yy2arr2217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2217[2] {
					yy2225 := &x.ObjectMeta
					yy2225.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2217[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2226 := &x.ObjectMeta
					yy2226.CodecEncodeSelf(e)
				}
			}
			if yyr2217 || yy2arr2217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2217[3] {
					yy2228 := &x.Status
					yy2228.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2217[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2229 := &x.Status
					yy2229.CodecEncodeSelf(e)
				}
			}
			if yyr2217 || yy2arr2217 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2230 := z.DecBinary()
	_ = yym2230
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2231 := r.ContainerType()
		if yyct2231 == codecSelferValueTypeMap1234 {
			yyl2231 := r.ReadMapStart()
			if yyl2231 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2231, d)
			}
		} else if yyct2231 == codecSelferValueTypeArray1234 {
			yyl2231 := r.ReadArrayStart()
			if yyl2231 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2231, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2232Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2232Slc
	var yyhl2232 bool = l >= 0
	for yyj2232 := 0; ; yyj2232++ {
		if yyhl2232 {
			if yyj2232 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2232Slc = r.DecodeBytes(yys2232Slc, true, true)
		yys2232 := string(yys2232Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2232 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2235 := &x.ObjectMeta
				yyv2235.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2236 := &x.Status
				yyv2236.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2232)
		} // end switch yys2232
	} // end for yyj2232
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2237 int
	var yyb2237 bool
	var yyhl2237 bool = l >= 0
	yyj2237++
	if yyhl2237 {
		yyb2237 = yyj2237 > l
	} else {
		yyb2237 = r.CheckBreak()
	}
	if yyb2237 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2237++
	if yyhl2237 {
		yyb2237 = yyj2237 > l
	} else {
		yyb2237 = r.CheckBreak()
	}
	if yyb2237 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2237++
	if yyhl2237 {
		yyb2237 = yyj2237 > l
	} else {
		yyb2237 = r.CheckBreak()
	}
	if yyb2237 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2240 := &x.ObjectMeta
		yyv2240.CodecDecodeSelf(d)
	}
	yyj2237++
	if yyhl2237 {
		yyb2237 = yyj2237 > l
	} else {
		yyb2237 = r.CheckBreak()
	}
	if yyb2237 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2241 := &x.Status
		yyv2241.CodecDecodeSelf(d)
	}
	for {
		yyj2237++
		if yyhl2237 {
			yyb2237 = yyj2237 > l
		} else {
			yyb2237 = r.CheckBreak()
		}
		if yyb2237 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2237-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2242 := z.EncBinary()
		_ = yym2242
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2243 := !z.EncBinary()
			yy2arr2243 := z.EncBasicHandle().StructToArray
			var yyq2243 [5]bool
			_, _, _ = yysep2243, yyq2243, yy2arr2243
			const yyr2243 bool = false
			yyq2243[0] = x.Kind != ""
			yyq2243[1] = x.APIVersion != ""
			yyq2243[2] = true
			yyq2243[3] = true
			yyq2243[4] = true
			var yynn2243 int
			if yyr2243 || yy2arr2243 {
				r.EncodeArrayStart(5)
			} else {
				yynn2243 = 0
				for _, b := range yyq2243 {
					if b {
						yynn2243++
					}
				}
				r.EncodeMapStart(yynn2243)
				yynn2243 = 0
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2243[0] {
					yym2245 := z.EncBinary()
					_ = yym2245
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2243[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2246 := z.EncBinary()
					_ = yym2246
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2243[1] {
					yym2248 := z.EncBinary()
					_ = yym2248
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2243[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2249 := z.EncBinary()
					_ = yym2249
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2243[2] {
					yy2251 := &x.ObjectMeta
					yy2251.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2243[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2252 := &x.ObjectMeta
					yy2252.CodecEncodeSelf(e)
				}
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2243[3] {
					yy2254 := &x.Spec
					yy2254.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2243[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2255 := &x.Spec
					yy2255.CodecEncodeSelf(e)
				}
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2243[4] {
					yy2257 := &x.Status
					yy2257.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2243[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2258 := &x.Status
					yy2258.CodecEncodeSelf(e)
				}
			}
			if yyr2243 || yy2arr2243 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2259 := z.DecBinary()
	_ = yym2259
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2260 := r.ContainerType()
		if yyct2260 == codecSelferValueTypeMap1234 {
			yyl2260 := r.ReadMapStart()
			if yyl2260 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2260, d)
			}
		} else if yyct2260 == codecSelferValueTypeArray1234 {
			yyl2260 := r.ReadArrayStart()
			if yyl2260 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2260, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2261Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2261Slc
	var yyhl2261 bool = l >= 0
	for yyj2261 := 0; ; yyj2261++ {
		if yyhl2261 {
			if yyj2261 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2261Slc = r.DecodeBytes(yys2261Slc, true, true)
		yys2261 := string(yys2261Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2261 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2264 := &x.ObjectMeta
				yyv2264.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2265 := &x.Spec
				yyv2265.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2266 := &x.Status
				yyv2266.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2261)
		} // end switch yys2261
	} // end for yyj2261
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2267 int
	var yyb2267 bool
	var yyhl2267 bool = l >= 0
	yyj2267++
	if yyhl2267 {
		yyb2267 = yyj2267 > l
	} else {
		yyb2267 = r.CheckBreak()
	}
	if yyb2267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2267++
	if yyhl2267 {
		yyb2267 = yyj2267 > l
	} else {
		yyb2267 = r.CheckBreak()
	}
	if yyb2267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2267++
	if yyhl2267 {
		yyb2267 = yyj2267 > l
	} else {
		yyb2267 = r.CheckBreak()
	}
	if yyb2267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2270 := &x.ObjectMeta
		yyv2270.CodecDecodeSelf(d)
	}
	yyj2267++
	if yyhl2267 {
		yyb2267 = yyj2267 > l
	} else {
		yyb2267 = r.CheckBreak()
	}
	if yyb2267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2271 := &x.Spec
		yyv2271.CodecDecodeSelf(d)
	}
	yyj2267++
	if yyhl2267 {
		yyb2267 = yyj2267 > l
	} else {
		yyb2267 = r.CheckBreak()
	}
	if yyb2267 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2272 := &x.Status
		yyv2272.CodecDecodeSelf(d)
	}
	for {
		yyj2267++
		if yyhl2267 {
			yyb2267 = yyj2267 > l
		} else {
			yyb2267 = r.CheckBreak()
		}
		if yyb2267 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2267-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2273 := z.EncBinary()
		_ = yym2273
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2274 := !z.EncBinary()
			yy2arr2274 := z.EncBasicHandle().StructToArray
			var yyq2274 [4]bool
			_, _, _ = yysep2274, yyq2274, yy2arr2274
			const yyr2274 bool = false
			yyq2274[0] = x.Kind != ""
			yyq2274[1] = x.APIVersion != ""
			yyq2274[2] = true
			var yynn2274 int
			if yyr2274 || yy2arr2274 {
				r.EncodeArrayStart(4)
			} else {
				yynn2274 = 1
				for _, b := range yyq2274 {
					if b {
						yynn2274++
					}
				}
				r.EncodeMapStart(yynn2274)
				yynn2274 = 0
			}
			if yyr2274 || yy2arr2274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2274[0] {
					yym2276 := z.EncBinary()
					_ = yym2276
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2274[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2277 := z.EncBinary()
					_ = yym2277
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2274 || yy2arr2274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2274[1] {
					yym2279 := z.EncBinary()
					_ = yym2279
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2274[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2280 := z.EncBinary()
					_ = yym2280
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2274 || yy2arr2274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2274[2] {
					yy2282 := &x.ListMeta
					yym2283 := z.EncBinary()
					_ = yym2283
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2282) {
					} else {
						z.EncFallback(yy2282)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2274[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2284 := &x.ListMeta
					yym2285 := z.EncBinary()
					_ = yym2285
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2284) {
					} else {
						z.EncFallback(yy2284)
					}
				}
			}
			if yyr2274 || yy2arr2274 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2287 := z.EncBinary()
					_ = yym2287
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2288 := z.EncBinary()
					_ = yym2288
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr2274 || yy2arr2274 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2289 := z.DecBinary()
	_ = yym2289
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2290 := r.ContainerType()
		if yyct2290 == codecSelferValueTypeMap1234 {
			yyl2290 := r.ReadMapStart()
			if yyl2290 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2290, d)
			}
		} else if yyct2290 == codecSelferValueTypeArray1234 {
			yyl2290 := r.ReadArrayStart()
			if yyl2290 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2290, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2291Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2291Slc
	var yyhl2291 bool = l >= 0
	for yyj2291 := 0; ; yyj2291++ {
		if yyhl2291 {
			if yyj2291 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2291Slc = r.DecodeBytes(yys2291Slc, true, true)
		yys2291 := string(yys2291Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2291 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2294 := &x.ListMeta
				yym2295 := z.DecBinary()
				_ = yym2295
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2294) {
				} else {
					z.DecFallback(yyv2294, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2296 := &x.Items
				yym2297 := z.DecBinary()
				_ = yym2297
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv2296), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2291)
		} // end switch yys2291
	} // end for yyj2291
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2298 int
	var yyb2298 bool
	var yyhl2298 bool = l >= 0
	yyj2298++
	if yyhl2298 {
		yyb2298 = yyj2298 > l
	} else {
		yyb2298 = r.CheckBreak()
	}
	if yyb2298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2298++
	if yyhl2298 {
		yyb2298 = yyj2298 > l
	} else {
		yyb2298 = r.CheckBreak()
	}
	if yyb2298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2298++
	if yyhl2298 {
		yyb2298 = yyj2298 > l
	} else {
		yyb2298 = r.CheckBreak()
	}
	if yyb2298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2301 := &x.ListMeta
		yym2302 := z.DecBinary()
		_ = yym2302
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2301) {
		} else {
			z.DecFallback(yyv2301, false)
		}
	}
	yyj2298++
	if yyhl2298 {
		yyb2298 = yyj2298 > l
	} else {
		yyb2298 = r.CheckBreak()
	}
	if yyb2298 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2303 := &x.Items
		yym2304 := z.DecBinary()
		_ = yym2304
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv2303), d)
		}
	}
	for {
		yyj2298++
		if yyhl2298 {
			yyb2298 = yyj2298 > l
		} else {
			yyb2298 = r.CheckBreak()
		}
		if yyb2298 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2298-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2305 := z.EncBinary()
		_ = yym2305
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2306 := !z.EncBinary()
			yy2arr2306 := z.EncBasicHandle().StructToArray
			var yyq2306 [2]bool
			_, _, _ = yysep2306, yyq2306, yy2arr2306
			const yyr2306 bool = false
			yyq2306[0] = true
			yyq2306[1] = true
			var yynn2306 int
			if yyr2306 || yy2arr2306 {
				r.EncodeArrayStart(2)
			} else {
				yynn2306 = 0
				for _, b := range yyq2306 {
					if b {
						yynn2306++
					}
				}
				r.EncodeMapStart(yynn2306)
				yynn2306 = 0
			}
			if yyr2306 || yy2arr2306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2306[0] {
					yy2308 := &x.ObjectMeta
					yy2308.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2306[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2309 := &x.ObjectMeta
					yy2309.CodecEncodeSelf(e)
				}
			}
			if yyr2306 || yy2arr2306 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2306[1] {
					yy2311 := &x.Spec
					yy2311.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2306[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2312 := &x.Spec
					yy2312.CodecEncodeSelf(e)
				}
			}
			if yyr2306 || yy2arr2306 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2313 := z.DecBinary()
	_ = yym2313
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2314 := r.ContainerType()
		if yyct2314 == codecSelferValueTypeMap1234 {
			yyl2314 := r.ReadMapStart()
			if yyl2314 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2314, d)
			}
		} else if yyct2314 == codecSelferValueTypeArray1234 {
			yyl2314 := r.ReadArrayStart()
			if yyl2314 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2314, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2315Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2315Slc
	var yyhl2315 bool = l >= 0
	for yyj2315 := 0; ; yyj2315++ {
		if yyhl2315 {
			if yyj2315 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2315Slc = r.DecodeBytes(yys2315Slc, true, true)
		yys2315 := string(yys2315Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2315 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2316 := &x.ObjectMeta
				yyv2316.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2317 := &x.Spec
				yyv2317.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2315)
		} // end switch yys2315
	} // end for yyj2315
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2318 int
	var yyb2318 bool
	var yyhl2318 bool = l >= 0
	yyj2318++
	if yyhl2318 {
		yyb2318 = yyj2318 > l
	} else {
		yyb2318 = r.CheckBreak()
	}
	if yyb2318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2319 := &x.ObjectMeta
		yyv2319.CodecDecodeSelf(d)
	}
	yyj2318++
	if yyhl2318 {
		yyb2318 = yyj2318 > l
	} else {
		yyb2318 = r.CheckBreak()
	}
	if yyb2318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2320 := &x.Spec
		yyv2320.CodecDecodeSelf(d)
	}
	for {
		yyj2318++
		if yyhl2318 {
			yyb2318 = yyj2318 > l
		} else {
			yyb2318 = r.CheckBreak()
		}
		if yyb2318 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2318-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2321 := z.EncBinary()
		_ = yym2321
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2322 := !z.EncBinary()
			yy2arr2322 := z.EncBasicHandle().StructToArray
			var yyq2322 [4]bool
			_, _, _ = yysep2322, yyq2322, yy2arr2322
			const yyr2322 bool = false
			yyq2322[0] = x.Kind != ""
			yyq2322[1] = x.APIVersion != ""
			yyq2322[2] = true
			yyq2322[3] = true
			var yynn2322 int
			if yyr2322 || yy2arr2322 {
				r.EncodeArrayStart(4)
			} else {
				yynn2322 = 0
				for _, b := range yyq2322 {
					if b {
						yynn2322++
					}
				}
				r.EncodeMapStart(yynn2322)
				yynn2322 = 0
			}
			if yyr2322 || yy2arr2322 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2322[0] {
					yym2324 := z.EncBinary()
					_ = yym2324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2322[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2325 := z.EncBinary()
					_ = yym2325
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2322 || yy2arr2322 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2322[1] {
					yym2327 := z.EncBinary()
					_ = yym2327
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2322[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2328 := z.EncBinary()
					_ = yym2328
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2322 || yy2arr2322 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2322[2] {
					yy2330 := &x.ObjectMeta
					yy2330.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2322[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2331 := &x.ObjectMeta
					yy2331.CodecEncodeSelf(e)
				}
			}
			if yyr2322 || yy2arr2322 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2322[3] {
					yy2333 := &x.Template
					yy2333.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2322[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2334 := &x.Template
					yy2334.CodecEncodeSelf(e)
				}
			}
			if yyr2322 || yy2arr2322 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2335 := z.DecBinary()
	_ = yym2335
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2336 := r.ContainerType()
		if yyct2336 == codecSelferValueTypeMap1234 {
			yyl2336 := r.ReadMapStart()
			if yyl2336 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2336, d)
			}
		} else if yyct2336 == codecSelferValueTypeArray1234 {
			yyl2336 := r.ReadArrayStart()
			if yyl2336 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2336, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2337Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2337Slc
	var yyhl2337 bool = l >= 0
	for yyj2337 := 0; ; yyj2337++ {
		if yyhl2337 {
			if yyj2337 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2337Slc = r.DecodeBytes(yys2337Slc, true, true)
		yys2337 := string(yys2337Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2337 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2340 := &x.ObjectMeta
				yyv2340.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv2341 := &x.Template
				yyv2341.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2337)
		} // end switch yys2337
	} // end for yyj2337
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2342 int
	var yyb2342 bool
	var yyhl2342 bool = l >= 0
	yyj2342++
	if yyhl2342 {
		yyb2342 = yyj2342 > l
	} else {
		yyb2342 = r.CheckBreak()
	}
	if yyb2342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2342++
	if yyhl2342 {
		yyb2342 = yyj2342 > l
	} else {
		yyb2342 = r.CheckBreak()
	}
	if yyb2342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2342++
	if yyhl2342 {
		yyb2342 = yyj2342 > l
	} else {
		yyb2342 = r.CheckBreak()
	}
	if yyb2342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2345 := &x.ObjectMeta
		yyv2345.CodecDecodeSelf(d)
	}
	yyj2342++
	if yyhl2342 {
		yyb2342 = yyj2342 > l
	} else {
		yyb2342 = r.CheckBreak()
	}
	if yyb2342 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv2346 := &x.Template
		yyv2346.CodecDecodeSelf(d)
	}
	for {
		yyj2342++
		if yyhl2342 {
			yyb2342 = yyj2342 > l
		} else {
			yyb2342 = r.CheckBreak()
		}
		if yyb2342 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2342-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2347 := z.EncBinary()
		_ = yym2347
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2348 := !z.EncBinary()
			yy2arr2348 := z.EncBasicHandle().StructToArray
			var yyq2348 [4]bool
			_, _, _ = yysep2348, yyq2348, yy2arr2348
			const yyr2348 bool = false
			yyq2348[0] = x.Kind != ""
			yyq2348[1] = x.APIVersion != ""
			yyq2348[2] = true
			var yynn2348 int
			if yyr2348 || yy2arr2348 {
				r.EncodeArrayStart(4)
			} else {
				yynn2348 = 1
				for _, b := range yyq2348 {
					if b {
						yynn2348++
					}
				}
				r.EncodeMapStart(yynn2348)
				yynn2348 = 0
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[0] {
					yym2350 := z.EncBinary()
					_ = yym2350
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2348[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2351 := z.EncBinary()
					_ = yym2351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[1] {
					yym2353 := z.EncBinary()
					_ = yym2353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2348[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2354 := z.EncBinary()
					_ = yym2354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2348[2] {
					yy2356 := &x.ListMeta
					yym2357 := z.EncBinary()
					_ = yym2357
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2356) {
					} else {
						z.EncFallback(yy2356)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2348[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2358 := &x.ListMeta
					yym2359 := z.EncBinary()
					_ = yym2359
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2358) {
					} else {
						z.EncFallback(yy2358)
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2361 := z.EncBinary()
					_ = yym2361
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2362 := z.EncBinary()
					_ = yym2362
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr2348 || yy2arr2348 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2363 := z.DecBinary()
	_ = yym2363
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2364 := r.ContainerType()
		if yyct2364 == codecSelferValueTypeMap1234 {
			yyl2364 := r.ReadMapStart()
			if yyl2364 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2364, d)
			}
		} else if yyct2364 == codecSelferValueTypeArray1234 {
			yyl2364 := r.ReadArrayStart()
			if yyl2364 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2364, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2365Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2365Slc
	var yyhl2365 bool = l >= 0
	for yyj2365 := 0; ; yyj2365++ {
		if yyhl2365 {
			if yyj2365 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2365Slc = r.DecodeBytes(yys2365Slc, true, true)
		yys2365 := string(yys2365Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2365 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2368 := &x.ListMeta
				yym2369 := z.DecBinary()
				_ = yym2369
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2368) {
				} else {
					z.DecFallback(yyv2368, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2370 := &x.Items
				yym2371 := z.DecBinary()
				_ = yym2371
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv2370), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2365)
		} // end switch yys2365
	} // end for yyj2365
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2372 int
	var yyb2372 bool
	var yyhl2372 bool = l >= 0
	yyj2372++
	if yyhl2372 {
		yyb2372 = yyj2372 > l
	} else {
		yyb2372 = r.CheckBreak()
	}
	if yyb2372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2372++
	if yyhl2372 {
		yyb2372 = yyj2372 > l
	} else {
		yyb2372 = r.CheckBreak()
	}
	if yyb2372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2372++
	if yyhl2372 {
		yyb2372 = yyj2372 > l
	} else {
		yyb2372 = r.CheckBreak()
	}
	if yyb2372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2375 := &x.ListMeta
		yym2376 := z.DecBinary()
		_ = yym2376
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2375) {
		} else {
			z.DecFallback(yyv2375, false)
		}
	}
	yyj2372++
	if yyhl2372 {
		yyb2372 = yyj2372 > l
	} else {
		yyb2372 = r.CheckBreak()
	}
	if yyb2372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2377 := &x.Items
		yym2378 := z.DecBinary()
		_ = yym2378
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv2377), d)
		}
	}
	for {
		yyj2372++
		if yyhl2372 {
			yyb2372 = yyj2372 > l
		} else {
			yyb2372 = r.CheckBreak()
		}
		if yyb2372 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2372-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2379 := z.EncBinary()
		_ = yym2379
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2380 := !z.EncBinary()
			yy2arr2380 := z.EncBasicHandle().StructToArray
			var yyq2380 [4]bool
			_, _, _ = yysep2380, yyq2380, yy2arr2380
			const yyr2380 bool = false
			yyq2380[0] = x.Replicas != nil
			yyq2380[1] = x.MinReadySeconds != 0
			yyq2380[2] = len(x.Selector) != 0
			yyq2380[3] = x.Template != nil
			var yynn2380 int
			if yyr2380 || yy2arr2380 {
				r.EncodeArrayStart(4)
			} else {
				yynn2380 = 0
				for _, b := range yyq2380 {
					if b {
						yynn2380++
					}
				}
				r.EncodeMapStart(yynn2380)
				yynn2380 = 0
			}
			if yyr2380 || yy2arr2380 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2380[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy2382 := *x.Replicas
						yym2383 := z.EncBinary()
						_ = yym2383
						if false {
						} else {
							r.EncodeInt(int64(yy2382))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2380[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy2384 := *x.Replicas
						yym2385 := z.EncBinary()
						_ = yym2385
						if false {
						} else {
							r.EncodeInt(int64(yy2384))
						}
					}
				}
			}
			if yyr2380 || yy2arr2380 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2380[1] {
					yym2387 := z.EncBinary()
					_ = yym2387
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2380[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2388 := z.EncBinary()
					_ = yym2388
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr2380 || yy2arr2380 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2380[2] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2390 := z.EncBinary()
						_ = yym2390
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2380[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2391 := z.EncBinary()
						_ = yym2391
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2380 || yy2arr2380 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2380[3] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2380[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2380 || yy2arr2380 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2393 := z.DecBinary()
	_ = yym2393
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2394 := r.ContainerType()
		if yyct2394 == codecSelferValueTypeMap1234 {
			yyl2394 := r.ReadMapStart()
			if yyl2394 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2394, d)
			}
		} else if yyct2394 == codecSelferValueTypeArray1234 {
			yyl2394 := r.ReadArrayStart()
			if yyl2394 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2394, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2395Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2395Slc
	var yyhl2395 bool = l >= 0
	for yyj2395 := 0; ; yyj2395++ {
		if yyhl2395 {
			if yyj2395 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2395Slc = r.DecodeBytes(yys2395Slc, true, true)
		yys2395 := string(yys2395Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2395 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym2397 := z.DecBinary()
				_ = yym2397
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2399 := &x.Selector
				yym2400 := z.DecBinary()
				_ = yym2400
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2399, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2395)
		} // end switch yys2395
	} // end for yyj2395
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2402 int
	var yyb2402 bool
	var yyhl2402 bool = l >= 0
	yyj2402++
	if yyhl2402 {
		yyb2402 = yyj2402 > l
	} else {
		yyb2402 = r.CheckBreak()
	}
	if yyb2402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym2404 := z.DecBinary()
		_ = yym2404
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj2402++
	if yyhl2402 {
		yyb2402 = yyj2402 > l
	} else {
		yyb2402 = r.CheckBreak()
	}
	if yyb2402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj2402++
	if yyhl2402 {
		yyb2402 = yyj2402 > l
	} else {
		yyb2402 = r.CheckBreak()
	}
	if yyb2402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2406 := &x.Selector
		yym2407 := z.DecBinary()
		_ = yym2407
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2406, false, d)
		}
	}
	yyj2402++
	if yyhl2402 {
		yyb2402 = yyj2402 > l
	} else {
		yyb2402 = r.CheckBreak()
	}
	if yyb2402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj2402++
		if yyhl2402 {
			yyb2402 = yyj2402 > l
		} else {
			yyb2402 = r.CheckBreak()
		}
		if yyb2402 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2402-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2409 := z.EncBinary()
		_ = yym2409
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2410 := !z.EncBinary()
			yy2arr2410 := z.EncBasicHandle().StructToArray
			var yyq2410 [6]bool
			_, _, _ = yysep2410, yyq2410, yy2arr2410
			const yyr2410 bool = false
			yyq2410[1] = x.FullyLabeledReplicas != 0
			yyq2410[2] = x.ReadyReplicas != 0
			yyq2410[3] = x.AvailableReplicas != 0
			yyq2410[4] = x.ObservedGeneration != 0
			yyq2410[5] = len(x.Conditions) != 0
			var yynn2410 int
			if yyr2410 || yy2arr2410 {
				r.EncodeArrayStart(6)
			} else {
				yynn2410 = 1
				for _, b := range yyq2410 {
					if b {
						yynn2410++
					}
				}
				r.EncodeMapStart(yynn2410)
				yynn2410 = 0
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2412 := z.EncBinary()
				_ = yym2412
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2413 := z.EncBinary()
				_ = yym2413
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2410[1] {
					yym2415 := z.EncBinary()
					_ = yym2415
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2410[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2416 := z.EncBinary()
					_ = yym2416
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2410[2] {
					yym2418 := z.EncBinary()
					_ = yym2418
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2410[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2419 := z.EncBinary()
					_ = yym2419
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2410[3] {
					yym2421 := z.EncBinary()
					_ = yym2421
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2410[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2422 := z.EncBinary()
					_ = yym2422
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2410[4] {
					yym2424 := z.EncBinary()
					_ = yym2424
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2410[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2425 := z.EncBinary()
					_ = yym2425
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2410[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2427 := z.EncBinary()
						_ = yym2427
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2410[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2428 := z.EncBinary()
						_ = yym2428
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2410 || yy2arr2410 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2429 := z.DecBinary()
	_ = yym2429
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2430 := r.ContainerType()
		if yyct2430 == codecSelferValueTypeMap1234 {
			yyl2430 := r.ReadMapStart()
			if yyl2430 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2430, d)
			}
		} else if yyct2430 == codecSelferValueTypeArray1234 {
			yyl2430 := r.ReadArrayStart()
			if yyl2430 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2430, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2431Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2431Slc
	var yyhl2431 bool = l >= 0
	for yyj2431 := 0; ; yyj2431++ {
		if yyhl2431 {
			if yyj2431 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2431Slc = r.DecodeBytes(yys2431Slc, true, true)
		yys2431 := string(yys2431Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2431 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2437 := &x.Conditions
				yym2438 := z.DecBinary()
				_ = yym2438
				if false {
				} else {
					h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv2437), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2431)
		} // end switch yys2431
	} // end for yyj2431
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2439 int
	var yyb2439 bool
	var yyhl2439 bool = l >= 0
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj2439++
	if yyhl2439 {
		yyb2439 = yyj2439 > l
	} else {
		yyb2439 = r.CheckBreak()
	}
	if yyb2439 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2445 := &x.Conditions
		yym2446 := z.DecBinary()
		_ = yym2446
		if false {
		} else {
			h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv2445), d)
		}
	}
	for {
		yyj2439++
		if yyhl2439 {
			yyb2439 = yyj2439 > l
		} else {
			yyb2439 = r.CheckBreak()
		}
		if yyb2439 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2439-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ReplicationControllerConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2447 := z.EncBinary()
	_ = yym2447
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ReplicationControllerConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2448 := z.DecBinary()
	_ = yym2448
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicationControllerCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2449 := z.EncBinary()
		_ = yym2449
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2450 := !z.EncBinary()
			yy2arr2450 := z.EncBasicHandle().StructToArray
			var yyq2450 [5]bool
			_, _, _ = yysep2450, yyq2450, yy2arr2450
			const yyr2450 bool = false
			yyq2450[2] = true
			yyq2450[3] = x.Reason != ""
			yyq2450[4] = x.Message != ""
			var yynn2450 int
			if yyr2450 || yy2arr2450 {
				r.EncodeArrayStart(5)
			} else {
				yynn2450 = 2
				for _, b := range yyq2450 {
					if b {
						yynn2450++
					}
				}
				r.EncodeMapStart(yynn2450)
				yynn2450 = 0
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2450[2] {
					yy2454 := &x.LastTransitionTime
					yym2455 := z.EncBinary()
					_ = yym2455
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2454) {
					} else if yym2455 {
						z.EncBinaryMarshal(yy2454)
					} else if !yym2455 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2454)
					} else {
						z.EncFallback(yy2454)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2450[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2456 := &x.LastTransitionTime
					yym2457 := z.EncBinary()
					_ = yym2457
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2456) {
					} else if yym2457 {
						z.EncBinaryMarshal(yy2456)
					} else if !yym2457 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2456)
					} else {
						z.EncFallback(yy2456)
					}
				}
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2450[3] {
					yym2459 := z.EncBinary()
					_ = yym2459
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2450[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2460 := z.EncBinary()
					_ = yym2460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2450[4] {
					yym2462 := z.EncBinary()
					_ = yym2462
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2450[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2463 := z.EncBinary()
					_ = yym2463
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2450 || yy2arr2450 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2464 := z.DecBinary()
	_ = yym2464
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2465 := r.ContainerType()
		if yyct2465 == codecSelferValueTypeMap1234 {
			yyl2465 := r.ReadMapStart()
			if yyl2465 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2465, d)
			}
		} else if yyct2465 == codecSelferValueTypeArray1234 {
			yyl2465 := r.ReadArrayStart()
			if yyl2465 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2465, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2466Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2466Slc
	var yyhl2466 bool = l >= 0
	for yyj2466 := 0; ; yyj2466++ {
		if yyhl2466 {
			if yyj2466 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2466Slc = r.DecodeBytes(yys2466Slc, true, true)
		yys2466 := string(yys2466Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2466 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ReplicationControllerConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv2469 := &x.LastTransitionTime
				yym2470 := z.DecBinary()
				_ = yym2470
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2469) {
				} else if yym2470 {
					z.DecBinaryUnmarshal(yyv2469)
				} else if !yym2470 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2469)
				} else {
					z.DecFallback(yyv2469, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2466)
		} // end switch yys2466
	} // end for yyj2466
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2473 int
	var yyb2473 bool
	var yyhl2473 bool = l >= 0
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ReplicationControllerConditionType(r.DecodeString())
	}
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv2476 := &x.LastTransitionTime
		yym2477 := z.DecBinary()
		_ = yym2477
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2476) {
		} else if yym2477 {
			z.DecBinaryUnmarshal(yyv2476)
		} else if !yym2477 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2476)
		} else {
			z.DecFallback(yyv2476, false)
		}
	}
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2473++
	if yyhl2473 {
		yyb2473 = yyj2473 > l
	} else {
		yyb2473 = r.CheckBreak()
	}
	if yyb2473 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj2473++
		if yyhl2473 {
			yyb2473 = yyj2473 > l
		} else {
			yyb2473 = r.CheckBreak()
		}
		if yyb2473 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2473-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2480 := z.EncBinary()
		_ = yym2480
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2481 := !z.EncBinary()
			yy2arr2481 := z.EncBasicHandle().StructToArray
			var yyq2481 [5]bool
			_, _, _ = yysep2481, yyq2481, yy2arr2481
			const yyr2481 bool = false
			yyq2481[0] = x.Kind != ""
			yyq2481[1] = x.APIVersion != ""
			yyq2481[2] = true
			yyq2481[3] = true
			yyq2481[4] = true
			var yynn2481 int
			if yyr2481 || yy2arr2481 {
				r.EncodeArrayStart(5)
			} else {
				yynn2481 = 0
				for _, b := range yyq2481 {
					if b {
						yynn2481++
					}
				}
				r.EncodeMapStart(yynn2481)
				yynn2481 = 0
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2481[0] {
					yym2483 := z.EncBinary()
					_ = yym2483
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2481[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2484 := z.EncBinary()
					_ = yym2484
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2481[1] {
					yym2486 := z.EncBinary()
					_ = yym2486
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2481[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2487 := z.EncBinary()
					_ = yym2487
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2481[2] {
					yy2489 := &x.ObjectMeta
					yy2489.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2481[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2490 := &x.ObjectMeta
					yy2490.CodecEncodeSelf(e)
				}
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2481[3] {
					yy2492 := &x.Spec
					yy2492.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2481[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2493 := &x.Spec
					yy2493.CodecEncodeSelf(e)
				}
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2481[4] {
					yy2495 := &x.Status
					yy2495.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2481[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2496 := &x.Status
					yy2496.CodecEncodeSelf(e)
				}
			}
			if yyr2481 || yy2arr2481 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2497 := z.DecBinary()
	_ = yym2497
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2498 := r.ContainerType()
		if yyct2498 == codecSelferValueTypeMap1234 {
			yyl2498 := r.ReadMapStart()
			if yyl2498 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2498, d)
			}
		} else if yyct2498 == codecSelferValueTypeArray1234 {
			yyl2498 := r.ReadArrayStart()
			if yyl2498 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2498, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2499Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2499Slc
	var yyhl2499 bool = l >= 0
	for yyj2499 := 0; ; yyj2499++ {
		if yyhl2499 {
			if yyj2499 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2499Slc = r.DecodeBytes(yys2499Slc, true, true)
		yys2499 := string(yys2499Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2499 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2502 := &x.ObjectMeta
				yyv2502.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv2503 := &x.Spec
				yyv2503.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv2504 := &x.Status
				yyv2504.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2499)
		} // end switch yys2499
	} // end for yyj2499
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2505 int
	var yyb2505 bool
	var yyhl2505 bool = l >= 0
	yyj2505++
	if yyhl2505 {
		yyb2505 = yyj2505 > l
	} else {
		yyb2505 = r.CheckBreak()
	}
	if yyb2505 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2505++
	if yyhl2505 {
		yyb2505 = yyj2505 > l
	} else {
		yyb2505 = r.CheckBreak()
	}
	if yyb2505 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2505++
	if yyhl2505 {
		yyb2505 = yyj2505 > l
	} else {
		yyb2505 = r.CheckBreak()
	}
	if yyb2505 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2508 := &x.ObjectMeta
		yyv2508.CodecDecodeSelf(d)
	}
	yyj2505++
	if yyhl2505 {
		yyb2505 = yyj2505 > l
	} else {
		yyb2505 = r.CheckBreak()
	}
	if yyb2505 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv2509 := &x.Spec
		yyv2509.CodecDecodeSelf(d)
	}
	yyj2505++
	if yyhl2505 {
		yyb2505 = yyj2505 > l
	} else {
		yyb2505 = r.CheckBreak()
	}
	if yyb2505 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv2510 := &x.Status
		yyv2510.CodecDecodeSelf(d)
	}
	for {
		yyj2505++
		if yyhl2505 {
			yyb2505 = yyj2505 > l
		} else {
			yyb2505 = r.CheckBreak()
		}
		if yyb2505 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2505-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2511 := z.EncBinary()
		_ = yym2511
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2512 := !z.EncBinary()
			yy2arr2512 := z.EncBasicHandle().StructToArray
			var yyq2512 [4]bool
			_, _, _ = yysep2512, yyq2512, yy2arr2512
			const yyr2512 bool = false
			yyq2512[0] = x.Kind != ""
			yyq2512[1] = x.APIVersion != ""
			yyq2512[2] = true
			var yynn2512 int
			if yyr2512 || yy2arr2512 {
				r.EncodeArrayStart(4)
			} else {
				yynn2512 = 1
				for _, b := range yyq2512 {
					if b {
						yynn2512++
					}
				}
				r.EncodeMapStart(yynn2512)
				yynn2512 = 0
			}
			if yyr2512 || yy2arr2512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2512[0] {
					yym2514 := z.EncBinary()
					_ = yym2514
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2512[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2515 := z.EncBinary()
					_ = yym2515
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2512 || yy2arr2512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2512[1] {
					yym2517 := z.EncBinary()
					_ = yym2517
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2512[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2518 := z.EncBinary()
					_ = yym2518
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2512 || yy2arr2512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2512[2] {
					yy2520 := &x.ListMeta
					yym2521 := z.EncBinary()
					_ = yym2521
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2520) {
					} else {
						z.EncFallback(yy2520)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2512[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2522 := &x.ListMeta
					yym2523 := z.EncBinary()
					_ = yym2523
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2522) {
					} else {
						z.EncFallback(yy2522)
					}
				}
			}
			if yyr2512 || yy2arr2512 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2525 := z.EncBinary()
					_ = yym2525
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2526 := z.EncBinary()
					_ = yym2526
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr2512 || yy2arr2512 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2527 := z.DecBinary()
	_ = yym2527
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2528 := r.ContainerType()
		if yyct2528 == codecSelferValueTypeMap1234 {
			yyl2528 := r.ReadMapStart()
			if yyl2528 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2528, d)
			}
		} else if yyct2528 == codecSelferValueTypeArray1234 {
			yyl2528 := r.ReadArrayStart()
			if yyl2528 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2528, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2529Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2529Slc
	var yyhl2529 bool = l >= 0
	for yyj2529 := 0; ; yyj2529++ {
		if yyhl2529 {
			if yyj2529 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2529Slc = r.DecodeBytes(yys2529Slc, true, true)
		yys2529 := string(yys2529Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2529 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2532 := &x.ListMeta
				yym2533 := z.DecBinary()
				_ = yym2533
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2532) {
				} else {
					z.DecFallback(yyv2532, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2534 := &x.Items
				yym2535 := z.DecBinary()
				_ = yym2535
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv2534), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2529)
		} // end switch yys2529
	} // end for yyj2529
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2536 int
	var yyb2536 bool
	var yyhl2536 bool = l >= 0
	yyj2536++
	if yyhl2536 {
		yyb2536 = yyj2536 > l
	} else {
		yyb2536 = r.CheckBreak()
	}
	if yyb2536 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2536++
	if yyhl2536 {
		yyb2536 = yyj2536 > l
	} else {
		yyb2536 = r.CheckBreak()
	}
	if yyb2536 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2536++
	if yyhl2536 {
		yyb2536 = yyj2536 > l
	} else {
		yyb2536 = r.CheckBreak()
	}
	if yyb2536 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2539 := &x.ListMeta
		yym2540 := z.DecBinary()
		_ = yym2540
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2539) {
		} else {
			z.DecFallback(yyv2539, false)
		}
	}
	yyj2536++
	if yyhl2536 {
		yyb2536 = yyj2536 > l
	} else {
		yyb2536 = r.CheckBreak()
	}
	if yyb2536 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2541 := &x.Items
		yym2542 := z.DecBinary()
		_ = yym2542
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv2541), d)
		}
	}
	for {
		yyj2536++
		if yyhl2536 {
			yyb2536 = yyj2536 > l
		} else {
			yyb2536 = r.CheckBreak()
		}
		if yyb2536 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2536-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2543 := z.EncBinary()
	_ = yym2543
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2544 := z.DecBinary()
	_ = yym2544
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2545 := z.EncBinary()
	_ = yym2545
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2546 := z.DecBinary()
	_ = yym2546
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2547 := z.EncBinary()
		_ = yym2547
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2548 := !z.EncBinary()
			yy2arr2548 := z.EncBasicHandle().StructToArray
			var yyq2548 [1]bool
			_, _, _ = yysep2548, yyq2548, yy2arr2548
			const yyr2548 bool = false
			yyq2548[0] = true
			var yynn2548 int
			if yyr2548 || yy2arr2548 {
				r.EncodeArrayStart(1)
			} else {
				yynn2548 = 0
				for _, b := range yyq2548 {
					if b {
						yynn2548++
					}
				}
				r.EncodeMapStart(yynn2548)
				yynn2548 = 0
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2548[0] {
					yy2550 := &x.LoadBalancer
					yy2550.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2548[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2551 := &x.LoadBalancer
					yy2551.CodecEncodeSelf(e)
				}
			}
			if yyr2548 || yy2arr2548 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2552 := z.DecBinary()
	_ = yym2552
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2553 := r.ContainerType()
		if yyct2553 == codecSelferValueTypeMap1234 {
			yyl2553 := r.ReadMapStart()
			if yyl2553 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2553, d)
			}
		} else if yyct2553 == codecSelferValueTypeArray1234 {
			yyl2553 := r.ReadArrayStart()
			if yyl2553 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2553, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2554Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2554Slc
	var yyhl2554 bool = l >= 0
	for yyj2554 := 0; ; yyj2554++ {
		if yyhl2554 {
			if yyj2554 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2554Slc = r.DecodeBytes(yys2554Slc, true, true)
		yys2554 := string(yys2554Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2554 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv2555 := &x.LoadBalancer
				yyv2555.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2554)
		} // end switch yys2554
	} // end for yyj2554
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2556 int
	var yyb2556 bool
	var yyhl2556 bool = l >= 0
	yyj2556++
	if yyhl2556 {
		yyb2556 = yyj2556 > l
	} else {
		yyb2556 = r.CheckBreak()
	}
	if yyb2556 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv2557 := &x.LoadBalancer
		yyv2557.CodecDecodeSelf(d)
	}
	for {
		yyj2556++
		if yyhl2556 {
			yyb2556 = yyj2556 > l
		} else {
			yyb2556 = r.CheckBreak()
		}
		if yyb2556 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2556-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2558 := z.EncBinary()
		_ = yym2558
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2559 := !z.EncBinary()
			yy2arr2559 := z.EncBasicHandle().StructToArray
			var yyq2559 [1]bool
			_, _, _ = yysep2559, yyq2559, yy2arr2559
			const yyr2559 bool = false
			yyq2559[0] = len(x.Ingress) != 0
			var yynn2559 int
			if yyr2559 || yy2arr2559 {
				r.EncodeArrayStart(1)
			} else {
				yynn2559 = 0
				for _, b := range yyq2559 {
					if b {
						yynn2559++
					}
				}
				r.EncodeMapStart(yynn2559)
				yynn2559 = 0
			}
			if yyr2559 || yy2arr2559 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2559[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2561 := z.EncBinary()
						_ = yym2561
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2559[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2562 := z.EncBinary()
						_ = yym2562
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr2559 || yy2arr2559 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2563 := z.DecBinary()
	_ = yym2563
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2564 := r.ContainerType()
		if yyct2564 == codecSelferValueTypeMap1234 {
			yyl2564 := r.ReadMapStart()
			if yyl2564 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2564, d)
			}
		} else if yyct2564 == codecSelferValueTypeArray1234 {
			yyl2564 := r.ReadArrayStart()
			if yyl2564 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2564, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2565Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2565Slc
	var yyhl2565 bool = l >= 0
	for yyj2565 := 0; ; yyj2565++ {
		if yyhl2565 {
			if yyj2565 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2565Slc = r.DecodeBytes(yys2565Slc, true, true)
		yys2565 := string(yys2565Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2565 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv2566 := &x.Ingress
				yym2567 := z.DecBinary()
				_ = yym2567
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2566), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2565)
		} // end switch yys2565
	} // end for yyj2565
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2568 int
	var yyb2568 bool
	var yyhl2568 bool = l >= 0
	yyj2568++
	if yyhl2568 {
		yyb2568 = yyj2568 > l
	} else {
		yyb2568 = r.CheckBreak()
	}
	if yyb2568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv2569 := &x.Ingress
		yym2570 := z.DecBinary()
		_ = yym2570
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2569), d)
		}
	}
	for {
		yyj2568++
		if yyhl2568 {
			yyb2568 = yyj2568 > l
		} else {
			yyb2568 = r.CheckBreak()
		}
		if yyb2568 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2568-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2571 := z.EncBinary()
		_ = yym2571
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2572 := !z.EncBinary()
			yy2arr2572 := z.EncBasicHandle().StructToArray
			var yyq2572 [2]bool
			_, _, _ = yysep2572, yyq2572, yy2arr2572
			const yyr2572 bool = false
			yyq2572[0] = x.IP != ""
			yyq2572[1] = x.Hostname != ""
			var yynn2572 int
			if yyr2572 || yy2arr2572 {
				r.EncodeArrayStart(2)
			} else {
				yynn2572 = 0
				for _, b := range yyq2572 {
					if b {
						yynn2572++
					}
				}
				r.EncodeMapStart(yynn2572)
				yynn2572 = 0
			}
			if yyr2572 || yy2arr2572 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2572[0] {
					yym2574 := z.EncBinary()
					_ = yym2574
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2572[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2575 := z.EncBinary()
					_ = yym2575
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr2572 || yy2arr2572 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2572[1] {
					yym2577 := z.EncBinary()
					_ = yym2577
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2572[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2578 := z.EncBinary()
					_ = yym2578
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2572 || yy2arr2572 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2579 := z.DecBinary()
	_ = yym2579
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2580 := r.ContainerType()
		if yyct2580 == codecSelferValueTypeMap1234 {
			yyl2580 := r.ReadMapStart()
			if yyl2580 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2580, d)
			}
		} else if yyct2580 == codecSelferValueTypeArray1234 {
			yyl2580 := r.ReadArrayStart()
			if yyl2580 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2580, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2581Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2581Slc
	var yyhl2581 bool = l >= 0
	for yyj2581 := 0; ; yyj2581++ {
		if yyhl2581 {
			if yyj2581 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2581Slc = r.DecodeBytes(yys2581Slc, true, true)
		yys2581 := string(yys2581Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2581 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2581)
		} // end switch yys2581
	} // end for yyj2581
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2584 int
	var yyb2584 bool
	var yyhl2584 bool = l >= 0
	yyj2584++
	if yyhl2584 {
		yyb2584 = yyj2584 > l
	} else {
		yyb2584 = r.CheckBreak()
	}
	if yyb2584 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2584++
	if yyhl2584 {
		yyb2584 = yyj2584 > l
	} else {
		yyb2584 = r.CheckBreak()
	}
	if yyb2584 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj2584++
		if yyhl2584 {
			yyb2584 = yyj2584 > l
		} else {
			yyb2584 = r.CheckBreak()
		}
		if yyb2584 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2584-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2587 := z.EncBinary()
		_ = yym2587
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2588 := !z.EncBinary()
			yy2arr2588 := z.EncBasicHandle().StructToArray
			var yyq2588 [10]bool
			_, _, _ = yysep2588, yyq2588, yy2arr2588
			const yyr2588 bool = false
			yyq2588[1] = len(x.Selector) != 0
			yyq2588[2] = x.ClusterIP != ""
			yyq2588[3] = x.Type != ""
			yyq2588[4] = len(x.ExternalIPs) != 0
			yyq2588[5] = len(x.DeprecatedPublicIPs) != 0
			yyq2588[6] = x.SessionAffinity != ""
			yyq2588[7] = x.LoadBalancerIP != ""
			yyq2588[8] = len(x.LoadBalancerSourceRanges) != 0
			yyq2588[9] = x.ExternalName != ""
			var yynn2588 int
			if yyr2588 || yy2arr2588 {
				r.EncodeArrayStart(10)
			} else {
				yynn2588 = 1
				for _, b := range yyq2588 {
					if b {
						yynn2588++
					}
				}
				r.EncodeMapStart(yynn2588)
				yynn2588 = 0
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2590 := z.EncBinary()
					_ = yym2590
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2591 := z.EncBinary()
					_ = yym2591
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2593 := z.EncBinary()
						_ = yym2593
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2588[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym2594 := z.EncBinary()
						_ = yym2594
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[2] {
					yym2596 := z.EncBinary()
					_ = yym2596
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2588[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2597 := z.EncBinary()
					_ = yym2597
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[3] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2588[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[4] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2600 := z.EncBinary()
						_ = yym2600
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2588[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2601 := z.EncBinary()
						_ = yym2601
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[5] {
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym2603 := z.EncBinary()
						_ = yym2603
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2588[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deprecatedPublicIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym2604 := z.EncBinary()
						_ = yym2604
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[6] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2588[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[7] {
					yym2607 := z.EncBinary()
					_ = yym2607
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2588[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2608 := z.EncBinary()
					_ = yym2608
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[8] {
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2610 := z.EncBinary()
						_ = yym2610
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2588[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerSourceRanges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2611 := z.EncBinary()
						_ = yym2611
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2588[9] {
					yym2613 := z.EncBinary()
					_ = yym2613
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2588[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2614 := z.EncBinary()
					_ = yym2614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				}
			}
			if yyr2588 || yy2arr2588 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2615 := z.DecBinary()
	_ = yym2615
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2616 := r.ContainerType()
		if yyct2616 == codecSelferValueTypeMap1234 {
			yyl2616 := r.ReadMapStart()
			if yyl2616 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2616, d)
			}
		} else if yyct2616 == codecSelferValueTypeArray1234 {
			yyl2616 := r.ReadArrayStart()
			if yyl2616 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2616, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2617Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2617Slc
	var yyhl2617 bool = l >= 0
	for yyj2617 := 0; ; yyj2617++ {
		if yyhl2617 {
			if yyj2617 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2617Slc = r.DecodeBytes(yys2617Slc, true, true)
		yys2617 := string(yys2617Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2617 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2618 := &x.Ports
				yym2619 := z.DecBinary()
				_ = yym2619
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv2618), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2620 := &x.Selector
				yym2621 := z.DecBinary()
				_ = yym2621
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2620, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv2624 := &x.ExternalIPs
				yym2625 := z.DecBinary()
				_ = yym2625
				if false {
				} else {
					z.F.DecSliceStringX(yyv2624, false, d)
				}
			}
		case "deprecatedPublicIPs":
			if r.TryDecodeAsNil() {
				x.DeprecatedPublicIPs = nil
			} else {
				yyv2626 := &x.DeprecatedPublicIPs
				yym2627 := z.DecBinary()
				_ = yym2627
				if false {
				} else {
					z.F.DecSliceStringX(yyv2626, false, d)
				}
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		case "loadBalancerSourceRanges":
			if r.TryDecodeAsNil() {
				x.LoadBalancerSourceRanges = nil
			} else {
				yyv2630 := &x.LoadBalancerSourceRanges
				yym2631 := z.DecBinary()
				_ = yym2631
				if false {
				} else {
					z.F.DecSliceStringX(yyv2630, false, d)
				}
			}
		case "externalName":
			if r.TryDecodeAsNil() {
				x.ExternalName = ""
			} else {
				x.ExternalName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2617)
		} // end switch yys2617
	} // end for yyj2617
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2633 int
	var yyb2633 bool
	var yyhl2633 bool = l >= 0
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2634 := &x.Ports
		yym2635 := z.DecBinary()
		_ = yym2635
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv2634), d)
		}
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2636 := &x.Selector
		yym2637 := z.DecBinary()
		_ = yym2637
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2636, false, d)
		}
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv2640 := &x.ExternalIPs
		yym2641 := z.DecBinary()
		_ = yym2641
		if false {
		} else {
			z.F.DecSliceStringX(yyv2640, false, d)
		}
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedPublicIPs = nil
	} else {
		yyv2642 := &x.DeprecatedPublicIPs
		yym2643 := z.DecBinary()
		_ = yym2643
		if false {
		} else {
			z.F.DecSliceStringX(yyv2642, false, d)
		}
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerSourceRanges = nil
	} else {
		yyv2646 := &x.LoadBalancerSourceRanges
		yym2647 := z.DecBinary()
		_ = yym2647
		if false {
		} else {
			z.F.DecSliceStringX(yyv2646, false, d)
		}
	}
	yyj2633++
	if yyhl2633 {
		yyb2633 = yyj2633 > l
	} else {
		yyb2633 = r.CheckBreak()
	}
	if yyb2633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalName = ""
	} else {
		x.ExternalName = string(r.DecodeString())
	}
	for {
		yyj2633++
		if yyhl2633 {
			yyb2633 = yyj2633 > l
		} else {
			yyb2633 = r.CheckBreak()
		}
		if yyb2633 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2633-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2649 := z.EncBinary()
		_ = yym2649
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2650 := !z.EncBinary()
			yy2arr2650 := z.EncBasicHandle().StructToArray
			var yyq2650 [5]bool
			_, _, _ = yysep2650, yyq2650, yy2arr2650
			const yyr2650 bool = false
			yyq2650[0] = x.Name != ""
			yyq2650[1] = x.Protocol != ""
			yyq2650[3] = true
			yyq2650[4] = x.NodePort != 0
			var yynn2650 int
			if yyr2650 || yy2arr2650 {
				r.EncodeArrayStart(5)
			} else {
				yynn2650 = 1
				for _, b := range yyq2650 {
					if b {
						yynn2650++
					}
				}
				r.EncodeMapStart(yynn2650)
				yynn2650 = 0
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2650[0] {
					yym2652 := z.EncBinary()
					_ = yym2652
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2650[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2653 := z.EncBinary()
					_ = yym2653
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2650[1] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2650[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2656 := z.EncBinary()
				_ = yym2656
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2657 := z.EncBinary()
				_ = yym2657
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2650[3] {
					yy2659 := &x.TargetPort
					yym2660 := z.EncBinary()
					_ = yym2660
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2659) {
					} else if !yym2660 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2659)
					} else {
						z.EncFallback(yy2659)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2650[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2661 := &x.TargetPort
					yym2662 := z.EncBinary()
					_ = yym2662
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2661) {
					} else if !yym2662 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2661)
					} else {
						z.EncFallback(yy2661)
					}
				}
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2650[4] {
					yym2664 := z.EncBinary()
					_ = yym2664
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2650[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2665 := z.EncBinary()
					_ = yym2665
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				}
			}
			if yyr2650 || yy2arr2650 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2666 := z.DecBinary()
	_ = yym2666
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2667 := r.ContainerType()
		if yyct2667 == codecSelferValueTypeMap1234 {
			yyl2667 := r.ReadMapStart()
			if yyl2667 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2667, d)
			}
		} else if yyct2667 == codecSelferValueTypeArray1234 {
			yyl2667 := r.ReadArrayStart()
			if yyl2667 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2667, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2668Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2668Slc
	var yyhl2668 bool = l >= 0
	for yyj2668 := 0; ; yyj2668++ {
		if yyhl2668 {
			if yyj2668 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2668Slc = r.DecodeBytes(yys2668Slc, true, true)
		yys2668 := string(yys2668Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2668 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg4_intstr.IntOrString{}
			} else {
				yyv2672 := &x.TargetPort
				yym2673 := z.DecBinary()
				_ = yym2673
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2672) {
				} else if !yym2673 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2672)
				} else {
					z.DecFallback(yyv2672, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2668)
		} // end switch yys2668
	} // end for yyj2668
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2675 int
	var yyb2675 bool
	var yyhl2675 bool = l >= 0
	yyj2675++
	if yyhl2675 {
		yyb2675 = yyj2675 > l
	} else {
		yyb2675 = r.CheckBreak()
	}
	if yyb2675 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2675++
	if yyhl2675 {
		yyb2675 = yyj2675 > l
	} else {
		yyb2675 = r.CheckBreak()
	}
	if yyb2675 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj2675++
	if yyhl2675 {
		yyb2675 = yyj2675 > l
	} else {
		yyb2675 = r.CheckBreak()
	}
	if yyb2675 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2675++
	if yyhl2675 {
		yyb2675 = yyj2675 > l
	} else {
		yyb2675 = r.CheckBreak()
	}
	if yyb2675 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg4_intstr.IntOrString{}
	} else {
		yyv2679 := &x.TargetPort
		yym2680 := z.DecBinary()
		_ = yym2680
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2679) {
		} else if !yym2680 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2679)
		} else {
			z.DecFallback(yyv2679, false)
		}
	}
	yyj2675++
	if yyhl2675 {
		yyb2675 = yyj2675 > l
	} else {
		yyb2675 = r.CheckBreak()
	}
	if yyb2675 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int32(r.DecodeInt(32))
	}
	for {
		yyj2675++
		if yyhl2675 {
			yyb2675 = yyj2675 > l
		} else {
			yyb2675 = r.CheckBreak()
		}
		if yyb2675 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2675-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2682 := z.EncBinary()
		_ = yym2682
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2683 := !z.EncBinary()
			yy2arr2683 := z.EncBasicHandle().StructToArray
			var yyq2683 [5]bool
			_, _, _ = yysep2683, yyq2683, yy2arr2683
			const yyr2683 bool = false
			yyq2683[0] = x.Kind != ""
			yyq2683[1] = x.APIVersion != ""
			yyq2683[2] = true
			yyq2683[3] = true
			yyq2683[4] = true
			var yynn2683 int
			if yyr2683 || yy2arr2683 {
				r.EncodeArrayStart(5)
			} else {
				yynn2683 = 0
				for _, b := range yyq2683 {
					if b {
						yynn2683++
					}
				}
				r.EncodeMapStart(yynn2683)
				yynn2683 = 0
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2683[0] {
					yym2685 := z.EncBinary()
					_ = yym2685
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2683[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2686 := z.EncBinary()
					_ = yym2686
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2683[1] {
					yym2688 := z.EncBinary()
					_ = yym2688
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2683[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2689 := z.EncBinary()
					_ = yym2689
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2683[2] {
					yy2691 := &x.ObjectMeta
					yy2691.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2683[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2692 := &x.ObjectMeta
					yy2692.CodecEncodeSelf(e)
				}
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2683[3] {
					yy2694 := &x.Spec
					yy2694.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2683[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2695 := &x.Spec
					yy2695.CodecEncodeSelf(e)
				}
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2683[4] {
					yy2697 := &x.Status
					yy2697.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2683[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2698 := &x.Status
					yy2698.CodecEncodeSelf(e)
				}
			}
			if yyr2683 || yy2arr2683 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2699 := z.DecBinary()
	_ = yym2699
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2700 := r.ContainerType()
		if yyct2700 == codecSelferValueTypeMap1234 {
			yyl2700 := r.ReadMapStart()
			if yyl2700 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2700, d)
			}
		} else if yyct2700 == codecSelferValueTypeArray1234 {
			yyl2700 := r.ReadArrayStart()
			if yyl2700 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2700, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2701Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2701Slc
	var yyhl2701 bool = l >= 0
	for yyj2701 := 0; ; yyj2701++ {
		if yyhl2701 {
			if yyj2701 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2701Slc = r.DecodeBytes(yys2701Slc, true, true)
		yys2701 := string(yys2701Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2701 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2704 := &x.ObjectMeta
				yyv2704.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2705 := &x.Spec
				yyv2705.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2706 := &x.Status
				yyv2706.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2701)
		} // end switch yys2701
	} // end for yyj2701
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2707 int
	var yyb2707 bool
	var yyhl2707 bool = l >= 0
	yyj2707++
	if yyhl2707 {
		yyb2707 = yyj2707 > l
	} else {
		yyb2707 = r.CheckBreak()
	}
	if yyb2707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2707++
	if yyhl2707 {
		yyb2707 = yyj2707 > l
	} else {
		yyb2707 = r.CheckBreak()
	}
	if yyb2707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2707++
	if yyhl2707 {
		yyb2707 = yyj2707 > l
	} else {
		yyb2707 = r.CheckBreak()
	}
	if yyb2707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2710 := &x.ObjectMeta
		yyv2710.CodecDecodeSelf(d)
	}
	yyj2707++
	if yyhl2707 {
		yyb2707 = yyj2707 > l
	} else {
		yyb2707 = r.CheckBreak()
	}
	if yyb2707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2711 := &x.Spec
		yyv2711.CodecDecodeSelf(d)
	}
	yyj2707++
	if yyhl2707 {
		yyb2707 = yyj2707 > l
	} else {
		yyb2707 = r.CheckBreak()
	}
	if yyb2707 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2712 := &x.Status
		yyv2712.CodecDecodeSelf(d)
	}
	for {
		yyj2707++
		if yyhl2707 {
			yyb2707 = yyj2707 > l
		} else {
			yyb2707 = r.CheckBreak()
		}
		if yyb2707 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2707-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2713 := z.EncBinary()
		_ = yym2713
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2714 := !z.EncBinary()
			yy2arr2714 := z.EncBasicHandle().StructToArray
			var yyq2714 [4]bool
			_, _, _ = yysep2714, yyq2714, yy2arr2714
			const yyr2714 bool = false
			yyq2714[0] = x.Kind != ""
			yyq2714[1] = x.APIVersion != ""
			yyq2714[2] = true
			var yynn2714 int
			if yyr2714 || yy2arr2714 {
				r.EncodeArrayStart(4)
			} else {
				yynn2714 = 1
				for _, b := range yyq2714 {
					if b {
						yynn2714++
					}
				}
				r.EncodeMapStart(yynn2714)
				yynn2714 = 0
			}
			if yyr2714 || yy2arr2714 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2714[0] {
					yym2716 := z.EncBinary()
					_ = yym2716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2714[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2717 := z.EncBinary()
					_ = yym2717
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2714 || yy2arr2714 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2714[1] {
					yym2719 := z.EncBinary()
					_ = yym2719
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2714[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2720 := z.EncBinary()
					_ = yym2720
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2714 || yy2arr2714 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2714[2] {
					yy2722 := &x.ListMeta
					yym2723 := z.EncBinary()
					_ = yym2723
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2722) {
					} else {
						z.EncFallback(yy2722)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2714[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2724 := &x.ListMeta
					yym2725 := z.EncBinary()
					_ = yym2725
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2724) {
					} else {
						z.EncFallback(yy2724)
					}
				}
			}
			if yyr2714 || yy2arr2714 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2727 := z.EncBinary()
					_ = yym2727
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2728 := z.EncBinary()
					_ = yym2728
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2714 || yy2arr2714 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2729 := z.DecBinary()
	_ = yym2729
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2730 := r.ContainerType()
		if yyct2730 == codecSelferValueTypeMap1234 {
			yyl2730 := r.ReadMapStart()
			if yyl2730 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2730, d)
			}
		} else if yyct2730 == codecSelferValueTypeArray1234 {
			yyl2730 := r.ReadArrayStart()
			if yyl2730 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2730, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2731Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2731Slc
	var yyhl2731 bool = l >= 0
	for yyj2731 := 0; ; yyj2731++ {
		if yyhl2731 {
			if yyj2731 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2731Slc = r.DecodeBytes(yys2731Slc, true, true)
		yys2731 := string(yys2731Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2731 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2734 := &x.ListMeta
				yym2735 := z.DecBinary()
				_ = yym2735
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2734) {
				} else {
					z.DecFallback(yyv2734, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2736 := &x.Items
				yym2737 := z.DecBinary()
				_ = yym2737
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv2736), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2731)
		} // end switch yys2731
	} // end for yyj2731
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2738 int
	var yyb2738 bool
	var yyhl2738 bool = l >= 0
	yyj2738++
	if yyhl2738 {
		yyb2738 = yyj2738 > l
	} else {
		yyb2738 = r.CheckBreak()
	}
	if yyb2738 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2738++
	if yyhl2738 {
		yyb2738 = yyj2738 > l
	} else {
		yyb2738 = r.CheckBreak()
	}
	if yyb2738 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2738++
	if yyhl2738 {
		yyb2738 = yyj2738 > l
	} else {
		yyb2738 = r.CheckBreak()
	}
	if yyb2738 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2741 := &x.ListMeta
		yym2742 := z.DecBinary()
		_ = yym2742
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2741) {
		} else {
			z.DecFallback(yyv2741, false)
		}
	}
	yyj2738++
	if yyhl2738 {
		yyb2738 = yyj2738 > l
	} else {
		yyb2738 = r.CheckBreak()
	}
	if yyb2738 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2743 := &x.Items
		yym2744 := z.DecBinary()
		_ = yym2744
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv2743), d)
		}
	}
	for {
		yyj2738++
		if yyhl2738 {
			yyb2738 = yyj2738 > l
		} else {
			yyb2738 = r.CheckBreak()
		}
		if yyb2738 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2738-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2745 := z.EncBinary()
		_ = yym2745
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2746 := !z.EncBinary()
			yy2arr2746 := z.EncBasicHandle().StructToArray
			var yyq2746 [5]bool
			_, _, _ = yysep2746, yyq2746, yy2arr2746
			const yyr2746 bool = false
			yyq2746[0] = x.Kind != ""
			yyq2746[1] = x.APIVersion != ""
			yyq2746[2] = true
			yyq2746[3] = len(x.Secrets) != 0
			yyq2746[4] = len(x.ImagePullSecrets) != 0
			var yynn2746 int
			if yyr2746 || yy2arr2746 {
				r.EncodeArrayStart(5)
			} else {
				yynn2746 = 0
				for _, b := range yyq2746 {
					if b {
						yynn2746++
					}
				}
				r.EncodeMapStart(yynn2746)
				yynn2746 = 0
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[0] {
					yym2748 := z.EncBinary()
					_ = yym2748
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2746[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2749 := z.EncBinary()
					_ = yym2749
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[1] {
					yym2751 := z.EncBinary()
					_ = yym2751
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2746[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2752 := z.EncBinary()
					_ = yym2752
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[2] {
					yy2754 := &x.ObjectMeta
					yy2754.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2746[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2755 := &x.ObjectMeta
					yy2755.CodecEncodeSelf(e)
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[3] {
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2757 := z.EncBinary()
						_ = yym2757
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2746[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym2758 := z.EncBinary()
						_ = yym2758
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2746[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2760 := z.EncBinary()
						_ = yym2760
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2746[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2761 := z.EncBinary()
						_ = yym2761
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2746 || yy2arr2746 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2762 := z.DecBinary()
	_ = yym2762
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2763 := r.ContainerType()
		if yyct2763 == codecSelferValueTypeMap1234 {
			yyl2763 := r.ReadMapStart()
			if yyl2763 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2763, d)
			}
		} else if yyct2763 == codecSelferValueTypeArray1234 {
			yyl2763 := r.ReadArrayStart()
			if yyl2763 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2763, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2764Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2764Slc
	var yyhl2764 bool = l >= 0
	for yyj2764 := 0; ; yyj2764++ {
		if yyhl2764 {
			if yyj2764 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2764Slc = r.DecodeBytes(yys2764Slc, true, true)
		yys2764 := string(yys2764Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2764 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2767 := &x.ObjectMeta
				yyv2767.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2768 := &x.Secrets
				yym2769 := z.DecBinary()
				_ = yym2769
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2768), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2770 := &x.ImagePullSecrets
				yym2771 := z.DecBinary()
				_ = yym2771
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2770), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2764)
		} // end switch yys2764
	} // end for yyj2764
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2772 int
	var yyb2772 bool
	var yyhl2772 bool = l >= 0
	yyj2772++
	if yyhl2772 {
		yyb2772 = yyj2772 > l
	} else {
		yyb2772 = r.CheckBreak()
	}
	if yyb2772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2772++
	if yyhl2772 {
		yyb2772 = yyj2772 > l
	} else {
		yyb2772 = r.CheckBreak()
	}
	if yyb2772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2772++
	if yyhl2772 {
		yyb2772 = yyj2772 > l
	} else {
		yyb2772 = r.CheckBreak()
	}
	if yyb2772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2775 := &x.ObjectMeta
		yyv2775.CodecDecodeSelf(d)
	}
	yyj2772++
	if yyhl2772 {
		yyb2772 = yyj2772 > l
	} else {
		yyb2772 = r.CheckBreak()
	}
	if yyb2772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2776 := &x.Secrets
		yym2777 := z.DecBinary()
		_ = yym2777
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2776), d)
		}
	}
	yyj2772++
	if yyhl2772 {
		yyb2772 = yyj2772 > l
	} else {
		yyb2772 = r.CheckBreak()
	}
	if yyb2772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2778 := &x.ImagePullSecrets
		yym2779 := z.DecBinary()
		_ = yym2779
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2778), d)
		}
	}
	for {
		yyj2772++
		if yyhl2772 {
			yyb2772 = yyj2772 > l
		} else {
			yyb2772 = r.CheckBreak()
		}
		if yyb2772 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2772-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2780 := z.EncBinary()
		_ = yym2780
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2781 := !z.EncBinary()
			yy2arr2781 := z.EncBasicHandle().StructToArray
			var yyq2781 [4]bool
			_, _, _ = yysep2781, yyq2781, yy2arr2781
			const yyr2781 bool = false
			yyq2781[0] = x.Kind != ""
			yyq2781[1] = x.APIVersion != ""
			yyq2781[2] = true
			var yynn2781 int
			if yyr2781 || yy2arr2781 {
				r.EncodeArrayStart(4)
			} else {
				yynn2781 = 1
				for _, b := range yyq2781 {
					if b {
						yynn2781++
					}
				}
				r.EncodeMapStart(yynn2781)
				yynn2781 = 0
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[0] {
					yym2783 := z.EncBinary()
					_ = yym2783
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2781[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2784 := z.EncBinary()
					_ = yym2784
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[1] {
					yym2786 := z.EncBinary()
					_ = yym2786
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2781[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2787 := z.EncBinary()
					_ = yym2787
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2781[2] {
					yy2789 := &x.ListMeta
					yym2790 := z.EncBinary()
					_ = yym2790
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2789) {
					} else {
						z.EncFallback(yy2789)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2781[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2791 := &x.ListMeta
					yym2792 := z.EncBinary()
					_ = yym2792
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2791) {
					} else {
						z.EncFallback(yy2791)
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2794 := z.EncBinary()
					_ = yym2794
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2795 := z.EncBinary()
					_ = yym2795
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2781 || yy2arr2781 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2796 := z.DecBinary()
	_ = yym2796
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2797 := r.ContainerType()
		if yyct2797 == codecSelferValueTypeMap1234 {
			yyl2797 := r.ReadMapStart()
			if yyl2797 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2797, d)
			}
		} else if yyct2797 == codecSelferValueTypeArray1234 {
			yyl2797 := r.ReadArrayStart()
			if yyl2797 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2797, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2798Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2798Slc
	var yyhl2798 bool = l >= 0
	for yyj2798 := 0; ; yyj2798++ {
		if yyhl2798 {
			if yyj2798 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2798Slc = r.DecodeBytes(yys2798Slc, true, true)
		yys2798 := string(yys2798Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2798 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2801 := &x.ListMeta
				yym2802 := z.DecBinary()
				_ = yym2802
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2801) {
				} else {
					z.DecFallback(yyv2801, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2803 := &x.Items
				yym2804 := z.DecBinary()
				_ = yym2804
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2803), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2798)
		} // end switch yys2798
	} // end for yyj2798
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2805 int
	var yyb2805 bool
	var yyhl2805 bool = l >= 0
	yyj2805++
	if yyhl2805 {
		yyb2805 = yyj2805 > l
	} else {
		yyb2805 = r.CheckBreak()
	}
	if yyb2805 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2805++
	if yyhl2805 {
		yyb2805 = yyj2805 > l
	} else {
		yyb2805 = r.CheckBreak()
	}
	if yyb2805 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2805++
	if yyhl2805 {
		yyb2805 = yyj2805 > l
	} else {
		yyb2805 = r.CheckBreak()
	}
	if yyb2805 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2808 := &x.ListMeta
		yym2809 := z.DecBinary()
		_ = yym2809
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2808) {
		} else {
			z.DecFallback(yyv2808, false)
		}
	}
	yyj2805++
	if yyhl2805 {
		yyb2805 = yyj2805 > l
	} else {
		yyb2805 = r.CheckBreak()
	}
	if yyb2805 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2810 := &x.Items
		yym2811 := z.DecBinary()
		_ = yym2811
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2810), d)
		}
	}
	for {
		yyj2805++
		if yyhl2805 {
			yyb2805 = yyj2805 > l
		} else {
			yyb2805 = r.CheckBreak()
		}
		if yyb2805 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2805-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2812 := z.EncBinary()
		_ = yym2812
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2813 := !z.EncBinary()
			yy2arr2813 := z.EncBasicHandle().StructToArray
			var yyq2813 [4]bool
			_, _, _ = yysep2813, yyq2813, yy2arr2813
			const yyr2813 bool = false
			yyq2813[0] = x.Kind != ""
			yyq2813[1] = x.APIVersion != ""
			yyq2813[2] = true
			var yynn2813 int
			if yyr2813 || yy2arr2813 {
				r.EncodeArrayStart(4)
			} else {
				yynn2813 = 1
				for _, b := range yyq2813 {
					if b {
						yynn2813++
					}
				}
				r.EncodeMapStart(yynn2813)
				yynn2813 = 0
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2813[0] {
					yym2815 := z.EncBinary()
					_ = yym2815
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2813[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2816 := z.EncBinary()
					_ = yym2816
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2813[1] {
					yym2818 := z.EncBinary()
					_ = yym2818
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2813[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2819 := z.EncBinary()
					_ = yym2819
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2813[2] {
					yy2821 := &x.ObjectMeta
					yy2821.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2813[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2822 := &x.ObjectMeta
					yy2822.CodecEncodeSelf(e)
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2824 := z.EncBinary()
					_ = yym2824
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2825 := z.EncBinary()
					_ = yym2825
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2813 || yy2arr2813 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2826 := z.DecBinary()
	_ = yym2826
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2827 := r.ContainerType()
		if yyct2827 == codecSelferValueTypeMap1234 {
			yyl2827 := r.ReadMapStart()
			if yyl2827 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2827, d)
			}
		} else if yyct2827 == codecSelferValueTypeArray1234 {
			yyl2827 := r.ReadArrayStart()
			if yyl2827 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2827, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2828Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2828Slc
	var yyhl2828 bool = l >= 0
	for yyj2828 := 0; ; yyj2828++ {
		if yyhl2828 {
			if yyj2828 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2828Slc = r.DecodeBytes(yys2828Slc, true, true)
		yys2828 := string(yys2828Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2828 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2831 := &x.ObjectMeta
				yyv2831.CodecDecodeSelf(d)
			}
		case "subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2832 := &x.Subsets
				yym2833 := z.DecBinary()
				_ = yym2833
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2832), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2828)
		} // end switch yys2828
	} // end for yyj2828
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2834 int
	var yyb2834 bool
	var yyhl2834 bool = l >= 0
	yyj2834++
	if yyhl2834 {
		yyb2834 = yyj2834 > l
	} else {
		yyb2834 = r.CheckBreak()
	}
	if yyb2834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2834++
	if yyhl2834 {
		yyb2834 = yyj2834 > l
	} else {
		yyb2834 = r.CheckBreak()
	}
	if yyb2834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2834++
	if yyhl2834 {
		yyb2834 = yyj2834 > l
	} else {
		yyb2834 = r.CheckBreak()
	}
	if yyb2834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2837 := &x.ObjectMeta
		yyv2837.CodecDecodeSelf(d)
	}
	yyj2834++
	if yyhl2834 {
		yyb2834 = yyj2834 > l
	} else {
		yyb2834 = r.CheckBreak()
	}
	if yyb2834 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2838 := &x.Subsets
		yym2839 := z.DecBinary()
		_ = yym2839
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2838), d)
		}
	}
	for {
		yyj2834++
		if yyhl2834 {
			yyb2834 = yyj2834 > l
		} else {
			yyb2834 = r.CheckBreak()
		}
		if yyb2834 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2834-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2840 := z.EncBinary()
		_ = yym2840
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2841 := !z.EncBinary()
			yy2arr2841 := z.EncBasicHandle().StructToArray
			var yyq2841 [3]bool
			_, _, _ = yysep2841, yyq2841, yy2arr2841
			const yyr2841 bool = false
			yyq2841[0] = len(x.Addresses) != 0
			yyq2841[1] = len(x.NotReadyAddresses) != 0
			yyq2841[2] = len(x.Ports) != 0
			var yynn2841 int
			if yyr2841 || yy2arr2841 {
				r.EncodeArrayStart(3)
			} else {
				yynn2841 = 0
				for _, b := range yyq2841 {
					if b {
						yynn2841++
					}
				}
				r.EncodeMapStart(yynn2841)
				yynn2841 = 0
			}
			if yyr2841 || yy2arr2841 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2841[0] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2843 := z.EncBinary()
						_ = yym2843
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2841[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym2844 := z.EncBinary()
						_ = yym2844
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr2841 || yy2arr2841 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2841[1] {
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2846 := z.EncBinary()
						_ = yym2846
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2841[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("notReadyAddresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NotReadyAddresses == nil {
						r.EncodeNil()
					} else {
						yym2847 := z.EncBinary()
						_ = yym2847
						if false {
						} else {
							h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
						}
					}
				}
			}
			if yyr2841 || yy2arr2841 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2841[2] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2849 := z.EncBinary()
						_ = yym2849
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2841[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym2850 := z.EncBinary()
						_ = yym2850
						if false {
						} else {
							h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr2841 || yy2arr2841 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2851 := z.DecBinary()
	_ = yym2851
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2852 := r.ContainerType()
		if yyct2852 == codecSelferValueTypeMap1234 {
			yyl2852 := r.ReadMapStart()
			if yyl2852 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2852, d)
			}
		} else if yyct2852 == codecSelferValueTypeArray1234 {
			yyl2852 := r.ReadArrayStart()
			if yyl2852 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2852, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2853Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2853Slc
	var yyhl2853 bool = l >= 0
	for yyj2853 := 0; ; yyj2853++ {
		if yyhl2853 {
			if yyj2853 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2853Slc = r.DecodeBytes(yys2853Slc, true, true)
		yys2853 := string(yys2853Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2853 {
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2854 := &x.Addresses
				yym2855 := z.DecBinary()
				_ = yym2855
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2854), d)
				}
			}
		case "notReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2856 := &x.NotReadyAddresses
				yym2857 := z.DecBinary()
				_ = yym2857
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2856), d)
				}
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2858 := &x.Ports
				yym2859 := z.DecBinary()
				_ = yym2859
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2858), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2853)
		} // end switch yys2853
	} // end for yyj2853
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2860 int
	var yyb2860 bool
	var yyhl2860 bool = l >= 0
	yyj2860++
	if yyhl2860 {
		yyb2860 = yyj2860 > l
	} else {
		yyb2860 = r.CheckBreak()
	}
	if yyb2860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2861 := &x.Addresses
		yym2862 := z.DecBinary()
		_ = yym2862
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2861), d)
		}
	}
	yyj2860++
	if yyhl2860 {
		yyb2860 = yyj2860 > l
	} else {
		yyb2860 = r.CheckBreak()
	}
	if yyb2860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2863 := &x.NotReadyAddresses
		yym2864 := z.DecBinary()
		_ = yym2864
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2863), d)
		}
	}
	yyj2860++
	if yyhl2860 {
		yyb2860 = yyj2860 > l
	} else {
		yyb2860 = r.CheckBreak()
	}
	if yyb2860 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2865 := &x.Ports
		yym2866 := z.DecBinary()
		_ = yym2866
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2865), d)
		}
	}
	for {
		yyj2860++
		if yyhl2860 {
			yyb2860 = yyj2860 > l
		} else {
			yyb2860 = r.CheckBreak()
		}
		if yyb2860 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2860-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2867 := z.EncBinary()
		_ = yym2867
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2868 := !z.EncBinary()
			yy2arr2868 := z.EncBasicHandle().StructToArray
			var yyq2868 [4]bool
			_, _, _ = yysep2868, yyq2868, yy2arr2868
			const yyr2868 bool = false
			yyq2868[1] = x.Hostname != ""
			yyq2868[2] = x.NodeName != nil
			yyq2868[3] = x.TargetRef != nil
			var yynn2868 int
			if yyr2868 || yy2arr2868 {
				r.EncodeArrayStart(4)
			} else {
				yynn2868 = 1
				for _, b := range yyq2868 {
					if b {
						yynn2868++
					}
				}
				r.EncodeMapStart(yynn2868)
				yynn2868 = 0
			}
			if yyr2868 || yy2arr2868 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2870 := z.EncBinary()
				_ = yym2870
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ip"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2871 := z.EncBinary()
				_ = yym2871
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2868 || yy2arr2868 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2868[1] {
					yym2873 := z.EncBinary()
					_ = yym2873
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2868[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2874 := z.EncBinary()
					_ = yym2874
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2868 || yy2arr2868 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2868[2] {
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2876 := *x.NodeName
						yym2877 := z.EncBinary()
						_ = yym2877
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2876))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2868[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2878 := *x.NodeName
						yym2879 := z.EncBinary()
						_ = yym2879
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2878))
						}
					}
				}
			}
			if yyr2868 || yy2arr2868 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2868[3] {
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2868[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TargetRef == nil {
						r.EncodeNil()
					} else {
						x.TargetRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2868 || yy2arr2868 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2881 := z.DecBinary()
	_ = yym2881
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2882 := r.ContainerType()
		if yyct2882 == codecSelferValueTypeMap1234 {
			yyl2882 := r.ReadMapStart()
			if yyl2882 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2882, d)
			}
		} else if yyct2882 == codecSelferValueTypeArray1234 {
			yyl2882 := r.ReadArrayStart()
			if yyl2882 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2882, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2883Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2883Slc
	var yyhl2883 bool = l >= 0
	for yyj2883 := 0; ; yyj2883++ {
		if yyhl2883 {
			if yyj2883 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2883Slc = r.DecodeBytes(yys2883Slc, true, true)
		yys2883 := string(yys2883Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2883 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				if x.NodeName != nil {
					x.NodeName = nil
				}
			} else {
				if x.NodeName == nil {
					x.NodeName = new(string)
				}
				yym2887 := z.DecBinary()
				_ = yym2887
				if false {
				} else {
					*((*string)(x.NodeName)) = r.DecodeString()
				}
			}
		case "targetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2883)
		} // end switch yys2883
	} // end for yyj2883
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2889 int
	var yyb2889 bool
	var yyhl2889 bool = l >= 0
	yyj2889++
	if yyhl2889 {
		yyb2889 = yyj2889 > l
	} else {
		yyb2889 = r.CheckBreak()
	}
	if yyb2889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2889++
	if yyhl2889 {
		yyb2889 = yyj2889 > l
	} else {
		yyb2889 = r.CheckBreak()
	}
	if yyb2889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2889++
	if yyhl2889 {
		yyb2889 = yyj2889 > l
	} else {
		yyb2889 = r.CheckBreak()
	}
	if yyb2889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeName != nil {
			x.NodeName = nil
		}
	} else {
		if x.NodeName == nil {
			x.NodeName = new(string)
		}
		yym2893 := z.DecBinary()
		_ = yym2893
		if false {
		} else {
			*((*string)(x.NodeName)) = r.DecodeString()
		}
	}
	yyj2889++
	if yyhl2889 {
		yyb2889 = yyj2889 > l
	} else {
		yyb2889 = r.CheckBreak()
	}
	if yyb2889 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2889++
		if yyhl2889 {
			yyb2889 = yyj2889 > l
		} else {
			yyb2889 = r.CheckBreak()
		}
		if yyb2889 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2889-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2895 := z.EncBinary()
		_ = yym2895
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2896 := !z.EncBinary()
			yy2arr2896 := z.EncBasicHandle().StructToArray
			var yyq2896 [3]bool
			_, _, _ = yysep2896, yyq2896, yy2arr2896
			const yyr2896 bool = false
			yyq2896[0] = x.Name != ""
			yyq2896[2] = x.Protocol != ""
			var yynn2896 int
			if yyr2896 || yy2arr2896 {
				r.EncodeArrayStart(3)
			} else {
				yynn2896 = 1
				for _, b := range yyq2896 {
					if b {
						yynn2896++
					}
				}
				r.EncodeMapStart(yynn2896)
				yynn2896 = 0
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2896[0] {
					yym2898 := z.EncBinary()
					_ = yym2898
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2896[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2899 := z.EncBinary()
					_ = yym2899
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2901 := z.EncBinary()
				_ = yym2901
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2902 := z.EncBinary()
				_ = yym2902
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2896[2] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2896[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2896 || yy2arr2896 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2904 := z.DecBinary()
	_ = yym2904
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2905 := r.ContainerType()
		if yyct2905 == codecSelferValueTypeMap1234 {
			yyl2905 := r.ReadMapStart()
			if yyl2905 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2905, d)
			}
		} else if yyct2905 == codecSelferValueTypeArray1234 {
			yyl2905 := r.ReadArrayStart()
			if yyl2905 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2905, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2906Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2906Slc
	var yyhl2906 bool = l >= 0
	for yyj2906 := 0; ; yyj2906++ {
		if yyhl2906 {
			if yyj2906 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2906Slc = r.DecodeBytes(yys2906Slc, true, true)
		yys2906 := string(yys2906Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2906 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2906)
		} // end switch yys2906
	} // end for yyj2906
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2910 int
	var yyb2910 bool
	var yyhl2910 bool = l >= 0
	yyj2910++
	if yyhl2910 {
		yyb2910 = yyj2910 > l
	} else {
		yyb2910 = r.CheckBreak()
	}
	if yyb2910 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2910++
	if yyhl2910 {
		yyb2910 = yyj2910 > l
	} else {
		yyb2910 = r.CheckBreak()
	}
	if yyb2910 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2910++
	if yyhl2910 {
		yyb2910 = yyj2910 > l
	} else {
		yyb2910 = r.CheckBreak()
	}
	if yyb2910 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2910++
		if yyhl2910 {
			yyb2910 = yyj2910 > l
		} else {
			yyb2910 = r.CheckBreak()
		}
		if yyb2910 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2910-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2914 := z.EncBinary()
		_ = yym2914
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2915 := !z.EncBinary()
			yy2arr2915 := z.EncBasicHandle().StructToArray
			var yyq2915 [4]bool
			_, _, _ = yysep2915, yyq2915, yy2arr2915
			const yyr2915 bool = false
			yyq2915[0] = x.Kind != ""
			yyq2915[1] = x.APIVersion != ""
			yyq2915[2] = true
			var yynn2915 int
			if yyr2915 || yy2arr2915 {
				r.EncodeArrayStart(4)
			} else {
				yynn2915 = 1
				for _, b := range yyq2915 {
					if b {
						yynn2915++
					}
				}
				r.EncodeMapStart(yynn2915)
				yynn2915 = 0
			}
			if yyr2915 || yy2arr2915 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2915[0] {
					yym2917 := z.EncBinary()
					_ = yym2917
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2915[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2918 := z.EncBinary()
					_ = yym2918
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2915 || yy2arr2915 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2915[1] {
					yym2920 := z.EncBinary()
					_ = yym2920
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2915[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2921 := z.EncBinary()
					_ = yym2921
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2915 || yy2arr2915 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2915[2] {
					yy2923 := &x.ListMeta
					yym2924 := z.EncBinary()
					_ = yym2924
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2923) {
					} else {
						z.EncFallback(yy2923)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2915[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2925 := &x.ListMeta
					yym2926 := z.EncBinary()
					_ = yym2926
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2925) {
					} else {
						z.EncFallback(yy2925)
					}
				}
			}
			if yyr2915 || yy2arr2915 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2928 := z.EncBinary()
					_ = yym2928
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2929 := z.EncBinary()
					_ = yym2929
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2915 || yy2arr2915 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2930 := z.DecBinary()
	_ = yym2930
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2931 := r.ContainerType()
		if yyct2931 == codecSelferValueTypeMap1234 {
			yyl2931 := r.ReadMapStart()
			if yyl2931 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2931, d)
			}
		} else if yyct2931 == codecSelferValueTypeArray1234 {
			yyl2931 := r.ReadArrayStart()
			if yyl2931 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2931, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2932Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2932Slc
	var yyhl2932 bool = l >= 0
	for yyj2932 := 0; ; yyj2932++ {
		if yyhl2932 {
			if yyj2932 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2932Slc = r.DecodeBytes(yys2932Slc, true, true)
		yys2932 := string(yys2932Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2932 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2935 := &x.ListMeta
				yym2936 := z.DecBinary()
				_ = yym2936
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2935) {
				} else {
					z.DecFallback(yyv2935, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2937 := &x.Items
				yym2938 := z.DecBinary()
				_ = yym2938
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2937), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2932)
		} // end switch yys2932
	} // end for yyj2932
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2939 int
	var yyb2939 bool
	var yyhl2939 bool = l >= 0
	yyj2939++
	if yyhl2939 {
		yyb2939 = yyj2939 > l
	} else {
		yyb2939 = r.CheckBreak()
	}
	if yyb2939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2939++
	if yyhl2939 {
		yyb2939 = yyj2939 > l
	} else {
		yyb2939 = r.CheckBreak()
	}
	if yyb2939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2939++
	if yyhl2939 {
		yyb2939 = yyj2939 > l
	} else {
		yyb2939 = r.CheckBreak()
	}
	if yyb2939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2942 := &x.ListMeta
		yym2943 := z.DecBinary()
		_ = yym2943
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2942) {
		} else {
			z.DecFallback(yyv2942, false)
		}
	}
	yyj2939++
	if yyhl2939 {
		yyb2939 = yyj2939 > l
	} else {
		yyb2939 = r.CheckBreak()
	}
	if yyb2939 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2944 := &x.Items
		yym2945 := z.DecBinary()
		_ = yym2945
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2944), d)
		}
	}
	for {
		yyj2939++
		if yyhl2939 {
			yyb2939 = yyj2939 > l
		} else {
			yyb2939 = r.CheckBreak()
		}
		if yyb2939 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2939-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2946 := z.EncBinary()
		_ = yym2946
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2947 := !z.EncBinary()
			yy2arr2947 := z.EncBasicHandle().StructToArray
			var yyq2947 [4]bool
			_, _, _ = yysep2947, yyq2947, yy2arr2947
			const yyr2947 bool = false
			yyq2947[0] = x.PodCIDR != ""
			yyq2947[1] = x.ExternalID != ""
			yyq2947[2] = x.ProviderID != ""
			yyq2947[3] = x.Unschedulable != false
			var yynn2947 int
			if yyr2947 || yy2arr2947 {
				r.EncodeArrayStart(4)
			} else {
				yynn2947 = 0
				for _, b := range yyq2947 {
					if b {
						yynn2947++
					}
				}
				r.EncodeMapStart(yynn2947)
				yynn2947 = 0
			}
			if yyr2947 || yy2arr2947 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2947[0] {
					yym2949 := z.EncBinary()
					_ = yym2949
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2947[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2950 := z.EncBinary()
					_ = yym2950
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2947 || yy2arr2947 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2947[1] {
					yym2952 := z.EncBinary()
					_ = yym2952
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2947[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2953 := z.EncBinary()
					_ = yym2953
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2947 || yy2arr2947 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2947[2] {
					yym2955 := z.EncBinary()
					_ = yym2955
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2947[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2956 := z.EncBinary()
					_ = yym2956
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2947 || yy2arr2947 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2947[3] {
					yym2958 := z.EncBinary()
					_ = yym2958
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2947[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2959 := z.EncBinary()
					_ = yym2959
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2947 || yy2arr2947 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2960 := z.DecBinary()
	_ = yym2960
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2961 := r.ContainerType()
		if yyct2961 == codecSelferValueTypeMap1234 {
			yyl2961 := r.ReadMapStart()
			if yyl2961 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2961, d)
			}
		} else if yyct2961 == codecSelferValueTypeArray1234 {
			yyl2961 := r.ReadArrayStart()
			if yyl2961 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2961, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2962Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2962Slc
	var yyhl2962 bool = l >= 0
	for yyj2962 := 0; ; yyj2962++ {
		if yyhl2962 {
			if yyj2962 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2962Slc = r.DecodeBytes(yys2962Slc, true, true)
		yys2962 := string(yys2962Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2962 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2962)
		} // end switch yys2962
	} // end for yyj2962
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2967 int
	var yyb2967 bool
	var yyhl2967 bool = l >= 0
	yyj2967++
	if yyhl2967 {
		yyb2967 = yyj2967 > l
	} else {
		yyb2967 = r.CheckBreak()
	}
	if yyb2967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj2967++
	if yyhl2967 {
		yyb2967 = yyj2967 > l
	} else {
		yyb2967 = r.CheckBreak()
	}
	if yyb2967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj2967++
	if yyhl2967 {
		yyb2967 = yyj2967 > l
	} else {
		yyb2967 = r.CheckBreak()
	}
	if yyb2967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj2967++
	if yyhl2967 {
		yyb2967 = yyj2967 > l
	} else {
		yyb2967 = r.CheckBreak()
	}
	if yyb2967 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj2967++
		if yyhl2967 {
			yyb2967 = yyj2967 > l
		} else {
			yyb2967 = r.CheckBreak()
		}
		if yyb2967 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2967-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2972 := z.EncBinary()
		_ = yym2972
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2973 := !z.EncBinary()
			yy2arr2973 := z.EncBasicHandle().StructToArray
			var yyq2973 [1]bool
			_, _, _ = yysep2973, yyq2973, yy2arr2973
			const yyr2973 bool = false
			var yynn2973 int
			if yyr2973 || yy2arr2973 {
				r.EncodeArrayStart(1)
			} else {
				yynn2973 = 1
				for _, b := range yyq2973 {
					if b {
						yynn2973++
					}
				}
				r.EncodeMapStart(yynn2973)
				yynn2973 = 0
			}
			if yyr2973 || yy2arr2973 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2975 := z.EncBinary()
				_ = yym2975
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2976 := z.EncBinary()
				_ = yym2976
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2973 || yy2arr2973 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2977 := z.DecBinary()
	_ = yym2977
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2978 := r.ContainerType()
		if yyct2978 == codecSelferValueTypeMap1234 {
			yyl2978 := r.ReadMapStart()
			if yyl2978 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2978, d)
			}
		} else if yyct2978 == codecSelferValueTypeArray1234 {
			yyl2978 := r.ReadArrayStart()
			if yyl2978 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2978, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2979Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2979Slc
	var yyhl2979 bool = l >= 0
	for yyj2979 := 0; ; yyj2979++ {
		if yyhl2979 {
			if yyj2979 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2979Slc = r.DecodeBytes(yys2979Slc, true, true)
		yys2979 := string(yys2979Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2979 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2979)
		} // end switch yys2979
	} // end for yyj2979
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2981 int
	var yyb2981 bool
	var yyhl2981 bool = l >= 0
	yyj2981++
	if yyhl2981 {
		yyb2981 = yyj2981 > l
	} else {
		yyb2981 = r.CheckBreak()
	}
	if yyb2981 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	for {
		yyj2981++
		if yyhl2981 {
			yyb2981 = yyj2981 > l
		} else {
			yyb2981 = r.CheckBreak()
		}
		if yyb2981 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2981-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2983 := z.EncBinary()
		_ = yym2983
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2984 := !z.EncBinary()
			yy2arr2984 := z.EncBasicHandle().StructToArray
			var yyq2984 [1]bool
			_, _, _ = yysep2984, yyq2984, yy2arr2984
			const yyr2984 bool = false
			yyq2984[0] = true
			var yynn2984 int
			if yyr2984 || yy2arr2984 {
				r.EncodeArrayStart(1)
			} else {
				yynn2984 = 0
				for _, b := range yyq2984 {
					if b {
						yynn2984++
					}
				}
				r.EncodeMapStart(yynn2984)
				yynn2984 = 0
			}
			if yyr2984 || yy2arr2984 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2984[0] {
					yy2986 := &x.KubeletEndpoint
					yy2986.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2984[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2987 := &x.KubeletEndpoint
					yy2987.CodecEncodeSelf(e)
				}
			}
			if yyr2984 || yy2arr2984 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2988 := z.DecBinary()
	_ = yym2988
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2989 := r.ContainerType()
		if yyct2989 == codecSelferValueTypeMap1234 {
			yyl2989 := r.ReadMapStart()
			if yyl2989 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2989, d)
			}
		} else if yyct2989 == codecSelferValueTypeArray1234 {
			yyl2989 := r.ReadArrayStart()
			if yyl2989 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2989, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2990Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2990Slc
	var yyhl2990 bool = l >= 0
	for yyj2990 := 0; ; yyj2990++ {
		if yyhl2990 {
			if yyj2990 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2990Slc = r.DecodeBytes(yys2990Slc, true, true)
		yys2990 := string(yys2990Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2990 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv2991 := &x.KubeletEndpoint
				yyv2991.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2990)
		} // end switch yys2990
	} // end for yyj2990
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2992 int
	var yyb2992 bool
	var yyhl2992 bool = l >= 0
	yyj2992++
	if yyhl2992 {
		yyb2992 = yyj2992 > l
	} else {
		yyb2992 = r.CheckBreak()
	}
	if yyb2992 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv2993 := &x.KubeletEndpoint
		yyv2993.CodecDecodeSelf(d)
	}
	for {
		yyj2992++
		if yyhl2992 {
			yyb2992 = yyj2992 > l
		} else {
			yyb2992 = r.CheckBreak()
		}
		if yyb2992 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2992-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2994 := z.EncBinary()
		_ = yym2994
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2995 := !z.EncBinary()
			yy2arr2995 := z.EncBasicHandle().StructToArray
			var yyq2995 [10]bool
			_, _, _ = yysep2995, yyq2995, yy2arr2995
			const yyr2995 bool = false
			var yynn2995 int
			if yyr2995 || yy2arr2995 {
				r.EncodeArrayStart(10)
			} else {
				yynn2995 = 10
				for _, b := range yyq2995 {
					if b {
						yynn2995++
					}
				}
				r.EncodeMapStart(yynn2995)
				yynn2995 = 0
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2997 := z.EncBinary()
				_ = yym2997
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2998 := z.EncBinary()
				_ = yym2998
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3000 := z.EncBinary()
				_ = yym3000
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3001 := z.EncBinary()
				_ = yym3001
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3003 := z.EncBinary()
				_ = yym3003
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3004 := z.EncBinary()
				_ = yym3004
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3006 := z.EncBinary()
				_ = yym3006
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3007 := z.EncBinary()
				_ = yym3007
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3009 := z.EncBinary()
				_ = yym3009
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3010 := z.EncBinary()
				_ = yym3010
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3012 := z.EncBinary()
				_ = yym3012
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3013 := z.EncBinary()
				_ = yym3013
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3015 := z.EncBinary()
				_ = yym3015
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3016 := z.EncBinary()
				_ = yym3016
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3018 := z.EncBinary()
				_ = yym3018
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3019 := z.EncBinary()
				_ = yym3019
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3021 := z.EncBinary()
				_ = yym3021
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operatingSystem"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3022 := z.EncBinary()
				_ = yym3022
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3024 := z.EncBinary()
				_ = yym3024
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("architecture"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3025 := z.EncBinary()
				_ = yym3025
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3026 := z.DecBinary()
	_ = yym3026
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3027 := r.ContainerType()
		if yyct3027 == codecSelferValueTypeMap1234 {
			yyl3027 := r.ReadMapStart()
			if yyl3027 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3027, d)
			}
		} else if yyct3027 == codecSelferValueTypeArray1234 {
			yyl3027 := r.ReadArrayStart()
			if yyl3027 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3027, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3028Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3028Slc
	var yyhl3028 bool = l >= 0
	for yyj3028 := 0; ; yyj3028++ {
		if yyhl3028 {
			if yyj3028 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3028Slc = r.DecodeBytes(yys3028Slc, true, true)
		yys3028 := string(yys3028Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3028 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		case "operatingSystem":
			if r.TryDecodeAsNil() {
				x.OperatingSystem = ""
			} else {
				x.OperatingSystem = string(r.DecodeString())
			}
		case "architecture":
			if r.TryDecodeAsNil() {
				x.Architecture = ""
			} else {
				x.Architecture = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3028)
		} // end switch yys3028
	} // end for yyj3028
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3039 int
	var yyb3039 bool
	var yyhl3039 bool = l >= 0
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OperatingSystem = ""
	} else {
		x.OperatingSystem = string(r.DecodeString())
	}
	yyj3039++
	if yyhl3039 {
		yyb3039 = yyj3039 > l
	} else {
		yyb3039 = r.CheckBreak()
	}
	if yyb3039 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Architecture = ""
	} else {
		x.Architecture = string(r.DecodeString())
	}
	for {
		yyj3039++
		if yyhl3039 {
			yyb3039 = yyj3039 > l
		} else {
			yyb3039 = r.CheckBreak()
		}
		if yyb3039 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3039-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3050 := z.EncBinary()
		_ = yym3050
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3051 := !z.EncBinary()
			yy2arr3051 := z.EncBasicHandle().StructToArray
			var yyq3051 [10]bool
			_, _, _ = yysep3051, yyq3051, yy2arr3051
			const yyr3051 bool = false
			yyq3051[0] = len(x.Capacity) != 0
			yyq3051[1] = len(x.Allocatable) != 0
			yyq3051[2] = x.Phase != ""
			yyq3051[3] = len(x.Conditions) != 0
			yyq3051[4] = len(x.Addresses) != 0
			yyq3051[5] = true
			yyq3051[6] = true
			yyq3051[7] = len(x.Images) != 0
			yyq3051[8] = len(x.VolumesInUse) != 0
			yyq3051[9] = len(x.VolumesAttached) != 0
			var yynn3051 int
			if yyr3051 || yy2arr3051 {
				r.EncodeArrayStart(10)
			} else {
				yynn3051 = 0
				for _, b := range yyq3051 {
					if b {
						yynn3051++
					}
				}
				r.EncodeMapStart(yynn3051)
				yynn3051 = 0
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3051[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3056 := z.EncBinary()
						_ = yym3056
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3057 := z.EncBinary()
						_ = yym3057
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3059 := z.EncBinary()
						_ = yym3059
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3060 := z.EncBinary()
						_ = yym3060
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[5] {
					yy3062 := &x.DaemonEndpoints
					yy3062.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3063 := &x.DaemonEndpoints
					yy3063.CodecEncodeSelf(e)
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[6] {
					yy3065 := &x.NodeInfo
					yy3065.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3066 := &x.NodeInfo
					yy3066.CodecEncodeSelf(e)
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[7] {
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3068 := z.EncBinary()
						_ = yym3068
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("images"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3069 := z.EncBinary()
						_ = yym3069
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[8] {
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3071 := z.EncBinary()
						_ = yym3071
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesInUse"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3072 := z.EncBinary()
						_ = yym3072
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3051[9] {
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3074 := z.EncBinary()
						_ = yym3074
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3051[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesAttached"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3075 := z.EncBinary()
						_ = yym3075
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				}
			}
			if yyr3051 || yy2arr3051 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3076 := z.DecBinary()
	_ = yym3076
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3077 := r.ContainerType()
		if yyct3077 == codecSelferValueTypeMap1234 {
			yyl3077 := r.ReadMapStart()
			if yyl3077 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3077, d)
			}
		} else if yyct3077 == codecSelferValueTypeArray1234 {
			yyl3077 := r.ReadArrayStart()
			if yyl3077 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3077, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3078Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3078Slc
	var yyhl3078 bool = l >= 0
	for yyj3078 := 0; ; yyj3078++ {
		if yyhl3078 {
			if yyj3078 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3078Slc = r.DecodeBytes(yys3078Slc, true, true)
		yys3078 := string(yys3078Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3078 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv3079 := &x.Capacity
				yyv3079.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv3080 := &x.Allocatable
				yyv3080.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv3082 := &x.Conditions
				yym3083 := z.DecBinary()
				_ = yym3083
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv3082), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv3084 := &x.Addresses
				yym3085 := z.DecBinary()
				_ = yym3085
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv3084), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv3086 := &x.DaemonEndpoints
				yyv3086.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv3087 := &x.NodeInfo
				yyv3087.CodecDecodeSelf(d)
			}
		case "images":
			if r.TryDecodeAsNil() {
				x.Images = nil
			} else {
				yyv3088 := &x.Images
				yym3089 := z.DecBinary()
				_ = yym3089
				if false {
				} else {
					h.decSliceContainerImage((*[]ContainerImage)(yyv3088), d)
				}
			}
		case "volumesInUse":
			if r.TryDecodeAsNil() {
				x.VolumesInUse = nil
			} else {
				yyv3090 := &x.VolumesInUse
				yym3091 := z.DecBinary()
				_ = yym3091
				if false {
				} else {
					h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3090), d)
				}
			}
		case "volumesAttached":
			if r.TryDecodeAsNil() {
				x.VolumesAttached = nil
			} else {
				yyv3092 := &x.VolumesAttached
				yym3093 := z.DecBinary()
				_ = yym3093
				if false {
				} else {
					h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3092), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3078)
		} // end switch yys3078
	} // end for yyj3078
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3094 int
	var yyb3094 bool
	var yyhl3094 bool = l >= 0
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv3095 := &x.Capacity
		yyv3095.CodecDecodeSelf(d)
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv3096 := &x.Allocatable
		yyv3096.CodecDecodeSelf(d)
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv3098 := &x.Conditions
		yym3099 := z.DecBinary()
		_ = yym3099
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv3098), d)
		}
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv3100 := &x.Addresses
		yym3101 := z.DecBinary()
		_ = yym3101
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv3100), d)
		}
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv3102 := &x.DaemonEndpoints
		yyv3102.CodecDecodeSelf(d)
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv3103 := &x.NodeInfo
		yyv3103.CodecDecodeSelf(d)
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Images = nil
	} else {
		yyv3104 := &x.Images
		yym3105 := z.DecBinary()
		_ = yym3105
		if false {
		} else {
			h.decSliceContainerImage((*[]ContainerImage)(yyv3104), d)
		}
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesInUse = nil
	} else {
		yyv3106 := &x.VolumesInUse
		yym3107 := z.DecBinary()
		_ = yym3107
		if false {
		} else {
			h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3106), d)
		}
	}
	yyj3094++
	if yyhl3094 {
		yyb3094 = yyj3094 > l
	} else {
		yyb3094 = r.CheckBreak()
	}
	if yyb3094 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesAttached = nil
	} else {
		yyv3108 := &x.VolumesAttached
		yym3109 := z.DecBinary()
		_ = yym3109
		if false {
		} else {
			h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3108), d)
		}
	}
	for {
		yyj3094++
		if yyhl3094 {
			yyb3094 = yyj3094 > l
		} else {
			yyb3094 = r.CheckBreak()
		}
		if yyb3094 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3094-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x UniqueVolumeName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3110 := z.EncBinary()
	_ = yym3110
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *UniqueVolumeName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3111 := z.DecBinary()
	_ = yym3111
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AttachedVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3112 := z.EncBinary()
		_ = yym3112
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3113 := !z.EncBinary()
			yy2arr3113 := z.EncBasicHandle().StructToArray
			var yyq3113 [2]bool
			_, _, _ = yysep3113, yyq3113, yy2arr3113
			const yyr3113 bool = false
			var yynn3113 int
			if yyr3113 || yy2arr3113 {
				r.EncodeArrayStart(2)
			} else {
				yynn3113 = 2
				for _, b := range yyq3113 {
					if b {
						yynn3113++
					}
				}
				r.EncodeMapStart(yynn3113)
				yynn3113 = 0
			}
			if yyr3113 || yy2arr3113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Name.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Name.CodecEncodeSelf(e)
			}
			if yyr3113 || yy2arr3113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3116 := z.EncBinary()
				_ = yym3116
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("devicePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3117 := z.EncBinary()
				_ = yym3117
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			}
			if yyr3113 || yy2arr3113 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AttachedVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3118 := z.DecBinary()
	_ = yym3118
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3119 := r.ContainerType()
		if yyct3119 == codecSelferValueTypeMap1234 {
			yyl3119 := r.ReadMapStart()
			if yyl3119 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3119, d)
			}
		} else if yyct3119 == codecSelferValueTypeArray1234 {
			yyl3119 := r.ReadArrayStart()
			if yyl3119 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3119, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AttachedVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3120Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3120Slc
	var yyhl3120 bool = l >= 0
	for yyj3120 := 0; ; yyj3120++ {
		if yyhl3120 {
			if yyj3120 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3120Slc = r.DecodeBytes(yys3120Slc, true, true)
		yys3120 := string(yys3120Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3120 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = UniqueVolumeName(r.DecodeString())
			}
		case "devicePath":
			if r.TryDecodeAsNil() {
				x.DevicePath = ""
			} else {
				x.DevicePath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3120)
		} // end switch yys3120
	} // end for yyj3120
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AttachedVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3123 int
	var yyb3123 bool
	var yyhl3123 bool = l >= 0
	yyj3123++
	if yyhl3123 {
		yyb3123 = yyj3123 > l
	} else {
		yyb3123 = r.CheckBreak()
	}
	if yyb3123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = UniqueVolumeName(r.DecodeString())
	}
	yyj3123++
	if yyhl3123 {
		yyb3123 = yyj3123 > l
	} else {
		yyb3123 = r.CheckBreak()
	}
	if yyb3123 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DevicePath = ""
	} else {
		x.DevicePath = string(r.DecodeString())
	}
	for {
		yyj3123++
		if yyhl3123 {
			yyb3123 = yyj3123 > l
		} else {
			yyb3123 = r.CheckBreak()
		}
		if yyb3123 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3123-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AvoidPods) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3126 := z.EncBinary()
		_ = yym3126
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3127 := !z.EncBinary()
			yy2arr3127 := z.EncBasicHandle().StructToArray
			var yyq3127 [1]bool
			_, _, _ = yysep3127, yyq3127, yy2arr3127
			const yyr3127 bool = false
			yyq3127[0] = len(x.PreferAvoidPods) != 0
			var yynn3127 int
			if yyr3127 || yy2arr3127 {
				r.EncodeArrayStart(1)
			} else {
				yynn3127 = 0
				for _, b := range yyq3127 {
					if b {
						yynn3127++
					}
				}
				r.EncodeMapStart(yynn3127)
				yynn3127 = 0
			}
			if yyr3127 || yy2arr3127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3127[0] {
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3129 := z.EncBinary()
						_ = yym3129
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3127[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferAvoidPods"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3130 := z.EncBinary()
						_ = yym3130
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				}
			}
			if yyr3127 || yy2arr3127 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AvoidPods) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3131 := z.DecBinary()
	_ = yym3131
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3132 := r.ContainerType()
		if yyct3132 == codecSelferValueTypeMap1234 {
			yyl3132 := r.ReadMapStart()
			if yyl3132 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3132, d)
			}
		} else if yyct3132 == codecSelferValueTypeArray1234 {
			yyl3132 := r.ReadArrayStart()
			if yyl3132 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3132, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AvoidPods) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3133Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3133Slc
	var yyhl3133 bool = l >= 0
	for yyj3133 := 0; ; yyj3133++ {
		if yyhl3133 {
			if yyj3133 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3133Slc = r.DecodeBytes(yys3133Slc, true, true)
		yys3133 := string(yys3133Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3133 {
		case "preferAvoidPods":
			if r.TryDecodeAsNil() {
				x.PreferAvoidPods = nil
			} else {
				yyv3134 := &x.PreferAvoidPods
				yym3135 := z.DecBinary()
				_ = yym3135
				if false {
				} else {
					h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3134), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3133)
		} // end switch yys3133
	} // end for yyj3133
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AvoidPods) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3136 int
	var yyb3136 bool
	var yyhl3136 bool = l >= 0
	yyj3136++
	if yyhl3136 {
		yyb3136 = yyj3136 > l
	} else {
		yyb3136 = r.CheckBreak()
	}
	if yyb3136 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferAvoidPods = nil
	} else {
		yyv3137 := &x.PreferAvoidPods
		yym3138 := z.DecBinary()
		_ = yym3138
		if false {
		} else {
			h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3137), d)
		}
	}
	for {
		yyj3136++
		if yyhl3136 {
			yyb3136 = yyj3136 > l
		} else {
			yyb3136 = r.CheckBreak()
		}
		if yyb3136 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3136-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferAvoidPodsEntry) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3139 := z.EncBinary()
		_ = yym3139
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3140 := !z.EncBinary()
			yy2arr3140 := z.EncBasicHandle().StructToArray
			var yyq3140 [4]bool
			_, _, _ = yysep3140, yyq3140, yy2arr3140
			const yyr3140 bool = false
			yyq3140[1] = true
			yyq3140[2] = x.Reason != ""
			yyq3140[3] = x.Message != ""
			var yynn3140 int
			if yyr3140 || yy2arr3140 {
				r.EncodeArrayStart(4)
			} else {
				yynn3140 = 1
				for _, b := range yyq3140 {
					if b {
						yynn3140++
					}
				}
				r.EncodeMapStart(yynn3140)
				yynn3140 = 0
			}
			if yyr3140 || yy2arr3140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy3142 := &x.PodSignature
				yy3142.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSignature"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy3143 := &x.PodSignature
				yy3143.CodecEncodeSelf(e)
			}
			if yyr3140 || yy2arr3140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3140[1] {
					yy3145 := &x.EvictionTime
					yym3146 := z.EncBinary()
					_ = yym3146
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3145) {
					} else if yym3146 {
						z.EncBinaryMarshal(yy3145)
					} else if !yym3146 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3145)
					} else {
						z.EncFallback(yy3145)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3140[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3147 := &x.EvictionTime
					yym3148 := z.EncBinary()
					_ = yym3148
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3147) {
					} else if yym3148 {
						z.EncBinaryMarshal(yy3147)
					} else if !yym3148 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3147)
					} else {
						z.EncFallback(yy3147)
					}
				}
			}
			if yyr3140 || yy2arr3140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3140[2] {
					yym3150 := z.EncBinary()
					_ = yym3150
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3140[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3151 := z.EncBinary()
					_ = yym3151
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3140 || yy2arr3140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3140[3] {
					yym3153 := z.EncBinary()
					_ = yym3153
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3140[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3154 := z.EncBinary()
					_ = yym3154
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr3140 || yy2arr3140 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferAvoidPodsEntry) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3155 := z.DecBinary()
	_ = yym3155
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3156 := r.ContainerType()
		if yyct3156 == codecSelferValueTypeMap1234 {
			yyl3156 := r.ReadMapStart()
			if yyl3156 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3156, d)
			}
		} else if yyct3156 == codecSelferValueTypeArray1234 {
			yyl3156 := r.ReadArrayStart()
			if yyl3156 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3156, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3157Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3157Slc
	var yyhl3157 bool = l >= 0
	for yyj3157 := 0; ; yyj3157++ {
		if yyhl3157 {
			if yyj3157 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3157Slc = r.DecodeBytes(yys3157Slc, true, true)
		yys3157 := string(yys3157Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3157 {
		case "podSignature":
			if r.TryDecodeAsNil() {
				x.PodSignature = PodSignature{}
			} else {
				yyv3158 := &x.PodSignature
				yyv3158.CodecDecodeSelf(d)
			}
		case "evictionTime":
			if r.TryDecodeAsNil() {
				x.EvictionTime = pkg2_unversioned.Time{}
			} else {
				yyv3159 := &x.EvictionTime
				yym3160 := z.DecBinary()
				_ = yym3160
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv3159) {
				} else if yym3160 {
					z.DecBinaryUnmarshal(yyv3159)
				} else if !yym3160 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv3159)
				} else {
					z.DecFallback(yyv3159, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3157)
		} // end switch yys3157
	} // end for yyj3157
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferAvoidPodsEntry) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3163 int
	var yyb3163 bool
	var yyhl3163 bool = l >= 0
	yyj3163++
	if yyhl3163 {
		yyb3163 = yyj3163 > l
	} else {
		yyb3163 = r.CheckBreak()
	}
	if yyb3163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSignature = PodSignature{}
	} else {
		yyv3164 := &x.PodSignature
		yyv3164.CodecDecodeSelf(d)
	}
	yyj3163++
	if yyhl3163 {
		yyb3163 = yyj3163 > l
	} else {
		yyb3163 = r.CheckBreak()
	}
	if yyb3163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionTime = pkg2_unversioned.Time{}
	} else {
		yyv3165 := &x.EvictionTime
		yym3166 := z.DecBinary()
		_ = yym3166
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv3165) {
		} else if yym3166 {
			z.DecBinaryUnmarshal(yyv3165)
		} else if !yym3166 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv3165)
		} else {
			z.DecFallback(yyv3165, false)
		}
	}
	yyj3163++
	if yyhl3163 {
		yyb3163 = yyj3163 > l
	} else {
		yyb3163 = r.CheckBreak()
	}
	if yyb3163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj3163++
	if yyhl3163 {
		yyb3163 = yyj3163 > l
	} else {
		yyb3163 = r.CheckBreak()
	}
	if yyb3163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj3163++
		if yyhl3163 {
			yyb3163 = yyj3163 > l
		} else {
			yyb3163 = r.CheckBreak()
		}
		if yyb3163 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3163-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSignature) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3169 := z.EncBinary()
		_ = yym3169
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3170 := !z.EncBinary()
			yy2arr3170 := z.EncBasicHandle().StructToArray
			var yyq3170 [1]bool
			_, _, _ = yysep3170, yyq3170, yy2arr3170
			const yyr3170 bool = false
			yyq3170[0] = x.PodController != nil
			var yynn3170 int
			if yyr3170 || yy2arr3170 {
				r.EncodeArrayStart(1)
			} else {
				yynn3170 = 0
				for _, b := range yyq3170 {
					if b {
						yynn3170++
					}
				}
				r.EncodeMapStart(yynn3170)
				yynn3170 = 0
			}
			if yyr3170 || yy2arr3170 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3170[0] {
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3170[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podController"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodController == nil {
						r.EncodeNil()
					} else {
						x.PodController.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3170 || yy2arr3170 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSignature) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3172 := z.DecBinary()
	_ = yym3172
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3173 := r.ContainerType()
		if yyct3173 == codecSelferValueTypeMap1234 {
			yyl3173 := r.ReadMapStart()
			if yyl3173 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3173, d)
			}
		} else if yyct3173 == codecSelferValueTypeArray1234 {
			yyl3173 := r.ReadArrayStart()
			if yyl3173 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3173, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSignature) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3174Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3174Slc
	var yyhl3174 bool = l >= 0
	for yyj3174 := 0; ; yyj3174++ {
		if yyhl3174 {
			if yyj3174 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3174Slc = r.DecodeBytes(yys3174Slc, true, true)
		yys3174 := string(yys3174Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3174 {
		case "podController":
			if r.TryDecodeAsNil() {
				if x.PodController != nil {
					x.PodController = nil
				}
			} else {
				if x.PodController == nil {
					x.PodController = new(OwnerReference)
				}
				x.PodController.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3174)
		} // end switch yys3174
	} // end for yyj3174
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSignature) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3176 int
	var yyb3176 bool
	var yyhl3176 bool = l >= 0
	yyj3176++
	if yyhl3176 {
		yyb3176 = yyj3176 > l
	} else {
		yyb3176 = r.CheckBreak()
	}
	if yyb3176 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodController != nil {
			x.PodController = nil
		}
	} else {
		if x.PodController == nil {
			x.PodController = new(OwnerReference)
		}
		x.PodController.CodecDecodeSelf(d)
	}
	for {
		yyj3176++
		if yyhl3176 {
			yyb3176 = yyj3176 > l
		} else {
			yyb3176 = r.CheckBreak()
		}
		if yyb3176 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3176-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerImage) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3178 := z.EncBinary()
		_ = yym3178
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3179 := !z.EncBinary()
			yy2arr3179 := z.EncBasicHandle().StructToArray
			var yyq3179 [2]bool
			_, _, _ = yysep3179, yyq3179, yy2arr3179
			const yyr3179 bool = false
			yyq3179[1] = x.SizeBytes != 0
			var yynn3179 int
			if yyr3179 || yy2arr3179 {
				r.EncodeArrayStart(2)
			} else {
				yynn3179 = 1
				for _, b := range yyq3179 {
					if b {
						yynn3179++
					}
				}
				r.EncodeMapStart(yynn3179)
				yynn3179 = 0
			}
			if yyr3179 || yy2arr3179 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3181 := z.EncBinary()
					_ = yym3181
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("names"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Names == nil {
					r.EncodeNil()
				} else {
					yym3182 := z.EncBinary()
					_ = yym3182
					if false {
					} else {
						z.F.EncSliceStringV(x.Names, false, e)
					}
				}
			}
			if yyr3179 || yy2arr3179 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3179[1] {
					yym3184 := z.EncBinary()
					_ = yym3184
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq3179[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sizeBytes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3185 := z.EncBinary()
					_ = yym3185
					if false {
					} else {
						r.EncodeInt(int64(x.SizeBytes))
					}
				}
			}
			if yyr3179 || yy2arr3179 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerImage) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3186 := z.DecBinary()
	_ = yym3186
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3187 := r.ContainerType()
		if yyct3187 == codecSelferValueTypeMap1234 {
			yyl3187 := r.ReadMapStart()
			if yyl3187 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3187, d)
			}
		} else if yyct3187 == codecSelferValueTypeArray1234 {
			yyl3187 := r.ReadArrayStart()
			if yyl3187 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3187, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerImage) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3188Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3188Slc
	var yyhl3188 bool = l >= 0
	for yyj3188 := 0; ; yyj3188++ {
		if yyhl3188 {
			if yyj3188 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3188Slc = r.DecodeBytes(yys3188Slc, true, true)
		yys3188 := string(yys3188Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3188 {
		case "names":
			if r.TryDecodeAsNil() {
				x.Names = nil
			} else {
				yyv3189 := &x.Names
				yym3190 := z.DecBinary()
				_ = yym3190
				if false {
				} else {
					z.F.DecSliceStringX(yyv3189, false, d)
				}
			}
		case "sizeBytes":
			if r.TryDecodeAsNil() {
				x.SizeBytes = 0
			} else {
				x.SizeBytes = int64(r.DecodeInt(64))
			}
		defaul