/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package componentconfig

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg2_config "k8s.io/kubernetes/pkg/util/config"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.TypeMeta
		var v1 pkg2_config.ConfigurationMap
		var v2 time.Duration
		_, _, _ = v0, v1, v2
	}
}

func (x *KubeProxyConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [23]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(23)
			} else {
				yynn2 = 21
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym13 := z.EncBinary()
				_ = yym13
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym14 := z.EncBinary()
				_ = yym14
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym19 := z.EncBinary()
				_ = yym19
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym22 := z.EncBinary()
				_ = yym22
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy25 := *x.IPTablesMasqueradeBit
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(yy25))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.IPTablesMasqueradeBit == nil {
					r.EncodeNil()
				} else {
					yy27 := *x.IPTablesMasqueradeBit
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeInt(int64(yy27))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy30 := &x.IPTablesSyncPeriod
				yym31 := z.EncBinary()
				_ = yym31
				if false {
				} else if z.HasExtensions() && z.EncExt(yy30) {
				} else if !yym31 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy30)
				} else {
					z.EncFallback(yy30)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy32 := &x.IPTablesSyncPeriod
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else if z.HasExtensions() && z.EncExt(yy32) {
				} else if !yym33 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy32)
				} else {
					z.EncFallback(yy32)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy35 := &x.IPTablesMinSyncPeriod
				yym36 := z.EncBinary()
				_ = yym36
				if false {
				} else if z.HasExtensions() && z.EncExt(yy35) {
				} else if !yym36 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy35)
				} else {
					z.EncFallback(yy35)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMinSyncPeriodSeconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy37 := &x.IPTablesMinSyncPeriod
				yym38 := z.EncBinary()
				_ = yym38
				if false {
				} else if z.HasExtensions() && z.EncExt(yy37) {
				} else if !yym38 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy37)
				} else {
					z.EncFallback(yy37)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym40 := z.EncBinary()
				_ = yym40
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeconfigPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym41 := z.EncBinary()
				_ = yym41
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeconfigPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym43 := z.EncBinary()
				_ = yym43
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masqueradeAll"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym44 := z.EncBinary()
				_ = yym44
				if false {
				} else {
					r.EncodeBool(bool(x.MasqueradeAll))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym46 := z.EncBinary()
				_ = yym46
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("master"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym47 := z.EncBinary()
				_ = yym47
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Master))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy49 := *x.OOMScoreAdj
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeInt(int64(yy49))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.OOMScoreAdj == nil {
					r.EncodeNil()
				} else {
					yy51 := *x.OOMScoreAdj
					yym52 := z.EncBinary()
					_ = yym52
					if false {
					} else {
						r.EncodeInt(int64(yy51))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("portRange"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym56 := z.EncBinary()
				_ = yym56
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PortRange))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym58 := z.EncBinary()
				_ = yym58
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceContainer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym59 := z.EncBinary()
				_ = yym59
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResourceContainer))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy61 := &x.UDPIdleTimeout
				yym62 := z.EncBinary()
				_ = yym62
				if false {
				} else if z.HasExtensions() && z.EncExt(yy61) {
				} else if !yym62 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy61)
				} else {
					z.EncFallback(yy61)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("udpTimeoutMilliseconds"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy63 := &x.UDPIdleTimeout
				yym64 := z.EncBinary()
				_ = yym64
				if false {
				} else if z.HasExtensions() && z.EncExt(yy63) {
				} else if !yym64 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy63)
				} else {
					z.EncFallback(yy63)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym66 := z.EncBinary()
				_ = yym66
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMax"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMax))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym69 := z.EncBinary()
				_ = yym69
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMaxPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMaxPerCore))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym72 := z.EncBinary()
				_ = yym72
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackMin"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym73 := z.EncBinary()
				_ = yym73
				if false {
				} else {
					r.EncodeInt(int64(x.ConntrackMin))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy75 := &x.ConntrackTCPEstablishedTimeout
				yym76 := z.EncBinary()
				_ = yym76
				if false {
				} else if z.HasExtensions() && z.EncExt(yy75) {
				} else if !yym76 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy75)
				} else {
					z.EncFallback(yy75)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPEstablishedTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy77 := &x.ConntrackTCPEstablishedTimeout
				yym78 := z.EncBinary()
				_ = yym78
				if false {
				} else if z.HasExtensions() && z.EncExt(yy77) {
				} else if !yym78 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy77)
				} else {
					z.EncFallback(yy77)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy80 := &x.ConntrackTCPCloseWaitTimeout
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else if z.HasExtensions() && z.EncExt(yy80) {
				} else if !yym81 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy80)
				} else {
					z.EncFallback(yy80)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("conntrackTCPCloseWaitTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy82 := &x.ConntrackTCPCloseWaitTimeout
				yym83 := z.EncBinary()
				_ = yym83
				if false {
				} else if z.HasExtensions() && z.EncExt(yy82) {
				} else if !yym83 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy82)
				} else {
					z.EncFallback(yy82)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeProxyConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym84 := z.DecBinary()
	_ = yym84
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct85 := r.ContainerType()
		if yyct85 == codecSelferValueTypeMap1234 {
			yyl85 := r.ReadMapStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl85, d)
			}
		} else if yyct85 == codecSelferValueTypeArray1234 {
			yyl85 := r.ReadArrayStart()
			if yyl85 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl85, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys86Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys86Slc
	var yyhl86 bool = l >= 0
	for yyj86 := 0; ; yyj86++ {
		if yyhl86 {
			if yyj86 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys86Slc = r.DecodeBytes(yys86Slc, true, true)
		yys86 := string(yys86Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys86 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "bindAddress":
			if r.TryDecodeAsNil() {
				x.BindAddress = ""
			} else {
				x.BindAddress = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				if x.IPTablesMasqueradeBit != nil {
					x.IPTablesMasqueradeBit = nil
				}
			} else {
				if x.IPTablesMasqueradeBit == nil {
					x.IPTablesMasqueradeBit = new(int32)
				}
				yym95 := z.DecBinary()
				_ = yym95
				if false {
				} else {
					*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
				}
			}
		case "iptablesSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv96 := &x.IPTablesSyncPeriod
				yym97 := z.DecBinary()
				_ = yym97
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv96) {
				} else if !yym97 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv96)
				} else {
					z.DecFallback(yyv96, false)
				}
			}
		case "iptablesMinSyncPeriodSeconds":
			if r.TryDecodeAsNil() {
				x.IPTablesMinSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv98 := &x.IPTablesMinSyncPeriod
				yym99 := z.DecBinary()
				_ = yym99
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv98) {
				} else if !yym99 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv98)
				} else {
					z.DecFallback(yyv98, false)
				}
			}
		case "kubeconfigPath":
			if r.TryDecodeAsNil() {
				x.KubeconfigPath = ""
			} else {
				x.KubeconfigPath = string(r.DecodeString())
			}
		case "masqueradeAll":
			if r.TryDecodeAsNil() {
				x.MasqueradeAll = false
			} else {
				x.MasqueradeAll = bool(r.DecodeBool())
			}
		case "master":
			if r.TryDecodeAsNil() {
				x.Master = ""
			} else {
				x.Master = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				if x.OOMScoreAdj != nil {
					x.OOMScoreAdj = nil
				}
			} else {
				if x.OOMScoreAdj == nil {
					x.OOMScoreAdj = new(int32)
				}
				yym104 := z.DecBinary()
				_ = yym104
				if false {
				} else {
					*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = ProxyMode(r.DecodeString())
			}
		case "portRange":
			if r.TryDecodeAsNil() {
				x.PortRange = ""
			} else {
				x.PortRange = string(r.DecodeString())
			}
		case "resourceContainer":
			if r.TryDecodeAsNil() {
				x.ResourceContainer = ""
			} else {
				x.ResourceContainer = string(r.DecodeString())
			}
		case "udpTimeoutMilliseconds":
			if r.TryDecodeAsNil() {
				x.UDPIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv108 := &x.UDPIdleTimeout
				yym109 := z.DecBinary()
				_ = yym109
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv108) {
				} else if !yym109 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv108)
				} else {
					z.DecFallback(yyv108, false)
				}
			}
		case "conntrackMax":
			if r.TryDecodeAsNil() {
				x.ConntrackMax = 0
			} else {
				x.ConntrackMax = int32(r.DecodeInt(32))
			}
		case "conntrackMaxPerCore":
			if r.TryDecodeAsNil() {
				x.ConntrackMaxPerCore = 0
			} else {
				x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
			}
		case "conntrackMin":
			if r.TryDecodeAsNil() {
				x.ConntrackMin = 0
			} else {
				x.ConntrackMin = int32(r.DecodeInt(32))
			}
		case "conntrackTCPEstablishedTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv113 := &x.ConntrackTCPEstablishedTimeout
				yym114 := z.DecBinary()
				_ = yym114
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv113) {
				} else if !yym114 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv113)
				} else {
					z.DecFallback(yyv113, false)
				}
			}
		case "conntrackTCPCloseWaitTimeout":
			if r.TryDecodeAsNil() {
				x.ConntrackTCPCloseWaitTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv115 := &x.ConntrackTCPCloseWaitTimeout
				yym116 := z.DecBinary()
				_ = yym116
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv115) {
				} else if !yym116 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv115)
				} else {
					z.DecFallback(yyv115, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys86)
		} // end switch yys86
	} // end for yyj86
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeProxyConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BindAddress = ""
	} else {
		x.BindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.IPTablesMasqueradeBit != nil {
			x.IPTablesMasqueradeBit = nil
		}
	} else {
		if x.IPTablesMasqueradeBit == nil {
			x.IPTablesMasqueradeBit = new(int32)
		}
		yym126 := z.DecBinary()
		_ = yym126
		if false {
		} else {
			*((*int32)(x.IPTablesMasqueradeBit)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv127 := &x.IPTablesSyncPeriod
		yym128 := z.DecBinary()
		_ = yym128
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv127) {
		} else if !yym128 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv127)
		} else {
			z.DecFallback(yyv127, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMinSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv129 := &x.IPTablesMinSyncPeriod
		yym130 := z.DecBinary()
		_ = yym130
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv129) {
		} else if !yym130 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv129)
		} else {
			z.DecFallback(yyv129, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeconfigPath = ""
	} else {
		x.KubeconfigPath = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasqueradeAll = false
	} else {
		x.MasqueradeAll = bool(r.DecodeBool())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Master = ""
	} else {
		x.Master = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.OOMScoreAdj != nil {
			x.OOMScoreAdj = nil
		}
	} else {
		if x.OOMScoreAdj == nil {
			x.OOMScoreAdj = new(int32)
		}
		yym135 := z.DecBinary()
		_ = yym135
		if false {
		} else {
			*((*int32)(x.OOMScoreAdj)) = int32(r.DecodeInt(32))
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = ProxyMode(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PortRange = ""
	} else {
		x.PortRange = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceContainer = ""
	} else {
		x.ResourceContainer = string(r.DecodeString())
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UDPIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv139 := &x.UDPIdleTimeout
		yym140 := z.DecBinary()
		_ = yym140
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv139) {
		} else if !yym140 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv139)
		} else {
			z.DecFallback(yyv139, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMax = 0
	} else {
		x.ConntrackMax = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMaxPerCore = 0
	} else {
		x.ConntrackMaxPerCore = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackMin = 0
	} else {
		x.ConntrackMin = int32(r.DecodeInt(32))
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPEstablishedTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv144 := &x.ConntrackTCPEstablishedTimeout
		yym145 := z.DecBinary()
		_ = yym145
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv144) {
		} else if !yym145 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv144)
		} else {
			z.DecFallback(yyv144, false)
		}
	}
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConntrackTCPCloseWaitTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv146 := &x.ConntrackTCPCloseWaitTimeout
		yym147 := z.DecBinary()
		_ = yym147
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv146) {
		} else if !yym147 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv146)
		} else {
			z.DecFallback(yyv146, false)
		}
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ProxyMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym148 := z.EncBinary()
	_ = yym148
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ProxyMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym149 := z.DecBinary()
	_ = yym149
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x HairpinMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym150 := z.EncBinary()
	_ = yym150
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *HairpinMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym151 := z.DecBinary()
	_ = yym151
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [113]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			yyq153[0] = x.Kind != ""
			yyq153[1] = x.APIVersion != ""
			yyq153[55] = x.CloudProvider != ""
			yyq153[56] = x.CloudConfigFile != ""
			yyq153[57] = x.KubeletCgroups != ""
			yyq153[58] = x.ExperimentalCgroupsPerQOS != false
			yyq153[59] = x.CgroupDriver != ""
			yyq153[60] = x.RuntimeCgroups != ""
			yyq153[61] = x.SystemCgroups != ""
			yyq153[62] = x.CgroupRoot != ""
			yyq153[66] = true
			yyq153[67] = x.RktPath != ""
			yyq153[68] = x.ExperimentalMounterPath != ""
			yyq153[69] = x.RktAPIEndpoint != ""
			yyq153[70] = x.RktStage1Image != ""
			yyq153[89] = true
			yyq153[90] = x.NodeIP != ""
			yyq153[94] = x.EvictionHard != ""
			yyq153[95] = x.EvictionSoft != ""
			yyq153[96] = x.EvictionSoftGracePeriod != ""
			yyq153[97] = true
			yyq153[98] = x.EvictionMaxPodGracePeriod != 0
			yyq153[99] = x.EvictionMinimumReclaim != ""
			yyq153[108] = len(x.AllowedUnsafeSysctls) != 0
			yyq153[110] = x.EnableCRI != false
			yyq153[111] = x.ExperimentalFailSwapOn != false
			yyq153[112] = x.ExperimentalCheckNodeCapabilitiesBeforeMount != false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(113)
			} else {
				yynn153 = 86
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[0] {
					yym155 := z.EncBinary()
					_ = yym155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[1] {
					yym158 := z.EncBinary()
					_ = yym158
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym159 := z.EncBinary()
					_ = yym159
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podManifestPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym162 := z.EncBinary()
				_ = yym162
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodManifestPath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy164 := &x.SyncFrequency
				yym165 := z.EncBinary()
				_ = yym165
				if false {
				} else if z.HasExtensions() && z.EncExt(yy164) {
				} else if !yym165 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy164)
				} else {
					z.EncFallback(yy164)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("syncFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy166 := &x.SyncFrequency
				yym167 := z.EncBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.EncExt(yy166) {
				} else if !yym167 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy166)
				} else {
					z.EncFallback(yy166)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy169 := &x.FileCheckFrequency
				yym170 := z.EncBinary()
				_ = yym170
				if false {
				} else if z.HasExtensions() && z.EncExt(yy169) {
				} else if !yym170 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy169)
				} else {
					z.EncFallback(yy169)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fileCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy171 := &x.FileCheckFrequency
				yym172 := z.EncBinary()
				_ = yym172
				if false {
				} else if z.HasExtensions() && z.EncExt(yy171) {
				} else if !yym172 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy171)
				} else {
					z.EncFallback(yy171)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy174 := &x.HTTPCheckFrequency
				yym175 := z.EncBinary()
				_ = yym175
				if false {
				} else if z.HasExtensions() && z.EncExt(yy174) {
				} else if !yym175 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy174)
				} else {
					z.EncFallback(yy174)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("httpCheckFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy176 := &x.HTTPCheckFrequency
				yym177 := z.EncBinary()
				_ = yym177
				if false {
				} else if z.HasExtensions() && z.EncExt(yy176) {
				} else if !yym177 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy176)
				} else {
					z.EncFallback(yy176)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym179 := z.EncBinary()
				_ = yym179
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym180 := z.EncBinary()
				_ = yym180
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURL))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym182 := z.EncBinary()
				_ = yym182
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("manifestURLHeader"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym183 := z.EncBinary()
				_ = yym183
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ManifestURLHeader))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym185 := z.EncBinary()
				_ = yym185
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableServer"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym186 := z.EncBinary()
				_ = yym186
				if false {
				} else {
					r.EncodeBool(bool(x.EnableServer))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym188 := z.EncBinary()
				_ = yym188
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym189 := z.EncBinary()
				_ = yym189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym191 := z.EncBinary()
				_ = yym191
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym192 := z.EncBinary()
				_ = yym192
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym194 := z.EncBinary()
				_ = yym194
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("readOnlyPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym195 := z.EncBinary()
				_ = yym195
				if false {
				} else {
					r.EncodeInt(int64(x.ReadOnlyPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym198 := z.EncBinary()
				_ = yym198
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSCertFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym200 := z.EncBinary()
				_ = yym200
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("tlsPrivateKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym201 := z.EncBinary()
				_ = yym201
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TLSPrivateKeyFile))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym203 := z.EncBinary()
				_ = yym203
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("certDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym204 := z.EncBinary()
				_ = yym204
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CertDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy206 := &x.Authentication
				yy206.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authentication"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy207 := &x.Authentication
				yy207.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy209 := &x.Authorization
				yy209.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("authorization"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy210 := &x.Authorization
				yy210.CodecEncodeSelf(e)
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym212 := z.EncBinary()
				_ = yym212
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostnameOverride"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym213 := z.EncBinary()
				_ = yym213
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HostnameOverride))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym215 := z.EncBinary()
				_ = yym215
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podInfraContainerImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym216 := z.EncBinary()
				_ = yym216
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodInfraContainerImage))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym218 := z.EncBinary()
				_ = yym218
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym219 := z.EncBinary()
				_ = yym219
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym221 := z.EncBinary()
				_ = yym221
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootDirectory"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym222 := z.EncBinary()
				_ = yym222
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootDirectory))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seccompProfileRoot"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SeccompProfileRoot))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allowPrivileged"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeBool(bool(x.AllowPrivileged))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym230 := z.EncBinary()
					_ = yym230
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostNetworkSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostNetworkSources == nil {
					r.EncodeNil()
				} else {
					yym231 := z.EncBinary()
					_ = yym231
					if false {
					} else {
						z.F.EncSliceStringV(x.HostNetworkSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym233 := z.EncBinary()
					_ = yym233
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostPIDSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostPIDSources == nil {
					r.EncodeNil()
				} else {
					yym234 := z.EncBinary()
					_ = yym234
					if false {
					} else {
						z.F.EncSliceStringV(x.HostPIDSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym236 := z.EncBinary()
					_ = yym236
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hostIPCSources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.HostIPCSources == nil {
					r.EncodeNil()
				} else {
					yym237 := z.EncBinary()
					_ = yym237
					if false {
					} else {
						z.F.EncSliceStringV(x.HostIPCSources, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym239 := z.EncBinary()
				_ = yym239
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryPullQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym240 := z.EncBinary()
				_ = yym240
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryPullQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym242 := z.EncBinary()
				_ = yym242
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registryBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym243 := z.EncBinary()
				_ = yym243
				if false {
				} else {
					r.EncodeInt(int64(x.RegistryBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym245 := z.EncBinary()
				_ = yym245
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventRecordQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym246 := z.EncBinary()
				_ = yym246
				if false {
				} else {
					r.EncodeInt(int64(x.EventRecordQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym248 := z.EncBinary()
				_ = yym248
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("eventBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym249 := z.EncBinary()
				_ = yym249
				if false {
				} else {
					r.EncodeInt(int64(x.EventBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym251 := z.EncBinary()
				_ = yym251
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDebuggingHandlers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym252 := z.EncBinary()
				_ = yym252
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDebuggingHandlers))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy254 := &x.MinimumGCAge
				yym255 := z.EncBinary()
				_ = yym255
				if false {
				} else if z.HasExtensions() && z.EncExt(yy254) {
				} else if !yym255 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy254)
				} else {
					z.EncFallback(yy254)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy256 := &x.MinimumGCAge
				yym257 := z.EncBinary()
				_ = yym257
				if false {
				} else if z.HasExtensions() && z.EncExt(yy256) {
				} else if !yym257 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy256)
				} else {
					z.EncFallback(yy256)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym259 := z.EncBinary()
				_ = yym259
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPerPodContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym260 := z.EncBinary()
				_ = yym260
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPerPodContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym262 := z.EncBinary()
				_ = yym262
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxContainerCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym263 := z.EncBinary()
				_ = yym263
				if false {
				} else {
					r.EncodeInt(int64(x.MaxContainerCount))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym265 := z.EncBinary()
				_ = yym265
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cAdvisorPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym266 := z.EncBinary()
				_ = yym266
				if false {
				} else {
					r.EncodeInt(int64(x.CAdvisorPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym268 := z.EncBinary()
				_ = yym268
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym269 := z.EncBinary()
				_ = yym269
				if false {
				} else {
					r.EncodeInt(int64(x.HealthzPort))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym271 := z.EncBinary()
				_ = yym271
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("healthzBindAddress"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym272 := z.EncBinary()
				_ = yym272
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HealthzBindAddress))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym274 := z.EncBinary()
				_ = yym274
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("oomScoreAdj"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym275 := z.EncBinary()
				_ = yym275
				if false {
				} else {
					r.EncodeInt(int64(x.OOMScoreAdj))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym277 := z.EncBinary()
				_ = yym277
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerNode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym278 := z.EncBinary()
				_ = yym278
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterNode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym280 := z.EncBinary()
				_ = yym280
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDomain"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym281 := z.EncBinary()
				_ = yym281
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDomain))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym283 := z.EncBinary()
				_ = yym283
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("masterServiceNamespace"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym284 := z.EncBinary()
				_ = yym284
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MasterServiceNamespace))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym286 := z.EncBinary()
				_ = yym286
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterDNS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym287 := z.EncBinary()
				_ = yym287
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterDNS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy289 := &x.StreamingConnectionIdleTimeout
				yym290 := z.EncBinary()
				_ = yym290
				if false {
				} else if z.HasExtensions() && z.EncExt(yy289) {
				} else if !yym290 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy289)
				} else {
					z.EncFallback(yy289)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("streamingConnectionIdleTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy291 := &x.StreamingConnectionIdleTimeout
				yym292 := z.EncBinary()
				_ = yym292
				if false {
				} else if z.HasExtensions() && z.EncExt(yy291) {
				} else if !yym292 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy291)
				} else {
					z.EncFallback(yy291)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy294 := &x.NodeStatusUpdateFrequency
				yym295 := z.EncBinary()
				_ = yym295
				if false {
				} else if z.HasExtensions() && z.EncExt(yy294) {
				} else if !yym295 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy294)
				} else {
					z.EncFallback(yy294)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStatusUpdateFrequency"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy296 := &x.NodeStatusUpdateFrequency
				yym297 := z.EncBinary()
				_ = yym297
				if false {
				} else if z.HasExtensions() && z.EncExt(yy296) {
				} else if !yym297 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy296)
				} else {
					z.EncFallback(yy296)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy299 := &x.ImageMinimumGCAge
				yym300 := z.EncBinary()
				_ = yym300
				if false {
				} else if z.HasExtensions() && z.EncExt(yy299) {
				} else if !yym300 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy299)
				} else {
					z.EncFallback(yy299)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageMinimumGCAge"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy301 := &x.ImageMinimumGCAge
				yym302 := z.EncBinary()
				_ = yym302
				if false {
				} else if z.HasExtensions() && z.EncExt(yy301) {
				} else if !yym302 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy301)
				} else {
					z.EncFallback(yy301)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym304 := z.EncBinary()
				_ = yym304
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCHighThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym305 := z.EncBinary()
				_ = yym305
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCHighThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym307 := z.EncBinary()
				_ = yym307
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageGCLowThresholdPercent"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym308 := z.EncBinary()
				_ = yym308
				if false {
				} else {
					r.EncodeInt(int64(x.ImageGCLowThresholdPercent))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym310 := z.EncBinary()
				_ = yym310
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lowDiskSpaceThresholdMB"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym311 := z.EncBinary()
				_ = yym311
				if false {
				} else {
					r.EncodeInt(int64(x.LowDiskSpaceThresholdMB))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy313 := &x.VolumeStatsAggPeriod
				yym314 := z.EncBinary()
				_ = yym314
				if false {
				} else if z.HasExtensions() && z.EncExt(yy313) {
				} else if !yym314 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy313)
				} else {
					z.EncFallback(yy313)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeStatsAggPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy315 := &x.VolumeStatsAggPeriod
				yym316 := z.EncBinary()
				_ = yym316
				if false {
				} else if z.HasExtensions() && z.EncExt(yy315) {
				} else if !yym316 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy315)
				} else {
					z.EncFallback(yy315)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym318 := z.EncBinary()
				_ = yym318
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym319 := z.EncBinary()
				_ = yym319
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym321 := z.EncBinary()
				_ = yym321
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginMTU"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym322 := z.EncBinary()
				_ = yym322
				if false {
				} else {
					r.EncodeInt(int64(x.NetworkPluginMTU))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym324 := z.EncBinary()
				_ = yym324
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("networkPluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym325 := z.EncBinary()
				_ = yym325
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NetworkPluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym327 := z.EncBinary()
				_ = yym327
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniConfDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym328 := z.EncBinary()
				_ = yym328
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIConfDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym330 := z.EncBinary()
				_ = yym330
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cniBinDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym331 := z.EncBinary()
				_ = yym331
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CNIBinDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym333 := z.EncBinary()
				_ = yym333
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym334 := z.EncBinary()
				_ = yym334
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePluginDir))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[55] {
					yym336 := z.EncBinary()
					_ = yym336
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[55] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym337 := z.EncBinary()
					_ = yym337
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[56] {
					yym339 := z.EncBinary()
					_ = yym339
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[56] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[57] {
					yym342 := z.EncBinary()
					_ = yym342
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[57] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.KubeletCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[58] {
					yym345 := z.EncBinary()
					_ = yym345
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[58] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalCgroupsPerQOS"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym346 := z.EncBinary()
					_ = yym346
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCgroupsPerQOS))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[59] {
					yym348 := z.EncBinary()
					_ = yym348
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[59] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupDriver"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym349 := z.EncBinary()
					_ = yym349
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupDriver))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[60] {
					yym351 := z.EncBinary()
					_ = yym351
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[60] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym352 := z.EncBinary()
					_ = yym352
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RuntimeCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[61] {
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[61] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("systemCgroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym355 := z.EncBinary()
					_ = yym355
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SystemCgroups))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[62] {
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[62] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cgroupRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym358 := z.EncBinary()
					_ = yym358
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.CgroupRoot))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym360 := z.EncBinary()
				_ = yym360
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntime"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym361 := z.EncBinary()
				_ = yym361
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntime))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym363 := z.EncBinary()
				_ = yym363
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteRuntimeEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym364 := z.EncBinary()
				_ = yym364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteRuntimeEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym366 := z.EncBinary()
				_ = yym366
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("remoteImageEndpoint"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym367 := z.EncBinary()
				_ = yym367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RemoteImageEndpoint))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[66] {
					yy369 := &x.RuntimeRequestTimeout
					yym370 := z.EncBinary()
					_ = yym370
					if false {
					} else if z.HasExtensions() && z.EncExt(yy369) {
					} else if !yym370 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy369)
					} else {
						z.EncFallback(yy369)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[66] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runtimeRequestTimeout"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy371 := &x.RuntimeRequestTimeout
					yym372 := z.EncBinary()
					_ = yym372
					if false {
					} else if z.HasExtensions() && z.EncExt(yy371) {
					} else if !yym372 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy371)
					} else {
						z.EncFallback(yy371)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[67] {
					yym374 := z.EncBinary()
					_ = yym374
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[67] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym375 := z.EncBinary()
					_ = yym375
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[68] {
					yym377 := z.EncBinary()
					_ = yym377
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[68] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalMounterPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym378 := z.EncBinary()
					_ = yym378
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExperimentalMounterPath))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[69] {
					yym380 := z.EncBinary()
					_ = yym380
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[69] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktAPIEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym381 := z.EncBinary()
					_ = yym381
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktAPIEndpoint))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[70] {
					yym383 := z.EncBinary()
					_ = yym383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[70] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rktStage1Image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym384 := z.EncBinary()
					_ = yym384
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RktStage1Image))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym386 := z.EncBinary()
				_ = yym386
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lockFilePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym387 := z.EncBinary()
				_ = yym387
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.LockFilePath))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym389 := z.EncBinary()
				_ = yym389
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitOnLockContention"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym390 := z.EncBinary()
				_ = yym390
				if false {
				} else {
					r.EncodeBool(bool(x.ExitOnLockContention))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym392 := z.EncBinary()
				_ = yym392
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hairpinMode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym393 := z.EncBinary()
				_ = yym393
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.HairpinMode))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym395 := z.EncBinary()
				_ = yym395
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("babysitDaemons"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym396 := z.EncBinary()
				_ = yym396
				if false {
				} else {
					r.EncodeBool(bool(x.BabysitDaemons))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym398 := z.EncBinary()
				_ = yym398
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxPods"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym399 := z.EncBinary()
				_ = yym399
				if false {
				} else {
					r.EncodeInt(int64(x.MaxPods))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym401 := z.EncBinary()
				_ = yym401
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nvidiaGPUs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym402 := z.EncBinary()
				_ = yym402
				if false {
				} else {
					r.EncodeInt(int64(x.NvidiaGPUs))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym404 := z.EncBinary()
				_ = yym404
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("dockerExecHandlerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym405 := z.EncBinary()
				_ = yym405
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DockerExecHandlerName))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym407 := z.EncBinary()
				_ = yym407
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym408 := z.EncBinary()
				_ = yym408
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym410 := z.EncBinary()
				_ = yym410
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resolvConf"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym411 := z.EncBinary()
				_ = yym411
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ResolverConfig))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym413 := z.EncBinary()
				_ = yym413
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cpuCFSQuota"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym414 := z.EncBinary()
				_ = yym414
				if false {
				} else {
					r.EncodeBool(bool(x.CPUCFSQuota))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym416 := z.EncBinary()
				_ = yym416
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerized"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym417 := z.EncBinary()
				_ = yym417
				if false {
				} else {
					r.EncodeBool(bool(x.Containerized))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym419 := z.EncBinary()
				_ = yym419
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxOpenFiles"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym420 := z.EncBinary()
				_ = yym420
				if false {
				} else {
					r.EncodeInt(int64(x.MaxOpenFiles))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym422 := z.EncBinary()
				_ = yym422
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("reconcileCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym423 := z.EncBinary()
				_ = yym423
				if false {
				} else {
					r.EncodeBool(bool(x.ReconcileCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym425 := z.EncBinary()
				_ = yym425
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerSchedulable"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym426 := z.EncBinary()
				_ = yym426
				if false {
				} else {
					r.EncodeBool(bool(x.RegisterSchedulable))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym428 := z.EncBinary()
				_ = yym428
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym429 := z.EncBinary()
				_ = yym429
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym431 := z.EncBinary()
				_ = yym431
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym432 := z.EncBinary()
				_ = yym432
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIQPS))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym434 := z.EncBinary()
				_ = yym434
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym435 := z.EncBinary()
				_ = yym435
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym437 := z.EncBinary()
				_ = yym437
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serializeImagePulls"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym438 := z.EncBinary()
				_ = yym438
				if false {
				} else {
					r.EncodeBool(bool(x.SerializeImagePulls))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[89] {
					yy440 := &x.OutOfDiskTransitionFrequency
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else if z.HasExtensions() && z.EncExt(yy440) {
					} else if !yym441 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy440)
					} else {
						z.EncFallback(yy440)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[89] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("outOfDiskTransitionFrequency"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy442 := &x.OutOfDiskTransitionFrequency
					yym443 := z.EncBinary()
					_ = yym443
					if false {
					} else if z.HasExtensions() && z.EncExt(yy442) {
					} else if !yym443 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy442)
					} else {
						z.EncFallback(yy442)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[90] {
					yym445 := z.EncBinary()
					_ = yym445
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[90] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym446 := z.EncBinary()
					_ = yym446
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeIP))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym448 := z.EncBinary()
					_ = yym448
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeLabels"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeLabels == nil {
					r.EncodeNil()
				} else {
					yym449 := z.EncBinary()
					_ = yym449
					if false {
					} else {
						z.F.EncMapStringStringV(x.NodeLabels, false, e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym451 := z.EncBinary()
				_ = yym451
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nonMasqueradeCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym452 := z.EncBinary()
				_ = yym452
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.NonMasqueradeCIDR))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym454 := z.EncBinary()
				_ = yym454
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableCustomMetrics"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym455 := z.EncBinary()
				_ = yym455
				if false {
				} else {
					r.EncodeBool(bool(x.EnableCustomMetrics))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[94] {
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[94] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionHard"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym458 := z.EncBinary()
					_ = yym458
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionHard))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[95] {
					yym460 := z.EncBinary()
					_ = yym460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[95] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoft"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym461 := z.EncBinary()
					_ = yym461
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoft))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[96] {
					yym463 := z.EncBinary()
					_ = yym463
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[96] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionSoftGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym464 := z.EncBinary()
					_ = yym464
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionSoftGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[97] {
					yy466 := &x.EvictionPressureTransitionPeriod
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else if z.HasExtensions() && z.EncExt(yy466) {
					} else if !yym467 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy466)
					} else {
						z.EncFallback(yy466)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[97] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionPressureTransitionPeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy468 := &x.EvictionPressureTransitionPeriod
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else if z.HasExtensions() && z.EncExt(yy468) {
					} else if !yym469 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy468)
					} else {
						z.EncFallback(yy468)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[98] {
					yym471 := z.EncBinary()
					_ = yym471
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq153[98] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMaxPodGracePeriod"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else {
						r.EncodeInt(int64(x.EvictionMaxPodGracePeriod))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[99] {
					yym474 := z.EncBinary()
					_ = yym474
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq153[99] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionMinimumReclaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym475 := z.EncBinary()
					_ = yym475
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.EvictionMinimumReclaim))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym477 := z.EncBinary()
				_ = yym477
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podsPerCore"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym478 := z.EncBinary()
				_ = yym478
				if false {
				} else {
					r.EncodeInt(int64(x.PodsPerCore))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym480 := z.EncBinary()
				_ = yym480
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableControllerAttachDetach"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym481 := z.EncBinary()
				_ = yym481
				if false {
				} else {
					r.EncodeBool(bool(x.EnableControllerAttachDetach))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym483 := z.EncBinary()
					_ = yym483
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SystemReserved == nil {
					r.EncodeNil()
				} else {
					yym484 := z.EncBinary()
					_ = yym484
					if false {
					} else if z.HasExtensions() && z.EncExt(x.SystemReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.SystemReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym486 := z.EncBinary()
					_ = yym486
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeReserved"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.KubeReserved == nil {
					r.EncodeNil()
				} else {
					yym487 := z.EncBinary()
					_ = yym487
					if false {
					} else if z.HasExtensions() && z.EncExt(x.KubeReserved) {
					} else {
						h.encconfig_ConfigurationMap((pkg2_config.ConfigurationMap)(x.KubeReserved), e)
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym489 := z.EncBinary()
				_ = yym489
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protectKernelDefaults"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym490 := z.EncBinary()
				_ = yym490
				if false {
				} else {
					r.EncodeBool(bool(x.ProtectKernelDefaults))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym492 := z.EncBinary()
				_ = yym492
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("makeIPTablesUtilChains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym493 := z.EncBinary()
				_ = yym493
				if false {
				} else {
					r.EncodeBool(bool(x.MakeIPTablesUtilChains))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym495 := z.EncBinary()
				_ = yym495
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesMasqueradeBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym496 := z.EncBinary()
				_ = yym496
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesMasqueradeBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym498 := z.EncBinary()
				_ = yym498
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iptablesDropBit"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym499 := z.EncBinary()
				_ = yym499
				if false {
				} else {
					r.EncodeInt(int64(x.IPTablesDropBit))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[108] {
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym501 := z.EncBinary()
						_ = yym501
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq153[108] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalAllowedUnsafeSysctls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedUnsafeSysctls == nil {
						r.EncodeNil()
					} else {
						yym502 := z.EncBinary()
						_ = yym502
						if false {
						} else {
							z.F.EncSliceStringV(x.AllowedUnsafeSysctls, false, e)
						}
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym504 := z.EncBinary()
				_ = yym504
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("featureGates"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym505 := z.EncBinary()
				_ = yym505
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FeatureGates))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[110] {
					yym507 := z.EncBinary()
					_ = yym507
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[110] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("enableCRI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym508 := z.EncBinary()
					_ = yym508
					if false {
					} else {
						r.EncodeBool(bool(x.EnableCRI))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[111] {
					yym510 := z.EncBinary()
					_ = yym510
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[111] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("experimentalFailSwapOn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym511 := z.EncBinary()
					_ = yym511
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalFailSwapOn))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq153[112] {
					yym513 := z.EncBinary()
					_ = yym513
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq153[112] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ExperimentalCheckNodeCapabilitiesBeforeMount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym514 := z.EncBinary()
					_ = yym514
					if false {
					} else {
						r.EncodeBool(bool(x.ExperimentalCheckNodeCapabilitiesBeforeMount))
					}
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym515 := z.DecBinary()
	_ = yym515
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct516 := r.ContainerType()
		if yyct516 == codecSelferValueTypeMap1234 {
			yyl516 := r.ReadMapStart()
			if yyl516 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl516, d)
			}
		} else if yyct516 == codecSelferValueTypeArray1234 {
			yyl516 := r.ReadArrayStart()
			if yyl516 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl516, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys517Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys517Slc
	var yyhl517 bool = l >= 0
	for yyj517 := 0; ; yyj517++ {
		if yyhl517 {
			if yyj517 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys517Slc = r.DecodeBytes(yys517Slc, true, true)
		yys517 := string(yys517Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys517 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "podManifestPath":
			if r.TryDecodeAsNil() {
				x.PodManifestPath = ""
			} else {
				x.PodManifestPath = string(r.DecodeString())
			}
		case "syncFrequency":
			if r.TryDecodeAsNil() {
				x.SyncFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv521 := &x.SyncFrequency
				yym522 := z.DecBinary()
				_ = yym522
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv521) {
				} else if !yym522 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv521)
				} else {
					z.DecFallback(yyv521, false)
				}
			}
		case "fileCheckFrequency":
			if r.TryDecodeAsNil() {
				x.FileCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv523 := &x.FileCheckFrequency
				yym524 := z.DecBinary()
				_ = yym524
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv523) {
				} else if !yym524 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv523)
				} else {
					z.DecFallback(yyv523, false)
				}
			}
		case "httpCheckFrequency":
			if r.TryDecodeAsNil() {
				x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv525 := &x.HTTPCheckFrequency
				yym526 := z.DecBinary()
				_ = yym526
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv525) {
				} else if !yym526 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv525)
				} else {
					z.DecFallback(yyv525, false)
				}
			}
		case "manifestURL":
			if r.TryDecodeAsNil() {
				x.ManifestURL = ""
			} else {
				x.ManifestURL = string(r.DecodeString())
			}
		case "manifestURLHeader":
			if r.TryDecodeAsNil() {
				x.ManifestURLHeader = ""
			} else {
				x.ManifestURLHeader = string(r.DecodeString())
			}
		case "enableServer":
			if r.TryDecodeAsNil() {
				x.EnableServer = false
			} else {
				x.EnableServer = bool(r.DecodeBool())
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "readOnlyPort":
			if r.TryDecodeAsNil() {
				x.ReadOnlyPort = 0
			} else {
				x.ReadOnlyPort = int32(r.DecodeInt(32))
			}
		case "tlsCertFile":
			if r.TryDecodeAsNil() {
				x.TLSCertFile = ""
			} else {
				x.TLSCertFile = string(r.DecodeString())
			}
		case "tlsPrivateKeyFile":
			if r.TryDecodeAsNil() {
				x.TLSPrivateKeyFile = ""
			} else {
				x.TLSPrivateKeyFile = string(r.DecodeString())
			}
		case "certDirectory":
			if r.TryDecodeAsNil() {
				x.CertDirectory = ""
			} else {
				x.CertDirectory = string(r.DecodeString())
			}
		case "authentication":
			if r.TryDecodeAsNil() {
				x.Authentication = KubeletAuthentication{}
			} else {
				yyv536 := &x.Authentication
				yyv536.CodecDecodeSelf(d)
			}
		case "authorization":
			if r.TryDecodeAsNil() {
				x.Authorization = KubeletAuthorization{}
			} else {
				yyv537 := &x.Authorization
				yyv537.CodecDecodeSelf(d)
			}
		case "hostnameOverride":
			if r.TryDecodeAsNil() {
				x.HostnameOverride = ""
			} else {
				x.HostnameOverride = string(r.DecodeString())
			}
		case "podInfraContainerImage":
			if r.TryDecodeAsNil() {
				x.PodInfraContainerImage = ""
			} else {
				x.PodInfraContainerImage = string(r.DecodeString())
			}
		case "dockerEndpoint":
			if r.TryDecodeAsNil() {
				x.DockerEndpoint = ""
			} else {
				x.DockerEndpoint = string(r.DecodeString())
			}
		case "rootDirectory":
			if r.TryDecodeAsNil() {
				x.RootDirectory = ""
			} else {
				x.RootDirectory = string(r.DecodeString())
			}
		case "seccompProfileRoot":
			if r.TryDecodeAsNil() {
				x.SeccompProfileRoot = ""
			} else {
				x.SeccompProfileRoot = string(r.DecodeString())
			}
		case "allowPrivileged":
			if r.TryDecodeAsNil() {
				x.AllowPrivileged = false
			} else {
				x.AllowPrivileged = bool(r.DecodeBool())
			}
		case "hostNetworkSources":
			if r.TryDecodeAsNil() {
				x.HostNetworkSources = nil
			} else {
				yyv544 := &x.HostNetworkSources
				yym545 := z.DecBinary()
				_ = yym545
				if false {
				} else {
					z.F.DecSliceStringX(yyv544, false, d)
				}
			}
		case "hostPIDSources":
			if r.TryDecodeAsNil() {
				x.HostPIDSources = nil
			} else {
				yyv546 := &x.HostPIDSources
				yym547 := z.DecBinary()
				_ = yym547
				if false {
				} else {
					z.F.DecSliceStringX(yyv546, false, d)
				}
			}
		case "hostIPCSources":
			if r.TryDecodeAsNil() {
				x.HostIPCSources = nil
			} else {
				yyv548 := &x.HostIPCSources
				yym549 := z.DecBinary()
				_ = yym549
				if false {
				} else {
					z.F.DecSliceStringX(yyv548, false, d)
				}
			}
		case "registryPullQPS":
			if r.TryDecodeAsNil() {
				x.RegistryPullQPS = 0
			} else {
				x.RegistryPullQPS = int32(r.DecodeInt(32))
			}
		case "registryBurst":
			if r.TryDecodeAsNil() {
				x.RegistryBurst = 0
			} else {
				x.RegistryBurst = int32(r.DecodeInt(32))
			}
		case "eventRecordQPS":
			if r.TryDecodeAsNil() {
				x.EventRecordQPS = 0
			} else {
				x.EventRecordQPS = int32(r.DecodeInt(32))
			}
		case "eventBurst":
			if r.TryDecodeAsNil() {
				x.EventBurst = 0
			} else {
				x.EventBurst = int32(r.DecodeInt(32))
			}
		case "enableDebuggingHandlers":
			if r.TryDecodeAsNil() {
				x.EnableDebuggingHandlers = false
			} else {
				x.EnableDebuggingHandlers = bool(r.DecodeBool())
			}
		case "minimumGCAge":
			if r.TryDecodeAsNil() {
				x.MinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv555 := &x.MinimumGCAge
				yym556 := z.DecBinary()
				_ = yym556
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv555) {
				} else if !yym556 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv555)
				} else {
					z.DecFallback(yyv555, false)
				}
			}
		case "maxPerPodContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxPerPodContainerCount = 0
			} else {
				x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
			}
		case "maxContainerCount":
			if r.TryDecodeAsNil() {
				x.MaxContainerCount = 0
			} else {
				x.MaxContainerCount = int32(r.DecodeInt(32))
			}
		case "cAdvisorPort":
			if r.TryDecodeAsNil() {
				x.CAdvisorPort = 0
			} else {
				x.CAdvisorPort = int32(r.DecodeInt(32))
			}
		case "healthzPort":
			if r.TryDecodeAsNil() {
				x.HealthzPort = 0
			} else {
				x.HealthzPort = int32(r.DecodeInt(32))
			}
		case "healthzBindAddress":
			if r.TryDecodeAsNil() {
				x.HealthzBindAddress = ""
			} else {
				x.HealthzBindAddress = string(r.DecodeString())
			}
		case "oomScoreAdj":
			if r.TryDecodeAsNil() {
				x.OOMScoreAdj = 0
			} else {
				x.OOMScoreAdj = int32(r.DecodeInt(32))
			}
		case "registerNode":
			if r.TryDecodeAsNil() {
				x.RegisterNode = false
			} else {
				x.RegisterNode = bool(r.DecodeBool())
			}
		case "clusterDomain":
			if r.TryDecodeAsNil() {
				x.ClusterDomain = ""
			} else {
				x.ClusterDomain = string(r.DecodeString())
			}
		case "masterServiceNamespace":
			if r.TryDecodeAsNil() {
				x.MasterServiceNamespace = ""
			} else {
				x.MasterServiceNamespace = string(r.DecodeString())
			}
		case "clusterDNS":
			if r.TryDecodeAsNil() {
				x.ClusterDNS = ""
			} else {
				x.ClusterDNS = string(r.DecodeString())
			}
		case "streamingConnectionIdleTimeout":
			if r.TryDecodeAsNil() {
				x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv567 := &x.StreamingConnectionIdleTimeout
				yym568 := z.DecBinary()
				_ = yym568
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv567) {
				} else if !yym568 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv567)
				} else {
					z.DecFallback(yyv567, false)
				}
			}
		case "nodeStatusUpdateFrequency":
			if r.TryDecodeAsNil() {
				x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv569 := &x.NodeStatusUpdateFrequency
				yym570 := z.DecBinary()
				_ = yym570
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv569) {
				} else if !yym570 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv569)
				} else {
					z.DecFallback(yyv569, false)
				}
			}
		case "imageMinimumGCAge":
			if r.TryDecodeAsNil() {
				x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
			} else {
				yyv571 := &x.ImageMinimumGCAge
				yym572 := z.DecBinary()
				_ = yym572
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv571) {
				} else if !yym572 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv571)
				} else {
					z.DecFallback(yyv571, false)
				}
			}
		case "imageGCHighThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCHighThresholdPercent = 0
			} else {
				x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
			}
		case "imageGCLowThresholdPercent":
			if r.TryDecodeAsNil() {
				x.ImageGCLowThresholdPercent = 0
			} else {
				x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
			}
		case "lowDiskSpaceThresholdMB":
			if r.TryDecodeAsNil() {
				x.LowDiskSpaceThresholdMB = 0
			} else {
				x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
			}
		case "volumeStatsAggPeriod":
			if r.TryDecodeAsNil() {
				x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv576 := &x.VolumeStatsAggPeriod
				yym577 := z.DecBinary()
				_ = yym577
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv576) {
				} else if !yym577 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv576)
				} else {
					z.DecFallback(yyv576, false)
				}
			}
		case "networkPluginName":
			if r.TryDecodeAsNil() {
				x.NetworkPluginName = ""
			} else {
				x.NetworkPluginName = string(r.DecodeString())
			}
		case "networkPluginMTU":
			if r.TryDecodeAsNil() {
				x.NetworkPluginMTU = 0
			} else {
				x.NetworkPluginMTU = int32(r.DecodeInt(32))
			}
		case "networkPluginDir":
			if r.TryDecodeAsNil() {
				x.NetworkPluginDir = ""
			} else {
				x.NetworkPluginDir = string(r.DecodeString())
			}
		case "cniConfDir":
			if r.TryDecodeAsNil() {
				x.CNIConfDir = ""
			} else {
				x.CNIConfDir = string(r.DecodeString())
			}
		case "cniBinDir":
			if r.TryDecodeAsNil() {
				x.CNIBinDir = ""
			} else {
				x.CNIBinDir = string(r.DecodeString())
			}
		case "volumePluginDir":
			if r.TryDecodeAsNil() {
				x.VolumePluginDir = ""
			} else {
				x.VolumePluginDir = string(r.DecodeString())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "kubeletCgroups":
			if r.TryDecodeAsNil() {
				x.KubeletCgroups = ""
			} else {
				x.KubeletCgroups = string(r.DecodeString())
			}
		case "experimentalCgroupsPerQOS":
			if r.TryDecodeAsNil() {
				x.ExperimentalCgroupsPerQOS = false
			} else {
				x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
			}
		case "cgroupDriver":
			if r.TryDecodeAsNil() {
				x.CgroupDriver = ""
			} else {
				x.CgroupDriver = string(r.DecodeString())
			}
		case "runtimeCgroups":
			if r.TryDecodeAsNil() {
				x.RuntimeCgroups = ""
			} else {
				x.RuntimeCgroups = string(r.DecodeString())
			}
		case "systemCgroups":
			if r.TryDecodeAsNil() {
				x.SystemCgroups = ""
			} else {
				x.SystemCgroups = string(r.DecodeString())
			}
		case "cgroupRoot":
			if r.TryDecodeAsNil() {
				x.CgroupRoot = ""
			} else {
				x.CgroupRoot = string(r.DecodeString())
			}
		case "containerRuntime":
			if r.TryDecodeAsNil() {
				x.ContainerRuntime = ""
			} else {
				x.ContainerRuntime = string(r.DecodeString())
			}
		case "remoteRuntimeEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteRuntimeEndpoint = ""
			} else {
				x.RemoteRuntimeEndpoint = string(r.DecodeString())
			}
		case "remoteImageEndpoint":
			if r.TryDecodeAsNil() {
				x.RemoteImageEndpoint = ""
			} else {
				x.RemoteImageEndpoint = string(r.DecodeString())
			}
		case "runtimeRequestTimeout":
			if r.TryDecodeAsNil() {
				x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv595 := &x.RuntimeRequestTimeout
				yym596 := z.DecBinary()
				_ = yym596
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv595) {
				} else if !yym596 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv595)
				} else {
					z.DecFallback(yyv595, false)
				}
			}
		case "rktPath":
			if r.TryDecodeAsNil() {
				x.RktPath = ""
			} else {
				x.RktPath = string(r.DecodeString())
			}
		case "experimentalMounterPath":
			if r.TryDecodeAsNil() {
				x.ExperimentalMounterPath = ""
			} else {
				x.ExperimentalMounterPath = string(r.DecodeString())
			}
		case "rktAPIEndpoint":
			if r.TryDecodeAsNil() {
				x.RktAPIEndpoint = ""
			} else {
				x.RktAPIEndpoint = string(r.DecodeString())
			}
		case "rktStage1Image":
			if r.TryDecodeAsNil() {
				x.RktStage1Image = ""
			} else {
				x.RktStage1Image = string(r.DecodeString())
			}
		case "lockFilePath":
			if r.TryDecodeAsNil() {
				x.LockFilePath = ""
			} else {
				x.LockFilePath = string(r.DecodeString())
			}
		case "exitOnLockContention":
			if r.TryDecodeAsNil() {
				x.ExitOnLockContention = false
			} else {
				x.ExitOnLockContention = bool(r.DecodeBool())
			}
		case "hairpinMode":
			if r.TryDecodeAsNil() {
				x.HairpinMode = ""
			} else {
				x.HairpinMode = string(r.DecodeString())
			}
		case "babysitDaemons":
			if r.TryDecodeAsNil() {
				x.BabysitDaemons = false
			} else {
				x.BabysitDaemons = bool(r.DecodeBool())
			}
		case "maxPods":
			if r.TryDecodeAsNil() {
				x.MaxPods = 0
			} else {
				x.MaxPods = int32(r.DecodeInt(32))
			}
		case "nvidiaGPUs":
			if r.TryDecodeAsNil() {
				x.NvidiaGPUs = 0
			} else {
				x.NvidiaGPUs = int32(r.DecodeInt(32))
			}
		case "dockerExecHandlerName":
			if r.TryDecodeAsNil() {
				x.DockerExecHandlerName = ""
			} else {
				x.DockerExecHandlerName = string(r.DecodeString())
			}
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "resolvConf":
			if r.TryDecodeAsNil() {
				x.ResolverConfig = ""
			} else {
				x.ResolverConfig = string(r.DecodeString())
			}
		case "cpuCFSQuota":
			if r.TryDecodeAsNil() {
				x.CPUCFSQuota = false
			} else {
				x.CPUCFSQuota = bool(r.DecodeBool())
			}
		case "containerized":
			if r.TryDecodeAsNil() {
				x.Containerized = false
			} else {
				x.Containerized = bool(r.DecodeBool())
			}
		case "maxOpenFiles":
			if r.TryDecodeAsNil() {
				x.MaxOpenFiles = 0
			} else {
				x.MaxOpenFiles = int64(r.DecodeInt(64))
			}
		case "reconcileCIDR":
			if r.TryDecodeAsNil() {
				x.ReconcileCIDR = false
			} else {
				x.ReconcileCIDR = bool(r.DecodeBool())
			}
		case "registerSchedulable":
			if r.TryDecodeAsNil() {
				x.RegisterSchedulable = false
			} else {
				x.RegisterSchedulable = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = int32(r.DecodeInt(32))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "serializeImagePulls":
			if r.TryDecodeAsNil() {
				x.SerializeImagePulls = false
			} else {
				x.SerializeImagePulls = bool(r.DecodeBool())
			}
		case "outOfDiskTransitionFrequency":
			if r.TryDecodeAsNil() {
				x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
			} else {
				yyv619 := &x.OutOfDiskTransitionFrequency
				yym620 := z.DecBinary()
				_ = yym620
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv619) {
				} else if !yym620 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv619)
				} else {
					z.DecFallback(yyv619, false)
				}
			}
		case "nodeIP":
			if r.TryDecodeAsNil() {
				x.NodeIP = ""
			} else {
				x.NodeIP = string(r.DecodeString())
			}
		case "nodeLabels":
			if r.TryDecodeAsNil() {
				x.NodeLabels = nil
			} else {
				yyv622 := &x.NodeLabels
				yym623 := z.DecBinary()
				_ = yym623
				if false {
				} else {
					z.F.DecMapStringStringX(yyv622, false, d)
				}
			}
		case "nonMasqueradeCIDR":
			if r.TryDecodeAsNil() {
				x.NonMasqueradeCIDR = ""
			} else {
				x.NonMasqueradeCIDR = string(r.DecodeString())
			}
		case "enableCustomMetrics":
			if r.TryDecodeAsNil() {
				x.EnableCustomMetrics = false
			} else {
				x.EnableCustomMetrics = bool(r.DecodeBool())
			}
		case "evictionHard":
			if r.TryDecodeAsNil() {
				x.EvictionHard = ""
			} else {
				x.EvictionHard = string(r.DecodeString())
			}
		case "evictionSoft":
			if r.TryDecodeAsNil() {
				x.EvictionSoft = ""
			} else {
				x.EvictionSoft = string(r.DecodeString())
			}
		case "evictionSoftGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionSoftGracePeriod = ""
			} else {
				x.EvictionSoftGracePeriod = string(r.DecodeString())
			}
		case "evictionPressureTransitionPeriod":
			if r.TryDecodeAsNil() {
				x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv629 := &x.EvictionPressureTransitionPeriod
				yym630 := z.DecBinary()
				_ = yym630
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv629) {
				} else if !yym630 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv629)
				} else {
					z.DecFallback(yyv629, false)
				}
			}
		case "evictionMaxPodGracePeriod":
			if r.TryDecodeAsNil() {
				x.EvictionMaxPodGracePeriod = 0
			} else {
				x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
			}
		case "evictionMinimumReclaim":
			if r.TryDecodeAsNil() {
				x.EvictionMinimumReclaim = ""
			} else {
				x.EvictionMinimumReclaim = string(r.DecodeString())
			}
		case "podsPerCore":
			if r.TryDecodeAsNil() {
				x.PodsPerCore = 0
			} else {
				x.PodsPerCore = int32(r.DecodeInt(32))
			}
		case "enableControllerAttachDetach":
			if r.TryDecodeAsNil() {
				x.EnableControllerAttachDetach = false
			} else {
				x.EnableControllerAttachDetach = bool(r.DecodeBool())
			}
		case "systemReserved":
			if r.TryDecodeAsNil() {
				x.SystemReserved = nil
			} else {
				yyv635 := &x.SystemReserved
				yym636 := z.DecBinary()
				_ = yym636
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv635) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv635), d)
				}
			}
		case "kubeReserved":
			if r.TryDecodeAsNil() {
				x.KubeReserved = nil
			} else {
				yyv637 := &x.KubeReserved
				yym638 := z.DecBinary()
				_ = yym638
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv637) {
				} else {
					h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv637), d)
				}
			}
		case "protectKernelDefaults":
			if r.TryDecodeAsNil() {
				x.ProtectKernelDefaults = false
			} else {
				x.ProtectKernelDefaults = bool(r.DecodeBool())
			}
		case "makeIPTablesUtilChains":
			if r.TryDecodeAsNil() {
				x.MakeIPTablesUtilChains = false
			} else {
				x.MakeIPTablesUtilChains = bool(r.DecodeBool())
			}
		case "iptablesMasqueradeBit":
			if r.TryDecodeAsNil() {
				x.IPTablesMasqueradeBit = 0
			} else {
				x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
			}
		case "iptablesDropBit":
			if r.TryDecodeAsNil() {
				x.IPTablesDropBit = 0
			} else {
				x.IPTablesDropBit = int32(r.DecodeInt(32))
			}
		case "experimentalAllowedUnsafeSysctls":
			if r.TryDecodeAsNil() {
				x.AllowedUnsafeSysctls = nil
			} else {
				yyv643 := &x.AllowedUnsafeSysctls
				yym644 := z.DecBinary()
				_ = yym644
				if false {
				} else {
					z.F.DecSliceStringX(yyv643, false, d)
				}
			}
		case "featureGates":
			if r.TryDecodeAsNil() {
				x.FeatureGates = ""
			} else {
				x.FeatureGates = string(r.DecodeString())
			}
		case "enableCRI":
			if r.TryDecodeAsNil() {
				x.EnableCRI = false
			} else {
				x.EnableCRI = bool(r.DecodeBool())
			}
		case "experimentalFailSwapOn":
			if r.TryDecodeAsNil() {
				x.ExperimentalFailSwapOn = false
			} else {
				x.ExperimentalFailSwapOn = bool(r.DecodeBool())
			}
		case "ExperimentalCheckNodeCapabilitiesBeforeMount":
			if r.TryDecodeAsNil() {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
			} else {
				x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys517)
		} // end switch yys517
	} // end for yyj517
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj649 int
	var yyb649 bool
	var yyhl649 bool = l >= 0
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodManifestPath = ""
	} else {
		x.PodManifestPath = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SyncFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv653 := &x.SyncFrequency
		yym654 := z.DecBinary()
		_ = yym654
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv653) {
		} else if !yym654 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv653)
		} else {
			z.DecFallback(yyv653, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FileCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv655 := &x.FileCheckFrequency
		yym656 := z.DecBinary()
		_ = yym656
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv655) {
		} else if !yym656 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv655)
		} else {
			z.DecFallback(yyv655, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPCheckFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv657 := &x.HTTPCheckFrequency
		yym658 := z.DecBinary()
		_ = yym658
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv657) {
		} else if !yym658 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv657)
		} else {
			z.DecFallback(yyv657, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURL = ""
	} else {
		x.ManifestURL = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ManifestURLHeader = ""
	} else {
		x.ManifestURLHeader = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableServer = false
	} else {
		x.EnableServer = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyPort = 0
	} else {
		x.ReadOnlyPort = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSCertFile = ""
	} else {
		x.TLSCertFile = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLSPrivateKeyFile = ""
	} else {
		x.TLSPrivateKeyFile = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CertDirectory = ""
	} else {
		x.CertDirectory = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authentication = KubeletAuthentication{}
	} else {
		yyv668 := &x.Authentication
		yyv668.CodecDecodeSelf(d)
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Authorization = KubeletAuthorization{}
	} else {
		yyv669 := &x.Authorization
		yyv669.CodecDecodeSelf(d)
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostnameOverride = ""
	} else {
		x.HostnameOverride = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodInfraContainerImage = ""
	} else {
		x.PodInfraContainerImage = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerEndpoint = ""
	} else {
		x.DockerEndpoint = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootDirectory = ""
	} else {
		x.RootDirectory = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SeccompProfileRoot = ""
	} else {
		x.SeccompProfileRoot = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowPrivileged = false
	} else {
		x.AllowPrivileged = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetworkSources = nil
	} else {
		yyv676 := &x.HostNetworkSources
		yym677 := z.DecBinary()
		_ = yym677
		if false {
		} else {
			z.F.DecSliceStringX(yyv676, false, d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPIDSources = nil
	} else {
		yyv678 := &x.HostPIDSources
		yym679 := z.DecBinary()
		_ = yym679
		if false {
		} else {
			z.F.DecSliceStringX(yyv678, false, d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPCSources = nil
	} else {
		yyv680 := &x.HostIPCSources
		yym681 := z.DecBinary()
		_ = yym681
		if false {
		} else {
			z.F.DecSliceStringX(yyv680, false, d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryPullQPS = 0
	} else {
		x.RegistryPullQPS = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegistryBurst = 0
	} else {
		x.RegistryBurst = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventRecordQPS = 0
	} else {
		x.EventRecordQPS = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EventBurst = 0
	} else {
		x.EventBurst = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDebuggingHandlers = false
	} else {
		x.EnableDebuggingHandlers = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv687 := &x.MinimumGCAge
		yym688 := z.DecBinary()
		_ = yym688
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv687) {
		} else if !yym688 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv687)
		} else {
			z.DecFallback(yyv687, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPerPodContainerCount = 0
	} else {
		x.MaxPerPodContainerCount = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxContainerCount = 0
	} else {
		x.MaxContainerCount = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CAdvisorPort = 0
	} else {
		x.CAdvisorPort = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzPort = 0
	} else {
		x.HealthzPort = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HealthzBindAddress = ""
	} else {
		x.HealthzBindAddress = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OOMScoreAdj = 0
	} else {
		x.OOMScoreAdj = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterNode = false
	} else {
		x.RegisterNode = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDomain = ""
	} else {
		x.ClusterDomain = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MasterServiceNamespace = ""
	} else {
		x.MasterServiceNamespace = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterDNS = ""
	} else {
		x.ClusterDNS = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StreamingConnectionIdleTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv699 := &x.StreamingConnectionIdleTimeout
		yym700 := z.DecBinary()
		_ = yym700
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv699) {
		} else if !yym700 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv699)
		} else {
			z.DecFallback(yyv699, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStatusUpdateFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv701 := &x.NodeStatusUpdateFrequency
		yym702 := z.DecBinary()
		_ = yym702
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv701) {
		} else if !yym702 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv701)
		} else {
			z.DecFallback(yyv701, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageMinimumGCAge = pkg1_unversioned.Duration{}
	} else {
		yyv703 := &x.ImageMinimumGCAge
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv703) {
		} else if !yym704 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv703)
		} else {
			z.DecFallback(yyv703, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCHighThresholdPercent = 0
	} else {
		x.ImageGCHighThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageGCLowThresholdPercent = 0
	} else {
		x.ImageGCLowThresholdPercent = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LowDiskSpaceThresholdMB = 0
	} else {
		x.LowDiskSpaceThresholdMB = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeStatsAggPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv708 := &x.VolumeStatsAggPeriod
		yym709 := z.DecBinary()
		_ = yym709
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv708) {
		} else if !yym709 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv708)
		} else {
			z.DecFallback(yyv708, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginName = ""
	} else {
		x.NetworkPluginName = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginMTU = 0
	} else {
		x.NetworkPluginMTU = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NetworkPluginDir = ""
	} else {
		x.NetworkPluginDir = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIConfDir = ""
	} else {
		x.CNIConfDir = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CNIBinDir = ""
	} else {
		x.CNIBinDir = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePluginDir = ""
	} else {
		x.VolumePluginDir = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletCgroups = ""
	} else {
		x.KubeletCgroups = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCgroupsPerQOS = false
	} else {
		x.ExperimentalCgroupsPerQOS = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupDriver = ""
	} else {
		x.CgroupDriver = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeCgroups = ""
	} else {
		x.RuntimeCgroups = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemCgroups = ""
	} else {
		x.SystemCgroups = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CgroupRoot = ""
	} else {
		x.CgroupRoot = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntime = ""
	} else {
		x.ContainerRuntime = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteRuntimeEndpoint = ""
	} else {
		x.RemoteRuntimeEndpoint = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RemoteImageEndpoint = ""
	} else {
		x.RemoteImageEndpoint = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RuntimeRequestTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv727 := &x.RuntimeRequestTimeout
		yym728 := z.DecBinary()
		_ = yym728
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv727) {
		} else if !yym728 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv727)
		} else {
			z.DecFallback(yyv727, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktPath = ""
	} else {
		x.RktPath = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalMounterPath = ""
	} else {
		x.ExperimentalMounterPath = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktAPIEndpoint = ""
	} else {
		x.RktAPIEndpoint = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RktStage1Image = ""
	} else {
		x.RktStage1Image = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LockFilePath = ""
	} else {
		x.LockFilePath = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitOnLockContention = false
	} else {
		x.ExitOnLockContention = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HairpinMode = ""
	} else {
		x.HairpinMode = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BabysitDaemons = false
	} else {
		x.BabysitDaemons = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxPods = 0
	} else {
		x.MaxPods = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NvidiaGPUs = 0
	} else {
		x.NvidiaGPUs = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DockerExecHandlerName = ""
	} else {
		x.DockerExecHandlerName = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResolverConfig = ""
	} else {
		x.ResolverConfig = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CPUCFSQuota = false
	} else {
		x.CPUCFSQuota = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containerized = false
	} else {
		x.Containerized = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxOpenFiles = 0
	} else {
		x.MaxOpenFiles = int64(r.DecodeInt(64))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReconcileCIDR = false
	} else {
		x.ReconcileCIDR = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterSchedulable = false
	} else {
		x.RegisterSchedulable = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SerializeImagePulls = false
	} else {
		x.SerializeImagePulls = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OutOfDiskTransitionFrequency = pkg1_unversioned.Duration{}
	} else {
		yyv751 := &x.OutOfDiskTransitionFrequency
		yym752 := z.DecBinary()
		_ = yym752
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv751) {
		} else if !yym752 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv751)
		} else {
			z.DecFallback(yyv751, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeIP = ""
	} else {
		x.NodeIP = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeLabels = nil
	} else {
		yyv754 := &x.NodeLabels
		yym755 := z.DecBinary()
		_ = yym755
		if false {
		} else {
			z.F.DecMapStringStringX(yyv754, false, d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonMasqueradeCIDR = ""
	} else {
		x.NonMasqueradeCIDR = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCustomMetrics = false
	} else {
		x.EnableCustomMetrics = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionHard = ""
	} else {
		x.EvictionHard = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoft = ""
	} else {
		x.EvictionSoft = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionSoftGracePeriod = ""
	} else {
		x.EvictionSoftGracePeriod = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionPressureTransitionPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv761 := &x.EvictionPressureTransitionPeriod
		yym762 := z.DecBinary()
		_ = yym762
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv761) {
		} else if !yym762 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv761)
		} else {
			z.DecFallback(yyv761, false)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMaxPodGracePeriod = 0
	} else {
		x.EvictionMaxPodGracePeriod = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EvictionMinimumReclaim = ""
	} else {
		x.EvictionMinimumReclaim = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodsPerCore = 0
	} else {
		x.PodsPerCore = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableControllerAttachDetach = false
	} else {
		x.EnableControllerAttachDetach = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemReserved = nil
	} else {
		yyv767 := &x.SystemReserved
		yym768 := z.DecBinary()
		_ = yym768
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv767) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv767), d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeReserved = nil
	} else {
		yyv769 := &x.KubeReserved
		yym770 := z.DecBinary()
		_ = yym770
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv769) {
		} else {
			h.decconfig_ConfigurationMap((*pkg2_config.ConfigurationMap)(yyv769), d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectKernelDefaults = false
	} else {
		x.ProtectKernelDefaults = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MakeIPTablesUtilChains = false
	} else {
		x.MakeIPTablesUtilChains = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesMasqueradeBit = 0
	} else {
		x.IPTablesMasqueradeBit = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IPTablesDropBit = 0
	} else {
		x.IPTablesDropBit = int32(r.DecodeInt(32))
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedUnsafeSysctls = nil
	} else {
		yyv775 := &x.AllowedUnsafeSysctls
		yym776 := z.DecBinary()
		_ = yym776
		if false {
		} else {
			z.F.DecSliceStringX(yyv775, false, d)
		}
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FeatureGates = ""
	} else {
		x.FeatureGates = string(r.DecodeString())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableCRI = false
	} else {
		x.EnableCRI = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalFailSwapOn = false
	} else {
		x.ExperimentalFailSwapOn = bool(r.DecodeBool())
	}
	yyj649++
	if yyhl649 {
		yyb649 = yyj649 > l
	} else {
		yyb649 = r.CheckBreak()
	}
	if yyb649 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = false
	} else {
		x.ExperimentalCheckNodeCapabilitiesBeforeMount = bool(r.DecodeBool())
	}
	for {
		yyj649++
		if yyhl649 {
			yyb649 = yyj649 > l
		} else {
			yyb649 = r.CheckBreak()
		}
		if yyb649 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj649-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x KubeletAuthorizationMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym781 := z.EncBinary()
	_ = yym781
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *KubeletAuthorizationMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym782 := z.DecBinary()
	_ = yym782
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *KubeletAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym783 := z.EncBinary()
		_ = yym783
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep784 := !z.EncBinary()
			yy2arr784 := z.EncBasicHandle().StructToArray
			var yyq784 [2]bool
			_, _, _ = yysep784, yyq784, yy2arr784
			const yyr784 bool = false
			var yynn784 int
			if yyr784 || yy2arr784 {
				r.EncodeArrayStart(2)
			} else {
				yynn784 = 2
				for _, b := range yyq784 {
					if b {
						yynn784++
					}
				}
				r.EncodeMapStart(yynn784)
				yynn784 = 0
			}
			if yyr784 || yy2arr784 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Mode.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Mode.CodecEncodeSelf(e)
			}
			if yyr784 || yy2arr784 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy787 := &x.Webhook
				yy787.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy788 := &x.Webhook
				yy788.CodecEncodeSelf(e)
			}
			if yyr784 || yy2arr784 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym789 := z.DecBinary()
	_ = yym789
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct790 := r.ContainerType()
		if yyct790 == codecSelferValueTypeMap1234 {
			yyl790 := r.ReadMapStart()
			if yyl790 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl790, d)
			}
		} else if yyct790 == codecSelferValueTypeArray1234 {
			yyl790 := r.ReadArrayStart()
			if yyl790 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl790, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys791Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys791Slc
	var yyhl791 bool = l >= 0
	for yyj791 := 0; ; yyj791++ {
		if yyhl791 {
			if yyj791 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys791Slc = r.DecodeBytes(yys791Slc, true, true)
		yys791 := string(yys791Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys791 {
		case "mode":
			if r.TryDecodeAsNil() {
				x.Mode = ""
			} else {
				x.Mode = KubeletAuthorizationMode(r.DecodeString())
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthorization{}
			} else {
				yyv793 := &x.Webhook
				yyv793.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys791)
		} // end switch yys791
	} // end for yyj791
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj794 int
	var yyb794 bool
	var yyhl794 bool = l >= 0
	yyj794++
	if yyhl794 {
		yyb794 = yyj794 > l
	} else {
		yyb794 = r.CheckBreak()
	}
	if yyb794 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Mode = ""
	} else {
		x.Mode = KubeletAuthorizationMode(r.DecodeString())
	}
	yyj794++
	if yyhl794 {
		yyb794 = yyj794 > l
	} else {
		yyb794 = r.CheckBreak()
	}
	if yyb794 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthorization{}
	} else {
		yyv796 := &x.Webhook
		yyv796.CodecDecodeSelf(d)
	}
	for {
		yyj794++
		if yyhl794 {
			yyb794 = yyj794 > l
		} else {
			yyb794 = r.CheckBreak()
		}
		if yyb794 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj794-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthorization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym797 := z.EncBinary()
		_ = yym797
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep798 := !z.EncBinary()
			yy2arr798 := z.EncBasicHandle().StructToArray
			var yyq798 [2]bool
			_, _, _ = yysep798, yyq798, yy2arr798
			const yyr798 bool = false
			var yynn798 int
			if yyr798 || yy2arr798 {
				r.EncodeArrayStart(2)
			} else {
				yynn798 = 2
				for _, b := range yyq798 {
					if b {
						yynn798++
					}
				}
				r.EncodeMapStart(yynn798)
				yynn798 = 0
			}
			if yyr798 || yy2arr798 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy800 := &x.CacheAuthorizedTTL
				yym801 := z.EncBinary()
				_ = yym801
				if false {
				} else if z.HasExtensions() && z.EncExt(yy800) {
				} else if !yym801 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy800)
				} else {
					z.EncFallback(yy800)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheAuthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy802 := &x.CacheAuthorizedTTL
				yym803 := z.EncBinary()
				_ = yym803
				if false {
				} else if z.HasExtensions() && z.EncExt(yy802) {
				} else if !yym803 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy802)
				} else {
					z.EncFallback(yy802)
				}
			}
			if yyr798 || yy2arr798 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy805 := &x.CacheUnauthorizedTTL
				yym806 := z.EncBinary()
				_ = yym806
				if false {
				} else if z.HasExtensions() && z.EncExt(yy805) {
				} else if !yym806 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy805)
				} else {
					z.EncFallback(yy805)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheUnauthorizedTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy807 := &x.CacheUnauthorizedTTL
				yym808 := z.EncBinary()
				_ = yym808
				if false {
				} else if z.HasExtensions() && z.EncExt(yy807) {
				} else if !yym808 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy807)
				} else {
					z.EncFallback(yy807)
				}
			}
			if yyr798 || yy2arr798 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthorization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym809 := z.DecBinary()
	_ = yym809
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct810 := r.ContainerType()
		if yyct810 == codecSelferValueTypeMap1234 {
			yyl810 := r.ReadMapStart()
			if yyl810 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl810, d)
			}
		} else if yyct810 == codecSelferValueTypeArray1234 {
			yyl810 := r.ReadArrayStart()
			if yyl810 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl810, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys811Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys811Slc
	var yyhl811 bool = l >= 0
	for yyj811 := 0; ; yyj811++ {
		if yyhl811 {
			if yyj811 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys811Slc = r.DecodeBytes(yys811Slc, true, true)
		yys811 := string(yys811Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys811 {
		case "cacheAuthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheAuthorizedTTL = pkg1_unversioned.Duration{}
			} else {
				yyv812 := &x.CacheAuthorizedTTL
				yym813 := z.DecBinary()
				_ = yym813
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv812) {
				} else if !yym813 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv812)
				} else {
					z.DecFallback(yyv812, false)
				}
			}
		case "cacheUnauthorizedTTL":
			if r.TryDecodeAsNil() {
				x.CacheUnauthorizedTTL = pkg1_unversioned.Duration{}
			} else {
				yyv814 := &x.CacheUnauthorizedTTL
				yym815 := z.DecBinary()
				_ = yym815
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv814) {
				} else if !yym815 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv814)
				} else {
					z.DecFallback(yyv814, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys811)
		} // end switch yys811
	} // end for yyj811
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthorization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj816 int
	var yyb816 bool
	var yyhl816 bool = l >= 0
	yyj816++
	if yyhl816 {
		yyb816 = yyj816 > l
	} else {
		yyb816 = r.CheckBreak()
	}
	if yyb816 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheAuthorizedTTL = pkg1_unversioned.Duration{}
	} else {
		yyv817 := &x.CacheAuthorizedTTL
		yym818 := z.DecBinary()
		_ = yym818
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv817) {
		} else if !yym818 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv817)
		} else {
			z.DecFallback(yyv817, false)
		}
	}
	yyj816++
	if yyhl816 {
		yyb816 = yyj816 > l
	} else {
		yyb816 = r.CheckBreak()
	}
	if yyb816 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheUnauthorizedTTL = pkg1_unversioned.Duration{}
	} else {
		yyv819 := &x.CacheUnauthorizedTTL
		yym820 := z.DecBinary()
		_ = yym820
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv819) {
		} else if !yym820 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv819)
		} else {
			z.DecFallback(yyv819, false)
		}
	}
	for {
		yyj816++
		if yyhl816 {
			yyb816 = yyj816 > l
		} else {
			yyb816 = r.CheckBreak()
		}
		if yyb816 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj816-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym821 := z.EncBinary()
		_ = yym821
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep822 := !z.EncBinary()
			yy2arr822 := z.EncBasicHandle().StructToArray
			var yyq822 [3]bool
			_, _, _ = yysep822, yyq822, yy2arr822
			const yyr822 bool = false
			var yynn822 int
			if yyr822 || yy2arr822 {
				r.EncodeArrayStart(3)
			} else {
				yynn822 = 3
				for _, b := range yyq822 {
					if b {
						yynn822++
					}
				}
				r.EncodeMapStart(yynn822)
				yynn822 = 0
			}
			if yyr822 || yy2arr822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy824 := &x.X509
				yy824.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("x509"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy825 := &x.X509
				yy825.CodecEncodeSelf(e)
			}
			if yyr822 || yy2arr822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy827 := &x.Webhook
				yy827.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("webhook"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy828 := &x.Webhook
				yy828.CodecEncodeSelf(e)
			}
			if yyr822 || yy2arr822 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy830 := &x.Anonymous
				yy830.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("anonymous"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy831 := &x.Anonymous
				yy831.CodecEncodeSelf(e)
			}
			if yyr822 || yy2arr822 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym832 := z.DecBinary()
	_ = yym832
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct833 := r.ContainerType()
		if yyct833 == codecSelferValueTypeMap1234 {
			yyl833 := r.ReadMapStart()
			if yyl833 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl833, d)
			}
		} else if yyct833 == codecSelferValueTypeArray1234 {
			yyl833 := r.ReadArrayStart()
			if yyl833 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl833, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys834Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys834Slc
	var yyhl834 bool = l >= 0
	for yyj834 := 0; ; yyj834++ {
		if yyhl834 {
			if yyj834 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys834Slc = r.DecodeBytes(yys834Slc, true, true)
		yys834 := string(yys834Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys834 {
		case "x509":
			if r.TryDecodeAsNil() {
				x.X509 = KubeletX509Authentication{}
			} else {
				yyv835 := &x.X509
				yyv835.CodecDecodeSelf(d)
			}
		case "webhook":
			if r.TryDecodeAsNil() {
				x.Webhook = KubeletWebhookAuthentication{}
			} else {
				yyv836 := &x.Webhook
				yyv836.CodecDecodeSelf(d)
			}
		case "anonymous":
			if r.TryDecodeAsNil() {
				x.Anonymous = KubeletAnonymousAuthentication{}
			} else {
				yyv837 := &x.Anonymous
				yyv837.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys834)
		} // end switch yys834
	} // end for yyj834
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj838 int
	var yyb838 bool
	var yyhl838 bool = l >= 0
	yyj838++
	if yyhl838 {
		yyb838 = yyj838 > l
	} else {
		yyb838 = r.CheckBreak()
	}
	if yyb838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.X509 = KubeletX509Authentication{}
	} else {
		yyv839 := &x.X509
		yyv839.CodecDecodeSelf(d)
	}
	yyj838++
	if yyhl838 {
		yyb838 = yyj838 > l
	} else {
		yyb838 = r.CheckBreak()
	}
	if yyb838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Webhook = KubeletWebhookAuthentication{}
	} else {
		yyv840 := &x.Webhook
		yyv840.CodecDecodeSelf(d)
	}
	yyj838++
	if yyhl838 {
		yyb838 = yyj838 > l
	} else {
		yyb838 = r.CheckBreak()
	}
	if yyb838 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Anonymous = KubeletAnonymousAuthentication{}
	} else {
		yyv841 := &x.Anonymous
		yyv841.CodecDecodeSelf(d)
	}
	for {
		yyj838++
		if yyhl838 {
			yyb838 = yyj838 > l
		} else {
			yyb838 = r.CheckBreak()
		}
		if yyb838 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj838-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletX509Authentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym842 := z.EncBinary()
		_ = yym842
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep843 := !z.EncBinary()
			yy2arr843 := z.EncBasicHandle().StructToArray
			var yyq843 [1]bool
			_, _, _ = yysep843, yyq843, yy2arr843
			const yyr843 bool = false
			var yynn843 int
			if yyr843 || yy2arr843 {
				r.EncodeArrayStart(1)
			} else {
				yynn843 = 1
				for _, b := range yyq843 {
					if b {
						yynn843++
					}
				}
				r.EncodeMapStart(yynn843)
				yynn843 = 0
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym845 := z.EncBinary()
				_ = yym845
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clientCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym846 := z.EncBinary()
				_ = yym846
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClientCAFile))
				}
			}
			if yyr843 || yy2arr843 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletX509Authentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym847 := z.DecBinary()
	_ = yym847
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct848 := r.ContainerType()
		if yyct848 == codecSelferValueTypeMap1234 {
			yyl848 := r.ReadMapStart()
			if yyl848 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl848, d)
			}
		} else if yyct848 == codecSelferValueTypeArray1234 {
			yyl848 := r.ReadArrayStart()
			if yyl848 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl848, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletX509Authentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys849Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys849Slc
	var yyhl849 bool = l >= 0
	for yyj849 := 0; ; yyj849++ {
		if yyhl849 {
			if yyj849 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys849Slc = r.DecodeBytes(yys849Slc, true, true)
		yys849 := string(yys849Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys849 {
		case "clientCAFile":
			if r.TryDecodeAsNil() {
				x.ClientCAFile = ""
			} else {
				x.ClientCAFile = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys849)
		} // end switch yys849
	} // end for yyj849
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletX509Authentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj851 int
	var yyb851 bool
	var yyhl851 bool = l >= 0
	yyj851++
	if yyhl851 {
		yyb851 = yyj851 > l
	} else {
		yyb851 = r.CheckBreak()
	}
	if yyb851 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClientCAFile = ""
	} else {
		x.ClientCAFile = string(r.DecodeString())
	}
	for {
		yyj851++
		if yyhl851 {
			yyb851 = yyj851 > l
		} else {
			yyb851 = r.CheckBreak()
		}
		if yyb851 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj851-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletWebhookAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym853 := z.EncBinary()
		_ = yym853
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep854 := !z.EncBinary()
			yy2arr854 := z.EncBasicHandle().StructToArray
			var yyq854 [2]bool
			_, _, _ = yysep854, yyq854, yy2arr854
			const yyr854 bool = false
			var yynn854 int
			if yyr854 || yy2arr854 {
				r.EncodeArrayStart(2)
			} else {
				yynn854 = 2
				for _, b := range yyq854 {
					if b {
						yynn854++
					}
				}
				r.EncodeMapStart(yynn854)
				yynn854 = 0
			}
			if yyr854 || yy2arr854 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym856 := z.EncBinary()
				_ = yym856
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym857 := z.EncBinary()
				_ = yym857
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr854 || yy2arr854 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy859 := &x.CacheTTL
				yym860 := z.EncBinary()
				_ = yym860
				if false {
				} else if z.HasExtensions() && z.EncExt(yy859) {
				} else if !yym860 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy859)
				} else {
					z.EncFallback(yy859)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cacheTTL"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy861 := &x.CacheTTL
				yym862 := z.EncBinary()
				_ = yym862
				if false {
				} else if z.HasExtensions() && z.EncExt(yy861) {
				} else if !yym862 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy861)
				} else {
					z.EncFallback(yy861)
				}
			}
			if yyr854 || yy2arr854 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletWebhookAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym863 := z.DecBinary()
	_ = yym863
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct864 := r.ContainerType()
		if yyct864 == codecSelferValueTypeMap1234 {
			yyl864 := r.ReadMapStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl864, d)
			}
		} else if yyct864 == codecSelferValueTypeArray1234 {
			yyl864 := r.ReadArrayStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl864, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys865Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys865Slc
	var yyhl865 bool = l >= 0
	for yyj865 := 0; ; yyj865++ {
		if yyhl865 {
			if yyj865 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys865Slc = r.DecodeBytes(yys865Slc, true, true)
		yys865 := string(yys865Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys865 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		case "cacheTTL":
			if r.TryDecodeAsNil() {
				x.CacheTTL = pkg1_unversioned.Duration{}
			} else {
				yyv867 := &x.CacheTTL
				yym868 := z.DecBinary()
				_ = yym868
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv867) {
				} else if !yym868 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv867)
				} else {
					z.DecFallback(yyv867, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys865)
		} // end switch yys865
	} // end for yyj865
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletWebhookAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj869 int
	var yyb869 bool
	var yyhl869 bool = l >= 0
	yyj869++
	if yyhl869 {
		yyb869 = yyj869 > l
	} else {
		yyb869 = r.CheckBreak()
	}
	if yyb869 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	yyj869++
	if yyhl869 {
		yyb869 = yyj869 > l
	} else {
		yyb869 = r.CheckBreak()
	}
	if yyb869 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CacheTTL = pkg1_unversioned.Duration{}
	} else {
		yyv871 := &x.CacheTTL
		yym872 := z.DecBinary()
		_ = yym872
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv871) {
		} else if !yym872 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv871)
		} else {
			z.DecFallback(yyv871, false)
		}
	}
	for {
		yyj869++
		if yyhl869 {
			yyb869 = yyj869 > l
		} else {
			yyb869 = r.CheckBreak()
		}
		if yyb869 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj869-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeletAnonymousAuthentication) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym873 := z.EncBinary()
		_ = yym873
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep874 := !z.EncBinary()
			yy2arr874 := z.EncBasicHandle().StructToArray
			var yyq874 [1]bool
			_, _, _ = yysep874, yyq874, yy2arr874
			const yyr874 bool = false
			var yynn874 int
			if yyr874 || yy2arr874 {
				r.EncodeArrayStart(1)
			} else {
				yynn874 = 1
				for _, b := range yyq874 {
					if b {
						yynn874++
					}
				}
				r.EncodeMapStart(yynn874)
				yynn874 = 0
			}
			if yyr874 || yy2arr874 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym876 := z.EncBinary()
				_ = yym876
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enabled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym877 := z.EncBinary()
				_ = yym877
				if false {
				} else {
					r.EncodeBool(bool(x.Enabled))
				}
			}
			if yyr874 || yy2arr874 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeletAnonymousAuthentication) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym878 := z.DecBinary()
	_ = yym878
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct879 := r.ContainerType()
		if yyct879 == codecSelferValueTypeMap1234 {
			yyl879 := r.ReadMapStart()
			if yyl879 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl879, d)
			}
		} else if yyct879 == codecSelferValueTypeArray1234 {
			yyl879 := r.ReadArrayStart()
			if yyl879 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl879, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys880Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys880Slc
	var yyhl880 bool = l >= 0
	for yyj880 := 0; ; yyj880++ {
		if yyhl880 {
			if yyj880 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys880Slc = r.DecodeBytes(yys880Slc, true, true)
		yys880 := string(yys880Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys880 {
		case "enabled":
			if r.TryDecodeAsNil() {
				x.Enabled = false
			} else {
				x.Enabled = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys880)
		} // end switch yys880
	} // end for yyj880
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeletAnonymousAuthentication) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj882 int
	var yyb882 bool
	var yyhl882 bool = l >= 0
	yyj882++
	if yyhl882 {
		yyb882 = yyj882 > l
	} else {
		yyb882 = r.CheckBreak()
	}
	if yyb882 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Enabled = false
	} else {
		x.Enabled = bool(r.DecodeBool())
	}
	for {
		yyj882++
		if yyhl882 {
			yyb882 = yyj882 > l
		} else {
			yyb882 = r.CheckBreak()
		}
		if yyb882 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj882-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeSchedulerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym884 := z.EncBinary()
		_ = yym884
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep885 := !z.EncBinary()
			yy2arr885 := z.EncBasicHandle().StructToArray
			var yyq885 [14]bool
			_, _, _ = yysep885, yyq885, yy2arr885
			const yyr885 bool = false
			yyq885[0] = x.Kind != ""
			yyq885[1] = x.APIVersion != ""
			var yynn885 int
			if yyr885 || yy2arr885 {
				r.EncodeArrayStart(14)
			} else {
				yynn885 = 12
				for _, b := range yyq885 {
					if b {
						yynn885++
					}
				}
				r.EncodeMapStart(yynn885)
				yynn885 = 0
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq885[0] {
					yym887 := z.EncBinary()
					_ = yym887
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq885[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym888 := z.EncBinary()
					_ = yym888
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq885[1] {
					yym890 := z.EncBinary()
					_ = yym890
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq885[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym891 := z.EncBinary()
					_ = yym891
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym893 := z.EncBinary()
				_ = yym893
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym894 := z.EncBinary()
				_ = yym894
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym896 := z.EncBinary()
				_ = yym896
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym897 := z.EncBinary()
				_ = yym897
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym899 := z.EncBinary()
				_ = yym899
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("algorithmProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym900 := z.EncBinary()
				_ = yym900
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.AlgorithmProvider))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym902 := z.EncBinary()
				_ = yym902
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("policyConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym903 := z.EncBinary()
				_ = yym903
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PolicyConfigFile))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym905 := z.EncBinary()
				_ = yym905
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym906 := z.EncBinary()
				_ = yym906
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym908 := z.EncBinary()
				_ = yym908
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym909 := z.EncBinary()
				_ = yym909
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym911 := z.EncBinary()
				_ = yym911
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym912 := z.EncBinary()
				_ = yym912
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym914 := z.EncBinary()
				_ = yym914
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym915 := z.EncBinary()
				_ = yym915
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym917 := z.EncBinary()
				_ = yym917
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym918 := z.EncBinary()
				_ = yym918
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym920 := z.EncBinary()
				_ = yym920
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("hardPodAffinitySymmetricWeight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym921 := z.EncBinary()
				_ = yym921
				if false {
				} else {
					r.EncodeInt(int64(x.HardPodAffinitySymmetricWeight))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym923 := z.EncBinary()
				_ = yym923
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("failureDomains"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym924 := z.EncBinary()
				_ = yym924
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FailureDomains))
				}
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy926 := &x.LeaderElection
				yy926.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy927 := &x.LeaderElection
				yy927.CodecEncodeSelf(e)
			}
			if yyr885 || yy2arr885 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeSchedulerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym928 := z.DecBinary()
	_ = yym928
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct929 := r.ContainerType()
		if yyct929 == codecSelferValueTypeMap1234 {
			yyl929 := r.ReadMapStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl929, d)
			}
		} else if yyct929 == codecSelferValueTypeArray1234 {
			yyl929 := r.ReadArrayStart()
			if yyl929 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl929, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys930Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys930Slc
	var yyhl930 bool = l >= 0
	for yyj930 := 0; ; yyj930++ {
		if yyhl930 {
			if yyj930 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys930Slc = r.DecodeBytes(yys930Slc, true, true)
		yys930 := string(yys930Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys930 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "algorithmProvider":
			if r.TryDecodeAsNil() {
				x.AlgorithmProvider = ""
			} else {
				x.AlgorithmProvider = string(r.DecodeString())
			}
		case "policyConfigFile":
			if r.TryDecodeAsNil() {
				x.PolicyConfigFile = ""
			} else {
				x.PolicyConfigFile = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				x.SchedulerName = string(r.DecodeString())
			}
		case "hardPodAffinitySymmetricWeight":
			if r.TryDecodeAsNil() {
				x.HardPodAffinitySymmetricWeight = 0
			} else {
				x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "failureDomains":
			if r.TryDecodeAsNil() {
				x.FailureDomains = ""
			} else {
				x.FailureDomains = string(r.DecodeString())
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv944 := &x.LeaderElection
				yyv944.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys930)
		} // end switch yys930
	} // end for yyj930
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeSchedulerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj945 int
	var yyb945 bool
	var yyhl945 bool = l >= 0
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AlgorithmProvider = ""
	} else {
		x.AlgorithmProvider = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PolicyConfigFile = ""
	} else {
		x.PolicyConfigFile = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		x.SchedulerName = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HardPodAffinitySymmetricWeight = 0
	} else {
		x.HardPodAffinitySymmetricWeight = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureDomains = ""
	} else {
		x.FailureDomains = string(r.DecodeString())
	}
	yyj945++
	if yyhl945 {
		yyb945 = yyj945 > l
	} else {
		yyb945 = r.CheckBreak()
	}
	if yyb945 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv959 := &x.LeaderElection
		yyv959.CodecDecodeSelf(d)
	}
	for {
		yyj945++
		if yyhl945 {
			yyb945 = yyj945 > l
		} else {
			yyb945 = r.CheckBreak()
		}
		if yyb945 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj945-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LeaderElectionConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym960 := z.EncBinary()
		_ = yym960
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep961 := !z.EncBinary()
			yy2arr961 := z.EncBasicHandle().StructToArray
			var yyq961 [4]bool
			_, _, _ = yysep961, yyq961, yy2arr961
			const yyr961 bool = false
			var yynn961 int
			if yyr961 || yy2arr961 {
				r.EncodeArrayStart(4)
			} else {
				yynn961 = 4
				for _, b := range yyq961 {
					if b {
						yynn961++
					}
				}
				r.EncodeMapStart(yynn961)
				yynn961 = 0
			}
			if yyr961 || yy2arr961 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym963 := z.EncBinary()
				_ = yym963
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym964 := z.EncBinary()
				_ = yym964
				if false {
				} else {
					r.EncodeBool(bool(x.LeaderElect))
				}
			}
			if yyr961 || yy2arr961 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy966 := &x.LeaseDuration
				yym967 := z.EncBinary()
				_ = yym967
				if false {
				} else if z.HasExtensions() && z.EncExt(yy966) {
				} else if !yym967 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy966)
				} else {
					z.EncFallback(yy966)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaseDuration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy968 := &x.LeaseDuration
				yym969 := z.EncBinary()
				_ = yym969
				if false {
				} else if z.HasExtensions() && z.EncExt(yy968) {
				} else if !yym969 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy968)
				} else {
					z.EncFallback(yy968)
				}
			}
			if yyr961 || yy2arr961 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy971 := &x.RenewDeadline
				yym972 := z.EncBinary()
				_ = yym972
				if false {
				} else if z.HasExtensions() && z.EncExt(yy971) {
				} else if !yym972 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy971)
				} else {
					z.EncFallback(yy971)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("renewDeadline"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy973 := &x.RenewDeadline
				yym974 := z.EncBinary()
				_ = yym974
				if false {
				} else if z.HasExtensions() && z.EncExt(yy973) {
				} else if !yym974 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy973)
				} else {
					z.EncFallback(yy973)
				}
			}
			if yyr961 || yy2arr961 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy976 := &x.RetryPeriod
				yym977 := z.EncBinary()
				_ = yym977
				if false {
				} else if z.HasExtensions() && z.EncExt(yy976) {
				} else if !yym977 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy976)
				} else {
					z.EncFallback(yy976)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("retryPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy978 := &x.RetryPeriod
				yym979 := z.EncBinary()
				_ = yym979
				if false {
				} else if z.HasExtensions() && z.EncExt(yy978) {
				} else if !yym979 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy978)
				} else {
					z.EncFallback(yy978)
				}
			}
			if yyr961 || yy2arr961 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LeaderElectionConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym980 := z.DecBinary()
	_ = yym980
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct981 := r.ContainerType()
		if yyct981 == codecSelferValueTypeMap1234 {
			yyl981 := r.ReadMapStart()
			if yyl981 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl981, d)
			}
		} else if yyct981 == codecSelferValueTypeArray1234 {
			yyl981 := r.ReadArrayStart()
			if yyl981 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl981, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys982Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys982Slc
	var yyhl982 bool = l >= 0
	for yyj982 := 0; ; yyj982++ {
		if yyhl982 {
			if yyj982 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys982Slc = r.DecodeBytes(yys982Slc, true, true)
		yys982 := string(yys982Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys982 {
		case "leaderElect":
			if r.TryDecodeAsNil() {
				x.LeaderElect = false
			} else {
				x.LeaderElect = bool(r.DecodeBool())
			}
		case "leaseDuration":
			if r.TryDecodeAsNil() {
				x.LeaseDuration = pkg1_unversioned.Duration{}
			} else {
				yyv984 := &x.LeaseDuration
				yym985 := z.DecBinary()
				_ = yym985
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv984) {
				} else if !yym985 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv984)
				} else {
					z.DecFallback(yyv984, false)
				}
			}
		case "renewDeadline":
			if r.TryDecodeAsNil() {
				x.RenewDeadline = pkg1_unversioned.Duration{}
			} else {
				yyv986 := &x.RenewDeadline
				yym987 := z.DecBinary()
				_ = yym987
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv986) {
				} else if !yym987 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv986)
				} else {
					z.DecFallback(yyv986, false)
				}
			}
		case "retryPeriod":
			if r.TryDecodeAsNil() {
				x.RetryPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv988 := &x.RetryPeriod
				yym989 := z.DecBinary()
				_ = yym989
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv988) {
				} else if !yym989 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv988)
				} else {
					z.DecFallback(yyv988, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys982)
		} // end switch yys982
	} // end for yyj982
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LeaderElectionConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj990 int
	var yyb990 bool
	var yyhl990 bool = l >= 0
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElect = false
	} else {
		x.LeaderElect = bool(r.DecodeBool())
	}
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaseDuration = pkg1_unversioned.Duration{}
	} else {
		yyv992 := &x.LeaseDuration
		yym993 := z.DecBinary()
		_ = yym993
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv992) {
		} else if !yym993 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv992)
		} else {
			z.DecFallback(yyv992, false)
		}
	}
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RenewDeadline = pkg1_unversioned.Duration{}
	} else {
		yyv994 := &x.RenewDeadline
		yym995 := z.DecBinary()
		_ = yym995
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv994) {
		} else if !yym995 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv994)
		} else {
			z.DecFallback(yyv994, false)
		}
	}
	yyj990++
	if yyhl990 {
		yyb990 = yyj990 > l
	} else {
		yyb990 = r.CheckBreak()
	}
	if yyb990 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RetryPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv996 := &x.RetryPeriod
		yym997 := z.DecBinary()
		_ = yym997
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv996) {
		} else if !yym997 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv996)
		} else {
			z.DecFallback(yyv996, false)
		}
	}
	for {
		yyj990++
		if yyhl990 {
			yyb990 = yyj990 > l
		} else {
			yyb990 = r.CheckBreak()
		}
		if yyb990 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj990-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KubeControllerManagerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym998 := z.EncBinary()
		_ = yym998
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep999 := !z.EncBinary()
			yy2arr999 := z.EncBasicHandle().StructToArray
			var yyq999 [61]bool
			_, _, _ = yysep999, yyq999, yy2arr999
			const yyr999 bool = false
			yyq999[0] = x.Kind != ""
			yyq999[1] = x.APIVersion != ""
			var yynn999 int
			if yyr999 || yy2arr999 {
				r.EncodeArrayStart(61)
			} else {
				yynn999 = 59
				for _, b := range yyq999 {
					if b {
						yynn999++
					}
				}
				r.EncodeMapStart(yynn999)
				yynn999 = 0
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq999[0] {
					yym1001 := z.EncBinary()
					_ = yym1001
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq999[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1002 := z.EncBinary()
					_ = yym1002
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq999[1] {
					yym1004 := z.EncBinary()
					_ = yym1004
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq999[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1005 := z.EncBinary()
					_ = yym1005
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1007 := z.EncBinary()
				_ = yym1007
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1008 := z.EncBinary()
				_ = yym1008
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1010 := z.EncBinary()
				_ = yym1010
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("address"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1011 := z.EncBinary()
				_ = yym1011
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Address))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1013 := z.EncBinary()
				_ = yym1013
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("useServiceAccountCredentials"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1014 := z.EncBinary()
				_ = yym1014
				if false {
				} else {
					r.EncodeBool(bool(x.UseServiceAccountCredentials))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1016 := z.EncBinary()
				_ = yym1016
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudProvider"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1017 := z.EncBinary()
				_ = yym1017
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudProvider))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1019 := z.EncBinary()
				_ = yym1019
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("cloudConfigFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1020 := z.EncBinary()
				_ = yym1020
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.CloudConfigFile))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1022 := z.EncBinary()
				_ = yym1022
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentEndpointSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1023 := z.EncBinary()
				_ = yym1023
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentEndpointSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1025 := z.EncBinary()
				_ = yym1025
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRSSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1026 := z.EncBinary()
				_ = yym1026
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRSSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1028 := z.EncBinary()
				_ = yym1028
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentRCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1029 := z.EncBinary()
				_ = yym1029
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentRCSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1031 := z.EncBinary()
				_ = yym1031
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentServiceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1032 := z.EncBinary()
				_ = yym1032
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentServiceSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1034 := z.EncBinary()
				_ = yym1034
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentResourceQuotaSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1035 := z.EncBinary()
				_ = yym1035
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentResourceQuotaSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1037 := z.EncBinary()
				_ = yym1037
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDeploymentSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1038 := z.EncBinary()
				_ = yym1038
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDeploymentSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1040 := z.EncBinary()
				_ = yym1040
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentDaemonSetSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1041 := z.EncBinary()
				_ = yym1041
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentDaemonSetSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentJobSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1044 := z.EncBinary()
				_ = yym1044
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentJobSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1046 := z.EncBinary()
				_ = yym1046
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentNamespaceSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1047 := z.EncBinary()
				_ = yym1047
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentNamespaceSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1049 := z.EncBinary()
				_ = yym1049
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentSATokenSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1050 := z.EncBinary()
				_ = yym1050
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentSATokenSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1052 := z.EncBinary()
				_ = yym1052
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRC"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1053 := z.EncBinary()
				_ = yym1053
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRC))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1055 := z.EncBinary()
				_ = yym1055
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForRS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1056 := z.EncBinary()
				_ = yym1056
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForRS))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1058 := z.EncBinary()
				_ = yym1058
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lookupCacheSizeForDaemonSet"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1059 := z.EncBinary()
				_ = yym1059
				if false {
				} else {
					r.EncodeInt(int64(x.LookupCacheSizeForDaemonSet))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1061 := &x.ServiceSyncPeriod
				yym1062 := z.EncBinary()
				_ = yym1062
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1061) {
				} else if !yym1062 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1061)
				} else {
					z.EncFallback(yy1061)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1063 := &x.ServiceSyncPeriod
				yym1064 := z.EncBinary()
				_ = yym1064
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1063) {
				} else if !yym1064 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1063)
				} else {
					z.EncFallback(yy1063)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1066 := &x.NodeSyncPeriod
				yym1067 := z.EncBinary()
				_ = yym1067
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1066) {
				} else if !yym1067 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1066)
				} else {
					z.EncFallback(yy1066)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1068 := &x.NodeSyncPeriod
				yym1069 := z.EncBinary()
				_ = yym1069
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1068) {
				} else if !yym1069 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1068)
				} else {
					z.EncFallback(yy1068)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1071 := &x.RouteReconciliationPeriod
				yym1072 := z.EncBinary()
				_ = yym1072
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1071) {
				} else if !yym1072 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1071)
				} else {
					z.EncFallback(yy1071)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("routeReconciliationPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1073 := &x.RouteReconciliationPeriod
				yym1074 := z.EncBinary()
				_ = yym1074
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1073) {
				} else if !yym1074 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1073)
				} else {
					z.EncFallback(yy1073)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1076 := &x.ResourceQuotaSyncPeriod
				yym1077 := z.EncBinary()
				_ = yym1077
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1076) {
				} else if !yym1077 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1076)
				} else {
					z.EncFallback(yy1076)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resourceQuotaSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1078 := &x.ResourceQuotaSyncPeriod
				yym1079 := z.EncBinary()
				_ = yym1079
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1078) {
				} else if !yym1079 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1078)
				} else {
					z.EncFallback(yy1078)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1081 := &x.NamespaceSyncPeriod
				yym1082 := z.EncBinary()
				_ = yym1082
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1081) {
				} else if !yym1082 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1081)
				} else {
					z.EncFallback(yy1081)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaceSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1083 := &x.NamespaceSyncPeriod
				yym1084 := z.EncBinary()
				_ = yym1084
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1083) {
				} else if !yym1084 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1083)
				} else {
					z.EncFallback(yy1083)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1086 := &x.PVClaimBinderSyncPeriod
				yym1087 := z.EncBinary()
				_ = yym1087
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1086) {
				} else if !yym1087 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1086)
				} else {
					z.EncFallback(yy1086)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pvClaimBinderSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1088 := &x.PVClaimBinderSyncPeriod
				yym1089 := z.EncBinary()
				_ = yym1089
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1088) {
				} else if !yym1089 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1088)
				} else {
					z.EncFallback(yy1088)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1091 := &x.MinResyncPeriod
				yym1092 := z.EncBinary()
				_ = yym1092
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1091) {
				} else if !yym1092 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1091)
				} else {
					z.EncFallback(yy1091)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minResyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1093 := &x.MinResyncPeriod
				yym1094 := z.EncBinary()
				_ = yym1094
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1093) {
				} else if !yym1094 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1093)
				} else {
					z.EncFallback(yy1093)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1096 := z.EncBinary()
				_ = yym1096
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("terminatedPodGCThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1097 := z.EncBinary()
				_ = yym1097
				if false {
				} else {
					r.EncodeInt(int64(x.TerminatedPodGCThreshold))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1099 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1100 := z.EncBinary()
				_ = yym1100
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1099) {
				} else if !yym1100 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1099)
				} else {
					z.EncFallback(yy1099)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("horizontalPodAutoscalerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1101 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1102 := z.EncBinary()
				_ = yym1102
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1101) {
				} else if !yym1102 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1101)
				} else {
					z.EncFallback(yy1101)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1104 := &x.DeploymentControllerSyncPeriod
				yym1105 := z.EncBinary()
				_ = yym1105
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1104) {
				} else if !yym1105 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1104)
				} else {
					z.EncFallback(yy1104)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deploymentControllerSyncPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1106 := &x.DeploymentControllerSyncPeriod
				yym1107 := z.EncBinary()
				_ = yym1107
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1106) {
				} else if !yym1107 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1106)
				} else {
					z.EncFallback(yy1106)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1109 := &x.PodEvictionTimeout
				yym1110 := z.EncBinary()
				_ = yym1110
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1109) {
				} else if !yym1110 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1109)
				} else {
					z.EncFallback(yy1109)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podEvictionTimeout"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1111 := &x.PodEvictionTimeout
				yym1112 := z.EncBinary()
				_ = yym1112
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1111) {
				} else if !yym1112 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1111)
				} else {
					z.EncFallback(yy1111)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1114 := z.EncBinary()
				_ = yym1114
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsQps"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1115 := z.EncBinary()
				_ = yym1115
				if false {
				} else {
					r.EncodeFloat32(float32(x.DeletingPodsQps))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1117 := z.EncBinary()
				_ = yym1117
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("deletingPodsBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1118 := z.EncBinary()
				_ = yym1118
				if false {
				} else {
					r.EncodeInt(int64(x.DeletingPodsBurst))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1120 := &x.NodeMonitorGracePeriod
				yym1121 := z.EncBinary()
				_ = yym1121
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1120) {
				} else if !yym1121 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1120)
				} else {
					z.EncFallback(yy1120)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1122 := &x.NodeMonitorGracePeriod
				yym1123 := z.EncBinary()
				_ = yym1123
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1122) {
				} else if !yym1123 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1122)
				} else {
					z.EncFallback(yy1122)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1125 := z.EncBinary()
				_ = yym1125
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registerRetryCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1126 := z.EncBinary()
				_ = yym1126
				if false {
				} else {
					r.EncodeInt(int64(x.RegisterRetryCount))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1128 := &x.NodeStartupGracePeriod
				yym1129 := z.EncBinary()
				_ = yym1129
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1128) {
				} else if !yym1129 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1128)
				} else {
					z.EncFallback(yy1128)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeStartupGracePeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1130 := &x.NodeStartupGracePeriod
				yym1131 := z.EncBinary()
				_ = yym1131
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1130) {
				} else if !yym1131 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1130)
				} else {
					z.EncFallback(yy1130)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1133 := &x.NodeMonitorPeriod
				yym1134 := z.EncBinary()
				_ = yym1134
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1133) {
				} else if !yym1134 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1133)
				} else {
					z.EncFallback(yy1133)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeMonitorPeriod"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1135 := &x.NodeMonitorPeriod
				yym1136 := z.EncBinary()
				_ = yym1136
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1135) {
				} else if !yym1136 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1135)
				} else {
					z.EncFallback(yy1135)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1138 := z.EncBinary()
				_ = yym1138
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1139 := z.EncBinary()
				_ = yym1139
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountKeyFile))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1141 := z.EncBinary()
				_ = yym1141
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningCertFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1142 := z.EncBinary()
				_ = yym1142
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningCertFile))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1144 := z.EncBinary()
				_ = yym1144
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterSigningKeyFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1145 := z.EncBinary()
				_ = yym1145
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterSigningKeyFile))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1147 := z.EncBinary()
				_ = yym1147
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("approveAllKubeletCSRsForGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1148 := z.EncBinary()
				_ = yym1148
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ApproveAllKubeletCSRsForGroup))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1150 := z.EncBinary()
				_ = yym1150
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableProfiling"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1151 := z.EncBinary()
				_ = yym1151
				if false {
				} else {
					r.EncodeBool(bool(x.EnableProfiling))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1153 := z.EncBinary()
				_ = yym1153
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1154 := z.EncBinary()
				_ = yym1154
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1156 := z.EncBinary()
				_ = yym1156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("clusterCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1157 := z.EncBinary()
				_ = yym1157
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClusterCIDR))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1159 := z.EncBinary()
				_ = yym1159
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceCIDR"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1160 := z.EncBinary()
				_ = yym1160
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceCIDR))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1162 := z.EncBinary()
				_ = yym1162
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeCIDRMaskSize"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1163 := z.EncBinary()
				_ = yym1163
				if false {
				} else {
					r.EncodeInt(int64(x.NodeCIDRMaskSize))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1165 := z.EncBinary()
				_ = yym1165
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("allocateNodeCIDRs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1166 := z.EncBinary()
				_ = yym1166
				if false {
				} else {
					r.EncodeBool(bool(x.AllocateNodeCIDRs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1168 := z.EncBinary()
				_ = yym1168
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("configureCloudRoutes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1169 := z.EncBinary()
				_ = yym1169
				if false {
				} else {
					r.EncodeBool(bool(x.ConfigureCloudRoutes))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1171 := z.EncBinary()
				_ = yym1171
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rootCAFile"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1172 := z.EncBinary()
				_ = yym1172
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RootCAFile))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1174 := z.EncBinary()
				_ = yym1174
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("contentType"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1175 := z.EncBinary()
				_ = yym1175
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContentType))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1177 := z.EncBinary()
				_ = yym1177
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIQPS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1178 := z.EncBinary()
				_ = yym1178
				if false {
				} else {
					r.EncodeFloat32(float32(x.KubeAPIQPS))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1180 := z.EncBinary()
				_ = yym1180
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeAPIBurst"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1181 := z.EncBinary()
				_ = yym1181
				if false {
				} else {
					r.EncodeInt(int64(x.KubeAPIBurst))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1183 := &x.LeaderElection
				yy1183.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("leaderElection"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1184 := &x.LeaderElection
				yy1184.CodecEncodeSelf(e)
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1186 := &x.VolumeConfiguration
				yy1186.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1187 := &x.VolumeConfiguration
				yy1187.CodecEncodeSelf(e)
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1189 := &x.ControllerStartInterval
				yym1190 := z.EncBinary()
				_ = yym1190
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1189) {
				} else if !yym1190 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1189)
				} else {
					z.EncFallback(yy1189)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("controllerStartInterval"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1191 := &x.ControllerStartInterval
				yym1192 := z.EncBinary()
				_ = yym1192
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1191) {
				} else if !yym1192 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1191)
				} else {
					z.EncFallback(yy1191)
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1194 := z.EncBinary()
				_ = yym1194
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableGarbageCollector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1195 := z.EncBinary()
				_ = yym1195
				if false {
				} else {
					r.EncodeBool(bool(x.EnableGarbageCollector))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1197 := z.EncBinary()
				_ = yym1197
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("concurrentGCSyncs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1198 := z.EncBinary()
				_ = yym1198
				if false {
				} else {
					r.EncodeInt(int64(x.ConcurrentGCSyncs))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1200 := z.EncBinary()
				_ = yym1200
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1201 := z.EncBinary()
				_ = yym1201
				if false {
				} else {
					r.EncodeFloat32(float32(x.NodeEvictionRate))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1203 := z.EncBinary()
				_ = yym1203
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secondaryNodeEvictionRate"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1204 := z.EncBinary()
				_ = yym1204
				if false {
				} else {
					r.EncodeFloat32(float32(x.SecondaryNodeEvictionRate))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1206 := z.EncBinary()
				_ = yym1206
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("largeClusterSizeThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1207 := z.EncBinary()
				_ = yym1207
				if false {
				} else {
					r.EncodeInt(int64(x.LargeClusterSizeThreshold))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1209 := z.EncBinary()
				_ = yym1209
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("unhealthyZoneThreshold"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1210 := z.EncBinary()
				_ = yym1210
				if false {
				} else {
					r.EncodeFloat32(float32(x.UnhealthyZoneThreshold))
				}
			}
			if yyr999 || yy2arr999 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KubeControllerManagerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1211 := z.DecBinary()
	_ = yym1211
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1212 := r.ContainerType()
		if yyct1212 == codecSelferValueTypeMap1234 {
			yyl1212 := r.ReadMapStart()
			if yyl1212 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1212, d)
			}
		} else if yyct1212 == codecSelferValueTypeArray1234 {
			yyl1212 := r.ReadArrayStart()
			if yyl1212 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1212, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1213Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1213Slc
	var yyhl1213 bool = l >= 0
	for yyj1213 := 0; ; yyj1213++ {
		if yyhl1213 {
			if yyj1213 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1213Slc = r.DecodeBytes(yys1213Slc, true, true)
		yys1213 := string(yys1213Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1213 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "address":
			if r.TryDecodeAsNil() {
				x.Address = ""
			} else {
				x.Address = string(r.DecodeString())
			}
		case "useServiceAccountCredentials":
			if r.TryDecodeAsNil() {
				x.UseServiceAccountCredentials = false
			} else {
				x.UseServiceAccountCredentials = bool(r.DecodeBool())
			}
		case "cloudProvider":
			if r.TryDecodeAsNil() {
				x.CloudProvider = ""
			} else {
				x.CloudProvider = string(r.DecodeString())
			}
		case "cloudConfigFile":
			if r.TryDecodeAsNil() {
				x.CloudConfigFile = ""
			} else {
				x.CloudConfigFile = string(r.DecodeString())
			}
		case "concurrentEndpointSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentEndpointSyncs = 0
			} else {
				x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRSSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRSSyncs = 0
			} else {
				x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentRCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentRCSyncs = 0
			} else {
				x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentServiceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentServiceSyncs = 0
			} else {
				x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentResourceQuotaSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentResourceQuotaSyncs = 0
			} else {
				x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDeploymentSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDeploymentSyncs = 0
			} else {
				x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentDaemonSetSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentDaemonSetSyncs = 0
			} else {
				x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentJobSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentJobSyncs = 0
			} else {
				x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentNamespaceSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentNamespaceSyncs = 0
			} else {
				x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
			}
		case "concurrentSATokenSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentSATokenSyncs = 0
			} else {
				x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRC":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRC = 0
			} else {
				x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForRS":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForRS = 0
			} else {
				x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
			}
		case "lookupCacheSizeForDaemonSet":
			if r.TryDecodeAsNil() {
				x.LookupCacheSizeForDaemonSet = 0
			} else {
				x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
			}
		case "serviceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1234 := &x.ServiceSyncPeriod
				yym1235 := z.DecBinary()
				_ = yym1235
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1234) {
				} else if !yym1235 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1234)
				} else {
					z.DecFallback(yyv1234, false)
				}
			}
		case "nodeSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NodeSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1236 := &x.NodeSyncPeriod
				yym1237 := z.DecBinary()
				_ = yym1237
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1236) {
				} else if !yym1237 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1236)
				} else {
					z.DecFallback(yyv1236, false)
				}
			}
		case "routeReconciliationPeriod":
			if r.TryDecodeAsNil() {
				x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1238 := &x.RouteReconciliationPeriod
				yym1239 := z.DecBinary()
				_ = yym1239
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1238) {
				} else if !yym1239 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1238)
				} else {
					z.DecFallback(yyv1238, false)
				}
			}
		case "resourceQuotaSyncPeriod":
			if r.TryDecodeAsNil() {
				x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1240 := &x.ResourceQuotaSyncPeriod
				yym1241 := z.DecBinary()
				_ = yym1241
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1240) {
				} else if !yym1241 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1240)
				} else {
					z.DecFallback(yyv1240, false)
				}
			}
		case "namespaceSyncPeriod":
			if r.TryDecodeAsNil() {
				x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1242 := &x.NamespaceSyncPeriod
				yym1243 := z.DecBinary()
				_ = yym1243
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1242) {
				} else if !yym1243 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1242)
				} else {
					z.DecFallback(yyv1242, false)
				}
			}
		case "pvClaimBinderSyncPeriod":
			if r.TryDecodeAsNil() {
				x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1244 := &x.PVClaimBinderSyncPeriod
				yym1245 := z.DecBinary()
				_ = yym1245
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1244) {
				} else if !yym1245 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1244)
				} else {
					z.DecFallback(yyv1244, false)
				}
			}
		case "minResyncPeriod":
			if r.TryDecodeAsNil() {
				x.MinResyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1246 := &x.MinResyncPeriod
				yym1247 := z.DecBinary()
				_ = yym1247
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1246) {
				} else if !yym1247 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1246)
				} else {
					z.DecFallback(yyv1246, false)
				}
			}
		case "terminatedPodGCThreshold":
			if r.TryDecodeAsNil() {
				x.TerminatedPodGCThreshold = 0
			} else {
				x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
			}
		case "horizontalPodAutoscalerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1249 := &x.HorizontalPodAutoscalerSyncPeriod
				yym1250 := z.DecBinary()
				_ = yym1250
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1249) {
				} else if !yym1250 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1249)
				} else {
					z.DecFallback(yyv1249, false)
				}
			}
		case "deploymentControllerSyncPeriod":
			if r.TryDecodeAsNil() {
				x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1251 := &x.DeploymentControllerSyncPeriod
				yym1252 := z.DecBinary()
				_ = yym1252
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1251) {
				} else if !yym1252 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1251)
				} else {
					z.DecFallback(yyv1251, false)
				}
			}
		case "podEvictionTimeout":
			if r.TryDecodeAsNil() {
				x.PodEvictionTimeout = pkg1_unversioned.Duration{}
			} else {
				yyv1253 := &x.PodEvictionTimeout
				yym1254 := z.DecBinary()
				_ = yym1254
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1253) {
				} else if !yym1254 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1253)
				} else {
					z.DecFallback(yyv1253, false)
				}
			}
		case "deletingPodsQps":
			if r.TryDecodeAsNil() {
				x.DeletingPodsQps = 0
			} else {
				x.DeletingPodsQps = float32(r.DecodeFloat(true))
			}
		case "deletingPodsBurst":
			if r.TryDecodeAsNil() {
				x.DeletingPodsBurst = 0
			} else {
				x.DeletingPodsBurst = int32(r.DecodeInt(32))
			}
		case "nodeMonitorGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1257 := &x.NodeMonitorGracePeriod
				yym1258 := z.DecBinary()
				_ = yym1258
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1257) {
				} else if !yym1258 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1257)
				} else {
					z.DecFallback(yyv1257, false)
				}
			}
		case "registerRetryCount":
			if r.TryDecodeAsNil() {
				x.RegisterRetryCount = 0
			} else {
				x.RegisterRetryCount = int32(r.DecodeInt(32))
			}
		case "nodeStartupGracePeriod":
			if r.TryDecodeAsNil() {
				x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1260 := &x.NodeStartupGracePeriod
				yym1261 := z.DecBinary()
				_ = yym1261
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1260) {
				} else if !yym1261 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1260)
				} else {
					z.DecFallback(yyv1260, false)
				}
			}
		case "nodeMonitorPeriod":
			if r.TryDecodeAsNil() {
				x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
			} else {
				yyv1262 := &x.NodeMonitorPeriod
				yym1263 := z.DecBinary()
				_ = yym1263
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1262) {
				} else if !yym1263 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1262)
				} else {
					z.DecFallback(yyv1262, false)
				}
			}
		case "serviceAccountKeyFile":
			if r.TryDecodeAsNil() {
				x.ServiceAccountKeyFile = ""
			} else {
				x.ServiceAccountKeyFile = string(r.DecodeString())
			}
		case "clusterSigningCertFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningCertFile = ""
			} else {
				x.ClusterSigningCertFile = string(r.DecodeString())
			}
		case "clusterSigningKeyFile":
			if r.TryDecodeAsNil() {
				x.ClusterSigningKeyFile = ""
			} else {
				x.ClusterSigningKeyFile = string(r.DecodeString())
			}
		case "approveAllKubeletCSRsForGroup":
			if r.TryDecodeAsNil() {
				x.ApproveAllKubeletCSRsForGroup = ""
			} else {
				x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
			}
		case "enableProfiling":
			if r.TryDecodeAsNil() {
				x.EnableProfiling = false
			} else {
				x.EnableProfiling = bool(r.DecodeBool())
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		case "clusterCIDR":
			if r.TryDecodeAsNil() {
				x.ClusterCIDR = ""
			} else {
				x.ClusterCIDR = string(r.DecodeString())
			}
		case "serviceCIDR":
			if r.TryDecodeAsNil() {
				x.ServiceCIDR = ""
			} else {
				x.ServiceCIDR = string(r.DecodeString())
			}
		case "nodeCIDRMaskSize":
			if r.TryDecodeAsNil() {
				x.NodeCIDRMaskSize = 0
			} else {
				x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
			}
		case "allocateNodeCIDRs":
			if r.TryDecodeAsNil() {
				x.AllocateNodeCIDRs = false
			} else {
				x.AllocateNodeCIDRs = bool(r.DecodeBool())
			}
		case "configureCloudRoutes":
			if r.TryDecodeAsNil() {
				x.ConfigureCloudRoutes = false
			} else {
				x.ConfigureCloudRoutes = bool(r.DecodeBool())
			}
		case "rootCAFile":
			if r.TryDecodeAsNil() {
				x.RootCAFile = ""
			} else {
				x.RootCAFile = string(r.DecodeString())
			}
		case "contentType":
			if r.TryDecodeAsNil() {
				x.ContentType = ""
			} else {
				x.ContentType = string(r.DecodeString())
			}
		case "kubeAPIQPS":
			if r.TryDecodeAsNil() {
				x.KubeAPIQPS = 0
			} else {
				x.KubeAPIQPS = float32(r.DecodeFloat(true))
			}
		case "kubeAPIBurst":
			if r.TryDecodeAsNil() {
				x.KubeAPIBurst = 0
			} else {
				x.KubeAPIBurst = int32(r.DecodeInt(32))
			}
		case "leaderElection":
			if r.TryDecodeAsNil() {
				x.LeaderElection = LeaderElectionConfiguration{}
			} else {
				yyv1279 := &x.LeaderElection
				yyv1279.CodecDecodeSelf(d)
			}
		case "volumeConfiguration":
			if r.TryDecodeAsNil() {
				x.VolumeConfiguration = VolumeConfiguration{}
			} else {
				yyv1280 := &x.VolumeConfiguration
				yyv1280.CodecDecodeSelf(d)
			}
		case "controllerStartInterval":
			if r.TryDecodeAsNil() {
				x.ControllerStartInterval = pkg1_unversioned.Duration{}
			} else {
				yyv1281 := &x.ControllerStartInterval
				yym1282 := z.DecBinary()
				_ = yym1282
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1281) {
				} else if !yym1282 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1281)
				} else {
					z.DecFallback(yyv1281, false)
				}
			}
		case "enableGarbageCollector":
			if r.TryDecodeAsNil() {
				x.EnableGarbageCollector = false
			} else {
				x.EnableGarbageCollector = bool(r.DecodeBool())
			}
		case "concurrentGCSyncs":
			if r.TryDecodeAsNil() {
				x.ConcurrentGCSyncs = 0
			} else {
				x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
			}
		case "nodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.NodeEvictionRate = 0
			} else {
				x.NodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "secondaryNodeEvictionRate":
			if r.TryDecodeAsNil() {
				x.SecondaryNodeEvictionRate = 0
			} else {
				x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
			}
		case "largeClusterSizeThreshold":
			if r.TryDecodeAsNil() {
				x.LargeClusterSizeThreshold = 0
			} else {
				x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
			}
		case "unhealthyZoneThreshold":
			if r.TryDecodeAsNil() {
				x.UnhealthyZoneThreshold = 0
			} else {
				x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1213)
		} // end switch yys1213
	} // end for yyj1213
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KubeControllerManagerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1289 int
	var yyb1289 bool
	var yyhl1289 bool = l >= 0
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Address = ""
	} else {
		x.Address = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UseServiceAccountCredentials = false
	} else {
		x.UseServiceAccountCredentials = bool(r.DecodeBool())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudProvider = ""
	} else {
		x.CloudProvider = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CloudConfigFile = ""
	} else {
		x.CloudConfigFile = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentEndpointSyncs = 0
	} else {
		x.ConcurrentEndpointSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRSSyncs = 0
	} else {
		x.ConcurrentRSSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentRCSyncs = 0
	} else {
		x.ConcurrentRCSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentServiceSyncs = 0
	} else {
		x.ConcurrentServiceSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentResourceQuotaSyncs = 0
	} else {
		x.ConcurrentResourceQuotaSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDeploymentSyncs = 0
	} else {
		x.ConcurrentDeploymentSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentDaemonSetSyncs = 0
	} else {
		x.ConcurrentDaemonSetSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentJobSyncs = 0
	} else {
		x.ConcurrentJobSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentNamespaceSyncs = 0
	} else {
		x.ConcurrentNamespaceSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentSATokenSyncs = 0
	} else {
		x.ConcurrentSATokenSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRC = 0
	} else {
		x.LookupCacheSizeForRC = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForRS = 0
	} else {
		x.LookupCacheSizeForRS = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LookupCacheSizeForDaemonSet = 0
	} else {
		x.LookupCacheSizeForDaemonSet = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1310 := &x.ServiceSyncPeriod
		yym1311 := z.DecBinary()
		_ = yym1311
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1310) {
		} else if !yym1311 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1310)
		} else {
			z.DecFallback(yyv1310, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1312 := &x.NodeSyncPeriod
		yym1313 := z.DecBinary()
		_ = yym1313
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1312) {
		} else if !yym1313 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1312)
		} else {
			z.DecFallback(yyv1312, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RouteReconciliationPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1314 := &x.RouteReconciliationPeriod
		yym1315 := z.DecBinary()
		_ = yym1315
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1314) {
		} else if !yym1315 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1314)
		} else {
			z.DecFallback(yyv1314, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceQuotaSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1316 := &x.ResourceQuotaSyncPeriod
		yym1317 := z.DecBinary()
		_ = yym1317
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1316) {
		} else if !yym1317 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1316)
		} else {
			z.DecFallback(yyv1316, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NamespaceSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1318 := &x.NamespaceSyncPeriod
		yym1319 := z.DecBinary()
		_ = yym1319
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1318) {
		} else if !yym1319 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1318)
		} else {
			z.DecFallback(yyv1318, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PVClaimBinderSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1320 := &x.PVClaimBinderSyncPeriod
		yym1321 := z.DecBinary()
		_ = yym1321
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1320) {
		} else if !yym1321 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1320)
		} else {
			z.DecFallback(yyv1320, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinResyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1322 := &x.MinResyncPeriod
		yym1323 := z.DecBinary()
		_ = yym1323
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1322) {
		} else if !yym1323 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1322)
		} else {
			z.DecFallback(yyv1322, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminatedPodGCThreshold = 0
	} else {
		x.TerminatedPodGCThreshold = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HorizontalPodAutoscalerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1325 := &x.HorizontalPodAutoscalerSyncPeriod
		yym1326 := z.DecBinary()
		_ = yym1326
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1325) {
		} else if !yym1326 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1325)
		} else {
			z.DecFallback(yyv1325, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeploymentControllerSyncPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1327 := &x.DeploymentControllerSyncPeriod
		yym1328 := z.DecBinary()
		_ = yym1328
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1327) {
		} else if !yym1328 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1327)
		} else {
			z.DecFallback(yyv1327, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodEvictionTimeout = pkg1_unversioned.Duration{}
	} else {
		yyv1329 := &x.PodEvictionTimeout
		yym1330 := z.DecBinary()
		_ = yym1330
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1329) {
		} else if !yym1330 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1329)
		} else {
			z.DecFallback(yyv1329, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsQps = 0
	} else {
		x.DeletingPodsQps = float32(r.DecodeFloat(true))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeletingPodsBurst = 0
	} else {
		x.DeletingPodsBurst = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1333 := &x.NodeMonitorGracePeriod
		yym1334 := z.DecBinary()
		_ = yym1334
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1333) {
		} else if !yym1334 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1333)
		} else {
			z.DecFallback(yyv1333, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RegisterRetryCount = 0
	} else {
		x.RegisterRetryCount = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeStartupGracePeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1336 := &x.NodeStartupGracePeriod
		yym1337 := z.DecBinary()
		_ = yym1337
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1336) {
		} else if !yym1337 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1336)
		} else {
			z.DecFallback(yyv1336, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeMonitorPeriod = pkg1_unversioned.Duration{}
	} else {
		yyv1338 := &x.NodeMonitorPeriod
		yym1339 := z.DecBinary()
		_ = yym1339
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1338) {
		} else if !yym1339 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1338)
		} else {
			z.DecFallback(yyv1338, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountKeyFile = ""
	} else {
		x.ServiceAccountKeyFile = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningCertFile = ""
	} else {
		x.ClusterSigningCertFile = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterSigningKeyFile = ""
	} else {
		x.ClusterSigningKeyFile = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ApproveAllKubeletCSRsForGroup = ""
	} else {
		x.ApproveAllKubeletCSRsForGroup = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableProfiling = false
	} else {
		x.EnableProfiling = bool(r.DecodeBool())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterCIDR = ""
	} else {
		x.ClusterCIDR = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceCIDR = ""
	} else {
		x.ServiceCIDR = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeCIDRMaskSize = 0
	} else {
		x.NodeCIDRMaskSize = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllocateNodeCIDRs = false
	} else {
		x.AllocateNodeCIDRs = bool(r.DecodeBool())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConfigureCloudRoutes = false
	} else {
		x.ConfigureCloudRoutes = bool(r.DecodeBool())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RootCAFile = ""
	} else {
		x.RootCAFile = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContentType = ""
	} else {
		x.ContentType = string(r.DecodeString())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIQPS = 0
	} else {
		x.KubeAPIQPS = float32(r.DecodeFloat(true))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeAPIBurst = 0
	} else {
		x.KubeAPIBurst = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LeaderElection = LeaderElectionConfiguration{}
	} else {
		yyv1355 := &x.LeaderElection
		yyv1355.CodecDecodeSelf(d)
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeConfiguration = VolumeConfiguration{}
	} else {
		yyv1356 := &x.VolumeConfiguration
		yyv1356.CodecDecodeSelf(d)
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ControllerStartInterval = pkg1_unversioned.Duration{}
	} else {
		yyv1357 := &x.ControllerStartInterval
		yym1358 := z.DecBinary()
		_ = yym1358
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1357) {
		} else if !yym1358 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1357)
		} else {
			z.DecFallback(yyv1357, false)
		}
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableGarbageCollector = false
	} else {
		x.EnableGarbageCollector = bool(r.DecodeBool())
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ConcurrentGCSyncs = 0
	} else {
		x.ConcurrentGCSyncs = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeEvictionRate = 0
	} else {
		x.NodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecondaryNodeEvictionRate = 0
	} else {
		x.SecondaryNodeEvictionRate = float32(r.DecodeFloat(true))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LargeClusterSizeThreshold = 0
	} else {
		x.LargeClusterSizeThreshold = int32(r.DecodeInt(32))
	}
	yyj1289++
	if yyhl1289 {
		yyb1289 = yyj1289 > l
	} else {
		yyb1289 = r.CheckBreak()
	}
	if yyb1289 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnhealthyZoneThreshold = 0
	} else {
		x.UnhealthyZoneThreshold = float32(r.DecodeFloat(true))
	}
	for {
		yyj1289++
		if yyhl1289 {
			yyb1289 = yyj1289 > l
		} else {
			yyb1289 = r.CheckBreak()
		}
		if yyb1289 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1289-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1365 := z.EncBinary()
		_ = yym1365
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1366 := !z.EncBinary()
			yy2arr1366 := z.EncBasicHandle().StructToArray
			var yyq1366 [4]bool
			_, _, _ = yysep1366, yyq1366, yy2arr1366
			const yyr1366 bool = false
			var yynn1366 int
			if yyr1366 || yy2arr1366 {
				r.EncodeArrayStart(4)
			} else {
				yynn1366 = 4
				for _, b := range yyq1366 {
					if b {
						yynn1366++
					}
				}
				r.EncodeMapStart(yynn1366)
				yynn1366 = 0
			}
			if yyr1366 || yy2arr1366 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1368 := z.EncBinary()
				_ = yym1368
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableHostPathProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1369 := z.EncBinary()
				_ = yym1369
				if false {
				} else {
					r.EncodeBool(bool(x.EnableHostPathProvisioning))
				}
			}
			if yyr1366 || yy2arr1366 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1371 := z.EncBinary()
				_ = yym1371
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("enableDynamicProvisioning"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1372 := z.EncBinary()
				_ = yym1372
				if false {
				} else {
					r.EncodeBool(bool(x.EnableDynamicProvisioning))
				}
			}
			if yyr1366 || yy2arr1366 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1374 := &x.PersistentVolumeRecyclerConfiguration
				yy1374.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("persitentVolumeRecyclerConfiguration"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1375 := &x.PersistentVolumeRecyclerConfiguration
				yy1375.CodecEncodeSelf(e)
			}
			if yyr1366 || yy2arr1366 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1377 := z.EncBinary()
				_ = yym1377
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("flexVolumePluginDir"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1378 := z.EncBinary()
				_ = yym1378
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FlexVolumePluginDir))
				}
			}
			if yyr1366 || yy2arr1366 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1379 := z.DecBinary()
	_ = yym1379
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1380 := r.ContainerType()
		if yyct1380 == codecSelferValueTypeMap1234 {
			yyl1380 := r.ReadMapStart()
			if yyl1380 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1380, d)
			}
		} else if yyct1380 == codecSelferValueTypeArray1234 {
			yyl1380 := r.ReadArrayStart()
			if yyl1380 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1380, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1381Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1381Slc
	var yyhl1381 bool = l >= 0
	for yyj1381 := 0; ; yyj1381++ {
		if yyhl1381 {
			if yyj1381 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1381Slc = r.DecodeBytes(yys1381Slc, true, true)
		yys1381 := string(yys1381Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1381 {
		case "enableHostPathProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableHostPathProvisioning = false
			} else {
				x.EnableHostPathProvisioning = bool(r.DecodeBool())
			}
		case "enableDynamicProvisioning":
			if r.TryDecodeAsNil() {
				x.EnableDynamicProvisioning = false
			} else {
				x.EnableDynamicProvisioning = bool(r.DecodeBool())
			}
		case "persitentVolumeRecyclerConfiguration":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
			} else {
				yyv1384 := &x.PersistentVolumeRecyclerConfiguration
				yyv1384.CodecDecodeSelf(d)
			}
		case "flexVolumePluginDir":
			if r.TryDecodeAsNil() {
				x.FlexVolumePluginDir = ""
			} else {
				x.FlexVolumePluginDir = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1381)
		} // end switch yys1381
	} // end for yyj1381
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1386 int
	var yyb1386 bool
	var yyhl1386 bool = l >= 0
	yyj1386++
	if yyhl1386 {
		yyb1386 = yyj1386 > l
	} else {
		yyb1386 = r.CheckBreak()
	}
	if yyb1386 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableHostPathProvisioning = false
	} else {
		x.EnableHostPathProvisioning = bool(r.DecodeBool())
	}
	yyj1386++
	if yyhl1386 {
		yyb1386 = yyj1386 > l
	} else {
		yyb1386 = r.CheckBreak()
	}
	if yyb1386 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnableDynamicProvisioning = false
	} else {
		x.EnableDynamicProvisioning = bool(r.DecodeBool())
	}
	yyj1386++
	if yyhl1386 {
		yyb1386 = yyj1386 > l
	} else {
		yyb1386 = r.CheckBreak()
	}
	if yyb1386 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeRecyclerConfiguration = PersistentVolumeRecyclerConfiguration{}
	} else {
		yyv1389 := &x.PersistentVolumeRecyclerConfiguration
		yyv1389.CodecDecodeSelf(d)
	}
	yyj1386++
	if yyhl1386 {
		yyb1386 = yyj1386 > l
	} else {
		yyb1386 = r.CheckBreak()
	}
	if yyb1386 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FlexVolumePluginDir = ""
	} else {
		x.FlexVolumePluginDir = string(r.DecodeString())
	}
	for {
		yyj1386++
		if yyhl1386 {
			yyb1386 = yyj1386 > l
		} else {
			yyb1386 = r.CheckBreak()
		}
		if yyb1386 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1386-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1391 := z.EncBinary()
		_ = yym1391
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1392 := !z.EncBinary()
			yy2arr1392 := z.EncBasicHandle().StructToArray
			var yyq1392 [7]bool
			_, _, _ = yysep1392, yyq1392, yy2arr1392
			const yyr1392 bool = false
			var yynn1392 int
			if yyr1392 || yy2arr1392 {
				r.EncodeArrayStart(7)
			} else {
				yynn1392 = 7
				for _, b := range yyq1392 {
					if b {
						yynn1392++
					}
				}
				r.EncodeMapStart(yynn1392)
				yynn1392 = 0
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1394 := z.EncBinary()
				_ = yym1394
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maximumRetry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1395 := z.EncBinary()
				_ = yym1395
				if false {
				} else {
					r.EncodeInt(int64(x.MaximumRetry))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1397 := z.EncBinary()
				_ = yym1397
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1398 := z.EncBinary()
				_ = yym1398
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutNFS))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1400 := z.EncBinary()
				_ = yym1400
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1401 := z.EncBinary()
				_ = yym1401
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathNFS))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1403 := z.EncBinary()
				_ = yym1403
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutNFS"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1404 := z.EncBinary()
				_ = yym1404
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutNFS))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1406 := z.EncBinary()
				_ = yym1406
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podTemplateFilePathHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1407 := z.EncBinary()
				_ = yym1407
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PodTemplateFilePathHostPath))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1409 := z.EncBinary()
				_ = yym1409
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("minimumTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1410 := z.EncBinary()
				_ = yym1410
				if false {
				} else {
					r.EncodeInt(int64(x.MinimumTimeoutHostPath))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1412 := z.EncBinary()
				_ = yym1412
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("incrementTimeoutHostPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1413 := z.EncBinary()
				_ = yym1413
				if false {
				} else {
					r.EncodeInt(int64(x.IncrementTimeoutHostPath))
				}
			}
			if yyr1392 || yy2arr1392 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1414 := z.DecBinary()
	_ = yym1414
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1415 := r.ContainerType()
		if yyct1415 == codecSelferValueTypeMap1234 {
			yyl1415 := r.ReadMapStart()
			if yyl1415 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1415, d)
			}
		} else if yyct1415 == codecSelferValueTypeArray1234 {
			yyl1415 := r.ReadArrayStart()
			if yyl1415 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1415, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1416Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1416Slc
	var yyhl1416 bool = l >= 0
	for yyj1416 := 0; ; yyj1416++ {
		if yyhl1416 {
			if yyj1416 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1416Slc = r.DecodeBytes(yys1416Slc, true, true)
		yys1416 := string(yys1416Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1416 {
		case "maximumRetry":
			if r.TryDecodeAsNil() {
				x.MaximumRetry = 0
			} else {
				x.MaximumRetry = int32(r.DecodeInt(32))
			}
		case "minimumTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutNFS = 0
			} else {
				x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathNFS":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathNFS = ""
			} else {
				x.PodTemplateFilePathNFS = string(r.DecodeString())
			}
		case "incrementTimeoutNFS":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutNFS = 0
			} else {
				x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
			}
		case "podTemplateFilePathHostPath":
			if r.TryDecodeAsNil() {
				x.PodTemplateFilePathHostPath = ""
			} else {
				x.PodTemplateFilePathHostPath = string(r.DecodeString())
			}
		case "minimumTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.MinimumTimeoutHostPath = 0
			} else {
				x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
			}
		case "incrementTimeoutHostPath":
			if r.TryDecodeAsNil() {
				x.IncrementTimeoutHostPath = 0
			} else {
				x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1416)
		} // end switch yys1416
	} // end for yyj1416
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeRecyclerConfiguration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1424 int
	var yyb1424 bool
	var yyhl1424 bool = l >= 0
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaximumRetry = 0
	} else {
		x.MaximumRetry = int32(r.DecodeInt(32))
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutNFS = 0
	} else {
		x.MinimumTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathNFS = ""
	} else {
		x.PodTemplateFilePathNFS = string(r.DecodeString())
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutNFS = 0
	} else {
		x.IncrementTimeoutNFS = int32(r.DecodeInt(32))
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodTemplateFilePathHostPath = ""
	} else {
		x.PodTemplateFilePathHostPath = string(r.DecodeString())
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinimumTimeoutHostPath = 0
	} else {
		x.MinimumTimeoutHostPath = int32(r.DecodeInt(32))
	}
	yyj1424++
	if yyhl1424 {
		yyb1424 = yyj1424 > l
	} else {
		yyb1424 = r.CheckBreak()
	}
	if yyb1424 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IncrementTimeoutHostPath = 0
	} else {
		x.IncrementTimeoutHostPath = int32(r.DecodeInt(32))
	}
	for {
		yyj1424++
		if yyhl1424 {
			yyb1424 = yyj1424 > l
		} else {
			yyb1424 = r.CheckBreak()
		}
		if yyb1424 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1424-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encconfig_ConfigurationMap(v pkg2_config.ConfigurationMap, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeMapStart(len(v))
	for yyk1432, yyv1432 := range v {
		z.EncSendContainerState(codecSelfer_containerMapKey1234)
		yym1433 := z.EncBinary()
		_ = yym1433
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyk1432))
		}
		z.EncSendContainerState(codecSelfer_containerMapValue1234)
		yym1434 := z.EncBinary()
		_ = yym1434
		if false {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1432))
		}
	}
	z.EncSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x codecSelfer1234) decconfig_ConfigurationMap(v *pkg2_config.ConfigurationMap, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1435 := *v
	yyl1435 := r.ReadMapStart()
	yybh1435 := z.DecBasicHandle()
	if yyv1435 == nil {
		yyrl1435, _ := z.DecInferLen(yyl1435, yybh1435.MaxInitLen, 32)
		yyv1435 = make(map[string]string, yyrl1435)
		*v = yyv1435
	}
	var yymk1435 string
	var yymv1435 string
	var yymg1435 bool
	if yybh1435.MapValueReset {
	}
	if yyl1435 > 0 {
		for yyj1435 := 0; yyj1435 < yyl1435; yyj1435++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1435 = ""
			} else {
				yymk1435 = string(r.DecodeString())
			}

			if yymg1435 {
				yymv1435 = yyv1435[yymk1435]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1435 = ""
			} else {
				yymv1435 = string(r.DecodeString())
			}

			if yyv1435 != nil {
				yyv1435[yymk1435] = yymv1435
			}
		}
	} else if yyl1435 < 0 {
		for yyj1435 := 0; !r.CheckBreak(); yyj1435++ {
			z.DecSendContainerState(codecSelfer_containerMapKey1234)
			if r.TryDecodeAsNil() {
				yymk1435 = ""
			} else {
				yymk1435 = string(r.DecodeString())
			}

			if yymg1435 {
				yymv1435 = yyv1435[yymk1435]
			}
			z.DecSendContainerState(codecSelfer_containerMapValue1234)
			if r.TryDecodeAsNil() {
				yymv1435 = ""
			} else {
				yymv1435 = string(r.DecodeString())
			}

			if yyv1435 != nil {
				yyv1435[yymk1435] = yymv1435
			}
		}
	} // else len==0: TODO: Should we clear map entries?
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}
