const path = require('path');
const { Level } = require('level');

const db = new Level(path.join(__dirname, 'database', process.env.NODE_ENV));

const dbPost = db.sublevel('posts');
const dbAccount = db.sublevel('account');
const dbSession = db.sublevel('session');

async function get(db, key) {
  try {
    return await db.get(key);
  } catch {
    return null;
  }
}

module.exports = {
  db,
  get,
  dbPost,
  dbAccount,
  dbSession,
}
