const express = require('express');
const captchapng = require('captchapng');
const { dbAccount } = require('../db');
const { visit } = require('./puppeteer');
const svgCaptcha = require('svg-captcha');

const router = express.Router();

function genCaptcha() {
  return svgCaptcha.create({
    size: 8,
    noise: 8,
    width: 300,
    height: 100
  });
}

function checkSchemeUrl(url) {
  let u = undefined;
  try { u = new URL(url); } catch { throw 'Wrong URL format'; }
  if (u.protocol !== 'http:' && u.protocol !== 'https:') throw 'URL must be http or https';
  return true;
}

router.get('/captcha.png', function (req, res) {
  let captcha = genCaptcha();
  req.session.captcha = captcha.text;
  res.type('svg');
  return res.status(200).send(captcha.data);
});

router.get('/', (req, res) => {
  return res.render('bot');
});

router.post('/', async (req, res) => {
  let { url, captcha } = req.body;
  try {
    if (!req.session.captcha || typeof captcha !== "string" || req.session.captcha !== captcha) {
      req.session.captcha = genCaptcha().text;
      return res.redirect(`/bot?msg=Wrong captcha`);
    }
    if (!url || typeof url !== "string") return res.redirect('/bot?msg=Invalid URL');
    checkSchemeUrl(url);
  } catch (err) {
    return res.redirect(`/bot?msg=${err}`)
  }
  try {
    visit(url);
    res.redirect(`/bot?msg=Admin is visitting your URL`);
  } catch {
    res.redirect(`/bot?msg=Something went wrong`);
  }
})

module.exports = router;
