const express = require('express');
const { db, get, dbAccount } = require('../db');
const { rand } = require('../helper');

const route = express.Router();

route.use((req, res, next) => {
  if (!req.user) return res.redirect(`/register?msg=You need to login`);
  next();
});

route.get('/', async (req, res) => {
  const search = (req.query.s || '');
  const posts = [];
  for (let i = 0; i < req.user.posts.length; ++i) {
    const id = req.user.posts[i];
    const content = await get(db, id);
    if (content.toString().includes(search))
      posts.push(id);
  }
  res.render('index', { user: { ...req.user, posts } });
});

route.post('/', async (req, res) => {
  const { csrf, content } = req.body;
  if (csrf !== req.user.csrf) return res.redirect(`/?msg=Hack detected`);
  if (!content || typeof content !== 'string') return res.redirect(`/?msg=Invalid data`);
  const id = rand();
  await db.put(id, content);
  req.user.posts.push(id);
  console.log({ id, content });
  await dbAccount.put(req.user.username, JSON.stringify(req.user));
  res.redirect('/?msg=Successfully added new post');
});

route.get('/post/:id', async (req, res) => {
  const { id } = req.params;
  if (!id || typeof id !== 'string') return res.send('Invalid data');
  let content = (await get(db, id)) || '';
  if (content.length > 200) content = content.slice(0, 200) + '...';
  res.render('post', { content });
});

module.exports = route;
