const Puppeteer = require('puppeteer');
const { rand } = require('../helper');

function sleep(time) {
  return new Promise(resolve => {
    setTimeout(resolve, time)
  });
}

// Admin visiting your URL
async function visit(url) {
  console.log(`bot visits ${url}`);
  try {
    const browser = await Puppeteer.launch({
      headless: true,
      ignoreHTTPSErrors: true,
      args: ['--no-sandbox'],
    });
    const page = await browser.newPage();
    page.on('dialog', async dialog => {
      await dialog.accept();
    });
    await page.goto(process.env.PAGE + '/register', { timeout: 3000, waitUntil: 'domcontentloaded' });
    await page.type('#username', process.env.ADMIN_USERNAME + '-' + rand());
    await page.type('#password', process.env.ADMIN_PASSWORD + '-' + rand());
    await page.click('#submit');
    await page.waitForNavigation();

    await page.evaluate(flag => {
      document.getElementById('content').value = flag;
      document.getElementById('form').submit();
    }, process.env.FLAG);
    await sleep(500);

    await page.goto(url, { timeout: 5000 }).catch(error => console.error(error));
    await sleep(5000);

    await page.close();
    await browser.close();
  } catch (e) {
    console.error(e);
    try { await browser.close() } catch (e) { 
      console.log("close error");
      console.error(e);
    }
  }
}

module.exports = { visit }
