const express = require('express');
const { rand, sha } = require('../helper');
const { get, dbAccount, dbSession } = require('../db');

const route = express.Router();

route.get('/', (req, res) => {
  res.render('register');
})

route.post('/', async (req, res) => {
  let next = req.query.next || '/';
  if (req.user) {
    return res.redirect(`${next}?msg=Already logged in ${req.user.username}`);
  }
  const { username, password } = req.body;
  if (!username || !password || typeof username !== 'string' || typeof password !== 'string') return res.redirect(`/register?msg=Invalid data`);
  let account = await get(dbAccount, username);
  if (account) account = JSON.parse(account);
  if (account && sha(password) !== account.password)
    return res.redirect(`/register?msg=Wrong password`);
  const id = rand();
  await dbSession.put(id, username);
  if (!account) {
    const csrf = rand();
    await dbAccount.put(username, JSON.stringify({
      csrf,
      username,
      password: sha(password),
      captcha: Math.floor(Math.random() * 9000 + 1000),
      posts: [],
    }));
  }
  res.cookie('id', id, {
    maxAge: 1000 * 60 * 60,
    httpOnly: true,
    secure: true,
    sameSite: 'none',
  })
  res.redirect(`${next}?msg=Successfully logged in`);
})

module.exports = route;
