# LuxOS Installer API

## Description

The LuxOS Installer API is a robust solution designed to streamline the installation and management of LuxOS firmware on mining devices.

Distributed as a CLI executable, it allows running an API server to manage remote installations via a REST API. It also offers direct bash commands for single device installations, bulk installations using a CSV.

This flexibility makes it ideal for various integration scenarios, from simple scripts to complex automated workflows.

## Installation

Downloading the LuxOS Installer CLI is the only step required to start using the API. It does not require any additional dependencies or setup.

## Usage
The LuxOS Installer CLI supports three main commands:

### 1. `server`
- **Description:** Runs an API server daemon to manage remote LuxOS installations via a REST API.
- **Usage:** Enables advanced integrations, allowing external systems to interact with the API. It allows to scan the network for available miners and start, stop, and monitor installations.
- **Example Command:**
```sh
./luxos-installer-darwin-arm64 server
```

### 2. `install`
- **Description:** Installs LuxOS on a single device.
- **Usage:** Suitable for quick small-scale deployments and simple scripting integrations.
- **Example Command:**
```sh
./luxos-installer-darwin-arm64 install --hostname 192.168.1.10
```

### 3. `batch-install`
- **Description:** Installs LuxOS on multiple devices using a CSV file.
- **Usage:** Ideal for large-scale deployments using scripting integrations.
- **Example Command:**
```sh
./luxos-installer-darwin-arm64 batch-install --file /path/to/devices.csv
```

The `API server` is the preferred method for integrating with the LuxOS Installer API. The `install` and `batch-install` commands are provided for quick and simple installations.

Note that you can get more information about each command using the --help flag:
```sh
./luxos-installer-[platform] --help                # displays general help
./luxos-installer-[platform] server --help         # displays server command help
./luxos-installer-[platform] install --help        # displays install command help
./luxos-installer-[platform] batch-install --help  # displays batch-install command help
```
Where `[platform]` is the platform you are running the CLI on (e.g., darwin-arm64, linux-amd64).

## Using the API server

### API Endpoints

Running LuxOS Installer API as a server is the easiest and preferred way to integrate with LuxOS Installer API.

To execute it, run the following command:
```sh
./luxos-installer-[platform] server
```
Where `[platform]` is the platform you are running the CLI on (e.g., darwin-arm64, linux-amd64).

When the LuxOS Installer API is running as a server, it exposes the following REST endpoints:

- **Start install**
  - **Endpoint:** POST `http://localhost:8188/v1/install`
  - **Description:** Initiates a new installation request. Supports single IP, IP range, CIDR notation, and a list of IPs.

- **Stop install**
  - **Endpoint:** DELETE `http://localhost:8188/v1/install/{request_id}`
  - **Description:** Stops a specific installation request.

- **Get install list**
  - **Endpoint:** GET `http://localhost:8188/v1/install`
  - **Description:** Retrieves a list of all installation requests.

- **Get install status**
  - **Endpoint:** GET `http://localhost:8188/v1/install/{request_id}`
  - **Description:** Retrieves the status of a specific installation request.

- **Start scan**
  - **Endpoint:** POST `http://localhost:8188/v1/scan`
  - **Description:** Initiates a new scan request. Supports single IP, IP range, CIDR notation, and a list of IPs.

- **Stop scan**
  - **Endpoint:** DELETE `http://localhost:8188/v1/scan/{request_id}`
  - **Description:** Stops a specific scan request.

- **Get scan list**
  - **Endpoint:** GET `http://localhost:8188/v1/scan`
  - **Description:** Retrieves a list of all scan requests.

- **Get scan status**
  - **Endpoint:** GET `http://localhost:8188/v1/scan/{request_id}`
  - **Description:** Retrieves the status of a specific scan request.

- **Shutdown**
  - **Endpoint:** POST `http://localhost:8188/v1/shutdown`
  - **Description:** Shuts down the server gracefully.

For detailed information and examples for each endpoint, please refer to the live documentation available at http://localhost:8188/docs.

## Common use cases

### Install LuxOS

You can use the [start install endpoint](http://localhost:8188/docs#/operations/post-v1-install) to start a new installation request.

It supports different ways to provide the IP addresses to install the LuxOS firmware on:
- **Single IP**: by providing start_ip and leaving end_ip empty
- **IP Range**: by providing start_ip and end_ip body fields.
- **CIDR**: by providing the IP rage in CIDR notation inside the cidr body field.
- **List of IPs**: by providing the list of IPs in the ip_list body field.

Please also note that you can provide range, CIDR and list of IPs at the same time. Repeated IPs will be ignored.

If you provide an IP that is not compatible with the LuxOS firmware, the installation process will skip that IP and continue with the next one.

#### IP range example
POST http://localhost:8188/v1/scan
```
POST http://localhost:8188/v1/install
{
  "start_ip": "10.20.0.1",
  "end_ip": "10.20.0.100"
}
```

#### Provide a partner ID

When performing LuxOS installations, you can provide a partner ID to associate the installations with a specific partner. The partner ID is the unique identifier of the partner who is managing the installations. Please contact Luxor to get more information about the partner ID.

You can provide the partner ID in the start install request body:
```
POST http://localhost:8188/v1/install
{
  "start_ip": "192.168.100.15",
  "end_ip": "192.168.100.200",
  "partner_id": "your partner id"
}
```

### Monitor installation progress

You can use the [get install status endpoint](http://localhost:8188/docs#/operations/get-v1-install-by-request-id) to monitor the progress of an installation request.
```
GET http://localhost:8188/v1/install/{request_id}
```

request_id param is the unique identifier of the installation request returned by the start install endpoint.

You can also get status for all installation requests by calling the [get install list endpoint](http://localhost:8188/docs#/operations/list-v1-install).
```
GET http://localhost:8188/v1/install
```

### Scan the network for available miners

You can use the [start scan endpoint](http://localhost:8188/docs#/operations/post-v1-scan) to discover available miners on your network. This is useful when you want to install LuxOS on multiple devices without knowing their IP addresses in advance.

This endpoint supports different ways to provide the IP addresses to scan for miners:
- **Single IP**: by providing start_ip and leaving end_ip empty
- **IP Range**: by providing start_ip and end_ip body fields.
- **CIDR**: by providing the IP rage in CIDR notation inside the cidr body field.
- **List of IPs**: by providing the list of IPs in the ip_list body field.

Please also note that you can provide range, CIDR and list of IPs at the same time. Repeated IPs will be ignored.

#### IP range example
POST http://localhost:8188/v1/scan
```
POST http://localhost:8188/v1/scan
{
  "start_ip": "10.20.0.1",
  "end_ip": "10.20.0.100"
}
```

### Monitor scan progress

You can use the [get scan status endpoint](http://localhost:8188/docs#/operations/get-v1-scan-by-request-id) to monitor the progress of a scan request.
```
GET http://localhost:8188/v1/scan/{request_id}
```

request_id param is the unique identifier of the scan request returned by the start scan endpoint.

You can also get status for all scan requests by calling the [get scan list endpoint"](http://localhost:8188/docs#/operations/list-v1-scan).
```
GET http://localhost:8188/v1/scan
```

## API server documentation

The LuxOS Installer API server provides a live documentation interface that allows you to explore the available endpoints and interact with them directly.
As mentioned before, you can access the API documentation by visiting http://localhost:8188/docs.

In the documentation, you can find detailed information about each endpoint, including the request and response schemas, examples, and the available parameters.

We also provide OpenAPI spec filesa and schema files for each resource in the API.

### OpenAPI spec

The API is documented using the OpenAPI 3.1 spec. You can use this spec to generate client libraries, documentation and more.

The OpenAPI spec is available in multiple versions (to better support older tools) and in JSON or YAML:
- OpenAPI 3.1 JSON: http://localhost:8188/openapi.json
- OpenAPI 3.1 YAML: http://localhost:8188/openapi.yaml
- OpenAPI 3.0.3 JSON: http://localhost:8188/openapi-3.0.json
- OpenAPI 3.0.3 YAML: http://localhost:8188/openapi-3.0.yaml

### Schema publishing

We also offer schema files for each resource in the API. These are available in JSON format in http://localhost:8188/schemas/{resource}.json.

A link to the corresponding schema files is available in the API documentation for each resource and in the OpenAPI spec.

> The $schema field is incredibly powerful when paired with [Restish's edit command](https://rest.sh/#/guide?id=editing-resources), giving you a quick and easy way to edit strongly-typed resources in your favorite editor.
> It also enables editors like VS Code to provide autocompletion and validation when using this API.

## Conclusion

The LuxOS Installer API provides a versatile and powerful toolset for managing LuxOS firmware installations across various scenarios. Whether you're performing a single installation or managing a large fleet of devices, this API offers the flexibility and control needed for efficient operations.
