/*
 * Copyright (C) Advanced Micro Devices, Inc. All rights reserved.
 * Copyright (C) 2024-2025, The vLLM team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Adapted from
 * https://github.com/pytorch/pytorch/blob/v2.0.1/aten/src/ATen/Dispatch.h
 */
#pragma once

#include <torch/extension.h>

#define AITER_CASE_VEC_SIZE(VC, ...)     \
    case VC: {                           \
        constexpr int32_t VEC_SIZE = VC; \
        __VA_ARGS__                      \
        break;                           \
    }

#define AITER_DISPATCH_CASE_VEC_SIZE(vec_size, ...)                           \
    switch(vec_size)                                                          \
    {                                                                         \
        AITER_CASE_VEC_SIZE(32, __VA_ARGS__)                                  \
        AITER_CASE_VEC_SIZE(16, __VA_ARGS__)                                  \
        AITER_CASE_VEC_SIZE(8, __VA_ARGS__)                                   \
        AITER_CASE_VEC_SIZE(4, __VA_ARGS__)                                   \
        AITER_CASE_VEC_SIZE(2, __VA_ARGS__)                                   \
        AITER_CASE_VEC_SIZE(1, __VA_ARGS__)                                   \
    default: TORCH_CHECK(false, __func__, " does't support ", vec_size, "."); \
    }

#define AITER_DISPATCH_CASE_FLOATING16_TYPES(...)       \
    AT_DISPATCH_CASE(at::ScalarType::Half, __VA_ARGS__) \
    AT_DISPATCH_CASE(at::ScalarType::BFloat16, __VA_ARGS__)

#define AITER_DISPATCH_FLOATING16_TYPES(TYPE, NAME, ...) \
    AT_DISPATCH_SWITCH(TYPE, NAME, AITER_DISPATCH_CASE_FLOATING16_TYPES(__VA_ARGS__))

#define VLLM_DISPATCH_CASE_FLOATING_TYPES(...)           \
    AT_DISPATCH_CASE(at::ScalarType::Float, __VA_ARGS__) \
    AT_DISPATCH_CASE(at::ScalarType::Half, __VA_ARGS__)  \
    AT_DISPATCH_CASE(at::ScalarType::BFloat16, __VA_ARGS__)

#define VLLM_DISPATCH_FLOATING_TYPES(TYPE, NAME, ...) \
    AT_DISPATCH_SWITCH(TYPE, NAME, VLLM_DISPATCH_CASE_FLOATING_TYPES(__VA_ARGS__))

#define VLLM_DISPATCH_CASE_FLOATING_AND_BYTE_TYPES(...)     \
    AT_DISPATCH_CASE(at::ScalarType::Float, __VA_ARGS__)    \
    AT_DISPATCH_CASE(at::ScalarType::Half, __VA_ARGS__)     \
    AT_DISPATCH_CASE(at::ScalarType::BFloat16, __VA_ARGS__) \
    AT_DISPATCH_CASE(at::ScalarType::Byte, __VA_ARGS__)

#define VLLM_DISPATCH_FLOATING_AND_BYTE_TYPES(TYPE, NAME, ...) \
    AT_DISPATCH_SWITCH(TYPE, NAME, VLLM_DISPATCH_CASE_FLOATING_AND_BYTE_TYPES(__VA_ARGS__))

#define VLLM_DISPATCH_CASE_INTEGRAL_TYPES(...)           \
    AT_DISPATCH_CASE(at::ScalarType::Byte, __VA_ARGS__)  \
    AT_DISPATCH_CASE(at::ScalarType::Char, __VA_ARGS__)  \
    AT_DISPATCH_CASE(at::ScalarType::Short, __VA_ARGS__) \
    AT_DISPATCH_CASE(at::ScalarType::Int, __VA_ARGS__)   \
    AT_DISPATCH_CASE(at::ScalarType::Long, __VA_ARGS__)

#define VLLM_DISPATCH_INTEGRAL_TYPES(TYPE, NAME, ...) \
    AT_DISPATCH_SWITCH(TYPE, NAME, VLLM_DISPATCH_CASE_INTEGRAL_TYPES(__VA_ARGS__))
