import os
from pathlib import Path
import torch
import tempfile

import triton
import triton.language as tl
from triton.backends.compiler import GPUTarget
from triton.tools.compile import compile_kernel, CompileArgs

from aiter.utility.triton.triton_metadata_redirect import (
    AOTMetadataContext,
    with_custom_metadata_path,
)

triton_path = triton.__path__[0]
kernel_path = os.path.join(Path(__file__).parent, "kernel.py")

ocml_path = os.path.join(triton_path, "backends", "amd", "lib", "ocml.bc")
ockl_path = os.path.join(triton_path, "backends", "amd", "lib", "ockl.bc")
aot_kernel0_json = f'{{"hash": "6bcc39a06793f9046cfac6c1e43d525df901f199afd42416bdc907df0b6194cf", "target": {{"backend": "hip", "arch": "gfx942", "warp_size": 64}}, "num_warps": 4, "waves_per_eu": 1, "num_stages": 2, "num_ctas": 1, "extern_libs": [["ocml", "{ocml_path}"], ["ockl", "{ockl_path}"]], "cluster_dims": [1, 1, 1], "debug": false, "sanitize_overflow": true, "arch": "gfx942", "supported_fp8_dtypes": ["fp8e4b8", "fp8e4nv", "fp8e5", "fp8e5b16"], "deprecated_fp8_dot_operand_dtypes": [], "default_dot_input_precision": "ieee", "allowed_dot_input_precisions": ["ieee", "tf32"], "enable_fp_fusion": true, "launch_cooperative_grid": false, "matrix_instr_nonkdim": 0, "kpack": 1, "allow_flush_denorm": false, "max_num_imprecise_acc_default": 0, "backend_name": "hip", "instrumentation_mode": "", "schedule_hint": "none", "warp_size": 64, "triton_version": "3.5.0", "shared": 0, "profile_scratch_size": 0, "profile_scratch_align": 1, "name": "empty_kernel"}}'

aot_kernel0_hsaco = [
    0x7F,
    0x45,
    0x4C,
    0x46,
    0x02,
    0x01,
    0x01,
    0x40,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0xE0,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x30,
    0x11,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4C,
    0x05,
    0x00,
    0x00,
    0x40,
    0x00,
    0x38,
    0x00,
    0x08,
    0x00,
    0x40,
    0x00,
    0x15,
    0x00,
    0x13,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC0,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC0,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x40,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x70,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC0,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x40,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x70,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x70,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x52,
    0xE5,
    0x74,
    0x64,
    0x04,
    0x00,
    0x00,
    0x00,
    0x40,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x70,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC0,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x51,
    0xE5,
    0x74,
    0x64,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4C,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4C,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x07,
    0x00,
    0x00,
    0x00,
    0x37,
    0x02,
    0x00,
    0x00,
    0x20,
    0x00,
    0x00,
    0x00,
    0x41,
    0x4D,
    0x44,
    0x47,
    0x50,
    0x55,
    0x00,
    0x00,
    0x83,
    0xAE,
    0x61,
    0x6D,
    0x64,
    0x68,
    0x73,
    0x61,
    0x2E,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x73,
    0x91,
    0x8F,
    0xAB,
    0x2E,
    0x61,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x63,
    0x6F,
    0x75,
    0x6E,
    0x74,
    0x00,
    0xA5,
    0x2E,
    0x61,
    0x72,
    0x67,
    0x73,
    0x93,
    0x84,
    0xAE,
    0x2E,
    0x61,
    0x64,
    0x64,
    0x72,
    0x65,
    0x73,
    0x73,
    0x5F,
    0x73,
    0x70,
    0x61,
    0x63,
    0x65,
    0xA6,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0xA7,
    0x2E,
    0x6F,
    0x66,
    0x66,
    0x73,
    0x65,
    0x74,
    0x00,
    0xA5,
    0x2E,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x08,
    0xAB,
    0x2E,
    0x76,
    0x61,
    0x6C,
    0x75,
    0x65,
    0x5F,
    0x6B,
    0x69,
    0x6E,
    0x64,
    0xAD,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0x5F,
    0x62,
    0x75,
    0x66,
    0x66,
    0x65,
    0x72,
    0x84,
    0xAE,
    0x2E,
    0x61,
    0x64,
    0x64,
    0x72,
    0x65,
    0x73,
    0x73,
    0x5F,
    0x73,
    0x70,
    0x61,
    0x63,
    0x65,
    0xA6,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0xA7,
    0x2E,
    0x6F,
    0x66,
    0x66,
    0x73,
    0x65,
    0x74,
    0x08,
    0xA5,
    0x2E,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x08,
    0xAB,
    0x2E,
    0x76,
    0x61,
    0x6C,
    0x75,
    0x65,
    0x5F,
    0x6B,
    0x69,
    0x6E,
    0x64,
    0xAD,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0x5F,
    0x62,
    0x75,
    0x66,
    0x66,
    0x65,
    0x72,
    0x84,
    0xAE,
    0x2E,
    0x61,
    0x64,
    0x64,
    0x72,
    0x65,
    0x73,
    0x73,
    0x5F,
    0x73,
    0x70,
    0x61,
    0x63,
    0x65,
    0xA6,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0xA7,
    0x2E,
    0x6F,
    0x66,
    0x66,
    0x73,
    0x65,
    0x74,
    0x10,
    0xA5,
    0x2E,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x08,
    0xAB,
    0x2E,
    0x76,
    0x61,
    0x6C,
    0x75,
    0x65,
    0x5F,
    0x6B,
    0x69,
    0x6E,
    0x64,
    0xAD,
    0x67,
    0x6C,
    0x6F,
    0x62,
    0x61,
    0x6C,
    0x5F,
    0x62,
    0x75,
    0x66,
    0x66,
    0x65,
    0x72,
    0xB9,
    0x2E,
    0x67,
    0x72,
    0x6F,
    0x75,
    0x70,
    0x5F,
    0x73,
    0x65,
    0x67,
    0x6D,
    0x65,
    0x6E,
    0x74,
    0x5F,
    0x66,
    0x69,
    0x78,
    0x65,
    0x64,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x00,
    0xB6,
    0x2E,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x61,
    0x72,
    0x67,
    0x5F,
    0x73,
    0x65,
    0x67,
    0x6D,
    0x65,
    0x6E,
    0x74,
    0x5F,
    0x61,
    0x6C,
    0x69,
    0x67,
    0x6E,
    0x08,
    0xB5,
    0x2E,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x61,
    0x72,
    0x67,
    0x5F,
    0x73,
    0x65,
    0x67,
    0x6D,
    0x65,
    0x6E,
    0x74,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x18,
    0xB8,
    0x2E,
    0x6D,
    0x61,
    0x78,
    0x5F,
    0x66,
    0x6C,
    0x61,
    0x74,
    0x5F,
    0x77,
    0x6F,
    0x72,
    0x6B,
    0x67,
    0x72,
    0x6F,
    0x75,
    0x70,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0xCD,
    0x01,
    0x00,
    0xA5,
    0x2E,
    0x6E,
    0x61,
    0x6D,
    0x65,
    0xAC,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0xBB,
    0x2E,
    0x70,
    0x72,
    0x69,
    0x76,
    0x61,
    0x74,
    0x65,
    0x5F,
    0x73,
    0x65,
    0x67,
    0x6D,
    0x65,
    0x6E,
    0x74,
    0x5F,
    0x66,
    0x69,
    0x78,
    0x65,
    0x64,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x00,
    0xAB,
    0x2E,
    0x73,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x63,
    0x6F,
    0x75,
    0x6E,
    0x74,
    0x0E,
    0xB1,
    0x2E,
    0x73,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x73,
    0x70,
    0x69,
    0x6C,
    0x6C,
    0x5F,
    0x63,
    0x6F,
    0x75,
    0x6E,
    0x74,
    0x00,
    0xA7,
    0x2E,
    0x73,
    0x79,
    0x6D,
    0x62,
    0x6F,
    0x6C,
    0xAF,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6B,
    0x64,
    0xB3,
    0x2E,
    0x75,
    0x73,
    0x65,
    0x73,
    0x5F,
    0x64,
    0x79,
    0x6E,
    0x61,
    0x6D,
    0x69,
    0x63,
    0x5F,
    0x73,
    0x74,
    0x61,
    0x63,
    0x6B,
    0xC2,
    0xAB,
    0x2E,
    0x76,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x63,
    0x6F,
    0x75,
    0x6E,
    0x74,
    0x00,
    0xB1,
    0x2E,
    0x76,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x73,
    0x70,
    0x69,
    0x6C,
    0x6C,
    0x5F,
    0x63,
    0x6F,
    0x75,
    0x6E,
    0x74,
    0x00,
    0xAF,
    0x2E,
    0x77,
    0x61,
    0x76,
    0x65,
    0x66,
    0x72,
    0x6F,
    0x6E,
    0x74,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x40,
    0xAD,
    0x61,
    0x6D,
    0x64,
    0x68,
    0x73,
    0x61,
    0x2E,
    0x74,
    0x61,
    0x72,
    0x67,
    0x65,
    0x74,
    0xB9,
    0x61,
    0x6D,
    0x64,
    0x67,
    0x63,
    0x6E,
    0x2D,
    0x61,
    0x6D,
    0x64,
    0x2D,
    0x61,
    0x6D,
    0x64,
    0x68,
    0x73,
    0x61,
    0x2D,
    0x2D,
    0x67,
    0x66,
    0x78,
    0x39,
    0x34,
    0x32,
    0xAE,
    0x61,
    0x6D,
    0x64,
    0x68,
    0x73,
    0x61,
    0x2E,
    0x76,
    0x65,
    0x72,
    0x73,
    0x69,
    0x6F,
    0x6E,
    0x92,
    0x01,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x12,
    0x03,
    0x07,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0E,
    0x00,
    0x00,
    0x00,
    0x11,
    0x00,
    0x06,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x1A,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x10,
    0x00,
    0x00,
    0x00,
    0x02,
    0x02,
    0x01,
    0x00,
    0x00,
    0x00,
    0x14,
    0xB0,
    0x18,
    0x3B,
    0x71,
    0x79,
    0xA6,
    0xE4,
    0x03,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6B,
    0x64,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x18,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x11,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x20,
    0x03,
    0xAF,
    0x00,
    0x90,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x80,
    0x00,
    0x06,
    0xC0,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x0A,
    0xC0,
    0x08,
    0x00,
    0x00,
    0x00,
    0x7F,
    0xC0,
    0x8C,
    0xBF,
    0x3A,
    0x00,
    0x82,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x81,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x00,
    0x00,
    0x80,
    0xBF,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x50,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x18,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xDC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0A,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x1E,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF5,
    0xFE,
    0xFF,
    0x6F,
    0x00,
    0x00,
    0x00,
    0x00,
    0x98,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xBC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x11,
    0x00,
    0x25,
    0x0E,
    0x13,
    0x05,
    0x03,
    0x0E,
    0x10,
    0x17,
    0x1B,
    0x0E,
    0x11,
    0x01,
    0x12,
    0x06,
    0x00,
    0x00,
    0x00,
    0x26,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x5A,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x07,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x01,
    0x00,
    0x00,
    0x74,
    0x72,
    0x69,
    0x74,
    0x6F,
    0x6E,
    0x00,
    0x2F,
    0x6D,
    0x6E,
    0x74,
    0x2F,
    0x72,
    0x61,
    0x69,
    0x64,
    0x30,
    0x2F,
    0x6A,
    0x69,
    0x61,
    0x6E,
    0x2E,
    0x77,
    0x75,
    0x2F,
    0x77,
    0x6F,
    0x72,
    0x6B,
    0x2F,
    0x61,
    0x69,
    0x74,
    0x65,
    0x72,
    0x2F,
    0x61,
    0x69,
    0x74,
    0x65,
    0x72,
    0x2F,
    0x6F,
    0x70,
    0x5F,
    0x74,
    0x65,
    0x73,
    0x74,
    0x73,
    0x2F,
    0x74,
    0x72,
    0x69,
    0x74,
    0x6F,
    0x6E,
    0x5F,
    0x74,
    0x65,
    0x73,
    0x74,
    0x73,
    0x2F,
    0x74,
    0x72,
    0x69,
    0x74,
    0x6F,
    0x6E,
    0x5F,
    0x6D,
    0x65,
    0x74,
    0x61,
    0x64,
    0x61,
    0x74,
    0x61,
    0x5F,
    0x72,
    0x65,
    0x64,
    0x69,
    0x72,
    0x65,
    0x63,
    0x74,
    0x00,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x70,
    0x79,
    0x00,
    0x95,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x74,
    0x00,
    0x00,
    0x00,
    0x04,
    0x01,
    0x01,
    0xFB,
    0x0E,
    0x0D,
    0x00,
    0x01,
    0x01,
    0x01,
    0x01,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x01,
    0x2F,
    0x6D,
    0x6E,
    0x74,
    0x2F,
    0x72,
    0x61,
    0x69,
    0x64,
    0x30,
    0x2F,
    0x6A,
    0x69,
    0x61,
    0x6E,
    0x2E,
    0x77,
    0x75,
    0x2F,
    0x77,
    0x6F,
    0x72,
    0x6B,
    0x2F,
    0x61,
    0x69,
    0x74,
    0x65,
    0x72,
    0x2F,
    0x61,
    0x69,
    0x74,
    0x65,
    0x72,
    0x2F,
    0x6F,
    0x70,
    0x5F,
    0x74,
    0x65,
    0x73,
    0x74,
    0x73,
    0x2F,
    0x74,
    0x72,
    0x69,
    0x74,
    0x6F,
    0x6E,
    0x5F,
    0x74,
    0x65,
    0x73,
    0x74,
    0x73,
    0x2F,
    0x74,
    0x72,
    0x69,
    0x74,
    0x6F,
    0x6E,
    0x5F,
    0x6D,
    0x65,
    0x74,
    0x61,
    0x64,
    0x61,
    0x74,
    0x61,
    0x5F,
    0x72,
    0x65,
    0x64,
    0x69,
    0x72,
    0x65,
    0x63,
    0x74,
    0x00,
    0x00,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x70,
    0x79,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x0A,
    0x00,
    0x09,
    0x02,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x06,
    0x02,
    0x40,
    0x0D,
    0x05,
    0x02,
    0x06,
    0x18,
    0x02,
    0x90,
    0x02,
    0x00,
    0x01,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0C,
    0x00,
    0x00,
    0x00,
    0xFF,
    0xFF,
    0xFF,
    0xFF,
    0x04,
    0x00,
    0x08,
    0x00,
    0x04,
    0x04,
    0x10,
    0x00,
    0x14,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4C,
    0x69,
    0x6E,
    0x6B,
    0x65,
    0x72,
    0x3A,
    0x20,
    0x4C,
    0x4C,
    0x44,
    0x20,
    0x32,
    0x32,
    0x2E,
    0x30,
    0x2E,
    0x30,
    0x20,
    0x28,
    0x68,
    0x74,
    0x74,
    0x70,
    0x73,
    0x3A,
    0x2F,
    0x2F,
    0x67,
    0x69,
    0x74,
    0x68,
    0x75,
    0x62,
    0x2E,
    0x63,
    0x6F,
    0x6D,
    0x2F,
    0x6C,
    0x6C,
    0x76,
    0x6D,
    0x2F,
    0x6C,
    0x6C,
    0x76,
    0x6D,
    0x2D,
    0x70,
    0x72,
    0x6F,
    0x6A,
    0x65,
    0x63,
    0x74,
    0x20,
    0x30,
    0x36,
    0x34,
    0x66,
    0x30,
    0x32,
    0x64,
    0x61,
    0x63,
    0x30,
    0x63,
    0x38,
    0x31,
    0x63,
    0x31,
    0x39,
    0x33,
    0x35,
    0x30,
    0x61,
    0x37,
    0x34,
    0x34,
    0x31,
    0x35,
    0x62,
    0x33,
    0x32,
    0x34,
    0x35,
    0x66,
    0x34,
    0x32,
    0x66,
    0x65,
    0x64,
    0x30,
    0x39,
    0x64,
    0x63,
    0x29,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x17,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x2D,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x48,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x66,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x7C,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x9B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xBC,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xD7,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF6,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0A,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x1E,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF1,
    0xFF,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4F,
    0x01,
    0x00,
    0x00,
    0x00,
    0x02,
    0x08,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x32,
    0x01,
    0x00,
    0x00,
    0x12,
    0x03,
    0x07,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x3F,
    0x01,
    0x00,
    0x00,
    0x11,
    0x00,
    0x06,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x2E,
    0x6E,
    0x6F,
    0x74,
    0x65,
    0x00,
    0x2E,
    0x64,
    0x79,
    0x6E,
    0x73,
    0x79,
    0x6D,
    0x00,
    0x2E,
    0x67,
    0x6E,
    0x75,
    0x2E,
    0x68,
    0x61,
    0x73,
    0x68,
    0x00,
    0x2E,
    0x68,
    0x61,
    0x73,
    0x68,
    0x00,
    0x2E,
    0x64,
    0x79,
    0x6E,
    0x73,
    0x74,
    0x72,
    0x00,
    0x2E,
    0x72,
    0x6F,
    0x64,
    0x61,
    0x74,
    0x61,
    0x00,
    0x2E,
    0x74,
    0x65,
    0x78,
    0x74,
    0x00,
    0x2E,
    0x64,
    0x79,
    0x6E,
    0x61,
    0x6D,
    0x69,
    0x63,
    0x00,
    0x2E,
    0x72,
    0x65,
    0x6C,
    0x72,
    0x6F,
    0x5F,
    0x70,
    0x61,
    0x64,
    0x64,
    0x69,
    0x6E,
    0x67,
    0x00,
    0x2E,
    0x41,
    0x4D,
    0x44,
    0x47,
    0x50,
    0x55,
    0x2E,
    0x63,
    0x73,
    0x64,
    0x61,
    0x74,
    0x61,
    0x00,
    0x2E,
    0x41,
    0x4D,
    0x44,
    0x47,
    0x50,
    0x55,
    0x2E,
    0x67,
    0x70,
    0x72,
    0x5F,
    0x6D,
    0x61,
    0x78,
    0x69,
    0x6D,
    0x75,
    0x6D,
    0x73,
    0x00,
    0x2E,
    0x64,
    0x65,
    0x62,
    0x75,
    0x67,
    0x5F,
    0x61,
    0x62,
    0x62,
    0x72,
    0x65,
    0x76,
    0x00,
    0x2E,
    0x64,
    0x65,
    0x62,
    0x75,
    0x67,
    0x5F,
    0x69,
    0x6E,
    0x66,
    0x6F,
    0x00,
    0x2E,
    0x64,
    0x65,
    0x62,
    0x75,
    0x67,
    0x5F,
    0x73,
    0x74,
    0x72,
    0x00,
    0x2E,
    0x64,
    0x65,
    0x62,
    0x75,
    0x67,
    0x5F,
    0x6C,
    0x69,
    0x6E,
    0x65,
    0x00,
    0x2E,
    0x64,
    0x65,
    0x62,
    0x75,
    0x67,
    0x5F,
    0x66,
    0x72,
    0x61,
    0x6D,
    0x65,
    0x00,
    0x2E,
    0x63,
    0x6F,
    0x6D,
    0x6D,
    0x65,
    0x6E,
    0x74,
    0x00,
    0x2E,
    0x73,
    0x79,
    0x6D,
    0x74,
    0x61,
    0x62,
    0x00,
    0x2E,
    0x73,
    0x68,
    0x73,
    0x74,
    0x72,
    0x74,
    0x61,
    0x62,
    0x00,
    0x2E,
    0x73,
    0x74,
    0x72,
    0x74,
    0x61,
    0x62,
    0x00,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6E,
    0x75,
    0x6D,
    0x5F,
    0x76,
    0x67,
    0x70,
    0x72,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6E,
    0x75,
    0x6D,
    0x5F,
    0x61,
    0x67,
    0x70,
    0x72,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6E,
    0x75,
    0x6D,
    0x62,
    0x65,
    0x72,
    0x65,
    0x64,
    0x5F,
    0x73,
    0x67,
    0x70,
    0x72,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x70,
    0x72,
    0x69,
    0x76,
    0x61,
    0x74,
    0x65,
    0x5F,
    0x73,
    0x65,
    0x67,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x75,
    0x73,
    0x65,
    0x73,
    0x5F,
    0x76,
    0x63,
    0x63,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x75,
    0x73,
    0x65,
    0x73,
    0x5F,
    0x66,
    0x6C,
    0x61,
    0x74,
    0x5F,
    0x73,
    0x63,
    0x72,
    0x61,
    0x74,
    0x63,
    0x68,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x68,
    0x61,
    0x73,
    0x5F,
    0x64,
    0x79,
    0x6E,
    0x5F,
    0x73,
    0x69,
    0x7A,
    0x65,
    0x64,
    0x5F,
    0x73,
    0x74,
    0x61,
    0x63,
    0x6B,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x68,
    0x61,
    0x73,
    0x5F,
    0x72,
    0x65,
    0x63,
    0x75,
    0x72,
    0x73,
    0x69,
    0x6F,
    0x6E,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x68,
    0x61,
    0x73,
    0x5F,
    0x69,
    0x6E,
    0x64,
    0x69,
    0x72,
    0x65,
    0x63,
    0x74,
    0x5F,
    0x63,
    0x61,
    0x6C,
    0x6C,
    0x00,
    0x61,
    0x6D,
    0x64,
    0x67,
    0x70,
    0x75,
    0x2E,
    0x6D,
    0x61,
    0x78,
    0x5F,
    0x6E,
    0x75,
    0x6D,
    0x5F,
    0x76,
    0x67,
    0x70,
    0x72,
    0x00,
    0x61,
    0x6D,
    0x64,
    0x67,
    0x70,
    0x75,
    0x2E,
    0x6D,
    0x61,
    0x78,
    0x5F,
    0x6E,
    0x75,
    0x6D,
    0x5F,
    0x61,
    0x67,
    0x70,
    0x72,
    0x00,
    0x61,
    0x6D,
    0x64,
    0x67,
    0x70,
    0x75,
    0x2E,
    0x6D,
    0x61,
    0x78,
    0x5F,
    0x6E,
    0x75,
    0x6D,
    0x5F,
    0x73,
    0x67,
    0x70,
    0x72,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x00,
    0x65,
    0x6D,
    0x70,
    0x74,
    0x79,
    0x5F,
    0x6B,
    0x65,
    0x72,
    0x6E,
    0x65,
    0x6C,
    0x2E,
    0x6B,
    0x64,
    0x00,
    0x5F,
    0x44,
    0x59,
    0x4E,
    0x41,
    0x4D,
    0x49,
    0x43,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x07,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4C,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x07,
    0x00,
    0x00,
    0x00,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x50,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x50,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x48,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x18,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0F,
    0x00,
    0x00,
    0x00,
    0xF6,
    0xFF,
    0xFF,
    0x6F,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x98,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x98,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x24,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x19,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xBC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xBC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x20,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x1F,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xDC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xDC,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x1E,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x27,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x2F,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x16,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x35,
    0x00,
    0x00,
    0x00,
    0x06,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x40,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x70,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x05,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x10,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x3E,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB0,
    0x2B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB0,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x50,
    0x04,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x4D,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB0,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x5C,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB0,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x71,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB0,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x14,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x7F,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC4,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x2A,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x8B,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x30,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xEE,
    0x0B,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x64,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x96,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x52,
    0x0C,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x99,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xA2,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xF0,
    0x0C,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x28,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xAF,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x30,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x18,
    0x0D,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x63,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xB8,
    0x00,
    0x00,
    0x00,
    0x02,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x80,
    0x0D,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x80,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x14,
    0x00,
    0x00,
    0x00,
    0x0E,
    0x00,
    0x00,
    0x00,
    0x08,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x18,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xC0,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x0F,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xD2,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xCA,
    0x00,
    0x00,
    0x00,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0xD2,
    0x0F,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x58,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
]


def test_f32_kernel():
    with tempfile.TemporaryDirectory() as temp_dir:
        print("temp_dir:", temp_dir)

        # write hsaco
        hsaco_file = os.path.join(temp_dir, "empty_kernel.hsaco")
        with open(hsaco_file, "wb") as f:
            f.write(bytes(aot_kernel0_hsaco))

        # write json
        json_file = os.path.join(temp_dir, "empty_kernel.json")
        with open(json_file, "w") as f:
            f.write(aot_kernel0_json)

        compile_args = CompileArgs(
            path=kernel_path,
            kernel_name="empty_kernel",
            signature=f"*fp32:16,1",
            grid="1,1,1",
            num_warps=4,
            num_stages=2,
            out_name="kernel_f32",
        )

        with AOTMetadataContext("empty_kernel", temp_dir):
            triton_kernel0, output_files0 = compile_kernel(compile_args)


def test_jit():
    with tempfile.TemporaryDirectory() as temp_dir:
        print("temp_dir:", temp_dir)

        # write hsaco
        hsaco_file = os.path.join(temp_dir, "empty_kernel.hsaco")
        with open(hsaco_file, "wb") as f:
            f.write(bytes(aot_kernel0_hsaco))

        # write json
        json_file = os.path.join(temp_dir, "empty_kernel.json")
        with open(json_file, "w") as f:
            f.write(aot_kernel0_json)

        @with_custom_metadata_path(temp_dir)
        @triton.jit
        def empty_kernel(x_ptr, SIZE: tl.constexpr):
            return

        x = torch.zeros((1, 1, 2), dtype=torch.float32, device="cuda")
        kernel = empty_kernel[(1, 1, 1)](x, SIZE=64)

        # check
        assert kernel.metadata.hash in aot_kernel0_json, "hash not found in json"


def test_separate_compile_and_run():
    with tempfile.TemporaryDirectory() as temp_dir:
        print("temp_dir:", temp_dir)

        # write hsaco
        hsaco_file = os.path.join(temp_dir, "empty_kernel.hsaco")
        with open(hsaco_file, "wb") as f:
            f.write(bytes(aot_kernel0_hsaco))

        # write json
        json_file = os.path.join(temp_dir, "empty_kernel.json")
        with open(json_file, "w") as f:
            f.write(aot_kernel0_json)

        @triton.jit
        def empty_kernel(x_ptr, SIZE: tl.constexpr):
            return

        # compile for kernel0
        target = GPUTarget("hip", "gfx942", 64)
        src = triton.compiler.ASTSource(
            fn=empty_kernel,
            signature={
                "x_ptr": "*fp32",
            },
            constexprs={"SIZE": 64},
        )
        with AOTMetadataContext("empty_kernel", temp_dir):
            kernel = triton.compile(src, target=target)

        # run kernel0
        x = torch.zeros((1, 1, 2), dtype=torch.float32, device="cuda")
        kernel[(1, 1, 1)](x)

        # check
        assert kernel.metadata.hash in aot_kernel0_json, "hash not found in json"

        # compile and run for kernel1
        # ...

        # compile and run for kernel2
        # ...


if __name__ == "__main__":
    test_f32_kernel()
    test_jit()
    test_separate_compile_and_run()
