import time
import json

try:
    import ingen_wrapper
    ingen_wrapper.start_send_thread()
except:
    pass

def change_local_presets(action):
    r_v = []
    with open("/git_repos/ample/ample_presets.json") as f:
        presets = json.load(f)
    for i in range(0,56):
        ingen_wrapper.set_json_nam("/main/neural_amp_modeler_lv2", presets[str(i)][0][2])
        ingen_wrapper.set_file("/main/CfgMono", "file://"+presets[str(i)][1][2], True)
        time.sleep(1)
        a = action(i)
        print(a)
        r_v.append(a)
    return r_v

class _Getch:
    """Gets a single character from standard input.  Does not echo to the
screen. From http://code.activestate.com/recipes/134892/"""
    def __init__(self):
        self.impl = _GetchUnix()
    def __call__(self): return self.impl()


class _GetchUnix:
    def __init__(self):
        import tty, sys, termios # import termios now or else you'll get the Unix version on the Mac
    def __call__(self):
        import sys, tty, termios
        fd = sys.stdin.fileno()
        old_settings = termios.tcgetattr(fd)
        try:
            tty.setraw(sys.stdin.fileno())
            ch = sys.stdin.read(1)
        finally:
            termios.tcsetattr(fd, termios.TCSADRAIN, old_settings)
        return ch

def getKey():
    inkey = _Getch()
    import sys
    for i in range(sys.maxsize):
        k=inkey()
        if k != '':
            break
    return k

def repeat_or_continue():
    print("test stage finished, enter for next, space to repeat, q to quit, f to mark as failed")
    k = getKey()
    if k == "\r":
        return False
    elif k == " ":
        return True
    elif k == "q":
        quit()
    elif k == "f":
        send_test_result(False)
        return True

def compare_change_local_presets(action=False):
    r_v = []
    with open("/git_repos/ample/ample_presets.json") as f:
        presets = json.load(f)
    with open("/git_repos/ample/with_cab_ample_presets.json") as f:
        cab_presets = json.load(f)
    for i in range(0,56):
        ingen_wrapper.set_json_nam("/main/neural_amp_modeler_lv2", presets[str(i)][0][2])
        ingen_wrapper.set_json_nam("/main/neural_amp_modeler_lv2_2", presets[str(i)][0][2][:-len(".nam")]+"_full_rig.nam")
        ingen_wrapper.set_file("/main/CfgMono", "file://"+cab_presets[str(i)][1][2], True)
        while repeat_or_continue():
            print("changing to amp+ir")
            ingen_wrapper.set_parameter_value("/main/wet_dry_stereo/xfade", -1.0)
            input()
            print("changing to full rig")
            ingen_wrapper.set_parameter_value("/main/wet_dry_stereo/xfade", 1.0)
        time.sleep(1)
        # a = action(i)
        # print(a)
        # r_v.append(a)
    return r_v
