import json, glob, os
from pathlib import Path
def gen_reverb_json(prefix, name, description, display_name, location=None, category=None):
    w_a = glob.glob(os.path.join(prefix, name, "**.wav"), recursive=True)
    w_b = glob.glob(os.path.join(prefix, name+"*.wav"), recursive=True)
    wavs = w_a + w_b
    f_a = glob.glob(os.path.join(prefix, name, "**.jp*g"), recursive=True)
    f_b = glob.glob(os.path.join(prefix, name+"*.jp*g"), recursive=True)
    f_i = f_a+f_b
    # name = Path(f_i[0]).stem
    # with open(f"{name}.json", "w") as f:
    obj = {"image": f_i[0] if len(f_i) > 0 else "", "files": sorted(wavs), "description": description, "display_name":display_name}
    if location is not None:
        obj["location"] = location
    if category is not None:
        obj["category"] = category
    return obj

a["EMT_140_plate"] =  gen_reverb_json("Analog Reverb Devices", "EMT_140_plate", """In 1957, EMT introduced the ’140’ Reverberation Unit, an electro-mechanical reverberation device that offered an alternative to the spring reverbs and echo chambers of the era. The EMT 140 used a 1 meter-tall by 2 meters-wide steel plate hinged within a wooden frame, which was coupled with a loudspeaker-like device that, when activated, produced bending sound waves with reverberation times adjustable between one and five seconds, which were captured by a microphone, whose signal was routed to the recording studio control room.""")

a["Adineko_Oil_Can"] =  gen_reverb_json("Analog Reverb Devices", "Adineko_Oil_Can", """The Fender Tel-Ray Adineko Echo-Reverb is oil can style delay reverb unit produced during the 50 and 60s. Instead of magnetic tape, these units house what appears to be a tuna can filled with oil which works as a dielectric, i.e. it can store a charge or signal.""")

a["BX20E1 AKG Spring"] =  gen_reverb_json("Analog Reverb Devices", "BX20E1 AKG Spring", """The AKG BX20 reverberation unit was produced in the late 1960s, and is one of the most popular spring reverb units ever made. It is a very large spring unit and sounds totally different to amp tanks.""")

a["Ecoplate"] =  gen_reverb_json("Analog Reverb Devices", "Ecoplate", """An American plate reverb, built in 1980 and designed to be smoother and brighter than the EMT 140.""")




