effect_type_maps = {"beebo" : {'ad_env_level': 'http://drobilla.net/plugins/omins/adenv_lvl',
    'ad_envelope': 'http://drobilla.net/plugins/omins/adenv',
    'adsr': 'http://drobilla.net/plugins/blop/adsr',
    'pitch_verb': 'http://polyeffects.com/lv2/polyclouds#oliverb',
    'amp_bass': 'http://guitarix.sourceforge.net/plugins/gx_ampegsvt_#_ampegsvt_',
    'attenuverter': 'http://drobilla.net/plugins/blop/product',
    'auto_swell': 'http://guitarix.sourceforge.net/plugins/gx_slowgear_#_slowgear_',
    'bitmangle': 'http://polyeffects.com/lv2/polywarps#bitcrusher',
    'chaos_controller': 'http://polyeffects.com/lv2/polymarbles',
    'chorus_d': 'http://polyeffects.com/lv2/chorus',
    'chorus_d_ext': 'http://polyeffects.com/lv2/chorus_ext',
    'cv_to_midi_cc': 'http://polyeffects.com/lv2/cv_to_cc',
    'dahdsr': 'http://drobilla.net/plugins/blop/dahdsr',
    'delay': 'http://polyeffects.com/lv2/digit_delay',
    'difference': 'http://polyeffects.com/lv2/basic_modular#difference',
    'diode_ladder_lpf': 'http://polyeffects.com/lv2/polyfilter#diode_ladder',
    'doppler_panner': 'http://polyeffects.com/lv2/polywarps#doppler',
    'drum_patterns': 'http://polyeffects.com/lv2/polygrids',
    'env_follower': 'http://ssj71.github.io/infamousPlugins/plugs.html#envfollowerCV',
    'filter': 'http://drobilla.net/plugins/fomp/mvclpf1',
    'flanger': 'http://polyeffects.com/lv2/flanger',
    'flanger_ext': 'http://polyeffects.com/lv2/flanger_ext',
    'foot_switch_a': 'http://polyeffects.com/lv2/polyfoot',
    'foot_switch_b': 'http://polyeffects.com/lv2/polyfoot',
    'foot_switch_c': 'http://polyeffects.com/lv2/polyfoot',
    'foot_switch_d': 'http://polyeffects.com/lv2/polyfoot',
    'foot_switch_e': 'http://polyeffects.com/lv2/polyfoot',
    'freeze': 'http://ssj71.github.io/infamousPlugins/plugs.html#stuck',
    'granular': 'http://polyeffects.com/lv2/polyclouds#granular',
    'harmonic_trem_ext': 'http://polyeffects.com/lv2/harm_trem_ext',
    'harmonic_tremolo': 'http://polyeffects.com/lv2/harm_trem',
    'chorus_j': 'https://chrisarndt.de/plugins/ykchorus',
    'k_org_hpf': 'http://polyeffects.com/lv2/polyfilter#korg_hpf',
    'k_org_lpf': 'http://polyeffects.com/lv2/polyfilter#korg_lpf',
    'lfo': 'http://avwlv2.sourceforge.net/plugins/avw/lfo_tempo',
    'granular_looping': 'http://polyeffects.com/lv2/polyclouds#looping_delay',
    'macro_osc': 'http://polyeffects.com/lv2/polyplaits',
    'max': 'http://polyeffects.com/lv2/basic_modular#max',
    'meta_modulation': 'http://polyeffects.com/lv2/polywarps#meta',
    'midi_cc': 'http://github.com/blablack/midimsg-lv2/controller',
    'midi_clock_in': 'http://polyeffects.com/lv2/mclk_in',
    'midi_clock_out': 'http://gareus.org/oss/lv2/mclk',
    'midi_note_to_cv': 'http://polyeffects.com/lv2/midi_to_cv_mono',
    'min': 'http://polyeffects.com/lv2/basic_modular#min',
    'mix_vca': 'http://avwlv2.sourceforge.net/plugins/avw/vcaexp_audio',
    'mono_EQ': 'http://gareus.org/oss/lv2/fil4#mono',
    'short_mono_cab': 'http://polyeffects.com/lv2/polyconvo#CabMono',
    'mono_cab': 'http://gareus.org/oss/lv2/zeroconvolv#CfgMono',
    'mono_compressor': 'http://gareus.org/oss/lv2/darc#mono',
    'mono_reverb': 'http://polyeffects.com/lv2/polyconvo#Mono',
    'multi_resonator': 'http://polyeffects.com/lv2/polyrings',
    'onset_detect': 'http://polyeffects.com/lv2/detect#onset',
'oog_half_lpf': 'http://polyeffects.com/lv2/polyfilter#moog_half_ladder',
     'pan': 'http://avwlv2.sourceforge.net/plugins/avw/vcpanning',
     'phaser': 'http://jpcima.sdf1.org/lv2/stone-phaser',
     'phaser_ext': 'http://polyeffects.com/lv2/stone-phaser-ext',
     'phaser_stereo_ext': 'http://polyeffects.com/lv2/stone-phaser-stereo-ext',
     'pitch_detect': 'http://polyeffects.com/lv2/detect#pitch',
     'pitch_shift': 'http://moddevices.com/plugins/tap/pitch',
     'poly_note_to_cv': 'http://polyeffects.com/lv2/midi_to_cv_poly',
     'power_amp_cream': 'http://guitarix.sourceforge.net/plugins/gx_CreamMachine_#_CreamMachine_',
     'power_amp_super': 'http://guitarix.sourceforge.net/plugins/gx_supersonic_#_supersonic_',
     'product': 'http://polyeffects.com/lv2/basic_modular#product',
     'quad_ir_cab': 'http://polyeffects.com/lv2/polyconvo#CabStereo',
     'quad_ir_reverb': 'http://gareus.org/oss/lv2/zeroconvolv#CfgStereo',# VERBS
     'short_quad_ir_reverb': 'http://polyeffects.com/lv2/polyconvo#Stereo',
     'quantizer': 'http://polyeffects.com/lv2/basic_quantizer',
     'ratio': 'http://polyeffects.com/lv2/basic_modular#ratio',
     'rectify_value': 'http://polyeffects.com/lv2/basic_modular#abs',
     'resonestor': 'http://polyeffects.com/lv2/polyclouds#resonestor',
     'reverse': 'http://moddevices.com/plugins/tap/reflector',
     'rotary': 'http://gareus.org/oss/lv2/b_whirl#simple',
     'rotary_advanced': 'http://gareus.org/oss/lv2/b_whirl#extended',
     'sample_hold': 'http://avwlv2.sourceforge.net/plugins/avw/samplehold',
     'saturator': 'http://moddevices.com/plugins/tap/sigmoid',
     'slew_limiter': 'http://avwlv2.sourceforge.net/plugins/avw/slew',
     'step_sequencer': 'http://polyeffects.com/lv2/step_sequencer_bpm',
     'step_sequencer_ext': 'http://polyeffects.com/lv2/step_sequencer',
     'stereo_EQ': 'http://gareus.org/oss/lv2/fil4#stereo',
     'stereo_cab': 'http://polyeffects.com/lv2/polyconvo#CabMonoToStereo',
     'stereo_compress': 'http://gareus.org/oss/lv2/darc#stereo',
     'stereo_phaser': 'http://jpcima.sdf1.org/lv2/stone-phaser-stereo',
     'stereo_reverb': 'http://gareus.org/oss/lv2/zeroconvolv#CfgMonoToStereo',
     'short_stereo_reverb': 'http://polyeffects.com/lv2/polyconvo#MonoToStereo',
     'sum': 'http://polyeffects.com/lv2/basic_modular#sum',
     'tempo_ratio': 'http://polyeffects.com/lv2/basic_modular#tempo_ratio',
     'thruzero_flange': 'http://drobilla.net/plugins/mda/ThruZero',
     'time_stretch': 'http://polyeffects.com/lv2/polyclouds#stretch',
     'toggle': 'http://polyeffects.com/lv2/basic_modular#toggle',
     'turntable_stop': 'http://ssj71.github.io/infamousPlugins/plugs.html#powercut',
     'twist_delay': 'http://polyeffects.com/lv2/polywarps#delay',
     'filter_uberheim': 'http://polyeffects.com/lv2/polyfilter#oberheim',
     'vca': 'http://polyeffects.com/lv2/basic_modular#amp',
     'vibrato': 'http://polyeffects.com/lv2/vibrato',
     'vibrato_ext': 'http://polyeffects.com/lv2/vibrato_ext',
     'warmth': 'http://moddevices.com/plugins/tap/tubewarmth',
     'wavefolder': 'http://polyeffects.com/lv2/polywarps#fold',
     'wet_dry': 'http://polyeffects.com/lv2/wet_dry',
     'wet_dry_stereo': 'http://polyeffects.com/lv2/wet_dry_stereo',
     'loop_common_out': 'http://polyeffects.com/lv2/loop_common_out',
     'loop_common_in': 'http://polyeffects.com/lv2/loop_common_in',
     'loop_extra_midi': 'http://polyeffects.com/lv2/loop_extra_midi',
     'loop_midi_out': 'http://polyeffects.com/lv2/loop_midi_out',
     'cv_to_trigger': 'http://polyeffects.com/lv2/basic_modular#schmitt',
     'euclidean': 'http://polyeffects.com/lv2/euclidean',
     'looping_envelope': 'http://polyeffects.com/lv2/polytides',
     'cv_meter': 'http://moddevices.com/plugins/mod-devel/mod-cv-meter',
     'pitch_cal_in': 'http://polyeffects.com/lv2/pitch_cal#in',
     'pitch_cal_out': 'http://polyeffects.com/lv2/pitch_cal#out',
     'basic_reverb': 'http://distrho.sf.net/plugins/MVerb',
     'cv_to_note': 'http://polyeffects.com/lv2/cv_to_note',
     'vinyl': 'http://calf.sourceforge.net/plugins/Vinyl',
     'note_sequencer': 'http://polyeffects.com/lv2/note_sequencer_bpm',
     'note_sequencer_ext': 'http://polyeffects.com/lv2/note_sequencer',
     'bitcrushed_delay': 'http://polyeffects.com/lv2/bitcrushed_delay',
     'bitcrusher': 'http://polyeffects.com/lv2/bitcrusher',
     'midi_cc_to_note': 'http://gareus.org/oss/lv2/midifilter#cctonote',
     'midi_channel_filter': 'http://gareus.org/oss/lv2/midifilter#channelfilter',
     'midi_channel_map': 'http://gareus.org/oss/lv2/midifilter#channelmap',
     'midi_choke_filter': 'http://gareus.org/oss/lv2/midifilter#chokefilter',
     'midi_chord': 'http://gareus.org/oss/lv2/midifilter#midichord',
     'midi_delay': 'http://gareus.org/oss/lv2/midifilter#mididelay',
     'midi_dup': 'http://gareus.org/oss/lv2/midifilter#mididup',
     'midi_enforce_scale': 'http://gareus.org/oss/lv2/midifilter#enforcescale',
     'midi_event_blocker': 'http://gareus.org/oss/lv2/midifilter#eventblocker',
     'midi_keyrange': 'http://gareus.org/oss/lv2/midifilter#keyrange',
     'midi_keysplit': 'http://gareus.org/oss/lv2/midifilter#keysplit',
     'midi_map_key_channel': 'http://gareus.org/oss/lv2/midifilter#mapkeychannel',
     'midi_map_key_scale': 'http://gareus.org/oss/lv2/midifilter#mapkeyscale',
     'midi_mapcc': 'http://gareus.org/oss/lv2/midifilter#mapcc',
     'midi_mono_legato': 'http://gareus.org/oss/lv2/midifilter#monolegato',
     'midi_no_active_sensing': 'http://gareus.org/oss/lv2/midifilter#noactivesensing',
     'midi_nodup': 'http://gareus.org/oss/lv2/midifilter#nodup',
     'midi_note_to_cc': 'http://gareus.org/oss/lv2/midifilter#notetocc',
     'midi_note_to_pgm': 'http://gareus.org/oss/lv2/midifilter#notetopgm',
     'midi_note_toggle': 'http://gareus.org/oss/lv2/midifilter#notetoggle',
     'midi_ntap_delay': 'http://gareus.org/oss/lv2/midifilter#ntapdelay',
     'midi_one_channel_filter': 'http://gareus.org/oss/lv2/midifilter#onechannelfilter',
     'midi_quantize': 'http://gareus.org/oss/lv2/midifilter#quantize',
     'midi_rand_velocity': 'http://gareus.org/oss/lv2/midifilter#randvelocity',
     'midi_scale_cc': 'http://gareus.org/oss/lv2/midifilter#scalecc',
     'midi_sostenuto': 'http://gareus.org/oss/lv2/midifilter#sostenuto',
     'midi_strum': 'http://gareus.org/oss/lv2/midifilter#midistrum',
     'midi_tonal_pedal': 'http://gareus.org/oss/lv2/midifilter#tonalpedal',
     'midi_transpose': 'http://gareus.org/oss/lv2/midifilter#miditranspose',
     'midi_velocity_gamma': 'http://gareus.org/oss/lv2/midifilter#velocitygamma',
     'midi_velocity_range': 'http://gareus.org/oss/lv2/midifilter#velocityrange',
     'midi_velocity_scale': 'http://gareus.org/oss/lv2/midifilter#velocityscale',
     'matrix_mixer': 'http://gareus.org/oss/lv2/matrixmixer#i4o3',
     'tuner': 'http://gareus.org/oss/lv2/tuna#mod',
     "trigger_to_gate": 'http://polyeffects.com/lv2/basic_modular#trigger_to_gate',
     'clock_divider': 'http://polyeffects.com/lv2/basic_modular#clock_divider',
     "strum": 'http://polyeffects.com/lv2/strum',
     # 'amp_rtneural': 'http://aidadsp.cc/plugins/aidadsp-bundle/rt-neural-generic',
     'amp_nam': 'http://github.com/mikeoliphant/neural-amp-modeler-lv2',
    'midi_pc': 'http://polyeffects.com/lv2/midi_pc',
    'tonestack': 'http://polyeffects.com/lv2/poly_3_band_eq',
    'boost': 'http://polyeffects.com/lv2/basic_modular#boost',
     }}

# categories effect, IO, control, synth, 

effect_prototypes_models_all = {'ad_env_level': {'category': 2,
                  'controls': {'attack': ['Attack Time', 0.5, 0, 5],
                               'attack_level': ['Attack to Level', 1, 0, 1],
                               'decay': ['Decay Time', 0.5, 0, 5],
                               'decay_level': ['Decay to Level', 0, 0, 1],
                               'init_level': ['Initial Level', 0, 0, 1]},
                  'description': 'An attack decay envelope generator with '
                                 'start and end levels. Works with a trigger.',
                  'inputs': {'gate': ['Gate', 'CVPort'],
                             'reset_level': ['Reset Level', 'CVPort'],
                             'trigger': ['Trigger', 'CVPort']},
                  'long_description': 'Envelopes take in a  trigger and '
                                      'produce a CV that changes over time.\n'
                                      '                  This version has just '
                                      '2 stages, attack and decay. Connect '
                                      'triggers to the envelope and then '
                                      'connect the envelope output to the '
                                      'parameter you want to change over '
                                      'time.\n'
                                      '                  This version adds a '
                                      'level to attack to and then decay to '
                                      'compared to the standard version.',
                  'outputs': {'out': ['Envelope Out', 'CVPort']},
                  'tags': {'cv generators'},
                  'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=94s'},
 'ad_envelope': {'category': 2,
                 'controls': {'attack': ['Attack Time', 0.5, 0, 5],
                              'decay': ['Decay Time', 0.5, 0, 5]},
                 'description': 'A attack decay envelope generator. Works with '
                                'a trigger.',
                 'inputs': {'port0': ['Gate', 'CVPort'],
                            'trigger': ['Trigger', 'CVPort']},
                 'long_description': 'Envelopes take in a trigger and produce '
                                     'a CV that changes over time.\n'
                                     '                  This version has just '
                                     '2 stages, attack and decay. Connect '
                                     'triggers to the envelope and then '
                                     'connect the envelope output to the '
                                     'parameter you want to change over time.\n'
                                     '                  This version attacks '
                                     'to 1 from 0.',
                 'outputs': {'out': ['Envelope Out', 'CVPort']},
                 'tags': {'cv generators'},
                 'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=94s'},
 'adsr': {'category': 2,
          'controls': {'attack': ['Attack Time', 0.5, 0, 5.0],
                       'decay': ['Decay Time', 0.5, 0, 5.0],
                       'release': ['Release Time', 0.5, 0, 5.0],
                       'sustain': ['Sustain Level', 1, 0, 1],
                       'thresh': ['Trigger Threshold', 0.4, 0.06, 1.0]},
          'description': 'Basic ADSR envelope generator. Takes in a gate.',
          'inputs': {'drive': ['Gate', 'CVPort']},
          'long_description': 'Envelopes take in a gate and produce a CV that '
                              'changes over time.\n'
                              '                  This version has 4 stages, '
                              'attack, decay, sustain and release. Connect '
                              'gates to the envelope and then connect the '
                              'envelope output to the parameter you want to '
                              'change over time.\n'
                              '                  This is an important part of '
                              'a synthesiser but can also be used to create '
                              'things like autoswells. Useful when connected '
                              'to a VCA.',
          'outputs': {'out': ['Envelope Out', 'CVPort']},
          'tags': {'cv generators'},
          'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=294s'},
 'amp_bass': {'category': 0,
              'controls': {'BASS': ['BASS', 0.5, 0.0, 1.0],
                           'CABSWITCH': ['CABSWITCH', 0.0, 0.0, 1.0, 'bool'],
                           'HIGHSWITCH': ['HIGHSWITCH', 0.0, 0.0, 1.0, 'bool'],
                           'LOWSWITCH': ['LOWSWITCH', 1.0, 0.0, 2.0, 'int'],
                           'MIDDLE': ['MIDDLE', 0.5, 0.0, 1.0],
                           'MIDSWITCH': ['MIDSWITCH', 1.0, 0.0, 2.0, 'int'],
                           'TREBLE': ['TREBLE', 0.5, 0.0, 1.0],
                           'VOLUME': ['VOLUME', 0.2, 0.0, 1.0]},
              'description': 'SVT40 bass amp sim',
              'inputs': {'in': ['In', 'AudioPort']},
              'long_description': 'A bass amp emulation. The tone stack has '
                                  'sections that can be tuned. Run a cab after '
                                  'this.',
              'outputs': {'out': ['Out', 'AudioPort']},
              'tags': {'amps, cabs + gain'},
              'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=575s'},
 'amp_nam': {'category': 0,
             'controls': {'input_level': ['Input Lvl', -25.0, -45.0, 5.0],
                          'ir': ['/audio/amp_nam/tone_king_gremlin/tone_king-gremlin-volume_mid-channel_lead.nam',
                                 0,
                                 0,
                                 1],
                          'output_level': ['Output Lvl', 0.0, -20.0, 20.0]},
             'description': 'Amp Model Player, allowing it to load models of '
                            'AI trained music gear',
             'inputs': {'input': ['Input', 'AudioPort']},
             'long_description': 'Using Neural Amp Modeler (NAM) code.',
             'outputs': {'output': ['Output', 'AudioPort']},
             'tags': {'amps, cabs + gain'},
             'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=60s'},
 'attenuverter': {'category': 2,
                  'controls': {'multiplicand': ['A', 0.5, -1.0, 1.0],
                               'multiplier': ['B', 0.5, -1.0, 1.0]},
                  'description': 'The attenuverter changes level and/or phase '
                                 'of a control signal. A x B',
                  'inputs': {'multiplicand': ['A', 'CVPort'],
                             'multiplier': ['B', 'CVPort']},
                  'long_description': 'An attenuverter attenuates and inverts '
                                      'signals.\n'
                                      '                  You can combine '
                                      'signals using it, for example to ring '
                                      'modulate two LFOs together, or just '
                                      'reduce the level of a CV',
                  'outputs': {'product': ['Product', 'CVPort']},
                  'tags': {'utilities'},
                  'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=710s'},
 'auto_swell': {'category': 0,
                'controls': {'DOWNTIME': ['DOWNTIME', 5.0, 0.0, 5000],
                             'TRESHOLD': ['THRESHOLD', 1.0, 0.0, 1],
                             'UPTIME': ['UPTIME', 100, 0.0, 5000]},
                'description': 'Automatically swells volume to remove note '
                               'attack',
                'inputs': {'TRESHOLD': ['THRESHOLD', 'CVPort'],
                           'in': ['In', 'AudioPort']},
                'long_description': 'Auto swell is a similar effect to using '
                                    'your volume knob but instead it '
                                    'automatically detects when to swell.If '
                                    'you are looking for something more '
                                    'complex, you can combine an envelope '
                                    'follower and VCA to create your own',
                'outputs': {'out': ['Out', 'AudioPort']},
                'tags': {'level + dynamics'},
                'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=940s'},
 'basic_reverb': {'category': 0,
                  'controls': {'bandwidth': ['Bandwidth', 50, 0, 100],
                               'damping': ['Damping', 50, 0, 100],
                               'decay': ['Decay', 50, 0, 100],
                               'density': ['Density', 50, 0, 100],
                               'earlymix': ['Early vs Late', 50, 0, 100],
                               'gain': ['Gain', 100, 0, 100],
                               'mix': ['Mix', 50, 0, 100],
                               'predelay': ['Predelay', 50, 0, 100],
                               'size': ['Size', 75, 5, 100]},
                  'description': 'A basic true stereo algorthmic reverb.',
                  'inputs': {'lv2_audio_in_1': ['L Input', 'AudioPort'],
                             'lv2_audio_in_2': ['R Input', 'AudioPort']},
                  'long_description': '',
                  'outputs': {'lv2_audio_out_1': ['L Output', 'AudioPort'],
                              'lv2_audio_out_2': ['R Output', 'AudioPort']},
                  'tags': {'time effects'},
                  'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=1285s'},
 'bitcrushed_delay': {'broadcast_ports': {'BPM_0': ['tempo', 120, 1, 320]},
                      'category': 0,
                      'controls': {'Amp_6': ['Level', 0.5, 0, 1],
                                   'BPM_1': ['BPM', 120, 30, 300],
                                   'DelayT60_4': ['Glide', 0.5, 0, 100],
                                   'Delay_2': ['Time', 0.5, 0.001, 64],
                                   'FeedbackSm_7': ['Tone', 0, 0, 1],
                                   'Feedback_5': ['Feedback', 0.3, 0, 1],
                                   'NBITS_0': ['Bits', 8, 1, 16],
                                   'Warp_3': ['Warp', 0, -1, 1],
                                   'enabled': ['Enabled', 1, 0, 1],
                                   'is_using_tempo': ['is_using_tempo',
                                                      0,
                                                      0,
                                                      1]},
                      'description': 'Flexible delay module with bitcrushed '
                                     'repeats. Add modules on the repeats for '
                                     'variations.',
                      'inputs': {'Amp_5': ['Level', 'CVPort'],
                                 'BPM_0': ['BPM', 'ControlPort'],
                                 'DelayT60_3': ['Glide', 'CVPort'],
                                 'Delay_1': ['Time', 'CVPort'],
                                 'FeedbackSm_6': ['Tone', 'CVPort'],
                                 'Feedback_4': ['Feedback', 'CVPort'],
                                 'Warp_2': ['Warp', 'CVPort'],
                                 'in0': ['in', 'AudioPort']},
                      'kill_dry': True,
                      'long_description': '',
                      'outputs': {'out0': ['out', 'AudioPort']},
                      'tags': {'time effects'},
                      'video_url': ''},
 'bitcrusher': {'category': 0,
                'controls': {'bits': ['bits', 8, 1, 16]},
                'description': 'basic bit reduction bit crusher, CV control of '
                               'bits.',
                'inputs': {'in': ['in', 'AudioPort'],
                           'num_bit_cv': ['bits_cv', 'CVPort']},
                'long_description': '',
                'outputs': {'out': ['out', 'AudioPort']},
                'tags': {'amps, cabs + gain'},
                'video_url': ''},
 'bitmangle': {'category': 0,
               'controls': {'bits': ['bits', 0.0, 0.0, 3.0],
                            'input_amp': ['amp or freq', 0.04, 0.0, 1.0],
                            'input_amp_2': ['input amplitude 2',
                                            0.15,
                                            0.0,
                                            1.0],
                            'int_osc': ['int_osc', 0.0, 0.0, 3.0],
                            'xor_vs_and': ['xor vs and', 0.5, 0.0, 1.0],
                             'enabled': ['Enabled', 1, 0, 1],
                             },
                # 'kill_dry': True,
               'description': 'Brutal bitmangler. Warning, can get very loud. '
                              'Based on Mutable Instuments Warps Parasite.',
               'inputs': {'bit_cv': ['bit cv', 'CVPort'],
                          'carrier': ['carrier', 'AudioPort'],
                          'input_amp_2_cv': ['input_amp_2_cv', 'CVPort'],
                          'input_amp_cv': ['input_amp_cv', 'CVPort'],
                          'modulator': ['modulator', 'AudioPort'],
                          'xor_vs_and_cv': ['xor vs and cv', 'CVPort']},
               'long_description': "The bit mangler isn't a normal bit "
                                   'crusher, instead it degredation and cross '
                                   'modulationthe bitwise AND is much louder '
                                   'than the bitwise XOR end, so I recommend a '
                                   'compressor or something aftwards to '
                                   'control levels.',
               'manual_url': 'https://mqtthiqs.github.io/parasites/warps.html',
               'outputs': {'aux': ['aux', 'AudioPort'],
                           'out': ['out', 'AudioPort']},
               'tags': {'amps, cabs + gain', 'ported'},
               'video_url': 'https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=1626s'},
 'chaos_controller': {'broadcast_ports': {'t_rate_param': ['T Clock BPM',
                                                           120,
                                                           5,
                                                           840]},
                      'category': 2,
                      'controls': {'deja_vu_length_param': ['Deja Vu Length',
                                                            0,
                                                            0.0,
                                                            1.0],
                                   'deja_vu_param': ['Deja Vu Probablity',
                                                     0.5,
                                                     0.0,
                                                     1.0],
                                   'external_param': ['External Control',
                                                      0,
                                                      0.0,
                                                      1.0,
                                                      'bool'],
                                   't_bias_param': ['T Gate Bias',
                                                    0.5,
                                                    0.0,
                                                    1.0],
                                   't_deja_vu_param': ['T Deja Vu',
                                                       0,
                                                       0.0,
                                                       1.0],
                                   't_jitter_param': ['T Jitter', 0, 0.0, 1.0],
                                   't_mode_param': ['T Mode', 0, 0.0, 2.0],
                                   't_range_param': ['T Range', 0, 0.0, 2.0],
                                   't_rate_param': ['T Clock BPM',
                                                    120,
                                                    5.0,
                                                    840.0],
                                   'x_bias_param': ['X Distribution Bias',
                                                    0.5,
                                                    0.0,
                                                    1.0],
                                   'x_clock_source_internal': ['X Clock Source '
                                                               'Internal',
                                                               0,
                                                               0.0,
                                                               3.0],
                                   'x_deja_vu_param': ['X Deja Vu',
                                                       0,
                                                       0.0,
                                                       1.0],
                                   'x_mode_param': ['X Mode', 0, 0.0, 2.0],
                                   'x_range_param': ['X Range', 0, 0.0, 2.0],
                                   'x_scale': ['X Scale', 0, 0.0, 5.0],
                                   'x_spread_param': ['X Spread', 0, 0.0, 1.0],
                                   'x_steps_param': ['X Smoothness Steps',
                                                     0.5,
                                                     0.0,
                                                     1.0],
                                   'y_bias_param': ['Y Distribution Bias',
                                                    0.5,
                                                    0.0,
                                                    1.0],
                                   'y_divider': ['Y Divider', 0, 0.0, 12.0],
                                   'y_spread_param': ['Y Spread',
                                                      0.0,
                                                      0.0,
                                                      1.0],
                                   'y_steps_param': ['Y Smoothness',
                                                     0.5,
                                                     0.0,
                                                     1.0]},
                      'description': 'Powerful repeatable randomness source. '
                                     'Based on Mutable Instruments Marbles '
                                     'module.',
                      'inputs': {'deja_vu_input': ['Deja Vu Input', 'CVPort'],
                                 't_bias_input': ['T Bias Input', 'CVPort'],
                                 't_clock_input': ['T Clock Trigger Input',
                                                   'CVPort'],
                                 't_jitter_input': ['T Jitter Input', 'CVPort'],
                                 't_rate_input': ['T Rate Input', 'CVPort'],
                                 't_rate_param': ['BPM T Clock', 'ControlPort'],
                                 'x_bias_input': ['X Bias Input', 'CVPort'],
                                 'x_clock_input': ['X Clock Input', 'CVPort'],
                                 'x_spread_input': ['X Spread Input', 'CVPort'],
                                 'x_steps_input': ['X Steps Input', 'CVPort']},
                      'long_description': 'A source of random gates and '
                                          'voltages, which offers an extensive '
                                          'amount of (voltage) control on all '
                                          'the different flavors of randomness '
                                          'it produces. The module gives the '
                                          'musician many different ways of '
                                          'imposing structure on the random '
                                          'events generated by the module: '
                                          'synchronization to external clocks, '
                                          'control of the repetition or '
                                          'novelty of the generated material, '
                                          'quantization of the voltages, or '
                                          'randomization of gates or voltages '
                                          'generated by traditional '
                                          'sequencers.',
                      'manual_url': 'https://www.mutable-instruments.net/modules/marbles/manual/',
                      'outputs': {'t1_output': ['T1 Output', 'CVPort'],
                                  't2_output': ['T2 Output', 'CVPort'],
                                  't3_output': ['T3 Output', 'CVPort'],
                                  'x1_output': ['X1 Output', 'CVPort'],
                                  'x2_output': ['X2 Output', 'CVPort'],
                                  'x3_output': ['X3 Output', 'CVPort'],
                                  'y_output': ['Y Output', 'CVPort']},
                      'tags': {'cv generators', 'ported'},
                      'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=146s'},
 'chorus_d': {'broadcast_ports': {'BPM_1': ['tempo', 120, 1, 320]},
              'category': 0,
              'controls': {'BPM_1': ['BPM', 30, 10.01, 420],
                           'Delay_0': ['Delay', 0.5, 0, 1],
                           'Depth_3': ['Depth', 0.5, 0, 1],
                           'Deviation_4': ['Deviation', 0.5, 0, 1]},
              'description': '8 voice multi dimensional chorus',
              'inputs': {'BPM_1': ['BPM', 'ControlPort'],
                         'in0': ['in', 'AudioPort']},
              'long_description': '',
              'outputs': {'out0': ['out L', 'AudioPort'],
                          'out1': ['out R', 'AudioPort']},
              'tags': {'mod effects'},
              'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=1316s'},
 'chorus_d_ext': {'category': 0,
                  'controls': {'Delay_0': ['Delay', 0.5, 0, 1],
                               'Depth_1': ['Depth', 0.5, 0, 1],
                               'Deviation_2': ['Deviation', 0.5, 0, 1]},
                  'description': '8 voice multi dimensional chorus CV LFO',
                  'inputs': {'in0': ['in', 'AudioPort'],
                             'in1': ['LFO CV', 'CVPort']},
                  'long_description': '',
                  'outputs': {'out0': ['out L', 'AudioPort'],
                              'out1': ['out R', 'AudioPort']},
                  'tags': {'mod effects'},
                  'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=1358s'},
 'chorus_j': {'category': 0,
              'controls': {'chorus_1_enable': ['Chorus 1 On/Off',
                                               1.0,
                                               0.0,
                                               1.0,
                                               'bool'],
                           'chorus_1_lfo_rate': ['Chorus 1 LFO Rate',
                                                 5.0,
                                                 0.1,
                                                 10.0],
                           'chorus_2_enable': ['Chorus 2 On/Off',
                                               0.0,
                                               0.0,
                                               1.0,
                                               'bool'],
                           'chorus_2_lfo_rate': ['Chorus 2 LFO Rate',
                                                 8.3,
                                                 0.1,
                                                 10.0]},
              'description': 'chorus based on vintage Japanese synth chorus',
              'inputs': {'chorus_1_enable': ['1 Enable', 'CVPort'],
                         'chorus_2_enable': ['2 Enable', 'CVPort'],
                         'lv2_audio_in_1': ['Audio Input 1', 'AudioPort'],
                         'lv2_audio_in_2': ['Audio Input 2', 'AudioPort']},
              'long_description': '',
              'outputs': {'lv2_audio_out_1': ['Audio Output 1', 'AudioPort'],
                          'lv2_audio_out_2': ['Audio Output 2', 'AudioPort']},
              'tags': {'mod effects'},
              'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=1520s'},
 'clock_divider': {'category': 0,
                   'controls': {'divider': ['Divider', 1, 1, 24, 'int']},
                   'description': 'outputs a trigger every n triggers',
                   'inputs': {'in': ['trigger input', 'CVPort']},
                   'long_description': 'useful for dividing down a eurorack '
                                       'style clock.',
                   'outputs': {'out': ['trigger out', 'CVPort']},
                   'tags': {'cv generators'},
                   'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=1745s'},
 'cv_meter': {'broadcast_ports': {'level': ['level', 0, -2.0, 2.0],
                                  'max_level': ['Max Level', 0, -2.0, 2.0],
                                  'min_level': ['Min Level', 0, -2.0, 2.0]},
              'category': 0,
              'controls': {'PluginEnabled': ['Enabled', 1.0, 0.0, 1.0],
                           'Reset': ['Reset', 0.0, 0.0, 1.0]},
              'description': 'Simple CV meter that shows instant values with '
                             'no smoothing',
              'inputs': {'CvInput': ['CV input', 'CVPort']},
              'long_description': '',
              'outputs': {'CvOutput': ['CV Output', 'CVPort']},
              'tags': {'utilities'},
              'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=2194s'},
 'cv_to_midi_cc': {'category': 1,
                   'controls': {'CC_NUM': ['CC Number', 0, 0, 127, 'int'],
                                'CHAN': ['Channel', 1, 1, 16, 'int'],
                                'RESOLUTION': ['resolution', 0.01, 1e-05, 1]},
                   'description': 'convert control to MIDI CC',
                   'inputs': {'CV_IN': ['CV In', 'CVPort']},
                   'long_description': '',
                   'outputs': {'MIDI_OUT': ['MIDI Out', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=2245s'},
 'cv_to_note': {'category': 0,
                'controls': {'chan': ['Channel', 1, 1, 16],
                             'note_offset': ['note offset', 0, -60, 60]},
                'description': 'converted v/oct pitch to MIDI notes. Velocity '
                               'is optional.',
                'inputs': {'gate_in': ['Gate', 'CVPort'],
                           'pitch_in': ['Pitch', 'CVPort'],
                           'velocity_in': ['Velocity', 'CVPort']},
                'long_description': 'If velocity is not connected, 64 is sent '
                                    'for velocity. Note offset is +- from note '
                                    '60',
                'outputs': {'midi_out': ['MIDI note Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=2520s'},
 'cv_to_trigger': {'category': 0,
                   'controls': {},
                   'description': 'A Schmitt trigger that converts external '
                                  'analog CV to digital on / off trigger',
                   'inputs': {'trigger': ['Trigger', 'CVPort']},
                   'long_description': '',
                   'outputs': {'out': ['Out Trigger', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=2620s'},
 'dahdsr': {'category': 2,
            'controls': {'attack': ['Attack Time', 0.5, 0, 5.0],
                         'decay': ['Decay Time', 0.5, 0, 5.0],
                         'delay': ['Delay Time', 0.1, 0, 5.0],
                         'hold': ['Hold Time', 0.5, 0, 5.0],
                         'release': ['Release Time', 0.5, 0, 5.0],
                         'sustain': ['Sustain Level', 1, 0, 1]},
            'description': 'A delay attack hold decay sustain release envelope '
                           'generator',
            'inputs': {'attack': ['Attack Time', 'CVPort'],
                       'decay': ['Decay Time', 'CVPort'],
                       'delay': ['Delay Time', 'CVPort'],
                       'gate': ['Gate', 'CVPort'],
                       'hold': ['Hold Time', 'CVPort'],
                       'release': ['Release Time', 'CVPort'],
                       'sustain': ['Sustain Level', 'CVPort'],
                       'trigger': ['Trigger', 'CVPort']},
            'long_description': '',
            'outputs': {'out': ['Envelope Out', 'CVPort']},
            'tags': {'cv generators'},
            'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=3015s'},
 'delay': {'broadcast_ports': {'BPM_0': ['tempo', 120, 1, 320]},
           'category': 0,
           'controls': {'Amp_5': ['Level', 0.5, 0, 1],
                        'BPM_0': ['BPM', 120, 30, 300],
                        'DelayT60_3': ['Glide', 0.5, 0, 100],
                        'Delay_1': ['Time', 0.5, 0.001, 64],
                        'FeedbackSm_6': ['Tone', 0, 0, 1],
                        'Feedback_4': ['Feedback', 0.3, 0, 1],
                        'Warp_2': ['Warp', 0, -1, 1],
                        'enabled': ['Enabled', 1, 0, 1],
                        'is_using_tempo': ['is_using_tempo', 0, 0, 1]},
           'description': 'Flexible delay module. Add modules on the repeats '
                          'for variations.',
           'inputs': {'Amp_5': ['Level', 'CVPort'],
                      'BPM_0': ['BPM', 'ControlPort'],
                      'DelayT60_3': ['Glide', 'CVPort'],
                      'Delay_1': ['Time', 'CVPort'],
                      'FeedbackSm_6': ['Tone', 'CVPort'],
                      'Feedback_4': ['Feedback', 'CVPort'],
                      'Warp_2': ['Warp', 'CVPort'],
                      'in0': ['in', 'AudioPort']},
           'kill_dry': True,
           'long_description': '',
           'outputs': {'out0': ['out', 'AudioPort']},
           'tags': {'time effects'},
           'video_url': 'https://www.youtube.com/watch?v=24a0UzbKCKk&t=3120s'},
 'difference': {'category': 2,
                'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
                'description': 'a - b for control signals',
                'inputs': {'a_cv': ['A CV', 'CVPort'],
                           'b_cv': ['B CV', 'CVPort']},
                'long_description': '',
                'outputs': {'out': ['Output', 'CVPort']},
                'tags': {'utilities'},
                'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=430s'},
 'diode_ladder_lpf': {'category': 3,
                      'controls': {'Q': ['Q', 1, 0.7072, 25],
                                   'cutoff': ['cutoff', 0.1, 0, 1]},
                      'description': 'A diode ladder low pass filter similar '
                                     'to the vintage Japanese designs',
                      'inputs': {'cutoff_cv': ['Cutoff CV', 'CVPort'],
                                 'in': ['in', 'AudioPort'],
                                 'q_cv': ['Q CV', 'CVPort']},
                      'long_description': '',
                      'outputs': {'out': ['out', 'AudioPort']},
                      'tags': {'pitch + synth'},
                      'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=547s'},
 'doppler_panner': {'category': 0,
                    'controls': {'lfo_amplitude': ['lfo_amplitude',
                                                   0.22,
                                                   0.0,
                                                   1.0],
                                 'lfo_frequency': ['lfo_frequency',
                                                   0.11,
                                                   0.0,
                                                   1.0],
                                 'space_size': ['space_size', 2.0, 0.0, 3.0],
                                 'x_coord': ['x coordinate', 4.45, 0.0, 8.0],
                                 'y_coord': ['y coordinate', 0.04, 0.0, 1.0],
                                 'enabled': ['Enabled', 1, 0, 1],
                                 },
                    # 'kill_dry': True,
                    'description': 'binaural panner, allows positioning in 3D. '
                                   'Based on Parasite firware of Warps by '
                                   'Mutable Instruments.',
                    'inputs': {'carrier': ['right in', 'AudioPort'],
                               'lfo_amplitude_cv': ['lfo_amplitude_cv',
                                                    'CVPort'],
                               'lfo_frequency_cv': ['lfo frequency cv',
                                                    'CVPort'],
                               'modulator': ['left in', 'AudioPort'],
                               'x_coord_cv': ['x coordinate cv', 'CVPort'],
                               'y_coord_cv': ['y coordinate cv', 'CVPort']},
                    'long_description': '',
                    'manual_url': 'https://mqtthiqs.github.io/parasites/warps.html',
                    'outputs': {'aux': ['right out', 'AudioPort'],
                                'out': ['left out', 'AudioPort']},
                    'tags': {'mod effects', 'ported'},
                    'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=740s'},
 'drum_patterns': {'broadcast_ports': {'tempo': ['tempo', 120, 1, 320]},
                   'category': 2,
                   'controls': {'bd_dens': ['bass drum density', 0.5, 0.0, 1.0],
                                'chaos': ['chaos', 0.0, 0.0, 1.0],
                                'hh_dens': ['hihat density', 0.5, 0.0, 1.0],
                                'mapx': ['Map x', 0.0, 0.0, 1.0],
                                'mapy': ['map y', 0.5, 0.0, 1.0],
                                'reset_button': ['reset button',
                                                 0,
                                                 0.0,
                                                 1.0,
                                                 'bool'],
                                'run_button': ['run button',
                                               0.0,
                                               0.0,
                                               1.0,
                                               'bool'],
                                'sn_dens': ['snare density', 0.5, 0.0, 1.0],
                                'swing': ['swing', 0.0, 0.0, 0.9],
                                'tempo': ['tempo', 120.0, 37.0, 240.0]},
                   'description': 'Drum trigger explorer. Based on Grids by '
                                  'Mutable Instruments. Expects a 4 ppq clock '
                                  'if using external clock',
                   'inputs': {'bd_fill_cv': ['bd_fill_cv', 'CVPort'],
                              'chaos_cv': ['chaos cv', 'CVPort'],
                              'clock': ['clock', 'CVPort'],
                              'hh_fill_cv': ['hh fill cv', 'CVPort'],
                              'mapx_cv': ['map x cv', 'CVPort'],
                              'mapy_cv': ['map y cv', 'CVPort'],
                              'reset': ['reset', 'CVPort'],
                              'run_input': ['run', 'CVPort'],
                              'sn_fill_cv': ['sn fill cv', 'CVPort'],
                              'swing_cv': ['swing cv', 'CVPort'],
                              'tempo': ['BPM', 'ControlPort']},
                   'long_description': '',
                   'manual_url': 'https://mutable-instruments.net/modules/grids/manual/',
                   'outputs': {'bd_acc_output': ['bass drum accent', 'CVPort'],
                               'bd_output': ['bass drum trigger', 'CVPort'],
                               'hh_acc_output': ['hihat accent', 'CVPort'],
                               'hh_output': ['hihat trigger', 'CVPort'],
                               'sn_acc_output': ['snare accent', 'CVPort'],
                               'sn_output': ['snare trigger', 'CVPort']},
                   'tags': {'cv generators', 'ported'},
                   'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=925s'},
 'env_follower': {'category': 2,
                  'controls': {'ATIME': ['Attack Time', 0.01, 0.001, 2.0],
                               'CDIRECTION': ['Invert', 0, 0, 1, 'bool'],
                               'CMAXV': ['Maximum Value', 1.0, 0.0, 1.0],
                               'CMINV': ['Minimum Value', 0.0, 0.0, 1.0],
                               'DTIME': ['Decay Time', 0.1, 0.001, 2.0],
                               'PEAKRMS': ['Peak/RMS', 0.0, 0.0, 1.0],
                               'SATURATION': ['Saturation', 1.0, 0.0, 2.0],
                               'THRESHOLD': ['Threshold', 0.0, 0.0, 1.0]},
                  'description': 'Track an input signal and convert it into a '
                                 'control signal',
                  'inputs': {'INPUT': ['Audio In', 'AudioPort']},
                  'long_description': '',
                  'outputs': {'CV_OUT': ['CV Out', 'CVPort']},
                  'tags': {'cv generators'},
                  'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=1644s'},
 'euclidean': {'broadcast_ports': {'current_step_out_1': ['current step out 1',
                                                          0,
                                                          0,
                                                          32],
                                   'current_step_out_2': ['current step out 2',
                                                          0,
                                                          0,
                                                          32],
                                   'current_step_out_3': ['current step out 3',
                                                          0,
                                                          0,
                                                          32],
                                   'current_step_out_4': ['current step out 4',
                                                          0,
                                                          0,
                                                          32]},
               'category': 2,
               'controls': {'beats1': ['Loop 1 beats', 4, 0, 32],
                            'beats2': ['Loop 2 beats', 4, 0, 32],
                            'beats3': ['Loop 3 beats', 4, 0, 32],
                            'beats4': ['Loop 4 beats', 4, 0, 32],
                            'is_enabled1': ['Loop 1 is_enabled', 1, 0, 1],
                            'is_enabled2': ['Loop 2 is_enabled', 1, 0, 1],
                            'is_enabled3': ['Loop 3 is_enabled', 1, 0, 1],
                            'is_enabled4': ['Loop 4 is_enabled', 1, 0, 1],
                            'shift1': ['Loop 1 shift', 0, 0, 32],
                            'shift2': ['Loop 2 shift', 0, 0, 32],
                            'shift3': ['Loop 3 shift', 0, 0, 32],
                            'shift4': ['Loop 4 shift', 0, 0, 32],
                            'steps1': ['Loop 1 Steps', 4, 0, 32],
                            'steps2': ['Loop 2 Steps', 4, 0, 32],
                            'steps3': ['Loop 3 Steps', 4, 0, 32],
                            'steps4': ['Loop 4 Steps', 4, 0, 32]},
               'description': 'A euclidean sequencer with 4 tracks. Connect a '
                              'trigger to go to the next step',
               'inputs': {'back_trigger': ['Back Trigger', 'CVPort'],
                          'reset': ['Reset Trigger', 'CVPort'],
                          'trigger': ['Step Trigger', 'CVPort']},
               'long_description': 'The is the one outputs are triggered on '
                                   'the first beat and can be used to chain '
                                   'sequencers.',
               'outputs': {'is_the_one1': ['Is The One 1', 'CVPort'],
                           'is_the_one2': ['Is The One 2', 'CVPort'],
                           'is_the_one3': ['Is The One 3', 'CVPort'],
                           'is_the_one4': ['Is The One 4', 'CVPort'],
                           'out1': ['Trigger Out1', 'CVPort'],
                           'out2': ['Trigger Out2', 'CVPort'],
                           'out3': ['Trigger Out3', 'CVPort'],
                           'out4': ['Trigger Out4', 'CVPort']},
               'tags': {'cv generators'},
               'video_url': 'https://www.youtube.com/watch?v=3X0R0w9ytus&t=2376s'},
 'filter': {'category': 3,
            'controls': {'exp_fm_gain': ['Exp. FM gain', 0.5, 0.0, 10.0],
                         'freq': ['Frequency', 440.0, 25, 18000],
                         'in_gain': ['Input gain', 0.0, -60.0, 10.0],
                         'out_gain': ['Output gain', 0.0, -15.0, 15.0],
                         'res': ['Resonance', 0.5, 0.0, 1.0],
                         'res_gain': ['Resonance gain', 0.5, 0.0, 1.0]},
            'description': 'Virtual analog resonant low pass filter',
            'inputs': {'exp_fm': ['Exp FM', 'CVPort'],
                       'fm': ['FM', 'CVPort'],
                       'in': ['Input', 'AudioPort'],
                       'res_mod': ['Resonance Mod', 'CVPort']},
            'long_description': '',
            'outputs': {'out': ['Output', 'AudioPort']},
            'tags': {'pitch + synth'},
            'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=525s'},
 'filter_uberheim': {'category': 3,
                     'controls': {'Q': ['Q', 1, 0.5, 10],
                                  'cutoff': ['cutoff', 0.5, 0, 1]},
                     'description': 'A multi out filter inspired by vintage '
                                    'American designs',
                     'inputs': {'cutoff_cv': ['Cutoff CV', 'CVPort'],
                                'in': ['in', 'AudioPort'],
                                'q_cv': ['Q CV', 'CVPort']},
                     'long_description': '',
                     'outputs': {'band_pass': ['Band Pass', 'AudioPort'],
                                 'band_stop': ['Band Stop', 'AudioPort'],
                                 'high_pass': ['High Pass', 'AudioPort'],
                                 'low_pass': ['Low Pass', 'AudioPort']},
                     'tags': {'pitch + synth'},
                     'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=698s'},
 'flanger': {'broadcast_ports': {'BPM_1': ['tempo', 120, 1, 320]},
             'category': 0,
             'controls': {'BPM_1': ['BPM', 30, 5, 300],
                          'Delay_0': ['Delay', 0.22, 0, 1],
                          'Depth_2': ['Depth', 0.75, 0, 1],
                          'Feedback_4': ['Feedback', 0, -0.995, 0.99],
                          'Invert_3': ['Invert', 0, 0, 1, 'bool'],
                          'Waveshape_5': ['Waveshape', 0, 0, 1]},
             'description': 'flanger with internal LFO',
             'inputs': {'BPM_1': ['BPM', 'ControlPort'],
                        'in0': ['in', 'AudioPort']},
             'long_description': '',
             'outputs': {'out0': ['out0', 'AudioPort']},
             'tags': {'mod effects'},
             'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=983s'},
 'flanger_ext': {'category': 0,
                 'controls': {'Delay_0': ['Delay', 0.22, 0, 1],
                              'Depth_1': ['Depth', 0.75, 0, 1],
                              'Feedback_3': ['Feedback', 0, -0.995, 0.99],
                              'Invert_2': ['Invert', 0, 0, 1, 'bool']},
                 'description': 'flanger with CV for LFO',
                 'inputs': {'in1': ['in', 'AudioPort'],
                            'lfo_cv': ['LFO CV', 'CVPort']},
                 'long_description': '',
                 'outputs': {'out0': ['out0', 'AudioPort']},
                 'tags': {'mod effects'},
                 'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1074s'},
 'foot_switch_a': {'category': 1,
                   'controls': {'bpm': ['BPM', 120.0, 35.0, 350.0],
                                'cur_out': ['value', 0.0, 0.0, 1.0, 'hide'],
                                'latching': ['Is Latching',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'bool'],
                                'off_v': ['Off Value', 0.0, -1.0, 1.0],
                                'on_v': ['On Value', 1.0, -1.0, 1.0],
                                'value': ['value', 0.0, 0.0, 1.0]},
                   'description': 'The left footswitch. Also available in '
                                  'Hector to allow patch compatability.',
                   'inputs': {},
                   'long_description': '',
                   'outputs': {'bpm_out': ['BPM Out', 'ControlPort'],
                               'out': ['Value Out', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s'},
 'foot_switch_b': {'category': 1,
                   'controls': {'bpm': ['BPM', 120.0, 35.0, 350.0],
                                'cur_out': ['value', 0.0, 0.0, 1.0, 'hide'],
                                'latching': ['Is Latching',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'bool'],
                                'off_v': ['Off Value', 0.0, -1.0, 1.0],
                                'on_v': ['On Value', 1.0, -1.0, 1.0],
                                'value': ['value', 0.0, 0.0, 1.0]},
                   'description': 'The center footswitch. Also available in '
                                  'Hector to allow patch compatability.',
                   'inputs': {},
                   'long_description': '',
                   'outputs': {'bpm_out': ['BPM Out', 'ControlPort'],
                               'out': ['Value Out', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s'},
 'foot_switch_c': {'category': 1,
                   'controls': {'bpm': ['BPM', 120.0, 35.0, 350.0],
                                'cur_out': ['value', 0.0, 0.0, 1.0, 'hide'],
                                'latching': ['Is Latching',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'bool'],
                                'off_v': ['Off Value', 0.0, -1.0, 1.0],
                                'on_v': ['On Value', 1.0, -1.0, 1.0],
                                'value': ['value', 0.0, 0.0, 1.0]},
                   'description': 'The right footswitch. Also available in '
                                  'Hector to allow patch compatability.',
                   'inputs': {},
                   'long_description': '',
                   'outputs': {'bpm_out': ['BPM Out', 'ControlPort'],
                               'out': ['Value Out', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s'},
 'foot_switch_d': {'category': 1,
                   'controls': {'bpm': ['BPM', 120.0, 35.0, 350.0],
                                'cur_out': ['value', 0.0, 0.0, 1.0, 'hide'],
                                'latching': ['Is Latching',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'bool'],
                                'off_v': ['Off Value', 0.0, -1.0, 1.0],
                                'on_v': ['On Value', 1.0, -1.0, 1.0],
                                'value': ['value', 0.0, 0.0, 1.0]},
                   'description': 'The left and centre right footswitch. Also '
                                  'available in Hector to allow patch '
                                  'compatability.',
                   'inputs': {},
                   'long_description': '',
                   'outputs': {'bpm_out': ['BPM Out', 'ControlPort'],
                               'out': ['Value Out', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s'},
 'foot_switch_e': {'category': 1,
                   'controls': {'bpm': ['BPM', 120.0, 35.0, 350.0],
                                'cur_out': ['value', 0.0, 0.0, 1.0, 'hide'],
                                'latching': ['Is Latching',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'bool'],
                                'off_v': ['Off Value', 0.0, -1.0, 1.0],
                                'on_v': ['On Value', 1.0, -1.0, 1.0],
                                'value': ['value', 0.0, 0.0, 1.0]},
                   'description': 'The right and centre footswitch. Also '
                                  'available in Hector to allow patch '
                                  'compatability.',
                   'inputs': {},
                   'long_description': '',
                   'outputs': {'bpm_out': ['BPM Out', 'ControlPort'],
                               'out': ['Value Out', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s'},
 'freeze': {'category': 0,
            'controls': {'DRONE_GAIN': ['Drone Gain', 0.5, 0.0, 2.0],
                         'RELEASE': ['Release', 0.5, 0.01, 3.0],
                         'STICK_IT': ['Freeze', 0, 0, 1, 'bool']},
            'description': 'Holds what you are playing when the control level '
                           'is active, creating a drone.',
            'inputs': {'INPUT': ['Audio In', 'AudioPort'],
                       'STICK_IT': ['Freeze', 'CVPort']},
            'long_description': '',
            'outputs': {'OUTPUT': ['Audio Out', 'AudioPort']},
            'tags': {'time effects'},
            'video_url': 'https://www.youtube.com/watch?v=irBJRf0vHe4&t=1328s'},
 'granular': {'category': 3,
              'controls': {'blend_param': ['blend', 0.78, 0.0, 1.0],
                           'density_param': ['density', 0.27, 0.0, 1.0],
                           'feedback_param': ['feedback', 0.05, 0.0, 1.0],
                           'freeze_param': ['freeze', 0.0, 0.0, 1.0],
                           'pitch_param': ['pitch', 0.0, -24.0, 24.0, 'int'],
                           'position_param': ['position', 0.24, 0.0, 1.0],
                           'reverb_param': ['reverb', 0.0, 0.0, 1.0],
                           'reverse_param': ['reverse', 0.0, 0.0, 1.0],
                           'size_param': ['size', 0.69, 0.0, 1.0],
                           'spread_param': ['spread', 0.7, 0.0, 1.0],
                           'texture_param': ['texture', 0.73, 0.0, 1.0],
                           'enabled': ['Enabled', 1, 0, 1],
                           },
              # 'kill_dry': True,
              'description': 'Granular texture generator, can work as a weird '
                             'delay or reverb. Based on Parasite firmware of '
                             'Mutable Instruments Clouds.',
              'inputs': {'Feedback': ['feedback', 'CVPort'],
                         'blend': ['Blend', 'CVPort'],
                         'density': ['Density', 'CVPort'],
                         'freeze': ['Freeze', 'CVPort'],
                         'l_in': ['L in', 'AudioPort'],
                         'pitch': ['Pitch', 'CVPort'],
                         'position': ['Position', 'CVPort'],
                         'r_in': ['R in', 'AudioPort'],
                         'reverb': ['Reverb', 'CVPort'],
                         'reverse': ['Reverse', 'CVPort'],
                         'size': ['Size', 'CVPort'],
                         'spread': ['Spread', 'CVPort'],
                         'texture': ['Texture', 'CVPort'],
                         'trig': ['Trigger', 'CVPort']},
              'long_description': '',
              'manual_url': 'https://www.mutable-instruments.net/modules/clouds/manual/',
              'outputs': {'l_out': ['L Out', 'AudioPort'],
                          'r_out': ['R Out', 'AudioPort']},
              'tags': {'time effects', 'ported'},
              'video_url': 'https://www.youtube.com/watch?v=2g7hH2-9iEA&t=50s'},
 'granular_looping': {'category': 0,
                      'controls': {'blend_param': ['blend', 0.44, 0.0, 1.0],
                                   'density_param': ['diffusion',
                                                     0.7,
                                                     0.0,
                                                     1.0],
                                   'feedback_param': ['feedback',
                                                      0.53,
                                                      0.0,
                                                      1.0],
                                   'freeze_param': ['freeze', 0.0, 0.0, 1.0],
                                   'pitch_param': ['pitch',
                                                   0.0,
                                                   -24.0,
                                                   24.0,
                                                   'int'],
                                   'position_param': ['tape length',
                                                      0.4,
                                                      0.0,
                                                      1.0],
                                   'reverb_param': ['reverb', 0.3, 0.0, 1.0],
                                   'reverse_param': ['reverse', 0.0, 0.0, 1.0],
                                   'size_param': ['pitch windows',
                                                  0.6,
                                                  0.0,
                                                  1.0],
                                   'spread_param': ['spread', 0.81, 0.0, 1.0],
                                   'texture_param': ['filter', 0.44, 0.0, 1.0],
                                   'enabled': ['Enabled', 1, 0, 1],
                                   },
                      # 'kill_dry': True,
                      'description': 'Granular pitch shifting, micro looping '
                                     'delay. CPU Hungry. Based on Parasite '
                                     'firmware of Clouds by Mutable '
                                     'Instruments.',
                      'inputs': {'Feedback': ['feedback', 'CVPort'],
                                 'blend': ['Blend', 'CVPort'],
                                 'density': ['Diffusion', 'CVPort'],
                                 'freeze': ['Loop', 'CVPort'],
                                 'l_in': ['L in', 'AudioPort'],
                                 'pitch': ['Pitch', 'CVPort'],
                                 'position': ['tape length', 'CVPort'],
                                 'r_in': ['R in', 'AudioPort'],
                                 'reverb': ['Reverb', 'CVPort'],
                                 'reverse': ['Reverse', 'CVPort'],
                                 'size': ['pitch window', 'CVPort'],
                                 'spread': ['Spread', 'CVPort'],
                                 'texture': ['Filter', 'CVPort'],
                                 'trig': ['Trigger', 'CVPort']},
                      'long_description': '',
                      'manual_url': 'https://mqtthiqs.github.io/parasites/clouds.html',
                      'outputs': {'l_out': ['L Out', 'AudioPort'],
                                  'r_out': ['R Out', 'AudioPort']},
                      'tags': {'time effects', 'ported'},
                      'video_url': 'https://www.youtube.com/watch?v=2g7hH2-9iEA&t=1208s'},
 'harmonic_trem_ext': {'category': 0,
                       'controls': {'CrossoverFreq_0': ['CrossoverFreq',
                                                        800,
                                                        20,
                                                        10000],
                                    'depth_1': ['depth', 0.1, 0, 1]},
                       'description': 'harmonic tremolo CV LFO input',
                       'inputs': {'in0': ['in', 'AudioPort'],
                                  'lfo_in1': ['LFO CV', 'CVPort']},
                       'long_description': '',
                       'outputs': {'out0': ['out', 'AudioPort']},
                       'tags': {'mod effects'},
                       'video_url': 'https://www.youtube.com/watch?v=6hHgWDboqIU&t=90s'},
 'harmonic_tremolo': {'broadcast_ports': {'BPM_0': ['tempo', 120, 1, 320]},
                      'category': 0,
                      'controls': {'BPM_0': ['BPM', 120, 15, 300],
                                   'CrossoverFreq_1': ['Crossover Freq',
                                                       800,
                                                       20,
                                                       10000],
                                   'depth_2': ['Depth', 0.1, 0, 1]},
                      'description': 'harmonic tremolo with internal LFO',
                      'inputs': {'BPM_0': ['BPM', 'ControlPort'],
                                 'in0': ['in', 'AudioPort']},
                      'long_description': '',
                      'outputs': {'out0': ['out', 'AudioPort']},
                      'tags': {'mod effects'},
                      'video_url': 'https://www.youtube.com/watch?v=6hHgWDboqIU&t=90s'},
 'input': {'controls': {},
           'inputs': {},
           'long_description': '',
           'outputs': {'output': ['in', 'AudioPort']},
           'tags': set(),
           'video_url': ''},
 'k_org_hpf': {'category': 3,
               'controls': {'Q': ['Q', 1, 0.5, 10],
                            'cutoff': ['cutoff', 0.5, 0, 1]},
               'description': 'A high pass filter similar to the vintage '
                              'Japanese designs',
               'inputs': {'cutoff_cv': ['Cutoff CV', 'CVPort'],
                          'in': ['in', 'AudioPort'],
                          'q_cv': ['Q CV', 'CVPort']},
               'long_description': '',
               'outputs': {'out': ['out', 'AudioPort']},
               'tags': {'pitch + synth'},
               'video_url': 'https://www.youtube.com/watch?v=6hHgWDboqIU&t=570s'},
 'k_org_lpf': {'category': 3,
               'controls': {'Q': ['Q', 1, 0.5, 10],
                            'cutoff': ['cutoff', 0.5, 0, 1]},
               'description': 'A low pass filter similar to the vintage '
                              'Japanese designs',
               'inputs': {'cutoff_cv': ['Cutoff CV', 'CVPort'],
                          'in': ['in', 'AudioPort'],
                          'q_cv': ['Q CV', 'CVPort']},
               'long_description': '',
               'outputs': {'out': ['out', 'AudioPort']},
               'tags': {'pitch + synth'},
               'video_url': 'https://www.youtube.com/watch?v=6hHgWDboqIU&t=570s'},
 'lfo': {'broadcast_ports': {'tempo': ['tempo', 120, 1, 320]},
         'category': 2,
         'controls': {'is_uni': ['Unipolar', 1.0, 0.0, 1.0, 'bool'],
                      'level': ['Level', 1.0, -1.0, 1.0],
                      'tempo': ['Tempo', 120.0, 10.0, 320.0],
                      'tempoMultiplier': ['Tempo Multiplier', 1.0, 0.02, 32.0],
                      'waveForm': ['Wave Form', 0, 0, 5, 'int']},
         'description': 'Low frequency oscillator, send a control signal.',
         'inputs': {'reset': ['Reset', 'CVPort'],
                    'tempo': ['BPM', 'ControlPort']},
         'long_description': '',
         'outputs': {'output': ['Output', 'CVPort']},
         'tags': {'cv generators'},
         'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=80s'},
 'loop_common_in': {'category': 1,
                    'controls': {},
                    'description': 'Common input to the loopler',
                    'inputs': {'input': ['out', 'AudioPort']},
                    'long_description': '',
                    'outputs': {},
                    'tags': {'time effects'},
                    'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s'},
 'loop_common_out': {'category': 1,
                     'controls': {},
                     'description': 'Common output from the loopler',
                     'inputs': {},
                     'long_description': '',
                     'outputs': {'output': ['in', 'AudioPort']},
                     'tags': {'time effects'},
                     'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s'},
 'loop_extra_midi': {'category': 1,
                     'controls': {},
                     'description': 'Connect internal MIDI generators to the '
                                    'Looper, do not connect external MIDI '
                                    'here, will duplicate.',
                     'inputs': {'input': ['out', 'AtomPort']},
                     'long_description': 'For example trigger loops with a '
                                         'chaos controller module connected to '
                                         'a CV to CC then to this.',
                     'outputs': {},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s'},
 'loop_midi_out': {'category': 1,
                   'controls': {},
                   'description': 'Ouput MIDI Clock from looper.',
                   'inputs': {},
                   'long_description': 'You can connect this to external gear '
                                       'to sync to a loop or drive internal or '
                                       'CV gear by connecting to the MIDI '
                                       'clock input module.',
                   'outputs': {'output': ['in', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=1915s'},
 'looping_envelope': {'category': 0,
                      'controls': {'frequency_cv_param': ['frequency',
                                                          0,
                                                          -1.0,
                                                          1.0],
                                   'frequency_param': ['frequency',
                                                       0,
                                                       -48.0,
                                                       48.0],
                                   'mode_param': ['mode', 0, 0.0, 4.0],
                                   'ramp_param': ['ramp', 0, 0.0, 3.0],
                                   'range_param': ['range', 0, 0.0, 3.0],
                                   'shape_cv_param': ['shape', 0, -1.0, 1.0],
                                   'shape_param': ['shape', 0.5, 0.0, 1.0],
                                   'shift_cv_param': ['shift', 0, -1.0, 1.0],
                                   'shift_param': ['shift', 0.5, 0.0, 1.0],
                                   'slope_cv_param': ['slope', 0, -1.0, 1.0],
                                   'slope_param': ['slope', 0.5, 0.0, 1.0],
                                   'smoothness_cv_param': ['smoothness',
                                                           0,
                                                           -1.0,
                                                           1.0],
                                   'smoothness_param': ['smoothness',
                                                        0.5,
                                                        0.0,
                                                        1.0]},
                      'description': 'A powerful envelope and LFO generator.\n'
                                     'Based on Tides by Mutable Instruments. ',
                      'inputs': {'clock_input': ['clock', 'CVPort'],
                                 'frequency_input': ['frequency', 'CVPort'],
                                 'shape_input': ['shape', 'CVPort'],
                                 'shift_input': ['shift', 'CVPort'],
                                 'slope_input': ['slope', 'CVPort'],
                                 'smoothness_input': ['smoothness', 'CVPort'],
                                 'trig_input': ['trigger', 'CVPort'],
                                 'v_oct_input': ['v per oct', 'CVPort']},
                      'long_description': 'Based on Tides by Mutable '
                                          'Instruments.',
                      'manual_url': 'https://www.mutable-instruments.net/modules/tides/manual/',
                      'outputs': {'out1': ['out1', 'CVPort'],
                                  'out2': ['out2', 'CVPort'],
                                  'out3': ['out3', 'CVPort'],
                                  'out4': ['out4', 'CVPort'],
                                  'tempo_out': ['tempo', 'ControlPort']},
                      'tags': {'cv generators', 'ported'},
                      'video_url': 'https://www.youtube.com/watch?v=jLku1gL3h8k&t=2087s'},
 'macro_osc': {'category': 3,
               'controls': {'freq_mod': ['Frequency Mod', 0.0, -1.0, 1.0],
                            'frequency': ['frequency', 0.0, -4.0, 4.0],
                            'harmonics': ['harmonics', 0.5, 0.0, 1.0],
                            'lpg_color': ['LPG Color', 0.5, 0.0, 1.0],
                            'lpg_decay': ['LPG Decay', 0.5, 0.0, 1.0],
                            'model': ['model', 0, 0.0, 16.0],
                            'morph': ['morph', 0.5, 0.0, 1.0],
                            'morph_mod': ['Morph Mod', 0.0, -1.0, 1.0],
                            'timbre': ['timbre', 0.5, 0.0, 1.0],
                            'timbre_mod': ['Timbre Mod', 0.0, -1.0, 1.0]},
               'description': 'A powerful multi model oscillator voice. Based '
                              'on Mutable Instruments Plaits module.',
               'inputs': {'engine_cv': ['engine cv', 'CVPort'],
                          'freq_cv': ['frequency cv', 'CVPort'],
                          'harmonics_cv': ['harmonics cv', 'CVPort'],
                          'level_cv': ['level cv', 'CVPort'],
                          'morph_cv': ['morph cv', 'CVPort'],
                          'note_cv': ['V per oct CV', 'CVPort'],
                          'timbre_cv': ['timbre cv', 'CVPort'],
                          'trigger_cv': ['trigger cv', 'CVPort']},
               'long_description': '',
               'manual_url': 'https://www.mutable-instruments.net/modules/plaits/manual/',
               'outputs': {'aux': ['aux', 'AudioPort'],
                           'out': ['out', 'AudioPort']},
               'tags': {'pitch + synth', 'ported'},
               'video_url': 'https://www.youtube.com/watch?v=1ED7ipo2wTM&t=1140s'},
 'matrix_mixer': {'category': 0,
                  'controls': {'mix_1_1': ['Input 1', 1.0, 0.0, 2.0],
                               'mix_1_2': ['Input 1', 0.0, 0.0, 2.0],
                               'mix_1_3': ['Input 1', 0.0, 0.0, 2.0],
                               'mix_2_1': ['Input 2', 0.0, 0.0, 2.0],
                               'mix_2_2': ['Input 2', 1.0, 0.0, 2.0],
                               'mix_2_3': ['Input 2', 0.0, 0.0, 2.0],
                               'mix_3_1': ['Input 3', 0.0, 0.0, 2.0],
                               'mix_3_2': ['Input 3', 0.0, 0.0, 2.0],
                               'mix_3_3': ['Input 3', 1.0, 0.0, 2.0],
                               'mix_4_1': ['Input 4', 0.0, 0.0, 2.0],
                               'mix_4_2': ['Input 4', 0.0, 0.0, 2.0],
                               'mix_4_3': ['Input 4', 0.0, 0.0, 2.0]},
                  'description': '4 in 3 out matrix mixer',
                  'inputs': {'in1': ['Input 1', 'AudioPort'],
                             'in2': ['Input 2', 'AudioPort'],
                             'in3': ['Input 3', 'AudioPort'],
                             'in4': ['Input 4', 'AudioPort']},
                  'long_description': '4 in 3 out matrix mixer',
                  'outputs': {'out1': ['Output 1', 'AudioPort'],
                              'out2': ['Output 2', 'AudioPort'],
                              'out3': ['Output 3', 'AudioPort']},
                  'tags': {'level + dynamics'},
                  'video_url': 'https://www.youtube.com/watch?v=1ED7ipo2wTM&t=1985s'},
 'max': {'category': 2,
         'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
         'description': 'max of a, b also logical or',
         'inputs': {'a_cv': ['A CV', 'CVPort'], 'b_cv': ['B CV', 'CVPort']},
         'long_description': '',
         'outputs': {'out': ['Output', 'CVPort']},
         'tags': {'utilities'},
         'video_url': 'https://www.youtube.com/watch?v=1ED7ipo2wTM&t=2115s'},
 'meta_modulation': {'category': 3,
                     'controls': {'algorithm': ['algorithm', 0.0, 0.0, 8.0],
                                  'level1': ['level 1 or freq', 1.0, 0.0, 1.0],
                                  'level2': ['level 2', 1.0, 0.0, 1.0],
                                  'shape': ['shape', 0.0, 0.0, 3.0],
                                  'timbre': ['timbre', 0.5, 0.0, 1.0],
                                  'enabled': ['Enabled', 1, 0, 1],
                                  },
                     # 'kill_dry': True,
                     'description': 'A powerful cross modulation module which '
                                    'applies an algorithm to the two inputs. '
                                    'Based on Warps by Mutable Instruments.',
                     'inputs': {'algorthm_cv': ['algorthm cv', 'CVPort'],
                                'carrier': ['carrier', 'AudioPort'],
                                'level1_cv': ['level 1 freq cv', 'CVPort'],
                                'level2_cv': ['level 2 cv', 'CVPort'],
                                'modulator': ['modulator', 'AudioPort'],
                                'timbre_cv': ['timbre cv', 'CVPort']},
                     'long_description': '',
                     'manual_url': 'https://www.mutable-instruments.net/modules/warps/manual/',
                     'outputs': {'aux': ['aux', 'AudioPort'],
                                 'out': ['out', 'AudioPort']},
                     'tags': {'pitch + synth', 'ported'},
                     'video_url': 'https://www.youtube.com/watch?v=1ED7ipo2wTM&t=2370s'},
 'midi_cc': {'category': 1,
             'controls': {'controller_number': ['CC Number',
                                                0,
                                                0.0,
                                                127.0,
                                                'int'],
                          'logarithmic': ['Logarithmic', 0.0, 0.0, 1.0, 'bool'],
                          'maximum': ['Maximum', 1.0, 0.0, 1.0],
                          'minimum': ['Minimum', 0, -1, 1]},
             'description': 'MIDI CC to control value',
             'inputs': {'input': ['MIDI Input', 'AtomPort']},
             'long_description': '',
             'outputs': {'output_cv': ['Output', 'CVPort']},
             'tags': {'midi'},
             'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=620s'},
 'midi_cc_to_note': {'category': 0,
                     'controls': {'channelf': ['Filter Channel',
                                               0,
                                               0,
                                               16,
                                               'int'],
                                  'key': ['Key (midi-note)', 48, 0, 127, 'int'],
                                  'mode': ['Operation Mode', 1, 0, 3, 'int'],
                                  'param': ['CC Parameter to intercept',
                                            0,
                                            0,
                                            127,
                                            'int']},
                     'description': 'translate control-commands to note-on/off '
                                    'messages',
                     'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                     'long_description': 'Filter ChannelMIDI Channel (1..16) '
                                         'on which the filter is active.Data '
                                         'on other channels is passed though '
                                         'unmodified.Operation Mode:Value 0 = '
                                         'Fixed key, velocity = CC-valueValue '
                                         '1 = key = CC-value, fixed velocity '
                                         '(64)Value 2 = All keys, key = '
                                         'parameter, velocity = CC-valueCC '
                                         'Parameter to Intercept:unused in '
                                         '"all keys" mode.Key (midi-note):only '
                                         'used in "velocity = value" '
                                         'mode.Convert MIDI control change '
                                         'messages to note-on/off '
                                         'messages.Note off is queued 10msec '
                                         'later.',
                     'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1205s'},
 'midi_channel_filter': {'category': 0,
                         'controls': {'chn1': ['Channel  1', 1, 0, 1, 'int'],
                                      'chn10': ['Channel 10', 1, 0, 1, 'int'],
                                      'chn11': ['Channel 11', 1, 0, 1, 'int'],
                                      'chn12': ['Channel 12', 1, 0, 1, 'int'],
                                      'chn2': ['Channel  2', 1, 0, 1, 'int'],
                                      'chn3': ['Channel  3', 1, 0, 1, 'int'],
                                      'chn4': ['Channel  4', 1, 0, 1, 'int'],
                                      'chn5': ['Channel  5', 1, 0, 1, 'int'],
                                      'chn6': ['Channel  6', 1, 0, 1, 'int'],
                                      'chn7': ['Channel  7', 1, 0, 1, 'int'],
                                      'chn8': ['Channel  8', 1, 0, 1, 'int'],
                                      'chn9': ['Channel  9', 1, 0, 1, 'int']},
                         'description': 'discard messages per channel',
                         'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                         'long_description': 'Simple MIDI channel filter. Only '
                                             'data for selected channels may '
                                             'pass.This filter only affects '
                                             'midi-data which is channel '
                                             'relevant (ie note-on/off, '
                                             'control and program changes, key '
                                             'and channel pressure and '
                                             'pitchbend).MIDI-SYSEX and '
                                             'Realtime message are always '
                                             'passed on. See also "MIDI '
                                             'Channel Map" filter.',
                         'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                         'tags': {'midi'},
                         'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_channel_map': {'category': 0,
                      'controls': {'chn1': ['Channel  1 to', 1, 0, 16, 'int'],
                                   'chn10': ['Channel 10 to', 10, 0, 16, 'int'],
                                   'chn11': ['Channel 11 to', 11, 0, 16, 'int'],
                                   'chn12': ['Channel 12 to', 12, 0, 16, 'int'],
                                   'chn2': ['Channel  2 to', 2, 0, 16, 'int'],
                                   'chn3': ['Channel  3 to', 3, 0, 16, 'int'],
                                   'chn4': ['Channel  4 to', 4, 0, 16, 'int'],
                                   'chn5': ['Channel  5 to', 5, 0, 16, 'int'],
                                   'chn6': ['Channel  6 to', 6, 0, 16, 'int'],
                                   'chn7': ['Channel  7 to', 7, 0, 16, 'int'],
                                   'chn8': ['Channel  8 to', 8, 0, 16, 'int'],
                                   'chn9': ['Channel  9 to', 9, 0, 16, 'int']},
                      'description': 'map any MIDI-channel to another '
                                     'MIDI-channel',
                      'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                      'long_description': '',
                      'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                      'tags': {'midi'},
                      'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1278s'},
 'midi_choke_filter': {'category': 0,
                       'controls': {'channelf': ['Filter Channel',
                                                 0,
                                                 0,
                                                 16,
                                                 'int'],
                                    'choke': ['Choke Note', 46, 0, 127, 'int'],
                                    'rvmode': ['Release Velocity',
                                               2,
                                               0,
                                               2,
                                               'int'],
                                    'triggerhi': ['High Trigger Note',
                                                  42,
                                                  0,
                                                  127,
                                                  'int'],
                                    'triggerlo': ['Low Trigger Note',
                                                  42,
                                                  0,
                                                  127,
                                                  'int']},
                       'description': 'trigger note-off events, create '
                                      'exclusive note-groups',
                       'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                       'long_description': 'MIDI Choke filter. Send note-off '
                                           'message for choke note (if it is '
                                           'on), when any note within the '
                                           'trigger note range is received.Low '
                                           'Trigger Note: Lowest note of the '
                                           'note range, which triggers the '
                                           'choke.High Trigger Note: Highest '
                                           'note of the note range, which '
                                           'triggers the choke.Choke Note: '
                                           'Note, which is choked when a '
                                           'trigger note is received.Release '
                                           'Velocity: What to set the release '
                                           'velocity of the choke note-off to.',
                       'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                       'tags': {'midi'},
                       'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1338s'},
 'midi_chord': {'category': 0,
                'controls': {'_8': ['bass', 0, 0, 1, 'bool'],
                             'c1': ['prime', 1, 0, 1, 'bool'],
                             'c2': ['2nd', 0, 0, 1, 'bool'],
                             'c3': ['3rd', 1, 0, 1, 'bool'],
                             'c4': ['4th', 0, 0, 1, 'bool'],
                             'c5': ['5th', 1, 0, 1, 'bool'],
                             'c7': ['7th', 0, 0, 1, 'bool'],
                             'c8': ['octave', 1, 0, 1, 'bool'],
                             'c9': ['9th', 0, 0, 1, 'bool'],
                             'channelf': ['Filter Channel', 0, 0, 16, 'int'],
                             'hold': ['Hold Chord', 0, 0, 1, 'bool'],
                             'scale': ['Scale', 0, 0, 11, 'int']},
                'description': 'create MIDI chords from a single note in a '
                               'given musical scale',
                'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                'long_description': 'Harmonizer - make chords from single '
                                    '(fundamental) note in a given musical '
                                    'scale. The scale as well as intervals can '
                                    'be automated freely (currently held '
                                    'chords will change). Note-ons are '
                                    'latched, for multiple/combined chords '
                                    'only single note-on/off will be triggered '
                                    'for the duration of the combined chords. '
                                    'If a off-scale note is given, it will be '
                                    'passed through - no chord is allocated. '
                                    'Note: Combine this effect with the "MIDI '
                                    'Enforce Scale" filter to weed them '
                                    'out.Hold a note until the next note '
                                    'arrives. -- Play the same note again to '
                                    'switch it off.',
                'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1500s'},
 'midi_clock_in': {'category': 1,
                   'controls': {'bandwidth': ['Bandwidth Smoothing',
                                              6.0,
                                              1,
                                              16],
                                'divider': ['pulse divider', 1.0, 1, 24]},
                   'description': 'MIDI Clock to BPM',
                   'inputs': {'control': ['MIDI Input', 'AtomPort']},
                   'long_description': '',
                   'outputs': {'bpm': ['BPM', 'ControlPort'],
                               'is_running': ['Is Running', 'CVPort'],
                               'pulse_out': ['Clock Pulse', 'CVPort'],
                               'start_trigger': ['Start Trigger', 'CVPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1515s'},
 'midi_clock_out': {'category': 1,
                    'controls': {'bpm': ['BPM', 120.0, 40.0, 208.0]},
                    'description': 'BPM to MIDI Clock',
                    'inputs': {'bpm': ['BPM', 'ControlPort']},
                    'long_description': '',
                    'outputs': {'mclk': ['Midi Out', 'AtomPort']},
                    'tags': {'midi'},
                    'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1820s'},
 'midi_delay': {'broadcast_ports': {'delayBPM': ['BPM', 120, 1, 320]},
                'category': 0,
                'controls': {'delayBPM': ['BPM', 120.0, 1.0, 280.0],
                             'delayBeats': ['Delay Beats 4/4',
                                            1.0,
                                            0.0,
                                            16.0,
                                            'int'],
                             'delayRandom': ['Randomize [Beats]',
                                             0.0,
                                             0.0,
                                             1.0,
                                             'int']},
                'description': 'delay MIDI events with optional randomization',
                'inputs': {'delayBPM': ['bpm', 'ControlPort'],
                           'midiin': ['MIDI In', 'AtomPort']},
                'long_description': 'MIDI delay line. Delay all MIDI events by '
                                    'a given time which is given as BPM and '
                                    'beats. If the delay includes a random '
                                    'factor, this effect takes care of always '
                                    'keeping note on/off events sequential '
                                    'regardless of the randomization.',
                'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1948s'},
 'midi_dup': {'category': 0,
              'controls': {'chd': ['Duplicate to Channel', 2, 1, 16, 'int'],
                           'chs': ['Source Channel', 1, 1, 16, 'int']},
              'description': 'duplicate MIDI events from one channel to '
                             'another',
              'inputs': {'midiin': ['MIDI In', 'AtomPort']},
              'long_description': 'MIDI Duplicate Blocker. Filter out '
                                  'overlapping note on/off and duplicate '
                                  'messages.',
              'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
              'tags': {'midi'},
              'video_url': ''},
 'midi_enforce_scale': {'category': 0,
                        'controls': {'channelf': ['Filter Channel',
                                                  0,
                                                  0,
                                                  16,
                                                  'int'],
                                     'mode': ['Mode', 0, 0, 2, 'int'],
                                     'scale': ['Scale', 0, 0, 11, 'int']},
                        'description': 'force midi notes on given musical '
                                       'scale',
                        'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                        'long_description': 'Filter note-on/off events '
                                            'depending on musical scale. If '
                                            'the scale is changed, note-off '
                                            'events are sent for all active '
                                            'out-of-key notes.',
                        'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                        'tags': {'midi'},
                        'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_event_blocker': {'category': 0,
                        'controls': {'blkcc': ['Block Control Changes',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blkcm': ['Block Custom Message',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blkcp': ['Block Channel-Pressure',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blknote': ['Block Notes',
                                                 0,
                                                 0,
                                                 1,
                                                 'bool'],
                                     'blkpb': ['Block Pitch Bend',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blkpc': ['Block Program Changes',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blkpp': ['Block Polykey-Pressure',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'blksx': ['Block System Messages',
                                               0,
                                               0,
                                               1,
                                               'bool'],
                                     'cm1': ['Custom message Data1',
                                             -1,
                                             -1,
                                             127,
                                             'int'],
                                     'cm2': ['Custom message Data2',
                                             -1,
                                             -1,
                                             127,
                                             'int'],
                                     'cmf': ['Custom message Channel',
                                             0,
                                             0,
                                             16,
                                             'int'],
                                     'cmt': ['Custom Message Type',
                                             0,
                                             0,
                                             6,
                                             'int']},
                        'description': 'notch style MIDI message filter. '
                                       'Suppress specific messages',
                        'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                        'long_description': 'For flexible note-on/off range '
                                            'see also "keyrange" and '
                                            '"velocityrange"',
                        'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                        'tags': {'midi'},
                        'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_input': {'controls': {},
                'inputs': {},
                'long_description': '',
                'outputs': {'output': ['in', 'AtomPort']},
                'tags': set(),
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_keyrange': {'category': 0,
                   'controls': {'channelf': ['Filter Channel', 0, 0, 16, 'int'],
                                'lower': ['Lowest Note', 0, 0, 127, 'int'],
                                'mode': ['Operation Mode', 1, 0, 2, 'int'],
                                'upper': ['Highest Note', 127, 0, 127, 'int']},
                   'description': 'discard notes-on/off events outside a given '
                                  'range',
                   'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                   'long_description': 'This filter allows to define a range '
                                       'of allowed midi notes. Notes-on/off '
                                       'events outside the allowed range are '
                                       'discarded. If the range changes, '
                                       'note-off events are sent to currently '
                                       'active notes that end up outside the '
                                       'valid range.',
                   'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_keysplit': {'category': 0,
                   'controls': {'channel0': ['Channel Lower', 1, 1, 16, 'int'],
                                'channel1': ['Channel Upper', 2, 1, 16, 'int'],
                                'channelf': ['Filter Channel', 0, 0, 16, 'int'],
                                'split': ['Splitpoint', 48, 0, 127, 'int'],
                                'transp0': ['Transpose Lower',
                                            0,
                                            -48,
                                            48,
                                            'int'],
                                'transp1': ['Transpose Upper',
                                            0,
                                            -48,
                                            48,
                                            'int']},
                   'description': 'change midi-channel number depending on '
                                  'note (and optionally transpose)',
                   'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                   'long_description': 'Change midi-channel number depending '
                                       'on note. The module keeps track of '
                                       'transposed midi-notes in case and '
                                       'sends note-off events accordingly if '
                                       'the range is changed even if a note is '
                                       'active. However the split-point and '
                                       'channel-assignments for each manual '
                                       'should only be changed when no notes '
                                       'are currently played.',
                   'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_map_key_channel': {'category': 0,
                          'controls': {'k0': ['C', 1, 0, 16, 'int'],
                                       'k1': ['C#', 1, 0, 16, 'int'],
                                       'k10': ['A#', 1, 0, 16, 'int'],
                                       'k11': ['B', 1, 0, 16, 'int'],
                                       'k2': ['D', 1, 0, 16, 'int'],
                                       'k3': ['D#', 1, 0, 16, 'int'],
                                       'k4': ['E', 1, 0, 16, 'int'],
                                       'k5': ['F', 1, 0, 16, 'int'],
                                       'k6': ['F#', 1, 0, 16, 'int'],
                                       'k7': ['G', 1, 0, 16, 'int'],
                                       'k8': ['G#', 1, 0, 16, 'int'],
                                       'k9': ['A', 1, 0, 16, 'int']},
                          'description': '12-tone channel map',
                          'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                          'long_description': '12-tone channel map. Allow to '
                                              'change midi-channel per note. '
                                              '(Events other than note-on/off '
                                              'will be passed through '
                                              'as-is;currently there is no '
                                              'channel panic forwarding, nor '
                                              'note-off events when changing '
                                              'the channel-assignments '
                                              'dynamically)',
                          'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                          'tags': {'midi'},
                          'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_map_key_scale': {'category': 0,
                        'controls': {'channelf': ['Filter Channel',
                                                  0,
                                                  0,
                                                  16,
                                                  'int'],
                                     'k0': ['C', 0, -13, 12, 'int'],
                                     'k1': ['C#', 0, -13, 12, 'int'],
                                     'k10': ['A#', 0, -13, 12, 'int'],
                                     'k11': ['B', 0, -13, 12, 'int'],
                                     'k2': ['D', 0, -13, 12, 'int'],
                                     'k3': ['D#', 0, -13, 12, 'int'],
                                     'k4': ['E', 0, -13, 12, 'int'],
                                     'k5': ['F', 0, -13, 12, 'int'],
                                     'k6': ['F#', 0, -13, 12, 'int'],
                                     'k7': ['G', 0, -13, 12, 'int'],
                                     'k8': ['G#', 0, -13, 12, 'int'],
                                     'k9': ['A', 0, -13, 12, 'int']},
                        'description': 'flexible 12-tone note map',
                        'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                        'long_description': 'Flexible 12-tone map. Allow to '
                                            'map a note within an octave to '
                                            'another note in the same '
                                            'octave-range +- 12 semitones. '
                                            'Alternatively notes can also be '
                                            'masked (disabled). If two keys '
                                            'are mapped to the same note, the '
                                            'corresponding note on/events are '
                                            'latched: only the first note on '
                                            'and last note off will be sent. '
                                            'The settings can be changed '
                                            'dynamically: Note-on/off events '
                                            'will be sent accordingly.',
                        'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                        'tags': {'midi'},
                        'video_url': ''},
 'midi_mapcc': {'category': 0,
                'controls': {'ccin': ['CC Input', 0, 0, 127, 'int'],
                             'ccout': ['CC Output', 0, 0, 127, 'int'],
                             'channelf': ['Filter Channel', 0, 0, 16, 'int']},
                'description': 'change one control message into another',
                'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                'long_description': 'Combine with scalecc to modify/scale the '
                                    'actual value.',
                'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_mono_legato': {'category': 0,
                      'controls': {'channelf': ['Filter Channel',
                                                0,
                                                0,
                                                16,
                                                'int']},
                      'description': 'hold a note until the next note arrives',
                      'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                      'long_description': 'Play the same note again to switch '
                                          'it off.',
                      'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                      'tags': {'midi'},
                      'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_no_active_sensing': {'category': 0,
                            'controls': {},
                            'description': 'strip MIDI Active-Sensing events',
                            'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                            'long_description': 'Filter to block all active '
                                                'sensing events. Active '
                                                'sensing messages are optional '
                                                'MIDI messages and intended to '
                                                'be sent repeatedly to tell a '
                                                'receiver that a connection is '
                                                'alive, however they can '
                                                'clutter up the MIDI channel '
                                                'or be inadvertently recorded '
                                                'when dumping raw MIDI data to '
                                                'disk.',
                            'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                            'tags': {'midi'},
                            'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_nodup': {'category': 0,
                'controls': {'channelf': ['Filter Channel', 0, 0, 16, 'int']},
                'description': 'MIDI duplicate blocker.',
                'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                'long_description': 'Filter out overlapping note on/off and '
                                    'duplicate messages.',
                'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_note_to_cc': {'category': 0,
                     'controls': {'channelf': ['Filter Channel',
                                               0,
                                               0,
                                               16,
                                               'int'],
                                  'key': ['Active Key (midi-note)',
                                          48,
                                          0,
                                          127,
                                          'int'],
                                  'mode': ['Operation Mode', 0, 0, 3, 'int'],
                                  'nooff': ['Ignore Note Off', 1, 0, 1, 'bool'],
                                  'param': ['CC Parameter', 1, 0, 127, 'int']},
                     'description': 'convert MIDI note-on messages to control '
                                    'change messages',
                     'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                     'long_description': 'Convert only MIDI note-on messages '
                                         'to control change messages (ignored '
                                         'in toggle mode).',
                     'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_note_to_cv': {'category': 1,
                     'controls': {'Cent': ['Cent', 0, -100, 100, 'int'],
                                  'Octave': ['Octave', 0, -3, 3, 'int'],
                                  'Panic': ['Panic', 0, 0, 1, 'bool'],
                                  'Retrigger': ['Retrigger',
                                                0.0,
                                                0.0,
                                                1.0,
                                                'bool'],
                                  'Semitone': ['Semitone', 0, -12, 12, 'int'],
                                  'channel': ['Channel', 1, 1, 16, 'int']},
                     'description': 'convert MIDI notes to v per octave pitch '
                                    'CVs',
                     'inputs': {'in': ['MIDI Input', 'AtomPort']},
                     'long_description': '',
                     'outputs': {'Gate': ['Gate', 'CVPort'],
                                 'Pitch': ['Pitch', 'CVPort'],
                                 'Velocity': ['Velocity', 'CVPort']},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_note_to_pgm': {'category': 0,
                      'controls': {'channelf': ['Filter Channel',
                                                0,
                                                0,
                                                16,
                                                'int'],
                                   'minvel': ['Min Velocity', 1, 0, 127, 'int'],
                                   'mode': ['Mode', 0, 0, 11, 'int'],
                                   'off': ['Offset', 0, -64, 64, 'int']},
                      'description': 'convert MIDI note messages to '
                                     'patch/program change messages',
                      'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                      'long_description': 'Mode: Mapping from note to '
                                          'patch-change. This is either '
                                          'chromatic mapping start at the '
                                          'lowest note (C-1), or white-keys '
                                          '(C-major scale) starting at a given '
                                          'C.',
                      'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                      'tags': {'midi'},
                      'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_note_toggle': {'category': 0,
                      'controls': {'channelf': ['Filter Channel',
                                                0,
                                                0,
                                                16,
                                                'int']},
                      'description': 'toggle notes: play a note to turn it on, '
                                     'play it again to turn it off',
                      'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                      'long_description': '',
                      'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                      'tags': {'midi'},
                      'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_ntap_delay': {'broadcast_ports': {'delayBPM': ['BPM', 120, 1, 320]},
                     'category': 0,
                     'controls': {'channelf': ['Filter Channel',
                                               0,
                                               0,
                                               16,
                                               'int'],
                                  'delayBPM': ['BPM', 120.0, 1.0, 280.0, 'int'],
                                  'delayBeats': ['Repeat-time in beats',
                                                 1.0,
                                                 0.00390625,
                                                 16.0],
                                  'taps': ['Repeats', 3, 0, 64, 'int'],
                                  'velocityadj': ['velocity ramp',
                                                  -10.0,
                                                  -64.0,
                                                  64.0,
                                                  'int']},
                     'description': 'repeat MIDI notes N times (incl '
                                    'tempo-ramps)',
                     'inputs': {'delayBPM': ['bpm', 'ControlPort'],
                                'midiin': ['MIDI In', 'AtomPort']},
                     'long_description': '',
                     'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_one_channel_filter': {'category': 0,
                             'controls': {'channel': ['Channel',
                                                      1,
                                                      1,
                                                      16,
                                                      'int']},
                             'description': 'basic MIDI channel filter',
                             'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                             'long_description': 'This effect repeats notes N '
                                                 'times. Where N is either a '
                                                 'fixed number or unlimited as '
                                                 'long as a given key is '
                                                 'pressed. BPM and delay-time '
                                                 'variable allows tempo-ramps. '
                                                 'On every repeat the given '
                                                 'velocity-adjustment is added '
                                                 'or subtracted, the result is '
                                                 'clamped between 1 and 127.',
                             'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                             'tags': {'midi'},
                             'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_output': {'controls': {},
                 'inputs': {'input': ['out', 'AtomPort']},
                 'long_description': '',
                 'outputs': {},
                 'tags': set(),
                 'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_pc': {'broadcast_ports': {'pc_out': ['Current PC', 0, 0, 127]},
             'category': 0,
             'controls': {'CHAN': ['Channel', 1, 1, 16, 'int'],
                          'PC_NUM': ['PC Number', 0, 0, 127, 'int']},
             'description': 'Send a MIDI program change message when triggered',
             'inputs': {'DOWN_CV': ['down trigger', 'CVPort'],
                        'SET_CV': ['set trigger', 'CVPort'],
                        'UP_CV': ['up trigger', 'CVPort']},
             'long_description': '',
             'outputs': {'MIDI_OUT': ['MIDI Out', 'AtomPort']},
             'tags': {'midi'}},
 'midi_quantize': {'category': 0,
                   'controls': {'bpm': ['BPM', 120.0, 1.0, 280.0, 'int'],
                                'mindur': ['Note-off behaviour',
                                           1,
                                           0,
                                           1,
                                           'int'],
                                'quant': ['Quantization Grid',
                                          0.25,
                                          0.00390625,
                                          4.0,
                                          'int']},
                   'description': 'live midi event quantization',
                   'inputs': {'bpm': ['bpm', 'ControlPort'],
                              'midiin': ['MIDI In', 'AtomPort']},
                   'long_description': 'Live event quantization. This filter '
                                       'aligns incoming MIDI events to a fixed '
                                       'time-grid. Since the effect operates '
                                       'on a live-stream it will introduce '
                                       'latency: Events will be delayed until '
                                       'the next "tick". If you provide tempo, '
                                       'the events are aligned to the clock '
                                       'otherwise the effect runs on its own '
                                       'time.',
                   'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_rand_velocity': {'category': 0,
                        'controls': {'channel': ['Filter Channel',
                                                 0,
                                                 0,
                                                 16,
                                                 'int'],
                                     'mode': ['Random Mode', 1, 0, 1, 'bool'],
                                     'randfact': ['Velocity Randomization',
                                                  8.0,
                                                  0.0,
                                                  127.0,
                                                  'int']},
                        'description': 'randomly change velocity of note-on '
                                       'events',
                        'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                        'long_description': 'Randomize Velocity of MIDI notes '
                                            '(both note on and note off).',
                        'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                        'tags': {'midi'},
                        'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_scale_cc': {'category': 0,
                   'controls': {'channelf': ['Filter Channel', 0, 0, 16, 'int'],
                                'lower': ['Parameter (Min)', 0, 0, 127, 'int'],
                                'pmode': ['Parameter Mode', 1, 0, 2, 'int'],
                                'upper': ['Parameter (Max)',
                                          127,
                                          0,
                                          127,
                                          'int'],
                                'valmul': ['Value Scale',
                                           1.0,
                                           -10.0,
                                           10.0,
                                           'int'],
                                'valoff': ['Value Offset', 0, -64, 64, 'int'],
                                'vmode': ['Value Mode', 0, 0, 2, 'int']},
                   'description': 'modify the value (data-byte) of a MIDI '
                                  'control change message',
                   'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                   'long_description': 'Parameter (Min): lower end of '
                                       'parameter-range (inclusive)Parameter '
                                       '(Max): upper end of parameter-range '
                                       '(inclusive)Parameter Mode: 0 = Bypass, '
                                       '1 = Include Range, 2 = Exclude '
                                       'RangeValue Mode: 0 = Clamp to 0..127, '
                                       '1 = Reflect Overflow (-1 to 1, 128 to '
                                       '127), 2 = Truncate Overflow (-1 to '
                                       '127, 128 to 0)',
                   'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                   'tags': {'midi'},
                   'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_sostenuto': {'category': 0,
                    'controls': {'channelf': ['Filter Channel',
                                              0,
                                              0,
                                              16,
                                              'int'],
                                 'pedal': ['Pedal Mode', 1, 0, 2, 'int'],
                                 'sostenuto': ['Sostenuto [sec]',
                                               0.0,
                                               0.0,
                                               600.0,
                                               'int']},
                    'description': 'delay note-off messages, emulate a piano '
                                   'sostenuto pedal',
                    'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                    'long_description': 'This filter delays note-off messages '
                                        'by a given time, emulating a piano '
                                        'sostenuto pedal. When the pedal is '
                                        'released, note-off messages that are '
                                        'queued will be sent immediately. The '
                                        'delay-time can be changed '
                                        'dynamically, changes do affects '
                                        'note-off messages that are still '
                                        'queued.Sostenuto [sec]: Time to delay '
                                        'the note-off signal.Pedal Mode: Mode '
                                        'of the sustain pedal. Fixed on (pedal '
                                        'pressed) or off (pedal released) for '
                                        'notes of all MIDI channels. The '
                                        'on/off state can alternatively be set '
                                        'by CC, in which case it is per '
                                        'MIDI-channel.',
                    'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                    'tags': {'midi'},
                    'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_strum': {'category': 0,
                'controls': {'adjspeed': ['Strum Acceleration',
                                          0.0,
                                          -1.0,
                                          1.0,
                                          'int'],
                             'adjvelocity': ['Velocity Change',
                                             0.0,
                                             -112.0,
                                             112.0,
                                             'int'],
                             'bpm': ['BPM', 120.0, 1.0, 280.0, 'int'],
                             'collect': ['Note Collect Timeout [ms]',
                                         15.0,
                                         0.0,
                                         300.0,
                                         'int'],
                             'duration': ['Strum Duration in Beats',
                                          0.25,
                                          0.0,
                                          4.0,
                                          'int'],
                             'mode': ['Strum Direction', 2, 0, 4, 'int'],
                             'randspeed': ['Randomize Acceleration',
                                           0.0,
                                           0.0,
                                           1.0,
                                           'bool'],
                             'randvelocity': ['Randomize Velocity',
                                              0.0,
                                              0.0,
                                              1.0,
                                              'bool']},
                'description': 'arpeggio effect intended to simulate strumming '
                               'a stringed instrument (e.g. guitar)',
                'inputs': {'bpm': ['bpm', 'ControlPort'],
                           'midiin': ['MIDI In', 'AtomPort']},
                'long_description': 'A chord is "collected" and the single '
                                    'notes of the chord are played back spread '
                                    'out over time. The "Note Collect Timeout" '
                                    'allows for the effect to be played live '
                                    'with midi-keyboard, it compensates for a '
                                    'human not pressing keys at the same point '
                                    'in time. If the effect is used with a '
                                    'sequencer that can send chords with all '
                                    'note-on at the exactly time, it should be '
                                    'set to zero.BPM: base unit for the '
                                    'timeStrum Direction: 0 = Always Down (low '
                                    'notes first), 1 = Always Up (high notes '
                                    'first), 2 = Alternate, 3 = Up/Down Beat, '
                                    '4 = Up/Down 8thNote Collect Timeout [ms]: '
                                    'Time to wait for chord to be "complete". '
                                    'Keys pressed withing given timeframe will '
                                    'be combined into one chord.Strum Duration '
                                    'in Beats: 0 = Immediate, 0.125 = 32nd, '
                                    '0.25 = 16th, 0.5 = Eighth, 1 = Quarter, 2 '
                                    '= Half Note, 4 = Whole NoteStrum '
                                    'Acceleration: Accellerate/Decelerate over '
                                    'the time of the strum. The total duration '
                                    'remains unchanged. If the value is '
                                    'greater than zero, early notes are '
                                    'further apart and later notes will be '
                                    'closer together.Velocity Change: Modify '
                                    'velocity over stroke time. If the value '
                                    'is greater than zero, later notes will '
                                    'played louder.Randomize Acceleration: '
                                    'Amount of randomization to apply to the '
                                    'accel/decel setting. A Value of 1.0 means '
                                    'to add a random-number of the full-range '
                                    '(-1..1) to the given value.Randomize '
                                    'Velocity: Amount of randomization to '
                                    'apply to the acceleation value. A value '
                                    'of 1.0 means to add a random-number of '
                                    'the full-range (-112..112) to the given '
                                    'value.',
                'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                'tags': {'midi'},
                'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_tonal_pedal': {'category': 0,
                      'controls': {'forward_cc': ['Forward CC',
                                                  0,
                                                  0,
                                                  1,
                                                  'bool'],
                                   'pedal': ['Pedal CC', 0, 0, 1, 'bool']},
                      'description': 'Holds any notes that are currently '
                                     'played when the sustain pedal is pressed '
                                     'for as long as the pedal remains '
                                     'pressed.',
                      'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                      'long_description': 'Releasing the pedal sends Note-Off '
                                          'events. New notes played after '
                                          'presseing the pedal are not '
                                          'affected.',
                      'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                      'tags': {'midi'},
                      'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_transpose': {'category': 0,
                    'controls': {'channelf': ['Filter Channel',
                                              0,
                                              0,
                                              16,
                                              'int'],
                                 'inversion': ['Inversion point',
                                               0,
                                               0,
                                               127,
                                               'int'],
                                 'transpose': ['Transpose', 0, -63, 64, 'int']},
                    'description': 'chromatic transpose MIDI notes',
                    'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                    'long_description': 'Chromatic transpose of midi notes and '
                                        'key-pressure. If an inversion point '
                                        'is set, the scale is mirrored around '
                                        'this point before transposing. Notes '
                                        'that end up outside the valid range '
                                        '0..127 are discarded.',
                    'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                    'tags': {'midi'},
                    'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_velocity_gamma': {'category': 0,
                         'controls': {'channel': ['Channel', 0, 0, 16, 'int'],
                                      'offgamma': ['Note-off Gamma',
                                                   1.0,
                                                   0.0,
                                                   5.0,
                                                   'int'],
                                      'ongamma': ['Note-on Gamma',
                                                  1.0,
                                                  0.0,
                                                  5.0,
                                                  'int']},
                         'description': 'modify note velocity curve by a gamma '
                                        'exponent',
                         'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                         'long_description': 'Change the velocity of note '
                                             'events with separate controls '
                                             'for Note-on and Note-off. '
                                             'Velocities are first normalized '
                                             'to the range 0..1, then the '
                                             'gamma is applied as an exponent, '
                                             'and then the result is scaled '
                                             'back onto the 0..127 range. '
                                             'Higher gamma values produce a '
                                             '"softer" velocity curve, lower '
                                             'gamma values make the low end '
                                             'harder. Gamma = 0 effectively '
                                             'produces a constant velocity.',
                         'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                         'tags': {'midi'},
                         'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_velocity_range': {'category': 0,
                         'controls': {'channelf': ['Filter Channel',
                                                   0,
                                                   0,
                                                   16,
                                                   'int'],
                                      'lower': ['Min Volume', 0, 0, 127, 'int'],
                                      'mode': ['Operation Mode',
                                               1,
                                               0,
                                               3,
                                               'int'],
                                      'upper': ['Max Volume',
                                                127,
                                                0,
                                                127,
                                                'int']},
                         'description': 'filter MIDI note events according to '
                                        'velocity',
                         'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                         'long_description': 'Note-on events outside the '
                                             'allowed range are discarded. If '
                                             'a Note-off is received for a '
                                             'note that was previously '
                                             'filtered, it is also not passed '
                                             'though. If the allowed range '
                                             'changes, note-off events are '
                                             'sent to currently active notes '
                                             'that end up outside the valid '
                                             'range.',
                         'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                         'tags': {'midi'},
                         'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'midi_velocity_scale': {'category': 0,
                         'controls': {'channel': ['Channel', 0, 0, 16, 'int'],
                                      'offmax': ['Note-off Max',
                                                 127.0,
                                                 0.0,
                                                 127.0,
                                                 'int'],
                                      'offmin': ['Note-off Min',
                                                 0.0,
                                                 0.0,
                                                 127.0,
                                                 'int'],
                                      'offoff': ['Note-off Offset',
                                                 0.0,
                                                 -64.0,
                                                 64.0,
                                                 'int'],
                                      'onmax': ['Note-on Max',
                                                127.0,
                                                0.0,
                                                127.0,
                                                'int'],
                                      'onmin': ['Note-on Min',
                                                1.0,
                                                1.0,
                                                127.0,
                                                'int'],
                                      'onoff': ['Note-on Offset',
                                                0.0,
                                                -64.0,
                                                64.0,
                                                'int']},
                         'description': 'modify note velocity by constant '
                                        'factor and offset',
                         'inputs': {'midiin': ['MIDI In', 'AtomPort']},
                         'long_description': 'Change the velocity of note '
                                             'events with separate controls '
                                             'for Note-on and Note-off. The '
                                             'input range 1 - 127 is mapped to '
                                             'the range between Min and Max. '
                                             'If Min is greater than Max, the '
                                             'range is reversed. The offsets '
                                             'value is added to the velocity '
                                             'event after mapping the Min/Max '
                                             'range.',
                         'outputs': {'midiout': ['MIDI Out', 'AtomPort']},
                         'tags': {'midi'},
                         'video_url': 'https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s'},
 'min': {'category': 2,
         'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
         'description': 'min of a, b also logical and',
         'inputs': {'a_cv': ['A CV', 'CVPort'], 'b_cv': ['B CV', 'CVPort']},
         'long_description': '',
         'outputs': {'out': ['Output', 'CVPort']},
         'tags': {'utilities'},
         'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=525s'},
 'mix_vca': {'category': 2,
             'controls': {'gain1': ['Gain Offset', 0, 0, 1],
                          'gain1Data': ['Main Gain', 0.0, -1.0, 1.0],
                          'gain2': ['2nd Gain Boost', 0, 0, 1],
                          'gain2Data': ['2nd Gain', 0.0, -1.0, 1.0],
                          'in1': ['In 1 Level', 1, 0, 2],
                          'in2': ['In 2 Level', 1, 0, 2],
                          'outputLevel': ['Output Level', 1, 0, 2]},
             'description': 'Voltage controlled amplifier. Used to change the '
                            'level from a control signal.',
             'inputs': {'gain1Data': ['Main Gain', 'CVPort'],
                        'gain2Data': ['2nd Gain', 'CVPort'],
                        'in1Data': ['In 1', 'AudioPort'],
                        'in2Data': ['In 2', 'AudioPort']},
             'long_description': '',
             'outputs': {'out': ['Out', 'AudioPort']},
             'tags': {'level + dynamics'},
             'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=582s'},
 'mono_EQ': {'category': 0,
             'controls': {'HPQ': ['HighPass Resonance', 0.7, 0.0, 1.4],
                          'HPfreq': ['Highpass Frequency', 20.0, 5.0, 1250.0],
                          'HSfreq': ['Highshelf Frequency',
                                     8000.0,
                                     1000.0,
                                     16000.0],
                          'HSgain': ['Highshelf Gain', 0.0, -18.0, 18.0],
                          'HSq': ['Highshelf Bandwidth', 1.0, 0.0625, 4.0],
                          'HSsec': ['Highshelf', 1, 0, 1],
                          'HighPass': ['Highpass', 0, 0, 1],
                          'LPQ': ['LowPass Resonance', 1.0, 0.0, 1.4],
                          'LPfreq': ['Lowpass Frequency',
                                     20000.0,
                                     500.0,
                                     20000.0],
                          'LSfreq': ['Lowshelf Frequency', 80.0, 25.0, 400.0],
                          'LSgain': ['Lowshelf Gain', 0.0, -18.0, 18.0],
                          'LSq': ['Lowshelf Bandwidth', 1.0, 0.0625, 4.0],
                          'LSsec': ['Lowshelf', 1, 0, 1],
                          'LowPass': ['Lowpass', 0, 0, 1],
                          'enable': ['Enable', 1, 0, 1],
                          'freq1': ['Frequency 1', 160.0, 20.0, 2000.0],
                          'freq2': ['Frequency 2', 397.0, 40.0, 4000.0],
                          'freq3': ['Frequency 3', 1250.0, 100.0, 10000.0],
                          'freq4': ['Frequency 4', 2500.0, 200.0, 20000.0],
                          'gain': ['Gain', 0.0, -18.0, 18.0],
                          'gain1': ['Gain 1', 0.0, -18.0, 18.0],
                          'gain2': ['Gain 2', 0.0, -18.0, 18.0],
                          'gain3': ['Gain 3', 0.0, -18.0, 18.0],
                          'gain4': ['Gain 4', 0.0, -18.0, 18.0],
                          'peakreset': ['Reset Peak Hold', 1, 0, 1],
                          'q1': ['Bandwidth 1', 0.6, 0.0625, 4.0],
                          'q2': ['Bandwidth 2', 0.6, 0.0625, 4.0],
                          'q3': ['Bandwidth 3', 0.6, 0.0625, 4.0],
                          'q4': ['Bandwidth 4', 0.6, 0.0625, 4.0],
                          'sec1': ['Section 1', 1, 0, 1],
                          'sec2': ['Section 2', 1, 0, 1],
                          'sec3': ['Section 3', 1, 0, 1],
                          'sec4': ['Section 4', 1, 0, 1]},
             'description': 'Mono multiband parametric EQ',
             'inputs': {'in': ['In', 'AudioPort']},
             'long_description': '',
             'outputs': {'out': ['Out', 'AudioPort']},
             'tags': {'level + dynamics'},
             'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=598s'},
 'short_mono_cab': {'category': 0,
              'controls': {'gain': ['Output Gain', 0.0, -40.0, 24.0],
                           'ir': ['/audio/cabs/1x12cab.wav', 0, 0, 1]},
              'description': 'Mono cab sim',
              'inputs': {'gain': ['Output Gain', 'CVPort'],
                         'in': ['In', 'AudioPort']},
              'long_description': '',
              'outputs': {'out': ['Out', 'AudioPort']},
              'tags': {'amps, cabs + gain'},
              'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=827s'},
 'mono_cab': {'category': 0,
              'controls': {'wet': ['Wet level', 0.0, -60.0, 6.0],
                           'ir': ['/audio/cabs/1x12cab.wav', 0, 0, 1]},
              'description': 'Mono cab sim',
              'inputs': {'gain': ['Output Gain', 'CVPort'],
                         'in': ['In', 'AudioPort']},
              'long_description': '',
              'outputs': {'out': ['Out', 'AudioPort']},
              'tags': {'amps, cabs + gain'},
              'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=827s'},
 'mono_compressor': {'category': 0,
                     'controls': {'Ratio': ['Ratio', 0.0, 0.0, 1.0],
                                  'attack': ['Attack Time', 0.01, 0.001, 0.1],
                                  'enable': ['Enable', 1, 0, 1, 'hide'],
                                  'hold': ['Hold', 0, 0, 1, 'bool'],
                                  'inputgain': ['Input Gain', 0.0, -10.0, 30.0],
                                  'release': ['Release Time', 0.3, 0.03, 3.0],
                                  'threshold': ['Threshold',
                                                -30.0,
                                                -50.0,
                                                -10.0]},
                     'description': 'RMS downward compressor with auto markup',
                     'inputs': {'in': ['In', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'out': ['Out', 'AudioPort']},
                     'tags': {'level + dynamics'},
                     'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=1082s'},
 'mono_reverb': {'category': 0,
                 'controls': {'enabled': ['Enabled', 1, 0, 1],
                              'gain': ['Output Gain', 0.0, -40.0, 4.0],
                              'ir': ['/audio/reverbs/emt_140_dark_1.wav',
                                     0,
                                     0,
                                     1]},
                 'description': 'Mono convolution based reverb.',
                 'inputs': {'gain': ['Output Gain', 'CVPort'],
                            'in': ['In', 'AudioPort']},
                 'kill_dry': True,
                 'long_description': '',
                 'outputs': {'out': ['Out', 'AudioPort']},
                 'tags': {'time effects'},
                 'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=1595s'},
 'multi_resonator': {'category': 3,
                     'controls': {'brightness_mod_param': ['Brightness Mod',
                                                           0,
                                                           -1.0,
                                                           1.0],
                                  'brightness_param': ['Brightness',
                                                       0.5,
                                                       0.0,
                                                       1.0],
                                  'damping_mod_param': ['Damping Mod',
                                                        0,
                                                        -1.0,
                                                        1.0],
                                  'damping_param': ['Damping', 0.5, 0.0, 1.0],
                                  'frequency_mod_param': ['Frequency Mod',
                                                          0,
                                                          -1.0,
                                                          1.0],
                                  'frequency_param': ['Frequency',
                                                      30,
                                                      0.0,
                                                      60.0],
                                  'internal_exciter_param': ['Internal Exicter',
                                                             1.0,
                                                             0.0,
                                                             1.0,
                                                             'bool'],
                                  'polyphony_param': ['Polyphony', 0, 0.0, 2.0],
                                  'position_mod_param': ['Position Mod',
                                                         0,
                                                         -1.0,
                                                         1.0],
                                  'position_param': ['Position', 0.5, 0.0, 1.0],
                                  'resonator_param': ['Resonator', 0, 0.0, 6.0],
                                  'structure_mod_param': ['Structure Mod',
                                                          0,
                                                          -1.0,
                                                          1.0],
                                  'structure_param': ['Structure',
                                                      0.5,
                                                      0.0,
                                                      1.0],
                                  'enabled': ['Enabled', 1, 0, 1],
                                  },
                     # 'kill_dry': True,
                     'description': 'Resonator building block simulating '
                                    'multiple vibrating structures. Based on '
                                    'Rings by Mutable Instruments.',
                     'inputs': {'brightness_mod_input': ['Brightness Mod',
                                                         'CVPort'],
                                'damping_mod_input': ['Damping Mod', 'CVPort'],
                                'frequency_mod_input': ['Frequency Mod',
                                                        'CVPort'],
                                'in_input': ['In', 'AudioPort'],
                                'pitch_input': ['Pitch', 'CVPort'],
                                'position_mod_input': ['Position Mod',
                                                       'CVPort'],
                                'structure_mod_input': ['Structure Mod',
                                                        'CVPort'],
                                'strum_input': ['Strum', 'CVPort']},
                     'manual_url': 'https://www.mutable-instruments.net/modules/rings/manual/',
                     'outputs': {'even_output': ['Even', 'AudioPort'],
                                 'odd_output': ['Odd', 'AudioPort']},
                     'tags': {'pitch + synth', 'ported'},
                     'video_url': 'https://www.youtube.com/watch?v=KU8xxLjNQMI&t=2570s'},
 'note_sequencer': {'broadcast_ports': {'bpm': ['tempo', 120, 1, 320],
                                        'current_step_out': ['current step out',
                                                             0,
                                                             0,
                                                             16]},
                    'category': 2,
                    'controls': {'back_gate': ['back', 0.0, 0.0, 1.0],
                                 'bpm': ['BPM', 120, 20, 320],
                                 'note_length': ['Note Length',
                                                 0.125,
                                                 0.03125,
                                                 1],
                                 'octave': ['octave', 0, -4, 4.0],
                                 'play': ['play', 0.0, 0.0, 1.0],
                                 'steps': ['Loop Steps', 16, 1, 16],
                                 'val0': ['Value 0', 6, 0, 12],
                                 'val1': ['Value 1', 6, 0, 12],
                                 'val10': ['Value 10', 6, 0, 12],
                                 'val11': ['Value 11', 6, 0, 12],
                                 'val12': ['Value 12', 6, 0, 12],
                                 'val13': ['Value 13', 6, 0, 12],
                                 'val14': ['Value 14', 6, 0, 12],
                                 'val15': ['Value 15', 6, 0, 12],
                                 'val2': ['Value 2', 6, 0, 12],
                                 'val3': ['Value 3', 6, 0, 12],
                                 'val4': ['Value 4', 6, 0, 12],
                                 'val5': ['Value 5', 6, 0, 12],
                                 'val6': ['Value 6', 6, 0, 12],
                                 'val7': ['Value 7', 6, 0, 12],
                                 'val8': ['Value 8', 6, 0, 12],
                                 'val9': ['Value 9', 6, 0, 12]},
                    'description': '16 Step note sequencer with internal clock',
                    'inputs': {'back_gate': ['Back Gate', 'CVPort'],
                               'bpm': ['BPM', 'ControlPort'],
                               'play': ['Play', 'CVPort'],
                               'reset': ['Reset Trigger', 'CVPort']},
                    'long_description': '',
                    'outputs': {'out': ['Value Out', 'CVPort']},
                    'tags': {'cv generators'},
                    'video_url': 'https://www.youtube.com/watch?v=n6cvz_eARg8&t=0s'},
 'note_sequencer_ext': {'broadcast_ports': {'current_step_out': ['current step '
                                                                 'out',
                                                                 0,
                                                                 0,
                                                                 16]},
                        'category': 2,
                        'controls': {'octave': ['Octave', 0, -4.0, 4.0],
                                     'steps': ['Loop Steps', 16, 1, 16],
                                     'val0': ['Value 0', 6, 0, 12],
                                     'val1': ['Value 1', 6, 0, 12],
                                     'val10': ['Value 10', 6, 0, 12],
                                     'val11': ['Value 11', 6, 0, 12],
                                     'val12': ['Value 12', 6, 0, 12],
                                     'val13': ['Value 13', 6, 0, 12],
                                     'val14': ['Value 14', 6, 0, 12],
                                     'val15': ['Value 15', 6, 0, 12],
                                     'val2': ['Value 2', 6, 0, 12],
                                     'val3': ['Value 3', 6, 0, 12],
                                     'val4': ['Value 4', 6, 0, 12],
                                     'val5': ['Value 5', 6, 0, 12],
                                     'val6': ['Value 6', 6, 0, 12],
                                     'val7': ['Value 7', 6, 0, 12],
                                     'val8': ['Value 8', 6, 0, 12],
                                     'val9': ['Value 9', 6, 0, 12]},
                        'description': '16 Step note sequencer that takes in a '
                                       'trigger for next or previous',
                        'inputs': {'back_trigger': ['Back Trigger', 'CVPort'],
                                   'reset': ['Reset Trigger', 'CVPort'],
                                   'trigger': ['Step Trigger', 'CVPort']},
                        'long_description': '',
                        'outputs': {'out': ['Value Out', 'CVPort']},
                        'tags': {'cv generators'},
                        'video_url': 'https://www.youtube.com/watch?v=n6cvz_eARg8&t=379s'},
 'onset_detect': {'category': 2,
                  'controls': {'onset_threshold': ['Onset Threshold',
                                                   0.3,
                                                   0.1,
                                                   1.0],
                               'silence_threshold': ['Silence Threshold',
                                                     -90.0,
                                                     -90.0,
                                                     -10.0]},
                  'description': 'detects when a note starts and sends a '
                                 'trigger',
                  'inputs': {'in': ['In', 'AudioPort']},
                  'long_description': '',
                  'outputs': {'gate': ['Gate', 'CVPort']},
                  'tags': {'cv generators'},
                  'video_url': 'https://www.youtube.com/watch?v=n6cvz_eARg8&t=1000s'},
 'oog_half_lpf': {'category': 3,
                  'controls': {'Q': ['Q', 1, 0.7072, 25],
                               'cutoff': ['cutoff', 0.5, 0, 1]},
                  'description': 'A low pass filter inspired by vintage '
                                 'American designs',
                  'inputs': {'cutoff_cv': ['Cutoff CV', 'CVPort'],
                             'in': ['in', 'AudioPort'],
                             'q_cv': ['Q CV', 'CVPort']},
                  'long_description': '',
                  'outputs': {'out': ['out', 'AudioPort']},
                  'tags': {'pitch + synth'},
                  'video_url': 'https://www.youtube.com/watch?v=n6cvz_eARg8&t=1575s'},
 'output': {'controls': {},
            'inputs': {'input': ['out', 'AudioPort']},
            'long_description': '',
            'outputs': {},
            'tags': set(),
            'video_url': ''},
 'pan': {'category': 0,
         'controls': {'panOffset': ['Pan Offset', 0, -1, 1]},
         'description': 'Control signal controlled panner',
         'inputs': {'in': ['In', 'AudioPort'], 'panCV': ['Pan CV', 'CVPort']},
         'long_description': '',
         'outputs': {'out1': ['Out L', 'AudioPort'],
                     'out2': ['Out R', 'AudioPort']},
         'tags': {'level + dynamics'},
         'video_url': 'https://www.youtube.com/watch?v=n6cvz_eARg8&t=1926s'},
 'phaser': {'category': 0,
            'controls': {'color': ['Color', 1, 0, 1, 'bool'],
                         'feedback_depth': ['Feedback depth', 75, 0, 99],
                         'feedback_hpf_cutoff': ['Feedback bass cut',
                                                 500.0,
                                                 10.0,
                                                 5000.0],
                         'lfo_frequency': ['LFO frequency', 0.2, 0.01, 5.0],
                         'mix': ['Dry/wet mix', 50, 0, 100]},
            'description': 'Basic phaser',
            'inputs': {'lv2_audio_in_1': ['Audio Input 1', 'AudioPort']},
            'long_description': '',
            'outputs': {'lv2_audio_out_1': ['Audio Output 1', 'AudioPort']},
            'tags': {'mod effects'},
            'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=0s'},
 'phaser_ext': {'category': 0,
                'controls': {'color': ['Color', 1, 0, 1, 'bool'],
                             'feedback_depth': ['Feedback depth', 75, 0, 99],
                             'feedback_hpf_cutoff': ['Feedback bass cut',
                                                     500.0,
                                                     10.0,
                                                     5000.0],
                             'mix': ['Dry/wet mix', 50, 0, 100]},
                'description': 'Mono phaser controlled by CV input',
                'inputs': {'lv2_audio_in_1': ['Audio Input 1', 'AudioPort'],
                           'lv2_audio_in_2': ['LFO CV', 'CVPort']},
                'long_description': '',
                'outputs': {'lv2_audio_out_1': ['Audio Output 1', 'AudioPort']},
                'tags': {'mod effects'},
                'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=379s'},
 'phaser_stereo_ext': {'category': 0,
                       'controls': {'color': ['Color', 1, 0, 1],
                                    'feedback_depth': ['Feedback depth',
                                                       75,
                                                       0,
                                                       99],
                                    'feedback_hpf_cutoff': ['Feedback bass cut',
                                                            500.0,
                                                            10.0,
                                                            5000.0],
                                    'mix': ['Dry/wet mix', 50, 0, 100],
                                    'stereo_phase': ['Stereo phase',
                                                     0,
                                                     -180,
                                                     180]},
                       'description': 'Stereo phaser controlled by CV input',
                       'inputs': {'lv2_audio_in_1': ['Audio Input 1',
                                                     'AudioPort'],
                                  'lv2_audio_in_2': ['Audio Input 2',
                                                     'AudioPort'],
                                  'lv2_audio_in_3': ['LFO CV', 'CVPort']},
                       'long_description': '',
                       'outputs': {'lv2_audio_out_1': ['Audio Output 1',
                                                       'AudioPort'],
                                   'lv2_audio_out_2': ['Audio Output 2',
                                                       'AudioPort']},
                       'tags': {'mod effects'},
                       'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=379s'},
 'pitch_cal_in': {'broadcast_ports': {'max_level': ['Max Level', 0, -2.0, 2.0],
                                      'min_level': ['Min Level', 0, -2.0, 2.0]},
                  'category': 0,
                  'controls': {'measure': ['measure', 0, 0, 1],
                               'offset': ['offset', 0, -1, 1],
                               'scale': ['scale', 1, 0, 2]},
                  'description': 'Pitch Calibration for a v per oct input',
                  'inputs': {'input': ['input', 'CVPort']},
                  'long_description': '',
                  'outputs': {'output': ['output', 'CVPort']},
                  'tags': {'pitch + synth'},
                  'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=546s'},
 'pitch_cal_out': {'category': 0,
                   'controls': {'offset': ['offset', 0, -5, 5],
                                'scale': ['scale', 1, 0, 2]},
                   'description': 'Pitch Calibration for a v per oct output',
                   'inputs': {'input': ['input', 'CVPort']},
                   'long_description': '',
                   'outputs': {'output': ['output', 'CVPort']},
                   'tags': {'pitch + synth'},
                   'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=757s'},
 'pitch_detect': {'category': 2,
                  'controls': {'onset_threshold': ['Onset Threshold',
                                                   0.3,
                                                   0.1,
                                                   1.0],
                               'pitch_threshold': ['Pitch Detection Tolerance',
                                                   0.3,
                                                   0.1,
                                                   0.7],
                               'silence_threshold': ['Silence Threshold',
                                                     -90.0,
                                                     -90.0,
                                                     -10.0]},
                  'description': 'BETA detects played notes and converts it '
                                 'volt per octave and MIDI',
                  'inputs': {'in': ['In', 'AudioPort']},
                  'long_description': '',
                  'outputs': {'gate': ['Gate', 'CVPort'],
                              'midi_out': ['Midi Out', 'AtomPort'],
                              'voct': ['V/Oct Pitch', 'CVPort']},
                  'tags': {'pitch + synth'},
                  'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=820s'},
 'pitch_shift': {'category': 3,
                 'controls': {'Drylevel': ['Dry Level', -90, -90, 20],
                              'Semitone': ['Semitone Shift', 0, -12, 12, 'int'],
                              'Wetlevel': ['Wet Level', 0, -90, 20]},
                 'description': 'a basic pitch shifter. It delays the input '
                                'signal',
                 'inputs': {'Input': ['Input', 'AudioPort'],
                            'SemitoneCV': ['V/Oct Pitch', 'CVPort']},
                 'long_description': '',
                 'outputs': {'Output': ['Output', 'AudioPort']},
                 'tags': {'pitch + synth'},
                 'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=1774s'},
 'pitch_verb': {'category': 0,
                'controls': {'blend_param': ['blend', 0.5, 0.0, 1.0],
                             'density_param': ['decay', 0.7, 0.0, 1.0],
                             'feedback_param': ['Modulation Speed',
                                                0.44,
                                                0.0,
                                                1.0],
                             'freeze_param': ['hold', 0.5, 0.0, 1.0],
                             'pitch_param': ['pitch', 0.0, -24.0, 24.0, 'int'],
                             'position_param': ['pre-delay', 0.5, 0.0, 1.0],
                             'reverb_param': ['Modulation Amount',
                                              0.0,
                                              0.0,
                                              1.0],
                             'reverse_param': ['reverse', 0.0, 0.0, 1.0],
                             'size_param': ['size', 0.77, 0.0, 1.0],
                             'spread_param': ['diffusion', 0.09, 0.0, 1.0],
                             'texture_param': ['damp', 0.33, 0.0, 1.0],
                             'enabled': ['Enabled', 1, 0, 1],
                             },
                # 'kill_dry': True,
                'description': 'A special effects algorthmic reverb, featuring '
                               'longer tails than the convolution reverb. '
                               'Based Parasites Oliverb firmware of Mutable '
                               'Intruments Clouds module. ',
                'inputs': {'Feedback': ['Modulation Speed', 'CVPort'],
                           'blend': ['Blend', 'CVPort'],
                           'density': ['Decay', 'CVPort'],
                           'freeze': ['Hold', 'CVPort'],
                           'l_in': ['L in', 'AudioPort'],
                           'pitch': ['Pitch', 'CVPort'],
                           'position': ['pre-delay', 'CVPort'],
                           'r_in': ['R in', 'AudioPort'],
                           'reverb': ['Modulation Amount', 'CVPort'],
                           'reverse': ['Reverse', 'CVPort'],
                           'size': ['Size', 'CVPort'],
                           'spread': ['Diffusion', 'CVPort'],
                           'texture': ['Damp', 'CVPort'],
                           'trig': ['Trigger', 'CVPort']},
                'long_description': 'This eurorack based algorithmic reverb is '
                                    'designed to be modulated by control '
                                    'values.\n'
                                    "                 It's great for special "
                                    "effects, and general weirdness. It isn't "
                                    "well suited to realistic sounds. It's "
                                    'capable of pitch shifting and self '
                                    'oscilliation.',
                'manual_url': 'https://mqtthiqs.github.io/parasites/clouds.html',
                'outputs': {'l_out': ['L Out', 'AudioPort'],
                            'r_out': ['R Out', 'AudioPort']},
                'tags': {'pitch + synth', 'ported'},
                'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2039s'},
 'poly_note_to_cv': {'category': 1,
                     'controls': {'Cent': ['Cent', 0, -100, 100, 'int'],
                                  'Octave': ['Octave', 0, -4, 4, 'int'],
                                  'Panic': ['Panic', 0, 0, 1, 'bool'],
                                  'Semitone': ['Semitone', 0, -12, 12, 'int'],
                                  'channel': ['Channel', 1, 1, 16, 'int']},
                     'description': 'convert poly MIDI notes to v per octave '
                                    'pitch CVs',
                     'inputs': {'MIDIIn': ['MIDI Input', 'AtomPort']},
                     'long_description': '',
                     'outputs': {'Gate1': ['Gate 1', 'CVPort'],
                                 'Gate2': ['Gate 2', 'CVPort'],
                                 'Gate3': ['Gate 3', 'CVPort'],
                                 'Gate4': ['Gate 4', 'CVPort'],
                                 'Pitch1': ['Pitch 1', 'CVPort'],
                                 'Pitch2': ['Pitch 2', 'CVPort'],
                                 'Pitch3': ['Pitch 3', 'CVPort'],
                                 'Pitch4': ['Pitch 4', 'CVPort'],
                                 'vel': ['Velocity', 'CVPort']},
                     'tags': {'midi'},
                     'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2338s'},
 'power_amp_cream': {'category': 0,
                     'controls': {'BASS': ['BASS', 0.5, 0.0, 1.0],
                                  'LEVEL': ['LEVEL', 0.5, 0.0, 1.0],
                                  'TREBLE': ['TREBLE', 0.5, 0.0, 1.0],
                                  'VOLUME': ['VOLUME', 0.5, 0.0, 1.0]},
                     'description': 'An attempt at a cream coloured power amp '
                                    'emulation.',
                     'inputs': {'in': ['In', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'out': ['Out', 'AudioPort']},
                     'tags': {'amps, cabs + gain'},
                     'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2483s'},
 'power_amp_super': {'category': 0,
                     'controls': {'BASS': ['BASS', 0.5, 0.0, 1.0],
                                  'GAIN': ['GAIN', 0.15, 0.0, 1.0],
                                  'TREBLE': ['TREBLE', 0.5, 0.0, 1.0],
                                  'VOLUME': ['VOLUME', 0.25, 0.0, 1.0]},
                     'description': 'An attempt at a power amp emulation',
                     'inputs': {'in': ['In', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'out': ['Out', 'AudioPort']},
                     'tags': {'amps, cabs + gain'},
                     'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2483s'},
 'product': {'category': 2,
             'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
             'description': 'a times b for control signals',
             'inputs': {'a_cv': ['A CV', 'CVPort'], 'b_cv': ['B CV', 'CVPort']},
             'long_description': '',
             'outputs': {'out': ['Output', 'CVPort']},
             'tags': {'utilities'},
             'video_url': 'https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2606s'},
 'quad_ir_cab': {'category': 0,
                 'controls': {'gain': ['Gain', 0.0, -40.0, 24.0],
                              'ir': ['/audio/cabs/1x12cab.wav', 0, 0, 1]},
                 'description': 'Requires quad channel IR. You do not want '
                                'this unless you have special IRs',
                 'inputs': {'gain': ['Gain', 'CVPort'],
                            'in_1': ['InL', 'AudioPort'],
                            'in_2': ['InR', 'AudioPort']},
                 'long_description': '',
                 'outputs': {'out_1': ['OutL', 'AudioPort'],
                             'out_2': ['OutR', 'AudioPort']},
                 'tags': {'amps, cabs + gain'},
                 'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=0s'},
 'short_quad_ir_reverb': {'category': 0,
                    'controls': {'enabled': ['Enabled', 1, 0, 1],
                                 'gain': ['Output Gain', 0.0, -40.0, 4.0],
                                 'ir': ['/audio/reverbs/emt_140_dark_1.wav',
                                        0,
                                        0,
                                        1]},
                    'description': 'Convolution reverb. Quad channel IRs '
                                   'required.',
                    'inputs': {'gain': ['Output Gain', 'CVPort'],
                               'in_1': ['InL', 'AudioPort'],
                               'in_2': ['InR', 'AudioPort']},
                    'kill_dry': True,
                    'long_description': '',
                    'outputs': {'out_1': ['OutL', 'AudioPort'],
                                'out_2': ['OutR', 'AudioPort']},
                    'tags': {'time effects'},
                    'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=259s'},
 'quad_ir_reverb': {'category': 0,
                    'controls': {'enabled': ['Enabled', 1, 0, 1],
                                 'wet': ['Output Gain', 0.0, -60.0, 6.0],
                                 'ir': ['/audio/reverbs/emt_140_dark_1.wav',
                                        0,
                                        0,
                                        1]},
                    'description': 'Convolution reverb. Quad channel IRs '
                                   'required.',
                    'inputs': {'gain': ['Output Gain', 'CVPort'],
                               'in_1': ['InL', 'AudioPort'],
                               'in_2': ['InR', 'AudioPort']},
                    'kill_dry': True,
                    'long_description': '',
                    'outputs': {'out_1': ['OutL', 'AudioPort'],
                                'out_2': ['OutR', 'AudioPort']},
                    'tags': {'time effects'},
                    'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=259s'},
 'quantizer': {'category': 2,
               'controls': {'n1': ['C', 1, 0, 1, 'bool'],
                            'n10': ['A', 1, 0, 1, 'bool'],
                            'n11': ['A#', 1, 0, 1, 'bool'],
                            'n12': ['B', 1, 0, 1, 'bool'],
                            'n2': ['C#', 1, 0, 1, 'bool'],
                            'n3': ['D', 1, 0, 1, 'bool'],
                            'n4': ['D#', 1, 0, 1, 'bool'],
                            'n5': ['E', 1, 0, 1, 'bool'],
                            'n6': ['F', 1, 0, 1, 'bool'],
                            'n7': ['F#', 1, 0, 1, 'bool'],
                            'n8': ['G', 1, 0, 1, 'bool'],
                            'n9': ['G#', 1, 0, 1, 'bool']},
               'description': 'quantize a v/oct signal to a musical scale.',
               'inputs': {'input': ['input', 'CVPort']},
               'long_description': 'Feed in an LFO to make it play specific '
                                   'notes instead of smoothly changing between '
                                   'pitches',
               'outputs': {'changed': ['Changed', 'CVPort'],
                           'output': ['Output', 'CVPort']},
               'tags': {'pitch + synth'},
               'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=336s'},
 'ratio': {'category': 2,
           'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
           'description': 'a divided by b for control signals',
           'inputs': {'a_cv': ['A CV', 'CVPort'], 'b_cv': ['B CV', 'CVPort']},
           'long_description': '',
           'outputs': {'out': ['Output', 'CVPort']},
           'tags': {'utilities'},
           'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1057s'},
 'rectify_value': {'category': 2,
                   'controls': {},
                   'description': 'rectify or get the absolute value of the '
                                  'input. ',
                   'inputs': {'a_cv': ['A CV', 'CVPort']},
                   'long_description': '',
                   'outputs': {'out': ['Output', 'CVPort']},
                   'tags': {'utilities'},
                   'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1226s'},
 'resonestor': {'category': 3,
                'controls': {'blend_param': ['random mod', 0.05, 0.0, 1.0],
                             'density_param': ['decay', 0.52, 0.0, 1.0],
                             'feedback_param': ['harmonics', 0.6, 0.0, 1.0],
                             'freeze_param': ['Switch Voice', 0.0, 0.0, 1.0],
                             'pitch_param': ['pitch', 0.0, -24.0, 24.0, 'int'],
                             'position_param': ['timbre', 0.83, 0.0, 1.0],
                             'reverb_param': ['scatter', 0.08, 0.0, 1.0],
                             'reverse_param': ['reverse', 0.0, 0.0, 1.0],
                             'size_param': ['chord', 0.36, 0.0, 1.0],
                             'spread_param': ['spread', 0.82, 0.0, 1.0],
                             'texture_param': ['filter', 0.5, 0.0, 1.0],
                             'enabled': ['Enabled', 1, 0, 1],
                             },
                # 'kill_dry': True,
                'description': 'dual voice four part resonator. Based on '
                               'Parasite firmware of Clouds by Mutable '
                               'Intstruments.',
                'inputs': {'blend': ['Random Mod', 'CVPort'],
                           'density': ['Decay', 'CVPort'],
                           'feedback': ['Harmonics', 'CVPort'],
                           'freeze': ['Switch Voice', 'CVPort'],
                           'l_in': ['L in', 'AudioPort'],
                           'pitch': ['Pitch', 'CVPort'],
                           'position': ['Timbre', 'CVPort'],
                           'r_in': ['R in', 'AudioPort'],
                           'reverb': ['Scatter', 'CVPort'],
                           'reverse': ['Reverse', 'CVPort'],
                           'size': ['Chord', 'CVPort'],
                           'spread': ['Spread', 'CVPort'],
                           'texture': ['Filter', 'CVPort'],
                           'trig': ['Trigger', 'CVPort']},
                'long_description': '',
                'manual_url': 'https://mqtthiqs.github.io/parasites/clouds.html',
                'outputs': {'l_out': ['L Out', 'AudioPort'],
                            'r_out': ['R Out', 'AudioPort']},
                'tags': {'pitch + synth', 'ported'},
                'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1449s'},
 'reverse': {'category': 0,
             'controls': {'dry': ['Dry Level', 0.0, -90.0, 20.0],
                          'fragment': ['Fragment Length',
                                       1000.0,
                                       100.0,
                                       1600.0],
                          'wet': ['Wet Level', 0.0, -90.0, 20.0]},
             'description': 'Reverse effect. Try short fragment length for '
                            'weird tremolo',
             'inputs': {'dry': ['Dry Level', 'CVPort'],
                        'input': ['Input', 'AudioPort'],
                        'wet': ['Wet Level', 'CVPort']},
             'long_description': '',
             'outputs': {'output': ['Output', 'AudioPort']},
             'tags': {'time effects'},
             'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1945s'},
 'rotary': {'category': 0,
            'controls': {'drumlvl': ['Drum Level', 0.0, -20.0, 20.0],
                         'drumwidth': ['Drum Stereo Width', 1.0, 0.0, 2.0],
                         'enable': ['Enable', 1, 0, 1],
                         'hornlvl': ['Horn Level', 0.0, -20.0, 20.0],
                         'rt_speed': ['Motors Ac/Dc', 4, 0, 8]},
            'description': 'A rotating loudspeaker using physical modelling. '
                           'Same sound as advanced.',
            'inputs': {'drum_brake_cv': ['Drum Brake', 'CVPort'],
                       'drum_speed_cv': ['Drum Speed', 'CVPort'],
                       'horn_brake_cv': ['Horn Brake', 'CVPort'],
                       'horn_speed_cv': ['Horn Speed', 'CVPort'],
                       'in': ['Input', 'AudioPort']},
            'long_description': '',
            'outputs': {'left': ['Left Output', 'AudioPort'],
                        'right': ['Right Output', 'AudioPort']},
            'tags': {'mod effects'},
            'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=2588s'},
 'rotary_advanced': {'category': 0,
                     'controls': {'drumaccel': ['Drum Acceleration',
                                                4.127,
                                                0.01,
                                                20.0],
                                  'drumbrake': ['Drum Brake Position',
                                                0.0,
                                                0.0,
                                                1.0],
                                  'drumdecel': ['Drum Deceleration',
                                                1.371,
                                                0.01,
                                                20.0],
                                  'drumlvl': ['Drum Level', 0.0, -20.0, 20.0],
                                  'drumradius': ['Drum Radius',
                                                 22.0,
                                                 9.0,
                                                 50.0],
                                  'drumrpmfast': ['Drum Speed Fast',
                                                  357.3,
                                                  60.0,
                                                  600.0],
                                  'drumrpmslow': ['Drum Speed Slow',
                                                  36.0,
                                                  5.0,
                                                  100.0],
                                  'drumwidth': ['Drum Stereo Width',
                                                1.0,
                                                0.0,
                                                2.0],
                                  'enable': ['Enable', 1, 0, 1],
                                  'filtafreq': ['Frequency',
                                                4500.0,
                                                250.0,
                                                8000.0],
                                  'filtagain': ['Gain', -30.0, -48.0, 48.0],
                                  'filtaq': ['Q', 2.7456, 0.01, 6.0],
                                  'filtatype': ['Horn Filter-1 Type', 0, 0, 8],
                                  'filtbfreq': ['Frequency',
                                                300.0,
                                                250.0,
                                                8000.0],
                                  'filtbgain': ['Gain', -30.0, -48.0, 48.0],
                                  'filtbq': ['Q', 1.0, 0.01, 6.0],
                                  'filtbtype': ['Horn Filter-2 Type', 7, 0, 8],
                                  'filtdfreq': ['Frequency',
                                                811.9695,
                                                50.0,
                                                8000.0],
                                  'filtdgain': ['Gain', -38.9291, -48.0, 48.0],
                                  'filtdq': ['Q', 1.6016, 0.01, 6.0],
                                  'filtdtype': ['Drum Filter Type', 8, 0, 8],
                                  'hornaccel': ['Horn Acceleration',
                                                0.161,
                                                0.001,
                                                10.0],
                                  'hornbrakepos': ['Horn Brake Position',
                                                   0.0,
                                                   0.0,
                                                   1.0],
                                  'horndecel': ['Horn Deceleration',
                                                0.321,
                                                0.001,
                                                10.0],
                                  'hornleak': ['Horn Signal Leakage',
                                               -16.47,
                                               -80.0,
                                               -3.0],
                                  'hornlvl': ['Horn Level', 0.0, -20.0, 20.0],
                                  'hornradius': ['Horn Radius',
                                                 19.2,
                                                 9.0,
                                                 50.0],
                                  'hornrpmfast': ['Horn Speed Fast',
                                                  423.36,
                                                  100.0,
                                                  1000.0],
                                  'hornrpmslow': ['Horn Speed Slow',
                                                  40.32,
                                                  5.0,
                                                  200.0],
                                  'hornwidth': ['Horn Stereo Width',
                                                1.0,
                                                0.0,
                                                2.0],
                                  'hornxoff': ['Horn X-Axis Offset',
                                               0.0,
                                               -20.0,
                                               20.0],
                                  'hornzoff': ['Horn Z-Axis Offset',
                                               0.0,
                                               -20.0,
                                               20.0],
                                  'link': ['Link Speed Control', 0, -1, 1],
                                  'micangle': ['Microphone Angle',
                                               180.0,
                                               0.0,
                                               180.0],
                                  'micdist': ['Microphone Distance',
                                              42.0,
                                              9.0,
                                              150.0],
                                  'rt_speed': ['Motors Ac/Dc', 4, 0, 8]},
                     'description': 'A rotating loudspeaker using physical '
                                    'modelling. Same sound, more controls.',
                     'inputs': {'drum_brake_cv': ['Drum Brake', 'CVPort'],
                                'drum_speed_cv': ['Drum Speed', 'CVPort'],
                                'horn_brake_cv': ['Horn Brake', 'CVPort'],
                                'horn_speed_cv': ['Horn Speed', 'CVPort'],
                                'in': ['Input', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'left': ['Left Output', 'AudioPort'],
                                 'right': ['Right Output', 'AudioPort']},
                     'tags': {'mod effects'},
                     'video_url': 'https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=2588s'},
 'sample_hold': {'category': 2,
                 'controls': {'triggerlevel': ['Trigger Level', 0.5, 0, 10]},
                 'description': 'sample and hold a CV value when a gate goes '
                                'high',
                 'inputs': {'input': ['Input', 'CVPort'],
                            'trigger': ['Gate', 'CVPort']},
                 'long_description': '',
                 'outputs': {'gate': ['Gate', 'CVPort'],
                             'output': ['Output', 'CVPort']},
                 'tags': {'cv generators'},
                 'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=158s'},
 'saturator': {'category': 0,
               'controls': {'Postgain': ['Postgain', 0, -90, 20],
                            'Pregain': ['Pregain', 0, -90, 20]},
               'description': 'Nonlinear saturation and soft limiting.',
               'inputs': {'Input': ['Input', 'AudioPort'],
                          'Postgain': ['Postgain', 'CVPort'],
                          'Pregain': ['Pregain', 'CVPort']},
               'long_description': '',
               'outputs': {'Output': ['Output', 'AudioPort']},
               'tags': {'amps, cabs + gain'},
               'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=392s'},
 'slew_limiter': {'category': 2,
                  'controls': {'timeDown': ['Time Down', 0.5, 0, 10],
                               'timeUp': ['Time Up', 0.5, 0.0, 10]},
                  'description': 'Slows how fast a control signal changes. '
                                 'Useful with foot switches.',
                  'inputs': {'in': ['In', 'CVPort']},
                  'long_description': '',
                  'outputs': {'out': ['Out', 'CVPort']},
                  'tags': {'cv generators'},
                  'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=679s'},
 'step_sequencer': {'broadcast_ports': {'bpm': ['tempo', 120, 1, 320],
                                        'current_step_out': ['current step out',
                                                             0,
                                                             0,
                                                             16]},
                    'category': 2,
                    'controls': {'back_gate': ['back', 0.0, 0.0, 1.0],
                                 'bpm': ['BPM', 120, 20, 320],
                                 'glide': ['Glide', 0.5, 0.0, 1.0],
                                 'note_length': ['Note Length',
                                                 0.125,
                                                 0.03125,
                                                 1],
                                 'play': ['play', 0.0, 0.0, 1.0],
                                 'steps': ['Loop Steps', 16, 1, 16],
                                 'val0': ['Value 0', 0.5, 0.0, 1.0],
                                 'val1': ['Value 1', 0.5, 0.0, 1.0],
                                 'val10': ['Value 10', 0.5, 0.0, 1.0],
                                 'val11': ['Value 11', 0.5, 0.0, 1.0],
                                 'val12': ['Value 12', 0.5, 0.0, 1.0],
                                 'val13': ['Value 13', 0.5, 0.0, 1.0],
                                 'val14': ['Value 14', 0.5, 0.0, 1.0],
                                 'val15': ['Value 15', 0.5, 0.0, 1.0],
                                 'val2': ['Value 2', 0.5, 0.0, 1.0],
                                 'val3': ['Value 3', 0.5, 0.0, 1.0],
                                 'val4': ['Value 4', 0.5, 0.0, 1.0],
                                 'val5': ['Value 5', 0.5, 0.0, 1.0],
                                 'val6': ['Value 6', 0.5, 0.0, 1.0],
                                 'val7': ['Value 7', 0.5, 0.0, 1.0],
                                 'val8': ['Value 8', 0.5, 0.0, 1.0],
                                 'val9': ['Value 9', 0.5, 0.0, 1.0]},
                    'description': '16 Step sequencer with internal clock',
                    'inputs': {'back_gate': ['Back Gate', 'CVPort'],
                               'bpm': ['BPM', 'ControlPort'],
                               'play': ['Play', 'CVPort'],
                               'reset': ['Reset Trigger', 'CVPort']},
                    'long_description': '',
                    'outputs': {'out': ['Value Out', 'CVPort']},
                    'tags': {'cv generators'},
                    'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1081s'},
 'step_sequencer_ext': {'broadcast_ports': {'current_step_out': ['current step '
                                                                 'out',
                                                                 0,
                                                                 0,
                                                                 16]},
                        'category': 2,
                        'controls': {'glide': ['Glide', 0.5, 0.0, 1.0],
                                     'steps': ['Loop Steps', 16, 1, 16],
                                     'val0': ['Value 0', 0.5, 0.0, 1.0],
                                     'val1': ['Value 1', 0.5, 0.0, 1.0],
                                     'val10': ['Value 10', 0.5, 0.0, 1.0],
                                     'val11': ['Value 11', 0.5, 0.0, 1.0],
                                     'val12': ['Value 12', 0.5, 0.0, 1.0],
                                     'val13': ['Value 13', 0.5, 0.0, 1.0],
                                     'val14': ['Value 14', 0.5, 0.0, 1.0],
                                     'val15': ['Value 15', 0.5, 0.0, 1.0],
                                     'val2': ['Value 2', 0.5, 0.0, 1.0],
                                     'val3': ['Value 3', 0.5, 0.0, 1.0],
                                     'val4': ['Value 4', 0.5, 0.0, 1.0],
                                     'val5': ['Value 5', 0.5, 0.0, 1.0],
                                     'val6': ['Value 6', 0.5, 0.0, 1.0],
                                     'val7': ['Value 7', 0.5, 0.0, 1.0],
                                     'val8': ['Value 8', 0.5, 0.0, 1.0],
                                     'val9': ['Value 9', 0.5, 0.0, 1.0]},
                        'description': '16 Step sequencer that takes in a '
                                       'trigger for next or previous',
                        'inputs': {'back_trigger': ['Back Trigger', 'CVPort'],
                                   'reset': ['Reset Trigger', 'CVPort'],
                                   'trigger': ['Step Trigger', 'CVPort']},
                        'long_description': '',
                        'outputs': {'out': ['Value Out', 'CVPort']},
                        'tags': {'cv generators'},
                        'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1205s'},
 'stereo_EQ': {'category': 0,
               'controls': {'HPQ': ['HighPass Resonance', 0.7, 0.0, 1.4],
                            'HPfreq': ['Highpass Frequency', 20.0, 5.0, 1250.0],
                            'HSfreq': ['Highshelf Frequency',
                                       8000.0,
                                       1000.0,
                                       16000.0],
                            'HSgain': ['Highshelf Gain', 0.0, -18.0, 18.0],
                            'HSq': ['Highshelf Bandwidth', 1.0, 0.0625, 4.0],
                            'HSsec': ['Highshelf', 1, 0, 1],
                            'HighPass': ['Highpass', 0, 0, 1],
                            'LPQ': ['LowPass Resonance', 1.0, 0.0, 1.4],
                            'LPfreq': ['Lowpass Frequency',
                                       20000.0,
                                       500.0,
                                       20000.0],
                            'LSfreq': ['Lowshelf Frequency', 80.0, 25.0, 400.0],
                            'LSgain': ['Lowshelf Gain', 0.0, -18.0, 18.0],
                            'LSq': ['Lowshelf Bandwidth', 1.0, 0.0625, 4.0],
                            'LSsec': ['Lowshelf', 1, 0, 1],
                            'LowPass': ['Lowpass', 0, 0, 1],
                            'enable': ['Enable', 1, 0, 1],
                            'freq1': ['Frequency 1', 160.0, 20.0, 2000.0],
                            'freq2': ['Frequency 2', 397.0, 40.0, 4000.0],
                            'freq3': ['Frequency 3', 1250.0, 100.0, 10000.0],
                            'freq4': ['Frequency 4', 2500.0, 200.0, 20000.0],
                            'gain': ['Gain', 0.0, -18.0, 18.0],
                            'gain1': ['Gain 1', 0.0, -18.0, 18.0],
                            'gain2': ['Gain 2', 0.0, -18.0, 18.0],
                            'gain3': ['Gain 3', 0.0, -18.0, 18.0],
                            'gain4': ['Gain 4', 0.0, -18.0, 18.0],
                            'q1': ['Bandwidth 1', 0.6, 0.0625, 4.0],
                            'q2': ['Bandwidth 2', 0.6, 0.0625, 4.0],
                            'q3': ['Bandwidth 3', 0.6, 0.0625, 4.0],
                            'q4': ['Bandwidth 4', 0.6, 0.0625, 4.0],
                            'sec1': ['Section 1', 1, 0, 1],
                            'sec2': ['Section 2', 1, 0, 1],
                            'sec3': ['Section 3', 1, 0, 1],
                            'sec4': ['Section 4', 1, 0, 1]},
               'description': 'Stereo multiband parametric EQ.',
               'inputs': {'inL': ['In Left', 'AudioPort'],
                          'inR': ['In Right', 'AudioPort']},
               'long_description': '',
               'outputs': {'outL': ['Out Left', 'AudioPort'],
                           'outR': ['Out Right', 'AudioPort']},
               'tags': {'level + dynamics'},
               'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1345s'},
 'stereo_cab': {'category': 0,
                'controls': {'gain': ['Output Gain', 0.0, -40.0, 24.0],
                             'ir': ['/audio/cabs/1x12cab.wav', 0, 0, 1]},
                'description': 'Stereo cab sim. You normally do not want this. '
                               'Requires stereo IRs.',
                'inputs': {'gain': ['Output Gain', 'CVPort'],
                           'in': ['In', 'AudioPort']},
                'long_description': '',
                'outputs': {'out_1': ['OutL', 'AudioPort'],
                            'out_2': ['OutR', 'AudioPort']},
                'tags': {'amps, cabs + gain'},
                'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1360s'},
 'stereo_compress': {'category': 0,
                     'controls': {'Ratio': ['Ratio', 0.0, 0.0, 1.0],
                                  'attack': ['Attack Time', 0.01, 0.001, 0.1],
                                  'enable': ['Enable', 1, 0, 1, 'hide'],
                                  'hold': ['Hold', 0, 0, 1, 'bool'],
                                  'inputgain': ['Input Gain', 0.0, -10.0, 30.0],
                                  'release': ['Release Time', 0.3, 0.03, 3.0],
                                  'threshold': ['Threshold',
                                                -30.0,
                                                -50.0,
                                                -10.0]},
                     'description': 'RMS downward compressor with auto markup',
                     'inputs': {'inL': ['In Left', 'AudioPort'],
                                'inR': ['In Right', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'outL': ['Out Left', 'AudioPort'],
                                 'outR': ['Out Right', 'AudioPort']},
                     'tags': {'level + dynamics'},
                     'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1462s'},
 'stereo_phaser': {'category': 0,
                   'controls': {'color': ['Color', 1, 0, 1, 'bool'],
                                'feedback_depth': ['Feedback depth', 75, 0, 99],
                                'feedback_hpf_cutoff': ['Feedback bass cut',
                                                        500.0,
                                                        10.0,
                                                        5000.0],
                                'lfo_frequency': ['LFO frequency',
                                                  0.2,
                                                  0.01,
                                                  5.0],
                                'mix': ['Dry/wet mix', 50, 0, 100],
                                'stereo_phase': ['Stereo phase', 0, -180, 180]},
                   'description': 'Basic stereo phaser',
                   'inputs': {'lv2_audio_in_1': ['Audio Input 1', 'AudioPort'],
                              'lv2_audio_in_2': ['Audio Input 2', 'AudioPort']},
                   'long_description': '',
                   'outputs': {'lv2_audio_out_1': ['Audio Output 1',
                                                   'AudioPort'],
                               'lv2_audio_out_2': ['Audio Output 2',
                                                   'AudioPort']},
                   'tags': {'mod effects'},
                   'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1490s'},
 'stereo_reverb': {'category': 0,
                    'controls': {'enable': ['Enable', 1, 0, 1],
                                 'wet': ['Output Gain', 0.0, -60.0, 6.0],
                                 'ir': ['/audio/0/0.wav',
                                        0,
                                        0,
                                        1]},
                    'description': 'Stereo convolution reverb.',
                    'inputs': { 'in': ['In', 'AudioPort'] },
                    'kill_dry': True,
                    'long_description': '',
                    'outputs': {'out_1': ['OutL', 'AudioPort'],
                                'out_2': ['OutR', 'AudioPort']},
                    'tags': {'time effects'},
                   'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1498s'},
 'short_stereo_reverb': {'category': 0,
                   'controls': {'enabled': ['Enabled', 1, 0, 1],
                                'gain': ['Output Gain', 0.0, -40.0, 4.0],
                                'ir': ['/audio/reverbs/emt_140_dark_1.wav',
                                       0,
                                       0,
                                       1]},
                   'description': 'Stereo convolution reverb',
                   'inputs': {'gain': ['Output Gain', 'CVPort'],
                              'in': ['In', 'AudioPort']},
                   'kill_dry': True,
                   'long_description': '',
                   'outputs': {'out_1': ['OutL', 'AudioPort'],
                               'out_2': ['OutR', 'AudioPort']},
                   'tags': {'time effects'},
                   'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1498s'},
 'strum': {'category': 0,
           'controls': {'chord_root': ['Chord Root', 0, 0, 12],
                        'chord_type': ['chord type', 0, 0, 3],
                        'lead_mode': ['lead mode', 0, 0, 1],
                        'octave': ['octave', 0, -4, 4],
                        'touched_notes': ['touched_notes', -1, -1, 256],
                        'velocity': ['velocity', 1.0, 0.0, 1]},
           'description': 'MIDI and V oct controller based on strumming',
           'inputs': {},
           'long_description': 'choose chords and then strum the lines to get '
                               'octaves of a chord',
           'outputs': {'gate_out': ['Gate', 'CVPort'],
                       'midi_out': ['MIDI Out', 'AtomPort'],
                       'v_oct_out': ['v_oct_out', 'CVPort']},
           'tags': {'pitch + synth'},
           'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1870s'},
 'sum': {'category': 2,
         'controls': {'a': ['a', 0, 0, 1], 'b': ['b', 0, 0, 1]},
         'description': 'a + b for control signals',
         'inputs': {'a_cv': ['A CV', 'CVPort'], 'b_cv': ['B CV', 'CVPort']},
         'long_description': '',
         'outputs': {'out': ['Output', 'CVPort']},
         'tags': {'utilities'},
         'video_url': 'https://www.youtube.com/watch?v=vKwA8wZaq3E&t=2324s'},
 'tempo_ratio': {'category': 2,
                 'controls': {'a': ['a', 1, 1, 16, 'int'],
                              'b': ['b', 1, 1, 16, 'int']},
                 'description': 'ratio between a tempo, like 3/4 to input '
                                'tempo',
                 'inputs': {'input_tempo': ['Input Tempo', 'ControlPort']},
                 'long_description': '',
                 'outputs': {'out_tempo': ['Output Tempo', 'ControlPort']},
                 'tags': {'utilities'},
                 'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=280s'},
 'thruzero_flange': {'category': 0,
                     'controls': {'depth': ['Depth', 0.43, 0.0, 1.0],
                                  'depth_mod': ['Depth Mod', 1.0, 0.0, 1.0],
                                  'feedback': ['Feedback', 0.3, 0.0, 1.0],
                                  'mix': ['Mix', 0.47, 0.0, 1.0],
                                  'rate': ['Rate', 0.3, 0.0, 1.0]},
                     'description': 'Through Zero Flanger.',
                     'inputs': {'depth': ['Depth', 'CVPort'],
                                'depth_mod': ['Depth Mod', 'CVPort'],
                                'feedback': ['Feedback', 'CVPort'],
                                'left_in': ['Left In', 'AudioPort'],
                                'mix': ['Mix', 'CVPort'],
                                'rate': ['Rate', 'CVPort'],
                                'right_in': ['Right In', 'AudioPort']},
                     'long_description': '',
                     'outputs': {'left_out': ['Left Out', 'AudioPort'],
                                 'right_out': ['Right Out', 'AudioPort']},
                     'tags': {'mod effects'},
                     'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=520s'},
 'time_stretch': {'category': 3,
                  'controls': {'blend_param': ['blend', 0.5, 0.0, 1.0],
                               'density_param': ['Diffusion', 0.18, 0.0, 1.0],
                               'feedback_param': ['feedback', 0.48, 0.0, 1.0],
                               'freeze_param': ['freeze', 0.0, 0.0, 1.0],
                               'pitch_param': ['pitch',
                                               0.0,
                                               -24.0,
                                               24.0,
                                               'int'],
                               'position_param': ['position', 0.5, 0.0, 1.0],
                               'reverb_param': ['reverb', 0.15, 0.0, 1.0],
                               'reverse_param': ['reverse', 0.0, 0.0, 1.0],
                               'size_param': ['size', 0.66, 0.0, 1.0],
                               'spread_param': ['spread', 0.79, 0.0, 1.0],
                               'texture_param': ['Filter', 0.48, 0.0, 1.0],
                               'enabled': ['Enabled', 1, 0, 1],
                               },
                  # 'kill_dry': True,
                  'description': 'A granular time stretching and pitch '
                                 'shifting module. Based on Parasite firmware '
                                 'of Clouds by Mutable Instruments.',
                  'inputs': {'Feedback': ['feedback', 'CVPort'],
                             'blend': ['Blend', 'CVPort'],
                             'density': ['Diffusion', 'CVPort'],
                             'freeze': ['Freeze', 'CVPort'],
                             'l_in': ['L in', 'AudioPort'],
                             'pitch': ['Pitch', 'CVPort'],
                             'position': ['Position', 'CVPort'],
                             'r_in': ['R in', 'AudioPort'],
                             'reverb': ['Reverb', 'CVPort'],
                             'reverse': ['Reverse', 'CVPort'],
                             'size': ['Size', 'CVPort'],
                             'spread': ['Spread', 'CVPort'],
                             'texture': ['Filter', 'CVPort'],
                             'trig': ['Trigger', 'CVPort']},
                  'long_description': '',
                  'manual_url': 'https://mqtthiqs.github.io/parasites/clouds.html',
                  'outputs': {'l_out': ['L Out', 'AudioPort'],
                              'r_out': ['R Out', 'AudioPort']},
                  'tags': {'time effects', 'ported'},
                  'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=690s'},
 'toggle': {'category': 2,
            'controls': {},
            'description': 'toggles the output value on every trigger',
            'inputs': {'trigger': ['Trigger', 'CVPort']},
            'long_description': '',
            'outputs': {'out': ['Out Gate', 'CVPort']},
            'tags': {'utilities'},
            'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1418s'},
 'trigger_to_gate': {'broadcast_ports': {'tempo': ['tempo', 120, 1, 320]},
                     'category': 0,
                     'controls': {'gate_length': ['gate length',
                                                  0.25,
                                                  0.03125,
                                                  1],
                                  'tempo': ['tempo', 120, 30, 300]},
                     'description': 'Takes in a trigger and outputs a gate '
                                    'with a length related to the tempo',
                     'inputs': {'gate_length_cv': ['Gate Length CV', 'CVPort'],
                                'tempo': ['Tempo', 'ControlPort'],
                                'trigger': ['trigger', 'CVPort']},
                     'long_description': 'The gate length is how much of a bar '
                                         'is taken up assuming tempo is '
                                         'quarter notes',
                     'outputs': {'gate_out': ['gate out', 'CVPort']},
                     'tags': {'utilities'},
                     'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=2130s'},
 'tuner': {'broadcast_ports': {'accuracy': ['Note Stability', -100, -100, 100],
                               'cent': ['Cent', 0, -50, 50],
                               'freq_out': ['Detected Frequency', 0, 0, 10000],
                               'note': ['Detected Note', 0, 0, 12],
                               'octave': ['Detected Octave', 0, -1, 10],
                               'rms': ['Signal Level (RMS)', -65.0, -100, 0],
                               'strobetoui': ['StrobeToUi', 0, 0, 100]},
           'category': 0,
           'controls': {'enabled': ['Enabled', 0, 0, 1],
                        'mode': ['Mode', 0, -128, 8000],
                        'thresholdFFT': ['thresholdFFT', -40.0, -50.0, 10.0],
                        'thresholdFundamental': ['thresholdFundamental',
                                                 5.0,
                                                 0.0,
                                                 60.0],
                        'thresholdOctave': ['thresholdOctave',
                                            -30.0,
                                            -100.0,
                                            0.0],
                        'thresholdOverride': ['thresholdOverride',
                                              20.0,
                                              0.0,
                                              40.0],
                        'thresholdOvertones': ['thresholdvertones',
                                               -15.0,
                                               -100.0,
                                               0.0],
                        'thresholdPostFilter': ['thresholdPostFilter',
                                                -45.0,
                                                -50.0,
                                                0.0],
                        'thresholdRMS': ['thresholdRMS', -85.0, -100.0, 0.0],
                        'tuning': ['Tuning A440', 440.0, 220.0, 880.0]},
           'description': 'A tuner suitable for tuning guitar or other '
                          'instruments',
           'inputs': {'in': ['Audio Input', 'AudioPort']},
           'long_description': '',
           'outputs': {'sysex': ['MIDI MTS SysEx', 'AtomPort']},
           'tags': {'utilities'},
           'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=2100s'},
 'turntable_stop': {'category': 0,
                    'controls': {'DCURVE': ['Decay Curve', 0.0, -10.0, 10.0],
                                 'DTIME': ['Decay Time', 0.5, 0.01, 10.0],
                                 'PULL_THE_PLUG': ['Pull the Plug',
                                                   0,
                                                   0,
                                                   1,
                                                   'bool']},
                    'description': 'Simulates turning off a turntable. Connect '
                                   'a control to pull the plug.',
                    'inputs': {'DTIME': ['Decay Time', 'CVPort'],
                               'INPUT': ['Audio In', 'AudioPort'],
                               'PULL_THE_PLUG': ['Pull the Plug', 'CVPort']},
                    'long_description': '',
                    'outputs': {'OUTPUT': ['Audio Out', 'AudioPort']},
                    'tags': {'mod effects'},
                    'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1480s'},
 'twist_delay': {'category': 0,
                 'controls': {'dry_wet': ['dry wet', 0.5, 0.0, 1.0],
                              'feedback': ['feedback', 0.75, 0.0, 1.0],
                              'length': ['length', 0.95, 0.0, 1.0],
                              'mode': ['mode', 1.0, 0.0, 3.0],
                              'speed_direction': ['speed direction',
                                                  2.39,
                                                  0.0,
                                                  8.0],
                              'enabled': ['Enabled', 1, 0, 1],
                              },
                 # 'kill_dry': True,
                 'description': 'A delay where speed and length interact with '
                                'quality. Based on Parasite firmware of Warps '
                                'by Mutable Instruments.',
                 'inputs': {'carrier': ['in 1', 'AudioPort'],
                            'dry_wet_cv': ['dry wet cv', 'CVPort'],
                            'feedback_cv': ['feedback cv', 'CVPort'],
                            'length_cv': ['length cv', 'CVPort'],
                            'modulator': ['in 2', 'AudioPort'],
                            'speed_direct_cv': ['speed direction cv',
                                                'CVPort']},
                 'long_description': '',
                 'manual_url': 'https://mqtthiqs.github.io/parasites/warps.html',
                 'outputs': {'aux': ['out 2', 'AudioPort'],
                             'out': ['out 1', 'AudioPort']},
                 'tags': {'time effects', 'ported'},
                 'video_url': 'https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1592s'},
 'vca': {'category': 2,
         'controls': {'gain': ['Gain', 1.0, 0.0, 1.0]},
         'description': 'simple voltage controlled amplifier',
         'inputs': {'gain': ['Gain', 'CVPort'], 'in': ['Input', 'AudioPort']},
         'long_description': '',
         'outputs': {'out': ['Output', 'AudioPort']},
         'tags': {'level + dynamics'},
         'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=590s'},
 'vibrato': {'broadcast_ports': {'BPM_1': ['tempo', 120, 1, 320]},
             'category': 0,
             'controls': {'BPM_9': ['BPM', 30, 4, 300],
                          'Feedback_Gain_3': ['Feedback Gain',
                                              0,
                                              -0.999,
                                              0.999],
                          'Invert_Internal_Phaser_Sum_0': ['Invert',
                                                           0.0,
                                                           0.0,
                                                           1.0,
                                                           'bool'],
                          'Max_Notch1_Freq_7': ['Max Notch1 Freq',
                                                800,
                                                20,
                                                10000],
                          'Min_Notch1_Freq_6': ['Min Notch1 Freq',
                                                100,
                                                20,
                                                5000],
                          'Notch_Depth__Intensity__2': ['Notch Depth', 1, 0, 1],
                          'Notch_Freq_Ratio_8': ['Notch Freq Ratio',
                                                 1.5,
                                                 1.1,
                                                 4],
                          'Notch_width_5': ['Notch width', 1000, 10, 5000],
                          'Phase_4': ['Phase', 0, 0, 1],
                          'Vibrato_Mode_1': ['Vibrato Mode',
                                             1.0,
                                             0.0,
                                             1.0,
                                             'bool']},
             'description': 'vibrato with internal LFO',
             'inputs': {'BPM_9': ['BPM', 'ControlPort'],
                        'in0': ['in', 'AudioPort']},
             'long_description': '',
             'outputs': {'out0': ['out', 'AudioPort']},
             'tags': {'mod effects'},
             'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1590s'},
 'vibrato_ext': {'category': 0,
                 'controls': {'Feedback_Gain_3': ['Feedback Gain',
                                                  0,
                                                  -0.999,
                                                  0.999],
                              'Invert_Internal_Phaser_Sum_0': ['Invert',
                                                               0.0,
                                                               0.0,
                                                               1.0,
                                                               'bool'],
                              'Max_Notch1_Freq_6': ['Max Notch1 Freq',
                                                    800,
                                                    20,
                                                    10000],
                              'Min_Notch1_Freq_5': ['Min Notch1 Freq',
                                                    100,
                                                    20,
                                                    5000],
                              'Notch_Depth__Intensity__2': ['Notch Depth',
                                                            1,
                                                            0,
                                                            1],
                              'Notch_Freq_Ratio_7': ['Notch Freq Ratio',
                                                     1.5,
                                                     1.1,
                                                     4],
                              'Notch_width_4': ['Notch width', 1000, 10, 5000],
                              'Vibrato_Mode_1': ['Vibrato Mode',
                                                 0.0,
                                                 0.0,
                                                 1.0,
                                                 'bool']},
                 'description': 'vibrato with CV LFO',
                 'inputs': {'in1': ['in', 'AudioPort'],
                            'lfo_cv': ['LFO CV', 'CVPort']},
                 'long_description': '',
                 'outputs': {'out0': ['out', 'AudioPort']},
                 'tags': {'mod effects'},
                 'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1936s'},
 'vinyl': {'category': 0,
           'controls': {'active1': ['Motor', 0, 0, 1, 'bool'],
                        'active2': ['Static', 0, 0, 1, 'bool'],
                        'active3': ['Noise', 0, 0, 1, 'bool'],
                        'active4': ['Rumble', 0, 0, 1, 'bool'],
                        'active5': ['Crackle', 0, 0, 1, 'bool'],
                        'active6': ['Crinkle', 0, 0, 1, 'bool'],
                        'aging': ['Aging', 0, 0, 1],
                        'freq': ['Aging Frequency', 1000, 600, 1800],
                        'gain0': ['Gain', 0.001, 0, 1],
                        'pitch5': ['Pitch Crackle', 0, -1, 1],
                        'pitch6': ['Pitch Crinkle', 0, -1, 1],
                        'enabled': ['Enabled', 1, 0, 1, 'bool'],
                        },
           # 'kill_dry': True,
           'description': 'Emulate dirty old lo-fi vinyl records. Bit CPU '
                          'hungry but fun',
           'inputs': {'gain1': ['Vol Motor', 'CVPort'],
                      'gain2': ['Vol Static', 'CVPort'],
                      'gain3': ['Vol Noise', 'CVPort'],
                      'gain4': ['Vol Rumble', 'CVPort'],
                      'gain5': ['Vol crackle', 'CVPort'],
                      'gain6': ['Vol Crinkle', 'CVPort'],
                      'in_l': ['In L', 'AudioPort'],
                      'in_r': ['In R', 'AudioPort']},
           'long_description': 'This is not good for nice clean stuff...',
           'outputs': {'out_l': ['Out L', 'AudioPort'],
                       'out_r': ['Out R', 'AudioPort']},
           'tags': {'mod effects'},
           'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1980s'},
 'warmth': {'category': 0,
            'controls': {'blend': ['Tape--Tube Blend', 10, -10, 10],
                         'drive': ['Drive', 5.0, 0.1, 10]},
            'description': 'Tube triode emulation',
            'inputs': {'blend': ['Tape--Tube Blend', 'CVPort'],
                       'drive': ['Drive', 'CVPort'],
                       'input': ['Input', 'AudioPort']},
            'long_description': '',
            'outputs': {'output': ['Output', 'AudioPort']},
            'tags': {'amps, cabs + gain'},
            'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=2400s'},
 'wavefolder': {'category': 3,
                'controls': {'input_amp': ['amp or freq', 1.0, 0.0, 1.0],
                             'input_amp_2': ['input amplitude 2',
                                             1.0,
                                             0.0,
                                             1.0],
                             'input_bias': ['input_bias', 0.5, 0.0, 1.0],
                             'int_osc': ['int_osc', 0.0, 0.0, 3.0],
                             'n_folds': ['number of folds', 0.0, 0.0, 8.0],
                             'enabled': ['Enabled', 1, 0, 1],
                             },
                # 'kill_dry': True,
                'description': 'Chebyshev wave folder. Based on Parasite '
                               'firmware of Warps by Mutable Instruments. ',
                'inputs': {'carrier': ['carrier', 'AudioPort'],
                           'input_amp_2_cv': ['input_amp_2_cv', 'CVPort'],
                           'input_amp_cv': ['input_amp_cv', 'CVPort'],
                           'input_bias_cv': ['input_bias_cv', 'CVPort'],
                           'modulator': ['modulator', 'AudioPort'],
                           'num_fold_cv': ['num_fold_cv', 'CVPort']},
                'long_description': '',
                'manual_url': 'https://mqtthiqs.github.io/parasites/warps.html',
                'outputs': {'aux': ['aux', 'AudioPort'],
                            'out': ['out', 'AudioPort']},
                'tags': {'amps, cabs + gain', 'ported'},
                'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=2622s'},
 'wet_dry': {'category': 0,
             'controls': {'level': ['level', 1.0, 0.0, 1.0],
                          'shape': ['Shape', 0.0, 0.0, 1.0],
                          'xfade': ['Wet Dry', 0.0, -1.0, 1.0]},
             'description': 'blend between two inputs',
             'inputs': {'dry': ['Dry', 'AudioPort'],
                        'level': ['Level', 'CVPort'],
                        'wet': ['Wet', 'AudioPort'],
                        'xfade': ['Wet Dry Blend', 'CVPort']},
             'long_description': '',
             'outputs': {'out': ['Out', 'AudioPort']},
             'tags': {'level + dynamics'},
             'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=3298s'},
 'wet_dry_stereo': {'category': 0,
                    'controls': {'level': ['level', 1.0, 0.0, 1.0],
                                 'shape': ['Shape', 0.0, 0.0, 1.0],
                                 'xfade': ['signal a/b', 0.0, -1.0, 1.0]},
                    'description': 'blend stereo inputs to stereo out',
                    'inputs': {'dry_l': ['Dry L', 'AudioPort'],
                               'dry_r': ['Dry R', 'AudioPort'],
                               'level': ['Level', 'CVPort'],
                               'wet_l': ['Wet L', 'AudioPort'],
                               'wet_r': ['Wet R', 'AudioPort'],
                               'xfade': ['Wet Dry Blend', 'CVPort']},
                    'long_description': '',
                    'outputs': {'out_l': ['Out L', 'AudioPort'],
                                'out_r': ['Out R', 'AudioPort']},
                    'tags': {'level + dynamics'},
                    'video_url': 'https://www.youtube.com/watch?v=fE8cb2v5kbw&t=3298s'},
'tonestack': {'category': 0,
               'controls': {'bass_0': ['Bass', 0.0, -10.0, 10.0],
                            'mid_1': ['Mid', 0.0, -10.0, 10.0],
                            'treble_2': ['Treble', 0.0, -10.0, 10.0]},
               'description': 'Amps style 3 knob tone stack',
               'inputs': {'in0': ['In', 'AudioPort']},
               'long_description': '',
               'outputs': {'out0': ['Out', 'AudioPort']},
               'tags': {'utilities'}},
'boost': {'category': 0,
           'controls': {'on': ['on', 1, 0.0, 1.0],
                        'gain': ['Gain', 2.0, 1.0, 4.0]},
           'description': 'very basic boost',
           'inputs': {'in': ['Input', 'AudioPort']},
           'long_description': '',
           'outputs': {'out': ['Output', 'AudioPort']},
           'tags': {'utilities'}}
 }



#unused

    # 'control_to_midi': {'description': '',
    #     'category': 1,
    #     'controls': {'AUTOFF': ['Auto Note-Off', 0, 0, 1],
    #                                   'CHAN': ['Channel', 0, 0, 15, "int"],
    #                                   'DATA1': ['Note/CC/PG Number', 0, 0, 127, "int"],
    #                                   'DATA2': ['Value', 0, 0, 127, "int"],
    #                                   'DELAY': ['1st Msg Repeat Delay Time',
    #                                             0.0,
    #                                             0.0,
    #                                             2000.0],
    #                                   'ENABLE': ['Enable', 1, 0, 1, "bool"],
    #                                   'MSGTYPE': ['Message Type', 11, 8, 15, "int"]},
    #                      'inputs': {},
    #                      'outputs': {'MIDI_OUT': ['MIDI Out', 'AtomPort']}},

# 'octaver': {'controls': {'DIRECT': ['DIRECT', 0.5, 0.0, 1.0],
#                           'OCTAVE1': ['OCTAVE1', 0.5, 0.0, 1.0],
#                           'OCTAVE2': ['OCTAVE2', 0.5, 0.0, 1.0]},
#              'inputs': {'in': ['In', 'AudioPort']},
#              'outputs': {'out': ['Out', 'AudioPort']}},

#      'square_distortion': {'description': '',
#         'category': 0,
#              'controls': {'DOWN': ['Down', 0.02, -0.5, 1.0],
#                                         'IN_GAIN': ['Input Gain', 1.0, 0.0, 1.0],
#                                         'OCTAVE': ['Octave', 0, -2, 1.0],
#                                         'OUT_GAIN': ['Output Gain', 1.0, 0.0, 1.0],
#                                         'UP': ['Up', 0.02, -0.5, 1.0],
#                                         'WETDRY': ['Wet/Dry Mix', 0.7, 0.0, 1.0]},
#                            'inputs': {'INPUT': ['Audio In', 'AudioPort']},
#                            'outputs': {'OUTPUT': ['Audio Out', 'AudioPort']}},
