import "controls" as PolyControls
import QtQuick 2.4

Flickable {
    id: flowListView
    anchors.fill: parent

    contentWidth: parent.width;
    contentHeight: flow.childrenRect.height

    property alias count: repeater.count
    property int currentIndex: -1
    property var currentItem;
    property alias delegate: repeater.delegate
    property alias flow: flow.flow
    property alias spacing: flow.spacing
    property alias model: repeater.model

    onCurrentIndexChanged: {
        currentItem = model.data(model.index(currentIndex, 0));
    }

    Flow {
        id: flow
        width: parent.width

        Repeater {
            id: repeater

            onCountChanged: {
                if (flowListView.currentIndex === -1 && count > 0) {
                    flowListView.currentIndex = 0
                }
                if (flowListView.currentIndex >= count) {
                    flowListView.currentIndex = count - 1
                }
            }
        }
    }
}
