.pragma library
var effectPrototypes = {"midi_map_key_scale": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "flexible 12-tone note map", "video_url": "", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Flexible 12-tone map. Allow to map a note within an octave to another note in the same octave-range +- 12 semitones. Alternatively notes can also be masked (disabled). If two keys are mapped to the same note, the corresponding note on/events are latched: only the first note on and last note off will be sent. The settings can be changed dynamically: Note-on/off events will be sent accordingly.", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"], "k11": ["B", 0, -13, 12, "int"], "k10": ["A#", 0, -13, 12, "int"], "k3": ["D#", 0, -13, 12, "int"], "k2": ["D", 0, -13, 12, "int"], "k1": ["C#", 0, -13, 12, "int"], "k0": ["C", 0, -13, 12, "int"], "k7": ["G", 0, -13, 12, "int"], "k6": ["F#", 0, -13, 12, "int"], "k5": ["F", 0, -13, 12, "int"], "k4": ["E", 0, -13, 12, "int"], "k9": ["A", 0, -13, 12, "int"], "k8": ["G#", 0, -13, 12, "int"]}, "num_cv_in": 0}, "midi_velocity_range": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "filter MIDI note events according to velocity", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Note-on events outside the allowed range are discarded. If a Note-off is received for a note that was previously filtered, it is also not passed though. If the allowed range changes, note-off events are sent to currently active notes that end up outside the valid range.", "controls": {"upper": ["Max Volume", 127, 0, 127, "int"], "lower": ["Min Volume", 0, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "mode": ["Operation Mode", 1, 0, 3, "int"]}, "num_cv_in": 0}, "flanger_ext": {"category": 0, "inputs": {"in1": ["in", "AudioPort"], "lfo_cv": ["LFO CV", "CVPort"]}, "description": "flanger with CV for LFO", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1074s", "tags": ["mod effects"], "outputs": {"out0": ["out0", "AudioPort"]}, "long_description": "", "controls": {"Depth_1": ["Depth", 0.75, 0, 1], "Feedback_3": ["Feedback", 0, -0.995, 0.99], "Invert_2": ["Invert", 0, 0, 1, "bool"], "Delay_0": ["Delay", 0.22, 0, 1]}, "num_cv_in": 1}, "loop_common_in": {"category": 1, "inputs": {"input": ["out", "AudioPort"]}, "description": "Common input to the loopler", "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s", "tags": ["time effects"], "outputs": {}, "long_description": "", "controls": {}, "num_cv_in": 0}, "diode_ladder_lpf": {"category": 3, "inputs": {"cutoff_cv": ["Cutoff CV", "CVPort"], "q_cv": ["Q CV", "CVPort"], "in": ["in", "AudioPort"]}, "description": "A diode ladder low pass filter similar to the vintage Japanese designs", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=547s", "tags": ["pitch + synth"], "outputs": {"out": ["out", "AudioPort"]}, "long_description": "", "controls": {"Q": ["Q", 1, 0.7072, 25], "cutoff": ["cutoff", 0.1, 0, 1]}, "num_cv_in": 2}, "phaser_stereo_ext": {"category": 0, "inputs": {"lv2_audio_in_1": ["Audio Input 1", "AudioPort"], "lv2_audio_in_2": ["Audio Input 2", "AudioPort"], "lv2_audio_in_3": ["LFO CV", "CVPort"]}, "description": "Stereo phaser controlled by CV input", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=379s", "tags": ["mod effects"], "outputs": {"lv2_audio_out_1": ["Audio Output 1", "AudioPort"], "lv2_audio_out_2": ["Audio Output 2", "AudioPort"]}, "long_description": "", "controls": {"color": ["Color", 1, 0, 1], "feedback_depth": ["Feedback depth", 75, 0, 99], "feedback_hpf_cutoff": ["Feedback bass cut", 500.0, 10.0, 5000.0], "stereo_phase": ["Stereo phase", 0, -180, 180], "mix": ["Dry/wet mix", 50, 0, 100]}, "num_cv_in": 1}, "toggle": {"category": 2, "inputs": {"trigger": ["Trigger", "CVPort"]}, "description": "toggles the output value on every trigger", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1418s", "tags": ["utilities"], "outputs": {"out": ["Out Gate", "CVPort"]}, "long_description": "", "controls": {}, "num_cv_in": 1}, "matrix_mixer": {"category": 0, "inputs": {"in4": ["Input 4", "AudioPort"], "in1": ["Input 1", "AudioPort"], "in2": ["Input 2", "AudioPort"], "in3": ["Input 3", "AudioPort"]}, "description": "4 in 3 out matrix mixer", "video_url": "https://www.youtube.com/watch?v=1ED7ipo2wTM&t=1985s", "tags": ["level + dynamics"], "outputs": {"out1": ["Output 1", "AudioPort"], "out2": ["Output 2", "AudioPort"], "out3": ["Output 3", "AudioPort"]}, "long_description": "4 in 3 out matrix mixer", "controls": {"mix_3_2": ["Input 3", 0.0, 0.0, 2.0], "mix_3_3": ["Input 3", 1.0, 0.0, 2.0], "mix_4_3": ["Input 4", 0.0, 0.0, 2.0], "mix_3_1": ["Input 3", 0.0, 0.0, 2.0], "mix_4_2": ["Input 4", 0.0, 0.0, 2.0], "mix_1_1": ["Input 1", 1.0, 0.0, 2.0], "mix_1_2": ["Input 1", 0.0, 0.0, 2.0], "mix_1_3": ["Input 1", 0.0, 0.0, 2.0], "mix_2_3": ["Input 2", 0.0, 0.0, 2.0], "mix_2_2": ["Input 2", 1.0, 0.0, 2.0], "mix_2_1": ["Input 2", 0.0, 0.0, 2.0], "mix_4_1": ["Input 4", 0.0, 0.0, 2.0]}, "num_cv_in": 0}, "env_follower": {"category": 2, "inputs": {"INPUT": ["Audio In", "AudioPort"]}, "description": "Track an input signal and convert it into a control signal", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=1644s", "tags": ["cv generators"], "outputs": {"CV_OUT": ["CV Out", "CVPort"]}, "long_description": "", "controls": {"CDIRECTION": ["Invert", 0, 0, 1, "bool"], "CMINV": ["Minimum Value", 0.0, 0.0, 1.0], "SATURATION": ["Saturation", 1.0, 0.0, 2.0], "PEAKRMS": ["Peak/RMS", 0.0, 0.0, 1.0], "THRESHOLD": ["Threshold", 0.0, 0.0, 1.0], "DTIME": ["Decay Time", 0.1, 0.001, 2.0], "ATIME": ["Attack Time", 0.01, 0.001, 2.0], "CMAXV": ["Maximum Value", 1.0, 0.0, 1.0]}, "num_cv_in": 0}, "pitch_shift": {"category": 3, "inputs": {"Input": ["Input", "AudioPort"], "SemitoneCV": ["V/Oct Pitch", "CVPort"]}, "description": "a basic pitch shifter. It delays the input signal", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=1774s", "tags": ["pitch + synth"], "outputs": {"Output": ["Output", "AudioPort"]}, "long_description": "", "controls": {"Semitone": ["Semitone Shift", 0, -12, 12, "int"], "Drylevel": ["Dry Level", -90, -90, 20], "Wetlevel": ["Wet Level", 0, -90, 20]}, "num_cv_in": 1}, "power_amp_cream": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "An attempt at a cream coloured power amp emulation.", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2483s", "tags": ["amps, cabs + gain"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"TREBLE": ["TREBLE", 0.5, 0.0, 1.0], "VOLUME": ["VOLUME", 0.5, 0.0, 1.0], "BASS": ["BASS", 0.5, 0.0, 1.0], "LEVEL": ["LEVEL", 0.5, 0.0, 1.0]}, "num_cv_in": 0}, "quad_ir_reverb": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in_2": ["InR", "AudioPort"], "in_1": ["InL", "AudioPort"]}, "description": "Convolution reverb. Quad channel IRs required.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=259s", "tags": ["time effects"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "kill_dry": true, "long_description": "", "controls": {"ir": ["/audio/reverbs/emt_140_dark_1.wav", 0, 0, 1], "enabled": ["Enabled", 1, 0, 1], "wet": ["Output Gain", 0.0, -60.0, 6.0]}, "num_cv_in": 1}, "mono_reverb": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Mono convolution based reverb.", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=1595s", "tags": ["time effects"], "outputs": {"out": ["Out", "AudioPort"]}, "kill_dry": true, "long_description": "", "controls": {"ir": ["/audio/reverbs/emt_140_dark_1.wav", 0, 0, 1], "enabled": ["Enabled", 1, 0, 1], "gain": ["Output Gain", 0.0, -40.0, 4.0]}, "num_cv_in": 1}, "midi_rand_velocity": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "randomly change velocity of note-on events", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Randomize Velocity of MIDI notes (both note on and note off).", "controls": {"randfact": ["Velocity Randomization", 8.0, 0.0, 127.0, "int"], "mode": ["Random Mode", 1, 0, 1, "bool"], "channel": ["Filter Channel", 0, 0, 16, "int"]}, "num_cv_in": 0}, "ratio": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "a divided by b for control signals", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1057s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "note_sequencer": {"category": 2, "inputs": {"back_gate": ["Back Gate", "CVPort"], "reset": ["Reset Trigger", "CVPort"], "play": ["Play", "CVPort"], "bpm": ["BPM", "ControlPort"]}, "description": "16 Step note sequencer with internal clock", "video_url": "https://www.youtube.com/watch?v=n6cvz_eARg8&t=0s", "tags": ["cv generators"], "outputs": {"out": ["Value Out", "CVPort"]}, "broadcast_ports": {"current_step_out": ["current step out", 0, 0, 16], "bpm": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"bpm": ["BPM", 120, 20, 320], "note_length": ["Note Length", 0.125, 0.03125, 1], "val9": ["Value 9", 6, 0, 12], "val8": ["Value 8", 6, 0, 12], "val3": ["Value 3", 6, 0, 12], "val2": ["Value 2", 6, 0, 12], "val1": ["Value 1", 6, 0, 12], "val0": ["Value 0", 6, 0, 12], "val7": ["Value 7", 6, 0, 12], "val6": ["Value 6", 6, 0, 12], "val5": ["Value 5", 6, 0, 12], "val4": ["Value 4", 6, 0, 12], "play": ["play", 0.0, 0.0, 1.0], "octave": ["octave", 0, -4, 4.0], "back_gate": ["back", 0.0, 0.0, 1.0], "val15": ["Value 15", 6, 0, 12], "val14": ["Value 14", 6, 0, 12], "val13": ["Value 13", 6, 0, 12], "val12": ["Value 12", 6, 0, 12], "val11": ["Value 11", 6, 0, 12], "val10": ["Value 10", 6, 0, 12], "steps": ["Loop Steps", 16, 1, 16]}, "num_cv_in": 3}, "granular": {"inputs": {"l_in": ["L in", "AudioPort"], "trig": ["Trigger", "CVPort"], "freeze": ["Freeze", "CVPort"], "pitch": ["Pitch", "CVPort"], "size": ["Size", "CVPort"], "reverse": ["Reverse", "CVPort"], "Feedback": ["feedback", "CVPort"], "r_in": ["R in", "AudioPort"], "density": ["Density", "CVPort"], "texture": ["Texture", "CVPort"], "spread": ["Spread", "CVPort"], "position": ["Position", "CVPort"], "reverb": ["Reverb", "CVPort"], "blend": ["Blend", "CVPort"]}, "description": "Granular texture generator, can work as a weird delay or reverb. Based on Parasite firmware of Mutable Instruments Clouds.", "video_url": "https://www.youtube.com/watch?v=2g7hH2-9iEA&t=50s", "tags": ["ported", "time effects"], "outputs": {"r_out": ["R Out", "AudioPort"], "l_out": ["L Out", "AudioPort"]}, "long_description": "", "num_cv_in": 12, "category": 3, "kill_dry": true, "controls": {"pitch_param": ["pitch", 0.0, -24.0, 24.0, "int"], "blend_param": ["blend", 0.78, 0.0, 1.0], "reverb_param": ["reverb", 0.0, 0.0, 1.0], "position_param": ["position", 0.24, 0.0, 1.0], "freeze_param": ["freeze", 0.0, 0.0, 1.0], "feedback_param": ["feedback", 0.05, 0.0, 1.0], "texture_param": ["texture", 0.73, 0.0, 1.0], "density_param": ["density", 0.27, 0.0, 1.0], "spread_param": ["spread", 0.7, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "size_param": ["size", 0.69, 0.0, 1.0], "reverse_param": ["reverse", 0.0, 0.0, 1.0]}, "manual_url": "https://www.mutable-instruments.net/modules/clouds/manual/"}, "macro_osc": {"category": 3, "inputs": {"timbre_cv": ["timbre cv", "CVPort"], "trigger_cv": ["trigger cv", "CVPort"], "engine_cv": ["engine cv", "CVPort"], "freq_cv": ["frequency cv", "CVPort"], "level_cv": ["level cv", "CVPort"], "morph_cv": ["morph cv", "CVPort"], "harmonics_cv": ["harmonics cv", "CVPort"], "note_cv": ["V per oct CV", "CVPort"]}, "description": "A powerful multi model oscillator voice. Based on Mutable Instruments Plaits module.", "manual_url": "https://www.mutable-instruments.net/modules/plaits/manual/", "tags": ["ported", "pitch + synth"], "outputs": {"aux": ["aux", "AudioPort"], "out": ["out", "AudioPort"]}, "num_cv_in": 8, "long_description": "", "controls": {"lpg_decay": ["LPG Decay", 0.5, 0.0, 1.0], "frequency": ["frequency", 0.0, -4.0, 4.0], "timbre_mod": ["Timbre Mod", 0.0, -1.0, 1.0], "harmonics": ["harmonics", 0.5, 0.0, 1.0], "lpg_color": ["LPG Color", 0.5, 0.0, 1.0], "freq_mod": ["Frequency Mod", 0.0, -1.0, 1.0], "timbre": ["timbre", 0.5, 0.0, 1.0], "model": ["model", 0, 0.0, 16.0], "morph": ["morph", 0.5, 0.0, 1.0], "morph_mod": ["Morph Mod", 0.0, -1.0, 1.0]}, "video_url": "https://www.youtube.com/watch?v=1ED7ipo2wTM&t=1140s"}, "pitch_verb": {"inputs": {"l_in": ["L in", "AudioPort"], "trig": ["Trigger", "CVPort"], "freeze": ["Hold", "CVPort"], "pitch": ["Pitch", "CVPort"], "size": ["Size", "CVPort"], "reverse": ["Reverse", "CVPort"], "Feedback": ["Modulation Speed", "CVPort"], "r_in": ["R in", "AudioPort"], "density": ["Decay", "CVPort"], "texture": ["Damp", "CVPort"], "spread": ["Diffusion", "CVPort"], "position": ["pre-delay", "CVPort"], "reverb": ["Modulation Amount", "CVPort"], "blend": ["Blend", "CVPort"]}, "description": "A special effects algorthmic reverb, featuring longer tails than the convolution reverb. Based Parasites Oliverb firmware of Mutable Intruments Clouds module. ", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2039s", "tags": ["ported", "pitch + synth"], "outputs": {"r_out": ["R Out", "AudioPort"], "l_out": ["L Out", "AudioPort"]}, "long_description": "This eurorack based algorithmic reverb is designed to be modulated by control values.\n                 It's great for special effects, and general weirdness. It isn't well suited to realistic sounds. It's capable of pitch shifting and self oscilliation.", "num_cv_in": 12, "category": 0, "kill_dry": true, "controls": {"pitch_param": ["pitch", 0.0, -24.0, 24.0, "int"], "blend_param": ["blend", 0.5, 0.0, 1.0], "reverb_param": ["Modulation Amount", 0.0, 0.0, 1.0], "position_param": ["pre-delay", 0.5, 0.0, 1.0], "freeze_param": ["hold", 0.5, 0.0, 1.0], "feedback_param": ["Modulation Speed", 0.44, 0.0, 1.0], "texture_param": ["damp", 0.33, 0.0, 1.0], "density_param": ["decay", 0.7, 0.0, 1.0], "spread_param": ["diffusion", 0.09, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "size_param": ["size", 0.77, 0.0, 1.0], "reverse_param": ["reverse", 0.0, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/clouds.html"}, "midi_velocity_scale": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "modify note velocity by constant factor and offset", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Change the velocity of note events with separate controls for Note-on and Note-off. The input range 1 - 127 is mapped to the range between Min and Max. If Min is greater than Max, the range is reversed. The offsets value is added to the velocity event after mapping the Min/Max range.", "controls": {"onmin": ["Note-on Min", 1.0, 1.0, 127.0, "int"], "offmax": ["Note-off Max", 127.0, 0.0, 127.0, "int"], "offmin": ["Note-off Min", 0.0, 0.0, 127.0, "int"], "offoff": ["Note-off Offset", 0.0, -64.0, 64.0, "int"], "onmax": ["Note-on Max", 127.0, 0.0, 127.0, "int"], "channel": ["Channel", 0, 0, 16, "int"], "onoff": ["Note-on Offset", 0.0, -64.0, 64.0, "int"]}, "num_cv_in": 0}, "amp_bass": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "SVT40 bass amp sim", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=575s", "tags": ["amps, cabs + gain"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "A bass amp emulation. The tone stack has sections that can be tuned. Run a cab after this.", "controls": {"TREBLE": ["TREBLE", 0.5, 0.0, 1.0], "MIDDLE": ["MIDDLE", 0.5, 0.0, 1.0], "HIGHSWITCH": ["HIGHSWITCH", 0.0, 0.0, 1.0, "bool"], "BASS": ["BASS", 0.5, 0.0, 1.0], "LOWSWITCH": ["LOWSWITCH", 1.0, 0.0, 2.0, "int"], "VOLUME": ["VOLUME", 0.2, 0.0, 1.0], "CABSWITCH": ["CABSWITCH", 0.0, 0.0, 1.0, "bool"], "MIDSWITCH": ["MIDSWITCH", 1.0, 0.0, 2.0, "int"]}, "num_cv_in": 0}, "granular_looping": {"inputs": {"l_in": ["L in", "AudioPort"], "trig": ["Trigger", "CVPort"], "freeze": ["Loop", "CVPort"], "pitch": ["Pitch", "CVPort"], "size": ["pitch window", "CVPort"], "reverse": ["Reverse", "CVPort"], "Feedback": ["feedback", "CVPort"], "r_in": ["R in", "AudioPort"], "density": ["Diffusion", "CVPort"], "texture": ["Filter", "CVPort"], "spread": ["Spread", "CVPort"], "position": ["tape length", "CVPort"], "reverb": ["Reverb", "CVPort"], "blend": ["Blend", "CVPort"]}, "description": "Granular pitch shifting, micro looping delay. CPU Hungry. Based on Parasite firmware of Clouds by Mutable Instruments.", "video_url": "https://www.youtube.com/watch?v=2g7hH2-9iEA&t=1208s", "tags": ["ported", "time effects"], "outputs": {"r_out": ["R Out", "AudioPort"], "l_out": ["L Out", "AudioPort"]}, "long_description": "", "num_cv_in": 12, "category": 0, "kill_dry": true, "controls": {"pitch_param": ["pitch", 0.0, -24.0, 24.0, "int"], "blend_param": ["blend", 0.44, 0.0, 1.0], "reverb_param": ["reverb", 0.3, 0.0, 1.0], "position_param": ["tape length", 0.4, 0.0, 1.0], "freeze_param": ["freeze", 0.0, 0.0, 1.0], "feedback_param": ["feedback", 0.53, 0.0, 1.0], "texture_param": ["filter", 0.44, 0.0, 1.0], "density_param": ["diffusion", 0.7, 0.0, 1.0], "spread_param": ["spread", 0.81, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "size_param": ["pitch windows", 0.6, 0.0, 1.0], "reverse_param": ["reverse", 0.0, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/clouds.html"}, "resonestor": {"inputs": {"l_in": ["L in", "AudioPort"], "feedback": ["Harmonics", "CVPort"], "trig": ["Trigger", "CVPort"], "freeze": ["Switch Voice", "CVPort"], "pitch": ["Pitch", "CVPort"], "size": ["Chord", "CVPort"], "reverse": ["Reverse", "CVPort"], "density": ["Decay", "CVPort"], "r_in": ["R in", "AudioPort"], "texture": ["Filter", "CVPort"], "spread": ["Spread", "CVPort"], "position": ["Timbre", "CVPort"], "reverb": ["Scatter", "CVPort"], "blend": ["Random Mod", "CVPort"]}, "description": "dual voice four part resonator. Based on Parasite firmware of Clouds by Mutable Intstruments.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1449s", "tags": ["ported", "pitch + synth"], "outputs": {"r_out": ["R Out", "AudioPort"], "l_out": ["L Out", "AudioPort"]}, "long_description": "", "num_cv_in": 12, "category": 3, "kill_dry": true, "controls": {"pitch_param": ["pitch", 0.0, -24.0, 24.0, "int"], "blend_param": ["random mod", 0.05, 0.0, 1.0], "reverb_param": ["scatter", 0.08, 0.0, 1.0], "position_param": ["timbre", 0.83, 0.0, 1.0], "freeze_param": ["Switch Voice", 0.0, 0.0, 1.0], "feedback_param": ["harmonics", 0.6, 0.0, 1.0], "texture_param": ["filter", 0.5, 0.0, 1.0], "density_param": ["decay", 0.52, 0.0, 1.0], "spread_param": ["spread", 0.82, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "size_param": ["chord", 0.36, 0.0, 1.0], "reverse_param": ["reverse", 0.0, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/clouds.html"}, "midi_chord": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "create MIDI chords from a single note in a given musical scale", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1500s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Harmonizer - make chords from single (fundamental) note in a given musical scale. The scale as well as intervals can be automated freely (currently held chords will change). Note-ons are latched, for multiple/combined chords only single note-on/off will be triggered for the duration of the combined chords. If a off-scale note is given, it will be passed through - no chord is allocated. Note: Combine this effect with the \"MIDI Enforce Scale\" filter to weed them out.Hold a note until the next note arrives. -- Play the same note again to switch it off.", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"], "c9": ["9th", 0, 0, 1, "bool"], "c8": ["octave", 1, 0, 1, "bool"], "c3": ["3rd", 1, 0, 1, "bool"], "c2": ["2nd", 0, 0, 1, "bool"], "c1": ["prime", 1, 0, 1, "bool"], "hold": ["Hold Chord", 0, 0, 1, "bool"], "c7": ["7th", 0, 0, 1, "bool"], "c5": ["5th", 1, 0, 1, "bool"], "c4": ["4th", 0, 0, 1, "bool"], "scale": ["Scale", 0, 0, 11, "int"], "_8": ["bass", 0, 0, 1, "bool"]}, "num_cv_in": 0}, "cv_to_midi_cc": {"category": 1, "inputs": {"CV_IN": ["CV In", "CVPort"]}, "description": "convert control to MIDI CC", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=2245s", "tags": ["midi"], "outputs": {"MIDI_OUT": ["MIDI Out", "AtomPort"]}, "long_description": "", "controls": {"RESOLUTION": ["resolution", 0.01, 1e-05, 1], "CHAN": ["Channel", 1, 1, 16, "int"], "CC_NUM": ["CC Number", 0, 0, 127, "int"]}, "num_cv_in": 1}, "mono_cab": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Mono cab sim", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=827s", "tags": ["amps, cabs + gain"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"ir": ["/audio/cabs/1x12cab.wav", 0, 0, 1], "wet": ["Wet level", 0.0, -60.0, 6.0]}, "num_cv_in": 1}, "midi_transpose": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "chromatic transpose MIDI notes", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Chromatic transpose of midi notes and key-pressure. If an inversion point is set, the scale is mirrored around this point before transposing. Notes that end up outside the valid range 0..127 are discarded.", "controls": {"inversion": ["Inversion point", 0, 0, 127, "int"], "transpose": ["Transpose", 0, -63, 64, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"]}, "num_cv_in": 0}, "tonestack": {"category": 0, "inputs": {"in0": ["In", "AudioPort"]}, "description": "Amps style 3 knob tone stack", "tags": ["utilities"], "outputs": {"out0": ["Out", "AudioPort"]}, "controls": {"bass_0": ["Bass", 0.0, -10.0, 10.0], "mid_1": ["Mid", 0.0, -10.0, 10.0], "treble_2": ["Treble", 0.0, -10.0, 10.0]}, "long_description": "", "num_cv_in": 0}, "flanger": {"category": 0, "inputs": {"BPM_1": ["BPM", "ControlPort"], "in0": ["in", "AudioPort"]}, "description": "flanger with internal LFO", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=983s", "tags": ["mod effects"], "outputs": {"out0": ["out0", "AudioPort"]}, "broadcast_ports": {"BPM_1": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"BPM_1": ["BPM", 30, 5, 300], "Invert_3": ["Invert", 0, 0, 1, "bool"], "Feedback_4": ["Feedback", 0, -0.995, 0.99], "Delay_0": ["Delay", 0.22, 0, 1], "Waveshape_5": ["Waveshape", 0, 0, 1], "Depth_2": ["Depth", 0.75, 0, 1]}, "num_cv_in": 0}, "strum": {"category": 0, "inputs": {}, "description": "MIDI and V oct controller based on strumming", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1870s", "tags": ["pitch + synth"], "outputs": {"midi_out": ["MIDI Out", "AtomPort"], "gate_out": ["Gate", "CVPort"], "v_oct_out": ["v_oct_out", "CVPort"]}, "long_description": "choose chords and then strum the lines to get octaves of a chord", "controls": {"chord_root": ["Chord Root", 0, 0, 12], "touched_notes": ["touched_notes", -1, -1, 256], "lead_mode": ["lead mode", 0, 0, 1], "octave": ["octave", 0, -4, 4], "velocity": ["velocity", 1.0, 0.0, 1], "chord_type": ["chord type", 0, 0, 3]}, "num_cv_in": 0}, "difference": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "a - b for control signals", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=430s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "midi_delay": {"category": 0, "inputs": {"delayBPM": ["bpm", "ControlPort"], "midiin": ["MIDI In", "AtomPort"]}, "description": "delay MIDI events with optional randomization", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1948s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "broadcast_ports": {"delayBPM": ["BPM", 120, 1, 320]}, "long_description": "MIDI delay line. Delay all MIDI events by a given time which is given as BPM and beats. If the delay includes a random factor, this effect takes care of always keeping note on/off events sequential regardless of the randomization.", "controls": {"delayBPM": ["BPM", 120.0, 1.0, 280.0], "delayBeats": ["Delay Beats 4/4", 1.0, 0.0, 16.0, "int"], "delayRandom": ["Randomize [Beats]", 0.0, 0.0, 1.0, "int"]}, "num_cv_in": 0}, "wet_dry": {"category": 0, "inputs": {"dry": ["Dry", "AudioPort"], "wet": ["Wet", "AudioPort"], "xfade": ["Wet Dry Blend", "CVPort"], "level": ["Level", "CVPort"]}, "description": "blend between two inputs", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=3298s", "tags": ["level + dynamics"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"shape": ["Shape", 0.0, 0.0, 1.0], "xfade": ["Wet Dry", 0.0, -1.0, 1.0], "level": ["level", 1.0, 0.0, 1.0]}, "num_cv_in": 2}, "midi_strum": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"], "bpm": ["bpm", "ControlPort"]}, "description": "arpeggio effect intended to simulate strumming a stringed instrument (e.g. guitar)", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "A chord is \"collected\" and the single notes of the chord are played back spread out over time. The \"Note Collect Timeout\" allows for the effect to be played live with midi-keyboard, it compensates for a human not pressing keys at the same point in time. If the effect is used with a sequencer that can send chords with all note-on at the exactly time, it should be set to zero.BPM: base unit for the timeStrum Direction: 0 = Always Down (low notes first), 1 = Always Up (high notes first), 2 = Alternate, 3 = Up/Down Beat, 4 = Up/Down 8thNote Collect Timeout [ms]: Time to wait for chord to be \"complete\". Keys pressed withing given timeframe will be combined into one chord.Strum Duration in Beats: 0 = Immediate, 0.125 = 32nd, 0.25 = 16th, 0.5 = Eighth, 1 = Quarter, 2 = Half Note, 4 = Whole NoteStrum Acceleration: Accellerate/Decelerate over the time of the strum. The total duration remains unchanged. If the value is greater than zero, early notes are further apart and later notes will be closer together.Velocity Change: Modify velocity over stroke time. If the value is greater than zero, later notes will played louder.Randomize Acceleration: Amount of randomization to apply to the accel/decel setting. A Value of 1.0 means to add a random-number of the full-range (-1..1) to the given value.Randomize Velocity: Amount of randomization to apply to the acceleation value. A value of 1.0 means to add a random-number of the full-range (-112..112) to the given value.", "controls": {"adjspeed": ["Strum Acceleration", 0.0, -1.0, 1.0, "int"], "collect": ["Note Collect Timeout [ms]", 15.0, 0.0, 300.0, "int"], "randvelocity": ["Randomize Velocity", 0.0, 0.0, 1.0, "bool"], "adjvelocity": ["Velocity Change", 0.0, -112.0, 112.0, "int"], "randspeed": ["Randomize Acceleration", 0.0, 0.0, 1.0, "bool"], "duration": ["Strum Duration in Beats", 0.25, 0.0, 4.0, "int"], "bpm": ["BPM", 120.0, 1.0, 280.0, "int"], "mode": ["Strum Direction", 2, 0, 4, "int"]}, "num_cv_in": 0}, "foot_switch_c": {"category": 1, "inputs": {}, "description": "The right footswitch. Also available in Hector to allow patch compatability.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s", "tags": ["utilities"], "outputs": {"bpm_out": ["BPM Out", "ControlPort"], "out": ["Value Out", "CVPort"]}, "long_description": "", "controls": {"latching": ["Is Latching", 0.0, 0.0, 1.0, "bool"], "bpm": ["BPM", 120.0, 35.0, 350.0], "off_v": ["Off Value", 0.0, -1.0, 1.0], "value": ["value", 0.0, 0.0, 1.0], "on_v": ["On Value", 1.0, -1.0, 1.0], "cur_out": ["value", 0.0, 0.0, 1.0, "hide"]}, "num_cv_in": 0}, "bitcrushed_delay": {"inputs": {"Amp_5": ["Level", "CVPort"], "Feedback_4": ["Feedback", "CVPort"], "Delay_1": ["Time", "CVPort"], "DelayT60_3": ["Glide", "CVPort"], "BPM_0": ["BPM", "ControlPort"], "Warp_2": ["Warp", "CVPort"], "in0": ["in", "AudioPort"], "FeedbackSm_6": ["Tone", "CVPort"]}, "description": "Flexible delay module with bitcrushed repeats. Add modules on the repeats for variations.", "video_url": "", "tags": ["time effects"], "outputs": {"out0": ["out", "AudioPort"]}, "broadcast_ports": {"BPM_0": ["tempo", 120, 1, 320]}, "long_description": "", "num_cv_in": 6, "category": 0, "kill_dry": true, "controls": {"Amp_6": ["Level", 0.5, 0, 1], "NBITS_0": ["Bits", 8, 1, 16], "BPM_1": ["BPM", 120, 30, 300], "Delay_2": ["Time", 0.5, 0.001, 64], "Warp_3": ["Warp", 0, -1, 1], "Feedback_5": ["Feedback", 0.3, 0, 1], "is_using_tempo": ["is_using_tempo", 0, 0, 1], "enabled": ["Enabled", 1, 0, 1], "DelayT60_4": ["Glide", 0.5, 0, 100], "FeedbackSm_7": ["Tone", 0, 0, 1]}}, "foot_switch_a": {"category": 1, "inputs": {}, "description": "The left footswitch. Also available in Hector to allow patch compatability.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s", "tags": ["utilities"], "outputs": {"bpm_out": ["BPM Out", "ControlPort"], "out": ["Value Out", "CVPort"]}, "long_description": "", "controls": {"latching": ["Is Latching", 0.0, 0.0, 1.0, "bool"], "bpm": ["BPM", 120.0, 35.0, 350.0], "off_v": ["Off Value", 0.0, -1.0, 1.0], "value": ["value", 0.0, 0.0, 1.0], "on_v": ["On Value", 1.0, -1.0, 1.0], "cur_out": ["value", 0.0, 0.0, 1.0, "hide"]}, "num_cv_in": 0}, "midi_cc": {"category": 1, "inputs": {"input": ["MIDI Input", "AtomPort"]}, "description": "MIDI CC to control value", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=620s", "tags": ["midi"], "outputs": {"output_cv": ["Output", "CVPort"]}, "long_description": "", "controls": {"controller_number": ["CC Number", 0, 0.0, 127.0, "int"], "minimum": ["Minimum", 0, -1, 1], "maximum": ["Maximum", 1.0, 0.0, 1.0], "logarithmic": ["Logarithmic", 0.0, 0.0, 1.0, "bool"]}, "num_cv_in": 0}, "midi_pc": {"category": 0, "inputs": {"SET_CV": ["set trigger", "CVPort"], "UP_CV": ["up trigger", "CVPort"], "DOWN_CV": ["down trigger", "CVPort"]}, "description": "Send a MIDI program change message when triggered", "tags": ["midi"], "outputs": {"MIDI_OUT": ["MIDI Out", "AtomPort"]}, "broadcast_ports": {"pc_out": ["Current PC", 0, 0, 127]}, "long_description": "", "controls": {"PC_NUM": ["PC Number", 0, 0, 127, "int"], "CHAN": ["Channel", 1, 1, 16, "int"]}, "num_cv_in": 3}, "foot_switch_e": {"category": 1, "inputs": {}, "description": "The right and centre footswitch. Also available in Hector to allow patch compatability.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s", "tags": ["utilities"], "outputs": {"bpm_out": ["BPM Out", "ControlPort"], "out": ["Value Out", "CVPort"]}, "long_description": "", "controls": {"latching": ["Is Latching", 0.0, 0.0, 1.0, "bool"], "bpm": ["BPM", 120.0, 35.0, 350.0], "off_v": ["Off Value", 0.0, -1.0, 1.0], "value": ["value", 0.0, 0.0, 1.0], "on_v": ["On Value", 1.0, -1.0, 1.0], "cur_out": ["value", 0.0, 0.0, 1.0, "hide"]}, "num_cv_in": 0}, "foot_switch_d": {"category": 1, "inputs": {}, "description": "The left and centre right footswitch. Also available in Hector to allow patch compatability.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s", "tags": ["utilities"], "outputs": {"bpm_out": ["BPM Out", "ControlPort"], "out": ["Value Out", "CVPort"]}, "long_description": "", "controls": {"latching": ["Is Latching", 0.0, 0.0, 1.0, "bool"], "bpm": ["BPM", 120.0, 35.0, 350.0], "off_v": ["Off Value", 0.0, -1.0, 1.0], "value": ["value", 0.0, 0.0, 1.0], "on_v": ["On Value", 1.0, -1.0, 1.0], "cur_out": ["value", 0.0, 0.0, 1.0, "hide"]}, "num_cv_in": 0}, "wavefolder": {"inputs": {"num_fold_cv": ["num_fold_cv", "CVPort"], "modulator": ["modulator", "AudioPort"], "input_bias_cv": ["input_bias_cv", "CVPort"], "carrier": ["carrier", "AudioPort"], "input_amp_cv": ["input_amp_cv", "CVPort"], "input_amp_2_cv": ["input_amp_2_cv", "CVPort"]}, "description": "Chebyshev wave folder. Based on Parasite firmware of Warps by Mutable Instruments. ", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=2622s", "tags": ["ported", "amps, cabs + gain"], "outputs": {"aux": ["aux", "AudioPort"], "out": ["out", "AudioPort"]}, "long_description": "", "num_cv_in": 4, "category": 3, "kill_dry": true, "controls": {"int_osc": ["int_osc", 0.0, 0.0, 3.0], "enabled": ["Enabled", 1, 0, 1], "input_amp_2": ["input amplitude 2", 1.0, 0.0, 1.0], "n_folds": ["number of folds", 0.0, 0.0, 8.0], "input_bias": ["input_bias", 0.5, 0.0, 1.0], "input_amp": ["amp or freq", 1.0, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/warps.html"}, "stereo_reverb": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "Stereo convolution reverb.", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1498s", "tags": ["time effects"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "kill_dry": true, "long_description": "", "controls": {"enable": ["Enable", 1, 0, 1], "ir": ["/audio/0/0.wav", 0, 0, 1], "wet": ["Output Gain", 0.0, -60.0, 6.0]}, "num_cv_in": 0}, "foot_switch_b": {"category": 1, "inputs": {}, "description": "The center footswitch. Also available in Hector to allow patch compatability.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1087s", "tags": ["utilities"], "outputs": {"bpm_out": ["BPM Out", "ControlPort"], "out": ["Value Out", "CVPort"]}, "long_description": "", "controls": {"latching": ["Is Latching", 0.0, 0.0, 1.0, "bool"], "bpm": ["BPM", 120.0, 35.0, 350.0], "off_v": ["Off Value", 0.0, -1.0, 1.0], "value": ["value", 0.0, 0.0, 1.0], "on_v": ["On Value", 1.0, -1.0, 1.0], "cur_out": ["value", 0.0, 0.0, 1.0, "hide"]}, "num_cv_in": 0}, "tuner": {"category": 0, "inputs": {"in": ["Audio Input", "AudioPort"]}, "description": "A tuner suitable for tuning guitar or other instruments", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=2100s", "tags": ["utilities"], "outputs": {"sysex": ["MIDI MTS SysEx", "AtomPort"]}, "broadcast_ports": {"rms": ["Signal Level (RMS)", -65.0, -100, 0], "freq_out": ["Detected Frequency", 0, 0, 10000], "strobetoui": ["StrobeToUi", 0, 0, 100], "cent": ["Cent", 0, -50, 50], "note": ["Detected Note", 0, 0, 12], "octave": ["Detected Octave", 0, -1, 10], "accuracy": ["Note Stability", -100, -100, 100]}, "long_description": "", "controls": {"thresholdFFT": ["thresholdFFT", -40.0, -50.0, 10.0], "mode": ["Mode", 0, -128, 8000], "thresholdFundamental": ["thresholdFundamental", 5.0, 0.0, 60.0], "thresholdOverride": ["thresholdOverride", 20.0, 0.0, 40.0], "thresholdOvertones": ["thresholdvertones", -15.0, -100.0, 0.0], "thresholdOctave": ["thresholdOctave", -30.0, -100.0, 0.0], "enabled": ["Enabled", 0, 0, 1], "tuning": ["Tuning A440", 440.0, 220.0, 880.0], "thresholdPostFilter": ["thresholdPostFilter", -45.0, -50.0, 0.0], "thresholdRMS": ["thresholdRMS", -85.0, -100.0, 0.0]}, "num_cv_in": 0}, "midi_output": {"inputs": {"input": ["out", "AtomPort"]}, "num_cv_in": 0, "controls": {}, "outputs": {}}, "midi_channel_filter": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "discard messages per channel", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Simple MIDI channel filter. Only data for selected channels may pass.This filter only affects midi-data which is channel relevant (ie note-on/off, control and program changes, key and channel pressure and pitchbend).MIDI-SYSEX and Realtime message are always passed on. See also \"MIDI Channel Map\" filter.", "controls": {"chn12": ["Channel 12", 1, 0, 1, "int"], "chn11": ["Channel 11", 1, 0, 1, "int"], "chn10": ["Channel 10", 1, 0, 1, "int"], "chn3": ["Channel  3", 1, 0, 1, "int"], "chn2": ["Channel  2", 1, 0, 1, "int"], "chn1": ["Channel  1", 1, 0, 1, "int"], "chn7": ["Channel  7", 1, 0, 1, "int"], "chn6": ["Channel  6", 1, 0, 1, "int"], "chn5": ["Channel  5", 1, 0, 1, "int"], "chn4": ["Channel  4", 1, 0, 1, "int"], "chn9": ["Channel  9", 1, 0, 1, "int"], "chn8": ["Channel  8", 1, 0, 1, "int"]}, "num_cv_in": 0}, "midi_scale_cc": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "modify the value (data-byte) of a MIDI control change message", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Parameter (Min): lower end of parameter-range (inclusive)Parameter (Max): upper end of parameter-range (inclusive)Parameter Mode: 0 = Bypass, 1 = Include Range, 2 = Exclude RangeValue Mode: 0 = Clamp to 0..127, 1 = Reflect Overflow (-1 to 1, 128 to 127), 2 = Truncate Overflow (-1 to 127, 128 to 0)", "controls": {"upper": ["Parameter (Max)", 127, 0, 127, "int"], "lower": ["Parameter (Min)", 0, 0, 127, "int"], "pmode": ["Parameter Mode", 1, 0, 2, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "vmode": ["Value Mode", 0, 0, 2, "int"], "valoff": ["Value Offset", 0, -64, 64, "int"], "valmul": ["Value Scale", 1.0, -10.0, 10.0, "int"]}, "num_cv_in": 0}, "filter_uberheim": {"category": 3, "inputs": {"cutoff_cv": ["Cutoff CV", "CVPort"], "q_cv": ["Q CV", "CVPort"], "in": ["in", "AudioPort"]}, "description": "A multi out filter inspired by vintage American designs", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=698s", "tags": ["pitch + synth"], "outputs": {"band_stop": ["Band Stop", "AudioPort"], "band_pass": ["Band Pass", "AudioPort"], "high_pass": ["High Pass", "AudioPort"], "low_pass": ["Low Pass", "AudioPort"]}, "long_description": "", "controls": {"Q": ["Q", 1, 0.5, 10], "cutoff": ["cutoff", 0.5, 0, 1]}, "num_cv_in": 2}, "midi_cc_to_note": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "translate control-commands to note-on/off messages", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1205s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Filter ChannelMIDI Channel (1..16) on which the filter is active.Data on other channels is passed though unmodified.Operation Mode:Value 0 = Fixed key, velocity = CC-valueValue 1 = key = CC-value, fixed velocity (64)Value 2 = All keys, key = parameter, velocity = CC-valueCC Parameter to Intercept:unused in \"all keys\" mode.Key (midi-note):only used in \"velocity = value\" mode.Convert MIDI control change messages to note-on/off messages.Note off is queued 10msec later.", "controls": {"param": ["CC Parameter to intercept", 0, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "key": ["Key (midi-note)", 48, 0, 127, "int"], "mode": ["Operation Mode", 1, 0, 3, "int"]}, "num_cv_in": 0}, "lfo": {"category": 2, "inputs": {"reset": ["Reset", "CVPort"], "tempo": ["BPM", "ControlPort"]}, "description": "Low frequency oscillator, send a control signal.", "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=80s", "tags": ["cv generators"], "outputs": {"output": ["Output", "CVPort"]}, "broadcast_ports": {"tempo": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"waveForm": ["Wave Form", 0, 0, 5, "int"], "tempoMultiplier": ["Tempo Multiplier", 1.0, 0.02, 32.0], "tempo": ["Tempo", 120.0, 10.0, 320.0], "is_uni": ["Unipolar", 1.0, 0.0, 1.0, "bool"], "level": ["Level", 1.0, -1.0, 1.0]}, "num_cv_in": 1}, "k_org_hpf": {"category": 3, "inputs": {"cutoff_cv": ["Cutoff CV", "CVPort"], "q_cv": ["Q CV", "CVPort"], "in": ["in", "AudioPort"]}, "description": "A high pass filter similar to the vintage Japanese designs", "video_url": "https://www.youtube.com/watch?v=6hHgWDboqIU&t=570s", "tags": ["pitch + synth"], "outputs": {"out": ["out", "AudioPort"]}, "long_description": "", "controls": {"Q": ["Q", 1, 0.5, 10], "cutoff": ["cutoff", 0.5, 0, 1]}, "num_cv_in": 2}, "freeze": {"category": 0, "inputs": {"STICK_IT": ["Freeze", "CVPort"], "INPUT": ["Audio In", "AudioPort"]}, "description": "Holds what you are playing when the control level is active, creating a drone.", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=1328s", "tags": ["time effects"], "outputs": {"OUTPUT": ["Audio Out", "AudioPort"]}, "long_description": "", "controls": {"RELEASE": ["Release", 0.5, 0.01, 3.0], "STICK_IT": ["Freeze", 0, 0, 1, "bool"], "DRONE_GAIN": ["Drone Gain", 0.5, 0.0, 2.0]}, "num_cv_in": 1}, "midi_input": {"inputs": {}, "num_cv_in": 0, "controls": {}, "outputs": {"output": ["in", "AtomPort"]}}, "input": {"inputs": {}, "num_cv_in": 0, "controls": {}, "outputs": {"output": ["in", "AudioPort"]}}, "vca": {"category": 2, "inputs": {"gain": ["Gain", "CVPort"], "in": ["Input", "AudioPort"]}, "description": "simple voltage controlled amplifier", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=590s", "tags": ["level + dynamics"], "outputs": {"out": ["Output", "AudioPort"]}, "long_description": "", "controls": {"gain": ["Gain", 1.0, 0.0, 1.0]}, "num_cv_in": 1}, "phaser": {"category": 0, "inputs": {"lv2_audio_in_1": ["Audio Input 1", "AudioPort"]}, "description": "Basic phaser", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=0s", "tags": ["mod effects"], "outputs": {"lv2_audio_out_1": ["Audio Output 1", "AudioPort"]}, "long_description": "", "controls": {"color": ["Color", 1, 0, 1, "bool"], "feedback_depth": ["Feedback depth", 75, 0, 99], "lfo_frequency": ["LFO frequency", 0.2, 0.01, 5.0], "feedback_hpf_cutoff": ["Feedback bass cut", 500.0, 10.0, 5000.0], "mix": ["Dry/wet mix", 50, 0, 100]}, "num_cv_in": 0}, "mono_EQ": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "Mono multiband parametric EQ", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=598s", "tags": ["level + dynamics"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"HPfreq": ["Highpass Frequency", 20.0, 5.0, 1250.0], "gain4": ["Gain 4", 0.0, -18.0, 18.0], "enable": ["Enable", 1, 0, 1], "gain2": ["Gain 2", 0.0, -18.0, 18.0], "gain3": ["Gain 3", 0.0, -18.0, 18.0], "HSfreq": ["Highshelf Frequency", 8000.0, 1000.0, 16000.0], "HPQ": ["HighPass Resonance", 0.7, 0.0, 1.4], "LSfreq": ["Lowshelf Frequency", 80.0, 25.0, 400.0], "sec2": ["Section 2", 1, 0, 1], "LPQ": ["LowPass Resonance", 1.0, 0.0, 1.4], "HighPass": ["Highpass", 0, 0, 1], "HSq": ["Highshelf Bandwidth", 1.0, 0.0625, 4.0], "gain": ["Gain", 0.0, -18.0, 18.0], "LowPass": ["Lowpass", 0, 0, 1], "LSq": ["Lowshelf Bandwidth", 1.0, 0.0625, 4.0], "peakreset": ["Reset Peak Hold", 1, 0, 1], "HSsec": ["Highshelf", 1, 0, 1], "q1": ["Bandwidth 1", 0.6, 0.0625, 4.0], "q3": ["Bandwidth 3", 0.6, 0.0625, 4.0], "q2": ["Bandwidth 2", 0.6, 0.0625, 4.0], "LPfreq": ["Lowpass Frequency", 20000.0, 500.0, 20000.0], "q4": ["Bandwidth 4", 0.6, 0.0625, 4.0], "freq4": ["Frequency 4", 2500.0, 200.0, 20000.0], "freq3": ["Frequency 3", 1250.0, 100.0, 10000.0], "freq2": ["Frequency 2", 397.0, 40.0, 4000.0], "freq1": ["Frequency 1", 160.0, 20.0, 2000.0], "sec1": ["Section 1", 1, 0, 1], "sec3": ["Section 3", 1, 0, 1], "LSsec": ["Lowshelf", 1, 0, 1], "sec4": ["Section 4", 1, 0, 1], "gain1": ["Gain 1", 0.0, -18.0, 18.0], "HSgain": ["Highshelf Gain", 0.0, -18.0, 18.0], "LSgain": ["Lowshelf Gain", 0.0, -18.0, 18.0]}, "num_cv_in": 0}, "onset_detect": {"category": 2, "inputs": {"in": ["In", "AudioPort"]}, "description": "detects when a note starts and sends a trigger", "video_url": "https://www.youtube.com/watch?v=n6cvz_eARg8&t=1000s", "tags": ["cv generators"], "outputs": {"gate": ["Gate", "CVPort"]}, "long_description": "", "controls": {"silence_threshold": ["Silence Threshold", -90.0, -90.0, -10.0], "onset_threshold": ["Onset Threshold", 0.3, 0.1, 1.0]}, "num_cv_in": 0}, "sum": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "a + b for control signals", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=2324s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "cv_to_note": {"category": 0, "inputs": {"pitch_in": ["Pitch", "CVPort"], "gate_in": ["Gate", "CVPort"], "velocity_in": ["Velocity", "CVPort"]}, "description": "converted v/oct pitch to MIDI notes. Velocity is optional.", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=2520s", "tags": ["midi"], "outputs": {"midi_out": ["MIDI note Out", "AtomPort"]}, "long_description": "If velocity is not connected, 64 is sent for velocity. Note offset is +- from note 60", "controls": {"note_offset": ["note offset", 0, -60, 60], "chan": ["Channel", 1, 1, 16]}, "num_cv_in": 3}, "short_mono_cab": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Mono cab sim", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=827s", "tags": ["amps, cabs + gain"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"ir": ["/audio/cabs/1x12cab.wav", 0, 0, 1], "gain": ["Output Gain", 0.0, -40.0, 24.0]}, "num_cv_in": 1}, "power_amp_super": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "An attempt at a power amp emulation", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2483s", "tags": ["amps, cabs + gain"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"TREBLE": ["TREBLE", 0.5, 0.0, 1.0], "VOLUME": ["VOLUME", 0.25, 0.0, 1.0], "BASS": ["BASS", 0.5, 0.0, 1.0], "GAIN": ["GAIN", 0.15, 0.0, 1.0]}, "num_cv_in": 0}, "vibrato_ext": {"category": 0, "inputs": {"in1": ["in", "AudioPort"], "lfo_cv": ["LFO CV", "CVPort"]}, "description": "vibrato with CV LFO", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1936s", "tags": ["mod effects"], "outputs": {"out0": ["out", "AudioPort"]}, "long_description": "", "controls": {"Feedback_Gain_3": ["Feedback Gain", 0, -0.999, 0.999], "Min_Notch1_Freq_5": ["Min Notch1 Freq", 100, 20, 5000], "Notch_width_4": ["Notch width", 1000, 10, 5000], "Max_Notch1_Freq_6": ["Max Notch1 Freq", 800, 20, 10000], "Notch_Depth__Intensity__2": ["Notch Depth", 1, 0, 1], "Notch_Freq_Ratio_7": ["Notch Freq Ratio", 1.5, 1.1, 4], "Invert_Internal_Phaser_Sum_0": ["Invert", 0.0, 0.0, 1.0, "bool"], "Vibrato_Mode_1": ["Vibrato Mode", 0.0, 0.0, 1.0, "bool"]}, "num_cv_in": 1}, "short_quad_ir_reverb": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in_2": ["InR", "AudioPort"], "in_1": ["InL", "AudioPort"]}, "description": "Convolution reverb. Quad channel IRs required.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=259s", "tags": ["time effects"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "kill_dry": true, "long_description": "", "controls": {"ir": ["/audio/reverbs/emt_140_dark_1.wav", 0, 0, 1], "enabled": ["Enabled", 1, 0, 1], "gain": ["Output Gain", 0.0, -40.0, 4.0]}, "num_cv_in": 1}, "boost": {"category": 0, "inputs": {"in": ["Input", "AudioPort"]}, "description": "very basic boost", "tags": ["utilities"], "outputs": {"out": ["Output", "AudioPort"]}, "controls": {"on": ["on", 1, 0.0, 1.0], "gain": ["Gain", 2.0, 1.0, 4.0]}, "long_description": "", "num_cv_in": 0}, "attenuverter": {"category": 2, "inputs": {"multiplicand": ["A", "CVPort"], "multiplier": ["B", "CVPort"]}, "description": "The attenuverter changes level and/or phase of a control signal. A x B", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=710s", "tags": ["utilities"], "outputs": {"product": ["Product", "CVPort"]}, "long_description": "An attenuverter attenuates and inverts signals.\n                  You can combine signals using it, for example to ring modulate two LFOs together, or just reduce the level of a CV", "controls": {"multiplicand": ["A", 0.5, -1.0, 1.0], "multiplier": ["B", 0.5, -1.0, 1.0]}, "num_cv_in": 2}, "chaos_controller": {"inputs": {"x_steps_input": ["X Steps Input", "CVPort"], "x_bias_input": ["X Bias Input", "CVPort"], "t_jitter_input": ["T Jitter Input", "CVPort"], "t_rate_param": ["BPM T Clock", "ControlPort"], "t_bias_input": ["T Bias Input", "CVPort"], "x_spread_input": ["X Spread Input", "CVPort"], "x_clock_input": ["X Clock Input", "CVPort"], "t_rate_input": ["T Rate Input", "CVPort"], "deja_vu_input": ["Deja Vu Input", "CVPort"], "t_clock_input": ["T Clock Trigger Input", "CVPort"]}, "description": "Powerful repeatable randomness source. Based on Mutable Instruments Marbles module.", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=146s", "tags": ["ported", "cv generators"], "outputs": {"x1_output": ["X1 Output", "CVPort"], "x2_output": ["X2 Output", "CVPort"], "t3_output": ["T3 Output", "CVPort"], "t1_output": ["T1 Output", "CVPort"], "x3_output": ["X3 Output", "CVPort"], "y_output": ["Y Output", "CVPort"], "t2_output": ["T2 Output", "CVPort"]}, "broadcast_ports": {"t_rate_param": ["T Clock BPM", 120, 5, 840]}, "long_description": "A source of random gates and voltages, which offers an extensive amount of (voltage) control on all the different flavors of randomness it produces. The module gives the musician many different ways of imposing structure on the random events generated by the module: synchronization to external clocks, control of the repetition or novelty of the generated material, quantization of the voltages, or randomization of gates or voltages generated by traditional sequencers.", "num_cv_in": 9, "category": 2, "controls": {"x_mode_param": ["X Mode", 0, 0.0, 2.0], "t_rate_param": ["T Clock BPM", 120, 5.0, 840.0], "deja_vu_param": ["Deja Vu Probablity", 0.5, 0.0, 1.0], "x_steps_param": ["X Smoothness Steps", 0.5, 0.0, 1.0], "x_deja_vu_param": ["X Deja Vu", 0, 0.0, 1.0], "t_bias_param": ["T Gate Bias", 0.5, 0.0, 1.0], "y_bias_param": ["Y Distribution Bias", 0.5, 0.0, 1.0], "y_steps_param": ["Y Smoothness", 0.5, 0.0, 1.0], "x_spread_param": ["X Spread", 0, 0.0, 1.0], "y_spread_param": ["Y Spread", 0.0, 0.0, 1.0], "x_clock_source_internal": ["X Clock Source Internal", 0, 0.0, 3.0], "x_range_param": ["X Range", 0, 0.0, 2.0], "t_deja_vu_param": ["T Deja Vu", 0, 0.0, 1.0], "deja_vu_length_param": ["Deja Vu Length", 0, 0.0, 1.0], "t_mode_param": ["T Mode", 0, 0.0, 2.0], "t_jitter_param": ["T Jitter", 0, 0.0, 1.0], "x_bias_param": ["X Distribution Bias", 0.5, 0.0, 1.0], "x_scale": ["X Scale", 0, 0.0, 5.0], "external_param": ["External Control", 0, 0.0, 1.0, "bool"], "y_divider": ["Y Divider", 0, 0.0, 12.0], "t_range_param": ["T Range", 0, 0.0, 2.0]}, "manual_url": "https://www.mutable-instruments.net/modules/marbles/manual/"}, "trigger_to_gate": {"category": 0, "inputs": {"trigger": ["trigger", "CVPort"], "tempo": ["Tempo", "ControlPort"], "gate_length_cv": ["Gate Length CV", "CVPort"]}, "description": "Takes in a trigger and outputs a gate with a length related to the tempo", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=2130s", "tags": ["utilities"], "outputs": {"gate_out": ["gate out", "CVPort"]}, "broadcast_ports": {"tempo": ["tempo", 120, 1, 320]}, "long_description": "The gate length is how much of a bar is taken up assuming tempo is quarter notes", "controls": {"tempo": ["tempo", 120, 30, 300], "gate_length": ["gate length", 0.25, 0.03125, 1]}, "num_cv_in": 2}, "phaser_ext": {"category": 0, "inputs": {"lv2_audio_in_1": ["Audio Input 1", "AudioPort"], "lv2_audio_in_2": ["LFO CV", "CVPort"]}, "description": "Mono phaser controlled by CV input", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=379s", "tags": ["mod effects"], "outputs": {"lv2_audio_out_1": ["Audio Output 1", "AudioPort"]}, "long_description": "", "controls": {"color": ["Color", 1, 0, 1, "bool"], "feedback_depth": ["Feedback depth", 75, 0, 99], "feedback_hpf_cutoff": ["Feedback bass cut", 500.0, 10.0, 5000.0], "mix": ["Dry/wet mix", 50, 0, 100]}, "num_cv_in": 1}, "stereo_EQ": {"category": 0, "inputs": {"inL": ["In Left", "AudioPort"], "inR": ["In Right", "AudioPort"]}, "description": "Stereo multiband parametric EQ.", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1345s", "tags": ["level + dynamics"], "outputs": {"outR": ["Out Right", "AudioPort"], "outL": ["Out Left", "AudioPort"]}, "long_description": "", "controls": {"HPfreq": ["Highpass Frequency", 20.0, 5.0, 1250.0], "gain4": ["Gain 4", 0.0, -18.0, 18.0], "enable": ["Enable", 1, 0, 1], "gain2": ["Gain 2", 0.0, -18.0, 18.0], "gain3": ["Gain 3", 0.0, -18.0, 18.0], "HSfreq": ["Highshelf Frequency", 8000.0, 1000.0, 16000.0], "HPQ": ["HighPass Resonance", 0.7, 0.0, 1.4], "LSfreq": ["Lowshelf Frequency", 80.0, 25.0, 400.0], "sec2": ["Section 2", 1, 0, 1], "LPQ": ["LowPass Resonance", 1.0, 0.0, 1.4], "HighPass": ["Highpass", 0, 0, 1], "HSq": ["Highshelf Bandwidth", 1.0, 0.0625, 4.0], "gain": ["Gain", 0.0, -18.0, 18.0], "LowPass": ["Lowpass", 0, 0, 1], "LSq": ["Lowshelf Bandwidth", 1.0, 0.0625, 4.0], "HSsec": ["Highshelf", 1, 0, 1], "q1": ["Bandwidth 1", 0.6, 0.0625, 4.0], "q3": ["Bandwidth 3", 0.6, 0.0625, 4.0], "q2": ["Bandwidth 2", 0.6, 0.0625, 4.0], "LPfreq": ["Lowpass Frequency", 20000.0, 500.0, 20000.0], "q4": ["Bandwidth 4", 0.6, 0.0625, 4.0], "freq4": ["Frequency 4", 2500.0, 200.0, 20000.0], "freq3": ["Frequency 3", 1250.0, 100.0, 10000.0], "freq2": ["Frequency 2", 397.0, 40.0, 4000.0], "freq1": ["Frequency 1", 160.0, 20.0, 2000.0], "sec1": ["Section 1", 1, 0, 1], "sec3": ["Section 3", 1, 0, 1], "LSsec": ["Lowshelf", 1, 0, 1], "sec4": ["Section 4", 1, 0, 1], "gain1": ["Gain 1", 0.0, -18.0, 18.0], "HSgain": ["Highshelf Gain", 0.0, -18.0, 18.0], "LSgain": ["Lowshelf Gain", 0.0, -18.0, 18.0]}, "num_cv_in": 0}, "chorus_d_ext": {"category": 0, "inputs": {"in0": ["in", "AudioPort"], "in1": ["LFO CV", "CVPort"]}, "description": "8 voice multi dimensional chorus CV LFO", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=1358s", "tags": ["mod effects"], "outputs": {"out0": ["out L", "AudioPort"], "out1": ["out R", "AudioPort"]}, "long_description": "", "controls": {"Depth_1": ["Depth", 0.5, 0, 1], "Deviation_2": ["Deviation", 0.5, 0, 1], "Delay_0": ["Delay", 0.5, 0, 1]}, "num_cv_in": 1}, "short_stereo_reverb": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Stereo convolution reverb", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1498s", "tags": ["time effects"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "kill_dry": true, "long_description": "", "controls": {"ir": ["/audio/reverbs/emt_140_dark_1.wav", 0, 0, 1], "enabled": ["Enabled", 1, 0, 1], "gain": ["Output Gain", 0.0, -40.0, 4.0]}, "num_cv_in": 1}, "vinyl": {"category": 0, "inputs": {"gain6": ["Vol Crinkle", "CVPort"], "gain4": ["Vol Rumble", "CVPort"], "gain5": ["Vol crackle", "CVPort"], "gain2": ["Vol Static", "CVPort"], "gain3": ["Vol Noise", "CVPort"], "in_r": ["In R", "AudioPort"], "gain1": ["Vol Motor", "CVPort"], "in_l": ["In L", "AudioPort"]}, "description": "Emulate dirty old lo-fi vinyl records. Bit CPU hungry but fun", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1980s", "tags": ["mod effects"], "outputs": {"out_l": ["Out L", "AudioPort"], "out_r": ["Out R", "AudioPort"]}, "long_description": "This is not good for nice clean stuff...", "controls": {"pitch5": ["Pitch Crackle", 0, -1, 1], "pitch6": ["Pitch Crinkle", 0, -1, 1], "enabled": ["Enabled", 1, 0, 1, "bool"], "freq": ["Aging Frequency", 1000, 600, 1800], "aging": ["Aging", 0, 0, 1], "gain0": ["Gain", 0.001, 0, 1], "active5": ["Crackle", 0, 0, 1, "bool"], "active4": ["Rumble", 0, 0, 1, "bool"], "active6": ["Crinkle", 0, 0, 1, "bool"], "active1": ["Motor", 0, 0, 1, "bool"], "active3": ["Noise", 0, 0, 1, "bool"], "active2": ["Static", 0, 0, 1, "bool"]}, "num_cv_in": 6}, "output": {"inputs": {"input": ["out", "AudioPort"]}, "num_cv_in": 0, "controls": {}, "outputs": {}}, "vibrato": {"category": 0, "inputs": {"BPM_9": ["BPM", "ControlPort"], "in0": ["in", "AudioPort"]}, "description": "vibrato with internal LFO", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=1590s", "tags": ["mod effects"], "outputs": {"out0": ["out", "AudioPort"]}, "broadcast_ports": {"BPM_1": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"Feedback_Gain_3": ["Feedback Gain", 0, -0.999, 0.999], "Notch_width_5": ["Notch width", 1000, 10, 5000], "Min_Notch1_Freq_6": ["Min Notch1 Freq", 100, 20, 5000], "Max_Notch1_Freq_7": ["Max Notch1 Freq", 800, 20, 10000], "Notch_Depth__Intensity__2": ["Notch Depth", 1, 0, 1], "Phase_4": ["Phase", 0, 0, 1], "Notch_Freq_Ratio_8": ["Notch Freq Ratio", 1.5, 1.1, 4], "BPM_9": ["BPM", 30, 4, 300], "Invert_Internal_Phaser_Sum_0": ["Invert", 0.0, 0.0, 1.0, "bool"], "Vibrato_Mode_1": ["Vibrato Mode", 1.0, 0.0, 1.0, "bool"]}, "num_cv_in": 0}, "midi_velocity_gamma": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "modify note velocity curve by a gamma exponent", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Change the velocity of note events with separate controls for Note-on and Note-off. Velocities are first normalized to the range 0..1, then the gamma is applied as an exponent, and then the result is scaled back onto the 0..127 range. Higher gamma values produce a \"softer\" velocity curve, lower gamma values make the low end harder. Gamma = 0 effectively produces a constant velocity.", "controls": {"offgamma": ["Note-off Gamma", 1.0, 0.0, 5.0, "int"], "channel": ["Channel", 0, 0, 16, "int"], "ongamma": ["Note-on Gamma", 1.0, 0.0, 5.0, "int"]}, "num_cv_in": 0}, "rectify_value": {"category": 2, "inputs": {"a_cv": ["A CV", "CVPort"]}, "description": "rectify or get the absolute value of the input. ", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1226s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {}, "num_cv_in": 1}, "auto_swell": {"category": 0, "inputs": {"TRESHOLD": ["THRESHOLD", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Automatically swells volume to remove note attack", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=940s", "tags": ["level + dynamics"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "Auto swell is a similar effect to using your volume knob but instead it automatically detects when to swell.If you are looking for something more complex, you can combine an envelope follower and VCA to create your own", "controls": {"TRESHOLD": ["THRESHOLD", 1.0, 0.0, 1], "UPTIME": ["UPTIME", 100, 0.0, 5000], "DOWNTIME": ["DOWNTIME", 5.0, 0.0, 5000]}, "num_cv_in": 1}, "twist_delay": {"inputs": {"length_cv": ["length cv", "CVPort"], "modulator": ["in 2", "AudioPort"], "dry_wet_cv": ["dry wet cv", "CVPort"], "carrier": ["in 1", "AudioPort"], "feedback_cv": ["feedback cv", "CVPort"], "speed_direct_cv": ["speed direction cv", "CVPort"]}, "description": "A delay where speed and length interact with quality. Based on Parasite firmware of Warps by Mutable Instruments.", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1592s", "tags": ["ported", "time effects"], "outputs": {"aux": ["out 2", "AudioPort"], "out": ["out 1", "AudioPort"]}, "long_description": "", "num_cv_in": 4, "category": 0, "kill_dry": true, "controls": {"speed_direction": ["speed direction", 2.39, 0.0, 8.0], "feedback": ["feedback", 0.75, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "length": ["length", 0.95, 0.0, 1.0], "mode": ["mode", 1.0, 0.0, 3.0], "dry_wet": ["dry wet", 0.5, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/warps.html"}, "slew_limiter": {"category": 2, "inputs": {"in": ["In", "CVPort"]}, "description": "Slows how fast a control signal changes. Useful with foot switches.", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=679s", "tags": ["cv generators"], "outputs": {"out": ["Out", "CVPort"]}, "long_description": "", "controls": {"timeUp": ["Time Up", 0.5, 0.0, 10], "timeDown": ["Time Down", 0.5, 0, 10]}, "num_cv_in": 1}, "harmonic_tremolo": {"category": 0, "inputs": {"BPM_0": ["BPM", "ControlPort"], "in0": ["in", "AudioPort"]}, "description": "harmonic tremolo with internal LFO", "video_url": "https://www.youtube.com/watch?v=6hHgWDboqIU&t=90s", "tags": ["mod effects"], "outputs": {"out0": ["out", "AudioPort"]}, "broadcast_ports": {"BPM_0": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"depth_2": ["Depth", 0.1, 0, 1], "BPM_0": ["BPM", 120, 15, 300], "CrossoverFreq_1": ["Crossover Freq", 800, 20, 10000]}, "num_cv_in": 0}, "reverse": {"category": 0, "inputs": {"dry": ["Dry Level", "CVPort"], "input": ["Input", "AudioPort"], "wet": ["Wet Level", "CVPort"]}, "description": "Reverse effect. Try short fragment length for weird tremolo", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=1945s", "tags": ["time effects"], "outputs": {"output": ["Output", "AudioPort"]}, "long_description": "", "controls": {"dry": ["Dry Level", 0.0, -90.0, 20.0], "fragment": ["Fragment Length", 1000.0, 100.0, 1600.0], "wet": ["Wet Level", 0.0, -90.0, 20.0]}, "num_cv_in": 2}, "midi_choke_filter": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "trigger note-off events, create exclusive note-groups", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1338s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "MIDI Choke filter. Send note-off message for choke note (if it is on), when any note within the trigger note range is received.Low Trigger Note: Lowest note of the note range, which triggers the choke.High Trigger Note: Highest note of the note range, which triggers the choke.Choke Note: Note, which is choked when a trigger note is received.Release Velocity: What to set the release velocity of the choke note-off to.", "controls": {"rvmode": ["Release Velocity", 2, 0, 2, "int"], "triggerhi": ["High Trigger Note", 42, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "triggerlo": ["Low Trigger Note", 42, 0, 127, "int"], "choke": ["Choke Note", 46, 0, 127, "int"]}, "num_cv_in": 0}, "loop_extra_midi": {"category": 1, "inputs": {"input": ["out", "AtomPort"]}, "description": "Connect internal MIDI generators to the Looper, do not connect external MIDI here, will duplicate.", "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s", "tags": ["midi"], "outputs": {}, "long_description": "For example trigger loops with a chaos controller module connected to a CV to CC then to this.", "controls": {}, "num_cv_in": 0}, "filter": {"category": 3, "inputs": {"exp_fm": ["Exp FM", "CVPort"], "res_mod": ["Resonance Mod", "CVPort"], "fm": ["FM", "CVPort"], "in": ["Input", "AudioPort"]}, "description": "Virtual analog resonant low pass filter", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=525s", "tags": ["pitch + synth"], "outputs": {"out": ["Output", "AudioPort"]}, "long_description": "", "controls": {"in_gain": ["Input gain", 0.0, -60.0, 10.0], "exp_fm_gain": ["Exp. FM gain", 0.5, 0.0, 10.0], "res": ["Resonance", 0.5, 0.0, 1.0], "res_gain": ["Resonance gain", 0.5, 0.0, 1.0], "out_gain": ["Output gain", 0.0, -15.0, 15.0], "freq": ["Frequency", 440.0, 25, 18000]}, "num_cv_in": 3}, "wet_dry_stereo": {"category": 0, "inputs": {"wet_l": ["Wet L", "AudioPort"], "level": ["Level", "CVPort"], "dry_l": ["Dry L", "AudioPort"], "xfade": ["Wet Dry Blend", "CVPort"], "dry_r": ["Dry R", "AudioPort"], "wet_r": ["Wet R", "AudioPort"]}, "description": "blend stereo inputs to stereo out", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=3298s", "tags": ["level + dynamics"], "outputs": {"out_l": ["Out L", "AudioPort"], "out_r": ["Out R", "AudioPort"]}, "long_description": "", "controls": {"shape": ["Shape", 0.0, 0.0, 1.0], "xfade": ["signal a/b", 0.0, -1.0, 1.0], "level": ["level", 1.0, 0.0, 1.0]}, "num_cv_in": 2}, "turntable_stop": {"category": 0, "inputs": {"INPUT": ["Audio In", "AudioPort"], "DTIME": ["Decay Time", "CVPort"], "PULL_THE_PLUG": ["Pull the Plug", "CVPort"]}, "description": "Simulates turning off a turntable. Connect a control to pull the plug.", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=1480s", "tags": ["mod effects"], "outputs": {"OUTPUT": ["Audio Out", "AudioPort"]}, "long_description": "", "controls": {"DTIME": ["Decay Time", 0.5, 0.01, 10.0], "DCURVE": ["Decay Curve", 0.0, -10.0, 10.0], "PULL_THE_PLUG": ["Pull the Plug", 0, 0, 1, "bool"]}, "num_cv_in": 2}, "meta_modulation": {"inputs": {"timbre_cv": ["timbre cv", "CVPort"], "level2_cv": ["level 2 cv", "CVPort"], "modulator": ["modulator", "AudioPort"], "carrier": ["carrier", "AudioPort"], "level1_cv": ["level 1 freq cv", "CVPort"], "algorthm_cv": ["algorthm cv", "CVPort"]}, "description": "A powerful cross modulation module which applies an algorithm to the two inputs. Based on Warps by Mutable Instruments.", "video_url": "https://www.youtube.com/watch?v=1ED7ipo2wTM&t=2370s", "tags": ["ported", "pitch + synth"], "outputs": {"aux": ["aux", "AudioPort"], "out": ["out", "AudioPort"]}, "long_description": "", "num_cv_in": 4, "category": 3, "kill_dry": true, "controls": {"algorithm": ["algorithm", 0.0, 0.0, 8.0], "timbre": ["timbre", 0.5, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "shape": ["shape", 0.0, 0.0, 3.0], "level1": ["level 1 or freq", 1.0, 0.0, 1.0], "level2": ["level 2", 1.0, 0.0, 1.0]}, "manual_url": "https://www.mutable-instruments.net/modules/warps/manual/"}, "midi_map_key_channel": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "12-tone channel map", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "12-tone channel map. Allow to change midi-channel per note. (Events other than note-on/off will be passed through as-is;currently there is no channel panic forwarding, nor note-off events when changing the channel-assignments dynamically)", "controls": {"k11": ["B", 1, 0, 16, "int"], "k10": ["A#", 1, 0, 16, "int"], "k3": ["D#", 1, 0, 16, "int"], "k2": ["D", 1, 0, 16, "int"], "k1": ["C#", 1, 0, 16, "int"], "k0": ["C", 1, 0, 16, "int"], "k7": ["G", 1, 0, 16, "int"], "k6": ["F#", 1, 0, 16, "int"], "k5": ["F", 1, 0, 16, "int"], "k4": ["E", 1, 0, 16, "int"], "k9": ["A", 1, 0, 16, "int"], "k8": ["G#", 1, 0, 16, "int"]}, "num_cv_in": 0}, "midi_quantize": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"], "bpm": ["bpm", "ControlPort"]}, "description": "live midi event quantization", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Live event quantization. This filter aligns incoming MIDI events to a fixed time-grid. Since the effect operates on a live-stream it will introduce latency: Events will be delayed until the next \"tick\". If you provide tempo, the events are aligned to the clock otherwise the effect runs on its own time.", "controls": {"quant": ["Quantization Grid", 0.25, 0.00390625, 4.0, "int"], "mindur": ["Note-off behaviour", 1, 0, 1, "int"], "bpm": ["BPM", 120.0, 1.0, 280.0, "int"]}, "num_cv_in": 0}, "midi_no_active_sensing": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "strip MIDI Active-Sensing events", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Filter to block all active sensing events. Active sensing messages are optional MIDI messages and intended to be sent repeatedly to tell a receiver that a connection is alive, however they can clutter up the MIDI channel or be inadvertently recorded when dumping raw MIDI data to disk.", "controls": {}, "num_cv_in": 0}, "chorus_j": {"category": 0, "inputs": {"chorus_2_enable": ["2 Enable", "CVPort"], "lv2_audio_in_1": ["Audio Input 1", "AudioPort"], "lv2_audio_in_2": ["Audio Input 2", "AudioPort"], "chorus_1_enable": ["1 Enable", "CVPort"]}, "description": "chorus based on vintage Japanese synth chorus", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=1520s", "tags": ["mod effects"], "outputs": {"lv2_audio_out_1": ["Audio Output 1", "AudioPort"], "lv2_audio_out_2": ["Audio Output 2", "AudioPort"]}, "long_description": "", "controls": {"chorus_1_lfo_rate": ["Chorus 1 LFO Rate", 5.0, 0.1, 10.0], "chorus_2_lfo_rate": ["Chorus 2 LFO Rate", 8.3, 0.1, 10.0], "chorus_2_enable": ["Chorus 2 On/Off", 0.0, 0.0, 1.0, "bool"], "chorus_1_enable": ["Chorus 1 On/Off", 1.0, 0.0, 1.0, "bool"]}, "num_cv_in": 2}, "ad_envelope": {"category": 2, "inputs": {"trigger": ["Trigger", "CVPort"], "port0": ["Gate", "CVPort"]}, "description": "A attack decay envelope generator. Works with a trigger.", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=94s", "tags": ["cv generators"], "outputs": {"out": ["Envelope Out", "CVPort"]}, "long_description": "Envelopes take in a trigger and produce a CV that changes over time.\n                  This version has just 2 stages, attack and decay. Connect triggers to the envelope and then connect the envelope output to the parameter you want to change over time.\n                  This version attacks to 1 from 0.", "controls": {"attack": ["Attack Time", 0.5, 0, 5], "decay": ["Decay Time", 0.5, 0, 5]}, "num_cv_in": 2}, "thruzero_flange": {"category": 0, "inputs": {"left_in": ["Left In", "AudioPort"], "feedback": ["Feedback", "CVPort"], "right_in": ["Right In", "AudioPort"], "rate": ["Rate", "CVPort"], "mix": ["Mix", "CVPort"], "depth": ["Depth", "CVPort"], "depth_mod": ["Depth Mod", "CVPort"]}, "description": "Through Zero Flanger.", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=520s", "tags": ["mod effects"], "outputs": {"left_out": ["Left Out", "AudioPort"], "right_out": ["Right Out", "AudioPort"]}, "long_description": "", "controls": {"mix": ["Mix", 0.47, 0.0, 1.0], "depth": ["Depth", 0.43, 0.0, 1.0], "feedback": ["Feedback", 0.3, 0.0, 1.0], "rate": ["Rate", 0.3, 0.0, 1.0], "depth_mod": ["Depth Mod", 1.0, 0.0, 1.0]}, "num_cv_in": 5}, "chorus_d": {"category": 0, "inputs": {"BPM_1": ["BPM", "ControlPort"], "in0": ["in", "AudioPort"]}, "description": "8 voice multi dimensional chorus", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=1316s", "tags": ["mod effects"], "outputs": {"out0": ["out L", "AudioPort"], "out1": ["out R", "AudioPort"]}, "broadcast_ports": {"BPM_1": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"BPM_1": ["BPM", 30, 10.01, 420], "Deviation_4": ["Deviation", 0.5, 0, 1], "Depth_3": ["Depth", 0.5, 0, 1], "Delay_0": ["Delay", 0.5, 0, 1]}, "num_cv_in": 0}, "stereo_compress": {"category": 0, "inputs": {"inL": ["In Left", "AudioPort"], "inR": ["In Right", "AudioPort"]}, "description": "RMS downward compressor with auto markup", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1462s", "tags": ["level + dynamics"], "outputs": {"outR": ["Out Right", "AudioPort"], "outL": ["Out Left", "AudioPort"]}, "long_description": "", "controls": {"enable": ["Enable", 1, 0, 1, "hide"], "inputgain": ["Input Gain", 0.0, -10.0, 30.0], "threshold": ["Threshold", -30.0, -50.0, -10.0], "attack": ["Attack Time", 0.01, 0.001, 0.1], "release": ["Release Time", 0.3, 0.03, 3.0], "Ratio": ["Ratio", 0.0, 0.0, 1.0], "hold": ["Hold", 0, 0, 1, "bool"]}, "num_cv_in": 0}, "basic_reverb": {"category": 0, "inputs": {"lv2_audio_in_1": ["L Input", "AudioPort"], "lv2_audio_in_2": ["R Input", "AudioPort"]}, "description": "A basic true stereo algorthmic reverb.", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=1285s", "tags": ["time effects"], "outputs": {"lv2_audio_out_1": ["L Output", "AudioPort"], "lv2_audio_out_2": ["R Output", "AudioPort"]}, "long_description": "", "controls": {"size": ["Size", 75, 5, 100], "mix": ["Mix", 50, 0, 100], "bandwidth": ["Bandwidth", 50, 0, 100], "damping": ["Damping", 50, 0, 100], "decay": ["Decay", 50, 0, 100], "density": ["Density", 50, 0, 100], "predelay": ["Predelay", 50, 0, 100], "earlymix": ["Early vs Late", 50, 0, 100], "gain": ["Gain", 100, 0, 100]}, "num_cv_in": 0}, "quad_ir_cab": {"category": 0, "inputs": {"gain": ["Gain", "CVPort"], "in_2": ["InR", "AudioPort"], "in_1": ["InL", "AudioPort"]}, "description": "Requires quad channel IR. You do not want this unless you have special IRs", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=0s", "tags": ["amps, cabs + gain"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "long_description": "", "controls": {"ir": ["/audio/cabs/1x12cab.wav", 0, 0, 1], "gain": ["Gain", 0.0, -40.0, 24.0]}, "num_cv_in": 1}, "midi_mono_legato": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "hold a note until the next note arrives", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Play the same note again to switch it off.", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"]}, "num_cv_in": 0}, "sample_hold": {"category": 2, "inputs": {"input": ["Input", "CVPort"], "trigger": ["Gate", "CVPort"]}, "description": "sample and hold a CV value when a gate goes high", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=158s", "tags": ["cv generators"], "outputs": {"gate": ["Gate", "CVPort"], "output": ["Output", "CVPort"]}, "long_description": "", "controls": {"triggerlevel": ["Trigger Level", 0.5, 0, 10]}, "num_cv_in": 2}, "midi_sostenuto": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "delay note-off messages, emulate a piano sostenuto pedal", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "This filter delays note-off messages by a given time, emulating a piano sostenuto pedal. When the pedal is released, note-off messages that are queued will be sent immediately. The delay-time can be changed dynamically, changes do affects note-off messages that are still queued.Sostenuto [sec]: Time to delay the note-off signal.Pedal Mode: Mode of the sustain pedal. Fixed on (pedal pressed) or off (pedal released) for notes of all MIDI channels. The on/off state can alternatively be set by CC, in which case it is per MIDI-channel.", "controls": {"pedal": ["Pedal Mode", 1, 0, 2, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "sostenuto": ["Sostenuto [sec]", 0.0, 0.0, 600.0, "int"]}, "num_cv_in": 0}, "step_sequencer_ext": {"category": 2, "inputs": {"reset": ["Reset Trigger", "CVPort"], "trigger": ["Step Trigger", "CVPort"], "back_trigger": ["Back Trigger", "CVPort"]}, "description": "16 Step sequencer that takes in a trigger for next or previous", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1205s", "tags": ["cv generators"], "outputs": {"out": ["Value Out", "CVPort"]}, "broadcast_ports": {"current_step_out": ["current step out", 0, 0, 16]}, "long_description": "", "controls": {"glide": ["Glide", 0.5, 0.0, 1.0], "val15": ["Value 15", 0.5, 0.0, 1.0], "val14": ["Value 14", 0.5, 0.0, 1.0], "val13": ["Value 13", 0.5, 0.0, 1.0], "val12": ["Value 12", 0.5, 0.0, 1.0], "val11": ["Value 11", 0.5, 0.0, 1.0], "val10": ["Value 10", 0.5, 0.0, 1.0], "val9": ["Value 9", 0.5, 0.0, 1.0], "val8": ["Value 8", 0.5, 0.0, 1.0], "steps": ["Loop Steps", 16, 1, 16], "val3": ["Value 3", 0.5, 0.0, 1.0], "val2": ["Value 2", 0.5, 0.0, 1.0], "val1": ["Value 1", 0.5, 0.0, 1.0], "val0": ["Value 0", 0.5, 0.0, 1.0], "val7": ["Value 7", 0.5, 0.0, 1.0], "val6": ["Value 6", 0.5, 0.0, 1.0], "val5": ["Value 5", 0.5, 0.0, 1.0], "val4": ["Value 4", 0.5, 0.0, 1.0]}, "num_cv_in": 3}, "mono_compressor": {"category": 0, "inputs": {"in": ["In", "AudioPort"]}, "description": "RMS downward compressor with auto markup", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=1082s", "tags": ["level + dynamics"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"enable": ["Enable", 1, 0, 1, "hide"], "inputgain": ["Input Gain", 0.0, -10.0, 30.0], "threshold": ["Threshold", -30.0, -50.0, -10.0], "attack": ["Attack Time", 0.01, 0.001, 0.1], "release": ["Release Time", 0.3, 0.03, 3.0], "Ratio": ["Ratio", 0.0, 0.0, 1.0], "hold": ["Hold", 0, 0, 1, "bool"]}, "num_cv_in": 0}, "tempo_ratio": {"category": 2, "inputs": {"input_tempo": ["Input Tempo", "ControlPort"]}, "description": "ratio between a tempo, like 3/4 to input tempo", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=280s", "tags": ["utilities"], "outputs": {"out_tempo": ["Output Tempo", "ControlPort"]}, "long_description": "", "controls": {"a": ["a", 1, 1, 16, "int"], "b": ["b", 1, 1, 16, "int"]}, "num_cv_in": 0}, "note_sequencer_ext": {"category": 2, "inputs": {"reset": ["Reset Trigger", "CVPort"], "trigger": ["Step Trigger", "CVPort"], "back_trigger": ["Back Trigger", "CVPort"]}, "description": "16 Step note sequencer that takes in a trigger for next or previous", "video_url": "https://www.youtube.com/watch?v=n6cvz_eARg8&t=379s", "tags": ["cv generators"], "outputs": {"out": ["Value Out", "CVPort"]}, "broadcast_ports": {"current_step_out": ["current step out", 0, 0, 16]}, "long_description": "", "controls": {"val15": ["Value 15", 6, 0, 12], "val14": ["Value 14", 6, 0, 12], "val13": ["Value 13", 6, 0, 12], "val12": ["Value 12", 6, 0, 12], "val11": ["Value 11", 6, 0, 12], "val10": ["Value 10", 6, 0, 12], "val9": ["Value 9", 6, 0, 12], "val8": ["Value 8", 6, 0, 12], "steps": ["Loop Steps", 16, 1, 16], "octave": ["Octave", 0, -4.0, 4.0], "val3": ["Value 3", 6, 0, 12], "val2": ["Value 2", 6, 0, 12], "val1": ["Value 1", 6, 0, 12], "val0": ["Value 0", 6, 0, 12], "val7": ["Value 7", 6, 0, 12], "val6": ["Value 6", 6, 0, 12], "val5": ["Value 5", 6, 0, 12], "val4": ["Value 4", 6, 0, 12]}, "num_cv_in": 3}, "warmth": {"category": 0, "inputs": {"input": ["Input", "AudioPort"], "blend": ["Tape--Tube Blend", "CVPort"], "drive": ["Drive", "CVPort"]}, "description": "Tube triode emulation", "video_url": "https://www.youtube.com/watch?v=fE8cb2v5kbw&t=2400s", "tags": ["amps, cabs + gain"], "outputs": {"output": ["Output", "AudioPort"]}, "long_description": "", "controls": {"blend": ["Tape--Tube Blend", 10, -10, 10], "drive": ["Drive", 5.0, 0.1, 10]}, "num_cv_in": 2}, "drum_patterns": {"inputs": {"sn_fill_cv": ["sn fill cv", "CVPort"], "tempo": ["BPM", "ControlPort"], "mapx_cv": ["map x cv", "CVPort"], "swing_cv": ["swing cv", "CVPort"], "reset": ["reset", "CVPort"], "clock": ["clock", "CVPort"], "run_input": ["run", "CVPort"], "hh_fill_cv": ["hh fill cv", "CVPort"], "bd_fill_cv": ["bd_fill_cv", "CVPort"], "chaos_cv": ["chaos cv", "CVPort"], "mapy_cv": ["map y cv", "CVPort"]}, "description": "Drum trigger explorer. Based on Grids by Mutable Instruments. Expects a 4 ppq clock if using external clock", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=925s", "tags": ["ported", "cv generators"], "outputs": {"hh_acc_output": ["hihat accent", "CVPort"], "bd_output": ["bass drum trigger", "CVPort"], "hh_output": ["hihat trigger", "CVPort"], "sn_output": ["snare trigger", "CVPort"], "sn_acc_output": ["snare accent", "CVPort"], "bd_acc_output": ["bass drum accent", "CVPort"]}, "broadcast_ports": {"tempo": ["tempo", 120, 1, 320]}, "long_description": "", "num_cv_in": 10, "category": 2, "controls": {"reset_button": ["reset button", 0, 0.0, 1.0, "bool"], "run_button": ["run button", 0.0, 0.0, 1.0, "bool"], "bd_dens": ["bass drum density", 0.5, 0.0, 1.0], "swing": ["swing", 0.0, 0.0, 0.9], "hh_dens": ["hihat density", 0.5, 0.0, 1.0], "sn_dens": ["snare density", 0.5, 0.0, 1.0], "mapx": ["Map x", 0.0, 0.0, 1.0], "mapy": ["map y", 0.5, 0.0, 1.0], "tempo": ["tempo", 120.0, 37.0, 240.0], "chaos": ["chaos", 0.0, 0.0, 1.0]}, "manual_url": "https://mutable-instruments.net/modules/grids/manual/"}, "step_sequencer": {"category": 2, "inputs": {"back_gate": ["Back Gate", "CVPort"], "reset": ["Reset Trigger", "CVPort"], "play": ["Play", "CVPort"], "bpm": ["BPM", "ControlPort"]}, "description": "16 Step sequencer with internal clock", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1081s", "tags": ["cv generators"], "outputs": {"out": ["Value Out", "CVPort"]}, "broadcast_ports": {"current_step_out": ["current step out", 0, 0, 16], "bpm": ["tempo", 120, 1, 320]}, "long_description": "", "controls": {"bpm": ["BPM", 120, 20, 320], "note_length": ["Note Length", 0.125, 0.03125, 1], "val9": ["Value 9", 0.5, 0.0, 1.0], "val8": ["Value 8", 0.5, 0.0, 1.0], "val3": ["Value 3", 0.5, 0.0, 1.0], "val2": ["Value 2", 0.5, 0.0, 1.0], "val1": ["Value 1", 0.5, 0.0, 1.0], "val0": ["Value 0", 0.5, 0.0, 1.0], "val7": ["Value 7", 0.5, 0.0, 1.0], "val6": ["Value 6", 0.5, 0.0, 1.0], "val5": ["Value 5", 0.5, 0.0, 1.0], "val4": ["Value 4", 0.5, 0.0, 1.0], "glide": ["Glide", 0.5, 0.0, 1.0], "play": ["play", 0.0, 0.0, 1.0], "back_gate": ["back", 0.0, 0.0, 1.0], "val15": ["Value 15", 0.5, 0.0, 1.0], "val14": ["Value 14", 0.5, 0.0, 1.0], "val13": ["Value 13", 0.5, 0.0, 1.0], "val12": ["Value 12", 0.5, 0.0, 1.0], "val11": ["Value 11", 0.5, 0.0, 1.0], "val10": ["Value 10", 0.5, 0.0, 1.0], "steps": ["Loop Steps", 16, 1, 16]}, "num_cv_in": 3}, "stereo_phaser": {"category": 0, "inputs": {"lv2_audio_in_1": ["Audio Input 1", "AudioPort"], "lv2_audio_in_2": ["Audio Input 2", "AudioPort"]}, "description": "Basic stereo phaser", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1490s", "tags": ["mod effects"], "outputs": {"lv2_audio_out_1": ["Audio Output 1", "AudioPort"], "lv2_audio_out_2": ["Audio Output 2", "AudioPort"]}, "long_description": "", "controls": {"feedback_depth": ["Feedback depth", 75, 0, 99], "lfo_frequency": ["LFO frequency", 0.2, 0.01, 5.0], "color": ["Color", 1, 0, 1, "bool"], "mix": ["Dry/wet mix", 50, 0, 100], "feedback_hpf_cutoff": ["Feedback bass cut", 500.0, 10.0, 5000.0], "stereo_phase": ["Stereo phase", 0, -180, 180]}, "num_cv_in": 0}, "mix_vca": {"category": 2, "inputs": {"gain2Data": ["2nd Gain", "CVPort"], "in1Data": ["In 1", "AudioPort"], "in2Data": ["In 2", "AudioPort"], "gain1Data": ["Main Gain", "CVPort"]}, "description": "Voltage controlled amplifier. Used to change the level from a control signal.", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=582s", "tags": ["level + dynamics"], "outputs": {"out": ["Out", "AudioPort"]}, "long_description": "", "controls": {"gain2": ["2nd Gain Boost", 0, 0, 1], "gain1": ["Gain Offset", 0, 0, 1], "gain1Data": ["Main Gain", 0.0, -1.0, 1.0], "outputLevel": ["Output Level", 1, 0, 2], "in1": ["In 1 Level", 1, 0, 2], "in2": ["In 2 Level", 1, 0, 2], "gain2Data": ["2nd Gain", 0.0, -1.0, 1.0]}, "num_cv_in": 2}, "midi_dup": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "duplicate MIDI events from one channel to another", "video_url": "", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "MIDI Duplicate Blocker. Filter out overlapping note on/off and duplicate messages.", "controls": {"chs": ["Source Channel", 1, 1, 16, "int"], "chd": ["Duplicate to Channel", 2, 1, 16, "int"]}, "num_cv_in": 0}, "rotary_advanced": {"category": 0, "inputs": {"drum_brake_cv": ["Drum Brake", "CVPort"], "in": ["Input", "AudioPort"], "horn_brake_cv": ["Horn Brake", "CVPort"], "horn_speed_cv": ["Horn Speed", "CVPort"], "drum_speed_cv": ["Drum Speed", "CVPort"]}, "description": "A rotating loudspeaker using physical modelling. Same sound, more controls.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=2588s", "tags": ["mod effects"], "outputs": {"right": ["Right Output", "AudioPort"], "left": ["Left Output", "AudioPort"]}, "long_description": "", "controls": {"hornradius": ["Horn Radius", 19.2, 9.0, 50.0], "hornxoff": ["Horn X-Axis Offset", 0.0, -20.0, 20.0], "enable": ["Enable", 1, 0, 1], "hornleak": ["Horn Signal Leakage", -16.47, -80.0, -3.0], "micangle": ["Microphone Angle", 180.0, 0.0, 180.0], "drumrpmslow": ["Drum Speed Slow", 36.0, 5.0, 100.0], "filtaq": ["Q", 2.7456, 0.01, 6.0], "drumradius": ["Drum Radius", 22.0, 9.0, 50.0], "rt_speed": ["Motors Ac/Dc", 4, 0, 8], "hornaccel": ["Horn Acceleration", 0.161, 0.001, 10.0], "drumrpmfast": ["Drum Speed Fast", 357.3, 60.0, 600.0], "filtbgain": ["Gain", -30.0, -48.0, 48.0], "hornlvl": ["Horn Level", 0.0, -20.0, 20.0], "filtatype": ["Horn Filter-1 Type", 0, 0, 8], "filtafreq": ["Frequency", 4500.0, 250.0, 8000.0], "filtdtype": ["Drum Filter Type", 8, 0, 8], "drumlvl": ["Drum Level", 0.0, -20.0, 20.0], "drumaccel": ["Drum Acceleration", 4.127, 0.01, 20.0], "drumdecel": ["Drum Deceleration", 1.371, 0.01, 20.0], "hornrpmfast": ["Horn Speed Fast", 423.36, 100.0, 1000.0], "filtdgain": ["Gain", -38.9291, -48.0, 48.0], "filtbfreq": ["Frequency", 300.0, 250.0, 8000.0], "filtdq": ["Q", 1.6016, 0.01, 6.0], "filtbtype": ["Horn Filter-2 Type", 7, 0, 8], "hornwidth": ["Horn Stereo Width", 1.0, 0.0, 2.0], "drumwidth": ["Drum Stereo Width", 1.0, 0.0, 2.0], "filtagain": ["Gain", -30.0, -48.0, 48.0], "hornzoff": ["Horn Z-Axis Offset", 0.0, -20.0, 20.0], "horndecel": ["Horn Deceleration", 0.321, 0.001, 10.0], "micdist": ["Microphone Distance", 42.0, 9.0, 150.0], "filtbq": ["Q", 1.0, 0.01, 6.0], "drumbrake": ["Drum Brake Position", 0.0, 0.0, 1.0], "link": ["Link Speed Control", 0, -1, 1], "filtdfreq": ["Frequency", 811.9695, 50.0, 8000.0], "hornrpmslow": ["Horn Speed Slow", 40.32, 5.0, 200.0], "hornbrakepos": ["Horn Brake Position", 0.0, 0.0, 1.0]}, "num_cv_in": 4}, "pitch_detect": {"category": 2, "inputs": {"in": ["In", "AudioPort"]}, "description": "BETA detects played notes and converts it volt per octave and MIDI", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=820s", "tags": ["pitch + synth"], "outputs": {"gate": ["Gate", "CVPort"], "midi_out": ["Midi Out", "AtomPort"], "voct": ["V/Oct Pitch", "CVPort"]}, "long_description": "", "controls": {"silence_threshold": ["Silence Threshold", -90.0, -90.0, -10.0], "pitch_threshold": ["Pitch Detection Tolerance", 0.3, 0.1, 0.7], "onset_threshold": ["Onset Threshold", 0.3, 0.1, 1.0]}, "num_cv_in": 0}, "pitch_cal_in": {"category": 0, "inputs": {"input": ["input", "CVPort"]}, "description": "Pitch Calibration for a v per oct input", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=546s", "tags": ["pitch + synth"], "outputs": {"output": ["output", "CVPort"]}, "broadcast_ports": {"max_level": ["Max Level", 0, -2.0, 2.0], "min_level": ["Min Level", 0, -2.0, 2.0]}, "long_description": "", "controls": {"offset": ["offset", 0, -1, 1], "scale": ["scale", 1, 0, 2], "measure": ["measure", 0, 0, 1]}, "num_cv_in": 1}, "midi_keyrange": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "discard notes-on/off events outside a given range", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "This filter allows to define a range of allowed midi notes. Notes-on/off events outside the allowed range are discarded. If the range changes, note-off events are sent to currently active notes that end up outside the valid range.", "controls": {"upper": ["Highest Note", 127, 0, 127, "int"], "lower": ["Lowest Note", 0, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "mode": ["Operation Mode", 1, 0, 2, "int"]}, "num_cv_in": 0}, "k_org_lpf": {"category": 3, "inputs": {"cutoff_cv": ["Cutoff CV", "CVPort"], "q_cv": ["Q CV", "CVPort"], "in": ["in", "AudioPort"]}, "description": "A low pass filter similar to the vintage Japanese designs", "video_url": "https://www.youtube.com/watch?v=6hHgWDboqIU&t=570s", "tags": ["pitch + synth"], "outputs": {"out": ["out", "AudioPort"]}, "long_description": "", "controls": {"Q": ["Q", 1, 0.5, 10], "cutoff": ["cutoff", 0.5, 0, 1]}, "num_cv_in": 2}, "loop_midi_out": {"category": 1, "inputs": {}, "description": "Ouput MIDI Clock from looper.", "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=1915s", "tags": ["midi"], "outputs": {"output": ["in", "AtomPort"]}, "long_description": "You can connect this to external gear to sync to a loop or drive internal or CV gear by connecting to the MIDI clock input module.", "controls": {}, "num_cv_in": 0}, "loop_common_out": {"category": 1, "inputs": {}, "description": "Common output from the loopler", "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=480s", "tags": ["time effects"], "outputs": {"output": ["in", "AudioPort"]}, "long_description": "", "controls": {}, "num_cv_in": 0}, "euclidean": {"category": 2, "inputs": {"reset": ["Reset Trigger", "CVPort"], "trigger": ["Step Trigger", "CVPort"], "back_trigger": ["Back Trigger", "CVPort"]}, "description": "A euclidean sequencer with 4 tracks. Connect a trigger to go to the next step", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=2376s", "tags": ["cv generators"], "outputs": {"out1": ["Trigger Out1", "CVPort"], "out2": ["Trigger Out2", "CVPort"], "out3": ["Trigger Out3", "CVPort"], "out4": ["Trigger Out4", "CVPort"], "is_the_one1": ["Is The One 1", "CVPort"], "is_the_one2": ["Is The One 2", "CVPort"], "is_the_one3": ["Is The One 3", "CVPort"], "is_the_one4": ["Is The One 4", "CVPort"]}, "broadcast_ports": {"current_step_out_4": ["current step out 4", 0, 0, 32], "current_step_out_2": ["current step out 2", 0, 0, 32], "current_step_out_3": ["current step out 3", 0, 0, 32], "current_step_out_1": ["current step out 1", 0, 0, 32]}, "long_description": "The is the one outputs are triggered on the first beat and can be used to chain sequencers.", "controls": {"is_enabled4": ["Loop 4 is_enabled", 1, 0, 1], "is_enabled1": ["Loop 1 is_enabled", 1, 0, 1], "steps3": ["Loop 3 Steps", 4, 0, 32], "is_enabled3": ["Loop 3 is_enabled", 1, 0, 1], "is_enabled2": ["Loop 2 is_enabled", 1, 0, 1], "steps4": ["Loop 4 Steps", 4, 0, 32], "steps2": ["Loop 2 Steps", 4, 0, 32], "beats3": ["Loop 3 beats", 4, 0, 32], "beats2": ["Loop 2 beats", 4, 0, 32], "beats1": ["Loop 1 beats", 4, 0, 32], "shift1": ["Loop 1 shift", 0, 0, 32], "shift2": ["Loop 2 shift", 0, 0, 32], "shift4": ["Loop 4 shift", 0, 0, 32], "beats4": ["Loop 4 beats", 4, 0, 32], "steps1": ["Loop 1 Steps", 4, 0, 32], "shift3": ["Loop 3 shift", 0, 0, 32]}, "num_cv_in": 3}, "quantizer": {"category": 2, "inputs": {"input": ["input", "CVPort"]}, "description": "quantize a v/oct signal to a musical scale.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=336s", "tags": ["pitch + synth"], "outputs": {"output": ["Output", "CVPort"], "changed": ["Changed", "CVPort"]}, "long_description": "Feed in an LFO to make it play specific notes instead of smoothly changing between pitches", "controls": {"n12": ["B", 1, 0, 1, "bool"], "n10": ["A", 1, 0, 1, "bool"], "n11": ["A#", 1, 0, 1, "bool"], "n8": ["G", 1, 0, 1, "bool"], "n9": ["G#", 1, 0, 1, "bool"], "n1": ["C", 1, 0, 1, "bool"], "n2": ["C#", 1, 0, 1, "bool"], "n3": ["D", 1, 0, 1, "bool"], "n4": ["D#", 1, 0, 1, "bool"], "n5": ["E", 1, 0, 1, "bool"], "n6": ["F", 1, 0, 1, "bool"], "n7": ["F#", 1, 0, 1, "bool"]}, "num_cv_in": 1}, "doppler_panner": {"inputs": {"y_coord_cv": ["y coordinate cv", "CVPort"], "modulator": ["left in", "AudioPort"], "lfo_frequency_cv": ["lfo frequency cv", "CVPort"], "carrier": ["right in", "AudioPort"], "x_coord_cv": ["x coordinate cv", "CVPort"], "lfo_amplitude_cv": ["lfo_amplitude_cv", "CVPort"]}, "description": "binaural panner, allows positioning in 3D. Based on Parasite firware of Warps by Mutable Instruments.", "video_url": "https://www.youtube.com/watch?v=3X0R0w9ytus&t=740s", "tags": ["ported", "mod effects"], "outputs": {"aux": ["right out", "AudioPort"], "out": ["left out", "AudioPort"]}, "long_description": "", "num_cv_in": 4, "category": 0, "kill_dry": true, "controls": {"lfo_frequency": ["lfo_frequency", 0.11, 0.0, 1.0], "space_size": ["space_size", 2.0, 0.0, 3.0], "y_coord": ["y coordinate", 0.04, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "x_coord": ["x coordinate", 4.45, 0.0, 8.0], "lfo_amplitude": ["lfo_amplitude", 0.22, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/warps.html"}, "midi_channel_map": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "map any MIDI-channel to another MIDI-channel", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1278s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "", "controls": {"chn12": ["Channel 12 to", 12, 0, 16, "int"], "chn11": ["Channel 11 to", 11, 0, 16, "int"], "chn10": ["Channel 10 to", 10, 0, 16, "int"], "chn3": ["Channel  3 to", 3, 0, 16, "int"], "chn2": ["Channel  2 to", 2, 0, 16, "int"], "chn1": ["Channel  1 to", 1, 0, 16, "int"], "chn7": ["Channel  7 to", 7, 0, 16, "int"], "chn6": ["Channel  6 to", 6, 0, 16, "int"], "chn5": ["Channel  5 to", 5, 0, 16, "int"], "chn4": ["Channel  4 to", 4, 0, 16, "int"], "chn9": ["Channel  9 to", 9, 0, 16, "int"], "chn8": ["Channel  8 to", 8, 0, 16, "int"]}, "num_cv_in": 0}, "pitch_cal_out": {"category": 0, "inputs": {"input": ["input", "CVPort"]}, "description": "Pitch Calibration for a v per oct output", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=757s", "tags": ["pitch + synth"], "outputs": {"output": ["output", "CVPort"]}, "long_description": "", "controls": {"scale": ["scale", 1, 0, 2], "offset": ["offset", 0, -5, 5]}, "num_cv_in": 1}, "midi_clock_out": {"category": 1, "inputs": {"bpm": ["BPM", "ControlPort"]}, "description": "BPM to MIDI Clock", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1820s", "tags": ["midi"], "outputs": {"mclk": ["Midi Out", "AtomPort"]}, "long_description": "", "controls": {"bpm": ["BPM", 120.0, 40.0, 208.0]}, "num_cv_in": 0}, "saturator": {"category": 0, "inputs": {"Input": ["Input", "AudioPort"], "Pregain": ["Pregain", "CVPort"], "Postgain": ["Postgain", "CVPort"]}, "description": "Nonlinear saturation and soft limiting.", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=392s", "tags": ["amps, cabs + gain"], "outputs": {"Output": ["Output", "AudioPort"]}, "long_description": "", "controls": {"Pregain": ["Pregain", 0, -90, 20], "Postgain": ["Postgain", 0, -90, 20]}, "num_cv_in": 2}, "adsr": {"category": 2, "inputs": {"drive": ["Gate", "CVPort"]}, "description": "Basic ADSR envelope generator. Takes in a gate.", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=294s", "tags": ["cv generators"], "outputs": {"out": ["Envelope Out", "CVPort"]}, "long_description": "Envelopes take in a gate and produce a CV that changes over time.\n                  This version has 4 stages, attack, decay, sustain and release. Connect gates to the envelope and then connect the envelope output to the parameter you want to change over time.\n                  This is an important part of a synthesiser but can also be used to create things like autoswells. Useful when connected to a VCA.", "controls": {"release": ["Release Time", 0.5, 0, 5.0], "thresh": ["Trigger Threshold", 0.4, 0.06, 1.0], "attack": ["Attack Time", 0.5, 0, 5.0], "sustain": ["Sustain Level", 1, 0, 1], "decay": ["Decay Time", 0.5, 0, 5.0]}, "num_cv_in": 1}, "harmonic_trem_ext": {"category": 0, "inputs": {"in0": ["in", "AudioPort"], "lfo_in1": ["LFO CV", "CVPort"]}, "description": "harmonic tremolo CV LFO input", "video_url": "https://www.youtube.com/watch?v=6hHgWDboqIU&t=90s", "tags": ["mod effects"], "outputs": {"out0": ["out", "AudioPort"]}, "long_description": "", "controls": {"depth_1": ["depth", 0.1, 0, 1], "CrossoverFreq_0": ["CrossoverFreq", 800, 20, 10000]}, "num_cv_in": 1}, "midi_tonal_pedal": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "Holds any notes that are currently played when the sustain pedal is pressed for as long as the pedal remains pressed.", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Releasing the pedal sends Note-Off events. New notes played after presseing the pedal are not affected.", "controls": {"pedal": ["Pedal CC", 0, 0, 1, "bool"], "forward_cc": ["Forward CC", 0, 0, 1, "bool"]}, "num_cv_in": 0}, "midi_keysplit": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "change midi-channel number depending on note (and optionally transpose)", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Change midi-channel number depending on note. The module keeps track of transposed midi-notes in case and sends note-off events accordingly if the range is changed even if a note is active. However the split-point and channel-assignments for each manual should only be changed when no notes are currently played.", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"], "transp1": ["Transpose Upper", 0, -48, 48, "int"], "transp0": ["Transpose Lower", 0, -48, 48, "int"], "channel1": ["Channel Upper", 2, 1, 16, "int"], "channel0": ["Channel Lower", 1, 1, 16, "int"], "split": ["Splitpoint", 48, 0, 127, "int"]}, "num_cv_in": 0}, "time_stretch": {"inputs": {"l_in": ["L in", "AudioPort"], "trig": ["Trigger", "CVPort"], "freeze": ["Freeze", "CVPort"], "pitch": ["Pitch", "CVPort"], "size": ["Size", "CVPort"], "reverse": ["Reverse", "CVPort"], "Feedback": ["feedback", "CVPort"], "r_in": ["R in", "AudioPort"], "density": ["Diffusion", "CVPort"], "texture": ["Filter", "CVPort"], "spread": ["Spread", "CVPort"], "position": ["Position", "CVPort"], "reverb": ["Reverb", "CVPort"], "blend": ["Blend", "CVPort"]}, "description": "A granular time stretching and pitch shifting module. Based on Parasite firmware of Clouds by Mutable Instruments.", "video_url": "https://www.youtube.com/watch?v=ECGLqKu9ptI&t=690s", "tags": ["ported", "time effects"], "outputs": {"r_out": ["R Out", "AudioPort"], "l_out": ["L Out", "AudioPort"]}, "long_description": "", "num_cv_in": 12, "category": 3, "kill_dry": true, "controls": {"pitch_param": ["pitch", 0.0, -24.0, 24.0, "int"], "blend_param": ["blend", 0.5, 0.0, 1.0], "reverb_param": ["reverb", 0.15, 0.0, 1.0], "position_param": ["position", 0.5, 0.0, 1.0], "freeze_param": ["freeze", 0.0, 0.0, 1.0], "feedback_param": ["feedback", 0.48, 0.0, 1.0], "texture_param": ["Filter", 0.48, 0.0, 1.0], "density_param": ["Diffusion", 0.18, 0.0, 1.0], "spread_param": ["spread", 0.79, 0.0, 1.0], "enabled": ["Enabled", 1, 0, 1], "size_param": ["size", 0.66, 0.0, 1.0], "reverse_param": ["reverse", 0.0, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/clouds.html"}, "bitcrusher": {"category": 0, "inputs": {"num_bit_cv": ["bits_cv", "CVPort"], "in": ["in", "AudioPort"]}, "description": "basic bit reduction bit crusher, CV control of bits.", "video_url": "", "tags": ["amps, cabs + gain"], "outputs": {"out": ["out", "AudioPort"]}, "long_description": "", "controls": {"bits": ["bits", 8, 1, 16]}, "num_cv_in": 1}, "min": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "min of a, b also logical and", "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=525s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "midi_note_to_cv": {"category": 1, "inputs": {"in": ["MIDI Input", "AtomPort"]}, "description": "convert MIDI notes to v per octave pitch CVs", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"Gate": ["Gate", "CVPort"], "Velocity": ["Velocity", "CVPort"], "Pitch": ["Pitch", "CVPort"]}, "long_description": "", "controls": {"Semitone": ["Semitone", 0, -12, 12, "int"], "Retrigger": ["Retrigger", 0.0, 0.0, 1.0, "bool"], "Cent": ["Cent", 0, -100, 100, "int"], "Octave": ["Octave", 0, -3, 3, "int"], "Panic": ["Panic", 0, 0, 1, "bool"], "channel": ["Channel", 1, 1, 16, "int"]}, "num_cv_in": 0}, "multi_resonator": {"category": 3, "inputs": {"brightness_mod_input": ["Brightness Mod", "CVPort"], "damping_mod_input": ["Damping Mod", "CVPort"], "in_input": ["In", "AudioPort"], "structure_mod_input": ["Structure Mod", "CVPort"], "strum_input": ["Strum", "CVPort"], "pitch_input": ["Pitch", "CVPort"], "frequency_mod_input": ["Frequency Mod", "CVPort"], "position_mod_input": ["Position Mod", "CVPort"]}, "description": "Resonator building block simulating multiple vibrating structures. Based on Rings by Mutable Instruments.", "manual_url": "https://www.mutable-instruments.net/modules/rings/manual/", "tags": ["ported", "pitch + synth"], "outputs": {"even_output": ["Even", "AudioPort"], "odd_output": ["Odd", "AudioPort"]}, "kill_dry": true, "video_url": "https://www.youtube.com/watch?v=KU8xxLjNQMI&t=2570s", "controls": {"brightness_mod_param": ["Brightness Mod", 0, -1.0, 1.0], "position_param": ["Position", 0.5, 0.0, 1.0], "frequency_mod_param": ["Frequency Mod", 0, -1.0, 1.0], "damping_mod_param": ["Damping Mod", 0, -1.0, 1.0], "internal_exciter_param": ["Internal Exicter", 1.0, 0.0, 1.0, "bool"], "frequency_param": ["Frequency", 30, 0.0, 60.0], "resonator_param": ["Resonator", 0, 0.0, 6.0], "damping_param": ["Damping", 0.5, 0.0, 1.0], "polyphony_param": ["Polyphony", 0, 0.0, 2.0], "enabled": ["Enabled", 1, 0, 1], "brightness_param": ["Brightness", 0.5, 0.0, 1.0], "position_mod_param": ["Position Mod", 0, -1.0, 1.0], "structure_param": ["Structure", 0.5, 0.0, 1.0], "structure_mod_param": ["Structure Mod", 0, -1.0, 1.0]}, "num_cv_in": 7}, "cv_to_trigger": {"category": 0, "inputs": {"trigger": ["Trigger", "CVPort"]}, "description": "A Schmitt trigger that converts external analog CV to digital on / off trigger", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=2620s", "tags": ["utilities"], "outputs": {"out": ["Out Trigger", "CVPort"]}, "long_description": "", "controls": {}, "num_cv_in": 1}, "delay": {"inputs": {"Amp_5": ["Level", "CVPort"], "Feedback_4": ["Feedback", "CVPort"], "Delay_1": ["Time", "CVPort"], "DelayT60_3": ["Glide", "CVPort"], "BPM_0": ["BPM", "ControlPort"], "Warp_2": ["Warp", "CVPort"], "in0": ["in", "AudioPort"], "FeedbackSm_6": ["Tone", "CVPort"]}, "description": "Flexible delay module. Add modules on the repeats for variations.", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=3120s", "tags": ["time effects"], "outputs": {"out0": ["out", "AudioPort"]}, "broadcast_ports": {"BPM_0": ["tempo", 120, 1, 320]}, "long_description": "", "num_cv_in": 6, "category": 0, "kill_dry": true, "controls": {"Amp_5": ["Level", 0.5, 0, 1], "Feedback_4": ["Feedback", 0.3, 0, 1], "Delay_1": ["Time", 0.5, 0.001, 64], "DelayT60_3": ["Glide", 0.5, 0, 100], "BPM_0": ["BPM", 120, 30, 300], "Warp_2": ["Warp", 0, -1, 1], "enabled": ["Enabled", 1, 0, 1], "FeedbackSm_6": ["Tone", 0, 0, 1], "is_using_tempo": ["is_using_tempo", 0, 0, 1]}}, "bitmangle": {"inputs": {"xor_vs_and_cv": ["xor vs and cv", "CVPort"], "modulator": ["modulator", "AudioPort"], "bit_cv": ["bit cv", "CVPort"], "carrier": ["carrier", "AudioPort"], "input_amp_cv": ["input_amp_cv", "CVPort"], "input_amp_2_cv": ["input_amp_2_cv", "CVPort"]}, "description": "Brutal bitmangler. Warning, can get very loud. Based on Mutable Instuments Warps Parasite.", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=1626s", "tags": ["ported", "amps, cabs + gain"], "outputs": {"aux": ["aux", "AudioPort"], "out": ["out", "AudioPort"]}, "long_description": "The bit mangler isn't a normal bit crusher, instead it degredation and cross modulationthe bitwise AND is much louder than the bitwise XOR end, so I recommend a compressor or something aftwards to control levels.", "num_cv_in": 4, "category": 0, "kill_dry": true, "controls": {"int_osc": ["int_osc", 0.0, 0.0, 3.0], "enabled": ["Enabled", 1, 0, 1], "xor_vs_and": ["xor vs and", 0.5, 0.0, 1.0], "input_amp_2": ["input amplitude 2", 0.15, 0.0, 1.0], "bits": ["bits", 0.0, 0.0, 3.0], "input_amp": ["amp or freq", 0.04, 0.0, 1.0]}, "manual_url": "https://mqtthiqs.github.io/parasites/warps.html"}, "midi_clock_in": {"category": 1, "inputs": {"control": ["MIDI Input", "AtomPort"]}, "description": "MIDI Clock to BPM", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1515s", "tags": ["midi"], "outputs": {"start_trigger": ["Start Trigger", "CVPort"], "pulse_out": ["Clock Pulse", "CVPort"], "bpm": ["BPM", "ControlPort"], "is_running": ["Is Running", "CVPort"]}, "long_description": "", "controls": {"bandwidth": ["Bandwidth Smoothing", 6.0, 1, 16], "divider": ["pulse divider", 1.0, 1, 24]}, "num_cv_in": 0}, "midi_mapcc": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "change one control message into another", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Combine with scalecc to modify/scale the actual value.", "controls": {"ccout": ["CC Output", 0, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "ccin": ["CC Input", 0, 0, 127, "int"]}, "num_cv_in": 0}, "midi_note_to_cc": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "convert MIDI note-on messages to control change messages", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Convert only MIDI note-on messages to control change messages (ignored in toggle mode).", "controls": {"nooff": ["Ignore Note Off", 1, 0, 1, "bool"], "param": ["CC Parameter", 1, 0, 127, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "key": ["Active Key (midi-note)", 48, 0, 127, "int"], "mode": ["Operation Mode", 0, 0, 3, "int"]}, "num_cv_in": 0}, "cv_meter": {"category": 0, "inputs": {"CvInput": ["CV input", "CVPort"]}, "description": "Simple CV meter that shows instant values with no smoothing", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=2194s", "tags": ["utilities"], "outputs": {"CvOutput": ["CV Output", "CVPort"]}, "broadcast_ports": {"max_level": ["Max Level", 0, -2.0, 2.0], "min_level": ["Min Level", 0, -2.0, 2.0], "level": ["level", 0, -2.0, 2.0]}, "long_description": "", "controls": {"Reset": ["Reset", 0.0, 0.0, 1.0], "PluginEnabled": ["Enabled", 1.0, 0.0, 1.0]}, "num_cv_in": 1}, "pan": {"category": 0, "inputs": {"panCV": ["Pan CV", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Control signal controlled panner", "video_url": "https://www.youtube.com/watch?v=n6cvz_eARg8&t=1926s", "tags": ["level + dynamics"], "outputs": {"out1": ["Out L", "AudioPort"], "out2": ["Out R", "AudioPort"]}, "long_description": "", "controls": {"panOffset": ["Pan Offset", 0, -1, 1]}, "num_cv_in": 1}, "oog_half_lpf": {"category": 3, "inputs": {"cutoff_cv": ["Cutoff CV", "CVPort"], "q_cv": ["Q CV", "CVPort"], "in": ["in", "AudioPort"]}, "description": "A low pass filter inspired by vintage American designs", "video_url": "https://www.youtube.com/watch?v=n6cvz_eARg8&t=1575s", "tags": ["pitch + synth"], "outputs": {"out": ["out", "AudioPort"]}, "long_description": "", "controls": {"Q": ["Q", 1, 0.7072, 25], "cutoff": ["cutoff", 0.5, 0, 1]}, "num_cv_in": 2}, "product": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "a times b for control signals", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2606s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "ad_env_level": {"category": 2, "inputs": {"gate": ["Gate", "CVPort"], "trigger": ["Trigger", "CVPort"], "reset_level": ["Reset Level", "CVPort"]}, "description": "An attack decay envelope generator with start and end levels. Works with a trigger.", "video_url": "https://www.youtube.com/watch?v=ON5TZzc1LJ8&t=94s", "tags": ["cv generators"], "outputs": {"out": ["Envelope Out", "CVPort"]}, "long_description": "Envelopes take in a  trigger and produce a CV that changes over time.\n                  This version has just 2 stages, attack and decay. Connect triggers to the envelope and then connect the envelope output to the parameter you want to change over time.\n                  This version adds a level to attack to and then decay to compared to the standard version.", "controls": {"attack": ["Attack Time", 0.5, 0, 5], "decay": ["Decay Time", 0.5, 0, 5], "init_level": ["Initial Level", 0, 0, 1], "decay_level": ["Decay to Level", 0, 0, 1], "attack_level": ["Attack to Level", 1, 0, 1]}, "num_cv_in": 3}, "midi_enforce_scale": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "force midi notes on given musical scale", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Filter note-on/off events depending on musical scale. If the scale is changed, note-off events are sent for all active out-of-key notes.", "controls": {"scale": ["Scale", 0, 0, 11, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "mode": ["Mode", 0, 0, 2, "int"]}, "num_cv_in": 0}, "amp_nam": {"category": 0, "inputs": {"input": ["Input", "AudioPort"]}, "description": "Amp Model Player, allowing it to load models of AI trained music gear", "video_url": "https://www.youtube.com/watch?v=irBJRf0vHe4&t=60s", "tags": ["amps, cabs + gain"], "outputs": {"output": ["Output", "AudioPort"]}, "long_description": "Using Neural Amp Modeler (NAM) code.", "controls": {"input_level": ["Input Lvl", -25.0, -45.0, 5.0], "output_level": ["Output Lvl", 0.0, -20.0, 20.0], "ir": ["/audio/amp_nam/tone_king_gremlin/tone_king-gremlin-volume_mid-channel_lead.nam", 0, 0, 1]}, "num_cv_in": 0}, "max": {"category": 2, "inputs": {"b_cv": ["B CV", "CVPort"], "a_cv": ["A CV", "CVPort"]}, "description": "max of a, b also logical or", "video_url": "https://www.youtube.com/watch?v=1ED7ipo2wTM&t=2115s", "tags": ["utilities"], "outputs": {"out": ["Output", "CVPort"]}, "long_description": "", "controls": {"a": ["a", 0, 0, 1], "b": ["b", 0, 0, 1]}, "num_cv_in": 2}, "midi_note_toggle": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "toggle notes: play a note to turn it on, play it again to turn it off", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"]}, "num_cv_in": 0}, "midi_note_to_pgm": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "convert MIDI note messages to patch/program change messages", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Mode: Mapping from note to patch-change. This is either chromatic mapping start at the lowest note (C-1), or white-keys (C-major scale) starting at a given C.", "controls": {"minvel": ["Min Velocity", 1, 0, 127, "int"], "off": ["Offset", 0, -64, 64, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "mode": ["Mode", 0, 0, 11, "int"]}, "num_cv_in": 0}, "looping_envelope": {"category": 0, "inputs": {"frequency_input": ["frequency", "CVPort"], "smoothness_input": ["smoothness", "CVPort"], "shift_input": ["shift", "CVPort"], "slope_input": ["slope", "CVPort"], "clock_input": ["clock", "CVPort"], "v_oct_input": ["v per oct", "CVPort"], "shape_input": ["shape", "CVPort"], "trig_input": ["trigger", "CVPort"]}, "description": "A powerful envelope and LFO generator.\nBased on Tides by Mutable Instruments. ", "manual_url": "https://www.mutable-instruments.net/modules/tides/manual/", "tags": ["ported", "cv generators"], "outputs": {"out1": ["out1", "CVPort"], "out2": ["out2", "CVPort"], "out3": ["out3", "CVPort"], "out4": ["out4", "CVPort"], "tempo_out": ["tempo", "ControlPort"]}, "num_cv_in": 8, "long_description": "Based on Tides by Mutable Instruments.", "controls": {"shape_cv_param": ["shape", 0, -1.0, 1.0], "mode_param": ["mode", 0, 0.0, 4.0], "frequency_cv_param": ["frequency", 0, -1.0, 1.0], "slope_param": ["slope", 0.5, 0.0, 1.0], "shift_param": ["shift", 0.5, 0.0, 1.0], "smoothness_cv_param": ["smoothness", 0, -1.0, 1.0], "range_param": ["range", 0, 0.0, 3.0], "frequency_param": ["frequency", 0, -48.0, 48.0], "shift_cv_param": ["shift", 0, -1.0, 1.0], "slope_cv_param": ["slope", 0, -1.0, 1.0], "smoothness_param": ["smoothness", 0.5, 0.0, 1.0], "ramp_param": ["ramp", 0, 0.0, 3.0], "shape_param": ["shape", 0.5, 0.0, 1.0]}, "video_url": "https://www.youtube.com/watch?v=jLku1gL3h8k&t=2087s"}, "clock_divider": {"category": 0, "inputs": {"in": ["trigger input", "CVPort"]}, "description": "outputs a trigger every n triggers", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=1745s", "tags": ["cv generators"], "outputs": {"out": ["trigger out", "CVPort"]}, "long_description": "useful for dividing down a eurorack style clock.", "controls": {"divider": ["Divider", 1, 1, 24, "int"]}, "num_cv_in": 1}, "poly_note_to_cv": {"category": 1, "inputs": {"MIDIIn": ["MIDI Input", "AtomPort"]}, "description": "convert poly MIDI notes to v per octave pitch CVs", "video_url": "https://www.youtube.com/watch?v=rfGIUH1nDeo&t=2338s", "tags": ["midi"], "outputs": {"Gate2": ["Gate 2", "CVPort"], "Gate3": ["Gate 3", "CVPort"], "Pitch2": ["Pitch 2", "CVPort"], "Gate1": ["Gate 1", "CVPort"], "Pitch3": ["Pitch 3", "CVPort"], "Gate4": ["Gate 4", "CVPort"], "Pitch1": ["Pitch 1", "CVPort"], "Pitch4": ["Pitch 4", "CVPort"], "vel": ["Velocity", "CVPort"]}, "long_description": "", "controls": {"Semitone": ["Semitone", 0, -12, 12, "int"], "Panic": ["Panic", 0, 0, 1, "bool"], "Octave": ["Octave", 0, -4, 4, "int"], "Cent": ["Cent", 0, -100, 100, "int"], "channel": ["Channel", 1, 1, 16, "int"]}, "num_cv_in": 0}, "midi_one_channel_filter": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "basic MIDI channel filter", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "This effect repeats notes N times. Where N is either a fixed number or unlimited as long as a given key is pressed. BPM and delay-time variable allows tempo-ramps. On every repeat the given velocity-adjustment is added or subtracted, the result is clamped between 1 and 127.", "controls": {"channel": ["Channel", 1, 1, 16, "int"]}, "num_cv_in": 0}, "stereo_cab": {"category": 0, "inputs": {"gain": ["Output Gain", "CVPort"], "in": ["In", "AudioPort"]}, "description": "Stereo cab sim. You normally do not want this. Requires stereo IRs.", "video_url": "https://www.youtube.com/watch?v=vKwA8wZaq3E&t=1360s", "tags": ["amps, cabs + gain"], "outputs": {"out_1": ["OutL", "AudioPort"], "out_2": ["OutR", "AudioPort"]}, "long_description": "", "controls": {"ir": ["/audio/cabs/1x12cab.wav", 0, 0, 1], "gain": ["Output Gain", 0.0, -40.0, 24.0]}, "num_cv_in": 1}, "rotary": {"category": 0, "inputs": {"drum_brake_cv": ["Drum Brake", "CVPort"], "in": ["Input", "AudioPort"], "horn_brake_cv": ["Horn Brake", "CVPort"], "horn_speed_cv": ["Horn Speed", "CVPort"], "drum_speed_cv": ["Drum Speed", "CVPort"]}, "description": "A rotating loudspeaker using physical modelling. Same sound as advanced.", "video_url": "https://www.youtube.com/watch?v=VEFFyJe0tVQ&t=2588s", "tags": ["mod effects"], "outputs": {"right": ["Right Output", "AudioPort"], "left": ["Left Output", "AudioPort"]}, "long_description": "", "controls": {"hornlvl": ["Horn Level", 0.0, -20.0, 20.0], "rt_speed": ["Motors Ac/Dc", 4, 0, 8], "enable": ["Enable", 1, 0, 1], "drumlvl": ["Drum Level", 0.0, -20.0, 20.0], "drumwidth": ["Drum Stereo Width", 1.0, 0.0, 2.0]}, "num_cv_in": 4}, "midi_ntap_delay": {"category": 0, "inputs": {"delayBPM": ["bpm", "ControlPort"], "midiin": ["MIDI In", "AtomPort"]}, "description": "repeat MIDI notes N times (incl tempo-ramps)", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "broadcast_ports": {"delayBPM": ["BPM", 120, 1, 320]}, "long_description": "", "controls": {"delayBPM": ["BPM", 120.0, 1.0, 280.0, "int"], "delayBeats": ["Repeat-time in beats", 1.0, 0.00390625, 16.0], "taps": ["Repeats", 3, 0, 64, "int"], "channelf": ["Filter Channel", 0, 0, 16, "int"], "velocityadj": ["velocity ramp", -10.0, -64.0, 64.0, "int"]}, "num_cv_in": 0}, "midi_nodup": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "MIDI duplicate blocker.", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "Filter out overlapping note on/off and duplicate messages.", "controls": {"channelf": ["Filter Channel", 0, 0, 16, "int"]}, "num_cv_in": 0}, "midi_event_blocker": {"category": 0, "inputs": {"midiin": ["MIDI In", "AtomPort"]}, "description": "notch style MIDI message filter. Suppress specific messages", "video_url": "https://www.youtube.com/watch?v=6sDNZ19IR-k&t=1155s", "tags": ["midi"], "outputs": {"midiout": ["MIDI Out", "AtomPort"]}, "long_description": "For flexible note-on/off range see also \"keyrange\" and \"velocityrange\"", "controls": {"blkcp": ["Block Channel-Pressure", 0, 0, 1, "bool"], "blkcc": ["Block Control Changes", 0, 0, 1, "bool"], "blkcm": ["Block Custom Message", 0, 0, 1, "bool"], "blknote": ["Block Notes", 0, 0, 1, "bool"], "cmf": ["Custom message Channel", 0, 0, 16, "int"], "blkpb": ["Block Pitch Bend", 0, 0, 1, "bool"], "blkpc": ["Block Program Changes", 0, 0, 1, "bool"], "blkpp": ["Block Polykey-Pressure", 0, 0, 1, "bool"], "blksx": ["Block System Messages", 0, 0, 1, "bool"], "cmt": ["Custom Message Type", 0, 0, 6, "int"], "cm2": ["Custom message Data2", -1, -1, 127, "int"], "cm1": ["Custom message Data1", -1, -1, 127, "int"]}, "num_cv_in": 0}, "dahdsr": {"category": 2, "inputs": {"delay": ["Delay Time", "CVPort"], "attack": ["Attack Time", "CVPort"], "trigger": ["Trigger", "CVPort"], "sustain": ["Sustain Level", "CVPort"], "decay": ["Decay Time", "CVPort"], "release": ["Release Time", "CVPort"], "gate": ["Gate", "CVPort"], "hold": ["Hold Time", "CVPort"]}, "description": "A delay attack hold decay sustain release envelope generator", "video_url": "https://www.youtube.com/watch?v=24a0UzbKCKk&t=3015s", "tags": ["cv generators"], "outputs": {"out": ["Envelope Out", "CVPort"]}, "long_description": "", "controls": {"decay": ["Decay Time", 0.5, 0, 5.0], "delay": ["Delay Time", 0.1, 0, 5.0], "attack": ["Attack Time", 0.5, 0, 5.0], "sustain": ["Sustain Level", 1, 0, 1], "release": ["Release Time", 0.5, 0, 5.0], "hold": ["Hold Time", 0.5, 0, 5.0]}, "num_cv_in": 8}}