/*----------------------------------------------------------------------------*/
// (C) 2022 FCNT LIMITED
/*----------------------------------------------------------------------------*/
// SPDX-License-Identifier: GPL-2.0

//==============================================================================
// include file
//==============================================================================
#include <linux/init.h>
#include <linux/module.h>
#include <linux/err.h>
#include <linux/soc/qcom/smem_custom.h>
#include <linux/custom_mode.h>

//==============================================================================
// define
//==============================================================================

//==============================================================================
// const data
//==============================================================================

//==============================================================================
// global valuable
//==============================================================================
int custom_boot_mode = CUSTOM_MODE_NORMAL;
EXPORT_SYMBOL(custom_boot_mode);
int charging_mode = 0;
EXPORT_SYMBOL(charging_mode);

//==============================================================================
// private valuable
//==============================================================================

//==============================================================================
// static functions prototype
//==============================================================================

//==============================================================================
// functions
//==============================================================================
static void androidboot_mode_get()
{
	char *cmdline = (char *)smem_alloc_vendor0(SMEM_OEM_V0_022);
	char *boot_mode;

	if (cmdline == NULL) {
		pr_err("[Custom mode]smem_alloc_vendor0(SMEM_OEM_V0_022) error: %s\n", __func__);
		return;
	}

	boot_mode = strstr(cmdline, "androidboot.mode=");
	if (boot_mode != NULL) {
		boot_mode += strlen("androidboot.mode=");

		if (strncmp(boot_mode, "charger", strlen("charger")) == 0) {
			charging_mode = 1;
			custom_boot_mode = CUSTOM_MODE_OFF_CHARGE;
		}
	}


	pr_info("custom_boot_mode = %d\n", custom_boot_mode);
	pr_info("chargemode: %d\n", charging_mode);
	return;
}


static int custom_mode_init(void)
{
	androidboot_mode_get();
	return 0;
}
module_init(custom_mode_init);

static void custom_mode_exit(void)
{
	return;
}
module_exit(custom_mode_exit);

MODULE_LICENSE("GPL v2");
