/*
 * (C) 2022 FCNT LIMITED
 */
// SPDX-License-Identifier: GPL-2.0

/*
 * include file
 */
#include <linux/init.h>
#include <linux/module.h>
#include <linux/workqueue.h>
#include <linux/soc/qcom/smem_custom.h>
#include <linux/nonvolatile_common.h>

/*
 * define
 */
#define APNV_MDM_MASTER_CLEAR_I		(41070)
#define FDR_MONITOR_DELAY			(3*HZ)
#define FDR_MONITOR_RETRY_NUM		(10)

/*
 * static variable
 */
static struct delayed_work			modem_fdr_monitor;
static unsigned char				mcflg_modem;
static bool							nvget_flag = false;
static unsigned long				retry_num = 0;
static bool							is_recovery = false;

/*
 * functions
 */
static void set_recovery_flag(char *str)
{
	if (str == NULL)
		return;

	if ((strncmp(str, "recoverymenu", strlen("recoverymenu")) == 0) ||
		(strncmp(str, "fotamode",     strlen("fotamode"))     == 0) ||
		(strncmp(str, "osupdatemode", strlen("osupdatemode")) == 0) ||
		(strncmp(str, "masterclear",  strlen("masterclear"))  == 0)) {
		is_recovery = true;
	}
	pr_info("[FDR monitor]is_recovery=%d\n", is_recovery);
}

#ifdef MODULE
static int custom_get_androidboot_mode(void)
{
	char *cmdline = (char *)smem_alloc_vendor0(SMEM_OEM_V0_022);
	char *boot_mode;

	if (cmdline == NULL) {
		pr_err("[FDR monitor]smem_alloc_vendor0(SMEM_OEM_V0_022) error: %s\n", __func__);
		return -1;
	}

	boot_mode = strstr(cmdline, "androidboot.mode=");
	if (boot_mode != NULL) {
		boot_mode += strlen("androidboot.mode=");
		set_recovery_flag(boot_mode);
	}
	return 0;
}
#else
static int __init custom_get_androidboot_mode(char *str)
{
	set_recovery_flag(str);
	return 0;
}
early_param("androidboot.mode", custom_get_androidboot_mode);
#endif
static void custom_fdrflag_monitor(struct work_struct *work)
{
	uint32_t* flag_p;
	int result, retry = 1;

	do {
		if (work == NULL) {
			break;
		}

		if (!nvget_flag) {
			result = get_nonvolatile((uint8_t*)&mcflg_modem, APNV_MDM_MASTER_CLEAR_I, sizeof(mcflg_modem));
			if (result < 0) {
				pr_info("[FDR monitor] Error get_nonvolatile.\n");
				break;
			}
			nvget_flag = true;
		}
		if (mcflg_modem == 0) {
			retry = 0;
			break;
		}

		flag_p = smem_alloc_vendor0(SMEM_OEM_V0_007);
		if (!flag_p) {
			pr_info("[FDR monitor] Error smem_alloc_vendor0.\n");
			break;
		}

		if (*flag_p == 0) {
			pr_info("[FDR monitor] FDR complete \n");
			mcflg_modem = 0;
			result = set_nonvolatile((uint8_t*)&mcflg_modem, APNV_MDM_MASTER_CLEAR_I, sizeof(mcflg_modem));
			retry = 0;
		} else {
			pr_info("[FDR monitor] FDR non completion %d \n", (unsigned int)*flag_p);
		}
	} while(0);

	if (retry) {
		if (retry_num < FDR_MONITOR_RETRY_NUM) {
			schedule_delayed_work(&modem_fdr_monitor, FDR_MONITOR_DELAY);
			retry_num++;
		}
	}

	return;
}
static int __init custom_fdr_monitor_init(void)
{
#ifdef MODULE
	custom_get_androidboot_mode();
#endif
	INIT_DELAYED_WORK(&modem_fdr_monitor, custom_fdrflag_monitor);

	if (!is_recovery)
		schedule_delayed_work(&modem_fdr_monitor, FDR_MONITOR_DELAY);

	return 0;
}

static void __exit custom_fdr_monitor_exit(void)
{
	cancel_delayed_work_sync(&modem_fdr_monitor);
}

module_init(custom_fdr_monitor_init);
module_exit(custom_fdr_monitor_exit);

MODULE_LICENSE("GPL v2");

