/*
 * (C) 2022 FCNT LIMITED
*/
/* SPDX-License-Identifier: GPL-2.0 */

#ifndef __CUSTOM_DET_DRIVER_H__
#define __CUSTOM_DET_DRIVER_H__

//==============================================================================
// include file
//==============================================================================
#include <linux/device.h>
#include <linux/power_supply.h>
#include <linux/mfd/custom_det.h>
#include "max77729_charger.h"

//==============================================================================
// feature
//==============================================================================
#define FEATURE_OEM_CHARGE

typedef enum {
	CUSTOM_DET_CHARGE_APSD = 0,
} CUSTOM_DET_CHARGE_TYPE;

//==============================================================================
// define & enum
//==============================================================================
#define CUSTOM_DET_HOT_DETECT 5
#define CUSTOM_DET_HOT_NONE 0

//==============================================================================
// functions
//==============================================================================
void custom_det_charge_req(CUSTOM_DET_CHARGE_TYPE type, bool enable);

void custom_det_otg_en_set(bool);

extern int custom_det_set_charge_control_limit(int set_val);
extern int custom_det_get_charge_control_limit_max(void);
extern int custom_det_get_charge_control_limit(void);

int custom_det_init(struct max77729_charger_data *chg);
void custom_det_shutdown(void);
int custom_det_remove(void);

#endif /* __CUSTOM_DET_DRIVER_H__ */
