// SPDX-License-Identifier: GPL-2.0-only
/*
 * (C) 2022 FCNT LIMITED
 */
#define pr_fmt(fmt) "nopmi_chg_common %s: " fmt, __func__

#include "nopmi_chg_common.h"

int nopmi_chg_is_usb_present(struct power_supply *usb_psy)
{
	union power_supply_propval prop = {0, };
	int ret = 0;
	int usb_present;

	if(!usb_psy)
	{
		usb_psy = power_supply_get_by_name("usb");
		if (!usb_psy) {
			pr_err("usb supply not found, defer probe\n");
			return -EINVAL;
		}
	}

	ret = power_supply_get_property(usb_psy,
				POWER_SUPPLY_PROP_ONLINE, &prop);
	if (ret < 0) {
		pr_err("couldn't read usb_present property, ret=%d\n", ret);
		return -EINVAL;
	}
	usb_present = prop.intval;

	return usb_present;
}

struct quick_charge adapter_cap[10] = {
	{ POWER_SUPPLY_TYPE_USB,        QUICK_CHARGE_NORMAL },
	{ POWER_SUPPLY_TYPE_USB_DCP,    QUICK_CHARGE_NORMAL },
	{ POWER_SUPPLY_TYPE_USB_CDP,    QUICK_CHARGE_NORMAL },
	{ POWER_SUPPLY_TYPE_USB_ACA,    QUICK_CHARGE_NORMAL },
	{ POWER_SUPPLY_TYPE_USB_FLOAT,  QUICK_CHARGE_NORMAL },
	{ POWER_SUPPLY_TYPE_USB_PD,       QUICK_CHARGE_FAST },
	{ POWER_SUPPLY_TYPE_USB_HVDCP,    QUICK_CHARGE_FAST },
	{ POWER_SUPPLY_TYPE_USB_HVDCP_3,  QUICK_CHARGE_FAST },
	{ POWER_SUPPLY_TYPE_WIRELESS,     QUICK_CHARGE_FAST },
	{0, 0},
};

int nopmi_get_quick_charge_type(struct power_supply *usb_psy)
{
	union power_supply_propval prop = {0, };
	int i = 0;
	int ret = 0;
	enum power_supply_type chg_type;

	if(!usb_psy)
	{
		usb_psy = power_supply_get_by_name("usb");
		if (!usb_psy) {
			pr_err("usb supply not found, defer probe\n");
			return -EINVAL;
		}
	}

	ret = power_supply_get_property(usb_psy,
				(enum power_supply_property)POWER_SUPPLY_EXT_PROP_REAL_TYPE, &prop);
	if (ret < 0) {
		pr_err("couldn't read usb real type, ret=%d\n", ret);
		return -EINVAL;
	}

	chg_type = prop.intval;

	while (adapter_cap[i].adap_type != 0) {
		if (chg_type == adapter_cap[i].adap_type) {
			return adapter_cap[i].adap_cap;
		}
		i++;
	}

	return 0;
}
