/* SPDX-License-Identifier: GPL-2.0+ */
/*----------------------------------------------------------------------------*/
// (C) 2022 FCNT LIMITED
/*----------------------------------------------------------------------------*/
#ifndef __OEM_CHARGER_LOCAL_H
#define __OEM_CHARGER_LOCAL_H

/* CHARGER_CONFIG */
//#define CHG_DRV_CONFIG_USE_APNV_VMAX
#undef CHG_DRV_CONFIG_USE_APNV_VMAX

#define CHG_DRV_CONFIG_PD_ENABLE
//#undef CHG_DRV_CONFIG_PD_ENABLE

/* CHARGER_WA */


/* NV items */
#define APNV_CHARGE_FG_FUNC_LIMITS_I		(41053)
#define APNV_CHARGE_FG_RCOMP0_I				(47140)
#define APNV_CHARGE_FG_TEMPCO_I				(47141)
#define APNV_CHARGE_FG_FULLCAP_I			(47142)
#define APNV_CHARGE_FG_CYCLES_I 			(47143)
#define APNV_CHARGE_FG_FULLCAPNOM_I 		(47144)
#define APNV_CHARGE_FG_IAVG_EMPTY_I 		(47145)
#define APNV_CHARGE_FG_QRTABLE00_I			(47146)
#define APNV_CHARGE_FG_QRTABLE10_I			(47147)
#define APNV_CHARGE_FG_QRTABLE20_I			(47148)
#define APNV_CHARGE_FG_QRTABLE30_I			(47149)
#define APNV_CHARGE_FG_AGE_RES_I			(47150)
#define APNV_CHARGE_FG_VF_COUNT_I			(49003)
#define APNV_CHARGE_FG_AGE_I				(49004)
#define APNV_CHARGE_DEMO_I					(49283)
#define APNV_ITEM_LONGEVITYCHARGE			(49395)
#define APNV_CHARGING_DATA					(49291)
#define APNV_CHARGING_SETTING				(49296)
#define APNV_CHARGE_LONGEVITY_CYCLE			(49467)

/* Power Supply name */
#define BMS_PSY_NAME						"bms"
#define USB_PSY_NAME						"usb"
#define BATTERY_PSY_NAME					"battery"
#define BBC_PSY_NAME						"bbc"

#define OEM_CHARGER_PSY_NAME				"oem-chg"
#define OEM_BATTERY_PSY_NAME				"oem-batt"

enum {
	CHG_DRV_SET_LOW = 0,
	CHG_DRV_SET_HIGH,
};

enum {
	OEM_CHG_SOURCE_USB = 0,			/* for USB         */
	OEM_CHG_SOURCE_AC,				/* for AC adaptor  */
	OEM_CHG_SOURCE_APSD,			/* for APSD result */
	OEM_CHG_SOURCE_NUM
};

enum chg_cycle_level {
	CHG_CYCLE_LEVEL_NONE = 0,
	CHG_CYCLE_LEVEL_01,
	CHG_CYCLE_LEVEL_02,
	CHG_CYCLE_LEVEL_NUM,
};

#endif /* __OEM_CHARGER_LOCAL_H */
