/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * (C) 2022 FCNT LIMITED
 */
/*
 * usb_pd_policy_manager.h
 *
 */

#ifndef SRC_PDLIB_USB_PD_POLICY_MANAGER_H_
#define SRC_PDLIB_USB_PD_POLICY_MANAGER_H_
#include <linux/device.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/workqueue.h>
#include <linux/power_supply.h>
#include <linux/usb/typec/maxim/max77729_usbc.h>
#include <linux/pmic-voter.h>
#include <linux/ktime.h>
#include <linux/time.h>
#include "nopmi_chg_common.h"

enum pm_state {
	PD_PM_STATE_PPS_READY,
	PD_PM_STATE_PPS_START,
	PD_PM_STATE_PPS_ENTRY_1,
	PD_PM_STATE_PPS_ENTRY_2,
	PD_PM_STATE_PPS_STOP,
};

struct cp_device {
	bool charge_enabled;

	bool batt_pres;
	bool vbus_pres;

	/* alarm/fault status */
	bool bat_ovp_fault;
	bool bat_ocp_fault;
	bool bus_ovp_fault;
	bool bus_ocp_fault;

	bool bat_ovp_alarm;
	bool bat_ocp_alarm;
	bool bus_ovp_alarm;
	bool bus_ocp_alarm;

	bool bat_ucp_alarm;

	bool bat_therm_alarm;
	bool bus_therm_alarm;
	bool die_therm_alarm;

	bool bat_therm_fault;
	bool bus_therm_fault;
	bool die_therm_fault;

	bool therm_shutdown_flag;
	bool therm_shutdown_stat;

	bool vbat_reg;
	bool ibat_reg;

	int  vout_volt;
	int  vbat_volt;
	int  vbus_volt;
	int  ibat_curr;
	int  ibat_curr_cp;
	int  ibat_curr_sw;
	int  ibus_curr;
	int  ibus_curr_cp;
	int  ibus_curr_sw;

	int vbus_error_low;
	int vbus_error_high;

	int  bat_temp;
	int  bus_temp;
	int  die_temp;
};

#define PM_STATE_LOG_MAX	32
struct usbpd_pm {
	struct tcpc_device *tcpc;
	struct notifier_block tcp_nb;
	struct charger_device *sw_chg;
	bool is_pps_en_unlock;
	int hrst_cnt;
	POWER_LIST* pdo;

	enum pm_state state;

	struct cp_device cp;
	struct cp_device cp_sec;

	bool	cp_sec_stopped;
	bool	pd_active;
	bool	pps_supported;
	bool	charge_enabled;
	int	request_voltage;
	int	request_current;
	int	apdo_max_volt;
	int	apdo_max_curr;
	int	apdo_selected_pdo;

	int	fixed_max_volt;
	int	fixed_max_curr;
	int	fixed_selected_pdo;
	int	prev_fixed_selected_pdo;

	int	adapter_voltage;
	int	adapter_current;
	int	adapter_ptf;
	bool	adapter_omf;

	ktime_t entry_bq_cv_time;
	struct delayed_work pm_work;

	struct notifier_block nb;

	bool   psy_change_running;
	struct work_struct usb_psy_change_work;
	spinlock_t psy_change_lock;

	struct power_supply *sw_psy;
	struct power_supply *usb_psy;
	struct power_supply *bms_psy;

	struct votable		*fcc_votable;

};

struct pdpm_config {
	int	bat_volt_lp_lmt; /*bat volt loop limit*/
	int	bat_curr_lp_lmt;
	int	bus_volt_lp_lmt;
	int	bus_curr_lp_lmt;

	int	fc2_taper_current;
	int	fc2_steps;

	int	min_adapter_volt_required;
	int min_adapter_curr_required;

	int	min_vbat_for_cp;

	bool cp_sec_enable;
	bool fc2_disable_sw;		/* disable switching charger during flash charge*/

};

extern POWER_LIST* usbpd_fetch_pdo(void);
extern void usbpd_select_fixed_pdo_maxim(int num);

int usbpd_pm_init(void);
void usbpd_pm_exit(void);

#endif /* SRC_PDLIB_USB_PD_POLICY_MANAGER_H_ */

