/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020, The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB_H
#define _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB_H

/* USB3-DP Combo PHY register offsets */
/* Module: USB3_DP_PHY_USB3_DP_COM_USB3_DP_COM_USB3_DP_COM */
#define USB3_DP_COM_PHY_MODE_CTRL				0x0000
#define USB3_DP_COM_SW_RESET					0x0004
#define USB3_DP_COM_POWER_DOWN_CTRL				0x0008
#define USB3_DP_COM_SWI_CTRL					0x000C
#define USB3_DP_COM_TYPEC_CTRL					0x0010
#define USB3_DP_COM_TYPEC_PWRDN_CTRL				0x0014
#define USB3_DP_COM_DP_BIST_CFG_0				0x0018
#define USB3_DP_COM_RESET_OVRD_CTRL				0x001C
#define USB3_DP_COM_DBG_CLK_MUX_CTRL				0x0020
#define USB3_DP_COM_TYPEC_STATUS				0x0024
#define USB3_DP_COM_PLACEHOLDER_STATUS				0x0028
#define USB3_DP_COM_REVISION_ID0				0x002C
#define USB3_DP_COM_REVISION_ID1				0x0030
#define USB3_DP_COM_REVISION_ID2				0x0034
#define USB3_DP_COM_REVISION_ID3				0x0038

/* Module: USB3_DP_PHY_USB3_DP_DBGINT_USB3_DP_DBGINT_USB3_PCS_DEBUG_INT */
#define USB3_DP_DBGINT_INTGEN_STATUS1				0x0200
#define USB3_DP_DBGINT_INTGEN_STATUS2				0x0204
#define USB3_DP_DBGINT_CONFIG1					0x0208
#define USB3_DP_DBGINT_SIGNALBLK1_CONFIG1			0x020C
#define USB3_DP_DBGINT_SIGNALBLK1_CONFIG2			0x0210
#define USB3_DP_DBGINT_SIGNALBLK1_CONFIG3			0x0214
#define USB3_DP_DBGINT_SIGNALBLK1_CONFIG4			0x0218
#define USB3_DP_DBGINT_SIGNALBLK1_CONFIG5			0x021C
#define USB3_DP_DBGINT_SIGNALBLK2_CONFIG1			0x0220
#define USB3_DP_DBGINT_SIGNALBLK2_CONFIG2			0x0224
#define USB3_DP_DBGINT_SIGNALBLK2_CONFIG3			0x0228
#define USB3_DP_DBGINT_SIGNALBLK2_CONFIG4			0x022C
#define USB3_DP_DBGINT_SIGNALBLK2_CONFIG5			0x0230
#define USB3_DP_DBGINT_STRINGBLK1_CONFIG1			0x0234
#define USB3_DP_DBGINT_STRINGBLK1_CONFIG2			0x0238
#define USB3_DP_DBGINT_STRINGBLK1_CONFIG3			0x023C
#define USB3_DP_DBGINT_STRINGBLK1_CONFIG4			0x0240
#define USB3_DP_DBGINT_STRINGBLK1_CONFIG5			0x0244
#define USB3_DP_DBGINT_STRINGBLK2_CONFIG1			0x0248
#define USB3_DP_DBGINT_STRINGBLK2_CONFIG2			0x024C
#define USB3_DP_DBGINT_STRINGBLK2_CONFIG3			0x0250
#define USB3_DP_DBGINT_STRINGBLK2_CONFIG4			0x0254
#define USB3_DP_DBGINT_STRINGBLK2_CONFIG5			0x0258

/* Module: USB3_DP_PHY_USB3_QSERDES_COM_USB3_QSERDES_COM_USB3_DP_QMP_PLL */
#define USB3_DP_QSERDES_COM_ATB_SEL1				0x1000
#define USB3_DP_QSERDES_COM_ATB_SEL2				0x1004
#define USB3_DP_QSERDES_COM_FREQ_UPDATE				0x1008
#define USB3_DP_QSERDES_COM_BG_TIMER				0x100C
#define USB3_DP_QSERDES_COM_SSC_EN_CENTER			0x1010
#define USB3_DP_QSERDES_COM_SSC_ADJ_PER1			0x1014
#define USB3_DP_QSERDES_COM_SSC_ADJ_PER2			0x1018
#define USB3_DP_QSERDES_COM_SSC_PER1				0x101C
#define USB3_DP_QSERDES_COM_SSC_PER2				0x1020
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE1_MODE0		0x1024
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE2_MODE0		0x1028
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE3_MODE0		0x102C
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE1_MODE1		0x1030
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE2_MODE1		0x1034
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE3_MODE1		0x1038
#define USB3_DP_QSERDES_COM_POST_DIV				0x103C
#define USB3_DP_QSERDES_COM_POST_DIV_MUX			0x1040
#define USB3_DP_QSERDES_COM_BIAS_EN_CLKBUFLR_EN			0x1044
#define USB3_DP_QSERDES_COM_CLK_ENABLE1				0x1048
#define USB3_DP_QSERDES_COM_SYS_CLK_CTRL			0x104C
#define USB3_DP_QSERDES_COM_SYSCLK_BUF_ENABLE			0x1050
#define USB3_DP_QSERDES_COM_PLL_EN				0x1054
#define USB3_DP_QSERDES_COM_PLL_IVCO				0x1058
#define USB3_DP_QSERDES_COM_CMN_IETRIM				0x105C
#define USB3_DP_QSERDES_COM_CMN_IPTRIM				0x1060
#define USB3_DP_QSERDES_COM_EP_CLOCK_DETECT_CTRL		0x1064
#define USB3_DP_QSERDES_COM_SYSCLK_DET_COMP_STATUS		0x1068
#define USB3_DP_QSERDES_COM_CLK_EP_DIV_MODE0			0x106C
#define USB3_DP_QSERDES_COM_CLK_EP_DIV_MODE1			0x1070
#define USB3_DP_QSERDES_COM_CP_CTRL_MODE0			0x1074
#define USB3_DP_QSERDES_COM_CP_CTRL_MODE1			0x1078
#define USB3_DP_QSERDES_COM_PLL_RCTRL_MODE0			0x107C
#define USB3_DP_QSERDES_COM_PLL_RCTRL_MODE1			0x1080
#define USB3_DP_QSERDES_COM_PLL_CCTRL_MODE0			0x1084
#define USB3_DP_QSERDES_COM_PLL_CCTRL_MODE1			0x1088
#define USB3_DP_QSERDES_COM_PLL_CNTRL				0x108C
#define USB3_DP_QSERDES_COM_BIAS_EN_CTRL_BY_PSM			0x1090
#define USB3_DP_QSERDES_COM_SYSCLK_EN_SEL			0x1094
#define USB3_DP_QSERDES_COM_CML_SYSCLK_SEL			0x1098
#define USB3_DP_QSERDES_COM_RESETSM_CNTRL			0x109C
#define USB3_DP_QSERDES_COM_RESETSM_CNTRL2			0x10A0
#define USB3_DP_QSERDES_COM_LOCK_CMP_EN				0x10A4
#define USB3_DP_QSERDES_COM_LOCK_CMP_CFG			0x10A8
#define USB3_DP_QSERDES_COM_LOCK_CMP1_MODE0			0x10AC
#define USB3_DP_QSERDES_COM_LOCK_CMP2_MODE0			0x10B0
#define USB3_DP_QSERDES_COM_LOCK_CMP1_MODE1			0x10B4
#define USB3_DP_QSERDES_COM_LOCK_CMP2_MODE1			0x10B8
#define USB3_DP_QSERDES_COM_DEC_START_MODE0			0x10BC
#define USB3_DP_QSERDES_COM_DEC_START_MSB_MODE0			0x10C0
#define USB3_DP_QSERDES_COM_DEC_START_MODE1			0x10C4
#define USB3_DP_QSERDES_COM_DEC_START_MSB_MODE1			0x10C8
#define USB3_DP_QSERDES_COM_DIV_FRAC_START1_MODE0		0x10CC
#define USB3_DP_QSERDES_COM_DIV_FRAC_START2_MODE0		0x10D0
#define USB3_DP_QSERDES_COM_DIV_FRAC_START3_MODE0		0x10D4
#define USB3_DP_QSERDES_COM_DIV_FRAC_START1_MODE1		0x10D8
#define USB3_DP_QSERDES_COM_DIV_FRAC_START2_MODE1		0x10DC
#define USB3_DP_QSERDES_COM_DIV_FRAC_START3_MODE1		0x10E0
#define USB3_DP_QSERDES_COM_INTEGLOOP_INITVAL			0x10E4
#define USB3_DP_QSERDES_COM_INTEGLOOP_EN			0x10E8
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN0_MODE0		0x10EC
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN1_MODE0		0x10F0
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN0_MODE1		0x10F4
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN1_MODE1		0x10F8
#define USB3_DP_QSERDES_COM_INTEGLOOP_P_PATH_GAIN0		0x10FC
#define USB3_DP_QSERDES_COM_INTEGLOOP_P_PATH_GAIN1		0x1100
#define USB3_DP_QSERDES_COM_VCOCAL_DEADMAN_CTRL			0x1104
#define USB3_DP_QSERDES_COM_VCO_TUNE_CTRL			0x1108
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAP			0x110C
#define USB3_DP_QSERDES_COM_VCO_TUNE1_MODE0			0x1110
#define USB3_DP_QSERDES_COM_VCO_TUNE2_MODE0			0x1114
#define USB3_DP_QSERDES_COM_VCO_TUNE1_MODE1			0x1118
#define USB3_DP_QSERDES_COM_VCO_TUNE2_MODE1			0x111C
#define USB3_DP_QSERDES_COM_VCO_TUNE_INITVAL1			0x1120
#define USB3_DP_QSERDES_COM_VCO_TUNE_INITVAL2			0x1124
#define USB3_DP_QSERDES_COM_VCO_TUNE_MINVAL1			0x1128
#define USB3_DP_QSERDES_COM_VCO_TUNE_MINVAL2			0x112C
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAXVAL1			0x1130
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAXVAL2			0x1134
#define USB3_DP_QSERDES_COM_VCO_TUNE_TIMER1			0x1138
#define USB3_DP_QSERDES_COM_VCO_TUNE_TIMER2			0x113C
#define USB3_DP_QSERDES_COM_CMN_STATUS				0x1140
#define USB3_DP_QSERDES_COM_RESET_SM_STATUS			0x1144
#define USB3_DP_QSERDES_COM_RESTRIM_CODE_STATUS			0x1148
#define USB3_DP_QSERDES_COM_PLLCAL_CODE1_STATUS			0x114C
#define USB3_DP_QSERDES_COM_PLLCAL_CODE2_STATUS			0x1150
#define USB3_DP_QSERDES_COM_CLK_SELECT				0x1154
#define USB3_DP_QSERDES_COM_HSCLK_SEL				0x1158
#define USB3_DP_QSERDES_COM_HSCLK_HS_SWITCH_SEL			0x115C
#define USB3_DP_QSERDES_COM_INTEGLOOP_BINCODE_STATUS		0x1160
#define USB3_DP_QSERDES_COM_PLL_ANALOG				0x1164
#define USB3_DP_QSERDES_COM_CORECLK_DIV_MODE0			0x1168
#define USB3_DP_QSERDES_COM_CORECLK_DIV_MODE1			0x116C
#define USB3_DP_QSERDES_COM_SW_RESET				0x1170
#define USB3_DP_QSERDES_COM_CORE_CLK_EN				0x1174
#define USB3_DP_QSERDES_COM_C_READY_STATUS			0x1178
#define USB3_DP_QSERDES_COM_CMN_CONFIG				0x117C
#define USB3_DP_QSERDES_COM_CMN_RATE_OVERRIDE			0x1180
#define USB3_DP_QSERDES_COM_SVS_MODE_CLK_SEL			0x1184
#define USB3_DP_QSERDES_COM_DEBUG_BUS0				0x1188
#define USB3_DP_QSERDES_COM_DEBUG_BUS1				0x118C
#define USB3_DP_QSERDES_COM_DEBUG_BUS2				0x1190
#define USB3_DP_QSERDES_COM_DEBUG_BUS3				0x1194
#define USB3_DP_QSERDES_COM_DEBUG_BUS_SEL			0x1198
#define USB3_DP_QSERDES_COM_CMN_MISC1				0x119C
#define USB3_DP_QSERDES_COM_CMN_MODE				0x11A0
#define USB3_DP_QSERDES_COM_CMN_MODE_CONTD			0x11A4
#define USB3_DP_QSERDES_COM_VCO_DC_LEVEL_CTRL			0x11A8
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE0		0x11AC
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE0		0x11B0
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE1		0x11B4
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE1		0x11B8
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_HSCLK_SEL		0x11BC
#define USB3_DP_QSERDES_COM_RESERVED_1				0x11C0
#define USB3_DP_QSERDES_COM_MODE_OPERATION_STATUS		0x11C4

/* Module: USB3_DP_PHY_USB3_QSERDES_TXA_USB3_QSERDES_TXA_USB3_DP_QMP_TX */
#define USB3_DP_QSERDES_TXA_BIST_MODE_LANENO			0x1200
#define USB3_DP_QSERDES_TXA_BIST_INVERT				0x1204
#define USB3_DP_QSERDES_TXA_CLKBUF_ENABLE			0x1208
#define USB3_DP_QSERDES_TXA_TX_EMP_POST1_LVL			0x120C
#define USB3_DP_QSERDES_TXA_TX_IDLE_LVL_LARGE_AMP		0x1210
#define USB3_DP_QSERDES_TXA_TX_DRV_LVL				0x1214
#define USB3_DP_QSERDES_TXA_TX_DRV_LVL_OFFSET			0x1218
#define USB3_DP_QSERDES_TXA_RESET_TSYNC_EN			0x121C
#define USB3_DP_QSERDES_TXA_PRE_STALL_LDO_BOOST_EN		0x1220
#define USB3_DP_QSERDES_TXA_TX_BAND				0x1224
#define USB3_DP_QSERDES_TXA_SLEW_CNTL				0x1228
#define USB3_DP_QSERDES_TXA_INTERFACE_SELECT			0x122C
#define USB3_DP_QSERDES_TXA_LPB_EN				0x1230
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_TX			0x1234
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_RX			0x1238
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_TX		0x123C
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_RX		0x1240
#define USB3_DP_QSERDES_TXA_PERL_LENGTH1			0x1244
#define USB3_DP_QSERDES_TXA_PERL_LENGTH2			0x1248
#define USB3_DP_QSERDES_TXA_SERDES_BYP_EN_OUT			0x124C
#define USB3_DP_QSERDES_TXA_DEBUG_BUS_SEL			0x1250
#define USB3_DP_QSERDES_TXA_TRANSCEIVER_BIAS_EN			0x1254
#define USB3_DP_QSERDES_TXA_HIGHZ_DRVR_EN			0x1258
#define USB3_DP_QSERDES_TXA_TX_POL_INV				0x125C
#define USB3_DP_QSERDES_TXA_PARRATE_REC_DETECT_IDLE_EN		0x1260
#define USB3_DP_QSERDES_TXA_BIST_PATTERN1			0x1264
#define USB3_DP_QSERDES_TXA_BIST_PATTERN2			0x1268
#define USB3_DP_QSERDES_TXA_BIST_PATTERN3			0x126C
#define USB3_DP_QSERDES_TXA_BIST_PATTERN4			0x1270
#define USB3_DP_QSERDES_TXA_BIST_PATTERN5			0x1274
#define USB3_DP_QSERDES_TXA_BIST_PATTERN6			0x1278
#define USB3_DP_QSERDES_TXA_BIST_PATTERN7			0x127C
#define USB3_DP_QSERDES_TXA_BIST_PATTERN8			0x1280
#define USB3_DP_QSERDES_TXA_LANE_MODE_1				0x1284
#define USB3_DP_QSERDES_TXA_LANE_MODE_2				0x1288
#define USB3_DP_QSERDES_TXA_LANE_MODE_3				0x128C
#define USB3_DP_QSERDES_TXA_LANE_MODE_4				0x1290
#define USB3_DP_QSERDES_TXA_LANE_MODE_5				0x1294
#define USB3_DP_QSERDES_TXA_ATB_SEL1				0x1298
#define USB3_DP_QSERDES_TXA_ATB_SEL2				0x129C
#define USB3_DP_QSERDES_TXA_RCV_DETECT_LVL			0x12A0
#define USB3_DP_QSERDES_TXA_RCV_DETECT_LVL_2			0x12A4
#define USB3_DP_QSERDES_TXA_PRBS_SEED1				0x12A8
#define USB3_DP_QSERDES_TXA_PRBS_SEED2				0x12AC
#define USB3_DP_QSERDES_TXA_PRBS_SEED3				0x12B0
#define USB3_DP_QSERDES_TXA_PRBS_SEED4				0x12B4
#define USB3_DP_QSERDES_TXA_RESET_GEN				0x12B8
#define USB3_DP_QSERDES_TXA_RESET_GEN_MUXES			0x12BC
#define USB3_DP_QSERDES_TXA_TRAN_DRVR_EMP_EN			0x12C0
#define USB3_DP_QSERDES_TXA_TX_INTERFACE_MODE			0x12C4
#define USB3_DP_QSERDES_TXA_VMODE_CTRL1				0x12C8
#define USB3_DP_QSERDES_TXA_ALOG_OBSV_BUS_CTRL_1		0x12CC
#define USB3_DP_QSERDES_TXA_BIST_STATUS				0x12D0
#define USB3_DP_QSERDES_TXA_BIST_ERROR_COUNT1			0x12D4
#define USB3_DP_QSERDES_TXA_BIST_ERROR_COUNT2			0x12D8
#define USB3_DP_QSERDES_TXA_ALOG_OBSV_BUS_STATUS_1		0x12DC
#define USB3_DP_QSERDES_TXA_LANE_DIG_CONFIG			0x12E0
#define USB3_DP_QSERDES_TXA_PI_QEC_CTRL				0x12E4
#define USB3_DP_QSERDES_TXA_PRE_EMPH				0x12E8
#define USB3_DP_QSERDES_TXA_SW_RESET				0x12EC
#define USB3_DP_QSERDES_TXA_DCC_OFFSET				0x12F0
#define USB3_DP_QSERDES_TXA_DCC_CMUX_POSTCAL_OFFSET		0x12F4
#define USB3_DP_QSERDES_TXA_DCC_CMUX_CAL_CTRL1			0x12F8
#define USB3_DP_QSERDES_TXA_DCC_CMUX_CAL_CTRL2			0x12FC
#define USB3_DP_QSERDES_TXA_DIG_BKUP_CTRL			0x1300
#define USB3_DP_QSERDES_TXA_DEBUG_BUS0				0x1304
#define USB3_DP_QSERDES_TXA_DEBUG_BUS1				0x1308
#define USB3_DP_QSERDES_TXA_DEBUG_BUS2				0x130C
#define USB3_DP_QSERDES_TXA_DEBUG_BUS3				0x1310
#define USB3_DP_QSERDES_TXA_READ_EQCODE				0x1314
#define USB3_DP_QSERDES_TXA_READ_OFFSETCODE			0x1318
#define USB3_DP_QSERDES_TXA_IA_ERROR_COUNTER_LOW		0x131C
#define USB3_DP_QSERDES_TXA_IA_ERROR_COUNTER_HIGH		0x1320
#define USB3_DP_QSERDES_TXA_VGA_READ_CODE			0x1324
#define USB3_DP_QSERDES_TXA_VTH_READ_CODE			0x1328
#define USB3_DP_QSERDES_TXA_DFE_TAP1_READ_CODE			0x132C
#define USB3_DP_QSERDES_TXA_DFE_TAP2_READ_CODE			0x1330
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_I			0x1334
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_IBAR			0x1338
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_Q			0x133C
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_QBAR			0x1340
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_A			0x1344
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_ABAR			0x1348
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_SM_ON			0x134C
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_CAL_DONE		0x1350
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_SIGNERROR		0x1354
#define USB3_DP_QSERDES_TXA_DCC_CAL_STATUS			0x1358
#define USB3_DP_QSERDES_TXA_DCC_READ_CODE_STATUS		0x135C

/* Module: USB3_DP_PHY_USB3_QSERDES_RXA_USB3_QSERDES_RXA_USB3_DP_QMP_RX */
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN_HALF			0x1400
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN_QUARTER		0x1404
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN			0x1408
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN_HALF			0x140C
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN_QUARTER		0x1410
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN			0x1414
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN_HALF		0x1418
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN_QUARTER		0x141C
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN			0x1420
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN_HALF		0x1424
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN_QUARTER		0x1428
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN			0x142C
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN		0x1430
#define USB3_DP_QSERDES_RXA_UCDR_SO_SATURATION_AND_ENABLE	0x1434
#define USB3_DP_QSERDES_RXA_UCDR_FO_TO_SO_DELAY			0x1438
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW		0x143C
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH		0x1440
#define USB3_DP_QSERDES_RXA_UCDR_PI_CONTROLS			0x1444
#define USB3_DP_QSERDES_RXA_UCDR_PI_CTRL2			0x1448
#define USB3_DP_QSERDES_RXA_UCDR_SB2_THRESH1			0x144C
#define USB3_DP_QSERDES_RXA_UCDR_SB2_THRESH2			0x1450
#define USB3_DP_QSERDES_RXA_UCDR_SB2_GAIN1			0x1454
#define USB3_DP_QSERDES_RXA_UCDR_SB2_GAIN2			0x1458
#define USB3_DP_QSERDES_RXA_AUX_CONTROL				0x145C
#define USB3_DP_QSERDES_RXA_AUX_DATA_TCOARSE_TFINE		0x1460
#define USB3_DP_QSERDES_RXA_RCLK_AUXDATA_SEL			0x1464
#define USB3_DP_QSERDES_RXA_AC_JTAG_ENABLE			0x1468
#define USB3_DP_QSERDES_RXA_AC_JTAG_INITP			0x146C
#define USB3_DP_QSERDES_RXA_AC_JTAG_INITN			0x1470
#define USB3_DP_QSERDES_RXA_AC_JTAG_LVL				0x1474
#define USB3_DP_QSERDES_RXA_AC_JTAG_MODE			0x1478
#define USB3_DP_QSERDES_RXA_AC_JTAG_RESET			0x147C
#define USB3_DP_QSERDES_RXA_RX_TERM_BW				0x1480
#define USB3_DP_QSERDES_RXA_RX_RCVR_IQ_EN			0x1484
#define USB3_DP_QSERDES_RXA_RX_IDAC_I_DC_OFFSETS		0x1488
#define USB3_DP_QSERDES_RXA_RX_IDAC_IBAR_DC_OFFSETS		0x148C
#define USB3_DP_QSERDES_RXA_RX_IDAC_Q_DC_OFFSETS		0x1490
#define USB3_DP_QSERDES_RXA_RX_IDAC_QBAR_DC_OFFSETS		0x1494
#define USB3_DP_QSERDES_RXA_RX_IDAC_A_DC_OFFSETS		0x1498
#define USB3_DP_QSERDES_RXA_RX_IDAC_ABAR_DC_OFFSETS		0x149C
#define USB3_DP_QSERDES_RXA_RX_IDAC_EN				0x14A0
#define USB3_DP_QSERDES_RXA_RX_IDAC_ENABLES			0x14A4
#define USB3_DP_QSERDES_RXA_RX_IDAC_SIGN			0x14A8
#define USB3_DP_QSERDES_RXA_RX_HIGHZ_HIGHRATE			0x14AC
#define USB3_DP_QSERDES_RXA_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x14B0
#define USB3_DP_QSERDES_RXA_DFE_1				0x14B4
#define USB3_DP_QSERDES_RXA_DFE_2				0x14B8
#define USB3_DP_QSERDES_RXA_DFE_3				0x14BC
#define USB3_DP_QSERDES_RXA_DFE_4				0x14C0
#define USB3_DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH1		0x14C4
#define USB3_DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH2		0x14C8
#define USB3_DP_QSERDES_RXA_TX_ADAPT_POST_THRESH		0x14CC
#define USB3_DP_QSERDES_RXA_TX_ADAPT_MAIN_THRESH		0x14D0
#define USB3_DP_QSERDES_RXA_VGA_CAL_CNTRL1			0x14D4
#define USB3_DP_QSERDES_RXA_VGA_CAL_CNTRL2			0x14D8
#define USB3_DP_QSERDES_RXA_GM_CAL				0x14DC
#define USB3_DP_QSERDES_RXA_RX_VGA_GAIN2_LSB			0x14E0
#define USB3_DP_QSERDES_RXA_RX_VGA_GAIN2_MSB			0x14E4
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL1		0x14E8
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL2		0x14EC
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL3		0x14F0
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL4		0x14F4
#define USB3_DP_QSERDES_RXA_RX_IDAC_TSETTLE_LOW			0x14F8
#define USB3_DP_QSERDES_RXA_RX_IDAC_TSETTLE_HIGH		0x14FC
#define USB3_DP_QSERDES_RXA_RX_IDAC_MEASURE_TIME		0x1500
#define USB3_DP_QSERDES_RXA_RX_IDAC_ACCUMULATOR			0x1504
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_LSB			0x1508
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_MSB			0x150C
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1510
#define USB3_DP_QSERDES_RXA_RX_OFFSET_ADAPTOR_CNTRL2		0x1514
#define USB3_DP_QSERDES_RXA_SIGDET_ENABLES			0x1518
#define USB3_DP_QSERDES_RXA_SIGDET_CNTRL			0x151C
#define USB3_DP_QSERDES_RXA_SIGDET_LVL				0x1520
#define USB3_DP_QSERDES_RXA_SIGDET_DEGLITCH_CNTRL		0x1524
#define USB3_DP_QSERDES_RXA_RX_BAND				0x1528
#define USB3_DP_QSERDES_RXA_CDR_FREEZE_UP_DN			0x152C
#define USB3_DP_QSERDES_RXA_CDR_RESET_OVERRIDE			0x1530
#define USB3_DP_QSERDES_RXA_RX_INTERFACE_MODE			0x1534
#define USB3_DP_QSERDES_RXA_JITTER_GEN_MODE			0x1538
#define USB3_DP_QSERDES_RXA_SJ_AMP1				0x153C
#define USB3_DP_QSERDES_RXA_SJ_AMP2				0x1540
#define USB3_DP_QSERDES_RXA_SJ_PER1				0x1544
#define USB3_DP_QSERDES_RXA_SJ_PER2				0x1548
#define USB3_DP_QSERDES_RXA_PPM_OFFSET1				0x154C
#define USB3_DP_QSERDES_RXA_PPM_OFFSET2				0x1550
#define USB3_DP_QSERDES_RXA_SIGN_PPM_PERIOD1			0x1554
#define USB3_DP_QSERDES_RXA_SIGN_PPM_PERIOD2			0x1558
#define USB3_DP_QSERDES_RXA_RX_MODE_00_LOW			0x155C
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH			0x1560
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH2			0x1564
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH3			0x1568
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH4			0x156C
#define USB3_DP_QSERDES_RXA_RX_MODE_01_LOW			0x1570
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH			0x1574
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH2			0x1578
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH3			0x157C
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH4			0x1580
#define USB3_DP_QSERDES_RXA_RX_MODE_10_LOW			0x1584
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH			0x1588
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH2			0x158C
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH3			0x1590
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH4			0x1594
#define USB3_DP_QSERDES_RXA_PHPRE_CTRL				0x1598
#define USB3_DP_QSERDES_RXA_PHPRE_INITVAL			0x159C
#define USB3_DP_QSERDES_RXA_DFE_EN_TIMER			0x15A0
#define USB3_DP_QSERDES_RXA_DFE_CTLE_POST_CAL_OFFSET		0x15A4
#define USB3_DP_QSERDES_RXA_DCC_CTRL1				0x15A8
#define USB3_DP_QSERDES_RXA_DCC_CTRL2				0x15AC
#define USB3_DP_QSERDES_RXA_VTH_CODE				0x15B0
#define USB3_DP_QSERDES_RXA_VTH_MIN_THRESH			0x15B4
#define USB3_DP_QSERDES_RXA_VTH_MAX_THRESH			0x15B8
#define USB3_DP_QSERDES_RXA_ALOG_OBSV_BUS_CTRL_1		0x15BC
#define USB3_DP_QSERDES_RXA_PI_CTRL1				0x15C0
#define USB3_DP_QSERDES_RXA_PI_CTRL2				0x15C4
#define USB3_DP_QSERDES_RXA_PI_QUAD				0x15C8
#define USB3_DP_QSERDES_RXA_IDATA1				0x15CC
#define USB3_DP_QSERDES_RXA_IDATA2				0x15D0
#define USB3_DP_QSERDES_RXA_AUX_DATA1				0x15D4
#define USB3_DP_QSERDES_RXA_AUX_DATA2				0x15D8
#define USB3_DP_QSERDES_RXA_AC_JTAG_OUTP			0x15DC
#define USB3_DP_QSERDES_RXA_AC_JTAG_OUTN			0x15E0
#define USB3_DP_QSERDES_RXA_RX_SIGDET				0x15E4
#define USB3_DP_QSERDES_RXA_ALOG_OBSV_BUS_STATUS_1		0x15E8

/* Module: USB3_DP_PHY_USB3_QSERDES_TXB_USB3_QSERDES_TXB_USB3_DP_QMP_TX */
#define USB3_DP_QSERDES_TXB_BIST_MODE_LANENO			0x1600
#define USB3_DP_QSERDES_TXB_BIST_INVERT				0x1604
#define USB3_DP_QSERDES_TXB_CLKBUF_ENABLE			0x1608
#define USB3_DP_QSERDES_TXB_TX_EMP_POST1_LVL			0x160C
#define USB3_DP_QSERDES_TXB_TX_IDLE_LVL_LARGE_AMP		0x1610
#define USB3_DP_QSERDES_TXB_TX_DRV_LVL				0x1614
#define USB3_DP_QSERDES_TXB_TX_DRV_LVL_OFFSET			0x1618
#define USB3_DP_QSERDES_TXB_RESET_TSYNC_EN			0x161C
#define USB3_DP_QSERDES_TXB_PRE_STALL_LDO_BOOST_EN		0x1620
#define USB3_DP_QSERDES_TXB_TX_BAND				0x1624
#define USB3_DP_QSERDES_TXB_SLEW_CNTL				0x1628
#define USB3_DP_QSERDES_TXB_INTERFACE_SELECT			0x162C
#define USB3_DP_QSERDES_TXB_LPB_EN				0x1630
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_TX			0x1634
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_RX			0x1638
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_TX		0x163C
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_RX		0x1640
#define USB3_DP_QSERDES_TXB_PERL_LENGTH1			0x1644
#define USB3_DP_QSERDES_TXB_PERL_LENGTH2			0x1648
#define USB3_DP_QSERDES_TXB_SERDES_BYP_EN_OUT			0x164C
#define USB3_DP_QSERDES_TXB_DEBUG_BUS_SEL			0x1650
#define USB3_DP_QSERDES_TXB_TRANSCEIVER_BIAS_EN			0x1654
#define USB3_DP_QSERDES_TXB_HIGHZ_DRVR_EN			0x1658
#define USB3_DP_QSERDES_TXB_TX_POL_INV				0x165C
#define USB3_DP_QSERDES_TXB_PARRATE_REC_DETECT_IDLE_EN		0x1660
#define USB3_DP_QSERDES_TXB_BIST_PATTERN1			0x1664
#define USB3_DP_QSERDES_TXB_BIST_PATTERN2			0x1668
#define USB3_DP_QSERDES_TXB_BIST_PATTERN3			0x166C
#define USB3_DP_QSERDES_TXB_BIST_PATTERN4			0x1670
#define USB3_DP_QSERDES_TXB_BIST_PATTERN5			0x1674
#define USB3_DP_QSERDES_TXB_BIST_PATTERN6			0x1678
#define USB3_DP_QSERDES_TXB_BIST_PATTERN7			0x167C
#define USB3_DP_QSERDES_TXB_BIST_PATTERN8			0x1680
#define USB3_DP_QSERDES_TXB_LANE_MODE_1				0x1684
#define USB3_DP_QSERDES_TXB_LANE_MODE_2				0x1688
#define USB3_DP_QSERDES_TXB_LANE_MODE_3				0x168C
#define USB3_DP_QSERDES_TXB_LANE_MODE_4				0x1690
#define USB3_DP_QSERDES_TXB_LANE_MODE_5				0x1694
#define USB3_DP_QSERDES_TXB_ATB_SEL1				0x1698
#define USB3_DP_QSERDES_TXB_ATB_SEL2				0x169C
#define USB3_DP_QSERDES_TXB_RCV_DETECT_LVL			0x16A0
#define USB3_DP_QSERDES_TXB_RCV_DETECT_LVL_2			0x16A4
#define USB3_DP_QSERDES_TXB_PRBS_SEED1				0x16A8
#define USB3_DP_QSERDES_TXB_PRBS_SEED2				0x16AC
#define USB3_DP_QSERDES_TXB_PRBS_SEED3				0x16B0
#define USB3_DP_QSERDES_TXB_PRBS_SEED4				0x16B4
#define USB3_DP_QSERDES_TXB_RESET_GEN				0x16B8
#define USB3_DP_QSERDES_TXB_RESET_GEN_MUXES			0x16BC
#define USB3_DP_QSERDES_TXB_TRAN_DRVR_EMP_EN			0x16C0
#define USB3_DP_QSERDES_TXB_TX_INTERFACE_MODE			0x16C4
#define USB3_DP_QSERDES_TXB_VMODE_CTRL1				0x16C8
#define USB3_DP_QSERDES_TXB_ALOG_OBSV_BUS_CTRL_1		0x16CC
#define USB3_DP_QSERDES_TXB_BIST_STATUS				0x16D0
#define USB3_DP_QSERDES_TXB_BIST_ERROR_COUNT1			0x16D4
#define USB3_DP_QSERDES_TXB_BIST_ERROR_COUNT2			0x16D8
#define USB3_DP_QSERDES_TXB_ALOG_OBSV_BUS_STATUS_1		0x16DC
#define USB3_DP_QSERDES_TXB_LANE_DIG_CONFIG			0x16E0
#define USB3_DP_QSERDES_TXB_PI_QEC_CTRL				0x16E4
#define USB3_DP_QSERDES_TXB_PRE_EMPH				0x16E8
#define USB3_DP_QSERDES_TXB_SW_RESET				0x16EC
#define USB3_DP_QSERDES_TXB_DCC_OFFSET				0x16F0
#define USB3_DP_QSERDES_TXB_DCC_CMUX_POSTCAL_OFFSET		0x16F4
#define USB3_DP_QSERDES_TXB_DCC_CMUX_CAL_CTRL1			0x16F8
#define USB3_DP_QSERDES_TXB_DCC_CMUX_CAL_CTRL2			0x16FC
#define USB3_DP_QSERDES_TXB_DIG_BKUP_CTRL			0x1700
#define USB3_DP_QSERDES_TXB_DEBUG_BUS0				0x1704
#define USB3_DP_QSERDES_TXB_DEBUG_BUS1				0x1708
#define USB3_DP_QSERDES_TXB_DEBUG_BUS2				0x170C
#define USB3_DP_QSERDES_TXB_DEBUG_BUS3				0x1710
#define USB3_DP_QSERDES_TXB_READ_EQCODE				0x1714
#define USB3_DP_QSERDES_TXB_READ_OFFSETCODE			0x1718
#define USB3_DP_QSERDES_TXB_IA_ERROR_COUNTER_LOW		0x171C
#define USB3_DP_QSERDES_TXB_IA_ERROR_COUNTER_HIGH		0x1720
#define USB3_DP_QSERDES_TXB_VGA_READ_CODE			0x1724
#define USB3_DP_QSERDES_TXB_VTH_READ_CODE			0x1728
#define USB3_DP_QSERDES_TXB_DFE_TAP1_READ_CODE			0x172C
#define USB3_DP_QSERDES_TXB_DFE_TAP2_READ_CODE			0x1730
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_I			0x1734
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_IBAR			0x1738
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_Q			0x173C
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_QBAR			0x1740
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_A			0x1744
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_ABAR			0x1748
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_SM_ON			0x174C
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_CAL_DONE		0x1750
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_SIGNERROR		0x1754
#define USB3_DP_QSERDES_TXB_DCC_CAL_STATUS			0x1758
#define USB3_DP_QSERDES_TXB_DCC_READ_CODE_STATUS		0x175C


/* Module: USB3_DP_PHY_USB3_QSERDES_RXB_USB3_QSERDES_RXB_USB3_DP_QMP_RX */
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN_HALF			0x1800
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN_QUARTER		0x1804
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN			0x1808
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN_HALF			0x180C
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN_QUARTER		0x1810
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN			0x1814
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN_HALF		0x1818
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN_QUARTER		0x181C
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN			0x1820
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN_HALF		0x1824
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN_QUARTER		0x1828
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN			0x182C
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN		0x1830
#define USB3_DP_QSERDES_RXB_UCDR_SO_SATURATION_AND_ENABLE	0x1834
#define USB3_DP_QSERDES_RXB_UCDR_FO_TO_SO_DELAY			0x1838
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW		0x183C
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH		0x1840
#define USB3_DP_QSERDES_RXB_UCDR_PI_CONTROLS			0x1844
#define USB3_DP_QSERDES_RXB_UCDR_PI_CTRL2			0x1848
#define USB3_DP_QSERDES_RXB_UCDR_SB2_THRESH1			0x184C
#define USB3_DP_QSERDES_RXB_UCDR_SB2_THRESH2			0x1850
#define USB3_DP_QSERDES_RXB_UCDR_SB2_GAIN1			0x1854
#define USB3_DP_QSERDES_RXB_UCDR_SB2_GAIN2			0x1858
#define USB3_DP_QSERDES_RXB_AUX_CONTROL				0x185C
#define USB3_DP_QSERDES_RXB_AUX_DATA_TCOARSE_TFINE		0x1860
#define USB3_DP_QSERDES_RXB_RCLK_AUXDATA_SEL			0x1864
#define USB3_DP_QSERDES_RXB_AC_JTAG_ENABLE			0x1868
#define USB3_DP_QSERDES_RXB_AC_JTAG_INITP			0x186C
#define USB3_DP_QSERDES_RXB_AC_JTAG_INITN			0x1870
#define USB3_DP_QSERDES_RXB_AC_JTAG_LVL				0x1874
#define USB3_DP_QSERDES_RXB_AC_JTAG_MODE			0x1878
#define USB3_DP_QSERDES_RXB_AC_JTAG_RESET			0x187C
#define USB3_DP_QSERDES_RXB_RX_TERM_BW				0x1880
#define USB3_DP_QSERDES_RXB_RX_RCVR_IQ_EN			0x1884
#define USB3_DP_QSERDES_RXB_RX_IDAC_I_DC_OFFSETS		0x1888
#define USB3_DP_QSERDES_RXB_RX_IDAC_IBAR_DC_OFFSETS		0x188C
#define USB3_DP_QSERDES_RXB_RX_IDAC_Q_DC_OFFSETS		0x1890
#define USB3_DP_QSERDES_RXB_RX_IDAC_QBAR_DC_OFFSETS		0x1894
#define USB3_DP_QSERDES_RXB_RX_IDAC_A_DC_OFFSETS		0x1898
#define USB3_DP_QSERDES_RXB_RX_IDAC_ABAR_DC_OFFSETS		0x189C
#define USB3_DP_QSERDES_RXB_RX_IDAC_EN				0x18A0
#define USB3_DP_QSERDES_RXB_RX_IDAC_ENABLES			0x18A4
#define USB3_DP_QSERDES_RXB_RX_IDAC_SIGN			0x18A8
#define USB3_DP_QSERDES_RXB_RX_HIGHZ_HIGHRATE			0x18AC
#define USB3_DP_QSERDES_RXB_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x18B0
#define USB3_DP_QSERDES_RXB_DFE_1				0x18B4
#define USB3_DP_QSERDES_RXB_DFE_2				0x18B8
#define USB3_DP_QSERDES_RXB_DFE_3				0x18BC
#define USB3_DP_QSERDES_RXB_DFE_4				0x18C0
#define USB3_DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH1		0x18C4
#define USB3_DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH2		0x18C8
#define USB3_DP_QSERDES_RXB_TX_ADAPT_POST_THRESH		0x18CC
#define USB3_DP_QSERDES_RXB_TX_ADAPT_MAIN_THRESH		0x18D0
#define USB3_DP_QSERDES_RXB_VGA_CAL_CNTRL1			0x18D4
#define USB3_DP_QSERDES_RXB_VGA_CAL_CNTRL2			0x18D8
#define USB3_DP_QSERDES_RXB_GM_CAL				0x18DC
#define USB3_DP_QSERDES_RXB_RX_VGA_GAIN2_LSB			0x18E0
#define USB3_DP_QSERDES_RXB_RX_VGA_GAIN2_MSB			0x18E4
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL1		0x18E8
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL2		0x18EC
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL3		0x18F0
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL4		0x18F4
#define USB3_DP_QSERDES_RXB_RX_IDAC_TSETTLE_LOW			0x18F8
#define USB3_DP_QSERDES_RXB_RX_IDAC_TSETTLE_HIGH		0x18FC
#define USB3_DP_QSERDES_RXB_RX_IDAC_MEASURE_TIME		0x1900
#define USB3_DP_QSERDES_RXB_RX_IDAC_ACCUMULATOR			0x1904
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_LSB			0x1908
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_MSB			0x190C
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1910
#define USB3_DP_QSERDES_RXB_RX_OFFSET_ADAPTOR_CNTRL2		0x1914
#define USB3_DP_QSERDES_RXB_SIGDET_ENABLES			0x1918
#define USB3_DP_QSERDES_RXB_SIGDET_CNTRL			0x191C
#define USB3_DP_QSERDES_RXB_SIGDET_LVL				0x1920
#define USB3_DP_QSERDES_RXB_SIGDET_DEGLITCH_CNTRL		0x1924
#define USB3_DP_QSERDES_RXB_RX_BAND				0x1928
#define USB3_DP_QSERDES_RXB_CDR_FREEZE_UP_DN			0x192C
#define USB3_DP_QSERDES_RXB_CDR_RESET_OVERRIDE			0x1930
#define USB3_DP_QSERDES_RXB_RX_INTERFACE_MODE			0x1934
#define USB3_DP_QSERDES_RXB_JITTER_GEN_MODE			0x1938
#define USB3_DP_QSERDES_RXB_SJ_AMP1				0x193C
#define USB3_DP_QSERDES_RXB_SJ_AMP2				0x1940
#define USB3_DP_QSERDES_RXB_SJ_PER1				0x1944
#define USB3_DP_QSERDES_RXB_SJ_PER2				0x1948
#define USB3_DP_QSERDES_RXB_PPM_OFFSET1				0x194C
#define USB3_DP_QSERDES_RXB_PPM_OFFSET2				0x1950
#define USB3_DP_QSERDES_RXB_SIGN_PPM_PERIOD1			0x1954
#define USB3_DP_QSERDES_RXB_SIGN_PPM_PERIOD2			0x1958
#define USB3_DP_QSERDES_RXB_RX_MODE_00_LOW			0x195C
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH			0x1960
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH2			0x1964
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH3			0x1968
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH4			0x196C
#define USB3_DP_QSERDES_RXB_RX_MODE_01_LOW			0x1970
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH			0x1974
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH2			0x1978
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH3			0x197C
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH4			0x1980
#define USB3_DP_QSERDES_RXB_RX_MODE_10_LOW			0x1984
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH			0x1988
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH2			0x198C
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH3			0x1990
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH4			0x1994
#define USB3_DP_QSERDES_RXB_PHPRE_CTRL				0x1998
#define USB3_DP_QSERDES_RXB_PHPRE_INITVAL			0x199C
#define USB3_DP_QSERDES_RXB_DFE_EN_TIMER			0x19A0
#define USB3_DP_QSERDES_RXB_DFE_CTLE_POST_CAL_OFFSET		0x19A4
#define USB3_DP_QSERDES_RXB_DCC_CTRL1				0x19A8
#define USB3_DP_QSERDES_RXB_DCC_CTRL2				0x19AC
#define USB3_DP_QSERDES_RXB_VTH_CODE				0x19B0
#define USB3_DP_QSERDES_RXB_VTH_MIN_THRESH			0x19B4
#define USB3_DP_QSERDES_RXB_VTH_MAX_THRESH			0x19B8
#define USB3_DP_QSERDES_RXB_ALOG_OBSV_BUS_CTRL_1		0x19BC
#define USB3_DP_QSERDES_RXB_PI_CTRL1				0x19C0
#define USB3_DP_QSERDES_RXB_PI_CTRL2				0x19C4
#define USB3_DP_QSERDES_RXB_PI_QUAD				0x19C8
#define USB3_DP_QSERDES_RXB_IDATA1				0x19CC
#define USB3_DP_QSERDES_RXB_IDATA2				0x19D0
#define USB3_DP_QSERDES_RXB_AUX_DATA1				0x19D4
#define USB3_DP_QSERDES_RXB_AUX_DATA2				0x19D8
#define USB3_DP_QSERDES_RXB_AC_JTAG_OUTP			0x19DC
#define USB3_DP_QSERDES_RXB_AC_JTAG_OUTN			0x19E0
#define USB3_DP_QSERDES_RXB_RX_SIGDET				0x19E4
#define USB3_DP_QSERDES_RXB_ALOG_OBSV_BUS_STATUS_1		0x19E8

/* Module: USB3_DP_PHY_USB3_PCS_MISC_USB3_PCS_MISC_USB3_PCS_MISC */
#define USB3_DP_PCS_MISC_TYPEC_CTRL				0x1A00
#define USB3_DP_PCS_MISC_TYPEC_PWRDN_CTRL			0x1A04
#define USB3_DP_PCS_MISC_PCS_MISC_CONFIG1			0x1A08
#define USB3_DP_PCS_MISC_CLAMP_ENABLE				0x1A0C
#define USB3_DP_PCS_MISC_TYPEC_STATUS				0x1A10
#define USB3_DP_PCS_MISC_PLACEHOLDER_STATUS			0x1A14

/* Module: USB3_DP_PHY_USB3_PCS_LN_USB3_PCS_LN_USB3_PCS_LANE */
#define USB3_DP_PCS_LN_PCS_STATUS1				0x1B00
#define USB3_DP_PCS_LN_PCS_STATUS2				0x1B04
#define USB3_DP_PCS_LN_PCS_STATUS2_CLEAR			0x1B08
#define USB3_DP_PCS_LN_PCS_STATUS3				0x1B0C
#define USB3_DP_PCS_LN_BIST_CHK_ERR_CNT_L_STATUS		0x1B10
#define USB3_DP_PCS_LN_BIST_CHK_ERR_CNT_H_STATUS		0x1B14
#define USB3_DP_PCS_LN_BIST_CHK_STATUS				0x1B18
#define USB3_DP_PCS_LN_INSIG_SW_CTRL1				0x1B1C
#define USB3_DP_PCS_LN_INSIG_MX_CTRL1				0x1B20
#define USB3_DP_PCS_LN_OUTSIG_SW_CTRL1				0x1B24
#define USB3_DP_PCS_LN_OUTSIG_MX_CTRL1				0x1B28
#define USB3_DP_PCS_LN_TEST_CONTROL1				0x1B2C
#define USB3_DP_PCS_LN_BIST_CTRL				0x1B30
#define USB3_DP_PCS_LN_PRBS_SEED0				0x1B34
#define USB3_DP_PCS_LN_PRBS_SEED1				0x1B38
#define USB3_DP_PCS_LN_FIXED_PAT_CTRL				0x1B3C
#define USB3_DP_PCS_LN_EQ_CONFIG				0x1B40
#define USB3_DP_PCS_LN_TEST_CONTROL2				0x1B44
#define USB3_DP_PCS_LN_TEST_CONTROL3				0x1B48

/* Module: USB3_DP_PHY_USB3_PCS_USB3_PCS_USB3_PCS */
#define USB3_DP_PCS_SW_RESET					0x1C00
#define USB3_DP_PCS_REVISION_ID0				0x1C04
#define USB3_DP_PCS_REVISION_ID1				0x1C08
#define USB3_DP_PCS_REVISION_ID2				0x1C0C
#define USB3_DP_PCS_REVISION_ID3				0x1C10
#define USB3_DP_PCS_PCS_STATUS1					0x1C14
#define USB3_DP_PCS_PCS_STATUS2					0x1C18
#define USB3_DP_PCS_PCS_STATUS3					0x1C1C
#define USB3_DP_PCS_PCS_STATUS4					0x1C20
#define USB3_DP_PCS_PCS_STATUS5					0x1C24
#define USB3_DP_PCS_PCS_STATUS6					0x1C28
#define USB3_DP_PCS_PCS_STATUS7					0x1C2C
#define USB3_DP_PCS_DEBUG_BUS_0_STATUS				0x1C30
#define USB3_DP_PCS_DEBUG_BUS_1_STATUS				0x1C34
#define USB3_DP_PCS_DEBUG_BUS_2_STATUS				0x1C38
#define USB3_DP_PCS_DEBUG_BUS_3_STATUS				0x1C3C
#define USB3_DP_PCS_POWER_DOWN_CONTROL				0x1C40
#define USB3_DP_PCS_START_CONTROL				0x1C44
#define USB3_DP_PCS_INSIG_SW_CTRL1				0x1C48
#define USB3_DP_PCS_INSIG_SW_CTRL2				0x1C4C
#define USB3_DP_PCS_INSIG_SW_CTRL3				0x1C50
#define USB3_DP_PCS_INSIG_SW_CTRL4				0x1C54
#define USB3_DP_PCS_INSIG_SW_CTRL5				0x1C58
#define USB3_DP_PCS_INSIG_SW_CTRL6				0x1C5C
#define USB3_DP_PCS_INSIG_SW_CTRL7				0x1C60
#define USB3_DP_PCS_INSIG_SW_CTRL8				0x1C64
#define USB3_DP_PCS_INSIG_MX_CTRL1				0x1C68
#define USB3_DP_PCS_INSIG_MX_CTRL2				0x1C6C
#define USB3_DP_PCS_INSIG_MX_CTRL3				0x1C70
#define USB3_DP_PCS_INSIG_MX_CTRL4				0x1C74
#define USB3_DP_PCS_INSIG_MX_CTRL5				0x1C78
#define USB3_DP_PCS_INSIG_MX_CTRL7				0x1C7C
#define USB3_DP_PCS_INSIG_MX_CTRL8				0x1C80
#define USB3_DP_PCS_OUTSIG_SW_CTRL1				0x1C84
#define USB3_DP_PCS_OUTSIG_MX_CTRL1				0x1C88
#define USB3_DP_PCS_CLAMP_ENABLE				0x1C8C
#define USB3_DP_PCS_POWER_STATE_CONFIG1				0x1C90
#define USB3_DP_PCS_POWER_STATE_CONFIG2				0x1C94
#define USB3_DP_PCS_FLL_CNTRL1					0x1C98
#define USB3_DP_PCS_FLL_CNTRL2					0x1C9C
#define USB3_DP_PCS_FLL_CNT_VAL_L				0x1CA0
#define USB3_DP_PCS_FLL_CNT_VAL_H_TOL				0x1CA4
#define USB3_DP_PCS_FLL_MAN_CODE				0x1CA8
#define USB3_DP_PCS_TEST_CONTROL1				0x1CAC
#define USB3_DP_PCS_TEST_CONTROL2				0x1CB0
#define USB3_DP_PCS_TEST_CONTROL3				0x1CB4
#define USB3_DP_PCS_TEST_CONTROL4				0x1CB8
#define USB3_DP_PCS_TEST_CONTROL5				0x1CBC
#define USB3_DP_PCS_TEST_CONTROL6				0x1CC0
#define USB3_DP_PCS_LOCK_DETECT_CONFIG1				0x1CC4
#define USB3_DP_PCS_LOCK_DETECT_CONFIG2				0x1CC8
#define USB3_DP_PCS_LOCK_DETECT_CONFIG3				0x1CCC
#define USB3_DP_PCS_LOCK_DETECT_CONFIG4				0x1CD0
#define USB3_DP_PCS_LOCK_DETECT_CONFIG5				0x1CD4
#define USB3_DP_PCS_LOCK_DETECT_CONFIG6				0x1CD8
#define USB3_DP_PCS_REFGEN_REQ_CONFIG1				0x1CDC
#define USB3_DP_PCS_REFGEN_REQ_CONFIG2				0x1CE0
#define USB3_DP_PCS_REFGEN_REQ_CONFIG3				0x1CE4
#define USB3_DP_PCS_BIST_CTRL					0x1CE8
#define USB3_DP_PCS_PRBS_POLY0					0x1CEC
#define USB3_DP_PCS_PRBS_POLY1					0x1CF0
#define USB3_DP_PCS_FIXED_PAT0					0x1CF4
#define USB3_DP_PCS_FIXED_PAT1					0x1CF8
#define USB3_DP_PCS_FIXED_PAT2					0x1CFC
#define USB3_DP_PCS_FIXED_PAT3					0x1D00
#define USB3_DP_PCS_FIXED_PAT4					0x1D04
#define USB3_DP_PCS_FIXED_PAT5					0x1D08
#define USB3_DP_PCS_FIXED_PAT6					0x1D0C
#define USB3_DP_PCS_FIXED_PAT7					0x1D10
#define USB3_DP_PCS_FIXED_PAT8					0x1D14
#define USB3_DP_PCS_FIXED_PAT9					0x1D18
#define USB3_DP_PCS_FIXED_PAT10					0x1D1C
#define USB3_DP_PCS_FIXED_PAT11					0x1D20
#define USB3_DP_PCS_FIXED_PAT12					0x1D24
#define USB3_DP_PCS_FIXED_PAT13					0x1D28
#define USB3_DP_PCS_FIXED_PAT14					0x1D2C
#define USB3_DP_PCS_FIXED_PAT15					0x1D30
#define USB3_DP_PCS_TXMGN_CONFIG				0x1D34
#define USB3_DP_PCS_G12S1_TXMGN_V0				0x1D38
#define USB3_DP_PCS_G12S1_TXMGN_V1				0x1D3C
#define USB3_DP_PCS_G12S1_TXMGN_V2				0x1D40
#define USB3_DP_PCS_G12S1_TXMGN_V3				0x1D44
#define USB3_DP_PCS_G12S1_TXMGN_V4				0x1D48
#define USB3_DP_PCS_G12S1_TXMGN_V0_RS				0x1D4C
#define USB3_DP_PCS_G12S1_TXMGN_V1_RS				0x1D50
#define USB3_DP_PCS_G12S1_TXMGN_V2_RS				0x1D54
#define USB3_DP_PCS_G12S1_TXMGN_V3_RS				0x1D58
#define USB3_DP_PCS_G12S1_TXMGN_V4_RS				0x1D5C
#define USB3_DP_PCS_G3S2_TXMGN_MAIN				0x1D60
#define USB3_DP_PCS_G3S2_TXMGN_MAIN_RS				0x1D64
#define USB3_DP_PCS_G12S1_TXDEEMPH_M6DB				0x1D68
#define USB3_DP_PCS_G12S1_TXDEEMPH_M3P5DB			0x1D6C
#define USB3_DP_PCS_G3S2_PRE_GAIN				0x1D70
#define USB3_DP_PCS_G3S2_POST_GAIN				0x1D74
#define USB3_DP_PCS_G3S2_PRE_POST_OFFSET			0x1D78
#define USB3_DP_PCS_G3S2_PRE_GAIN_RS				0x1D7C
#define USB3_DP_PCS_G3S2_POST_GAIN_RS				0x1D80
#define USB3_DP_PCS_G3S2_PRE_POST_OFFSET_RS			0x1D84
#define USB3_DP_PCS_RX_SIGDET_LVL				0x1D88
#define USB3_DP_PCS_RX_SIGDET_DTCT_CNTRL			0x1D8C
#define USB3_DP_PCS_RCVR_DTCT_DLY_P1U2_L			0x1D90
#define USB3_DP_PCS_RCVR_DTCT_DLY_P1U2_H			0x1D94
#define USB3_DP_PCS_RATE_SLEW_CNTRL1				0x1D98
#define USB3_DP_PCS_RATE_SLEW_CNTRL2				0x1D9C
#define USB3_DP_PCS_PWRUP_RESET_DLY_TIME_AUXCLK			0x1DA0
#define USB3_DP_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_L		0x1DA4
#define USB3_DP_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_H		0x1DA8
#define USB3_DP_PCS_TSYNC_RSYNC_TIME				0x1DAC
#define USB3_DP_PCS_CDR_RESET_TIME				0x1DB0
#define USB3_DP_PCS_TSYNC_DLY_TIME				0x1DB4
#define USB3_DP_PCS_ELECIDLE_DLY_SEL				0x1DB8
#define USB3_DP_PCS_CMN_ACK_OUT_SEL				0x1DBC
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG1			0x1DC0
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG2			0x1DC4
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG3			0x1DC8
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG4			0x1DCC
#define USB3_DP_PCS_PCS_TX_RX_CONFIG				0x1DD0
#define USB3_DP_PCS_RX_IDLE_DTCT_CNTRL				0x1DD4
#define USB3_DP_PCS_RX_DCC_CAL_CONFIG				0x1DD8
#define USB3_DP_PCS_EQ_CONFIG1					0x1DDC
#define USB3_DP_PCS_EQ_CONFIG2					0x1DE0
#define USB3_DP_PCS_EQ_CONFIG3					0x1DE4
#define USB3_DP_PCS_EQ_CONFIG4					0x1DE8
#define USB3_DP_PCS_EQ_CONFIG5					0x1DEC

/* Module: USB3_DP_PHY_USB3_PCS_USB3_USB3_PCS_USB3_USB3_PCS_USB3 */
#define USB3_DP_PCS_USB3_POWER_STATE_CONFIG1			0x1F00
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_STATUS			0x1F04
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_CTRL			0x1F08
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_CTRL2			0x1F0C
#define USB3_DP_PCS_USB3_LFPS_RXTERM_IRQ_SOURCE_STATUS		0x1F10
#define USB3_DP_PCS_USB3_LFPS_RXTERM_IRQ_CLEAR			0x1F14
#define USB3_DP_PCS_USB3_LFPS_DET_HIGH_COUNT_VAL		0x1F18
#define USB3_DP_PCS_USB3_LFPS_TX_ECSTART			0x1F1C
#define USB3_DP_PCS_USB3_LFPS_PER_TIMER_VAL			0x1F20
#define USB3_DP_PCS_USB3_LFPS_TX_END_CNT_U3_START		0x1F24
#define USB3_DP_PCS_USB3_LFPS_CONFIG1				0x1F28
#define USB3_DP_PCS_USB3_RXEQTRAINING_LOCK_TIME			0x1F2C
#define USB3_DP_PCS_USB3_RXEQTRAINING_WAIT_TIME			0x1F30
#define USB3_DP_PCS_USB3_RXEQTRAINING_CTLE_TIME			0x1F34
#define USB3_DP_PCS_USB3_RXEQTRAINING_WAIT_TIME_S2		0x1F38
#define USB3_DP_PCS_USB3_RXEQTRAINING_DFE_TIME_S2		0x1F3C
#define USB3_DP_PCS_USB3_RCVR_DTCT_DLY_U3_L			0x1F40
#define USB3_DP_PCS_USB3_RCVR_DTCT_DLY_U3_H			0x1F44
#define USB3_DP_PCS_USB3_ARCVR_DTCT_EN_PERIOD			0x1F48
#define USB3_DP_PCS_USB3_ARCVR_DTCT_CM_DLY			0x1F4C
#define USB3_DP_PCS_USB3_TXONESZEROS_RUN_LENGTH			0x1F50
#define USB3_DP_PCS_USB3_ALFPS_DEGLITCH_VAL			0x1F54
#define USB3_DP_PCS_USB3_SIGDET_STARTUP_TIMER_VAL		0x1F58
#define USB3_DP_PCS_USB3_TEST_CONTROL				0x1F5C
#define USB3_DP_PCS_USB3_RXTERMINATION_DLY_SEL			0x1F60

#endif /* _DT_BINDINGS_PHY_QCOM_5NM_QMP_COMBO_USB_H */
