/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020, The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_PHY_QCOM_5NM_QMP_UNI_USB_H
#define _DT_BINDINGS_PHY_QCOM_5NM_QMP_UNI_USB_H

/* USB3 Uni PHY register offsets */
/* Module: USB3_UNI_PHY_QSERDES_COM_QSERDES_COM_PCIE_USB3_UNI_QMP_PLL */
#define USB3_UNI_QSERDES_COM_ATB_SEL1				0x0000
#define USB3_UNI_QSERDES_COM_ATB_SEL2				0x0004
#define USB3_UNI_QSERDES_COM_FREQ_UPDATE			0x0008
#define USB3_UNI_QSERDES_COM_BG_TIMER				0x000C
#define USB3_UNI_QSERDES_COM_SSC_EN_CENTER			0x0010
#define USB3_UNI_QSERDES_COM_SSC_ADJ_PER1			0x0014
#define USB3_UNI_QSERDES_COM_SSC_ADJ_PER2			0x0018
#define USB3_UNI_QSERDES_COM_SSC_PER1				0x001C
#define USB3_UNI_QSERDES_COM_SSC_PER2				0x0020
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE1_MODE0		0x0024
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE2_MODE0		0x0028
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE3_MODE0		0x002C
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE1_MODE1		0x0030
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE2_MODE1		0x0034
#define USB3_UNI_QSERDES_COM_SSC_STEP_SIZE3_MODE1		0x0038
#define USB3_UNI_QSERDES_COM_POST_DIV				0x003C
#define USB3_UNI_QSERDES_COM_POST_DIV_MUX			0x0040
#define USB3_UNI_QSERDES_COM_BIAS_EN_CLKBUFLR_EN		0x0044
#define USB3_UNI_QSERDES_COM_CLK_ENABLE1			0x0048
#define USB3_UNI_QSERDES_COM_SYS_CLK_CTRL			0x004C
#define USB3_UNI_QSERDES_COM_SYSCLK_BUF_ENABLE			0x0050
#define USB3_UNI_QSERDES_COM_PLL_EN				0x0054
#define USB3_UNI_QSERDES_COM_PLL_IVCO				0x0058
#define USB3_UNI_QSERDES_COM_CMN_IETRIM				0x005C
#define USB3_UNI_QSERDES_COM_CMN_IPTRIM				0x0060
#define USB3_UNI_QSERDES_COM_EP_CLOCK_DETECT_CTRL		0x0064
#define USB3_UNI_QSERDES_COM_SYSCLK_DET_COMP_STATUS		0x0068
#define USB3_UNI_QSERDES_COM_CLK_EP_DIV_MODE0			0x006C
#define USB3_UNI_QSERDES_COM_CLK_EP_DIV_MODE1			0x0070
#define USB3_UNI_QSERDES_COM_CP_CTRL_MODE0			0x0074
#define USB3_UNI_QSERDES_COM_CP_CTRL_MODE1			0x0078
#define USB3_UNI_QSERDES_COM_PLL_RCTRL_MODE0			0x007C
#define USB3_UNI_QSERDES_COM_PLL_RCTRL_MODE1			0x0080
#define USB3_UNI_QSERDES_COM_PLL_CCTRL_MODE0			0x0084
#define USB3_UNI_QSERDES_COM_PLL_CCTRL_MODE1			0x0088
#define USB3_UNI_QSERDES_COM_PLL_CNTRL				0x008C
#define USB3_UNI_QSERDES_COM_BIAS_EN_CTRL_BY_PSM		0x0090
#define USB3_UNI_QSERDES_COM_SYSCLK_EN_SEL			0x0094
#define USB3_UNI_QSERDES_COM_CML_SYSCLK_SEL			0x0098
#define USB3_UNI_QSERDES_COM_RESETSM_CNTRL			0x009C
#define USB3_UNI_QSERDES_COM_RESETSM_CNTRL2			0x00A0
#define USB3_UNI_QSERDES_COM_LOCK_CMP_EN			0x00A4
#define USB3_UNI_QSERDES_COM_LOCK_CMP_CFG			0x00A8
#define USB3_UNI_QSERDES_COM_LOCK_CMP1_MODE0			0x00AC
#define USB3_UNI_QSERDES_COM_LOCK_CMP2_MODE0			0x00B0
#define USB3_UNI_QSERDES_COM_LOCK_CMP1_MODE1			0x00B4
#define USB3_UNI_QSERDES_COM_LOCK_CMP2_MODE1			0x00B8
#define USB3_UNI_QSERDES_COM_DEC_START_MODE0			0x00BC
#define USB3_UNI_QSERDES_COM_DEC_START_MSB_MODE0		0x00C0
#define USB3_UNI_QSERDES_COM_DEC_START_MODE1			0x00C4
#define USB3_UNI_QSERDES_COM_DEC_START_MSB_MODE1		0x00C8
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START1_MODE0		0x00CC
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START2_MODE0		0x00D0
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START3_MODE0		0x00D4
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START1_MODE1		0x00D8
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START2_MODE1		0x00DC
#define USB3_UNI_QSERDES_COM_DIV_FRAC_START3_MODE1		0x00E0
#define USB3_UNI_QSERDES_COM_INTEGLOOP_INITVAL			0x00E4
#define USB3_UNI_QSERDES_COM_INTEGLOOP_EN			0x00E8
#define USB3_UNI_QSERDES_COM_INTEGLOOP_GAIN0_MODE0		0x00EC
#define USB3_UNI_QSERDES_COM_INTEGLOOP_GAIN1_MODE0		0x00F0
#define USB3_UNI_QSERDES_COM_INTEGLOOP_GAIN0_MODE1		0x00F4
#define USB3_UNI_QSERDES_COM_INTEGLOOP_GAIN1_MODE1		0x00F8
#define USB3_UNI_QSERDES_COM_INTEGLOOP_P_PATH_GAIN0		0x00FC
#define USB3_UNI_QSERDES_COM_INTEGLOOP_P_PATH_GAIN1		0x0100
#define USB3_UNI_QSERDES_COM_VCOCAL_DEADMAN_CTRL		0x0104
#define USB3_UNI_QSERDES_COM_VCO_TUNE_CTRL			0x0108
#define USB3_UNI_QSERDES_COM_VCO_TUNE_MAP			0x010C
#define USB3_UNI_QSERDES_COM_VCO_TUNE1_MODE0			0x0110
#define USB3_UNI_QSERDES_COM_VCO_TUNE2_MODE0			0x0114
#define USB3_UNI_QSERDES_COM_VCO_TUNE1_MODE1			0x0118
#define USB3_UNI_QSERDES_COM_VCO_TUNE2_MODE1			0x011C
#define USB3_UNI_QSERDES_COM_VCO_TUNE_INITVAL1			0x0120
#define USB3_UNI_QSERDES_COM_VCO_TUNE_INITVAL2			0x0124
#define USB3_UNI_QSERDES_COM_VCO_TUNE_MINVAL1			0x0128
#define USB3_UNI_QSERDES_COM_VCO_TUNE_MINVAL2			0x012C
#define USB3_UNI_QSERDES_COM_VCO_TUNE_MAXVAL1			0x0130
#define USB3_UNI_QSERDES_COM_VCO_TUNE_MAXVAL2			0x0134
#define USB3_UNI_QSERDES_COM_VCO_TUNE_TIMER1			0x0138
#define USB3_UNI_QSERDES_COM_VCO_TUNE_TIMER2			0x013C
#define USB3_UNI_QSERDES_COM_CMN_STATUS				0x0140
#define USB3_UNI_QSERDES_COM_RESET_SM_STATUS			0x0144
#define USB3_UNI_QSERDES_COM_RESTRIM_CODE_STATUS		0x0148
#define USB3_UNI_QSERDES_COM_PLLCAL_CODE1_STATUS		0x014C
#define USB3_UNI_QSERDES_COM_PLLCAL_CODE2_STATUS		0x0150
#define USB3_UNI_QSERDES_COM_CLK_SELECT				0x0154
#define USB3_UNI_QSERDES_COM_HSCLK_SEL				0x0158
#define USB3_UNI_QSERDES_COM_HSCLK_HS_SWITCH_SEL		0x015C
#define USB3_UNI_QSERDES_COM_INTEGLOOP_BINCODE_STATUS		0x0160
#define USB3_UNI_QSERDES_COM_PLL_ANALOG				0x0164
#define USB3_UNI_QSERDES_COM_CORECLK_DIV_MODE0			0x0168
#define USB3_UNI_QSERDES_COM_CORECLK_DIV_MODE1			0x016C
#define USB3_UNI_QSERDES_COM_SW_RESET				0x0170
#define USB3_UNI_QSERDES_COM_CORE_CLK_EN			0x0174
#define USB3_UNI_QSERDES_COM_C_READY_STATUS			0x0178
#define USB3_UNI_QSERDES_COM_CMN_CONFIG				0x017C
#define USB3_UNI_QSERDES_COM_CMN_RATE_OVERRIDE			0x0180
#define USB3_UNI_QSERDES_COM_SVS_MODE_CLK_SEL			0x0184
#define USB3_UNI_QSERDES_COM_DEBUG_BUS0				0x0188
#define USB3_UNI_QSERDES_COM_DEBUG_BUS1				0x018C
#define USB3_UNI_QSERDES_COM_DEBUG_BUS2				0x0190
#define USB3_UNI_QSERDES_COM_DEBUG_BUS3				0x0194
#define USB3_UNI_QSERDES_COM_DEBUG_BUS_SEL			0x0198
#define USB3_UNI_QSERDES_COM_CMN_MISC1				0x019C
#define USB3_UNI_QSERDES_COM_CMN_MODE				0x01A0
#define USB3_UNI_QSERDES_COM_CMN_MODE_CONTD			0x01A4
#define USB3_UNI_QSERDES_COM_VCO_DC_LEVEL_CTRL			0x01A8
#define USB3_UNI_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE0		0x01AC
#define USB3_UNI_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE0		0x01B0
#define USB3_UNI_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE1		0x01B4
#define USB3_UNI_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE1		0x01B8
#define USB3_UNI_QSERDES_COM_BIN_VCOCAL_HSCLK_SEL		0x01BC
#define USB3_UNI_QSERDES_COM_RESERVED_1				0x01C0
#define USB3_UNI_QSERDES_COM_MODE_OPERATION_STATUS		0x01C4


/* Module: USB3_UNI_PHY_QSERDES_TX_PCIE_USB3_UNI_QMP_TX */
#define USB3_UNI_QSERDES_TX_BIST_MODE_LANENO			0x0E00
#define USB3_UNI_QSERDES_TX_BIST_INVERT				0x0E04
#define USB3_UNI_QSERDES_TX_CLKBUF_ENABLE			0x0E08
#define USB3_UNI_QSERDES_TX_TX_EMP_POST1_LVL			0x0E0C
#define USB3_UNI_QSERDES_TX_TX_IDLE_LVL_LARGE_AMP		0x0E10
#define USB3_UNI_QSERDES_TX_TX_DRV_LVL				0x0E14
#define USB3_UNI_QSERDES_TX_TX_DRV_LVL_OFFSET			0x0E18
#define USB3_UNI_QSERDES_TX_RESET_TSYNC_EN			0x0E1C
#define USB3_UNI_QSERDES_TX_PRE_STALL_LDO_BOOST_EN		0x0E20
#define USB3_UNI_QSERDES_TX_TX_BAND				0x0E24
#define USB3_UNI_QSERDES_TX_SLEW_CNTL				0x0E28
#define USB3_UNI_QSERDES_TX_INTERFACE_SELECT			0x0E2C
#define USB3_UNI_QSERDES_TX_LPB_EN				0x0E30
#define USB3_UNI_QSERDES_TX_RES_CODE_LANE_TX			0x0E34
#define USB3_UNI_QSERDES_TX_RES_CODE_LANE_RX			0x0E38
#define USB3_UNI_QSERDES_TX_RES_CODE_LANE_OFFSET_TX		0x0E3C
#define USB3_UNI_QSERDES_TX_RES_CODE_LANE_OFFSET_RX		0x0E40
#define USB3_UNI_QSERDES_TX_PERL_LENGTH1			0x0E44
#define USB3_UNI_QSERDES_TX_PERL_LENGTH2			0x0E48
#define USB3_UNI_QSERDES_TX_SERDES_BYP_EN_OUT			0x0E4C
#define USB3_UNI_QSERDES_TX_DEBUG_BUS_SEL			0x0E50
#define USB3_UNI_QSERDES_TX_TRANSCEIVER_BIAS_EN			0x0E54
#define USB3_UNI_QSERDES_TX_HIGHZ_DRVR_EN			0x0E58
#define USB3_UNI_QSERDES_TX_TX_POL_INV				0x0E5C
#define USB3_UNI_QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN		0x0E60
#define USB3_UNI_QSERDES_TX_BIST_PATTERN1			0x0E64
#define USB3_UNI_QSERDES_TX_BIST_PATTERN2			0x0E68
#define USB3_UNI_QSERDES_TX_BIST_PATTERN3			0x0E6C
#define USB3_UNI_QSERDES_TX_BIST_PATTERN4			0x0E70
#define USB3_UNI_QSERDES_TX_BIST_PATTERN5			0x0E74
#define USB3_UNI_QSERDES_TX_BIST_PATTERN6			0x0E78
#define USB3_UNI_QSERDES_TX_BIST_PATTERN7			0x0E7C
#define USB3_UNI_QSERDES_TX_BIST_PATTERN8			0x0E80
#define USB3_UNI_QSERDES_TX_LANE_MODE_1				0x0E84
#define USB3_UNI_QSERDES_TX_LANE_MODE_2				0x0E88
#define USB3_UNI_QSERDES_TX_LANE_MODE_3				0x0E8C
#define USB3_UNI_QSERDES_TX_LANE_MODE_4				0x0E90
#define USB3_UNI_QSERDES_TX_LANE_MODE_5				0x0E94
#define USB3_UNI_QSERDES_TX_ATB_SEL1				0x0E98
#define USB3_UNI_QSERDES_TX_ATB_SEL2				0x0E9C
#define USB3_UNI_QSERDES_TX_RCV_DETECT_LVL			0x0EA0
#define USB3_UNI_QSERDES_TX_RCV_DETECT_LVL_2			0x0EA4
#define USB3_UNI_QSERDES_TX_PRBS_SEED1				0x0EA8
#define USB3_UNI_QSERDES_TX_PRBS_SEED2				0x0EAC
#define USB3_UNI_QSERDES_TX_PRBS_SEED3				0x0EB0
#define USB3_UNI_QSERDES_TX_PRBS_SEED4				0x0EB4
#define USB3_UNI_QSERDES_TX_RESET_GEN				0x0EB8
#define USB3_UNI_QSERDES_TX_RESET_GEN_MUXES			0x0EBC
#define USB3_UNI_QSERDES_TX_TRAN_DRVR_EMP_EN			0x0EC0
#define USB3_UNI_QSERDES_TX_TX_INTERFACE_MODE			0x0EC4
#define USB3_UNI_QSERDES_TX_VMODE_CTRL1				0x0EC8
#define USB3_UNI_QSERDES_TX_ALOG_OBSV_BUS_CTRL_1		0x0ECC
#define USB3_UNI_QSERDES_TX_BIST_STATUS				0x0ED0
#define USB3_UNI_QSERDES_TX_BIST_ERROR_COUNT1			0x0ED4
#define USB3_UNI_QSERDES_TX_BIST_ERROR_COUNT2			0x0ED8
#define USB3_UNI_QSERDES_TX_ALOG_OBSV_BUS_STATUS_1		0x0EDC
#define USB3_UNI_QSERDES_TX_LANE_DIG_CONFIG			0x0EE0
#define USB3_UNI_QSERDES_TX_PI_QEC_CTRL				0x0EE4
#define USB3_UNI_QSERDES_TX_PRE_EMPH				0x0EE8
#define USB3_UNI_QSERDES_TX_SW_RESET				0x0EEC
#define USB3_UNI_QSERDES_TX_DCC_OFFSET				0x0EF0
#define USB3_UNI_QSERDES_TX_DCC_CMUX_POSTCAL_OFFSET		0x0EF4
#define USB3_UNI_QSERDES_TX_DCC_CMUX_CAL_CTRL1			0x0EF8
#define USB3_UNI_QSERDES_TX_DCC_CMUX_CAL_CTRL2			0x0EFC
#define USB3_UNI_QSERDES_TX_DIG_BKUP_CTRL			0x0F00
#define USB3_UNI_QSERDES_TX_DEBUG_BUS0				0x0F04
#define USB3_UNI_QSERDES_TX_DEBUG_BUS1				0x0F08
#define USB3_UNI_QSERDES_TX_DEBUG_BUS2				0x0F0C
#define USB3_UNI_QSERDES_TX_DEBUG_BUS3				0x0F10
#define USB3_UNI_QSERDES_TX_READ_EQCODE				0x0F14
#define USB3_UNI_QSERDES_TX_READ_OFFSETCODE			0x0F18
#define USB3_UNI_QSERDES_TX_IA_ERROR_COUNTER_LOW		0x0F1C
#define USB3_UNI_QSERDES_TX_IA_ERROR_COUNTER_HIGH		0x0F20
#define USB3_UNI_QSERDES_TX_VGA_READ_CODE			0x0F24
#define USB3_UNI_QSERDES_TX_VTH_READ_CODE			0x0F28
#define USB3_UNI_QSERDES_TX_DFE_TAP1_READ_CODE			0x0F2C
#define USB3_UNI_QSERDES_TX_DFE_TAP2_READ_CODE			0x0F30
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_I			0x0F34
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_IBAR			0x0F38
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_Q			0x0F3C
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_QBAR			0x0F40
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_A			0x0F44
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_ABAR			0x0F48
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_SM_ON			0x0F4C
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_CAL_DONE		0x0F50
#define USB3_UNI_QSERDES_TX_IDAC_STATUS_SIGNERROR		0x0F54
#define USB3_UNI_QSERDES_TX_DCC_CAL_STATUS			0x0F58
#define USB3_UNI_QSERDES_TX_DCC_READ_CODE_STATUS		0x0F5C

/* Module: USB3_UNI_PHY_QSERDES_RX_QSERDES_RX_PCIE_USB3_UNI_QMP_RX */
#define USB3_UNI_QSERDES_RX_UCDR_FO_GAIN_HALF			0x1000
#define USB3_UNI_QSERDES_RX_UCDR_FO_GAIN_QUARTER		0x1004
#define USB3_UNI_QSERDES_RX_UCDR_FO_GAIN			0x1008
#define USB3_UNI_QSERDES_RX_UCDR_SO_GAIN_HALF			0x100C
#define USB3_UNI_QSERDES_RX_UCDR_SO_GAIN_QUARTER		0x1010
#define USB3_UNI_QSERDES_RX_UCDR_SO_GAIN			0x1014
#define USB3_UNI_QSERDES_RX_UCDR_SVS_FO_GAIN_HALF		0x1018
#define USB3_UNI_QSERDES_RX_UCDR_SVS_FO_GAIN_QUARTER		0x101C
#define USB3_UNI_QSERDES_RX_UCDR_SVS_FO_GAIN			0x1020
#define USB3_UNI_QSERDES_RX_UCDR_SVS_SO_GAIN_HALF		0x1024
#define USB3_UNI_QSERDES_RX_UCDR_SVS_SO_GAIN_QUARTER		0x1028
#define USB3_UNI_QSERDES_RX_UCDR_SVS_SO_GAIN			0x102C
#define USB3_UNI_QSERDES_RX_UCDR_FASTLOCK_FO_GAIN		0x1030
#define USB3_UNI_QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE	0x1034
#define USB3_UNI_QSERDES_RX_UCDR_FO_TO_SO_DELAY			0x1038
#define USB3_UNI_QSERDES_RX_UCDR_FASTLOCK_COUNT_LOW		0x103C
#define USB3_UNI_QSERDES_RX_UCDR_FASTLOCK_COUNT_HIGH		0x1040
#define USB3_UNI_QSERDES_RX_UCDR_PI_CONTROLS			0x1044
#define USB3_UNI_QSERDES_RX_UCDR_PI_CTRL2			0x1048
#define USB3_UNI_QSERDES_RX_UCDR_SB2_THRESH1			0x104C
#define USB3_UNI_QSERDES_RX_UCDR_SB2_THRESH2			0x1050
#define USB3_UNI_QSERDES_RX_UCDR_SB2_GAIN1			0x1054
#define USB3_UNI_QSERDES_RX_UCDR_SB2_GAIN2			0x1058
#define USB3_UNI_QSERDES_RX_AUX_CONTROL				0x105C
#define USB3_UNI_QSERDES_RX_AUX_DATA_TCOARSE_TFINE		0x1060
#define USB3_UNI_QSERDES_RX_RCLK_AUXDATA_SEL			0x1064
#define USB3_UNI_QSERDES_RX_AC_JTAG_ENABLE			0x1068
#define USB3_UNI_QSERDES_RX_AC_JTAG_INITP			0x106C
#define USB3_UNI_QSERDES_RX_AC_JTAG_INITN			0x1070
#define USB3_UNI_QSERDES_RX_AC_JTAG_LVL				0x1074
#define USB3_UNI_QSERDES_RX_AC_JTAG_MODE			0x1078
#define USB3_UNI_QSERDES_RX_AC_JTAG_RESET			0x107C
#define USB3_UNI_QSERDES_RX_RX_TERM_BW				0x1080
#define USB3_UNI_QSERDES_RX_RX_RCVR_IQ_EN			0x1084
#define USB3_UNI_QSERDES_RX_RX_IDAC_I_DC_OFFSETS		0x1088
#define USB3_UNI_QSERDES_RX_RX_IDAC_IBAR_DC_OFFSETS		0x108C
#define USB3_UNI_QSERDES_RX_RX_IDAC_Q_DC_OFFSETS		0x1090
#define USB3_UNI_QSERDES_RX_RX_IDAC_QBAR_DC_OFFSETS		0x1094
#define USB3_UNI_QSERDES_RX_RX_IDAC_A_DC_OFFSETS		0x1098
#define USB3_UNI_QSERDES_RX_RX_IDAC_ABAR_DC_OFFSETS		0x109C
#define USB3_UNI_QSERDES_RX_RX_IDAC_EN				0x10A0
#define USB3_UNI_QSERDES_RX_RX_IDAC_ENABLES			0x10A4
#define USB3_UNI_QSERDES_RX_RX_IDAC_SIGN			0x10A8
#define USB3_UNI_QSERDES_RX_RX_HIGHZ_HIGHRATE			0x10AC
#define USB3_UNI_QSERDES_RX_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x10B0
#define USB3_UNI_QSERDES_RX_DFE_1				0x10B4
#define USB3_UNI_QSERDES_RX_DFE_2				0x10B8
#define USB3_UNI_QSERDES_RX_DFE_3				0x10BC
#define USB3_UNI_QSERDES_RX_DFE_4				0x10C0
#define USB3_UNI_QSERDES_RX_TX_ADAPT_PRE_THRESH1		0x10C4
#define USB3_UNI_QSERDES_RX_TX_ADAPT_PRE_THRESH2		0x10C8
#define USB3_UNI_QSERDES_RX_TX_ADAPT_POST_THRESH		0x10CC
#define USB3_UNI_QSERDES_RX_TX_ADAPT_MAIN_THRESH		0x10D0
#define USB3_UNI_QSERDES_RX_VGA_CAL_CNTRL1			0x10D4
#define USB3_UNI_QSERDES_RX_VGA_CAL_CNTRL2			0x10D8
#define USB3_UNI_QSERDES_RX_GM_CAL				0x10DC
#define USB3_UNI_QSERDES_RX_RX_VGA_GAIN2_LSB			0x10E0
#define USB3_UNI_QSERDES_RX_RX_VGA_GAIN2_MSB			0x10E4
#define USB3_UNI_QSERDES_RX_RX_EQU_ADAPTOR_CNTRL1		0x10E8
#define USB3_UNI_QSERDES_RX_RX_EQU_ADAPTOR_CNTRL2		0x10EC
#define USB3_UNI_QSERDES_RX_RX_EQU_ADAPTOR_CNTRL3		0x10F0
#define USB3_UNI_QSERDES_RX_RX_EQU_ADAPTOR_CNTRL4		0x10F4
#define USB3_UNI_QSERDES_RX_RX_IDAC_TSETTLE_LOW			0x10F8
#define USB3_UNI_QSERDES_RX_RX_IDAC_TSETTLE_HIGH		0x10FC
#define USB3_UNI_QSERDES_RX_RX_IDAC_MEASURE_TIME		0x1100
#define USB3_UNI_QSERDES_RX_RX_IDAC_ACCUMULATOR			0x1104
#define USB3_UNI_QSERDES_RX_RX_EQ_OFFSET_LSB			0x1108
#define USB3_UNI_QSERDES_RX_RX_EQ_OFFSET_MSB			0x110C
#define USB3_UNI_QSERDES_RX_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1110
#define USB3_UNI_QSERDES_RX_RX_OFFSET_ADAPTOR_CNTRL2		0x1114
#define USB3_UNI_QSERDES_RX_SIGDET_ENABLES			0x1118
#define USB3_UNI_QSERDES_RX_SIGDET_CNTRL			0x111C
#define USB3_UNI_QSERDES_RX_SIGDET_LVL				0x1120
#define USB3_UNI_QSERDES_RX_SIGDET_DEGLITCH_CNTRL		0x1124
#define USB3_UNI_QSERDES_RX_RX_BAND				0x1128
#define USB3_UNI_QSERDES_RX_CDR_FREEZE_UP_DN			0x112C
#define USB3_UNI_QSERDES_RX_CDR_RESET_OVERRIDE			0x1130
#define USB3_UNI_QSERDES_RX_RX_INTERFACE_MODE			0x1134
#define USB3_UNI_QSERDES_RX_JITTER_GEN_MODE			0x1138
#define USB3_UNI_QSERDES_RX_SJ_AMP1				0x113C
#define USB3_UNI_QSERDES_RX_SJ_AMP2				0x1140
#define USB3_UNI_QSERDES_RX_SJ_PER1				0x1144
#define USB3_UNI_QSERDES_RX_SJ_PER2				0x1148
#define USB3_UNI_QSERDES_RX_PPM_OFFSET1				0x114C
#define USB3_UNI_QSERDES_RX_PPM_OFFSET2				0x1150
#define USB3_UNI_QSERDES_RX_SIGN_PPM_PERIOD1			0x1154
#define USB3_UNI_QSERDES_RX_SIGN_PPM_PERIOD2			0x1158
#define USB3_UNI_QSERDES_RX_RX_MODE_00_LOW			0x115C
#define USB3_UNI_QSERDES_RX_RX_MODE_00_HIGH			0x1160
#define USB3_UNI_QSERDES_RX_RX_MODE_00_HIGH2			0x1164
#define USB3_UNI_QSERDES_RX_RX_MODE_00_HIGH3			0x1168
#define USB3_UNI_QSERDES_RX_RX_MODE_00_HIGH4			0x116C
#define USB3_UNI_QSERDES_RX_RX_MODE_01_LOW			0x1170
#define USB3_UNI_QSERDES_RX_RX_MODE_01_HIGH			0x1174
#define USB3_UNI_QSERDES_RX_RX_MODE_01_HIGH2			0x1178
#define USB3_UNI_QSERDES_RX_RX_MODE_01_HIGH3			0x117C
#define USB3_UNI_QSERDES_RX_RX_MODE_01_HIGH4			0x1180
#define USB3_UNI_QSERDES_RX_RX_MODE_10_LOW			0x1184
#define USB3_UNI_QSERDES_RX_RX_MODE_10_HIGH			0x1188
#define USB3_UNI_QSERDES_RX_RX_MODE_10_HIGH2			0x118C
#define USB3_UNI_QSERDES_RX_RX_MODE_10_HIGH3			0x1190
#define USB3_UNI_QSERDES_RX_RX_MODE_10_HIGH4			0x1194
#define USB3_UNI_QSERDES_RX_PHPRE_CTRL				0x1198
#define USB3_UNI_QSERDES_RX_PHPRE_INITVAL			0x119C
#define USB3_UNI_QSERDES_RX_DFE_EN_TIMER			0x11A0
#define USB3_UNI_QSERDES_RX_DFE_CTLE_POST_CAL_OFFSET		0x11A4
#define USB3_UNI_QSERDES_RX_DCC_CTRL1				0x11A8
#define USB3_UNI_QSERDES_RX_DCC_CTRL2				0x11AC
#define USB3_UNI_QSERDES_RX_VTH_CODE				0x11B0
#define USB3_UNI_QSERDES_RX_VTH_MIN_THRESH			0x11B4
#define USB3_UNI_QSERDES_RX_VTH_MAX_THRESH			0x11B8
#define USB3_UNI_QSERDES_RX_ALOG_OBSV_BUS_CTRL_1		0x11BC
#define USB3_UNI_QSERDES_RX_PI_CTRL1				0x11C0
#define USB3_UNI_QSERDES_RX_PI_CTRL2				0x11C4
#define USB3_UNI_QSERDES_RX_PI_QUAD				0x11C8
#define USB3_UNI_QSERDES_RX_IDATA1				0x11CC
#define USB3_UNI_QSERDES_RX_IDATA2				0x11D0
#define USB3_UNI_QSERDES_RX_AUX_DATA1				0x11D4
#define USB3_UNI_QSERDES_RX_AUX_DATA2				0x11D8
#define USB3_UNI_QSERDES_RX_AC_JTAG_OUTP			0x11DC
#define USB3_UNI_QSERDES_RX_AC_JTAG_OUTN			0x11E0
#define USB3_UNI_QSERDES_RX_RX_SIGDET				0x11E4
#define USB3_UNI_QSERDES_RX_ALOG_OBSV_BUS_STATUS_1		0x11E8

/* Module:  USB3_UNI_PCS_LN_PCIE_USB3_UNI_PCS_LANE */
#define USB3_UNI_PCS_LN_PCS_STATUS1				0x0A00
#define USB3_UNI_PCS_LN_PCS_STATUS2				0x0A04
#define USB3_UNI_PCS_LN_PCS_STATUS2_CLEAR			0x0A08
#define USB3_UNI_PCS_LN_PCS_STATUS3				0x0A0C
#define USB3_UNI_PCS_LN_BIST_CHK_ERR_CNT_L_STATUS		0x0A10
#define USB3_UNI_PCS_LN_BIST_CHK_ERR_CNT_H_STATUS		0x0A14
#define USB3_UNI_PCS_LN_BIST_CHK_STATUS				0x0A18
#define USB3_UNI_PCS_LN_INSIG_SW_CTRL1				0x0A1C
#define USB3_UNI_PCS_LN_INSIG_MX_CTRL1				0x0A20
#define USB3_UNI_PCS_LN_OUTSIG_SW_CTRL1				0x0A24
#define USB3_UNI_PCS_LN_OUTSIG_MX_CTRL1				0x0A28
#define USB3_UNI_PCS_LN_TEST_CONTROL1				0x0A2C
#define USB3_UNI_PCS_LN_BIST_CTRL				0x0A30
#define USB3_UNI_PCS_LN_PRBS_SEED0				0x0A34
#define USB3_UNI_PCS_LN_PRBS_SEED1				0x0A38
#define USB3_UNI_PCS_LN_FIXED_PAT_CTRL				0x0A3C
#define USB3_UNI_PCS_LN_EQ_CONFIG				0x0A40
#define USB3_UNI_PCS_LN_TEST_CONTROL2				0x0A44
#define USB3_UNI_PCS_LN_TEST_CONTROL3				0x0A48

/* Module: USB3_UNI_PCS_PCIE_LN_PCIE_USB3_UNI_PCS_PCIE_LANE */
#define USB3_UNI_PCS_PCIE_LN_PRESET_OVERRIDE_PRE_POST		0x0C00
#define USB3_UNI_PCS_PCIE_LN_PRESET_OVERRIDE_PRE_POST_RS	0x0C04
#define USB3_UNI_PCS_PCIE_LN_PRESET_OVERRIDE_EN			0x0C08
#define USB3_UNI_PCS_PCIE_LN_PRESET_DSBL_L			0x0C0C
#define USB3_UNI_PCS_PCIE_LN_PRESET_DSBL_H			0x0C10
#define USB3_UNI_PCS_PCIE_LN_LANE_OFF_CONFIG			0x0C14
#define USB3_UNI_PCS_PCIE_LN_RXEQ_DONE_CONFIG1			0x0C18
#define USB3_UNI_PCS_PCIE_LN_RXEQ_DONE_CONFIG2			0x0C1C
#define USB3_UNI_PCS_PCIE_LN_PCIE_PCS_STATUS			0x0C20
#define USB3_UNI_PCS_PCIE_LN_INSIG_SW_CTRL2			0x0C24
#define USB3_UNI_PCS_PCIE_LN_INSIG_MX_CTRL2			0x0C28

/* Module: USB3_UNI_PHY_PCIE_USB3_UNI_PCS_PCIE_USB3_UNI_PCS_PCIE_USB3_UNI_PCS */
#define USB3_UNI_PCS_SW_RESET					0x0200
#define USB3_UNI_PCS_REVISION_ID0				0x0204
#define USB3_UNI_PCS_REVISION_ID1				0x0208
#define USB3_UNI_PCS_REVISION_ID2				0x020C
#define USB3_UNI_PCS_REVISION_ID3				0x0210
#define USB3_UNI_PCS_PCS_STATUS1				0x0214
#define USB3_UNI_PCS_PCS_STATUS2				0x0218
#define USB3_UNI_PCS_PCS_STATUS3				0x021C
#define USB3_UNI_PCS_PCS_STATUS4				0x0220
#define USB3_UNI_PCS_PCS_STATUS5				0x0224
#define USB3_UNI_PCS_PCS_STATUS6				0x0228
#define USB3_UNI_PCS_PCS_STATUS7				0x022C
#define USB3_UNI_PCS_DEBUG_BUS_0_STATUS				0x0230
#define USB3_UNI_PCS_DEBUG_BUS_1_STATUS				0x0234
#define USB3_UNI_PCS_DEBUG_BUS_2_STATUS				0x0238
#define USB3_UNI_PCS_DEBUG_BUS_3_STATUS				0x023C
#define USB3_UNI_PCS_POWER_DOWN_CONTROL				0x0240
#define USB3_UNI_PCS_START_CONTROL				0x0244
#define USB3_UNI_PCS_INSIG_SW_CTRL1				0x0248
#define USB3_UNI_PCS_INSIG_SW_CTRL2				0x024C
#define USB3_UNI_PCS_INSIG_SW_CTRL3				0x0250
#define USB3_UNI_PCS_INSIG_SW_CTRL4				0x0254
#define USB3_UNI_PCS_INSIG_SW_CTRL5				0x0258
#define USB3_UNI_PCS_INSIG_SW_CTRL6				0x025C
#define USB3_UNI_PCS_INSIG_SW_CTRL7				0x0260
#define USB3_UNI_PCS_INSIG_SW_CTRL8				0x0264
#define USB3_UNI_PCS_INSIG_MX_CTRL1				0x0268
#define USB3_UNI_PCS_INSIG_MX_CTRL2				0x026C
#define USB3_UNI_PCS_INSIG_MX_CTRL3				0x0270
#define USB3_UNI_PCS_INSIG_MX_CTRL4				0x0274
#define USB3_UNI_PCS_INSIG_MX_CTRL5				0x0278
#define USB3_UNI_PCS_INSIG_MX_CTRL7				0x027C
#define USB3_UNI_PCS_INSIG_MX_CTRL8				0x0280
#define USB3_UNI_PCS_OUTSIG_SW_CTRL1				0x0284
#define USB3_UNI_PCS_OUTSIG_MX_CTRL1				0x0288
#define USB3_UNI_PCS_CLAMP_ENABLE				0x028C
#define USB3_UNI_PCS_POWER_STATE_CONFIG1			0x0290
#define USB3_UNI_PCS_POWER_STATE_CONFIG2			0x0294
#define USB3_UNI_PCS_FLL_CNTRL1					0x0298
#define USB3_UNI_PCS_FLL_CNTRL2					0x029C
#define USB3_UNI_PCS_FLL_CNT_VAL_L				0x02A0
#define USB3_UNI_PCS_FLL_CNT_VAL_H_TOL				0x02A4
#define USB3_UNI_PCS_FLL_MAN_CODE				0x02A8
#define USB3_UNI_PCS_TEST_CONTROL1				0x02AC
#define USB3_UNI_PCS_TEST_CONTROL2				0x02B0
#define USB3_UNI_PCS_TEST_CONTROL3				0x02B4
#define USB3_UNI_PCS_TEST_CONTROL4				0x02B8
#define USB3_UNI_PCS_TEST_CONTROL5				0x02BC
#define USB3_UNI_PCS_TEST_CONTROL6				0x02C0
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG1			0x02C4
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG2			0x02C8
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG3			0x02CC
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG4			0x02D0
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG5			0x02D4
#define USB3_UNI_PCS_LOCK_DETECT_CONFIG6			0x02D8
#define USB3_UNI_PCS_REFGEN_REQ_CONFIG1				0x02DC
#define USB3_UNI_PCS_REFGEN_REQ_CONFIG2				0x02E0
#define USB3_UNI_PCS_REFGEN_REQ_CONFIG3				0x02E4
#define USB3_UNI_PCS_BIST_CTRL					0x02E8
#define USB3_UNI_PCS_PRBS_POLY0					0x02EC
#define USB3_UNI_PCS_PRBS_POLY1					0x02F0
#define USB3_UNI_PCS_FIXED_PAT0					0x02F4
#define USB3_UNI_PCS_FIXED_PAT1					0x02F8
#define USB3_UNI_PCS_FIXED_PAT2					0x02FC
#define USB3_UNI_PCS_FIXED_PAT3					0x0300
#define USB3_UNI_PCS_FIXED_PAT4					0x0304
#define USB3_UNI_PCS_FIXED_PAT5					0x0308
#define USB3_UNI_PCS_FIXED_PAT6					0x030C
#define USB3_UNI_PCS_FIXED_PAT7					0x0310
#define USB3_UNI_PCS_FIXED_PAT8					0x0314
#define USB3_UNI_PCS_FIXED_PAT9					0x0318
#define USB3_UNI_PCS_FIXED_PAT10				0x031C
#define USB3_UNI_PCS_FIXED_PAT11				0x0320
#define USB3_UNI_PCS_FIXED_PAT12				0x0324
#define USB3_UNI_PCS_FIXED_PAT13				0x0328
#define USB3_UNI_PCS_FIXED_PAT14				0x032C
#define USB3_UNI_PCS_FIXED_PAT15				0x0330
#define USB3_UNI_PCS_TXMGN_CONFIG				0x0334
#define USB3_UNI_PCS_G12S1_TXMGN_V0				0x0338
#define USB3_UNI_PCS_G12S1_TXMGN_V1				0x033C
#define USB3_UNI_PCS_G12S1_TXMGN_V2				0x0340
#define USB3_UNI_PCS_G12S1_TXMGN_V3				0x0344
#define USB3_UNI_PCS_G12S1_TXMGN_V4				0x0348
#define USB3_UNI_PCS_G12S1_TXMGN_V0_RS				0x034C
#define USB3_UNI_PCS_G12S1_TXMGN_V1_RS				0x0350
#define USB3_UNI_PCS_G12S1_TXMGN_V2_RS				0x0354
#define USB3_UNI_PCS_G12S1_TXMGN_V3_RS				0x0358
#define USB3_UNI_PCS_G12S1_TXMGN_V4_RS				0x035C
#define USB3_UNI_PCS_G3S2_TXMGN_MAIN				0x0360
#define USB3_UNI_PCS_G3S2_TXMGN_MAIN_RS				0x0364
#define USB3_UNI_PCS_G12S1_TXDEEMPH_M6DB			0x0368
#define USB3_UNI_PCS_G12S1_TXDEEMPH_M3P5DB			0x036C
#define USB3_UNI_PCS_G3S2_PRE_GAIN				0x0370
#define USB3_UNI_PCS_G3S2_POST_GAIN				0x0374
#define USB3_UNI_PCS_G3S2_PRE_POST_OFFSET			0x0378
#define USB3_UNI_PCS_G3S2_PRE_GAIN_RS				0x037C
#define USB3_UNI_PCS_G3S2_POST_GAIN_RS				0x0380
#define USB3_UNI_PCS_G3S2_PRE_POST_OFFSET_RS			0x0384
#define USB3_UNI_PCS_RX_SIGDET_LVL				0x0388
#define USB3_UNI_PCS_RX_SIGDET_DTCT_CNTRL			0x038C
#define USB3_UNI_PCS_RCVR_DTCT_DLY_P1U2_L			0x0390
#define USB3_UNI_PCS_RCVR_DTCT_DLY_P1U2_H			0x0394
#define USB3_UNI_PCS_RATE_SLEW_CNTRL1				0x0398
#define USB3_UNI_PCS_RATE_SLEW_CNTRL2				0x039C
#define USB3_UNI_PCS_PWRUP_RESET_DLY_TIME_AUXCLK		0x03A0
#define USB3_UNI_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_L		0x03A4
#define USB3_UNI_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_H		0x03A8
#define USB3_UNI_PCS_TSYNC_RSYNC_TIME				0x03AC
#define USB3_UNI_PCS_CDR_RESET_TIME				0x03B0
#define USB3_UNI_PCS_TSYNC_DLY_TIME				0x03B4
#define USB3_UNI_PCS_ELECIDLE_DLY_SEL				0x03B8
#define USB3_UNI_PCS_CMN_ACK_OUT_SEL				0x03BC
#define USB3_UNI_PCS_ALIGN_DETECT_CONFIG1			0x03C0
#define USB3_UNI_PCS_ALIGN_DETECT_CONFIG2			0x03C4
#define USB3_UNI_PCS_ALIGN_DETECT_CONFIG3			0x03C8
#define USB3_UNI_PCS_ALIGN_DETECT_CONFIG4			0x03CC
#define USB3_UNI_PCS_PCS_TX_RX_CONFIG				0x03D0
#define USB3_UNI_PCS_RX_IDLE_DTCT_CNTRL				0x03D4
#define USB3_UNI_PCS_RX_DCC_CAL_CONFIG				0x03D8
#define USB3_UNI_PCS_EQ_CONFIG1					0x03DC
#define USB3_UNI_PCS_EQ_CONFIG2					0x03E0
#define USB3_UNI_PCS_EQ_CONFIG3					0x03E4
#define USB3_UNI_PCS_EQ_CONFIG4					0x03E8
#define USB3_UNI_PCS_EQ_CONFIG5					0x03EC

/* Module: USB3_UNI_PHY_PCIE_PCS */
#define USB3_UNI_PCS_PCIE_INT_AUX_CLK_STATUS			0x0600
#define USB3_UNI_PCS_PCIE_OSC_DTCT_STATUS			0x0604
#define USB3_UNI_PCS_PCIE_POWER_STATE_CONFIG1			0x0608
#define USB3_UNI_PCS_PCIE_POWER_STATE_CONFIG2			0x060C
#define USB3_UNI_PCS_PCIE_POWER_STATE_CONFIG3			0x0610
#define USB3_UNI_PCS_PCIE_POWER_STATE_CONFIG4			0x0614
#define USB3_UNI_PCS_PCIE_POWER_STATE_CONFIG5			0x0618
#define USB3_UNI_PCS_PCIE_PCS_TX_RX_CONFIG			0x061C
#define USB3_UNI_PCS_PCIE_ENDPOINT_REFCLK_DRIVE			0x0620
#define USB3_UNI_PCS_PCIE_ENDPOINT_REFCLK_CNTRL			0x0624
#define USB3_UNI_PCS_PCIE_EPCLK_PRE_PLL_LOCK_DLY_AUXCLK		0x0628
#define USB3_UNI_PCS_PCIE_EPCLK_DLY_COUNT_VAL_L			0x062C
#define USB3_UNI_PCS_PCIE_EPCLK_DLY_COUNT_VAL_H			0x0630
#define USB3_UNI_PCS_PCIE_RX_IDLE_DTCT_CNTRL1			0x0634
#define USB3_UNI_PCS_PCIE_RX_IDLE_DTCT_CNTRL2			0x0638
#define USB3_UNI_PCS_PCIE_SIGDET_CNTRL				0x063C
#define USB3_UNI_PCS_PCIE_SIGDET_LOW_2_IDLE_TIME		0x0640
#define USB3_UNI_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_L		0x0644
#define USB3_UNI_PCS_PCIE_L1P1_WAKEUP_DLY_TIME_AUXCLK_H		0x0648
#define USB3_UNI_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_L		0x064C
#define USB3_UNI_PCS_PCIE_L1P2_WAKEUP_DLY_TIME_AUXCLK_H		0x0650
#define USB3_UNI_PCS_PCIE_INT_AUX_CLK_CONFIG1			0x0654
#define USB3_UNI_PCS_PCIE_INT_AUX_CLK_CONFIG2			0x0658
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG1			0x065C
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG2			0x0660
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG3			0x0664
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG4			0x0668
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG5			0x066C
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG6			0x0670
#define USB3_UNI_PCS_PCIE_OSC_DTCT_CONFIG7			0x0674
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG1		0x0678
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG2		0x067C
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG3		0x0680
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG4		0x0684
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG5		0x0688
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG6		0x068C
#define USB3_UNI_PCS_PCIE_OSC_DTCT_MODE2_CONFIG7		0x0690
#define USB3_UNI_PCS_PCIE_OSC_DTCT_ACTIONS			0x0694
#define USB3_UNI_PCS_PCIE_LOCAL_FS				0x0698
#define USB3_UNI_PCS_PCIE_LOCAL_LF				0x069C
#define USB3_UNI_PCS_PCIE_LOCAL_FS_RS				0x06A0
#define USB3_UNI_PCS_PCIE_EQ_CONFIG1				0x06A4
#define USB3_UNI_PCS_PCIE_EQ_CONFIG2				0x06A8
#define USB3_UNI_PCS_PCIE_PRESET_P0_P1_PRE			0x06AC
#define USB3_UNI_PCS_PCIE_PRESET_P2_P3_PRE			0x06B0
#define USB3_UNI_PCS_PCIE_PRESET_P4_P5_PRE			0x06B4
#define USB3_UNI_PCS_PCIE_PRESET_P6_P7_PRE			0x06B8
#define USB3_UNI_PCS_PCIE_PRESET_P8_P9_PRE			0x06BC
#define USB3_UNI_PCS_PCIE_PRESET_P10_PRE			0x06C0
#define USB3_UNI_PCS_PCIE_PRESET_P1_P3_PRE_RS			0x06C4
#define USB3_UNI_PCS_PCIE_PRESET_P4_P5_PRE_RS			0x06C8
#define USB3_UNI_PCS_PCIE_PRESET_P6_P9_PRE_RS			0x06CC
#define USB3_UNI_PCS_PCIE_PRESET_P0_P1_POST			0x06D0
#define USB3_UNI_PCS_PCIE_PRESET_P2_P3_POST			0x06D4
#define USB3_UNI_PCS_PCIE_PRESET_P4_P5_POST			0x06D8
#define USB3_UNI_PCS_PCIE_PRESET_P6_P7_POST			0x06DC
#define USB3_UNI_PCS_PCIE_PRESET_P8_P9_POST			0x06E0
#define USB3_UNI_PCS_PCIE_PRESET_P10_POST			0x06E4
#define USB3_UNI_PCS_PCIE_PRESET_P1_P3_POST_RS			0x06E8
#define USB3_UNI_PCS_PCIE_PRESET_P4_P5_POST_RS			0x06EC
#define USB3_UNI_PCS_PCIE_PRESET_P6_P9_POST_RS			0x06F0
#define USB3_UNI_PCS_PCIE_RXEQEVAL_TIME				0x06F4


/* Module: USB3_UNI_PHY_PCIE_PCS_DEBUG_INTGEN */
#define USB3_UNI_PCS_INTGEN_INTGEN_STATUS1			0x0800
#define USB3_UNI_PCS_INTGEN_INTGEN_STATUS2			0x0804
#define USB3_UNI_PCS_INTGEN_CONFIG1				0x0808
#define USB3_UNI_PCS_INTGEN_SIGNALBLK1_CONFIG1			0x080C
#define USB3_UNI_PCS_INTGEN_SIGNALBLK1_CONFIG2			0x0810
#define USB3_UNI_PCS_INTGEN_SIGNALBLK1_CONFIG3			0x0814
#define USB3_UNI_PCS_INTGEN_SIGNALBLK1_CONFIG4			0x0818
#define USB3_UNI_PCS_INTGEN_SIGNALBLK1_CONFIG5			0x081C
#define USB3_UNI_PCS_INTGEN_SIGNALBLK2_CONFIG1			0x0820
#define USB3_UNI_PCS_INTGEN_SIGNALBLK2_CONFIG2			0x0824
#define USB3_UNI_PCS_INTGEN_SIGNALBLK2_CONFIG3			0x0828
#define USB3_UNI_PCS_INTGEN_SIGNALBLK2_CONFIG4			0x082C
#define USB3_UNI_PCS_INTGEN_SIGNALBLK2_CONFIG5			0x0830
#define USB3_UNI_PCS_INTGEN_STRINGBLK1_CONFIG1			0x0834
#define USB3_UNI_PCS_INTGEN_STRINGBLK1_CONFIG2			0x0838
#define USB3_UNI_PCS_INTGEN_STRINGBLK1_CONFIG3			0x083C
#define USB3_UNI_PCS_INTGEN_STRINGBLK1_CONFIG4			0x0840
#define USB3_UNI_PCS_INTGEN_STRINGBLK1_CONFIG5			0x0844
#define USB3_UNI_PCS_INTGEN_STRINGBLK2_CONFIG1			0x0848
#define USB3_UNI_PCS_INTGEN_STRINGBLK2_CONFIG2			0x084C
#define USB3_UNI_PCS_INTGEN_STRINGBLK2_CONFIG3			0x0850
#define USB3_UNI_PCS_INTGEN_STRINGBLK2_CONFIG4			0x0854
#define USB3_UNI_PCS_INTGEN_STRINGBLK2_CONFIG5			0x0858


/* Module: USB3_UNI_PCS_USB3_PCIE_USB3_UNI_PCS_USB3 */
#define USB3_UNI_PCS_USB3_POWER_STATE_CONFIG1			0x1200
#define USB3_UNI_PCS_USB3_AUTONOMOUS_MODE_STATUS		0x1204
#define USB3_UNI_PCS_USB3_AUTONOMOUS_MODE_CTRL			0x1208
#define USB3_UNI_PCS_USB3_AUTONOMOUS_MODE_CTRL2			0x120C
#define USB3_UNI_PCS_USB3_LFPS_RXTERM_IRQ_SOURCE_STATUS		0x1210
#define USB3_UNI_PCS_USB3_LFPS_RXTERM_IRQ_CLEAR			0x1214
#define USB3_UNI_PCS_USB3_LFPS_DET_HIGH_COUNT_VAL		0x1218
#define USB3_UNI_PCS_USB3_LFPS_TX_ECSTART			0x121C
#define USB3_UNI_PCS_USB3_LFPS_PER_TIMER_VAL			0x1220
#define USB3_UNI_PCS_USB3_LFPS_TX_END_CNT_U3_START		0x1224
#define USB3_UNI_PCS_USB3_LFPS_CONFIG1				0x1228
#define USB3_UNI_PCS_USB3_RXEQTRAINING_LOCK_TIME		0x122C
#define USB3_UNI_PCS_USB3_RXEQTRAINING_WAIT_TIME		0x1230
#define USB3_UNI_PCS_USB3_RXEQTRAINING_CTLE_TIME		0x1234
#define USB3_UNI_PCS_USB3_RXEQTRAINING_WAIT_TIME_S2		0x1238
#define USB3_UNI_PCS_USB3_RXEQTRAINING_DFE_TIME_S2		0x123C
#define USB3_UNI_PCS_USB3_RCVR_DTCT_DLY_U3_L			0x1240
#define USB3_UNI_PCS_USB3_RCVR_DTCT_DLY_U3_H			0x1244
#define USB3_UNI_PCS_USB3_ARCVR_DTCT_EN_PERIOD			0x1248
#define USB3_UNI_PCS_USB3_ARCVR_DTCT_CM_DLY			0x124C
#define USB3_UNI_PCS_USB3_TXONESZEROS_RUN_LENGTH		0x1250
#define USB3_UNI_PCS_USB3_ALFPS_DEGLITCH_VAL			0x1254
#define USB3_UNI_PCS_USB3_SIGDET_STARTUP_TIMER_VAL		0x1258
#define USB3_UNI_PCS_USB3_TEST_CONTROL				0x125C
#define USB3_UNI_PCS_USB3_RXTERMINATION_DLY_SEL			0x1260

#endif /* _DT_BINDINGS_PHY_QCOM_5NM_QMP_UNI_USB_H */
