/* SPDX-License-Identifier: GPL-2.0 WITH Linux-syscall-note */
/*
 * sec Log
 */
#ifndef _SEC_LOG_H
#define _SEC_LOG_H
#define SECLOG			"[sec_input]"
#define INPUT_LOG_BUF_SIZE	512

#define input_dbg(mode, dev, fmt, ...)						\
({										\
	static char input_log_buf[INPUT_LOG_BUF_SIZE];				\
	snprintf(input_log_buf, sizeof(input_log_buf), "%s %s", SECLOG, fmt);	\
	dev_dbg(dev, input_log_buf, ## __VA_ARGS__);				\
})
#define input_info(mode, dev, fmt, ...)						\
({										\
	static char input_log_buf[INPUT_LOG_BUF_SIZE];				\
	snprintf(input_log_buf, sizeof(input_log_buf), "%s %s", SECLOG, fmt);	\
	dev_info(dev, input_log_buf, ## __VA_ARGS__);				\
})
#define input_err(mode, dev, fmt, ...)						\
({										\
	static char input_log_buf[INPUT_LOG_BUF_SIZE];				\
	snprintf(input_log_buf, sizeof(input_log_buf), "%s %s", SECLOG, fmt);	\
	dev_err(dev, input_log_buf, ## __VA_ARGS__);				\
})
#define input_raw_info(mode, dev, fmt, ...) input_info(mode, dev, fmt, ## __VA_ARGS__)
#define input_log_fix()	{}
#define input_raw_data_clear() {}
#endif /* _SEC_LOG_H */
