/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020 The Linux Foundation. All rights reserved.
 */

#ifndef __QTI_POWER_SUPPLY_H_
#define __QTI_POWER_SUPPLY_H_

#define QTI_POWER_SUPPLY_TYPE_USB_HVDCP		20
#define QTI_POWER_SUPPLY_TYPE_USB_HVDCP_3	21
#define QTI_POWER_SUPPLY_TYPE_USB_HVDCP_3P5	22
#define QTI_POWER_SUPPLY_TYPE_USB_FLOAT		23

enum {
	QTI_POWER_SUPPLY_CHARGER_SEC_NONE = 0,
	QTI_POWER_SUPPLY_CHARGER_SEC_CP,
	QTI_POWER_SUPPLY_CHARGER_SEC_PL,
	QTI_POWER_SUPPLY_CHARGER_SEC_CP_PL,
};

enum {
	QTI_POWER_SUPPLY_CP_NONE = 0,
	QTI_POWER_SUPPLY_CP_HVDCP3,
	QTI_POWER_SUPPLY_CP_HVDCP3P5,
	QTI_POWER_SUPPLY_CP_PPS,
	QTI_POWER_SUPPLY_CP_WIRELESS,
};

enum {
	QTI_POWER_SUPPLY_CONNECTOR_TYPEC,
	QTI_POWER_SUPPLY_CONNECTOR_MICRO_USB,
};

enum {
	QC_CTM_DISABLE = BIT(0),
	QC_THERMAL_BALANCE_DISABLE = BIT(1),
	QC_INOV_THERMAL_DISABLE = BIT(2),
};

enum {
	QTI_POWER_SUPPLY_PD_INACTIVE = 0,
	QTI_POWER_SUPPLY_PD_ACTIVE,
	QTI_POWER_SUPPLY_PD_PPS_ACTIVE,
};

enum {
	QTI_POWER_SUPPLY_DP_DM_UNKNOWN = 0,
	QTI_POWER_SUPPLY_DP_DM_PREPARE = 1,
	QTI_POWER_SUPPLY_DP_DM_UNPREPARE = 2,
	QTI_POWER_SUPPLY_DP_DM_CONFIRMED_HVDCP3 = 3,
	QTI_POWER_SUPPLY_DP_DM_DP_PULSE = 4,
	QTI_POWER_SUPPLY_DP_DM_DM_PULSE = 5,
	QTI_POWER_SUPPLY_DP_DM_DP0P6_DMF = 6,
	QTI_POWER_SUPPLY_DP_DM_DP0P6_DM3P3 = 7,
	QTI_POWER_SUPPLY_DP_DM_DPF_DMF = 8,
	QTI_POWER_SUPPLY_DP_DM_DPR_DMR = 9,
	QTI_POWER_SUPPLY_DP_DM_HVDCP3_SUPPORTED = 10,
	QTI_POWER_SUPPLY_DP_DM_ICL_DOWN = 11,
	QTI_POWER_SUPPLY_DP_DM_ICL_UP = 12,
	QTI_POWER_SUPPLY_DP_DM_FORCE_5V = 13,
	QTI_POWER_SUPPLY_DP_DM_FORCE_9V = 14,
	QTI_POWER_SUPPLY_DP_DM_FORCE_12V = 15,
	QTI_POWER_SUPPLY_DP_DM_CONFIRMED_HVDCP3P5 = 16,
};

/* Indicates USB Type-C CC connection status */
enum power_supply_typec_mode {
	QTI_POWER_SUPPLY_TYPEC_NONE,

	/* Acting as source */
	QTI_POWER_SUPPLY_TYPEC_SINK,		/* Rd only */
	QTI_POWER_SUPPLY_TYPEC_SINK_POWERED_CABLE,	/* Rd/Ra */
	QTI_POWER_SUPPLY_TYPEC_SINK_DEBUG_ACCESSORY,/* Rd/Rd */
	QTI_POWER_SUPPLY_TYPEC_SINK_AUDIO_ADAPTER,	/* Ra/Ra */
	QTI_POWER_SUPPLY_TYPEC_POWERED_CABLE_ONLY,	/* Ra only */

	/* Acting as sink */
	QTI_POWER_SUPPLY_TYPEC_SOURCE_DEFAULT,	/* Rp default */
	QTI_POWER_SUPPLY_TYPEC_SOURCE_MEDIUM,	/* Rp 1.5A */
	QTI_POWER_SUPPLY_TYPEC_SOURCE_HIGH,		/* Rp 3A */
	QTI_POWER_SUPPLY_TYPEC_NON_COMPLIANT,
};

enum power_supply_typec_src_rp {
	QTI_POWER_SUPPLY_TYPEC_SRC_RP_STD,
	QTI_POWER_SUPPLY_TYPEC_SRC_RP_1P5A,
	QTI_POWER_SUPPLY_TYPEC_SRC_RP_3A
};

/* Parallel output connection topology */
enum {
	QTI_POWER_SUPPLY_PL_OUTPUT_NONE,
	QTI_POWER_SUPPLY_PL_OUTPUT_VPH,
	QTI_POWER_SUPPLY_PL_OUTPUT_VBAT,
};

enum {
	QTI_POWER_SUPPLY_PL_NONE,
	QTI_POWER_SUPPLY_PL_USBIN_USBIN,
	QTI_POWER_SUPPLY_PL_USBIN_USBIN_EXT,
	QTI_POWER_SUPPLY_PL_USBMID_USBMID,
};

enum {
	QTI_POWER_SUPPLY_PL_STACKED_BATFET,
	QTI_POWER_SUPPLY_PL_NON_STACKED_BATFET,
};

enum power_supply_typec_power_role {
	QTI_POWER_SUPPLY_TYPEC_PR_NONE,		/* CC lines in high-Z */
	QTI_POWER_SUPPLY_TYPEC_PR_DUAL,
	QTI_POWER_SUPPLY_TYPEC_PR_SINK,
	QTI_POWER_SUPPLY_TYPEC_PR_SOURCE,
};

#endif /* __QTI_POWER_SUPPLY_H_ */
