/*
 * @Descripttion: Header file of AW87XXX_PID_59_5X9_REG
 * @version: V1.33
 * @Author: zhaozhongbo
 * @Date: 2021-03-10
 * @LastEditors: Please set LastEditors
 * @LastEditTime: 2021-03-10
 */
#ifndef __AW87XXX_PID_59_5X9_REG_H__
#define __AW87XXX_PID_59_5X9_REG_H__


#define AW87XXX_PID_59_5X9_REG_CHIPID		(0x00)
#define AW87XXX_PID_59_5X9_REG_SYSCTRL		(0x01)
#define AW87XXX_PID_59_5X9_REG_BATSAFE		(0x02)
#define AW87XXX_PID_59_5X9_REG_BSTOVR		(0x03)
#define AW87XXX_PID_59_5X9_REG_BSTVPR		(0x04)
#define AW87XXX_PID_59_5X9_REG_PAGR		(0x05)
#define AW87XXX_PID_59_5X9_REG_PAGC3OPR		(0x06)
#define AW87XXX_PID_59_5X9_REG_PAGC3PR		(0x07)
#define AW87XXX_PID_59_5X9_REG_PAGC2OPR		(0x08)
#define AW87XXX_PID_59_5X9_REG_PAGC2PR		(0x09)
#define AW87XXX_PID_59_5X9_REG_PAGC1PR		(0x0A)
#define AW87XXX_PID_59_5X9_REG_SYSST		(0x58)
#define AW87XXX_PID_59_5X9_REG_SYSINT		(0x59)
#define AW87XXX_PID_59_5X9_REG_CPCR		(0x60)
#define AW87XXX_PID_59_5X9_REG_DFT1R		(0x61)
#define AW87XXX_PID_59_5X9_REG_DFT2R		(0x62)
#define AW87XXX_PID_59_5X9_REG_DFT3R		(0x63)
#define AW87XXX_PID_59_5X9_REG_DFT4R		(0x64)
#define AW87XXX_PID_59_5X9_REG_DFT5R		(0x65)
#define AW87XXX_PID_59_5X9_REG_DFT6R		(0x66)
#define AW87XXX_PID_59_5X9_REG_DFT7R		(0x67)
#define AW87XXX_PID_59_5X9_REG_DFT8R		(0x68)
#define AW87XXX_PID_59_5X9_REG_ENCR		(0x69)

#define AW87XXX_PID_59_5X9_ENCRY_DEFAULT	(0x00)

/********************************************
 * soft control info
 * If you need to update this file, add this information manually
 *******************************************/
unsigned char aw87xxx_pid_59_5x9_softrst_access[2] = {0x00, 0xaa};

/********************************************
 * Register Access
 *******************************************/
#define AW87XXX_PID_59_5X9_REG_MAX			(0x70)

#define REG_NONE_ACCESS		(0)
#define REG_RD_ACCESS		(1 << 0)
#define REG_WR_ACCESS		(1 << 1)

const unsigned char aw87xxx_pid_59_5x9_reg_access[AW87XXX_PID_59_5X9_REG_MAX] = {
	[AW87XXX_PID_59_5X9_REG_CHIPID]		= (REG_RD_ACCESS),
	[AW87XXX_PID_59_5X9_REG_SYSCTRL]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_BATSAFE]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_BSTOVR]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_BSTVPR]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGR]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGC3OPR]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGC3PR]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGC2OPR]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGC2PR]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_PAGC1PR]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_SYSST]		= (REG_RD_ACCESS),
	[AW87XXX_PID_59_5X9_REG_SYSINT]		= (REG_RD_ACCESS),
	[AW87XXX_PID_59_5X9_REG_CPCR]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT1R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT2R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT3R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT4R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT5R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT6R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT7R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_DFT8R]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_59_5X9_REG_ENCR]		= (REG_RD_ACCESS | REG_WR_ACCESS),
};

/* RCV_MODE bit 3 (SYSCTRL 0x01) */
#define AW87XXX_PID_59_5X9_REC_MODE_START_BIT	(3)
#define AW87XXX_PID_59_5X9_REC_MODE_BITS_LEN	(1)
#define AW87XXX_PID_59_5X9_REC_MODE_MASK	\
	(~(((1<<AW87XXX_PID_59_5X9_REC_MODE_BITS_LEN)-1) << AW87XXX_PID_59_5X9_REC_MODE_START_BIT))

#define AW87XXX_PID_59_5X9_REC_MODE_DISABLE	(0)
#define AW87XXX_PID_59_5X9_REC_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_59_5X9_REC_MODE_DISABLE << AW87XXX_PID_59_5X9_REC_MODE_START_BIT)

#define AW87XXX_PID_59_5X9_REC_MODE_ENABLE	(1)
#define AW87XXX_PID_59_5X9_REC_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_59_5X9_REC_MODE_ENABLE << AW87XXX_PID_59_5X9_REC_MODE_START_BIT)

#endif
