#ifndef __AW87XXX_PID_60_REG_H__
#define __AW87XXX_PID_60_REG_H__

/* registers list */
#define AW87XXX_PID_60_ID_REG			(0x00)
#define AW87XXX_PID_60_SYSCTRL_REG		(0x01)
#define AW87XXX_PID_60_BSTOVR_REG		(0x02)
#define AW87XXX_PID_60_PEAKLIMIT_REG		(0x03)
#define AW87XXX_PID_60_ADPSET_REG		(0x04)
#define AW87XXX_PID_60_PAG_REG			(0x05)
#define AW87XXX_PID_60_AGC1PA_REG		(0x06)
#define AW87XXX_PID_60_AGC2PA_REG		(0x07)
#define AW87XXX_PID_60_AGC3PA_REG		(0x08)
#define AW87XXX_PID_60_AGC3P_REG		(0x09)
#define AW87XXX_PID_60_LOW_BAT_REG		(0x0A)
#define AW87XXX_PID_60_BSTOUT_REG		(0x0B)
#define AW87XXX_PID_60_SYSST_REG		(0x59)
#define AW87XXX_PID_60_SYSINT_REG		(0x60)
#define AW87XXX_PID_60_BURST_CON_REG		(0x61)
#define AW87XXX_PID_60_BST_BIAS_REG		(0x62)
#define AW87XXX_PID_60_BST_EA_REG		(0x63)
#define AW87XXX_PID_60_BST_DE_SOFT_REG		(0x64)
#define AW87XXX_PID_60_BST_BURST_KICK_REG	(0x65)
#define AW87XXX_PID_60_BST_CON1_REG		(0x66)
#define AW87XXX_PID_60_BST_OVP_REG		(0x67)
#define AW87XXX_PID_60_LINE_MODE_REG		(0x68)
#define AW87XXX_PID_60_BST_ISEN_REG		(0x69)
#define AW87XXX_PID_60_BST_PEAK_REG		(0x6A)
#define AW87XXX_PID_60_BST_PEAK2_REG		(0x6B)
#define AW87XXX_PID_60_OFFTIME_REG		(0x6C)
#define AW87XXX_PID_60_ADPBST_REG		(0x6D)
#define AW87XXX_PID_60_OTA_REG			(0x6E)
#define AW87XXX_PID_60_RAMPGEN_REG		(0x6F)
#define AW87XXX_PID_60_CLASSD_SYSCTRL_REG	(0x70)
#define AW87XXX_PID_60_GTDR_REG			(0x71)
#define AW87XXX_PID_60_OC_REG			(0x72)
#define AW87XXX_PID_60_AGC_CON_REG		(0x73)
#define AW87XXX_PID_60_NG_REG			(0x74)
#define AW87XXX_PID_60_NG2_REG			(0x75)
#define AW87XXX_PID_60_NG3_REG			(0x76)
#define AW87XXX_PID_60_CP_REG			(0x77)
#define AW87XXX_PID_60_TEST_GTDR_REG		(0x78)
#define AW87XXX_PID_60_TEST_BST_REG		(0x79)
#define AW87XXX_PID_60_TEST_MODE_REG		(0x7A)
#define AW87XXX_PID_60_TEST_CON_REG		(0x7B)
#define AW87XXX_PID_60_ENCR_REG			(0x7C)

/********************************************
 * soft control info
 * If you need to update this file, add this information manually
 *******************************************/
unsigned char aw87xxx_pid_60_softrst_access[2] = {0x00, 0xaa};

/********************************************
 * Register Access
 *******************************************/
#define AW87XXX_PID_60_REG_MAX			(0x7D)

#define REG_NONE_ACCESS					(0)
#define REG_RD_ACCESS					(1 << 0)
#define REG_WR_ACCESS					(1 << 1)
#define AW87XXX_PID_60_ESD_REG_VAL			(0x91)

const unsigned char aw87xxx_pid_60_reg_access[AW87XXX_PID_60_REG_MAX] = {
	[AW87XXX_PID_60_ID_REG]		= (REG_RD_ACCESS),
	[AW87XXX_PID_60_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BSTOVR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_PEAKLIMIT_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_ADPSET_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_PAG_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_AGC1PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_AGC2PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_AGC3PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_AGC3P_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_LOW_BAT_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BSTOUT_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_60_SYSST_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_60_SYSINT_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_60_BURST_CON_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_BIAS_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_EA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_DE_SOFT_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_BURST_KICK_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_CON1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_OVP_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_LINE_MODE_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_ISEN_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_PEAK_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_BST_PEAK2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_OFFTIME_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_ADPBST_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_OTA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_RAMPGEN_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_CLASSD_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_GTDR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_OC_REG]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_AGC_CON_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_NG_REG]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_NG2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_NG3_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_CP_REG]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_TEST_GTDR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_TEST_BST_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_TEST_MODE_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_TEST_CON_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_60_ENCR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
};

/* detail information of registers begin */
/* ID (0x00) detail */
/* IDCODE bit 7:0 (ID 0x00) */
#define AW87XXX_PID_60_IDCODE_START_BIT	(0)
#define AW87XXX_PID_60_IDCODE_BITS_LEN	(8)
#define AW87XXX_PID_60_IDCODE_MASK		\
	(~(((1<<AW87XXX_PID_60_IDCODE_BITS_LEN)-1) << AW87XXX_PID_60_IDCODE_START_BIT))

#define AW87XXX_PID_60_IDCODE_DEFAULT_VALUE	(0x60)
#define AW87XXX_PID_60_IDCODE_DEFAULT	\
	(AW87XXX_PID_60_IDCODE_DEFAULT_VALUE << AW87XXX_PID_60_IDCODE_START_BIT)

/* default value of ID (0x00) */
/* #define AW87XXX_PID_60_ID_DEFAULT		(0x60) */

/* SYSCTRL (0x01) detail */
/* EN_HVBAT bit 0 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_EN_HVBAT_START_BIT	(0)
#define AW87XXX_PID_60_EN_HVBAT_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_HVBAT_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_HVBAT_BITS_LEN)-1) << AW87XXX_PID_60_EN_HVBAT_START_BIT))

#define AW87XXX_PID_60_EN_HVBAT_DISABLE	(0)
#define AW87XXX_PID_60_EN_HVBAT_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_HVBAT_DISABLE << AW87XXX_PID_60_EN_HVBAT_START_BIT)

#define AW87XXX_PID_60_EN_HVBAT_ENABLE	(1)
#define AW87XXX_PID_60_EN_HVBAT_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_HVBAT_ENABLE << AW87XXX_PID_60_EN_HVBAT_START_BIT)

#define AW87XXX_PID_60_EN_HVBAT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_HVBAT_DEFAULT	\
	(AW87XXX_PID_60_EN_HVBAT_DEFAULT_VALUE << AW87XXX_PID_60_EN_HVBAT_START_BIT)

/* RCV_MODE bit 1 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_RCV_MODE_START_BIT	(1)
#define AW87XXX_PID_60_RCV_MODE_BITS_LEN	(1)
#define AW87XXX_PID_60_RCV_MODE_MASK	\
	(~(((1<<AW87XXX_PID_60_RCV_MODE_BITS_LEN)-1) << AW87XXX_PID_60_RCV_MODE_START_BIT))

#define AW87XXX_PID_60_RCV_MODE_DISABLE	(0)
#define AW87XXX_PID_60_RCV_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_60_RCV_MODE_DISABLE << AW87XXX_PID_60_RCV_MODE_START_BIT)

#define AW87XXX_PID_60_RCV_MODE_ENABLE	(1)
#define AW87XXX_PID_60_RCV_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_60_RCV_MODE_ENABLE << AW87XXX_PID_60_RCV_MODE_START_BIT)

#define AW87XXX_PID_60_RCV_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_RCV_MODE_DEFAULT	\
	(AW87XXX_PID_60_RCV_MODE_DEFAULT_VALUE << AW87XXX_PID_60_RCV_MODE_START_BIT)

/* EN_PA bit 2 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_EN_PA_START_BIT	(2)
#define AW87XXX_PID_60_EN_PA_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_PA_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_PA_BITS_LEN)-1) << AW87XXX_PID_60_EN_PA_START_BIT))

#define AW87XXX_PID_60_EN_PA_DISABLE	(0)
#define AW87XXX_PID_60_EN_PA_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_PA_DISABLE << AW87XXX_PID_60_EN_PA_START_BIT)

#define AW87XXX_PID_60_EN_PA_ENABLE		(1)
#define AW87XXX_PID_60_EN_PA_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_PA_ENABLE << AW87XXX_PID_60_EN_PA_START_BIT)

#define AW87XXX_PID_60_EN_PA_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_EN_PA_DEFAULT	\
	(AW87XXX_PID_60_EN_PA_DEFAULT_VALUE << AW87XXX_PID_60_EN_PA_START_BIT)

/* EN_BOOST bit 3 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_EN_BOOST_START_BIT	(3)
#define AW87XXX_PID_60_EN_BOOST_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_BOOST_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_BOOST_BITS_LEN)-1) << AW87XXX_PID_60_EN_BOOST_START_BIT))

#define AW87XXX_PID_60_EN_BOOST_DISABLE	(0)
#define AW87XXX_PID_60_EN_BOOST_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_BOOST_DISABLE << AW87XXX_PID_60_EN_BOOST_START_BIT)

#define AW87XXX_PID_60_EN_BOOST_ENABLE	(1)
#define AW87XXX_PID_60_EN_BOOST_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_BOOST_ENABLE << AW87XXX_PID_60_EN_BOOST_START_BIT)

#define AW87XXX_PID_60_EN_BOOST_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_EN_BOOST_DEFAULT	\
	(AW87XXX_PID_60_EN_BOOST_DEFAULT_VALUE << AW87XXX_PID_60_EN_BOOST_START_BIT)

/* EN_CP bit 4 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_EN_CP_START_BIT	(4)
#define AW87XXX_PID_60_EN_CP_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_CP_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_CP_BITS_LEN)-1) << AW87XXX_PID_60_EN_CP_START_BIT))

#define AW87XXX_PID_60_EN_CP_DISABLE	(0)
#define AW87XXX_PID_60_EN_CP_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_CP_DISABLE << AW87XXX_PID_60_EN_CP_START_BIT)

#define AW87XXX_PID_60_EN_CP_ENABLE		(1)
#define AW87XXX_PID_60_EN_CP_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_CP_ENABLE << AW87XXX_PID_60_EN_CP_START_BIT)

#define AW87XXX_PID_60_EN_CP_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_EN_CP_DEFAULT	\
	(AW87XXX_PID_60_EN_CP_DEFAULT_VALUE << AW87XXX_PID_60_EN_CP_START_BIT)

/* EN_SW bit 5 (SYSCTRL 0x01) */
#define AW87XXX_PID_60_EN_SW_START_BIT	(5)
#define AW87XXX_PID_60_EN_SW_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_SW_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_SW_BITS_LEN)-1) << AW87XXX_PID_60_EN_SW_START_BIT))

#define AW87XXX_PID_60_EN_SW_DISABLE	(0)
#define AW87XXX_PID_60_EN_SW_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_SW_DISABLE << AW87XXX_PID_60_EN_SW_START_BIT)

#define AW87XXX_PID_60_EN_SW_ENABLE		(1)
#define AW87XXX_PID_60_EN_SW_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_SW_ENABLE << AW87XXX_PID_60_EN_SW_START_BIT)

#define AW87XXX_PID_60_EN_SW_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_SW_DEFAULT	\
	(AW87XXX_PID_60_EN_SW_DEFAULT_VALUE << AW87XXX_PID_60_EN_SW_START_BIT)

/* default value of SYSCTRL (0x01) */
/* #define AW87XXX_PID_60_SYSCTRL_DEFAULT		(0x1C) */

/* BSTOVR (0x02) detail */
/* CP_FREQ bit 6:5 (BSTOVR 0x02) */
#define AW87XXX_PID_60_CP_FREQ_START_BIT	(5)
#define AW87XXX_PID_60_CP_FREQ_BITS_LEN	(2)
#define AW87XXX_PID_60_CP_FREQ_MASK		\
	(~(((1<<AW87XXX_PID_60_CP_FREQ_BITS_LEN)-1) << AW87XXX_PID_60_CP_FREQ_START_BIT))

#define AW87XXX_PID_60_CP_FREQ_4P8MHZ	(0)
#define AW87XXX_PID_60_CP_FREQ_4P8MHZ_VALUE	\
	(AW87XXX_PID_60_CP_FREQ_4P8MHZ << AW87XXX_PID_60_CP_FREQ_START_BIT)

#define AW87XXX_PID_60_CP_FREQ_6P4MHZ	(1)
#define AW87XXX_PID_60_CP_FREQ_6P4MHZ_VALUE	\
	(AW87XXX_PID_60_CP_FREQ_6P4MHZ << AW87XXX_PID_60_CP_FREQ_START_BIT)

#define AW87XXX_PID_60_CP_FREQ_8P0MHZ	(2)
#define AW87XXX_PID_60_CP_FREQ_8P0MHZ_VALUE	\
	(AW87XXX_PID_60_CP_FREQ_8P0MHZ << AW87XXX_PID_60_CP_FREQ_START_BIT)

#define AW87XXX_PID_60_CP_FREQ_9P6MHZ	(3)
#define AW87XXX_PID_60_CP_FREQ_9P6MHZ_VALUE	\
	(AW87XXX_PID_60_CP_FREQ_9P6MHZ << AW87XXX_PID_60_CP_FREQ_START_BIT)

#define AW87XXX_PID_60_CP_FREQ_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_CP_FREQ_DEFAULT	\
	(AW87XXX_PID_60_CP_FREQ_DEFAULT_VALUE << AW87XXX_PID_60_CP_FREQ_START_BIT)

/* BST_VOUT bit 4:0 (BSTOVR 0x02) */
#define AW87XXX_PID_60_BST_VOUT_START_BIT	(0)
#define AW87XXX_PID_60_BST_VOUT_BITS_LEN	(5)
#define AW87XXX_PID_60_BST_VOUT_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_VOUT_BITS_LEN)-1) << AW87XXX_PID_60_BST_VOUT_START_BIT))

#define AW87XXX_PID_60_BST_VOUT_4P75V	(0)
#define AW87XXX_PID_60_BST_VOUT_4P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_4P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_5P0V	(1)
#define AW87XXX_PID_60_BST_VOUT_5P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_5P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_5P25V	(2)
#define AW87XXX_PID_60_BST_VOUT_5P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_5P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_5P5V	(3)
#define AW87XXX_PID_60_BST_VOUT_5P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_5P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_5P75V	(4)
#define AW87XXX_PID_60_BST_VOUT_5P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_5P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_6P0V	(5)
#define AW87XXX_PID_60_BST_VOUT_6P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_6P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_6P25V	(6)
#define AW87XXX_PID_60_BST_VOUT_6P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_6P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_6P5V	(7)
#define AW87XXX_PID_60_BST_VOUT_6P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_6P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_6P75V	(8)
#define AW87XXX_PID_60_BST_VOUT_6P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_6P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_7P0V	(9)
#define AW87XXX_PID_60_BST_VOUT_7P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_7P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_7P25V	(10)
#define AW87XXX_PID_60_BST_VOUT_7P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_7P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_7P5V	(11)
#define AW87XXX_PID_60_BST_VOUT_7P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_7P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_7P75V	(12)
#define AW87XXX_PID_60_BST_VOUT_7P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_7P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_8P0V	(13)
#define AW87XXX_PID_60_BST_VOUT_8P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_8P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_8P25V	(14)
#define AW87XXX_PID_60_BST_VOUT_8P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_8P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_8P5V	(15)
#define AW87XXX_PID_60_BST_VOUT_8P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_8P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_8P75V	(16)
#define AW87XXX_PID_60_BST_VOUT_8P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_8P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_9P0V	(17)
#define AW87XXX_PID_60_BST_VOUT_9P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_9P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_9P25V	(18)
#define AW87XXX_PID_60_BST_VOUT_9P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_9P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_9P5V	(19)
#define AW87XXX_PID_60_BST_VOUT_9P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_9P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_9P75V	(20)
#define AW87XXX_PID_60_BST_VOUT_9P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_9P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_10P0V	(21)
#define AW87XXX_PID_60_BST_VOUT_10P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_10P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_10P25V	(22)
#define AW87XXX_PID_60_BST_VOUT_10P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_10P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_10P5V	(23)
#define AW87XXX_PID_60_BST_VOUT_10P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_10P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_10P75V	(24)
#define AW87XXX_PID_60_BST_VOUT_10P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_10P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_11P0V	(25)
#define AW87XXX_PID_60_BST_VOUT_11P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_11P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_11P25V	(26)
#define AW87XXX_PID_60_BST_VOUT_11P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_11P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_11P5V	(27)
#define AW87XXX_PID_60_BST_VOUT_11P5V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_11P5V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_11P75V	(28)
#define AW87XXX_PID_60_BST_VOUT_11P75V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_11P75V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_12P0V	(29)
#define AW87XXX_PID_60_BST_VOUT_12P0V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_12P0V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_12P25V	(30)
#define AW87XXX_PID_60_BST_VOUT_12P25V_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_12P25V << AW87XXX_PID_60_BST_VOUT_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_DEFAULT_VALUE	(0x11)
#define AW87XXX_PID_60_BST_VOUT_DEFAULT	\
	(AW87XXX_PID_60_BST_VOUT_DEFAULT_VALUE << AW87XXX_PID_60_BST_VOUT_START_BIT)

/* default value of BSTOVR (0x02) */
/* #define AW87XXX_PID_60_BSTOVR_DEFAULT		(0x31) */

/* PEAKLIMIT (0x03) detail */
/* BST_OVP2_VTH bit 6:4 (PEAKLIMIT 0x03) */
#define AW87XXX_PID_60_BST_OVP2_VTH_START_BIT	(4)
#define AW87XXX_PID_60_BST_OVP2_VTH_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_OVP2_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP2_VTH_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT))

#define AW87XXX_PID_60_BST_OVP2_VTH_13P5V	(0)
#define AW87XXX_PID_60_BST_OVP2_VTH_13P5V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_13P5V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_14P0	(1)
#define AW87XXX_PID_60_BST_OVP2_VTH_14P0_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_14P0 << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_14P5V	(2)
#define AW87XXX_PID_60_BST_OVP2_VTH_14P5V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_14P5V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_15P0V	(3)
#define AW87XXX_PID_60_BST_OVP2_VTH_15P0V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_15P0V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_9P0V	(4)
#define AW87XXX_PID_60_BST_OVP2_VTH_9P0V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_9P0V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_9P5V	(5)
#define AW87XXX_PID_60_BST_OVP2_VTH_9P5V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_9P5V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_10P0V	(6)
#define AW87XXX_PID_60_BST_OVP2_VTH_10P0V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_10P0V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_10P5V	(7)
#define AW87XXX_PID_60_BST_OVP2_VTH_10P5V_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_VTH_10P5V << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_VTH_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_OVP2_VTH_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP2_VTH_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP2_VTH_START_BIT)

/* BST_IPEAK bit 3:0 (PEAKLIMIT 0x03) */
#define AW87XXX_PID_60_BST_IPEAK_START_BIT	(0)
#define AW87XXX_PID_60_BST_IPEAK_BITS_LEN	(4)
#define AW87XXX_PID_60_BST_IPEAK_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_1P5A	(0)
#define AW87XXX_PID_60_BST_IPEAK_1P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_1P5A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_1P75A	(1)
#define AW87XXX_PID_60_BST_IPEAK_1P75A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_1P75A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_2P0A	(2)
#define AW87XXX_PID_60_BST_IPEAK_2P0A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_2P0A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_2P25A	(3)
#define AW87XXX_PID_60_BST_IPEAK_2P25A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_2P25A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_2P5A	(4)
#define AW87XXX_PID_60_BST_IPEAK_2P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_2P5A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_2P75A	(5)
#define AW87XXX_PID_60_BST_IPEAK_2P75A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_2P75A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_3P0A	(6)
#define AW87XXX_PID_60_BST_IPEAK_3P0A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_3P0A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_3P25A	(7)
#define AW87XXX_PID_60_BST_IPEAK_3P25A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_3P25A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_3P5A	(8)
#define AW87XXX_PID_60_BST_IPEAK_3P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_3P5A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_3P75A	(9)
#define AW87XXX_PID_60_BST_IPEAK_3P75A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_3P75A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_4A		(10)
#define AW87XXX_PID_60_BST_IPEAK_4A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_4A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_4P25A	(11)
#define AW87XXX_PID_60_BST_IPEAK_4P25A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_4P25A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_4P50A	(12)
#define AW87XXX_PID_60_BST_IPEAK_4P50A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_4P50A << AW87XXX_PID_60_BST_IPEAK_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_DEFAULT_VALUE	(9)
#define AW87XXX_PID_60_BST_IPEAK_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_START_BIT)

/* default value of PEAKLIMIT (0x03) */
/* #define AW87XXX_PID_60_PEAKLIMIT_DEFAULT		(0x09) */

/* ADPSET (0x04) detail */
/* EN_ADP_BST bit 6 (ADPSET 0x04) */
#define AW87XXX_PID_60_EN_ADP_BST_START_BIT	(6)
#define AW87XXX_PID_60_EN_ADP_BST_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_ADP_BST_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_ADP_BST_BITS_LEN)-1) << AW87XXX_PID_60_EN_ADP_BST_START_BIT))

#define AW87XXX_PID_60_EN_ADP_BST_DISABLE	(0)
#define AW87XXX_PID_60_EN_ADP_BST_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_BST_DISABLE << AW87XXX_PID_60_EN_ADP_BST_START_BIT)

#define AW87XXX_PID_60_EN_ADP_BST_ENABLE	(1)
#define AW87XXX_PID_60_EN_ADP_BST_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_BST_ENABLE << AW87XXX_PID_60_EN_ADP_BST_START_BIT)

#define AW87XXX_PID_60_EN_ADP_BST_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_EN_ADP_BST_DEFAULT	\
	(AW87XXX_PID_60_EN_ADP_BST_DEFAULT_VALUE << AW87XXX_PID_60_EN_ADP_BST_START_BIT)

/* ADP_BOOST_MODE bit 5:3 (ADPSET 0x04) */
#define AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT	(3)
#define AW87XXX_PID_60_ADP_BOOST_MODE_BITS_LEN	(3)
#define AW87XXX_PID_60_ADP_BOOST_MODE_MASK	\
	(~(((1<<AW87XXX_PID_60_ADP_BOOST_MODE_BITS_LEN)-1) << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT))

#define AW87XXX_PID_60_ADP_BOOST_MODE_RCV	(0)
#define AW87XXX_PID_60_ADP_BOOST_MODE_RCV_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_RCV << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_FORCE_BOOST	(1)
#define AW87XXX_PID_60_ADP_BOOST_MODE_FORCE_BOOST_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_FORCE_BOOST << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_OSBOSD	(2)
#define AW87XXX_PID_60_ADP_BOOST_MODE_OSBOSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_OSBOSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_TSBTSD	(3)
#define AW87XXX_PID_60_ADP_BOOST_MODE_TSBTSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_TSBTSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_TSBOSD	(4)
#define AW87XXX_PID_60_ADP_BOOST_MODE_TSBOSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_TSBOSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBOSD	(5)
#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBOSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_MSBOSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBTSD	(6)
#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBTSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_MSBTSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBMSD	(7)
#define AW87XXX_PID_60_ADP_BOOST_MODE_MSBMSD_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_MSBMSD << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_MODE_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_ADP_BOOST_MODE_DEFAULT	\
	(AW87XXX_PID_60_ADP_BOOST_MODE_DEFAULT_VALUE << AW87XXX_PID_60_ADP_BOOST_MODE_START_BIT)

/* SET_BOOST_VTH2 bit 2:0 (ADPSET 0x04) */
#define AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT	(0)
#define AW87XXX_PID_60_SET_BOOST_VTH2_BITS_LEN	(3)
#define AW87XXX_PID_60_SET_BOOST_VTH2_MASK	\
	(~(((1<<AW87XXX_PID_60_SET_BOOST_VTH2_BITS_LEN)-1) << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT))

#define AW87XXX_PID_60_SET_BOOST_VTH2_1P2W	(0)
#define AW87XXX_PID_60_SET_BOOST_VTH2_1P2W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_1P2W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_1P4W	(1)
#define AW87XXX_PID_60_SET_BOOST_VTH2_1P4W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_1P4W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_1P6W	(2)
#define AW87XXX_PID_60_SET_BOOST_VTH2_1P6W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_1P6W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_1P8W	(3)
#define AW87XXX_PID_60_SET_BOOST_VTH2_1P8W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_1P8W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_2P0W	(4)
#define AW87XXX_PID_60_SET_BOOST_VTH2_2P0W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_2P0W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_2P2W	(5)
#define AW87XXX_PID_60_SET_BOOST_VTH2_2P2W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_2P2W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_2P4W	(6)
#define AW87XXX_PID_60_SET_BOOST_VTH2_2P4W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_2P4W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_2P6W	(7)
#define AW87XXX_PID_60_SET_BOOST_VTH2_2P6W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_2P6W << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH2_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_60_SET_BOOST_VTH2_DEFAULT	\
	(AW87XXX_PID_60_SET_BOOST_VTH2_DEFAULT_VALUE << AW87XXX_PID_60_SET_BOOST_VTH2_START_BIT)

/* default value of ADPSET (0x04) */
/* #define AW87XXX_PID_60_ADPSET_DEFAULT		(0x54) */

/* PAG (0x05) detail */
/* SET_BOOST_VTH1 bit 6:5 (PAG 0x05) */
#define AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT	(5)
#define AW87XXX_PID_60_SET_BOOST_VTH1_BITS_LEN	(2)
#define AW87XXX_PID_60_SET_BOOST_VTH1_MASK	\
	(~(((1<<AW87XXX_PID_60_SET_BOOST_VTH1_BITS_LEN)-1) << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT))

#define AW87XXX_PID_60_SET_BOOST_VTH1_0P1W	(0)
#define AW87XXX_PID_60_SET_BOOST_VTH1_0P1W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH1_0P1W << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH1_0P2W	(1)
#define AW87XXX_PID_60_SET_BOOST_VTH1_0P2W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH1_0P2W << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH1_0P3W	(2)
#define AW87XXX_PID_60_SET_BOOST_VTH1_0P3W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH1_0P3W << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH1_0P4W	(3)
#define AW87XXX_PID_60_SET_BOOST_VTH1_0P4W_VALUE	\
	(AW87XXX_PID_60_SET_BOOST_VTH1_0P4W << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT)

#define AW87XXX_PID_60_SET_BOOST_VTH1_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_SET_BOOST_VTH1_DEFAULT	\
	(AW87XXX_PID_60_SET_BOOST_VTH1_DEFAULT_VALUE << AW87XXX_PID_60_SET_BOOST_VTH1_START_BIT)

/* PA_GAIN bit 4:0 (PAG 0x05) */
#define AW87XXX_PID_60_PA_GAIN_START_BIT	(0)
#define AW87XXX_PID_60_PA_GAIN_BITS_LEN	(5)
#define AW87XXX_PID_60_PA_GAIN_MASK		\
	(~(((1<<AW87XXX_PID_60_PA_GAIN_BITS_LEN)-1) << AW87XXX_PID_60_PA_GAIN_START_BIT))

#define AW87XXX_PID_60_PA_GAIN_0DB		(0)
#define AW87XXX_PID_60_PA_GAIN_0DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_0DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_1P5DB	(1)
#define AW87XXX_PID_60_PA_GAIN_1P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_1P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_3DB		(2)
#define AW87XXX_PID_60_PA_GAIN_3DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_3DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_4P5DB	(3)
#define AW87XXX_PID_60_PA_GAIN_4P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_4P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_6DB		(4)
#define AW87XXX_PID_60_PA_GAIN_6DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_6DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_7P5DB	(5)
#define AW87XXX_PID_60_PA_GAIN_7P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_7P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_9DB		(6)
#define AW87XXX_PID_60_PA_GAIN_9DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_9DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_10P5DB	(7)
#define AW87XXX_PID_60_PA_GAIN_10P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_10P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_12DB		(8)
#define AW87XXX_PID_60_PA_GAIN_12DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_12DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_13P5DB	(9)
#define AW87XXX_PID_60_PA_GAIN_13P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_13P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_15DB		(10)
#define AW87XXX_PID_60_PA_GAIN_15DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_15DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_16P5DB	(11)
#define AW87XXX_PID_60_PA_GAIN_16P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_16P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_18DB		(12)
#define AW87XXX_PID_60_PA_GAIN_18DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_18DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_19P5DB	(13)
#define AW87XXX_PID_60_PA_GAIN_19P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_19P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_21DB		(14)
#define AW87XXX_PID_60_PA_GAIN_21DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_21DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_22P5DB	(15)
#define AW87XXX_PID_60_PA_GAIN_22P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_22P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_24DB		(16)
#define AW87XXX_PID_60_PA_GAIN_24DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_24DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_25P5DB	(17)
#define AW87XXX_PID_60_PA_GAIN_25P5DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_25P5DB << AW87XXX_PID_60_PA_GAIN_START_BIT)

#define AW87XXX_PID_60_PA_GAIN_27DB		(18)
#define AW87XXX_PID_60_PA_GAIN_27DB_VALUE	\
	(AW87XXX_PID_60_PA_GAIN_27DB << AW87XXX_PID_60_PA_GAIN_START_BIT)
/*
Fix me here:
reg_addr:0x05, reg_name:PAG, field_name:PA_GAIN, content:when RCV_MODE=0PA_GAIN  default 10000
maybe need to fix manually
*/
#define AW87XXX_PID_60_PA_GAIN_DEFAULT_VALUE	(0x10)
#define AW87XXX_PID_60_PA_GAIN_DEFAULT	\
	(AW87XXX_PID_60_PA_GAIN_DEFAULT_VALUE << AW87XXX_PID_60_PA_GAIN_START_BIT)

/* default value of PAG (0x05) */
/* #define AW87XXX_PID_60_PAG_DEFAULT		(0x50) */

/* AGC1PA (0x06) detail */
/* PD_AGC1 bit 7 (AGC1PA 0x06) */
#define AW87XXX_PID_60_PD_AGC1_START_BIT	(7)
#define AW87XXX_PID_60_PD_AGC1_BITS_LEN	(1)
#define AW87XXX_PID_60_PD_AGC1_MASK		\
	(~(((1<<AW87XXX_PID_60_PD_AGC1_BITS_LEN)-1) << AW87XXX_PID_60_PD_AGC1_START_BIT))

#define AW87XXX_PID_60_PD_AGC1_ENABLE	(0)
#define AW87XXX_PID_60_PD_AGC1_ENABLE_VALUE	\
	(AW87XXX_PID_60_PD_AGC1_ENABLE << AW87XXX_PID_60_PD_AGC1_START_BIT)

#define AW87XXX_PID_60_PD_AGC1_DISABLE	(1)
#define AW87XXX_PID_60_PD_AGC1_DISABLE_VALUE	\
	(AW87XXX_PID_60_PD_AGC1_DISABLE << AW87XXX_PID_60_PD_AGC1_START_BIT)

#define AW87XXX_PID_60_PD_AGC1_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PD_AGC1_DEFAULT	\
	(AW87XXX_PID_60_PD_AGC1_DEFAULT_VALUE << AW87XXX_PID_60_PD_AGC1_START_BIT)

/* AGC1_OUTPUT_LEVEL bit 6:3 (AGC1PA 0x06) */
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT	(3)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_BITS_LEN	(4)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_BITS_LEN)-1) << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT))

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5V	(0)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P2V	(1)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P2V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P2V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P4V	(2)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P4V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P4V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P6V	(3)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P6V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P6V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P8V	(4)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P8V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_5P8V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P0V	(5)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P0V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P0V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P2V	(6)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P2V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P2V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P4V	(7)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P4V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P4V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P6V	(8)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P6V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P6V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P8V	(9)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P8V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_6P8V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7V	(10)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P2V	(11)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P2V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P2V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P4V	(12)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P4V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P4V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P6V	(13)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P6V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P6V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P8V	(14)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P8V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_7P8V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_8V	(15)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_8V_VALUE	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_8V << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_DEFAULT_VALUE	(0x9)
#define AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_DEFAULT	\
	(AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_DEFAULT_VALUE << AW87XXX_PID_60_AGC1_OUTPUT_LEVEL_START_BIT)

/* AGC1_ATT_TIME bit 2:0 (AGC1PA 0x06) */
#define AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_60_AGC1_ATT_TIME_BITS_LEN	(3)
#define AW87XXX_PID_60_AGC1_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC1_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT))

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P04MSDB	(0)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P04MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P04MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P08MSDB	(1)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P08MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P08MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P16MSDB	(2)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P16MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P16MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P32MSDB	(3)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P32MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P32MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P02MSDB	(4)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P02MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P02MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P01MSDB	(5)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P01MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P01MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB	(6)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

/*
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB	(7)
#define AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB_VALUE	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_0P005MSDB << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)
*/

#define AW87XXX_PID_60_AGC1_ATT_TIME_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_AGC1_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC1_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC1_ATT_TIME_START_BIT)

/* default value of AGC1PA (0x06) */
/* #define AW87XXX_PID_60_AGC1PA_DEFAULT		(0x49) */

/* AGC2PA (0x07) detail */
/* AGC2_OUTPUT_POWER bit 6:3 (AGC2PA 0x07) */
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT	(3)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_BITS_LEN	(4)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC2_OUTPUT_POWER_BITS_LEN)-1) << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT))

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P0W4_OHM	(0)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P0W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P4W4_OHM	(1)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P4W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P4W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P8W4_OHM	(2)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P8W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_2P8W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P2W4_OHM	(3)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P2W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P2W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P6W4_OHM	(4)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_3P6W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P0W4_OHM	(5)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P0W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P4W4_OHM	(6)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P4W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P4W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P8W4_OHM	(7)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P8W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_4P8W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P2W4_OHM	(8)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P2W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P2W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P6W4_OHM	(9)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_5P6W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_6W4_OHM	(10)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_6W4_OHM << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_AGC2_OFF	(11)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_AGC2_OFF_VALUE	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_AGC2_OFF << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_AGC2_OUTPUT_POWER_DEFAULT	\
	(AW87XXX_PID_60_AGC2_OUTPUT_POWER_DEFAULT_VALUE << AW87XXX_PID_60_AGC2_OUTPUT_POWER_START_BIT)

/* AGC2_ATT_TIME bit 2:0 (AGC2PA 0x07) */
#define AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_60_AGC2_ATT_TIME_BITS_LEN	(3)
#define AW87XXX_PID_60_AGC2_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC2_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT))

#define AW87XXX_PID_60_AGC2_ATT_TIME_0P16MSDB	(0)
#define AW87XXX_PID_60_AGC2_ATT_TIME_0P16MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_0P16MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_0P32MSDB	(1)
#define AW87XXX_PID_60_AGC2_ATT_TIME_0P32MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_0P32MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_0P64MSDB	(2)
#define AW87XXX_PID_60_AGC2_ATT_TIME_0P64MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_0P64MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_2P56MSDB	(3)
#define AW87XXX_PID_60_AGC2_ATT_TIME_2P56MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_2P56MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_10P24MSDB	(4)
#define AW87XXX_PID_60_AGC2_ATT_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_10P24MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_40P96MSDB	(5)
#define AW87XXX_PID_60_AGC2_ATT_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_40P96MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_82MSDB	(6)
#define AW87XXX_PID_60_AGC2_ATT_TIME_82MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_82MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_164MSDB	(7)
#define AW87XXX_PID_60_AGC2_ATT_TIME_164MSDB_VALUE	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_164MSDB << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_ATT_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_AGC2_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC2_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC2_ATT_TIME_START_BIT)

/* default value of AGC2PA (0x07) */
/* #define AW87XXX_PID_60_AGC2PA_DEFAULT		(0x1A) */

/* AGC3PA (0x08) detail */
/* PD_AGC3 bit 4 (AGC3PA 0x08) */
#define AW87XXX_PID_60_PD_AGC3_START_BIT	(4)
#define AW87XXX_PID_60_PD_AGC3_BITS_LEN	(1)
#define AW87XXX_PID_60_PD_AGC3_MASK		\
	(~(((1<<AW87XXX_PID_60_PD_AGC3_BITS_LEN)-1) << AW87XXX_PID_60_PD_AGC3_START_BIT))

#define AW87XXX_PID_60_PD_AGC3_ENABLE	(0)
#define AW87XXX_PID_60_PD_AGC3_ENABLE_VALUE	\
	(AW87XXX_PID_60_PD_AGC3_ENABLE << AW87XXX_PID_60_PD_AGC3_START_BIT)

#define AW87XXX_PID_60_PD_AGC3_DISABLE	(1)
#define AW87XXX_PID_60_PD_AGC3_DISABLE_VALUE	\
	(AW87XXX_PID_60_PD_AGC3_DISABLE << AW87XXX_PID_60_PD_AGC3_START_BIT)

#define AW87XXX_PID_60_PD_AGC3_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PD_AGC3_DEFAULT	\
	(AW87XXX_PID_60_PD_AGC3_DEFAULT_VALUE << AW87XXX_PID_60_PD_AGC3_START_BIT)

/* EN_HW_MODE bit 5 (AGC3PA 0x08) */
#define AW87XXX_PID_60_EN_HW_MODE_START_BIT	(5)
#define AW87XXX_PID_60_EN_HW_MODE_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_HW_MODE_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_HW_MODE_BITS_LEN)-1) << AW87XXX_PID_60_EN_HW_MODE_START_BIT))

#define AW87XXX_PID_60_EN_HW_MODE_DISABLE	(0)
#define AW87XXX_PID_60_EN_HW_MODE_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_HW_MODE_DISABLE << AW87XXX_PID_60_EN_HW_MODE_START_BIT)

#define AW87XXX_PID_60_EN_HW_MODE_ENABLE	(1)
#define AW87XXX_PID_60_EN_HW_MODE_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_HW_MODE_ENABLE << AW87XXX_PID_60_EN_HW_MODE_START_BIT)

#define AW87XXX_PID_60_EN_HW_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_HW_MODE_DEFAULT	\
	(AW87XXX_PID_60_EN_HW_MODE_DEFAULT_VALUE << AW87XXX_PID_60_EN_HW_MODE_START_BIT)

/* AGC3_OUTPUT_POWER bit 3:0 (AGC3PA 0x08) */
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT	(0)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_BITS_LEN	(4)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC3_OUTPUT_POWER_BITS_LEN)-1) << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT))

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P0W4_OHM	(0)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P0W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P2W4_OHM	(1)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P2W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P2W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P4W4_OHM	(2)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P4W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P4W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P6W4_OHM	(3)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P6W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P8W4_OHM	(4)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P8W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_1P8W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P0W4_OHM	(5)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P0W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P2W4_OHM	(6)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P2W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P2W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P4W4_OHM	(7)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P4W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P4W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P6W4_OHM	(8)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P6W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P8W4_OHM	(9)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P8W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_2P8W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P0W4_OHM	(10)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P0W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P2W4_OHM	(11)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P2W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P2W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P4W4_OHM	(12)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P4W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P4W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P6W4_OHM	(13)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P6W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P6W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P8W4_OHM	(14)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P8W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_3P8W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_4P0W4_OHM	(15)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_4P0W4_OHM_VALUE	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_4P0W4_OHM << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_AGC3_OUTPUT_POWER_DEFAULT	\
	(AW87XXX_PID_60_AGC3_OUTPUT_POWER_DEFAULT_VALUE << AW87XXX_PID_60_AGC3_OUTPUT_POWER_START_BIT)

/* default value of AGC3PA (0x08) */
/* #define AW87XXX_PID_60_AGC3PA_DEFAULT		(0x03) */

/* AGC3P (0x09) detail */
/* AGC3_REL_TIME bit 7:5 (AGC3P 0x09) */
#define AW87XXX_PID_60_AGC3_REL_TIME_START_BIT	(5)
#define AW87XXX_PID_60_AGC3_REL_TIME_BITS_LEN	(3)
#define AW87XXX_PID_60_AGC3_REL_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC3_REL_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT))

#define AW87XXX_PID_60_AGC3_REL_TIME_5P12MSDB	(0)
#define AW87XXX_PID_60_AGC3_REL_TIME_5P12MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_5P12MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_10P24MSDB	(1)
#define AW87XXX_PID_60_AGC3_REL_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_10P24MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_20P48MSDB	(2)
#define AW87XXX_PID_60_AGC3_REL_TIME_20P48MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_20P48MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_40P96MSDB	(3)
#define AW87XXX_PID_60_AGC3_REL_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_40P96MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_81P92MSDB	(4)
#define AW87XXX_PID_60_AGC3_REL_TIME_81P92MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_81P92MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_163P84MSDB	(5)
#define AW87XXX_PID_60_AGC3_REL_TIME_163P84MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_163P84MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_327P68MSDB	(6)
#define AW87XXX_PID_60_AGC3_REL_TIME_327P68MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_327P68MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_655P36MSDB	(7)
#define AW87XXX_PID_60_AGC3_REL_TIME_655P36MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_REL_TIME_655P36MSDB << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_REL_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_AGC3_REL_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC3_REL_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC3_REL_TIME_START_BIT)

/* AGC3_ATT_TIME bit 4:2 (AGC3P 0x09) */
#define AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT	(2)
#define AW87XXX_PID_60_AGC3_ATT_TIME_BITS_LEN	(3)
#define AW87XXX_PID_60_AGC3_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC3_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT))

#define AW87XXX_PID_60_AGC3_ATT_TIME_1P28MSDB	(0)
#define AW87XXX_PID_60_AGC3_ATT_TIME_1P28MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_1P28MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_2P56MSDB	(1)
#define AW87XXX_PID_60_AGC3_ATT_TIME_2P56MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_2P56MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_10P24MSDB	(2)
#define AW87XXX_PID_60_AGC3_ATT_TIME_10P24MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_10P24MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_40P96MSDB	(3)
#define AW87XXX_PID_60_AGC3_ATT_TIME_40P96MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_40P96MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_82MSDB	(4)
#define AW87XXX_PID_60_AGC3_ATT_TIME_82MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_82MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_164MSDB	(5)
#define AW87XXX_PID_60_AGC3_ATT_TIME_164MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_164MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_328MSDB	(6)
#define AW87XXX_PID_60_AGC3_ATT_TIME_328MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_328MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_656MSDB	(7)
#define AW87XXX_PID_60_AGC3_ATT_TIME_656MSDB_VALUE	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_656MSDB << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_ATT_TIME_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_AGC3_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC3_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC3_ATT_TIME_START_BIT)

/* AGC3_FIRST_ATT_TIME bit 1:0 (AGC3P 0x09) */
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_BITS_LEN	(2)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT))

#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_5P12MS	(0)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_5P12MS_VALUE	\
	(AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_5P12MS << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_10P24MS	(1)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_10P24MS_VALUE	\
	(AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_10P24MS << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_20P48MS	(2)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_20P48MS_VALUE	\
	(AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_20P48MS << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_41MS	(3)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_41MS_VALUE	\
	(AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_41MS << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC3_FIRST_ATT_TIME_START_BIT)

/* default value of AGC3P (0x09) */
/* #define AW87XXX_PID_60_AGC3P_DEFAULT		(0x4E) */

/* LOW_BAT (0x0A) detail */
/* EN_BAT_SFGD bit 6 (LOW_BAT 0x0A) */
#define AW87XXX_PID_60_EN_BAT_SFGD_START_BIT	(6)
#define AW87XXX_PID_60_EN_BAT_SFGD_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_BAT_SFGD_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_BAT_SFGD_BITS_LEN)-1) << AW87XXX_PID_60_EN_BAT_SFGD_START_BIT))

#define AW87XXX_PID_60_EN_BAT_SFGD_DISABLE	(0)
#define AW87XXX_PID_60_EN_BAT_SFGD_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_BAT_SFGD_DISABLE << AW87XXX_PID_60_EN_BAT_SFGD_START_BIT)

#define AW87XXX_PID_60_EN_BAT_SFGD_ENABLE	(1)
#define AW87XXX_PID_60_EN_BAT_SFGD_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_BAT_SFGD_ENABLE << AW87XXX_PID_60_EN_BAT_SFGD_START_BIT)

#define AW87XXX_PID_60_EN_BAT_SFGD_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_BAT_SFGD_DEFAULT	\
	(AW87XXX_PID_60_EN_BAT_SFGD_DEFAULT_VALUE << AW87XXX_PID_60_EN_BAT_SFGD_START_BIT)

/* BAT_SFGD_VTH bit 5:4 (LOW_BAT 0x0A) */
#define AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT	(4)
#define AW87XXX_PID_60_BAT_SFGD_VTH_BITS_LEN	(2)
#define AW87XXX_PID_60_BAT_SFGD_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_BAT_SFGD_VTH_BITS_LEN)-1) << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT))

#define AW87XXX_PID_60_BAT_SFGD_VTH_3P3V	(0)
#define AW87XXX_PID_60_BAT_SFGD_VTH_3P3V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_VTH_3P3V << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_VTH_3P4V	(1)
#define AW87XXX_PID_60_BAT_SFGD_VTH_3P4V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_VTH_3P4V << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_VTH_3P5V	(2)
#define AW87XXX_PID_60_BAT_SFGD_VTH_3P5V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_VTH_3P5V << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_VTH_3P6V	(3)
#define AW87XXX_PID_60_BAT_SFGD_VTH_3P6V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_VTH_3P6V << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_VTH_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BAT_SFGD_VTH_DEFAULT	\
	(AW87XXX_PID_60_BAT_SFGD_VTH_DEFAULT_VALUE << AW87XXX_PID_60_BAT_SFGD_VTH_START_BIT)

/* BAT_SFGD_LEVEL bit 3:2 (LOW_BAT 0x0A) */
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT	(2)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_BITS_LEN	(2)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_MASK	\
	(~(((1<<AW87XXX_PID_60_BAT_SFGD_LEVEL_BITS_LEN)-1) << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT))

#define AW87XXX_PID_60_BAT_SFGD_LEVEL_5V	(0)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_5V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_LEVEL_5V << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_LEVEL_5P5V	(1)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_5P5V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_LEVEL_5P5V << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_LEVEL_6V	(2)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_6V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_LEVEL_6V << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_LEVEL_6P5V	(3)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_6P5V_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_LEVEL_6P5V << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_LEVEL_DEFAULT_VALUE	(0x01)
#define AW87XXX_PID_60_BAT_SFGD_LEVEL_DEFAULT	\
	(AW87XXX_PID_60_BAT_SFGD_LEVEL_DEFAULT_VALUE << AW87XXX_PID_60_BAT_SFGD_LEVEL_START_BIT)

/* BAT_SFGD_DEGLITCH bit 1:0 (LOW_BAT 0x0A) */
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT	(0)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_BITS_LEN	(2)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_MASK	\
	(~(((1<<AW87XXX_PID_60_BAT_SFGD_DEGLITCH_BITS_LEN)-1) << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT))

#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_1MS	(0)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_1MS_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_DEGLITCH_1MS << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_500US	(1)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_500US_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_DEGLITCH_500US << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_200US	(2)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_200US_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_DEGLITCH_200US << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DISABLE	(3)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DISABLE_VALUE	\
	(AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DISABLE << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DEFAULT	\
	(AW87XXX_PID_60_BAT_SFGD_DEGLITCH_DEFAULT_VALUE << AW87XXX_PID_60_BAT_SFGD_DEGLITCH_START_BIT)

/* default value of LOW_BAT (0x0A) */
/* #define AW87XXX_PID_60_LOW_BAT_DEFAULT		(0x14) */

/* BSTOUT (0x0B) detail */
/* ADP_BOOST_VOUT bit 4:0 (BSTOUT 0x0B) */
#define AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT	(0)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_BITS_LEN	(5)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_MASK	\
	(~(((1<<AW87XXX_PID_60_ADP_BOOST_VOUT_BITS_LEN)-1) << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT))

#define AW87XXX_PID_60_ADP_BOOST_VOUT_4P75V	(0)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_4P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_4P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P0V	(1)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_5P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P25V	(2)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_5P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P5V	(3)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_5P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P75V	(4)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_5P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_5P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P0V	(5)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_6P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P25V	(6)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_6P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P5V	(7)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_6P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P75V	(8)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_6P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_6P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P0V	(9)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_7P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P25V	(10)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_7P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P5V	(11)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_7P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P75V	(12)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_7P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_7P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P0V	(13)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_8P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P25V	(14)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_8P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P5V	(15)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_8P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P75V	(16)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_8P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_8P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P0V	(17)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_9P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P25V	(18)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_9P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P5V	(19)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_9P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P75V	(20)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_9P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_9P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P0V	(21)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_10P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P25V	(22)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_10P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P5V	(23)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_10P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P75V	(24)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_10P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_10P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P0V	(25)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_11P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P25V	(26)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_11P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P5V	(27)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P5V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_11P5V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P75V	(28)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_11P75V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_11P75V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_12P0V	(29)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_12P0V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_12P0V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_12P25V	(30)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_12P25V_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_12P25V << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_VOUT_DEFAULT_VALUE	(0x11)
#define AW87XXX_PID_60_ADP_BOOST_VOUT_DEFAULT	\
	(AW87XXX_PID_60_ADP_BOOST_VOUT_DEFAULT_VALUE << AW87XXX_PID_60_ADP_BOOST_VOUT_START_BIT)

/* default value of BSTOUT (0x0B) */
/* #define AW87XXX_PID_60_BSTOUT_DEFAULT		(0x11) */

/* SYSST (0x59) detail */
/* ADP_BOOST_S bit 0 (SYSST 0x59) */
#define AW87XXX_PID_60_ADP_BOOST_S_START_BIT	(0)
#define AW87XXX_PID_60_ADP_BOOST_S_BITS_LEN	(1)
#define AW87XXX_PID_60_ADP_BOOST_S_MASK	\
	(~(((1<<AW87XXX_PID_60_ADP_BOOST_S_BITS_LEN)-1) << AW87XXX_PID_60_ADP_BOOST_S_START_BIT))

#define AW87XXX_PID_60_ADP_BOOST_S_DIRECT_MODE	(0)
#define AW87XXX_PID_60_ADP_BOOST_S_DIRECT_MODE_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_S_DIRECT_MODE << AW87XXX_PID_60_ADP_BOOST_S_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_S_BOOST_MODE	(1)
#define AW87XXX_PID_60_ADP_BOOST_S_BOOST_MODE_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_S_BOOST_MODE << AW87XXX_PID_60_ADP_BOOST_S_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_ADP_BOOST_S_DEFAULT	\
	(AW87XXX_PID_60_ADP_BOOST_S_DEFAULT_VALUE << AW87XXX_PID_60_ADP_BOOST_S_START_BIT)

/* OT160_S bit 1 (SYSST 0x59) */
#define AW87XXX_PID_60_OT160_S_START_BIT	(1)
#define AW87XXX_PID_60_OT160_S_BITS_LEN	(1)
#define AW87XXX_PID_60_OT160_S_MASK		\
	(~(((1<<AW87XXX_PID_60_OT160_S_BITS_LEN)-1) << AW87XXX_PID_60_OT160_S_START_BIT))

#define AW87XXX_PID_60_OT160_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_OT160_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_OT160_S_NORMAL_OPERATION << AW87XXX_PID_60_OT160_S_START_BIT)

#define AW87XXX_PID_60_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_OT160_S_PA_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_60_OT160_S_START_BIT)

#define AW87XXX_PID_60_OT160_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_OT160_S_DEFAULT	\
	(AW87XXX_PID_60_OT160_S_DEFAULT_VALUE << AW87XXX_PID_60_OT160_S_START_BIT)

/* PA_OC_S bit 2 (SYSST 0x59) */
#define AW87XXX_PID_60_PA_OC_S_START_BIT	(2)
#define AW87XXX_PID_60_PA_OC_S_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_OC_S_MASK		\
	(~(((1<<AW87XXX_PID_60_PA_OC_S_BITS_LEN)-1) << AW87XXX_PID_60_PA_OC_S_START_BIT))

#define AW87XXX_PID_60_PA_OC_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_PA_OC_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_PA_OC_S_NORMAL_OPERATION << AW87XXX_PID_60_PA_OC_S_START_BIT)

#define AW87XXX_PID_60_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_PA_OC_S_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_60_PA_OC_S_START_BIT)

#define AW87XXX_PID_60_PA_OC_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PA_OC_S_DEFAULT	\
	(AW87XXX_PID_60_PA_OC_S_DEFAULT_VALUE << AW87XXX_PID_60_PA_OC_S_START_BIT)

/* BST_SCP_S bit 3 (SYSST 0x59) */
#define AW87XXX_PID_60_BST_SCP_S_START_BIT	(3)
#define AW87XXX_PID_60_BST_SCP_S_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SCP_S_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SCP_S_BITS_LEN)-1) << AW87XXX_PID_60_BST_SCP_S_START_BIT))

#define AW87XXX_PID_60_BST_SCP_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_SCP_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_SCP_S_NORMAL_OPERATION << AW87XXX_PID_60_BST_SCP_S_START_BIT)

#define AW87XXX_PID_60_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_BST_SCP_S_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED << AW87XXX_PID_60_BST_SCP_S_START_BIT)

#define AW87XXX_PID_60_BST_SCP_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_SCP_S_DEFAULT	\
	(AW87XXX_PID_60_BST_SCP_S_DEFAULT_VALUE << AW87XXX_PID_60_BST_SCP_S_START_BIT)

/* BST_OVP2_S bit 4 (SYSST 0x59) */
#define AW87XXX_PID_60_BST_OVP2_S_START_BIT	(4)
#define AW87XXX_PID_60_BST_OVP2_S_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP2_S_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP2_S_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP2_S_START_BIT))

#define AW87XXX_PID_60_BST_OVP2_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_OVP2_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_S_NORMAL_OPERATION << AW87XXX_PID_60_BST_OVP2_S_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_S_BOOST_HEAVY_LOAD_PROTECTION_DETECTED << AW87XXX_PID_60_BST_OVP2_S_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_OVP2_S_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP2_S_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP2_S_START_BIT)

/* BST_OVP_S bit 5 (SYSST 0x59) */
#define AW87XXX_PID_60_BST_OVP_S_START_BIT	(5)
#define AW87XXX_PID_60_BST_OVP_S_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP_S_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP_S_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP_S_START_BIT))

#define AW87XXX_PID_60_BST_OVP_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_OVP_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_OVP_S_NORMAL_OPERATION << AW87XXX_PID_60_BST_OVP_S_START_BIT)

#define AW87XXX_PID_60_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION	(1)
#define AW87XXX_PID_60_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION_VALUE	\
	(AW87XXX_PID_60_BST_OVP_S_BOOST_OVER_VOLTAGE_PROTECTION << AW87XXX_PID_60_BST_OVP_S_START_BIT)

#define AW87XXX_PID_60_BST_OVP_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_OVP_S_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP_S_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP_S_START_BIT)

/* LOW_BATT_S bit 6 (SYSST 0x59) */
#define AW87XXX_PID_60_LOW_BATT_S_START_BIT	(6)
#define AW87XXX_PID_60_LOW_BATT_S_BITS_LEN	(1)
#define AW87XXX_PID_60_LOW_BATT_S_MASK	\
	(~(((1<<AW87XXX_PID_60_LOW_BATT_S_BITS_LEN)-1) << AW87XXX_PID_60_LOW_BATT_S_START_BIT))

#define AW87XXX_PID_60_LOW_BATT_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_LOW_BATT_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_LOW_BATT_S_NORMAL_OPERATION << AW87XXX_PID_60_LOW_BATT_S_START_BIT)

#define AW87XXX_PID_60_LOW_BATT_S_LOW_VBAT_DETECTED	(1)
#define AW87XXX_PID_60_LOW_BATT_S_LOW_VBAT_DETECTED_VALUE	\
	(AW87XXX_PID_60_LOW_BATT_S_LOW_VBAT_DETECTED << AW87XXX_PID_60_LOW_BATT_S_START_BIT)

#define AW87XXX_PID_60_LOW_BATT_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_LOW_BATT_S_DEFAULT	\
	(AW87XXX_PID_60_LOW_BATT_S_DEFAULT_VALUE << AW87XXX_PID_60_LOW_BATT_S_START_BIT)

/* UVLO_S bit 7 (SYSST 0x59) */
#define AW87XXX_PID_60_UVLO_S_START_BIT	(7)
#define AW87XXX_PID_60_UVLO_S_BITS_LEN	(1)
#define AW87XXX_PID_60_UVLO_S_MASK		\
	(~(((1<<AW87XXX_PID_60_UVLO_S_BITS_LEN)-1) << AW87XXX_PID_60_UVLO_S_START_BIT))

#define AW87XXX_PID_60_UVLO_S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_UVLO_S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_UVLO_S_NORMAL_OPERATION << AW87XXX_PID_60_UVLO_S_START_BIT)

#define AW87XXX_PID_60_UVLO_S_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_60_UVLO_S_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_60_UVLO_S_VBAT_UNDER_VOLTAGE << AW87XXX_PID_60_UVLO_S_START_BIT)

#define AW87XXX_PID_60_UVLO_S_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_UVLO_S_DEFAULT	\
	(AW87XXX_PID_60_UVLO_S_DEFAULT_VALUE << AW87XXX_PID_60_UVLO_S_START_BIT)

/* default value of SYSST (0x59) */
/* #define AW87XXX_PID_60_SYSST_DEFAULT		(0xFF) */

/* SYSINT (0x60) detail */
/* ADP_BOOST_I bit 0 (SYSINT 0x60) */
#define AW87XXX_PID_60_ADP_BOOST_I_START_BIT	(0)
#define AW87XXX_PID_60_ADP_BOOST_I_BITS_LEN	(1)
#define AW87XXX_PID_60_ADP_BOOST_I_MASK	\
	(~(((1<<AW87XXX_PID_60_ADP_BOOST_I_BITS_LEN)-1) << AW87XXX_PID_60_ADP_BOOST_I_START_BIT))

#define AW87XXX_PID_60_ADP_BOOST_I_DIRECT_MODE	(0)
#define AW87XXX_PID_60_ADP_BOOST_I_DIRECT_MODE_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_I_DIRECT_MODE << AW87XXX_PID_60_ADP_BOOST_I_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_I_BOOST_MODE	(1)
#define AW87XXX_PID_60_ADP_BOOST_I_BOOST_MODE_VALUE	\
	(AW87XXX_PID_60_ADP_BOOST_I_BOOST_MODE << AW87XXX_PID_60_ADP_BOOST_I_START_BIT)

#define AW87XXX_PID_60_ADP_BOOST_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_ADP_BOOST_I_DEFAULT	\
	(AW87XXX_PID_60_ADP_BOOST_I_DEFAULT_VALUE << AW87XXX_PID_60_ADP_BOOST_I_START_BIT)

/* OT160_I bit 1 (SYSINT 0x60) */
#define AW87XXX_PID_60_OT160_I_START_BIT	(1)
#define AW87XXX_PID_60_OT160_I_BITS_LEN	(1)
#define AW87XXX_PID_60_OT160_I_MASK		\
	(~(((1<<AW87XXX_PID_60_OT160_I_BITS_LEN)-1) << AW87XXX_PID_60_OT160_I_START_BIT))

#define AW87XXX_PID_60_OT160_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_OT160_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_OT160_I_NORMAL_OPERATION << AW87XXX_PID_60_OT160_I_START_BIT)

#define AW87XXX_PID_60_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_OT160_I_PA_OVER_TEMPRETURE_PROTECTION_DETECTED << AW87XXX_PID_60_OT160_I_START_BIT)

#define AW87XXX_PID_60_OT160_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_OT160_I_DEFAULT	\
	(AW87XXX_PID_60_OT160_I_DEFAULT_VALUE << AW87XXX_PID_60_OT160_I_START_BIT)

/* PA_OC_I bit 2 (SYSINT 0x60) */
#define AW87XXX_PID_60_PA_OC_I_START_BIT	(2)
#define AW87XXX_PID_60_PA_OC_I_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_OC_I_MASK		\
	(~(((1<<AW87XXX_PID_60_PA_OC_I_BITS_LEN)-1) << AW87XXX_PID_60_PA_OC_I_START_BIT))

#define AW87XXX_PID_60_PA_OC_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_PA_OC_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_PA_OC_I_NORMAL_OPERATION << AW87XXX_PID_60_PA_OC_I_START_BIT)

#define AW87XXX_PID_60_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_PA_OC_I_PA_OVER_CURRENT_PROTECTION_DETECTED << AW87XXX_PID_60_PA_OC_I_START_BIT)

#define AW87XXX_PID_60_PA_OC_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PA_OC_I_DEFAULT	\
	(AW87XXX_PID_60_PA_OC_I_DEFAULT_VALUE << AW87XXX_PID_60_PA_OC_I_START_BIT)

/* BST_SCP_I bit 3 (SYSINT 0x60) */
#define AW87XXX_PID_60_BST_SCP_I_START_BIT	(3)
#define AW87XXX_PID_60_BST_SCP_I_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SCP_I_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SCP_I_BITS_LEN)-1) << AW87XXX_PID_60_BST_SCP_I_START_BIT))

#define AW87XXX_PID_60_BST_SCP_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_SCP_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_SCP_I_NORMAL_OPERATION << AW87XXX_PID_60_BST_SCP_I_START_BIT)

#define AW87XXX_PID_60_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_BST_SCP_I_BOOST_SHORT_CIRCUIT_PROTECTION_DETECTED << AW87XXX_PID_60_BST_SCP_I_START_BIT)

#define AW87XXX_PID_60_BST_SCP_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_SCP_I_DEFAULT	\
	(AW87XXX_PID_60_BST_SCP_I_DEFAULT_VALUE << AW87XXX_PID_60_BST_SCP_I_START_BIT)

/* BST_OVP2_I bit 4 (SYSINT 0x60) */
#define AW87XXX_PID_60_BST_OVP2_I_START_BIT	(4)
#define AW87XXX_PID_60_BST_OVP2_I_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP2_I_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP2_I_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP2_I_START_BIT))

#define AW87XXX_PID_60_BST_OVP2_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_OVP2_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_I_NORMAL_OPERATION << AW87XXX_PID_60_BST_OVP2_I_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED	(1)
#define AW87XXX_PID_60_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_I_BOOST_HEAVY_LOAD_PROTECTION_DETECTED << AW87XXX_PID_60_BST_OVP2_I_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_OVP2_I_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP2_I_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP2_I_START_BIT)

/* BST_OVP_I bit 5 (SYSINT 0x60) */
#define AW87XXX_PID_60_BST_OVP_I_START_BIT	(5)
#define AW87XXX_PID_60_BST_OVP_I_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP_I_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP_I_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP_I_START_BIT))

#define AW87XXX_PID_60_BST_OVP_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_BST_OVP_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_BST_OVP_I_NORMAL_OPERATION << AW87XXX_PID_60_BST_OVP_I_START_BIT)

#define AW87XXX_PID_60_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION	(1)
#define AW87XXX_PID_60_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION_VALUE	\
	(AW87XXX_PID_60_BST_OVP_I_BOOST_OVER_VOLTAGE_PROTECTION << AW87XXX_PID_60_BST_OVP_I_START_BIT)

#define AW87XXX_PID_60_BST_OVP_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_OVP_I_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP_I_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP_I_START_BIT)

/* LOW_BATT_I bit 6 (SYSINT 0x60) */
#define AW87XXX_PID_60_LOW_BATT_I_START_BIT	(6)
#define AW87XXX_PID_60_LOW_BATT_I_BITS_LEN	(1)
#define AW87XXX_PID_60_LOW_BATT_I_MASK	\
	(~(((1<<AW87XXX_PID_60_LOW_BATT_I_BITS_LEN)-1) << AW87XXX_PID_60_LOW_BATT_I_START_BIT))

#define AW87XXX_PID_60_LOW_BATT_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_LOW_BATT_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_LOW_BATT_I_NORMAL_OPERATION << AW87XXX_PID_60_LOW_BATT_I_START_BIT)

#define AW87XXX_PID_60_LOW_BATT_I_LOW_VBAT_DETECTED	(1)
#define AW87XXX_PID_60_LOW_BATT_I_LOW_VBAT_DETECTED_VALUE	\
	(AW87XXX_PID_60_LOW_BATT_I_LOW_VBAT_DETECTED << AW87XXX_PID_60_LOW_BATT_I_START_BIT)

#define AW87XXX_PID_60_LOW_BATT_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_LOW_BATT_I_DEFAULT	\
	(AW87XXX_PID_60_LOW_BATT_I_DEFAULT_VALUE << AW87XXX_PID_60_LOW_BATT_I_START_BIT)

/* UVLO_I bit 7 (SYSINT 0x60) */
#define AW87XXX_PID_60_UVLO_I_START_BIT	(7)
#define AW87XXX_PID_60_UVLO_I_BITS_LEN	(1)
#define AW87XXX_PID_60_UVLO_I_MASK		\
	(~(((1<<AW87XXX_PID_60_UVLO_I_BITS_LEN)-1) << AW87XXX_PID_60_UVLO_I_START_BIT))

#define AW87XXX_PID_60_UVLO_I_NORMAL_OPERATION	(0)
#define AW87XXX_PID_60_UVLO_I_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_60_UVLO_I_NORMAL_OPERATION << AW87XXX_PID_60_UVLO_I_START_BIT)

#define AW87XXX_PID_60_UVLO_I_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_60_UVLO_I_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_60_UVLO_I_VBAT_UNDER_VOLTAGE << AW87XXX_PID_60_UVLO_I_START_BIT)

#define AW87XXX_PID_60_UVLO_I_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_UVLO_I_DEFAULT	\
	(AW87XXX_PID_60_UVLO_I_DEFAULT_VALUE << AW87XXX_PID_60_UVLO_I_START_BIT)

/* default value of SYSINT (0x60) */
/* #define AW87XXX_PID_60_SYSINT_DEFAULT		(0xFF) */

/* BURST_CON (0x61) detail */
/* BURST_PEAK bit 7:5 (BURST_CON 0x61) */
#define AW87XXX_PID_60_BURST_PEAK_START_BIT	(5)
#define AW87XXX_PID_60_BURST_PEAK_BITS_LEN	(3)
#define AW87XXX_PID_60_BURST_PEAK_MASK	\
	(~(((1<<AW87XXX_PID_60_BURST_PEAK_BITS_LEN)-1) << AW87XXX_PID_60_BURST_PEAK_START_BIT))

#define AW87XXX_PID_60_BURST_PEAK_10MA	(0)
#define AW87XXX_PID_60_BURST_PEAK_10MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_10MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_20MA	(1)
#define AW87XXX_PID_60_BURST_PEAK_20MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_20MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_30MA	(2)
#define AW87XXX_PID_60_BURST_PEAK_30MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_30MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_50MA	(3)
#define AW87XXX_PID_60_BURST_PEAK_50MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_50MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_70MA	(4)
#define AW87XXX_PID_60_BURST_PEAK_70MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_70MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_130MA	(5)
#define AW87XXX_PID_60_BURST_PEAK_130MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_130MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_160MA	(7)
#define AW87XXX_PID_60_BURST_PEAK_160MA_VALUE	\
	(AW87XXX_PID_60_BURST_PEAK_160MA << AW87XXX_PID_60_BURST_PEAK_START_BIT)

#define AW87XXX_PID_60_BURST_PEAK_DEFAULT_VALUE	(2)
#define AW87XXX_PID_60_BURST_PEAK_DEFAULT	\
	(AW87XXX_PID_60_BURST_PEAK_DEFAULT_VALUE << AW87XXX_PID_60_BURST_PEAK_START_BIT)

/* BST_BURST_SS bit 4:2 (BURST_CON 0x61) */
#define AW87XXX_PID_60_BST_BURST_SS_START_BIT	(2)
#define AW87XXX_PID_60_BST_BURST_SS_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_BURST_SS_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_SS_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_SS_START_BIT))

#define AW87XXX_PID_60_BST_BURST_SS_700MV	(0)
#define AW87XXX_PID_60_BST_BURST_SS_700MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_700MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_760MV	(1)
#define AW87XXX_PID_60_BST_BURST_SS_760MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_760MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_820MV	(2)
#define AW87XXX_PID_60_BST_BURST_SS_820MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_820MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_880MV	(3)
#define AW87XXX_PID_60_BST_BURST_SS_880MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_880MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_940MV	(4)
#define AW87XXX_PID_60_BST_BURST_SS_940MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_940MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_1000MV	(5)
#define AW87XXX_PID_60_BST_BURST_SS_1000MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_1000MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_1060MV	(6)
#define AW87XXX_PID_60_BST_BURST_SS_1060MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_1060MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_1120MV	(7)
#define AW87XXX_PID_60_BST_BURST_SS_1120MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SS_1120MV << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_BURST_SS_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_SS_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_SS_START_BIT)

/* BST_COMPMAX bit 1:0 (BURST_CON 0x61) */
#define AW87XXX_PID_60_BST_COMPMAX_START_BIT	(0)
#define AW87XXX_PID_60_BST_COMPMAX_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_COMPMAX_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_COMPMAX_BITS_LEN)-1) << AW87XXX_PID_60_BST_COMPMAX_START_BIT))

#define AW87XXX_PID_60_BST_COMPMAX_2P0V	(0)
#define AW87XXX_PID_60_BST_COMPMAX_2P0V_VALUE	\
	(AW87XXX_PID_60_BST_COMPMAX_2P0V << AW87XXX_PID_60_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_60_BST_COMPMAX_2P2V	(1)
#define AW87XXX_PID_60_BST_COMPMAX_2P2V_VALUE	\
	(AW87XXX_PID_60_BST_COMPMAX_2P2V << AW87XXX_PID_60_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_60_BST_COMPMAX_2P3V	(2)
#define AW87XXX_PID_60_BST_COMPMAX_2P3V_VALUE	\
	(AW87XXX_PID_60_BST_COMPMAX_2P3V << AW87XXX_PID_60_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_60_BST_COMPMAX_2P4V	(3)
#define AW87XXX_PID_60_BST_COMPMAX_2P4V_VALUE	\
	(AW87XXX_PID_60_BST_COMPMAX_2P4V << AW87XXX_PID_60_BST_COMPMAX_START_BIT)

#define AW87XXX_PID_60_BST_COMPMAX_DEFAULT_VALUE	(3)
#define AW87XXX_PID_60_BST_COMPMAX_DEFAULT	\
	(AW87XXX_PID_60_BST_COMPMAX_DEFAULT_VALUE << AW87XXX_PID_60_BST_COMPMAX_START_BIT)

/* default value of BURST_CON (0x61) */
/* #define AW87XXX_PID_60_BURST_CON_DEFAULT		(0x47) */

/* BST_BIAS (0x62) detail */
/* BST_EA_CUR bit 0 (BST_BIAS 0x62) */
#define AW87XXX_PID_60_BST_EA_CUR_START_BIT	(0)
#define AW87XXX_PID_60_BST_EA_CUR_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_EA_CUR_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_EA_CUR_BITS_LEN)-1) << AW87XXX_PID_60_BST_EA_CUR_START_BIT))

#define AW87XXX_PID_60_BST_EA_CUR_1UA	(0)
#define AW87XXX_PID_60_BST_EA_CUR_1UA_VALUE	\
	(AW87XXX_PID_60_BST_EA_CUR_1UA << AW87XXX_PID_60_BST_EA_CUR_START_BIT)

#define AW87XXX_PID_60_BST_EA_CUR_2UA	(1)
#define AW87XXX_PID_60_BST_EA_CUR_2UA_VALUE	\
	(AW87XXX_PID_60_BST_EA_CUR_2UA << AW87XXX_PID_60_BST_EA_CUR_START_BIT)

#define AW87XXX_PID_60_BST_EA_CUR_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_EA_CUR_DEFAULT	\
	(AW87XXX_PID_60_BST_EA_CUR_DEFAULT_VALUE << AW87XXX_PID_60_BST_EA_CUR_START_BIT)

/* BST_BURST_SSMD bit 5 (BST_BIAS 0x62) */
#define AW87XXX_PID_60_BST_BURST_SSMD_START_BIT	(5)
#define AW87XXX_PID_60_BST_BURST_SSMD_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_BURST_SSMD_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_SSMD_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_SSMD_START_BIT))

#define AW87XXX_PID_60_BST_BURST_SSMD_SLOW	(0)
#define AW87XXX_PID_60_BST_BURST_SSMD_SLOW_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SSMD_SLOW << AW87XXX_PID_60_BST_BURST_SSMD_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SSMD_FAST	(1)
#define AW87XXX_PID_60_BST_BURST_SSMD_FAST_VALUE	\
	(AW87XXX_PID_60_BST_BURST_SSMD_FAST << AW87XXX_PID_60_BST_BURST_SSMD_START_BIT)

#define AW87XXX_PID_60_BST_BURST_SSMD_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_BURST_SSMD_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_SSMD_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_SSMD_START_BIT)

/* BST_NCD_ITH bit 7:6 (BST_BIAS 0x62) */
#define AW87XXX_PID_60_BST_NCD_ITH_START_BIT	(6)
#define AW87XXX_PID_60_BST_NCD_ITH_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_NCD_ITH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_NCD_ITH_BITS_LEN)-1) << AW87XXX_PID_60_BST_NCD_ITH_START_BIT))

#define AW87XXX_PID_60_BST_NCD_ITH_170MA	(0)
#define AW87XXX_PID_60_BST_NCD_ITH_170MA_VALUE	\
	(AW87XXX_PID_60_BST_NCD_ITH_170MA << AW87XXX_PID_60_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_60_BST_NCD_ITH_220MA	(1)
#define AW87XXX_PID_60_BST_NCD_ITH_220MA_VALUE	\
	(AW87XXX_PID_60_BST_NCD_ITH_220MA << AW87XXX_PID_60_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_60_BST_NCD_ITH_280MA	(2)
#define AW87XXX_PID_60_BST_NCD_ITH_280MA_VALUE	\
	(AW87XXX_PID_60_BST_NCD_ITH_280MA << AW87XXX_PID_60_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_60_BST_NCD_ITH_340MA	(3)
#define AW87XXX_PID_60_BST_NCD_ITH_340MA_VALUE	\
	(AW87XXX_PID_60_BST_NCD_ITH_340MA << AW87XXX_PID_60_BST_NCD_ITH_START_BIT)

#define AW87XXX_PID_60_BST_NCD_ITH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_NCD_ITH_DEFAULT	\
	(AW87XXX_PID_60_BST_NCD_ITH_DEFAULT_VALUE << AW87XXX_PID_60_BST_NCD_ITH_START_BIT)

/* BST_VOUT_TRIM bit 4:3 (BST_BIAS 0x62) */
#define AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT	(3)
#define AW87XXX_PID_60_BST_VOUT_TRIM_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_VOUT_TRIM_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_VOUT_TRIM_BITS_LEN)-1) << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT))

#define AW87XXX_PID_60_BST_VOUT_TRIM_25UA	(0)
#define AW87XXX_PID_60_BST_VOUT_TRIM_25UA_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_TRIM_25UA << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_TRIM_24UA	(1)
#define AW87XXX_PID_60_BST_VOUT_TRIM_24UA_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_TRIM_24UA << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_TRIM_25P5UA	(2)
#define AW87XXX_PID_60_BST_VOUT_TRIM_25P5UA_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_TRIM_25P5UA << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_TRIM_24P5UA	(3)
#define AW87XXX_PID_60_BST_VOUT_TRIM_24P5UA_VALUE	\
	(AW87XXX_PID_60_BST_VOUT_TRIM_24P5UA << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_VOUT_TRIM_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_VOUT_TRIM_DEFAULT	\
	(AW87XXX_PID_60_BST_VOUT_TRIM_DEFAULT_VALUE << AW87XXX_PID_60_BST_VOUT_TRIM_START_BIT)

/* BST_BURST_IN bit 2:1 (BST_BIAS 0x62) */
#define AW87XXX_PID_60_BST_BURST_IN_START_BIT	(1)
#define AW87XXX_PID_60_BST_BURST_IN_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_BURST_IN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_IN_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_IN_START_BIT))

#define AW87XXX_PID_60_BST_BURST_IN_3MV	(0)
#define AW87XXX_PID_60_BST_BURST_IN_3MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_3MV << AW87XXX_PID_60_BST_BURST_IN_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_5MV	(1)
#define AW87XXX_PID_60_BST_BURST_IN_5MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_5MV << AW87XXX_PID_60_BST_BURST_IN_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_7MV	(2)
#define AW87XXX_PID_60_BST_BURST_IN_7MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_7MV << AW87XXX_PID_60_BST_BURST_IN_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_9MV	(3)
#define AW87XXX_PID_60_BST_BURST_IN_9MV_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_9MV << AW87XXX_PID_60_BST_BURST_IN_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_BURST_IN_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_IN_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_IN_START_BIT)

/* default value of BST_BIAS (0x62) */
/* #define AW87XXX_PID_60_BST_BIAS_DEFAULT		(0x60) */

/* BST_EA (0x63) detail */
/* BST_LOW_CLAMP_EN bit 2 (BST_EA 0x63) */
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_START_BIT	(2)
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_LOW_CLAMP_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_LOW_CLAMP_EN_START_BIT))

#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_DISABLE	(0)
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_LOW_CLAMP_EN_DISABLE << AW87XXX_PID_60_BST_LOW_CLAMP_EN_START_BIT)

#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_LOW_CLAMP_EN_ENABLE << AW87XXX_PID_60_BST_LOW_CLAMP_EN_START_BIT)

#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_LOW_CLAMP_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_LOW_CLAMP_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_LOW_CLAMP_EN_START_BIT)

/* EN_VOUT_DIV bit 7 (BST_EA 0x63) */
#define AW87XXX_PID_60_EN_VOUT_DIV_START_BIT	(7)
#define AW87XXX_PID_60_EN_VOUT_DIV_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_VOUT_DIV_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_VOUT_DIV_BITS_LEN)-1) << AW87XXX_PID_60_EN_VOUT_DIV_START_BIT))

#define AW87XXX_PID_60_EN_VOUT_DIV_DISABLE	(0)
#define AW87XXX_PID_60_EN_VOUT_DIV_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_VOUT_DIV_DISABLE << AW87XXX_PID_60_EN_VOUT_DIV_START_BIT)

#define AW87XXX_PID_60_EN_VOUT_DIV_ENABLE	(1)
#define AW87XXX_PID_60_EN_VOUT_DIV_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_VOUT_DIV_ENABLE << AW87XXX_PID_60_EN_VOUT_DIV_START_BIT)

#define AW87XXX_PID_60_EN_VOUT_DIV_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_EN_VOUT_DIV_DEFAULT	\
	(AW87XXX_PID_60_EN_VOUT_DIV_DEFAULT_VALUE << AW87XXX_PID_60_EN_VOUT_DIV_START_BIT)

/* BST_BURST_OUT_DELAY bit 6:5 (BST_EA 0x63) */
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT	(5)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_OUT_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT))

#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_2P8US	(0)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_2P8US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_OUT_DELAY_2P8US << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_8P1US	(1)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_8P1US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_OUT_DELAY_8P1US << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P2US	(2)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P2US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P2US << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P8US	(3)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P8US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_OUT_DELAY_1P8US << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_BURST_OUT_DELAY_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_OUT_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_OUT_DELAY_START_BIT)

/* BST_BURST_IN_DELAY bit 4:3 (BST_EA 0x63) */
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT	(3)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_IN_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT))

#define AW87XXX_PID_60_BST_BURST_IN_DELAY_7P4US	(0)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_7P4US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_DELAY_7P4US << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_DELAY_14P6US	(1)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_14P6US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_DELAY_14P6US << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_DELAY_3P7US	(2)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_3P7US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_DELAY_3P7US << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_DELAY_5US	(3)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_5US_VALUE	\
	(AW87XXX_PID_60_BST_BURST_IN_DELAY_5US << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_BURST_IN_DELAY_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_BURST_IN_DELAY_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_IN_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_IN_DELAY_START_BIT)

/* BST_LOOPR bit 1:0 (BST_EA 0x63) */
#define AW87XXX_PID_60_BST_LOOPR_START_BIT	(0)
#define AW87XXX_PID_60_BST_LOOPR_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_LOOPR_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_LOOPR_BITS_LEN)-1) << AW87XXX_PID_60_BST_LOOPR_START_BIT))

#define AW87XXX_PID_60_BST_LOOPR_100K	(0)
#define AW87XXX_PID_60_BST_LOOPR_100K_VALUE	\
	(AW87XXX_PID_60_BST_LOOPR_100K << AW87XXX_PID_60_BST_LOOPR_START_BIT)

#define AW87XXX_PID_60_BST_LOOPR_200K	(1)
#define AW87XXX_PID_60_BST_LOOPR_200K_VALUE	\
	(AW87XXX_PID_60_BST_LOOPR_200K << AW87XXX_PID_60_BST_LOOPR_START_BIT)

#define AW87XXX_PID_60_BST_LOOPR_400K	(2)
#define AW87XXX_PID_60_BST_LOOPR_400K_VALUE	\
	(AW87XXX_PID_60_BST_LOOPR_400K << AW87XXX_PID_60_BST_LOOPR_START_BIT)

#define AW87XXX_PID_60_BST_LOOPR_500K	(3)
#define AW87XXX_PID_60_BST_LOOPR_500K_VALUE	\
	(AW87XXX_PID_60_BST_LOOPR_500K << AW87XXX_PID_60_BST_LOOPR_START_BIT)

#define AW87XXX_PID_60_BST_LOOPR_DEFAULT_VALUE	(2)
#define AW87XXX_PID_60_BST_LOOPR_DEFAULT	\
	(AW87XXX_PID_60_BST_LOOPR_DEFAULT_VALUE << AW87XXX_PID_60_BST_LOOPR_START_BIT)

/* default value of BST_EA (0x63) */
/* #define AW87XXX_PID_60_BST_EA_DEFAULT		(0x86) */

/* BST_DE_SOFT (0x64) detail */
/* EN_ADP_PEAK bit 0 (BST_DE_SOFT 0x64) */
#define AW87XXX_PID_60_EN_ADP_PEAK_START_BIT	(0)
#define AW87XXX_PID_60_EN_ADP_PEAK_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_ADP_PEAK_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_ADP_PEAK_BITS_LEN)-1) << AW87XXX_PID_60_EN_ADP_PEAK_START_BIT))

#define AW87XXX_PID_60_EN_ADP_PEAK_DISABLE	(0)
#define AW87XXX_PID_60_EN_ADP_PEAK_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_PEAK_DISABLE << AW87XXX_PID_60_EN_ADP_PEAK_START_BIT)

#define AW87XXX_PID_60_EN_ADP_PEAK_ENABLE	(1)
#define AW87XXX_PID_60_EN_ADP_PEAK_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_PEAK_ENABLE << AW87XXX_PID_60_EN_ADP_PEAK_START_BIT)

#define AW87XXX_PID_60_EN_ADP_PEAK_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_EN_ADP_PEAK_DEFAULT	\
	(AW87XXX_PID_60_EN_ADP_PEAK_DEFAULT_VALUE << AW87XXX_PID_60_EN_ADP_PEAK_START_BIT)

/* BST_SOFT_MODE_EN bit 7 (BST_DE_SOFT 0x64) */
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_START_BIT	(7)
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SOFT_MODE_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_SOFT_MODE_EN_START_BIT))

#define AW87XXX_PID_60_BST_SOFT_MODE_EN_DISABLE	(0)
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_MODE_EN_DISABLE << AW87XXX_PID_60_BST_SOFT_MODE_EN_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_MODE_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_MODE_EN_ENABLE << AW87XXX_PID_60_BST_SOFT_MODE_EN_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_MODE_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SOFT_MODE_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_SOFT_MODE_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_SOFT_MODE_EN_START_BIT)

/* BST_LOOPC bit 6:5 (BST_DE_SOFT 0x64) */
#define AW87XXX_PID_60_BST_LOOPC_START_BIT	(5)
#define AW87XXX_PID_60_BST_LOOPC_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_LOOPC_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_LOOPC_BITS_LEN)-1) << AW87XXX_PID_60_BST_LOOPC_START_BIT))

#define AW87XXX_PID_60_BST_LOOPC_30PF	(0)
#define AW87XXX_PID_60_BST_LOOPC_30PF_VALUE	\
	(AW87XXX_PID_60_BST_LOOPC_30PF << AW87XXX_PID_60_BST_LOOPC_START_BIT)

#define AW87XXX_PID_60_BST_LOOPC_40PF	(1)
#define AW87XXX_PID_60_BST_LOOPC_40PF_VALUE	\
	(AW87XXX_PID_60_BST_LOOPC_40PF << AW87XXX_PID_60_BST_LOOPC_START_BIT)

/*
#define AW87XXX_PID_60_BST_LOOPC_40PF	(2)
#define AW87XXX_PID_60_BST_LOOPC_40PF_VALUE	\
	(AW87XXX_PID_60_BST_LOOPC_40PF << AW87XXX_PID_60_BST_LOOPC_START_BIT)
*/

#define AW87XXX_PID_60_BST_LOOPC_50PF	(3)
#define AW87XXX_PID_60_BST_LOOPC_50PF_VALUE	\
	(AW87XXX_PID_60_BST_LOOPC_50PF << AW87XXX_PID_60_BST_LOOPC_START_BIT)

#define AW87XXX_PID_60_BST_LOOPC_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_LOOPC_DEFAULT	\
	(AW87XXX_PID_60_BST_LOOPC_DEFAULT_VALUE << AW87XXX_PID_60_BST_LOOPC_START_BIT)

/* BST_SEL_DFPWM bit 4:3 (BST_DE_SOFT 0x64) */
#define AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT	(3)
#define AW87XXX_PID_60_BST_SEL_DFPWM_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_SEL_DFPWM_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SEL_DFPWM_BITS_LEN)-1) << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT))

#define AW87XXX_PID_60_BST_SEL_DFPWM_32US_00_2US	(0)
#define AW87XXX_PID_60_BST_SEL_DFPWM_32US_00_2US_VALUE	\
	(AW87XXX_PID_60_BST_SEL_DFPWM_32US_00_2US << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT)

#define AW87XXX_PID_60_BST_SEL_DFPWM_64US_01_CLK	(1)
#define AW87XXX_PID_60_BST_SEL_DFPWM_64US_01_CLK_VALUE	\
	(AW87XXX_PID_60_BST_SEL_DFPWM_64US_01_CLK << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT)

#define AW87XXX_PID_60_BST_SEL_DFPWM_128US_10_4US	(2)
#define AW87XXX_PID_60_BST_SEL_DFPWM_128US_10_4US_VALUE	\
	(AW87XXX_PID_60_BST_SEL_DFPWM_128US_10_4US << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT)

#define AW87XXX_PID_60_BST_SEL_DFPWM_256US_11_8US	(3)
#define AW87XXX_PID_60_BST_SEL_DFPWM_256US_11_8US_VALUE	\
	(AW87XXX_PID_60_BST_SEL_DFPWM_256US_11_8US << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT)

#define AW87XXX_PID_60_BST_SEL_DFPWM_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_SEL_DFPWM_DEFAULT	\
	(AW87XXX_PID_60_BST_SEL_DFPWM_DEFAULT_VALUE << AW87XXX_PID_60_BST_SEL_DFPWM_START_BIT)

/* BST_SOFT_DELAY bit 2:1 (BST_DE_SOFT 0x64) */
#define AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT	(1)
#define AW87XXX_PID_60_BST_SOFT_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_SOFT_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SOFT_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT))

#define AW87XXX_PID_60_BST_SOFT_DELAY_40US_001280U	(0)
#define AW87XXX_PID_60_BST_SOFT_DELAY_40US_001280U_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_DELAY_40US_001280U << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_DELAY_80US_012560U	(1)
#define AW87XXX_PID_60_BST_SOFT_DELAY_80US_012560U_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_DELAY_80US_012560U << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_DELAY_160US_105120U	(2)
#define AW87XXX_PID_60_BST_SOFT_DELAY_160US_105120U_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_DELAY_160US_105120U << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_DELAY_320US_1110240U	(3)
#define AW87XXX_PID_60_BST_SOFT_DELAY_320US_1110240U_VALUE	\
	(AW87XXX_PID_60_BST_SOFT_DELAY_320US_1110240U << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_SOFT_DELAY_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SOFT_DELAY_DEFAULT	\
	(AW87XXX_PID_60_BST_SOFT_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_BST_SOFT_DELAY_START_BIT)

/* default value of BST_DE_SOFT (0x64) */
/* #define AW87XXX_PID_60_BST_DE_SOFT_DEFAULT		(0x09) */

/* BST_BURST_KICK (0x65) detail */
/* EN_TRANS_ERROR bit 0 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_EN_TRANS_ERROR_START_BIT	(0)
#define AW87XXX_PID_60_EN_TRANS_ERROR_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_TRANS_ERROR_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_TRANS_ERROR_BITS_LEN)-1) << AW87XXX_PID_60_EN_TRANS_ERROR_START_BIT))

#define AW87XXX_PID_60_EN_TRANS_ERROR_DISABLE	(0)
#define AW87XXX_PID_60_EN_TRANS_ERROR_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_TRANS_ERROR_DISABLE << AW87XXX_PID_60_EN_TRANS_ERROR_START_BIT)

#define AW87XXX_PID_60_EN_TRANS_ERROR_ENABLE	(1)
#define AW87XXX_PID_60_EN_TRANS_ERROR_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_TRANS_ERROR_ENABLE << AW87XXX_PID_60_EN_TRANS_ERROR_START_BIT)

#define AW87XXX_PID_60_EN_TRANS_ERROR_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_EN_TRANS_ERROR_DEFAULT	\
	(AW87XXX_PID_60_EN_TRANS_ERROR_DEFAULT_VALUE << AW87XXX_PID_60_EN_TRANS_ERROR_START_BIT)

/* BST_SCP_VTH bit 1 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_BST_SCP_VTH_START_BIT	(1)
#define AW87XXX_PID_60_BST_SCP_VTH_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SCP_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SCP_VTH_BITS_LEN)-1) << AW87XXX_PID_60_BST_SCP_VTH_START_BIT))

#define AW87XXX_PID_60_BST_SCP_VTH_HIGH_SIDE_VDD	(0)
#define AW87XXX_PID_60_BST_SCP_VTH_HIGH_SIDE_VDD_VALUE	\
	(AW87XXX_PID_60_BST_SCP_VTH_HIGH_SIDE_VDD << AW87XXX_PID_60_BST_SCP_VTH_START_BIT)

#define AW87XXX_PID_60_BST_SCP_VTH_LOW_SIDE_VDD	(1)
#define AW87XXX_PID_60_BST_SCP_VTH_LOW_SIDE_VDD_VALUE	\
	(AW87XXX_PID_60_BST_SCP_VTH_LOW_SIDE_VDD << AW87XXX_PID_60_BST_SCP_VTH_START_BIT)

#define AW87XXX_PID_60_BST_SCP_VTH_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SCP_VTH_DEFAULT	\
	(AW87XXX_PID_60_BST_SCP_VTH_DEFAULT_VALUE << AW87XXX_PID_60_BST_SCP_VTH_START_BIT)

/* BST_SKIP_EN bit 6 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_BST_SKIP_EN_START_BIT	(6)
#define AW87XXX_PID_60_BST_SKIP_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SKIP_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SKIP_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_SKIP_EN_START_BIT))

#define AW87XXX_PID_60_BST_SKIP_EN_ENABLE	(0)
#define AW87XXX_PID_60_BST_SKIP_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_SKIP_EN_ENABLE << AW87XXX_PID_60_BST_SKIP_EN_START_BIT)

#define AW87XXX_PID_60_BST_SKIP_EN_DISABLE	(1)
#define AW87XXX_PID_60_BST_SKIP_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_SKIP_EN_DISABLE << AW87XXX_PID_60_BST_SKIP_EN_START_BIT)

#define AW87XXX_PID_60_BST_SKIP_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SKIP_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_SKIP_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_SKIP_EN_START_BIT)

/* BST_ADBK_COMP_ADJ bit 7 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_START_BIT	(7)
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_ADBK_COMP_ADJ_BITS_LEN)-1) << AW87XXX_PID_60_BST_ADBK_COMP_ADJ_START_BIT))

#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_14UA	(0)
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_14UA_VALUE	\
	(AW87XXX_PID_60_BST_ADBK_COMP_ADJ_14UA << AW87XXX_PID_60_BST_ADBK_COMP_ADJ_START_BIT)

#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_10UA	(1)
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_10UA_VALUE	\
	(AW87XXX_PID_60_BST_ADBK_COMP_ADJ_10UA << AW87XXX_PID_60_BST_ADBK_COMP_ADJ_START_BIT)

#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_ADBK_COMP_ADJ_DEFAULT	\
	(AW87XXX_PID_60_BST_ADBK_COMP_ADJ_DEFAULT_VALUE << AW87XXX_PID_60_BST_ADBK_COMP_ADJ_START_BIT)

/* BST_OVP2_ITH bit 5:4 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_BST_OVP2_ITH_START_BIT	(4)
#define AW87XXX_PID_60_BST_OVP2_ITH_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_OVP2_ITH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP2_ITH_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT))

#define AW87XXX_PID_60_BST_OVP2_ITH_32MA	(0)
#define AW87XXX_PID_60_BST_OVP2_ITH_32MA_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_ITH_32MA << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_ITH_48MA	(1)
#define AW87XXX_PID_60_BST_OVP2_ITH_48MA_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_ITH_48MA << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_ITH_64MA	(2)
#define AW87XXX_PID_60_BST_OVP2_ITH_64MA_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_ITH_64MA << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT)

/*
#define AW87XXX_PID_60_BST_OVP2_ITH_64MA	(3)
#define AW87XXX_PID_60_BST_OVP2_ITH_64MA_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_ITH_64MA << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT)
*/

#define AW87XXX_PID_60_BST_OVP2_ITH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_OVP2_ITH_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP2_ITH_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP2_ITH_START_BIT)

/* BST_KICK_ITH bit 3:2 (BST_BURST_KICK 0x65) */
#define AW87XXX_PID_60_BST_KICK_ITH_START_BIT	(2)
#define AW87XXX_PID_60_BST_KICK_ITH_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_KICK_ITH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_KICK_ITH_BITS_LEN)-1) << AW87XXX_PID_60_BST_KICK_ITH_START_BIT))

#define AW87XXX_PID_60_BST_KICK_ITH_32MA	(0)
#define AW87XXX_PID_60_BST_KICK_ITH_32MA_VALUE	\
	(AW87XXX_PID_60_BST_KICK_ITH_32MA << AW87XXX_PID_60_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_60_BST_KICK_ITH_48MA	(1)
#define AW87XXX_PID_60_BST_KICK_ITH_48MA_VALUE	\
	(AW87XXX_PID_60_BST_KICK_ITH_48MA << AW87XXX_PID_60_BST_KICK_ITH_START_BIT)

#define AW87XXX_PID_60_BST_KICK_ITH_64MA	(2)
#define AW87XXX_PID_60_BST_KICK_ITH_64MA_VALUE	\
	(AW87XXX_PID_60_BST_KICK_ITH_64MA << AW87XXX_PID_60_BST_KICK_ITH_START_BIT)

/*
#define AW87XXX_PID_60_BST_KICK_ITH_64MA	(3)
#define AW87XXX_PID_60_BST_KICK_ITH_64MA_VALUE	\
	(AW87XXX_PID_60_BST_KICK_ITH_64MA << AW87XXX_PID_60_BST_KICK_ITH_START_BIT)
*/

#define AW87XXX_PID_60_BST_KICK_ITH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_KICK_ITH_DEFAULT	\
	(AW87XXX_PID_60_BST_KICK_ITH_DEFAULT_VALUE << AW87XXX_PID_60_BST_KICK_ITH_START_BIT)

/* default value of BST_BURST_KICK (0x65) */
/* #define AW87XXX_PID_60_BST_BURST_KICK_DEFAULT		(0x14) */

/* BST_CON1 (0x66) detail */
/* BST_GTDR_DDT bit 2 (BST_CON1 0x66) */
#define AW87XXX_PID_60_BST_GTDR_DDT_START_BIT	(2)
#define AW87XXX_PID_60_BST_GTDR_DDT_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_GTDR_DDT_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_GTDR_DDT_BITS_LEN)-1) << AW87XXX_PID_60_BST_GTDR_DDT_START_BIT))

#define AW87XXX_PID_60_BST_GTDR_DDT_9NS	(0)
#define AW87XXX_PID_60_BST_GTDR_DDT_9NS_VALUE	\
	(AW87XXX_PID_60_BST_GTDR_DDT_9NS << AW87XXX_PID_60_BST_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_BST_GTDR_DDT_12NS	(1)
#define AW87XXX_PID_60_BST_GTDR_DDT_12NS_VALUE	\
	(AW87XXX_PID_60_BST_GTDR_DDT_12NS << AW87XXX_PID_60_BST_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_BST_GTDR_DDT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_GTDR_DDT_DEFAULT	\
	(AW87XXX_PID_60_BST_GTDR_DDT_DEFAULT_VALUE << AW87XXX_PID_60_BST_GTDR_DDT_START_BIT)

/* EN_ADP_MODE1_DEGLITCH bit 3 (BST_CON1 0x66) */
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_START_BIT	(3)
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_BITS_LEN)-1) << AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_START_BIT))

#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DISABLE	(0)
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DISABLE << AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_ENABLE	(1)
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_ENABLE << AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_START_BIT)

#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DEFAULT	\
	(AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_DEFAULT_VALUE << AW87XXX_PID_60_EN_ADP_MODE1_DEGLITCH_START_BIT)

/* SS_FINISH_SELECT bit 6 (BST_CON1 0x66) */
#define AW87XXX_PID_60_SS_FINISH_SELECT_START_BIT	(6)
#define AW87XXX_PID_60_SS_FINISH_SELECT_BITS_LEN	(1)
#define AW87XXX_PID_60_SS_FINISH_SELECT_MASK	\
	(~(((1<<AW87XXX_PID_60_SS_FINISH_SELECT_BITS_LEN)-1) << AW87XXX_PID_60_SS_FINISH_SELECT_START_BIT))

#define AW87XXX_PID_60_SS_FINISH_SELECT_NOT_USE	(0)
#define AW87XXX_PID_60_SS_FINISH_SELECT_NOT_USE_VALUE	\
	(AW87XXX_PID_60_SS_FINISH_SELECT_NOT_USE << AW87XXX_PID_60_SS_FINISH_SELECT_START_BIT)

#define AW87XXX_PID_60_SS_FINISH_SELECT_USE	(1)
#define AW87XXX_PID_60_SS_FINISH_SELECT_USE_VALUE	\
	(AW87XXX_PID_60_SS_FINISH_SELECT_USE << AW87XXX_PID_60_SS_FINISH_SELECT_START_BIT)

#define AW87XXX_PID_60_SS_FINISH_SELECT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_SS_FINISH_SELECT_DEFAULT	\
	(AW87XXX_PID_60_SS_FINISH_SELECT_DEFAULT_VALUE << AW87XXX_PID_60_SS_FINISH_SELECT_START_BIT)

/* BST_GDRV_TEST bit 7 (BST_CON1 0x66) */
#define AW87XXX_PID_60_BST_GDRV_TEST_START_BIT	(7)
#define AW87XXX_PID_60_BST_GDRV_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_GDRV_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_GDRV_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_GDRV_TEST_START_BIT))

#define AW87XXX_PID_60_BST_GDRV_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_GDRV_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_GDRV_TEST_DIABLE << AW87XXX_PID_60_BST_GDRV_TEST_START_BIT)

#define AW87XXX_PID_60_BST_GDRV_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_GDRV_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_GDRV_TEST_ENABLE << AW87XXX_PID_60_BST_GDRV_TEST_START_BIT)

#define AW87XXX_PID_60_BST_GDRV_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_GDRV_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_GDRV_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_GDRV_TEST_START_BIT)

/* BST_EN_DELAY bit 5:4 (BST_CON1 0x66) */
#define AW87XXX_PID_60_BST_EN_DELAY_START_BIT	(4)
#define AW87XXX_PID_60_BST_EN_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_EN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_EN_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_BST_EN_DELAY_START_BIT))

#define AW87XXX_PID_60_BST_EN_DELAY_8N	(0)
#define AW87XXX_PID_60_BST_EN_DELAY_8N_VALUE	\
	(AW87XXX_PID_60_BST_EN_DELAY_8N << AW87XXX_PID_60_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_EN_DELAY_80N	(1)
#define AW87XXX_PID_60_BST_EN_DELAY_80N_VALUE	\
	(AW87XXX_PID_60_BST_EN_DELAY_80N << AW87XXX_PID_60_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_EN_DELAY_130N	(2)
#define AW87XXX_PID_60_BST_EN_DELAY_130N_VALUE	\
	(AW87XXX_PID_60_BST_EN_DELAY_130N << AW87XXX_PID_60_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_EN_DELAY_200N	(3)
#define AW87XXX_PID_60_BST_EN_DELAY_200N_VALUE	\
	(AW87XXX_PID_60_BST_EN_DELAY_200N << AW87XXX_PID_60_BST_EN_DELAY_START_BIT)

#define AW87XXX_PID_60_BST_EN_DELAY_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_EN_DELAY_DEFAULT	\
	(AW87XXX_PID_60_BST_EN_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_BST_EN_DELAY_START_BIT)

/* BST_SRC bit 1:0 (BST_CON1 0x66) */
#define AW87XXX_PID_60_BST_SRC_START_BIT	(0)
#define AW87XXX_PID_60_BST_SRC_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_SRC_MASK		\
	(~(((1<<AW87XXX_PID_60_BST_SRC_BITS_LEN)-1) << AW87XXX_PID_60_BST_SRC_START_BIT))

#define AW87XXX_PID_60_BST_SRC_3NS		(0)
#define AW87XXX_PID_60_BST_SRC_3NS_VALUE	\
	(AW87XXX_PID_60_BST_SRC_3NS << AW87XXX_PID_60_BST_SRC_START_BIT)

#define AW87XXX_PID_60_BST_SRC_4NS		(1)
#define AW87XXX_PID_60_BST_SRC_4NS_VALUE	\
	(AW87XXX_PID_60_BST_SRC_4NS << AW87XXX_PID_60_BST_SRC_START_BIT)

#define AW87XXX_PID_60_BST_SRC_7NS		(2)
#define AW87XXX_PID_60_BST_SRC_7NS_VALUE	\
	(AW87XXX_PID_60_BST_SRC_7NS << AW87XXX_PID_60_BST_SRC_START_BIT)

#define AW87XXX_PID_60_BST_SRC_15NS		(3)
#define AW87XXX_PID_60_BST_SRC_15NS_VALUE	\
	(AW87XXX_PID_60_BST_SRC_15NS << AW87XXX_PID_60_BST_SRC_START_BIT)

#define AW87XXX_PID_60_BST_SRC_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SRC_DEFAULT	\
	(AW87XXX_PID_60_BST_SRC_DEFAULT_VALUE << AW87XXX_PID_60_BST_SRC_START_BIT)

/* default value of BST_CON1 (0x66) */
/* #define AW87XXX_PID_60_BST_CON1_DEFAULT		(0x10) */

/* BST_OVP (0x67) detail */
/* BST_OVP_VTH bit 0 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_OVP_VTH_START_BIT	(0)
#define AW87XXX_PID_60_BST_OVP_VTH_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP_VTH_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP_VTH_START_BIT))

#define AW87XXX_PID_60_BST_OVP_VTH_3MINUS6P875V	(0)
#define AW87XXX_PID_60_BST_OVP_VTH_3MINUS6P875V_VALUE	\
	(AW87XXX_PID_60_BST_OVP_VTH_3MINUS6P875V << AW87XXX_PID_60_BST_OVP_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP_VTH_7MINUS11V	(1)
#define AW87XXX_PID_60_BST_OVP_VTH_7MINUS11V_VALUE	\
	(AW87XXX_PID_60_BST_OVP_VTH_7MINUS11V << AW87XXX_PID_60_BST_OVP_VTH_START_BIT)

#define AW87XXX_PID_60_BST_OVP_VTH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_OVP_VTH_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP_VTH_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP_VTH_START_BIT)

/* BST_VFB_EN bit 1 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_VFB_EN_START_BIT	(1)
#define AW87XXX_PID_60_BST_VFB_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_VFB_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_VFB_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_VFB_EN_START_BIT))

#define AW87XXX_PID_60_BST_VFB_EN_DISABLE	(0)
#define AW87XXX_PID_60_BST_VFB_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_VFB_EN_DISABLE << AW87XXX_PID_60_BST_VFB_EN_START_BIT)

#define AW87XXX_PID_60_BST_VFB_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_VFB_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_VFB_EN_ENABLE << AW87XXX_PID_60_BST_VFB_EN_START_BIT)

#define AW87XXX_PID_60_BST_VFB_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_VFB_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_VFB_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_VFB_EN_START_BIT)

/* BST_FORCE_PWM bit 2 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_FORCE_PWM_START_BIT	(2)
#define AW87XXX_PID_60_BST_FORCE_PWM_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_FORCE_PWM_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_FORCE_PWM_BITS_LEN)-1) << AW87XXX_PID_60_BST_FORCE_PWM_START_BIT))

#define AW87XXX_PID_60_BST_FORCE_PWM_DISABLE	(0)
#define AW87XXX_PID_60_BST_FORCE_PWM_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_FORCE_PWM_DISABLE << AW87XXX_PID_60_BST_FORCE_PWM_START_BIT)

#define AW87XXX_PID_60_BST_FORCE_PWM_ENABLE	(1)
#define AW87XXX_PID_60_BST_FORCE_PWM_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_FORCE_PWM_ENABLE << AW87XXX_PID_60_BST_FORCE_PWM_START_BIT)

#define AW87XXX_PID_60_BST_FORCE_PWM_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_FORCE_PWM_DEFAULT	\
	(AW87XXX_PID_60_BST_FORCE_PWM_DEFAULT_VALUE << AW87XXX_PID_60_BST_FORCE_PWM_START_BIT)

/* BST_OVP2_EN bit 5 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_OVP2_EN_START_BIT	(5)
#define AW87XXX_PID_60_BST_OVP2_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP2_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP2_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP2_EN_START_BIT))

#define AW87XXX_PID_60_BST_OVP2_EN_DISABLE	(0)
#define AW87XXX_PID_60_BST_OVP2_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_EN_DISABLE << AW87XXX_PID_60_BST_OVP2_EN_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_OVP2_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_OVP2_EN_ENABLE << AW87XXX_PID_60_BST_OVP2_EN_START_BIT)

#define AW87XXX_PID_60_BST_OVP2_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_OVP2_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP2_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP2_EN_START_BIT)

/* BST_OVP_DEGLI_SEL bit 6 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_START_BIT	(6)
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP_DEGLI_SEL_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP_DEGLI_SEL_START_BIT))

#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_NO_DEGLITCH	(0)
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_NO_DEGLITCH_VALUE	\
	(AW87XXX_PID_60_BST_OVP_DEGLI_SEL_NO_DEGLITCH << AW87XXX_PID_60_BST_OVP_DEGLI_SEL_START_BIT)

#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEGLITCH	(1)
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEGLITCH_VALUE	\
	(AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEGLITCH << AW87XXX_PID_60_BST_OVP_DEGLI_SEL_START_BIT)

#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP_DEGLI_SEL_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP_DEGLI_SEL_START_BIT)

/* BST_CLK_DIV bit 7 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BST_CLK_DIV_START_BIT	(7)
#define AW87XXX_PID_60_BST_CLK_DIV_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_CLK_DIV_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_CLK_DIV_BITS_LEN)-1) << AW87XXX_PID_60_BST_CLK_DIV_START_BIT))

#define AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_4	(0)
#define AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_4_VALUE	\
	(AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_4 << AW87XXX_PID_60_BST_CLK_DIV_START_BIT)

#define AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_2	(1)
#define AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_2_VALUE	\
	(AW87XXX_PID_60_BST_CLK_DIV_DIV_BY_2 << AW87XXX_PID_60_BST_CLK_DIV_START_BIT)

#define AW87XXX_PID_60_BST_CLK_DIV_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_CLK_DIV_DEFAULT	\
	(AW87XXX_PID_60_BST_CLK_DIV_DEFAULT_VALUE << AW87XXX_PID_60_BST_CLK_DIV_START_BIT)

/* BURST_HYS_EN bit 4:3 (BST_OVP 0x67) */
#define AW87XXX_PID_60_BURST_HYS_EN_START_BIT	(3)
#define AW87XXX_PID_60_BURST_HYS_EN_BITS_LEN	(2)
#define AW87XXX_PID_60_BURST_HYS_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BURST_HYS_EN_BITS_LEN)-1) << AW87XXX_PID_60_BURST_HYS_EN_START_BIT))

#define AW87XXX_PID_60_BURST_HYS_EN_OUT	(0)
#define AW87XXX_PID_60_BURST_HYS_EN_OUT_VALUE	\
	(AW87XXX_PID_60_BURST_HYS_EN_OUT << AW87XXX_PID_60_BURST_HYS_EN_START_BIT)

#define AW87XXX_PID_60_BURST_HYS_EN_IN	(1)
#define AW87XXX_PID_60_BURST_HYS_EN_IN_VALUE	\
	(AW87XXX_PID_60_BURST_HYS_EN_IN << AW87XXX_PID_60_BURST_HYS_EN_START_BIT)

#define AW87XXX_PID_60_BURST_HYS_EN_OUT_AND_IN	(3)
#define AW87XXX_PID_60_BURST_HYS_EN_OUT_AND_IN_VALUE	\
	(AW87XXX_PID_60_BURST_HYS_EN_OUT_AND_IN << AW87XXX_PID_60_BURST_HYS_EN_START_BIT)

#define AW87XXX_PID_60_BURST_HYS_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BURST_HYS_EN_DEFAULT	\
	(AW87XXX_PID_60_BURST_HYS_EN_DEFAULT_VALUE << AW87XXX_PID_60_BURST_HYS_EN_START_BIT)

/* default value of BST_OVP (0x67) */
/* #define AW87XXX_PID_60_BST_OVP_DEFAULT		(0x81) */

/* LINE_MODE (0x68) detail */
/* BST_EN_RSQN_DLY bit 0 (LINE_MODE 0x68) */
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_START_BIT	(0)
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_EN_RSQN_DLY_BITS_LEN)-1) << AW87XXX_PID_60_BST_EN_RSQN_DLY_START_BIT))

#define AW87XXX_PID_60_BST_EN_RSQN_DLY_DISABLE	(0)
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_EN_RSQN_DLY_DISABLE << AW87XXX_PID_60_BST_EN_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_EN_RSQN_DLY_ENABLE	(1)
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_EN_RSQN_DLY_ENABLE << AW87XXX_PID_60_BST_EN_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_EN_RSQN_DLY_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_EN_RSQN_DLY_DEFAULT	\
	(AW87XXX_PID_60_BST_EN_RSQN_DLY_DEFAULT_VALUE << AW87XXX_PID_60_BST_EN_RSQN_DLY_START_BIT)

/* BST_FORCE_BOOST bit 1 (LINE_MODE 0x68) */
#define AW87XXX_PID_60_BST_FORCE_BOOST_START_BIT	(1)
#define AW87XXX_PID_60_BST_FORCE_BOOST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_FORCE_BOOST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_FORCE_BOOST_BITS_LEN)-1) << AW87XXX_PID_60_BST_FORCE_BOOST_START_BIT))

#define AW87XXX_PID_60_BST_FORCE_BOOST_DISABLE	(0)
#define AW87XXX_PID_60_BST_FORCE_BOOST_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_FORCE_BOOST_DISABLE << AW87XXX_PID_60_BST_FORCE_BOOST_START_BIT)

#define AW87XXX_PID_60_BST_FORCE_BOOST_ENABLE	(1)
#define AW87XXX_PID_60_BST_FORCE_BOOST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_FORCE_BOOST_ENABLE << AW87XXX_PID_60_BST_FORCE_BOOST_START_BIT)

#define AW87XXX_PID_60_BST_FORCE_BOOST_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_FORCE_BOOST_DEFAULT	\
	(AW87XXX_PID_60_BST_FORCE_BOOST_DEFAULT_VALUE << AW87XXX_PID_60_BST_FORCE_BOOST_START_BIT)

/* BST_PWM_SHORT bit 2 (LINE_MODE 0x68) */
#define AW87XXX_PID_60_BST_PWM_SHORT_START_BIT	(2)
#define AW87XXX_PID_60_BST_PWM_SHORT_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_PWM_SHORT_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_PWM_SHORT_BITS_LEN)-1) << AW87XXX_PID_60_BST_PWM_SHORT_START_BIT))

#define AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDD	(0)
#define AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDD_VALUE	\
	(AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDD << AW87XXX_PID_60_BST_PWM_SHORT_START_BIT)

#define AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDDMINUSVTH	(1)
#define AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDDMINUSVTH_VALUE	\
	(AW87XXX_PID_60_BST_PWM_SHORT_VBSTBELOWVDDMINUSVTH << AW87XXX_PID_60_BST_PWM_SHORT_START_BIT)

#define AW87XXX_PID_60_BST_PWM_SHORT_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_PWM_SHORT_DEFAULT	\
	(AW87XXX_PID_60_BST_PWM_SHORT_DEFAULT_VALUE << AW87XXX_PID_60_BST_PWM_SHORT_START_BIT)

/* BST_OS_WIDTH bit 7:5 (LINE_MODE 0x68) */
#define AW87XXX_PID_60_BST_OS_WIDTH_START_BIT	(5)
#define AW87XXX_PID_60_BST_OS_WIDTH_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_OS_WIDTH_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OS_WIDTH_BITS_LEN)-1) << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT))

#define AW87XXX_PID_60_BST_OS_WIDTH_10NS	(0)
#define AW87XXX_PID_60_BST_OS_WIDTH_10NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_10NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_20NS	(1)
#define AW87XXX_PID_60_BST_OS_WIDTH_20NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_20NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_30NS	(2)
#define AW87XXX_PID_60_BST_OS_WIDTH_30NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_30NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_40NS	(3)
#define AW87XXX_PID_60_BST_OS_WIDTH_40NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_40NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_50NS	(4)
#define AW87XXX_PID_60_BST_OS_WIDTH_50NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_50NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_60NS	(5)
#define AW87XXX_PID_60_BST_OS_WIDTH_60NS_VALUE	\
	(AW87XXX_PID_60_BST_OS_WIDTH_60NS << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

#define AW87XXX_PID_60_BST_OS_WIDTH_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_OS_WIDTH_DEFAULT	\
	(AW87XXX_PID_60_BST_OS_WIDTH_DEFAULT_VALUE << AW87XXX_PID_60_BST_OS_WIDTH_START_BIT)

/* MODE1_START_DELAY bit 4:3 (LINE_MODE 0x68) */
#define AW87XXX_PID_60_MODE1_START_DELAY_START_BIT	(3)
#define AW87XXX_PID_60_MODE1_START_DELAY_BITS_LEN	(2)
#define AW87XXX_PID_60_MODE1_START_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_MODE1_START_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT))

#define AW87XXX_PID_60_MODE1_START_DELAY_15P6US	(0)
#define AW87XXX_PID_60_MODE1_START_DELAY_15P6US_VALUE	\
	(AW87XXX_PID_60_MODE1_START_DELAY_15P6US << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT)

#define AW87XXX_PID_60_MODE1_START_DELAY_11P4US	(1)
#define AW87XXX_PID_60_MODE1_START_DELAY_11P4US_VALUE	\
	(AW87XXX_PID_60_MODE1_START_DELAY_11P4US << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT)

#define AW87XXX_PID_60_MODE1_START_DELAY_7P3US	(2)
#define AW87XXX_PID_60_MODE1_START_DELAY_7P3US_VALUE	\
	(AW87XXX_PID_60_MODE1_START_DELAY_7P3US << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT)

#define AW87XXX_PID_60_MODE1_START_DELAY_3US	(3)
#define AW87XXX_PID_60_MODE1_START_DELAY_3US_VALUE	\
	(AW87XXX_PID_60_MODE1_START_DELAY_3US << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT)

#define AW87XXX_PID_60_MODE1_START_DELAY_DEFAULT_VALUE	(3)
#define AW87XXX_PID_60_MODE1_START_DELAY_DEFAULT	\
	(AW87XXX_PID_60_MODE1_START_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_MODE1_START_DELAY_START_BIT)

/* default value of LINE_MODE (0x68) */
/* #define AW87XXX_PID_60_LINE_MODE_DEFAULT		(0x3F) */

/* BST_ISEN (0x69) detail */
/* BST_RSQN_DLY bit 7:5 (BST_ISEN 0x69) */
#define AW87XXX_PID_60_BST_RSQN_DLY_START_BIT	(5)
#define AW87XXX_PID_60_BST_RSQN_DLY_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_RSQN_DLY_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_RSQN_DLY_BITS_LEN)-1) << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT))

#define AW87XXX_PID_60_BST_RSQN_DLY_15NS	(0)
#define AW87XXX_PID_60_BST_RSQN_DLY_15NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_15NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_25NS	(1)
#define AW87XXX_PID_60_BST_RSQN_DLY_25NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_25NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_35NS	(2)
#define AW87XXX_PID_60_BST_RSQN_DLY_35NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_35NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_45NS	(3)
#define AW87XXX_PID_60_BST_RSQN_DLY_45NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_45NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_70NS	(4)
#define AW87XXX_PID_60_BST_RSQN_DLY_70NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_70NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_80NS	(5)
#define AW87XXX_PID_60_BST_RSQN_DLY_80NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_80NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_90NS	(6)
#define AW87XXX_PID_60_BST_RSQN_DLY_90NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_90NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_100NS	(7)
#define AW87XXX_PID_60_BST_RSQN_DLY_100NS_VALUE	\
	(AW87XXX_PID_60_BST_RSQN_DLY_100NS << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

#define AW87XXX_PID_60_BST_RSQN_DLY_DEFAULT_VALUE	(2)
#define AW87XXX_PID_60_BST_RSQN_DLY_DEFAULT	\
	(AW87XXX_PID_60_BST_RSQN_DLY_DEFAULT_VALUE << AW87XXX_PID_60_BST_RSQN_DLY_START_BIT)

/* BST_SLOPE bit 4:3 (BST_ISEN 0x69) */
#define AW87XXX_PID_60_BST_SLOPE_START_BIT	(3)
#define AW87XXX_PID_60_BST_SLOPE_BITS_LEN	(2)
#define AW87XXX_PID_60_BST_SLOPE_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SLOPE_BITS_LEN)-1) << AW87XXX_PID_60_BST_SLOPE_START_BIT))

#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1	(0)
#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_ISLOPE1 << AW87XXX_PID_60_BST_SLOPE_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P25	(1)
#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P25_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_ISLOPE1P25 << AW87XXX_PID_60_BST_SLOPE_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P5	(2)
#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P5_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_ISLOPE1P5 << AW87XXX_PID_60_BST_SLOPE_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P75	(3)
#define AW87XXX_PID_60_BST_SLOPE_ISLOPE1P75_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_ISLOPE1P75 << AW87XXX_PID_60_BST_SLOPE_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SLOPE_DEFAULT	\
	(AW87XXX_PID_60_BST_SLOPE_DEFAULT_VALUE << AW87XXX_PID_60_BST_SLOPE_START_BIT)

/* BST_SLOPE_LIMIT bit 2:0 (BST_ISEN 0x69) */
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT	(0)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SLOPE_LIMIT_BITS_LEN)-1) << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT))

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_0P50ISLOPE	(0)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_0P50ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_0P50ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_0P75ISLOPE	(1)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_0P75ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_0P75ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P00ISLOPE	(2)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P00ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_1P00ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P25ISLOPE	(3)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P25ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_1P25ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P50ISLOPE	(4)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P50ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_1P50ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P75ISLOPE	(5)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_1P75ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_1P75ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_2P00ISLOPE	(6)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_2P00ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_2P00ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_2P25ISLOPE	(7)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_2P25ISLOPE_VALUE	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_2P25ISLOPE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

#define AW87XXX_PID_60_BST_SLOPE_LIMIT_DEFAULT_VALUE	(2)
#define AW87XXX_PID_60_BST_SLOPE_LIMIT_DEFAULT	\
	(AW87XXX_PID_60_BST_SLOPE_LIMIT_DEFAULT_VALUE << AW87XXX_PID_60_BST_SLOPE_LIMIT_START_BIT)

/* default value of BST_ISEN (0x69) */
/* #define AW87XXX_PID_60_BST_ISEN_DEFAULT		(0x42) */

/* BST_PEAK (0x6A) detail */
/* BST_IPEAK_LOWBAT bit 3 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_START_BIT	(3)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_LOWBAT_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_LOWBAT_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P5A	(0)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P5A << AW87XXX_PID_60_BST_IPEAK_LOWBAT_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P75A	(1)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P75A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_2P75A << AW87XXX_PID_60_BST_IPEAK_LOWBAT_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_LOWBAT_START_BIT)

/* BST_IPEAK_LOWBAT_EN bit 4 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_START_BIT	(4)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DISABLE	(0)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DISABLE << AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_ENABLE << AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_LOWBAT_EN_START_BIT)

/* BST_IPEAK_ADJ bit 5 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_BST_IPEAK_ADJ_START_BIT	(5)
#define AW87XXX_PID_60_BST_IPEAK_ADJ_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_IPEAK_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_ADJ_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_ADJ_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK	(0)
#define AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK << AW87XXX_PID_60_BST_IPEAK_ADJ_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK0P5A	(1)
#define AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK0P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_ADJ_IPEAK0P5A << AW87XXX_PID_60_BST_IPEAK_ADJ_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_ADJ_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_IPEAK_ADJ_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_ADJ_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_ADJ_START_BIT)

/* BACK_ADPT_R400K bit 6 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_BACK_ADPT_R400K_START_BIT	(6)
#define AW87XXX_PID_60_BACK_ADPT_R400K_BITS_LEN	(1)
#define AW87XXX_PID_60_BACK_ADPT_R400K_MASK	\
	(~(((1<<AW87XXX_PID_60_BACK_ADPT_R400K_BITS_LEN)-1) << AW87XXX_PID_60_BACK_ADPT_R400K_START_BIT))

#define AW87XXX_PID_60_BACK_ADPT_R400K_DISABLE	(0)
#define AW87XXX_PID_60_BACK_ADPT_R400K_DISABLE_VALUE	\
	(AW87XXX_PID_60_BACK_ADPT_R400K_DISABLE << AW87XXX_PID_60_BACK_ADPT_R400K_START_BIT)

#define AW87XXX_PID_60_BACK_ADPT_R400K_ENABALE	(1)
#define AW87XXX_PID_60_BACK_ADPT_R400K_ENABALE_VALUE	\
	(AW87XXX_PID_60_BACK_ADPT_R400K_ENABALE << AW87XXX_PID_60_BACK_ADPT_R400K_START_BIT)

#define AW87XXX_PID_60_BACK_ADPT_R400K_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BACK_ADPT_R400K_DEFAULT	\
	(AW87XXX_PID_60_BACK_ADPT_R400K_DEFAULT_VALUE << AW87XXX_PID_60_BACK_ADPT_R400K_START_BIT)

/* SEL_FINISH_ID bit 7 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_SEL_FINISH_ID_START_BIT	(7)
#define AW87XXX_PID_60_SEL_FINISH_ID_BITS_LEN	(1)
#define AW87XXX_PID_60_SEL_FINISH_ID_MASK	\
	(~(((1<<AW87XXX_PID_60_SEL_FINISH_ID_BITS_LEN)-1) << AW87XXX_PID_60_SEL_FINISH_ID_START_BIT))

#define AW87XXX_PID_60_SEL_FINISH_ID_MODE1START	(0)
#define AW87XXX_PID_60_SEL_FINISH_ID_MODE1START_VALUE	\
	(AW87XXX_PID_60_SEL_FINISH_ID_MODE1START << AW87XXX_PID_60_SEL_FINISH_ID_START_BIT)

#define AW87XXX_PID_60_SEL_FINISH_ID_LIMITSSFINISH	(1)
#define AW87XXX_PID_60_SEL_FINISH_ID_LIMITSSFINISH_VALUE	\
	(AW87XXX_PID_60_SEL_FINISH_ID_LIMITSSFINISH << AW87XXX_PID_60_SEL_FINISH_ID_START_BIT)

#define AW87XXX_PID_60_SEL_FINISH_ID_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_SEL_FINISH_ID_DEFAULT	\
	(AW87XXX_PID_60_SEL_FINISH_ID_DEFAULT_VALUE << AW87XXX_PID_60_SEL_FINISH_ID_START_BIT)

/* BST_IPEAK_SS bit 2:0 (BST_PEAK 0x6A) */
#define AW87XXX_PID_60_BST_IPEAK_SS_START_BIT	(0)
#define AW87XXX_PID_60_BST_IPEAK_SS_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_IPEAK_SS_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_SS_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_SS_0P8A	(0)
#define AW87XXX_PID_60_BST_IPEAK_SS_0P8A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_0P8A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_1P0A	(1)
#define AW87XXX_PID_60_BST_IPEAK_SS_1P0A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_1P0A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_1P25A	(2)
#define AW87XXX_PID_60_BST_IPEAK_SS_1P25A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_1P25A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_1P5A	(3)
#define AW87XXX_PID_60_BST_IPEAK_SS_1P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_1P5A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_1P75A	(4)
#define AW87XXX_PID_60_BST_IPEAK_SS_1P75A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_1P75A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_2A	(5)
#define AW87XXX_PID_60_BST_IPEAK_SS_2A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_2A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_2P25A	(6)
#define AW87XXX_PID_60_BST_IPEAK_SS_2P25A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_2P25A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_2P50A	(7)
#define AW87XXX_PID_60_BST_IPEAK_SS_2P50A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_SS_2P50A << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_SS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_60_BST_IPEAK_SS_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_SS_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_SS_START_BIT)

/* default value of BST_PEAK (0x6A) */
/* #define AW87XXX_PID_60_BST_PEAK_DEFAULT		(0x01) */

/* BST_PEAK2 (0x6B) detail */
/* BST_BACK_EN bit 2 (BST_PEAK2 0x6B) */
#define AW87XXX_PID_60_BST_BACK_EN_START_BIT	(2)
#define AW87XXX_PID_60_BST_BACK_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_BACK_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BACK_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_BACK_EN_START_BIT))

#define AW87XXX_PID_60_BST_BACK_EN_ENABLE	(0)
#define AW87XXX_PID_60_BST_BACK_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_BACK_EN_ENABLE << AW87XXX_PID_60_BST_BACK_EN_START_BIT)

#define AW87XXX_PID_60_BST_BACK_EN_DIABALE	(1)
#define AW87XXX_PID_60_BST_BACK_EN_DIABALE_VALUE	\
	(AW87XXX_PID_60_BST_BACK_EN_DIABALE << AW87XXX_PID_60_BST_BACK_EN_START_BIT)

#define AW87XXX_PID_60_BST_BACK_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_BACK_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_BACK_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_BACK_EN_START_BIT)

/* BST_IPEAK_ITH_EN bit 3 (BST_PEAK2 0x6B) */
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_START_BIT	(3)
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_ITH_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_ITH_EN_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAK	(0)
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAK_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAK << AW87XXX_PID_60_BST_IPEAK_ITH_EN_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAKMINUS0P5A	(1)
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAKMINUS0P5A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_ITH_EN_IPEAKMINUS0P5A << AW87XXX_PID_60_BST_IPEAK_ITH_EN_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_IPEAK_ITH_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_ITH_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_ITH_EN_START_BIT)

/* BST_IPEAK_TRIM bit 7:4 (BST_PEAK2 0x6B) */
#define AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT	(4)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_BITS_LEN	(4)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_IPEAK_TRIM_BITS_LEN)-1) << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT))

#define AW87XXX_PID_60_BST_IPEAK_TRIM_0A	(0)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_0A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_0A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P2A	(1)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P2A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_0P2A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P4A	(2)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P4A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_0P4A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P6A	(3)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_0P6A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_0P6A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P6A	(8)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P6A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P6A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P4A	(9)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P4A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P4A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P2A	(10)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P2A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1P2A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1A	(11)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS1A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P8A	(12)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P8A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P8A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P6A	(13)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P6A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P6A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P4A	(14)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P4A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P4A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P2A	(15)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P2A_VALUE	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_MINUS0P2A << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

#define AW87XXX_PID_60_BST_IPEAK_TRIM_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_IPEAK_TRIM_DEFAULT	\
	(AW87XXX_PID_60_BST_IPEAK_TRIM_DEFAULT_VALUE << AW87XXX_PID_60_BST_IPEAK_TRIM_START_BIT)

/* OFFTIME_OUT_C bit 1:0 (BST_PEAK2 0x6B) */
#define AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT	(0)
#define AW87XXX_PID_60_OFFTIME_OUT_C_BITS_LEN	(2)
#define AW87XXX_PID_60_OFFTIME_OUT_C_MASK	\
	(~(((1<<AW87XXX_PID_60_OFFTIME_OUT_C_BITS_LEN)-1) << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT))

#define AW87XXX_PID_60_OFFTIME_OUT_C_0	(0)
#define AW87XXX_PID_60_OFFTIME_OUT_C_0_VALUE	\
	(AW87XXX_PID_60_OFFTIME_OUT_C_0 << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT)

#define AW87XXX_PID_60_OFFTIME_OUT_C_1	(1)
#define AW87XXX_PID_60_OFFTIME_OUT_C_1_VALUE	\
	(AW87XXX_PID_60_OFFTIME_OUT_C_1 << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT)

#define AW87XXX_PID_60_OFFTIME_OUT_C_2	(2)
#define AW87XXX_PID_60_OFFTIME_OUT_C_2_VALUE	\
	(AW87XXX_PID_60_OFFTIME_OUT_C_2 << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT)

#define AW87XXX_PID_60_OFFTIME_OUT_C_3	(3)
#define AW87XXX_PID_60_OFFTIME_OUT_C_3_VALUE	\
	(AW87XXX_PID_60_OFFTIME_OUT_C_3 << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT)

#define AW87XXX_PID_60_OFFTIME_OUT_C_DEFAULT_VALUE	(2)
#define AW87XXX_PID_60_OFFTIME_OUT_C_DEFAULT	\
	(AW87XXX_PID_60_OFFTIME_OUT_C_DEFAULT_VALUE << AW87XXX_PID_60_OFFTIME_OUT_C_START_BIT)

/* default value of BST_PEAK2 (0x6B) */
/* #define AW87XXX_PID_60_BST_PEAK2_DEFAULT		(0x02) */

/* OFFTIME (0x6C) detail */
/* HEAD_ROOM bit 3 (OFFTIME 0x6C) */
#define AW87XXX_PID_60_HEAD_ROOM_START_BIT	(3)
#define AW87XXX_PID_60_HEAD_ROOM_BITS_LEN	(1)
#define AW87XXX_PID_60_HEAD_ROOM_MASK	\
	(~(((1<<AW87XXX_PID_60_HEAD_ROOM_BITS_LEN)-1) << AW87XXX_PID_60_HEAD_ROOM_START_BIT))

#define AW87XXX_PID_60_HEAD_ROOM_1P5V	(0)
#define AW87XXX_PID_60_HEAD_ROOM_1P5V_VALUE	\
	(AW87XXX_PID_60_HEAD_ROOM_1P5V << AW87XXX_PID_60_HEAD_ROOM_START_BIT)

#define AW87XXX_PID_60_HEAD_ROOM_2P0V	(1)
#define AW87XXX_PID_60_HEAD_ROOM_2P0V_VALUE	\
	(AW87XXX_PID_60_HEAD_ROOM_2P0V << AW87XXX_PID_60_HEAD_ROOM_START_BIT)

#define AW87XXX_PID_60_HEAD_ROOM_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_HEAD_ROOM_DEFAULT	\
	(AW87XXX_PID_60_HEAD_ROOM_DEFAULT_VALUE << AW87XXX_PID_60_HEAD_ROOM_START_BIT)

/* BST_OFFTIME_EN bit 7 (OFFTIME 0x6C) */
#define AW87XXX_PID_60_BST_OFFTIME_EN_START_BIT	(7)
#define AW87XXX_PID_60_BST_OFFTIME_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OFFTIME_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OFFTIME_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_OFFTIME_EN_START_BIT))

#define AW87XXX_PID_60_BST_OFFTIME_EN_ENABLE	(0)
#define AW87XXX_PID_60_BST_OFFTIME_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_EN_ENABLE << AW87XXX_PID_60_BST_OFFTIME_EN_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_EN_DIABALE	(1)
#define AW87XXX_PID_60_BST_OFFTIME_EN_DIABALE_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_EN_DIABALE << AW87XXX_PID_60_BST_OFFTIME_EN_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_OFFTIME_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_OFFTIME_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_OFFTIME_EN_START_BIT)

/* BST_OFFTIME bit 6:4 (OFFTIME 0x6C) */
#define AW87XXX_PID_60_BST_OFFTIME_START_BIT	(4)
#define AW87XXX_PID_60_BST_OFFTIME_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_OFFTIME_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OFFTIME_BITS_LEN)-1) << AW87XXX_PID_60_BST_OFFTIME_START_BIT))

#define AW87XXX_PID_60_BST_OFFTIME_4	(0)
#define AW87XXX_PID_60_BST_OFFTIME_4_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_4 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_3	(1)
#define AW87XXX_PID_60_BST_OFFTIME_3_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_3 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_2	(2)
#define AW87XXX_PID_60_BST_OFFTIME_2_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_2 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_1	(3)
#define AW87XXX_PID_60_BST_OFFTIME_1_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_1 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_0	(4)
#define AW87XXX_PID_60_BST_OFFTIME_0_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_0 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_MINUS1	(5)
#define AW87XXX_PID_60_BST_OFFTIME_MINUS1_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_MINUS1 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_MINUS2	(6)
#define AW87XXX_PID_60_BST_OFFTIME_MINUS2_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_MINUS2 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_MINUS3	(7)
#define AW87XXX_PID_60_BST_OFFTIME_MINUS3_VALUE	\
	(AW87XXX_PID_60_BST_OFFTIME_MINUS3 << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

#define AW87XXX_PID_60_BST_OFFTIME_DEFAULT_VALUE	(4)
#define AW87XXX_PID_60_BST_OFFTIME_DEFAULT	\
	(AW87XXX_PID_60_BST_OFFTIME_DEFAULT_VALUE << AW87XXX_PID_60_BST_OFFTIME_START_BIT)

/* BST_OUT_VTH0 bit 2:0 (OFFTIME 0x6C) */
#define AW87XXX_PID_60_BST_OUT_VTH0_START_BIT	(0)
#define AW87XXX_PID_60_BST_OUT_VTH0_BITS_LEN	(3)
#define AW87XXX_PID_60_BST_OUT_VTH0_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OUT_VTH0_BITS_LEN)-1) << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT))

#define AW87XXX_PID_60_BST_OUT_VTH0_6P5V	(0)
#define AW87XXX_PID_60_BST_OUT_VTH0_6P5V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_6P5V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_6P75V	(1)
#define AW87XXX_PID_60_BST_OUT_VTH0_6P75V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_6P75V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_7P0V	(2)
#define AW87XXX_PID_60_BST_OUT_VTH0_7P0V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_7P0V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_7P25V	(3)
#define AW87XXX_PID_60_BST_OUT_VTH0_7P25V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_7P25V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_7P5V	(4)
#define AW87XXX_PID_60_BST_OUT_VTH0_7P5V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_7P5V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_7P75V	(5)
#define AW87XXX_PID_60_BST_OUT_VTH0_7P75V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_7P75V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_8P0V	(6)
#define AW87XXX_PID_60_BST_OUT_VTH0_8P0V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_8P0V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_8P25V	(7)
#define AW87XXX_PID_60_BST_OUT_VTH0_8P25V_VALUE	\
	(AW87XXX_PID_60_BST_OUT_VTH0_8P25V << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

#define AW87XXX_PID_60_BST_OUT_VTH0_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_BST_OUT_VTH0_DEFAULT	\
	(AW87XXX_PID_60_BST_OUT_VTH0_DEFAULT_VALUE << AW87XXX_PID_60_BST_OUT_VTH0_START_BIT)

/* default value of OFFTIME (0x6C) */
/* #define AW87XXX_PID_60_OFFTIME_DEFAULT		(0x41) */

/* ADPBST (0x6D) detail */
/* REG_CLK_CP_OTA bit 0 (ADPBST 0x6D) */
#define AW87XXX_PID_60_REG_CLK_CP_OTA_START_BIT	(0)
#define AW87XXX_PID_60_REG_CLK_CP_OTA_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_CLK_CP_OTA_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_CLK_CP_OTA_BITS_LEN)-1) << AW87XXX_PID_60_REG_CLK_CP_OTA_START_BIT))

#define AW87XXX_PID_60_REG_CLK_CP_OTA_200KHZ	(0)
#define AW87XXX_PID_60_REG_CLK_CP_OTA_200KHZ_VALUE	\
	(AW87XXX_PID_60_REG_CLK_CP_OTA_200KHZ << AW87XXX_PID_60_REG_CLK_CP_OTA_START_BIT)

#define AW87XXX_PID_60_REG_CLK_CP_OTA_400KHZ	(1)
#define AW87XXX_PID_60_REG_CLK_CP_OTA_400KHZ_VALUE	\
	(AW87XXX_PID_60_REG_CLK_CP_OTA_400KHZ << AW87XXX_PID_60_REG_CLK_CP_OTA_START_BIT)

#define AW87XXX_PID_60_REG_CLK_CP_OTA_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_CLK_CP_OTA_DEFAULT	\
	(AW87XXX_PID_60_REG_CLK_CP_OTA_DEFAULT_VALUE << AW87XXX_PID_60_REG_CLK_CP_OTA_START_BIT)

/* OTA_MD2 bit 1 (ADPBST 0x6D) */
#define AW87XXX_PID_60_OTA_MD2_START_BIT	(1)
#define AW87XXX_PID_60_OTA_MD2_BITS_LEN	(1)
#define AW87XXX_PID_60_OTA_MD2_MASK		\
	(~(((1<<AW87XXX_PID_60_OTA_MD2_BITS_LEN)-1) << AW87XXX_PID_60_OTA_MD2_START_BIT))

#define AW87XXX_PID_60_OTA_MD2_DISABLE	(0)
#define AW87XXX_PID_60_OTA_MD2_DISABLE_VALUE	\
	(AW87XXX_PID_60_OTA_MD2_DISABLE << AW87XXX_PID_60_OTA_MD2_START_BIT)

#define AW87XXX_PID_60_OTA_MD2_ENABLE	(1)
#define AW87XXX_PID_60_OTA_MD2_ENABLE_VALUE	\
	(AW87XXX_PID_60_OTA_MD2_ENABLE << AW87XXX_PID_60_OTA_MD2_START_BIT)

#define AW87XXX_PID_60_OTA_MD2_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_OTA_MD2_DEFAULT	\
	(AW87XXX_PID_60_OTA_MD2_DEFAULT_VALUE << AW87XXX_PID_60_OTA_MD2_START_BIT)

/* OTA_RCV bit 2 (ADPBST 0x6D) */
#define AW87XXX_PID_60_OTA_RCV_START_BIT	(2)
#define AW87XXX_PID_60_OTA_RCV_BITS_LEN	(1)
#define AW87XXX_PID_60_OTA_RCV_MASK		\
	(~(((1<<AW87XXX_PID_60_OTA_RCV_BITS_LEN)-1) << AW87XXX_PID_60_OTA_RCV_START_BIT))

#define AW87XXX_PID_60_OTA_RCV_DISABLE	(0)
#define AW87XXX_PID_60_OTA_RCV_DISABLE_VALUE	\
	(AW87XXX_PID_60_OTA_RCV_DISABLE << AW87XXX_PID_60_OTA_RCV_START_BIT)

#define AW87XXX_PID_60_OTA_RCV_ENABLE	(1)
#define AW87XXX_PID_60_OTA_RCV_ENABLE_VALUE	\
	(AW87XXX_PID_60_OTA_RCV_ENABLE << AW87XXX_PID_60_OTA_RCV_START_BIT)

#define AW87XXX_PID_60_OTA_RCV_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_OTA_RCV_DEFAULT	\
	(AW87XXX_PID_60_OTA_RCV_DEFAULT_VALUE << AW87XXX_PID_60_OTA_RCV_START_BIT)

/* MSBM_VDD_SEL bit 3 (ADPBST 0x6D) */
#define AW87XXX_PID_60_MSBM_VDD_SEL_START_BIT	(3)
#define AW87XXX_PID_60_MSBM_VDD_SEL_BITS_LEN	(1)
#define AW87XXX_PID_60_MSBM_VDD_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_MSBM_VDD_SEL_BITS_LEN)-1) << AW87XXX_PID_60_MSBM_VDD_SEL_START_BIT))

#define AW87XXX_PID_60_MSBM_VDD_SEL_VDDBELOW4P5V	(0)
#define AW87XXX_PID_60_MSBM_VDD_SEL_VDDBELOW4P5V_VALUE	\
	(AW87XXX_PID_60_MSBM_VDD_SEL_VDDBELOW4P5V << AW87XXX_PID_60_MSBM_VDD_SEL_START_BIT)

#define AW87XXX_PID_60_MSBM_VDD_SEL_VDDABOVE4P5V	(1)
#define AW87XXX_PID_60_MSBM_VDD_SEL_VDDABOVE4P5V_VALUE	\
	(AW87XXX_PID_60_MSBM_VDD_SEL_VDDABOVE4P5V << AW87XXX_PID_60_MSBM_VDD_SEL_START_BIT)

#define AW87XXX_PID_60_MSBM_VDD_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_MSBM_VDD_SEL_DEFAULT	\
	(AW87XXX_PID_60_MSBM_VDD_SEL_DEFAULT_VALUE << AW87XXX_PID_60_MSBM_VDD_SEL_START_BIT)

/* DLY_EN bit 4 (ADPBST 0x6D) */
#define AW87XXX_PID_60_DLY_EN_START_BIT	(4)
#define AW87XXX_PID_60_DLY_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_DLY_EN_MASK		\
	(~(((1<<AW87XXX_PID_60_DLY_EN_BITS_LEN)-1) << AW87XXX_PID_60_DLY_EN_START_BIT))

#define AW87XXX_PID_60_DLY_EN_DISABLE	(0)
#define AW87XXX_PID_60_DLY_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_DLY_EN_DISABLE << AW87XXX_PID_60_DLY_EN_START_BIT)

#define AW87XXX_PID_60_DLY_EN_ENABLE	(1)
#define AW87XXX_PID_60_DLY_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_DLY_EN_ENABLE << AW87XXX_PID_60_DLY_EN_START_BIT)

#define AW87XXX_PID_60_DLY_EN_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_DLY_EN_DEFAULT	\
	(AW87XXX_PID_60_DLY_EN_DEFAULT_VALUE << AW87XXX_PID_60_DLY_EN_START_BIT)

/* DLY_CLK_EN bit 5 (ADPBST 0x6D) */
#define AW87XXX_PID_60_DLY_CLK_EN_START_BIT	(5)
#define AW87XXX_PID_60_DLY_CLK_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_DLY_CLK_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_DLY_CLK_EN_BITS_LEN)-1) << AW87XXX_PID_60_DLY_CLK_EN_START_BIT))

#define AW87XXX_PID_60_DLY_CLK_EN_DISABLE	(0)
#define AW87XXX_PID_60_DLY_CLK_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_DLY_CLK_EN_DISABLE << AW87XXX_PID_60_DLY_CLK_EN_START_BIT)

#define AW87XXX_PID_60_DLY_CLK_EN_ENABLE	(1)
#define AW87XXX_PID_60_DLY_CLK_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_DLY_CLK_EN_ENABLE << AW87XXX_PID_60_DLY_CLK_EN_START_BIT)

#define AW87XXX_PID_60_DLY_CLK_EN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_DLY_CLK_EN_DEFAULT	\
	(AW87XXX_PID_60_DLY_CLK_EN_DEFAULT_VALUE << AW87XXX_PID_60_DLY_CLK_EN_START_BIT)

/* ADPBST_FALL_TIME bit 7:6 (ADPBST 0x6D) */
#define AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT	(6)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_BITS_LEN	(2)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_ADPBST_FALL_TIME_BITS_LEN)-1) << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT))

#define AW87XXX_PID_60_ADPBST_FALL_TIME_5MS	(0)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_5MS_VALUE	\
	(AW87XXX_PID_60_ADPBST_FALL_TIME_5MS << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT)

#define AW87XXX_PID_60_ADPBST_FALL_TIME_10MS	(1)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_10MS_VALUE	\
	(AW87XXX_PID_60_ADPBST_FALL_TIME_10MS << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT)

#define AW87XXX_PID_60_ADPBST_FALL_TIME_20MS	(2)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_20MS_VALUE	\
	(AW87XXX_PID_60_ADPBST_FALL_TIME_20MS << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT)

#define AW87XXX_PID_60_ADPBST_FALL_TIME_40MS	(3)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_40MS_VALUE	\
	(AW87XXX_PID_60_ADPBST_FALL_TIME_40MS << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT)

#define AW87XXX_PID_60_ADPBST_FALL_TIME_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_ADPBST_FALL_TIME_DEFAULT	\
	(AW87XXX_PID_60_ADPBST_FALL_TIME_DEFAULT_VALUE << AW87XXX_PID_60_ADPBST_FALL_TIME_START_BIT)

/* default value of ADPBST (0x6D) */
/* #define AW87XXX_PID_60_ADPBST_DEFAULT		(0x50) */

/* OTA (0x6E) detail */
/* EN_SWF bit 0 (OTA 0x6E) */
#define AW87XXX_PID_60_EN_SWF_START_BIT	(0)
#define AW87XXX_PID_60_EN_SWF_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_SWF_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_SWF_BITS_LEN)-1) << AW87XXX_PID_60_EN_SWF_START_BIT))

#define AW87XXX_PID_60_EN_SWF_DISABLE	(0)
#define AW87XXX_PID_60_EN_SWF_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_SWF_DISABLE << AW87XXX_PID_60_EN_SWF_START_BIT)

#define AW87XXX_PID_60_EN_SWF_ENABLE	(1)
#define AW87XXX_PID_60_EN_SWF_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_SWF_ENABLE << AW87XXX_PID_60_EN_SWF_START_BIT)

#define AW87XXX_PID_60_EN_SWF_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_SWF_DEFAULT	\
	(AW87XXX_PID_60_EN_SWF_DEFAULT_VALUE << AW87XXX_PID_60_EN_SWF_START_BIT)

/* BST_CK_MODE bit 1 (OTA 0x6E) */
#define AW87XXX_PID_60_BST_CK_MODE_START_BIT	(1)
#define AW87XXX_PID_60_BST_CK_MODE_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_CK_MODE_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_CK_MODE_BITS_LEN)-1) << AW87XXX_PID_60_BST_CK_MODE_START_BIT))

#define AW87XXX_PID_60_BST_CK_MODE_1P6MHZ	(0)
#define AW87XXX_PID_60_BST_CK_MODE_1P6MHZ_VALUE	\
	(AW87XXX_PID_60_BST_CK_MODE_1P6MHZ << AW87XXX_PID_60_BST_CK_MODE_START_BIT)

#define AW87XXX_PID_60_BST_CK_MODE_2P0MHZ	(1)
#define AW87XXX_PID_60_BST_CK_MODE_2P0MHZ_VALUE	\
	(AW87XXX_PID_60_BST_CK_MODE_2P0MHZ << AW87XXX_PID_60_BST_CK_MODE_START_BIT)

#define AW87XXX_PID_60_BST_CK_MODE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_BST_CK_MODE_DEFAULT	\
	(AW87XXX_PID_60_BST_CK_MODE_DEFAULT_VALUE << AW87XXX_PID_60_BST_CK_MODE_START_BIT)

/* EN_LOOP_GBW_REDUCE bit 2 (OTA 0x6E) */
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_START_BIT	(2)
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_BITS_LEN)-1) << AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_START_BIT))

#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DISABLE	(0)
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DISABLE << AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_START_BIT)

#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_ENABLE	(1)
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_ENABLE << AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_START_BIT)

#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DEFAULT	\
	(AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_DEFAULT_VALUE << AW87XXX_PID_60_EN_LOOP_GBW_REDUCE_START_BIT)

/* EN_DEM_POWER bit 3 (OTA 0x6E) */
#define AW87XXX_PID_60_EN_DEM_POWER_START_BIT	(3)
#define AW87XXX_PID_60_EN_DEM_POWER_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_DEM_POWER_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_DEM_POWER_BITS_LEN)-1) << AW87XXX_PID_60_EN_DEM_POWER_START_BIT))

#define AW87XXX_PID_60_EN_DEM_POWER_DISABLE	(0)
#define AW87XXX_PID_60_EN_DEM_POWER_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_DEM_POWER_DISABLE << AW87XXX_PID_60_EN_DEM_POWER_START_BIT)

#define AW87XXX_PID_60_EN_DEM_POWER_ENABLE	(1)
#define AW87XXX_PID_60_EN_DEM_POWER_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_DEM_POWER_ENABLE << AW87XXX_PID_60_EN_DEM_POWER_START_BIT)

#define AW87XXX_PID_60_EN_DEM_POWER_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_DEM_POWER_DEFAULT	\
	(AW87XXX_PID_60_EN_DEM_POWER_DEFAULT_VALUE << AW87XXX_PID_60_EN_DEM_POWER_START_BIT)

/* REG_CLK_CP_RIN bit 4 (OTA 0x6E) */
#define AW87XXX_PID_60_REG_CLK_CP_RIN_START_BIT	(4)
#define AW87XXX_PID_60_REG_CLK_CP_RIN_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_CLK_CP_RIN_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_CLK_CP_RIN_BITS_LEN)-1) << AW87XXX_PID_60_REG_CLK_CP_RIN_START_BIT))

#define AW87XXX_PID_60_REG_CLK_CP_RIN_200KHZ	(0)
#define AW87XXX_PID_60_REG_CLK_CP_RIN_200KHZ_VALUE	\
	(AW87XXX_PID_60_REG_CLK_CP_RIN_200KHZ << AW87XXX_PID_60_REG_CLK_CP_RIN_START_BIT)

#define AW87XXX_PID_60_REG_CLK_CP_RIN_400KHZ	(1)
#define AW87XXX_PID_60_REG_CLK_CP_RIN_400KHZ_VALUE	\
	(AW87XXX_PID_60_REG_CLK_CP_RIN_400KHZ << AW87XXX_PID_60_REG_CLK_CP_RIN_START_BIT)

#define AW87XXX_PID_60_REG_CLK_CP_RIN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_CLK_CP_RIN_DEFAULT	\
	(AW87XXX_PID_60_REG_CLK_CP_RIN_DEFAULT_VALUE << AW87XXX_PID_60_REG_CLK_CP_RIN_START_BIT)

/* EN_DEM bit 5 (OTA 0x6E) */
#define AW87XXX_PID_60_EN_DEM_START_BIT	(5)
#define AW87XXX_PID_60_EN_DEM_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_DEM_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_DEM_BITS_LEN)-1) << AW87XXX_PID_60_EN_DEM_START_BIT))

#define AW87XXX_PID_60_EN_DEM_DISABLE	(0)
#define AW87XXX_PID_60_EN_DEM_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_DEM_DISABLE << AW87XXX_PID_60_EN_DEM_START_BIT)

#define AW87XXX_PID_60_EN_DEM_ENABLE	(1)
#define AW87XXX_PID_60_EN_DEM_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_DEM_ENABLE << AW87XXX_PID_60_EN_DEM_START_BIT)

#define AW87XXX_PID_60_EN_DEM_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_DEM_DEFAULT	\
	(AW87XXX_PID_60_EN_DEM_DEFAULT_VALUE << AW87XXX_PID_60_EN_DEM_START_BIT)

/* OTA_NG bit 6 (OTA 0x6E) */
#define AW87XXX_PID_60_OTA_NG_START_BIT	(6)
#define AW87XXX_PID_60_OTA_NG_BITS_LEN	(1)
#define AW87XXX_PID_60_OTA_NG_MASK		\
	(~(((1<<AW87XXX_PID_60_OTA_NG_BITS_LEN)-1) << AW87XXX_PID_60_OTA_NG_START_BIT))

#define AW87XXX_PID_60_OTA_NG_DISABLE	(0)
#define AW87XXX_PID_60_OTA_NG_DISABLE_VALUE	\
	(AW87XXX_PID_60_OTA_NG_DISABLE << AW87XXX_PID_60_OTA_NG_START_BIT)

#define AW87XXX_PID_60_OTA_NG_ENABLE	(1)
#define AW87XXX_PID_60_OTA_NG_ENABLE_VALUE	\
	(AW87XXX_PID_60_OTA_NG_ENABLE << AW87XXX_PID_60_OTA_NG_START_BIT)

#define AW87XXX_PID_60_OTA_NG_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_OTA_NG_DEFAULT	\
	(AW87XXX_PID_60_OTA_NG_DEFAULT_VALUE << AW87XXX_PID_60_OTA_NG_START_BIT)

/* OTA_CP bit 7 (OTA 0x6E) */
#define AW87XXX_PID_60_OTA_CP_START_BIT	(7)
#define AW87XXX_PID_60_OTA_CP_BITS_LEN	(1)
#define AW87XXX_PID_60_OTA_CP_MASK		\
	(~(((1<<AW87XXX_PID_60_OTA_CP_BITS_LEN)-1) << AW87XXX_PID_60_OTA_CP_START_BIT))

#define AW87XXX_PID_60_OTA_CP_DISABLE	(0)
#define AW87XXX_PID_60_OTA_CP_DISABLE_VALUE	\
	(AW87XXX_PID_60_OTA_CP_DISABLE << AW87XXX_PID_60_OTA_CP_START_BIT)

#define AW87XXX_PID_60_OTA_CP_ENABLE	(1)
#define AW87XXX_PID_60_OTA_CP_ENABLE_VALUE	\
	(AW87XXX_PID_60_OTA_CP_ENABLE << AW87XXX_PID_60_OTA_CP_START_BIT)

#define AW87XXX_PID_60_OTA_CP_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_OTA_CP_DEFAULT	\
	(AW87XXX_PID_60_OTA_CP_DEFAULT_VALUE << AW87XXX_PID_60_OTA_CP_START_BIT)

/* default value of OTA (0x6E) */
/* #define AW87XXX_PID_60_OTA_DEFAULT		(0xC0) */

/* RAMPGEN (0x6F) detail */
/* RAMP_1SPW_VL bit 7:6 (RAMPGEN 0x6F) */
#define AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT	(6)
#define AW87XXX_PID_60_RAMP_1SPW_VL_BITS_LEN	(2)
#define AW87XXX_PID_60_RAMP_1SPW_VL_MASK	\
	(~(((1<<AW87XXX_PID_60_RAMP_1SPW_VL_BITS_LEN)-1) << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT))

#define AW87XXX_PID_60_RAMP_1SPW_VL_0P16VDD	(0)
#define AW87XXX_PID_60_RAMP_1SPW_VL_0P16VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VL_0P16VDD << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VL_0P18VDD	(1)
#define AW87XXX_PID_60_RAMP_1SPW_VL_0P18VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VL_0P18VDD << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VL_0P20VDD	(2)
#define AW87XXX_PID_60_RAMP_1SPW_VL_0P20VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VL_0P20VDD << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VL_0P14VDD	(3)
#define AW87XXX_PID_60_RAMP_1SPW_VL_0P14VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VL_0P14VDD << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_RAMP_1SPW_VL_DEFAULT	\
	(AW87XXX_PID_60_RAMP_1SPW_VL_DEFAULT_VALUE << AW87XXX_PID_60_RAMP_1SPW_VL_START_BIT)

/* PA_RAMP_AGC1 bit 5:4 (RAMPGEN 0x6F) */
#define AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT	(4)
#define AW87XXX_PID_60_PA_RAMP_AGC1_BITS_LEN	(2)
#define AW87XXX_PID_60_PA_RAMP_AGC1_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_RAMP_AGC1_BITS_LEN)-1) << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT))

#define AW87XXX_PID_60_PA_RAMP_AGC1_0P8VDD	(0)
#define AW87XXX_PID_60_PA_RAMP_AGC1_0P8VDD_VALUE	\
	(AW87XXX_PID_60_PA_RAMP_AGC1_0P8VDD << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_60_PA_RAMP_AGC1_0P825VDD	(1)
#define AW87XXX_PID_60_PA_RAMP_AGC1_0P825VDD_VALUE	\
	(AW87XXX_PID_60_PA_RAMP_AGC1_0P825VDD << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_60_PA_RAMP_AGC1_0P85VDD	(2)
#define AW87XXX_PID_60_PA_RAMP_AGC1_0P85VDD_VALUE	\
	(AW87XXX_PID_60_PA_RAMP_AGC1_0P85VDD << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_60_PA_RAMP_AGC1_0P875VDD	(3)
#define AW87XXX_PID_60_PA_RAMP_AGC1_0P875VDD_VALUE	\
	(AW87XXX_PID_60_PA_RAMP_AGC1_0P875VDD << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT)

#define AW87XXX_PID_60_PA_RAMP_AGC1_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PA_RAMP_AGC1_DEFAULT	\
	(AW87XXX_PID_60_PA_RAMP_AGC1_DEFAULT_VALUE << AW87XXX_PID_60_PA_RAMP_AGC1_START_BIT)

/* RAMP_1SPW_VC bit 3:2 (RAMPGEN 0x6F) */
#define AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT	(2)
#define AW87XXX_PID_60_RAMP_1SPW_VC_BITS_LEN	(2)
#define AW87XXX_PID_60_RAMP_1SPW_VC_MASK	\
	(~(((1<<AW87XXX_PID_60_RAMP_1SPW_VC_BITS_LEN)-1) << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT))

#define AW87XXX_PID_60_RAMP_1SPW_VC_0P37VDD	(0)
#define AW87XXX_PID_60_RAMP_1SPW_VC_0P37VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VC_0P37VDD << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VC_0P39VDD	(1)
#define AW87XXX_PID_60_RAMP_1SPW_VC_0P39VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VC_0P39VDD << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VC_0P33VDD	(2)
#define AW87XXX_PID_60_RAMP_1SPW_VC_0P33VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VC_0P33VDD << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VC_0P35VDD	(3)
#define AW87XXX_PID_60_RAMP_1SPW_VC_0P35VDD_VALUE	\
	(AW87XXX_PID_60_RAMP_1SPW_VC_0P35VDD << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT)

#define AW87XXX_PID_60_RAMP_1SPW_VC_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_RAMP_1SPW_VC_DEFAULT	\
	(AW87XXX_PID_60_RAMP_1SPW_VC_DEFAULT_VALUE << AW87XXX_PID_60_RAMP_1SPW_VC_START_BIT)

/* SS_CONTROL bit 1:0 (RAMPGEN 0x6F) */
#define AW87XXX_PID_60_SS_CONTROL_START_BIT	(0)
#define AW87XXX_PID_60_SS_CONTROL_BITS_LEN	(2)
#define AW87XXX_PID_60_SS_CONTROL_MASK	\
	(~(((1<<AW87XXX_PID_60_SS_CONTROL_BITS_LEN)-1) << AW87XXX_PID_60_SS_CONTROL_START_BIT))

#define AW87XXX_PID_60_SS_CONTROL_SS_MODE	(0)
#define AW87XXX_PID_60_SS_CONTROL_SS_MODE_VALUE	\
	(AW87XXX_PID_60_SS_CONTROL_SS_MODE << AW87XXX_PID_60_SS_CONTROL_START_BIT)

#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE111	(1)
#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE111_VALUE	\
	(AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE111 << AW87XXX_PID_60_SS_CONTROL_START_BIT)

#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE000	(2)
#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE000_VALUE	\
	(AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE000 << AW87XXX_PID_60_SS_CONTROL_START_BIT)

#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE011	(3)
#define AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE011_VALUE	\
	(AW87XXX_PID_60_SS_CONTROL_SWBELOW20ABOVE011 << AW87XXX_PID_60_SS_CONTROL_START_BIT)

#define AW87XXX_PID_60_SS_CONTROL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_SS_CONTROL_DEFAULT	\
	(AW87XXX_PID_60_SS_CONTROL_DEFAULT_VALUE << AW87XXX_PID_60_SS_CONTROL_START_BIT)

/* default value of RAMPGEN (0x6F) */
/* #define AW87XXX_PID_60_RAMPGEN_DEFAULT		(0x0C) */

/* CLASSD_SYSCTRL (0x70) detail */
/* SEL_VCOM1 bit 0 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_SEL_VCOM1_START_BIT	(0)
#define AW87XXX_PID_60_SEL_VCOM1_BITS_LEN	(1)
#define AW87XXX_PID_60_SEL_VCOM1_MASK	\
	(~(((1<<AW87XXX_PID_60_SEL_VCOM1_BITS_LEN)-1) << AW87XXX_PID_60_SEL_VCOM1_START_BIT))

#define AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V	(0)
#define AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V_VALUE	\
	(AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V << AW87XXX_PID_60_SEL_VCOM1_START_BIT)

/*
#define AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V	(1)
#define AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V_VALUE	\
	(AW87XXX_PID_60_SEL_VCOM1_VCOM11P4V << AW87XXX_PID_60_SEL_VCOM1_START_BIT)
*/
/*
Fix me here:
reg_addr:0x70, reg_name:CLASSD_SYSCTRL, field_name:SEL_VCOM1, content:When ENOTA=0:
maybe need to fix manually
*/
#define AW87XXX_PID_60_SEL_VCOM1_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_SEL_VCOM1_DEFAULT	\
	(AW87XXX_PID_60_SEL_VCOM1_DEFAULT_VALUE << AW87XXX_PID_60_SEL_VCOM1_START_BIT)

/* PA_OPD bit 1 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_PA_OPD_START_BIT	(1)
#define AW87XXX_PID_60_PA_OPD_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_OPD_MASK		\
	(~(((1<<AW87XXX_PID_60_PA_OPD_BITS_LEN)-1) << AW87XXX_PID_60_PA_OPD_START_BIT))

#define AW87XXX_PID_60_PA_OPD_FLOATING	(0)
#define AW87XXX_PID_60_PA_OPD_FLOATING_VALUE	\
	(AW87XXX_PID_60_PA_OPD_FLOATING << AW87XXX_PID_60_PA_OPD_START_BIT)

#define AW87XXX_PID_60_PA_OPD_TIED_TO_GND	(1)
#define AW87XXX_PID_60_PA_OPD_TIED_TO_GND_VALUE	\
	(AW87XXX_PID_60_PA_OPD_TIED_TO_GND << AW87XXX_PID_60_PA_OPD_START_BIT)

#define AW87XXX_PID_60_PA_OPD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PA_OPD_DEFAULT	\
	(AW87XXX_PID_60_PA_OPD_DEFAULT_VALUE << AW87XXX_PID_60_PA_OPD_START_BIT)

/* CLK_OCP_SEL bit 4 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_CLK_OCP_SEL_START_BIT	(4)
#define AW87XXX_PID_60_CLK_OCP_SEL_BITS_LEN	(1)
#define AW87XXX_PID_60_CLK_OCP_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_CLK_OCP_SEL_BITS_LEN)-1) << AW87XXX_PID_60_CLK_OCP_SEL_START_BIT))

#define AW87XXX_PID_60_CLK_OCP_SEL_160MS	(0)
#define AW87XXX_PID_60_CLK_OCP_SEL_160MS_VALUE	\
	(AW87XXX_PID_60_CLK_OCP_SEL_160MS << AW87XXX_PID_60_CLK_OCP_SEL_START_BIT)

#define AW87XXX_PID_60_CLK_OCP_SEL_SHUTDOWN	(1)
#define AW87XXX_PID_60_CLK_OCP_SEL_SHUTDOWN_VALUE	\
	(AW87XXX_PID_60_CLK_OCP_SEL_SHUTDOWN << AW87XXX_PID_60_CLK_OCP_SEL_START_BIT)

#define AW87XXX_PID_60_CLK_OCP_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_CLK_OCP_SEL_DEFAULT	\
	(AW87XXX_PID_60_CLK_OCP_SEL_DEFAULT_VALUE << AW87XXX_PID_60_CLK_OCP_SEL_START_BIT)

/* PD_OT bit 5 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_PD_OT_START_BIT	(5)
#define AW87XXX_PID_60_PD_OT_BITS_LEN	(1)
#define AW87XXX_PID_60_PD_OT_MASK		\
	(~(((1<<AW87XXX_PID_60_PD_OT_BITS_LEN)-1) << AW87XXX_PID_60_PD_OT_START_BIT))

#define AW87XXX_PID_60_PD_OT_ENABLE		(0)
#define AW87XXX_PID_60_PD_OT_ENABLE_VALUE	\
	(AW87XXX_PID_60_PD_OT_ENABLE << AW87XXX_PID_60_PD_OT_START_BIT)

#define AW87XXX_PID_60_PD_OT_SHUTDOWN	(1)
#define AW87XXX_PID_60_PD_OT_SHUTDOWN_VALUE	\
	(AW87XXX_PID_60_PD_OT_SHUTDOWN << AW87XXX_PID_60_PD_OT_START_BIT)

#define AW87XXX_PID_60_PD_OT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PD_OT_DEFAULT	\
	(AW87XXX_PID_60_PD_OT_DEFAULT_VALUE << AW87XXX_PID_60_PD_OT_START_BIT)

/* PA_FLT_SR bit 6 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_PA_FLT_SR_START_BIT	(6)
#define AW87XXX_PID_60_PA_FLT_SR_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_FLT_SR_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_FLT_SR_BITS_LEN)-1) << AW87XXX_PID_60_PA_FLT_SR_START_BIT))

#define AW87XXX_PID_60_PA_FLT_SR_ADD_RC	(0)
#define AW87XXX_PID_60_PA_FLT_SR_ADD_RC_VALUE	\
	(AW87XXX_PID_60_PA_FLT_SR_ADD_RC << AW87XXX_PID_60_PA_FLT_SR_START_BIT)

#define AW87XXX_PID_60_PA_FLT_SR_NO_RC	(1)
#define AW87XXX_PID_60_PA_FLT_SR_NO_RC_VALUE	\
	(AW87XXX_PID_60_PA_FLT_SR_NO_RC << AW87XXX_PID_60_PA_FLT_SR_START_BIT)

#define AW87XXX_PID_60_PA_FLT_SR_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PA_FLT_SR_DEFAULT	\
	(AW87XXX_PID_60_PA_FLT_SR_DEFAULT_VALUE << AW87XXX_PID_60_PA_FLT_SR_START_BIT)

/* PA_PORT bit 3:2 (CLASSD_SYSCTRL 0x70) */
#define AW87XXX_PID_60_PA_PORT_START_BIT	(2)
#define AW87XXX_PID_60_PA_PORT_BITS_LEN	(2)
#define AW87XXX_PID_60_PA_PORT_MASK		\
	(~(((1<<AW87XXX_PID_60_PA_PORT_BITS_LEN)-1) << AW87XXX_PID_60_PA_PORT_START_BIT))

#define AW87XXX_PID_60_PA_PORT_80MS		(0)
#define AW87XXX_PID_60_PA_PORT_80MS_VALUE	\
	(AW87XXX_PID_60_PA_PORT_80MS << AW87XXX_PID_60_PA_PORT_START_BIT)

#define AW87XXX_PID_60_PA_PORT_40MS		(1)
#define AW87XXX_PID_60_PA_PORT_40MS_VALUE	\
	(AW87XXX_PID_60_PA_PORT_40MS << AW87XXX_PID_60_PA_PORT_START_BIT)

#define AW87XXX_PID_60_PA_PORT_20MS		(2)
#define AW87XXX_PID_60_PA_PORT_20MS_VALUE	\
	(AW87XXX_PID_60_PA_PORT_20MS << AW87XXX_PID_60_PA_PORT_START_BIT)

#define AW87XXX_PID_60_PA_PORT_10MS		(3)
#define AW87XXX_PID_60_PA_PORT_10MS_VALUE	\
	(AW87XXX_PID_60_PA_PORT_10MS << AW87XXX_PID_60_PA_PORT_START_BIT)

#define AW87XXX_PID_60_PA_PORT_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PA_PORT_DEFAULT	\
	(AW87XXX_PID_60_PA_PORT_DEFAULT_VALUE << AW87XXX_PID_60_PA_PORT_START_BIT)

/* default value of CLASSD_SYSCTRL (0x70) */
/* #define AW87XXX_PID_60_CLASSD_SYSCTRL_DEFAULT		(0x07) */

/* GTDR (0x71) detail */
/* REG_DUTY_T bit 0 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_DUTY_T_START_BIT	(0)
#define AW87XXX_PID_60_REG_DUTY_T_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_DUTY_T_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_DUTY_T_BITS_LEN)-1) << AW87XXX_PID_60_REG_DUTY_T_START_BIT))

#define AW87XXX_PID_60_REG_DUTY_T_DISABLE	(0)
#define AW87XXX_PID_60_REG_DUTY_T_DISABLE_VALUE	\
	(AW87XXX_PID_60_REG_DUTY_T_DISABLE << AW87XXX_PID_60_REG_DUTY_T_START_BIT)

#define AW87XXX_PID_60_REG_DUTY_T_ENALBE	(1)
#define AW87XXX_PID_60_REG_DUTY_T_ENALBE_VALUE	\
	(AW87XXX_PID_60_REG_DUTY_T_ENALBE << AW87XXX_PID_60_REG_DUTY_T_START_BIT)

#define AW87XXX_PID_60_REG_DUTY_T_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_REG_DUTY_T_DEFAULT	\
	(AW87XXX_PID_60_REG_DUTY_T_DEFAULT_VALUE << AW87XXX_PID_60_REG_DUTY_T_START_BIT)

/* LN_DELAY bit 1 (GTDR 0x71) */
#define AW87XXX_PID_60_LN_DELAY_START_BIT	(1)
#define AW87XXX_PID_60_LN_DELAY_BITS_LEN	(1)
#define AW87XXX_PID_60_LN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_LN_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_LN_DELAY_START_BIT))

#define AW87XXX_PID_60_LN_DELAY_DISABLE	(0)
#define AW87XXX_PID_60_LN_DELAY_DISABLE_VALUE	\
	(AW87XXX_PID_60_LN_DELAY_DISABLE << AW87XXX_PID_60_LN_DELAY_START_BIT)

#define AW87XXX_PID_60_LN_DELAY_ENABLE	(1)
#define AW87XXX_PID_60_LN_DELAY_ENABLE_VALUE	\
	(AW87XXX_PID_60_LN_DELAY_ENABLE << AW87XXX_PID_60_LN_DELAY_START_BIT)

#define AW87XXX_PID_60_LN_DELAY_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_LN_DELAY_DEFAULT	\
	(AW87XXX_PID_60_LN_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_LN_DELAY_START_BIT)

/* HN_DELAY bit 2 (GTDR 0x71) */
#define AW87XXX_PID_60_HN_DELAY_START_BIT	(2)
#define AW87XXX_PID_60_HN_DELAY_BITS_LEN	(1)
#define AW87XXX_PID_60_HN_DELAY_MASK	\
	(~(((1<<AW87XXX_PID_60_HN_DELAY_BITS_LEN)-1) << AW87XXX_PID_60_HN_DELAY_START_BIT))

#define AW87XXX_PID_60_HN_DELAY_DISABLE	(0)
#define AW87XXX_PID_60_HN_DELAY_DISABLE_VALUE	\
	(AW87XXX_PID_60_HN_DELAY_DISABLE << AW87XXX_PID_60_HN_DELAY_START_BIT)

#define AW87XXX_PID_60_HN_DELAY_ENABLE	(1)
#define AW87XXX_PID_60_HN_DELAY_ENABLE_VALUE	\
	(AW87XXX_PID_60_HN_DELAY_ENABLE << AW87XXX_PID_60_HN_DELAY_START_BIT)

#define AW87XXX_PID_60_HN_DELAY_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_HN_DELAY_DEFAULT	\
	(AW87XXX_PID_60_HN_DELAY_DEFAULT_VALUE << AW87XXX_PID_60_HN_DELAY_START_BIT)

/* REG_T_EDGE bit 3 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_T_EDGE_START_BIT	(3)
#define AW87XXX_PID_60_REG_T_EDGE_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_T_EDGE_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_T_EDGE_BITS_LEN)-1) << AW87XXX_PID_60_REG_T_EDGE_START_BIT))

#define AW87XXX_PID_60_REG_T_EDGE_5NS	(0)
#define AW87XXX_PID_60_REG_T_EDGE_5NS_VALUE	\
	(AW87XXX_PID_60_REG_T_EDGE_5NS << AW87XXX_PID_60_REG_T_EDGE_START_BIT)

#define AW87XXX_PID_60_REG_T_EDGE_15NS	(1)
#define AW87XXX_PID_60_REG_T_EDGE_15NS_VALUE	\
	(AW87XXX_PID_60_REG_T_EDGE_15NS << AW87XXX_PID_60_REG_T_EDGE_START_BIT)

#define AW87XXX_PID_60_REG_T_EDGE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_T_EDGE_DEFAULT	\
	(AW87XXX_PID_60_REG_T_EDGE_DEFAULT_VALUE << AW87XXX_PID_60_REG_T_EDGE_START_BIT)

/* REG_L_PULL bit 4 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_L_PULL_START_BIT	(4)
#define AW87XXX_PID_60_REG_L_PULL_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_L_PULL_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_L_PULL_BITS_LEN)-1) << AW87XXX_PID_60_REG_L_PULL_START_BIT))

#define AW87XXX_PID_60_REG_L_PULL_7NS	(0)
#define AW87XXX_PID_60_REG_L_PULL_7NS_VALUE	\
	(AW87XXX_PID_60_REG_L_PULL_7NS << AW87XXX_PID_60_REG_L_PULL_START_BIT)

#define AW87XXX_PID_60_REG_L_PULL_14NS	(1)
#define AW87XXX_PID_60_REG_L_PULL_14NS_VALUE	\
	(AW87XXX_PID_60_REG_L_PULL_14NS << AW87XXX_PID_60_REG_L_PULL_START_BIT)

#define AW87XXX_PID_60_REG_L_PULL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_L_PULL_DEFAULT	\
	(AW87XXX_PID_60_REG_L_PULL_DEFAULT_VALUE << AW87XXX_PID_60_REG_L_PULL_START_BIT)

/* REG_L_PUD bit 5 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_L_PUD_START_BIT	(5)
#define AW87XXX_PID_60_REG_L_PUD_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_L_PUD_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_L_PUD_BITS_LEN)-1) << AW87XXX_PID_60_REG_L_PUD_START_BIT))

#define AW87XXX_PID_60_REG_L_PUD_0NS	(0)
#define AW87XXX_PID_60_REG_L_PUD_0NS_VALUE	\
	(AW87XXX_PID_60_REG_L_PUD_0NS << AW87XXX_PID_60_REG_L_PUD_START_BIT)

#define AW87XXX_PID_60_REG_L_PUD_3NS	(1)
#define AW87XXX_PID_60_REG_L_PUD_3NS_VALUE	\
	(AW87XXX_PID_60_REG_L_PUD_3NS << AW87XXX_PID_60_REG_L_PUD_START_BIT)

#define AW87XXX_PID_60_REG_L_PUD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_REG_L_PUD_DEFAULT	\
	(AW87XXX_PID_60_REG_L_PUD_DEFAULT_VALUE << AW87XXX_PID_60_REG_L_PUD_START_BIT)

/* REG_HNG_PULL bit 6 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_HNG_PULL_START_BIT	(6)
#define AW87XXX_PID_60_REG_HNG_PULL_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_HNG_PULL_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_HNG_PULL_BITS_LEN)-1) << AW87XXX_PID_60_REG_HNG_PULL_START_BIT))

#define AW87XXX_PID_60_REG_HNG_PULL_DISABLE	(0)
#define AW87XXX_PID_60_REG_HNG_PULL_DISABLE_VALUE	\
	(AW87XXX_PID_60_REG_HNG_PULL_DISABLE << AW87XXX_PID_60_REG_HNG_PULL_START_BIT)

#define AW87XXX_PID_60_REG_HNG_PULL_ENABLE	(1)
#define AW87XXX_PID_60_REG_HNG_PULL_ENABLE_VALUE	\
	(AW87XXX_PID_60_REG_HNG_PULL_ENABLE << AW87XXX_PID_60_REG_HNG_PULL_START_BIT)

#define AW87XXX_PID_60_REG_HNG_PULL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_HNG_PULL_DEFAULT	\
	(AW87XXX_PID_60_REG_HNG_PULL_DEFAULT_VALUE << AW87XXX_PID_60_REG_HNG_PULL_START_BIT)

/* REG_DUTY_VTH bit 7 (GTDR 0x71) */
#define AW87XXX_PID_60_REG_DUTY_VTH_START_BIT	(7)
#define AW87XXX_PID_60_REG_DUTY_VTH_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_DUTY_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_DUTY_VTH_BITS_LEN)-1) << AW87XXX_PID_60_REG_DUTY_VTH_START_BIT))

#define AW87XXX_PID_60_REG_DUTY_VTH_POVTH0	(0)
#define AW87XXX_PID_60_REG_DUTY_VTH_POVTH0_VALUE	\
	(AW87XXX_PID_60_REG_DUTY_VTH_POVTH0 << AW87XXX_PID_60_REG_DUTY_VTH_START_BIT)

#define AW87XXX_PID_60_REG_DUTY_VTH_POVTH4	(1)
#define AW87XXX_PID_60_REG_DUTY_VTH_POVTH4_VALUE	\
	(AW87XXX_PID_60_REG_DUTY_VTH_POVTH4 << AW87XXX_PID_60_REG_DUTY_VTH_START_BIT)

#define AW87XXX_PID_60_REG_DUTY_VTH_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_REG_DUTY_VTH_DEFAULT	\
	(AW87XXX_PID_60_REG_DUTY_VTH_DEFAULT_VALUE << AW87XXX_PID_60_REG_DUTY_VTH_START_BIT)

/* default value of GTDR (0x71) */
/* #define AW87XXX_PID_60_GTDR_DEFAULT		(0x27) */

/* OC (0x72) detail */
/* REG_SHORT_GUARD bit 7 (OC 0x72) */
#define AW87XXX_PID_60_REG_SHORT_GUARD_START_BIT	(7)
#define AW87XXX_PID_60_REG_SHORT_GUARD_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_SHORT_GUARD_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_SHORT_GUARD_BITS_LEN)-1) << AW87XXX_PID_60_REG_SHORT_GUARD_START_BIT))

#define AW87XXX_PID_60_REG_SHORT_GUARD_DISABLE	(0)
#define AW87XXX_PID_60_REG_SHORT_GUARD_DISABLE_VALUE	\
	(AW87XXX_PID_60_REG_SHORT_GUARD_DISABLE << AW87XXX_PID_60_REG_SHORT_GUARD_START_BIT)

#define AW87XXX_PID_60_REG_SHORT_GUARD_ENALBE	(1)
#define AW87XXX_PID_60_REG_SHORT_GUARD_ENALBE_VALUE	\
	(AW87XXX_PID_60_REG_SHORT_GUARD_ENALBE << AW87XXX_PID_60_REG_SHORT_GUARD_START_BIT)

#define AW87XXX_PID_60_REG_SHORT_GUARD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_REG_SHORT_GUARD_DEFAULT	\
	(AW87XXX_PID_60_REG_SHORT_GUARD_DEFAULT_VALUE << AW87XXX_PID_60_REG_SHORT_GUARD_START_BIT)

/* PA_GTDR_DDT bit 6:5 (OC 0x72) */
#define AW87XXX_PID_60_PA_GTDR_DDT_START_BIT	(5)
#define AW87XXX_PID_60_PA_GTDR_DDT_BITS_LEN	(2)
#define AW87XXX_PID_60_PA_GTDR_DDT_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_GTDR_DDT_BITS_LEN)-1) << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT))

#define AW87XXX_PID_60_PA_GTDR_DDT_12NS	(0)
#define AW87XXX_PID_60_PA_GTDR_DDT_12NS_VALUE	\
	(AW87XXX_PID_60_PA_GTDR_DDT_12NS << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_PA_GTDR_DDT_13NS	(1)
#define AW87XXX_PID_60_PA_GTDR_DDT_13NS_VALUE	\
	(AW87XXX_PID_60_PA_GTDR_DDT_13NS << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_PA_GTDR_DDT_14NS	(2)
#define AW87XXX_PID_60_PA_GTDR_DDT_14NS_VALUE	\
	(AW87XXX_PID_60_PA_GTDR_DDT_14NS << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_PA_GTDR_DDT_15NS	(3)
#define AW87XXX_PID_60_PA_GTDR_DDT_15NS_VALUE	\
	(AW87XXX_PID_60_PA_GTDR_DDT_15NS << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT)

#define AW87XXX_PID_60_PA_GTDR_DDT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PA_GTDR_DDT_DEFAULT	\
	(AW87XXX_PID_60_PA_GTDR_DDT_DEFAULT_VALUE << AW87XXX_PID_60_PA_GTDR_DDT_START_BIT)

/* PA_OC_ITH bit 4:2 (OC 0x72) */
#define AW87XXX_PID_60_PA_OC_ITH_START_BIT	(2)
#define AW87XXX_PID_60_PA_OC_ITH_BITS_LEN	(3)
#define AW87XXX_PID_60_PA_OC_ITH_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_OC_ITH_BITS_LEN)-1) << AW87XXX_PID_60_PA_OC_ITH_START_BIT))

#define AW87XXX_PID_60_PA_OC_ITH_3P4A	(0)
#define AW87XXX_PID_60_PA_OC_ITH_3P4A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_3P4A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_3P8A	(1)
#define AW87XXX_PID_60_PA_OC_ITH_3P8A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_3P8A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_4P2A	(2)
#define AW87XXX_PID_60_PA_OC_ITH_4P2A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_4P2A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_4P6A	(3)
#define AW87XXX_PID_60_PA_OC_ITH_4P6A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_4P6A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_5P0A	(4)
#define AW87XXX_PID_60_PA_OC_ITH_5P0A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_5P0A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_5P4A	(5)
#define AW87XXX_PID_60_PA_OC_ITH_5P4A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_5P4A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_5P7A	(6)
#define AW87XXX_PID_60_PA_OC_ITH_5P7A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_5P7A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_6P0A	(7)
#define AW87XXX_PID_60_PA_OC_ITH_6P0A_VALUE	\
	(AW87XXX_PID_60_PA_OC_ITH_6P0A << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

#define AW87XXX_PID_60_PA_OC_ITH_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_PA_OC_ITH_DEFAULT	\
	(AW87XXX_PID_60_PA_OC_ITH_DEFAULT_VALUE << AW87XXX_PID_60_PA_OC_ITH_START_BIT)

/* PA_OC_DT bit 1:0 (OC 0x72) */
#define AW87XXX_PID_60_PA_OC_DT_START_BIT	(0)
#define AW87XXX_PID_60_PA_OC_DT_BITS_LEN	(2)
#define AW87XXX_PID_60_PA_OC_DT_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_OC_DT_BITS_LEN)-1) << AW87XXX_PID_60_PA_OC_DT_START_BIT))

#define AW87XXX_PID_60_PA_OC_DT_20NS	(0)
#define AW87XXX_PID_60_PA_OC_DT_20NS_VALUE	\
	(AW87XXX_PID_60_PA_OC_DT_20NS << AW87XXX_PID_60_PA_OC_DT_START_BIT)

#define AW87XXX_PID_60_PA_OC_DT_40NS	(1)
#define AW87XXX_PID_60_PA_OC_DT_40NS_VALUE	\
	(AW87XXX_PID_60_PA_OC_DT_40NS << AW87XXX_PID_60_PA_OC_DT_START_BIT)

#define AW87XXX_PID_60_PA_OC_DT_60NS	(2)
#define AW87XXX_PID_60_PA_OC_DT_60NS_VALUE	\
	(AW87XXX_PID_60_PA_OC_DT_60NS << AW87XXX_PID_60_PA_OC_DT_START_BIT)

#define AW87XXX_PID_60_PA_OC_DT_80NS	(3)
#define AW87XXX_PID_60_PA_OC_DT_80NS_VALUE	\
	(AW87XXX_PID_60_PA_OC_DT_80NS << AW87XXX_PID_60_PA_OC_DT_START_BIT)

#define AW87XXX_PID_60_PA_OC_DT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PA_OC_DT_DEFAULT	\
	(AW87XXX_PID_60_PA_OC_DT_DEFAULT_VALUE << AW87XXX_PID_60_PA_OC_DT_START_BIT)

/* default value of OC (0x72) */
/* #define AW87XXX_PID_60_OC_DEFAULT		(0x8C) */

/* AGC_CON (0x73) detail */
/* PA_OCSWD bit 6 (AGC_CON 0x73) */
#define AW87XXX_PID_60_PA_OCSWD_START_BIT	(6)
#define AW87XXX_PID_60_PA_OCSWD_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_OCSWD_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_OCSWD_BITS_LEN)-1) << AW87XXX_PID_60_PA_OCSWD_START_BIT))

#define AW87XXX_PID_60_PA_OCSWD_FAST	(0)
#define AW87XXX_PID_60_PA_OCSWD_FAST_VALUE	\
	(AW87XXX_PID_60_PA_OCSWD_FAST << AW87XXX_PID_60_PA_OCSWD_START_BIT)

#define AW87XXX_PID_60_PA_OCSWD_SLOW	(1)
#define AW87XXX_PID_60_PA_OCSWD_SLOW_VALUE	\
	(AW87XXX_PID_60_PA_OCSWD_SLOW << AW87XXX_PID_60_PA_OCSWD_START_BIT)

#define AW87XXX_PID_60_PA_OCSWD_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PA_OCSWD_DEFAULT	\
	(AW87XXX_PID_60_PA_OCSWD_DEFAULT_VALUE << AW87XXX_PID_60_PA_OCSWD_START_BIT)

/* PD_CROSSZERO bit 5:4 (AGC_CON 0x73) */
#define AW87XXX_PID_60_PD_CROSSZERO_START_BIT	(4)
#define AW87XXX_PID_60_PD_CROSSZERO_BITS_LEN	(2)
#define AW87XXX_PID_60_PD_CROSSZERO_MASK	\
	(~(((1<<AW87XXX_PID_60_PD_CROSSZERO_BITS_LEN)-1) << AW87XXX_PID_60_PD_CROSSZERO_START_BIT))

#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC2_3_CROSSZERO	(0)
#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC2_3_CROSSZERO_VALUE	\
	(AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC2_3_CROSSZERO << AW87XXX_PID_60_PD_CROSSZERO_START_BIT)

#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO	(1)
#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO_VALUE	\
	(AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO << AW87XXX_PID_60_PD_CROSSZERO_START_BIT)

/*
#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO	(2)
#define AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO_VALUE	\
	(AW87XXX_PID_60_PD_CROSSZERO_ENABLE_AGC1_WHEN_PVDD_IS_RISINGAGC23_CROSSZERO << AW87XXX_PID_60_PD_CROSSZERO_START_BIT)
*/

#define AW87XXX_PID_60_PD_CROSSZERO_AGC123_CROSSZERO	(3)
#define AW87XXX_PID_60_PD_CROSSZERO_AGC123_CROSSZERO_VALUE	\
	(AW87XXX_PID_60_PD_CROSSZERO_AGC123_CROSSZERO << AW87XXX_PID_60_PD_CROSSZERO_START_BIT)
/*
Fix me here:
reg_addr:0x73, reg_name:AGC_CON, field_name:PD_CROSSZERO, content:AGC cross_zero adaptively When EN_AGC1_ADP=1
maybe need to fix manually
*/
#define AW87XXX_PID_60_PD_CROSSZERO_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PD_CROSSZERO_DEFAULT	\
	(AW87XXX_PID_60_PD_CROSSZERO_DEFAULT_VALUE << AW87XXX_PID_60_PD_CROSSZERO_START_BIT)

/* AGC1_VTH_SEL bit 3:2 (AGC_CON 0x73) */
#define AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT	(2)
#define AW87XXX_PID_60_AGC1_VTH_SEL_BITS_LEN	(2)
#define AW87XXX_PID_60_AGC1_VTH_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC1_VTH_SEL_BITS_LEN)-1) << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT))

#define AW87XXX_PID_60_AGC1_VTH_SEL_RAMPGEN	(0)
#define AW87XXX_PID_60_AGC1_VTH_SEL_RAMPGEN_VALUE	\
	(AW87XXX_PID_60_AGC1_VTH_SEL_RAMPGEN << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT)

#define AW87XXX_PID_60_AGC1_VTH_SEL_THGEN	(1)
#define AW87XXX_PID_60_AGC1_VTH_SEL_THGEN_VALUE	\
	(AW87XXX_PID_60_AGC1_VTH_SEL_THGEN << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT)

#define AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN	(2)
#define AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN_VALUE	\
	(AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT)

/*
#define AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN	(3)
#define AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN_VALUE	\
	(AW87XXX_PID_60_AGC1_VTH_SEL_BOTH_MIN << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT)
*/

#define AW87XXX_PID_60_AGC1_VTH_SEL_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_AGC1_VTH_SEL_DEFAULT	\
	(AW87XXX_PID_60_AGC1_VTH_SEL_DEFAULT_VALUE << AW87XXX_PID_60_AGC1_VTH_SEL_START_BIT)

/* AGC2_FIRST_ATT_TIME bit 1:0 (AGC_CON 0x73) */
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT	(0)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_BITS_LEN	(2)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_MASK	\
	(~(((1<<AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_BITS_LEN)-1) << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT))

#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P08MS	(0)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P08MS_VALUE	\
	(AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P08MS << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P32MS	(1)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P32MS_VALUE	\
	(AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_0P32MS << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_1P28MS	(2)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_1P28MS_VALUE	\
	(AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_1P28MS << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_5P12MS	(3)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_5P12MS_VALUE	\
	(AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_5P12MS << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT)

#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_DEFAULT	\
	(AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_DEFAULT_VALUE << AW87XXX_PID_60_AGC2_FIRST_ATT_TIME_START_BIT)

/* default value of AGC_CON (0x73) */
/* #define AW87XXX_PID_60_AGC_CON_DEFAULT		(0x48) */

/* NG (0x74) detail */
/* NG_MODE bit 2 (NG 0x74) */
#define AW87XXX_PID_60_NG_MODE_START_BIT	(2)
#define AW87XXX_PID_60_NG_MODE_BITS_LEN	(1)
#define AW87XXX_PID_60_NG_MODE_MASK		\
	(~(((1<<AW87XXX_PID_60_NG_MODE_BITS_LEN)-1) << AW87XXX_PID_60_NG_MODE_START_BIT))

#define AW87XXX_PID_60_NG_MODE_MODE1	(0)
#define AW87XXX_PID_60_NG_MODE_MODE1_VALUE	\
	(AW87XXX_PID_60_NG_MODE_MODE1 << AW87XXX_PID_60_NG_MODE_START_BIT)

#define AW87XXX_PID_60_NG_MODE_MODE2	(1)
#define AW87XXX_PID_60_NG_MODE_MODE2_VALUE	\
	(AW87XXX_PID_60_NG_MODE_MODE2 << AW87XXX_PID_60_NG_MODE_START_BIT)

#define AW87XXX_PID_60_NG_MODE_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_NG_MODE_DEFAULT	\
	(AW87XXX_PID_60_NG_MODE_DEFAULT_VALUE << AW87XXX_PID_60_NG_MODE_START_BIT)

/* EN_NG bit 3 (NG 0x74) */
#define AW87XXX_PID_60_EN_NG_START_BIT	(3)
#define AW87XXX_PID_60_EN_NG_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_NG_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_NG_BITS_LEN)-1) << AW87XXX_PID_60_EN_NG_START_BIT))

#define AW87XXX_PID_60_EN_NG_DISABLE	(0)
#define AW87XXX_PID_60_EN_NG_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_NG_DISABLE << AW87XXX_PID_60_EN_NG_START_BIT)

#define AW87XXX_PID_60_EN_NG_ENABLE		(1)
#define AW87XXX_PID_60_EN_NG_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_NG_ENABLE << AW87XXX_PID_60_EN_NG_START_BIT)

#define AW87XXX_PID_60_EN_NG_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_NG_DEFAULT	\
	(AW87XXX_PID_60_EN_NG_DEFAULT_VALUE << AW87XXX_PID_60_EN_NG_START_BIT)

/* EN_AGC1_ADP bit 7 (NG 0x74) */
#define AW87XXX_PID_60_EN_AGC1_ADP_START_BIT	(7)
#define AW87XXX_PID_60_EN_AGC1_ADP_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_AGC1_ADP_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_AGC1_ADP_BITS_LEN)-1) << AW87XXX_PID_60_EN_AGC1_ADP_START_BIT))

#define AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE	(0)
#define AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE_VALUE	\
	(AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_AS_BEFORE << AW87XXX_PID_60_EN_AGC1_ADP_START_BIT)

#define AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY	(1)
#define AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY_VALUE	\
	(AW87XXX_PID_60_EN_AGC1_ADP_AGC_CROSSZERO_ADAPTIVELY << AW87XXX_PID_60_EN_AGC1_ADP_START_BIT)

#define AW87XXX_PID_60_EN_AGC1_ADP_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_AGC1_ADP_DEFAULT	\
	(AW87XXX_PID_60_EN_AGC1_ADP_DEFAULT_VALUE << AW87XXX_PID_60_EN_AGC1_ADP_START_BIT)

/* PAVG_ADJ bit 6:4 (NG 0x74) */
#define AW87XXX_PID_60_PAVG_ADJ_START_BIT	(4)
#define AW87XXX_PID_60_PAVG_ADJ_BITS_LEN	(3)
#define AW87XXX_PID_60_PAVG_ADJ_MASK	\
	(~(((1<<AW87XXX_PID_60_PAVG_ADJ_BITS_LEN)-1) << AW87XXX_PID_60_PAVG_ADJ_START_BIT))

#define AW87XXX_PID_60_PAVG_ADJ_0P94	(0)
#define AW87XXX_PID_60_PAVG_ADJ_0P94_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_0P94 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_0P97	(1)
#define AW87XXX_PID_60_PAVG_ADJ_0P97_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_0P97 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_1P0		(2)
#define AW87XXX_PID_60_PAVG_ADJ_1P0_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_1P0 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_1P03	(3)
#define AW87XXX_PID_60_PAVG_ADJ_1P03_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_1P03 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_1P06	(4)
#define AW87XXX_PID_60_PAVG_ADJ_1P06_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_1P06 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_1P09	(5)
#define AW87XXX_PID_60_PAVG_ADJ_1P09_VALUE	\
	(AW87XXX_PID_60_PAVG_ADJ_1P09 << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

#define AW87XXX_PID_60_PAVG_ADJ_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_PAVG_ADJ_DEFAULT	\
	(AW87XXX_PID_60_PAVG_ADJ_DEFAULT_VALUE << AW87XXX_PID_60_PAVG_ADJ_START_BIT)

/* NG_GAIN bit 1:0 (NG 0x74) */
#define AW87XXX_PID_60_NG_GAIN_START_BIT	(0)
#define AW87XXX_PID_60_NG_GAIN_BITS_LEN	(2)
#define AW87XXX_PID_60_NG_GAIN_MASK		\
	(~(((1<<AW87XXX_PID_60_NG_GAIN_BITS_LEN)-1) << AW87XXX_PID_60_NG_GAIN_START_BIT))

#define AW87XXX_PID_60_NG_GAIN_MINUS6DB	(0)
#define AW87XXX_PID_60_NG_GAIN_MINUS6DB_VALUE	\
	(AW87XXX_PID_60_NG_GAIN_MINUS6DB << AW87XXX_PID_60_NG_GAIN_START_BIT)

#define AW87XXX_PID_60_NG_GAIN_MINUS7P5DB	(1)
#define AW87XXX_PID_60_NG_GAIN_MINUS7P5DB_VALUE	\
	(AW87XXX_PID_60_NG_GAIN_MINUS7P5DB << AW87XXX_PID_60_NG_GAIN_START_BIT)

#define AW87XXX_PID_60_NG_GAIN_MINUS9DB	(2)
#define AW87XXX_PID_60_NG_GAIN_MINUS9DB_VALUE	\
	(AW87XXX_PID_60_NG_GAIN_MINUS9DB << AW87XXX_PID_60_NG_GAIN_START_BIT)

#define AW87XXX_PID_60_NG_GAIN_MINUS12DB	(3)
#define AW87XXX_PID_60_NG_GAIN_MINUS12DB_VALUE	\
	(AW87XXX_PID_60_NG_GAIN_MINUS12DB << AW87XXX_PID_60_NG_GAIN_START_BIT)

#define AW87XXX_PID_60_NG_GAIN_DEFAULT_VALUE	(0x3)
#define AW87XXX_PID_60_NG_GAIN_DEFAULT	\
	(AW87XXX_PID_60_NG_GAIN_DEFAULT_VALUE << AW87XXX_PID_60_NG_GAIN_START_BIT)

/* default value of NG (0x74) */
/* #define AW87XXX_PID_60_NG_DEFAULT		(0x27) */

/* NG2 (0x75) detail */
/* NG_CLK0_SEL bit 0 (NG2 0x75) */
#define AW87XXX_PID_60_NG_CLK0_SEL_START_BIT	(0)
#define AW87XXX_PID_60_NG_CLK0_SEL_BITS_LEN	(1)
#define AW87XXX_PID_60_NG_CLK0_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_NG_CLK0_SEL_BITS_LEN)-1) << AW87XXX_PID_60_NG_CLK0_SEL_START_BIT))

#define AW87XXX_PID_60_NG_CLK0_SEL_5US	(0)
#define AW87XXX_PID_60_NG_CLK0_SEL_5US_VALUE	\
	(AW87XXX_PID_60_NG_CLK0_SEL_5US << AW87XXX_PID_60_NG_CLK0_SEL_START_BIT)

#define AW87XXX_PID_60_NG_CLK0_SEL_10US	(1)
#define AW87XXX_PID_60_NG_CLK0_SEL_10US_VALUE	\
	(AW87XXX_PID_60_NG_CLK0_SEL_10US << AW87XXX_PID_60_NG_CLK0_SEL_START_BIT)

#define AW87XXX_PID_60_NG_CLK0_SEL_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_NG_CLK0_SEL_DEFAULT	\
	(AW87XXX_PID_60_NG_CLK0_SEL_DEFAULT_VALUE << AW87XXX_PID_60_NG_CLK0_SEL_START_BIT)

/* NG_DEGLITCH_CTRL bit 7 (NG2 0x75) */
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_START_BIT	(7)
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_BITS_LEN	(1)
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_MASK	\
	(~(((1<<AW87XXX_PID_60_NG_DEGLITCH_CTRL_BITS_LEN)-1) << AW87XXX_PID_60_NG_DEGLITCH_CTRL_START_BIT))

#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_8P6N	(0)
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_8P6N_VALUE	\
	(AW87XXX_PID_60_NG_DEGLITCH_CTRL_8P6N << AW87XXX_PID_60_NG_DEGLITCH_CTRL_START_BIT)

#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_14P2N	(1)
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_14P2N_VALUE	\
	(AW87XXX_PID_60_NG_DEGLITCH_CTRL_14P2N << AW87XXX_PID_60_NG_DEGLITCH_CTRL_START_BIT)

#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_NG_DEGLITCH_CTRL_DEFAULT	\
	(AW87XXX_PID_60_NG_DEGLITCH_CTRL_DEFAULT_VALUE << AW87XXX_PID_60_NG_DEGLITCH_CTRL_START_BIT)

/* NGVTH bit 6:4 (NG2 0x75) */
#define AW87XXX_PID_60_NGVTH_START_BIT	(4)
#define AW87XXX_PID_60_NGVTH_BITS_LEN	(3)
#define AW87XXX_PID_60_NGVTH_MASK		\
	(~(((1<<AW87XXX_PID_60_NGVTH_BITS_LEN)-1) << AW87XXX_PID_60_NGVTH_START_BIT))

#define AW87XXX_PID_60_NGVTH_5MV		(0)
#define AW87XXX_PID_60_NGVTH_5MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_5MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_8MV		(1)
#define AW87XXX_PID_60_NGVTH_8MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_8MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_10MV		(2)
#define AW87XXX_PID_60_NGVTH_10MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_10MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_12MV		(3)
#define AW87XXX_PID_60_NGVTH_12MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_12MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_14MV		(4)
#define AW87XXX_PID_60_NGVTH_14MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_14MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_16MV		(5)
#define AW87XXX_PID_60_NGVTH_16MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_16MV << AW87XXX_PID_60_NGVTH_START_BIT)

/*
#define AW87XXX_PID_60_NGVTH_16MV		(6)
#define AW87XXX_PID_60_NGVTH_16MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_16MV << AW87XXX_PID_60_NGVTH_START_BIT)
*/

#define AW87XXX_PID_60_NGVTH_25MV		(7)
#define AW87XXX_PID_60_NGVTH_25MV_VALUE	\
	(AW87XXX_PID_60_NGVTH_25MV << AW87XXX_PID_60_NGVTH_START_BIT)

#define AW87XXX_PID_60_NGVTH_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_NGVTH_DEFAULT	\
	(AW87XXX_PID_60_NGVTH_DEFAULT_VALUE << AW87XXX_PID_60_NGVTH_START_BIT)

/* NG_ACK bit 3:1 (NG2 0x75) */
#define AW87XXX_PID_60_NG_ACK_START_BIT	(1)
#define AW87XXX_PID_60_NG_ACK_BITS_LEN	(3)
#define AW87XXX_PID_60_NG_ACK_MASK		\
	(~(((1<<AW87XXX_PID_60_NG_ACK_BITS_LEN)-1) << AW87XXX_PID_60_NG_ACK_START_BIT))

#define AW87XXX_PID_60_NG_ACK_10MS		(0)
#define AW87XXX_PID_60_NG_ACK_10MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_10MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_20MS		(1)
#define AW87XXX_PID_60_NG_ACK_20MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_20MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_40MS		(2)
#define AW87XXX_PID_60_NG_ACK_40MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_40MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_80MS		(3)
#define AW87XXX_PID_60_NG_ACK_80MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_80MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_160MS		(4)
#define AW87XXX_PID_60_NG_ACK_160MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_160MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_320MS		(5)
#define AW87XXX_PID_60_NG_ACK_320MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_320MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_640MS		(6)
#define AW87XXX_PID_60_NG_ACK_640MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_640MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_1280MS	(7)
#define AW87XXX_PID_60_NG_ACK_1280MS_VALUE	\
	(AW87XXX_PID_60_NG_ACK_1280MS << AW87XXX_PID_60_NG_ACK_START_BIT)

#define AW87XXX_PID_60_NG_ACK_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_60_NG_ACK_DEFAULT	\
	(AW87XXX_PID_60_NG_ACK_DEFAULT_VALUE << AW87XXX_PID_60_NG_ACK_START_BIT)

/* default value of NG2 (0x75) */
/* #define AW87XXX_PID_60_NG2_DEFAULT		(0xA9) */

/* NG3 (0x76) detail */
/* NG_RCK bit 7:5 (NG3 0x76) */
#define AW87XXX_PID_60_NG_RCK_START_BIT	(5)
#define AW87XXX_PID_60_NG_RCK_BITS_LEN	(3)
#define AW87XXX_PID_60_NG_RCK_MASK		\
	(~(((1<<AW87XXX_PID_60_NG_RCK_BITS_LEN)-1) << AW87XXX_PID_60_NG_RCK_START_BIT))

#define AW87XXX_PID_60_NG_RCK_90US		(0)
#define AW87XXX_PID_60_NG_RCK_90US_VALUE	\
	(AW87XXX_PID_60_NG_RCK_90US << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_180US		(1)
#define AW87XXX_PID_60_NG_RCK_180US_VALUE	\
	(AW87XXX_PID_60_NG_RCK_180US << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_360US		(2)
#define AW87XXX_PID_60_NG_RCK_360US_VALUE	\
	(AW87XXX_PID_60_NG_RCK_360US << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_720US		(3)
#define AW87XXX_PID_60_NG_RCK_720US_VALUE	\
	(AW87XXX_PID_60_NG_RCK_720US << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_1P44M		(4)
#define AW87XXX_PID_60_NG_RCK_1P44M_VALUE	\
	(AW87XXX_PID_60_NG_RCK_1P44M << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_2P88MS	(5)
#define AW87XXX_PID_60_NG_RCK_2P88MS_VALUE	\
	(AW87XXX_PID_60_NG_RCK_2P88MS << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_5P76MS	(6)
#define AW87XXX_PID_60_NG_RCK_5P76MS_VALUE	\
	(AW87XXX_PID_60_NG_RCK_5P76MS << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_11P52MS	(7)
#define AW87XXX_PID_60_NG_RCK_11P52MS_VALUE	\
	(AW87XXX_PID_60_NG_RCK_11P52MS << AW87XXX_PID_60_NG_RCK_START_BIT)

#define AW87XXX_PID_60_NG_RCK_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_60_NG_RCK_DEFAULT	\
	(AW87XXX_PID_60_NG_RCK_DEFAULT_VALUE << AW87XXX_PID_60_NG_RCK_START_BIT)

/* NG_WCK bit 4:2 (NG3 0x76) */
#define AW87XXX_PID_60_NG_WCK_START_BIT	(2)
#define AW87XXX_PID_60_NG_WCK_BITS_LEN	(3)
#define AW87XXX_PID_60_NG_WCK_MASK		\
	(~(((1<<AW87XXX_PID_60_NG_WCK_BITS_LEN)-1) << AW87XXX_PID_60_NG_WCK_START_BIT))

#define AW87XXX_PID_60_NG_WCK_20MS		(0)
#define AW87XXX_PID_60_NG_WCK_20MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_20MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_40MS		(1)
#define AW87XXX_PID_60_NG_WCK_40MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_40MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_80MS		(2)
#define AW87XXX_PID_60_NG_WCK_80MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_80MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_160MS		(3)
#define AW87XXX_PID_60_NG_WCK_160MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_160MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_320MS		(4)
#define AW87XXX_PID_60_NG_WCK_320MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_320MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_640MS		(5)
#define AW87XXX_PID_60_NG_WCK_640MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_640MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_1280MS	(6)
#define AW87XXX_PID_60_NG_WCK_1280MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_1280MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_2556MS	(7)
#define AW87XXX_PID_60_NG_WCK_2556MS_VALUE	\
	(AW87XXX_PID_60_NG_WCK_2556MS << AW87XXX_PID_60_NG_WCK_START_BIT)

#define AW87XXX_PID_60_NG_WCK_DEFAULT_VALUE	(0x4)
#define AW87XXX_PID_60_NG_WCK_DEFAULT	\
	(AW87XXX_PID_60_NG_WCK_DEFAULT_VALUE << AW87XXX_PID_60_NG_WCK_START_BIT)

/* CP_VOS bit 1:0 (NG3 0x76) */
#define AW87XXX_PID_60_CP_VOS_START_BIT	(0)
#define AW87XXX_PID_60_CP_VOS_BITS_LEN	(2)
#define AW87XXX_PID_60_CP_VOS_MASK		\
	(~(((1<<AW87XXX_PID_60_CP_VOS_BITS_LEN)-1) << AW87XXX_PID_60_CP_VOS_START_BIT))

#define AW87XXX_PID_60_CP_VOS_0MV		(0)
#define AW87XXX_PID_60_CP_VOS_0MV_VALUE	\
	(AW87XXX_PID_60_CP_VOS_0MV << AW87XXX_PID_60_CP_VOS_START_BIT)

#define AW87XXX_PID_60_CP_VOS_50MV		(1)
#define AW87XXX_PID_60_CP_VOS_50MV_VALUE	\
	(AW87XXX_PID_60_CP_VOS_50MV << AW87XXX_PID_60_CP_VOS_START_BIT)

#define AW87XXX_PID_60_CP_VOS_100MV		(2)
#define AW87XXX_PID_60_CP_VOS_100MV_VALUE	\
	(AW87XXX_PID_60_CP_VOS_100MV << AW87XXX_PID_60_CP_VOS_START_BIT)

#define AW87XXX_PID_60_CP_VOS_150MV		(3)
#define AW87XXX_PID_60_CP_VOS_150MV_VALUE	\
	(AW87XXX_PID_60_CP_VOS_150MV << AW87XXX_PID_60_CP_VOS_START_BIT)

#define AW87XXX_PID_60_CP_VOS_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_CP_VOS_DEFAULT	\
	(AW87XXX_PID_60_CP_VOS_DEFAULT_VALUE << AW87XXX_PID_60_CP_VOS_START_BIT)

/* default value of NG3 (0x76) */
/* #define AW87XXX_PID_60_NG3_DEFAULT		(0x91) */

/* CP (0x77) detail */
/* CP_DDT bit 0 (CP 0x77) */
#define AW87XXX_PID_60_CP_DDT_START_BIT	(0)
#define AW87XXX_PID_60_CP_DDT_BITS_LEN	(1)
#define AW87XXX_PID_60_CP_DDT_MASK		\
	(~(((1<<AW87XXX_PID_60_CP_DDT_BITS_LEN)-1) << AW87XXX_PID_60_CP_DDT_START_BIT))

#define AW87XXX_PID_60_CP_DDT_0NS		(0)
#define AW87XXX_PID_60_CP_DDT_0NS_VALUE	\
	(AW87XXX_PID_60_CP_DDT_0NS << AW87XXX_PID_60_CP_DDT_START_BIT)

#define AW87XXX_PID_60_CP_DDT_10NS		(1)
#define AW87XXX_PID_60_CP_DDT_10NS_VALUE	\
	(AW87XXX_PID_60_CP_DDT_10NS << AW87XXX_PID_60_CP_DDT_START_BIT)

#define AW87XXX_PID_60_CP_DDT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_CP_DDT_DEFAULT	\
	(AW87XXX_PID_60_CP_DDT_DEFAULT_VALUE << AW87XXX_PID_60_CP_DDT_START_BIT)

/* CPOK_TM bit 1 (CP 0x77) */
#define AW87XXX_PID_60_CPOK_TM_START_BIT	(1)
#define AW87XXX_PID_60_CPOK_TM_BITS_LEN	(1)
#define AW87XXX_PID_60_CPOK_TM_MASK		\
	(~(((1<<AW87XXX_PID_60_CPOK_TM_BITS_LEN)-1) << AW87XXX_PID_60_CPOK_TM_START_BIT))

#define AW87XXX_PID_60_CPOK_TM_0P6MS	(0)
#define AW87XXX_PID_60_CPOK_TM_0P6MS_VALUE	\
	(AW87XXX_PID_60_CPOK_TM_0P6MS << AW87XXX_PID_60_CPOK_TM_START_BIT)

#define AW87XXX_PID_60_CPOK_TM_1MS		(1)
#define AW87XXX_PID_60_CPOK_TM_1MS_VALUE	\
	(AW87XXX_PID_60_CPOK_TM_1MS << AW87XXX_PID_60_CPOK_TM_START_BIT)

#define AW87XXX_PID_60_CPOK_TM_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_CPOK_TM_DEFAULT	\
	(AW87XXX_PID_60_CPOK_TM_DEFAULT_VALUE << AW87XXX_PID_60_CPOK_TM_START_BIT)

/* UVLO_DT bit 4 (CP 0x77) */
#define AW87XXX_PID_60_UVLO_DT_START_BIT	(4)
#define AW87XXX_PID_60_UVLO_DT_BITS_LEN	(1)
#define AW87XXX_PID_60_UVLO_DT_MASK		\
	(~(((1<<AW87XXX_PID_60_UVLO_DT_BITS_LEN)-1) << AW87XXX_PID_60_UVLO_DT_START_BIT))

#define AW87XXX_PID_60_UVLO_DT_3US		(0)
#define AW87XXX_PID_60_UVLO_DT_3US_VALUE	\
	(AW87XXX_PID_60_UVLO_DT_3US << AW87XXX_PID_60_UVLO_DT_START_BIT)

#define AW87XXX_PID_60_UVLO_DT_10US		(1)
#define AW87XXX_PID_60_UVLO_DT_10US_VALUE	\
	(AW87XXX_PID_60_UVLO_DT_10US << AW87XXX_PID_60_UVLO_DT_START_BIT)

#define AW87XXX_PID_60_UVLO_DT_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_UVLO_DT_DEFAULT	\
	(AW87XXX_PID_60_UVLO_DT_DEFAULT_VALUE << AW87XXX_PID_60_UVLO_DT_START_BIT)

/* PD_UVLO bit 7 (CP 0x77) */
#define AW87XXX_PID_60_PD_UVLO_START_BIT	(7)
#define AW87XXX_PID_60_PD_UVLO_BITS_LEN	(1)
#define AW87XXX_PID_60_PD_UVLO_MASK		\
	(~(((1<<AW87XXX_PID_60_PD_UVLO_BITS_LEN)-1) << AW87XXX_PID_60_PD_UVLO_START_BIT))

#define AW87XXX_PID_60_PD_UVLO_ENABLE	(0)
#define AW87XXX_PID_60_PD_UVLO_ENABLE_VALUE	\
	(AW87XXX_PID_60_PD_UVLO_ENABLE << AW87XXX_PID_60_PD_UVLO_START_BIT)

#define AW87XXX_PID_60_PD_UVLO_DISABLE	(1)
#define AW87XXX_PID_60_PD_UVLO_DISABLE_VALUE	\
	(AW87XXX_PID_60_PD_UVLO_DISABLE << AW87XXX_PID_60_PD_UVLO_START_BIT)

#define AW87XXX_PID_60_PD_UVLO_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PD_UVLO_DEFAULT	\
	(AW87XXX_PID_60_PD_UVLO_DEFAULT_VALUE << AW87XXX_PID_60_PD_UVLO_START_BIT)

/* UVLO_VTH bit 6:5 (CP 0x77) */
#define AW87XXX_PID_60_UVLO_VTH_START_BIT	(5)
#define AW87XXX_PID_60_UVLO_VTH_BITS_LEN	(2)
#define AW87XXX_PID_60_UVLO_VTH_MASK	\
	(~(((1<<AW87XXX_PID_60_UVLO_VTH_BITS_LEN)-1) << AW87XXX_PID_60_UVLO_VTH_START_BIT))

#define AW87XXX_PID_60_UVLO_VTH_VH2P6V_VL2P5V	(0)
#define AW87XXX_PID_60_UVLO_VTH_VH2P6V_VL2P5V_VALUE	\
	(AW87XXX_PID_60_UVLO_VTH_VH2P6V_VL2P5V << AW87XXX_PID_60_UVLO_VTH_START_BIT)

#define AW87XXX_PID_60_UVLO_VTH_VH2P7V_VL2P6V	(1)
#define AW87XXX_PID_60_UVLO_VTH_VH2P7V_VL2P6V_VALUE	\
	(AW87XXX_PID_60_UVLO_VTH_VH2P7V_VL2P6V << AW87XXX_PID_60_UVLO_VTH_START_BIT)

#define AW87XXX_PID_60_UVLO_VTH_VH2P8V_VL2P7V	(2)
#define AW87XXX_PID_60_UVLO_VTH_VH2P8V_VL2P7V_VALUE	\
	(AW87XXX_PID_60_UVLO_VTH_VH2P8V_VL2P7V << AW87XXX_PID_60_UVLO_VTH_START_BIT)

#define AW87XXX_PID_60_UVLO_VTH_VH2P9V_VL2P8V	(3)
#define AW87XXX_PID_60_UVLO_VTH_VH2P9V_VL2P8V_VALUE	\
	(AW87XXX_PID_60_UVLO_VTH_VH2P9V_VL2P8V << AW87XXX_PID_60_UVLO_VTH_START_BIT)

#define AW87XXX_PID_60_UVLO_VTH_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_UVLO_VTH_DEFAULT	\
	(AW87XXX_PID_60_UVLO_VTH_DEFAULT_VALUE << AW87XXX_PID_60_UVLO_VTH_START_BIT)

/* CP_LDO bit 3:2 (CP 0x77) */
#define AW87XXX_PID_60_CP_LDO_START_BIT	(2)
#define AW87XXX_PID_60_CP_LDO_BITS_LEN	(2)
#define AW87XXX_PID_60_CP_LDO_MASK		\
	(~(((1<<AW87XXX_PID_60_CP_LDO_BITS_LEN)-1) << AW87XXX_PID_60_CP_LDO_START_BIT))

#define AW87XXX_PID_60_CP_LDO_4P75V		(0)
#define AW87XXX_PID_60_CP_LDO_4P75V_VALUE	\
	(AW87XXX_PID_60_CP_LDO_4P75V << AW87XXX_PID_60_CP_LDO_START_BIT)

#define AW87XXX_PID_60_CP_LDO_5V		(1)
#define AW87XXX_PID_60_CP_LDO_5V_VALUE	\
	(AW87XXX_PID_60_CP_LDO_5V << AW87XXX_PID_60_CP_LDO_START_BIT)

#define AW87XXX_PID_60_CP_LDO_5P25V		(2)
#define AW87XXX_PID_60_CP_LDO_5P25V_VALUE	\
	(AW87XXX_PID_60_CP_LDO_5P25V << AW87XXX_PID_60_CP_LDO_START_BIT)

#define AW87XXX_PID_60_CP_LDO_5P5V		(3)
#define AW87XXX_PID_60_CP_LDO_5P5V_VALUE	\
	(AW87XXX_PID_60_CP_LDO_5P5V << AW87XXX_PID_60_CP_LDO_START_BIT)

#define AW87XXX_PID_60_CP_LDO_DEFAULT_VALUE	(0x2)
#define AW87XXX_PID_60_CP_LDO_DEFAULT	\
	(AW87XXX_PID_60_CP_LDO_DEFAULT_VALUE << AW87XXX_PID_60_CP_LDO_START_BIT)

/* default value of CP (0x77) */
/* #define AW87XXX_PID_60_CP_DEFAULT		(0x5A) */

/* TEST_GTDR (0x78) detail */
/* TEST_OC bit 0 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_TEST_OC_START_BIT	(0)
#define AW87XXX_PID_60_TEST_OC_BITS_LEN	(1)
#define AW87XXX_PID_60_TEST_OC_MASK		\
	(~(((1<<AW87XXX_PID_60_TEST_OC_BITS_LEN)-1) << AW87XXX_PID_60_TEST_OC_START_BIT))

#define AW87XXX_PID_60_TEST_OC_DISABLE	(0)
#define AW87XXX_PID_60_TEST_OC_DISABLE_VALUE	\
	(AW87XXX_PID_60_TEST_OC_DISABLE << AW87XXX_PID_60_TEST_OC_START_BIT)

#define AW87XXX_PID_60_TEST_OC_ENABLE	(1)
#define AW87XXX_PID_60_TEST_OC_ENABLE_VALUE	\
	(AW87XXX_PID_60_TEST_OC_ENABLE << AW87XXX_PID_60_TEST_OC_START_BIT)

#define AW87XXX_PID_60_TEST_OC_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_TEST_OC_DEFAULT	\
	(AW87XXX_PID_60_TEST_OC_DEFAULT_VALUE << AW87XXX_PID_60_TEST_OC_START_BIT)

/* OC_DEBUG_EN bit 1 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_OC_DEBUG_EN_START_BIT	(1)
#define AW87XXX_PID_60_OC_DEBUG_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_OC_DEBUG_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_OC_DEBUG_EN_BITS_LEN)-1) << AW87XXX_PID_60_OC_DEBUG_EN_START_BIT))

#define AW87XXX_PID_60_OC_DEBUG_EN_DISABLE	(0)
#define AW87XXX_PID_60_OC_DEBUG_EN_DISABLE_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_EN_DISABLE << AW87XXX_PID_60_OC_DEBUG_EN_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_EN_ENABLE	(1)
#define AW87XXX_PID_60_OC_DEBUG_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_EN_ENABLE << AW87XXX_PID_60_OC_DEBUG_EN_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_EN_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_OC_DEBUG_EN_DEFAULT	\
	(AW87XXX_PID_60_OC_DEBUG_EN_DEFAULT_VALUE << AW87XXX_PID_60_OC_DEBUG_EN_START_BIT)

/* LN_RON_T_N bit 4 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_LN_RON_T_N_START_BIT	(4)
#define AW87XXX_PID_60_LN_RON_T_N_BITS_LEN	(1)
#define AW87XXX_PID_60_LN_RON_T_N_MASK	\
	(~(((1<<AW87XXX_PID_60_LN_RON_T_N_BITS_LEN)-1) << AW87XXX_PID_60_LN_RON_T_N_START_BIT))

#define AW87XXX_PID_60_LN_RON_T_N_DISABLE	(0)
#define AW87XXX_PID_60_LN_RON_T_N_DISABLE_VALUE	\
	(AW87XXX_PID_60_LN_RON_T_N_DISABLE << AW87XXX_PID_60_LN_RON_T_N_START_BIT)

#define AW87XXX_PID_60_LN_RON_T_N_ENALBE	(1)
#define AW87XXX_PID_60_LN_RON_T_N_ENALBE_VALUE	\
	(AW87XXX_PID_60_LN_RON_T_N_ENALBE << AW87XXX_PID_60_LN_RON_T_N_START_BIT)

#define AW87XXX_PID_60_LN_RON_T_N_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_LN_RON_T_N_DEFAULT	\
	(AW87XXX_PID_60_LN_RON_T_N_DEFAULT_VALUE << AW87XXX_PID_60_LN_RON_T_N_START_BIT)

/* LN_RON_T_P bit 5 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_LN_RON_T_P_START_BIT	(5)
#define AW87XXX_PID_60_LN_RON_T_P_BITS_LEN	(1)
#define AW87XXX_PID_60_LN_RON_T_P_MASK	\
	(~(((1<<AW87XXX_PID_60_LN_RON_T_P_BITS_LEN)-1) << AW87XXX_PID_60_LN_RON_T_P_START_BIT))

#define AW87XXX_PID_60_LN_RON_T_P_DISABLE	(0)
#define AW87XXX_PID_60_LN_RON_T_P_DISABLE_VALUE	\
	(AW87XXX_PID_60_LN_RON_T_P_DISABLE << AW87XXX_PID_60_LN_RON_T_P_START_BIT)

#define AW87XXX_PID_60_LN_RON_T_P_ENALBE	(1)
#define AW87XXX_PID_60_LN_RON_T_P_ENALBE_VALUE	\
	(AW87XXX_PID_60_LN_RON_T_P_ENALBE << AW87XXX_PID_60_LN_RON_T_P_START_BIT)

#define AW87XXX_PID_60_LN_RON_T_P_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_LN_RON_T_P_DEFAULT	\
	(AW87XXX_PID_60_LN_RON_T_P_DEFAULT_VALUE << AW87XXX_PID_60_LN_RON_T_P_START_BIT)

/* HN_RON_T_N bit 6 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_HN_RON_T_N_START_BIT	(6)
#define AW87XXX_PID_60_HN_RON_T_N_BITS_LEN	(1)
#define AW87XXX_PID_60_HN_RON_T_N_MASK	\
	(~(((1<<AW87XXX_PID_60_HN_RON_T_N_BITS_LEN)-1) << AW87XXX_PID_60_HN_RON_T_N_START_BIT))

#define AW87XXX_PID_60_HN_RON_T_N_DISABLE	(0)
#define AW87XXX_PID_60_HN_RON_T_N_DISABLE_VALUE	\
	(AW87XXX_PID_60_HN_RON_T_N_DISABLE << AW87XXX_PID_60_HN_RON_T_N_START_BIT)

#define AW87XXX_PID_60_HN_RON_T_N_ENALBE	(1)
#define AW87XXX_PID_60_HN_RON_T_N_ENALBE_VALUE	\
	(AW87XXX_PID_60_HN_RON_T_N_ENALBE << AW87XXX_PID_60_HN_RON_T_N_START_BIT)

#define AW87XXX_PID_60_HN_RON_T_N_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_HN_RON_T_N_DEFAULT	\
	(AW87XXX_PID_60_HN_RON_T_N_DEFAULT_VALUE << AW87XXX_PID_60_HN_RON_T_N_START_BIT)

/* HN_RON_T_P bit 7 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_HN_RON_T_P_START_BIT	(7)
#define AW87XXX_PID_60_HN_RON_T_P_BITS_LEN	(1)
#define AW87XXX_PID_60_HN_RON_T_P_MASK	\
	(~(((1<<AW87XXX_PID_60_HN_RON_T_P_BITS_LEN)-1) << AW87XXX_PID_60_HN_RON_T_P_START_BIT))

#define AW87XXX_PID_60_HN_RON_T_P_DISABLE	(0)
#define AW87XXX_PID_60_HN_RON_T_P_DISABLE_VALUE	\
	(AW87XXX_PID_60_HN_RON_T_P_DISABLE << AW87XXX_PID_60_HN_RON_T_P_START_BIT)

#define AW87XXX_PID_60_HN_RON_T_P_ENALBE	(1)
#define AW87XXX_PID_60_HN_RON_T_P_ENALBE_VALUE	\
	(AW87XXX_PID_60_HN_RON_T_P_ENALBE << AW87XXX_PID_60_HN_RON_T_P_START_BIT)

#define AW87XXX_PID_60_HN_RON_T_P_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_HN_RON_T_P_DEFAULT	\
	(AW87XXX_PID_60_HN_RON_T_P_DEFAULT_VALUE << AW87XXX_PID_60_HN_RON_T_P_START_BIT)

/* OC_DEBUG_SEL bit 3:2 (TEST_GTDR 0x78) */
#define AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT	(2)
#define AW87XXX_PID_60_OC_DEBUG_SEL_BITS_LEN	(2)
#define AW87XXX_PID_60_OC_DEBUG_SEL_MASK	\
	(~(((1<<AW87XXX_PID_60_OC_DEBUG_SEL_BITS_LEN)-1) << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT))

#define AW87XXX_PID_60_OC_DEBUG_SEL_VOPP	(0)
#define AW87XXX_PID_60_OC_DEBUG_SEL_VOPP_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_SEL_VOPP << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_SEL_VOPN	(1)
#define AW87XXX_PID_60_OC_DEBUG_SEL_VOPN_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_SEL_VOPN << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_SEL_VONP	(2)
#define AW87XXX_PID_60_OC_DEBUG_SEL_VONP_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_SEL_VONP << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_SEL_VONN	(3)
#define AW87XXX_PID_60_OC_DEBUG_SEL_VONN_VALUE	\
	(AW87XXX_PID_60_OC_DEBUG_SEL_VONN << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT)

#define AW87XXX_PID_60_OC_DEBUG_SEL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_OC_DEBUG_SEL_DEFAULT	\
	(AW87XXX_PID_60_OC_DEBUG_SEL_DEFAULT_VALUE << AW87XXX_PID_60_OC_DEBUG_SEL_START_BIT)

/* default value of TEST_GTDR (0x78) */
/* #define AW87XXX_PID_60_TEST_GTDR_DEFAULT		(0x00) */

/* TEST_BST (0x79) detail */
/* BST_LNMOS_TEST bit 0 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_LNMOS_TEST_START_BIT	(0)
#define AW87XXX_PID_60_BST_LNMOS_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_LNMOS_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_LNMOS_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_LNMOS_TEST_START_BIT))

#define AW87XXX_PID_60_BST_LNMOS_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_LNMOS_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_LNMOS_TEST_DIABLE << AW87XXX_PID_60_BST_LNMOS_TEST_START_BIT)

#define AW87XXX_PID_60_BST_LNMOS_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_LNMOS_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_LNMOS_TEST_ENABLE << AW87XXX_PID_60_BST_LNMOS_TEST_START_BIT)

#define AW87XXX_PID_60_BST_LNMOS_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_LNMOS_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_LNMOS_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_LNMOS_TEST_START_BIT)

/* BST_HNMOS_TEST bit 1 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_HNMOS_TEST_START_BIT	(1)
#define AW87XXX_PID_60_BST_HNMOS_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_HNMOS_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_HNMOS_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_HNMOS_TEST_START_BIT))

#define AW87XXX_PID_60_BST_HNMOS_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_HNMOS_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_HNMOS_TEST_DIABLE << AW87XXX_PID_60_BST_HNMOS_TEST_START_BIT)

#define AW87XXX_PID_60_BST_HNMOS_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_HNMOS_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_HNMOS_TEST_ENABLE << AW87XXX_PID_60_BST_HNMOS_TEST_START_BIT)

#define AW87XXX_PID_60_BST_HNMOS_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_HNMOS_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_HNMOS_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_HNMOS_TEST_START_BIT)

/* BST_SCP_TEST bit 2 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_SCP_TEST_START_BIT	(2)
#define AW87XXX_PID_60_BST_SCP_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_SCP_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_SCP_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_SCP_TEST_START_BIT))

#define AW87XXX_PID_60_BST_SCP_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_SCP_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_SCP_TEST_DIABLE << AW87XXX_PID_60_BST_SCP_TEST_START_BIT)

#define AW87XXX_PID_60_BST_SCP_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_SCP_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_SCP_TEST_ENABLE << AW87XXX_PID_60_BST_SCP_TEST_START_BIT)

#define AW87XXX_PID_60_BST_SCP_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_SCP_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_SCP_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_SCP_TEST_START_BIT)

/* ANTIR_TEST bit 3 (TEST_BST 0x79) */
#define AW87XXX_PID_60_ANTIR_TEST_START_BIT	(3)
#define AW87XXX_PID_60_ANTIR_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_ANTIR_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_ANTIR_TEST_BITS_LEN)-1) << AW87XXX_PID_60_ANTIR_TEST_START_BIT))

#define AW87XXX_PID_60_ANTIR_TEST_DIABLE	(0)
#define AW87XXX_PID_60_ANTIR_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_ANTIR_TEST_DIABLE << AW87XXX_PID_60_ANTIR_TEST_START_BIT)

#define AW87XXX_PID_60_ANTIR_TEST_ENABLE	(1)
#define AW87XXX_PID_60_ANTIR_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_ANTIR_TEST_ENABLE << AW87XXX_PID_60_ANTIR_TEST_START_BIT)

#define AW87XXX_PID_60_ANTIR_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_ANTIR_TEST_DEFAULT	\
	(AW87XXX_PID_60_ANTIR_TEST_DEFAULT_VALUE << AW87XXX_PID_60_ANTIR_TEST_START_BIT)

/* BST_PEAK_TEST bit 4 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_PEAK_TEST_START_BIT	(4)
#define AW87XXX_PID_60_BST_PEAK_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_PEAK_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_PEAK_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_PEAK_TEST_START_BIT))

#define AW87XXX_PID_60_BST_PEAK_TEST_DISABLE	(0)
#define AW87XXX_PID_60_BST_PEAK_TEST_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_PEAK_TEST_DISABLE << AW87XXX_PID_60_BST_PEAK_TEST_START_BIT)

#define AW87XXX_PID_60_BST_PEAK_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_PEAK_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_PEAK_TEST_ENABLE << AW87XXX_PID_60_BST_PEAK_TEST_START_BIT)

#define AW87XXX_PID_60_BST_PEAK_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_PEAK_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_PEAK_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_PEAK_TEST_START_BIT)

/* BST_OVP_TEST bit 5 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_OVP_TEST_START_BIT	(5)
#define AW87XXX_PID_60_BST_OVP_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_OVP_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_OVP_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_OVP_TEST_START_BIT))

#define AW87XXX_PID_60_BST_OVP_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_OVP_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_OVP_TEST_DIABLE << AW87XXX_PID_60_BST_OVP_TEST_START_BIT)

#define AW87XXX_PID_60_BST_OVP_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_OVP_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_OVP_TEST_ENABLE << AW87XXX_PID_60_BST_OVP_TEST_START_BIT)

#define AW87XXX_PID_60_BST_OVP_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_OVP_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_OVP_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_OVP_TEST_START_BIT)

/* BST_TEST_EN bit 6 (TEST_BST 0x79) */
#define AW87XXX_PID_60_BST_TEST_EN_START_BIT	(6)
#define AW87XXX_PID_60_BST_TEST_EN_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_TEST_EN_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_TEST_EN_BITS_LEN)-1) << AW87XXX_PID_60_BST_TEST_EN_START_BIT))

#define AW87XXX_PID_60_BST_TEST_EN_DIABLE	(0)
#define AW87XXX_PID_60_BST_TEST_EN_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_TEST_EN_DIABLE << AW87XXX_PID_60_BST_TEST_EN_START_BIT)

#define AW87XXX_PID_60_BST_TEST_EN_ENABLE	(1)
#define AW87XXX_PID_60_BST_TEST_EN_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_TEST_EN_ENABLE << AW87XXX_PID_60_BST_TEST_EN_START_BIT)

#define AW87XXX_PID_60_BST_TEST_EN_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_TEST_EN_DEFAULT	\
	(AW87XXX_PID_60_BST_TEST_EN_DEFAULT_VALUE << AW87XXX_PID_60_BST_TEST_EN_START_BIT)

/* OC_DISABLE bit 7 (TEST_BST 0x79) */
#define AW87XXX_PID_60_OC_DISABLE_START_BIT	(7)
#define AW87XXX_PID_60_OC_DISABLE_BITS_LEN	(1)
#define AW87XXX_PID_60_OC_DISABLE_MASK	\
	(~(((1<<AW87XXX_PID_60_OC_DISABLE_BITS_LEN)-1) << AW87XXX_PID_60_OC_DISABLE_START_BIT))

#define AW87XXX_PID_60_OC_DISABLE_ENABLE	(0)
#define AW87XXX_PID_60_OC_DISABLE_ENABLE_VALUE	\
	(AW87XXX_PID_60_OC_DISABLE_ENABLE << AW87XXX_PID_60_OC_DISABLE_START_BIT)

#define AW87XXX_PID_60_OC_DISABLE_SHUTDOWN	(1)
#define AW87XXX_PID_60_OC_DISABLE_SHUTDOWN_VALUE	\
	(AW87XXX_PID_60_OC_DISABLE_SHUTDOWN << AW87XXX_PID_60_OC_DISABLE_START_BIT)

#define AW87XXX_PID_60_OC_DISABLE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_OC_DISABLE_DEFAULT	\
	(AW87XXX_PID_60_OC_DISABLE_DEFAULT_VALUE << AW87XXX_PID_60_OC_DISABLE_START_BIT)

/* default value of TEST_BST (0x79) */
/* #define AW87XXX_PID_60_TEST_BST_DEFAULT		(0x00) */

/* TEST_MODE (0x7A) detail */
/* PA_TEST_FORCE bit 3 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_PA_TEST_FORCE_START_BIT	(3)
#define AW87XXX_PID_60_PA_TEST_FORCE_BITS_LEN	(1)
#define AW87XXX_PID_60_PA_TEST_FORCE_MASK	\
	(~(((1<<AW87XXX_PID_60_PA_TEST_FORCE_BITS_LEN)-1) << AW87XXX_PID_60_PA_TEST_FORCE_START_BIT))

#define AW87XXX_PID_60_PA_TEST_FORCE_DISABLE	(0)
#define AW87XXX_PID_60_PA_TEST_FORCE_DISABLE_VALUE	\
	(AW87XXX_PID_60_PA_TEST_FORCE_DISABLE << AW87XXX_PID_60_PA_TEST_FORCE_START_BIT)

#define AW87XXX_PID_60_PA_TEST_FORCE_ENABLE	(1)
#define AW87XXX_PID_60_PA_TEST_FORCE_ENABLE_VALUE	\
	(AW87XXX_PID_60_PA_TEST_FORCE_ENABLE << AW87XXX_PID_60_PA_TEST_FORCE_START_BIT)

#define AW87XXX_PID_60_PA_TEST_FORCE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_PA_TEST_FORCE_DEFAULT	\
	(AW87XXX_PID_60_PA_TEST_FORCE_DEFAULT_VALUE << AW87XXX_PID_60_PA_TEST_FORCE_START_BIT)

/* BST_TEST_FORCE bit 4 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_BST_TEST_FORCE_START_BIT	(4)
#define AW87XXX_PID_60_BST_TEST_FORCE_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_TEST_FORCE_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_TEST_FORCE_BITS_LEN)-1) << AW87XXX_PID_60_BST_TEST_FORCE_START_BIT))

#define AW87XXX_PID_60_BST_TEST_FORCE_DISABLE	(0)
#define AW87XXX_PID_60_BST_TEST_FORCE_DISABLE_VALUE	\
	(AW87XXX_PID_60_BST_TEST_FORCE_DISABLE << AW87XXX_PID_60_BST_TEST_FORCE_START_BIT)

#define AW87XXX_PID_60_BST_TEST_FORCE_ENABLE	(1)
#define AW87XXX_PID_60_BST_TEST_FORCE_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_TEST_FORCE_ENABLE << AW87XXX_PID_60_BST_TEST_FORCE_START_BIT)

#define AW87XXX_PID_60_BST_TEST_FORCE_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_BST_TEST_FORCE_DEFAULT	\
	(AW87XXX_PID_60_BST_TEST_FORCE_DEFAULT_VALUE << AW87XXX_PID_60_BST_TEST_FORCE_START_BIT)

/* EN_OT_TEST bit 5 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_EN_OT_TEST_START_BIT	(5)
#define AW87XXX_PID_60_EN_OT_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_OT_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_OT_TEST_BITS_LEN)-1) << AW87XXX_PID_60_EN_OT_TEST_START_BIT))

#define AW87XXX_PID_60_EN_OT_TEST_DISABLE	(0)
#define AW87XXX_PID_60_EN_OT_TEST_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_OT_TEST_DISABLE << AW87XXX_PID_60_EN_OT_TEST_START_BIT)

#define AW87XXX_PID_60_EN_OT_TEST_ENABLE	(1)
#define AW87XXX_PID_60_EN_OT_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_OT_TEST_ENABLE << AW87XXX_PID_60_EN_OT_TEST_START_BIT)

#define AW87XXX_PID_60_EN_OT_TEST_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_OT_TEST_DEFAULT	\
	(AW87XXX_PID_60_EN_OT_TEST_DEFAULT_VALUE << AW87XXX_PID_60_EN_OT_TEST_START_BIT)

/* EN_TEST bit 6 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_EN_TEST_START_BIT	(6)
#define AW87XXX_PID_60_EN_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_TEST_MASK		\
	(~(((1<<AW87XXX_PID_60_EN_TEST_BITS_LEN)-1) << AW87XXX_PID_60_EN_TEST_START_BIT))

#define AW87XXX_PID_60_EN_TEST_DISABLE	(0)
#define AW87XXX_PID_60_EN_TEST_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_TEST_DISABLE << AW87XXX_PID_60_EN_TEST_START_BIT)

#define AW87XXX_PID_60_EN_TEST_ENABLE	(1)
#define AW87XXX_PID_60_EN_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_TEST_ENABLE << AW87XXX_PID_60_EN_TEST_START_BIT)

#define AW87XXX_PID_60_EN_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_EN_TEST_DEFAULT	\
	(AW87XXX_PID_60_EN_TEST_DEFAULT_VALUE << AW87XXX_PID_60_EN_TEST_START_BIT)

/* BST_BURST_TEST bit 7 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_BST_BURST_TEST_START_BIT	(7)
#define AW87XXX_PID_60_BST_BURST_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_BST_BURST_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_BST_BURST_TEST_BITS_LEN)-1) << AW87XXX_PID_60_BST_BURST_TEST_START_BIT))

#define AW87XXX_PID_60_BST_BURST_TEST_DIABLE	(0)
#define AW87XXX_PID_60_BST_BURST_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_BST_BURST_TEST_DIABLE << AW87XXX_PID_60_BST_BURST_TEST_START_BIT)

#define AW87XXX_PID_60_BST_BURST_TEST_ENABLE	(1)
#define AW87XXX_PID_60_BST_BURST_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_BST_BURST_TEST_ENABLE << AW87XXX_PID_60_BST_BURST_TEST_START_BIT)

#define AW87XXX_PID_60_BST_BURST_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_BST_BURST_TEST_DEFAULT	\
	(AW87XXX_PID_60_BST_BURST_TEST_DEFAULT_VALUE << AW87XXX_PID_60_BST_BURST_TEST_START_BIT)

/* TEST_ANALOG_CTRL bit 2:0 (TEST_MODE 0x7A) */
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT	(0)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_BITS_LEN	(3)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_MASK	\
	(~(((1<<AW87XXX_PID_60_TEST_ANALOG_CTRL_BITS_LEN)-1) << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT))

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VBG	(0)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VBG_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_VBG << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_COMPT	(1)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_COMPT_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_COMPT << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_HALFVDD	(2)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_HALFVDD_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_HALFVDD << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VCSEL	(3)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VCSEL_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_VCSEL << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VLSEL	(4)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VLSEL_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_VLSEL << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH1T	(5)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH1T_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH1T << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH4T	(6)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH4T_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_MSBMVTH4T << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VCM2T	(7)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_VCM2T_VALUE	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_VCM2T << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_ANALOG_CTRL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_TEST_ANALOG_CTRL_DEFAULT	\
	(AW87XXX_PID_60_TEST_ANALOG_CTRL_DEFAULT_VALUE << AW87XXX_PID_60_TEST_ANALOG_CTRL_START_BIT)

/* default value of TEST_MODE (0x7A) */
/* #define AW87XXX_PID_60_TEST_MODE_DEFAULT		(0x00) */

/* TEST_CON (0x7B) detail */
/* COMP_TEST bit 5 (TEST_CON 0x7B) */
#define AW87XXX_PID_60_COMP_TEST_START_BIT	(5)
#define AW87XXX_PID_60_COMP_TEST_BITS_LEN	(1)
#define AW87XXX_PID_60_COMP_TEST_MASK	\
	(~(((1<<AW87XXX_PID_60_COMP_TEST_BITS_LEN)-1) << AW87XXX_PID_60_COMP_TEST_START_BIT))

#define AW87XXX_PID_60_COMP_TEST_DIABLE	(0)
#define AW87XXX_PID_60_COMP_TEST_DIABLE_VALUE	\
	(AW87XXX_PID_60_COMP_TEST_DIABLE << AW87XXX_PID_60_COMP_TEST_START_BIT)

#define AW87XXX_PID_60_COMP_TEST_ENABLE	(1)
#define AW87XXX_PID_60_COMP_TEST_ENABLE_VALUE	\
	(AW87XXX_PID_60_COMP_TEST_ENABLE << AW87XXX_PID_60_COMP_TEST_START_BIT)

#define AW87XXX_PID_60_COMP_TEST_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_COMP_TEST_DEFAULT	\
	(AW87XXX_PID_60_COMP_TEST_DEFAULT_VALUE << AW87XXX_PID_60_COMP_TEST_START_BIT)

/* REG_EN_ESD bit 6 (TEST_CON 0x7B) */
#define AW87XXX_PID_60_REG_EN_ESD_START_BIT	(6)
#define AW87XXX_PID_60_REG_EN_ESD_BITS_LEN	(1)
#define AW87XXX_PID_60_REG_EN_ESD_MASK	\
	(~(((1<<AW87XXX_PID_60_REG_EN_ESD_BITS_LEN)-1) << AW87XXX_PID_60_REG_EN_ESD_START_BIT))

#define AW87XXX_PID_60_REG_EN_ESD_DISABLE	(0)
#define AW87XXX_PID_60_REG_EN_ESD_DISABLE_VALUE	\
	(AW87XXX_PID_60_REG_EN_ESD_DISABLE << AW87XXX_PID_60_REG_EN_ESD_START_BIT)

#define AW87XXX_PID_60_REG_EN_ESD_ENABLE	(1)
#define AW87XXX_PID_60_REG_EN_ESD_ENABLE_VALUE	\
	(AW87XXX_PID_60_REG_EN_ESD_ENABLE << AW87XXX_PID_60_REG_EN_ESD_START_BIT)

#define AW87XXX_PID_60_REG_EN_ESD_DEFAULT_VALUE	(0)
#define AW87XXX_PID_60_REG_EN_ESD_DEFAULT	\
	(AW87XXX_PID_60_REG_EN_ESD_DEFAULT_VALUE << AW87XXX_PID_60_REG_EN_ESD_START_BIT)

/* EN_POWER_MT bit 7 (TEST_CON 0x7B) */
#define AW87XXX_PID_60_EN_POWER_MT_START_BIT	(7)
#define AW87XXX_PID_60_EN_POWER_MT_BITS_LEN	(1)
#define AW87XXX_PID_60_EN_POWER_MT_MASK	\
	(~(((1<<AW87XXX_PID_60_EN_POWER_MT_BITS_LEN)-1) << AW87XXX_PID_60_EN_POWER_MT_START_BIT))

#define AW87XXX_PID_60_EN_POWER_MT_DISABLE	(0)
#define AW87XXX_PID_60_EN_POWER_MT_DISABLE_VALUE	\
	(AW87XXX_PID_60_EN_POWER_MT_DISABLE << AW87XXX_PID_60_EN_POWER_MT_START_BIT)

#define AW87XXX_PID_60_EN_POWER_MT_ENABLE	(1)
#define AW87XXX_PID_60_EN_POWER_MT_ENABLE_VALUE	\
	(AW87XXX_PID_60_EN_POWER_MT_ENABLE << AW87XXX_PID_60_EN_POWER_MT_START_BIT)

#define AW87XXX_PID_60_EN_POWER_MT_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_EN_POWER_MT_DEFAULT	\
	(AW87XXX_PID_60_EN_POWER_MT_DEFAULT_VALUE << AW87XXX_PID_60_EN_POWER_MT_START_BIT)

/* TEST_DIGITAL_CTRL bit 4:0 (TEST_CON 0x7B) */
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT	(0)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BITS_LEN	(5)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_MASK	\
	(~(((1<<AW87XXX_PID_60_TEST_DIGITAL_CTRL_BITS_LEN)-1) << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT))

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVPS	(0)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVPS_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVPS << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVP2	(1)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVP2_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTOVP2 << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTHNMOS	(2)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTHNMOS_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTHNMOS << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTLNMOS	(3)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTLNMOS_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTLNMOS << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTPEAK	(4)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTPEAK_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTPEAK << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTRSQ	(5)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTRSQ_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTRSQ << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTBURST	(6)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTBURST_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTBURST << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSSFINISH	(7)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSSFINISH_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSSFINISH << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSCP	(8)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSCP_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTSCP << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTENCLAMP	(9)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTENCLAMP_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTENCLAMP << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTNCD	(10)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTNCD_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_BSTNCD << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENSYNC	(11)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENSYNC_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENSYNC << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENOTA	(12)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENOTA_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_ENOTA << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_NGDET	(13)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_NGDET_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_NGDET << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTN	(14)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTN_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTN << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTN	(15)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTN_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTN << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEN	(16)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEN_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEN << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTP	(17)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTP_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_HNGTP << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTP	(18)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTP_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_LNGTP << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEP	(19)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEP_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_GATESENSEP << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ADPBOOST	(20)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_ADPBOOST_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_ADPBOOST << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW0ABOVE	(21)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW0ABOVE_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW0ABOVE << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW3ABOVE	(22)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW3ABOVE_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_POVTHBELOW3ABOVE << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_AMPOC	(23)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_AMPOC_VALUE	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_AMPOC << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_TEST_DIGITAL_CTRL_DEFAULT	\
	(AW87XXX_PID_60_TEST_DIGITAL_CTRL_DEFAULT_VALUE << AW87XXX_PID_60_TEST_DIGITAL_CTRL_START_BIT)

/* default value of TEST_CON (0x7B) */
/* #define AW87XXX_PID_60_TEST_CON_DEFAULT		(0x00) */

/* ENCR (0x7C) detail */
/* TEST_REG_ENCRY bit 7:6 (ENCR 0x7C) */
#define AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT	(6)
#define AW87XXX_PID_60_TEST_REG_ENCRY_BITS_LEN	(2)
#define AW87XXX_PID_60_TEST_REG_ENCRY_MASK	\
	(~(((1<<AW87XXX_PID_60_TEST_REG_ENCRY_BITS_LEN)-1) << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT))

#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE0	(0)
#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE0_VALUE	\
	(AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE0 << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE1	(1)
#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE1_VALUE	\
	(AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE1 << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE2	(2)
#define AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE2_VALUE	\
	(AW87XXX_PID_60_TEST_REG_ENCRY_CANNOT_WRITE2 << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_TEST_REG_ENCRY_CAN_BE_WRITE	(3)
#define AW87XXX_PID_60_TEST_REG_ENCRY_CAN_BE_WRITE_VALUE	\
	(AW87XXX_PID_60_TEST_REG_ENCRY_CAN_BE_WRITE << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT)
/*
Fix me here:
reg_addr:0x7C, reg_name:ENCR, field_name:TEST_REG_ENCRY, content:Encryption bits for test registers(78h~7Ch) , when0x7D=7a & test_Reg_Encry=11
maybe need to fix manually
*/
#define AW87XXX_PID_60_TEST_REG_ENCRY_DEFAULT_VALUE	(0x0)
#define AW87XXX_PID_60_TEST_REG_ENCRY_DEFAULT	\
	(AW87XXX_PID_60_TEST_REG_ENCRY_DEFAULT_VALUE << AW87XXX_PID_60_TEST_REG_ENCRY_START_BIT)

/* PRODUCT_REG_ENCRY bit 5:0 (ENCR 0x7C) */
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT	(0)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_BITS_LEN	(6)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_MASK	\
	(~(((1<<AW87XXX_PID_60_PRODUCT_REG_ENCRY_BITS_LEN)-1) << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT))

#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87560	(1)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87560_VALUE	\
	(AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87560 << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87561	(2)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87561_VALUE	\
	(AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87561 << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87562	(4)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87562_VALUE	\
	(AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87562 << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT)

#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87501	(8)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87501_VALUE	\
	(AW87XXX_PID_60_PRODUCT_REG_ENCRY_AW87501 << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT)
/*
Fix me here:
reg_addr:0x7C, reg_name:ENCR, field_name:PRODUCT_REG_ENCRY, content:Production encryption  register (when0x7D=7a & test_Reg_Encry=11 
maybe need to fix manually
*/
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_DEFAULT_VALUE	(0x1)
#define AW87XXX_PID_60_PRODUCT_REG_ENCRY_DEFAULT	\
	(AW87XXX_PID_60_PRODUCT_REG_ENCRY_DEFAULT_VALUE << AW87XXX_PID_60_PRODUCT_REG_ENCRY_START_BIT)

/* default value of ENCR (0x7C) */
/* #define AW87XXX_PID_60_ENCR_DEFAULT		(0x01) */

/* detail information of registers end */

#endif  /* #ifndef  __AW87XXX_PID_60_REG_H__ */