#ifndef __AW87XXX_PID_76_REG_H__
#define __AW87XXX_PID_76_REG_H__

/* registers list */
#define AW87XXX_PID_76_ID_REG			(0x00)
#define AW87XXX_PID_76_SYSCTRL_REG		(0x01)
#define AW87XXX_PID_76_MDCTRL_REG		(0x02)
#define AW87XXX_PID_76_CPOVP_REG		(0x03)
#define AW87XXX_PID_76_CPP_REG			(0x04)
#define AW87XXX_PID_76_PAG_REG			(0x05)
#define AW87XXX_PID_76_AGC3P_REG		(0x06)
#define AW87XXX_PID_76_AGC3PA_REG		(0x07)
#define AW87XXX_PID_76_AGC2P_REG		(0x08)
#define AW87XXX_PID_76_AGC2PA_REG		(0x09)
#define AW87XXX_PID_76_AGC1PA_REG		(0x0A)
#define AW87XXX_PID_76_SYSST_REG		(0x59)
#define AW87XXX_PID_76_SYSINT_REG		(0x60)
#define AW87XXX_PID_76_DFT_SYSCTRL_REG		(0x61)
#define AW87XXX_PID_76_DFT_MDCTRL_REG		(0x62)
#define AW87XXX_PID_76_DFT_CPADP_REG		(0x63)
#define AW87XXX_PID_76_DFT_AGCPA_REG		(0x64)
#define AW87XXX_PID_76_DFT_POFR_REG		(0x65)
#define AW87XXX_PID_76_DFT_OC_REG		(0x66)
#define AW87XXX_PID_76_DFT_ADP1_REG		(0x67)
#define AW87XXX_PID_76_DFT_REF_REG		(0x68)
#define AW87XXX_PID_76_DFT_LDO_REG		(0x69)
#define AW87XXX_PID_76_ADP1_REG			(0x70)
#define AW87XXX_PID_76_ADP2_REG			(0x71)
#define AW87XXX_PID_76_NG1_REG			(0x72)
#define AW87XXX_PID_76_NG2_REG			(0x73)
#define AW87XXX_PID_76_NG3_REG			(0x74)
#define AW87XXX_PID_76_CP_REG			(0x75)
#define AW87XXX_PID_76_AB_REG			(0x76)
#define AW87XXX_PID_76_TEST_REG			(0x77)
#define AW87XXX_PID_76_ENCR_REG			(0x78)
#define AW87XXX_PID_76_DFT_ADP1_CHECK		(0x04)

/********************************************
 * soft control info
 * If you need to update this file, add this information manually
 *******************************************/
unsigned char aw87xxx_pid_76_softrst_access[2] = {0x00, 0xaa};


/********************************************
 * Register Access
 *******************************************/
#define AW87XXX_PID_76_REG_MAX				(0x79)

#define REG_NONE_ACCESS					(0)
#define REG_RD_ACCESS					(1 << 0)
#define REG_WR_ACCESS					(1 << 1)

const unsigned char aw87xxx_pid_76_reg_access[AW87XXX_PID_76_REG_MAX] = {
	[AW87XXX_PID_76_ID_REG]		= (REG_RD_ACCESS),
	[AW87XXX_PID_76_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_MDCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_CPOVP_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_CPP_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_PAG_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AGC3P_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AGC3PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AGC2P_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AGC2PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AGC1PA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_SYSST_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_76_SYSINT_REG]	= (REG_RD_ACCESS),
	[AW87XXX_PID_76_DFT_SYSCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_MDCTRL_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_CPADP_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_AGCPA_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_POFR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_OC_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_ADP1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_REF_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_DFT_LDO_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_ADP1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_ADP2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_NG1_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_NG2_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_NG3_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_CP_REG]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_AB_REG]		= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_TEST_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
	[AW87XXX_PID_76_ENCR_REG]	= (REG_RD_ACCESS | REG_WR_ACCESS),
};

/* detail information of registers begin */
/* ID (0x00) detail */
/* IDCODE bit 7:0 (ID 0x00) */
#define AW87XXX_PID_76_IDCODE_START_BIT	(0)
#define AW87XXX_PID_76_IDCODE_BITS_LEN	(8)
#define AW87XXX_PID_76_IDCODE_MASK		\
	(~(((1<<AW87XXX_PID_76_IDCODE_BITS_LEN)-1) << AW87XXX_PID_76_IDCODE_START_BIT))

#define AW87XXX_PID_76_IDCODE_DEFAULT_VALUE	(0x76)
#define AW87XXX_PID_76_IDCODE_DEFAULT	\
	(AW87XXX_PID_76_IDCODE_DEFAULT_VALUE << AW87XXX_PID_76_IDCODE_START_BIT)

/* default value of ID (0x00) */
/* #define AW87XXX_PID_76_ID_DEFAULT		(0x76) */

/* SYSCTRL (0x01) detail */
/* EN_PA bit 2 (SYSCTRL 0x01) */
#define AW87XXX_PID_76_EN_PA_START_BIT	(2)
#define AW87XXX_PID_76_EN_PA_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_PA_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_PA_BITS_LEN)-1) << AW87XXX_PID_76_EN_PA_START_BIT))

#define AW87XXX_PID_76_EN_PA_DISABLE	(0)
#define AW87XXX_PID_76_EN_PA_DISABLE_VALUE	\
	(AW87XXX_PID_76_EN_PA_DISABLE << AW87XXX_PID_76_EN_PA_START_BIT)

#define AW87XXX_PID_76_EN_PA_ENABLE_DEPENDS_ON_EN_AB	(1)
#define AW87XXX_PID_76_EN_PA_ENABLE_DEPENDS_ON_EN_AB_VALUE	\
	(AW87XXX_PID_76_EN_PA_ENABLE_DEPENDS_ON_EN_AB << AW87XXX_PID_76_EN_PA_START_BIT)

#define AW87XXX_PID_76_EN_PA_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_EN_PA_DEFAULT	\
	(AW87XXX_PID_76_EN_PA_DEFAULT_VALUE << AW87XXX_PID_76_EN_PA_START_BIT)

/* EN_CP bit 1 (SYSCTRL 0x01) */
#define AW87XXX_PID_76_EN_CP_START_BIT	(1)
#define AW87XXX_PID_76_EN_CP_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_CP_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_CP_BITS_LEN)-1) << AW87XXX_PID_76_EN_CP_START_BIT))

#define AW87XXX_PID_76_EN_CP_DISABLE_PVDD0	(0)
#define AW87XXX_PID_76_EN_CP_DISABLE_PVDD0_VALUE	\
	(AW87XXX_PID_76_EN_CP_DISABLE_PVDD0 << AW87XXX_PID_76_EN_CP_START_BIT)

#define AW87XXX_PID_76_EN_CP_ENABLE_DEPENDS_ON_EN_2X	(1)
#define AW87XXX_PID_76_EN_CP_ENABLE_DEPENDS_ON_EN_2X_VALUE	\
	(AW87XXX_PID_76_EN_CP_ENABLE_DEPENDS_ON_EN_2X << AW87XXX_PID_76_EN_CP_START_BIT)

#define AW87XXX_PID_76_EN_CP_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_EN_CP_DEFAULT	\
	(AW87XXX_PID_76_EN_CP_DEFAULT_VALUE << AW87XXX_PID_76_EN_CP_START_BIT)

/* PU_CPPA bit 0 (SYSCTRL 0x01) */
#define AW87XXX_PID_76_PU_CPPA_START_BIT	(0)
#define AW87XXX_PID_76_PU_CPPA_BITS_LEN	(1)
#define AW87XXX_PID_76_PU_CPPA_MASK		\
	(~(((1<<AW87XXX_PID_76_PU_CPPA_BITS_LEN)-1) << AW87XXX_PID_76_PU_CPPA_START_BIT))

#define AW87XXX_PID_76_PU_CPPA_POWERMINUS_DOWN	(0)
#define AW87XXX_PID_76_PU_CPPA_POWERMINUS_DOWN_VALUE	\
	(AW87XXX_PID_76_PU_CPPA_POWERMINUS_DOWN << AW87XXX_PID_76_PU_CPPA_START_BIT)

#define AW87XXX_PID_76_PU_CPPA_POWERMINUS_UP	(1)
#define AW87XXX_PID_76_PU_CPPA_POWERMINUS_UP_VALUE	\
	(AW87XXX_PID_76_PU_CPPA_POWERMINUS_UP << AW87XXX_PID_76_PU_CPPA_START_BIT)

#define AW87XXX_PID_76_PU_CPPA_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_PU_CPPA_DEFAULT	\
	(AW87XXX_PID_76_PU_CPPA_DEFAULT_VALUE << AW87XXX_PID_76_PU_CPPA_START_BIT)

/* default value of SYSCTRL (0x01) */
/* #define AW87XXX_PID_76_SYSCTRL_DEFAULT		(0x06) */

/* MDCTRL (0x02) detail */
/* EN_ADAP bit 4 (MDCTRL 0x02) */
#define AW87XXX_PID_76_EN_ADAP_START_BIT	(4)
#define AW87XXX_PID_76_EN_ADAP_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_ADAP_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_ADAP_BITS_LEN)-1) << AW87XXX_PID_76_EN_ADAP_START_BIT))

#define AW87XXX_PID_76_EN_ADAP_DISABLEDEFAULT	(0)
#define AW87XXX_PID_76_EN_ADAP_DISABLEDEFAULT_VALUE	\
	(AW87XXX_PID_76_EN_ADAP_DISABLEDEFAULT << AW87XXX_PID_76_EN_ADAP_START_BIT)

#define AW87XXX_PID_76_EN_ADAP_ENABLE	(1)
#define AW87XXX_PID_76_EN_ADAP_ENABLE_VALUE	\
	(AW87XXX_PID_76_EN_ADAP_ENABLE << AW87XXX_PID_76_EN_ADAP_START_BIT)

#define AW87XXX_PID_76_EN_ADAP_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_EN_ADAP_DEFAULT	\
	(AW87XXX_PID_76_EN_ADAP_DEFAULT_VALUE << AW87XXX_PID_76_EN_ADAP_START_BIT)

/* EN_2X bit 3 (MDCTRL 0x02) */
#define AW87XXX_PID_76_EN_2X_START_BIT	(3)
#define AW87XXX_PID_76_EN_2X_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_2X_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_2X_BITS_LEN)-1) << AW87XXX_PID_76_EN_2X_START_BIT))

#define AW87XXX_PID_76_EN_2X_DISABLE	(0)
#define AW87XXX_PID_76_EN_2X_DISABLE_VALUE	\
	(AW87XXX_PID_76_EN_2X_DISABLE << AW87XXX_PID_76_EN_2X_START_BIT)

#define AW87XXX_PID_76_EN_2X_ENABLE		(1)
#define AW87XXX_PID_76_EN_2X_ENABLE_VALUE	\
	(AW87XXX_PID_76_EN_2X_ENABLE << AW87XXX_PID_76_EN_2X_START_BIT)

#define AW87XXX_PID_76_EN_2X_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_EN_2X_DEFAULT	\
	(AW87XXX_PID_76_EN_2X_DEFAULT_VALUE << AW87XXX_PID_76_EN_2X_START_BIT)

/* EN_SPK bit 2 (MDCTRL 0x02) */
#define AW87XXX_PID_76_EN_SPK_START_BIT	(2)
#define AW87XXX_PID_76_EN_SPK_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_SPK_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_SPK_BITS_LEN)-1) << AW87XXX_PID_76_EN_SPK_START_BIT))

#define AW87XXX_PID_76_EN_SPK_DISABLE	(0)
#define AW87XXX_PID_76_EN_SPK_DISABLE_VALUE	\
	(AW87XXX_PID_76_EN_SPK_DISABLE << AW87XXX_PID_76_EN_SPK_START_BIT)

#define AW87XXX_PID_76_EN_SPK_ENABLE	(1)
#define AW87XXX_PID_76_EN_SPK_ENABLE_VALUE	\
	(AW87XXX_PID_76_EN_SPK_ENABLE << AW87XXX_PID_76_EN_SPK_START_BIT)

#define AW87XXX_PID_76_EN_SPK_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_EN_SPK_DEFAULT	\
	(AW87XXX_PID_76_EN_SPK_DEFAULT_VALUE << AW87XXX_PID_76_EN_SPK_START_BIT)

/* EN_LG bit 1 (MDCTRL 0x02) */
#define AW87XXX_PID_76_EN_LG_START_BIT	(1)
#define AW87XXX_PID_76_EN_LG_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_LG_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_LG_BITS_LEN)-1) << AW87XXX_PID_76_EN_LG_START_BIT))

#define AW87XXX_PID_76_EN_LG_DISABLE	(0)
#define AW87XXX_PID_76_EN_LG_DISABLE_VALUE	\
	(AW87XXX_PID_76_EN_LG_DISABLE << AW87XXX_PID_76_EN_LG_START_BIT)

#define AW87XXX_PID_76_EN_LG_ENABLE		(1)
#define AW87XXX_PID_76_EN_LG_ENABLE_VALUE	\
	(AW87XXX_PID_76_EN_LG_ENABLE << AW87XXX_PID_76_EN_LG_START_BIT)

#define AW87XXX_PID_76_EN_LG_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_EN_LG_DEFAULT	\
	(AW87XXX_PID_76_EN_LG_DEFAULT_VALUE << AW87XXX_PID_76_EN_LG_START_BIT)

/* EN_AB bit 0 (MDCTRL 0x02) */
#define AW87XXX_PID_76_EN_AB_START_BIT	(0)
#define AW87XXX_PID_76_EN_AB_BITS_LEN	(1)
#define AW87XXX_PID_76_EN_AB_MASK		\
	(~(((1<<AW87XXX_PID_76_EN_AB_BITS_LEN)-1) << AW87XXX_PID_76_EN_AB_START_BIT))

#define AW87XXX_PID_76_EN_AB_DISABLE	(0)
#define AW87XXX_PID_76_EN_AB_DISABLE_VALUE	\
	(AW87XXX_PID_76_EN_AB_DISABLE << AW87XXX_PID_76_EN_AB_START_BIT)

#define AW87XXX_PID_76_EN_AB_ENABLE		(1)
#define AW87XXX_PID_76_EN_AB_ENABLE_VALUE	\
	(AW87XXX_PID_76_EN_AB_ENABLE << AW87XXX_PID_76_EN_AB_START_BIT)

#define AW87XXX_PID_76_EN_AB_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_EN_AB_DEFAULT	\
	(AW87XXX_PID_76_EN_AB_DEFAULT_VALUE << AW87XXX_PID_76_EN_AB_START_BIT)

/* default value of MDCTRL (0x02) */
/* #define AW87XXX_PID_76_MDCTRL_DEFAULT		(0x0C) */

/* CPOVP (0x03) detail */
/* CP_OVP1 bit 3:0 (CPOVP 0x03) */
#define AW87XXX_PID_76_CP_OVP1_START_BIT	(0)
#define AW87XXX_PID_76_CP_OVP1_BITS_LEN	(4)
#define AW87XXX_PID_76_CP_OVP1_MASK		\
	(~(((1<<AW87XXX_PID_76_CP_OVP1_BITS_LEN)-1) << AW87XXX_PID_76_CP_OVP1_START_BIT))

#define AW87XXX_PID_76_CP_OVP1_6P0V		(0)
#define AW87XXX_PID_76_CP_OVP1_6P0V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_6P0V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_6P25V	(1)
#define AW87XXX_PID_76_CP_OVP1_6P25V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_6P25V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_6P5V		(2)
#define AW87XXX_PID_76_CP_OVP1_6P5V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_6P5V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_6P75V	(3)
#define AW87XXX_PID_76_CP_OVP1_6P75V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_6P75V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_7V		(4)
#define AW87XXX_PID_76_CP_OVP1_7V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_7V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_7P25V	(5)
#define AW87XXX_PID_76_CP_OVP1_7P25V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_7P25V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_7P5V		(6)
#define AW87XXX_PID_76_CP_OVP1_7P5V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_7P5V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_7P75V	(7)
#define AW87XXX_PID_76_CP_OVP1_7P75V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_7P75V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_8V		(8)
#define AW87XXX_PID_76_CP_OVP1_8V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_8V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_8P25V	(9)
#define AW87XXX_PID_76_CP_OVP1_8P25V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_8P25V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_8P5V		(10)
#define AW87XXX_PID_76_CP_OVP1_8P5V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_8P5V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_8P75V	(11)
#define AW87XXX_PID_76_CP_OVP1_8P75V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_8P75V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_9V		(12)
#define AW87XXX_PID_76_CP_OVP1_9V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_9V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_9P25V	(13)
#define AW87XXX_PID_76_CP_OVP1_9P25V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_9P25V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_9P5V		(14)
#define AW87XXX_PID_76_CP_OVP1_9P5V_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_9P5V << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_RESERVEDP_IF_SET_TURNS_TO_DEFAULTP	(15)
#define AW87XXX_PID_76_CP_OVP1_RESERVEDP_IF_SET_TURNS_TO_DEFAULTP_VALUE	\
	(AW87XXX_PID_76_CP_OVP1_RESERVEDP_IF_SET_TURNS_TO_DEFAULTP << AW87XXX_PID_76_CP_OVP1_START_BIT)

#define AW87XXX_PID_76_CP_OVP1_DEFAULT_VALUE	(8)
#define AW87XXX_PID_76_CP_OVP1_DEFAULT	\
	(AW87XXX_PID_76_CP_OVP1_DEFAULT_VALUE << AW87XXX_PID_76_CP_OVP1_START_BIT)

/* default value of CPOVP (0x03) */
/* #define AW87XXX_PID_76_CPOVP_DEFAULT		(0x08) */

/* CPP (0x04) detail */
/* CP_PEAK_CUR bit 4:2 (CPP 0x04) */
#define AW87XXX_PID_76_CP_PEAK_CUR_START_BIT	(2)
#define AW87XXX_PID_76_CP_PEAK_CUR_BITS_LEN	(3)
#define AW87XXX_PID_76_CP_PEAK_CUR_MASK	\
	(~(((1<<AW87XXX_PID_76_CP_PEAK_CUR_BITS_LEN)-1) << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT))

#define AW87XXX_PID_76_CP_PEAK_CUR_2A	(0)
#define AW87XXX_PID_76_CP_PEAK_CUR_2A_VALUE	\
	(AW87XXX_PID_76_CP_PEAK_CUR_2A << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

#define AW87XXX_PID_76_CP_PEAK_CUR_2P5A	(1)
#define AW87XXX_PID_76_CP_PEAK_CUR_2P5A_VALUE	\
	(AW87XXX_PID_76_CP_PEAK_CUR_2P5A << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

#define AW87XXX_PID_76_CP_PEAK_CUR_3A	(2)
#define AW87XXX_PID_76_CP_PEAK_CUR_3A_VALUE	\
	(AW87XXX_PID_76_CP_PEAK_CUR_3A << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

#define AW87XXX_PID_76_CP_PEAK_CUR_3P5A	(3)
#define AW87XXX_PID_76_CP_PEAK_CUR_3P5A_VALUE	\
	(AW87XXX_PID_76_CP_PEAK_CUR_3P5A << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

#define AW87XXX_PID_76_CP_PEAK_CUR_4A	(4)
#define AW87XXX_PID_76_CP_PEAK_CUR_4A_VALUE	\
	(AW87XXX_PID_76_CP_PEAK_CUR_4A << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

#define AW87XXX_PID_76_CP_PEAK_CUR_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_CP_PEAK_CUR_DEFAULT	\
	(AW87XXX_PID_76_CP_PEAK_CUR_DEFAULT_VALUE << AW87XXX_PID_76_CP_PEAK_CUR_START_BIT)

/* CP_SOFT_CUR bit 1:0 (CPP 0x04) */
#define AW87XXX_PID_76_CP_SOFT_CUR_START_BIT	(0)
#define AW87XXX_PID_76_CP_SOFT_CUR_BITS_LEN	(2)
#define AW87XXX_PID_76_CP_SOFT_CUR_MASK	\
	(~(((1<<AW87XXX_PID_76_CP_SOFT_CUR_BITS_LEN)-1) << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT))

#define AW87XXX_PID_76_CP_SOFT_CUR_0P2A	(0)
#define AW87XXX_PID_76_CP_SOFT_CUR_0P2A_VALUE	\
	(AW87XXX_PID_76_CP_SOFT_CUR_0P2A << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT)

#define AW87XXX_PID_76_CP_SOFT_CUR_0P3A	(1)
#define AW87XXX_PID_76_CP_SOFT_CUR_0P3A_VALUE	\
	(AW87XXX_PID_76_CP_SOFT_CUR_0P3A << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT)

#define AW87XXX_PID_76_CP_SOFT_CUR_0P4A	(2)
#define AW87XXX_PID_76_CP_SOFT_CUR_0P4A_VALUE	\
	(AW87XXX_PID_76_CP_SOFT_CUR_0P4A << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT)

#define AW87XXX_PID_76_CP_SOFT_CUR_0P5A	(3)
#define AW87XXX_PID_76_CP_SOFT_CUR_0P5A_VALUE	\
	(AW87XXX_PID_76_CP_SOFT_CUR_0P5A << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT)

#define AW87XXX_PID_76_CP_SOFT_CUR_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_CP_SOFT_CUR_DEFAULT	\
	(AW87XXX_PID_76_CP_SOFT_CUR_DEFAULT_VALUE << AW87XXX_PID_76_CP_SOFT_CUR_START_BIT)

/* default value of CPP (0x04) */
/* #define AW87XXX_PID_76_CPP_DEFAULT		(0x05) */

/* PAG (0x05) detail */
/* GAIN bit 4:0 (PAG 0x05) */
#define AW87XXX_PID_76_GAIN_START_BIT	(0)
#define AW87XXX_PID_76_GAIN_BITS_LEN	(5)
#define AW87XXX_PID_76_GAIN_MASK		\
	(~(((1<<AW87XXX_PID_76_GAIN_BITS_LEN)-1) << AW87XXX_PID_76_GAIN_START_BIT))

#define AW87XXX_PID_76_GAIN_0DB			(0)
#define AW87XXX_PID_76_GAIN_0DB_VALUE	\
	(AW87XXX_PID_76_GAIN_0DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_1P5DB		(1)
#define AW87XXX_PID_76_GAIN_1P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_1P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_3DB			(2)
#define AW87XXX_PID_76_GAIN_3DB_VALUE	\
	(AW87XXX_PID_76_GAIN_3DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_4P5DB		(3)
#define AW87XXX_PID_76_GAIN_4P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_4P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_6DB			(4)
#define AW87XXX_PID_76_GAIN_6DB_VALUE	\
	(AW87XXX_PID_76_GAIN_6DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_7P5DB		(5)
#define AW87XXX_PID_76_GAIN_7P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_7P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_9DB			(6)
#define AW87XXX_PID_76_GAIN_9DB_VALUE	\
	(AW87XXX_PID_76_GAIN_9DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_10P5DB		(7)
#define AW87XXX_PID_76_GAIN_10P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_10P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_12DB		(8)
#define AW87XXX_PID_76_GAIN_12DB_VALUE	\
	(AW87XXX_PID_76_GAIN_12DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_13P5DB		(9)
#define AW87XXX_PID_76_GAIN_13P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_13P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_15DB		(10)
#define AW87XXX_PID_76_GAIN_15DB_VALUE	\
	(AW87XXX_PID_76_GAIN_15DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_16P5DB		(11)
#define AW87XXX_PID_76_GAIN_16P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_16P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_18DB		(12)
#define AW87XXX_PID_76_GAIN_18DB_VALUE	\
	(AW87XXX_PID_76_GAIN_18DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_19P5DB		(13)
#define AW87XXX_PID_76_GAIN_19P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_19P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_21DB		(14)
#define AW87XXX_PID_76_GAIN_21DB_VALUE	\
	(AW87XXX_PID_76_GAIN_21DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_22P5DB		(15)
#define AW87XXX_PID_76_GAIN_22P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_22P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_24DB		(16)
#define AW87XXX_PID_76_GAIN_24DB_VALUE	\
	(AW87XXX_PID_76_GAIN_24DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_25P5DB		(17)
#define AW87XXX_PID_76_GAIN_25P5DB_VALUE	\
	(AW87XXX_PID_76_GAIN_25P5DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_27DB		(18)
#define AW87XXX_PID_76_GAIN_27DB_VALUE	\
	(AW87XXX_PID_76_GAIN_27DB << AW87XXX_PID_76_GAIN_START_BIT)

#define AW87XXX_PID_76_GAIN_DEFAULT_VALUE	(12)
#define AW87XXX_PID_76_GAIN_DEFAULT		\
	(AW87XXX_PID_76_GAIN_DEFAULT_VALUE << AW87XXX_PID_76_GAIN_START_BIT)

/* default value of PAG (0x05) */
/* #define AW87XXX_PID_76_PAG_DEFAULT		(0x0C) */

/* AGC3P (0x06) detail */
/* AGC3PO bit 3:0 (AGC3P 0x06) */
#define AW87XXX_PID_76_AGC3PO_START_BIT	(0)
#define AW87XXX_PID_76_AGC3PO_BITS_LEN	(4)
#define AW87XXX_PID_76_AGC3PO_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC3PO_BITS_LEN)-1) << AW87XXX_PID_76_AGC3PO_START_BIT))

#define AW87XXX_PID_76_AGC3PO_0P2W4		(0)
#define AW87XXX_PID_76_AGC3PO_0P2W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_0P2W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_0P4W4		(1)
#define AW87XXX_PID_76_AGC3PO_0P4W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_0P4W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_0P6W4		(2)
#define AW87XXX_PID_76_AGC3PO_0P6W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_0P6W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_0P8W4		(3)
#define AW87XXX_PID_76_AGC3PO_0P8W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_0P8W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_1P0W4		(4)
#define AW87XXX_PID_76_AGC3PO_1P0W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_1P0W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_1P2W4		(5)
#define AW87XXX_PID_76_AGC3PO_1P2W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_1P2W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_1P4W4		(6)
#define AW87XXX_PID_76_AGC3PO_1P4W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_1P4W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_1P6W4		(7)
#define AW87XXX_PID_76_AGC3PO_1P6W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_1P6W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_1P8W4		(8)
#define AW87XXX_PID_76_AGC3PO_1P8W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_1P8W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_2P0W4		(9)
#define AW87XXX_PID_76_AGC3PO_2P0W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_2P0W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_2P2W4		(10)
#define AW87XXX_PID_76_AGC3PO_2P2W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_2P2W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_2P4W4		(11)
#define AW87XXX_PID_76_AGC3PO_2P4W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_2P4W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_2P6W4		(12)
#define AW87XXX_PID_76_AGC3PO_2P6W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_2P6W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_2P8W4		(13)
#define AW87XXX_PID_76_AGC3PO_2P8W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_2P8W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_3P0W4		(14)
#define AW87XXX_PID_76_AGC3PO_3P0W4_VALUE	\
	(AW87XXX_PID_76_AGC3PO_3P0W4 << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_AGC3_OFF	(15)
#define AW87XXX_PID_76_AGC3PO_AGC3_OFF_VALUE	\
	(AW87XXX_PID_76_AGC3PO_AGC3_OFF << AW87XXX_PID_76_AGC3PO_START_BIT)

#define AW87XXX_PID_76_AGC3PO_DEFAULT_VALUE	(7)
#define AW87XXX_PID_76_AGC3PO_DEFAULT	\
	(AW87XXX_PID_76_AGC3PO_DEFAULT_VALUE << AW87XXX_PID_76_AGC3PO_START_BIT)

/* default value of AGC3P (0x06) */
/* #define AW87XXX_PID_76_AGC3P_DEFAULT		(0x07) */

/* AGC3PA (0x07) detail */
/* AGC3RT bit 7:5 (AGC3PA 0x07) */
#define AW87XXX_PID_76_AGC3RT_START_BIT	(5)
#define AW87XXX_PID_76_AGC3RT_BITS_LEN	(3)
#define AW87XXX_PID_76_AGC3RT_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC3RT_BITS_LEN)-1) << AW87XXX_PID_76_AGC3RT_START_BIT))

#define AW87XXX_PID_76_AGC3RT_5P12MSDB	(0)
#define AW87XXX_PID_76_AGC3RT_5P12MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_5P12MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_10P24MSDB	(1)
#define AW87XXX_PID_76_AGC3RT_10P24MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_10P24MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_20P48MSDB	(2)
#define AW87XXX_PID_76_AGC3RT_20P48MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_20P48MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_41MSDB	(3)
#define AW87XXX_PID_76_AGC3RT_41MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_41MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_82MSDB	(4)
#define AW87XXX_PID_76_AGC3RT_82MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_82MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_164MSDB	(5)
#define AW87XXX_PID_76_AGC3RT_164MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_164MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_328MSDB	(6)
#define AW87XXX_PID_76_AGC3RT_328MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_328MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_656MSDB	(7)
#define AW87XXX_PID_76_AGC3RT_656MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3RT_656MSDB << AW87XXX_PID_76_AGC3RT_START_BIT)

#define AW87XXX_PID_76_AGC3RT_DEFAULT_VALUE	(2)
#define AW87XXX_PID_76_AGC3RT_DEFAULT	\
	(AW87XXX_PID_76_AGC3RT_DEFAULT_VALUE << AW87XXX_PID_76_AGC3RT_START_BIT)

/* AGC3AT bit 4:2 (AGC3PA 0x07) */
#define AW87XXX_PID_76_AGC3AT_START_BIT	(2)
#define AW87XXX_PID_76_AGC3AT_BITS_LEN	(3)
#define AW87XXX_PID_76_AGC3AT_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC3AT_BITS_LEN)-1) << AW87XXX_PID_76_AGC3AT_START_BIT))

#define AW87XXX_PID_76_AGC3AT_1P28MSDB	(0)
#define AW87XXX_PID_76_AGC3AT_1P28MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_1P28MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_2P56MSDB	(1)
#define AW87XXX_PID_76_AGC3AT_2P56MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_2P56MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_10P24MSDB	(2)
#define AW87XXX_PID_76_AGC3AT_10P24MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_10P24MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_41MSDB	(3)
#define AW87XXX_PID_76_AGC3AT_41MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_41MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_82MSDB	(4)
#define AW87XXX_PID_76_AGC3AT_82MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_82MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_164MSDB	(5)
#define AW87XXX_PID_76_AGC3AT_164MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_164MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_328MSDB	(6)
#define AW87XXX_PID_76_AGC3AT_328MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_328MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_656MSDB	(7)
#define AW87XXX_PID_76_AGC3AT_656MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3AT_656MSDB << AW87XXX_PID_76_AGC3AT_START_BIT)

#define AW87XXX_PID_76_AGC3AT_DEFAULT_VALUE	(3)
#define AW87XXX_PID_76_AGC3AT_DEFAULT	\
	(AW87XXX_PID_76_AGC3AT_DEFAULT_VALUE << AW87XXX_PID_76_AGC3AT_START_BIT)

/* AGC3FSAT bit 1:0 (AGC3PA 0x07) */
#define AW87XXX_PID_76_AGC3FSAT_START_BIT	(0)
#define AW87XXX_PID_76_AGC3FSAT_BITS_LEN	(2)
#define AW87XXX_PID_76_AGC3FSAT_MASK	\
	(~(((1<<AW87XXX_PID_76_AGC3FSAT_BITS_LEN)-1) << AW87XXX_PID_76_AGC3FSAT_START_BIT))

#define AW87XXX_PID_76_AGC3FSAT_10P24MSDB	(0)
#define AW87XXX_PID_76_AGC3FSAT_10P24MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3FSAT_10P24MSDB << AW87XXX_PID_76_AGC3FSAT_START_BIT)

#define AW87XXX_PID_76_AGC3FSAT_20P48MSDB	(1)
#define AW87XXX_PID_76_AGC3FSAT_20P48MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3FSAT_20P48MSDB << AW87XXX_PID_76_AGC3FSAT_START_BIT)

#define AW87XXX_PID_76_AGC3FSAT_41MSDB	(2)
#define AW87XXX_PID_76_AGC3FSAT_41MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3FSAT_41MSDB << AW87XXX_PID_76_AGC3FSAT_START_BIT)

#define AW87XXX_PID_76_AGC3FSAT_82MSDB	(3)
#define AW87XXX_PID_76_AGC3FSAT_82MSDB_VALUE	\
	(AW87XXX_PID_76_AGC3FSAT_82MSDB << AW87XXX_PID_76_AGC3FSAT_START_BIT)

#define AW87XXX_PID_76_AGC3FSAT_DEFAULT_VALUE	(2)
#define AW87XXX_PID_76_AGC3FSAT_DEFAULT	\
	(AW87XXX_PID_76_AGC3FSAT_DEFAULT_VALUE << AW87XXX_PID_76_AGC3FSAT_START_BIT)

/* default value of AGC3PA (0x07) */
/* #define AW87XXX_PID_76_AGC3PA_DEFAULT		(0x4E) */

/* AGC2P (0x08) detail */
/* AGC2PO bit 3:0 (AGC2P 0x08) */
#define AW87XXX_PID_76_AGC2PO_START_BIT	(0)
#define AW87XXX_PID_76_AGC2PO_BITS_LEN	(4)
#define AW87XXX_PID_76_AGC2PO_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC2PO_BITS_LEN)-1) << AW87XXX_PID_76_AGC2PO_START_BIT))

#define AW87XXX_PID_76_AGC2PO_0P8W4		(0)
#define AW87XXX_PID_76_AGC2PO_0P8W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_0P8W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_1P2W4		(1)
#define AW87XXX_PID_76_AGC2PO_1P2W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_1P2W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_1P6W4		(2)
#define AW87XXX_PID_76_AGC2PO_1P6W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_1P6W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_2P0W4		(3)
#define AW87XXX_PID_76_AGC2PO_2P0W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_2P0W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_2P4W4		(4)
#define AW87XXX_PID_76_AGC2PO_2P4W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_2P4W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_2P8W4		(5)
#define AW87XXX_PID_76_AGC2PO_2P8W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_2P8W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_3P2W4		(6)
#define AW87XXX_PID_76_AGC2PO_3P2W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_3P2W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_3P6W4		(7)
#define AW87XXX_PID_76_AGC2PO_3P6W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_3P6W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_4P0W4		(8)
#define AW87XXX_PID_76_AGC2PO_4P0W4_VALUE	\
	(AW87XXX_PID_76_AGC2PO_4P0W4 << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_AGC2_OFF	(9)
#define AW87XXX_PID_76_AGC2PO_AGC2_OFF_VALUE	\
	(AW87XXX_PID_76_AGC2PO_AGC2_OFF << AW87XXX_PID_76_AGC2PO_START_BIT)

#define AW87XXX_PID_76_AGC2PO_DEFAULT_VALUE	(6)
#define AW87XXX_PID_76_AGC2PO_DEFAULT	\
	(AW87XXX_PID_76_AGC2PO_DEFAULT_VALUE << AW87XXX_PID_76_AGC2PO_START_BIT)

/* default value of AGC2P (0x08) */
/* #define AW87XXX_PID_76_AGC2P_DEFAULT		(0x06) */

/* AGC2PA (0x09) detail */
/* AGC2AT bit 4:2 (AGC2PA 0x09) */
#define AW87XXX_PID_76_AGC2AT_START_BIT	(2)
#define AW87XXX_PID_76_AGC2AT_BITS_LEN	(3)
#define AW87XXX_PID_76_AGC2AT_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC2AT_BITS_LEN)-1) << AW87XXX_PID_76_AGC2AT_START_BIT))

#define AW87XXX_PID_76_AGC2AT_0P16MSDB	(0)
#define AW87XXX_PID_76_AGC2AT_0P16MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_0P16MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_0P32MSDB	(1)
#define AW87XXX_PID_76_AGC2AT_0P32MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_0P32MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_0P64MSDB	(2)
#define AW87XXX_PID_76_AGC2AT_0P64MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_0P64MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_2P56MSDB	(3)
#define AW87XXX_PID_76_AGC2AT_2P56MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_2P56MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_10P24MSDB	(4)
#define AW87XXX_PID_76_AGC2AT_10P24MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_10P24MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_41MSDB	(5)
#define AW87XXX_PID_76_AGC2AT_41MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_41MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_82MSDB	(6)
#define AW87XXX_PID_76_AGC2AT_82MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_82MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_164MSDB	(7)
#define AW87XXX_PID_76_AGC2AT_164MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2AT_164MSDB << AW87XXX_PID_76_AGC2AT_START_BIT)

#define AW87XXX_PID_76_AGC2AT_DEFAULT_VALUE	(2)
#define AW87XXX_PID_76_AGC2AT_DEFAULT	\
	(AW87XXX_PID_76_AGC2AT_DEFAULT_VALUE << AW87XXX_PID_76_AGC2AT_START_BIT)

/* AGC2FSAT bit 1:0 (AGC2PA 0x09) */
#define AW87XXX_PID_76_AGC2FSAT_START_BIT	(0)
#define AW87XXX_PID_76_AGC2FSAT_BITS_LEN	(2)
#define AW87XXX_PID_76_AGC2FSAT_MASK	\
	(~(((1<<AW87XXX_PID_76_AGC2FSAT_BITS_LEN)-1) << AW87XXX_PID_76_AGC2FSAT_START_BIT))

#define AW87XXX_PID_76_AGC2FSAT_0P16MSDB	(0)
#define AW87XXX_PID_76_AGC2FSAT_0P16MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2FSAT_0P16MSDB << AW87XXX_PID_76_AGC2FSAT_START_BIT)

#define AW87XXX_PID_76_AGC2FSAT_0P64MSDB	(1)
#define AW87XXX_PID_76_AGC2FSAT_0P64MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2FSAT_0P64MSDB << AW87XXX_PID_76_AGC2FSAT_START_BIT)

#define AW87XXX_PID_76_AGC2FSAT_2P56MSDB	(2)
#define AW87XXX_PID_76_AGC2FSAT_2P56MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2FSAT_2P56MSDB << AW87XXX_PID_76_AGC2FSAT_START_BIT)

#define AW87XXX_PID_76_AGC2FSAT_10P24MSDB	(3)
#define AW87XXX_PID_76_AGC2FSAT_10P24MSDB_VALUE	\
	(AW87XXX_PID_76_AGC2FSAT_10P24MSDB << AW87XXX_PID_76_AGC2FSAT_START_BIT)

#define AW87XXX_PID_76_AGC2FSAT_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_AGC2FSAT_DEFAULT	\
	(AW87XXX_PID_76_AGC2FSAT_DEFAULT_VALUE << AW87XXX_PID_76_AGC2FSAT_START_BIT)

/* default value of AGC2PA (0x09) */
/* #define AW87XXX_PID_76_AGC2PA_DEFAULT		(0x08) */

/* AGC1PA (0x0A) detail */
/* AGC1THVTH bit 6:3 (AGC1PA 0x0A) */
#define AW87XXX_PID_76_AGC1THVTH_START_BIT	(3)
#define AW87XXX_PID_76_AGC1THVTH_BITS_LEN	(4)
#define AW87XXX_PID_76_AGC1THVTH_MASK	\
	(~(((1<<AW87XXX_PID_76_AGC1THVTH_BITS_LEN)-1) << AW87XXX_PID_76_AGC1THVTH_START_BIT))

#define AW87XXX_PID_76_AGC1THVTH_5V		(0)
#define AW87XXX_PID_76_AGC1THVTH_5V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_5V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_5P2V	(1)
#define AW87XXX_PID_76_AGC1THVTH_5P2V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_5P2V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_5P4V	(2)
#define AW87XXX_PID_76_AGC1THVTH_5P4V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_5P4V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_5P6V	(3)
#define AW87XXX_PID_76_AGC1THVTH_5P6V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_5P6V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_5P8V	(4)
#define AW87XXX_PID_76_AGC1THVTH_5P8V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_5P8V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_6P0V	(5)
#define AW87XXX_PID_76_AGC1THVTH_6P0V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_6P0V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_6P2V	(6)
#define AW87XXX_PID_76_AGC1THVTH_6P2V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_6P2V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_6P4V	(7)
#define AW87XXX_PID_76_AGC1THVTH_6P4V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_6P4V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_6P6V	(8)
#define AW87XXX_PID_76_AGC1THVTH_6P6V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_6P6V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_6P8V	(9)
#define AW87XXX_PID_76_AGC1THVTH_6P8V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_6P8V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_7V		(10)
#define AW87XXX_PID_76_AGC1THVTH_7V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_7V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_7P2V	(11)
#define AW87XXX_PID_76_AGC1THVTH_7P2V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_7P2V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_7P4V	(12)
#define AW87XXX_PID_76_AGC1THVTH_7P4V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_7P4V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_7P6V	(13)
#define AW87XXX_PID_76_AGC1THVTH_7P6V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_7P6V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_7P8V	(14)
#define AW87XXX_PID_76_AGC1THVTH_7P8V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_7P8V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_8V		(15)
#define AW87XXX_PID_76_AGC1THVTH_8V_VALUE	\
	(AW87XXX_PID_76_AGC1THVTH_8V << AW87XXX_PID_76_AGC1THVTH_START_BIT)

#define AW87XXX_PID_76_AGC1THVTH_DEFAULT_VALUE	(9)
#define AW87XXX_PID_76_AGC1THVTH_DEFAULT	\
	(AW87XXX_PID_76_AGC1THVTH_DEFAULT_VALUE << AW87XXX_PID_76_AGC1THVTH_START_BIT)

/* AGC1AT bit 2:1 (AGC1PA 0x0A) */
#define AW87XXX_PID_76_AGC1AT_START_BIT	(1)
#define AW87XXX_PID_76_AGC1AT_BITS_LEN	(2)
#define AW87XXX_PID_76_AGC1AT_MASK		\
	(~(((1<<AW87XXX_PID_76_AGC1AT_BITS_LEN)-1) << AW87XXX_PID_76_AGC1AT_START_BIT))

#define AW87XXX_PID_76_AGC1AT_0P04MSDB	(0)
#define AW87XXX_PID_76_AGC1AT_0P04MSDB_VALUE	\
	(AW87XXX_PID_76_AGC1AT_0P04MSDB << AW87XXX_PID_76_AGC1AT_START_BIT)

#define AW87XXX_PID_76_AGC1AT_0P08MSDB	(1)
#define AW87XXX_PID_76_AGC1AT_0P08MSDB_VALUE	\
	(AW87XXX_PID_76_AGC1AT_0P08MSDB << AW87XXX_PID_76_AGC1AT_START_BIT)

#define AW87XXX_PID_76_AGC1AT_0P16MSDB	(2)
#define AW87XXX_PID_76_AGC1AT_0P16MSDB_VALUE	\
	(AW87XXX_PID_76_AGC1AT_0P16MSDB << AW87XXX_PID_76_AGC1AT_START_BIT)

#define AW87XXX_PID_76_AGC1AT_0P32MSDB	(3)
#define AW87XXX_PID_76_AGC1AT_0P32MSDB_VALUE	\
	(AW87XXX_PID_76_AGC1AT_0P32MSDB << AW87XXX_PID_76_AGC1AT_START_BIT)

#define AW87XXX_PID_76_AGC1AT_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_AGC1AT_DEFAULT	\
	(AW87XXX_PID_76_AGC1AT_DEFAULT_VALUE << AW87XXX_PID_76_AGC1AT_START_BIT)

/* PD_AGC1 bit 0 (AGC1PA 0x0A) */
#define AW87XXX_PID_76_PD_AGC1_START_BIT	(0)
#define AW87XXX_PID_76_PD_AGC1_BITS_LEN	(1)
#define AW87XXX_PID_76_PD_AGC1_MASK		\
	(~(((1<<AW87XXX_PID_76_PD_AGC1_BITS_LEN)-1) << AW87XXX_PID_76_PD_AGC1_START_BIT))

#define AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_UP	(0)
#define AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_UP_VALUE	\
	(AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_UP << AW87XXX_PID_76_PD_AGC1_START_BIT)

#define AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_DOWN	(1)
#define AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_DOWN_VALUE	\
	(AW87XXX_PID_76_PD_AGC1_AGC1_FUNCTION_POWERMINUS_DOWN << AW87XXX_PID_76_PD_AGC1_START_BIT)

#define AW87XXX_PID_76_PD_AGC1_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_PD_AGC1_DEFAULT	\
	(AW87XXX_PID_76_PD_AGC1_DEFAULT_VALUE << AW87XXX_PID_76_PD_AGC1_START_BIT)

/* default value of AGC1PA (0x0A) */
/* #define AW87XXX_PID_76_AGC1PA_DEFAULT		(0x4A) */

/* SYSST (0x59) detail */
/* UVLOS bit 7 (SYSST 0x59) */
#define AW87XXX_PID_76_UVLOS_START_BIT	(7)
#define AW87XXX_PID_76_UVLOS_BITS_LEN	(1)
#define AW87XXX_PID_76_UVLOS_MASK		\
	(~(((1<<AW87XXX_PID_76_UVLOS_BITS_LEN)-1) << AW87XXX_PID_76_UVLOS_START_BIT))

#define AW87XXX_PID_76_UVLOS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_76_UVLOS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_UVLOS_NORMAL_OPERATION << AW87XXX_PID_76_UVLOS_START_BIT)

#define AW87XXX_PID_76_UVLOS_VBAT_UNDER_VOLTAGE	(1)
#define AW87XXX_PID_76_UVLOS_VBAT_UNDER_VOLTAGE_VALUE	\
	(AW87XXX_PID_76_UVLOS_VBAT_UNDER_VOLTAGE << AW87XXX_PID_76_UVLOS_START_BIT)

#define AW87XXX_PID_76_UVLOS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_UVLOS_DEFAULT	\
	(AW87XXX_PID_76_UVLOS_DEFAULT_VALUE << AW87XXX_PID_76_UVLOS_START_BIT)

/* OTNS bit 6 (SYSST 0x59) */
#define AW87XXX_PID_76_OTNS_START_BIT	(6)
#define AW87XXX_PID_76_OTNS_BITS_LEN	(1)
#define AW87XXX_PID_76_OTNS_MASK		\
	(~(((1<<AW87XXX_PID_76_OTNS_BITS_LEN)-1) << AW87XXX_PID_76_OTNS_START_BIT))

#define AW87XXX_PID_76_OTNS_DETECTED	(0)
#define AW87XXX_PID_76_OTNS_DETECTED_VALUE	\
	(AW87XXX_PID_76_OTNS_DETECTED << AW87XXX_PID_76_OTNS_START_BIT)

#define AW87XXX_PID_76_OTNS_NORMAL_OPERATION	(1)
#define AW87XXX_PID_76_OTNS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_OTNS_NORMAL_OPERATION << AW87XXX_PID_76_OTNS_START_BIT)

#define AW87XXX_PID_76_OTNS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_OTNS_DEFAULT		\
	(AW87XXX_PID_76_OTNS_DEFAULT_VALUE << AW87XXX_PID_76_OTNS_START_BIT)

/* OC_FLAGS bit 5 (SYSST 0x59) */
#define AW87XXX_PID_76_OC_FLAGS_START_BIT	(5)
#define AW87XXX_PID_76_OC_FLAGS_BITS_LEN	(1)
#define AW87XXX_PID_76_OC_FLAGS_MASK	\
	(~(((1<<AW87XXX_PID_76_OC_FLAGS_BITS_LEN)-1) << AW87XXX_PID_76_OC_FLAGS_START_BIT))

#define AW87XXX_PID_76_OC_FLAGS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_76_OC_FLAGS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_OC_FLAGS_NORMAL_OPERATION << AW87XXX_PID_76_OC_FLAGS_START_BIT)

#define AW87XXX_PID_76_OC_FLAGS_DETECTED	(1)
#define AW87XXX_PID_76_OC_FLAGS_DETECTED_VALUE	\
	(AW87XXX_PID_76_OC_FLAGS_DETECTED << AW87XXX_PID_76_OC_FLAGS_START_BIT)

#define AW87XXX_PID_76_OC_FLAGS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_OC_FLAGS_DEFAULT	\
	(AW87XXX_PID_76_OC_FLAGS_DEFAULT_VALUE << AW87XXX_PID_76_OC_FLAGS_START_BIT)

/* ADAP_CPS bit 4 (SYSST 0x59) */
#define AW87XXX_PID_76_ADAP_CPS_START_BIT	(4)
#define AW87XXX_PID_76_ADAP_CPS_BITS_LEN	(1)
#define AW87XXX_PID_76_ADAP_CPS_MASK	\
	(~(((1<<AW87XXX_PID_76_ADAP_CPS_BITS_LEN)-1) << AW87XXX_PID_76_ADAP_CPS_START_BIT))

#define AW87XXX_PID_76_ADAP_CPS_1X_MODE	(0)
#define AW87XXX_PID_76_ADAP_CPS_1X_MODE_VALUE	\
	(AW87XXX_PID_76_ADAP_CPS_1X_MODE << AW87XXX_PID_76_ADAP_CPS_START_BIT)

#define AW87XXX_PID_76_ADAP_CPS_2X_MODE	(1)
#define AW87XXX_PID_76_ADAP_CPS_2X_MODE_VALUE	\
	(AW87XXX_PID_76_ADAP_CPS_2X_MODE << AW87XXX_PID_76_ADAP_CPS_START_BIT)

#define AW87XXX_PID_76_ADAP_CPS_DEFAULT_VALUE	(1)
#define AW87XXX_PID_76_ADAP_CPS_DEFAULT	\
	(AW87XXX_PID_76_ADAP_CPS_DEFAULT_VALUE << AW87XXX_PID_76_ADAP_CPS_START_BIT)

/* STARTOKS bit 3 (SYSST 0x59) */
#define AW87XXX_PID_76_STARTOKS_START_BIT	(3)
#define AW87XXX_PID_76_STARTOKS_BITS_LEN	(1)
#define AW87XXX_PID_76_STARTOKS_MASK	\
	(~(((1<<AW87XXX_PID_76_STARTOKS_BITS_LEN)-1) << AW87XXX_PID_76_STARTOKS_START_BIT))

#define AW87XXX_PID_76_STARTOKS_CP_START_FAIL_DECTECTED	(0)
#define AW87XXX_PID_76_STARTOKS_CP_START_FAIL_DECTECTED_VALUE	\
	(AW87XXX_PID_76_STARTOKS_CP_START_FAIL_DECTECTED << AW87XXX_PID_76_STARTOKS_START_BIT)

#define AW87XXX_PID_76_STARTOKS_NORMAL_OPERATION	(1)
#define AW87XXX_PID_76_STARTOKS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_STARTOKS_NORMAL_OPERATION << AW87XXX_PID_76_STARTOKS_START_BIT)

#define AW87XXX_PID_76_STARTOKS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_STARTOKS_DEFAULT	\
	(AW87XXX_PID_76_STARTOKS_DEFAULT_VALUE << AW87XXX_PID_76_STARTOKS_START_BIT)

/* OVP1S bit 2 (SYSST 0x59) */
#define AW87XXX_PID_76_OVP1S_START_BIT	(2)
#define AW87XXX_PID_76_OVP1S_BITS_LEN	(1)
#define AW87XXX_PID_76_OVP1S_MASK		\
	(~(((1<<AW87XXX_PID_76_OVP1S_BITS_LEN)-1) << AW87XXX_PID_76_OVP1S_START_BIT))

#define AW87XXX_PID_76_OVP1S_NORMAL_OPERATION	(0)
#define AW87XXX_PID_76_OVP1S_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_OVP1S_NORMAL_OPERATION << AW87XXX_PID_76_OVP1S_START_BIT)

#define AW87XXX_PID_76_OVP1S_CP_OVP_DETECTED	(1)
#define AW87XXX_PID_76_OVP1S_CP_OVP_DETECTED_VALUE	\
	(AW87XXX_PID_76_OVP1S_CP_OVP_DETECTED << AW87XXX_PID_76_OVP1S_START_BIT)

#define AW87XXX_PID_76_OVP1S_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_OVP1S_DEFAULT	\
	(AW87XXX_PID_76_OVP1S_DEFAULT_VALUE << AW87XXX_PID_76_OVP1S_START_BIT)

/* PORNS bit 1 (SYSST 0x59) */
#define AW87XXX_PID_76_PORNS_START_BIT	(1)
#define AW87XXX_PID_76_PORNS_BITS_LEN	(1)
#define AW87XXX_PID_76_PORNS_MASK		\
	(~(((1<<AW87XXX_PID_76_PORNS_BITS_LEN)-1) << AW87XXX_PID_76_PORNS_START_BIT))

#define AW87XXX_PID_76_PORNS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_PORNS_DEFAULT	\
	(AW87XXX_PID_76_PORNS_DEFAULT_VALUE << AW87XXX_PID_76_PORNS_START_BIT)

/* CP_SHORTS bit 0 (SYSST 0x59) */
#define AW87XXX_PID_76_CP_SHORTS_START_BIT	(0)
#define AW87XXX_PID_76_CP_SHORTS_BITS_LEN	(1)
#define AW87XXX_PID_76_CP_SHORTS_MASK	\
	(~(((1<<AW87XXX_PID_76_CP_SHORTS_BITS_LEN)-1) << AW87XXX_PID_76_CP_SHORTS_START_BIT))

#define AW87XXX_PID_76_CP_SHORTS_NORMAL_OPERATION	(0)
#define AW87XXX_PID_76_CP_SHORTS_NORMAL_OPERATION_VALUE	\
	(AW87XXX_PID_76_CP_SHORTS_NORMAL_OPERATION << AW87XXX_PID_76_CP_SHORTS_START_BIT)

#define AW87XXX_PID_76_CP_SHORTS_CHARGE_PUMP_SHORT_DECTECTED	(1)
#define AW87XXX_PID_76_CP_SHORTS_CHARGE_PUMP_SHORT_DECTECTED_VALUE	\
	(AW87XXX_PID_76_CP_SHORTS_CHARGE_PUMP_SHORT_DECTECTED << AW87XXX_PID_76_CP_SHORTS_START_BIT)

#define AW87XXX_PID_76_CP_SHORTS_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_CP_SHORTS_DEFAULT	\
	(AW87XXX_PID_76_CP_SHORTS_DEFAULT_VALUE << AW87XXX_PID_76_CP_SHORTS_START_BIT)

/* default value of SYSST (0x59) */
/* #define AW87XXX_PID_76_SYSST_DEFAULT		(0xD0) */

/* SYSINT (0x60) detail */
/* UVLOI bit 7 (SYSINT 0x60) */
#define AW87XXX_PID_76_UVLOI_START_BIT	(7)
#define AW87XXX_PID_76_UVLOI_BITS_LEN	(1)
#define AW87XXX_PID_76_UVLOI_MASK		\
	(~(((1<<AW87XXX_PID_76_UVLOI_BITS_LEN)-1) << AW87XXX_PID_76_UVLOI_START_BIT))

#define AW87XXX_PID_76_UVLOI_NOT_CHANGE	(0)
#define AW87XXX_PID_76_UVLOI_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_UVLOI_NOT_CHANGE << AW87XXX_PID_76_UVLOI_START_BIT)

#define AW87XXX_PID_76_UVLOI_DETECTED	(1)
#define AW87XXX_PID_76_UVLOI_DETECTED_VALUE	\
	(AW87XXX_PID_76_UVLOI_DETECTED << AW87XXX_PID_76_UVLOI_START_BIT)

#define AW87XXX_PID_76_UVLOI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_UVLOI_DEFAULT	\
	(AW87XXX_PID_76_UVLOI_DEFAULT_VALUE << AW87XXX_PID_76_UVLOI_START_BIT)

/* OTNI bit 6 (SYSINT 0x60) */
#define AW87XXX_PID_76_OTNI_START_BIT	(6)
#define AW87XXX_PID_76_OTNI_BITS_LEN	(1)
#define AW87XXX_PID_76_OTNI_MASK		\
	(~(((1<<AW87XXX_PID_76_OTNI_BITS_LEN)-1) << AW87XXX_PID_76_OTNI_START_BIT))

#define AW87XXX_PID_76_OTNI_NOT_CHANGE	(0)
#define AW87XXX_PID_76_OTNI_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_OTNI_NOT_CHANGE << AW87XXX_PID_76_OTNI_START_BIT)

#define AW87XXX_PID_76_OTNI_DETECTED	(1)
#define AW87XXX_PID_76_OTNI_DETECTED_VALUE	\
	(AW87XXX_PID_76_OTNI_DETECTED << AW87XXX_PID_76_OTNI_START_BIT)

#define AW87XXX_PID_76_OTNI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_OTNI_DEFAULT		\
	(AW87XXX_PID_76_OTNI_DEFAULT_VALUE << AW87XXX_PID_76_OTNI_START_BIT)

/* OC_FLAGI bit 5 (SYSINT 0x60) */
#define AW87XXX_PID_76_OC_FLAGI_START_BIT	(5)
#define AW87XXX_PID_76_OC_FLAGI_BITS_LEN	(1)
#define AW87XXX_PID_76_OC_FLAGI_MASK	\
	(~(((1<<AW87XXX_PID_76_OC_FLAGI_BITS_LEN)-1) << AW87XXX_PID_76_OC_FLAGI_START_BIT))

#define AW87XXX_PID_76_OC_FLAGI_NOT_CHANGE	(0)
#define AW87XXX_PID_76_OC_FLAGI_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_OC_FLAGI_NOT_CHANGE << AW87XXX_PID_76_OC_FLAGI_START_BIT)

#define AW87XXX_PID_76_OC_FLAGI_DETECTED	(1)
#define AW87XXX_PID_76_OC_FLAGI_DETECTED_VALUE	\
	(AW87XXX_PID_76_OC_FLAGI_DETECTED << AW87XXX_PID_76_OC_FLAGI_START_BIT)

#define AW87XXX_PID_76_OC_FLAGI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_OC_FLAGI_DEFAULT	\
	(AW87XXX_PID_76_OC_FLAGI_DEFAULT_VALUE << AW87XXX_PID_76_OC_FLAGI_START_BIT)

/* ADAP_CPI bit 4 (SYSINT 0x60) */
#define AW87XXX_PID_76_ADAP_CPI_START_BIT	(4)
#define AW87XXX_PID_76_ADAP_CPI_BITS_LEN	(1)
#define AW87XXX_PID_76_ADAP_CPI_MASK	\
	(~(((1<<AW87XXX_PID_76_ADAP_CPI_BITS_LEN)-1) << AW87XXX_PID_76_ADAP_CPI_START_BIT))

#define AW87XXX_PID_76_ADAP_CPI_1X_MODE	(0)
#define AW87XXX_PID_76_ADAP_CPI_1X_MODE_VALUE	\
	(AW87XXX_PID_76_ADAP_CPI_1X_MODE << AW87XXX_PID_76_ADAP_CPI_START_BIT)

#define AW87XXX_PID_76_ADAP_CPI_2X_MODE	(1)
#define AW87XXX_PID_76_ADAP_CPI_2X_MODE_VALUE	\
	(AW87XXX_PID_76_ADAP_CPI_2X_MODE << AW87XXX_PID_76_ADAP_CPI_START_BIT)

#define AW87XXX_PID_76_ADAP_CPI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_ADAP_CPI_DEFAULT	\
	(AW87XXX_PID_76_ADAP_CPI_DEFAULT_VALUE << AW87XXX_PID_76_ADAP_CPI_START_BIT)

/* STARTOKI bit 3 (SYSINT 0x60) */
#define AW87XXX_PID_76_STARTOKI_START_BIT	(3)
#define AW87XXX_PID_76_STARTOKI_BITS_LEN	(1)
#define AW87XXX_PID_76_STARTOKI_MASK	\
	(~(((1<<AW87XXX_PID_76_STARTOKI_BITS_LEN)-1) << AW87XXX_PID_76_STARTOKI_START_BIT))

#define AW87XXX_PID_76_STARTOKI_NOT_CHANGE	(0)
#define AW87XXX_PID_76_STARTOKI_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_STARTOKI_NOT_CHANGE << AW87XXX_PID_76_STARTOKI_START_BIT)

#define AW87XXX_PID_76_STARTOKI_DECTECTED	(1)
#define AW87XXX_PID_76_STARTOKI_DECTECTED_VALUE	\
	(AW87XXX_PID_76_STARTOKI_DECTECTED << AW87XXX_PID_76_STARTOKI_START_BIT)

#define AW87XXX_PID_76_STARTOKI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_STARTOKI_DEFAULT	\
	(AW87XXX_PID_76_STARTOKI_DEFAULT_VALUE << AW87XXX_PID_76_STARTOKI_START_BIT)

/* OVP1I bit 2 (SYSINT 0x60) */
#define AW87XXX_PID_76_OVP1I_START_BIT	(2)
#define AW87XXX_PID_76_OVP1I_BITS_LEN	(1)
#define AW87XXX_PID_76_OVP1I_MASK		\
	(~(((1<<AW87XXX_PID_76_OVP1I_BITS_LEN)-1) << AW87XXX_PID_76_OVP1I_START_BIT))

#define AW87XXX_PID_76_OVP1I_NOT_CHANGE	(0)
#define AW87XXX_PID_76_OVP1I_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_OVP1I_NOT_CHANGE << AW87XXX_PID_76_OVP1I_START_BIT)

#define AW87XXX_PID_76_OVP1I_DETECTED	(1)
#define AW87XXX_PID_76_OVP1I_DETECTED_VALUE	\
	(AW87XXX_PID_76_OVP1I_DETECTED << AW87XXX_PID_76_OVP1I_START_BIT)

#define AW87XXX_PID_76_OVP1I_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_OVP1I_DEFAULT	\
	(AW87XXX_PID_76_OVP1I_DEFAULT_VALUE << AW87XXX_PID_76_OVP1I_START_BIT)

/* PORNI bit 1 (SYSINT 0x60) */
#define AW87XXX_PID_76_PORNI_START_BIT	(1)
#define AW87XXX_PID_76_PORNI_BITS_LEN	(1)
#define AW87XXX_PID_76_PORNI_MASK		\
	(~(((1<<AW87XXX_PID_76_PORNI_BITS_LEN)-1) << AW87XXX_PID_76_PORNI_START_BIT))

#define AW87XXX_PID_76_PORNI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_PORNI_DEFAULT	\
	(AW87XXX_PID_76_PORNI_DEFAULT_VALUE << AW87XXX_PID_76_PORNI_START_BIT)

/* CP_SHORTI bit 0 (SYSINT 0x60) */
#define AW87XXX_PID_76_CP_SHORTI_START_BIT	(0)
#define AW87XXX_PID_76_CP_SHORTI_BITS_LEN	(1)
#define AW87XXX_PID_76_CP_SHORTI_MASK	\
	(~(((1<<AW87XXX_PID_76_CP_SHORTI_BITS_LEN)-1) << AW87XXX_PID_76_CP_SHORTI_START_BIT))

#define AW87XXX_PID_76_CP_SHORTI_NOT_CHANGE	(0)
#define AW87XXX_PID_76_CP_SHORTI_NOT_CHANGE_VALUE	\
	(AW87XXX_PID_76_CP_SHORTI_NOT_CHANGE << AW87XXX_PID_76_CP_SHORTI_START_BIT)

#define AW87XXX_PID_76_CP_SHORTI_SHORT_DECTECTED	(1)
#define AW87XXX_PID_76_CP_SHORTI_SHORT_DECTECTED_VALUE	\
	(AW87XXX_PID_76_CP_SHORTI_SHORT_DECTECTED << AW87XXX_PID_76_CP_SHORTI_START_BIT)

#define AW87XXX_PID_76_CP_SHORTI_DEFAULT_VALUE	(0)
#define AW87XXX_PID_76_CP_SHORTI_DEFAULT	\
	(AW87XXX_PID_76_CP_SHORTI_DEFAULT_VALUE << AW87XXX_PID_76_CP_SHORTI_START_BIT)

/* default value of SYSINT (0x60) */
/* #define AW87XXX_PID_76_SYSINT_DEFAULT		(0x00) */

/* detail information of registers end */

#endif  /* #ifndef  __AW87XXX_PID_76_REG_H__ */