/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020, The Linux Foundation. All rights reserved.
 */

#ifndef _ROULEUR_REGISTERS_H
#define _ROULEUR_REGISTERS_H

#define ROULEUR_ANA_BASE_ADDR 0x3000
#define ROULEUR_DIG_BASE_ADDR 0x3400

#define ROULEUR_REG(reg)  ((reg > ROULEUR_DIG_BASE_ADDR) ? \
			   (reg - ROULEUR_DIG_BASE_ADDR) : \
			   (reg - ROULEUR_ANA_BASE_ADDR))

enum {
	REG_NO_ACCESS,
	RD_REG,
	WR_REG,
	RD_WR_REG
};

#define ROULEUR_ANA_MICBIAS_MICB_1_2_EN       (ROULEUR_ANA_BASE_ADDR+0x040)
#define ROULEUR_ANA_MICBIAS_MICB_3_EN         (ROULEUR_ANA_BASE_ADDR+0x041)
#define ROULEUR_ANA_MICBIAS_LDO_1_SETTING     (ROULEUR_ANA_BASE_ADDR+0x042)
#define ROULEUR_ANA_MICBIAS_LDO_1_CTRL        (ROULEUR_ANA_BASE_ADDR+0x043)
#define ROULEUR_ANA_TX_AMIC1                  (ROULEUR_ANA_BASE_ADDR+0x047)
#define ROULEUR_ANA_TX_AMIC2                  (ROULEUR_ANA_BASE_ADDR+0x048)
#define ROULEUR_ANA_MBHC_MECH                 (ROULEUR_ANA_BASE_ADDR+0x05A)
#define ROULEUR_ANA_MBHC_ELECT                (ROULEUR_ANA_BASE_ADDR+0x05B)
#define ROULEUR_ANA_MBHC_ZDET                 (ROULEUR_ANA_BASE_ADDR+0x05C)
#define ROULEUR_ANA_MBHC_RESULT_1             (ROULEUR_ANA_BASE_ADDR+0x05D)
#define ROULEUR_ANA_MBHC_RESULT_2             (ROULEUR_ANA_BASE_ADDR+0x05E)
#define ROULEUR_ANA_MBHC_RESULT_3             (ROULEUR_ANA_BASE_ADDR+0x05F)
#define ROULEUR_ANA_MBHC_BTN0_ZDET_VREF1      (ROULEUR_ANA_BASE_ADDR+0x060)
#define ROULEUR_ANA_MBHC_BTN1_ZDET_VREF2      (ROULEUR_ANA_BASE_ADDR+0x061)
#define ROULEUR_ANA_MBHC_BTN2_ZDET_VREF3      (ROULEUR_ANA_BASE_ADDR+0x062)
#define ROULEUR_ANA_MBHC_BTN3_ZDET_DBG_400    (ROULEUR_ANA_BASE_ADDR+0x063)
#define ROULEUR_ANA_MBHC_BTN4_ZDET_DBG_1400   (ROULEUR_ANA_BASE_ADDR+0x064)
#define ROULEUR_ANA_MBHC_MICB2_RAMP           (ROULEUR_ANA_BASE_ADDR+0x065)
#define ROULEUR_ANA_MBHC_CTL_1                (ROULEUR_ANA_BASE_ADDR+0x066)
#define ROULEUR_ANA_MBHC_CTL_2                (ROULEUR_ANA_BASE_ADDR+0x067)
#define ROULEUR_ANA_MBHC_PLUG_DETECT_CTL      (ROULEUR_ANA_BASE_ADDR+0x068)
#define ROULEUR_ANA_MBHC_ZDET_ANA_CTL         (ROULEUR_ANA_BASE_ADDR+0x069)
#define ROULEUR_ANA_MBHC_ZDET_RAMP_CTL        (ROULEUR_ANA_BASE_ADDR+0x06A)
#define ROULEUR_ANA_MBHC_FSM_STATUS           (ROULEUR_ANA_BASE_ADDR+0x06B)
#define ROULEUR_ANA_MBHC_ADC_RESULT           (ROULEUR_ANA_BASE_ADDR+0x06C)
#define ROULEUR_ANA_MBHC_CTL_CLK              (ROULEUR_ANA_BASE_ADDR+0x06D)
#define ROULEUR_ANA_MBHC_ZDET_CALIB_RESULT    (ROULEUR_ANA_BASE_ADDR+0x072)
#define ROULEUR_ANA_NCP_EN                    (ROULEUR_ANA_BASE_ADDR+0x077)
#define ROULEUR_ANA_NCP_VCTRL                 (ROULEUR_ANA_BASE_ADDR+0x07C)
#define ROULEUR_ANA_HPHPA_CNP_CTL_1           (ROULEUR_ANA_BASE_ADDR+0x083)
#define ROULEUR_ANA_HPHPA_CNP_CTL_2           (ROULEUR_ANA_BASE_ADDR+0x084)
#define ROULEUR_ANA_HPHPA_PA_STATUS           (ROULEUR_ANA_BASE_ADDR+0x087)
#define ROULEUR_ANA_HPHPA_FSM_CLK             (ROULEUR_ANA_BASE_ADDR+0x088)
#define ROULEUR_ANA_HPHPA_L_GAIN              (ROULEUR_ANA_BASE_ADDR+0x08B)
#define ROULEUR_ANA_HPHPA_R_GAIN              (ROULEUR_ANA_BASE_ADDR+0x08C)
#define ROULEUR_ANA_HPHPA_SPARE_CTL           (ROULEUR_ANA_BASE_ADDR+0x08E)
#define ROULEUR_SWR_HPHPA_HD2                 (ROULEUR_ANA_BASE_ADDR+0x090)
#define ROULEUR_ANA_SURGE_EN                  (ROULEUR_ANA_BASE_ADDR+0x097)
#define ROULEUR_ANA_COMBOPA_CTL               (ROULEUR_ANA_BASE_ADDR+0x09B)
#define ROULEUR_ANA_COMBOPA_CTL_4             (ROULEUR_ANA_BASE_ADDR+0x09F)
#define ROULEUR_ANA_COMBOPA_CTL_5             (ROULEUR_ANA_BASE_ADDR+0x0A0)
#define ROULEUR_ANA_RXLDO_CTL                 (ROULEUR_ANA_BASE_ADDR+0x0B2)
#define ROULEUR_ANA_MBIAS_EN                  (ROULEUR_ANA_BASE_ADDR+0x0B4)

#define ROULEUR_DIG_SWR_CHIP_ID0              (ROULEUR_DIG_BASE_ADDR+0x001)
#define ROULEUR_DIG_SWR_CHIP_ID1              (ROULEUR_DIG_BASE_ADDR+0x002)
#define ROULEUR_DIG_SWR_CHIP_ID2              (ROULEUR_DIG_BASE_ADDR+0x003)
#define ROULEUR_DIG_SWR_CHIP_ID3              (ROULEUR_DIG_BASE_ADDR+0x004)
#define ROULEUR_DIG_SWR_SWR_TX_CLK_RATE       (ROULEUR_DIG_BASE_ADDR+0x040)
#define ROULEUR_DIG_SWR_CDC_RST_CTL           (ROULEUR_DIG_BASE_ADDR+0x041)
#define ROULEUR_DIG_SWR_TOP_CLK_CFG           (ROULEUR_DIG_BASE_ADDR+0x042)
#define ROULEUR_DIG_SWR_CDC_RX_CLK_CTL        (ROULEUR_DIG_BASE_ADDR+0x043)
#define ROULEUR_DIG_SWR_CDC_TX_CLK_CTL        (ROULEUR_DIG_BASE_ADDR+0x044)
#define ROULEUR_DIG_SWR_SWR_RST_EN            (ROULEUR_DIG_BASE_ADDR+0x045)
#define ROULEUR_DIG_SWR_CDC_RX_RST            (ROULEUR_DIG_BASE_ADDR+0x047)
#define ROULEUR_DIG_SWR_CDC_RX0_CTL           (ROULEUR_DIG_BASE_ADDR+0x048)
#define ROULEUR_DIG_SWR_CDC_RX1_CTL           (ROULEUR_DIG_BASE_ADDR+0x049)
#define ROULEUR_DIG_SWR_CDC_TX_ANA_MODE_0_1   (ROULEUR_DIG_BASE_ADDR+0x04B)
#define ROULEUR_DIG_SWR_CDC_COMP_CTL_0        (ROULEUR_DIG_BASE_ADDR+0x04F)
#define ROULEUR_DIG_SWR_CDC_RX_DELAY_CTL      (ROULEUR_DIG_BASE_ADDR+0x052)
#define ROULEUR_DIG_SWR_CDC_RX_GAIN_0         (ROULEUR_DIG_BASE_ADDR+0x053)
#define ROULEUR_DIG_SWR_CDC_RX_GAIN_1         (ROULEUR_DIG_BASE_ADDR+0x054)
#define ROULEUR_DIG_SWR_CDC_RX_GAIN_CTL       (ROULEUR_DIG_BASE_ADDR+0x057)
#define ROULEUR_DIG_SWR_CDC_TX0_CTL           (ROULEUR_DIG_BASE_ADDR+0x060)
#define ROULEUR_DIG_SWR_CDC_TX1_CTL           (ROULEUR_DIG_BASE_ADDR+0x061)
#define ROULEUR_DIG_SWR_CDC_TX_RST            (ROULEUR_DIG_BASE_ADDR+0x063)
#define ROULEUR_DIG_SWR_CDC_REQ0_CTL          (ROULEUR_DIG_BASE_ADDR+0x064)
#define ROULEUR_DIG_SWR_CDC_REQ1_CTL          (ROULEUR_DIG_BASE_ADDR+0x065)
#define ROULEUR_DIG_SWR_CDC_RST               (ROULEUR_DIG_BASE_ADDR+0x067)
#define ROULEUR_DIG_SWR_CDC_AMIC_CTL          (ROULEUR_DIG_BASE_ADDR+0x06A)
#define ROULEUR_DIG_SWR_CDC_DMIC_CTL          (ROULEUR_DIG_BASE_ADDR+0x06B)
#define ROULEUR_DIG_SWR_CDC_DMIC1_CTL         (ROULEUR_DIG_BASE_ADDR+0x06C)
#define ROULEUR_DIG_SWR_CDC_DMIC1_RATE        (ROULEUR_DIG_BASE_ADDR+0x06D)
#define ROULEUR_DIG_SWR_PDM_WD_CTL0           (ROULEUR_DIG_BASE_ADDR+0x070)
#define ROULEUR_DIG_SWR_PDM_WD_CTL1           (ROULEUR_DIG_BASE_ADDR+0x071)
#define ROULEUR_DIG_SWR_INTR_MODE             (ROULEUR_DIG_BASE_ADDR+0x080)
#define ROULEUR_DIG_SWR_INTR_MASK_0           (ROULEUR_DIG_BASE_ADDR+0x081)
#define ROULEUR_DIG_SWR_INTR_MASK_1           (ROULEUR_DIG_BASE_ADDR+0x082)
#define ROULEUR_DIG_SWR_INTR_MASK_2           (ROULEUR_DIG_BASE_ADDR+0x083)
#define ROULEUR_DIG_SWR_INTR_STATUS_0         (ROULEUR_DIG_BASE_ADDR+0x084)
#define ROULEUR_DIG_SWR_INTR_STATUS_1         (ROULEUR_DIG_BASE_ADDR+0x085)
#define ROULEUR_DIG_SWR_INTR_STATUS_2         (ROULEUR_DIG_BASE_ADDR+0x086)
#define ROULEUR_DIG_SWR_INTR_CLEAR_0          (ROULEUR_DIG_BASE_ADDR+0x087)
#define ROULEUR_DIG_SWR_INTR_CLEAR_1          (ROULEUR_DIG_BASE_ADDR+0x088)
#define ROULEUR_DIG_SWR_INTR_CLEAR_2          (ROULEUR_DIG_BASE_ADDR+0x089)
#define ROULEUR_DIG_SWR_INTR_LEVEL_0          (ROULEUR_DIG_BASE_ADDR+0x08A)
#define ROULEUR_DIG_SWR_INTR_LEVEL_1          (ROULEUR_DIG_BASE_ADDR+0x08B)
#define ROULEUR_DIG_SWR_INTR_LEVEL_2          (ROULEUR_DIG_BASE_ADDR+0x08C)
#define ROULEUR_DIG_SWR_CDC_CONN_RX0_CTL      (ROULEUR_DIG_BASE_ADDR+0x093)
#define ROULEUR_DIG_SWR_CDC_CONN_RX1_CTL      (ROULEUR_DIG_BASE_ADDR+0x094)
#define ROULEUR_DIG_SWR_LOOP_BACK_MODE        (ROULEUR_DIG_BASE_ADDR+0x097)
#define ROULEUR_DIG_SWR_DRIVE_STRENGTH_0      (ROULEUR_DIG_BASE_ADDR+0x0A0)
#define ROULEUR_DIG_SWR_DIG_DEBUG_CTL         (ROULEUR_DIG_BASE_ADDR+0x0AB)
#define ROULEUR_DIG_SWR_DIG_DEBUG_EN          (ROULEUR_DIG_BASE_ADDR+0x0AC)
#define ROULEUR_DIG_SWR_DEM_BYPASS_DATA0      (ROULEUR_DIG_BASE_ADDR+0x0B0)
#define ROULEUR_DIG_SWR_DEM_BYPASS_DATA1      (ROULEUR_DIG_BASE_ADDR+0x0B1)
#define ROULEUR_DIG_SWR_DEM_BYPASS_DATA2      (ROULEUR_DIG_BASE_ADDR+0x0B2)
#define ROULEUR_DIG_SWR_DEM_BYPASS_DATA3      (ROULEUR_DIG_BASE_ADDR+0x0B3)

#define ROULEUR_ANALOG_REGISTERS_MAX_SIZE (ROULEUR_ANA_BASE_ADDR+0x0B5)
#define ROULEUR_DIGITAL_REGISTERS_MAX_SIZE (ROULEUR_DIG_BASE_ADDR+0x0B4)
#define ROULEUR_ANALOG_MAX_REGISTER (ROULEUR_ANALOG_REGISTERS_MAX_SIZE - 1)
#define ROULEUR_DIGITAL_MAX_REGISTER (ROULEUR_DIGITAL_REGISTERS_MAX_SIZE - 1)
#endif
