/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2015, 2018-2020 The Linux Foundation. All rights reserved.
 */

#ifndef _SWR_SLAVE_REGISTERS_H
#define _SWR_SLAVE_REGISTERS_H

#define SWRS_BASE                               0x00

#define SWRS_SCP_INT_STATUS_1                           (SWRS_BASE+0x0040)
#define SWRS_SCP_INT_CLEAR_1                            (SWRS_BASE+0x0040)
#define SWRS_SCP_INT_MASK_1                             (SWRS_BASE+0x0041)
#define SWRS_SCP_INT_STATUS_2                           (SWRS_BASE+0x0042)
#define SWRS_SCP_INT_STATUS_3                           (SWRS_BASE+0x0043)
#define SWRS_SCP_CONTROL                                (SWRS_BASE+0x0044)
#define SWRS_SCP_STATUS                                 (SWRS_BASE+0x0044)
#define SWRS_SCP_CLOCK_STOP_CONTROL                     (SWRS_BASE+0x0045)
#define SWRS_SCP_DEV_NUMBER                             (SWRS_BASE+0x0046)
#define SWRS_SCP_KEEPER_EN                              (SWRS_BASE+0x004A)
#define SWRS_SCP_DEVICE_ID_0                            (SWRS_BASE+0x0050)
#define SWRS_SCP_DEVICE_ID_1                            (SWRS_BASE+0x0051)
#define SWRS_SCP_DEVICE_ID_2                            (SWRS_BASE+0x0052)
#define SWRS_SCP_DEVICE_ID_3                            (SWRS_BASE+0x0053)
#define SWRS_SCP_DEVICE_ID_4                            (SWRS_BASE+0x0054)
#define SWRS_SCP_DEVICE_ID_5                            (SWRS_BASE+0x0055)
#define SWRS_SCP_FRAME_CTRL_BANK(m)                    (SWRS_BASE+0x0060+0x10*m)
#define SWRS_SCP_IMPDEF_SWR_INTERRUPT_DETECT_TYPE      (SWRS_BASE+0x00C8)
#define SWRS_SCP_HOST_CLK_DIV2_CTL_BANK(m)             (SWRS_BASE+0x00E0+0x10*m)
#define SWRS_DP_INT_STATUS(n)                          (SWRS_BASE+0x100+0x0100*n)
#define SWRS_DP_INT_STATUS_MASK(n)                     (SWRS_BASE+0x101+0x100*n)
#define SWRS_DP_PORT_CONTROL(n)                        (SWRS_BASE+0x102+0x100*n)
#define SWRS_DP_BLOCK_CONTROL_1(n)                     (SWRS_BASE+0x103+0x100*n)
#define SWRS_DP_PREPARE_STATUS(n)                      (SWRS_BASE+0x104+0x100*n)
#define SWRS_DP_PREPARE_CONTROL(n)                     (SWRS_BASE+0x105+0x100*n)
#define SWRS_DP_CHANNEL_ENABLE_BANK(n, m)       (SWRS_BASE+0x120+0x100*n+0x10*m)
#define SWRS_DP_BLOCK_CONTROL_2_BANK(n, m)      (SWRS_BASE+0x121+0x100*n+0x10*m)
#define SWRS_DP_SAMPLE_CONTROL_1_BANK(n, m)     (SWRS_BASE+0x122+0x100*n+0x10*m)
#define SWRS_DP_SAMPLE_CONTROL_2_BANK(n, m)     (SWRS_BASE+0x123+0x100*n+0x10*m)
#define SWRS_DP_OFFSET_CONTROL_1_BANK(n, m)     (SWRS_BASE+0x124+0x100*n+0x10*m)
#define SWRS_DP_OFFSET_CONTROL_2_BANK(n, m)     (SWRS_BASE+0x125+0x100*n+0x10*m)
#define SWRS_DP_HCONTROL_BANK(n, m)             (SWRS_BASE+0x126+0x100*n+0x10*m)
#define SWRS_DP_BLOCK_CONTROL_3_BANK(n, m)      (SWRS_BASE+0x127+0x100*n+0x10*m)
#define SWRS_DP_LANE_CONTROL_BANK(n, m)         (SWRS_BASE+0x128+0x100*n+0x10*m)
#define SWRS_DP_ALL_INT_STATUS                  (SWRS_BASE+0x0F00)
#define SWRS_DP_ALL_INT_STATUS_MASK             (SWRS_BASE+0x0F01)
#define SWRS_DP_ALL_PORT_CONTROL                (SWRS_BASE+0x0F02)
#define SWRS_DP_ALL_BLOCK_CONTROL_1             (SWRS_BASE+0x0F03)
#define SWRS_DP_ALL_PREPARE_STATUS              (SWRS_BASE+0x0F04)
#define SWRS_DP_ALL_PREPARE_CONTROL             (SWRS_BASE+0x0F05)
#define SWRS_DP_ALL_CHANNEL_ENABLE_BANK(m)             (SWRS_BASE+0x0F20+0x10*m)
#define SWRS_DP_ALL_BLOCK_CONTROL_2_BANK(m)            (SWRS_BASE+0x0F21+0x10*m)
#define SWRS_DP_ALL_SAMPLE_CONTROL_1_BANK(m)           (SWRS_BASE+0x0F22+0x10*m)
#define SWRS_DP_ALL_SAMPLE_CONTROL_2_BANK(m)           (SWRS_BASE+0x0F23+0x10*m)
#define SWRS_DP_ALL_OFFSET_CONTROL_1_BANK(m)           (SWRS_BASE+0x0F24+0x10*m)
#define SWRS_DP_ALL_OFFSET_CONTROL_2_BANK(m)           (SWRS_BASE+0x0F25+0x10*m)
#define SWRS_DP_ALL_HCONTROL_BANK(m)                   (SWRS_BASE+0x0F26+0x10*m)
#define SWRS_DP_ALL_BLOCK_CONTROL_3_BANK(m)            (SWRS_BASE+0x0F27+0x10*m)
#define SWRS_DP_ALL_LANE_CONTROL_BANK(m)               (SWRS_BASE+0x0F28+0x10*m)
#define SWRS_COMP_HW_VERSION_MAJOR      (SWRS_BASE+0x2000)
#define SWRS_COMP_HW_VERSION_MINOR      (SWRS_BASE+0x2001)
#define SWRS_COMP_HW_VERSION_STEP       (SWRS_BASE+0x2002)
#define SWRS_COMP_STATUS                (SWRS_BASE+0x2003)
#define SWRS_COMP_POWER_CFG             (SWRS_BASE+0x2004)
#define SWRS_COMP_FEATURE_CFG           (SWRS_BASE+0x2005)
#define SWRS_COMP_PARAMS                (SWRS_BASE+0x2006)
#define SWRS_TEST_BUS_CTL               (SWRS_BASE+0x2007)
#define SWRS_TEST_BUS_STATUS_LOW        (SWRS_BASE+0x200A)
#define SWRS_TEST_BUS_STATUS_HIGH       (SWRS_BASE+0x200B)
#define SWRS_LOOPBACK_CTL               (SWRS_BASE+0x2009)

#endif /* _SWR_SLAVE_REGISTERS_H */
