/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2019-2021, The Linux Foundation. All rights reserved.
 */

#ifndef _CPASTOP_V480_CUSTOM_H_
#define _CPASTOP_V480_CUSTOM_H_

#define TEST_IRQ_ENABLE 0

static struct cam_camnoc_irq_sbm cam_cpas_v480_custom_irq_sbm = {
	.sbm_enable = {
		.access_type = CAM_REG_TYPE_READ_WRITE,
		.enable = true,
		.offset = 0x3840, /* SBM_FAULTINEN0_LOW */
		.value = 0x2 | /* SBM_FAULTINEN0_LOW_PORT1_MASK */
			0x4 | /* SBM_FAULTINEN0_LOW_PORT2_MASK */
			0x8 | /* SBM_FAULTINEN0_LOW_PORT3_MASK */
			0x10 | /* SBM_FAULTINEN0_LOW_PORT4_MASK */
			(TEST_IRQ_ENABLE ?
			0x40 : /* SBM_FAULTINEN0_LOW_PORT6_MASK */
			0x0),
	},
	.sbm_status = {
		.access_type = CAM_REG_TYPE_READ,
		.enable = true,
		.offset = 0x3848, /* SBM_FAULTINSTATUS0_LOW */
	},
	.sbm_clear = {
		.access_type = CAM_REG_TYPE_WRITE,
		.enable = true,
		.offset = 0x3880, /* SBM_FLAGOUTCLR0_LOW */
		.value = TEST_IRQ_ENABLE ? 0x5 : 0x1,
	}
};

static struct cam_camnoc_irq_err
	cam_cpas_v480_custom_irq_err[] = {
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_SLAVE_ERROR,
		.enable = false,
		.sbm_port = 0x1, /* SBM_FAULTINSTATUS0_LOW_PORT0_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x7008, /* ERL_MAINCTL_LOW */
			.value = 1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x7010, /* ERL_ERRVLD_LOW */
		},
		.err_clear = {
			.access_type = CAM_REG_TYPE_WRITE,
			.enable = true,
			.offset = 0x7018, /* ERL_ERRCLR_LOW */
			.value = 1,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_IFE_UBWC_STATS_ENCODE_ERROR,
		.enable = true,
		.sbm_port = 0x2, /* SBM_FAULTINSTATUS0_LOW_PORT1_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x1BA0, /* IFE_UBWC_STATS_ENCERREN_LOW */
			.value = 1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x1B90, /* IFE_UBWC_STATS_ENCERRSTATUS_LOW */
		},
		.err_clear = {
			.access_type = CAM_REG_TYPE_WRITE,
			.enable = true,
			.offset = 0x1B98, /* IFE_UBWC_STATS_ENCERRCLR_LOW */
			.value = 1,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_IPE1_BPS_UBWC_DECODE_ERROR,
		.enable = true,
		.sbm_port = 0x4, /* SBM_FAULTINSTATUS0_LOW_PORT2_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x2520, /* IPE1_BPS_RD_DECERREN_LOW */
			.value = 1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x2510, /* IPE1_BPS_RD_DECERRSTATUS_LOW */
		},
		.err_clear = {
			.access_type = CAM_REG_TYPE_WRITE,
			.enable = true,
			.offset = 0x2518, /* IPE1_BPS_RD_DECERRCLR_LOW */
			.value = 1,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_IPE0_UBWC_DECODE_ERROR,
		.enable = true,
		.sbm_port = 0x8, /* SBM_FAULTINSTATUS0_LOW_PORT3_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x1F20, /* IPE0_RD_DECERREN_LOW */
			.value = 1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x1F10, /* IPE0_RD_DECERRSTATUS_LOW */
		},
		.err_clear = {
			.access_type = CAM_REG_TYPE_WRITE,
			.enable = true,
			.offset = 0x1F18, /* IPE0_RD_DECERRCLR_LOW */
			.value = 1,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_IPE_BPS_UBWC_ENCODE_ERROR,
		.enable = true,
		.sbm_port = 0x10, /* SBM_FAULTINSTATUS0_LOW_PORT4_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x29A0, /* IPE_BPS_WR_ENCERREN_LOW */
			.value = 1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x2990,
			/* IPE_BPS_WR_ENCERRSTATUS_LOW */
		},
		.err_clear = {
			.access_type = CAM_REG_TYPE_WRITE,
			.enable = true,
			.offset = 0x2998, /* IPE_BPS_WR_ENCERRCLR_LOW */
			.value = 1,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_AHB_TIMEOUT,
		.enable = false,
		.sbm_port = 0x20, /* SBM_FAULTINSTATUS0_LOW_PORT5_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x3888, /* SBM_FLAGOUTSET0_LOW */
			.value = 0x1,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x3890, /* SBM_FLAGOUTSTATUS0_LOW */
		},
		.err_clear = {
			.enable = false,
		},
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_RESERVED1,
		.enable = false,
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_RESERVED2,
		.enable = false,
	},
	{
		.irq_type = CAM_CAMNOC_HW_IRQ_CAMNOC_TEST,
		.enable = TEST_IRQ_ENABLE ? true : false,
		.sbm_port = 0x40, /* SBM_FAULTINSTATUS0_LOW_PORT6_MASK */
		.err_enable = {
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.enable = true,
			.offset = 0x3888, /* SBM_FLAGOUTSET0_LOW */
			.value = 0x5,
		},
		.err_status = {
			.access_type = CAM_REG_TYPE_READ,
			.enable = true,
			.offset = 0x3890, /* SBM_FLAGOUTSTATUS0_LOW */
		},
		.err_clear = {
			.enable = false,
		},
	},
};

static struct cam_camnoc_specific
	cam_cpas_v480_custom_camnoc_specific[] = {
	{
		.port_type = CAM_CAMNOC_CDM,
		.enable = true,
		.priority_lut_low = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x30, /* CDM_PRIORITYLUT_LOW */
			.value = 0x0,
		},
		.priority_lut_high = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x34, /* CDM_PRIORITYLUT_HIGH */
			.value = 0x0,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x38, /* CDM_URGENCY_LOW */
			.value = 0x3,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x40, /* CDM_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x48, /* CDM_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_FD,
		.enable = true,
		.priority_lut_low = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x630, /* FD_PRIORITYLUT_LOW */
			.value = 0x0,
		},
		.priority_lut_high = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x634, /* FD_PRIORITYLUT_HIGH */
			.value = 0x0,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x638, /* FD_URGENCY_LOW */
			.value = 0x33,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x640, /* FD_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x648, /* FD_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_IFE_LINEAR,
		.enable = true,
		.priority_lut_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0xA30, /* IFE_LINEAR_PRIORITYLUT_LOW */
			.value = 0x66665433,
		},
		.priority_lut_high = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0xA34, /* IFE_LINEAR_PRIORITYLUT_HIGH */
			.value = 0x66666666,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0xA38, /* IFE_LINEAR_URGENCY_LOW */
			.value = 0x1030,
		},
		.danger_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0xA40, /* IFE_LINEAR_DANGERLUT_LOW */
			.value = 0xFFFFFF00,
		},
		.safe_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0xA48, /* IFE_LINEAR_SAFELUT_LOW */
			.value = 0x000F,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_IFE_RDI_RD,
		.enable = true,
		.priority_lut_low = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1030, /* IFE_RDI_RD_PRIORITYLUT_LOW */
			.value = 0x0,
		},
		.priority_lut_high = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1034, /* IFE_RDI_RD_PRIORITYLUT_HIGH */
			.value = 0x0,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1038, /* IFE_RDI_RD_URGENCY_LOW */
			.value = 0x3,
		},
		.danger_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1040, /* IFE_RDI_RD_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1048, /* IFE_RDI_RD_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_IFE_RDI_WR,
		.enable = true,
		.priority_lut_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1430, /* IFE_RDI_WR_PRIORITYLUT_LOW */
			.value = 0x66665433,
		},
		.priority_lut_high = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1434, /* IFE_RDI_WR_PRIORITYLUT_HIGH */
			.value = 0x66666666,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1438, /* IFE_RDI_WR_URGENCY_LOW */
			.value = 0x1070,
		},
		.danger_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1440, /* IFE_RDI_WR_DANGERLUT_LOW */
			.value = 0xFFFFFFF0,
		},
		.safe_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1448, /* IFE_RDI_WR_SAFELUT_LOW */
			.value = 0x1,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_IFE_UBWC_STATS,
		.enable = true,
		.priority_lut_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1A30, /* IFE_UBWC_STATS_PRIORITYLUT_LOW */
			.value = 0x66665433,
		},
		.priority_lut_high = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1A34, /* IFE_UBWC_STATS_PRIORITYLUT_HIGH */
			.value = 0x66666666,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1A38, /* IFE_UBWC_STATS_URGENCY_LOW */
			.value = 0x1030,
		},
		.danger_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1A40, /* IFE_UBWC_STATS_DANGERLUT_LOW */
			.value = 0xFFFFFF00,
		},
		.safe_lut = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.offset = 0x1A48, /* IFE_UBWC_STATS_SAFELUT_LOW */
			.value = 0x000F,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1B88, /* IFE_ENCCTL_LOW */
			.value = 1,
		},
	},
	{
		.port_type = CAM_CAMNOC_IPE0_RD,
		.enable = true,
		.priority_lut_low = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1E30, /* IPE0_RD_PRIORITYLUT_LOW */
			.value = 0x33333333,
		},
		.priority_lut_high = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1E34, /* IPE0_RD_PRIORITYLUT_HIGH */
			.value = 0x33333333,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1E38, /* IPE0_RD_URGENCY_LOW */
			.value = 0x3,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1E40, /* IPE0_RD_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1E48, /* IPE0_RD_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x1F08, /* IPE0_RD_DECCTL_LOW */
			.value = 1,
		},
	},
	{
		.port_type = CAM_CAMNOC_IPE1_BPS_RD,
		.enable = true,
		.priority_lut_low = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2430, /* IPE1_BPS_RD_PRIORITYLUT_LOW */
			.value = 0x33333333,
		},
		.priority_lut_high = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2434, /* IPE1_BPS_RD_PRIORITYLUT_HIGH */
			.value = 0x33333333,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2438, /* IPE1_BPS_RD_URGENCY_LOW */
			.value = 0x3,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2440, /* IPE1_BPS_RD_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2448, /* IPE1_BPS_RD_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2508, /* IPE1_BPS_RD_DECCTL_LOW */
			.value = 1,
		},
	},
	{
		.port_type = CAM_CAMNOC_IPE_BPS_WR,
		.enable = true,
		.priority_lut_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2830, /* IPE_BPS_WR_PRIORITYLUT_LOW */
			.value = 0x33333333,
		},
		.priority_lut_high = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2834, /* IPE_BPS_WR_PRIORITYLUT_HIGH */
			.value = 0x33333333,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2838, /* IPE_BPS_WR_URGENCY_LOW */
			.value = 0x30,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2840, /* IPE_BPS_WR_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2848, /* IPE_BPS_WR_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			/*
			 * Do not explicitly set ubwc config register.
			 * Power on default values are taking care of required
			 * register settings.
			 */
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2988, /* IPE_BPS_WR_ENCCTL_LOW */
			.value = 1,
		},
	},
	{
		.port_type = CAM_CAMNOC_JPEG,
		.enable = true,
		.priority_lut_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2E30, /* JPEG_PRIORITYLUT_LOW */
			.value = 0x22222222,
		},
		.priority_lut_high = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2E34, /* JPEG_PRIORITYLUT_HIGH */
			.value = 0x22222222,
		},
		.urgency = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2E38, /* JPEG_URGENCY_LOW */
			.value = 0x22,
		},
		.danger_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2E40, /* JPEG_DANGERLUT_LOW */
			.value = 0x0,
		},
		.safe_lut = {
			.enable = false,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_READ_WRITE,
			.masked_value = 0,
			.offset = 0x2E48, /* JPEG_SAFELUT_LOW */
			.value = 0x0,
		},
		.ubwc_ctl = {
			.enable = false,
			.is_fuse_based = false,
		},
	},
	{
		.port_type = CAM_CAMNOC_ICP,
		.enable = true,
		.flag_out_set0_low = {
			.enable = true,
			.is_fuse_based = false,
			.access_type = CAM_REG_TYPE_WRITE,
			.masked_value = 0,
			.offset = 0x2088,
			.value = 0x100000,
		},
	},
};

static struct cam_camnoc_err_logger_info cam480_custom_err_logger_offsets = {
	.mainctrl     =  0x7008, /* ERRLOGGER_MAINCTL_LOW */
	.errvld       =  0x7010, /* ERRLOGGER_ERRVLD_LOW */
	.errlog0_low  =  0x7020, /* ERRLOGGER_ERRLOG0_LOW */
	.errlog0_high =  0x7024, /* ERRLOGGER_ERRLOG0_HIGH */
	.errlog1_low  =  0x7028, /* ERRLOGGER_ERRLOG1_LOW */
	.errlog1_high =  0x702c, /* ERRLOGGER_ERRLOG1_HIGH */
	.errlog2_low  =  0x7030, /* ERRLOGGER_ERRLOG2_LOW */
	.errlog2_high =  0x7034, /* ERRLOGGER_ERRLOG2_HIGH */
	.errlog3_low  =  0x7038, /* ERRLOGGER_ERRLOG3_LOW */
	.errlog3_high =  0x703c, /* ERRLOGGER_ERRLOG3_HIGH */
};

static struct cam_cpas_hw_errata_wa_list cam480_custom_errata_wa_list = {
	.camnoc_flush_slave_pending_trans = {
		.enable = false,
		.data.reg_info = {
			.access_type = CAM_REG_TYPE_READ,
			.offset = 0x2100, /* SidebandManager_SenseIn0_Low */
			.mask = 0xE0000, /* Bits 17, 18, 19 */
			.value = 0, /* expected to be 0 */
		},
	},
};

static struct cam_camnoc_info cam480_custom_camnoc_info = {
	.specific = &cam_cpas_v480_custom_camnoc_specific[0],
	.specific_size = ARRAY_SIZE(cam_cpas_v480_custom_camnoc_specific),
	.irq_sbm = &cam_cpas_v480_custom_irq_sbm,
	.irq_err = &cam_cpas_v480_custom_irq_err[0],
	.irq_err_size = ARRAY_SIZE(cam_cpas_v480_custom_irq_err),
	.err_logger = &cam480_custom_err_logger_offsets,
	.errata_wa_list = &cam480_cpas100_errata_wa_list,
};

#endif /* _CPASTOP_V480_CUSTOM_H_ */
