/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2020, The Linux Foundation. All rights reserved.
 */

#ifndef _CAM_TOP_TPG103_H_
#define _CAM_TOP_TPG103_H_

#include "cam_top_tpg_ver3.h"
#include "cam_top_tpg_core.h"

static struct cam_top_tpg_ver3_reg_offset cam_top_tpg103_reg = {
	.tpg_hw_version        = 0x0,
	.tpg_hw_status         = 0x4,
	.tpg_ctrl              = 0x64,
	.tpg_vc0_cfg0          = 0x68,
	.tpg_vc0_lfsr_seed     = 0x6C,
	.tpg_vc0_hbi_cfg       = 0x70,
	.tpg_vc0_vbi_cfg       = 0x74,
	.tpg_vc0_color_bar_cfg = 0x78,
	.tpg_vc0_dt_0_cfg_0   = 0x7C,
	.tpg_vc0_dt_0_cfg_1   = 0x80,
	.tpg_vc0_dt_0_cfg_2   = 0x84,
	.tpg_vc0_dt_1_cfg_0   = 0x88,
	.tpg_vc0_dt_1_cfg_1   = 0x8C,
	.tpg_vc0_dt_1_cfg_2   = 0x90,
	.tpg_vc0_dt_2_cfg_0   = 0x94,
	.tpg_vc0_dt_2_cfg_1   = 0x98,
	.tpg_vc0_dt_2_cfg_2   = 0x9C,
	.tpg_vc0_dt_3_cfg_0   = 0xA0,
	.tpg_vc0_dt_3_cfg_1   = 0xA4,
	.tpg_vc0_dt_3_cfg_2   = 0xA8,

	.tpg_vc1_cfg0          = 0xC8,
	.tpg_vc1_lfsr_seed     = 0xCC,
	.tpg_vc1_hbi_cfg       = 0xD0,
	.tpg_vc1_vbi_cfg       = 0xD4,
	.tpg_vc1_color_bar_cfg = 0xD8,
	.tpg_vc1_dt_0_cfg_0   = 0xDC,
	.tpg_vc1_dt_0_cfg_1   = 0xE0,
	.tpg_vc1_dt_0_cfg_2   = 0xE4,
	.tpg_vc1_dt_1_cfg_0   = 0xE8,
	.tpg_vc1_dt_1_cfg_1   = 0xEC,
	.tpg_vc1_dt_1_cfg_2   = 0xF0,
	.tpg_vc1_dt_2_cfg_0   = 0xF4,
	.tpg_vc1_dt_2_cfg_1   = 0xF8,
	.tpg_vc1_dt_2_cfg_2   = 0xFC,
	.tpg_vc1_dt_3_cfg_0   = 0x100,
	.tpg_vc1_dt_3_cfg_1   = 0x104,
	.tpg_vc1_dt_3_cfg_2   = 0x108,

	.tpg_vc2_cfg0          = 0x128,
	.tpg_vc2_lfsr_seed     = 0x12C,
	.tpg_vc2_hbi_cfg       = 0x130,
	.tpg_vc2_vbi_cfg       = 0x134,
	.tpg_vc2_color_bar_cfg = 0x138,
	.tpg_vc2_dt_0_cfg_0   = 0x13C,
	.tpg_vc2_dt_0_cfg_1   = 0x140,
	.tpg_vc2_dt_0_cfg_2   = 0x144,
	.tpg_vc2_dt_1_cfg_0   = 0x148,
	.tpg_vc2_dt_1_cfg_1   = 0x14C,
	.tpg_vc2_dt_1_cfg_2   = 0x150,
	.tpg_vc2_dt_2_cfg_0   = 0x154,
	.tpg_vc2_dt_2_cfg_1   = 0x158,
	.tpg_vc2_dt_2_cfg_2   = 0x15C,
	.tpg_vc2_dt_3_cfg_0   = 0x160,
	.tpg_vc2_dt_3_cfg_1   = 0x164,
	.tpg_vc2_dt_3_cfg_2   = 0x168,

	.tpg_vc3_cfg0          = 0x188,
	.tpg_vc3_lfsr_seed     = 0x18C,
	.tpg_vc3_hbi_cfg       = 0x190,
	.tpg_vc3_vbi_cfg       = 0x194,
	.tpg_vc3_color_bar_cfg = 0x198,
	.tpg_vc3_dt_0_cfg_0   = 0x19C,
	.tpg_vc3_dt_0_cfg_1   = 0x1A0,
	.tpg_vc3_dt_0_cfg_2   = 0x1A4,
	.tpg_vc3_dt_1_cfg_0   = 0x1A8,
	.tpg_vc3_dt_1_cfg_1   = 0x1AC,
	.tpg_vc3_dt_1_cfg_2   = 0x1B0,
	.tpg_vc3_dt_2_cfg_0   = 0x1B4,
	.tpg_vc3_dt_2_cfg_1   = 0x1B8,
	.tpg_vc3_dt_2_cfg_2   = 0x1BC,
	.tpg_vc3_dt_3_cfg_0   = 0x1C0,
	.tpg_vc3_dt_3_cfg_1   = 0x1C4,
	.tpg_vc3_dt_3_cfg_2   = 0x1C8,
	.tpg_throttle          = 0x1CC,
	.tpg_top_irq_status    = 0x1E0,
	.tpg_top_irq_mask      = 0x1E4,
	.tpg_top_irq_clear     = 0x1E8,
	.tpg_top_irq_set       = 0x1EC,
	.tpg_top_irq_cmd       = 0x1F0,
	.tpg_top_clear         = 0x1F4,
	.tpg_test_bus_crtl     = 0x1F8,
	.tpg_spare             = 0x1FC,

	/* configurations */
	.major_version = 2,
	.minor_version = 0,
	.version_incr = 0,
	.tpg_en_shift_val = 0,
	.tpg_cphy_dphy_sel_shift_val = 3,
	.tpg_num_active_lanes_shift = 4,
	.tpg_fe_pkt_en_shift = 2,
	.tpg_fs_pkt_en_shift = 1,
	.tpg_line_interleaving_mode_shift = 10,
	.tpg_num_dts_shift_val = 8,
	.tpg_v_blank_cnt_shift = 12,
	.tpg_dt_encode_format_shift = 20,
	.tpg_payload_mode_color = 0x8,
	.tpg_split_en_shift = 4,
	.top_mux_reg_offset = 0x1C,
	.tpg_vc_dt_pattern_id_shift = 6,
	.tpg_num_active_vcs_shift = 30,
	.tpg_color_bar_qcfa_en_shift = 3,
};

struct cam_top_tpg_hw_info cam_top_tpg103_hw_info = {
	.tpg_reg = &cam_top_tpg103_reg,
	.hw_dts_version = CAM_TOP_TPG_VERSION_3,
	.csid_max_clk = 480000000,
	.phy_max_clk = 480000000,
};

#endif /* _CAM_TOP_TPG103_H_ */
