/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2019-2020, The Linux Foundation. All rights reserved.
 */


#ifndef _CAM_VFE680_H_
#define _CAM_VFE680_H_
#include "cam_vfe_camif_ver3.h"
#include "cam_vfe_top_ver3.h"
#include "cam_vfe_core.h"
#include "cam_vfe_bus_ver3.h"
#include "cam_irq_controller.h"

static struct cam_irq_register_set vfe680_top_irq_reg_set[3] = {
	{
		.mask_reg_offset   = 0x00000034,
		.clear_reg_offset  = 0x0000003c,
		.status_reg_offset = 0x00000044,
	},
	{
		.mask_reg_offset   = 0x00000038,
		.clear_reg_offset  = 0x00000040,
		.status_reg_offset = 0x00000048,
	},
};

static struct cam_irq_controller_reg_info vfe680_top_irq_reg_info = {
	.num_registers = 2,
	.irq_reg_set = vfe680_top_irq_reg_set,
	.global_clear_offset  = 0x00000030,
	.global_clear_bitmask = 0x00000001,
};

static struct cam_vfe_top_ver3_reg_offset_common vfe680_top_common_reg = {
	.hw_version               = 0x00000000,
	.hw_capability            = 0x00000004,
	.lens_feature             = 0x00000008,
	.stats_feature            = 0x0000000C,
	.color_feature            = 0x00000010,
	.zoom_feature             = 0x00000014,
	.core_cfg_0               = 0x00000024,
	.core_cfg_1               = 0x00000028,
	.core_cfg_2               = 0x0000002C,
	.global_reset_cmd         = 0x00000030,
	.diag_config              = 0x00000050,
	.diag_sensor_status_0     = 0x00000054,
	.diag_sensor_status_1     = 0x00000058,
	.diag_frm_cnt_status_0    = 0x0000005C,
	.diag_frm_cnt_status_1    = 0x00000060,
	.violation_status         = 0x00000064,
	.core_cfg_3               = 0x00000068,
	.core_cgc_ovd_0           = 0x00000018,
	.core_cgc_ovd_1           = 0x0000001C,
	.ahb_cgc_ovd              = 0x00000020,
	.dsp_status               = 0x0000006C,
	.stats_throttle_cfg_0     = 0x00000070,
	.stats_throttle_cfg_1     = 0x00000074,
	.stats_throttle_cfg_2     = 0x00000078,
	.core_cfg_4               = 0x00000080,
	.core_cfg_5               = 0x00000084,
	.core_cfg_6               = 0x00000088,
	.period_cfg               = 0x0000008C,
	.irq_sub_pattern_cfg      = 0x00000090,
	.epoch0_pattern_cfg       = 0x00000094,
	.epoch1_pattern_cfg       = 0x00000098,
	.epoch_height_cfg         = 0x0000009C,
	.bus_overflow_status      = 0x0000AA68,
	.top_debug_cfg            = 0x000000FC,
	.top_debug_0              = 0x000000A0,
	.top_debug_1              = 0x000000A4,
	.top_debug_2              = 0x000000A8,
	.top_debug_3              = 0x000000AC,
	.top_debug_4              = 0x000000B0,
	.top_debug_5              = 0x000000B4,
	.top_debug_6              = 0x000000B8,
	.top_debug_7              = 0x000000BC,
	.top_debug_8              = 0x000000C0,
	.top_debug_9              = 0x000000C4,
	.top_debug_10             = 0x000000C8,
	.top_debug_11             = 0x000000CC,
	.top_debug_12             = 0x000000D0,
	.top_debug_13             = 0x000000D4,
	.top_debug_14             = 0x000000D8,
	.top_debug_15             = 0x000000DC,
	.top_debug_16             = 0x000000E0,
};


static struct cam_vfe_top_ver3_hw_info vfe680_top_hw_info = {
	.common_reg = &vfe480_top_common_reg,
	.camif_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_reg      = &vfe480_camif_reg,
		.reg_data       = &vfe_480_camif_reg_data,
		},
	.pdlib_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_pd,
		.reg_data       = &vfe480_camif_pd_reg_data,
		},
	.rdi_hw_info[0] = &rdi_hw_info_arr[0],
	.rdi_hw_info[1] = &rdi_hw_info_arr[1],
	.rdi_hw_info[2] = &rdi_hw_info_arr[2],
	.lcr_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_lcr,
		.reg_data       = &vfe480_camif_lcr_reg_data,
		},
	.num_mux = 6,
	.mux_type = {
		CAM_VFE_CAMIF_VER_3_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_PDLIB_VER_1_0,
		CAM_VFE_LCR_VER_1_0,
	},
};

static struct cam_irq_register_set vfe680_bus_irq_reg[2] = {
		{
			.mask_reg_offset   = 0x00000C18,
			.clear_reg_offset  = 0x00000C20,
			.status_reg_offset = 0x00000C28,
		},
		{
			.mask_reg_offset   = 0x00000C1C,
			.clear_reg_offset  = 0x00000C24,
			.status_reg_offset = 0x00000C2C,
		},
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe680_ubwc_regs_client_0 = {
	.meta_addr        = 0x00000E40,
	.meta_cfg         = 0x00000E44,
	.mode_cfg         = 0x00000E48,
	.stats_ctrl       = 0x00000E4C,
	.ctrl_2           = 0x00000E50,
	.lossy_thresh0    = 0x00000E54,
	.lossy_thresh1    = 0x00000E58,
	.off_lossy_var    = 0x00000E5C,
	.bw_limit         = 0x00000E1C,
	.ubwc_comp_en_bit = BIT(1),
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe680_ubwc_regs_client_1 = {
	.meta_addr        = 0x00000F40,
	.meta_cfg         = 0x00000F44,
	.mode_cfg         = 0x00000F48,
	.stats_ctrl       = 0x00000F4C,
	.ctrl_2           = 0x00000F50,
	.lossy_thresh0    = 0x00000F54,
	.lossy_thresh1    = 0x00000F58,
	.off_lossy_var    = 0x00000F5C,
	.bw_limit         = 0x00000F1C,
	.ubwc_comp_en_bit = BIT(1),
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe680_ubwc_regs_client_4 = {
	.meta_addr        = 0x00001240,
	.meta_cfg         = 0x00001244,
	.mode_cfg         = 0x00001248,
	.stats_ctrl       = 0x0000124C,
	.ctrl_2           = 0x00001250,
	.lossy_thresh0    = 0x00001254,
	.lossy_thresh1    = 0x00001258,
	.off_lossy_var    = 0x0000125C,
	.bw_limit         = 0x0000121C,
	.ubwc_comp_en_bit = BIT(1),
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe680_ubwc_regs_client_5 = {
	.meta_addr        = 0x00001340,
	.meta_cfg         = 0x00001344,
	.mode_cfg         = 0x00001348,
	.stats_ctrl       = 0x0000134C,
	.ctrl_2           = 0x00001350,
	.lossy_thresh0    = 0x00001354,
	.lossy_thresh1    = 0x00001358,
	.off_lossy_var    = 0x0000135C,
	.bw_limit         = 0x0000131C,
	.ubwc_comp_en_bit = BIT(1),
};

static struct cam_vfe_bus_ver3_hw_info vfe680_bus_hw_info = {
	.common_reg = {
		.hw_version                       = 0x00000C00,
		.cgc_ovd                          = 0x00000C08,
		.if_frameheader_cfg               = {
			0x00000C34,
			0x00000C38,
			0x00000C3C,
			0x00000C40,
			0x00000C44,
			0x00000C48,
		},
		.ubwc_static_ctrl                 = 0x00000C58,
		.pwr_iso_cfg                      = 0x00000C5C,
		.overflow_status_clear            = 0x00000C60,
		.ccif_violation_status            = 0x00000C64,
		.overflow_status                  = 0x00000C68,
		.image_size_violation_status      = 0x00000C70,
		.debug_status_top_cfg             = 0x00000CD4,
		.debug_status_top                 = 0x00000CD8,
		.test_bus_ctrl                    = 0x00000CDC,
		.irq_reg_info = {
			.num_registers            = 2,
			.irq_reg_set              = vfe680_bus_irq_reg,
			.global_clear_offset      = 0x00000C30,
			.global_clear_bitmask     = 0x00000001,
		},
	},
	.num_client = CAM_VFE_BUS_VER3_680_MAX_CLIENTS,
	.bus_client_reg = {
		/* BUS Client 0 FULL Y */
		{
			.cfg                      = 0x00000E00,
			.image_addr               = 0x00000E04,
			.frame_incr               = 0x00000E08,
			.image_cfg_0              = 0x00000E0C,
			.image_cfg_1              = 0x00000E10,
			.image_cfg_2              = 0x00000E14,
			.packer_cfg               = 0x00000E18,
			.frame_header_addr        = 0x00000E20,
			.frame_header_incr        = 0x00000E24,
			.frame_header_cfg         = 0x00000E28,
			.irq_subsample_period     = 0x00000E30,
			.irq_subsample_pattern    = 0x00000E34,
			.framedrop_period         = 0x00000E38,
			.framedrop_pattern        = 0x00000E3C,
			.mmu_prefetch_cfg         = 0x00000E60,
			.mmu_prefetch_max_offset  = 0x00000E64,
			.system_cache_cfg         = 0x00000E68,
			.addr_status_0            = 0x00000E70,
			.addr_status_1            = 0x00000E74,
			.addr_status_2            = 0x00000E78,
			.addr_status_3            = 0x00000E7C,
			.debug_status_cfg         = 0x00000E80,
			.debug_status_0           = 0x00000E84,
			.debug_status_1           = 0x00000E88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = &vfe680_ubwc_regs_client_0,
		},
		/* BUS Client 1 FULL C */
		{
			.cfg                      = 0x00000F00,
			.image_addr               = 0x00000F04,
			.frame_incr               = 0x00000F08,
			.image_cfg_0              = 0x00000F0C,
			.image_cfg_1              = 0x00000F10,
			.image_cfg_2              = 0x00000F14,
			.packer_cfg               = 0x00000F18,
			.frame_header_addr        = 0x00000F20,
			.frame_header_incr        = 0x00000F24,
			.frame_header_cfg         = 0x00000F28,
			.irq_subsample_period     = 0x00000F30,
			.irq_subsample_pattern    = 0x00000F34,
			.framedrop_period         = 0x00000F38,
			.framedrop_pattern        = 0x00000F3C,
			.mmu_prefetch_cfg         = 0x00000F60,
			.mmu_prefetch_max_offset  = 0x00000F64,
			.system_cache_cfg         = 0x00000F68,
			.addr_status_0            = 0x00000F70,
			.addr_status_1            = 0x00000F74,
			.addr_status_2            = 0x00000F78,
			.addr_status_3            = 0x00000F7C,
			.debug_status_cfg         = 0x00000F80,
			.debug_status_0           = 0x00000F84,
			.debug_status_1           = 0x00000F88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = &vfe680_ubwc_regs_client_1,
		},
		/* BUS Client 2 DS4 */
		{
			.cfg                      = 0x00001000,
			.image_addr               = 0x00001004,
			.frame_incr               = 0x00001008,
			.image_cfg_0              = 0x0000100C,
			.image_cfg_1              = 0x00001010,
			.image_cfg_2              = 0x00001014,
			.packer_cfg               = 0x00001018,
			.irq_subsample_period     = 0x00001030,
			.irq_subsample_pattern    = 0x00001034,
			.framedrop_period         = 0x00001038,
			.framedrop_pattern        = 0x0000103C,
			.mmu_prefetch_cfg         = 0x00001060,
			.mmu_prefetch_max_offset  = 0x00001064,
			.system_cache_cfg         = 0x00001068,
			.addr_status_0            = 0x00001070,
			.addr_status_1            = 0x00001074,
			.addr_status_2            = 0x00001078,
			.addr_status_3            = 0x0000107C,
			.debug_status_cfg         = 0x00001080,
			.debug_status_0           = 0x00001084,
			.debug_status_1           = 0x00001088,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 3 DS16 */
		{
			.cfg                      = 0x00001100,
			.image_addr               = 0x00001104,
			.frame_incr               = 0x00001108,
			.image_cfg_0              = 0x0000110C,
			.image_cfg_1              = 0x00001110,
			.image_cfg_2              = 0x00001114,
			.packer_cfg               = 0x00001118,
			.irq_subsample_period     = 0x00001130,
			.irq_subsample_pattern    = 0x00001134,
			.framedrop_period         = 0x00001138,
			.framedrop_pattern        = 0x0000113C,
			.mmu_prefetch_cfg         = 0x00001160,
			.mmu_prefetch_max_offset  = 0x00001164,
			.system_cache_cfg         = 0x00001168,
			.addr_status_0            = 0x00001170,
			.addr_status_1            = 0x00001174,
			.addr_status_2            = 0x00001178,
			.addr_status_3            = 0x0000117C,
			.debug_status_cfg         = 0x00001180,
			.debug_status_0           = 0x00001184,
			.debug_status_1           = 0x00001188,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 4 DISP Y */
		{
			.cfg                      = 0x00001200,
			.image_addr               = 0x00001204,
			.frame_incr               = 0x00001208,
			.image_cfg_0              = 0x0000120C,
			.image_cfg_1              = 0x00001210,
			.image_cfg_2              = 0x00001214,
			.packer_cfg               = 0x00001218,
			.frame_header_addr        = 0x00001220,
			.frame_header_incr        = 0x00001224,
			.frame_header_cfg         = 0x00001228,
			.irq_subsample_period     = 0x00001230,
			.irq_subsample_pattern    = 0x00001234,
			.framedrop_period         = 0x00001238,
			.framedrop_pattern        = 0x0000123C,
			.mmu_prefetch_cfg         = 0x00001260,
			.mmu_prefetch_max_offset  = 0x00001264,
			.system_cache_cfg         = 0x00001268,
			.addr_status_0            = 0x00001270,
			.addr_status_1            = 0x00001274,
			.addr_status_2            = 0x00001278,
			.addr_status_3            = 0x0000127C,
			.debug_status_cfg         = 0x00001280,
			.debug_status_0           = 0x00001284,
			.debug_status_1           = 0x00001288,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = &vfe680_ubwc_regs_client_4,
		},
		/* BUS Client 5 DISP C */
		{
			.cfg                      = 0x00001300,
			.image_addr               = 0x00001304,
			.frame_incr               = 0x00001308,
			.image_cfg_0              = 0x0000130C,
			.image_cfg_1              = 0x00001310,
			.image_cfg_2              = 0x00001314,
			.packer_cfg               = 0x00001318,
			.frame_header_addr        = 0x00001320,
			.frame_header_incr        = 0x00001324,
			.frame_header_cfg         = 0x00001328,
			.irq_subsample_period     = 0x00001330,
			.irq_subsample_pattern    = 0x00001334,
			.framedrop_period         = 0x00001338,
			.framedrop_pattern        = 0x0000133C,
			.mmu_prefetch_cfg         = 0x00001360,
			.mmu_prefetch_max_offset  = 0x00001364,
			.system_cache_cfg         = 0x00001368,
			.addr_status_0            = 0x00001370,
			.addr_status_1            = 0x00001374,
			.addr_status_2            = 0x00001378,
			.addr_status_3            = 0x0000137C,
			.debug_status_cfg         = 0x00001380,
			.debug_status_0           = 0x00001384,
			.debug_status_1           = 0x00001388,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = &vfe680_ubwc_regs_client_5,
		},
		/* BUS Client 6 DISP DS4 */
		{
			.cfg                      = 0x00001400,
			.image_addr               = 0x00001404,
			.frame_incr               = 0x00001408,
			.image_cfg_0              = 0x0000140C,
			.image_cfg_1              = 0x00001410,
			.image_cfg_2              = 0x00001414,
			.packer_cfg               = 0x00001418,
			.irq_subsample_period     = 0x00001430,
			.irq_subsample_pattern    = 0x00001434,
			.framedrop_period         = 0x00001438,
			.framedrop_pattern        = 0x0000143C,
			.mmu_prefetch_cfg         = 0x00001460,
			.mmu_prefetch_max_offset  = 0x00001464,
			.system_cache_cfg         = 0x00001468,
			.addr_status_0            = 0x00001470,
			.addr_status_1            = 0x00001474,
			.addr_status_2            = 0x00001478,
			.addr_status_3            = 0x0000147C,
			.debug_status_cfg         = 0x00001480,
			.debug_status_0           = 0x00001484,
			.debug_status_1           = 0x00001488,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 7 DISP DS16 */
		{
			.cfg                      = 0x00001500,
			.image_addr               = 0x00001504,
			.frame_incr               = 0x00001508,
			.image_cfg_0              = 0x0000150C,
			.image_cfg_1              = 0x00001510,
			.image_cfg_2              = 0x00001514,
			.packer_cfg               = 0x00001518,
			.irq_subsample_period     = 0x00001530,
			.irq_subsample_pattern    = 0x00001534,
			.framedrop_period         = 0x00001538,
			.framedrop_pattern        = 0x0000153C,
			.mmu_prefetch_cfg         = 0x00001560,
			.mmu_prefetch_max_offset  = 0x00001564,
			.system_cache_cfg         = 0x00001568,
			.addr_status_0            = 0x00001570,
			.addr_status_1            = 0x00001574,
			.addr_status_2            = 0x00001578,
			.addr_status_3            = 0x0000157C,
			.debug_status_cfg         = 0x00001580,
			.debug_status_0           = 0x00001584,
			.debug_status_1           = 0x00001588,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 8 FD Y */
		{
			.cfg                      = 0x00001600,
			.image_addr               = 0x00001604,
			.frame_incr               = 0x00001608,
			.image_cfg_0              = 0x0000160C,
			.image_cfg_1              = 0x00001610,
			.image_cfg_2              = 0x00001614,
			.packer_cfg               = 0x00001618,
			.frame_header_addr        = 0x00001620,
			.frame_header_incr        = 0x00001624,
			.frame_header_cfg         = 0x00001628,
			.irq_subsample_period     = 0x00001630,
			.irq_subsample_pattern    = 0x00001634,
			.framedrop_period         = 0x00001638,
			.framedrop_pattern        = 0x0000163C,
			.mmu_prefetch_cfg         = 0x00001660,
			.mmu_prefetch_max_offset  = 0x00001664,
			.system_cache_cfg         = 0x00001668,
			.addr_status_0            = 0x00001670,
			.addr_status_1            = 0x00001674,
			.addr_status_2            = 0x00001678,
			.addr_status_3            = 0x0000167C,
			.debug_status_cfg         = 0x00001680,
			.debug_status_0           = 0x00001684,
			.debug_status_1           = 0x00001688,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_2,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 9 FD C */
		{
			.cfg                      = 0x00001700,
			.image_addr               = 0x00001704,
			.frame_incr               = 0x00001708,
			.image_cfg_0              = 0x0000170C,
			.image_cfg_1              = 0x00001710,
			.image_cfg_2              = 0x00001714,
			.packer_cfg               = 0x00001718,
			.irq_subsample_period     = 0x00001730,
			.irq_subsample_pattern    = 0x00001734,
			.framedrop_period         = 0x00001738,
			.framedrop_pattern        = 0x0000173C,
			.mmu_prefetch_cfg         = 0x00001760,
			.mmu_prefetch_max_offset  = 0x00001764,
			.system_cache_cfg         = 0x00001768,
			.addr_status_0            = 0x00001770,
			.addr_status_1            = 0x00001774,
			.addr_status_2            = 0x00001778,
			.addr_status_3            = 0x0000177C,
			.debug_status_cfg         = 0x00001780,
			.debug_status_0           = 0x00001784,
			.debug_status_1           = 0x00001788,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_2,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 10 PIXEL RAW */
		{
			.cfg                      = 0x00001800,
			.image_addr               = 0x00001804,
			.frame_incr               = 0x00001808,
			.image_cfg_0              = 0x0000180C,
			.image_cfg_1              = 0x00001810,
			.image_cfg_2              = 0x00001814,
			.packer_cfg               = 0x00001818,
			.frame_header_addr        = 0x00001820,
			.frame_header_incr        = 0x00001824,
			.frame_header_cfg         = 0x00001828,
			.irq_subsample_period     = 0x00001830,
			.irq_subsample_pattern    = 0x00001834,
			.framedrop_period         = 0x00001838,
			.framedrop_pattern        = 0x0000183C,
			.mmu_prefetch_cfg         = 0x00001860,
			.mmu_prefetch_max_offset  = 0x00001864,
			.system_cache_cfg         = 0x00001868,
			.addr_status_0            = 0x00001870,
			.addr_status_1            = 0x00001874,
			.addr_status_2            = 0x00001878,
			.addr_status_3            = 0x0000187C,
			.debug_status_cfg         = 0x00001880,
			.debug_status_0           = 0x00001884,
			.debug_status_1           = 0x00001888,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_3,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 11 STATS BE 0 */
		{
			.cfg                      = 0x00001900,
			.image_addr               = 0x00001904,
			.frame_incr               = 0x00001908,
			.image_cfg_0              = 0x0000190C,
			.image_cfg_1              = 0x00001910,
			.image_cfg_2              = 0x00001914,
			.packer_cfg               = 0x00001918,
			.frame_header_addr        = 0x00001920,
			.frame_header_incr        = 0x00001924,
			.frame_header_cfg         = 0x00001928,
			.irq_subsample_period     = 0x00001930,
			.irq_subsample_pattern    = 0x00001934,
			.framedrop_period         = 0x00001938,
			.framedrop_pattern        = 0x0000193C,
			.mmu_prefetch_cfg         = 0x00001960,
			.mmu_prefetch_max_offset  = 0x00001964,
			.system_cache_cfg         = 0x00001968,
			.addr_status_0            = 0x00001970,
			.addr_status_1            = 0x00001974,
			.addr_status_2            = 0x00001978,
			.addr_status_3            = 0x0000197C,
			.debug_status_cfg         = 0x00001980,
			.debug_status_0           = 0x00001984,
			.debug_status_1           = 0x00001988,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_4,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 12 STATS BHIST 0 */
		{
			.cfg                      = 0x00001A00,
			.image_addr               = 0x00001A04,
			.frame_incr               = 0x00001A08,
			.image_cfg_0              = 0x00001A0C,
			.image_cfg_1              = 0x00001A10,
			.image_cfg_2              = 0x00001A14,
			.packer_cfg               = 0x00001A18,
			.frame_header_addr        = 0x00001A20,
			.frame_header_incr        = 0x00001A24,
			.frame_header_cfg         = 0x00001A28,
			.irq_subsample_period     = 0x00001A30,
			.irq_subsample_pattern    = 0x00001A34,
			.framedrop_period         = 0x00001A38,
			.framedrop_pattern        = 0x00001A3C,
			.mmu_prefetch_cfg         = 0x00001A60,
			.mmu_prefetch_max_offset  = 0x00001A64,
			.system_cache_cfg         = 0x00001A68,
			.addr_status_0            = 0x00001A70,
			.addr_status_1            = 0x00001A74,
			.addr_status_2            = 0x00001A78,
			.addr_status_3            = 0x00001A7C,
			.debug_status_cfg         = 0x00001A80,
			.debug_status_0           = 0x00001A84,
			.debug_status_1           = 0x00001A88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_4,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 13 STATS TINTLESS BG */
		{
			.cfg                      = 0x00001B00,
			.image_addr               = 0x00001B04,
			.frame_incr               = 0x00001B08,
			.image_cfg_0              = 0x00001B0C,
			.image_cfg_1              = 0x00001B10,
			.image_cfg_2              = 0x00001B14,
			.packer_cfg               = 0x00001B18,
			.frame_header_addr        = 0x00001B20,
			.frame_header_incr        = 0x00001B24,
			.frame_header_cfg         = 0x00001B28,
			.irq_subsample_period     = 0x00001B30,
			.irq_subsample_pattern    = 0x00001B34,
			.framedrop_period         = 0x00001B38,
			.framedrop_pattern        = 0x00001B3C,
			.mmu_prefetch_cfg         = 0x00001B60,
			.mmu_prefetch_max_offset  = 0x00001B64,
			.system_cache_cfg         = 0x00001B68,
			.addr_status_0            = 0x00001B70,
			.addr_status_1            = 0x00001B74,
			.addr_status_2            = 0x00001B78,
			.addr_status_3            = 0x00001B7C,
			.debug_status_cfg         = 0x00001B80,
			.debug_status_0           = 0x00001B84,
			.debug_status_1           = 0x00001B88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_5,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 14 STATS AWB BG */
		{
			.cfg                      = 0x00001C00,
			.image_addr               = 0x00001C04,
			.frame_incr               = 0x00001C08,
			.image_cfg_0              = 0x00001C0C,
			.image_cfg_1              = 0x00001C10,
			.image_cfg_2              = 0x00001C14,
			.packer_cfg               = 0x00001C18,
			.frame_header_addr        = 0x00001C20,
			.frame_header_incr        = 0x00001C24,
			.frame_header_cfg         = 0x00001C28,
			.irq_subsample_period     = 0x00001C30,
			.irq_subsample_pattern    = 0x00001C34,
			.framedrop_period         = 0x00001C38,
			.framedrop_pattern        = 0x00001C3C,
			.mmu_prefetch_cfg         = 0x00001C60,
			.mmu_prefetch_max_offset  = 0x00001C64,
			.system_cache_cfg         = 0x00001C68,
			.addr_status_0            = 0x00001C70,
			.addr_status_1            = 0x00001C74,
			.addr_status_2            = 0x00001C78,
			.addr_status_3            = 0x00001C7C,
			.debug_status_cfg         = 0x00001C80,
			.debug_status_0           = 0x00001C84,
			.debug_status_1           = 0x00001C88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_6,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 15 STATS AWB BFW */
		{
			.cfg                      = 0x00001D00,
			.image_addr               = 0x00001D04,
			.frame_incr               = 0x00001D08,
			.image_cfg_0              = 0x00001D0C,
			.image_cfg_1              = 0x00001D10,
			.image_cfg_2              = 0x00001D14,
			.packer_cfg               = 0x00001D18,
			.frame_header_addr        = 0x00001D20,
			.frame_header_incr        = 0x00001D24,
			.frame_header_cfg         = 0x00001D28,
			.irq_subsample_period     = 0x00001D30,
			.irq_subsample_pattern    = 0x00001D34,
			.framedrop_period         = 0x00001D38,
			.framedrop_pattern        = 0x00001D3C,
			.mmu_prefetch_cfg         = 0x00001D60,
			.mmu_prefetch_max_offset  = 0x00001D64,
			.system_cache_cfg         = 0x00001D68,
			.addr_status_0            = 0x00001D70,
			.addr_status_1            = 0x00001D74,
			.addr_status_2            = 0x00001D78,
			.addr_status_3            = 0x00001D7C,
			.debug_status_cfg         = 0x00001D80,
			.debug_status_0           = 0x00001D84,
			.debug_status_1           = 0x00001D88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_6,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 16 STATS BAF */
		{
			.cfg                      = 0x00001E00,
			.image_addr               = 0x00001E04,
			.frame_incr               = 0x00001E08,
			.image_cfg_0              = 0x00001E0C,
			.image_cfg_1              = 0x00001E10,
			.image_cfg_2              = 0x00001E14,
			.packer_cfg               = 0x00001E18,
			.frame_header_addr        = 0x00001E20,
			.frame_header_incr        = 0x00001E24,
			.frame_header_cfg         = 0x00001E28,
			.irq_subsample_period     = 0x00001E30,
			.irq_subsample_pattern    = 0x00001E34,
			.framedrop_period         = 0x00001E38,
			.framedrop_pattern        = 0x00001E3C,
			.mmu_prefetch_cfg         = 0x00001E60,
			.mmu_prefetch_max_offset  = 0x00001E64,
			.system_cache_cfg         = 0x00001E68,
			.addr_status_0            = 0x00001E70,
			.addr_status_1            = 0x00001E74,
			.addr_status_2            = 0x00001E78,
			.addr_status_3            = 0x00001E7C,
			.debug_status_cfg         = 0x00001E80,
			.debug_status_0           = 0x00001E84,
			.debug_status_1           = 0x00001E88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_7,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 17 STATS BHIST */
		{
			.cfg                      = 0x00001F00,
			.image_addr               = 0x00001F04,
			.frame_incr               = 0x00001F08,
			.image_cfg_0              = 0x00001F0C,
			.image_cfg_1              = 0x00001F10,
			.image_cfg_2              = 0x00001F14,
			.packer_cfg               = 0x00001F18,
			.frame_header_addr        = 0x00001F20,
			.frame_header_incr        = 0x00001F24,
			.frame_header_cfg         = 0x00001F28,
			.irq_subsample_period     = 0x00001F30,
			.irq_subsample_pattern    = 0x00001F34,
			.framedrop_period         = 0x00001F38,
			.framedrop_pattern        = 0x00001F3C,
			.mmu_prefetch_cfg         = 0x00001F60,
			.mmu_prefetch_max_offset  = 0x00001F64,
			.system_cache_cfg         = 0x00001F68,
			.addr_status_0            = 0x00001F70,
			.addr_status_1            = 0x00001F74,
			.addr_status_2            = 0x00001F78,
			.addr_status_3            = 0x00001F7C,
			.debug_status_cfg         = 0x00001F80,
			.debug_status_0           = 0x00001F84,
			.debug_status_1           = 0x00001F88,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_8,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 18 STATS RS */
		{
			.cfg                      = 0x00002000,
			.image_addr               = 0x00002004,
			.frame_incr               = 0x00002008,
			.image_cfg_0              = 0x0000200C,
			.image_cfg_1              = 0x00002010,
			.image_cfg_2              = 0x00002014,
			.packer_cfg               = 0x00002018,
			.frame_header_addr        = 0x00002020,
			.frame_header_incr        = 0x00002024,
			.frame_header_cfg         = 0x00002028,
			.irq_subsample_period     = 0x00002030,
			.irq_subsample_pattern    = 0x00002034,
			.framedrop_period         = 0x00002038,
			.framedrop_pattern        = 0x0000203C,
			.mmu_prefetch_cfg         = 0x00002060,
			.mmu_prefetch_max_offset  = 0x00002064,
			.system_cache_cfg         = 0x00002068,
			.addr_status_0            = 0x00002070,
			.addr_status_1            = 0x00002074,
			.addr_status_2            = 0x00002078,
			.addr_status_3            = 0x0000207C,
			.debug_status_cfg         = 0x00002080,
			.debug_status_0           = 0x00002084,
			.debug_status_1           = 0x00002088,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_9,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 19 STATS IHIST */
		{
			.cfg                      = 0x00002100,
			.image_addr               = 0x00002104,
			.frame_incr               = 0x00002108,
			.image_cfg_0              = 0x0000210C,
			.image_cfg_1              = 0x00002110,
			.image_cfg_2              = 0x00002114,
			.packer_cfg               = 0x00002118,
			.frame_header_addr        = 0x00002120,
			.frame_header_incr        = 0x00002124,
			.frame_header_cfg         = 0x00002128,
			.irq_subsample_period     = 0x00002130,
			.irq_subsample_pattern    = 0x00002134,
			.framedrop_period         = 0x00002138,
			.framedrop_pattern        = 0x0000213C,
			.mmu_prefetch_cfg         = 0x00002160,
			.mmu_prefetch_max_offset  = 0x00002164,
			.system_cache_cfg         = 0x00002168,
			.addr_status_0            = 0x00002170,
			.addr_status_1            = 0x00002174,
			.addr_status_2            = 0x00002178,
			.addr_status_3            = 0x0000217C,
			.debug_status_cfg         = 0x00002180,
			.debug_status_0           = 0x00002184,
			.debug_status_1           = 0x00002188,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_10,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 20 CAMIF PD - PDAF */
		{
			.cfg                      = 0x00002200,
			.image_addr               = 0x00002204,
			.frame_incr               = 0x00002208,
			.image_cfg_0              = 0x0000220C,
			.image_cfg_1              = 0x00002210,
			.image_cfg_2              = 0x00002214,
			.packer_cfg               = 0x00002218,
			.frame_header_addr        = 0x00002220,
			.frame_header_incr        = 0x00002224,
			.frame_header_cfg         = 0x00002228,
			.irq_subsample_period     = 0x00002230,
			.irq_subsample_pattern    = 0x00002234,
			.framedrop_period         = 0x00002238,
			.framedrop_pattern        = 0x0000223C,
			.mmu_prefetch_cfg         = 0x00002260,
			.mmu_prefetch_max_offset  = 0x00002264,
			.system_cache_cfg         = 0x00002268,
			.addr_status_0            = 0x00002270,
			.addr_status_1            = 0x00002274,
			.addr_status_2            = 0x00002278,
			.addr_status_3            = 0x0000227C,
			.debug_status_cfg         = 0x00002280,
			.debug_status_0           = 0x00002284,
			.debug_status_1           = 0x00002288,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_12,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 21 PDAF V2.0 PD DATA - 2PD */
		{
			.cfg                      = 0x00002300,
			.image_addr               = 0x00002304,
			.frame_incr               = 0x00002308,
			.image_cfg_0              = 0x0000230C,
			.image_cfg_1              = 0x00002310,
			.image_cfg_2              = 0x00002314,
			.packer_cfg               = 0x00002318,
			.frame_header_addr        = 0x00002320,
			.frame_header_incr        = 0x00002324,
			.frame_header_cfg         = 0x00002328,
			.irq_subsample_period     = 0x00002330,
			.irq_subsample_pattern    = 0x00002334,
			.framedrop_period         = 0x00002338,
			.framedrop_pattern        = 0x0000233C,
			.mmu_prefetch_cfg         = 0x00002360,
			.mmu_prefetch_max_offset  = 0x00002364,
			.system_cache_cfg         = 0x00002368,
			.addr_status_0            = 0x00002370,
			.addr_status_1            = 0x00002374,
			.addr_status_2            = 0x00002378,
			.addr_status_3            = 0x0000237C,
			.debug_status_cfg         = 0x00002380,
			.debug_status_0           = 0x00002384,
			.debug_status_1           = 0x00002388,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_13,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 22 PDAF V2.0 SAD STATS */
		{
			.cfg                      = 0x00002400,
			.image_addr               = 0x00002404,
			.frame_incr               = 0x00002408,
			.image_cfg_0              = 0x0000240C,
			.image_cfg_1              = 0x00002410,
			.image_cfg_2              = 0x00002414,
			.packer_cfg               = 0x00002418,
			.frame_header_addr        = 0x00002420,
			.frame_header_incr        = 0x00002424,
			.frame_header_cfg         = 0x00002428,
			.irq_subsample_period     = 0x00002430,
			.irq_subsample_pattern    = 0x00002434,
			.framedrop_period         = 0x00002438,
			.framedrop_pattern        = 0x0000243C,
			.mmu_prefetch_cfg         = 0x00002460,
			.mmu_prefetch_max_offset  = 0x00002464,
			.system_cache_cfg         = 0x00002468,
			.addr_status_0            = 0x00002470,
			.addr_status_1            = 0x00002474,
			.addr_status_2            = 0x00002478,
			.addr_status_3            = 0x0000247C,
			.debug_status_cfg         = 0x00002480,
			.debug_status_0           = 0x00002484,
			.debug_status_1           = 0x00002488,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_13,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 23 LCR */
		{
			.cfg                      = 0x00002500,
			.image_addr               = 0x00002504,
			.frame_incr               = 0x00002508,
			.image_cfg_0              = 0x0000250C,
			.image_cfg_1              = 0x00002510,
			.image_cfg_2              = 0x00002514,
			.packer_cfg               = 0x00002518,
			.frame_header_addr        = 0x00002520,
			.frame_header_incr        = 0x00002524,
			.frame_header_cfg         = 0x00002528,
			.irq_subsample_period     = 0x00002530,
			.irq_subsample_pattern    = 0x00002534,
			.framedrop_period         = 0x00002538,
			.framedrop_pattern        = 0x0000253C,
			.mmu_prefetch_cfg         = 0x00002560,
			.mmu_prefetch_max_offset  = 0x00002564,
			.system_cache_cfg         = 0x00002568,
			.addr_status_0            = 0x00002570,
			.addr_status_1            = 0x00002574,
			.addr_status_2            = 0x00002578,
			.addr_status_3            = 0x0000257C,
			.debug_status_cfg         = 0x00002580,
			.debug_status_0           = 0x00002584,
			.debug_status_1           = 0x00002588,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_11,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 24 RDI0 */
		{
			.cfg                      = 0x00002600,
			.image_addr               = 0x00002604,
			.frame_incr               = 0x00002608,
			.image_cfg_0              = 0x0000260C,
			.image_cfg_1              = 0x00002610,
			.image_cfg_2              = 0x00002614,
			.packer_cfg               = 0x00002618,
			.frame_header_addr        = 0x00002620,
			.frame_header_incr        = 0x00002624,
			.frame_header_cfg         = 0x00002628,
			.irq_subsample_period     = 0x00002630,
			.irq_subsample_pattern    = 0x00002634,
			.framedrop_period         = 0x00002638,
			.framedrop_pattern        = 0x0000263C,
			.mmu_prefetch_cfg         = 0x00002660,
			.mmu_prefetch_max_offset  = 0x00002664,
			.system_cache_cfg         = 0x00002668,
			.addr_status_0            = 0x00002670,
			.addr_status_1            = 0x00002674,
			.addr_status_2            = 0x00002678,
			.addr_status_3            = 0x0000267C,
			.debug_status_cfg         = 0x00002680,
			.debug_status_0           = 0x00002684,
			.debug_status_1           = 0x00002688,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_14,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 25 RDI1 */
		{
			.cfg                      = 0x00002700,
			.image_addr               = 0x00002704,
			.frame_incr               = 0x00002708,
			.image_cfg_0              = 0x0000270C,
			.image_cfg_1              = 0x00002710,
			.image_cfg_2              = 0x00002714,
			.packer_cfg               = 0x00002718,
			.frame_header_addr        = 0x00002720,
			.frame_header_incr        = 0x00002724,
			.frame_header_cfg         = 0x00002728,
			.irq_subsample_period     = 0x00002730,
			.irq_subsample_pattern    = 0x00002734,
			.framedrop_period         = 0x00002738,
			.framedrop_pattern        = 0x0000273C,
			.mmu_prefetch_cfg         = 0x00002760,
			.mmu_prefetch_max_offset  = 0x00002764,
			.system_cache_cfg         = 0x00002768,
			.addr_status_0            = 0x00002770,
			.addr_status_1            = 0x00002774,
			.addr_status_2            = 0x00002778,
			.addr_status_3            = 0x0000277C,
			.debug_status_cfg         = 0x00002780,
			.debug_status_0           = 0x00002784,
			.debug_status_1           = 0x00002788,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_15,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 26 RDI2 */
		{
			.cfg                      = 0x00002800,
			.image_addr               = 0x00002804,
			.frame_incr               = 0x00002808,
			.image_cfg_0              = 0x0000280C,
			.image_cfg_1              = 0x00002810,
			.image_cfg_2              = 0x00002814,
			.packer_cfg               = 0x00002818,
			.frame_header_addr        = 0x00002820,
			.frame_header_incr        = 0x00002824,
			.frame_header_cfg         = 0x00002828,
			.irq_subsample_period     = 0x00002830,
			.irq_subsample_pattern    = 0x00002834,
			.framedrop_period         = 0x00002838,
			.framedrop_pattern        = 0x0000283C,
			.mmu_prefetch_cfg         = 0x00002860,
			.mmu_prefetch_max_offset  = 0x00002864,
			.system_cache_cfg         = 0x00002868,
			.addr_status_0            = 0x00002870,
			.addr_status_1            = 0x00002874,
			.addr_status_2            = 0x00002878,
			.addr_status_3            = 0x0000287C,
			.debug_status_cfg         = 0x00002880,
			.debug_status_0           = 0x00002884,
			.debug_status_1           = 0x00002888,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_16,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 27 LTM STATS */
		{
			.cfg                      = 0x00002900,
			.image_addr               = 0x00002904,
			.frame_incr               = 0x00002908,
			.image_cfg_0              = 0x0000290C,
			.image_cfg_1              = 0x00002910,
			.image_cfg_2              = 0x00002914,
			.packer_cfg               = 0x00002918,
			.frame_header_addr        = 0x00002920,
			.frame_header_incr        = 0x00002924,
			.frame_header_cfg         = 0x00002928,
			.irq_subsample_period     = 0x00002930,
			.irq_subsample_pattern    = 0x00002934,
			.framedrop_period         = 0x00002938,
			.framedrop_pattern        = 0x0000293C,
			.mmu_prefetch_cfg         = 0x00002960,
			.mmu_prefetch_max_offset  = 0x00002964,
			.system_cache_cfg         = 0x00002968,
			.addr_status_0            = 0x00002970,
			.addr_status_1            = 0x00002974,
			.addr_status_2            = 0x00002978,
			.addr_status_3            = 0x0000297C,
			.debug_status_cfg         = 0x00002980,
			.debug_status_0           = 0x00002984,
			.debug_status_1           = 0x00002988,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_3,
			.ubwc_regs                = NULL,
		},
	},
	.num_out = 27,
	.vfe_out_hw_info = {
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI0,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_2,
			.num_wm        = 1,
			.wm_idx        = {
				24,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI1,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_3,
			.num_wm        = 1,
			.wm_idx        = {
				25,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI2,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_4,
			.num_wm        = 1,
			.wm_idx        = {
				26,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FULL,
			.max_width     = 4096,
			.max_height    = 4096,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 2,
			.wm_idx        = {
				0,
				1,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS4,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				2,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS16,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				3,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RAW_DUMP,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				10,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FD,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 2,
			.wm_idx        = {
				8,
				9,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_PDAF,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				20,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_HDR_BE,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				11,
			},
		},
		{
			.vfe_out_type  =
				CAM_VFE_BUS_VER3_VFE_OUT_STATS_HDR_BHIST,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				12,
			},
		},
		{
			.vfe_out_type  =
				CAM_VFE_BUS_VER3_VFE_OUT_STATS_TL_BG,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				13,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_BF,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				16,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_AWB_BG,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				14,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_BHIST,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				12,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_RS,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				18,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_IHIST,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				19,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FULL_DISP,
			.max_width     = 4096,
			.max_height    = 4096,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 2,
			.wm_idx        = {
				4,
				5,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS4_DISP,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				6,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS16_DISP,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				7,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_2PD,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_1,
			.num_wm        = 1,
			.wm_idx        = {
				21,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_LCR,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				23,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_AWB_BFW,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				15,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_2PD_STATS,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_1,
			.num_wm        = 1,
			.wm_idx        = {
				22,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_AEC_BE,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				11,
			},
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_LTM_STATS,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				27,
			},
		},
		{
			.vfe_out_type  =
				CAM_VFE_BUS_VER3_VFE_OUT_STATS_GTM_BHIST,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
			.num_wm        = 1,
			.wm_idx        = {
				17,
			},
		},
	},
	.num_comp_grp    = 17,
	.comp_done_shift = 0,
	.top_irq_shift   = 1,
	.max_out_res = CAM_ISP_IFE_OUT_RES_BASE + 33,
};


static struct cam_vfe_hw_info cam_vfe680_hw_info = {
	.irq_reg_info                  = &vfe680_top_irq_reg_info,

	.bus_version                   = CAM_VFE_BUS_VER_3_0,
	.bus_hw_info                   = &vfe680_bus_hw_info,

	.bus_rd_version                = NULL,
	.bus_rd_hw_info                = NULL,

	.top_version                   = CAM_VFE_TOP_VER_4_0,
	.top_hw_info                   = &vfe680_top_hw_info,
};

#endif /* _CAM_VFE680_H_ */
