/*
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8143353
 * @summary Test corner cases of sin and cos
 * @build Tests
 * @build SinCosCornerCasesTests
 * @run main SinCosCornerCasesTests
 * @author Vivek Deshpande
 */
package test.java.lang.Math;

import org.testng.annotations.Test;

public class SinCosCornerCasesTests {

    private SinCosCornerCasesTests() {
    }

    @Test
    public void testCornerCasesSin() {
        double[][] testCases = {
                {0x1.9283586503fep-5, 0x1.9259e3708bd3ap-5, 0x1.9259e3708bd39p-5},
                {-0x1.9283586503fep-5, -0x1.9259e3708bd3ap-5, -0x1.9259e3708bd39p-5},
                {0x1.d7bdcd778049fp-5, 0x1.d77b117f230d6p-5, 0x1.d77b117f230d5p-5},
                {-0x1.d7bdcd778049fp-5, -0x1.d77b117f230d6p-5, -0x1.d77b117f230d5p-5},
                {0x1.a202b3fb84788p-4, 0x1.a1490c8c06ba7p-4, 0x1.a1490c8c06ba6p-4},
                {-0x1.a202b3fb84788p-4, -0x1.a1490c8c06ba7p-4, -0x1.a1490c8c06ba6p-4},
                {0x1.d037cb27ee6dfp-3, 0x1.cc40c3805229ap-3, 0x1.cc40c3805229bp-3},
                {-0x1.d037cb27ee6dfp-3, -0x1.cc40c3805229ap-3, -0x1.cc40c3805229bp-3},
                {0x1.d5064e6fe82c5p-3, 0x1.d0ef799001ba9p-3, 0x1.d0ef799001baap-3},
                {-0x1.d5064e6fe82c5p-3, -0x1.d0ef799001ba9p-3, -0x1.d0ef799001baap-3},
                {0x1.fe767739d0f6dp-2, 0x1.e9950730c4696p-2, 0x1.e9950730c4696p-2},
                {-0x1.fe767739d0f6dp-2, -0x1.e9950730c4696p-2, -0x1.e9950730c4696p-2},
                {0x1.d98c4c612718dp-1, 0x1.98dcd09337793p-1, 0x1.98dcd09337792p-1},
                {-0x1.d98c4c612718dp-1, -0x1.98dcd09337793p-1, -0x1.98dcd09337792p-1},
                {0x1.921fb54442d18p0, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p0, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.0000001f8p500, 0x1.70a9d825b5064p-1, 0x1.70a9d825b5065p-1},
                {0x1.0000001f8p500, -0x1.70a9d825b5064p-1, -0x1.70a9d825b5065p-1},
                {-0x1.00c0bf8p700, 0x1.bf3980c6c1e9fp-1, 0x1.bf3980c6c1eap-1},
                {0x1.00c0bf8p700, -0x1.bf3980c6c1e9fp-1, -0x1.bf3980c6c1eap-1},
                {-0x1.13fffffffff8p6, 0x1.d62899d48b43ap-4, 0x1.d62899d48b439p-4},
                {0x1.13fffffffff8p6, -0x1.d62899d48b43ap-4, -0x1.d62899d48b439p-4},
                {-0x1.17c5920767dfcp-5, -0x1.17b7a60ce1f15p-5, -0x1.17b7a60ce1f14p-5},
                {0x1.17c5920767dfcp-5, 0x1.17b7a60ce1f15p-5, 0x1.17b7a60ce1f14p-5},
                {-0x1.1d99be08713ccp2, 0x1.f0192b794fbbep-1, 0x1.f0192b794fbbfp-1},
                {0x1.1d99be08713ccp2, -0x1.f0192b794fbbep-1, -0x1.f0192b794fbbfp-1},
                {-0x1.1ddbfd64fc0d3p81, -0x1.5e61328c0034fp-3, -0x1.5e61328c0034ep-3},
                {0x1.1ddbfd64fc0d3p81, 0x1.5e61328c0034fp-3, 0x1.5e61328c0034ep-3},
                {-0x1.1e2a1563e068ep7, 0x1.fb028c5df1db4p-1, 0x1.fb028c5df1db3p-1},
                {0x1.1e2a1563e068ep7, -0x1.fb028c5df1db4p-1, -0x1.fb028c5df1db3p-1},
                {-0x1.2e07a91314dp-3, -0x1.2cefb196ba208p-3, -0x1.2cefb196ba207p-3},
                {0x1.2e07a91314dp-3, 0x1.2cefb196ba208p-3, 0x1.2cefb196ba207p-3},
                {-0x1.3bcec270444e2p3, 0x1.b80f489d3edf5p-2, 0x1.b80f489d3edf4p-2},
                {0x1.3bcec270444e2p3, -0x1.b80f489d3edf5p-2, -0x1.b80f489d3edf4p-2},
                {-0x1.500000000004p-20, -0x1.4fffffffffa39p-20, -0x1.4fffffffffa38p-20},
                {0x1.500000000004p-20, 0x1.4fffffffffa39p-20, 0x1.4fffffffffa38p-20},
                {-0x1.559001a42d90cp1, -0x1.d29da5b44f51cp-2, -0x1.d29da5b44f51bp-2},
                {0x1.559001a42d90cp1, 0x1.d29da5b44f51cp-2, 0x1.d29da5b44f51bp-2},
                {-0x1.597bf3e9776b7p99, -0x1.f85f526147f78p-1, -0x1.f85f526147f79p-1},
                {0x1.597bf3e9776b7p99, 0x1.f85f526147f78p-1, 0x1.f85f526147f79p-1},
                {-0x1.6c6cbc45dc8dep7, -0x1.6d61b58c99c43p-59, -0x1.6d61b58c99c42p-59},
                {0x1.6c6cbc45dc8dep7, 0x1.6d61b58c99c43p-59, 0x1.6d61b58c99c42p-59},
                {-0x1.73d8d173f90dp4, 0x1.e5c3c08a258a8p-1, 0x1.e5c3c08a258a7p-1},
                {0x1.73d8d173f90dp4, -0x1.e5c3c08a258a8p-1, -0x1.e5c3c08a258a7p-1},
                {-0x1.8c202d3a31802p6, 0x1.feb36806ca5fbp-1, 0x1.feb36806ca5fcp-1},
                {0x1.8c202d3a31802p6, -0x1.feb36806ca5fbp-1, -0x1.feb36806ca5fcp-1},
                {-0x1.acd538b1a6d5dp-1, -0x1.7c6c7b01b98dap-1, -0x1.7c6c7b01b98d9p-1},
                {0x1.acd538b1a6d5dp-1, 0x1.7c6c7b01b98dap-1, 0x1.7c6c7b01b98d9p-1},
                {-0x1.b7525ac97e0d2p2, -0x1.191be2059dcb6p-1, -0x1.191be2059dcb5p-1},
                {0x1.b7525ac97e0d2p2, 0x1.191be2059dcb6p-1, 0x1.191be2059dcb5p-1},
                {-0x1.bee5fa8a84b02p0, -0x1.f8305993a212cp-1, -0x1.f8305993a212dp-1},
                {0x1.bee5fa8a84b02p0, 0x1.f8305993a212cp-1, 0x1.f8305993a212dp-1},
                {-0x1.c393979fe5921p9, 0x1.ff3b13530fd71p-1, 0x1.ff3b13530fd7p-1},
                {0x1.c393979fe5921p9, -0x1.ff3b13530fd71p-1, -0x1.ff3b13530fd7p-1},
                {-0x1.c48ffc72563c8p18, -0x1.f119da81a4da6p-1, -0x1.f119da81a4da5p-1},
                {0x1.c48ffc72563c8p18, 0x1.f119da81a4da6p-1, 0x1.f119da81a4da5p-1},
                {-0x1.c79548bc31856p3, -0x1.fd73b81e04cccp-1, -0x1.fd73b81e04ccdp-1},
                {0x1.c79548bc31856p3, 0x1.fd73b81e04cccp-1, 0x1.fd73b81e04ccdp-1},
                {-0x1.cb6p-3, -0x1.c7885aef33a95p-3, -0x1.c7885aef33a94p-3},
                {0x1.cb6p-3, 0x1.c7885aef33a95p-3, 0x1.c7885aef33a94p-3},
                {-0x1.e64ddaf7bd72fp-7, -0x1.e6494911eedd1p-7, -0x1.e6494911eeddp-7},
                {0x1.e64ddaf7bd72fp-7, 0x1.e6494911eedd1p-7, 0x1.e6494911eeddp-7},
                {-0x1.ecdd0fbf07942p5, 0x1.e180eef5b1c88p-1, 0x1.e180eef5b1c89p-1},
                {0x1.ecdd0fbf07942p5, -0x1.e180eef5b1c88p-1, -0x1.e180eef5b1c89p-1},
                {-0x1.f073a23292337p2, -0x1.fd98d20c1be44p-1, -0x1.fd98d20c1be43p-1},
                {0x1.f073a23292337p2, 0x1.fd98d20c1be44p-1, 0x1.fd98d20c1be43p-1},
                {-0x1.f5e4c410f4ef8p15, -0x1.7268c112297c8p-5, -0x1.7268c112297c9p-5},
                {0x1.f5e4c410f4ef8p15, 0x1.7268c112297c8p-5, 0x1.7268c112297c9p-5},
                {-0x1.f8000000002p95, 0x1.420796146070ep-18, 0x1.420796146070fp-18},
                {0x1.f8000000002p95, -0x1.420796146070ep-18, -0x1.420796146070fp-18},
                {-0x1.f9365d79546e1p-2, -0x1.e4f6dc499d9ccp-2, -0x1.e4f6dc499d9cdp-2},
                {0x1.f9365d79546e1p-2, 0x1.e4f6dc499d9ccp-2, 0x1.e4f6dc499d9cdp-2},
                {-0x1.ffffffffffe7ep1023, 0x1.b2ef99b140d65p-14, 0x1.b2ef99b140d66p-14},
                {0x1.ffffffffffe7ep1023, -0x1.b2ef99b140d65p-14, -0x1.b2ef99b140d66p-14},
                {0x1.0p15, 0x1.db0ffc3ecc6e4p-1, 0x1.db0ffc3ecc6e3p-1},
                {-0x1.0p15, -0x1.db0ffc3ecc6e4p-1, -0x1.db0ffc3ecc6e3p-1},
                {0x1.0000000000001p13, -0x1.e98f87098b627p-1, -0x1.e98f87098b626p-1},
                {-0x1.0000000000001p13, 0x1.e98f87098b627p-1, 0x1.e98f87098b626p-1},
                {0x1.0000000000001p52, 0x1.053c35068e10dp-4, 0x1.053c35068e10ep-4},
                {-0x1.0000000000001p52, -0x1.053c35068e10dp-4, -0x1.053c35068e10ep-4},
                {0x1.0000000000001p228, 0x1.72d421b6884e5p-1, 0x1.72d421b6884e6p-1},
                {-0x1.0000000000001p228, -0x1.72d421b6884e5p-1, -0x1.72d421b6884e6p-1},
                {0x1.0000000000001p491, 0x1.77fba987c5654p-1, 0x1.77fba987c5653p-1},
                {-0x1.0000000000001p491, -0x1.77fba987c5654p-1, -0x1.77fba987c5653p-1},
                {0x1.0000000000003p215, -0x1.723b2625331afp-1, -0x1.723b2625331bp-1},
                {-0x1.0000000000003p215, 0x1.723b2625331afp-1, 0x1.723b2625331bp-1},
                {0x1.0000000000006p0, 0x1.aed548f090cf5p-1, 0x1.aed548f090cf4p-1},
                {-0x1.0000000000006p0, -0x1.aed548f090cf5p-1, -0x1.aed548f090cf4p-1},
                {0x1.0000000000007p8, -0x1.ff983208c7dc9p-1, -0x1.ff983208c7dcap-1},
                {-0x1.0000000000007p8, 0x1.ff983208c7dc9p-1, 0x1.ff983208c7dcap-1},
                {0x1.0000000000007p275, 0x1.ffef29dc38453p-1, 0x1.ffef29dc38452p-1},
                {-0x1.0000000000007p275, -0x1.ffef29dc38453p-1, -0x1.ffef29dc38452p-1},
                {0x1.0000000000007p449, -0x1.fa88c375723c1p-8, -0x1.fa88c375723cp-8},
                {-0x1.0000000000007p449, 0x1.fa88c375723c1p-8, 0x1.fa88c375723cp-8},
                {0x1.0000000000011p644, 0x1.fff5322c94eaep-1, 0x1.fff5322c94eafp-1},
                {-0x1.0000000000011p644, -0x1.fff5322c94eaep-1, -0x1.fff5322c94eafp-1},
                {0x1.000000000001fp164, -0x1.a73630af8f15cp-1, -0x1.a73630af8f15bp-1},
                {-0x1.000000000001fp164, 0x1.a73630af8f15cp-1, 0x1.a73630af8f15bp-1},
                {0x1.0000000000038p380, 0x1.1c548f9249e44p-2, 0x1.1c548f9249e45p-2},
                {-0x1.0000000000038p380, -0x1.1c548f9249e44p-2, -0x1.1c548f9249e45p-2},
                {0x1.0000000000118p380, 0x1.ca965bd2c4dffp-3, 0x1.ca965bd2c4dfep-3},
                {-0x1.0000000000118p380, -0x1.ca965bd2c4dffp-3, -0x1.ca965bd2c4dfep-3},
                {0x1.000000000012cp2, -0x1.837b9dddc24dp-1, -0x1.837b9dddc24cfp-1},
                {-0x1.000000000012cp2, 0x1.837b9dddc24dp-1, 0x1.837b9dddc24cfp-1},
                {0x1.00000000001f8p700, 0x1.d82c1784c3eccp-2, 0x1.d82c1784c3ecbp-2},
                {-0x1.00000000001f8p700, -0x1.d82c1784c3eccp-2, -0x1.d82c1784c3ecbp-2},
                {0x1.00000000002p-7, 0x1.fffeaaaaef2eep-8, 0x1.fffeaaaaef2efp-8},
                {-0x1.00000000002p-7, -0x1.fffeaaaaef2eep-8, -0x1.fffeaaaaef2efp-8},
                {0x1.00000000002p40, -0x1.0871bddd90fc6p-1, -0x1.0871bddd90fc5p-1},
                {-0x1.00000000002p40, 0x1.0871bddd90fc6p-1, 0x1.0871bddd90fc5p-1},
                {0x1.0000000000201p-7, 0x1.fffeaaaaef2fp-8, 0x1.fffeaaaaef2f1p-8},
                {-0x1.0000000000201p-7, -0x1.fffeaaaaef2fp-8, -0x1.fffeaaaaef2f1p-8},
                {0x1.0000000000221p-7, 0x1.fffeaaaaef33p-8, 0x1.fffeaaaaef331p-8},
                {-0x1.0000000000221p-7, -0x1.fffeaaaaef33p-8, -0x1.fffeaaaaef331p-8},
                {0x1.000000000023ap-7, 0x1.fffeaaaaef362p-8, 0x1.fffeaaaaef363p-8},
                {-0x1.000000000023ap-7, -0x1.fffeaaaaef362p-8, -0x1.fffeaaaaef363p-8},
                {0x1.0000000004p45, 0x1.e0c6edfa93601p-9, 0x1.e0c6edfa93602p-9},
                {-0x1.0000000004p45, -0x1.e0c6edfa93601p-9, -0x1.e0c6edfa93602p-9},
                {0x1.0000000cp40, 0x1.ea1f618356db1p-5, 0x1.ea1f618356dbp-5},
                {-0x1.0000000cp40, -0x1.ea1f618356db1p-5, -0x1.ea1f618356dbp-5},
                {0x1.00000013c86f4p-2, 0x1.faaeed7587542p-3, 0x1.faaeed7587541p-3},
                {-0x1.00000013c86f4p-2, -0x1.faaeed7587542p-3, -0x1.faaeed7587541p-3},
                {0x1.001p13, 0x1.540bc7785680bp-1, 0x1.540bc7785680ap-1},
                {-0x1.001p13, -0x1.540bc7785680bp-1, -0x1.540bc7785680ap-1},
                {0x1.003p699, -0x1.37a7cb907a2e5p-1, -0x1.37a7cb907a2e6p-1},
                {-0x1.003p699, 0x1.37a7cb907a2e5p-1, 0x1.37a7cb907a2e6p-1},
                {0x1.0038p40, -0x1.29e5845fc54b5p-1, -0x1.29e5845fc54b6p-1},
                {-0x1.0038p40, 0x1.29e5845fc54b5p-1, 0x1.29e5845fc54b6p-1},
                {0x1.007p10, 0x1.ffe5ca4656491p-1, 0x1.ffe5ca4656492p-1},
                {-0x1.007p10, -0x1.ffe5ca4656491p-1, -0x1.ffe5ca4656492p-1},
                {0x1.007p25, 0x1.ea4df82db014bp-1, 0x1.ea4df82db014ap-1},
                {-0x1.007p25, -0x1.ea4df82db014bp-1, -0x1.ea4df82db014ap-1},
                {0x1.007p41, 0x1.fe757aef1c80cp-1, 0x1.fe757aef1c80dp-1},
                {-0x1.007p41, -0x1.fe757aef1c80cp-1, -0x1.fe757aef1c80dp-1},
                {0x1.00cp41, 0x1.e9b71805ec068p-7, 0x1.e9b71805ec069p-7},
                {-0x1.00cp41, -0x1.e9b71805ec068p-7, -0x1.e9b71805ec069p-7},
                {0x1.01c00000001p0, 0x1.b0b6d0a540583p-1, 0x1.b0b6d0a540582p-1},
                {-0x1.01c00000001p0, -0x1.b0b6d0a540583p-1, -0x1.b0b6d0a540582p-1},
                {0x1.02322e46da919p-2, 0x1.fef0092627012p-3, 0x1.fef0092627013p-3},
                {-0x1.02322e46da919p-2, -0x1.fef0092627012p-3, -0x1.fef0092627013p-3},
                {0x1.02a236478p-2, 0x1.ffc90059804a1p-3, 0x1.ffc90059804ap-3},
                {-0x1.02a236478p-2, -0x1.ffc90059804a1p-3, -0x1.ffc90059804ap-3},
                {0x1.02a65d08ca5e5p-2, 0x1.ffd10a6b5429fp-3, 0x1.ffd10a6b5429ep-3},
                {-0x1.02a65d08ca5e5p-2, -0x1.ffd10a6b5429fp-3, -0x1.ffd10a6b5429ep-3},
                {0x1.02a65d2dce49ap-2, 0x1.ffd10ab302a3fp-3, 0x1.ffd10ab302a4p-3},
                {-0x1.02a65d2dce49ap-2, -0x1.ffd10ab302a3fp-3, -0x1.ffd10ab302a4p-3},
                {0x1.02ae7238ap-2, 0x1.ffe0b1764ca4cp-3, 0x1.ffe0b1764ca4dp-3},
                {-0x1.02ae7238ap-2, -0x1.ffe0b1764ca4cp-3, -0x1.ffe0b1764ca4dp-3},
                {0x1.0501d22221dacp621, -0x1.f68f0e26c0f6bp-3, -0x1.f68f0e26c0f6ap-3},
                {-0x1.0501d22221dacp621, 0x1.f68f0e26c0f6bp-3, 0x1.f68f0e26c0f6ap-3},
                {0x1.06ffffffffff8p0, 0x1.b63c41f09eb75p-1, 0x1.b63c41f09eb74p-1},
                {-0x1.06ffffffffff8p0, -0x1.b63c41f09eb75p-1, -0x1.b63c41f09eb74p-1},
                {0x1.07023d3d44215p12, -0x1.ffdc173adabb2p-1, -0x1.ffdc173adabb1p-1},
                {-0x1.07023d3d44215p12, 0x1.ffdc173adabb2p-1, 0x1.ffdc173adabb1p-1},
                {0x1.0895a7a3e8ae6p-5, 0x1.0889e11bef135p-5, 0x1.0889e11bef136p-5},
                {-0x1.0895a7a3e8ae6p-5, -0x1.0889e11bef135p-5, -0x1.0889e11bef136p-5},
                {0x1.08d5d69840601p-5, 0x1.08ca077c76445p-5, 0x1.08ca077c76446p-5},
                {-0x1.08d5d69840601p-5, -0x1.08ca077c76445p-5, -0x1.08ca077c76446p-5},
                {0x1.0ep6, -0x1.ff7fbe518023fp-1, -0x1.ff7fbe518023ep-1},
                {-0x1.0ep6, 0x1.ff7fbe518023fp-1, 0x1.ff7fbe518023ep-1},
                {0x1.107ba49c346e4p9, -0x1.fd6c68b877afep-1, -0x1.fd6c68b877affp-1},
                {-0x1.107ba49c346e4p9, 0x1.fd6c68b877afep-1, 0x1.fd6c68b877affp-1},
                {0x1.149154477444p745, -0x1.a2ba6bc70bce4p-1, -0x1.a2ba6bc70bce5p-1},
                {-0x1.149154477444p745, 0x1.a2ba6bc70bce4p-1, 0x1.a2ba6bc70bce5p-1},
                {0x1.1663c0e51818p-5, 0x1.165609790f235p-5, 0x1.165609790f234p-5},
                {-0x1.1663c0e51818p-5, -0x1.165609790f235p-5, -0x1.165609790f234p-5},
                {0x1.1745d1745d176p238, -0x1.fc0523ff94e45p-1, -0x1.fc0523ff94e44p-1},
                {-0x1.1745d1745d176p238, 0x1.fc0523ff94e45p-1, 0x1.fc0523ff94e44p-1},
                {0x1.17472a408a3ep97, 0x1.f34a729c584bdp-1, 0x1.f34a729c584bcp-1},
                {-0x1.17472a408a3ep97, -0x1.f34a729c584bdp-1, -0x1.f34a729c584bcp-1},
                {0x1.178d91b6b992dp-5, 0x1.177fae169fdf1p-5, 0x1.177fae169fdfp-5},
                {-0x1.178d91b6b992dp-5, -0x1.177fae169fdf1p-5, -0x1.177fae169fdfp-5},
                {0x1.178d91b6bad4ep-5, 0x1.177fae16a120fp-5, 0x1.177fae16a120ep-5},
                {-0x1.178d91b6bad4ep-5, -0x1.177fae16a120fp-5, -0x1.177fae16a120ep-5},
                {0x1.178d91b6bbabap-5, 0x1.177fae16a1f79p-5, 0x1.177fae16a1f78p-5},
                {-0x1.178d91b6bbabap-5, -0x1.177fae16a1f79p-5, -0x1.177fae16a1f78p-5},
                {0x1.178d91b6bdc45p-5, 0x1.177fae16a40ffp-5, 0x1.177fae16a40fep-5},
                {-0x1.178d91b6bdc45p-5, -0x1.177fae16a40ffp-5, -0x1.177fae16a40fep-5},
                {0x1.19752dbee5f6ap933, 0x1.297c768f2413p-1, 0x1.297c768f24131p-1},
                {-0x1.19752dbee5f6ap933, -0x1.297c768f2413p-1, -0x1.297c768f24131p-1},
                {0x1.1b3009cfe4dbcp8, 0x1.b826df5cafafap-2, 0x1.b826df5cafafbp-2},
                {-0x1.1b3009cfe4dbcp8, -0x1.b826df5cafafap-2, -0x1.b826df5cafafbp-2},
                {0x1.1f6475d95bf18p3, 0x1.b7a5956250b6bp-2, 0x1.b7a5956250b6ap-2},
                {-0x1.1f6475d95bf18p3, -0x1.b7a5956250b6bp-2, -0x1.b7a5956250b6ap-2},
                {0x1.229148a452291p118, 0x1.4db6566b64548p-1, 0x1.4db6566b64547p-1},
                {-0x1.229148a452291p118, -0x1.4db6566b64548p-1, -0x1.4db6566b64547p-1},
                {0x1.268p-1, 0x1.1686fee2c49a8p-1, 0x1.1686fee2c49a7p-1},
                {-0x1.268p-1, -0x1.1686fee2c49a8p-1, -0x1.1686fee2c49a7p-1},
                {0x1.26fb3844dd19p-2, 0x1.22eb21a44d627p-2, 0x1.22eb21a44d628p-2},
                {-0x1.26fb3844dd19p-2, -0x1.22eb21a44d627p-2, -0x1.22eb21a44d628p-2},
                {0x1.27fffffffe6bp0, 0x1.d4a216d89b2b3p-1, 0x1.d4a216d89b2b4p-1},
                {-0x1.27fffffffe6bp0, -0x1.d4a216d89b2b3p-1, -0x1.d4a216d89b2b4p-1},
                {0x1.284b84048d481p204, -0x1.76c9b0f3a22f8p-1, -0x1.76c9b0f3a22f7p-1},
                {-0x1.284b84048d481p204, 0x1.76c9b0f3a22f8p-1, 0x1.76c9b0f3a22f7p-1},
                {0x1.2999e3109cad4p2, -0x1.ff01226f97d33p-1, -0x1.ff01226f97d32p-1},
                {-0x1.2999e3109cad4p2, 0x1.ff01226f97d33p-1, 0x1.ff01226f97d32p-1},
                {0x1.2aap-5, 0x1.2a8f11e7ae82cp-5, 0x1.2a8f11e7ae82dp-5},
                {-0x1.2aap-5, -0x1.2a8f11e7ae82cp-5, -0x1.2a8f11e7ae82dp-5},
                {0x1.2b14d3be0c23p-5, 0x1.2b03d1bf773dfp-5, 0x1.2b03d1bf773ep-5},
                {-0x1.2b14d3be0c23p-5, -0x1.2b03d1bf773dfp-5, -0x1.2b03d1bf773ep-5},
                {0x1.2b7cb44849981p2, -0x1.ffb90ee641792p-1, -0x1.ffb90ee641791p-1},
                {-0x1.2b7cb44849981p2, 0x1.ffb90ee641792p-1, 0x1.ffb90ee641791p-1},
                {0x1.2becc8685258p200, -0x1.ffffff79e71a4p-1, -0x1.ffffff79e71a3p-1},
                {-0x1.2becc8685258p200, 0x1.ffffff79e71a4p-1, 0x1.ffffff79e71a3p-1},
                {0x1.2cfa14ce27cd5p2, -0x1.fff9edaf85b77p-1, -0x1.fff9edaf85b76p-1},
                {-0x1.2cfa14ce27cd5p2, 0x1.fff9edaf85b77p-1, 0x1.fff9edaf85b76p-1},
                {0x1.2dp-4, 0x1.2cbaaa4cebb52p-4, 0x1.2cbaaa4cebb51p-4},
                {-0x1.2dp-4, -0x1.2cbaaa4cebb52p-4, -0x1.2cbaaa4cebb51p-4},
                {0x1.2d76d18721be8p2, -0x1.ffffbc177e01p-1, -0x1.ffffbc177e00fp-1},
                {-0x1.2d76d18721be8p2, 0x1.ffffbc177e01p-1, 0x1.ffffbc177e00fp-1},
                {0x1.302a494e0909p97, 0x1.745843dfafefdp-18, 0x1.745843dfafefep-18},
                {-0x1.302a494e0909p97, -0x1.745843dfafefdp-18, -0x1.745843dfafefep-18},
                {0x1.31cc731cc731cp1000, 0x1.ffcc568d42376p-1, 0x1.ffcc568d42377p-1},
                {-0x1.31cc731cc731cp1000, -0x1.ffcc568d42376p-1, -0x1.ffcc568d42377p-1},
                {0x1.328463d4f8ca6p441, 0x1.b676077d4faf8p-1, 0x1.b676077d4faf7p-1},
                {-0x1.328463d4f8ca6p441, -0x1.b676077d4faf8p-1, -0x1.b676077d4faf7p-1},
                {0x1.32ce90b32171ep18, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.32ce90b32171ep18, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.35debd7f020ecp-5, 0x1.35cbd3240d149p-5, 0x1.35cbd3240d148p-5},
                {-0x1.35debd7f020ecp-5, -0x1.35cbd3240d149p-5, -0x1.35cbd3240d148p-5},
                {0x1.3bb3487893405p-7, 0x1.3bb2086559faap-7, 0x1.3bb2086559fa9p-7},
                {-0x1.3bb3487893405p-7, -0x1.3bb2086559faap-7, -0x1.3bb2086559fa9p-7},
                {0x1.3bb3487893407p-7, 0x1.3bb2086559facp-7, 0x1.3bb2086559fabp-7},
                {-0x1.3bb3487893407p-7, -0x1.3bb2086559facp-7, -0x1.3bb2086559fabp-7},
                {0x1.3bb681d65aa6p100, 0x1.dff197edc51d2p-16, 0x1.dff197edc51d3p-16},
                {-0x1.3bb681d65aa6p100, -0x1.dff197edc51d2p-16, -0x1.dff197edc51d3p-16},
                {0x1.3f9aa8626042fp83, -0x1.5d08d3dbb41bp-3, -0x1.5d08d3dbb41afp-3},
                {-0x1.3f9aa8626042fp83, 0x1.5d08d3dbb41bp-3, 0x1.5d08d3dbb41afp-3},
                {0x1.3fep19, 0x1.fb503983f94bbp-3, 0x1.fb503983f94bcp-3},
                {-0x1.3fep19, -0x1.fb503983f94bbp-3, -0x1.fb503983f94bcp-3},
                {0x1.4285478f1e3c8p58, -0x1.d3876eacc9ee7p-1, -0x1.d3876eacc9ee6p-1},
                {-0x1.4285478f1e3c8p58, 0x1.d3876eacc9ee7p-1, 0x1.d3876eacc9ee6p-1},
                {0x1.42cbcf45a169ep-5, 0x1.42b66d54f69c1p-5, 0x1.42b66d54f69cp-5},
                {-0x1.42cbcf45a169ep-5, -0x1.42b66d54f69c1p-5, -0x1.42b66d54f69cp-5},
                {0x1.43fffffffff6ap557, 0x1.b45e9e9427554p-1, 0x1.b45e9e9427553p-1},
                {-0x1.43fffffffff6ap557, -0x1.b45e9e9427554p-1, -0x1.b45e9e9427553p-1},
                {0x1.44p-17, 0x1.43ffffffea603p-17, 0x1.43ffffffea602p-17},
                {-0x1.44p-17, -0x1.43ffffffea603p-17, -0x1.43ffffffea602p-17},
                {0x1.4748c08dc0976p200, -0x1.6a4e98d2d8b1cp-1, -0x1.6a4e98d2d8b1bp-1},
                {-0x1.4748c08dc0976p200, 0x1.6a4e98d2d8b1cp-1, 0x1.6a4e98d2d8b1bp-1},
                {0x1.478fc08p43, -0x1.b57ca8aacf2a9p-1, -0x1.b57ca8aacf2aap-1},
                {-0x1.478fc08p43, 0x1.b57ca8aacf2a9p-1, 0x1.b57ca8aacf2aap-1},
                {0x1.4cf36d17c596ep200, 0x1.ffe38008ef6b5p-1, 0x1.ffe38008ef6b4p-1},
                {-0x1.4cf36d17c596ep200, -0x1.ffe38008ef6b5p-1, -0x1.ffe38008ef6b4p-1},
                {0x1.4f0f308p488, 0x1.d6457a3f12e6cp-1, 0x1.d6457a3f12e6dp-1},
                {-0x1.4f0f308p488, -0x1.d6457a3f12e6cp-1, -0x1.d6457a3f12e6dp-1},
                {0x1.5p-20, 0x1.4fffffffff9f9p-20, 0x1.4fffffffff9f8p-20},
                {-0x1.5p-20, -0x1.4fffffffff9f9p-20, -0x1.4fffffffff9f8p-20},
                {0x1.5143e25a488f1p3, -0x1.cbad095f503a2p-1, -0x1.cbad095f503a1p-1},
                {-0x1.5143e25a488f1p3, 0x1.cbad095f503a2p-1, 0x1.cbad095f503a1p-1},
                {0x1.51f0f44da4df4p200, -0x1.f942d6262e82ep-5, -0x1.f942d6262e82dp-5},
                {-0x1.51f0f44da4df4p200, 0x1.f942d6262e82ep-5, 0x1.f942d6262e82dp-5},
                {0x1.52ad6c5a3602fp16, -0x1.fc466ccaece8p-3, -0x1.fc466ccaece81p-3},
                {-0x1.52ad6c5a3602fp16, 0x1.fc466ccaece8p-3, 0x1.fc466ccaece81p-3},
                {0x1.52f00ep793, 0x1.d69c3cf4eecdep-1, 0x1.d69c3cf4eecddp-1},
                {-0x1.52f00ep793, -0x1.d69c3cf4eecdep-1, -0x1.d69c3cf4eecddp-1},
                {0x1.5555555555556p239, 0x1.e120292f3d495p-1, 0x1.e120292f3d496p-1},
                {-0x1.5555555555556p239, -0x1.e120292f3d495p-1, -0x1.e120292f3d496p-1},
                {0x1.5a0000008p6, -0x1.fd1d85b7ef004p-1, -0x1.fd1d85b7ef003p-1},
                {-0x1.5a0000008p6, 0x1.fd1d85b7ef004p-1, 0x1.fd1d85b7ef003p-1},
                {0x1.5b063ad2dd08fp-6, 0x1.5aff9664b07e2p-6, 0x1.5aff9664b07e1p-6},
                {-0x1.5b063ad2dd08fp-6, -0x1.5aff9664b07e2p-6, -0x1.5aff9664b07e1p-6},
                {0x1.5b179d75fa285p2, -0x1.83f8bbb59f2f8p-1, -0x1.83f8bbb59f2f9p-1},
                {-0x1.5b179d75fa285p2, 0x1.83f8bbb59f2f8p-1, 0x1.83f8bbb59f2f9p-1},
                {0x1.5bb5967402f9cp79, 0x1.fa865b0d99497p-1, 0x1.fa865b0d99496p-1},
                {-0x1.5bb5967402f9cp79, -0x1.fa865b0d99497p-1, -0x1.fa865b0d99496p-1},
                {0x1.5bea01p468, 0x1.e8a523fce884dp-2, 0x1.e8a523fce884ep-2},
                {-0x1.5bea01p468, -0x1.e8a523fce884dp-2, -0x1.e8a523fce884ep-2},
                {0x1.5f19fbc507af6p9, -0x1.ff2ad941f0a41p-1, -0x1.ff2ad941f0a4p-1},
                {-0x1.5f19fbc507af6p9, 0x1.ff2ad941f0a41p-1, 0x1.ff2ad941f0a4p-1},
                {0x1.60a610a658da9p889, -0x1.75ce4a0d0bd03p-1, -0x1.75ce4a0d0bd04p-1},
                {-0x1.60a610a658da9p889, 0x1.75ce4a0d0bd03p-1, 0x1.75ce4a0d0bd04p-1},
                {0x1.62ad7ce17143dp62, -0x1.721586594ab48p-1, -0x1.721586594ab49p-1},
                {-0x1.62ad7ce17143dp62, 0x1.721586594ab48p-1, 0x1.721586594ab49p-1},
                {0x1.645926cc1132cp9, 0x1.b8d27019d1b9fp-2, 0x1.b8d27019d1b9ep-2},
                {-0x1.645926cc1132cp9, -0x1.b8d27019d1b9fp-2, -0x1.b8d27019d1b9ep-2},
                {0x1.647e25d391f17p-9, 0x1.647e09059c1eap-9, 0x1.647e09059c1e9p-9},
                {-0x1.647e25d391f17p-9, -0x1.647e09059c1eap-9, -0x1.647e09059c1e9p-9},
                {0x1.64ef438p142, -0x1.8d3b53ff85a82p-1, -0x1.8d3b53ff85a83p-1},
                {-0x1.64ef438p142, 0x1.8d3b53ff85a82p-1, 0x1.8d3b53ff85a83p-1},
                {0x1.6599665996658p3, -0x1.f7c8630e62a02p-1, -0x1.f7c8630e62a01p-1},
                {-0x1.6599665996658p3, 0x1.f7c8630e62a02p-1, 0x1.f7c8630e62a01p-1},
                {0x1.672p-5, 0x1.67028e3602035p-5, 0x1.67028e3602034p-5},
                {-0x1.672p-5, -0x1.67028e3602035p-5, -0x1.67028e3602034p-5},
                {0x1.688ae6c138ea8p299, 0x1.bc60c8c33cb5fp-2, 0x1.bc60c8c33cb5ep-2},
                {-0x1.688ae6c138ea8p299, -0x1.bc60c8c33cb5fp-2, -0x1.bc60c8c33cb5ep-2},
                {0x1.6aa78p17, -0x1.fc3b4bb8b012ep-1, -0x1.fc3b4bb8b012fp-1},
                {-0x1.6aa78p17, 0x1.fc3b4bb8b012ep-1, 0x1.fc3b4bb8b012fp-1},
                {0x1.6ac5b262ca1ffp849, 0x1.0p0, 0x1.0p0},
                {-0x1.6ac5b262ca1ffp849, -0x1.0p0, -0x1.0p0},
                {0x1.6d88083749412p4, -0x1.82317836a97c8p-1, -0x1.82317836a97c9p-1},
                {-0x1.6d88083749412p4, 0x1.82317836a97c8p-1, 0x1.82317836a97c9p-1},
                {0x1.6f8p-6, 0x1.6f781c78cc82bp-6, 0x1.6f781c78cc82ap-6},
                {-0x1.6f8p-6, -0x1.6f781c78cc82bp-6, -0x1.6f781c78cc82ap-6},
                {0x1.729aa6859d1f4p396, -0x1.fdbe5085494aep-1, -0x1.fdbe5085494afp-1},
                {-0x1.729aa6859d1f4p396, 0x1.fdbe5085494aep-1, 0x1.fdbe5085494afp-1},
                {0x1.73e2dbe9a2f8p10, -0x1.fffffae862b5p-1, -0x1.fffffae862b4fp-1},
                {-0x1.73e2dbe9a2f8p10, 0x1.fffffae862b5p-1, 0x1.fffffae862b4fp-1},
                {0x1.769cde0b90b8p-7, 0x1.769ac74459b06p-7, 0x1.769ac74459b05p-7},
                {-0x1.769cde0b90b8p-7, -0x1.769ac74459b06p-7, -0x1.769ac74459b05p-7},
                {0x1.76cp-5, 0x1.769e8afb6a4ecp-5, 0x1.769e8afb6a4ebp-5},
                {-0x1.76cp-5, -0x1.769e8afb6a4ecp-5, -0x1.769e8afb6a4ebp-5},
                {0x1.78001p0, 0x1.fd562611f5bd4p-1, 0x1.fd562611f5bd5p-1},
                {-0x1.78001p0, -0x1.fd562611f5bd4p-1, -0x1.fd562611f5bd5p-1},
                {0x1.7ap0, 0x1.fdba784ca00f2p-1, 0x1.fdba784ca00f1p-1},
                {-0x1.7ap0, -0x1.fdba784ca00f2p-1, -0x1.fdba784ca00f1p-1},
                {0x1.7abd870381c2dp38, 0x1.f930c222a8683p-5, 0x1.f930c222a8682p-5},
                {-0x1.7abd870381c2dp38, -0x1.f930c222a8683p-5, -0x1.f930c222a8682p-5},
                {0x1.7dc945c21248p95, 0x1.ffeb2ff2b6923p-1, 0x1.ffeb2ff2b6924p-1},
                {-0x1.7dc945c21248p95, -0x1.ffeb2ff2b6923p-1, -0x1.ffeb2ff2b6924p-1},
                {0x1.7f73e1594b70cp98, 0x1.b279153c23fb2p-2, 0x1.b279153c23fb1p-2},
                {-0x1.7f73e1594b70cp98, -0x1.b279153c23fb2p-2, -0x1.b279153c23fb1p-2},
                {0x1.7f7ef77e83f1ap21, -0x1.599fad35cf60bp-41, -0x1.599fad35cf60ap-41},
                {-0x1.7f7ef77e83f1ap21, 0x1.599fad35cf60bp-41, 0x1.599fad35cf60ap-41},
                {0x1.8p0, 0x1.feb7a9b2c6d8bp-1, 0x1.feb7a9b2c6d8ap-1},
                {-0x1.8p0, -0x1.feb7a9b2c6d8bp-1, -0x1.feb7a9b2c6d8ap-1},
                {0x1.8p6, 0x1.f798d01ec615cp-1, 0x1.f798d01ec615bp-1},
                {-0x1.8p6, -0x1.f798d01ec615cp-1, -0x1.f798d01ec615bp-1},
                {0x1.8132ceb1c4f39p0, 0x1.fee1a2a977bcfp-1, 0x1.fee1a2a977bcep-1},
                {-0x1.8132ceb1c4f39p0, -0x1.fee1a2a977bcfp-1, -0x1.fee1a2a977bcep-1},
                {0x1.81ae0dffa3b33p959, -0x1.24245af4cd995p-52, -0x1.24245af4cd994p-52},
                {-0x1.81ae0dffa3b33p959, 0x1.24245af4cd995p-52, 0x1.24245af4cd994p-52},
                {0x1.85ec5a399a2e6p1, 0x1.85d41b0bf3091p-4, 0x1.85d41b0bf309p-4},
                {-0x1.85ec5a399a2e6p1, -0x1.85d41b0bf3091p-4, -0x1.85d41b0bf309p-4},
                {0x1.86a0092754022p16, 0x1.1e42ae3cfbdc6p-24, 0x1.1e42ae3cfbdc7p-24},
                {-0x1.86a0092754022p16, -0x1.1e42ae3cfbdc6p-24, -0x1.1e42ae3cfbdc7p-24},
                {0x1.8720588p392, -0x1.dbf4e594cefe1p-1, -0x1.dbf4e594cefe2p-1},
                {-0x1.8720588p392, 0x1.dbf4e594cefe1p-1, 0x1.dbf4e594cefe2p-1},
                {0x1.8929354ebc6aap43, 0x1.44302d6a82d4p-9, 0x1.44302d6a82d41p-9},
                {-0x1.8929354ebc6aap43, -0x1.44302d6a82d4p-9, -0x1.44302d6a82d41p-9},
                {0x1.8a791e4791e75p-5, 0x1.8a52189ec3487p-5, 0x1.8a52189ec3488p-5},
                {-0x1.8a791e4791e75p-5, -0x1.8a52189ec3487p-5, -0x1.8a52189ec3488p-5},
                {0x1.8ba761438f5edp11, -0x1.fe8566e538123p-1, -0x1.fe8566e538122p-1},
                {-0x1.8ba761438f5edp11, 0x1.fe8566e538123p-1, 0x1.fe8566e538122p-1},
                {0x1.8eaf16de6392p0, 0x1.fff42aca4cb5ap-1, 0x1.fff42aca4cb5bp-1},
                {-0x1.8eaf16de6392p0, -0x1.fff42aca4cb5ap-1, -0x1.fff42aca4cb5bp-1},
                {0x1.9p0, 0x1.fffb7d3f3a253p-1, 0x1.fffb7d3f3a252p-1},
                {-0x1.9p0, -0x1.fffb7d3f3a253p-1, -0x1.fffb7d3f3a252p-1},
                {0x1.91a5657fb6a9ap6, -0x1.e815770667fd9p-4, -0x1.e815770667fd8p-4},
                {-0x1.91a5657fb6a9ap6, 0x1.e815770667fd9p-4, 0x1.e815770667fd8p-4},
                {0x1.921fb54468847p37, -0x1.fffffffd311dcp-1, -0x1.fffffffd311ddp-1},
                {-0x1.921fb54468847p37, 0x1.fffffffd311dcp-1, 0x1.fffffffd311ddp-1},
                {0x1.921ff54442d18p2, 0x1.ffffffff875e6p-17, 0x1.ffffffff875e5p-17},
                {-0x1.921ff54442d18p2, -0x1.ffffffff875e6p-17, -0x1.ffffffff875e5p-17},
                {0x1.928p2, 0x1.812a5da3777cdp-8, 0x1.812a5da3777cep-8},
                {-0x1.928p2, -0x1.812a5da3777cdp-8, -0x1.812a5da3777cep-8},
                {0x1.94ap0, 0x1.fff9be8d82573p-1, 0x1.fff9be8d82572p-1},
                {-0x1.94ap0, -0x1.fff9be8d82573p-1, -0x1.fff9be8d82572p-1},
                {0x1.94a5294a51bdep-5, 0x1.947b0ace235f3p-5, 0x1.947b0ace235f2p-5},
                {-0x1.94a5294a51bdep-5, -0x1.947b0ace235f3p-5, -0x1.947b0ace235f2p-5},
                {0x1.94a5294a52948p100, 0x1.c34f70e55a708p-2, 0x1.c34f70e55a707p-2},
                {-0x1.94a5294a52948p100, -0x1.c34f70e55a708p-2, -0x1.c34f70e55a707p-2},
                {0x1.95361b8f7697dp-5, 0x1.950bcfc0f3d51p-5, 0x1.950bcfc0f3d5p-5},
                {-0x1.95361b8f7697dp-5, -0x1.950bcfc0f3d51p-5, -0x1.950bcfc0f3d5p-5},
                {0x1.956p-1, 0x1.6c548bfcce696p-1, 0x1.6c548bfcce695p-1},
                {-0x1.956p-1, -0x1.6c548bfcce696p-1, -0x1.6c548bfcce695p-1},
                {0x1.962p0, 0x1.ffeffdbf67ca6p-1, 0x1.ffeffdbf67ca7p-1},
                {-0x1.962p0, -0x1.ffeffdbf67ca6p-1, -0x1.ffeffdbf67ca7p-1},
                {0x1.97330d2ea16d9p-5, 0x1.9708213bf67f5p-5, 0x1.9708213bf67f4p-5},
                {-0x1.97330d2ea16d9p-5, -0x1.9708213bf67f5p-5, -0x1.9708213bf67f4p-5},
                {0x1.9756f073b6b61p-5, 0x1.972bf92713d51p-5, 0x1.972bf92713d5p-5},
                {-0x1.9756f073b6b61p-5, -0x1.972bf92713d51p-5, -0x1.972bf92713d5p-5},
                {0x1.97935055cec1bp-5, 0x1.976845ebe7119p-5, 0x1.976845ebe7118p-5},
                {-0x1.97935055cec1bp-5, -0x1.976845ebe7119p-5, -0x1.976845ebe7118p-5},
                {0x1.98p-4, 0x1.97535cee51a43p-4, 0x1.97535cee51a42p-4},
                {-0x1.98p-4, -0x1.97535cee51a43p-4, -0x1.97535cee51a42p-4},
                {0x1.999999a42160cp-1, 0x1.6f494c3356177p-1, 0x1.6f494c3356178p-1},
                {-0x1.999999a42160cp-1, -0x1.6f494c3356177p-1, -0x1.6f494c3356178p-1},
                {0x1.999999aab8f5p-1, 0x1.6f494c37edd6ep-1, 0x1.6f494c37edd6dp-1},
                {-0x1.999999aab8f5p-1, -0x1.6f494c37edd6ep-1, -0x1.6f494c37edd6dp-1},
                {0x1.9a2324b9c6326p-1, 0x1.6fa912bdeaab2p-1, 0x1.6fa912bdeaab3p-1},
                {-0x1.9a2324b9c6326p-1, -0x1.6fa912bdeaab2p-1, -0x1.6fa912bdeaab3p-1},
                {0x1.9bcp-1, 0x1.70c7ef4ef9b34p-1, 0x1.70c7ef4ef9b35p-1},
                {-0x1.9bcp-1, -0x1.70c7ef4ef9b34p-1, -0x1.70c7ef4ef9b35p-1},
                {0x1.a0d1d817d6c4ap0, 0x1.ff28176ad3164p-1, 0x1.ff28176ad3163p-1},
                {-0x1.a0d1d817d6c4ap0, -0x1.ff28176ad3164p-1, -0x1.ff28176ad3163p-1},
                {0x1.a141c9de12fdfp-1, 0x1.749468a7248dep-1, 0x1.749468a7248ddp-1},
                {-0x1.a141c9de12fdfp-1, -0x1.749468a7248dep-1, -0x1.749468a7248ddp-1},
                {0x1.a251bc6766f2p-1, 0x1.754ebb7e73f46p-1, 0x1.754ebb7e73f45p-1},
                {-0x1.a251bc6766f2p-1, -0x1.754ebb7e73f46p-1, -0x1.754ebb7e73f45p-1},
                {0x1.a2689ae1b86ddp62, -0x1.7c3bfefa74bd1p-1, -0x1.7c3bfefa74bdp-1},
                {-0x1.a2689ae1b86ddp62, 0x1.7c3bfefa74bd1p-1, 0x1.7c3bfefa74bdp-1},
                {0x1.a3f66180c455p100, -0x1.ffff4f3648e03p-1, -0x1.ffff4f3648e02p-1},
                {-0x1.a3f66180c455p100, 0x1.ffff4f3648e03p-1, 0x1.ffff4f3648e02p-1},
                {0x1.a3fdd2a5286c3p1, -0x1.1cf463983c0e3p-3, -0x1.1cf463983c0e2p-3},
                {-0x1.a3fdd2a5286c3p1, 0x1.1cf463983c0e3p-3, 0x1.1cf463983c0e2p-3},
                {0x1.a44p0, 0x1.feb7948d224d8p-1, 0x1.feb7948d224d7p-1},
                {-0x1.a44p0, -0x1.feb7948d224d8p-1, -0x1.feb7948d224d7p-1},
                {0x1.a701ef3c7d54bp-1, 0x1.78801e3e11665p-1, 0x1.78801e3e11664p-1},
                {-0x1.a701ef3c7d54bp-1, -0x1.78801e3e11665p-1, -0x1.78801e3e11664p-1},
                {0x1.a8c01fd43cp537, -0x1.fff11e871d59cp-1, -0x1.fff11e871d59dp-1},
                {-0x1.a8c01fd43cp537, 0x1.fff11e871d59cp-1, 0x1.fff11e871d59dp-1},
                {0x1.a8e29b7602f3bp0, 0x1.fdfa4366eb733p-1, 0x1.fdfa4366eb734p-1},
                {-0x1.a8e29b7602f3bp0, -0x1.fdfa4366eb733p-1, -0x1.fdfa4366eb734p-1},
                {0x1.a94p0, 0x1.fde98b94e7948p-1, 0x1.fde98b94e7947p-1},
                {-0x1.a94p0, -0x1.fde98b94e7948p-1, -0x1.fde98b94e7947p-1},
                {0x1.aa445fce93b82p2, 0x1.7931cba100008p-2, 0x1.7931cba100009p-2},
                {-0x1.aa445fce93b82p2, -0x1.7931cba100008p-2, -0x1.7931cba100009p-2},
                {0x1.aaa3fbc359fbep-1, 0x1.7af3f76c7a708p-1, 0x1.7af3f76c7a709p-1},
                {-0x1.aaa3fbc359fbep-1, -0x1.7af3f76c7a708p-1, -0x1.7af3f76c7a709p-1},
                {0x1.abdd3dbd4d86p119, 0x1.fd74e53ae32fdp-6, 0x1.fd74e53ae32fcp-6},
                {-0x1.abdd3dbd4d86p119, -0x1.fd74e53ae32fdp-6, -0x1.fd74e53ae32fcp-6},
                {0x1.ae2165a0c9f8ep-1, 0x1.7d4a7bf183a34p-1, 0x1.7d4a7bf183a33p-1},
                {-0x1.ae2165a0c9f8ep-1, -0x1.7d4a7bf183a34p-1, -0x1.7d4a7bf183a33p-1},
                {0x1.ae8dfefcfe13bp2, 0x1.b81410edc79e1p-2, 0x1.b81410edc79ep-2},
                {-0x1.ae8dfefcfe13bp2, -0x1.b81410edc79e1p-2, -0x1.b81410edc79ep-2},
                {0x1.b5597f950ee8cp29, -0x1.ff751561dc50ap-2, -0x1.ff751561dc509p-2},
                {-0x1.b5597f950ee8cp29, 0x1.ff751561dc50ap-2, 0x1.ff751561dc509p-2},
                {0x1.bab62ed655019p970, 0x1.027d184afb198p-52, 0x1.027d184afb199p-52},
                {-0x1.bab62ed655019p970, -0x1.027d184afb198p-52, -0x1.027d184afb199p-52},
                {0x1.bc573c4ffffffp-10, 0x1.bc572e5e413e1p-10, 0x1.bc572e5e413e2p-10},
                {-0x1.bc573c4ffffffp-10, -0x1.bc572e5e413e1p-10, -0x1.bc572e5e413e2p-10},
                {0x1.bef5cd25ab1adp9, 0x1.fb300f1e39afep-1, 0x1.fb300f1e39affp-1},
                {-0x1.bef5cd25ab1adp9, -0x1.fb300f1e39afep-1, -0x1.fb300f1e39affp-1},
                {0x1.bfdf6df2a24c1p-2, 0x1.b1baaf622d3a3p-2, 0x1.b1baaf622d3a2p-2},
                {-0x1.bfdf6df2a24c1p-2, -0x1.b1baaf622d3a3p-2, -0x1.b1baaf622d3a2p-2},
                {0x1.bfffffdffffffp-1, 0x1.88fb762c35ce4p-1, 0x1.88fb762c35ce3p-1},
                {-0x1.bfffffdffffffp-1, -0x1.88fb762c35ce4p-1, -0x1.88fb762c35ce3p-1},
                {0x1.c2b489520e376p920, 0x1.fe0ebff99ab8dp-1, 0x1.fe0ebff99ab8cp-1},
                {-0x1.c2b489520e376p920, -0x1.fe0ebff99ab8dp-1, -0x1.fe0ebff99ab8cp-1},
                {0x1.c54beb008547p5, 0x1.cf7f749f2a836p-4, 0x1.cf7f749f2a835p-4},
                {-0x1.c54beb008547p5, -0x1.cf7f749f2a836p-4, -0x1.cf7f749f2a835p-4},
                {0x1.c5ad34f5f472ap-2, 0x1.b6facf6658915p-2, 0x1.b6facf6658914p-2},
                {-0x1.c5ad34f5f472ap-2, -0x1.b6facf6658915p-2, -0x1.b6facf6658914p-2},
                {0x1.c728fc2f34bd6p-2, 0x1.b851cd9b84ee7p-2, 0x1.b851cd9b84ee6p-2},
                {-0x1.c728fc2f34bd6p-2, -0x1.b851cd9b84ee7p-2, -0x1.b851cd9b84ee6p-2},
                {0x1.c92b0f6105089p-2, 0x1.ba21b53cf2ff3p-2, 0x1.ba21b53cf2ff2p-2},
                {-0x1.c92b0f6105089p-2, -0x1.ba21b53cf2ff3p-2, -0x1.ba21b53cf2ff2p-2},
                {0x1.c9dfbbe9ec704p-5, 0x1.c9a2b68e30ec7p-5, 0x1.c9a2b68e30ec8p-5},
                {-0x1.c9dfbbe9ec704p-5, -0x1.c9a2b68e30ec7p-5, -0x1.c9a2b68e30ec8p-5},
                {0x1.caf31bd7ee217p0, 0x1.f370115c9ab35p-1, 0x1.f370115c9ab36p-1},
                {-0x1.caf31bd7ee217p0, -0x1.f370115c9ab35p-1, -0x1.f370115c9ab36p-1},
                {0x1.cb44e86bc192bp648, -0x1.dd38a1f1d289bp-54, -0x1.dd38a1f1d289cp-54},
                {-0x1.cb44e86bc192bp648, 0x1.dd38a1f1d289bp-54, 0x1.dd38a1f1d289cp-54},
                {0x1.cb44e86bc192bp649, 0x1.dd38a1f1d289bp-53, 0x1.dd38a1f1d289cp-53},
                {-0x1.cb44e86bc192bp649, -0x1.dd38a1f1d289bp-53, -0x1.dd38a1f1d289cp-53},
                {0x1.cb6p-3, 0x1.c7885aef33a95p-3, 0x1.c7885aef33a94p-3},
                {-0x1.cb6p-3, -0x1.c7885aef33a95p-3, -0x1.c7885aef33a94p-3},
                {0x1.ce2271d2f662fp-4, 0x1.cd279aa6196b6p-4, 0x1.cd279aa6196b5p-4},
                {-0x1.ce2271d2f662fp-4, -0x1.cd279aa6196b6p-4, -0x1.cd279aa6196b5p-4},
                {0x1.d0000000004p-1, 0x1.930b705f9fad2p-1, 0x1.930b705f9fad1p-1},
                {-0x1.d0000000004p-1, -0x1.930b705f9fad2p-1, -0x1.930b705f9fad1p-1},
                {0x1.d01p199, 0x1.7ef24c8e67d9ap-1, 0x1.7ef24c8e67d9bp-1},
                {-0x1.d01p199, -0x1.7ef24c8e67d9ap-1, -0x1.7ef24c8e67d9bp-1},
                {0x1.d024ba6f953cfp1000, 0x1.ffff124c001abp-1, 0x1.ffff124c001aap-1},
                {-0x1.d024ba6f953cfp1000, -0x1.ffff124c001abp-1, -0x1.ffff124c001aap-1},
                {0x1.d4067c60f471ep1, -0x1.f83a0983dd15dp-2, -0x1.f83a0983dd15ep-2},
                {-0x1.d4067c60f471ep1, 0x1.f83a0983dd15dp-2, 0x1.f83a0983dd15ep-2},
                {0x1.d7de6263bcaabp-5, 0x1.d79b9896ff555p-5, 0x1.d79b9896ff554p-5},
                {-0x1.d7de6263bcaabp-5, -0x1.d79b9896ff555p-5, -0x1.d79b9896ff554p-5},
                {0x1.d800000002274p0, 0x1.ed0b908a2983p-1, 0x1.ed0b908a2982fp-1},
                {-0x1.d800000002274p0, -0x1.ed0b908a2983p-1, -0x1.ed0b908a2982fp-1},
                {0x1.d96e058p488, -0x1.f2c217cbc7dcdp-1, -0x1.f2c217cbc7dccp-1},
                {-0x1.d96e058p488, 0x1.f2c217cbc7dcdp-1, 0x1.f2c217cbc7dccp-1},
                {0x1.d98c4c612718dp-1, 0x1.98dcd09337793p-1, 0x1.98dcd09337792p-1},
                {-0x1.d98c4c612718dp-1, -0x1.98dcd09337793p-1, -0x1.98dcd09337792p-1},
                {0x1.db8p-5, 0x1.db3ba8775ca26p-5, 0x1.db3ba8775ca25p-5},
                {-0x1.db8p-5, -0x1.db3ba8775ca26p-5, -0x1.db3ba8775ca25p-5},
                {0x1.de386d6090303p200, -0x1.9fee37697d582p-2, -0x1.9fee37697d583p-2},
                {-0x1.de386d6090303p200, 0x1.9fee37697d582p-2, 0x1.9fee37697d583p-2},
                {0x1.de5e5054e921bp35, -0x1.5361ee6553188p-53, -0x1.5361ee6553189p-53},
                {-0x1.de5e5054e921bp35, 0x1.5361ee6553188p-53, 0x1.5361ee6553189p-53},
                {0x1.df77ddf77ddf4p10, 0x1.fec48d5e769ecp-1, 0x1.fec48d5e769ebp-1},
                {-0x1.df77ddf77ddf4p10, -0x1.fec48d5e769ecp-1, -0x1.fec48d5e769ebp-1},
                {0x1.e1562b0448a86p1, -0x1.2902a83d72632p-1, -0x1.2902a83d72633p-1},
                {-0x1.e1562b0448a86p1, 0x1.2902a83d72632p-1, 0x1.2902a83d72633p-1},
                {0x1.e2700cdc86635p-1, 0x1.9e26c7bc96b69p-1, 0x1.9e26c7bc96b68p-1},
                {-0x1.e2700cdc86635p-1, -0x1.9e26c7bc96b69p-1, -0x1.9e26c7bc96b68p-1},
                {0x1.e64ddaf7bd73p-7, 0x1.e6494911eedd2p-7, 0x1.e6494911eedd1p-7},
                {-0x1.e64ddaf7bd73p-7, -0x1.e6494911eedd2p-7, -0x1.e6494911eedd1p-7},
                {0x1.eb7239bca8afap-5, 0x1.eb26c690bda25p-5, 0x1.eb26c690bda24p-5},
                {-0x1.eb7239bca8afap-5, -0x1.eb26c690bda25p-5, -0x1.eb26c690bda24p-5},
                {0x1.ef7b83f7bdef4p3, 0x1.c73238790a4cfp-3, 0x1.c73238790a4cep-3},
                {-0x1.ef7b83f7bdef4p3, -0x1.c73238790a4cfp-3, -0x1.c73238790a4cep-3},
                {0x1.f20000000109bp-3, 0x1.ed1b575acb8c8p-3, 0x1.ed1b575acb8c9p-3},
                {-0x1.f20000000109bp-3, -0x1.ed1b575acb8c8p-3, -0x1.ed1b575acb8c9p-3},
                {0x1.f40ca67a9e8d7p9, 0x1.c1b50a56c8809p-1, 0x1.c1b50a56c880ap-1},
                {-0x1.f40ca67a9e8d7p9, -0x1.c1b50a56c8809p-1, -0x1.c1b50a56c880ap-1},
                {0x1.f7224d2c7754p-2, 0x1.e321fea643a96p-2, 0x1.e321fea643a97p-2},
                {-0x1.f7224d2c7754p-2, -0x1.e321fea643a96p-2, -0x1.e321fea643a97p-2},
                {0x1.f78a0d05e60e2p6, 0x1.c1269b020a108p-3, 0x1.c1269b020a107p-3},
                {-0x1.f78a0d05e60e2p6, -0x1.c1269b020a108p-3, -0x1.c1269b020a107p-3},
                {0x1.f7bdef7bdf073p-5, 0x1.f76cae28a0775p-5, 0x1.f76cae28a0774p-5},
                {-0x1.f7bdef7bdf073p-5, -0x1.f76cae28a0775p-5, -0x1.f76cae28a0774p-5},
                {0x1.f8502d5955443p-2, 0x1.e42c139dc2054p-2, 0x1.e42c139dc2053p-2},
                {-0x1.f8502d5955443p-2, -0x1.e42c139dc2054p-2, -0x1.e42c139dc2053p-2},
                {0x1.f8fc824d2693bp61, 0x1.0fa749e07f64p-9, 0x1.0fa749e07f63fp-9},
                {-0x1.f8fc824d2693bp61, -0x1.0fa749e07f64p-9, -0x1.0fa749e07f63fp-9},
                {0x1.f8fffffffffffp2, 0x1.ffa80324e2d8fp-1, 0x1.ffa80324e2d8ep-1},
                {-0x1.f8fffffffffffp2, -0x1.ffa80324e2d8fp-1, -0x1.ffa80324e2d8ep-1},
                {0x1.fd8p1, -0x1.7cdf79d5e37b8p-1, -0x1.7cdf79d5e37b9p-1},
                {-0x1.fd8p1, 0x1.7cdf79d5e37b8p-1, 0x1.7cdf79d5e37b9p-1},
                {0x1.fd9364d936596p-5, 0x1.fd3f48847a1d1p-5, 0x1.fd3f48847a1d2p-5},
                {-0x1.fd9364d936596p-5, -0x1.fd3f48847a1d1p-5, -0x1.fd3f48847a1d2p-5},
                {0x1.fe8p-3, 0x1.f93ad471d262fp-3, 0x1.f93ad471d263p-3},
                {-0x1.fe8p-3, -0x1.f93ad471d262fp-3, -0x1.f93ad471d263p-3},
                {0x1.febb646e2ee57p13, 0x1.83b3062414974p-1, 0x1.83b3062414973p-1},
                {-0x1.febb646e2ee57p13, -0x1.83b3062414974p-1, -0x1.83b3062414973p-1},
                {0x1.feeffffffffc6p995, 0x1.3b45bd7449775p-1, 0x1.3b45bd7449776p-1},
                {-0x1.feeffffffffc6p995, -0x1.3b45bd7449775p-1, -0x1.3b45bd7449776p-1},
                {0x1.ff8ffffffffffp7, -0x1.eefb59d143646p-1, -0x1.eefb59d143645p-1},
                {-0x1.ff8ffffffffffp7, 0x1.eefb59d143646p-1, 0x1.eefb59d143645p-1},
                {0x1.ff8ffffffffffp870, -0x1.56433f0c6bceep-1, -0x1.56433f0c6bcefp-1},
                {-0x1.ff8ffffffffffp870, 0x1.56433f0c6bceep-1, 0x1.56433f0c6bcefp-1},
                {0x1.ffcfff8p19, -0x1.930006246a6cp-2, -0x1.930006246a6c1p-2},
                {-0x1.ffcfff8p19, 0x1.930006246a6cp-2, 0x1.930006246a6c1p-2},
                {0x1.ffcfff8p365, 0x1.ded37a1f0aa6dp-1, 0x1.ded37a1f0aa6ep-1},
                {-0x1.ffcfff8p365, -0x1.ded37a1f0aa6dp-1, -0x1.ded37a1f0aa6ep-1},
                {0x1.ffcffffffff6cp720, -0x1.93e4d96b621ep-1, -0x1.93e4d96b621e1p-1},
                {-0x1.ffcffffffff6cp720, 0x1.93e4d96b621ep-1, 0x1.93e4d96b621e1p-1},
                {0x1.ffcfffffffff9p320, 0x1.9068b90e42606p-1, 0x1.9068b90e42605p-1},
                {-0x1.ffcfffffffff9p320, -0x1.9068b90e42606p-1, -0x1.9068b90e42605p-1},
                {0x1.ffcffffffffffp12, 0x1.cf81642e7421cp-1, 0x1.cf81642e7421dp-1},
                {-0x1.ffcffffffffffp12, -0x1.cf81642e7421cp-1, -0x1.cf81642e7421dp-1},
                {0x1.ffcffffffffffp404, 0x1.ffffffe61fe61p-1, 0x1.ffffffe61fe62p-1},
                {-0x1.ffcffffffffffp404, -0x1.ffffffe61fe61p-1, -0x1.ffffffe61fe62p-1},
                {0x1.ffeffffffffccp995, -0x1.406ee9ae91e17p-1, -0x1.406ee9ae91e16p-1},
                {-0x1.ffeffffffffccp995, 0x1.406ee9ae91e17p-1, 0x1.406ee9ae91e16p-1},
                {0x1.ffeffffffffffp-3, 0x1.fa9f6ca0ec44ep-3, 0x1.fa9f6ca0ec44fp-3},
                {-0x1.ffeffffffffffp-3, -0x1.fa9f6ca0ec44ep-3, -0x1.fa9f6ca0ec44fp-3},
                {0x1.ffeffffffffffp55, 0x1.6b491db8b66d9p-4, 0x1.6b491db8b66d8p-4},
                {-0x1.ffeffffffffffp55, -0x1.6b491db8b66d9p-4, -0x1.6b491db8b66d8p-4},
                {0x1.ffeffffffffffp180, 0x1.fb0ab102cb13p-1, 0x1.fb0ab102cb12fp-1},
                {-0x1.ffeffffffffffp180, -0x1.fb0ab102cb13p-1, -0x1.fb0ab102cb12fp-1},
                {0x1.ffeffffffffffp706, 0x1.e4315ec04635dp-3, 0x1.e4315ec04635cp-3},
                {-0x1.ffeffffffffffp706, -0x1.e4315ec04635dp-3, -0x1.e4315ec04635cp-3},
                {0x1.fff1fffffffffp41, 0x1.ffffc39997ef6p-1, 0x1.ffffc39997ef7p-1},
                {-0x1.fff1fffffffffp41, -0x1.ffffc39997ef6p-1, -0x1.ffffc39997ef7p-1},
                {0x1.fff6b89ffffffp-7, 0x1.fff163992831fp-7, 0x1.fff163992831ep-7},
                {-0x1.fff6b89ffffffp-7, -0x1.fff163992831fp-7, -0x1.fff163992831ep-7},
                {0x1.fffdffff0001fp105, -0x1.d9757a05fcc43p-1, -0x1.d9757a05fcc42p-1},
                {-0x1.fffdffff0001fp105, 0x1.d9757a05fcc43p-1, 0x1.d9757a05fcc42p-1},
                {0x1.ffff0c0000002p1, -0x1.83791fe63a17ap-1, -0x1.83791fe63a17bp-1},
                {-0x1.ffff0c0000002p1, 0x1.83791fe63a17ap-1, 0x1.83791fe63a17bp-1},
                {0x1.ffffc00000055p150, -0x1.d9d3a85acc50dp-1, -0x1.d9d3a85acc50cp-1},
                {-0x1.ffffc00000055p150, 0x1.d9d3a85acc50dp-1, 0x1.d9d3a85acc50cp-1},
                {0x1.ffffe3fffffffp40, -0x1.f25d858dcdee7p-3, -0x1.f25d858dcdee8p-3},
                {-0x1.ffffe3fffffffp40, 0x1.f25d858dcdee7p-3, 0x1.f25d858dcdee8p-3},
                {0x1.ffffefffcffaep0, 0x1.d18f7bfe557ecp-1, 0x1.d18f7bfe557ebp-1},
                {-0x1.ffffefffcffaep0, -0x1.d18f7bfe557ecp-1, -0x1.d18f7bfe557ebp-1},
                {0x1.fffffbfffffffp228, -0x1.bc14ebf6bfb52p-4, -0x1.bc14ebf6bfb51p-4},
                {-0x1.fffffbfffffffp228, 0x1.bc14ebf6bfb52p-4, 0x1.bc14ebf6bfb51p-4},
                {0x1.fffffbfffffffp735, 0x1.bb887a06f6c51p-3, 0x1.bb887a06f6c5p-3},
                {-0x1.fffffbfffffffp735, -0x1.bb887a06f6c51p-3, -0x1.bb887a06f6c5p-3},
                {0x1.fffffefffffffp-5, 0x1.ffaaadef54e2fp-5, 0x1.ffaaadef54e3p-5},
                {-0x1.fffffefffffffp-5, -0x1.ffaaadef54e2fp-5, -0x1.ffaaadef54e3p-5},
                {0x1.ffffff8p119, 0x1.d4a3c62c5be09p-1, 0x1.d4a3c62c5be08p-1},
                {-0x1.ffffff8p119, -0x1.d4a3c62c5be09p-1, -0x1.d4a3c62c5be08p-1},
                {0x1.ffffff8p192, 0x1.cec20f197703fp-3, 0x1.cec20f197704p-3},
                {-0x1.ffffff8p192, -0x1.cec20f197703fp-3, -0x1.cec20f197704p-3},
                {0x1.ffffff8p543, 0x1.d37aadc7c8662p-2, 0x1.d37aadc7c8663p-2},
                {-0x1.ffffff8p543, -0x1.d37aadc7c8662p-2, -0x1.d37aadc7c8663p-2},
                {0x1.ffffffc0018ffp2, 0x1.fa8d2a4d0a202p-1, 0x1.fa8d2a4d0a203p-1},
                {-0x1.ffffffc0018ffp2, -0x1.fa8d2a4d0a202p-1, -0x1.fa8d2a4d0a203p-1},
                {0x1.ffffffffeffffp2, 0x1.fa8d2a029f978p-1, 0x1.fa8d2a029f977p-1},
                {-0x1.ffffffffeffffp2, -0x1.fa8d2a029f978p-1, -0x1.fa8d2a029f977p-1},
                {0x1.fffffffff825p943, -0x1.2763f02a2d1eap-4, -0x1.2763f02a2d1e9p-4},
                {-0x1.fffffffff825p943, 0x1.2763f02a2d1eap-4, 0x1.2763f02a2d1e9p-4},
                {0x1.fffffffffe09dp320, 0x1.fcff128f77ddbp-1, 0x1.fcff128f77ddap-1},
                {-0x1.fffffffffe09dp320, -0x1.fcff128f77ddbp-1, -0x1.fcff128f77ddap-1},
                {0x1.fffffffffe6e3p720, -0x1.fcc0bfedd84a6p-1, -0x1.fcc0bfedd84a5p-1},
                {-0x1.fffffffffe6e3p720, 0x1.fcc0bfedd84a6p-1, 0x1.fcc0bfedd84a5p-1},
                {0x1.ffffffffffe7fp-1, 0x1.aed548f090c1ep-1, 0x1.aed548f090c1dp-1},
                {-0x1.ffffffffffe7fp-1, -0x1.aed548f090c1ep-1, -0x1.aed548f090c1dp-1},
                {0x1.ffffffffffeffp250, -0x1.f5e11def99d2bp-1, -0x1.f5e11def99d2cp-1},
                {-0x1.ffffffffffeffp250, 0x1.f5e11def99d2bp-1, 0x1.f5e11def99d2cp-1},
                {0x1.fffffffffff78p920, 0x1.8a9cbf48fec9fp-1, 0x1.8a9cbf48fecap-1},
                {-0x1.fffffffffff78p920, -0x1.8a9cbf48fec9fp-1, -0x1.8a9cbf48fecap-1},
                {0x1.fffffffffff83p150, -0x1.7eba5894844ccp-3, -0x1.7eba5894844cdp-3},
                {-0x1.fffffffffff83p150, 0x1.7eba5894844ccp-3, 0x1.7eba5894844cdp-3},
                {0x1.fffffffffffd5p995, 0x1.92c4f06d2cdd1p-1, 0x1.92c4f06d2cdd2p-1},
                {-0x1.fffffffffffd5p995, -0x1.92c4f06d2cdd1p-1, -0x1.92c4f06d2cdd2p-1},
                {0x1.fffffffffffe8p720, -0x1.3d5f7deb1d3bbp-1, -0x1.3d5f7deb1d3bap-1},
                {-0x1.fffffffffffe8p720, 0x1.3d5f7deb1d3bbp-1, 0x1.3d5f7deb1d3bap-1},
                {0x1.fffffffffffebp920, -0x1.91349b0ae90e5p-1, -0x1.91349b0ae90e6p-1},
                {-0x1.fffffffffffebp920, 0x1.91349b0ae90e5p-1, 0x1.91349b0ae90e6p-1},
                {0x1.ffffffffffff1p1, -0x1.837b9dddc1e88p-1, -0x1.837b9dddc1e87p-1},
                {-0x1.ffffffffffff1p1, 0x1.837b9dddc1e88p-1, 0x1.837b9dddc1e87p-1},
                {0x1.ffffffffffff1p245, 0x1.510e062e7fa2p-1, 0x1.510e062e7fa21p-1},
                {-0x1.ffffffffffff1p245, -0x1.510e062e7fa2p-1, -0x1.510e062e7fa21p-1},
                {0x1.ffffffffffff3p-2, 0x1.eaee8744b05e5p-2, 0x1.eaee8744b05e4p-2},
                {-0x1.ffffffffffff3p-2, -0x1.eaee8744b05e5p-2, -0x1.eaee8744b05e4p-2},
                {0x1.ffffffffffff4p845, 0x1.8a4dee8f40628p-1, 0x1.8a4dee8f40627p-1},
                {-0x1.ffffffffffff4p845, -0x1.8a4dee8f40628p-1, -0x1.8a4dee8f40627p-1},
                {0x1.ffffffffffff4p1020, 0x1.5118d6bbde07ep-1, 0x1.5118d6bbde07fp-1},
                {-0x1.ffffffffffff4p1020, -0x1.5118d6bbde07ep-1, -0x1.5118d6bbde07fp-1},
                {0x1.ffffffffffff8p616, -0x1.5cd5c53cf30a9p-1, -0x1.5cd5c53cf30aap-1},
                {-0x1.ffffffffffff8p616, 0x1.5cd5c53cf30a9p-1, 0x1.5cd5c53cf30aap-1},
                {0x1.ffffffffffffcp475, 0x1.ffffa1f0d7dafp-1, 0x1.ffffa1f0d7dbp-1},
                {-0x1.ffffffffffffcp475, -0x1.ffffa1f0d7dafp-1, -0x1.ffffa1f0d7dbp-1},
                {0x1.ffffffffffffep970, 0x1.51e9d840106d7p-1, 0x1.51e9d840106d8p-1},
                {-0x1.ffffffffffffep970, -0x1.51e9d840106d7p-1, -0x1.51e9d840106d8p-1},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0p0, -0x0.0p0, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {-0x1.0000000000001p-1022, -0x1.0000000000001p-1022, -0x1.0000000000001p-1022},
                {0x1.0000000000001p-1022, 0x1.0000000000001p-1022, 0x1.0000000000001p-1022},
                {-0x1.0p-1022, -0x1.0p-1022, -0x1.0p-1022},
                {0x1.0p-1022, 0x1.0p-1022, 0x1.0p-1022},
                {-0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022},
                {0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022},
                {0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022},
                {-0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022},
                {0x1.0p-1022, 0x1.0p-1022, 0x1.0p-1022},
                {-0x1.0p-1022, -0x1.0p-1022, -0x1.0p-1022},
                {0x1.0000000000001p-1022, 0x1.0000000000001p-1022, 0x1.0000000000001p-1022},
                {-0x1.0000000000001p-1022, -0x1.0000000000001p-1022, -0x1.0000000000001p-1022},
                {0x1.999999999999ap-13, 0x1.9999996de8ca2p-13, 0x1.9999996de8ca1p-13},
                {-0x1.999999999999ap-13, -0x1.9999996de8ca2p-13, -0x1.9999996de8ca1p-13},
                {0x1.999999999999ap-12, 0x1.999998ead65b9p-12, 0x1.999998ead65bap-12},
                {-0x1.999999999999ap-12, -0x1.999998ead65b9p-12, -0x1.999998ead65bap-12},
                {0x1.3333333333334p-11, 0x1.3333320c49bacp-11, 0x1.3333320c49babp-11},
                {-0x1.3333333333334p-11, -0x1.3333320c49bacp-11, -0x1.3333320c49babp-11},
                {0x1.999999999999ap-11, 0x1.999996de8ca29p-11, 0x1.999996de8ca28p-11},
                {-0x1.999999999999ap-11, -0x1.999996de8ca29p-11, -0x1.999996de8ca28p-11},
                {0x1.0p-10, 0x1.fffffaaaaaaefp-11, 0x1.fffffaaaaaaeep-11},
                {-0x1.0p-10, -0x1.fffffaaaaaaefp-11, -0x1.fffffaaaaaaeep-11},
                {0x1.3333333333333p-10, 0x1.33332e978d553p-10, 0x1.33332e978d552p-10},
                {-0x1.3333333333333p-10, -0x1.33332e978d553p-10, -0x1.33332e978d552p-10},
                {0x1.6666666666666p-10, 0x1.66665f1529bp-10, 0x1.66665f1529affp-10},
                {-0x1.6666666666666p-10, -0x1.66665f1529bp-10, -0x1.66665f1529affp-10},
                {0x1.9999999999999p-10, 0x1.99998ead65cep-10, 0x1.99998ead65cdfp-10},
                {-0x1.9999999999999p-10, -0x1.99998ead65cep-10, -0x1.99998ead65cdfp-10},
                {0x1.cccccccccccccp-10, 0x1.ccccbd3f7d15dp-10, 0x1.ccccbd3f7d15ep-10},
                {-0x1.cccccccccccccp-10, -0x1.ccccbd3f7d15dp-10, -0x1.ccccbd3f7d15ep-10},
                {0x1.0666666666666p-7, 0x1.0665ae9c7b44fp-7, 0x1.0665ae9c7b44ep-7},
                {-0x1.0666666666666p-7, -0x1.0665ae9c7b44fp-7, -0x1.0665ae9c7b44ep-7},
                {0x1.cccccccccccccp-7, 0x1.ccc8e97b59f62p-7, 0x1.ccc8e97b59f61p-7},
                {-0x1.cccccccccccccp-7, -0x1.ccc8e97b59f62p-7, -0x1.ccc8e97b59f61p-7},
                {0x1.4999999999999p-6, 0x1.4993e8a8ff79bp-6, 0x1.4993e8a8ff79cp-6},
                {-0x1.4999999999999p-6, -0x1.4993e8a8ff79bp-6, -0x1.4993e8a8ff79cp-6},
                {0x1.accccccccccccp-6, 0x1.acc044c56db0ep-6, 0x1.acc044c56db0fp-6},
                {-0x1.accccccccccccp-6, -0x1.acc044c56db0ep-6, -0x1.acc044c56db0fp-6},
                {0x1.08p-5, 0x1.07f44d67cf41bp-5, 0x1.07f44d67cf41ap-5},
                {-0x1.08p-5, -0x1.07f44d67cf41bp-5, -0x1.07f44d67cf41ap-5},
                {0x1.399999999999ap-5, 0x1.3985fe46f1c87p-5, 0x1.3985fe46f1c88p-5},
                {-0x1.399999999999ap-5, -0x1.3985fe46f1c87p-5, -0x1.3985fe46f1c88p-5},
                {0x1.6b33333333334p-5, 0x1.6b14bde93ac5fp-5, 0x1.6b14bde93ac6p-5},
                {-0x1.6b33333333334p-5, -0x1.6b14bde93ac5fp-5, -0x1.6b14bde93ac6p-5},
                {0x1.9cccccccccccep-5, 0x1.9ca0153ed8397p-5, 0x1.9ca0153ed8396p-5},
                {-0x1.9cccccccccccep-5, -0x1.9ca0153ed8397p-5, -0x1.9ca0153ed8396p-5},
                {0x1.ce66666666666p-5, 0x1.ce278d4027d34p-5, 0x1.ce278d4027d35p-5},
                {-0x1.ce66666666666p-5, -0x1.ce278d4027d34p-5, -0x1.ce278d4027d35p-5},
                {0x1.5e7fc4369bdadp-1, 0x1.43c1e9c171a66p-1, 0x1.43c1e9c171a67p-1},
                {-0x1.5e7fc4369bdadp-1, -0x1.43c1e9c171a66p-1, -0x1.43c1e9c171a67p-1},
                {0x1.4e7fc4369bdadp0, 0x1.ee3d6bcea09cap-1, 0x1.ee3d6bcea09cbp-1},
                {-0x1.4e7fc4369bdadp0, -0x1.ee3d6bcea09cap-1, -0x1.ee3d6bcea09cbp-1},
                {0x1.edbfa651e9c84p0, 0x1.df8e22ea809d6p-1, 0x1.df8e22ea809d7p-1},
                {-0x1.edbfa651e9c84p0, -0x1.df8e22ea809d6p-1, -0x1.df8e22ea809d7p-1},
                {0x1.467fc4369bdadp1, 0x1.1d3479eac7ae3p-1, 0x1.1d3479eac7ae4p-1},
                {-0x1.467fc4369bdadp1, -0x1.1d3479eac7ae3p-1, -0x1.1d3479eac7ae4p-1},
                {0x1.961fb54442d18p1, -0x1.ffeaaaeeee84bp-6, -0x1.ffeaaaeeee84cp-6},
                {-0x1.961fb54442d18p1, 0x1.ffeaaaeeee84bp-6, 0x1.ffeaaaeeee84cp-6},
                {0x1.e5bfa651e9c83p1, -0x1.3734d32d49bd1p-1, -0x1.3734d32d49bdp-1},
                {-0x1.e5bfa651e9c83p1, 0x1.3734d32d49bd1p-1, 0x1.3734d32d49bdp-1},
                {0x1.1aafcbafc85f7p2, -0x1.e9d25d19911e2p-1, -0x1.e9d25d19911e3p-1},
                {-0x1.1aafcbafc85f7p2, 0x1.e9d25d19911e2p-1, 0x1.e9d25d19911e3p-1},
                {0x1.427fc4369bdadp2, -0x1.e4ecdc5a4e466p-1, -0x1.e4ecdc5a4e465p-1},
                {-0x1.427fc4369bdadp2, 0x1.e4ecdc5a4e466p-1, 0x1.e4ecdc5a4e465p-1},
                {0x1.6a4fbcbd6f562p2, -0x1.2a59f10344262p-1, -0x1.2a59f10344261p-1},
                {-0x1.6a4fbcbd6f562p2, 0x1.2a59f10344262p-1, 0x1.2a59f10344261p-1},
                {0x1.6af2eff0a2896p2, -0x1.26312443bd35fp-1, -0x1.26312443bd36p-1},
                {-0x1.6af2eff0a2896p2, 0x1.26312443bd35fp-1, 0x1.26312443bd36p-1},
                {0x1.43c62a9d02414p2, -0x1.e18e660a5e2fbp-1, -0x1.e18e660a5e2fcp-1},
                {-0x1.43c62a9d02414p2, 0x1.e18e660a5e2fbp-1, 0x1.e18e660a5e2fcp-1},
                {0x1.1c99654961f92p2, -0x1.ee0e83a0198b7p-1, -0x1.ee0e83a0198b6p-1},
                {-0x1.1c99654961f92p2, 0x1.ee0e83a0198b7p-1, 0x1.ee0e83a0198b6p-1},
                {0x1.ead93feb8361fp1, -0x1.4727747338e46p-1, -0x1.4727747338e47p-1},
                {-0x1.ead93feb8361fp1, 0x1.4727747338e46p-1, 0x1.4727747338e47p-1},
                {0x1.9c7fb54442d1ap1, -0x1.4ba2f75dda5fep-4, -0x1.4ba2f75dda5ffp-4},
                {-0x1.9c7fb54442d1ap1, 0x1.4ba2f75dda5fep-4, 0x1.4ba2f75dda5ffp-4},
                {0x1.4e262a9d02415p1, 0x1.034c4d633b4efp-1, 0x1.034c4d633b4fp-1},
                {-0x1.4e262a9d02415p1, -0x1.034c4d633b4efp-1, -0x1.034c4d633b4fp-1},
                {0x1.ff993feb8362p0, 0x1.d1e4cde2f3945p-1, 0x1.d1e4cde2f3944p-1},
                {-0x1.ff993feb8362p0, -0x1.d1e4cde2f3945p-1, -0x1.d1e4cde2f3944p-1},
                {0x1.62e62a9d02416p0, 0x1.f750235c94992p-1, 0x1.f750235c94993p-1},
                {-0x1.62e62a9d02416p0, -0x1.f750235c94992p-1, -0x1.f750235c94993p-1},
                {0x1.8c662a9d02419p-1, 0x1.65f7d571279b1p-1, 0x1.65f7d571279bp-1},
                {-0x1.8c662a9d02419p-1, -0x1.65f7d571279b1p-1, -0x1.65f7d571279bp-1},
                {-0x1.a8aa1d11c44ffp0, -0x1.fe043f57369d7p-1, -0x1.fe043f57369d6p-1},
                {0x1.a8aa1d11c44ffp0, 0x1.fe043f57369d7p-1, 0x1.fe043f57369d6p-1},
                {-0x1.95ec8b9e03d54p0, -0x1.fff18f24f3e4cp-1, -0x1.fff18f24f3e4bp-1},
                {0x1.95ec8b9e03d54p0, 0x1.fff18f24f3e4cp-1, 0x1.fff18f24f3e4bp-1},
                {-0x1.832efa2a435a9p0, -0x1.ff20d961624e7p-1, -0x1.ff20d961624e8p-1},
                {0x1.832efa2a435a9p0, 0x1.ff20d961624e7p-1, 0x1.ff20d961624e8p-1},
                {-0x1.707168b682dfep0, -0x1.fb933c40107fdp-1, -0x1.fb933c40107fep-1},
                {0x1.707168b682dfep0, 0x1.fb933c40107fdp-1, 0x1.fb933c40107fep-1},
                {-0x1.5db3d742c2653p0, -0x1.f54d971881ad7p-1, -0x1.f54d971881ad6p-1},
                {0x1.5db3d742c2653p0, 0x1.f54d971881ad7p-1, 0x1.f54d971881ad6p-1},
                {-0x1.4af645cf01ea8p0, -0x1.ec5883b7b6cf5p-1, -0x1.ec5883b7b6cf4p-1},
                {0x1.4af645cf01ea8p0, 0x1.ec5883b7b6cf5p-1, 0x1.ec5883b7b6cf4p-1},
                {-0x1.3838b45b416fdp0, -0x1.e0c04a94e1731p-1, -0x1.e0c04a94e173p-1},
                {0x1.3838b45b416fdp0, 0x1.e0c04a94e1731p-1, 0x1.e0c04a94e173p-1},
                {-0x1.257b22e780f52p0, -0x1.d294d1f96c7ecp-1, -0x1.d294d1f96c7ebp-1},
                {0x1.257b22e780f52p0, 0x1.d294d1f96c7ecp-1, 0x1.d294d1f96c7ebp-1},
                {-0x1.12bd9173c07abp0, -0x1.c1e9883373d7fp-1, -0x1.c1e9883373d7ep-1},
                {0x1.12bd9173c07abp0, 0x1.c1e9883373d7fp-1, 0x1.c1e9883373d7ep-1},
                {-0x1.ea5c3ed5b385p-1, -0x1.a2c289d9d055bp-1, -0x1.a2c289d9d055ap-1},
                {0x1.ea5c3ed5b385p-1, 0x1.a2c289d9d055bp-1, 0x1.a2c289d9d055ap-1},
                {-0x1.d4b87dab670ap-1, -0x1.95f05257dbcb6p-1, -0x1.95f05257dbcb5p-1},
                {0x1.d4b87dab670ap-1, 0x1.95f05257dbcb6p-1, 0x1.95f05257dbcb5p-1},
                {-0x1.bf14bc811a8fp-1, -0x1.88647f26a6e0fp-1, -0x1.88647f26a6e1p-1},
                {0x1.bf14bc811a8fp-1, 0x1.88647f26a6e0fp-1, 0x1.88647f26a6e1p-1},
                {-0x1.a970fb56ce14p-1, -0x1.7a2541dfd4e75p-1, -0x1.7a2541dfd4e76p-1},
                {0x1.a970fb56ce14p-1, 0x1.7a2541dfd4e75p-1, 0x1.7a2541dfd4e76p-1},
                {-0x1.93cd3a2c8199p-1, -0x1.6b391e25bc26dp-1, -0x1.6b391e25bc26cp-1},
                {0x1.93cd3a2c8199p-1, 0x1.6b391e25bc26dp-1, 0x1.6b391e25bc26cp-1},
                {-0x1.7e297902351ep-1, -0x1.5ba6e6a8e7065p-1, -0x1.5ba6e6a8e7066p-1},
                {0x1.7e297902351ep-1, 0x1.5ba6e6a8e7065p-1, 0x1.5ba6e6a8e7066p-1},
                {-0x1.6885b7d7e8a3p-1, -0x1.4b75ba096fa55p-1, -0x1.4b75ba096fa54p-1},
                {0x1.6885b7d7e8a3p-1, 0x1.4b75ba096fa55p-1, 0x1.4b75ba096fa54p-1},
                {-0x1.52e1f6ad9c28p-1, -0x1.3aacff95a3123p-1, -0x1.3aacff95a3122p-1},
                {0x1.52e1f6ad9c28p-1, 0x1.3aacff95a3123p-1, 0x1.3aacff95a3122p-1},
                {-0x1.3d3e35834fadp-1, -0x1.295463e769285p-1, -0x1.295463e769284p-1},
                {0x1.3d3e35834fadp-1, 0x1.295463e769285p-1, 0x1.295463e769284p-1},
                {-0x1.0a0b02501c799p-1, -0x1.fc769b77e5885p-2, -0x1.fc769b77e5884p-2},
                {0x1.0a0b02501c799p-1, 0x1.fc769b77e5885p-2, 0x1.fc769b77e5884p-2},
                {-0x1.d8f7208e6b82cp-2, -0x1.c853c78462de4p-2, -0x1.c853c78462de5p-2},
                {0x1.d8f7208e6b82cp-2, 0x1.c853c78462de4p-2, 0x1.c853c78462de5p-2},
                {-0x1.9dd83c7c9e126p-2, -0x1.92aba90aaf272p-2, -0x1.92aba90aaf273p-2},
                {0x1.9dd83c7c9e126p-2, 0x1.92aba90aaf272p-2, 0x1.92aba90aaf273p-2},
                {-0x1.62b9586ad0a2p-2, -0x1.5bac064658f39p-2, -0x1.5bac064658f3ap-2},
                {0x1.62b9586ad0a2p-2, 0x1.5bac064658f39p-2, 0x1.5bac064658f3ap-2},
                {-0x1.279a74590331ap-2, -0x1.2383ca8078e58p-2, -0x1.2383ca8078e59p-2},
                {0x1.279a74590331ap-2, 0x1.2383ca8078e58p-2, 0x1.2383ca8078e59p-2},
                {-0x1.d8f7208e6b829p-3, -0x1.d4c5bc11d2372p-3, -0x1.d4c5bc11d2371p-3},
                {0x1.d8f7208e6b829p-3, 0x1.d4c5bc11d2372p-3, 0x1.d4c5bc11d2371p-3},
                {-0x1.62b9586ad0a1ep-3, -0x1.60f3faaf43024p-3, -0x1.60f3faaf43023p-3},
                {0x1.62b9586ad0a1ep-3, 0x1.60f3faaf43024p-3, 0x1.60f3faaf43023p-3},
                {-0x1.d8f7208e6b826p-4, -0x1.d7ea3de45a9d6p-4, -0x1.d7ea3de45a9d7p-4},
                {0x1.d8f7208e6b826p-4, 0x1.d7ea3de45a9d6p-4, 0x1.d7ea3de45a9d7p-4},
                {-0x1.d8f7208e6b82dp-5, -0x1.d8b3df489987ap-5, -0x1.d8b3df489987bp-5},
                {0x1.d8f7208e6b82dp-5, 0x1.d8b3df489987ap-5, 0x1.d8b3df489987bp-5},
                {0x1.d8f7208e6b82dp-5, 0x1.d8b3df489987ap-5, 0x1.d8b3df489987bp-5},
                {-0x1.d8f7208e6b82dp-5, -0x1.d8b3df489987ap-5, -0x1.d8b3df489987bp-5},
                {0x1.d8f7208e6b82dp-4, 0x1.d7ea3de45a9ddp-4, 0x1.d7ea3de45a9dep-4},
                {-0x1.d8f7208e6b82dp-4, -0x1.d7ea3de45a9ddp-4, -0x1.d7ea3de45a9dep-4},
                {0x1.62b9586ad0a22p-3, 0x1.60f3faaf43028p-3, 0x1.60f3faaf43027p-3},
                {-0x1.62b9586ad0a22p-3, -0x1.60f3faaf43028p-3, -0x1.60f3faaf43027p-3},
                {0x1.d8f7208e6b82dp-3, 0x1.d4c5bc11d2376p-3, 0x1.d4c5bc11d2375p-3},
                {-0x1.d8f7208e6b82dp-3, -0x1.d4c5bc11d2376p-3, -0x1.d4c5bc11d2375p-3},
                {0x1.279a74590331cp-2, 0x1.2383ca8078e5ap-2, 0x1.2383ca8078e5bp-2},
                {-0x1.279a74590331cp-2, -0x1.2383ca8078e5ap-2, -0x1.2383ca8078e5bp-2},
                {0x1.62b9586ad0a22p-2, 0x1.5bac064658f3bp-2, 0x1.5bac064658f3cp-2},
                {-0x1.62b9586ad0a22p-2, -0x1.5bac064658f3bp-2, -0x1.5bac064658f3cp-2},
                {0x1.9dd83c7c9e128p-2, 0x1.92aba90aaf274p-2, 0x1.92aba90aaf275p-2},
                {-0x1.9dd83c7c9e128p-2, -0x1.92aba90aaf274p-2, -0x1.92aba90aaf275p-2},
                {0x1.d8f7208e6b82ep-2, 0x1.c853c78462de6p-2, 0x1.c853c78462de7p-2},
                {-0x1.d8f7208e6b82ep-2, -0x1.c853c78462de6p-2, -0x1.c853c78462de7p-2},
                {0x1.0a0b02501c799p-1, 0x1.fc769b77e5885p-2, 0x1.fc769b77e5884p-2},
                {-0x1.0a0b02501c799p-1, -0x1.fc769b77e5885p-2, -0x1.fc769b77e5884p-2},
                {0x1.3d3e35834faccp-1, 0x1.295463e769281p-1, 0x1.295463e769282p-1},
                {-0x1.3d3e35834faccp-1, -0x1.295463e769281p-1, -0x1.295463e769282p-1},
                {0x1.52e1f6ad9c27cp-1, 0x1.3aacff95a312p-1, 0x1.3aacff95a311fp-1},
                {-0x1.52e1f6ad9c27cp-1, -0x1.3aacff95a312p-1, -0x1.3aacff95a311fp-1},
                {0x1.6885b7d7e8a2cp-1, 0x1.4b75ba096fa52p-1, 0x1.4b75ba096fa51p-1},
                {-0x1.6885b7d7e8a2cp-1, -0x1.4b75ba096fa52p-1, -0x1.4b75ba096fa51p-1},
                {0x1.7e297902351dcp-1, 0x1.5ba6e6a8e7062p-1, 0x1.5ba6e6a8e7063p-1},
                {-0x1.7e297902351dcp-1, -0x1.5ba6e6a8e7062p-1, -0x1.5ba6e6a8e7063p-1},
                {0x1.93cd3a2c8198cp-1, 0x1.6b391e25bc26ap-1, 0x1.6b391e25bc269p-1},
                {-0x1.93cd3a2c8198cp-1, -0x1.6b391e25bc26ap-1, -0x1.6b391e25bc269p-1},
                {0x1.a970fb56ce13cp-1, 0x1.7a2541dfd4e73p-1, 0x1.7a2541dfd4e72p-1},
                {-0x1.a970fb56ce13cp-1, -0x1.7a2541dfd4e73p-1, -0x1.7a2541dfd4e72p-1},
                {0x1.bf14bc811a8ecp-1, 0x1.88647f26a6e0dp-1, 0x1.88647f26a6e0cp-1},
                {-0x1.bf14bc811a8ecp-1, -0x1.88647f26a6e0dp-1, -0x1.88647f26a6e0cp-1},
                {0x1.d4b87dab6709cp-1, 0x1.95f05257dbcb4p-1, 0x1.95f05257dbcb3p-1},
                {-0x1.d4b87dab6709cp-1, -0x1.95f05257dbcb4p-1, -0x1.95f05257dbcb3p-1},
                {0x1.ea5c3ed5b384cp-1, 0x1.a2c289d9d0558p-1, 0x1.a2c289d9d0559p-1},
                {-0x1.ea5c3ed5b384cp-1, -0x1.a2c289d9d0558p-1, -0x1.a2c289d9d0559p-1},
                {0x1.12bd9173c07abp0, 0x1.c1e9883373d7fp-1, 0x1.c1e9883373d7ep-1},
                {-0x1.12bd9173c07abp0, -0x1.c1e9883373d7fp-1, -0x1.c1e9883373d7ep-1},
                {0x1.257b22e780f56p0, 0x1.d294d1f96c7efp-1, 0x1.d294d1f96c7fp-1},
                {-0x1.257b22e780f56p0, -0x1.d294d1f96c7efp-1, -0x1.d294d1f96c7fp-1},
                {0x1.3838b45b41701p0, 0x1.e0c04a94e1733p-1, 0x1.e0c04a94e1734p-1},
                {-0x1.3838b45b41701p0, -0x1.e0c04a94e1733p-1, -0x1.e0c04a94e1734p-1},
                {0x1.4af645cf01eacp0, 0x1.ec5883b7b6cf7p-1, 0x1.ec5883b7b6cf8p-1},
                {-0x1.4af645cf01eacp0, -0x1.ec5883b7b6cf7p-1, -0x1.ec5883b7b6cf8p-1},
                {0x1.5db3d742c2657p0, 0x1.f54d971881ad8p-1, 0x1.f54d971881ad9p-1},
                {-0x1.5db3d742c2657p0, -0x1.f54d971881ad8p-1, -0x1.f54d971881ad9p-1},
                {0x1.707168b682e02p0, 0x1.fb933c40107fep-1, 0x1.fb933c40107ffp-1},
                {-0x1.707168b682e02p0, -0x1.fb933c40107fep-1, -0x1.fb933c40107ffp-1},
                {0x1.832efa2a435adp0, 0x1.ff20d961624e7p-1, 0x1.ff20d961624e8p-1},
                {-0x1.832efa2a435adp0, -0x1.ff20d961624e7p-1, -0x1.ff20d961624e8p-1},
                {0x1.95ec8b9e03d58p0, 0x1.fff18f24f3e4bp-1, 0x1.fff18f24f3e4cp-1},
                {-0x1.95ec8b9e03d58p0, -0x1.fff18f24f3e4bp-1, -0x1.fff18f24f3e4cp-1},
                {0x1.a8aa1d11c44ffp0, 0x1.fe043f57369d7p-1, 0x1.fe043f57369d6p-1},
                {-0x1.a8aa1d11c44ffp0, -0x1.fe043f57369d7p-1, -0x1.fe043f57369d6p-1},
                {0x1.04aff6d330942p0, 0x1.b3d3695acc413p-1, 0x1.b3d3695acc414p-1},
                {-0x1.04aff6d330942p0, -0x1.b3d3695acc413p-1, -0x1.b3d3695acc414p-1},
                {0x1.04b09e98dcdb4p0, 0x1.b3d41972dc806p-1, 0x1.b3d41972dc807p-1},
                {-0x1.04b09e98dcdb4p0, -0x1.b3d41972dc806p-1, -0x1.b3d41972dc807p-1},
                {0x1.04b1465e89226p0, 0x1.b3d4c98a318fbp-1, 0x1.b3d4c98a318fcp-1},
                {-0x1.04b1465e89226p0, -0x1.b3d4c98a318fbp-1, -0x1.b3d4c98a318fcp-1},
                {0x1.04b1ee2435698p0, 0x1.b3d579a0cb6eep-1, 0x1.b3d579a0cb6efp-1},
                {-0x1.04b1ee2435698p0, -0x1.b3d579a0cb6eep-1, -0x1.b3d579a0cb6efp-1},
                {0x1.04b295e9e1b0ap0, 0x1.b3d629b6aa1dap-1, 0x1.b3d629b6aa1d9p-1},
                {-0x1.04b295e9e1b0ap0, -0x1.b3d629b6aa1dap-1, -0x1.b3d629b6aa1d9p-1},
                {0x1.04b33daf8df7cp0, 0x1.b3d6d9cbcd9bap-1, 0x1.b3d6d9cbcd9b9p-1},
                {-0x1.04b33daf8df7cp0, -0x1.b3d6d9cbcd9bap-1, -0x1.b3d6d9cbcd9b9p-1},
                {0x1.04b3e5753a3eep0, 0x1.b3d789e035e89p-1, 0x1.b3d789e035e8ap-1},
                {-0x1.04b3e5753a3eep0, -0x1.b3d789e035e89p-1, -0x1.b3d789e035e8ap-1},
                {0x1.04b48d3ae686p0, 0x1.b3d839f3e3043p-1, 0x1.b3d839f3e3044p-1},
                {-0x1.04b48d3ae686p0, -0x1.b3d839f3e3043p-1, -0x1.b3d839f3e3044p-1},
                {0x1.04b5350092ccfp0, 0x1.b3d8ea06d4eep-1, 0x1.b3d8ea06d4ee1p-1},
                {-0x1.04b5350092ccfp0, -0x1.b3d8ea06d4eep-1, -0x1.b3d8ea06d4ee1p-1},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0p0, -0x0.0p0, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x1.279a74590331bp-1, 0x1.1773d561fd506p-1, 0x1.1773d561fd507p-1},
                {-0x1.279a74590331bp-1, -0x1.1773d561fd506p-1, -0x1.1773d561fd507p-1},
                {0x1.279a74590331cp-1, 0x1.1773d561fd507p-1, 0x1.1773d561fd508p-1},
                {-0x1.279a74590331cp-1, -0x1.1773d561fd507p-1, -0x1.1773d561fd508p-1},
                {0x1.279a74590331dp-1, 0x1.1773d561fd508p-1, 0x1.1773d561fd509p-1},
                {-0x1.279a74590331dp-1, -0x1.1773d561fd508p-1, -0x1.1773d561fd509p-1},
                {0x1.bb67ae8584ca9p0, 0x1.f95b8e7107419p-1, 0x1.f95b8e7107418p-1},
                {-0x1.bb67ae8584ca9p0, -0x1.f95b8e7107419p-1, -0x1.f95b8e7107418p-1},
                {0x1.bb67ae8584caap0, 0x1.f95b8e7107418p-1, 0x1.f95b8e7107419p-1},
                {-0x1.bb67ae8584caap0, -0x1.f95b8e7107418p-1, -0x1.f95b8e7107419p-1},
                {0x1.bb67ae8584cabp0, 0x1.f95b8e7107418p-1, 0x1.f95b8e7107419p-1},
                {-0x1.bb67ae8584cabp0, -0x1.f95b8e7107418p-1, -0x1.f95b8e7107419p-1},
                {0x1.bffffffffffffp-2, 0x1.b1d8305321616p-2, 0x1.b1d8305321615p-2},
                {-0x1.bffffffffffffp-2, -0x1.b1d8305321616p-2, -0x1.b1d8305321615p-2},
                {0x1.cp-2, 0x1.b1d8305321617p-2, 0x1.b1d8305321616p-2},
                {-0x1.cp-2, -0x1.b1d8305321617p-2, -0x1.b1d8305321616p-2},
                {0x1.c000000000001p-2, 0x1.b1d8305321617p-2, 0x1.b1d8305321618p-2},
                {-0x1.c000000000001p-2, -0x1.b1d8305321617p-2, -0x1.b1d8305321618p-2},
                {0x1.5ffffffffffffp-1, 0x1.44eb381cf386ap-1, 0x1.44eb381cf3869p-1},
                {-0x1.5ffffffffffffp-1, -0x1.44eb381cf386ap-1, -0x1.44eb381cf3869p-1},
                {0x1.6p-1, 0x1.44eb381cf386bp-1, 0x1.44eb381cf386ap-1},
                {-0x1.6p-1, -0x1.44eb381cf386bp-1, -0x1.44eb381cf386ap-1},
                {0x1.6000000000001p-1, 0x1.44eb381cf386cp-1, 0x1.44eb381cf386bp-1},
                {-0x1.6000000000001p-1, -0x1.44eb381cf386cp-1, -0x1.44eb381cf386bp-1},
                {0x1.2ffffffffffffp0, 0x1.dad902fa8ac86p-1, 0x1.dad902fa8ac87p-1},
                {-0x1.2ffffffffffffp0, -0x1.dad902fa8ac86p-1, -0x1.dad902fa8ac87p-1},
                {0x1.3p0, 0x1.dad902fa8ac87p-1, 0x1.dad902fa8ac88p-1},
                {-0x1.3p0, -0x1.dad902fa8ac87p-1, -0x1.dad902fa8ac88p-1},
                {0x1.3000000000001p0, 0x1.dad902fa8ac88p-1, 0x1.dad902fa8ac87p-1},
                {-0x1.3000000000001p0, -0x1.dad902fa8ac88p-1, -0x1.dad902fa8ac87p-1},
                {0x1.37fffffffffffp1, 0x1.4b707a7acdedp-1, 0x1.4b707a7acdecfp-1},
                {-0x1.37fffffffffffp1, -0x1.4b707a7acdedp-1, -0x1.4b707a7acdecfp-1},
                {0x1.38p1, 0x1.4b707a7acdecdp-1, 0x1.4b707a7acdeccp-1},
                {-0x1.38p1, -0x1.4b707a7acdecdp-1, -0x1.4b707a7acdeccp-1},
                {0x1.3800000000001p1, 0x1.4b707a7acdecap-1, 0x1.4b707a7acdec9p-1},
                {-0x1.3800000000001p1, -0x1.4b707a7acdecap-1, -0x1.4b707a7acdec9p-1},
                {0x1.069c8b46b3792p-4, 0x1.066e7eb76f5c6p-4, 0x1.066e7eb76f5c7p-4},
                {-0x1.069c8b46b3792p-4, -0x1.066e7eb76f5c6p-4, -0x1.066e7eb76f5c7p-4},
                {0x1.069c8b46b3792p-3, 0x1.05e4761ab8d8fp-3, 0x1.05e4761ab8d9p-3},
                {-0x1.069c8b46b3792p-3, -0x1.05e4761ab8d8fp-3, -0x1.05e4761ab8d9p-3},
                {0x1.89ead0ea0d35bp-3, 0x1.877e2cd4f6fdap-3, 0x1.877e2cd4f6fd9p-3},
                {-0x1.89ead0ea0d35bp-3, -0x1.877e2cd4f6fdap-3, -0x1.877e2cd4f6fd9p-3},
                {0x1.069c8b46b3792p-2, 0x1.03be06f97cbeep-2, 0x1.03be06f97cbefp-2},
                {-0x1.069c8b46b3792p-2, -0x1.03be06f97cbeep-2, -0x1.03be06f97cbefp-2},
                {0x1.4843ae1860576p-2, 0x1.42abba8c72fbcp-2, 0x1.42abba8c72fbbp-2},
                {-0x1.4843ae1860576p-2, -0x1.42abba8c72fbcp-2, -0x1.42abba8c72fbbp-2},
                {0x1.89ead0ea0d35ap-2, 0x1.8045fe64e62dcp-2, 0x1.8045fe64e62ddp-2},
                {-0x1.89ead0ea0d35ap-2, -0x1.8045fe64e62dcp-2, -0x1.8045fe64e62ddp-2},
                {0x1.cb91f3bbba13ep-2, 0x1.bc4c04d71abbfp-2, 0x1.bc4c04d71abbep-2},
                {-0x1.cb91f3bbba13ep-2, -0x1.bc4c04d71abbfp-2, -0x1.bc4c04d71abbep-2},
                {0x1.069c8b46b3791p-1, 0x1.f67ea975b86ap-2, 0x1.f67ea975b86a1p-2},
                {-0x1.069c8b46b3791p-1, -0x1.f67ea975b86ap-2, -0x1.f67ea975b86a1p-2},
                {0x1.27701caf89e83p-1, 0x1.175059bf0d425p-1, 0x1.175059bf0d426p-1},
                {-0x1.27701caf89e83p-1, -0x1.175059bf0d425p-1, -0x1.175059bf0d426p-1},
                {0x1.4843ae1860575p-1, 0x1.323b8b1fb4ba2p-1, 0x1.323b8b1fb4ba3p-1},
                {-0x1.4843ae1860575p-1, -0x1.323b8b1fb4ba2p-1, -0x1.323b8b1fb4ba3p-1},
                {0x1.69173f8136c67p-1, 0x1.4be4979c5efb3p-1, 0x1.4be4979c5efb4p-1},
                {-0x1.69173f8136c67p-1, -0x1.4be4979c5efb3p-1, -0x1.4be4979c5efb4p-1},
                {0x1.89ead0ea0d359p-1, 0x1.643080d67acc1p-1, 0x1.643080d67acc2p-1},
                {-0x1.89ead0ea0d359p-1, -0x1.643080d67acc1p-1, -0x1.643080d67acc2p-1},
                {0x1.aabe6252e3a4bp-1, 0x1.7b05b7b6c612ep-1, 0x1.7b05b7b6c612fp-1},
                {-0x1.aabe6252e3a4bp-1, -0x1.7b05b7b6c612ep-1, -0x1.7b05b7b6c612fp-1},
                {0x1.cb91f3bbba13dp-1, 0x1.904c37505de49p-1, 0x1.904c37505de48p-1},
                {-0x1.cb91f3bbba13dp-1, -0x1.904c37505de49p-1, -0x1.904c37505de48p-1},
                {0x1.ec6585249082fp-1, 0x1.a3ed9e252938ap-1, 0x1.a3ed9e252938bp-1},
                {-0x1.ec6585249082fp-1, -0x1.a3ed9e252938ap-1, -0x1.a3ed9e252938bp-1},
                {0x1.069c8b46b3791p0, 0x1.b5d545b109bf9p-1, 0x1.b5d545b109bfap-1},
                {-0x1.069c8b46b3791p0, -0x1.b5d545b109bf9p-1, -0x1.b5d545b109bfap-1},
                {0x1.170653fb1eb0ap0, 0x1.c5f058230e7fdp-1, 0x1.c5f058230e7fep-1},
                {-0x1.170653fb1eb0ap0, -0x1.c5f058230e7fdp-1, -0x1.c5f058230e7fep-1},
                {0x1.27701caf89e83p0, 0x1.d42de42dce134p-1, 0x1.d42de42dce135p-1},
                {-0x1.27701caf89e83p0, -0x1.d42de42dce134p-1, -0x1.d42de42dce135p-1},
                {0x1.37d9e563f51fcp0, 0x1.e07eeeda109cbp-1, 0x1.e07eeeda109ccp-1},
                {-0x1.37d9e563f51fcp0, -0x1.e07eeeda109cbp-1, -0x1.e07eeeda109ccp-1},
                {0x1.4843ae1860575p0, 0x1.ead6834909b93p-1, 0x1.ead6834909b94p-1},
                {-0x1.4843ae1860575p0, -0x1.ead6834909b93p-1, -0x1.ead6834909b94p-1},
                {0x1.58ad76cccb8eep0, 0x1.f329c0558e968p-1, 0x1.f329c0558e967p-1},
                {-0x1.58ad76cccb8eep0, -0x1.f329c0558e968p-1, -0x1.f329c0558e967p-1},
                {0x1.69173f8136c67p0, 0x1.f96fe405f1ac6p-1, 0x1.f96fe405f1ac5p-1},
                {-0x1.69173f8136c67p0, -0x1.f96fe405f1ac6p-1, -0x1.f96fe405f1ac5p-1},
                {0x1.79810835a1fep0, 0x1.fda254c27a01fp-1, 0x1.fda254c27a02p-1},
                {-0x1.79810835a1fep0, -0x1.fda254c27a01fp-1, -0x1.fda254c27a02p-1},
                {0x1.89ead0ea0d359p0, 0x1.ffbca846c4fcap-1, 0x1.ffbca846c4fc9p-1},
                {-0x1.89ead0ea0d359p0, -0x1.ffbca846c4fcap-1, -0x1.ffbca846c4fc9p-1},
                {0x1.9a54999e786d2p0, 0x1.ffbca846c4fcap-1, 0x1.ffbca846c4fc9p-1},
                {-0x1.9a54999e786d2p0, -0x1.ffbca846c4fcap-1, -0x1.ffbca846c4fc9p-1},
                {0x1.aabe6252e3a4bp0, 0x1.fda254c27a02p-1, 0x1.fda254c27a021p-1},
                {-0x1.aabe6252e3a4bp0, -0x1.fda254c27a02p-1, -0x1.fda254c27a021p-1},
                {0x1.bb282b074edc4p0, 0x1.f96fe405f1ac8p-1, 0x1.f96fe405f1ac7p-1},
                {-0x1.bb282b074edc4p0, -0x1.f96fe405f1ac8p-1, -0x1.f96fe405f1ac7p-1},
                {0x1.cb91f3bbba13dp0, 0x1.f329c0558e96ap-1, 0x1.f329c0558e96bp-1},
                {-0x1.cb91f3bbba13dp0, -0x1.f329c0558e96ap-1, -0x1.f329c0558e96bp-1},
                {0x1.dbfbbc70254b6p0, 0x1.ead6834909b96p-1, 0x1.ead6834909b97p-1},
                {-0x1.dbfbbc70254b6p0, -0x1.ead6834909b96p-1, -0x1.ead6834909b97p-1},
                {0x1.ec6585249082fp0, 0x1.e07eeeda109cfp-1, 0x1.e07eeeda109dp-1},
                {-0x1.ec6585249082fp0, -0x1.e07eeeda109cfp-1, -0x1.e07eeeda109dp-1},
                {0x1.fccf4dd8fbba8p0, 0x1.d42de42dce139p-1, 0x1.d42de42dce138p-1},
                {-0x1.fccf4dd8fbba8p0, -0x1.d42de42dce139p-1, -0x1.d42de42dce138p-1},
                {0x1.069c8b46b3791p1, 0x1.c5f058230e801p-1, 0x1.c5f058230e802p-1},
                {-0x1.069c8b46b3791p1, -0x1.c5f058230e801p-1, -0x1.c5f058230e802p-1},
                {0x1.0ed16fa0e914ep1, 0x1.b5d545b109bfdp-1, 0x1.b5d545b109bfcp-1},
                {-0x1.0ed16fa0e914ep1, -0x1.b5d545b109bfdp-1, -0x1.b5d545b109bfcp-1},
                {0x1.170653fb1eb0bp1, 0x1.a3ed9e252938dp-1, 0x1.a3ed9e252938ep-1},
                {-0x1.170653fb1eb0bp1, -0x1.a3ed9e252938dp-1, -0x1.a3ed9e252938ep-1},
                {0x1.1f3b3855544c8p1, 0x1.904c37505de4cp-1, 0x1.904c37505de4bp-1},
                {-0x1.1f3b3855544c8p1, -0x1.904c37505de4cp-1, -0x1.904c37505de4bp-1},
                {0x1.27701caf89e85p1, 0x1.7b05b7b6c613p-1, 0x1.7b05b7b6c612fp-1},
                {-0x1.27701caf89e85p1, -0x1.7b05b7b6c613p-1, -0x1.7b05b7b6c612fp-1},
                {0x1.2fa50109bf842p1, 0x1.643080d67acc1p-1, 0x1.643080d67acc2p-1},
                {-0x1.2fa50109bf842p1, -0x1.643080d67acc1p-1, -0x1.643080d67acc2p-1},
                {0x1.37d9e563f51ffp1, 0x1.4be4979c5efb2p-1, 0x1.4be4979c5efb1p-1},
                {-0x1.37d9e563f51ffp1, -0x1.4be4979c5efb2p-1, -0x1.4be4979c5efb1p-1},
                {0x1.400ec9be2abbcp1, 0x1.323b8b1fb4b9fp-1, 0x1.323b8b1fb4b9ep-1},
                {-0x1.400ec9be2abbcp1, -0x1.323b8b1fb4b9fp-1, -0x1.323b8b1fb4b9ep-1},
                {0x1.4843ae1860579p1, 0x1.175059bf0d42p-1, 0x1.175059bf0d421p-1},
                {-0x1.4843ae1860579p1, -0x1.175059bf0d42p-1, -0x1.175059bf0d421p-1},
                {0x1.5078927295f36p1, 0x1.f67ea975b8692p-2, 0x1.f67ea975b8693p-2},
                {-0x1.5078927295f36p1, -0x1.f67ea975b8692p-2, -0x1.f67ea975b8693p-2},
                {0x1.58ad76cccb8f3p1, 0x1.bc4c04d71abadp-2, 0x1.bc4c04d71abaep-2},
                {-0x1.58ad76cccb8f3p1, -0x1.bc4c04d71abadp-2, -0x1.bc4c04d71abaep-2},
                {0x1.60e25b27012bp1, 0x1.8045fe64e62c6p-2, 0x1.8045fe64e62c7p-2},
                {-0x1.60e25b27012bp1, -0x1.8045fe64e62c6p-2, -0x1.8045fe64e62c7p-2},
                {0x1.69173f8136c6dp1, 0x1.42abba8c72fa1p-2, 0x1.42abba8c72fa2p-2},
                {-0x1.69173f8136c6dp1, -0x1.42abba8c72fa1p-2, -0x1.42abba8c72fa2p-2},
                {0x1.714c23db6c62ap1, 0x1.03be06f97cbdp-2, 0x1.03be06f97cbcfp-2},
                {-0x1.714c23db6c62ap1, -0x1.03be06f97cbdp-2, -0x1.03be06f97cbcfp-2},
                {0x1.79810835a1fe7p1, 0x1.877e2cd4f6f94p-3, 0x1.877e2cd4f6f95p-3},
                {-0x1.79810835a1fe7p1, -0x1.877e2cd4f6f94p-3, -0x1.877e2cd4f6f95p-3},
                {0x1.81b5ec8fd79a4p1, 0x1.05e4761ab8d42p-3, 0x1.05e4761ab8d43p-3},
                {-0x1.81b5ec8fd79a4p1, -0x1.05e4761ab8d42p-3, -0x1.05e4761ab8d43p-3},
                {0x1.89ead0ea0d35bp1, 0x1.066e7eb76f5ddp-4, 0x1.066e7eb76f5dep-4},
                {-0x1.89ead0ea0d35bp1, -0x1.066e7eb76f5ddp-4, -0x1.066e7eb76f5dep-4},
                {-0x1.81b5ec8fd799fp2, 0x1.03be06f97cbf1p-2, 0x1.03be06f97cbfp-2},
                {0x1.81b5ec8fd799fp2, -0x1.03be06f97cbf1p-2, -0x1.03be06f97cbfp-2},
                {-0x1.714c23db6c626p2, 0x1.f67ea975b86a2p-2, 0x1.f67ea975b86a3p-2},
                {0x1.714c23db6c626p2, -0x1.f67ea975b86a2p-2, -0x1.f67ea975b86a3p-2},
                {-0x1.60e25b27012adp2, 0x1.643080d67acc2p-1, 0x1.643080d67acc3p-1},
                {0x1.60e25b27012adp2, -0x1.643080d67acc2p-1, -0x1.643080d67acc3p-1},
                {-0x1.5078927295f34p2, 0x1.b5d545b109bf9p-1, 0x1.b5d545b109bfap-1},
                {0x1.5078927295f34p2, -0x1.b5d545b109bf9p-1, -0x1.b5d545b109bfap-1},
                {-0x1.400ec9be2abbbp2, 0x1.ead6834909b93p-1, 0x1.ead6834909b94p-1},
                {0x1.400ec9be2abbbp2, -0x1.ead6834909b93p-1, -0x1.ead6834909b94p-1},
                {-0x1.2fa50109bf842p2, 0x1.ffbca846c4fcap-1, 0x1.ffbca846c4fc9p-1},
                {0x1.2fa50109bf842p2, -0x1.ffbca846c4fcap-1, -0x1.ffbca846c4fc9p-1},
                {-0x1.1f3b3855544c9p2, 0x1.f329c0558e96ap-1, 0x1.f329c0558e96bp-1},
                {0x1.1f3b3855544c9p2, -0x1.f329c0558e96ap-1, -0x1.f329c0558e96bp-1},
                {-0x1.0ed16fa0e915p2, 0x1.c5f058230e802p-1, 0x1.c5f058230e803p-1},
                {0x1.0ed16fa0e915p2, -0x1.c5f058230e802p-1, -0x1.c5f058230e803p-1},
                {-0x1.fccf4dd8fbbaep1, 0x1.7b05b7b6c6136p-1, 0x1.7b05b7b6c6137p-1},
                {0x1.fccf4dd8fbbaep1, -0x1.7b05b7b6c6136p-1, -0x1.7b05b7b6c6137p-1},
                {-0x1.dbfbbc70254bcp1, 0x1.175059bf0d42fp-1, 0x1.175059bf0d43p-1},
                {0x1.dbfbbc70254bcp1, -0x1.175059bf0d42fp-1, -0x1.175059bf0d43p-1},
                {-0x1.bb282b074edcap1, 0x1.42abba8c72fd2p-2, 0x1.42abba8c72fd3p-2},
                {0x1.bb282b074edcap1, -0x1.42abba8c72fd2p-2, -0x1.42abba8c72fd3p-2},
                {-0x1.9a54999e786d8p1, 0x1.066e7eb76f62bp-4, 0x1.066e7eb76f62cp-4},
                {0x1.9a54999e786d8p1, -0x1.066e7eb76f62bp-4, -0x1.066e7eb76f62cp-4},
                {-0x1.79810835a1fe6p1, -0x1.877e2cd4f6fa4p-3, -0x1.877e2cd4f6fa5p-3},
                {0x1.79810835a1fe6p1, 0x1.877e2cd4f6fa4p-3, 0x1.877e2cd4f6fa5p-3},
                {-0x1.58ad76cccb8f4p1, -0x1.bc4c04d71aba6p-2, -0x1.bc4c04d71aba5p-2},
                {0x1.58ad76cccb8f4p1, 0x1.bc4c04d71aba6p-2, 0x1.bc4c04d71aba5p-2},
                {-0x1.37d9e563f5202p1, -0x1.4be4979c5efa8p-1, -0x1.4be4979c5efa9p-1},
                {0x1.37d9e563f5202p1, 0x1.4be4979c5efa8p-1, 0x1.4be4979c5efa9p-1},
                {-0x1.170653fb1eb1p1, -0x1.a3ed9e2529382p-1, -0x1.a3ed9e2529383p-1},
                {0x1.170653fb1eb1p1, 0x1.a3ed9e2529382p-1, 0x1.a3ed9e2529383p-1},
                {-0x1.ec6585249083cp0, -0x1.e07eeeda109c6p-1, -0x1.e07eeeda109c7p-1},
                {0x1.ec6585249083cp0, 0x1.e07eeeda109c6p-1, 0x1.e07eeeda109c7p-1},
                {-0x1.aabe6252e3a58p0, -0x1.fda254c27a01ep-1, -0x1.fda254c27a01dp-1},
                {0x1.aabe6252e3a58p0, 0x1.fda254c27a01ep-1, 0x1.fda254c27a01dp-1},
                {-0x1.69173f8136c74p0, -0x1.f96fe405f1acap-1, -0x1.f96fe405f1acbp-1},
                {0x1.69173f8136c74p0, 0x1.f96fe405f1acap-1, 0x1.f96fe405f1acbp-1},
                {-0x1.27701caf89e9p0, -0x1.d42de42dce13fp-1, -0x1.d42de42dce13ep-1},
                {0x1.27701caf89e9p0, 0x1.d42de42dce13fp-1, 0x1.d42de42dce13ep-1},
                {-0x1.cb91f3bbba157p-1, -0x1.904c37505de59p-1, -0x1.904c37505de5ap-1},
                {0x1.cb91f3bbba157p-1, 0x1.904c37505de59p-1, 0x1.904c37505de5ap-1},
                {-0x1.4843ae186058ep-1, -0x1.323b8b1fb4bb6p-1, -0x1.323b8b1fb4bb7p-1},
                {0x1.4843ae186058ep-1, 0x1.323b8b1fb4bb6p-1, 0x1.323b8b1fb4bb7p-1},
                {-0x1.89ead0ea0d38ap-2, -0x1.8045fe64e6309p-2, -0x1.8045fe64e6308p-2},
                {0x1.89ead0ea0d38ap-2, 0x1.8045fe64e6309p-2, 0x1.8045fe64e6308p-2},
                {-0x1.069c8b46b37fp-3, -0x1.05e4761ab8decp-3, -0x1.05e4761ab8dedp-3},
                {0x1.069c8b46b37fp-3, 0x1.05e4761ab8decp-3, 0x1.05e4761ab8dedp-3},
                {0x1.069c8b46b3734p-3, 0x1.05e4761ab8d32p-3, 0x1.05e4761ab8d31p-3},
                {-0x1.069c8b46b3734p-3, -0x1.05e4761ab8d32p-3, -0x1.05e4761ab8d31p-3},
                {0x1.89ead0ea0d32cp-2, 0x1.8045fe64e62b2p-2, 0x1.8045fe64e62b1p-2},
                {-0x1.89ead0ea0d32cp-2, -0x1.8045fe64e62b2p-2, -0x1.8045fe64e62b1p-2},
                {0x1.4843ae186055fp-1, 0x1.323b8b1fb4b9p-1, 0x1.323b8b1fb4b91p-1},
                {-0x1.4843ae186055fp-1, -0x1.323b8b1fb4b9p-1, -0x1.323b8b1fb4b91p-1},
                {0x1.cb91f3bbba128p-1, 0x1.904c37505de3cp-1, 0x1.904c37505de3bp-1},
                {-0x1.cb91f3bbba128p-1, -0x1.904c37505de3cp-1, -0x1.904c37505de3bp-1},
                {0x1.27701caf89e78p0, 0x1.d42de42dce12bp-1, 0x1.d42de42dce12cp-1},
                {-0x1.27701caf89e78p0, -0x1.d42de42dce12bp-1, -0x1.d42de42dce12cp-1},
                {0x1.69173f8136c5cp0, 0x1.f96fe405f1ac2p-1, 0x1.f96fe405f1ac3p-1},
                {-0x1.69173f8136c5cp0, -0x1.f96fe405f1ac2p-1, -0x1.f96fe405f1ac3p-1},
                {0x1.aabe6252e3a4p0, 0x1.fda254c27a022p-1, 0x1.fda254c27a023p-1},
                {-0x1.aabe6252e3a4p0, -0x1.fda254c27a022p-1, -0x1.fda254c27a023p-1},
                {0x1.ec65852490824p0, 0x1.e07eeeda109d7p-1, 0x1.e07eeeda109d6p-1},
                {-0x1.ec65852490824p0, -0x1.e07eeeda109d7p-1, -0x1.e07eeeda109d6p-1},
                {0x1.170653fb1eb04p1, 0x1.a3ed9e252939ep-1, 0x1.a3ed9e252939dp-1},
                {-0x1.170653fb1eb04p1, -0x1.a3ed9e252939ep-1, -0x1.a3ed9e252939dp-1},
                {0x1.37d9e563f51f6p1, 0x1.4be4979c5efcdp-1, 0x1.4be4979c5efccp-1},
                {-0x1.37d9e563f51f6p1, -0x1.4be4979c5efcdp-1, -0x1.4be4979c5efccp-1},
                {0x1.58ad76cccb8e8p1, 0x1.bc4c04d71abfcp-2, 0x1.bc4c04d71abfdp-2},
                {-0x1.58ad76cccb8e8p1, -0x1.bc4c04d71abfcp-2, -0x1.bc4c04d71abfdp-2},
                {0x1.79810835a1fdap1, 0x1.877e2cd4f7061p-3, 0x1.877e2cd4f706p-3},
                {-0x1.79810835a1fdap1, -0x1.877e2cd4f7061p-3, -0x1.877e2cd4f706p-3},
                {0x1.9a54999e786ccp1, -0x1.066e7eb76f4acp-4, -0x1.066e7eb76f4adp-4},
                {-0x1.9a54999e786ccp1, 0x1.066e7eb76f4acp-4, 0x1.066e7eb76f4adp-4},
                {0x1.bb282b074edbep1, -0x1.42abba8c72f77p-2, -0x1.42abba8c72f78p-2},
                {-0x1.bb282b074edbep1, 0x1.42abba8c72f77p-2, 0x1.42abba8c72f78p-2},
                {0x1.dbfbbc70254bp1, -0x1.175059bf0d407p-1, -0x1.175059bf0d406p-1},
                {-0x1.dbfbbc70254bp1, 0x1.175059bf0d407p-1, 0x1.175059bf0d406p-1},
                {0x1.fccf4dd8fbba2p1, -0x1.7b05b7b6c6116p-1, -0x1.7b05b7b6c6117p-1},
                {-0x1.fccf4dd8fbba2p1, 0x1.7b05b7b6c6116p-1, 0x1.7b05b7b6c6117p-1},
                {0x1.0ed16fa0e914ap2, -0x1.c5f058230e7ecp-1, -0x1.c5f058230e7ebp-1},
                {-0x1.0ed16fa0e914ap2, 0x1.c5f058230e7ecp-1, 0x1.c5f058230e7ebp-1},
                {0x1.1f3b3855544c3p2, -0x1.f329c0558e96p-1, -0x1.f329c0558e95fp-1},
                {-0x1.1f3b3855544c3p2, 0x1.f329c0558e96p-1, 0x1.f329c0558e95fp-1},
                {0x1.2fa50109bf83cp2, -0x1.ffbca846c4fcbp-1, -0x1.ffbca846c4fccp-1},
                {-0x1.2fa50109bf83cp2, 0x1.ffbca846c4fcbp-1, 0x1.ffbca846c4fccp-1},
                {0x1.400ec9be2abb5p2, -0x1.ead6834909ba1p-1, -0x1.ead6834909bap-1},
                {-0x1.400ec9be2abb5p2, 0x1.ead6834909ba1p-1, 0x1.ead6834909bap-1},
                {0x1.5078927295f2ep2, -0x1.b5d545b109c12p-1, -0x1.b5d545b109c13p-1},
                {-0x1.5078927295f2ep2, 0x1.b5d545b109c12p-1, 0x1.b5d545b109c13p-1},
                {0x1.60e25b27012a7p2, -0x1.643080d67ace4p-1, -0x1.643080d67ace5p-1},
                {-0x1.60e25b27012a7p2, 0x1.643080d67ace4p-1, 0x1.643080d67ace5p-1},
                {0x1.714c23db6c62p2, -0x1.f67ea975b86f6p-2, -0x1.f67ea975b86f5p-2},
                {-0x1.714c23db6c62p2, 0x1.f67ea975b86f6p-2, 0x1.f67ea975b86f5p-2},
                {0x1.81b5ec8fd7999p2, -0x1.03be06f97cc4dp-2, -0x1.03be06f97cc4ep-2},
                {-0x1.81b5ec8fd7999p2, 0x1.03be06f97cc4dp-2, 0x1.03be06f97cc4ep-2},
                {0x1.effffffffffffp-5, 0x1.efb26ef930c4cp-5, 0x1.efb26ef930c4dp-5},
                {-0x1.effffffffffffp-5, -0x1.efb26ef930c4cp-5, -0x1.efb26ef930c4dp-5},
                {0x1.fp-5, 0x1.efb26ef930c4dp-5, 0x1.efb26ef930c4ep-5},
                {-0x1.fp-5, -0x1.efb26ef930c4dp-5, -0x1.efb26ef930c4ep-5},
                {0x1.f000000000001p-5, 0x1.efb26ef930c4ep-5, 0x1.efb26ef930c4fp-5},
                {-0x1.f000000000001p-5, -0x1.efb26ef930c4ep-5, -0x1.efb26ef930c4fp-5},
                {0x1.f7fffffffffffp-4, 0x1.f6baaa131de63p-4, 0x1.f6baaa131de64p-4},
                {-0x1.f7fffffffffffp-4, -0x1.f6baaa131de63p-4, -0x1.f6baaa131de64p-4},
                {0x1.f8p-4, 0x1.f6baaa131de64p-4, 0x1.f6baaa131de65p-4},
                {-0x1.f8p-4, -0x1.f6baaa131de64p-4, -0x1.f6baaa131de65p-4},
                {0x1.f800000000001p-4, 0x1.f6baaa131de65p-4, 0x1.f6baaa131de66p-4},
                {-0x1.f800000000001p-4, -0x1.f6baaa131de65p-4, -0x1.f6baaa131de66p-4},
                {0x1.4bfffffffffffp-3, 0x1.4a8c3b4e9c7ffp-3, 0x1.4a8c3b4e9c8p-3},
                {-0x1.4bfffffffffffp-3, -0x1.4a8c3b4e9c7ffp-3, -0x1.4a8c3b4e9c8p-3},
                {0x1.4cp-3, 0x1.4a8c3b4e9c8p-3, 0x1.4a8c3b4e9c7ffp-3},
                {-0x1.4cp-3, -0x1.4a8c3b4e9c8p-3, -0x1.4a8c3b4e9c7ffp-3},
                {0x1.4c00000000001p-3, 0x1.4a8c3b4e9c801p-3, 0x1.4a8c3b4e9c8p-3},
                {-0x1.4c00000000001p-3, -0x1.4a8c3b4e9c801p-3, -0x1.4a8c3b4e9c8p-3},
                {0x1.3333333333332p-2, 0x1.2e9cd95baba32p-2, 0x1.2e9cd95baba33p-2},
                {-0x1.3333333333332p-2, -0x1.2e9cd95baba32p-2, -0x1.2e9cd95baba33p-2},
                {0x1.3333333333333p-2, 0x1.2e9cd95baba33p-2, 0x1.2e9cd95baba34p-2},
                {-0x1.3333333333333p-2, -0x1.2e9cd95baba33p-2, -0x1.2e9cd95baba34p-2},
                {0x1.3333333333334p-2, 0x1.2e9cd95baba34p-2, 0x1.2e9cd95baba35p-2},
                {-0x1.3333333333334p-2, -0x1.2e9cd95baba34p-2, -0x1.2e9cd95baba35p-2},
                {0x1.594317acc4ef8p-1, 0x1.3faefc7a5466fp-1, 0x1.3faefc7a5466ep-1},
                {-0x1.594317acc4ef8p-1, -0x1.3faefc7a5466fp-1, -0x1.3faefc7a5466ep-1},
                {0x1.594317acc4ef9p-1, 0x1.3faefc7a5467p-1, 0x1.3faefc7a5466fp-1},
                {-0x1.594317acc4ef9p-1, -0x1.3faefc7a5467p-1, -0x1.3faefc7a5466fp-1},
                {0x1.594317acc4efap-1, 0x1.3faefc7a5467p-1, 0x1.3faefc7a54671p-1},
                {-0x1.594317acc4efap-1, -0x1.3faefc7a5467p-1, -0x1.3faefc7a54671p-1},
                {0x1.8ffffffffffffp-1, 0x1.6888a4e134b2ep-1, 0x1.6888a4e134b2dp-1},
                {-0x1.8ffffffffffffp-1, -0x1.6888a4e134b2ep-1, -0x1.6888a4e134b2dp-1},
                {0x1.9p-1, 0x1.6888a4e134b2fp-1, 0x1.6888a4e134b2ep-1},
                {-0x1.9p-1, -0x1.6888a4e134b2fp-1, -0x1.6888a4e134b2ep-1},
                {0x1.9000000000001p-1, 0x1.6888a4e134b2fp-1, 0x1.6888a4e134b3p-1},
                {-0x1.9000000000001p-1, -0x1.6888a4e134b2fp-1, -0x1.6888a4e134b3p-1},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0p0, -0x0.0p0, -0x0.0p0},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x1.921fb54442d17p-5, 0x1.91f65f10dd813p-5, 0x1.91f65f10dd812p-5},
                {-0x1.921fb54442d17p-5, -0x1.91f65f10dd813p-5, -0x1.91f65f10dd812p-5},
                {0x1.921fb54442d18p-5, 0x1.91f65f10dd814p-5, 0x1.91f65f10dd813p-5},
                {-0x1.921fb54442d18p-5, -0x1.91f65f10dd814p-5, -0x1.91f65f10dd813p-5},
                {0x1.921fb54442d19p-5, 0x1.91f65f10dd815p-5, 0x1.91f65f10dd814p-5},
                {-0x1.921fb54442d19p-5, -0x1.91f65f10dd815p-5, -0x1.91f65f10dd814p-5},
                {0x1.921fb54442d17p-4, 0x1.917a6bc29b42bp-4, 0x1.917a6bc29b42ap-4},
                {-0x1.921fb54442d17p-4, -0x1.917a6bc29b42bp-4, -0x1.917a6bc29b42ap-4},
                {0x1.921fb54442d18p-4, 0x1.917a6bc29b42cp-4, 0x1.917a6bc29b42bp-4},
                {-0x1.921fb54442d18p-4, -0x1.917a6bc29b42cp-4, -0x1.917a6bc29b42bp-4},
                {0x1.921fb54442d19p-4, 0x1.917a6bc29b42dp-4, 0x1.917a6bc29b42cp-4},
                {-0x1.921fb54442d19p-4, -0x1.917a6bc29b42dp-4, -0x1.917a6bc29b42cp-4},
                {0x1.921fb54442d17p-3, 0x1.8f8b83c69a609p-3, 0x1.8f8b83c69a60ap-3},
                {-0x1.921fb54442d17p-3, -0x1.8f8b83c69a609p-3, -0x1.8f8b83c69a60ap-3},
                {0x1.921fb54442d18p-3, 0x1.8f8b83c69a60ap-3, 0x1.8f8b83c69a60bp-3},
                {-0x1.921fb54442d18p-3, -0x1.8f8b83c69a60ap-3, -0x1.8f8b83c69a60bp-3},
                {0x1.921fb54442d19p-3, 0x1.8f8b83c69a60bp-3, 0x1.8f8b83c69a60cp-3},
                {-0x1.921fb54442d19p-3, -0x1.8f8b83c69a60bp-3, -0x1.8f8b83c69a60cp-3},
                {0x1.921fb54442d17p-2, 0x1.87de2a6aea962p-2, 0x1.87de2a6aea961p-2},
                {-0x1.921fb54442d17p-2, -0x1.87de2a6aea962p-2, -0x1.87de2a6aea961p-2},
                {0x1.921fb54442d18p-2, 0x1.87de2a6aea963p-2, 0x1.87de2a6aea962p-2},
                {-0x1.921fb54442d18p-2, -0x1.87de2a6aea963p-2, -0x1.87de2a6aea962p-2},
                {0x1.921fb54442d19p-2, 0x1.87de2a6aea964p-2, 0x1.87de2a6aea963p-2},
                {-0x1.921fb54442d19p-2, -0x1.87de2a6aea964p-2, -0x1.87de2a6aea963p-2},
                {0x1.921fb54442d17p-1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcbp-1},
                {-0x1.921fb54442d17p-1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcbp-1},
                {0x1.921fb54442d18p-1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcdp-1},
                {-0x1.921fb54442d18p-1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcdp-1},
                {0x1.921fb54442d19p-1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bcep-1},
                {-0x1.921fb54442d19p-1, -0x1.6a09e667f3bcdp-1, -0x1.6a09e667f3bcep-1},
                {0x1.921fb54442d17p0, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p0, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p0, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p0, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p0, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p0, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p1, 0x1.469898cc51702p-51, 0x1.469898cc51701p-51},
                {-0x1.921fb54442d17p1, -0x1.469898cc51702p-51, -0x1.469898cc51701p-51},
                {0x1.921fb54442d18p1, 0x1.1a62633145c07p-53, 0x1.1a62633145c06p-53},
                {-0x1.921fb54442d18p1, -0x1.1a62633145c07p-53, -0x1.1a62633145c06p-53},
                {0x1.921fb54442d19p1, -0x1.72cece675d1fdp-52, -0x1.72cece675d1fcp-52},
                {-0x1.921fb54442d19p1, 0x1.72cece675d1fdp-52, 0x1.72cece675d1fcp-52},
                {0x1.921fb54442d17p2, -0x1.469898cc51702p-50, -0x1.469898cc51701p-50},
                {-0x1.921fb54442d17p2, 0x1.469898cc51702p-50, 0x1.469898cc51701p-50},
                {0x1.921fb54442d18p2, -0x1.1a62633145c07p-52, -0x1.1a62633145c06p-52},
                {-0x1.921fb54442d18p2, 0x1.1a62633145c07p-52, 0x1.1a62633145c06p-52},
                {0x1.921fb54442d19p2, 0x1.72cece675d1fdp-51, 0x1.72cece675d1fcp-51},
                {-0x1.921fb54442d19p2, -0x1.72cece675d1fdp-51, -0x1.72cece675d1fcp-51},
                {0x1.921fb54442d17p3, -0x1.469898cc51702p-49, -0x1.469898cc51701p-49},
                {-0x1.921fb54442d17p3, 0x1.469898cc51702p-49, 0x1.469898cc51701p-49},
                {0x1.921fb54442d18p3, -0x1.1a62633145c07p-51, -0x1.1a62633145c06p-51},
                {-0x1.921fb54442d18p3, 0x1.1a62633145c07p-51, 0x1.1a62633145c06p-51},
                {0x1.921fb54442d19p3, 0x1.72cece675d1fdp-50, 0x1.72cece675d1fcp-50},
                {-0x1.921fb54442d19p3, -0x1.72cece675d1fdp-50, -0x1.72cece675d1fcp-50},
                {0x1.921fb54442d17p4, -0x1.469898cc51702p-48, -0x1.469898cc51701p-48},
                {-0x1.921fb54442d17p4, 0x1.469898cc51702p-48, 0x1.469898cc51701p-48},
                {0x1.921fb54442d18p4, -0x1.1a62633145c07p-50, -0x1.1a62633145c06p-50},
                {-0x1.921fb54442d18p4, 0x1.1a62633145c07p-50, 0x1.1a62633145c06p-50},
                {0x1.921fb54442d19p4, 0x1.72cece675d1fdp-49, 0x1.72cece675d1fcp-49},
                {-0x1.921fb54442d19p4, -0x1.72cece675d1fdp-49, -0x1.72cece675d1fcp-49},
                {0x1.921fb54442d17p5, -0x1.469898cc51702p-47, -0x1.469898cc51701p-47},
                {-0x1.921fb54442d17p5, 0x1.469898cc51702p-47, 0x1.469898cc51701p-47},
                {0x1.921fb54442d18p5, -0x1.1a62633145c07p-49, -0x1.1a62633145c06p-49},
                {-0x1.921fb54442d18p5, 0x1.1a62633145c07p-49, 0x1.1a62633145c06p-49},
                {0x1.921fb54442d19p5, 0x1.72cece675d1fdp-48, 0x1.72cece675d1fcp-48},
                {-0x1.921fb54442d19p5, -0x1.72cece675d1fdp-48, -0x1.72cece675d1fcp-48},
                {0x1.921fb54442d17p6, -0x1.469898cc51702p-46, -0x1.469898cc51701p-46},
                {-0x1.921fb54442d17p6, 0x1.469898cc51702p-46, 0x1.469898cc51701p-46},
                {0x1.921fb54442d18p6, -0x1.1a62633145c07p-48, -0x1.1a62633145c06p-48},
                {-0x1.921fb54442d18p6, 0x1.1a62633145c07p-48, 0x1.1a62633145c06p-48},
                {0x1.921fb54442d19p6, 0x1.72cece675d1fdp-47, 0x1.72cece675d1fcp-47},
                {-0x1.921fb54442d19p6, -0x1.72cece675d1fdp-47, -0x1.72cece675d1fcp-47},
                {0x1.921fb54442d17p7, -0x1.469898cc51702p-45, -0x1.469898cc51701p-45},
                {-0x1.921fb54442d17p7, 0x1.469898cc51702p-45, 0x1.469898cc51701p-45},
                {0x1.921fb54442d18p7, -0x1.1a62633145c07p-47, -0x1.1a62633145c06p-47},
                {-0x1.921fb54442d18p7, 0x1.1a62633145c07p-47, 0x1.1a62633145c06p-47},
                {0x1.921fb54442d19p7, 0x1.72cece675d1fdp-46, 0x1.72cece675d1fcp-46},
                {-0x1.921fb54442d19p7, -0x1.72cece675d1fdp-46, -0x1.72cece675d1fcp-46},
                {0x1.2d97c7f3321d1p1, 0x1.6a09e667f3bdp-1, 0x1.6a09e667f3bcfp-1},
                {-0x1.2d97c7f3321d1p1, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bcfp-1},
                {0x1.2d97c7f3321d2p1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bcep-1},
                {-0x1.2d97c7f3321d2p1, -0x1.6a09e667f3bcdp-1, -0x1.6a09e667f3bcep-1},
                {0x1.2d97c7f3321d3p1, 0x1.6a09e667f3bcap-1, 0x1.6a09e667f3bcbp-1},
                {-0x1.2d97c7f3321d3p1, -0x1.6a09e667f3bcap-1, -0x1.6a09e667f3bcbp-1},
                {0x1.f6a7a2955385dp1, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bc8p-1},
                {-0x1.f6a7a2955385dp1, 0x1.6a09e667f3bc9p-1, 0x1.6a09e667f3bc8p-1},
                {0x1.f6a7a2955385ep1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcbp-1},
                {-0x1.f6a7a2955385ep1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcbp-1},
                {0x1.f6a7a2955385fp1, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcfp-1},
                {-0x1.f6a7a2955385fp1, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcfp-1},
                {0x1.2d97c7f3321d1p2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d1p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d2p2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d2p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d3p2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d3p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.5fdbbe9bba774p2, -0x1.6a09e667f3bd4p-1, -0x1.6a09e667f3bd3p-1},
                {-0x1.5fdbbe9bba774p2, 0x1.6a09e667f3bd4p-1, 0x1.6a09e667f3bd3p-1},
                {0x1.5fdbbe9bba775p2, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcdp-1},
                {-0x1.5fdbbe9bba775p2, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcdp-1},
                {0x1.5fdbbe9bba776p2, -0x1.6a09e667f3bc8p-1, -0x1.6a09e667f3bc9p-1},
                {-0x1.5fdbbe9bba776p2, 0x1.6a09e667f3bc8p-1, 0x1.6a09e667f3bc9p-1},
                {0x1.c463abeccb2bap2, 0x1.6a09e667f3bc5p-1, 0x1.6a09e667f3bc6p-1},
                {-0x1.c463abeccb2bap2, -0x1.6a09e667f3bc5p-1, -0x1.6a09e667f3bc6p-1},
                {0x1.c463abeccb2bbp2, 0x1.6a09e667f3bcbp-1, 0x1.6a09e667f3bcap-1},
                {-0x1.c463abeccb2bbp2, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bcap-1},
                {0x1.c463abeccb2bcp2, 0x1.6a09e667f3bd1p-1, 0x1.6a09e667f3bdp-1},
                {-0x1.c463abeccb2bcp2, -0x1.6a09e667f3bd1p-1, -0x1.6a09e667f3bdp-1},
                {0x1.f6a7a2955385dp2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385dp2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.f6a7a2955385ep2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385ep2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.f6a7a2955385fp2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385fp2, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.1475cc9eedeffp3, 0x1.6a09e667f3bdfp-1, 0x1.6a09e667f3bep-1},
                {-0x1.1475cc9eedeffp3, -0x1.6a09e667f3bdfp-1, -0x1.6a09e667f3bep-1},
                {0x1.1475cc9eedfp3, 0x1.6a09e667f3bd4p-1, 0x1.6a09e667f3bd5p-1},
                {-0x1.1475cc9eedfp3, -0x1.6a09e667f3bd4p-1, -0x1.6a09e667f3bd5p-1},
                {0x1.1475cc9eedf01p3, 0x1.6a09e667f3bc9p-1, 0x1.6a09e667f3bcap-1},
                {-0x1.1475cc9eedf01p3, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bcap-1},
                {0x1.2d97c7f3321d1p3, 0x1.34f272993d141p-49, 0x1.34f272993d142p-49},
                {-0x1.2d97c7f3321d1p3, -0x1.34f272993d141p-49, -0x1.34f272993d142p-49},
                {0x1.2d97c7f3321d2p3, 0x1.a79394c9e8a0ap-52, 0x1.a79394c9e8a0bp-52},
                {-0x1.2d97c7f3321d2p3, -0x1.a79394c9e8a0ap-52, -0x1.a79394c9e8a0bp-52},
                {0x1.2d97c7f3321d3p3, -0x1.961b1acd85d7dp-50, -0x1.961b1acd85d7ep-50},
                {-0x1.2d97c7f3321d3p3, 0x1.961b1acd85d7dp-50, 0x1.961b1acd85d7ep-50},
                {0x1.46b9c347764a2p3, -0x1.6a09e667f3bb9p-1, -0x1.6a09e667f3bbap-1},
                {-0x1.46b9c347764a2p3, 0x1.6a09e667f3bb9p-1, 0x1.6a09e667f3bbap-1},
                {0x1.46b9c347764a3p3, -0x1.6a09e667f3bc4p-1, -0x1.6a09e667f3bc5p-1},
                {-0x1.46b9c347764a3p3, 0x1.6a09e667f3bc4p-1, 0x1.6a09e667f3bc5p-1},
                {0x1.46b9c347764a4p3, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bcfp-1},
                {-0x1.46b9c347764a4p3, 0x1.6a09e667f3bdp-1, 0x1.6a09e667f3bcfp-1},
                {0x1.5fdbbe9bba774p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba774p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.5fdbbe9bba775p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba775p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.5fdbbe9bba776p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba776p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.78fdb9effea45p3, -0x1.6a09e667f3bep-1, -0x1.6a09e667f3be1p-1},
                {-0x1.78fdb9effea45p3, 0x1.6a09e667f3bep-1, 0x1.6a09e667f3be1p-1},
                {0x1.78fdb9effea46p3, -0x1.6a09e667f3bd5p-1, -0x1.6a09e667f3bd6p-1},
                {-0x1.78fdb9effea46p3, 0x1.6a09e667f3bd5p-1, 0x1.6a09e667f3bd6p-1},
                {0x1.78fdb9effea47p3, -0x1.6a09e667f3bcap-1, -0x1.6a09e667f3bc9p-1},
                {-0x1.78fdb9effea47p3, 0x1.6a09e667f3bcap-1, 0x1.6a09e667f3bc9p-1},
                {0x1.ab41b09886fe8p3, 0x1.6a09e667f3bb8p-1, 0x1.6a09e667f3bb9p-1},
                {-0x1.ab41b09886fe8p3, -0x1.6a09e667f3bb8p-1, -0x1.6a09e667f3bb9p-1},
                {0x1.ab41b09886fe9p3, 0x1.6a09e667f3bc4p-1, 0x1.6a09e667f3bc3p-1},
                {-0x1.ab41b09886fe9p3, -0x1.6a09e667f3bc4p-1, -0x1.6a09e667f3bc3p-1},
                {0x1.ab41b09886feap3, 0x1.6a09e667f3bcfp-1, 0x1.6a09e667f3bcep-1},
                {-0x1.ab41b09886feap3, -0x1.6a09e667f3bcfp-1, -0x1.6a09e667f3bcep-1},
                {0x1.c463abeccb2bap3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.c463abeccb2bap3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.c463abeccb2bbp3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.c463abeccb2bbp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.c463abeccb2bcp3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.c463abeccb2bcp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.dd85a7410f58bp3, 0x1.6a09e667f3be1p-1, 0x1.6a09e667f3be2p-1},
                {-0x1.dd85a7410f58bp3, -0x1.6a09e667f3be1p-1, -0x1.6a09e667f3be2p-1},
                {0x1.dd85a7410f58cp3, 0x1.6a09e667f3bd6p-1, 0x1.6a09e667f3bd5p-1},
                {-0x1.dd85a7410f58cp3, -0x1.6a09e667f3bd6p-1, -0x1.6a09e667f3bd5p-1},
                {0x1.dd85a7410f58dp3, 0x1.6a09e667f3bcbp-1, 0x1.6a09e667f3bcap-1},
                {-0x1.dd85a7410f58dp3, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bcap-1},
                {0x1.f6a7a2955385dp3, 0x1.583ebeff65cc2p-49, 0x1.583ebeff65cc3p-49},
                {-0x1.f6a7a2955385dp3, -0x1.583ebeff65cc2p-49, -0x1.583ebeff65cc3p-49},
                {0x1.f6a7a2955385ep3, 0x1.60fafbfd97309p-51, 0x1.60fafbfd97308p-51},
                {-0x1.f6a7a2955385ep3, -0x1.60fafbfd97309p-51, -0x1.60fafbfd97308p-51},
                {0x1.f6a7a2955385fp3, -0x1.4f8282013467cp-50, -0x1.4f8282013467bp-50},
                {-0x1.f6a7a2955385fp3, 0x1.4f8282013467cp-50, 0x1.4f8282013467bp-50},
                {0x1.07e4cef4cbd96p4, -0x1.6a09e667f3ba1p-1, -0x1.6a09e667f3bap-1},
                {-0x1.07e4cef4cbd96p4, 0x1.6a09e667f3ba1p-1, 0x1.6a09e667f3bap-1},
                {0x1.07e4cef4cbd97p4, -0x1.6a09e667f3bb8p-1, -0x1.6a09e667f3bb7p-1},
                {-0x1.07e4cef4cbd97p4, 0x1.6a09e667f3bb8p-1, 0x1.6a09e667f3bb7p-1},
                {0x1.07e4cef4cbd98p4, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcfp-1},
                {-0x1.07e4cef4cbd98p4, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcfp-1},
                {0x1.1475cc9eedeffp4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.1475cc9eedeffp4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.1475cc9eedfp4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.1475cc9eedfp4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.1475cc9eedf01p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.1475cc9eedf01p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2106ca4910068p4, -0x1.6a09e667f3bedp-1, -0x1.6a09e667f3beep-1},
                {-0x1.2106ca4910068p4, 0x1.6a09e667f3bedp-1, 0x1.6a09e667f3beep-1},
                {0x1.2106ca4910069p4, -0x1.6a09e667f3bd7p-1, -0x1.6a09e667f3bd6p-1},
                {-0x1.2106ca4910069p4, 0x1.6a09e667f3bd7p-1, 0x1.6a09e667f3bd6p-1},
                {0x1.2106ca491006ap4, -0x1.6a09e667f3bcp-1, -0x1.6a09e667f3bc1p-1},
                {-0x1.2106ca491006ap4, 0x1.6a09e667f3bcp-1, 0x1.6a09e667f3bc1p-1},
                {0x1.2d97c7f3321d1p4, -0x1.34f272993d141p-48, -0x1.34f272993d142p-48},
                {-0x1.2d97c7f3321d1p4, 0x1.34f272993d141p-48, 0x1.34f272993d142p-48},
                {0x1.2d97c7f3321d2p4, -0x1.a79394c9e8a0ap-51, -0x1.a79394c9e8a0bp-51},
                {-0x1.2d97c7f3321d2p4, 0x1.a79394c9e8a0ap-51, 0x1.a79394c9e8a0bp-51},
                {0x1.2d97c7f3321d3p4, 0x1.961b1acd85d7dp-49, 0x1.961b1acd85d7ep-49},
                {-0x1.2d97c7f3321d3p4, -0x1.961b1acd85d7dp-49, -0x1.961b1acd85d7ep-49},
                {0x1.3a28c59d54339p4, 0x1.6a09e667f3bap-1, 0x1.6a09e667f3ba1p-1},
                {-0x1.3a28c59d54339p4, -0x1.6a09e667f3bap-1, -0x1.6a09e667f3ba1p-1},
                {0x1.3a28c59d5433ap4, 0x1.6a09e667f3bb7p-1, 0x1.6a09e667f3bb6p-1},
                {-0x1.3a28c59d5433ap4, -0x1.6a09e667f3bb7p-1, -0x1.6a09e667f3bb6p-1},
                {0x1.3a28c59d5433bp4, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcdp-1},
                {-0x1.3a28c59d5433bp4, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcdp-1},
                {0x1.46b9c347764a2p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.46b9c347764a2p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.46b9c347764a3p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.46b9c347764a3p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.46b9c347764a4p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.46b9c347764a4p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.534ac0f19860bp4, 0x1.6a09e667f3beep-1, 0x1.6a09e667f3befp-1},
                {-0x1.534ac0f19860bp4, -0x1.6a09e667f3beep-1, -0x1.6a09e667f3befp-1},
                {0x1.534ac0f19860cp4, 0x1.6a09e667f3bd8p-1, 0x1.6a09e667f3bd7p-1},
                {-0x1.534ac0f19860cp4, -0x1.6a09e667f3bd8p-1, -0x1.6a09e667f3bd7p-1},
                {0x1.534ac0f19860dp4, 0x1.6a09e667f3bc1p-1, 0x1.6a09e667f3bcp-1},
                {-0x1.534ac0f19860dp4, -0x1.6a09e667f3bc1p-1, -0x1.6a09e667f3bcp-1},
                {0x1.5fdbbe9bba774p4, 0x1.3dc585b2c7422p-48, 0x1.3dc585b2c7421p-48},
                {-0x1.5fdbbe9bba774p4, -0x1.3dc585b2c7422p-48, -0x1.3dc585b2c7421p-48},
                {0x1.5fdbbe9bba775p4, 0x1.ee2c2d963a10cp-51, 0x1.ee2c2d963a10dp-51},
                {-0x1.5fdbbe9bba775p4, -0x1.ee2c2d963a10cp-51, -0x1.ee2c2d963a10dp-51},
                {0x1.5fdbbe9bba776p4, -0x1.8474f49a717bdp-49, -0x1.8474f49a717bcp-49},
                {-0x1.5fdbbe9bba776p4, 0x1.8474f49a717bdp-49, 0x1.8474f49a717bcp-49},
                {0x1.6c6cbc45dc8dcp4, -0x1.6a09e667f3b9fp-1, -0x1.6a09e667f3bap-1},
                {-0x1.6c6cbc45dc8dcp4, 0x1.6a09e667f3b9fp-1, 0x1.6a09e667f3bap-1},
                {0x1.6c6cbc45dc8ddp4, -0x1.6a09e667f3bb6p-1, -0x1.6a09e667f3bb5p-1},
                {-0x1.6c6cbc45dc8ddp4, 0x1.6a09e667f3bb6p-1, 0x1.6a09e667f3bb5p-1},
                {0x1.6c6cbc45dc8dep4, -0x1.6a09e667f3bcdp-1, -0x1.6a09e667f3bccp-1},
                {-0x1.6c6cbc45dc8dep4, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bccp-1},
                {0x1.78fdb9effea45p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.78fdb9effea45p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.78fdb9effea46p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.78fdb9effea46p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.78fdb9effea47p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.78fdb9effea47p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.858eb79a20baep4, -0x1.6a09e667f3befp-1, -0x1.6a09e667f3beep-1},
                {-0x1.858eb79a20baep4, 0x1.6a09e667f3befp-1, 0x1.6a09e667f3beep-1},
                {0x1.858eb79a20bafp4, -0x1.6a09e667f3bd8p-1, -0x1.6a09e667f3bd9p-1},
                {-0x1.858eb79a20bafp4, 0x1.6a09e667f3bd8p-1, 0x1.6a09e667f3bd9p-1},
                {0x1.858eb79a20bbp4, -0x1.6a09e667f3bc2p-1, -0x1.6a09e667f3bc1p-1},
                {-0x1.858eb79a20bbp4, 0x1.6a09e667f3bc2p-1, 0x1.6a09e667f3bc1p-1},
                {0x1.fffffffffffffp62, 0x1.fa7299b17573dp-1, 0x1.fa7299b17573ep-1},
                {-0x1.fffffffffffffp62, -0x1.fa7299b17573dp-1, -0x1.fa7299b17573ep-1},
                {0x1.0p63, 0x1.fff6dfd42dc54p-1, 0x1.fff6dfd42dc55p-1},
                {-0x1.0p63, -0x1.fff6dfd42dc54p-1, -0x1.fff6dfd42dc55p-1},
                {0x1.0000000000001p63, 0x1.e456b818e7397p-1, 0x1.e456b818e7396p-1},
                {-0x1.0000000000001p63, -0x1.e456b818e7397p-1, -0x1.e456b818e7396p-1},
                {0x1.fffffffffffffp26, -0x1.86dcca0d689e8p-1, -0x1.86dcca0d689e7p-1},
                {-0x1.fffffffffffffp26, 0x1.86dcca0d689e8p-1, 0x1.86dcca0d689e7p-1},
                {0x1.0p27, -0x1.86dcc9babb0a4p-1, -0x1.86dcc9babb0a5p-1},
                {-0x1.0p27, 0x1.86dcc9babb0a4p-1, 0x1.86dcc9babb0a5p-1},
                {0x1.0000000000001p27, -0x1.86dcc9155fe18p-1, -0x1.86dcc9155fe19p-1},
                {-0x1.0000000000001p27, 0x1.86dcc9155fe18p-1, 0x1.86dcc9155fe19p-1},
                {0x1.fffffffffffffp23, -0x1.8f22f84d42da2p-1, -0x1.8f22f84d42da1p-1},
                {-0x1.fffffffffffffp23, 0x1.8f22f84d42da2p-1, 0x1.8f22f84d42da1p-1},
                {0x1.0p24, -0x1.8f22f8433d6eep-1, -0x1.8f22f8433d6edp-1},
                {-0x1.0p24, 0x1.8f22f8433d6eep-1, 0x1.8f22f8433d6edp-1},
                {0x1.0000000000001p24, -0x1.8f22f82f32986p-1, -0x1.8f22f82f32985p-1},
                {-0x1.0000000000001p24, 0x1.8f22f82f32986p-1, 0x1.8f22f82f32985p-1},
                {0x1.fffffffffffffp1, -0x1.837b9dddc1eacp-1, -0x1.837b9dddc1eabp-1},
                {-0x1.fffffffffffffp1, 0x1.837b9dddc1eacp-1, 0x1.837b9dddc1eabp-1},
                {0x1.0p2, -0x1.837b9dddc1eaep-1, -0x1.837b9dddc1eafp-1},
                {-0x1.0p2, 0x1.837b9dddc1eaep-1, 0x1.837b9dddc1eafp-1},
                {0x1.0000000000001p2, -0x1.837b9dddc1eb4p-1, -0x1.837b9dddc1eb3p-1},
                {-0x1.0000000000001p2, 0x1.837b9dddc1eb4p-1, 0x1.837b9dddc1eb3p-1},
                {0x1.fffffffffffffp0, 0x1.d18f6ead1b447p-1, 0x1.d18f6ead1b446p-1},
                {-0x1.fffffffffffffp0, -0x1.d18f6ead1b447p-1, -0x1.d18f6ead1b446p-1},
                {0x1.0p1, 0x1.d18f6ead1b446p-1, 0x1.d18f6ead1b445p-1},
                {-0x1.0p1, -0x1.d18f6ead1b446p-1, -0x1.d18f6ead1b445p-1},
                {0x1.0000000000001p1, 0x1.d18f6ead1b444p-1, 0x1.d18f6ead1b445p-1},
                {-0x1.0000000000001p1, -0x1.d18f6ead1b444p-1, -0x1.d18f6ead1b445p-1},
                {0x1.fffffffffffffp-1, 0x1.aed548f090cedp-1, 0x1.aed548f090ceep-1},
                {-0x1.fffffffffffffp-1, -0x1.aed548f090cedp-1, -0x1.aed548f090ceep-1},
                {0x1.0p0, 0x1.aed548f090ceep-1, 0x1.aed548f090cefp-1},
                {-0x1.0p0, -0x1.aed548f090ceep-1, -0x1.aed548f090cefp-1},
                {0x1.0000000000001p0, 0x1.aed548f090cefp-1, 0x1.aed548f090cfp-1},
                {-0x1.0000000000001p0, -0x1.aed548f090cefp-1, -0x1.aed548f090cfp-1},
                {0x1.fffffffffffffp-2, 0x1.eaee8744b05efp-2, 0x1.eaee8744b05fp-2},
                {-0x1.fffffffffffffp-2, -0x1.eaee8744b05efp-2, -0x1.eaee8744b05fp-2},
                {0x1.0p-1, 0x1.eaee8744b05fp-2, 0x1.eaee8744b05efp-2},
                {-0x1.0p-1, -0x1.eaee8744b05fp-2, -0x1.eaee8744b05efp-2},
                {0x1.0000000000001p-1, 0x1.eaee8744b05f2p-2, 0x1.eaee8744b05f1p-2},
                {-0x1.0000000000001p-1, -0x1.eaee8744b05f2p-2, -0x1.eaee8744b05f1p-2},
                {0x1.fffffffffffffp-3, 0x1.faaeed4f31576p-3, 0x1.faaeed4f31575p-3},
                {-0x1.fffffffffffffp-3, -0x1.faaeed4f31576p-3, -0x1.faaeed4f31575p-3},
                {0x1.0p-2, 0x1.faaeed4f31577p-3, 0x1.faaeed4f31576p-3},
                {-0x1.0p-2, -0x1.faaeed4f31577p-3, -0x1.faaeed4f31576p-3},
                {0x1.0000000000001p-2, 0x1.faaeed4f31579p-3, 0x1.faaeed4f31578p-3},
                {-0x1.0000000000001p-2, -0x1.faaeed4f31579p-3, -0x1.faaeed4f31578p-3},
                {0x1.fffffffffffffp-4, 0x1.feaaeee86ee35p-4, 0x1.feaaeee86ee34p-4},
                {-0x1.fffffffffffffp-4, -0x1.feaaeee86ee35p-4, -0x1.feaaeee86ee34p-4},
                {0x1.0p-3, 0x1.feaaeee86ee36p-4, 0x1.feaaeee86ee35p-4},
                {-0x1.0p-3, -0x1.feaaeee86ee36p-4, -0x1.feaaeee86ee35p-4},
                {0x1.0000000000001p-3, 0x1.feaaeee86ee38p-4, 0x1.feaaeee86ee37p-4},
                {-0x1.0000000000001p-3, -0x1.feaaeee86ee38p-4, -0x1.feaaeee86ee37p-4},
                {0x1.fffffffffffffp-5, 0x1.ffaaaeeed4edap-5, 0x1.ffaaaeeed4ed9p-5},
                {-0x1.fffffffffffffp-5, -0x1.ffaaaeeed4edap-5, -0x1.ffaaaeeed4ed9p-5},
                {0x1.0p-4, 0x1.ffaaaeeed4edbp-5, 0x1.ffaaaeeed4edap-5},
                {-0x1.0p-4, -0x1.ffaaaeeed4edbp-5, -0x1.ffaaaeeed4edap-5},
                {0x1.0000000000001p-4, 0x1.ffaaaeeed4eddp-5, 0x1.ffaaaeeed4edcp-5},
                {-0x1.0000000000001p-4, -0x1.ffaaaeeed4eddp-5, -0x1.ffaaaeeed4edcp-5},
                {0x1.fffffffffffffp-6, 0x1.ffeaaaeeee86ep-6, 0x1.ffeaaaeeee86dp-6},
                {-0x1.fffffffffffffp-6, -0x1.ffeaaaeeee86ep-6, -0x1.ffeaaaeeee86dp-6},
                {0x1.0p-5, 0x1.ffeaaaeeee86fp-6, 0x1.ffeaaaeeee86ep-6},
                {-0x1.0p-5, -0x1.ffeaaaeeee86fp-6, -0x1.ffeaaaeeee86ep-6},
                {0x1.0000000000001p-5, 0x1.ffeaaaeeee871p-6, 0x1.ffeaaaeeee87p-6},
                {-0x1.0000000000001p-5, -0x1.ffeaaaeeee871p-6, -0x1.ffeaaaeeee87p-6},
                {0x1.fffffffffffffp-7, 0x1.fffaaaaeeeed4p-7, 0x1.fffaaaaeeeed3p-7},
                {-0x1.fffffffffffffp-7, -0x1.fffaaaaeeeed4p-7, -0x1.fffaaaaeeeed3p-7},
                {0x1.0p-6, 0x1.fffaaaaeeeed5p-7, 0x1.fffaaaaeeeed4p-7},
                {-0x1.0p-6, -0x1.fffaaaaeeeed5p-7, -0x1.fffaaaaeeeed4p-7},
                {0x1.0000000000001p-6, 0x1.fffaaaaeeeed7p-7, 0x1.fffaaaaeeeed6p-7},
                {-0x1.0000000000001p-6, -0x1.fffaaaaeeeed7p-7, -0x1.fffaaaaeeeed6p-7},
                {0x1.fffffffffffffp-15, 0x1.fffffffaaaaaap-15, 0x1.fffffffaaaaa9p-15},
                {-0x1.fffffffffffffp-15, -0x1.fffffffaaaaaap-15, -0x1.fffffffaaaaa9p-15},
                {0x1.0p-14, 0x1.fffffffaaaaabp-15, 0x1.fffffffaaaaaap-15},
                {-0x1.0p-14, -0x1.fffffffaaaaabp-15, -0x1.fffffffaaaaaap-15},
                {0x1.0000000000001p-14, 0x1.fffffffaaaaadp-15, 0x1.fffffffaaaaacp-15},
                {-0x1.0000000000001p-14, -0x1.fffffffaaaaadp-15, -0x1.fffffffaaaaacp-15},
                {0x1.fffffffffffffp-28, 0x1.fffffffffffffp-28, 0x1.ffffffffffffep-28},
                {-0x1.fffffffffffffp-28, -0x1.fffffffffffffp-28, -0x1.ffffffffffffep-28},
                {0x1.0p-27, 0x1.0p-27, 0x1.fffffffffffffp-28},
                {-0x1.0p-27, -0x1.0p-27, -0x1.fffffffffffffp-28},
                {0x1.0000000000001p-27, 0x1.0000000000001p-27, 0x1.0p-27},
                {-0x1.0000000000001p-27, -0x1.0000000000001p-27, -0x1.0p-27},
                {0x1.fffffffffffffp-31, 0x1.fffffffffffffp-31, 0x1.ffffffffffffep-31},
                {-0x1.fffffffffffffp-31, -0x1.fffffffffffffp-31, -0x1.ffffffffffffep-31},
                {0x1.0p-30, 0x1.0p-30, 0x1.fffffffffffffp-31},
                {-0x1.0p-30, -0x1.0p-30, -0x1.fffffffffffffp-31},
                {0x1.0000000000001p-30, 0x1.0000000000001p-30, 0x1.0p-30},
                {-0x1.0000000000001p-30, -0x1.0000000000001p-30, -0x1.0p-30},
                {-0x1.fffffffffffffp1023, -0x1.452fc98b34e97p-8, -0x1.452fc98b34e96p-8},
                {0x1.fffffffffffffp1023, 0x1.452fc98b34e97p-8, 0x1.452fc98b34e96p-8},
                {0x1.fffffffffffffp1023, 0x1.452fc98b34e97p-8, 0x1.452fc98b34e96p-8},
                {-0x1.fffffffffffffp1023, -0x1.452fc98b34e97p-8, -0x1.452fc98b34e96p-8},
                {0x1.fffffffffffffp1023, 0x1.452fc98b34e97p-8, 0x1.452fc98b34e96p-8},
                {-0x1.fffffffffffffp1023, -0x1.452fc98b34e97p-8, -0x1.452fc98b34e96p-8},
                {0x1.ffffffffffffep1023, 0x1.daa3677c6ee8ap-1, 0x1.daa3677c6ee8bp-1},
                {-0x1.ffffffffffffep1023, -0x1.daa3677c6ee8ap-1, -0x1.daa3677c6ee8bp-1},
                {0x1.921fb54442d18p1, 0x1.1a62633145c07p-53, 0x1.1a62633145c06p-53},
                {-0x1.921fb54442d18p1, -0x1.1a62633145c07p-53, -0x1.1a62633145c06p-53},
                {0x1.921fb54442d18p0, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p0, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.0000000000001p0, 0x1.aed548f090cefp-1, 0x1.aed548f090cfp-1},
                {-0x1.0000000000001p0, -0x1.aed548f090cefp-1, -0x1.aed548f090cfp-1},
                {0x1.0p0, 0x1.aed548f090ceep-1, 0x1.aed548f090cefp-1},
                {-0x1.0p0, -0x1.aed548f090ceep-1, -0x1.aed548f090cefp-1},
                {0x1.fffffffffffffp-1, 0x1.aed548f090cedp-1, 0x1.aed548f090ceep-1},
                {-0x1.fffffffffffffp-1, -0x1.aed548f090cedp-1, -0x1.aed548f090ceep-1},
                {0x1.921fb54442d18p-1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcdp-1},
                {-0x1.921fb54442d18p-1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcdp-1},
                {0x1.0000000000001p-1022, 0x1.0000000000001p-1022, 0x1.0000000000001p-1022},
                {-0x1.0000000000001p-1022, -0x1.0000000000001p-1022, -0x1.0000000000001p-1022},
                {0x1.0p-1022, 0x1.0p-1022, 0x1.0p-1022},
                {-0x1.0p-1022, -0x1.0p-1022, -0x1.0p-1022},
                {0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022, 0x0.fffffffffffffp-1022},
                {-0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022, -0x0.fffffffffffffp-1022},
                {0x0.ffffffffffffep-1022, 0x0.ffffffffffffep-1022, 0x0.ffffffffffffep-1022},
                {-0x0.ffffffffffffep-1022, -0x0.ffffffffffffep-1022, -0x0.ffffffffffffep-1022},
                {0x0.0000000000002p-1022, 0x0.0000000000002p-1022, 0x0.0000000000002p-1022},
                {-0x0.0000000000002p-1022, -0x0.0000000000002p-1022, -0x0.0000000000001p-1022},
                {0x0.0000000000001p-1022, 0x0.0000000000001p-1022, 0x0.0p0},
                {-0x0.0000000000001p-1022, -0x0.0000000000001p-1022, -0x0.0p0},
                {0x0.0p0, 0x0.0p0, 0x0.0p0},
                {-0x0.0p0, -0x0.0p0, -0x0.0p0}

        };

        for (double[] testCase : testCases) {
            testSinCase(testCase[0], testCase[1], testCase[2]);
        }
    }

    private static void testSinCase(double input, double bound1, double bound2) {
        Tests.testBounds("Math.sin", input, Math.sin(input), bound1, bound2);
    }

    @Test
    public void testCornerCasesCos() {
        double[][] testCases = {
                {0x1.feb1f7920e248p-2, 0x1.c1a27ae836f13p-1, 0x1.c1a27ae836f12p-1},
                {-0x1.feb1f7920e248p-2, 0x1.c1a27ae836f13p-1, 0x1.c1a27ae836f12p-1},
                {0x1.7cb7648526f99p-1, 0x1.78daf01036d0dp-1, 0x1.78daf01036d0cp-1},
                {-0x1.7cb7648526f99p-1, 0x1.78daf01036d0dp-1, 0x1.78daf01036d0cp-1},
                {0x1.549ec0c0c5afap-5, 0x1.ff8eb6a91ecbp-1, 0x1.ff8eb6a91ecb1p-1},
                {-0x1.549ec0c0c5afap-5, 0x1.ff8eb6a91ecbp-1, 0x1.ff8eb6a91ecb1p-1},
                {0x1.16e534ee3658p-4, 0x1.fed0476fc75cap-1, 0x1.fed0476fc75c9p-1},
                {-0x1.16e534ee3658p-4, 0x1.fed0476fc75cap-1, 0x1.fed0476fc75c9p-1},
                {0x1.efeef61d39ac2p-3, 0x1.f10fc61e2c78fp-1, 0x1.f10fc61e2c78ep-1},
                {-0x1.efeef61d39ac2p-3, 0x1.f10fc61e2c78fp-1, 0x1.f10fc61e2c78ep-1},
                {0x1.c65a170474549p-1, 0x1.434a3645be208p-1, 0x1.434a3645be209p-1},
                {-0x1.c65a170474549p-1, 0x1.434a3645be208p-1, 0x1.434a3645be209p-1},
                {0x1.6b8a6273d7c21p0, 0x1.337fc5b072c53p-3, 0x1.337fc5b072c52p-3},
                {-0x1.6b8a6273d7c21p0, 0x1.337fc5b072c53p-3, 0x1.337fc5b072c52p-3},
                {-0x1.036f4ba7e90aap-2, 0x1.efa7cddb128fcp-1, 0x1.efa7cddb128fbp-1},
                {0x1.036f4ba7e90aap-2, 0x1.efa7cddb128fcp-1, 0x1.efa7cddb128fbp-1},
                {-0x1.1500766c9df2p-31, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.1500766c9df2p-31, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.1e2a1563e068ep-2, 0x1.ec231802917bep-1, 0x1.ec231802917bdp-1},
                {0x1.1e2a1563e068ep-2, 0x1.ec231802917bep-1, 0x1.ec231802917bdp-1},
                {-0x1.2115aa73f8d05p5, 0x1.dc044ac92b7fcp-8, 0x1.dc044ac92b7fbp-8},
                {0x1.2115aa73f8d05p5, 0x1.dc044ac92b7fcp-8, 0x1.dc044ac92b7fbp-8},
                {-0x1.34e3bcdf8f69ap2, 0x1.d1fa67c50dd53p-4, 0x1.d1fa67c50dd52p-4},
                {0x1.34e3bcdf8f69ap2, 0x1.d1fa67c50dd53p-4, 0x1.d1fa67c50dd52p-4},
                {-0x1.380000000000bp7, 0x1.e2f8d19fb8db8p-2, 0x1.e2f8d19fb8db9p-2},
                {0x1.380000000000bp7, 0x1.e2f8d19fb8db8p-2, 0x1.e2f8d19fb8db9p-2},
                {-0x1.440000004p6, 0x1.8da9c90c3eda1p-1, 0x1.8da9c90c3eda2p-1},
                {0x1.440000004p6, 0x1.8da9c90c3eda1p-1, 0x1.8da9c90c3eda2p-1},
                {-0x1.550c8ee67a4c4p29, 0x1.b59b320603f83p-1, 0x1.b59b320603f84p-1},
                {0x1.550c8ee67a4c4p29, 0x1.b59b320603f83p-1, 0x1.b59b320603f84p-1},
                {-0x1.711789fdb2e8ap-13, 0x1.ffffff7af6c88p-1, 0x1.ffffff7af6c89p-1},
                {0x1.711789fdb2e8ap-13, 0x1.ffffff7af6c88p-1, 0x1.ffffff7af6c89p-1},
                {-0x1.77e000002p8, 0x1.c1b68ebb0b4fep-2, 0x1.c1b68ebb0b4ffp-2},
                {0x1.77e000002p8, 0x1.c1b68ebb0b4fep-2, 0x1.c1b68ebb0b4ffp-2},
                {-0x1.8106561931b43p0, 0x1.1161e1dad76dcp-4, 0x1.1161e1dad76dbp-4},
                {0x1.8106561931b43p0, 0x1.1161e1dad76dcp-4, 0x1.1161e1dad76dbp-4},
                {-0x1.825be2461cad4p0, 0x1.f828c3226b3d7p-5, 0x1.f828c3226b3d8p-5},
                {0x1.825be2461cad4p0, 0x1.f828c3226b3d7p-5, 0x1.f828c3226b3d8p-5},
                {-0x1.8288755803b08p0, 0x1.f2990d742e9fbp-5, 0x1.f2990d742e9fap-5},
                {0x1.8288755803b08p0, 0x1.f2990d742e9fbp-5, 0x1.f2990d742e9fap-5},
                {-0x1.8a75701f4ccd3p1, -0x1.ff150dda7524dp-1, -0x1.ff150dda7524cp-1},
                {0x1.8a75701f4ccd3p1, -0x1.ff150dda7524dp-1, -0x1.ff150dda7524cp-1},
                {-0x1.b389316f37f37p3, 0x1.015c47c32b574p-1, 0x1.015c47c32b575p-1},
                {0x1.b389316f37f37p3, 0x1.015c47c32b574p-1, 0x1.015c47c32b575p-1},
                {-0x1.c602c465d7d27p6, 0x1.d681a366a0534p-1, 0x1.d681a366a0535p-1},
                {0x1.c602c465d7d27p6, 0x1.d681a366a0534p-1, 0x1.d681a366a0535p-1},
                {-0x1.cfb81fe69664cp4, -0x1.84e896c7543d6p-1, -0x1.84e896c7543d5p-1},
                {0x1.cfb81fe69664cp4, -0x1.84e896c7543d6p-1, -0x1.84e896c7543d5p-1},
                {-0x1.d08f2d86b12c6p13, 0x1.fc5dcfddd54cp-1, 0x1.fc5dcfddd54c1p-1},
                {0x1.d08f2d86b12c6p13, 0x1.fc5dcfddd54cp-1, 0x1.fc5dcfddd54c1p-1},
                {-0x1.de13f0943c494p99, 0x1.fe83235fbe016p-3, 0x1.fe83235fbe015p-3},
                {0x1.de13f0943c494p99, 0x1.fe83235fbe016p-3, 0x1.fe83235fbe015p-3},
                {-0x1.de3c1f1285e8bp3, -0x1.720321239ec5p-1, -0x1.720321239ec4fp-1},
                {0x1.de3c1f1285e8bp3, -0x1.720321239ec5p-1, -0x1.720321239ec4fp-1},
                {-0x1.fffffffffff7fp1023, 0x1.f7143c8bba407p-4, 0x1.f7143c8bba406p-4},
                {0x1.fffffffffff7fp1023, 0x1.f7143c8bba407p-4, 0x1.f7143c8bba406p-4},
                {-0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.0000000000001p51, 0x1.055e457ac1227p-5, 0x1.055e457ac1228p-5},
                {-0x1.0000000000001p51, 0x1.055e457ac1227p-5, 0x1.055e457ac1228p-5},
                {0x1.0000000000003p-1, 0x1.c1528065b7d4ep-1, 0x1.c1528065b7d4fp-1},
                {-0x1.0000000000003p-1, 0x1.c1528065b7d4ep-1, 0x1.c1528065b7d4fp-1},
                {0x1.0000000000003p-32, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.0000000000003p-32, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.000000000002p150, 0x1.fffea444bc05ep-1, 0x1.fffea444bc05fp-1},
                {-0x1.000000000002p150, 0x1.fffea444bc05ep-1, 0x1.fffea444bc05fp-1},
                {0x1.0000000000038p380, -0x1.ebddee876f434p-1, -0x1.ebddee876f433p-1},
                {-0x1.0000000000038p380, -0x1.ebddee876f434p-1, -0x1.ebddee876f433p-1},
                {0x1.0000000000118p380, -0x1.f2ffc51dc6968p-1, -0x1.f2ffc51dc6969p-1},
                {-0x1.0000000000118p380, -0x1.f2ffc51dc6968p-1, -0x1.f2ffc51dc6969p-1},
                {0x1.00000000003ffp641, -0x1.f8fbb4d358b2p-1, -0x1.f8fbb4d358b21p-1},
                {-0x1.00000000003ffp641, -0x1.f8fbb4d358b2p-1, -0x1.f8fbb4d358b21p-1},
                {0x1.0000000001p1, -0x1.aa2265753e668p-2, -0x1.aa2265753e669p-2},
                {-0x1.0000000001p1, -0x1.aa2265753e668p-2, -0x1.aa2265753e669p-2},
                {0x1.000000008p452, 0x1.fd1242c25994dp-1, 0x1.fd1242c25994ep-1},
                {-0x1.000000008p452, 0x1.fd1242c25994dp-1, 0x1.fd1242c25994ep-1},
                {0x1.00000000effafp-7, 0x1.fffc0001554dap-1, 0x1.fffc0001554dbp-1},
                {-0x1.00000000effafp-7, 0x1.fffc0001554dap-1, 0x1.fffc0001554dbp-1},
                {0x1.00000114fefe2p0, 0x1.14a27f2925522p-1, 0x1.14a27f2925523p-1},
                {-0x1.00000114fefe2p0, 0x1.14a27f2925522p-1, 0x1.14a27f2925523p-1},
                {0x1.000007p40, 0x1.bf81e0269c59dp-3, 0x1.bf81e0269c59cp-3},
                {-0x1.000007p40, 0x1.bf81e0269c59dp-3, 0x1.bf81e0269c59cp-3},
                {0x1.00000acadb3d3p0, 0x1.14a26ed1960d6p-1, 0x1.14a26ed1960d7p-1},
                {-0x1.00000acadb3d3p0, 0x1.14a26ed1960d6p-1, 0x1.14a26ed1960d7p-1},
                {0x1.00003p-17, 0x1.ffffffffbfffep-1, 0x1.ffffffffbffffp-1},
                {-0x1.00003p-17, 0x1.ffffffffbfffep-1, 0x1.ffffffffbffffp-1},
                {0x1.00003ffffffaep-18, 0x1.ffffffffeffffp-1, 0x1.fffffffffp-1},
                {-0x1.00003ffffffaep-18, 0x1.ffffffffeffffp-1, 0x1.fffffffffp-1},
                {0x1.00003ffffffffp-18, 0x1.ffffffffeffffp-1, 0x1.fffffffffp-1},
                {-0x1.00003ffffffffp-18, 0x1.ffffffffeffffp-1, 0x1.fffffffffp-1},
                {0x1.00007ffffdeap41, -0x1.dab7efeb35baep-2, -0x1.dab7efeb35badp-2},
                {-0x1.00007ffffdeap41, -0x1.dab7efeb35baep-2, -0x1.dab7efeb35badp-2},
                {0x1.0000ffff8p-19, 0x1.fffffffffcp-1, 0x1.fffffffffbfffp-1},
                {-0x1.0000ffff8p-19, 0x1.fffffffffcp-1, 0x1.fffffffffbfffp-1},
                {0x1.0003fff800051p-20, 0x1.ffffffffffp-1, 0x1.fffffffffefffp-1},
                {-0x1.0003fff800051p-20, 0x1.ffffffffffp-1, 0x1.fffffffffefffp-1},
                {0x1.0003fff800096p-20, 0x1.ffffffffffp-1, 0x1.fffffffffefffp-1},
                {-0x1.0003fff800096p-20, 0x1.ffffffffffp-1, 0x1.fffffffffefffp-1},
                {0x1.000fd2p334, -0x1.fbf2b71a23a58p-2, -0x1.fbf2b71a23a57p-2},
                {-0x1.000fd2p334, -0x1.fbf2b71a23a58p-2, -0x1.fbf2b71a23a57p-2},
                {0x1.003p514, 0x1.fccc87eae7737p-5, 0x1.fccc87eae7736p-5},
                {-0x1.003p514, 0x1.fccc87eae7737p-5, 0x1.fccc87eae7736p-5},
                {0x1.00600000015f4p41, -0x1.a43f40d92b7edp-7, -0x1.a43f40d92b7eep-7},
                {-0x1.00600000015f4p41, -0x1.a43f40d92b7edp-7, -0x1.a43f40d92b7eep-7},
                {0x1.007p-1, 0x1.c11cc38f40ab3p-1, 0x1.c11cc38f40ab2p-1},
                {-0x1.007p-1, 0x1.c11cc38f40ab3p-1, 0x1.c11cc38f40ab2p-1},
                {0x1.007p-21, 0x1.ffffffffffbfcp-1, 0x1.ffffffffffbfdp-1},
                {-0x1.007p-21, 0x1.ffffffffffbfcp-1, 0x1.ffffffffffbfdp-1},
                {0x1.00cp40, 0x1.e9ba98231f734p-8, 0x1.e9ba98231f735p-8},
                {-0x1.00cp40, 0x1.e9ba98231f734p-8, 0x1.e9ba98231f735p-8},
                {0x1.011p-4, 0x1.fefdf48ed649dp-1, 0x1.fefdf48ed649cp-1},
                {-0x1.011p-4, 0x1.fefdf48ed649dp-1, 0x1.fefdf48ed649cp-1},
                {0x1.011p996, -0x1.ffc16a0f12ff2p-1, -0x1.ffc16a0f12ff3p-1},
                {-0x1.011p996, -0x1.ffc16a0f12ff2p-1, -0x1.ffc16a0f12ff3p-1},
                {0x1.02p-2, 0x1.efd5b61a30a38p-1, 0x1.efd5b61a30a39p-1},
                {-0x1.02p-2, 0x1.efd5b61a30a38p-1, 0x1.efd5b61a30a39p-1},
                {0x1.0204260c18307p59, 0x1.c97b8161dc50ap-2, 0x1.c97b8161dc50bp-2},
                {-0x1.0204260c18307p59, 0x1.c97b8161dc50ap-2, 0x1.c97b8161dc50bp-2},
                {0x1.02e78a321155ep1, -0x1.bf26a3c9b9fbfp-2, -0x1.bf26a3c9b9fbep-2},
                {-0x1.02e78a321155ep1, -0x1.bf26a3c9b9fbfp-2, -0x1.bf26a3c9b9fbep-2},
                {0x1.04p-4, 0x1.fef806b1f84e5p-1, 0x1.fef806b1f84e4p-1},
                {-0x1.04p-4, 0x1.fef806b1f84e5p-1, 0x1.fef806b1f84e4p-1},
                {0x1.04bde8bb80258p98, 0x1.fe851fbf87d17p-1, 0x1.fe851fbf87d18p-1},
                {-0x1.04bde8bb80258p98, 0x1.fe851fbf87d17p-1, 0x1.fe851fbf87d18p-1},
                {0x1.077e749e37ceep236, 0x1.70f6a51da8effp-1, 0x1.70f6a51da8efep-1},
                {-0x1.077e749e37ceep236, 0x1.70f6a51da8effp-1, 0x1.70f6a51da8efep-1},
                {0x1.07f8p300, 0x1.6b408c856bda6p-3, 0x1.6b408c856bda5p-3},
                {-0x1.07f8p300, 0x1.6b408c856bda6p-3, 0x1.6b408c856bda5p-3},
                {0x1.07f9bea1b3546p27, 0x1.2b2f965ae40fcp-1, 0x1.2b2f965ae40fdp-1},
                {-0x1.07f9bea1b3546p27, 0x1.2b2f965ae40fcp-1, 0x1.2b2f965ae40fdp-1},
                {0x1.090d18372f2d5p4, -0x1.4eed2f3fc76a8p-1, -0x1.4eed2f3fc76a7p-1},
                {-0x1.090d18372f2d5p4, -0x1.4eed2f3fc76a8p-1, -0x1.4eed2f3fc76a7p-1},
                {0x1.0b4p-3, 0x1.fba59aecee5p-1, 0x1.fba59aecee501p-1},
                {-0x1.0b4p-3, 0x1.fba59aecee5p-1, 0x1.fba59aecee501p-1},
                {0x1.0c0d5c2af3c2ep346, 0x1.fffd1bcda7a7dp-1, 0x1.fffd1bcda7a7ep-1},
                {-0x1.0c0d5c2af3c2ep346, 0x1.fffd1bcda7a7dp-1, 0x1.fffd1bcda7a7ep-1},
                {0x1.0d30596ee91fdp216, -0x1.e4dfe83129286p-1, -0x1.e4dfe83129287p-1},
                {-0x1.0d30596ee91fdp216, -0x1.e4dfe83129286p-1, -0x1.e4dfe83129287p-1},
                {0x1.0d6p0, 0x1.fb8432886a284p-2, 0x1.fb8432886a283p-2},
                {-0x1.0d6p0, 0x1.fb8432886a284p-2, 0x1.fb8432886a283p-2},
                {0x1.0e9474c68831cp-10, 0x1.ffffee202854p-1, 0x1.ffffee202853fp-1},
                {-0x1.0e9474c68831cp-10, 0x1.ffffee202854p-1, 0x1.ffffee202853fp-1},
                {0x1.113bae4049849p2, -0x1.b70d3d5584b1bp-2, -0x1.b70d3d5584b1ap-2},
                {-0x1.113bae4049849p2, -0x1.b70d3d5584b1bp-2, -0x1.b70d3d5584b1ap-2},
                {0x1.12eb87097654p-4, 0x1.fed8df58f626p-1, 0x1.fed8df58f625fp-1},
                {-0x1.12eb87097654p-4, 0x1.fed8df58f626p-1, 0x1.fed8df58f625fp-1},
                {0x1.13cp0, 0x1.e536ae395dfcep-2, 0x1.e536ae395dfcfp-2},
                {-0x1.13cp0, 0x1.e536ae395dfcep-2, 0x1.e536ae395dfcfp-2},
                {0x1.16e534ee3658p-4, 0x1.fed0476fc75cap-1, 0x1.fed0476fc75c9p-1},
                {-0x1.16e534ee3658p-4, 0x1.fed0476fc75cap-1, 0x1.fed0476fc75c9p-1},
                {0x1.17fffffffea98p-3, 0x1.fb38e82e3193ap-1, 0x1.fb38e82e3193bp-1},
                {-0x1.17fffffffea98p-3, 0x1.fb38e82e3193ap-1, 0x1.fb38e82e3193bp-1},
                {0x1.18p-3, 0x1.fb38e82e3188p-1, 0x1.fb38e82e3187fp-1},
                {-0x1.18p-3, 0x1.fb38e82e3188p-1, 0x1.fb38e82e3187fp-1},
                {0x1.1a191ebbb4d7fp7, -0x1.e59647f1fe9c7p-1, -0x1.e59647f1fe9c8p-1},
                {-0x1.1a191ebbb4d7fp7, -0x1.e59647f1fe9c7p-1, -0x1.e59647f1fe9c8p-1},
                {0x1.1da84f2b7b1d8p7, -0x1.d0dca1f8715bep-4, -0x1.d0dca1f8715bdp-4},
                {-0x1.1da84f2b7b1d8p7, -0x1.d0dca1f8715bep-4, -0x1.d0dca1f8715bdp-4},
                {0x1.201e973251302p0, 0x1.b917ebbc30e1ep-2, 0x1.b917ebbc30e1dp-2},
                {-0x1.201e973251302p0, 0x1.b917ebbc30e1ep-2, 0x1.b917ebbc30e1dp-2},
                {0x1.21e02p-7, 0x1.fffadf12ff414p-1, 0x1.fffadf12ff415p-1},
                {-0x1.21e02p-7, 0x1.fffadf12ff414p-1, 0x1.fffadf12ff415p-1},
                {0x1.27e29a4b985bfp1, -0x1.598a4dab3de5ap-1, -0x1.598a4dab3de59p-1},
                {-0x1.27e29a4b985bfp1, -0x1.598a4dab3de5ap-1, -0x1.598a4dab3de59p-1},
                {0x1.2a1f28dbfb6cp-3, 0x1.fa95c1154abf5p-1, 0x1.fa95c1154abf6p-1},
                {-0x1.2a1f28dbfb6cp-3, 0x1.fa95c1154abf5p-1, 0x1.fa95c1154abf6p-1},
                {0x1.2b8p1, -0x1.6412293adb7bcp-1, -0x1.6412293adb7bdp-1},
                {-0x1.2b8p1, -0x1.6412293adb7bcp-1, -0x1.6412293adb7bdp-1},
                {0x1.31199def72f4dp-7, 0x1.fffa518a7d0e7p-1, 0x1.fffa518a7d0e8p-1},
                {-0x1.31199def72f4dp-7, 0x1.fffa518a7d0e7p-1, 0x1.fffa518a7d0e8p-1},
                {0x1.31260e1485014p4, 0x1.f36895fe177f8p-1, 0x1.f36895fe177f7p-1},
                {-0x1.31260e1485014p4, 0x1.f36895fe177f8p-1, 0x1.f36895fe177f7p-1},
                {0x1.34e964cd103bdp2, 0x1.d36207b4fee17p-4, 0x1.d36207b4fee16p-4},
                {-0x1.34e964cd103bdp2, 0x1.d36207b4fee17p-4, 0x1.d36207b4fee16p-4},
                {0x1.37618a0ba785p1, -0x1.84a37f4fa7616p-1, -0x1.84a37f4fa7617p-1},
                {-0x1.37618a0ba785p1, -0x1.84a37f4fa7616p-1, -0x1.84a37f4fa7617p-1},
                {0x1.379704f5f1eb3p24, -0x1.c830bbc99e229p-39, -0x1.c830bbc99e22ap-39},
                {-0x1.379704f5f1eb3p24, -0x1.c830bbc99e229p-39, -0x1.c830bbc99e22ap-39},
                {0x1.3b61dd166d47p2, 0x1.b5daaa233bd5p-3, 0x1.b5daaa233bd4fp-3},
                {-0x1.3b61dd166d47p2, 0x1.b5daaa233bd5p-3, 0x1.b5daaa233bd4fp-3},
                {0x1.3c011022acbdp37, -0x1.ffd00dc4db401p-4, -0x1.ffd00dc4db4p-4},
                {-0x1.3c011022acbdp37, -0x1.ffd00dc4db401p-4, -0x1.ffd00dc4db4p-4},
                {0x1.3e7788e900b7p727, -0x1.14052b4016ff5p-1, -0x1.14052b4016ff6p-1},
                {-0x1.3e7788e900b7p727, -0x1.14052b4016ff5p-1, -0x1.14052b4016ff6p-1},
                {0x1.423eafdcc2779p-10, 0x1.ffffe6a5e4198p-1, 0x1.ffffe6a5e4197p-1},
                {-0x1.423eafdcc2779p-10, 0x1.ffffe6a5e4198p-1, 0x1.ffffe6a5e4197p-1},
                {0x1.4321828c1b538p119, -0x1.fe09fc3d16feep-6, -0x1.fe09fc3d16fedp-6},
                {-0x1.4321828c1b538p119, -0x1.fe09fc3d16feep-6, -0x1.fe09fc3d16fedp-6},
                {0x1.43506cb22975dp22, 0x1.b685d949a27ap-14, 0x1.b685d949a27a1p-14},
                {-0x1.43506cb22975dp22, 0x1.b685d949a27ap-14, 0x1.b685d949a27a1p-14},
                {0x1.439f63495786ap67, 0x1.fe398090e203cp-1, 0x1.fe398090e203bp-1},
                {-0x1.439f63495786ap67, 0x1.fe398090e203cp-1, 0x1.fe398090e203bp-1},
                {0x1.457538a6bd073p-4, 0x1.fe6274e000974p-1, 0x1.fe6274e000973p-1},
                {-0x1.457538a6bd073p-4, 0x1.fe6274e000974p-1, 0x1.fe6274e000973p-1},
                {0x1.478fc08p43, 0x1.09fcb69359c0ap-1, 0x1.09fcb69359c09p-1},
                {-0x1.478fc08p43, 0x1.09fcb69359c0ap-1, 0x1.09fcb69359c09p-1},
                {0x1.48a45797cbe63p61, -0x1.20c2158511e79p-9, -0x1.20c2158511e78p-9},
                {-0x1.48a45797cbe63p61, -0x1.20c2158511e79p-9, -0x1.20c2158511e78p-9},
                {0x1.4a62e0e12c173p-1, 0x1.990d17aae253p-1, 0x1.990d17aae2531p-1},
                {-0x1.4a62e0e12c173p-1, 0x1.990d17aae253p-1, 0x1.990d17aae2531p-1},
                {0x1.4c596642a9488p9, 0x1.fdd4f1e00b387p-3, 0x1.fdd4f1e00b388p-3},
                {-0x1.4c596642a9488p9, 0x1.fdd4f1e00b387p-3, 0x1.fdd4f1e00b388p-3},
                {0x1.4dp-4, 0x1.fe4f141032f38p-1, 0x1.fe4f141032f37p-1},
                {-0x1.4dp-4, 0x1.fe4f141032f38p-1, 0x1.fe4f141032f37p-1},
                {0x1.4f0f308p488, 0x1.94e9f45d43c14p-2, 0x1.94e9f45d43c13p-2},
                {-0x1.4f0f308p488, 0x1.94e9f45d43c14p-2, 0x1.94e9f45d43c13p-2},
                {0x1.52f00ep793, 0x1.9355f69ad4326p-2, 0x1.9355f69ad4327p-2},
                {-0x1.52f00ep793, 0x1.9355f69ad4326p-2, 0x1.9355f69ad4327p-2},
                {0x1.52f06c730ec02p2, 0x1.1a19be8bea10ap-1, 0x1.1a19be8bea10bp-1},
                {-0x1.52f06c730ec02p2, 0x1.1a19be8bea10ap-1, 0x1.1a19be8bea10bp-1},
                {0x1.53e7d5845fe3dp220, 0x1.385d92ec0c734p-1, 0x1.385d92ec0c733p-1},
                {-0x1.53e7d5845fe3dp220, 0x1.385d92ec0c734p-1, 0x1.385d92ec0c733p-1},
                {0x1.59p-20, 0x1.fffffffffe2f1p-1, 0x1.fffffffffe2fp-1},
                {-0x1.59p-20, 0x1.fffffffffe2f1p-1, 0x1.fffffffffe2fp-1},
                {0x1.592f1176f098p86, -0x1.ffd7bc28ded92p-1, -0x1.ffd7bc28ded91p-1},
                {-0x1.592f1176f098p86, -0x1.ffd7bc28ded92p-1, -0x1.ffd7bc28ded91p-1},
                {0x1.5999999dc09dcp1, -0x1.cee28b3d79799p-1, -0x1.cee28b3d7979ap-1},
                {-0x1.5999999dc09dcp1, -0x1.cee28b3d79799p-1, -0x1.cee28b3d7979ap-1},
                {0x1.5bea01p468, 0x1.c1f1eb08c2604p-1, 0x1.c1f1eb08c2605p-1},
                {-0x1.5bea01p468, 0x1.c1f1eb08c2604p-1, 0x1.c1f1eb08c2605p-1},
                {0x1.5cb80a6135e5ap1000, 0x1.fffe35ab09a65p-1, 0x1.fffe35ab09a66p-1},
                {-0x1.5cb80a6135e5ap1000, 0x1.fffe35ab09a65p-1, 0x1.fffe35ab09a66p-1},
                {0x1.5d5be48730d2dp13, -0x1.07b85f606e75dp-3, -0x1.07b85f606e75ep-3},
                {-0x1.5d5be48730d2dp13, -0x1.07b85f606e75dp-3, -0x1.07b85f606e75ep-3},
                {0x1.614p-21, 0x1.ffffffffff862p-1, 0x1.ffffffffff863p-1},
                {-0x1.614p-21, 0x1.ffffffffff862p-1, 0x1.ffffffffff863p-1},
                {0x1.62adc8a660364p1, -0x1.dd3a806e89cf2p-1, -0x1.dd3a806e89cf1p-1},
                {-0x1.62adc8a660364p1, -0x1.dd3a806e89cf2p-1, -0x1.dd3a806e89cf1p-1},
                {0x1.64ef438p142, -0x1.4308b14f4b6eep-1, -0x1.4308b14f4b6edp-1},
                {-0x1.64ef438p142, -0x1.4308b14f4b6eep-1, -0x1.4308b14f4b6edp-1},
                {0x1.652p0, 0x1.6623d2eb6add2p-3, 0x1.6623d2eb6add1p-3},
                {-0x1.652p0, 0x1.6623d2eb6add2p-3, 0x1.6623d2eb6add1p-3},
                {0x1.65865b2cb08a2p-7, 0x1.fff832c50f472p-1, 0x1.fff832c50f471p-1},
                {-0x1.65865b2cb08a2p-7, 0x1.fff832c50f472p-1, 0x1.fff832c50f471p-1},
                {0x1.6a937daabc20ep375, 0x1.acc251be33023p-1, 0x1.acc251be33022p-1},
                {-0x1.6a937daabc20ep375, 0x1.acc251be33023p-1, 0x1.acc251be33022p-1},
                {0x1.6ac5b262ca1ffp849, -0x1.14ae72e6ba22fp-61, -0x1.14ae72e6ba22ep-61},
                {-0x1.6ac5b262ca1ffp849, -0x1.14ae72e6ba22fp-61, -0x1.14ae72e6ba22ep-61},
                {0x1.6f7bdef7bdef4p3, 0x1.e0619960a11c6p-2, 0x1.e0619960a11c7p-2},
                {-0x1.6f7bdef7bdef4p3, 0x1.e0619960a11c6p-2, 0x1.e0619960a11c7p-2},
                {0x1.739ce759ce738p200, 0x1.8d23f97901a3p-1, 0x1.8d23f97901a31p-1},
                {-0x1.739ce759ce738p200, 0x1.8d23f97901a3p-1, 0x1.8d23f97901a31p-1},
                {0x1.7450c3f49d0b2p-11, 0x1.fffff78a14ba1p-1, 0x1.fffff78a14bap-1},
                {-0x1.7450c3f49d0b2p-11, 0x1.fffff78a14ba1p-1, 0x1.fffff78a14bap-1},
                {0x1.749fe53f963fdp0, 0x1.d6f1c727fb2ccp-4, 0x1.d6f1c727fb2cbp-4},
                {-0x1.749fe53f963fdp0, 0x1.d6f1c727fb2ccp-4, 0x1.d6f1c727fb2cbp-4},
                {0x1.74af6725c6206p1, -0x1.f284b5028c184p-1, -0x1.f284b5028c185p-1},
                {-0x1.74af6725c6206p1, -0x1.f284b5028c184p-1, -0x1.f284b5028c185p-1},
                {0x1.7550d28ffccc4p1, -0x1.f3165a0b306b2p-1, -0x1.f3165a0b306b1p-1},
                {-0x1.7550d28ffccc4p1, -0x1.f3165a0b306b2p-1, -0x1.f3165a0b306b1p-1},
                {0x1.775e397cd6aap6, 0x1.d66d2078ebdecp-1, 0x1.d66d2078ebdebp-1},
                {-0x1.775e397cd6aap6, 0x1.d66d2078ebdecp-1, 0x1.d66d2078ebdebp-1},
                {0x1.799302bf7f29p-1, 0x1.7af9a13085f53p-1, 0x1.7af9a13085f54p-1},
                {-0x1.799302bf7f29p-1, 0x1.7af9a13085f53p-1, 0x1.7af9a13085f54p-1},
                {0x1.799fffffffffdp-6, 0x1.ffdd2fdac0c25p-1, 0x1.ffdd2fdac0c24p-1},
                {-0x1.799fffffffffdp-6, 0x1.ffdd2fdac0c25p-1, 0x1.ffdd2fdac0c24p-1},
                {0x1.7a3692ca9449p-7, 0x1.fff744f185a73p-1, 0x1.fff744f185a74p-1},
                {-0x1.7a3692ca9449p-7, 0x1.fff744f185a73p-1, 0x1.fff744f185a74p-1},
                {0x1.7a66a638ac5b5p-1, 0x1.7a6b326b690fbp-1, 0x1.7a6b326b690fap-1},
                {-0x1.7a66a638ac5b5p-1, 0x1.7a6b326b690fbp-1, 0x1.7a6b326b690fap-1},
                {0x1.7ba65462b49ap0, 0x1.671fdb64ffbeep-4, 0x1.671fdb64ffbedp-4},
                {-0x1.7ba65462b49ap0, 0x1.671fdb64ffbeep-4, 0x1.671fdb64ffbedp-4},
                {0x1.7cdf37cdf37c9p239, 0x1.ffa55490f206ep-1, 0x1.ffa55490f206fp-1},
                {-0x1.7cdf37cdf37c9p239, 0x1.ffa55490f206ep-1, 0x1.ffa55490f206fp-1},
                {0x1.7d542565f472ep0, 0x1.4c5b5970a3a49p-4, 0x1.4c5b5970a3a48p-4},
                {-0x1.7d542565f472ep0, 0x1.4c5b5970a3a49p-4, 0x1.4c5b5970a3a48p-4},
                {0x1.7da0751649058p0, 0x1.479a5667c63f6p-4, 0x1.479a5667c63f5p-4},
                {-0x1.7da0751649058p0, 0x1.479a5667c63f6p-4, 0x1.479a5667c63f5p-4},
                {0x1.7e0ddcda6cc0dp-7, 0x1.fff717511dcb5p-1, 0x1.fff717511dcb6p-1},
                {-0x1.7e0ddcda6cc0dp-7, 0x1.fff717511dcb5p-1, 0x1.fff717511dcb6p-1},
                {0x1.7f6p-21, 0x1.ffffffffff707p-1, 0x1.ffffffffff708p-1},
                {-0x1.7f6p-21, 0x1.ffffffffff707p-1, 0x1.ffffffffff708p-1},
                {0x1.7f90117d44c74p100, -0x1.fff9e1554698p-1, -0x1.fff9e15546981p-1},
                {-0x1.7f90117d44c74p100, -0x1.fff9e1554698p-1, -0x1.fff9e15546981p-1},
                {0x1.7ffffffffef7ap-6, 0x1.ffdc006bff7eap-1, 0x1.ffdc006bff7e9p-1},
                {-0x1.7ffffffffef7ap-6, 0x1.ffdc006bff7eap-1, 0x1.ffdc006bff7e9p-1},
                {0x1.7fffffffffa26p-6, 0x1.ffdc006bff7e8p-1, 0x1.ffdc006bff7e7p-1},
                {-0x1.7fffffffffa26p-6, 0x1.ffdc006bff7e8p-1, 0x1.ffdc006bff7e7p-1},
                {0x1.7ffffffffff8p-6, 0x1.ffdc006bff7e7p-1, 0x1.ffdc006bff7e6p-1},
                {-0x1.7ffffffffff8p-6, 0x1.ffdc006bff7e7p-1, 0x1.ffdc006bff7e6p-1},
                {0x1.80ep-1, 0x1.760718ab44398p-1, 0x1.760718ab44397p-1},
                {-0x1.80ep-1, 0x1.760718ab44398p-1, 0x1.760718ab44397p-1},
                {0x1.81ae0dffa3b33p959, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.81ae0dffa3b33p959, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.81d612289c5cfp1, -0x1.fbdc48125b345p-1, -0x1.fbdc48125b346p-1},
                {-0x1.81d612289c5cfp1, -0x1.fbdc48125b345p-1, -0x1.fbdc48125b346p-1},
                {0x1.8220192270a0ep0, 0x1.ff9e396651ccap-5, 0x1.ff9e396651cc9p-5},
                {-0x1.8220192270a0ep0, 0x1.ff9e396651ccap-5, 0x1.ff9e396651cc9p-5},
                {0x1.822bb780e9104p0, 0x1.fe2b26dddb5c9p-5, 0x1.fe2b26dddb5c8p-5},
                {-0x1.822bb780e9104p0, 0x1.fe2b26dddb5c9p-5, 0x1.fe2b26dddb5c8p-5},
                {0x1.82c119c4b8e49p0, 0x1.eb87cff7c9115p-5, 0x1.eb87cff7c9116p-5},
                {-0x1.82c119c4b8e49p0, 0x1.eb87cff7c9115p-5, 0x1.eb87cff7c9116p-5},
                {0x1.82c119c4b9fc4p0, 0x1.eb87cff7a62b7p-5, 0x1.eb87cff7a62b8p-5},
                {-0x1.82c119c4b9fc4p0, 0x1.eb87cff7a62b7p-5, 0x1.eb87cff7a62b8p-5},
                {0x1.82c119c4ba808p0, 0x1.eb87cff795ab1p-5, 0x1.eb87cff795ab2p-5},
                {-0x1.82c119c4ba808p0, 0x1.eb87cff795ab1p-5, 0x1.eb87cff795ab2p-5},
                {0x1.832c9fc76527p0, 0x1.de1d17ab0d6a5p-5, 0x1.de1d17ab0d6a4p-5},
                {-0x1.832c9fc76527p0, 0x1.de1d17ab0d6a5p-5, 0x1.de1d17ab0d6a4p-5},
                {0x1.833956ce7d1f9p0, 0x1.dc86e7bec0c45p-5, 0x1.dc86e7bec0c44p-5},
                {-0x1.833956ce7d1f9p0, 0x1.dc86e7bec0c45p-5, 0x1.dc86e7bec0c44p-5},
                {0x1.834574eb1c099p0, 0x1.db03cbb942a7bp-5, 0x1.db03cbb942a7ap-5},
                {-0x1.834574eb1c099p0, 0x1.db03cbb942a7bp-5, 0x1.db03cbb942a7ap-5},
                {0x1.83aba5688e13ep0, 0x1.ce431710d1507p-5, 0x1.ce431710d1508p-5},
                {-0x1.83aba5688e13ep0, 0x1.ce431710d1507p-5, 0x1.ce431710d1508p-5},
                {0x1.83b38bbafd75bp0, 0x1.cd46b3a77f6ddp-5, 0x1.cd46b3a77f6dep-5},
                {-0x1.83b38bbafd75bp0, 0x1.cd46b3a77f6ddp-5, 0x1.cd46b3a77f6dep-5},
                {0x1.86a017cb1c31cp16, -0x1.ff29bc666bee7p-1, -0x1.ff29bc666bee6p-1},
                {-0x1.86a017cb1c31cp16, -0x1.ff29bc666bee7p-1, -0x1.ff29bc666bee6p-1},
                {0x1.8720588p392, -0x1.7968916e4c646p-2, -0x1.7968916e4c647p-2},
                {-0x1.8720588p392, -0x1.7968916e4c646p-2, -0x1.7968916e4c647p-2},
                {0x1.88a2288a22888p9, 0x1.fb97c7e452918p-1, 0x1.fb97c7e452917p-1},
                {-0x1.88a2288a22888p9, 0x1.fb97c7e452918p-1, 0x1.fb97c7e452917p-1},
                {0x1.8cf013991c308p1000, -0x1.ae44a5f01bf63p-1, -0x1.ae44a5f01bf64p-1},
                {-0x1.8cf013991c308p1000, -0x1.ae44a5f01bf63p-1, -0x1.ae44a5f01bf64p-1},
                {0x1.9p-2, 0x1.d96e82f71a9dcp-1, 0x1.d96e82f71a9ddp-1},
                {-0x1.9p-2, 0x1.d96e82f71a9dcp-1, 0x1.d96e82f71a9ddp-1},
                {0x1.9p0, 0x1.0fd9d5c093df5p-7, 0x1.0fd9d5c093df4p-7},
                {-0x1.9p0, 0x1.0fd9d5c093df5p-7, 0x1.0fd9d5c093df4p-7},
                {0x1.90000000006bp0, 0x1.0fd9d5c05e5fdp-7, 0x1.0fd9d5c05e5fcp-7},
                {-0x1.90000000006bp0, 0x1.0fd9d5c05e5fdp-7, 0x1.0fd9d5c05e5fcp-7},
                {0x1.900c206d44162p6, 0x1.bc8be725417d8p-1, 0x1.bc8be725417d9p-1},
                {-0x1.900c206d44162p6, 0x1.bc8be725417d8p-1, 0x1.bc8be725417d9p-1},
                {0x1.900c2af7baef3p-19, 0x1.fffffffff63b6p-1, 0x1.fffffffff63b7p-1},
                {-0x1.900c2af7baef3p-19, 0x1.fffffffff63b6p-1, 0x1.fffffffff63b7p-1},
                {0x1.900f11bd8955dp6, 0x1.bd464c9352d11p-1, 0x1.bd464c9352d1p-1},
                {-0x1.900f11bd8955dp6, 0x1.bd464c9352d11p-1, 0x1.bd464c9352d1p-1},
                {0x1.910b35c3253d4p100, 0x1.fffffda85cdd1p-1, 0x1.fffffda85cddp-1},
                {-0x1.910b35c3253d4p100, 0x1.fffffda85cdd1p-1, 0x1.fffffda85cddp-1},
                {0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {-0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {0x1.922p0, -0x1.2aeef4b9ea1aep-18, -0x1.2aeef4b9ea1afp-18},
                {-0x1.922p0, -0x1.2aeef4b9ea1aep-18, -0x1.2aeef4b9ea1afp-18},
                {0x1.9220354442d18p0, -0x1.ffffffffd9048p-18, -0x1.ffffffffd9049p-18},
                {-0x1.9220354442d18p0, -0x1.ffffffffd9048p-18, -0x1.ffffffffd9049p-18},
                {0x1.9251f93aeb59dp12, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.9251f93aeb59dp12, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.943be221d909ap2, 0x1.ffb8c4d1f78a8p-1, 0x1.ffb8c4d1f78a9p-1},
                {-0x1.943be221d909ap2, 0x1.ffb8c4d1f78a8p-1, 0x1.ffb8c4d1f78a9p-1},
                {0x1.94af699302875p-7, 0x1.fff6011fdddabp-1, 0x1.fff6011fdddacp-1},
                {-0x1.94af699302875p-7, 0x1.fff6011fdddabp-1, 0x1.fff6011fdddacp-1},
                {0x1.999999ab7b0edp-2, 0x1.d7954e7a3ee99p-1, 0x1.d7954e7a3ee9ap-1},
                {-0x1.999999ab7b0edp-2, 0x1.d7954e7a3ee99p-1, 0x1.d7954e7a3ee9ap-1},
                {0x1.999999bd4190bp-2, 0x1.d7954e76c8e31p-1, 0x1.d7954e76c8e3p-1},
                {-0x1.999999bd4190bp-2, 0x1.d7954e76c8e31p-1, 0x1.d7954e76c8e3p-1},
                {0x1.9bd0f19479a24p2, 0x1.fa23cfb820224p-1, 0x1.fa23cfb820225p-1},
                {-0x1.9bd0f19479a24p2, 0x1.fa23cfb820224p-1, 0x1.fa23cfb820225p-1},
                {0x1.9c55835e7e83ep8, -0x1.6a09e667f3af1p-1, -0x1.6a09e667f3afp-1},
                {-0x1.9c55835e7e83ep8, -0x1.6a09e667f3af1p-1, -0x1.6a09e667f3afp-1},
                {0x1.9c9942b14448dp-7, 0x1.fff59c1255809p-1, 0x1.fff59c125580ap-1},
                {-0x1.9c9942b14448dp-7, 0x1.fff59c1255809p-1, 0x1.fff59c125580ap-1},
                {0x1.9d3d92485e2b5p523, 0x1.ffece5cab4ca5p-1, 0x1.ffece5cab4ca6p-1},
                {-0x1.9d3d92485e2b5p523, 0x1.ffece5cab4ca5p-1, 0x1.ffece5cab4ca6p-1},
                {0x1.a0d068341a08p1000, -0x1.ff55301d3a781p-5, -0x1.ff55301d3a78p-5},
                {-0x1.a0d068341a08p1000, -0x1.ff55301d3a781p-5, -0x1.ff55301d3a78p-5},
                {0x1.a7ep-1, 0x1.5a5615acd0dcp-1, 0x1.5a5615acd0dc1p-1},
                {-0x1.a7ep-1, 0x1.5a5615acd0dcp-1, 0x1.5a5615acd0dc1p-1},
                {0x1.a858343863965p119, 0x1.766ad27a1de5p-14, 0x1.766ad27a1de4fp-14},
                {-0x1.a858343863965p119, 0x1.766ad27a1de5p-14, 0x1.766ad27a1de4fp-14},
                {0x1.ab190633d88eap3, 0x1.6bd4d5be72494p-1, 0x1.6bd4d5be72493p-1},
                {-0x1.ab190633d88eap3, 0x1.6bd4d5be72494p-1, 0x1.6bd4d5be72493p-1},
                {0x1.af4bd2f4bd2fp-21, 0x1.ffffffffff4a5p-1, 0x1.ffffffffff4a6p-1},
                {-0x1.af4bd2f4bd2fp-21, 0x1.ffffffffff4a5p-1, 0x1.ffffffffff4a6p-1},
                {0x1.afa70300aee6p72, 0x1.7ff2934ad29a8p-1, 0x1.7ff2934ad29a7p-1},
                {-0x1.afa70300aee6p72, 0x1.7ff2934ad29a8p-1, 0x1.7ff2934ad29a7p-1},
                {0x1.b5ab427cffb4cp94, 0x1.ff866aebdce0ap-1, 0x1.ff866aebdce0bp-1},
                {-0x1.b5ab427cffb4cp94, 0x1.ff866aebdce0ap-1, 0x1.ff866aebdce0bp-1},
                {0x1.b951f1572eba5p23, -0x1.f54f5227a4e84p-60, -0x1.f54f5227a4e83p-60},
                {-0x1.b951f1572eba5p23, -0x1.f54f5227a4e84p-60, -0x1.f54f5227a4e83p-60},
                {0x1.b96e5b96e5b91p-8, 0x1.fffd06d35579cp-1, 0x1.fffd06d35579dp-1},
                {-0x1.b96e5b96e5b91p-8, 0x1.fffd06d35579cp-1, 0x1.fffd06d35579dp-1},
                {0x1.ba3b18395d17bp8, -0x1.7c4128e2aff4cp-1, -0x1.7c4128e2aff4bp-1},
                {-0x1.ba3b18395d17bp8, -0x1.7c4128e2aff4cp-1, -0x1.7c4128e2aff4bp-1},
                {0x1.bab62ed655019p970, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.bab62ed655019p970, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.bd55aa411ab46p-13, 0x1.ffffff3e53446p-1, 0x1.ffffff3e53447p-1},
                {-0x1.bd55aa411ab46p-13, 0x1.ffffff3e53446p-1, 0x1.ffffff3e53447p-1},
                {0x1.bd616d4fe95cdp36, -0x1.7fdb07b9f77ep-1, -0x1.7fdb07b9f77e1p-1},
                {-0x1.bd616d4fe95cdp36, -0x1.7fdb07b9f77ep-1, -0x1.7fdb07b9f77e1p-1},
                {0x1.beap-6, 0x1.ffcf4da76222dp-1, 0x1.ffcf4da76222cp-1},
                {-0x1.beap-6, 0x1.ffcf4da76222dp-1, 0x1.ffcf4da76222cp-1},
                {0x1.c11516af585a4p1, -0x1.ddee13357ec6fp-1, -0x1.ddee13357ec7p-1},
                {-0x1.c11516af585a4p1, -0x1.ddee13357ec6fp-1, -0x1.ddee13357ec7p-1},
                {0x1.c75e54de4c06ep2, 0x1.58cccec059da2p-1, 0x1.58cccec059da1p-1},
                {-0x1.c75e54de4c06ep2, 0x1.58cccec059da2p-1, 0x1.58cccec059da1p-1},
                {0x1.cb44e86bc192bp648, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.cb44e86bc192bp648, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.cb44e86bc192bp649, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.cb44e86bc192bp649, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.cd5a6f8762affp1, -0x1.ca281d7fe44bp-1, -0x1.ca281d7fe44b1p-1},
                {-0x1.cd5a6f8762affp1, -0x1.ca281d7fe44bp-1, -0x1.ca281d7fe44b1p-1},
                {0x1.d0cb95f02ad77p464, 0x1.e80ad4fe54c72p-5, 0x1.e80ad4fe54c71p-5},
                {-0x1.d0cb95f02ad77p464, 0x1.e80ad4fe54c72p-5, 0x1.e80ad4fe54c71p-5},
                {0x1.d31bd604903ap2, 0x1.0df8eb409efe4p-1, 0x1.0df8eb409efe3p-1},
                {-0x1.d31bd604903ap2, 0x1.0df8eb409efe4p-1, 0x1.0df8eb409efe3p-1},
                {0x1.d32f4610180f6p-5, 0x1.ff2ae968efe71p-1, 0x1.ff2ae968efe7p-1},
                {-0x1.d32f4610180f6p-5, 0x1.ff2ae968efe71p-1, 0x1.ff2ae968efe7p-1},
                {0x1.d96e058p488, -0x1.cec307a674d3fp-3, -0x1.cec307a674d3ep-3},
                {-0x1.d96e058p488, -0x1.cec307a674d3fp-3, -0x1.cec307a674d3ep-3},
                {0x1.db0803c392b4cp15, -0x1.ac8dbf9cdc955p-5, -0x1.ac8dbf9cdc954p-5},
                {-0x1.db0803c392b4cp15, -0x1.ac8dbf9cdc955p-5, -0x1.ac8dbf9cdc954p-5},
                {0x1.db0803c3ff51dp15, -0x1.ac94870ca6317p-5, -0x1.ac94870ca6316p-5},
                {-0x1.db0803c3ff51dp15, -0x1.ac94870ca6317p-5, -0x1.ac94870ca6316p-5},
                {0x1.dc4p-5, 0x1.ff229073fd8b6p-1, 0x1.ff229073fd8b5p-1},
                {-0x1.dc4p-5, 0x1.ff229073fd8b6p-1, 0x1.ff229073fd8b5p-1},
                {0x1.dcf73dcf73dccp-5, 0x1.ff21e5f976p-1, 0x1.ff21e5f975fffp-1},
                {-0x1.dcf73dcf73dccp-5, 0x1.ff21e5f976p-1, 0x1.ff21e5f975fffp-1},
                {0x1.dffffffffffffp-1, 0x1.2f011326420e5p-1, 0x1.2f011326420e6p-1},
                {-0x1.dffffffffffffp-1, 0x1.2f011326420e5p-1, 0x1.2f011326420e6p-1},
                {0x1.e123691a7c4bep26, 0x1.f72c8e16dbc79p-1, 0x1.f72c8e16dbc78p-1},
                {-0x1.e123691a7c4bep26, 0x1.f72c8e16dbc79p-1, 0x1.f72c8e16dbc78p-1},
                {0x1.e666666f9cf49p0, -0x1.4b0c6bb623f58p-2, -0x1.4b0c6bb623f57p-2},
                {-0x1.e666666f9cf49p0, -0x1.4b0c6bb623f58p-2, -0x1.4b0c6bb623f57p-2},
                {0x1.e83accfc50b7p995, 0x1.fd74b55875885p-1, 0x1.fd74b55875884p-1},
                {-0x1.e83accfc50b7p995, 0x1.fd74b55875885p-1, 0x1.fd74b55875884p-1},
                {0x1.e8ep-7, 0x1.fff169b6ab7d1p-1, 0x1.fff169b6ab7d2p-1},
                {-0x1.e8ep-7, 0x1.fff169b6ab7d1p-1, 0x1.fff169b6ab7d2p-1},
                {0x1.eaf5ea5317442p4, 0x1.7d39c9f1b0b3cp-1, 0x1.7d39c9f1b0b3dp-1},
                {-0x1.eaf5ea5317442p4, 0x1.7d39c9f1b0b3cp-1, 0x1.7d39c9f1b0b3dp-1},
                {0x1.eb0c2b00b1b83p4, 0x1.7f13af7081a68p-1, 0x1.7f13af7081a67p-1},
                {-0x1.eb0c2b00b1b83p4, 0x1.7f13af7081a68p-1, 0x1.7f13af7081a67p-1},
                {0x1.ebc6b555311c4p15, -0x1.7ad7b88a1fe1p-1, -0x1.7ad7b88a1fe0fp-1},
                {-0x1.ebc6b555311c4p15, -0x1.7ad7b88a1fe1p-1, -0x1.7ad7b88a1fe0fp-1},
                {0x1.ef7bdef7bdef2p239, 0x1.b06b2b58a2a24p-5, 0x1.b06b2b58a2a23p-5},
                {-0x1.ef7bdef7bdef2p239, 0x1.b06b2b58a2a24p-5, 0x1.b06b2b58a2a23p-5},
                {0x1.efbbeefbbeef8p15, 0x1.fe6ded53172a7p-1, 0x1.fe6ded53172a6p-1},
                {-0x1.efbbeefbbeef8p15, 0x1.fe6ded53172a7p-1, 0x1.fe6ded53172a6p-1},
                {0x1.f07c1f07c1ef7p239, -0x1.fe2bcb87a7e16p-1, -0x1.fe2bcb87a7e15p-1},
                {-0x1.f07c1f07c1ef7p239, -0x1.fe2bcb87a7e16p-1, -0x1.fe2bcb87a7e15p-1},
                {0x1.f0f2b5e060b29p1, -0x1.79d08d6b3a883p-1, -0x1.79d08d6b3a882p-1},
                {-0x1.f0f2b5e060b29p1, -0x1.79d08d6b3a883p-1, -0x1.79d08d6b3a882p-1},
                {0x1.f4p-3, 0x1.f0d11d321178ep-1, 0x1.f0d11d321178dp-1},
                {-0x1.f4p-3, 0x1.f0d11d321178ep-1, 0x1.f0d11d321178dp-1},
                {0x1.f43d49f947e87p9, 0x1.e3ff5b15f723ep-4, 0x1.e3ff5b15f723dp-4},
                {-0x1.f43d49f947e87p9, 0x1.e3ff5b15f723ep-4, 0x1.e3ff5b15f723dp-4},
                {0x1.f7fffffffffffp1, -0x1.6636c9f6a87aap-1, -0x1.6636c9f6a87a9p-1},
                {-0x1.f7fffffffffffp1, -0x1.6636c9f6a87aap-1, -0x1.6636c9f6a87a9p-1},
                {0x1.f8fffffffffffp-6, 0x1.ffc1be3309286p-1, 0x1.ffc1be3309285p-1},
                {-0x1.f8fffffffffffp-6, 0x1.ffc1be3309286p-1, 0x1.ffc1be3309285p-1},
                {0x1.f9p-6, 0x1.ffc1be3309285p-1, 0x1.ffc1be3309286p-1},
                {-0x1.f9p-6, 0x1.ffc1be3309285p-1, 0x1.ffc1be3309286p-1},
                {0x1.fa0236523ce54p344, -0x1.fffffffcab0d6p-1, -0x1.fffffffcab0d5p-1},
                {-0x1.fa0236523ce54p344, -0x1.fffffffcab0d6p-1, -0x1.fffffffcab0d5p-1},
                {0x1.fceab54d37dap-4, 0x1.fc0d98ace2308p-1, 0x1.fc0d98ace2309p-1},
                {-0x1.fceab54d37dap-4, 0x1.fc0d98ace2308p-1, 0x1.fc0d98ace2309p-1},
                {0x1.fd0072fffffffp2, -0x1.9589bca128b92p-4, -0x1.9589bca128b91p-4},
                {-0x1.fd0072fffffffp2, -0x1.9589bca128b92p-4, -0x1.9589bca128b91p-4},
                {0x1.fe0f827673422p62, -0x1.4d304b07fc898p-2, -0x1.4d304b07fc897p-2},
                {-0x1.fe0f827673422p62, -0x1.4d304b07fc898p-2, -0x1.4d304b07fc897p-2},
                {0x1.feb1f7920e248p-2, 0x1.c1a27ae836f13p-1, 0x1.c1a27ae836f12p-1},
                {-0x1.feb1f7920e248p-2, 0x1.c1a27ae836f13p-1, 0x1.c1a27ae836f12p-1},
                {0x1.feeffffffffc6p995, -0x1.936b64e955979p-1, -0x1.936b64e955978p-1},
                {-0x1.feeffffffffc6p995, -0x1.936b64e955979p-1, -0x1.936b64e955978p-1},
                {0x1.ff8ffffffffffp-7, 0x1.fff007147ea57p-1, 0x1.fff007147ea58p-1},
                {-0x1.ff8ffffffffffp-7, 0x1.fff007147ea57p-1, 0x1.fff007147ea58p-1},
                {0x1.ff8ffffffffffp-10, 0x1.ffffc01bfe443p-1, 0x1.ffffc01bfe442p-1},
                {-0x1.ff8ffffffffffp-10, 0x1.ffffc01bfe443p-1, 0x1.ffffc01bfe442p-1},
                {0x1.ff8ffffffffffp870, 0x1.7cc9fb75317aep-1, 0x1.7cc9fb75317afp-1},
                {-0x1.ff8ffffffffffp870, 0x1.7cc9fb75317aep-1, 0x1.7cc9fb75317afp-1},
                {0x1.ffcfff8p19, 0x1.d6aea48015589p-1, 0x1.d6aea48015588p-1},
                {-0x1.ffcfff8p19, 0x1.d6aea48015589p-1, 0x1.d6aea48015588p-1},
                {0x1.ffcfff8p365, -0x1.6a9972eee19bbp-2, -0x1.6a9972eee19bap-2},
                {-0x1.ffcfff8p365, -0x1.6a9972eee19bbp-2, -0x1.6a9972eee19bap-2},
                {0x1.ffcffffffff6cp720, -0x1.3aaa15f7544b7p-1, -0x1.3aaa15f7544b6p-1},
                {-0x1.ffcffffffff6cp720, -0x1.3aaa15f7544b7p-1, -0x1.3aaa15f7544b6p-1},
                {0x1.ffcfffffffff9p320, 0x1.3f164bce055c5p-1, 0x1.3f164bce055c4p-1},
                {-0x1.ffcfffffffff9p320, 0x1.3f164bce055c5p-1, 0x1.3f164bce055c4p-1},
                {0x1.ffcffffffffffp-11, 0x1.fffff002fff15p-1, 0x1.fffff002fff14p-1},
                {-0x1.ffcffffffffffp-11, 0x1.fffff002fff15p-1, 0x1.fffff002fff14p-1},
                {0x1.ffcffffffffffp405, -0x1.ffffff987f986p-1, -0x1.ffffff987f985p-1},
                {-0x1.ffcffffffffffp405, -0x1.ffffff987f986p-1, -0x1.ffffff987f985p-1},
                {0x1.ffcffffffffffp567, -0x1.ffff6235a25eep-1, -0x1.ffff6235a25edp-1},
                {-0x1.ffcffffffffffp567, -0x1.ffff6235a25eep-1, -0x1.ffff6235a25edp-1},
                {0x1.ffefff8ffffffp16, 0x1.fdf11ae4608b1p-3, 0x1.fdf11ae4608bp-3},
                {-0x1.ffefff8ffffffp16, 0x1.fdf11ae4608b1p-3, 0x1.fdf11ae4608bp-3},
                {0x1.ffeffffffffccp995, 0x1.8f5525ab4583cp-1, 0x1.8f5525ab4583dp-1},
                {-0x1.ffeffffffffccp995, 0x1.8f5525ab4583cp-1, 0x1.8f5525ab4583dp-1},
                {0x1.ffeffffffffffp77, 0x1.a0af44a45c057p-8, 0x1.a0af44a45c056p-8},
                {-0x1.ffeffffffffffp77, 0x1.a0af44a45c057p-8, 0x1.a0af44a45c056p-8},
                {0x1.ffeffffffffffp122, -0x1.df7546c31bf8dp-1, -0x1.df7546c31bf8cp-1},
                {-0x1.ffeffffffffffp122, -0x1.df7546c31bf8dp-1, -0x1.df7546c31bf8cp-1},
                {0x1.ffeffffffffffp179, -0x1.825a7bea27d5bp-1, -0x1.825a7bea27d5cp-1},
                {-0x1.ffeffffffffffp179, -0x1.825a7bea27d5bp-1, -0x1.825a7bea27d5cp-1},
                {0x1.ffeffffffffffp238, -0x1.1be2ab2078d54p-1, -0x1.1be2ab2078d55p-1},
                {-0x1.ffeffffffffffp238, -0x1.1be2ab2078d54p-1, -0x1.1be2ab2078d55p-1},
                {0x1.fff0000002511p492, -0x1.a4cc5f838f529p-7, -0x1.a4cc5f838f52ap-7},
                {-0x1.fff0000002511p492, -0x1.a4cc5f838f529p-7, -0x1.a4cc5f838f52ap-7},
                {0x1.fff1fffffffffp41, 0x1.f16437d6119f9p-10, 0x1.f16437d6119f8p-10},
                {-0x1.fff1fffffffffp41, 0x1.f16437d6119f9p-10, 0x1.f16437d6119f8p-10},
                {0x1.ffffc7fffffffp45, 0x1.898324c2f1cfcp-11, 0x1.898324c2f1cfdp-11},
                {-0x1.ffffc7fffffffp45, 0x1.898324c2f1cfcp-11, 0x1.898324c2f1cfdp-11},
                {0x1.ffffdf1ffffffp-3, 0x1.f0154c00688f8p-1, 0x1.f0154c00688f9p-1},
                {-0x1.ffffdf1ffffffp-3, 0x1.f0154c00688f8p-1, 0x1.f0154c00688f9p-1},
                {0x1.fffff8fffffffp-6, 0x1.ffc00157126a8p-1, 0x1.ffc00157126a7p-1},
                {-0x1.fffff8fffffffp-6, 0x1.ffc00157126a8p-1, 0x1.ffc00157126a7p-1},
                {0x1.fffffbfffffffp968, -0x1.e0d9f0f38c73fp-2, -0x1.e0d9f0f38c74p-2},
                {-0x1.fffffbfffffffp968, -0x1.e0d9f0f38c73fp-2, -0x1.e0d9f0f38c74p-2},
                {0x1.fffffcfffffffp40, 0x1.fff4699dd560bp-1, 0x1.fff4699dd560cp-1},
                {-0x1.fffffcfffffffp40, 0x1.fff4699dd560bp-1, 0x1.fff4699dd560cp-1},
                {0x1.ffffff000004p-5, 0x1.ff0015559f228p-1, 0x1.ff0015559f229p-1},
                {-0x1.ffffff000004p-5, 0x1.ff0015559f228p-1, 0x1.ff0015559f229p-1},
                {0x1.ffffff8p119, -0x1.9c6951cccd39cp-2, -0x1.9c6951cccd39bp-2},
                {-0x1.ffffff8p119, -0x1.9c6951cccd39cp-2, -0x1.9c6951cccd39bp-2},
                {0x1.ffffff8p192, -0x1.f2c2263590035p-1, -0x1.f2c2263590034p-1},
                {-0x1.ffffff8p192, -0x1.f2c2263590035p-1, -0x1.f2c2263590034p-1},
                {0x1.ffffff8p543, 0x1.c7884d6cfb551p-1, 0x1.c7884d6cfb552p-1},
                {-0x1.ffffff8p543, 0x1.c7884d6cfb551p-1, 0x1.c7884d6cfb552p-1},
                {0x1.ffffffc3fffffp500, 0x1.e66c79e776a1fp-2, 0x1.e66c79e776a1ep-2},
                {-0x1.ffffffc3fffffp500, 0x1.e66c79e776a1fp-2, 0x1.e66c79e776a1ep-2},
                {0x1.ffffffe1fffffp700, 0x1.c7c9a9c57c0b2p-3, 0x1.c7c9a9c57c0b3p-3},
                {-0x1.ffffffe1fffffp700, 0x1.c7c9a9c57c0b2p-3, 0x1.c7c9a9c57c0b3p-3},
                {0x1.ffffffff0f0ffp400, 0x1.7bb28daf5f9aep-1, 0x1.7bb28daf5f9adp-1},
                {-0x1.ffffffff0f0ffp400, 0x1.7bb28daf5f9aep-1, 0x1.7bb28daf5f9adp-1},
                {0x1.ffffffff3ffffp-4, 0x1.fc015527d8bb3p-1, 0x1.fc015527d8bb4p-1},
                {-0x1.ffffffff3ffffp-4, 0x1.fc015527d8bb3p-1, 0x1.fc015527d8bb4p-1},
                {0x1.ffffffff8ffffp3, -0x1.ea5257eb66e3cp-1, -0x1.ea5257eb66e3bp-1},
                {-0x1.ffffffff8ffffp3, -0x1.ea5257eb66e3cp-1, -0x1.ea5257eb66e3bp-1},
                {0x1.fffffffffbcffp1, -0x1.4eaa606dbef97p-1, -0x1.4eaa606dbef96p-1},
                {-0x1.fffffffffbcffp1, -0x1.4eaa606dbef97p-1, -0x1.4eaa606dbef96p-1},
                {0x1.fffffffffe0b5p720, -0x1.fc9cd6b5f0095p-1, -0x1.fc9cd6b5f0094p-1},
                {-0x1.fffffffffe0b5p720, -0x1.fc9cd6b5f0095p-1, -0x1.fc9cd6b5f0094p-1},
                {0x1.fffffffffe7ffp41, 0x1.e96ac045dd139p-3, 0x1.e96ac045dd138p-3},
                {-0x1.fffffffffe7ffp41, 0x1.e96ac045dd139p-3, 0x1.e96ac045dd138p-3},
                {0x1.fffffffffee09p720, -0x1.fcaf39cfb94d5p-1, -0x1.fcaf39cfb94d4p-1},
                {-0x1.fffffffffee09p720, -0x1.fcaf39cfb94d5p-1, -0x1.fcaf39cfb94d4p-1},
                {0x1.ffffffffffdffp40, 0x1.8432232a6d1dap-1, 0x1.8432232a6d1dbp-1},
                {-0x1.ffffffffffdffp40, 0x1.8432232a6d1dap-1, 0x1.8432232a6d1dbp-1},
                {0x1.ffffffffffeffp41, 0x1.9e375143139dap-6, 0x1.9e375143139d9p-6},
                {-0x1.ffffffffffeffp41, 0x1.9e375143139dap-6, 0x1.9e375143139d9p-6},
                {0x1.fffffffffff4ap-8, 0x1.fffc000155552p-1, 0x1.fffc000155553p-1},
                {-0x1.fffffffffff4ap-8, 0x1.fffc000155552p-1, 0x1.fffc000155553p-1},
                {0x1.fffffffffff78p920, 0x1.463a895c4ea5dp-1, 0x1.463a895c4ea5cp-1},
                {-0x1.fffffffffff78p920, 0x1.463a895c4ea5dp-1, 0x1.463a895c4ea5cp-1},
                {0x1.fffffffffffd5p995, 0x1.3c1a48635cf38p-1, 0x1.3c1a48635cf39p-1},
                {-0x1.fffffffffffd5p995, 0x1.3c1a48635cf38p-1, 0x1.3c1a48635cf39p-1},
                {0x1.fffffffffffe8p720, 0x1.91c4e0708bd48p-1, 0x1.91c4e0708bd49p-1},
                {-0x1.fffffffffffe8p720, 0x1.91c4e0708bd48p-1, 0x1.91c4e0708bd49p-1},
                {0x1.fffffffffffebp920, -0x1.3e15cb849b5eap-1, -0x1.3e15cb849b5ebp-1},
                {-0x1.fffffffffffebp920, -0x1.3e15cb849b5eap-1, -0x1.3e15cb849b5ebp-1},
                {0x1.ffffffffffff1p245, -0x1.816808349b80ep-1, -0x1.816808349b80dp-1},
                {-0x1.ffffffffffff1p245, -0x1.816808349b80ep-1, -0x1.816808349b80dp-1},
                {0x1.ffffffffffff4p845, 0x1.4699c814c5f07p-1, 0x1.4699c814c5f08p-1},
                {-0x1.ffffffffffff4p845, 0x1.4699c814c5f07p-1, 0x1.4699c814c5f08p-1},
                {0x1.ffffffffffff4p1020, -0x1.815e92b7a2a01p-1, -0x1.815e92b7a2a02p-1},
                {-0x1.ffffffffffff4p1020, -0x1.815e92b7a2a01p-1, -0x1.815e92b7a2a02p-1},
                {0x1.ffffffffffffcp45, -0x1.3e8d028153202p-10, -0x1.3e8d028153201p-10},
                {-0x1.ffffffffffffcp45, -0x1.3e8d028153202p-10, -0x1.3e8d028153201p-10},
                {0x1.ffffffffffffep105, 0x1.7d6765714c786p-1, 0x1.7d6765714c785p-1},
                {-0x1.ffffffffffffep105, 0x1.7d6765714c786p-1, 0x1.7d6765714c785p-1},
                {0x1.ffffffffffffep480, -0x1.f869fb14d2569p-3, -0x1.f869fb14d2568p-3},
                {-0x1.ffffffffffffep480, -0x1.f869fb14d2569p-3, -0x1.f869fb14d2568p-3},
                {0x1.ffffffffffffep970, -0x1.80a75b369d3c4p-1, -0x1.80a75b369d3c3p-1},
                {-0x1.ffffffffffffep970, -0x1.80a75b369d3c4p-1, -0x1.80a75b369d3c3p-1},
                {0x1.0000000000001p42, -0x1.9dba69e853bd8p-4, -0x1.9dba69e853bd7p-4},
                {-0x1.0000000000001p42, -0x1.9dba69e853bd8p-4, -0x1.9dba69e853bd7p-4},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0p0, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.999999999999ap-13, 0x1.ffffff5c28f5dp-1, 0x1.ffffff5c28f5cp-1},
                {-0x1.999999999999ap-13, 0x1.ffffff5c28f5dp-1, 0x1.ffffff5c28f5cp-1},
                {0x1.999999999999ap-12, 0x1.fffffd70a3d79p-1, 0x1.fffffd70a3d7ap-1},
                {-0x1.999999999999ap-12, 0x1.fffffd70a3d79p-1, 0x1.fffffd70a3d7ap-1},
                {0x1.3333333333334p-11, 0x1.fffffa3d70a6ap-1, 0x1.fffffa3d70a69p-1},
                {-0x1.3333333333334p-11, 0x1.fffffa3d70a6ap-1, 0x1.fffffa3d70a69p-1},
                {0x1.999999999999ap-11, 0x1.fffff5c28f64ep-1, 0x1.fffff5c28f64fp-1},
                {-0x1.999999999999ap-11, 0x1.fffff5c28f64ep-1, 0x1.fffff5c28f64fp-1},
                {0x1.0p-10, 0x1.fffff00000155p-1, 0x1.fffff00000156p-1},
                {-0x1.0p-10, 0x1.fffff00000155p-1, 0x1.fffff00000156p-1},
                {0x1.3333333333333p-10, 0x1.ffffe8f5c2bbap-1, 0x1.ffffe8f5c2bb9p-1},
                {-0x1.3333333333333p-10, 0x1.ffffe8f5c2bbap-1, 0x1.ffffe8f5c2bb9p-1},
                {0x1.6666666666666p-10, 0x1.ffffe0a3d75c3p-1, 0x1.ffffe0a3d75c4p-1},
                {-0x1.6666666666666p-10, 0x1.ffffe0a3d75c3p-1, 0x1.ffffe0a3d75c4p-1},
                {0x1.9999999999999p-10, 0x1.ffffd70a3dfc7p-1, 0x1.ffffd70a3dfc8p-1},
                {-0x1.9999999999999p-10, 0x1.ffffd70a3dfc7p-1, 0x1.ffffd70a3dfc8p-1},
                {0x1.cccccccccccccp-10, 0x1.ffffcc28f6a28p-1, 0x1.ffffcc28f6a29p-1},
                {-0x1.cccccccccccccp-10, 0x1.ffffcc28f6a28p-1, 0x1.ffffcc28f6a29p-1},
                {0x1.0666666666666p-7, 0x1.fffbcc2a6e87p-1, 0x1.fffbcc2a6e86fp-1},
                {-0x1.0666666666666p-7, 0x1.fffbcc2a6e87p-1, 0x1.fffbcc2a6e86fp-1},
                {0x1.cccccccccccccp-7, 0x1.fff30a4b6fcc1p-1, 0x1.fff30a4b6fcc2p-1},
                {-0x1.cccccccccccccp-7, 0x1.fff30a4b6fcc1p-1, 0x1.fff30a4b6fcc2p-1},
                {0x1.4999999999999p-6, 0x1.ffe57a780f38cp-1, 0x1.ffe57a780f38dp-1},
                {-0x1.4999999999999p-6, 0x1.ffe57a780f38cp-1, 0x1.ffe57a780f38dp-1},
                {0x1.accccccccccccp-6, 0x1.ffd31cd0e1d63p-1, 0x1.ffd31cd0e1d62p-1},
                {-0x1.accccccccccccp-6, 0x1.ffd31cd0e1d63p-1, 0x1.ffd31cd0e1d62p-1},
                {0x1.08p-5, 0x1.ffbbf18207543p-1, 0x1.ffbbf18207542p-1},
                {-0x1.08p-5, 0x1.ffbbf18207543p-1, 0x1.ffbbf18207542p-1},
                {0x1.399999999999ap-5, 0x1.ff9ff8c3299f5p-1, 0x1.ff9ff8c3299f6p-1},
                {-0x1.399999999999ap-5, 0x1.ff9ff8c3299f5p-1, 0x1.ff9ff8c3299f6p-1},
                {0x1.6b33333333334p-5, 0x1.ff7f32d77c5b2p-1, 0x1.ff7f32d77c5b1p-1},
                {-0x1.6b33333333334p-5, 0x1.ff7f32d77c5b2p-1, 0x1.ff7f32d77c5b1p-1},
                {0x1.9cccccccccccep-5, 0x1.ff59a00dbc409p-1, 0x1.ff59a00dbc408p-1},
                {-0x1.9cccccccccccep-5, 0x1.ff59a00dbc409p-1, 0x1.ff59a00dbc408p-1},
                {0x1.ce66666666666p-5, 0x1.ff2f40c02e60fp-1, 0x1.ff2f40c02e61p-1},
                {-0x1.ce66666666666p-5, 0x1.ff2f40c02e60fp-1, 0x1.ff2f40c02e61p-1},
                {0x1.5e7fc4369bdadp-1, 0x1.8ca46c7d8975ep-1, 0x1.8ca46c7d8975fp-1},
                {-0x1.5e7fc4369bdadp-1, 0x1.8ca46c7d8975ep-1, 0x1.8ca46c7d8975fp-1},
                {0x1.4e7fc4369bdadp0, 0x1.0b5d3802fc799p-2, 0x1.0b5d3802fc79ap-2},
                {-0x1.4e7fc4369bdadp0, 0x1.0b5d3802fc799p-2, 0x1.0b5d3802fc79ap-2},
                {0x1.edbfa651e9c84p0, -0x1.66b96f53323afp-2, -0x1.66b96f53323bp-2},
                {-0x1.edbfa651e9c84p0, -0x1.66b96f53323afp-2, -0x1.66b96f53323bp-2},
                {0x1.467fc4369bdadp1, -0x1.a93554888c33p-1, -0x1.a93554888c32fp-1},
                {-0x1.467fc4369bdadp1, -0x1.a93554888c33p-1, -0x1.a93554888c32fp-1},
                {0x1.961fb54442d18p1, -0x1.ffc00155527d3p-1, -0x1.ffc00155527d2p-1},
                {-0x1.961fb54442d18p1, -0x1.ffc00155527d3p-1, -0x1.ffc00155527d2p-1},
                {0x1.e5bfa651e9c83p1, -0x1.96907c5c7c25cp-1, -0x1.96907c5c7c25bp-1},
                {-0x1.e5bfa651e9c83p1, -0x1.96907c5c7c25cp-1, -0x1.96907c5c7c25bp-1},
                {0x1.1aafcbafc85f7p2, -0x1.2a1e5a50f948dp-2, -0x1.2a1e5a50f948cp-2},
                {-0x1.1aafcbafc85f7p2, -0x1.2a1e5a50f948dp-2, -0x1.2a1e5a50f948cp-2},
                {0x1.427fc4369bdadp2, 0x1.4894f695dc56cp-2, 0x1.4894f695dc56bp-2},
                {-0x1.427fc4369bdadp2, 0x1.4894f695dc56cp-2, 0x1.4894f695dc56bp-2},
                {0x1.6a4fbcbd6f562p2, 0x1.a016ea3a692cep-1, 0x1.a016ea3a692cfp-1},
                {-0x1.6a4fbcbd6f562p2, 0x1.a016ea3a692cep-1, 0x1.a016ea3a692cfp-1},
                {0x1.6af2eff0a2896p2, 0x1.a30a69f5537ecp-1, 0x1.a30a69f5537ebp-1},
                {-0x1.6af2eff0a2896p2, 0x1.a30a69f5537ecp-1, 0x1.a30a69f5537ebp-1},
                {0x1.43c62a9d02414p2, 0x1.5bd62e8b04ad6p-2, 0x1.5bd62e8b04ad5p-2},
                {-0x1.43c62a9d02414p2, 0x1.5bd62e8b04ad6p-2, 0x1.5bd62e8b04ad5p-2},
                {0x1.1c99654961f92p2, -0x1.0cb71f671e634p-2, -0x1.0cb71f671e635p-2},
                {-0x1.1c99654961f92p2, -0x1.0cb71f671e634p-2, -0x1.0cb71f671e635p-2},
                {0x1.ead93feb8361fp1, -0x1.89d86aa8521c1p-1, -0x1.89d86aa8521c2p-1},
                {-0x1.ead93feb8361fp1, -0x1.89d86aa8521c1p-1, -0x1.89d86aa8521c2p-1},
                {0x1.9c7fb54442d1ap1, -0x1.fe51ac554a16bp-1, -0x1.fe51ac554a16ap-1},
                {-0x1.9c7fb54442d1ap1, -0x1.fe51ac554a16bp-1, -0x1.fe51ac554a16ap-1},
                {0x1.4e262a9d02415p1, -0x1.b97c04d08bc5dp-1, -0x1.b97c04d08bc5ep-1},
                {-0x1.4e262a9d02415p1, -0x1.b97c04d08bc5dp-1, -0x1.b97c04d08bc5ep-1},
                {0x1.ff993feb8362p0, -0x1.a8ac8a3e58f6dp-2, -0x1.a8ac8a3e58f6cp-2},
                {-0x1.ff993feb8362p0, -0x1.a8ac8a3e58f6dp-2, -0x1.a8ac8a3e58f6cp-2},
                {0x1.62e62a9d02416p0, 0x1.77a8b9b3d254bp-3, 0x1.77a8b9b3d254ap-3},
                {-0x1.62e62a9d02416p0, 0x1.77a8b9b3d254bp-3, 0x1.77a8b9b3d254ap-3},
                {0x1.8c662a9d02419p-1, 0x1.6e1061205dd79p-1, 0x1.6e1061205dd7ap-1},
                {-0x1.8c662a9d02419p-1, 0x1.6e1061205dd79p-1, 0x1.6e1061205dd7ap-1},
                {-0x1.a8aa1d11c44ffp0, -0x1.682f3cc3c7a09p-4, -0x1.682f3cc3c7a08p-4},
                {0x1.a8aa1d11c44ffp0, -0x1.682f3cc3c7a09p-4, -0x1.682f3cc3c7a08p-4},
                {-0x1.95ec8b9e03d54p0, -0x1.e6669a270c36dp-7, -0x1.e6669a270c36ep-7},
                {0x1.95ec8b9e03d54p0, -0x1.e6669a270c36dp-7, -0x1.e6669a270c36ep-7},
                {-0x1.832efa2a435a9p0, 0x1.ddd1ec25e209fp-5, 0x1.ddd1ec25e20ap-5},
                {0x1.832efa2a435a9p0, 0x1.ddd1ec25e209fp-5, 0x1.ddd1ec25e20ap-5},
                {-0x1.707168b682dfep0, 0x1.0cab9115640dap-3, 0x1.0cab9115640d9p-3},
                {0x1.707168b682dfep0, 0x1.0cab9115640dap-3, 0x1.0cab9115640d9p-3},
                {-0x1.5db3d742c2653p0, 0x1.a0723a95492eep-3, 0x1.a0723a95492edp-3},
                {0x1.5db3d742c2653p0, 0x1.a0723a95492eep-3, 0x1.a0723a95492edp-3},
                {-0x1.4af645cf01ea8p0, 0x1.18fee96a1a586p-2, 0x1.18fee96a1a585p-2},
                {0x1.4af645cf01ea8p0, 0x1.18fee96a1a586p-2, 0x1.18fee96a1a585p-2},
                {-0x1.3838b45b416fdp0, 0x1.6043621b13be3p-2, 0x1.6043621b13be2p-2},
                {0x1.3838b45b416fdp0, 0x1.6043621b13be3p-2, 0x1.6043621b13be2p-2},
                {-0x1.257b22e780f52p0, 0x1.a5a4ccf40d9dap-2, 0x1.a5a4ccf40d9d9p-2},
                {0x1.257b22e780f52p0, 0x1.a5a4ccf40d9dap-2, 0x1.a5a4ccf40d9d9p-2},
                {-0x1.12bd9173c07abp0, 0x1.e8c405f36f85cp-2, 0x1.e8c405f36f85bp-2},
                {0x1.12bd9173c07abp0, 0x1.e8c405f36f85cp-2, 0x1.e8c405f36f85bp-2},
                {-0x1.ea5c3ed5b385p-1, 0x1.26976a6c4e0f8p-1, 0x1.26976a6c4e0f9p-1},
                {0x1.ea5c3ed5b385p-1, 0x1.26976a6c4e0f8p-1, 0x1.26976a6c4e0f9p-1},
                {-0x1.d4b87dab670ap-1, 0x1.3805a1882009fp-1, 0x1.3805a188200ap-1},
                {0x1.d4b87dab670ap-1, 0x1.3805a1882009fp-1, 0x1.3805a188200ap-1},
                {-0x1.bf14bc811a8fp-1, 0x1.48e52e0a65bcbp-1, 0x1.48e52e0a65bccp-1},
                {0x1.bf14bc811a8fp-1, 0x1.48e52e0a65bcbp-1, 0x1.48e52e0a65bccp-1},
                {-0x1.a970fb56ce14p-1, 0x1.592e58ea0a9efp-1, 0x1.592e58ea0a9eep-1},
                {0x1.a970fb56ce14p-1, 0x1.592e58ea0a9efp-1, 0x1.592e58ea0a9eep-1},
                {-0x1.93cd3a2c8199p-1, 0x1.68d9afe052d1fp-1, 0x1.68d9afe052d2p-1},
                {0x1.93cd3a2c8199p-1, 0x1.68d9afe052d1fp-1, 0x1.68d9afe052d2p-1},
                {-0x1.7e297902351ep-1, 0x1.77e008d0775e7p-1, 0x1.77e008d0775e8p-1},
                {0x1.7e297902351ep-1, 0x1.77e008d0775e7p-1, 0x1.77e008d0775e8p-1},
                {-0x1.6885b7d7e8a3p-1, 0x1.863a850e438fep-1, 0x1.863a850e438ffp-1},
                {0x1.6885b7d7e8a3p-1, 0x1.863a850e438fep-1, 0x1.863a850e438ffp-1},
                {-0x1.52e1f6ad9c28p-1, 0x1.93e2948233fcep-1, 0x1.93e2948233fcfp-1},
                {0x1.52e1f6ad9c28p-1, 0x1.93e2948233fcep-1, 0x1.93e2948233fcfp-1},
                {-0x1.3d3e35834fadp-1, 0x1.a0d1f8a9a791dp-1, 0x1.a0d1f8a9a791ep-1},
                {0x1.3d3e35834fadp-1, 0x1.a0d1f8a9a791dp-1, 0x1.a0d1f8a9a791ep-1},
                {-0x1.0a0b02501c799p-1, 0x1.bc6bd861e13dep-1, 0x1.bc6bd861e13dfp-1},
                {0x1.0a0b02501c799p-1, 0x1.bc6bd861e13dep-1, 0x1.bc6bd861e13dfp-1},
                {-0x1.d8f7208e6b82cp-2, 0x1.ca59c6fa3d9cep-1, 0x1.ca59c6fa3d9cfp-1},
                {0x1.d8f7208e6b82cp-2, 0x1.ca59c6fa3d9cep-1, 0x1.ca59c6fa3d9cfp-1},
                {-0x1.9dd83c7c9e126p-2, 0x1.d6c0b125791dp-1, 0x1.d6c0b125791cfp-1},
                {0x1.9dd83c7c9e126p-2, 0x1.d6c0b125791dp-1, 0x1.d6c0b125791cfp-1},
                {-0x1.62b9586ad0a2p-2, 0x1.e196026182986p-1, 0x1.e196026182985p-1},
                {0x1.62b9586ad0a2p-2, 0x1.e196026182986p-1, 0x1.e196026182985p-1},
                {-0x1.279a74590331ap-2, 0x1.ead07cc635696p-1, 0x1.ead07cc635697p-1},
                {0x1.279a74590331ap-2, 0x1.ead07cc635696p-1, 0x1.ead07cc635697p-1},
                {-0x1.d8f7208e6b829p-3, 0x1.f26840e7b2189p-1, 0x1.f26840e7b2188p-1},
                {0x1.d8f7208e6b829p-3, 0x1.f26840e7b2189p-1, 0x1.f26840e7b2188p-1},
                {-0x1.62b9586ad0a1ep-3, 0x1.f856d48db797ep-1, 0x1.f856d48db797dp-1},
                {0x1.62b9586ad0a1ep-3, 0x1.f856d48db797ep-1, 0x1.f856d48db797dp-1},
                {-0x1.d8f7208e6b826p-4, 0x1.fc97283a42479p-1, 0x1.fc97283a4247ap-1},
                {0x1.d8f7208e6b826p-4, 0x1.fc97283a42479p-1, 0x1.fc97283a4247ap-1},
                {-0x1.d8f7208e6b82dp-5, 0x1.ff259b7ab9f5p-1, 0x1.ff259b7ab9f4fp-1},
                {0x1.d8f7208e6b82dp-5, 0x1.ff259b7ab9f5p-1, 0x1.ff259b7ab9f4fp-1},
                {0x1.d8f7208e6b82dp-5, 0x1.ff259b7ab9f5p-1, 0x1.ff259b7ab9f4fp-1},
                {-0x1.d8f7208e6b82dp-5, 0x1.ff259b7ab9f5p-1, 0x1.ff259b7ab9f4fp-1},
                {0x1.d8f7208e6b82dp-4, 0x1.fc97283a42479p-1, 0x1.fc97283a4247ap-1},
                {-0x1.d8f7208e6b82dp-4, 0x1.fc97283a42479p-1, 0x1.fc97283a4247ap-1},
                {0x1.62b9586ad0a22p-3, 0x1.f856d48db797ep-1, 0x1.f856d48db797dp-1},
                {-0x1.62b9586ad0a22p-3, 0x1.f856d48db797ep-1, 0x1.f856d48db797dp-1},
                {0x1.d8f7208e6b82dp-3, 0x1.f26840e7b2189p-1, 0x1.f26840e7b2188p-1},
                {-0x1.d8f7208e6b82dp-3, 0x1.f26840e7b2189p-1, 0x1.f26840e7b2188p-1},
                {0x1.279a74590331cp-2, 0x1.ead07cc635696p-1, 0x1.ead07cc635697p-1},
                {-0x1.279a74590331cp-2, 0x1.ead07cc635696p-1, 0x1.ead07cc635697p-1},
                {0x1.62b9586ad0a22p-2, 0x1.e196026182985p-1, 0x1.e196026182986p-1},
                {-0x1.62b9586ad0a22p-2, 0x1.e196026182985p-1, 0x1.e196026182986p-1},
                {0x1.9dd83c7c9e128p-2, 0x1.d6c0b125791dp-1, 0x1.d6c0b125791cfp-1},
                {-0x1.9dd83c7c9e128p-2, 0x1.d6c0b125791dp-1, 0x1.d6c0b125791cfp-1},
                {0x1.d8f7208e6b82ep-2, 0x1.ca59c6fa3d9cep-1, 0x1.ca59c6fa3d9cdp-1},
                {-0x1.d8f7208e6b82ep-2, 0x1.ca59c6fa3d9cep-1, 0x1.ca59c6fa3d9cdp-1},
                {0x1.0a0b02501c799p-1, 0x1.bc6bd861e13dep-1, 0x1.bc6bd861e13dfp-1},
                {-0x1.0a0b02501c799p-1, 0x1.bc6bd861e13dep-1, 0x1.bc6bd861e13dfp-1},
                {0x1.3d3e35834faccp-1, 0x1.a0d1f8a9a792p-1, 0x1.a0d1f8a9a791fp-1},
                {-0x1.3d3e35834faccp-1, 0x1.a0d1f8a9a792p-1, 0x1.a0d1f8a9a791fp-1},
                {0x1.52e1f6ad9c27cp-1, 0x1.93e2948233fd1p-1, 0x1.93e2948233fdp-1},
                {-0x1.52e1f6ad9c27cp-1, 0x1.93e2948233fd1p-1, 0x1.93e2948233fdp-1},
                {0x1.6885b7d7e8a2cp-1, 0x1.863a850e439p-1, 0x1.863a850e43901p-1},
                {-0x1.6885b7d7e8a2cp-1, 0x1.863a850e439p-1, 0x1.863a850e43901p-1},
                {0x1.7e297902351dcp-1, 0x1.77e008d0775eap-1, 0x1.77e008d0775e9p-1},
                {-0x1.7e297902351dcp-1, 0x1.77e008d0775eap-1, 0x1.77e008d0775e9p-1},
                {0x1.93cd3a2c8198cp-1, 0x1.68d9afe052d22p-1, 0x1.68d9afe052d21p-1},
                {-0x1.93cd3a2c8198cp-1, 0x1.68d9afe052d22p-1, 0x1.68d9afe052d21p-1},
                {0x1.a970fb56ce13cp-1, 0x1.592e58ea0a9f2p-1, 0x1.592e58ea0a9f1p-1},
                {-0x1.a970fb56ce13cp-1, 0x1.592e58ea0a9f2p-1, 0x1.592e58ea0a9f1p-1},
                {0x1.bf14bc811a8ecp-1, 0x1.48e52e0a65bcep-1, 0x1.48e52e0a65bcfp-1},
                {-0x1.bf14bc811a8ecp-1, 0x1.48e52e0a65bcep-1, 0x1.48e52e0a65bcfp-1},
                {0x1.d4b87dab6709cp-1, 0x1.3805a188200a2p-1, 0x1.3805a188200a3p-1},
                {-0x1.d4b87dab6709cp-1, 0x1.3805a188200a2p-1, 0x1.3805a188200a3p-1},
                {0x1.ea5c3ed5b384cp-1, 0x1.26976a6c4e0fcp-1, 0x1.26976a6c4e0fbp-1},
                {-0x1.ea5c3ed5b384cp-1, 0x1.26976a6c4e0fcp-1, 0x1.26976a6c4e0fbp-1},
                {0x1.12bd9173c07abp0, 0x1.e8c405f36f85cp-2, 0x1.e8c405f36f85bp-2},
                {-0x1.12bd9173c07abp0, 0x1.e8c405f36f85cp-2, 0x1.e8c405f36f85bp-2},
                {0x1.257b22e780f56p0, 0x1.a5a4ccf40d9cbp-2, 0x1.a5a4ccf40d9ccp-2},
                {-0x1.257b22e780f56p0, 0x1.a5a4ccf40d9cbp-2, 0x1.a5a4ccf40d9ccp-2},
                {0x1.3838b45b41701p0, 0x1.6043621b13bd4p-2, 0x1.6043621b13bd3p-2},
                {-0x1.3838b45b41701p0, 0x1.6043621b13bd4p-2, 0x1.6043621b13bd3p-2},
                {0x1.4af645cf01eacp0, 0x1.18fee96a1a576p-2, 0x1.18fee96a1a577p-2},
                {-0x1.4af645cf01eacp0, 0x1.18fee96a1a576p-2, 0x1.18fee96a1a577p-2},
                {0x1.5db3d742c2657p0, 0x1.a0723a95492cfp-3, 0x1.a0723a95492cep-3},
                {-0x1.5db3d742c2657p0, 0x1.a0723a95492cfp-3, 0x1.a0723a95492cep-3},
                {0x1.707168b682e02p0, 0x1.0cab9115640bap-3, 0x1.0cab9115640b9p-3},
                {-0x1.707168b682e02p0, 0x1.0cab9115640bap-3, 0x1.0cab9115640b9p-3},
                {0x1.832efa2a435adp0, 0x1.ddd1ec25e201fp-5, 0x1.ddd1ec25e202p-5},
                {-0x1.832efa2a435adp0, 0x1.ddd1ec25e201fp-5, 0x1.ddd1ec25e202p-5},
                {0x1.95ec8b9e03d58p0, -0x1.e6669a270c56dp-7, -0x1.e6669a270c56ep-7},
                {-0x1.95ec8b9e03d58p0, -0x1.e6669a270c56dp-7, -0x1.e6669a270c56ep-7},
                {0x1.a8aa1d11c44ffp0, -0x1.682f3cc3c7a09p-4, -0x1.682f3cc3c7a08p-4},
                {-0x1.a8aa1d11c44ffp0, -0x1.682f3cc3c7a09p-4, -0x1.682f3cc3c7a08p-4},
                {0x1.04aff6d330942p0, 0x1.0cb3469a29ea6p-1, 0x1.0cb3469a29ea7p-1},
                {-0x1.04aff6d330942p0, 0x1.0cb3469a29ea6p-1, 0x1.0cb3469a29ea7p-1},
                {0x1.04b09e98dcdb4p0, 0x1.0cb228fa7f811p-1, 0x1.0cb228fa7f812p-1},
                {-0x1.04b09e98dcdb4p0, 0x1.0cb228fa7f811p-1, 0x1.0cb228fa7f812p-1},
                {0x1.04b1465e89226p0, 0x1.0cb10b5a61b06p-1, 0x1.0cb10b5a61b05p-1},
                {-0x1.04b1465e89226p0, 0x1.0cb10b5a61b06p-1, 0x1.0cb10b5a61b05p-1},
                {0x1.04b1ee2435698p0, 0x1.0cafedb9d078bp-1, 0x1.0cafedb9d078ap-1},
                {-0x1.04b1ee2435698p0, 0x1.0cafedb9d078bp-1, 0x1.0cafedb9d078ap-1},
                {0x1.04b295e9e1b0ap0, 0x1.0caed018cbda8p-1, 0x1.0caed018cbda7p-1},
                {-0x1.04b295e9e1b0ap0, 0x1.0caed018cbda8p-1, 0x1.0caed018cbda7p-1},
                {0x1.04b33daf8df7cp0, 0x1.0cadb27753d65p-1, 0x1.0cadb27753d66p-1},
                {-0x1.04b33daf8df7cp0, 0x1.0cadb27753d65p-1, 0x1.0cadb27753d66p-1},
                {0x1.04b3e5753a3eep0, 0x1.0cac94d5686cbp-1, 0x1.0cac94d5686cap-1},
                {-0x1.04b3e5753a3eep0, 0x1.0cac94d5686cbp-1, 0x1.0cac94d5686cap-1},
                {0x1.04b48d3ae686p0, 0x1.0cab7733099dfp-1, 0x1.0cab7733099ep-1},
                {-0x1.04b48d3ae686p0, 0x1.0cab7733099dfp-1, 0x1.0cab7733099ep-1},
                {0x1.04b5350092ccfp0, 0x1.0caa5990376bp-1, 0x1.0caa5990376b1p-1},
                {-0x1.04b5350092ccfp0, 0x1.0caa5990376bp-1, 0x1.0caa5990376b1p-1},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0p0, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.279a74590331bp-1, 0x1.ad02c771c35edp-1, 0x1.ad02c771c35eep-1},
                {-0x1.279a74590331bp-1, 0x1.ad02c771c35edp-1, 0x1.ad02c771c35eep-1},
                {0x1.279a74590331cp-1, 0x1.ad02c771c35edp-1, 0x1.ad02c771c35ecp-1},
                {-0x1.279a74590331cp-1, 0x1.ad02c771c35edp-1, 0x1.ad02c771c35ecp-1},
                {0x1.279a74590331dp-1, 0x1.ad02c771c35ecp-1, 0x1.ad02c771c35edp-1},
                {-0x1.279a74590331dp-1, 0x1.ad02c771c35ecp-1, 0x1.ad02c771c35edp-1},
                {0x1.bb67ae8584ca9p0, -0x1.48d1ddd2b2b4p-3, -0x1.48d1ddd2b2b3fp-3},
                {-0x1.bb67ae8584ca9p0, -0x1.48d1ddd2b2b4p-3, -0x1.48d1ddd2b2b3fp-3},
                {0x1.bb67ae8584caap0, -0x1.48d1ddd2b2b47p-3, -0x1.48d1ddd2b2b48p-3},
                {-0x1.bb67ae8584caap0, -0x1.48d1ddd2b2b47p-3, -0x1.48d1ddd2b2b48p-3},
                {0x1.bb67ae8584cabp0, -0x1.48d1ddd2b2b4fp-3, -0x1.48d1ddd2b2b5p-3},
                {-0x1.bb67ae8584cabp0, -0x1.48d1ddd2b2b4fp-3, -0x1.48d1ddd2b2b5p-3},
                {0x1.bffffffffffffp-2, 0x1.cfc6cfa52adap-1, 0x1.cfc6cfa52ad9fp-1},
                {-0x1.bffffffffffffp-2, 0x1.cfc6cfa52adap-1, 0x1.cfc6cfa52ad9fp-1},
                {0x1.cp-2, 0x1.cfc6cfa52ad9fp-1, 0x1.cfc6cfa52adap-1},
                {-0x1.cp-2, 0x1.cfc6cfa52ad9fp-1, 0x1.cfc6cfa52adap-1},
                {0x1.c000000000001p-2, 0x1.cfc6cfa52ad9fp-1, 0x1.cfc6cfa52adap-1},
                {-0x1.c000000000001p-2, 0x1.cfc6cfa52ad9fp-1, 0x1.cfc6cfa52adap-1},
                {0x1.5ffffffffffffp-1, 0x1.8bb105a5dc901p-1, 0x1.8bb105a5dc902p-1},
                {-0x1.5ffffffffffffp-1, 0x1.8bb105a5dc901p-1, 0x1.8bb105a5dc902p-1},
                {0x1.6p-1, 0x1.8bb105a5dc9p-1, 0x1.8bb105a5dc901p-1},
                {-0x1.6p-1, 0x1.8bb105a5dc9p-1, 0x1.8bb105a5dc901p-1},
                {0x1.6000000000001p-1, 0x1.8bb105a5dc9p-1, 0x1.8bb105a5dc8ffp-1},
                {-0x1.6000000000001p-1, 0x1.8bb105a5dc9p-1, 0x1.8bb105a5dc8ffp-1},
                {0x1.2ffffffffffffp0, 0x1.7ef4842f0bcd1p-2, 0x1.7ef4842f0bcd2p-2},
                {-0x1.2ffffffffffffp0, 0x1.7ef4842f0bcd1p-2, 0x1.7ef4842f0bcd2p-2},
                {0x1.3p0, 0x1.7ef4842f0bccdp-2, 0x1.7ef4842f0bccep-2},
                {-0x1.3p0, 0x1.7ef4842f0bccdp-2, 0x1.7ef4842f0bccep-2},
                {0x1.3000000000001p0, 0x1.7ef4842f0bccap-2, 0x1.7ef4842f0bcc9p-2},
                {-0x1.3000000000001p0, 0x1.7ef4842f0bccap-2, 0x1.7ef4842f0bcc9p-2},
                {0x1.37fffffffffffp1, -0x1.863efa361dc22p-1, -0x1.863efa361dc23p-1},
                {-0x1.37fffffffffffp1, -0x1.863efa361dc22p-1, -0x1.863efa361dc23p-1},
                {0x1.38p1, -0x1.863efa361dc25p-1, -0x1.863efa361dc26p-1},
                {-0x1.38p1, -0x1.863efa361dc25p-1, -0x1.863efa361dc26p-1},
                {0x1.3800000000001p1, -0x1.863efa361dc28p-1, -0x1.863efa361dc27p-1},
                {-0x1.3800000000001p1, -0x1.863efa361dc28p-1, -0x1.863efa361dc27p-1},
                {0x1.069c8b46b3792p-4, 0x1.fef2b2d21cf6cp-1, 0x1.fef2b2d21cf6dp-1},
                {-0x1.069c8b46b3792p-4, 0x1.fef2b2d21cf6cp-1, 0x1.fef2b2d21cf6dp-1},
                {0x1.069c8b46b3792p-3, 0x1.fbcbe693bd8edp-1, 0x1.fbcbe693bd8ecp-1},
                {-0x1.069c8b46b3792p-3, 0x1.fbcbe693bd8edp-1, 0x1.fbcbe693bd8ecp-1},
                {0x1.89ead0ea0d35bp-3, 0x1.f68eebfcbb5e8p-1, 0x1.f68eebfcbb5e9p-1},
                {-0x1.89ead0ea0d35bp-3, 0x1.f68eebfcbb5e8p-1, 0x1.f68eebfcbb5e9p-1},
                {0x1.069c8b46b3792p-2, 0x1.ef4145b4aedp-1, 0x1.ef4145b4aecffp-1},
                {-0x1.069c8b46b3792p-2, 0x1.ef4145b4aedp-1, 0x1.ef4145b4aecffp-1},
                {0x1.4843ae1860576p-2, 0x1.e5eaa286fbbc6p-1, 0x1.e5eaa286fbbc7p-1},
                {-0x1.4843ae1860576p-2, 0x1.e5eaa286fbbc6p-1, 0x1.e5eaa286fbbc7p-1},
                {0x1.89ead0ea0d35ap-2, 0x1.da94d54dd4c08p-1, 0x1.da94d54dd4c09p-1},
                {-0x1.89ead0ea0d35ap-2, 0x1.da94d54dd4c08p-1, 0x1.da94d54dd4c09p-1},
                {0x1.cb91f3bbba13ep-2, 0x1.cd4bca9cb5c71p-1, 0x1.cd4bca9cb5c72p-1},
                {-0x1.cb91f3bbba13ep-2, 0x1.cd4bca9cb5c71p-1, 0x1.cd4bca9cb5c72p-1},
                {0x1.069c8b46b3791p-1, 0x1.be1d7c3534c4p-1, 0x1.be1d7c3534c41p-1},
                {-0x1.069c8b46b3791p-1, 0x1.be1d7c3534c4p-1, 0x1.be1d7c3534c41p-1},
                {0x1.27701caf89e83p-1, 0x1.ad19e2535aa96p-1, 0x1.ad19e2535aa97p-1},
                {-0x1.27701caf89e83p-1, 0x1.ad19e2535aa96p-1, 0x1.ad19e2535aa97p-1},
                {0x1.4843ae1860575p-1, 0x1.9a52e2e0fbcb4p-1, 0x1.9a52e2e0fbcb3p-1},
                {-0x1.4843ae1860575p-1, 0x1.9a52e2e0fbcb4p-1, 0x1.9a52e2e0fbcb3p-1},
                {0x1.69173f8136c67p-1, 0x1.85dc3ea1bbceap-1, 0x1.85dc3ea1bbce9p-1},
                {-0x1.69173f8136c67p-1, 0x1.85dc3ea1bbceap-1, 0x1.85dc3ea1bbce9p-1},
                {0x1.89ead0ea0d359p-1, 0x1.6fcb7c6b8b91ap-1, 0x1.6fcb7c6b8b919p-1},
                {-0x1.89ead0ea0d359p-1, 0x1.6fcb7c6b8b91ap-1, 0x1.6fcb7c6b8b919p-1},
                {0x1.aabe6252e3a4bp-1, 0x1.5837d2817cf3p-1, 0x1.5837d2817cf31p-1},
                {-0x1.aabe6252e3a4bp-1, 0x1.5837d2817cf3p-1, 0x1.5837d2817cf31p-1},
                {0x1.cb91f3bbba13dp-1, 0x1.3f3a0e28bedd4p-1, 0x1.3f3a0e28bedd5p-1},
                {-0x1.cb91f3bbba13dp-1, 0x1.3f3a0e28bedd4p-1, 0x1.3f3a0e28bedd5p-1},
                {0x1.ec6585249082fp-1, 0x1.24ec799171643p-1, 0x1.24ec799171642p-1},
                {-0x1.ec6585249082fp-1, 0x1.24ec799171643p-1, 0x1.24ec799171642p-1},
                {0x1.069c8b46b3791p0, 0x1.096ac02ec42c8p-1, 0x1.096ac02ec42c9p-1},
                {-0x1.069c8b46b3791p0, 0x1.096ac02ec42c8p-1, 0x1.096ac02ec42c9p-1},
                {0x1.170653fb1eb0ap0, 0x1.d9a3a336edb76p-2, 0x1.d9a3a336edb77p-2},
                {-0x1.170653fb1eb0ap0, 0x1.d9a3a336edb76p-2, 0x1.d9a3a336edb77p-2},
                {0x1.27701caf89e83p0, 0x1.9e7f8652b4758p-2, 0x1.9e7f8652b4759p-2},
                {-0x1.27701caf89e83p0, 0x1.9e7f8652b4758p-2, 0x1.9e7f8652b4759p-2},
                {0x1.37d9e563f51fcp0, 0x1.61a76077aee08p-2, 0x1.61a76077aee07p-2},
                {-0x1.37d9e563f51fcp0, 0x1.61a76077aee08p-2, 0x1.61a76077aee07p-2},
                {0x1.4843ae1860575p0, 0x1.235b331d8f749p-2, 0x1.235b331d8f748p-2},
                {-0x1.4843ae1860575p0, 0x1.235b331d8f749p-2, 0x1.235b331d8f748p-2},
                {0x1.58ad76cccb8eep0, 0x1.c7b90e3024594p-3, 0x1.c7b90e3024593p-3},
                {-0x1.58ad76cccb8eep0, 0x1.c7b90e3024594p-3, 0x1.c7b90e3024593p-3},
                {0x1.69173f8136c67p0, 0x1.46dc4f4ce83dap-3, 0x1.46dc4f4ce83dbp-3},
                {-0x1.69173f8136c67p0, 0x1.46dc4f4ce83dap-3, 0x1.46dc4f4ce83dbp-3},
                {0x1.79810835a1fep0, 0x1.894f70befbb9ap-4, 0x1.894f70befbb99p-4},
                {-0x1.79810835a1fep0, 0x1.894f70befbb9ap-4, 0x1.894f70befbb99p-4},
                {0x1.89ead0ea0d359p0, 0x1.069107ae9333p-5, 0x1.069107ae9332fp-5},
                {-0x1.89ead0ea0d359p0, 0x1.069107ae9333p-5, 0x1.069107ae9332fp-5},
                {0x1.9a54999e786d2p0, -0x1.069107ae9327ep-5, -0x1.069107ae9327fp-5},
                {-0x1.9a54999e786d2p0, -0x1.069107ae9327ep-5, -0x1.069107ae9327fp-5},
                {0x1.aabe6252e3a4bp0, -0x1.894f70befbb41p-4, -0x1.894f70befbb42p-4},
                {-0x1.aabe6252e3a4bp0, -0x1.894f70befbb41p-4, -0x1.894f70befbb42p-4},
                {0x1.bb282b074edc4p0, -0x1.46dc4f4ce83afp-3, -0x1.46dc4f4ce83aep-3},
                {-0x1.bb282b074edc4p0, -0x1.46dc4f4ce83afp-3, -0x1.46dc4f4ce83aep-3},
                {0x1.cb91f3bbba13dp0, -0x1.c7b90e3024569p-3, -0x1.c7b90e3024568p-3},
                {-0x1.cb91f3bbba13dp0, -0x1.c7b90e3024569p-3, -0x1.c7b90e3024568p-3},
                {0x1.dbfbbc70254b6p0, -0x1.235b331d8f734p-2, -0x1.235b331d8f733p-2},
                {-0x1.dbfbbc70254b6p0, -0x1.235b331d8f734p-2, -0x1.235b331d8f733p-2},
                {0x1.ec6585249082fp0, -0x1.61a76077aedf3p-2, -0x1.61a76077aedf2p-2},
                {-0x1.ec6585249082fp0, -0x1.61a76077aedf3p-2, -0x1.61a76077aedf2p-2},
                {0x1.fccf4dd8fbba8p0, -0x1.9e7f8652b4744p-2, -0x1.9e7f8652b4743p-2},
                {-0x1.fccf4dd8fbba8p0, -0x1.9e7f8652b4744p-2, -0x1.9e7f8652b4743p-2},
                {0x1.069c8b46b3791p1, -0x1.d9a3a336edb66p-2, -0x1.d9a3a336edb65p-2},
                {-0x1.069c8b46b3791p1, -0x1.d9a3a336edb66p-2, -0x1.d9a3a336edb65p-2},
                {0x1.0ed16fa0e914ep1, -0x1.096ac02ec42c2p-1, -0x1.096ac02ec42c3p-1},
                {-0x1.0ed16fa0e914ep1, -0x1.096ac02ec42c2p-1, -0x1.096ac02ec42c3p-1},
                {0x1.170653fb1eb0bp1, -0x1.24ec79917163ep-1, -0x1.24ec79917163dp-1},
                {-0x1.170653fb1eb0bp1, -0x1.24ec79917163ep-1, -0x1.24ec79917163dp-1},
                {0x1.1f3b3855544c8p1, -0x1.3f3a0e28bedd1p-1, -0x1.3f3a0e28beddp-1},
                {-0x1.1f3b3855544c8p1, -0x1.3f3a0e28bedd1p-1, -0x1.3f3a0e28beddp-1},
                {0x1.27701caf89e85p1, -0x1.5837d2817cf2fp-1, -0x1.5837d2817cf2ep-1},
                {-0x1.27701caf89e85p1, -0x1.5837d2817cf2fp-1, -0x1.5837d2817cf2ep-1},
                {0x1.2fa50109bf842p1, -0x1.6fcb7c6b8b91ap-1, -0x1.6fcb7c6b8b919p-1},
                {-0x1.2fa50109bf842p1, -0x1.6fcb7c6b8b91ap-1, -0x1.6fcb7c6b8b919p-1},
                {0x1.37d9e563f51ffp1, -0x1.85dc3ea1bbcebp-1, -0x1.85dc3ea1bbceap-1},
                {-0x1.37d9e563f51ffp1, -0x1.85dc3ea1bbcebp-1, -0x1.85dc3ea1bbceap-1},
                {0x1.400ec9be2abbcp1, -0x1.9a52e2e0fbcb6p-1, -0x1.9a52e2e0fbcb5p-1},
                {-0x1.400ec9be2abbcp1, -0x1.9a52e2e0fbcb6p-1, -0x1.9a52e2e0fbcb5p-1},
                {0x1.4843ae1860579p1, -0x1.ad19e2535aa9ap-1, -0x1.ad19e2535aa99p-1},
                {-0x1.4843ae1860579p1, -0x1.ad19e2535aa9ap-1, -0x1.ad19e2535aa99p-1},
                {0x1.5078927295f36p1, -0x1.be1d7c3534c44p-1, -0x1.be1d7c3534c45p-1},
                {-0x1.5078927295f36p1, -0x1.be1d7c3534c44p-1, -0x1.be1d7c3534c45p-1},
                {0x1.58ad76cccb8f3p1, -0x1.cd4bca9cb5c76p-1, -0x1.cd4bca9cb5c75p-1},
                {-0x1.58ad76cccb8f3p1, -0x1.cd4bca9cb5c76p-1, -0x1.cd4bca9cb5c75p-1},
                {0x1.60e25b27012bp1, -0x1.da94d54dd4c0dp-1, -0x1.da94d54dd4c0cp-1},
                {-0x1.60e25b27012bp1, -0x1.da94d54dd4c0dp-1, -0x1.da94d54dd4c0cp-1},
                {0x1.69173f8136c6dp1, -0x1.e5eaa286fbbcbp-1, -0x1.e5eaa286fbbcap-1},
                {-0x1.69173f8136c6dp1, -0x1.e5eaa286fbbcbp-1, -0x1.e5eaa286fbbcap-1},
                {0x1.714c23db6c62ap1, -0x1.ef4145b4aed04p-1, -0x1.ef4145b4aed03p-1},
                {-0x1.714c23db6c62ap1, -0x1.ef4145b4aed04p-1, -0x1.ef4145b4aed03p-1},
                {0x1.79810835a1fe7p1, -0x1.f68eebfcbb5ecp-1, -0x1.f68eebfcbb5ebp-1},
                {-0x1.79810835a1fe7p1, -0x1.f68eebfcbb5ecp-1, -0x1.f68eebfcbb5ebp-1},
                {0x1.81b5ec8fd79a4p1, -0x1.fbcbe693bd8efp-1, -0x1.fbcbe693bd8fp-1},
                {-0x1.81b5ec8fd79a4p1, -0x1.fbcbe693bd8efp-1, -0x1.fbcbe693bd8fp-1},
                {0x1.89ead0ea0d35bp1, -0x1.fef2b2d21cf6cp-1, -0x1.fef2b2d21cf6bp-1},
                {-0x1.89ead0ea0d35bp1, -0x1.fef2b2d21cf6cp-1, -0x1.fef2b2d21cf6bp-1},
                {-0x1.81b5ec8fd799fp2, 0x1.ef4145b4aecffp-1, 0x1.ef4145b4aedp-1},
                {0x1.81b5ec8fd799fp2, 0x1.ef4145b4aecffp-1, 0x1.ef4145b4aedp-1},
                {-0x1.714c23db6c626p2, 0x1.be1d7c3534c4p-1, 0x1.be1d7c3534c3fp-1},
                {0x1.714c23db6c626p2, 0x1.be1d7c3534c4p-1, 0x1.be1d7c3534c3fp-1},
                {-0x1.60e25b27012adp2, 0x1.6fcb7c6b8b919p-1, 0x1.6fcb7c6b8b918p-1},
                {0x1.60e25b27012adp2, 0x1.6fcb7c6b8b919p-1, 0x1.6fcb7c6b8b918p-1},
                {-0x1.5078927295f34p2, 0x1.096ac02ec42c8p-1, 0x1.096ac02ec42c9p-1},
                {0x1.5078927295f34p2, 0x1.096ac02ec42c8p-1, 0x1.096ac02ec42c9p-1},
                {-0x1.400ec9be2abbbp2, 0x1.235b331d8f748p-2, 0x1.235b331d8f749p-2},
                {0x1.400ec9be2abbbp2, 0x1.235b331d8f748p-2, 0x1.235b331d8f749p-2},
                {-0x1.2fa50109bf842p2, 0x1.069107ae9332cp-5, 0x1.069107ae9332dp-5},
                {0x1.2fa50109bf842p2, 0x1.069107ae9332cp-5, 0x1.069107ae9332dp-5},
                {-0x1.1f3b3855544c9p2, -0x1.c7b90e3024569p-3, -0x1.c7b90e302456ap-3},
                {0x1.1f3b3855544c9p2, -0x1.c7b90e3024569p-3, -0x1.c7b90e302456ap-3},
                {-0x1.0ed16fa0e915p2, -0x1.d9a3a336edb63p-2, -0x1.d9a3a336edb62p-2},
                {0x1.0ed16fa0e915p2, -0x1.d9a3a336edb63p-2, -0x1.d9a3a336edb62p-2},
                {-0x1.fccf4dd8fbbaep1, -0x1.5837d2817cf28p-1, -0x1.5837d2817cf27p-1},
                {0x1.fccf4dd8fbbaep1, -0x1.5837d2817cf28p-1, -0x1.5837d2817cf27p-1},
                {-0x1.dbfbbc70254bcp1, -0x1.ad19e2535aa9p-1, -0x1.ad19e2535aa8fp-1},
                {0x1.dbfbbc70254bcp1, -0x1.ad19e2535aa9p-1, -0x1.ad19e2535aa8fp-1},
                {-0x1.bb282b074edcap1, -0x1.e5eaa286fbbc3p-1, -0x1.e5eaa286fbbc2p-1},
                {0x1.bb282b074edcap1, -0x1.e5eaa286fbbc3p-1, -0x1.e5eaa286fbbc2p-1},
                {-0x1.9a54999e786d8p1, -0x1.fef2b2d21cf6bp-1, -0x1.fef2b2d21cf6cp-1},
                {0x1.9a54999e786d8p1, -0x1.fef2b2d21cf6bp-1, -0x1.fef2b2d21cf6cp-1},
                {-0x1.79810835a1fe6p1, -0x1.f68eebfcbb5ebp-1, -0x1.f68eebfcbb5eap-1},
                {0x1.79810835a1fe6p1, -0x1.f68eebfcbb5ebp-1, -0x1.f68eebfcbb5eap-1},
                {-0x1.58ad76cccb8f4p1, -0x1.cd4bca9cb5c77p-1, -0x1.cd4bca9cb5c78p-1},
                {0x1.58ad76cccb8f4p1, -0x1.cd4bca9cb5c77p-1, -0x1.cd4bca9cb5c78p-1},
                {-0x1.37d9e563f5202p1, -0x1.85dc3ea1bbcf3p-1, -0x1.85dc3ea1bbcf2p-1},
                {0x1.37d9e563f5202p1, -0x1.85dc3ea1bbcf3p-1, -0x1.85dc3ea1bbcf2p-1},
                {-0x1.170653fb1eb1p1, -0x1.24ec79917164ep-1, -0x1.24ec79917164fp-1},
                {0x1.170653fb1eb1p1, -0x1.24ec79917164ep-1, -0x1.24ec79917164fp-1},
                {-0x1.ec6585249083cp0, -0x1.61a76077aee24p-2, -0x1.61a76077aee23p-2},
                {0x1.ec6585249083cp0, -0x1.61a76077aee24p-2, -0x1.61a76077aee23p-2},
                {-0x1.aabe6252e3a58p0, -0x1.894f70befbc1p-4, -0x1.894f70befbc11p-4},
                {0x1.aabe6252e3a58p0, -0x1.894f70befbc1p-4, -0x1.894f70befbc11p-4},
                {-0x1.69173f8136c74p0, 0x1.46dc4f4ce8374p-3, 0x1.46dc4f4ce8373p-3},
                {0x1.69173f8136c74p0, 0x1.46dc4f4ce8374p-3, 0x1.46dc4f4ce8373p-3},
                {-0x1.27701caf89e9p0, 0x1.9e7f8652b4729p-2, 0x1.9e7f8652b4728p-2},
                {0x1.27701caf89e9p0, 0x1.9e7f8652b4729p-2, 0x1.9e7f8652b4728p-2},
                {-0x1.cb91f3bbba157p-1, 0x1.3f3a0e28bedcp-1, 0x1.3f3a0e28bedbfp-1},
                {0x1.cb91f3bbba157p-1, 0x1.3f3a0e28bedcp-1, 0x1.3f3a0e28bedbfp-1},
                {-0x1.4843ae186058ep-1, 0x1.9a52e2e0fbca5p-1, 0x1.9a52e2e0fbca4p-1},
                {0x1.4843ae186058ep-1, 0x1.9a52e2e0fbca5p-1, 0x1.9a52e2e0fbca4p-1},
                {-0x1.89ead0ea0d38ap-2, 0x1.da94d54dd4bffp-1, 0x1.da94d54dd4cp-1},
                {0x1.89ead0ea0d38ap-2, 0x1.da94d54dd4bffp-1, 0x1.da94d54dd4cp-1},
                {-0x1.069c8b46b37fp-3, 0x1.fbcbe693bd8eap-1, 0x1.fbcbe693bd8e9p-1},
                {0x1.069c8b46b37fp-3, 0x1.fbcbe693bd8eap-1, 0x1.fbcbe693bd8e9p-1},
                {0x1.069c8b46b3734p-3, 0x1.fbcbe693bd8fp-1, 0x1.fbcbe693bd8efp-1},
                {-0x1.069c8b46b3734p-3, 0x1.fbcbe693bd8fp-1, 0x1.fbcbe693bd8efp-1},
                {0x1.89ead0ea0d32cp-2, 0x1.da94d54dd4c11p-1, 0x1.da94d54dd4c12p-1},
                {-0x1.89ead0ea0d32cp-2, 0x1.da94d54dd4c11p-1, 0x1.da94d54dd4c12p-1},
                {0x1.4843ae186055fp-1, 0x1.9a52e2e0fbcc1p-1, 0x1.9a52e2e0fbccp-1},
                {-0x1.4843ae186055fp-1, 0x1.9a52e2e0fbcc1p-1, 0x1.9a52e2e0fbccp-1},
                {0x1.cb91f3bbba128p-1, 0x1.3f3a0e28bede4p-1, 0x1.3f3a0e28bede5p-1},
                {-0x1.cb91f3bbba128p-1, 0x1.3f3a0e28bede4p-1, 0x1.3f3a0e28bede5p-1},
                {0x1.27701caf89e78p0, 0x1.9e7f8652b478p-2, 0x1.9e7f8652b4781p-2},
                {-0x1.27701caf89e78p0, 0x1.9e7f8652b478p-2, 0x1.9e7f8652b4781p-2},
                {0x1.69173f8136c5cp0, 0x1.46dc4f4ce8431p-3, 0x1.46dc4f4ce8432p-3},
                {-0x1.69173f8136c5cp0, 0x1.46dc4f4ce8431p-3, 0x1.46dc4f4ce8432p-3},
                {0x1.aabe6252e3a4p0, -0x1.894f70befba92p-4, -0x1.894f70befba93p-4},
                {-0x1.aabe6252e3a4p0, -0x1.894f70befba92p-4, -0x1.894f70befba93p-4},
                {0x1.ec65852490824p0, -0x1.61a76077aedcap-2, -0x1.61a76077aedc9p-2},
                {-0x1.ec65852490824p0, -0x1.61a76077aedcap-2, -0x1.61a76077aedc9p-2},
                {0x1.170653fb1eb04p1, -0x1.24ec799171627p-1, -0x1.24ec799171626p-1},
                {-0x1.170653fb1eb04p1, -0x1.24ec799171627p-1, -0x1.24ec799171626p-1},
                {0x1.37d9e563f51f6p1, -0x1.85dc3ea1bbcd3p-1, -0x1.85dc3ea1bbcd4p-1},
                {-0x1.37d9e563f51f6p1, -0x1.85dc3ea1bbcd3p-1, -0x1.85dc3ea1bbcd4p-1},
                {0x1.58ad76cccb8e8p1, -0x1.cd4bca9cb5c63p-1, -0x1.cd4bca9cb5c62p-1},
                {-0x1.58ad76cccb8e8p1, -0x1.cd4bca9cb5c63p-1, -0x1.cd4bca9cb5c62p-1},
                {0x1.79810835a1fdap1, -0x1.f68eebfcbb5e2p-1, -0x1.f68eebfcbb5e1p-1},
                {-0x1.79810835a1fdap1, -0x1.f68eebfcbb5e2p-1, -0x1.f68eebfcbb5e1p-1},
                {0x1.9a54999e786ccp1, -0x1.fef2b2d21cf6ep-1, -0x1.fef2b2d21cf6fp-1},
                {-0x1.9a54999e786ccp1, -0x1.fef2b2d21cf6ep-1, -0x1.fef2b2d21cf6fp-1},
                {0x1.bb282b074edbep1, -0x1.e5eaa286fbbd2p-1, -0x1.e5eaa286fbbd1p-1},
                {-0x1.bb282b074edbep1, -0x1.e5eaa286fbbd2p-1, -0x1.e5eaa286fbbd1p-1},
                {0x1.dbfbbc70254bp1, -0x1.ad19e2535aaaap-1, -0x1.ad19e2535aaabp-1},
                {-0x1.dbfbbc70254bp1, -0x1.ad19e2535aaaap-1, -0x1.ad19e2535aaabp-1},
                {0x1.fccf4dd8fbba2p1, -0x1.5837d2817cf4bp-1, -0x1.5837d2817cf4ap-1},
                {-0x1.fccf4dd8fbba2p1, -0x1.5837d2817cf4bp-1, -0x1.5837d2817cf4ap-1},
                {0x1.0ed16fa0e914ap2, -0x1.d9a3a336edbb8p-2, -0x1.d9a3a336edbb7p-2},
                {-0x1.0ed16fa0e914ap2, -0x1.d9a3a336edbb8p-2, -0x1.d9a3a336edbb7p-2},
                {0x1.1f3b3855544c3p2, -0x1.c7b90e3024625p-3, -0x1.c7b90e3024624p-3},
                {-0x1.1f3b3855544c3p2, -0x1.c7b90e3024625p-3, -0x1.c7b90e3024624p-3},
                {0x1.2fa50109bf83cp2, 0x1.069107ae9302dp-5, 0x1.069107ae9302cp-5},
                {-0x1.2fa50109bf83cp2, 0x1.069107ae9302dp-5, 0x1.069107ae9302cp-5},
                {0x1.400ec9be2abb5p2, 0x1.235b331d8f6ecp-2, 0x1.235b331d8f6edp-2},
                {-0x1.400ec9be2abb5p2, 0x1.235b331d8f6ecp-2, 0x1.235b331d8f6edp-2},
                {0x1.5078927295f2ep2, 0x1.096ac02ec429fp-1, 0x1.096ac02ec42ap-1},
                {-0x1.5078927295f2ep2, 0x1.096ac02ec429fp-1, 0x1.096ac02ec42ap-1},
                {0x1.60e25b27012a7p2, 0x1.6fcb7c6b8b8f7p-1, 0x1.6fcb7c6b8b8f8p-1},
                {-0x1.60e25b27012a7p2, 0x1.6fcb7c6b8b8f7p-1, 0x1.6fcb7c6b8b8f8p-1},
                {0x1.714c23db6c62p2, 0x1.be1d7c3534c28p-1, 0x1.be1d7c3534c29p-1},
                {-0x1.714c23db6c62p2, 0x1.be1d7c3534c28p-1, 0x1.be1d7c3534c29p-1},
                {0x1.81b5ec8fd7999p2, 0x1.ef4145b4aecf3p-1, 0x1.ef4145b4aecf4p-1},
                {-0x1.81b5ec8fd7999p2, 0x1.ef4145b4aecf3p-1, 0x1.ef4145b4aecf4p-1},
                {0x1.effffffffffffp-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {-0x1.effffffffffffp-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {0x1.fp-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {-0x1.fp-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {0x1.f000000000001p-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {-0x1.f000000000001p-5, 0x1.ff0fd2c96adfcp-1, 0x1.ff0fd2c96adfbp-1},
                {0x1.f7fffffffffffp-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {-0x1.f7fffffffffffp-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {0x1.f8p-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {-0x1.f8p-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {0x1.f800000000001p-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {-0x1.f800000000001p-4, 0x1.fc210055467fep-1, 0x1.fc210055467ffp-1},
                {0x1.4bfffffffffffp-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {-0x1.4bfffffffffffp-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {0x1.4cp-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {-0x1.4cp-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {0x1.4c00000000001p-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {-0x1.4c00000000001p-3, 0x1.f94984b2552e2p-1, 0x1.f94984b2552e1p-1},
                {0x1.3333333333332p-2, 0x1.e921dd42f09bbp-1, 0x1.e921dd42f09bap-1},
                {-0x1.3333333333332p-2, 0x1.e921dd42f09bbp-1, 0x1.e921dd42f09bap-1},
                {0x1.3333333333333p-2, 0x1.e921dd42f09bap-1, 0x1.e921dd42f09bbp-1},
                {-0x1.3333333333333p-2, 0x1.e921dd42f09bap-1, 0x1.e921dd42f09bbp-1},
                {0x1.3333333333334p-2, 0x1.e921dd42f09bap-1, 0x1.e921dd42f09bbp-1},
                {-0x1.3333333333334p-2, 0x1.e921dd42f09bap-1, 0x1.e921dd42f09bbp-1},
                {0x1.594317acc4ef8p-1, 0x1.8feedb86bf0efp-1, 0x1.8feedb86bf0fp-1},
                {-0x1.594317acc4ef8p-1, 0x1.8feedb86bf0efp-1, 0x1.8feedb86bf0fp-1},
                {0x1.594317acc4ef9p-1, 0x1.8feedb86bf0efp-1, 0x1.8feedb86bf0eep-1},
                {-0x1.594317acc4ef9p-1, 0x1.8feedb86bf0efp-1, 0x1.8feedb86bf0eep-1},
                {0x1.594317acc4efap-1, 0x1.8feedb86bf0eep-1, 0x1.8feedb86bf0edp-1},
                {-0x1.594317acc4efap-1, 0x1.8feedb86bf0eep-1, 0x1.8feedb86bf0edp-1},
                {0x1.8ffffffffffffp-1, 0x1.6b898fa9efb5ep-1, 0x1.6b898fa9efb5dp-1},
                {-0x1.8ffffffffffffp-1, 0x1.6b898fa9efb5ep-1, 0x1.6b898fa9efb5dp-1},
                {0x1.9p-1, 0x1.6b898fa9efb5dp-1, 0x1.6b898fa9efb5ep-1},
                {-0x1.9p-1, 0x1.6b898fa9efb5dp-1, 0x1.6b898fa9efb5ep-1},
                {0x1.9000000000001p-1, 0x1.6b898fa9efb5cp-1, 0x1.6b898fa9efb5dp-1},
                {-0x1.9000000000001p-1, 0x1.6b898fa9efb5cp-1, 0x1.6b898fa9efb5dp-1},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0p0, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.921fb54442d17p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {-0x1.921fb54442d17p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {0x1.921fb54442d18p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {-0x1.921fb54442d18p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {0x1.921fb54442d19p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {-0x1.921fb54442d19p-5, 0x1.ff621e3796d7ep-1, 0x1.ff621e3796d7dp-1},
                {0x1.921fb54442d17p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {-0x1.921fb54442d17p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {0x1.921fb54442d18p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {-0x1.921fb54442d18p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {0x1.921fb54442d19p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {-0x1.921fb54442d19p-4, 0x1.fd88da3d12526p-1, 0x1.fd88da3d12525p-1},
                {0x1.921fb54442d17p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {-0x1.921fb54442d17p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {0x1.921fb54442d18p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {-0x1.921fb54442d18p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {0x1.921fb54442d19p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {-0x1.921fb54442d19p-3, 0x1.f6297cff75cbp-1, 0x1.f6297cff75cb1p-1},
                {0x1.921fb54442d17p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {-0x1.921fb54442d17p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {0x1.921fb54442d18p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {-0x1.921fb54442d18p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {0x1.921fb54442d19p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {-0x1.921fb54442d19p-2, 0x1.d906bcf328d46p-1, 0x1.d906bcf328d47p-1},
                {0x1.921fb54442d17p-1, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcdp-1},
                {-0x1.921fb54442d17p-1, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcdp-1},
                {0x1.921fb54442d18p-1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bccp-1},
                {-0x1.921fb54442d18p-1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bccp-1},
                {0x1.921fb54442d19p-1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcdp-1},
                {-0x1.921fb54442d19p-1, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcdp-1},
                {0x1.921fb54442d17p0, 0x1.469898cc51702p-52, 0x1.469898cc51701p-52},
                {-0x1.921fb54442d17p0, 0x1.469898cc51702p-52, 0x1.469898cc51701p-52},
                {0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {-0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {0x1.921fb54442d19p0, -0x1.72cece675d1fdp-53, -0x1.72cece675d1fcp-53},
                {-0x1.921fb54442d19p0, -0x1.72cece675d1fdp-53, -0x1.72cece675d1fcp-53},
                {0x1.921fb54442d17p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p2, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p3, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p5, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p6, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d17p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d17p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.921fb54442d19p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.921fb54442d19p7, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d1p1, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bcap-1},
                {-0x1.2d97c7f3321d1p1, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bcap-1},
                {0x1.2d97c7f3321d2p1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcbp-1},
                {-0x1.2d97c7f3321d2p1, -0x1.6a09e667f3bccp-1, -0x1.6a09e667f3bcbp-1},
                {0x1.2d97c7f3321d3p1, -0x1.6a09e667f3bcfp-1, -0x1.6a09e667f3bcep-1},
                {-0x1.2d97c7f3321d3p1, -0x1.6a09e667f3bcfp-1, -0x1.6a09e667f3bcep-1},
                {0x1.f6a7a2955385dp1, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bd1p-1},
                {-0x1.f6a7a2955385dp1, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bd1p-1},
                {0x1.f6a7a2955385ep1, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcdp-1},
                {-0x1.f6a7a2955385ep1, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcdp-1},
                {0x1.f6a7a2955385fp1, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bcap-1},
                {-0x1.f6a7a2955385fp1, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bcap-1},
                {0x1.2d97c7f3321d1p2, -0x1.34f272993d141p-50, -0x1.34f272993d142p-50},
                {-0x1.2d97c7f3321d1p2, -0x1.34f272993d141p-50, -0x1.34f272993d142p-50},
                {0x1.2d97c7f3321d2p2, -0x1.a79394c9e8a0ap-53, -0x1.a79394c9e8a0bp-53},
                {-0x1.2d97c7f3321d2p2, -0x1.a79394c9e8a0ap-53, -0x1.a79394c9e8a0bp-53},
                {0x1.2d97c7f3321d3p2, 0x1.961b1acd85d7dp-51, 0x1.961b1acd85d7ep-51},
                {-0x1.2d97c7f3321d3p2, 0x1.961b1acd85d7dp-51, 0x1.961b1acd85d7ep-51},
                {0x1.5fdbbe9bba774p2, 0x1.6a09e667f3bc6p-1, 0x1.6a09e667f3bc5p-1},
                {-0x1.5fdbbe9bba774p2, 0x1.6a09e667f3bc6p-1, 0x1.6a09e667f3bc5p-1},
                {0x1.5fdbbe9bba775p2, 0x1.6a09e667f3bcbp-1, 0x1.6a09e667f3bccp-1},
                {-0x1.5fdbbe9bba775p2, 0x1.6a09e667f3bcbp-1, 0x1.6a09e667f3bccp-1},
                {0x1.5fdbbe9bba776p2, 0x1.6a09e667f3bd1p-1, 0x1.6a09e667f3bdp-1},
                {-0x1.5fdbbe9bba776p2, 0x1.6a09e667f3bd1p-1, 0x1.6a09e667f3bdp-1},
                {0x1.c463abeccb2bap2, 0x1.6a09e667f3bd4p-1, 0x1.6a09e667f3bd3p-1},
                {-0x1.c463abeccb2bap2, 0x1.6a09e667f3bd4p-1, 0x1.6a09e667f3bd3p-1},
                {0x1.c463abeccb2bbp2, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcfp-1},
                {-0x1.c463abeccb2bbp2, 0x1.6a09e667f3bcep-1, 0x1.6a09e667f3bcfp-1},
                {0x1.c463abeccb2bcp2, 0x1.6a09e667f3bc9p-1, 0x1.6a09e667f3bc8p-1},
                {-0x1.c463abeccb2bcp2, 0x1.6a09e667f3bc9p-1, 0x1.6a09e667f3bc8p-1},
                {0x1.f6a7a2955385dp2, 0x1.583ebeff65cc2p-50, 0x1.583ebeff65cc3p-50},
                {-0x1.f6a7a2955385dp2, 0x1.583ebeff65cc2p-50, 0x1.583ebeff65cc3p-50},
                {0x1.f6a7a2955385ep2, 0x1.60fafbfd97309p-52, 0x1.60fafbfd97308p-52},
                {-0x1.f6a7a2955385ep2, 0x1.60fafbfd97309p-52, 0x1.60fafbfd97308p-52},
                {0x1.f6a7a2955385fp2, -0x1.4f8282013467cp-51, -0x1.4f8282013467bp-51},
                {-0x1.f6a7a2955385fp2, -0x1.4f8282013467cp-51, -0x1.4f8282013467bp-51},
                {0x1.1475cc9eedeffp3, -0x1.6a09e667f3bb9p-1, -0x1.6a09e667f3bbap-1},
                {-0x1.1475cc9eedeffp3, -0x1.6a09e667f3bb9p-1, -0x1.6a09e667f3bbap-1},
                {0x1.1475cc9eedfp3, -0x1.6a09e667f3bc5p-1, -0x1.6a09e667f3bc4p-1},
                {-0x1.1475cc9eedfp3, -0x1.6a09e667f3bc5p-1, -0x1.6a09e667f3bc4p-1},
                {0x1.1475cc9eedf01p3, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bd1p-1},
                {-0x1.1475cc9eedf01p3, -0x1.6a09e667f3bdp-1, -0x1.6a09e667f3bd1p-1},
                {0x1.2d97c7f3321d1p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d1p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d2p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d2p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d3p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d3p3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.46b9c347764a2p3, -0x1.6a09e667f3bep-1, -0x1.6a09e667f3be1p-1},
                {-0x1.46b9c347764a2p3, -0x1.6a09e667f3bep-1, -0x1.6a09e667f3be1p-1},
                {0x1.46b9c347764a3p3, -0x1.6a09e667f3bd5p-1, -0x1.6a09e667f3bd4p-1},
                {-0x1.46b9c347764a3p3, -0x1.6a09e667f3bd5p-1, -0x1.6a09e667f3bd4p-1},
                {0x1.46b9c347764a4p3, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bcap-1},
                {-0x1.46b9c347764a4p3, -0x1.6a09e667f3bc9p-1, -0x1.6a09e667f3bcap-1},
                {0x1.5fdbbe9bba774p3, -0x1.3dc585b2c7422p-49, -0x1.3dc585b2c7421p-49},
                {-0x1.5fdbbe9bba774p3, -0x1.3dc585b2c7422p-49, -0x1.3dc585b2c7421p-49},
                {0x1.5fdbbe9bba775p3, -0x1.ee2c2d963a10cp-52, -0x1.ee2c2d963a10dp-52},
                {-0x1.5fdbbe9bba775p3, -0x1.ee2c2d963a10cp-52, -0x1.ee2c2d963a10dp-52},
                {0x1.5fdbbe9bba776p3, 0x1.8474f49a717bdp-50, 0x1.8474f49a717bcp-50},
                {-0x1.5fdbbe9bba776p3, 0x1.8474f49a717bdp-50, 0x1.8474f49a717bcp-50},
                {0x1.78fdb9effea45p3, 0x1.6a09e667f3bb9p-1, 0x1.6a09e667f3bb8p-1},
                {-0x1.78fdb9effea45p3, 0x1.6a09e667f3bb9p-1, 0x1.6a09e667f3bb8p-1},
                {0x1.78fdb9effea46p3, 0x1.6a09e667f3bc4p-1, 0x1.6a09e667f3bc3p-1},
                {-0x1.78fdb9effea46p3, 0x1.6a09e667f3bc4p-1, 0x1.6a09e667f3bc3p-1},
                {0x1.78fdb9effea47p3, 0x1.6a09e667f3bcfp-1, 0x1.6a09e667f3bdp-1},
                {-0x1.78fdb9effea47p3, 0x1.6a09e667f3bcfp-1, 0x1.6a09e667f3bdp-1},
                {0x1.ab41b09886fe8p3, 0x1.6a09e667f3be1p-1, 0x1.6a09e667f3bep-1},
                {-0x1.ab41b09886fe8p3, 0x1.6a09e667f3be1p-1, 0x1.6a09e667f3bep-1},
                {0x1.ab41b09886fe9p3, 0x1.6a09e667f3bd6p-1, 0x1.6a09e667f3bd5p-1},
                {-0x1.ab41b09886fe9p3, 0x1.6a09e667f3bd6p-1, 0x1.6a09e667f3bd5p-1},
                {0x1.ab41b09886feap3, 0x1.6a09e667f3bcap-1, 0x1.6a09e667f3bcbp-1},
                {-0x1.ab41b09886feap3, 0x1.6a09e667f3bcap-1, 0x1.6a09e667f3bcbp-1},
                {0x1.c463abeccb2bap3, 0x1.4f6babe5db9e2p-49, 0x1.4f6babe5db9e1p-49},
                {-0x1.c463abeccb2bap3, 0x1.4f6babe5db9e2p-49, 0x1.4f6babe5db9e1p-49},
                {0x1.c463abeccb2bbp3, 0x1.3daeaf976e788p-51, 0x1.3daeaf976e787p-51},
                {-0x1.c463abeccb2bbp3, 0x1.3daeaf976e788p-51, 0x1.3daeaf976e787p-51},
                {0x1.c463abeccb2bcp3, -0x1.6128a83448c3cp-50, -0x1.6128a83448c3dp-50},
                {-0x1.c463abeccb2bcp3, -0x1.6128a83448c3cp-50, -0x1.6128a83448c3dp-50},
                {0x1.dd85a7410f58bp3, -0x1.6a09e667f3bb8p-1, -0x1.6a09e667f3bb7p-1},
                {-0x1.dd85a7410f58bp3, -0x1.6a09e667f3bb8p-1, -0x1.6a09e667f3bb7p-1},
                {0x1.dd85a7410f58cp3, -0x1.6a09e667f3bc3p-1, -0x1.6a09e667f3bc4p-1},
                {-0x1.dd85a7410f58cp3, -0x1.6a09e667f3bc3p-1, -0x1.6a09e667f3bc4p-1},
                {0x1.dd85a7410f58dp3, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcfp-1},
                {-0x1.dd85a7410f58dp3, -0x1.6a09e667f3bcep-1, -0x1.6a09e667f3bcfp-1},
                {0x1.f6a7a2955385dp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385dp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.f6a7a2955385ep3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385ep3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.f6a7a2955385fp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.f6a7a2955385fp3, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.07e4cef4cbd96p4, -0x1.6a09e667f3bf8p-1, -0x1.6a09e667f3bf9p-1},
                {-0x1.07e4cef4cbd96p4, -0x1.6a09e667f3bf8p-1, -0x1.6a09e667f3bf9p-1},
                {0x1.07e4cef4cbd97p4, -0x1.6a09e667f3be2p-1, -0x1.6a09e667f3be1p-1},
                {-0x1.07e4cef4cbd97p4, -0x1.6a09e667f3be2p-1, -0x1.6a09e667f3be1p-1},
                {0x1.07e4cef4cbd98p4, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bccp-1},
                {-0x1.07e4cef4cbd98p4, -0x1.6a09e667f3bcbp-1, -0x1.6a09e667f3bccp-1},
                {0x1.1475cc9eedeffp4, -0x1.b088e90c77fd1p-48, -0x1.b088e90c77fd2p-48},
                {-0x1.1475cc9eedeffp4, -0x1.b088e90c77fd1p-48, -0x1.b088e90c77fd2p-48},
                {0x1.1475cc9eedfp4, -0x1.6111d218effa2p-49, -0x1.6111d218effa3p-49},
                {-0x1.1475cc9eedfp4, -0x1.6111d218effa2p-49, -0x1.6111d218effa3p-49},
                {0x1.1475cc9eedf01p4, 0x1.3ddc5bce200bbp-50, 0x1.3ddc5bce200bcp-50},
                {-0x1.1475cc9eedf01p4, 0x1.3ddc5bce200bbp-50, 0x1.3ddc5bce200bcp-50},
                {0x1.2106ca4910068p4, 0x1.6a09e667f3bacp-1, 0x1.6a09e667f3babp-1},
                {-0x1.2106ca4910068p4, 0x1.6a09e667f3bacp-1, 0x1.6a09e667f3babp-1},
                {0x1.2106ca4910069p4, 0x1.6a09e667f3bc3p-1, 0x1.6a09e667f3bc2p-1},
                {-0x1.2106ca4910069p4, 0x1.6a09e667f3bc3p-1, 0x1.6a09e667f3bc2p-1},
                {0x1.2106ca491006ap4, 0x1.6a09e667f3bd9p-1, 0x1.6a09e667f3bdap-1},
                {-0x1.2106ca491006ap4, 0x1.6a09e667f3bd9p-1, 0x1.6a09e667f3bdap-1},
                {0x1.2d97c7f3321d1p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d1p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d2p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d2p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.2d97c7f3321d3p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.2d97c7f3321d3p4, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.3a28c59d54339p4, 0x1.6a09e667f3bf9p-1, 0x1.6a09e667f3bfap-1},
                {-0x1.3a28c59d54339p4, 0x1.6a09e667f3bf9p-1, 0x1.6a09e667f3bfap-1},
                {0x1.3a28c59d5433ap4, 0x1.6a09e667f3be2p-1, 0x1.6a09e667f3be3p-1},
                {-0x1.3a28c59d5433ap4, 0x1.6a09e667f3be2p-1, 0x1.6a09e667f3be3p-1},
                {0x1.3a28c59d5433bp4, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcbp-1},
                {-0x1.3a28c59d5433bp4, 0x1.6a09e667f3bccp-1, 0x1.6a09e667f3bcbp-1},
                {0x1.46b9c347764a2p4, 0x1.b95bfc26022b1p-48, 0x1.b95bfc26022b2p-48},
                {-0x1.46b9c347764a2p4, 0x1.b95bfc26022b1p-48, 0x1.b95bfc26022b2p-48},
                {0x1.46b9c347764a3p4, 0x1.72b7f84c04563p-49, 0x1.72b7f84c04562p-49},
                {-0x1.46b9c347764a3p4, 0x1.72b7f84c04563p-49, 0x1.72b7f84c04562p-49},
                {0x1.46b9c347764a4p4, -0x1.1a900f67f753ap-50, -0x1.1a900f67f753bp-50},
                {-0x1.46b9c347764a4p4, -0x1.1a900f67f753ap-50, -0x1.1a900f67f753bp-50},
                {0x1.534ac0f19860bp4, -0x1.6a09e667f3babp-1, -0x1.6a09e667f3bacp-1},
                {-0x1.534ac0f19860bp4, -0x1.6a09e667f3babp-1, -0x1.6a09e667f3bacp-1},
                {0x1.534ac0f19860cp4, -0x1.6a09e667f3bc2p-1, -0x1.6a09e667f3bc1p-1},
                {-0x1.534ac0f19860cp4, -0x1.6a09e667f3bc2p-1, -0x1.6a09e667f3bc1p-1},
                {0x1.534ac0f19860dp4, -0x1.6a09e667f3bd8p-1, -0x1.6a09e667f3bd9p-1},
                {-0x1.534ac0f19860dp4, -0x1.6a09e667f3bd8p-1, -0x1.6a09e667f3bd9p-1},
                {0x1.5fdbbe9bba774p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba774p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.5fdbbe9bba775p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba775p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.5fdbbe9bba776p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.5fdbbe9bba776p4, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.6c6cbc45dc8dcp4, -0x1.6a09e667f3bfap-1, -0x1.6a09e667f3bf9p-1},
                {-0x1.6c6cbc45dc8dcp4, -0x1.6a09e667f3bfap-1, -0x1.6a09e667f3bf9p-1},
                {0x1.6c6cbc45dc8ddp4, -0x1.6a09e667f3be3p-1, -0x1.6a09e667f3be4p-1},
                {-0x1.6c6cbc45dc8ddp4, -0x1.6a09e667f3be3p-1, -0x1.6a09e667f3be4p-1},
                {0x1.6c6cbc45dc8dep4, -0x1.6a09e667f3bcdp-1, -0x1.6a09e667f3bccp-1},
                {-0x1.6c6cbc45dc8dep4, -0x1.6a09e667f3bcdp-1, -0x1.6a09e667f3bccp-1},
                {0x1.78fdb9effea45p4, -0x1.c22f0f3f8c592p-48, -0x1.c22f0f3f8c591p-48},
                {-0x1.78fdb9effea45p4, -0x1.c22f0f3f8c592p-48, -0x1.c22f0f3f8c591p-48},
                {0x1.78fdb9effea46p4, -0x1.845e1e7f18b23p-49, -0x1.845e1e7f18b24p-49},
                {-0x1.78fdb9effea46p4, -0x1.845e1e7f18b23p-49, -0x1.845e1e7f18b24p-49},
                {0x1.78fdb9effea47p4, 0x1.ee8786039d373p-51, 0x1.ee8786039d374p-51},
                {-0x1.78fdb9effea47p4, 0x1.ee8786039d373p-51, 0x1.ee8786039d374p-51},
                {0x1.858eb79a20baep4, 0x1.6a09e667f3baap-1, 0x1.6a09e667f3babp-1},
                {-0x1.858eb79a20baep4, 0x1.6a09e667f3baap-1, 0x1.6a09e667f3babp-1},
                {0x1.858eb79a20bafp4, 0x1.6a09e667f3bc1p-1, 0x1.6a09e667f3bcp-1},
                {-0x1.858eb79a20bafp4, 0x1.6a09e667f3bc1p-1, 0x1.6a09e667f3bcp-1},
                {0x1.858eb79a20bbp4, 0x1.6a09e667f3bd8p-1, 0x1.6a09e667f3bd7p-1},
                {-0x1.858eb79a20bbp4, 0x1.6a09e667f3bd8p-1, 0x1.6a09e667f3bd7p-1},
                {0x1.fffffffffffffp62, -0x1.2ccaf641d4262p-3, -0x1.2ccaf641d4261p-3},
                {-0x1.fffffffffffffp62, -0x1.2ccaf641d4262p-3, -0x1.2ccaf641d4261p-3},
                {0x1.0p63, 0x1.82aa375b3c33ep-7, 0x1.82aa375b3c33fp-7},
                {-0x1.0p63, 0x1.82aa375b3c33ep-7, 0x1.82aa375b3c33fp-7},
                {0x1.0000000000001p63, 0x1.4c0622a6e35dep-2, 0x1.4c0622a6e35ddp-2},
                {-0x1.0000000000001p63, 0x1.4c0622a6e35dep-2, 0x1.4c0622a6e35ddp-2},
                {0x1.fffffffffffffp26, 0x1.4ab650b8c6073p-1, 0x1.4ab650b8c6074p-1},
                {-0x1.fffffffffffffp26, 0x1.4ab650b8c6073p-1, 0x1.4ab650b8c6074p-1},
                {0x1.0p27, 0x1.4ab6511a7d39bp-1, 0x1.4ab6511a7d39ap-1},
                {-0x1.0p27, 0x1.4ab6511a7d39bp-1, 0x1.4ab6511a7d39ap-1},
                {0x1.0000000000001p27, 0x1.4ab651ddeb9e6p-1, 0x1.4ab651ddeb9e7p-1},
                {-0x1.0000000000001p27, 0x1.4ab651ddeb9e6p-1, 0x1.4ab651ddeb9e7p-1},
                {0x1.fffffffffffffp23, 0x1.40ad67e777b1ep-1, 0x1.40ad67e777b1dp-1},
                {-0x1.fffffffffffffp23, 0x1.40ad67e777b1ep-1, 0x1.40ad67e777b1dp-1},
                {0x1.0p24, 0x1.40ad67f3f0c9ap-1, 0x1.40ad67f3f0c9bp-1},
                {-0x1.0p24, 0x1.40ad67f3f0c9ap-1, 0x1.40ad67f3f0c9bp-1},
                {0x1.0000000000001p24, 0x1.40ad680ce2f92p-1, 0x1.40ad680ce2f93p-1},
                {-0x1.0000000000001p24, 0x1.40ad680ce2f92p-1, 0x1.40ad680ce2f93p-1},
                {0x1.fffffffffffffp1, -0x1.4eaa606db24c4p-1, -0x1.4eaa606db24c3p-1},
                {-0x1.fffffffffffffp1, -0x1.4eaa606db24c4p-1, -0x1.4eaa606db24c3p-1},
                {0x1.0p2, -0x1.4eaa606db24c1p-1, -0x1.4eaa606db24cp-1},
                {-0x1.0p2, -0x1.4eaa606db24c1p-1, -0x1.4eaa606db24cp-1},
                {0x1.0000000000001p2, -0x1.4eaa606db24bbp-1, -0x1.4eaa606db24bap-1},
                {-0x1.0000000000001p2, -0x1.4eaa606db24bbp-1, -0x1.4eaa606db24bap-1},
                {0x1.fffffffffffffp0, -0x1.aa22657537201p-2, -0x1.aa22657537202p-2},
                {-0x1.fffffffffffffp0, -0x1.aa22657537201p-2, -0x1.aa22657537202p-2},
                {0x1.0p1, -0x1.aa22657537205p-2, -0x1.aa22657537204p-2},
                {-0x1.0p1, -0x1.aa22657537205p-2, -0x1.aa22657537204p-2},
                {0x1.0000000000001p1, -0x1.aa2265753720cp-2, -0x1.aa2265753720bp-2},
                {-0x1.0000000000001p1, -0x1.aa2265753720cp-2, -0x1.aa2265753720bp-2},
                {0x1.fffffffffffffp-1, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068dp-1},
                {-0x1.fffffffffffffp-1, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068dp-1},
                {0x1.0p0, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068bp-1},
                {-0x1.0p0, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068bp-1},
                {0x1.0000000000001p0, 0x1.14a280fb5068ap-1, 0x1.14a280fb50689p-1},
                {-0x1.0000000000001p0, 0x1.14a280fb5068ap-1, 0x1.14a280fb50689p-1},
                {0x1.fffffffffffffp-2, 0x1.c1528065b7d5p-1, 0x1.c1528065b7d4fp-1},
                {-0x1.fffffffffffffp-2, 0x1.c1528065b7d5p-1, 0x1.c1528065b7d4fp-1},
                {0x1.0p-1, 0x1.c1528065b7d5p-1, 0x1.c1528065b7d4fp-1},
                {-0x1.0p-1, 0x1.c1528065b7d5p-1, 0x1.c1528065b7d4fp-1},
                {0x1.0000000000001p-1, 0x1.c1528065b7d4fp-1, 0x1.c1528065b7d5p-1},
                {-0x1.0000000000001p-1, 0x1.c1528065b7d4fp-1, 0x1.c1528065b7d5p-1},
                {0x1.fffffffffffffp-3, 0x1.f01549f7deea2p-1, 0x1.f01549f7deea1p-1},
                {-0x1.fffffffffffffp-3, 0x1.f01549f7deea2p-1, 0x1.f01549f7deea1p-1},
                {0x1.0p-2, 0x1.f01549f7deea1p-1, 0x1.f01549f7deea2p-1},
                {-0x1.0p-2, 0x1.f01549f7deea1p-1, 0x1.f01549f7deea2p-1},
                {0x1.0000000000001p-2, 0x1.f01549f7deea1p-1, 0x1.f01549f7deea2p-1},
                {-0x1.0000000000001p-2, 0x1.f01549f7deea1p-1, 0x1.f01549f7deea2p-1},
                {0x1.fffffffffffffp-4, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {-0x1.fffffffffffffp-4, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {0x1.0p-3, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {-0x1.0p-3, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {0x1.0000000000001p-3, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {-0x1.0000000000001p-3, 0x1.fc015527d5bd3p-1, 0x1.fc015527d5bd4p-1},
                {0x1.fffffffffffffp-5, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {-0x1.fffffffffffffp-5, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {0x1.0p-4, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {-0x1.0p-4, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {0x1.0000000000001p-4, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {-0x1.0000000000001p-4, 0x1.ff0015549f4d3p-1, 0x1.ff0015549f4d4p-1},
                {0x1.fffffffffffffp-6, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {-0x1.fffffffffffffp-6, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {0x1.0p-5, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {-0x1.0p-5, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {0x1.0000000000001p-5, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {-0x1.0000000000001p-5, 0x1.ffc00155527d3p-1, 0x1.ffc00155527d2p-1},
                {0x1.fffffffffffffp-7, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {-0x1.fffffffffffffp-7, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {0x1.0p-6, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {-0x1.0p-6, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {0x1.0000000000001p-6, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {-0x1.0000000000001p-6, 0x1.fff000155549fp-1, 0x1.fff00015554ap-1},
                {0x1.fffffffffffffp-15, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {-0x1.fffffffffffffp-15, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {0x1.0p-14, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {-0x1.0p-14, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {0x1.0000000000001p-14, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {-0x1.0000000000001p-14, 0x1.fffffffp-1, 0x1.fffffff000001p-1},
                {0x1.fffffffffffffp-28, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.fffffffffffffp-28, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.0p-27, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.0p-27, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.0000000000001p-27, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.0000000000001p-27, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.fffffffffffffp-31, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.fffffffffffffp-31, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.0p-30, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.0p-30, 0x1.0p0, 0x1.fffffffffffffp-1},
                {0x1.0000000000001p-30, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.0000000000001p-30, 0x1.0p0, 0x1.fffffffffffffp-1},
                {-0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {-0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {-0x1.fffffffffffffp1023, -0x1.fffe62ecfab75p-1, -0x1.fffe62ecfab76p-1},
                {0x1.ffffffffffffep1023, 0x1.7ffdfb4c5309p-2, 0x1.7ffdfb4c5308fp-2},
                {-0x1.ffffffffffffep1023, 0x1.7ffdfb4c5309p-2, 0x1.7ffdfb4c5308fp-2},
                {0x1.921fb54442d18p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {-0x1.921fb54442d18p1, -0x1.0p0, -0x1.fffffffffffffp-1},
                {0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {-0x1.921fb54442d18p0, 0x1.1a62633145c07p-54, 0x1.1a62633145c06p-54},
                {0x1.0000000000001p0, 0x1.14a280fb5068ap-1, 0x1.14a280fb50689p-1},
                {-0x1.0000000000001p0, 0x1.14a280fb5068ap-1, 0x1.14a280fb50689p-1},
                {0x1.0p0, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068bp-1},
                {-0x1.0p0, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068bp-1},
                {0x1.fffffffffffffp-1, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068dp-1},
                {-0x1.fffffffffffffp-1, 0x1.14a280fb5068cp-1, 0x1.14a280fb5068dp-1},
                {0x1.921fb54442d18p-1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bccp-1},
                {-0x1.921fb54442d18p-1, 0x1.6a09e667f3bcdp-1, 0x1.6a09e667f3bccp-1},
                {0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {-0x1.0p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.fffffffffffffp-1022, 0x1.0p0, 0x1.0p0},
                {0x0.ffffffffffffep-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.ffffffffffffep-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000002p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0000000000002p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {-0x0.0000000000001p-1022, 0x1.0p0, 0x1.0p0},
                {0x0.0p0, 0x1.0p0, 0x1.0p0},
                {-0x0.0p0, 0x1.0p0, 0x1.0p0}
        };

        for (double[] testCase : testCases) {
            testCosCase(testCase[0], testCase[1], testCase[2]);
        }
    }

    private static void testCosCase(double input, double bound1, double bound2) {
        Tests.testBounds("Math.cos", input, Math.cos(input), bound1, bound2);
    }
}
