/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.FileManagers;
import com.google.errorprone.FileObjects;
import com.google.errorprone.ImportOrderParser;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.scanner.ErrorProneScanner;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourceSubjectFactory;
import com.google.testing.compile.JavaSourcesSubject;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.junit.Assert;

@CheckReturnValue
public class BugCheckerRefactoringTestHelper {
    private final Map<JavaFileObject, JavaFileObject> sources = new HashMap<JavaFileObject, JavaFileObject>();
    private final Class<?> clazz;
    private final ScannerSupplier scannerSupplier;
    private FixChooser fixChooser = FixChoosers.FIRST;
    private ImmutableList<String> options = ImmutableList.of();
    private boolean allowBreakingChanges = false;
    private String importOrder = "static-first";
    private boolean run = false;

    private BugCheckerRefactoringTestHelper(Class<?> clazz, ScannerSupplier scannerSupplier) {
        this.clazz = clazz;
        this.scannerSupplier = scannerSupplier;
    }

    @Deprecated
    public static BugCheckerRefactoringTestHelper newInstance(BugChecker refactoringBugChecker, Class<?> clazz) {
        return new BugCheckerRefactoringTestHelper(clazz, new OverrideIgnoringScannerSupplier(new ErrorProneScanner(new BugChecker[]{refactoringBugChecker})));
    }

    public static BugCheckerRefactoringTestHelper newInstance(ScannerSupplier scannerSupplier, Class<?> clazz) {
        return new BugCheckerRefactoringTestHelper(clazz, scannerSupplier);
    }

    public static BugCheckerRefactoringTestHelper newInstance(Class<? extends BugChecker> checkerClass, Class<?> clazz) {
        return new BugCheckerRefactoringTestHelper(clazz, ScannerSupplier.fromBugCheckerClasses((Class[])new Class[]{checkerClass}));
    }

    public ExpectOutput addInput(String inputFilename) {
        return new ExpectOutput(FileObjects.forResource(this.clazz, inputFilename));
    }

    public ExpectOutput addInputLines(String path, String ... input) {
        return new ExpectOutput(FileObjects.forSourceLines(path, input));
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper setFixChooser(FixChooser chooser) {
        this.fixChooser = chooser;
        return this;
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper addModules(String ... modules) {
        return this.setArgs((ImmutableList<String>)((ImmutableList)Arrays.stream(modules).map(m -> String.format("--add-exports=%s=ALL-UNNAMED", m)).collect(ImmutableList.toImmutableList())));
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper setArgs(ImmutableList<String> args) {
        Preconditions.checkState((boolean)this.options.isEmpty());
        this.options = args;
        return this;
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper setArgs(String ... args) {
        this.options = ImmutableList.copyOf((Object[])args);
        return this;
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper allowBreakingChanges() {
        this.allowBreakingChanges = true;
        return this;
    }

    @CanIgnoreReturnValue
    public BugCheckerRefactoringTestHelper setImportOrder(String importOrder) {
        this.importOrder = importOrder;
        return this;
    }

    public void doTest() {
        this.doTest(TestMode.AST_MATCH);
    }

    public void doTest(TestMode testMode) {
        Preconditions.checkState((!this.run ? 1 : 0) != 0, (Object)"doTest should only be called once");
        this.run = true;
        for (Map.Entry<JavaFileObject, JavaFileObject> entry : this.sources.entrySet()) {
            try {
                this.runTestOnPair(entry.getKey(), entry.getValue(), testMode);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @CanIgnoreReturnValue
    private BugCheckerRefactoringTestHelper addInputAndOutput(JavaFileObject input, JavaFileObject output) {
        this.sources.put(input, output);
        return this;
    }

    private void runTestOnPair(JavaFileObject input, JavaFileObject output, TestMode testMode) throws IOException {
        Context context = new Context();
        JCTree.JCCompilationUnit tree = this.doCompile(input, this.sources.keySet(), context);
        JavaFileObject transformed = this.applyDiff(input, context, tree);
        BugCheckerRefactoringTestHelper.closeCompiler(context);
        testMode.verifyMatch(transformed, output);
        if (!this.allowBreakingChanges) {
            Context anotherContext = new Context();
            this.doCompile(output, this.sources.values(), anotherContext);
            BugCheckerRefactoringTestHelper.closeCompiler(anotherContext);
        }
    }

    @CanIgnoreReturnValue
    private JCTree.JCCompilationUnit doCompile(JavaFileObject input, Iterable<JavaFileObject> files, Context context) throws IOException {
        ErrorProneOptions errorProneOptions;
        JavacTool tool = JavacTool.create();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        try {
            errorProneOptions = ErrorProneOptions.processArgs(this.options);
        }
        catch (InvalidCommandLineOptionException e) {
            throw new IllegalArgumentException("Exception during argument processing: " + e);
        }
        context.put(ErrorProneOptions.class, errorProneOptions);
        StringWriter out = new StringWriter();
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(new PrintWriter((Writer)out, true), FileManagers.testFileManager(), diagnosticsCollector, (Iterable<String>)ImmutableList.copyOf((Object[])errorProneOptions.getRemainingArgs()), null, files, context);
        Iterable<? extends CompilationUnitTree> trees = task.parse();
        task.analyze();
        ImmutableMap byURI = (ImmutableMap)Streams.stream(trees).collect(ImmutableMap.toImmutableMap(t -> t.getSourceFile().toUri(), t -> t));
        URI inputURI = input.toUri();
        Truth.assertWithMessage((String)(out + Joiner.on((char)'\n').join(diagnosticsCollector.getDiagnostics()))).that((Map)byURI).containsKey((Object)inputURI);
        JCTree.JCCompilationUnit tree = (JCTree.JCCompilationUnit)byURI.get((Object)inputURI);
        Iterable errorDiagnostics = Iterables.filter(diagnosticsCollector.getDiagnostics(), d -> d.getKind() == Diagnostic.Kind.ERROR);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            Assert.fail((String)("compilation failed unexpectedly: " + errorDiagnostics));
        }
        return tree;
    }

    private JavaFileObject applyDiff(JavaFileObject sourceFileObject, Context context, JCTree.JCCompilationUnit tree) throws IOException {
        ImportOrganizer importOrganizer = ImportOrderParser.getImportOrganizer((String)this.importOrder);
        DescriptionBasedDiff diff = DescriptionBasedDiff.create((JCTree.JCCompilationUnit)tree, (ImportOrganizer)importOrganizer);
        ErrorProneOptions errorProneOptions = context.get(ErrorProneOptions.class);
        ErrorProneScannerTransformer.create((Scanner)((Scanner)this.scannerSupplier.applyOverrides(errorProneOptions).get())).apply(new TreePath(tree), context, description -> {
            if (!description.fixes.isEmpty()) {
                diff.handleFix(this.fixChooser.choose((List<Fix>)description.fixes));
            }
        });
        SourceFile sourceFile = SourceFile.create((JavaFileObject)sourceFileObject);
        diff.applyDifferences(sourceFile);
        JavaFileObject transformed = JavaFileObjects.forSourceString((String)BugCheckerRefactoringTestHelper.getFullyQualifiedName(tree), (String)sourceFile.getSourceText());
        return transformed;
    }

    private static String getFullyQualifiedName(JCTree.JCCompilationUnit tree) {
        Iterator types = Iterables.filter((Iterable)tree.getTypeDecls(), JCTree.JCClassDecl.class).iterator();
        if (types.hasNext()) {
            return ((JCTree.JCClassDecl)Iterators.getOnlyElement(types)).sym.getQualifiedName().toString();
        }
        return tree.getPackage().packge.package_info.toString();
    }

    private static void closeCompiler(Context context) {
        JavaCompiler compiler = context.get(JavaCompiler.compilerKey);
        if (compiler != null) {
            compiler.close();
        }
    }

    private static class OverrideIgnoringScannerSupplier
    extends ScannerSupplier {
        private final ScannerSupplier delegate;

        public OverrideIgnoringScannerSupplier(ErrorProneScanner scanner) {
            this.delegate = ScannerSupplier.fromScanner((Scanner)scanner);
        }

        public Scanner get() {
            return (Scanner)this.delegate.get();
        }

        public ScannerSupplier applyOverrides(ErrorProneOptions errorProneOptions) {
            return this;
        }

        public ImmutableBiMap<String, BugCheckerInfo> getAllChecks() {
            throw new UnsupportedOperationException();
        }

        public ImmutableSet<BugCheckerInfo> getEnabledChecks() {
            throw new UnsupportedOperationException();
        }

        public ImmutableMap<String, BugPattern.SeverityLevel> severities() {
            throw new UnsupportedOperationException();
        }

        protected ImmutableSet<String> disabled() {
            throw new UnsupportedOperationException();
        }

        public ErrorProneFlags getFlags() {
            throw new UnsupportedOperationException();
        }
    }

    public class ExpectOutput {
        private final JavaFileObject input;

        private ExpectOutput(JavaFileObject input) {
            this.input = input;
        }

        public BugCheckerRefactoringTestHelper addOutputLines(String path, String ... output) {
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, FileObjects.forSourceLines(path, output));
        }

        public BugCheckerRefactoringTestHelper addOutput(String outputFilename) {
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, FileObjects.forResource(BugCheckerRefactoringTestHelper.this.clazz, outputFilename));
        }

        public BugCheckerRefactoringTestHelper expectUnchanged() {
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, this.input);
        }
    }

    public static enum FixChoosers implements FixChooser
    {
        FIRST{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(0);
            }
        }
        ,
        SECOND{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(1);
            }
        }
        ,
        THIRD{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(2);
            }
        }
        ,
        FOURTH{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(3);
            }
        };

    }

    public static interface FixChooser {
        public Fix choose(List<Fix> var1);
    }

    public static enum TestMode {
        TEXT_MATCH{

            @Override
            void verifyMatch(JavaFileObject refactoredSource, JavaFileObject expectedSource) throws IOException {
                Truth.assertThat((String)this.maybeFormat(refactoredSource.getCharContent(false).toString())).isEqualTo((Object)this.maybeFormat(expectedSource.getCharContent(false).toString()));
            }

            private String maybeFormat(String input) {
                try {
                    return new Formatter().formatSource(input);
                }
                catch (FormatterException e) {
                    return input;
                }
            }
        }
        ,
        AST_MATCH{

            @Override
            void verifyMatch(JavaFileObject refactoredSource, JavaFileObject expectedSource) {
                ((JavaSourcesSubject.SingleSourceAdapter)Truth.assertAbout((Subject.Factory)JavaSourceSubjectFactory.javaSource()).that((Object)refactoredSource)).parsesAs(expectedSource, new JavaFileObject[0]);
            }
        };


        abstract void verifyMatch(JavaFileObject var1, JavaFileObject var2) throws IOException;
    }
}

