/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import com.google.errorprone.BaseErrorProneJavaCompiler;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DiagnosticTestHelper;
import com.google.errorprone.FileManagers;
import com.google.errorprone.FileObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.main.Main;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.junit.Assert;

@CheckReturnValue
public class CompilationTestHelper {
    private static final ImmutableList<String> DEFAULT_ARGS = ImmutableList.of((Object)"-encoding", (Object)"UTF-8", (Object)"-XDdev", (Object)"-parameters", (Object)"-XDcompilePolicy=simple", (Object)"-Xmaxerrs", (Object)"500", (Object)"-Xmaxwarns", (Object)"500");
    private final DiagnosticTestHelper diagnosticHelper;
    private final BaseErrorProneJavaCompiler compiler;
    private final ByteArrayOutputStream outputStream;
    private final Class<?> clazz;
    private final List<JavaFileObject> sources = new ArrayList<JavaFileObject>();
    private ImmutableList<String> extraArgs = ImmutableList.of();
    @Nullable
    private ImmutableList<Class<?>> overrideClasspath;
    private boolean expectNoDiagnostics = false;
    private Optional<Main.Result> expectedResult = Optional.empty();
    private DiagnosticTestHelper.LookForCheckNameInDiagnostic lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.YES;
    private boolean run = false;

    private CompilationTestHelper(ScannerSupplier scannerSupplier, String checkName, Class<?> clazz) {
        this.clazz = clazz;
        this.diagnosticHelper = new DiagnosticTestHelper(checkName);
        this.outputStream = new ByteArrayOutputStream();
        this.compiler = new BaseErrorProneJavaCompiler((JavaCompiler)JavacTool.create(), scannerSupplier);
    }

    public static CompilationTestHelper newInstance(ScannerSupplier scannerSupplier, Class<?> clazz) {
        return new CompilationTestHelper(scannerSupplier, null, clazz);
    }

    public static CompilationTestHelper newInstance(Class<? extends BugChecker> checker, Class<?> clazz) {
        ScannerSupplier scannerSupplier = ScannerSupplier.fromBugCheckerClasses((Class[])new Class[]{checker});
        String checkName = BugCheckerInfo.canonicalName((String)checker.getSimpleName(), (BugPattern)checker.getAnnotation(BugPattern.class));
        return new CompilationTestHelper(scannerSupplier, checkName, clazz);
    }

    static List<String> disableImplicitProcessing(List<String> args) {
        if (args.contains("-processor") || args.contains("-processorpath")) {
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-proc:none").build();
    }

    private static ImmutableList<String> buildArguments(@Nullable List<Class<?>> overrideClasspath, List<String> extraArgs) {
        ImmutableList.Builder result = ImmutableList.builder().addAll(DEFAULT_ARGS);
        CompilationTestHelper.getOverrideClasspath(overrideClasspath).ifPresent(jar -> result.add((Object)"-cp").add((Object)jar.toString()));
        return result.addAll(CompilationTestHelper.disableImplicitProcessing(extraArgs)).build();
    }

    private static Optional<Path> getOverrideClasspath(@Nullable List<Class<?>> overrideClasspath) {
        if (overrideClasspath == null) {
            return Optional.empty();
        }
        try {
            Path tempJarFile = Files.createTempFile(null, ".jar", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempJarFile, new OpenOption[0]);
                 JarOutputStream jos = new JarOutputStream(os);){
                for (Class<?> clazz : overrideClasspath) {
                    String entryPath = clazz.getName().replace('.', '/') + ".class";
                    jos.putNextEntry(new JarEntry(entryPath));
                    InputStream is = clazz.getClassLoader().getResourceAsStream(entryPath);
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)jos);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            return Optional.of(tempJarFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper addSourceLines(String path, String ... lines) {
        this.sources.add(FileObjects.forSourceLines(path, lines));
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper addSourceFile(String path) {
        this.sources.add(FileObjects.forResource(this.clazz, path));
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper withClasspath(Class<?> ... classes) {
        this.overrideClasspath = ImmutableList.copyOf((Object[])classes);
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper addModules(String ... modules) {
        return this.setArgs((List)Arrays.stream(modules).map(m -> String.format("--add-exports=%s=ALL-UNNAMED", m)).collect(ImmutableList.toImmutableList()));
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper setArgs(String ... args) {
        return this.setArgs(Arrays.asList(args));
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper setArgs(List<String> args) {
        Preconditions.checkState((boolean)this.extraArgs.isEmpty(), (String)"Extra args already set: old value: %s, new value: %s", this.extraArgs, args);
        this.extraArgs = ImmutableList.copyOf(args);
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper expectNoDiagnostics() {
        this.expectNoDiagnostics = true;
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper matchAllDiagnostics() {
        this.lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.NO;
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper expectResult(Main.Result result) {
        this.expectedResult = Optional.of(result);
        return this;
    }

    @CanIgnoreReturnValue
    public CompilationTestHelper expectErrorMessage(String key, Predicate<? super String> matcher) {
        this.diagnosticHelper.expectErrorMessage(key, matcher);
        return this;
    }

    public void doTest() {
        Preconditions.checkState((!this.sources.isEmpty() ? 1 : 0) != 0, (Object)"No source files to compile");
        Preconditions.checkState((!this.run ? 1 : 0) != 0, (Object)"doTest should only be called once");
        this.run = true;
        Main.Result result = this.compile();
        for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnosticHelper.getDiagnostics()) {
            if (!diagnostic.getCode().contains("error.prone.crash")) continue;
            Assert.fail((String)diagnostic.getMessage(Locale.ENGLISH));
        }
        if (this.expectNoDiagnostics) {
            List<Diagnostic<? extends JavaFileObject>> diagnostics = this.diagnosticHelper.getDiagnostics();
            Truth.assertWithMessage((String)String.format("Expected no diagnostics produced, but found %d: %s", diagnostics.size(), diagnostics)).that(Integer.valueOf(diagnostics.size())).isEqualTo((Object)0);
            Truth.assertWithMessage((String)String.format("Expected compilation result to be " + (Object)((Object)this.expectedResult.orElse(Main.Result.OK)) + ", but was %s. No diagnostics were emitted. OutputStream from Compiler follows.\n\n%s", new Object[]{result, this.outputStream})).that((Comparable)((Object)result)).isEqualTo((Object)this.expectedResult.orElse(Main.Result.OK));
        } else {
            for (JavaFileObject source : this.sources) {
                try {
                    this.diagnosticHelper.assertHasDiagnosticOnAllMatchingLines(source, this.lookForCheckNameInDiagnostic);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Truth.assertWithMessage((String)("Unused error keys: " + this.diagnosticHelper.getUnusedLookupKeys())).that(Boolean.valueOf(this.diagnosticHelper.getUnusedLookupKeys().isEmpty())).isTrue();
        }
        this.expectedResult.ifPresent(expected -> Truth.assertWithMessage((String)String.format("Expected compilation result %s, but was %s\n%s\n%s", new Object[]{expected, result, Joiner.on((char)'\n').join(this.diagnosticHelper.getDiagnostics()), this.outputStream})).that((Comparable)((Object)result)).isEqualTo((Object)expected));
    }

    private Main.Result compile() {
        ImmutableList<String> processedArgs = CompilationTestHelper.buildArguments(this.overrideClasspath, this.extraArgs);
        return this.compiler.getTask((Writer)new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8)), true), (JavaFileManager)FileManagers.testFileManager(), this.diagnosticHelper.collector, (Iterable)ImmutableList.copyOf(processedArgs), (Iterable)ImmutableList.of(), this.sources).call() != false ? Main.Result.OK : Main.Result.ERROR;
    }
}

