/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.jimfs.Jimfs;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import javax.tools.StandardLocation;

public final class FileManagers {
    private static final ThreadLocal<JavacFileManager> FILE_MANAGER = ThreadLocal.withInitial(FileManagers::createFileManager);
    private static final ThreadLocal<FileSystem> FILE_SYSTEM = ThreadLocal.withInitial(Jimfs::newFileSystem);

    private static JavacFileManager createFileManager() {
        Context context = new Context();
        CacheFSInfo.preRegister(context);
        return new JavacFileManager(context, false, StandardCharsets.UTF_8);
    }

    public static JavacFileManager testFileManager() {
        Path tempDirectory;
        JavacFileManager fileManager = FILE_MANAGER.get();
        FileManagers.setLocation(fileManager, FileManagers.systemClassPath(), StandardLocation.CLASS_PATH);
        try {
            tempDirectory = Files.createTempDirectory(FILE_SYSTEM.get().getRootDirectories().iterator().next(), "", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Arrays.stream(StandardLocation.values()).filter(StandardLocation::isOutputLocation).forEach(outputLocation -> FileManagers.setLocation(fileManager, (ImmutableList<Path>)ImmutableList.of((Object)tempDirectory), outputLocation));
        return fileManager;
    }

    private static ImmutableList<Path> systemClassPath() {
        return (ImmutableList)Streams.stream((Iterable)Splitter.on((char)File.pathSeparatorChar).split((CharSequence)StandardSystemProperty.JAVA_CLASS_PATH.value())).map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    private static void setLocation(JavacFileManager fileManager, ImmutableList<Path> collect, StandardLocation classPath) {
        try {
            fileManager.setLocationFromPaths(classPath, (Collection<? extends Path>)collect);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private FileManagers() {
    }
}

