/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class FileObjects {
    public static ImmutableList<JavaFileObject> forResources(Class<?> clazz, String ... fileNames) {
        return (ImmutableList)Arrays.stream(fileNames).map(fileName -> FileObjects.forResource(clazz, fileName)).collect(ImmutableList.toImmutableList());
    }

    public static JavaFileObject forResource(Class<?> clazz, String resourceName) {
        String content;
        URI uri = URI.create("file:///" + clazz.getPackage().getName().replace('.', '/') + "/" + resourceName);
        try (InputStream inputStream = FileObjects.findResource(clazz, resourceName);){
            content = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return content;
            }
        };
    }

    @MustBeClosed
    private static InputStream findResource(Class<?> clazz, String name) {
        InputStream is = clazz.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        is = clazz.getResourceAsStream("testdata/" + name);
        if (is != null) {
            return is;
        }
        throw new AssertionError((Object)("could not find resource: " + name + " for: " + clazz));
    }

    public static JavaFileObject forSourceLines(String path, final String ... lines) {
        return new SimpleJavaFileObject(URI.create("file:///" + path), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return Joiner.on((char)'\n').join((Object[])lines) + "\n";
            }
        };
    }

    private FileObjects() {
    }
}

