/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.ConeTypeCompatibilityChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityCompatibilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirEqualityOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkCompatibility", "lType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rType", "checkSensibleness", "isEnumType", "", "checkers"})
public final class FirEqualityCompatibilityChecker
extends FirExpressionChecker<FirEqualityOperatorCall> {
    @NotNull
    public static final FirEqualityCompatibilityChecker INSTANCE = new FirEqualityCompatibilityChecker();

    private FirEqualityCompatibilityChecker() {
    }

    @Override
    public void check(@NotNull FirEqualityOperatorCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        List<FirExpression> arguments2 = expression2.getArgumentList().getArguments();
        if (arguments2.size() != 2) {
            return;
        }
        ConeKotlinType lType = FirTypeUtilsKt.getConeType(arguments2.get(0).getTypeRef());
        ConeKotlinType rType = FirTypeUtilsKt.getConeType(arguments2.get(1).getTypeRef());
        this.checkCompatibility(lType, rType, context, expression2, reporter);
        this.checkSensibleness(lType, rType, context, expression2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCompatibility(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context, FirEqualityOperatorCall expression2, DiagnosticReporter reporter) {
        ConeTypeCompatibilityChecker.Compatibility compatibility;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(lType) || ConeBuiltinTypeUtilsKt.isNullableNothing(rType)) {
            return;
        }
        ConeInferenceContext inferenceContext = TypeComponentsKt.getTypeContext(context.getSession());
        try {
            compatibility = ConeTypeCompatibilityChecker.INSTANCE.isCompatible(inferenceContext, lType, rType);
        }
        catch (Throwable e) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Iterable iterable = context.getContainingDeclarations();
            StringBuilder stringBuilder2 = new StringBuilder().append("Exception while determining type compatibility: lType: ").append(lType).append(", rType: ").append(rType).append(", equality ").append(UtilsKt.render(expression2)).append(", file ");
            boolean $i$f$filterIsInstance = false;
            void var12_12 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            FirFile firFile = (FirFile)CollectionsKt.firstOrNull((List)destination$iv$iv);
            Throwable throwable = e;
            String string2 = stringBuilder2.append(firFile != null ? firFile.getName() : null).toString();
            throw new IllegalStateException(string2, throwable);
        }
        ConeTypeCompatibilityChecker.Compatibility compatibility2 = compatibility;
        if (compatibility2 != ConeTypeCompatibilityChecker.Compatibility.COMPATIBLE) {
            KtSourceElement ktSourceElement = expression2.getSource();
            if (Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtRealSourceElementKind.INSTANCE)) {
                if (compatibility2 == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE && (this.isEnumType(lType, context) || this.isEnumType(rType, context))) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getINCOMPATIBLE_ENUM_COMPARISON_ERROR(), (Object)lType, (Object)rType, (DiagnosticContext)context, null, 32, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), compatibility2 == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE() : FirErrors.INSTANCE.getEQUALITY_NOT_APPLICABLE_WARNING(), (Object)expression2.getOperation().getOperator(), (Object)lType, (Object)rType, (DiagnosticContext)context, null, 64, null);
                }
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), compatibility2 == ConeTypeCompatibilityChecker.Compatibility.HARD_INCOMPATIBLE ? FirErrors.INSTANCE.getINCOMPATIBLE_TYPES() : FirErrors.INSTANCE.getINCOMPATIBLE_TYPES_WARNING(), (Object)lType, (Object)rType, (DiagnosticContext)context, null, 32, null);
            }
        }
    }

    private final boolean isEnumType(ConeKotlinType $this$isEnumType, CheckerContext context) {
        if (ConeBuiltinTypeUtilsKt.isEnum($this$isEnumType)) {
            return true;
        }
        Object object = $this$isEnumType instanceof ConeClassLikeType ? (ConeClassLikeType)$this$isEnumType : null;
        if (object == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) {
            return false;
        }
        Object firRegularClassSymbol = object;
        FirClassSymbol $this$isEnumClass$iv = (FirClassSymbol)firRegularClassSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        return $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
    }

    private final void checkSensibleness(ConeKotlinType lType, ConeKotlinType rType, CheckerContext context, FirEqualityOperatorCall expression2, DiagnosticReporter reporter) {
        boolean bl;
        ConeKotlinType coneKotlinType;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(rType)) {
            coneKotlinType = lType;
        } else if (ConeBuiltinTypeUtilsKt.isNullableNothing(lType)) {
            coneKotlinType = rType;
        } else {
            return;
        }
        ConeKotlinType type2 = coneKotlinType;
        if (type2 instanceof ConeErrorType) {
            return;
        }
        boolean isPositiveCompare = expression2.getOperation() == FirOperation.EQ || expression2.getOperation() == FirOperation.IDENTITY;
        ConeInferenceContext $this$checkSensibleness_u24lambda_u240 = TypeComponentsKt.getTypeContext(context.getSession());
        boolean bl2 = false;
        if (ConeBuiltinTypeUtilsKt.isNullableNothing(type2)) {
            bl = isPositiveCompare;
        } else if (!$this$checkSensibleness_u24lambda_u240.isNullableType(type2)) {
            bl = !isPositiveCompare;
        } else {
            return;
        }
        boolean compareResult = bl;
        KtSourceElement ktSourceElement = expression2.getSource();
        if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getElementType() : null, KtNodeTypes.BINARY_EXPRESSION) && type2 == lType) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_NULL_IN_WHEN(), (DiagnosticContext)context, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSENSELESS_COMPARISON(), (Object)expression2, (Object)compareResult, (DiagnosticContext)context, null, 32, null);
        }
    }
}

