/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.FirOverridesBackwardCompatibilityHelper;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u00020\u00062\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/FirJvmOverridesBackwardCompatibilityHelper;", "Lorg/jetbrains/kotlin/fir/analysis/FirOverridesBackwardCompatibilityHelper;", "()V", "platformDependentAnnotation", "Lorg/jetbrains/kotlin/name/ClassId;", "isPlatformSpecificSymbolThatCanBeImplicitlyOverridden", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "visitedSymbols", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "overrideCanBeOmitted", "overriddenMemberSymbols", "", "checkers.jvm"})
public final class FirJvmOverridesBackwardCompatibilityHelper
implements FirOverridesBackwardCompatibilityHelper {
    @NotNull
    public static final FirJvmOverridesBackwardCompatibilityHelper INSTANCE = new FirJvmOverridesBackwardCompatibilityHelper();
    @NotNull
    private static final ClassId platformDependentAnnotation;

    private FirJvmOverridesBackwardCompatibilityHelper() {
    }

    @Override
    public boolean overrideCanBeOmitted(@NotNull List<? extends FirCallableSymbol<?>> overriddenMemberSymbols, @NotNull CheckerContext context) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(overriddenMemberSymbols, "overriddenMemberSymbols");
            Intrinsics.checkNotNullParameter(context, "context");
            HashSet visitedSymbols = new HashSet();
            Iterable $this$all$iv = overriddenMemberSymbols;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it, visitedSymbols, context)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(FirCallableSymbol<?> symbol2, Set<FirCallableSymbol<?>> visitedSymbols, CheckerContext context) {
        boolean bl;
        block27: {
            List list2;
            Object object;
            boolean bl2;
            FirCallableDeclaration originalMember;
            block26: {
                Modality modality$iv;
                FirCallableSymbol<?> $this$isFinal$iv = symbol2;
                boolean $i$f$isFinal = false;
                Modality modality = $this$isFinal$iv.getResolvedStatus().getModality();
                if (modality == null ? true : (modality$iv = modality) == Modality.FINAL) {
                    return false;
                }
                if (visitedSymbols.contains(symbol2)) {
                    return true;
                }
                ((Collection)visitedSymbols).add(symbol2);
                FirCallableSymbol<?> $this$originalOrSelf$iv = symbol2;
                boolean $i$f$originalOrSelf = false;
                FirCallableDeclaration $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
                boolean $i$f$originalOrSelf2 = false;
                FirCallableDeclaration result$iv$iv = $this$originalOrSelf$iv$iv;
                while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
                    FirCallableDeclaration $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
                    boolean $i$f$originalIfFakeOverride = false;
                    FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                    boolean $i$f$getOriginalForSubstitutionOverride = false;
                    FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv) : null;
                    if (firCallableDeclaration == null) {
                        FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                        boolean $i$f$getBaseForIntersectionOverride = false;
                        firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
                    }
                    if (firCallableDeclaration == null) break;
                    result$iv$iv = firCallableDeclaration;
                }
                FirCallableSymbol<? extends FirCallableDeclaration> firCallableSymbol = result$iv$iv.getSymbol();
                if (firCallableSymbol == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
                }
                FirCallableSymbol<? extends FirCallableDeclaration> originalMemberSymbol = firCallableSymbol;
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)originalMemberSymbol, FirResolvePhase.BODY_RESOLVE);
                originalMember = (FirCallableDeclaration)originalMemberSymbol.getFir();
                Iterable $this$any$iv = originalMember.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl3 = false;
                        FirTypeRef $this$coneTypeSafe$iv = it.getAnnotationTypeRef();
                        boolean $i$f$coneTypeSafe = false;
                        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                        if (!(coneKotlinType instanceof ConeClassLikeType)) {
                            coneKotlinType = null;
                        }
                        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                        if (!Intrinsics.areEqual(coneClassLikeType != null ? ConeTypeUtilsKt.getClassId(coneClassLikeType) : null, platformDependentAnnotation)) continue;
                        bl2 = true;
                        break block26;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            FirDeclaration $this$isJavaOrEnhancement$iv = originalMember;
            boolean $i$f$isJavaOrEnhancement = false;
            if (!($this$isJavaOrEnhancement$iv.getOrigin() instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual($this$isJavaOrEnhancement$iv.getOrigin(), FirDeclarationOrigin.Enhancement.INSTANCE))) {
                return false;
            }
            Object object2 = ClassMembersKt.containingClass(originalMember);
            if (object2 == null || (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) == null || (object2 = ((ClassId)object2).asSingleFqName()) == null || (object2 = ((FqName)object2).toUnsafe()) == null) {
                return false;
            }
            Object containingClassName = object2;
            if (JavaToKotlinClassMap.INSTANCE.mapKotlinToJava((FqNameUnsafe)containingClassName) != null) {
                return true;
            }
            FirMemberDeclaration $this$isAbstract$iv = originalMember;
            boolean $i$f$isAbstract = false;
            if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                boolean bl4;
                FirRegularClassSymbol containingClass;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClass(originalMember);
                FirRegularClassSymbol firRegularClassSymbol = containingClass = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, context.getSession()) : null;
                if (firRegularClassSymbol != null) {
                    FirClassSymbol $this$isInterface$iv = firRegularClassSymbol;
                    boolean $i$f$isInterface = false;
                    ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                    boolean $i$f$isInterface2 = false;
                    boolean bl5 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                    bl4 = !bl5;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return false;
                }
            }
            if ((object = ClassMembersKt.dispatchReceiverTypeOrNull(symbol2)) == null || (object = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)object, context.getSession())) == null || (object = FirHelpersKt.unsubstitutedScope((FirClassSymbol)object, context)) == null) {
                return false;
            }
            Object scope2 = object;
            FirCallableDeclaration $i$f$isInterface = originalMember;
            if ($i$f$isInterface instanceof FirSimpleFunction) {
                list2 = FirTypeScopeKt.getDirectOverriddenFunctions$default((FirTypeScope)scope2, ((FirSimpleFunction)originalMember).getSymbol(), false, 2, null);
            } else if ($i$f$isInterface instanceof FirProperty) {
                list2 = FirTypeScopeKt.getDirectOverriddenProperties$default((FirTypeScope)scope2, ((FirProperty)originalMember).getSymbol(), false, 2, null);
            } else {
                return false;
            }
            List overriddenSymbols2 = list2;
            if (overriddenSymbols2.isEmpty()) {
                return false;
            }
            Iterable $this$all$iv = overriddenSymbols2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirCallableSymbol it = (FirCallableSymbol)element$iv;
                    boolean bl6 = false;
                    if (INSTANCE.isPlatformSpecificSymbolThatCanBeImplicitlyOverridden(it, visitedSymbols, context)) continue;
                    bl = false;
                    break block27;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        ClassId classId = ClassId.fromString("kotlin/internal/PlatformDependent");
        Intrinsics.checkNotNullExpressionValue(classId, "fromString(\"kotlin/internal/PlatformDependent\")");
        platformDependentAnnotation = classId;
    }
}

