/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.SecondaryCtorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateFactoryBody", "", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "delegate", "generateInitBody", "generateStubsBody", "factory", "transformConstructor", "", "transformFlat", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ThisUsageReplaceTransformer", "backend.js"})
public final class SecondaryConstructorLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public SecondaryConstructorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.context.getEs6mode()) {
            return null;
        }
        if (declaration instanceof IrConstructor && !((IrConstructor)declaration).isPrimary()) {
            IrClass irClass2 = IrUtilsKt.getParentAsClass(declaration);
            if (this.context.getInlineClassesUtils().isClassInlineLike(irClass2)) {
                return null;
            }
            return this.transformConstructor((IrConstructor)declaration, irClass2);
        }
        return null;
    }

    private final List<IrSimpleFunction> transformConstructor(IrConstructor constructor2, IrClass irClass2) {
        IrSimpleFunction delegate2 = SecondaryCtorLoweringKt.access$buildConstructorDelegate(this.context, constructor2, irClass2);
        IrSimpleFunction factory2 = SecondaryCtorLoweringKt.access$buildConstructorFactory(this.context, constructor2, irClass2);
        this.generateStubsBody(constructor2, irClass2, delegate2, factory2);
        IrSimpleFunction[] irSimpleFunctionArray = new IrSimpleFunction[]{delegate2, factory2};
        return CollectionsKt.listOf(irSimpleFunctionArray);
    }

    private final void generateStubsBody(IrConstructor constructor2, IrClass irClass2, IrSimpleFunction delegate2, IrSimpleFunction factory2) {
        this.generateInitBody(constructor2, irClass2, delegate2);
        this.generateFactoryBody(constructor2, irClass2, factory2, delegate2);
    }

    private final void generateFactoryBody(IrConstructor constructor2, IrClass irClass2, IrSimpleFunction stub2, IrSimpleFunction delegate2) {
        stub2.setBody(this.context.getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(irClass2, this, delegate2, stub2, constructor2){
            final /* synthetic */ IrClass $irClass;
            final /* synthetic */ SecondaryConstructorLowering this$0;
            final /* synthetic */ IrSimpleFunction $delegate;
            final /* synthetic */ IrSimpleFunction $stub;
            final /* synthetic */ IrConstructor $constructor;
            {
                this.$irClass = $irClass;
                this.this$0 = $receiver;
                this.$delegate = $delegate;
                this.$stub = $stub;
                this.$constructor = $constructor;
                super(1);
            }

            public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                int i;
                Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                IrSimpleType type2 = IrUtilsKt.getDefaultType(this.$irClass);
                IrSimpleFunctionSymbol createFunctionIntrinsic = this.this$0.getContext().getIntrinsics().getJsObjectCreate();
                IrCall irCreateCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, createFunctionIntrinsic, type2, CollectionsKt.listOf(type2), null, 8, null);
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.$delegate.getSymbol(), type2, null, null, 12, null);
                Object object = this.$stub;
                IrElementBase irElementBase = this.$constructor;
                IrCall call2 = irCall;
                boolean bl = false;
                int n = object.getTypeParameters().size();
                for (i = 0; i < n; ++i) {
                    call2.putTypeArgument(i, SecondaryCtorLoweringKt.access$toIrType(object.getTypeParameters().get(i)));
                }
                n = ((IrFunction)object).getValueParameters().size();
                for (i = 0; i < n; ++i) {
                    call2.putValueArgument(i, JsIrBuilder.INSTANCE.buildGetValue(((IrFunction)object).getValueParameters().get(i).getSymbol()));
                }
                call2.putValueArgument(((IrFunction)irElementBase).getValueParameters().size(), irCreateCall);
                IrCall irDelegateCall = irCall;
                if (IrUtilsKt.isSubclassOf(this.$irClass, (IrClass)this.this$0.getContext().getIrBuiltIns().getThrowableClass().getOwner())) {
                    IrVariable tmp = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, irDelegateCall.getType(), this.$stub, null, false, false, false, irDelegateCall, 60, null);
                    ((Collection)$this$createBlockBody.getStatements()).add(tmp);
                    object = $this$createBlockBody.getStatements();
                    irElementBase = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getCaptureStack(), null, null, null, 14, null);
                    SecondaryConstructorLowering secondaryConstructorLowering = this.this$0;
                    IrSimpleFunction irSimpleFunction = this.$stub;
                    IrElementBase call3 = irElementBase;
                    boolean bl2 = false;
                    ((IrMemberAccessExpression)call3).putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(tmp.getSymbol()));
                    ((IrMemberAccessExpression)call3).putValueArgument(1, new IrRawFunctionReferenceImpl(-1, -1, secondaryConstructorLowering.getContext().getIrBuiltIns().getAnyType(), irSimpleFunction.getSymbol()));
                    object.add(irElementBase);
                    ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn(this.$stub.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue(tmp.getSymbol()), this.this$0.getContext().getIrBuiltIns().getNothingType()));
                } else {
                    IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(this.$stub.getSymbol(), irDelegateCall, this.this$0.getContext().getIrBuiltIns().getNothingType());
                    ((Collection)$this$createBlockBody.getStatements()).add(irReturn);
                }
            }
        }));
    }

    private final void generateInitBody(IrConstructor constructor2, IrClass irClass2, IrSimpleFunction delegate2) {
        IrValueParameter thisParam = CollectionsKt.last(delegate2.getValueParameters());
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        IrValueParameter oldThisReceiver = irValueParameter;
        IrBody constructorBody = constructor2.getBody();
        List<IrValueParameter> oldValueParameters = CollectionsKt.plus((Collection)constructor2.getValueParameters(), oldThisReceiver);
        if (constructorBody != null) {
            delegate2.setBody(this.context.getIrFactory().createBlockBody(-1, -1, (Function1<? super IrBlockBody, Unit>)new Function1<IrBlockBody, Unit>(constructorBody, delegate2, thisParam, this, constructor2, oldValueParameters){
                final /* synthetic */ IrBody $constructorBody;
                final /* synthetic */ IrSimpleFunction $delegate;
                final /* synthetic */ IrValueParameter $thisParam;
                final /* synthetic */ SecondaryConstructorLowering this$0;
                final /* synthetic */ IrConstructor $constructor;
                final /* synthetic */ List<IrValueParameter> $oldValueParameters;
                {
                    this.$constructorBody = $constructorBody;
                    this.$delegate = $delegate;
                    this.$thisParam = $thisParam;
                    this.this$0 = $receiver;
                    this.$constructor = $constructor;
                    this.$oldValueParameters = $oldValueParameters;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                    Map map;
                    void $this$associateTo$iv$iv;
                    void $this$associate$iv;
                    void p1;
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    void $this$deepCopyWithSymbols$iv$iv;
                    void $this$deepCopyWithSymbols_u24default$iv;
                    Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
                    Iterable<E> iterable = $this$createBlockBody.getStatements();
                    IrElement irElement = this.$constructorBody;
                    IrDeclarationParent initialParent$iv = this.$delegate;
                    boolean $i$f$deepCopyWithSymbols = false;
                    Iterator<T> iterator2 = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                    TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    IrElement irElement2 = $this$deepCopyWithSymbols$iv$iv;
                    boolean bl = false;
                    typeRemapper = typeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    IrElement irElement3 = PatchDeclarationParentsKt.patchDeclarationParents(irElement2.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
                    if (irElement3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBody");
                    }
                    IrElement irElement4 = (IrBody)irElement3;
                    Intrinsics.checkNotNull(irElement4, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrStatementContainer");
                    CollectionsKt.addAll(iterable, (Iterable)((IrStatementContainer)irElement4).getStatements());
                    ((Collection)$this$createBlockBody.getStatements()).add(JsIrBuilder.INSTANCE.buildReturn(this.$delegate.getSymbol(), JsIrBuilder.INSTANCE.buildGetValue(this.$thisParam.getSymbol()), this.this$0.getContext().getIrBuiltIns().getNothingType()));
                    iterable = CollectionsKt.zip((Iterable)this.$oldValueParameters, (Iterable)this.$delegate.getValueParameters());
                    IrFunctionSymbol irFunctionSymbol = this.$delegate.getSymbol();
                    IrConstructorSymbol irConstructorSymbol = this.$constructor.getSymbol();
                    irElement2 = $this$createBlockBody;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                    initialParent$iv = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (T element$iv$iv : $this$associateTo$iv$iv) {
                        Map map2 = destination$iv$iv;
                        Pair<IrValueParameterSymbol, IrValueParameterSymbol> pair = (Pair<IrValueParameterSymbol, IrValueParameterSymbol>)element$iv$iv;
                        boolean bl2 = false;
                        IrValueParameter old = (IrValueParameter)pair.component1();
                        IrValueParameter irValueParameter = (IrValueParameter)pair.component2();
                        pair = TuplesKt.to(old.getSymbol(), irValueParameter.getSymbol());
                        map2.put(pair.getFirst(), pair.getSecond());
                    }
                    Map map3 = map = destination$iv$iv;
                    IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
                    IrConstructorSymbol irConstructorSymbol2 = irConstructorSymbol;
                    IrElementTransformerVoidKt.transformChildrenVoid(irElement2, new ThisUsageReplaceTransformer(irConstructorSymbol2, irFunctionSymbol2, map3));
                }
            }));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/SecondaryConstructorLowering$ThisUsageReplaceTransformer;", "Lorg/jetbrains/kotlin/backend/common/ir/ValueRemapper;", "constructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "symbolMapping", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Map;)V", "getConstructor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "newThisSymbol", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "backend.js"})
    private static final class ThisUsageReplaceTransformer
    extends ValueRemapper {
        @NotNull
        private final IrConstructorSymbol constructor;
        @NotNull
        private final IrFunctionSymbol function;
        @NotNull
        private final IrValueSymbol newThisSymbol;

        public ThisUsageReplaceTransformer(@NotNull IrConstructorSymbol constructor2, @NotNull IrFunctionSymbol function2, @NotNull Map<IrValueSymbol, ? extends IrValueSymbol> symbolMapping) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(symbolMapping, "symbolMapping");
            super(symbolMapping);
            this.constructor = constructor2;
            this.function = function2;
            this.newThisSymbol = (IrValueSymbol)CollectionsKt.last((Iterable)symbolMapping.values());
        }

        @NotNull
        public final IrConstructorSymbol getConstructor() {
            return this.constructor;
        }

        @NotNull
        public final IrFunctionSymbol getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public IrExpression visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            return !Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.constructor) ? (IrExpression)expression2 : (IrExpression)new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.function, new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.newThisSymbol.getOwner().getType(), this.newThisSymbol, null, 16, null));
        }
    }
}

